/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.power;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.collection.Queue;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.WindowedMean;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.consumers.ConsumePower;
import io.anuke.mindustry.world.consumers.Consumers;

public class PowerGraph {
    private static final Queue<Tile> queue = new Queue();
    private static final Array<Tile> outArray1 = new Array();
    private static final Array<Tile> outArray2 = new Array();
    private static final IntSet closedSet = new IntSet();
    private final ObjectSet<Tile> producers = new ObjectSet();
    private final ObjectSet<Tile> consumers = new ObjectSet();
    private final ObjectSet<Tile> batteries = new ObjectSet();
    private final ObjectSet<Tile> all = new ObjectSet();
    private final WindowedMean powerBalance = new WindowedMean(60);
    private float lastPowerProduced;
    private float lastPowerNeeded;
    private long lastFrameUpdated = -1L;
    private final int graphID = lastGraphID++;
    private static int lastGraphID;

    public int getID() {
        return this.graphID;
    }

    public float getPowerBalance() {
        return this.powerBalance.getMean();
    }

    public float getLastPowerNeeded() {
        return this.lastPowerNeeded;
    }

    public float getLastPowerProduced() {
        return this.lastPowerProduced;
    }

    public float getSatisfaction() {
        if (Mathf.isZero(this.lastPowerProduced)) {
            return 0.0f;
        }
        if (Mathf.isZero(this.lastPowerNeeded)) {
            return 1.0f;
        }
        return Mathf.clamp(this.lastPowerProduced / this.lastPowerNeeded);
    }

    public float getPowerProduced() {
        float powerProduced = 0.0f;
        for (Tile producer : this.producers) {
            if (producer.entity == null) continue;
            powerProduced += producer.block().getPowerProduction(producer) * producer.entity.delta();
        }
        return powerProduced;
    }

    public float getPowerNeeded() {
        float powerNeeded = 0.0f;
        for (Tile consumer : this.consumers) {
            ConsumePower consumePower;
            Consumers consumes = consumer.block().consumes;
            if (!consumes.hasPower() || !this.otherConsumersAreValid(consumer, consumePower = consumes.getPower())) continue;
            powerNeeded += consumePower.requestedPower(consumer.entity) * consumer.entity.delta();
        }
        return powerNeeded;
    }

    public float getBatteryStored() {
        float totalAccumulator = 0.0f;
        for (Tile battery : this.batteries) {
            Consumers consumes = battery.block().consumes;
            if (!consumes.hasPower()) continue;
            totalAccumulator += battery.entity.power.satisfaction * consumes.getPower().capacity;
        }
        return totalAccumulator;
    }

    public float getBatteryCapacity() {
        float totalCapacity = 0.0f;
        for (Tile battery : this.batteries) {
            if (!battery.block().consumes.hasPower()) continue;
            ConsumePower power = battery.block().consumes.getPower();
            totalCapacity += (1.0f - battery.entity.power.satisfaction) * power.capacity;
        }
        return totalCapacity;
    }

    public float getTotalBatteryCapacity() {
        float totalCapacity = 0.0f;
        for (Tile battery : this.batteries) {
            if (!battery.block().consumes.hasPower()) continue;
            totalCapacity += battery.block().consumes.getPower().capacity;
        }
        return totalCapacity;
    }

    public float useBatteries(float needed) {
        float stored = this.getBatteryStored();
        if (Mathf.isEqual(stored, 0.0f)) {
            return 0.0f;
        }
        float used = Math.min(stored, needed);
        float consumedPowerPercentage = Math.min(1.0f, needed / stored);
        for (Tile battery : this.batteries) {
            Consumers consumes = battery.block().consumes;
            if (!consumes.hasPower()) continue;
            battery.entity.power.satisfaction *= 1.0f - consumedPowerPercentage;
        }
        return used;
    }

    public float chargeBatteries(float excess) {
        float capacity = this.getBatteryCapacity();
        float chargedPercent = Math.min(excess / capacity, 1.0f);
        if (Mathf.isEqual(capacity, 0.0f)) {
            return 0.0f;
        }
        for (Tile battery : this.batteries) {
            Consumers consumes = battery.block().consumes;
            if (!consumes.hasPower()) continue;
            ConsumePower consumePower = consumes.getPower();
            if (!(consumePower.capacity > 0.0f)) continue;
            battery.entity.power.satisfaction += (1.0f - battery.entity.power.satisfaction) * chargedPercent;
        }
        return Math.min(excess, capacity);
    }

    public void distributePower(float needed, float produced) {
        float coverage = Mathf.isZero(needed) && Mathf.isZero(produced) ? 0.0f : (Mathf.isZero(needed) ? 1.0f : Math.min(1.0f, produced / needed));
        for (Tile consumer : this.consumers) {
            Consumers consumes = consumer.block().consumes;
            if (!consumes.hasPower()) continue;
            ConsumePower consumePower = consumes.getPower();
            if (consumePower.buffered) {
                if (Mathf.isZero(consumePower.capacity)) continue;
                float maximumRate = consumePower.requestedPower(consumer.entity) * coverage * consumer.entity.delta();
                consumer.entity.power.satisfaction = Mathf.clamp(consumer.entity.power.satisfaction + maximumRate / consumePower.capacity);
                continue;
            }
            if (this.otherConsumersAreValid(consumer, consumePower)) {
                consumer.entity.power.satisfaction = coverage;
                continue;
            }
            consumer.entity.power.satisfaction = Math.min(1.0f, produced / (needed + consumePower.usage * consumer.entity.delta()));
            if (!Float.isNaN(consumer.entity.power.satisfaction)) continue;
            consumer.entity.power.satisfaction = 0.0f;
        }
    }

    public void update() {
        if (Core.graphics.getFrameId() == this.lastFrameUpdated) {
            return;
        }
        if (!this.consumers.isEmpty() && this.consumers.first().isEnemyCheat()) {
            for (Tile tile : this.consumers) {
                tile.entity.power.satisfaction = 1.0f;
            }
            return;
        }
        this.lastFrameUpdated = Core.graphics.getFrameId();
        float powerNeeded = this.getPowerNeeded();
        float powerProduced = this.getPowerProduced();
        this.lastPowerNeeded = powerNeeded;
        this.lastPowerProduced = powerProduced;
        this.powerBalance.addValue((powerProduced - powerNeeded) / Time.delta());
        if (this.consumers.size == 0 && this.producers.size == 0 && this.batteries.size == 0) {
            return;
        }
        if (!Mathf.isEqual(powerNeeded, powerProduced)) {
            if (powerNeeded > powerProduced) {
                powerProduced += this.useBatteries(powerNeeded - powerProduced);
            } else if (powerProduced > powerNeeded) {
                powerProduced -= this.chargeBatteries(powerProduced - powerNeeded);
            }
        }
        this.distributePower(powerNeeded, powerProduced);
    }

    public void add(PowerGraph graph) {
        for (Tile tile : graph.all) {
            this.add(tile);
        }
    }

    public void add(Tile tile) {
        if (tile.entity == null || tile.entity.power == null) {
            return;
        }
        tile.entity.power.graph = this;
        this.all.add(tile);
        if (tile.block().outputsPower && tile.block().consumesPower && !tile.block().consumes.getPower().buffered) {
            this.producers.add(tile);
            this.consumers.add(tile);
        } else if (tile.block().outputsPower && tile.block().consumesPower) {
            this.batteries.add(tile);
        } else if (tile.block().outputsPower) {
            this.producers.add(tile);
        } else if (tile.block().consumesPower) {
            this.consumers.add(tile);
        }
    }

    public void reflow(Tile tile) {
        queue.clear();
        queue.addLast(tile);
        closedSet.clear();
        while (PowerGraph.queue.size > 0) {
            Tile child = queue.removeFirst();
            this.add(child);
            for (Tile next : child.block().getPowerConnections(child, outArray2)) {
                if (closedSet.contains(next.pos())) continue;
                queue.addLast(next);
                closedSet.add(next.pos());
            }
        }
    }

    private void removeSingle(Tile tile) {
        this.all.remove(tile);
        this.producers.remove(tile);
        this.consumers.remove(tile);
        this.batteries.remove(tile);
    }

    public void remove(Tile tile) {
        this.removeSingle(tile);
        closedSet.clear();
        for (Tile other : tile.block().getPowerConnections(tile, outArray1)) {
            if (other.entity.power.graph != this) continue;
            PowerGraph graph = new PowerGraph();
            graph.add(other);
            queue.clear();
            queue.addLast(other);
            while (PowerGraph.queue.size > 0) {
                Tile child = queue.removeFirst();
                this.removeSingle(child);
                graph.add(child);
                for (Tile next : child.block().getPowerConnections(child, outArray2)) {
                    if (next == tile || next.entity.power.graph == graph || closedSet.contains(next.pos())) continue;
                    queue.addLast(next);
                    closedSet.add(next.pos());
                }
            }
            graph.update();
        }
    }

    private boolean otherConsumersAreValid(Tile tile, Consume consumePower) {
        for (Consume cons : tile.block().consumes.all()) {
            if (cons == consumePower || cons.isOptional() || cons.valid((TileEntity)tile.entity())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "PowerGraph{producers=" + this.producers + ", consumers=" + this.consumers + ", batteries=" + this.batteries + ", all=" + this.all + ", lastFrameUpdated=" + this.lastFrameUpdated + ", graphID=" + this.graphID + '}';
    }
}

