/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.power;

import io.anuke.arc.Core;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Intersector;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.PowerBlock;
import io.anuke.mindustry.world.blocks.power.PowerGraph;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public class PowerNode
extends PowerBlock {
    protected ObjectSet<PowerGraph> graphs = new ObjectSet();
    protected Vector2 t1 = new Vector2();
    protected Vector2 t2 = new Vector2();
    protected TextureRegion laser;
    protected TextureRegion laserEnd;
    protected float laserRange = 6.0f;
    protected int maxNodes = 3;

    public PowerNode(String name) {
        super(name);
        this.expanded = true;
        this.layer = Layer.power;
        this.configurable = true;
        this.consumesPower = false;
        this.outputsPower = false;
    }

    public static void linkPowerNodes(Player player, Tile tile, Tile other) {
        if (tile.entity == null || other == null || tile.entity.power == null || !((PowerNode)tile.block()).linkValid(tile, other) || tile.entity.power.links.size >= ((PowerNode)tile.block()).maxNodes) {
            return;
        }
        if (!Units.canInteract(player, tile)) {
            return;
        }
        Object entity = tile.entity();
        if (!((TileEntity)entity).power.links.contains(other.pos())) {
            ((TileEntity)entity).power.links.add(other.pos());
        }
        if (other.getTeamID() == tile.getTeamID() && !other.entity.power.links.contains(tile.pos())) {
            other.entity.power.links.add(tile.pos());
        }
        ((TileEntity)entity).power.graph.add(other.entity.power.graph);
    }

    public static void unlinkPowerNodes(Player player, Tile tile, Tile other) {
        if (tile.entity.power == null || other.entity == null || other.entity.power == null) {
            return;
        }
        if (!Units.canInteract(player, tile)) {
            return;
        }
        Object entity = tile.entity();
        ((TileEntity)entity).power.links.removeValue(other.pos());
        other.entity.power.links.removeValue(tile.pos());
        PowerGraph newgraph = new PowerGraph();
        newgraph.reflow(tile);
        if (other.entity.power.graph != newgraph) {
            PowerGraph og = new PowerGraph();
            og.reflow(other);
        }
    }

    @Override
    public void load() {
        super.load();
        this.laser = Core.atlas.find("laser");
        this.laserEnd = Core.atlas.find("laser-end");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("power", entity -> new Bar(() -> Core.bundle.format("bar.powerbalance", (entity.power.graph.getPowerBalance() >= 0.0f ? "+" : "") + Strings.fixed(entity.power.graph.getPowerBalance() * 60.0f, 1)), () -> Pal.powerBar, () -> Mathf.clamp(entity.power.graph.getPowerProduced() / entity.power.graph.getPowerNeeded())));
        this.bars.add("batteries", entity -> new Bar(() -> Core.bundle.format("bar.powerstored", Vars.ui.formatAmount((int)entity.power.graph.getBatteryStored()), Vars.ui.formatAmount((int)entity.power.graph.getTotalBatteryCapacity())), () -> Pal.powerBar, () -> Mathf.clamp(entity.power.graph.getBatteryStored() / entity.power.graph.getTotalBatteryCapacity())));
    }

    @Override
    public void placed(Tile tile) {
        if (Vars.net.client()) {
            return;
        }
        Predicate<Tile> valid = other -> other != null && other != tile && (!other.block().outputsPower && other.block().consumesPower || other.block().outputsPower && !other.block().consumesPower || other.block() instanceof PowerNode) && this.linkValid(tile, (Tile)other) && !other.entity.proximity().contains(tile) && other.entity.power.graph != tile.entity.power.graph;
        this.tempTiles.clear();
        Geometry.circle(tile.x, tile.y, (int)(this.laserRange + 1.0f), (x, y) -> {
            Tile other = Vars.world.ltile(x, y);
            if (valid.test(other)) {
                this.tempTiles.add(other);
            }
        });
        this.tempTiles.sort(Structs.comparingFloat(t -> t.dst2(tile)));
        this.tempTiles.each(valid, other -> Call.linkPowerNodes(null, tile, other));
        super.placed(tile);
    }

    private void getPotentialLinks(Tile tile, Consumer<Tile> others) {
        Predicate<Tile> valid = other -> other != null && other != tile && other.entity != null && other.entity.power != null && (!other.block().outputsPower && other.block().consumesPower || other.block().outputsPower && !other.block().consumesPower || other.block() instanceof PowerNode) && this.overlaps((float)(tile.x * 8) + this.offset(), (float)(tile.y * 8) + this.offset(), (Tile)other, this.laserRange * 8.0f) && other.getTeam() == Vars.player.getTeam() && !other.entity.proximity().contains(tile) && !this.graphs.contains(other.entity.power.graph);
        this.tempTiles.clear();
        this.graphs.clear();
        Geometry.circle(tile.x, tile.y, (int)(this.laserRange + 1.0f), (x, y) -> {
            Tile other = Vars.world.ltile(x, y);
            if (valid.test(other)) {
                this.tempTiles.add(other);
            }
        });
        this.tempTiles.sort(Structs.comparingFloat(t -> t.dst2(tile)));
        this.tempTiles.each(valid, t -> {
            this.graphs.add(t.entity.power.graph);
            others.accept((Tile)t);
        });
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.powerRange, this.laserRange, StatUnit.blocks);
    }

    @Override
    public void update(Tile tile) {
        tile.entity.power.graph.update();
    }

    @Override
    public boolean onConfigureTileTapped(Tile tile, Tile other) {
        Object entity = tile.entity();
        Tile result = other = other.link();
        if (this.linkValid(tile, other)) {
            if (this.linked(tile, other)) {
                Call.unlinkPowerNodes(null, tile, result);
            } else if (((TileEntity)entity).power.links.size < this.maxNodes) {
                Call.linkPowerNodes(null, tile, result);
            }
            return false;
        }
        return true;
    }

    @Override
    public void drawSelect(Tile tile) {
        super.drawSelect(tile);
        Lines.stroke(1.0f);
        Draw.color(Pal.accent);
        Drawf.circles(tile.drawx(), tile.drawy(), this.laserRange * 8.0f);
        Draw.reset();
    }

    @Override
    public void drawConfigure(Tile tile) {
        Draw.color(Pal.accent);
        Lines.stroke(1.5f);
        Lines.circle(tile.drawx(), tile.drawy(), (float)(tile.block().size * 8) / 2.0f + 1.0f + Mathf.absin(Time.time(), 4.0f, 1.0f));
        Drawf.circles(tile.drawx(), tile.drawy(), this.laserRange * 8.0f);
        Lines.stroke(1.5f);
        int x = (int)((float)tile.x - this.laserRange - 1.0f);
        while ((float)x <= (float)tile.x + this.laserRange + 1.0f) {
            int y = (int)((float)tile.y - this.laserRange - 1.0f);
            while ((float)y <= (float)tile.y + this.laserRange + 1.0f) {
                boolean linked;
                Tile link = Vars.world.ltile(x, y);
                if (link != tile && this.linkValid(tile, link, false) && (linked = this.linked(tile, link))) {
                    Drawf.square(link.drawx(), link.drawy(), (float)(link.block().size * 8) / 2.0f + 1.0f, Pal.place);
                }
                ++y;
            }
            ++x;
        }
        Draw.reset();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        Lines.stroke(1.0f);
        Draw.color(Pal.placing);
        Drawf.circles((float)(x * 8) + this.offset(), (float)(y * 8) + this.offset(), this.laserRange * 8.0f);
        this.getPotentialLinks(tile, other -> Drawf.square(other.drawx(), other.drawy(), (float)(other.block().size * 8) / 2.0f + 2.0f, Pal.place));
        Draw.reset();
    }

    @Override
    public void drawLayer(Tile tile) {
        if (!Core.settings.getBool("lasers")) {
            return;
        }
        Object entity = tile.entity();
        for (int i = 0; i < ((TileEntity)entity).power.links.size; ++i) {
            Tile link = Vars.world.tile(((TileEntity)entity).power.links.get(i));
            if (!this.linkValid(tile, link) || link.pos() >= tile.pos() && link.block() instanceof PowerNode && Core.camera.bounds(Tmp.r1).contains(link.drawx(), link.drawy())) continue;
            this.drawLaser(tile, link);
        }
        Draw.reset();
    }

    protected boolean linked(Tile tile, Tile other) {
        return tile.entity.power.links.contains(other.pos());
    }

    public boolean linkValid(Tile tile, Tile link) {
        return this.linkValid(tile, link, true);
    }

    public boolean linkValid(Tile tile, Tile link, boolean checkMaxNodes) {
        if (tile == link || link == null || link.entity == null || tile.entity == null || !link.block().hasPower || tile.getTeam() != link.getTeam()) {
            return false;
        }
        if (this.overlaps(tile, link, this.laserRange * 8.0f) || link.block() instanceof PowerNode && this.overlaps(link, tile, ((PowerNode)link.cblock()).laserRange * 8.0f)) {
            if (checkMaxNodes && link.block() instanceof PowerNode) {
                return link.entity.power.links.size < ((PowerNode)link.cblock()).maxNodes || link.entity.power.links.contains(tile.pos());
            }
            return true;
        }
        return false;
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, float range) {
        return Intersector.overlaps(Tmp.cr1.set(srcx, srcy, range), other.getHitbox(Tmp.r1));
    }

    protected boolean overlaps(Tile src, Tile other, float range) {
        return this.overlaps(src.drawx(), src.drawy(), other, range);
    }

    protected void drawLaser(Tile tile, Tile target) {
        float x1 = tile.drawx();
        float y1 = tile.drawy();
        float x2 = target.drawx();
        float y2 = target.drawy();
        float angle1 = Angles.angle(x1, y1, x2, y2);
        this.t1.trns(angle1, (float)(tile.block().size * 8) / 2.0f - 1.5f);
        this.t2.trns(angle1 + 180.0f, (float)(target.block().size * 8) / 2.0f - 1.5f);
        float fract = 1.0f - tile.entity.power.graph.getSatisfaction();
        Draw.color(Color.white, Pal.powerLight, fract * 0.86f + Mathf.absin(3.0f, 0.1f));
        Drawf.laser(this.laser, this.laserEnd, x1 += this.t1.x, y1 += this.t1.y, x2 += this.t2.x, y2 += this.t2.y, 0.3f);
        Draw.color();
    }
}

