/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.power;

import io.anuke.arc.Core;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.power.PowerGenerator;
import io.anuke.mindustry.world.meta.Attribute;

public class ThermalGenerator
extends PowerGenerator {
    protected Effects.Effect generateEffect = Fx.none;

    public ThermalGenerator(String name) {
        super(name);
    }

    @Override
    public void update(Tile tile) {
        PowerGenerator.GeneratorEntity entity = (PowerGenerator.GeneratorEntity)tile.entity();
        if (entity.productionEfficiency > 0.1f && Mathf.chance(0.05 * (double)entity.delta())) {
            Effects.effect(this.generateEffect, tile.drawx() + Mathf.range(3.0f), tile.drawy() + Mathf.range(3.0f));
        }
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPlaceText(Core.bundle.formatFloat("bar.efficiency", this.sumAttribute(Attribute.heat, x, y) * 100.0f, 1), x, y, valid);
    }

    @Override
    public void onProximityAdded(Tile tile) {
        super.onProximityAdded(tile);
        PowerGenerator.GeneratorEntity entity = (PowerGenerator.GeneratorEntity)tile.entity();
        entity.productionEfficiency = this.sumAttribute(Attribute.heat, tile.x, tile.y);
    }

    @Override
    public float getPowerProduction(Tile tile) {
        return this.powerProduction * ((PowerGenerator.GeneratorEntity)tile.entity()).productionEfficiency;
    }

    @Override
    public boolean canPlaceOn(Tile tile) {
        return tile.getLinkedTilesAs(this, this.tempTiles).sumf(other -> other.floor().attributes.get(Attribute.heat)) > 0.01f;
    }
}

