/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.RandomXS128;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.production.GenericCrafter;
import io.anuke.mindustry.world.meta.Attribute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Cultivator
extends GenericCrafter {
    protected static final Color plantColor = Color.valueOf("5541b1");
    protected static final Color plantColorLight = Color.valueOf("7457ce");
    protected static final Color bottomColor = Color.valueOf("474747");
    protected TextureRegion middleRegion;
    protected TextureRegion topRegion;
    protected RandomXS128 random = new RandomXS128(0L);
    protected float recurrence = 6.0f;

    public Cultivator(String name) {
        super(name);
        this.craftEffect = Fx.none;
    }

    @Override
    public void load() {
        super.load();
        this.middleRegion = Core.atlas.find(this.name + "-middle");
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    @Override
    public void update(Tile tile) {
        super.update(tile);
        CultivatorEntity entity = (CultivatorEntity)tile.entity();
        entity.warmup = Mathf.lerpDelta(entity.warmup, entity.cons.valid() ? 1.0f : 0.0f, 0.015f);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("multiplier", entity -> new Bar(() -> Core.bundle.formatFloat("bar.efficiency", (((CultivatorEntity)entity).boost + 1.0f) * ((CultivatorEntity)entity).warmup * 100.0f, 1), () -> Pal.ammo, () -> ((CultivatorEntity)entity).warmup));
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPlaceText(Core.bundle.formatFloat("bar.efficiency", (1.0f + this.sumAttribute(Attribute.spores, x, y)) * 100.0f, 1), x, y, valid);
    }

    @Override
    public void draw(Tile tile) {
        CultivatorEntity entity = (CultivatorEntity)tile.entity();
        Draw.rect(this.region, tile.drawx(), tile.drawy());
        Draw.color(plantColor);
        Draw.alpha(entity.warmup);
        Draw.rect(this.middleRegion, tile.drawx(), tile.drawy());
        Draw.color(bottomColor, plantColorLight, entity.warmup);
        this.random.setSeed(tile.pos());
        for (int i = 0; i < 12; ++i) {
            float offset = this.random.nextFloat() * 999999.0f;
            float x = this.random.range(4.0f);
            float y = this.random.range(4.0f);
            float life = 1.0f - (Time.time() + offset) / 50.0f % this.recurrence;
            if (!(life > 0.0f)) continue;
            Lines.stroke(entity.warmup * (life * 1.0f + 0.2f));
            Lines.poly(tile.drawx() + x, tile.drawy() + y, 8, (1.0f - life) * 3.0f);
        }
        Draw.color();
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-top")};
    }

    @Override
    public TileEntity newEntity() {
        return new CultivatorEntity();
    }

    @Override
    public void onProximityAdded(Tile tile) {
        super.onProximityAdded(tile);
        CultivatorEntity entity = (CultivatorEntity)tile.entity();
        entity.boost = this.sumAttribute(Attribute.spores, tile.x, tile.y);
    }

    @Override
    protected float getProgressIncrease(TileEntity entity, float baseTime) {
        CultivatorEntity c = (CultivatorEntity)entity;
        return super.getProgressIncrease(entity, baseTime) * (1.0f + c.boost);
    }

    public static class CultivatorEntity
    extends GenericCrafter.GenericCrafterEntity {
        public float warmup;
        public float boost;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.warmup);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.warmup = stream.readFloat();
        }
    }
}

