/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.LiquidStack;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.ConsumeLiquidBase;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GenericCrafter
extends Block {
    protected ItemStack outputItem;
    protected LiquidStack outputLiquid;
    protected float craftTime = 80.0f;
    protected Effects.Effect craftEffect = Fx.none;
    protected Effects.Effect updateEffect = Fx.none;
    protected float updateEffectChance = 0.04f;
    protected Consumer<Tile> drawer = null;
    protected Supplier<TextureRegion[]> drawIcons = null;

    public GenericCrafter(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.health = 60;
        this.idleSound = Sounds.machine;
        this.idleSoundVolume = 0.03f;
    }

    @Override
    public void setStats() {
        if (this.consumes.has(ConsumeType.liquid)) {
            ConsumeLiquidBase cons = (ConsumeLiquidBase)this.consumes.get(ConsumeType.liquid);
            cons.timePeriod = this.craftTime;
        }
        super.setStats();
        this.stats.add(BlockStat.productionTime, this.craftTime / 60.0f, StatUnit.seconds);
        if (this.outputItem != null) {
            this.stats.add(BlockStat.output, this.outputItem);
        }
        if (this.outputLiquid != null) {
            this.stats.add(BlockStat.output, this.outputLiquid.liquid, this.outputLiquid.amount, false);
        }
    }

    @Override
    public boolean shouldIdleSound(Tile tile) {
        return tile.entity.cons.valid();
    }

    @Override
    public void init() {
        this.outputsLiquid = this.outputLiquid != null;
        super.init();
    }

    @Override
    public void draw(Tile tile) {
        if (this.drawer == null) {
            super.draw(tile);
        } else {
            this.drawer.accept(tile);
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        return this.drawIcons == null ? super.generateIcons() : this.drawIcons.get();
    }

    @Override
    public void update(Tile tile) {
        GenericCrafterEntity entity = (GenericCrafterEntity)tile.entity();
        if (entity.cons.valid()) {
            entity.progress += this.getProgressIncrease(entity, this.craftTime);
            entity.totalProgress += entity.delta();
            entity.warmup = Mathf.lerpDelta(entity.warmup, 1.0f, 0.02f);
            if (Mathf.chance(Time.delta() * this.updateEffectChance)) {
                Effects.effect(this.updateEffect, entity.x + Mathf.range((float)this.size * 4.0f), entity.y + (float)Mathf.range(this.size * 4));
            }
        } else {
            entity.warmup = Mathf.lerp(entity.warmup, 0.0f, 0.02f);
        }
        if (entity.progress >= 1.0f) {
            entity.cons.trigger();
            if (this.outputItem != null) {
                this.useContent(tile, this.outputItem.item);
                for (int i = 0; i < this.outputItem.amount; ++i) {
                    this.offloadNear(tile, this.outputItem.item);
                }
            }
            if (this.outputLiquid != null) {
                this.useContent(tile, this.outputLiquid.liquid);
                this.handleLiquid(tile, tile, this.outputLiquid.liquid, this.outputLiquid.amount);
            }
            Effects.effect(this.craftEffect, tile.drawx(), tile.drawy());
            entity.progress = 0.0f;
        }
        if (this.outputItem != null && tile.entity.timer.get(this.timerDump, 5.0f)) {
            this.tryDump(tile, this.outputItem.item);
        }
        if (this.outputLiquid != null) {
            this.tryDumpLiquid(tile, this.outputLiquid.liquid);
        }
    }

    @Override
    public boolean outputsItems() {
        return this.outputItem != null;
    }

    @Override
    public boolean canProduce(Tile tile) {
        if (this.outputItem != null && tile.entity.items.get(this.outputItem.item) >= this.itemCapacity) {
            return false;
        }
        return this.outputLiquid == null || !(tile.entity.liquids.get(this.outputLiquid.liquid) >= this.liquidCapacity);
    }

    @Override
    public TileEntity newEntity() {
        return new GenericCrafterEntity();
    }

    @Override
    public int getMaximumAccepted(Tile tile, Item item) {
        return this.itemCapacity;
    }

    public Item outputItem() {
        return this.outputItem == null ? null : this.outputItem.item;
    }

    public Liquid outputLiquid() {
        return this.outputLiquid == null ? null : this.outputLiquid.liquid;
    }

    public static class GenericCrafterEntity
    extends TileEntity {
        public float progress;
        public float totalProgress;
        public float warmup;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.progress);
            stream.writeFloat(this.warmup);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.progress = stream.readFloat();
            this.warmup = stream.readFloat();
        }
    }
}

