/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.production.GenericCrafter;

public class GenericSmelter
extends GenericCrafter {
    protected Color flameColor = Color.valueOf("ffc999");
    protected TextureRegion topRegion;

    public GenericSmelter(String name) {
        super(name);
    }

    @Override
    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
        if (entity.warmup > 0.0f && this.flameColor.a > 0.001f) {
            float g = 0.3f;
            float r = 0.06f;
            float cr = Mathf.random(0.1f);
            Draw.alpha((1.0f - g + Mathf.absin(Time.time(), 8.0f, g) + Mathf.random(r) - r) * entity.warmup);
            Draw.tint(this.flameColor);
            Fill.circle(tile.drawx(), tile.drawy(), 3.0f + Mathf.absin(Time.time(), 5.0f, 2.0f) + cr);
            Draw.color(1.0f, 1.0f, 1.0f, entity.warmup);
            Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
            Fill.circle(tile.drawx(), tile.drawy(), 1.9f + Mathf.absin(Time.time(), 5.0f, 1.0f) + cr);
            Draw.color();
        }
    }
}

