/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.production.GenericCrafter;
import io.anuke.mindustry.world.consumers.ConsumeLiquidBase;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;

public class LiquidConverter
extends GenericCrafter {
    public LiquidConverter(String name) {
        super(name);
        this.hasLiquids = true;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void init() {
        ConsumeLiquidBase cl = (ConsumeLiquidBase)this.consumes.get(ConsumeType.liquid);
        cl.update(true);
        this.outputLiquid.amount = cl.amount;
        super.init();
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(BlockStat.output);
        this.stats.add(BlockStat.output, this.outputLiquid.liquid, this.outputLiquid.amount * this.craftTime, false);
    }

    @Override
    public void update(Tile tile) {
        GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
        ConsumeLiquidBase cl = (ConsumeLiquidBase)this.consumes.get(ConsumeType.liquid);
        if (tile.entity.cons.valid()) {
            float use = Math.min(cl.amount * entity.delta(), this.liquidCapacity - entity.liquids.get(this.outputLiquid.liquid));
            if (this.hasPower) {
                use *= entity.power.satisfaction;
            }
            this.useContent(tile, this.outputLiquid.liquid);
            entity.progress += use / cl.amount / this.craftTime;
            entity.liquids.add(this.outputLiquid.liquid, use);
            if (entity.progress >= 1.0f) {
                entity.cons.trigger();
                entity.progress = 0.0f;
            }
        }
        this.tryDumpLiquid(tile, this.outputLiquid.liquid);
    }
}

