/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Liquids;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.production.Pump;
import io.anuke.mindustry.world.meta.Attribute;
import io.anuke.mindustry.world.meta.BlockStat;

public class SolidPump
extends Pump {
    protected Liquid result = Liquids.water;
    protected Effects.Effect updateEffect = Fx.none;
    protected float updateEffectChance = 0.02f;
    protected float rotateSpeed = 1.0f;
    protected Attribute attribute;

    public SolidPump(String name) {
        super(name);
        this.hasPower = true;
    }

    @Override
    public void load() {
        super.load();
        this.liquidRegion = Core.atlas.find(this.name + "-liquid");
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        if (this.attribute != null) {
            this.drawPlaceText(Core.bundle.formatFloat("bar.efficiency", (this.sumAttribute(this.attribute, x, y) + 1.0f) * 100.0f, 1), x, y, valid);
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("efficiency", entity -> new Bar(() -> Core.bundle.formatFloat("bar.efficiency", (((SolidPumpEntity)entity).boost + 1.0f) * ((SolidPumpEntity)entity).warmup * 100.0f, 1), () -> Pal.ammo, () -> ((SolidPumpEntity)entity).warmup));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(BlockStat.output);
        this.stats.add(BlockStat.output, this.result, 60.0f * this.pumpAmount, true);
    }

    @Override
    public void draw(Tile tile) {
        SolidPumpEntity entity = (SolidPumpEntity)tile.entity();
        Draw.rect(this.region, tile.drawx(), tile.drawy());
        Draw.color(tile.entity.liquids.current().color);
        Draw.alpha(tile.entity.liquids.total() / this.liquidCapacity);
        Draw.rect(this.liquidRegion, tile.drawx(), tile.drawy());
        Draw.color();
        Draw.rect(this.name + "-rotator", tile.drawx(), tile.drawy(), entity.pumpTime * this.rotateSpeed);
        Draw.rect(this.name + "-top", tile.drawx(), tile.drawy());
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-rotator"), Core.atlas.find(this.name + "-top")};
    }

    @Override
    public void update(Tile tile) {
        SolidPumpEntity entity = (SolidPumpEntity)tile.entity();
        float fraction = 0.0f;
        if (this.isMultiblock()) {
            for (Tile other : tile.getLinkedTiles(this.tempTiles)) {
                if (!this.isValid(other)) continue;
                fraction += 1.0f / (float)(this.size * this.size);
            }
        } else if (this.isValid(tile)) {
            fraction = 1.0f;
        }
        fraction += entity.boost;
        if (tile.entity.cons.valid() && this.typeLiquid(tile) < this.liquidCapacity - 0.001f) {
            float maxPump = Math.min(this.liquidCapacity - this.typeLiquid(tile), this.pumpAmount * entity.delta() * fraction * entity.power.satisfaction);
            tile.entity.liquids.add(this.result, maxPump);
            entity.warmup = Mathf.lerpDelta(entity.warmup, 1.0f, 0.02f);
            if (Mathf.chance(entity.delta() * this.updateEffectChance)) {
                Effects.effect(this.updateEffect, entity.x + Mathf.range((float)this.size * 2.0f), entity.y + Mathf.range((float)this.size * 2.0f));
            }
        } else {
            entity.warmup = Mathf.lerpDelta(entity.warmup, 0.0f, 0.02f);
        }
        entity.pumpTime += entity.warmup * entity.delta();
        this.tryDumpLiquid(tile, this.result);
    }

    @Override
    public boolean canPlaceOn(Tile tile) {
        if (this.isMultiblock()) {
            for (Tile other : tile.getLinkedTilesAs(this, this.drawTiles)) {
                if (!this.isValid(other)) continue;
                return true;
            }
            return false;
        }
        return this.isValid(tile);
    }

    @Override
    protected boolean isValid(Tile tile) {
        return tile != null && !tile.floor().isLiquid;
    }

    @Override
    public TileEntity newEntity() {
        return new SolidPumpEntity();
    }

    @Override
    public void onProximityAdded(Tile tile) {
        super.onProximityAdded(tile);
        if (this.attribute != null) {
            SolidPumpEntity entity = (SolidPumpEntity)tile.entity();
            entity.boost = this.sumAttribute(this.attribute, tile.x, tile.y);
        }
    }

    public float typeLiquid(Tile tile) {
        return tile.entity.liquids.total();
    }

    public static class SolidPumpEntity
    extends TileEntity {
        public float warmup;
        public float pumpTime;
        public float boost;
    }
}

