/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.sandbox;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.ItemSelection;
import io.anuke.mindustry.world.meta.BlockGroup;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ItemSource
extends Block {
    private static Item lastItem;

    public ItemSource(String name) {
        super(name);
        this.hasItems = true;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
    }

    public static void setItemSourceItem(Player player, Tile tile, Item item) {
        if (!Units.canInteract(player, tile)) {
            return;
        }
        ItemSourceEntity entity = (ItemSourceEntity)tile.entity();
        if (entity != null) {
            entity.outputItem = item;
        }
    }

    @Override
    public void playerPlaced(Tile tile) {
        Core.app.post(() -> Call.setItemSourceItem(null, tile, lastItem));
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("items");
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        ItemSourceEntity entity = (ItemSourceEntity)tile.entity();
        if (entity.outputItem == null) {
            return;
        }
        Draw.color(entity.outputItem.color);
        Draw.rect("center", tile.worldx(), tile.worldy());
        Draw.color();
    }

    @Override
    public void update(Tile tile) {
        ItemSourceEntity entity = (ItemSourceEntity)tile.entity();
        if (entity.outputItem == null) {
            return;
        }
        entity.items.set(entity.outputItem, 1);
        this.tryDump(tile, entity.outputItem);
        entity.items.set(entity.outputItem, 0);
    }

    @Override
    public void buildTable(Tile tile, Table table) {
        ItemSourceEntity entity = (ItemSourceEntity)tile.entity();
        ItemSelection.buildItemTable(table, () -> entity.outputItem, item -> {
            lastItem = item;
            Call.setItemSourceItem(null, tile, item);
        });
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return false;
    }

    @Override
    public TileEntity newEntity() {
        return new ItemSourceEntity();
    }

    public class ItemSourceEntity
    extends TileEntity {
        Item outputItem;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeShort(this.outputItem == null ? -1 : (int)this.outputItem.id);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.outputItem = Vars.content.item(stream.readShort());
        }
    }
}

