/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.storage;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Mechs;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.traits.SpawnerTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.RespawnBlock;
import io.anuke.mindustry.world.blocks.storage.StorageBlock;
import io.anuke.mindustry.world.meta.BlockFlag;
import io.anuke.mindustry.world.modules.ItemModule;

public class CoreBlock
extends StorageBlock {
    protected Mech mech = Mechs.starter;

    public CoreBlock(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.core, BlockFlag.producer});
        this.activeSound = Sounds.respawning;
        this.activeSoundVolume = 1.0f;
        this.layer = Layer.overlay;
    }

    public static void onUnitRespawn(Tile tile, Player player) {
        if (player == null || tile.entity == null) {
            return;
        }
        CoreEntity entity = (CoreEntity)tile.entity();
        Effects.effect(Fx.spawn, entity);
        entity.progress = 0.0f;
        entity.spawnPlayer = player;
        entity.spawnPlayer.onRespawn(tile);
        entity.spawnPlayer.applyImpulse(0.0f, 8.0f);
        entity.spawnPlayer = null;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.bars.add("capacity", e -> new Bar(() -> Core.bundle.format("bar.capacity", Vars.ui.formatAmount(((CoreEntity)e).storageCapacity)), () -> Pal.items, () -> (float)e.items.total() / (float)(((CoreEntity)e).storageCapacity * Vars.content.items().count(i -> i.type == ItemType.material))));
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return tile.entity.items.get(item) < this.getMaximumAccepted(tile, item);
    }

    @Override
    public int getMaximumAccepted(Tile tile, Item item) {
        CoreEntity entity = (CoreEntity)tile.entity();
        return item.type == ItemType.material ? entity.storageCapacity : 0;
    }

    @Override
    public void onProximityUpdate(Tile tile) {
        CoreEntity entity = (CoreEntity)tile.entity();
        for (Tile other : Vars.state.teams.get((Team)tile.getTeam()).cores) {
            if (other == tile) continue;
            entity.items = other.entity.items;
        }
        Vars.state.teams.get((Team)tile.getTeam()).cores.add(tile);
        entity.storageCapacity = this.itemCapacity + entity.proximity().sum(e -> this.isContainer((Tile)e) ? e.block().itemCapacity : 0);
        entity.proximity().each(this::isContainer, t -> {
            t.entity.items = entity.items;
            ((StorageBlock.StorageBlockEntity)t.entity()).linkedCore = tile;
        });
        for (Tile other : Vars.state.teams.get((Team)tile.getTeam()).cores) {
            if (other == tile) continue;
            entity.storageCapacity += other.block().itemCapacity + other.entity.proximity().sum(e -> this.isContainer((Tile)e) ? e.block().itemCapacity : 0);
        }
        if (!Vars.world.isGenerating()) {
            for (Item item : Vars.content.items()) {
                entity.items.set(item, Math.min(entity.items.get(item), entity.storageCapacity));
            }
        }
        for (Tile other : Vars.state.teams.get((Team)tile.getTeam()).cores) {
            CoreEntity oe = (CoreEntity)other.entity();
            oe.storageCapacity = entity.storageCapacity;
        }
    }

    @Override
    public void drawSelect(Tile tile) {
        Lines.stroke(1.0f, Pal.accent);
        Consumer<Tile> outline = t -> {
            for (int i = 0; i < 4; ++i) {
                Point2 p = Geometry.d8edge[i];
                float offset = (float)(-Math.max(t.block().size - 1, 0)) / 2.0f * 8.0f;
                Draw.rect("block-select", t.drawx() + offset * (float)p.x, t.drawy() + offset * (float)p.y, (float)(i * 90));
            }
        };
        if (tile.entity.proximity().contains((Tile)((Object)((Predicate<Tile>)e -> this.isContainer((Tile)e) && e.entity.items == tile.entity.items)))) {
            outline.accept(tile);
        }
        tile.entity.proximity().each(e -> this.isContainer((Tile)e) && e.entity.items == tile.entity.items, outline);
        Draw.reset();
    }

    public boolean isContainer(Tile tile) {
        return tile.entity instanceof StorageBlock.StorageBlockEntity;
    }

    @Override
    public boolean canBreak(Tile tile) {
        return false;
    }

    @Override
    public void removed(Tile tile) {
        int total = tile.entity.proximity().count(e -> e.entity.items == tile.entity.items);
        float fract = 1.0f / (float)total / (float)Vars.state.teams.get((Team)tile.getTeam()).cores.size;
        tile.entity.proximity().each(e -> this.isContainer((Tile)e) && e.entity.items == tile.entity.items, t -> {
            StorageBlock.StorageBlockEntity ent = (StorageBlock.StorageBlockEntity)t.entity;
            ent.linkedCore = null;
            ent.items = new ItemModule();
            for (Item item : Vars.content.items()) {
                ent.items.set(item, (int)(fract * (float)tile.entity.items.get(item)));
            }
        });
        Vars.state.teams.get((Team)tile.getTeam()).cores.remove(tile);
        int max = this.itemCapacity * Vars.state.teams.get((Team)tile.getTeam()).cores.size;
        for (Item item : Vars.content.items()) {
            tile.entity.items.set(item, Math.min(tile.entity.items.get(item), max));
        }
        for (Tile other : new ObjectSet.ObjectSetIterator<Tile>(Vars.state.teams.get((Team)tile.getTeam()).cores)) {
            other.block().onProximityUpdate(other);
        }
    }

    @Override
    public void placed(Tile tile) {
        super.placed(tile);
        Vars.state.teams.get((Team)tile.getTeam()).cores.add(tile);
    }

    @Override
    public void drawLayer(Tile tile) {
        CoreEntity entity = (CoreEntity)tile.entity();
        if (entity.heat > 0.001f) {
            RespawnBlock.drawRespawn(tile, entity.heat, entity.progress, entity.time, entity.spawnPlayer, this.mech);
        }
    }

    @Override
    public void handleItem(Item item, Tile tile, Tile source) {
        if (Vars.net.server() || !Vars.net.active()) {
            super.handleItem(item, tile, source);
            if (Vars.state.rules.tutorial) {
                Events.fire(new EventType.CoreItemDeliverEvent());
            }
        }
    }

    @Override
    public void update(Tile tile) {
        CoreEntity entity = (CoreEntity)tile.entity();
        if (entity.spawnPlayer != null) {
            if (!entity.spawnPlayer.isDead() || !entity.spawnPlayer.isAdded()) {
                entity.spawnPlayer = null;
                return;
            }
            entity.spawnPlayer.set(tile.drawx(), tile.drawy());
            entity.heat = Mathf.lerpDelta(entity.heat, 1.0f, 0.1f);
            entity.time += entity.delta();
            entity.progress += 1.0f / Vars.state.rules.respawnTime * entity.delta();
            if (entity.progress >= 1.0f) {
                Call.onUnitRespawn(tile, entity.spawnPlayer);
            }
        } else {
            entity.heat = Mathf.lerpDelta(entity.heat, 0.0f, 0.1f);
        }
    }

    @Override
    public boolean shouldActiveSound(Tile tile) {
        CoreEntity entity = (CoreEntity)tile.entity();
        return entity.spawnPlayer != null;
    }

    @Override
    public TileEntity newEntity() {
        return new CoreEntity();
    }

    public class CoreEntity
    extends TileEntity
    implements SpawnerTrait {
        protected Player spawnPlayer;
        protected float progress;
        protected float time;
        protected float heat;
        protected int storageCapacity;

        @Override
        public boolean hasUnit(Unit unit) {
            return unit == this.spawnPlayer;
        }

        @Override
        public void updateSpawning(Player player) {
            if (!Vars.netServer.isWaitingForPlayers() && this.spawnPlayer == null) {
                this.spawnPlayer = player;
                this.progress = 0.0f;
                player.mech = CoreBlock.this.mech;
                player.beginRespawning(this);
            }
        }
    }
}

