/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.storage;

import io.anuke.arc.Events;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.storage.StorageBlock;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public class LaunchPad
extends StorageBlock {
    protected final int timerLaunch;
    protected float launchTime;

    public LaunchPad(String name) {
        super(name);
        this.timerLaunch = this.timers++;
        this.update = true;
        this.hasItems = true;
        this.solid = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.launchTime, this.launchTime / 60.0f, StatUnit.seconds);
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return item.type == ItemType.material && tile.entity.items.total() < this.itemCapacity;
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        float progress = Mathf.clamp(Mathf.clamp((float)tile.entity.items.total() / (float)this.itemCapacity) * (tile.entity.timer.getTime(this.timerLaunch) / (this.launchTime / tile.entity.timeScale)));
        float scale = (float)this.size / 3.0f;
        Lines.stroke(2.0f);
        Draw.color(Pal.accentBack);
        Lines.poly(tile.drawx(), tile.drawy(), 4, scale * 10.0f * (1.0f - progress), 45.0f + 360.0f * progress);
        Draw.color(Pal.accent);
        if (tile.entity.cons.valid()) {
            for (int i = 0; i < 3; ++i) {
                float f = (Time.time() / 200.0f + (float)i * 0.5f) % 1.0f;
                Lines.stroke(2.0f * (2.0f - Math.abs(0.5f - f) * 2.0f) - 2.0f + 0.2f);
                Lines.poly(tile.drawx(), tile.drawy(), 4, (1.0f - f) * 10.0f * scale);
            }
        }
        Draw.reset();
    }

    @Override
    public void update(Tile tile) {
        TileEntity entity = tile.entity;
        if (Vars.world.isZone() && entity.cons.valid() && Vars.world.isZone() && entity.items.total() >= this.itemCapacity && entity.timer.get(this.timerLaunch, this.launchTime / entity.timeScale)) {
            for (Item item : Vars.content.items()) {
                Events.fire(EventType.Trigger.itemLaunch);
                Effects.effect(Fx.padlaunch, tile);
                int used = Math.min(entity.items.get(item), this.itemCapacity);
                Vars.data.addItem(item, used);
                entity.items.remove(item, used);
            }
        }
    }
}

