/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.storage;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.ItemSelection;
import io.anuke.mindustry.world.blocks.storage.StorageBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Unloader
extends Block {
    protected float speed = 1.0f;
    protected final int timerUnload = this.timers++;
    private static Item lastItem;

    public Unloader(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.health = 70;
        this.hasItems = true;
        this.configurable = true;
    }

    @Override
    public boolean canDump(Tile tile, Tile to, Item item) {
        return !(to.block() instanceof StorageBlock);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("items");
    }

    @Override
    public void playerPlaced(Tile tile) {
        Core.app.post(() -> Call.setSortedUnloaderItem(null, tile, lastItem));
    }

    public static void setSortedUnloaderItem(Player player, Tile tile, Item item) {
        if (!Units.canInteract(player, tile)) {
            return;
        }
        SortedUnloaderEntity entity = (SortedUnloaderEntity)tile.entity();
        entity.items.clear();
        entity.sortItem = item;
    }

    @Override
    public void update(Tile tile) {
        SortedUnloaderEntity entity = (SortedUnloaderEntity)tile.entity();
        if (tile.entity.timer.get(this.timerUnload, this.speed / entity.timeScale) && tile.entity.items.total() == 0) {
            for (Tile other : tile.entity.proximity()) {
                if (!other.interactable(tile.getTeam()) || !other.block().unloadable || !other.block().hasItems || entity.items.total() != 0 || (entity.sortItem != null || other.entity.items.total() <= 0) && !this.hasItem(other, entity.sortItem)) continue;
                this.offloadNear(tile, this.removeItem(other, entity.sortItem));
            }
        }
        if (entity.items.total() > 0) {
            this.tryDump(tile);
        }
    }

    private Item removeItem(Tile tile, Item item) {
        TileEntity entity = tile.entity;
        if (item == null) {
            return entity.items.take();
        }
        if (entity.items.has(item)) {
            entity.items.remove(item, 1);
            return item;
        }
        return null;
    }

    private boolean hasItem(Tile tile, Item item) {
        TileEntity entity = tile.entity;
        if (item == null) {
            return entity.items.total() > 0;
        }
        return entity.items.has(item);
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        SortedUnloaderEntity entity = (SortedUnloaderEntity)tile.entity();
        Draw.color(entity.sortItem == null ? Color.clear : entity.sortItem.color);
        Fill.square(tile.worldx(), tile.worldy(), 1.0f);
        Draw.color();
    }

    @Override
    public void buildTable(Tile tile, Table table) {
        SortedUnloaderEntity entity = (SortedUnloaderEntity)tile.entity();
        ItemSelection.buildItemTable(table, () -> entity.sortItem, item -> {
            lastItem = item;
            Call.setSortedUnloaderItem(null, tile, item);
        });
    }

    @Override
    public TileEntity newEntity() {
        return new SortedUnloaderEntity();
    }

    public static class SortedUnloaderEntity
    extends TileEntity {
        public Item sortItem = null;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeByte(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            byte id = stream.readByte();
            this.sortItem = id == -1 ? null : Vars.content.items().get(id);
        }
    }
}

