/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.units;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.IconSize;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockFlag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CommandCenter
extends Block {
    protected TextureRegion[] commandRegions = new TextureRegion[UnitCommand.all.length];
    protected Color topColor = Pal.command;
    protected Color bottomColor = Color.valueOf("5e5e5e");
    protected Effects.Effect effect = Fx.commandSend;

    public CommandCenter(String name) {
        super(name);
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.comandCenter});
        this.destructible = true;
        this.solid = true;
        this.configurable = true;
    }

    @Override
    public void placed(Tile tile) {
        super.placed(tile);
        ObjectSet<Tile> set = Vars.indexer.getAllied(tile.getTeam(), BlockFlag.comandCenter);
        if (set.size > 0) {
            CommandCenterEntity entity = (CommandCenterEntity)tile.entity();
            CommandCenterEntity oe = (CommandCenterEntity)set.first().entity();
            entity.command = oe.command;
        }
    }

    @Override
    public void removed(Tile tile) {
        super.removed(tile);
        ObjectSet<Tile> set = Vars.indexer.getAllied(tile.getTeam(), BlockFlag.comandCenter);
        if (set.size == 1) {
            for (BaseUnit unit : Vars.unitGroups[tile.getTeam().ordinal()].all()) {
                unit.onCommand(UnitCommand.all[0]);
            }
        }
    }

    @Override
    public void load() {
        super.load();
        for (UnitCommand cmd : UnitCommand.all) {
            this.commandRegions[cmd.ordinal()] = Core.atlas.find("icon-command-" + cmd.name() + "-small");
        }
    }

    @Override
    public void draw(Tile tile) {
        CommandCenterEntity entity = (CommandCenterEntity)tile.entity();
        super.draw(tile);
        float size = (float)IconSize.small.size / 4.0f;
        Draw.color(this.bottomColor);
        Draw.rect(this.commandRegions[entity.command.ordinal()], tile.drawx(), tile.drawy() - 1.0f, size, size);
        Draw.color(this.topColor);
        Draw.rect(this.commandRegions[entity.command.ordinal()], tile.drawx(), tile.drawy(), size, size);
        Draw.color();
    }

    @Override
    public void buildTable(Tile tile, Table table) {
        CommandCenterEntity entity = (CommandCenterEntity)tile.entity();
        ButtonGroup group = new ButtonGroup();
        Table buttons = new Table();
        for (UnitCommand cmd : UnitCommand.all) {
            buttons.addImageButton(Core.atlas.drawable("icon-command-" + cmd.name() + "-small"), Styles.clearToggleTransi, () -> Call.onCommandCenterSet(Vars.player, tile, cmd)).size(44.0f).group(group).update((T b) -> b.setChecked(entity.command == cmd));
        }
        table.add(buttons);
        table.row();
        table.label(() -> entity.command.localized()).style(Styles.outlineLabel).center().growX().get().setAlignment(1);
    }

    public static void onCommandCenterSet(Player player, Tile tile, UnitCommand command) {
        if (player == null || tile == null || !Units.canInteract(player, tile)) {
            return;
        }
        Effects.effect(((CommandCenter)tile.block()).effect, tile);
        for (Tile center : Vars.indexer.getAllied(tile.getTeam(), BlockFlag.comandCenter)) {
            if (!(center.block() instanceof CommandCenter)) continue;
            CommandCenterEntity entity = (CommandCenterEntity)center.entity();
            entity.command = command;
        }
        Team team = player == null ? tile.getTeam() : player.getTeam();
        for (BaseUnit unit : Vars.unitGroups[team.ordinal()].all()) {
            unit.onCommand(command);
        }
        Events.fire(new EventType.CommandIssueEvent(tile, command));
    }

    @Override
    public TileEntity newEntity() {
        return new CommandCenterEntity();
    }

    public class CommandCenterEntity
    extends TileEntity {
        public UnitCommand command = UnitCommand.attack;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeByte(this.command.ordinal());
        }

        @Override
        public void read(DataInput stream, byte version) throws IOException {
            super.read(stream, version);
            this.command = UnitCommand.all[stream.readByte()];
        }
    }
}

