/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.units;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.graphics.Shaders;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.ConsumeItems;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockFlag;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UnitFactory
extends Block {
    protected UnitType type;
    protected float produceTime = 1000.0f;
    protected float launchVelocity = 0.0f;
    protected TextureRegion topRegion;
    protected int maxSpawn = 4;
    protected int[] capacities;

    public UnitFactory(String name) {
        super(name);
        this.update = true;
        this.hasPower = true;
        this.hasItems = true;
        this.solid = false;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.producer});
    }

    public static void onUnitFactorySpawn(Tile tile, int spawns) {
        if (!(tile.entity instanceof UnitFactoryEntity) || !(tile.block() instanceof UnitFactory)) {
            return;
        }
        UnitFactoryEntity entity = (UnitFactoryEntity)tile.entity();
        UnitFactory factory = (UnitFactory)tile.block();
        entity.buildTime = 0.0f;
        entity.spawned = spawns;
        Effects.shake(2.0f, 3.0f, entity);
        Effects.effect(Fx.producesmoke, tile.drawx(), tile.drawy());
        if (!Vars.net.client()) {
            BaseUnit unit = factory.type.create(tile.getTeam());
            unit.setSpawner(tile);
            unit.set(tile.drawx() + (float)Mathf.range(4), tile.drawy() + (float)Mathf.range(4));
            unit.add();
            unit.velocity().y = factory.launchVelocity;
            Events.fire(new EventType.UnitCreateEvent(unit));
        }
    }

    @Override
    public void init() {
        super.init();
        this.capacities = new int[Vars.content.items().size];
        if (this.consumes.has(ConsumeType.item)) {
            ConsumeItems cons = (ConsumeItems)this.consumes.get(ConsumeType.item);
            for (ItemStack stack : cons.items) {
                this.capacities[stack.item.id] = stack.amount * 2;
            }
        }
    }

    @Override
    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("progress", entity -> new Bar("bar.progress", Pal.ammo, () -> ((UnitFactoryEntity)entity).buildTime / this.produceTime));
        this.bars.add("spawned", entity -> new Bar(() -> Core.bundle.format("bar.spawned", ((UnitFactoryEntity)entity).spawned, this.maxSpawn), () -> Pal.command, () -> (float)((UnitFactoryEntity)entity).spawned / (float)this.maxSpawn));
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(BlockStat.itemCapacity);
        this.stats.add(BlockStat.productionTime, this.produceTime / 60.0f, StatUnit.seconds);
        this.stats.add(BlockStat.maxUnits, this.maxSpawn, StatUnit.none);
    }

    @Override
    public void unitRemoved(Tile tile, Unit unit) {
        UnitFactoryEntity entity = (UnitFactoryEntity)tile.entity();
        --entity.spawned;
        entity.spawned = Math.max(entity.spawned, 0);
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-top")};
    }

    @Override
    public void draw(Tile tile) {
        UnitFactoryEntity entity = (UnitFactoryEntity)tile.entity();
        TextureRegion region = this.type.iconRegion;
        Draw.rect(this.name, tile.drawx(), tile.drawy());
        Shaders.build.region = region;
        Shaders.build.progress = entity.buildTime / this.produceTime;
        Shaders.build.color.set(Pal.accent);
        Shaders.build.color.a = entity.speedScl;
        Shaders.build.time = -entity.time / 20.0f;
        Draw.shader(Shaders.build);
        Draw.rect(region, tile.drawx(), tile.drawy());
        Draw.shader();
        Draw.color(Pal.accent);
        Draw.alpha(entity.speedScl);
        Lines.lineAngleCenter(tile.drawx() + Mathf.sin(entity.time, 20.0f, 4.0f * (float)this.size - 2.0f), tile.drawy(), 90.0f, (float)(this.size * 8) - 4.0f);
        Draw.reset();
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
    }

    @Override
    public void update(Tile tile) {
        UnitFactoryEntity entity = (UnitFactoryEntity)tile.entity();
        if (entity.spawned >= this.maxSpawn) {
            return;
        }
        if (entity.cons.valid() || tile.isEnemyCheat()) {
            entity.time += entity.delta() * entity.speedScl * Vars.state.rules.unitBuildSpeedMultiplier * entity.power.satisfaction;
            entity.buildTime += entity.delta() * entity.power.satisfaction * Vars.state.rules.unitBuildSpeedMultiplier;
            entity.speedScl = Mathf.lerpDelta(entity.speedScl, 1.0f, 0.05f);
        } else {
            entity.speedScl = Mathf.lerpDelta(entity.speedScl, 0.0f, 0.05f);
        }
        if (entity.buildTime >= this.produceTime) {
            entity.buildTime = 0.0f;
            Call.onUnitFactorySpawn(tile, entity.spawned + 1);
            this.useContent(tile, this.type);
            entity.cons.trigger();
        }
    }

    @Override
    public int getMaximumAccepted(Tile tile, Item item) {
        return this.capacities[item.id];
    }

    @Override
    public TileEntity newEntity() {
        return new UnitFactoryEntity();
    }

    @Override
    public boolean canProduce(Tile tile) {
        UnitFactoryEntity entity = (UnitFactoryEntity)tile.entity();
        return entity.spawned < this.maxSpawn;
    }

    public static class UnitFactoryEntity
    extends TileEntity {
        float buildTime;
        float time;
        float speedScl;
        int spawned;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.buildTime);
            stream.writeInt(this.spawned);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.buildTime = stream.readFloat();
            this.spawned = stream.readInt();
        }
    }
}

