/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.consumers;

import io.anuke.arc.function.Predicate;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.UnlockableContent;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.ui.ItemImage;
import io.anuke.mindustry.ui.MultiReqImage;
import io.anuke.mindustry.ui.ReqImage;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BlockStats;
import io.anuke.mindustry.world.meta.values.ItemFilterValue;

public class ConsumeItemFilter
extends Consume {
    public final Predicate<Item> filter;

    public ConsumeItemFilter(Predicate<Item> item) {
        this.filter = item;
    }

    @Override
    public void applyItemFilter(boolean[] arr) {
        Vars.content.items().each(this.filter, item -> {
            arr[item.id] = true;
        });
    }

    @Override
    public ConsumeType type() {
        return ConsumeType.item;
    }

    @Override
    public void build(Tile tile, Table table) {
        MultiReqImage image = new MultiReqImage();
        Vars.content.items().each(i -> this.filter.test((Item)i) && (!Vars.world.isZone() || Vars.data.isUnlocked((UnlockableContent)i)), item -> image.add(new ReqImage((Element)new ItemImage(item.icon(Item.Icon.large), 1), () -> tile.entity != null && tile.entity.items != null && tile.entity.items.has((Item)item))));
        table.add(image).size(32.0f);
    }

    @Override
    public String getIcon() {
        return "icon-item";
    }

    @Override
    public void update(TileEntity entity) {
    }

    @Override
    public void trigger(TileEntity entity) {
        for (int i = 0; i < Vars.content.items().size; ++i) {
            Item item = Vars.content.item(i);
            if (entity.items == null || !entity.items.has(item) || !this.filter.test(item)) continue;
            entity.items.remove(item, 1);
            break;
        }
    }

    @Override
    public boolean valid(TileEntity entity) {
        for (int i = 0; i < Vars.content.items().size; ++i) {
            Item item = Vars.content.item(i);
            if (entity.items == null || !entity.items.has(item) || !this.filter.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void display(BlockStats stats) {
        stats.add(this.booster ? BlockStat.booster : BlockStat.input, new ItemFilterValue(this.filter));
    }
}

