/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.consumers;

import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.MultiReqImage;
import io.anuke.mindustry.ui.ReqImage;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.ConsumeLiquidBase;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BlockStats;
import io.anuke.mindustry.world.meta.values.LiquidFilterValue;

public class ConsumeLiquidFilter
extends ConsumeLiquidBase {
    public final Predicate<Liquid> filter;

    public ConsumeLiquidFilter(Predicate<Liquid> liquid, float amount) {
        super(amount);
        this.filter = liquid;
    }

    @Override
    public void applyLiquidFilter(boolean[] arr) {
        Vars.content.liquids().each(this.filter, item -> {
            arr[item.id] = true;
        });
    }

    @Override
    public void build(Tile tile, Table table) {
        Array<Liquid> list = Vars.content.liquids().select(l -> !l.isHidden() && this.filter.test((Liquid)l));
        MultiReqImage image = new MultiReqImage();
        list.each(liquid -> image.add(new ReqImage(liquid.getContentIcon(), () -> tile.entity != null && tile.entity.liquids != null && tile.entity.liquids.get((Liquid)liquid) >= this.use(tile.entity))));
        table.add(image).size(32.0f);
    }

    @Override
    public String getIcon() {
        return "icon-liquid-consume";
    }

    @Override
    public void update(TileEntity entity) {
        entity.liquids.remove(entity.liquids.current(), this.use(entity));
    }

    @Override
    public boolean valid(TileEntity entity) {
        return entity != null && entity.liquids != null && this.filter.test(entity.liquids.current()) && entity.liquids.currentAmount() >= this.use(entity);
    }

    @Override
    public void display(BlockStats stats) {
        stats.add(this.booster ? BlockStat.booster : BlockStat.input, new LiquidFilterValue(this.filter, this.amount * this.timePeriod, this.timePeriod == 60.0f));
    }
}

