/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.meta.values;

import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.LiquidDisplay;
import io.anuke.mindustry.world.meta.StatValue;

public class LiquidFilterValue
implements StatValue {
    private final Predicate<Liquid> filter;
    private final float amount;
    private final boolean perSecond;

    public LiquidFilterValue(Predicate<Liquid> filter, float amount, boolean perSecond) {
        this.filter = filter;
        this.amount = amount;
        this.perSecond = perSecond;
    }

    @Override
    public void display(Table table) {
        Array<Liquid> list = new Array<Liquid>();
        for (Liquid item : Vars.content.liquids()) {
            if (item.isHidden() || !this.filter.test(item)) continue;
            list.add(item);
        }
        for (int i = 0; i < list.size; ++i) {
            table.add(new LiquidDisplay((Liquid)list.get(i), this.amount, this.perSecond)).padRight(5.0f);
            if (i == list.size - 1) continue;
            table.add("/");
        }
    }
}

