/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.modules;

import io.anuke.mindustry.Vars;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.modules.BlockModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class LiquidModule
extends BlockModule {
    private float[] liquids;
    private float total;
    private Liquid current;

    public LiquidModule() {
        this.liquids = new float[Vars.content.liquids().size];
        this.current = Vars.content.liquid(0);
    }

    public float total() {
        return this.total;
    }

    public Liquid current() {
        return this.current;
    }

    public void reset(Liquid liquid, float amount) {
        for (int i = 0; i < this.liquids.length; ++i) {
            this.liquids[i] = 0.0f;
        }
        this.liquids[liquid.id] = amount;
        this.total = amount;
        this.current = liquid;
    }

    public float currentAmount() {
        return this.liquids[this.current.id];
    }

    public float get(Liquid liquid) {
        return this.liquids[liquid.id];
    }

    public void clear() {
        this.total = 0.0f;
        Arrays.fill(this.liquids, 0.0f);
    }

    public void add(Liquid liquid, float amount) {
        short s = liquid.id;
        this.liquids[s] = this.liquids[s] + amount;
        this.total += amount;
        this.current = liquid;
    }

    public void remove(Liquid liquid, float amount) {
        this.add(liquid, -amount);
    }

    public void forEach(LiquidConsumer cons) {
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            cons.accept(Vars.content.liquid(i), this.liquids[i]);
        }
    }

    public float sum(LiquidCalculator calc) {
        float sum = 0.0f;
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            sum += calc.get(Vars.content.liquid(i), this.liquids[i]);
        }
        return sum;
    }

    @Override
    public void write(DataOutput stream) throws IOException {
        int amount = 0;
        for (float liquid : this.liquids) {
            if (!(liquid > 0.0f)) continue;
            amount = (byte)(amount + 1);
        }
        stream.writeByte(amount);
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            stream.writeByte(i);
            stream.writeFloat(this.liquids[i]);
        }
    }

    @Override
    public void read(DataInput stream) throws IOException {
        int count = stream.readByte();
        for (int j = 0; j < count; ++j) {
            float amount;
            byte liquidid = stream.readByte();
            this.liquids[liquidid] = amount = stream.readFloat();
            if (amount > 0.0f) {
                this.current = Vars.content.liquid(liquidid);
            }
            this.total += amount;
        }
    }

    public static interface LiquidCalculator {
        public float get(Liquid var1, float var2);
    }

    public static interface LiquidConsumer {
        public void accept(Liquid var1, float var2);
    }
}

