-- 
-- DO NOT EDIT THIS FILE. IT WILL BE OVERWRITTEN WHEN YOU UPGRADE RAINLENDAR!
-- 

--
-- Snoozes the given event or task. The snooze time is the default time
-- as set in the settings.
--
-- Parameters: 
--    uidItem - The unique identifier of the event/task.
-- Return:
--    Nothing
--
function Global_Snooze(uidItem)
	Rainlendar_SnoozeAlarm(uidItem, -1)
	Rainlendar_Redraw(1)
end

--
-- Snoozes all visible alarms. The snooze time is the default time
-- as set in the settings.
--
-- Parameters: 
--    None
-- Return:
--    Nothing
--
function Global_SnoozeAll()
-- TODO: calculate some good snooze time

	uidAlarms = Rainlendar_GetAlarmItems()
	for key, value in pairs (uidAlarms) do
		Rainlendar_SnoozeAlarm(value, -1)
	end

	Rainlendar_Redraw(1)
end

--
-- Dismisses the given event's or task's alarm.
--
-- Parameters: 
--    uidItem - The unique identifier of the event/task.
-- Return:
--    Nothing
--
function Global_Dismiss(uidItem)
	Rainlendar_DismissAlarm(uidItem)
	Rainlendar_Redraw(1)
end

--
-- Dismisses all visible alarms.
--
-- Parameters: 
--    None
-- Return:
--    Nothing
--
function Global_DismissAll()
	Rainlendar_DismissAlarm("")		-- empty string dismisses all
	Rainlendar_Redraw(1)
end

--
-- Opens the snooze menu on the mouse position. The snooze values are read
-- from the settings. If an item is selected from the menu the chosen
-- alarm is snoozed for that amount of time.
--
-- Parameters: 
--    uidItem - The unique identifier of the event/task.
-- Return:
--    Nothing
--
function Global_SnoozeMenu(uidItem)
  snooze, relative = Internal_ShowSnoozeMenu(false)
  if snooze > -1 then
    Rainlendar_SnoozeAlarm(uidItem, snooze, relative)
    Rainlendar_Redraw(1)
  end
end

--
-- Opens the dismiss and snooze menu on the mouse position. The snooze values are read
-- from the settings. If an item is selected from the menu the chosen
-- alarm is snoozed for that amount of time.
--
-- Parameters: 
--    uidItem - The unique identifier of the event/task.
-- Return:
--    Nothing
--
function Global_DismissAndSnoozeMenu(uidItem)
  snooze, relative = Internal_ShowSnoozeMenu(true)
  if snooze > -1 then
    Rainlendar_SnoozeAlarm(uidItem, snooze, relative)
    Rainlendar_Redraw(1)
  elseif snooze == -2 then
    Rainlendar_DismissAlarm(uidItem)
    Rainlendar_Redraw(1)
  end
end

--
-- Opens the snooze menu on the mouse position. The snooze values are read
-- from the settings. If an item is selected from the menu all visible
-- alarms are snoozed for that amount of time.
--
-- Parameters: 
--    None
-- Return:
--    Nothing
--
function Global_SnoozeMenuAll()
  snooze, relative = Internal_ShowSnoozeMenu()
  if snooze > -1 then
	  uidAlarms = Rainlendar_GetAlarmItems()
	  for key, value in pairs (uidAlarms) do
  		Rainlendar_SnoozeAlarm(value, values[result], relative)
  	end
  	Rainlendar_Redraw(1)
  end
end

--
-- Internal function which opens the snooze menu and returns the
-- time user selected from the list.
--
-- Parameters: 
--    dismiss - Show also dismiss item in the menu
-- Return:
--    The snooze time in seconds. -1 is returned if nothing is selected. -2 for dismiss.
--
function Internal_ShowSnoozeMenu(dismiss)
  menu = {}
  values = {}
  relative = {}

  -- Get the snooze times from the settings
  snoozeTimes = Rainlendar_GetOption("GlobalSettings", "SnoozeTimes")

  -- Split the values
  sep = ";"
  snoozeMinutes = {}
  snoozeTimes = snoozeTimes .. sep
  snoozeTimes:gsub("([^"..sep.."]*)"..sep, function(c) table.insert(snoozeMinutes, c) end)

  -- Create the menu items
  for key, value in pairs(snoozeMinutes) do

    rel = false
    if string.sub(value, -1) == "r" then
      rel = true
      value = string.sub(value, 0, -2)
    end
    
    mins = math.floor(tonumber(value) % 60)
    hours = math.floor(tonumber(value / 60) % 24)
    days = math.floor(tonumber(value / 60 / 24))
    
    text = Rainlendar_GetString("Snooze")   

	timeFormat = Rainlendar_GetOption("GlobalSettings", "TimeFormat")
	timeFormat = timeFormat:gsub("#", "")
	if timeFormat == "" then
        timeFormat = "%H:%M"
	end

	dateFormat = Rainlendar_GetOption("GlobalSettings", "DateFormat")
	dateFormat = dateFormat:gsub("#", "")
	if dateFormat == "" then
        dateFormat = "%x"
	end

	current = os.time()
	snooze = current + days * 24 * 60 * 60 + hours * 60 * 60 + mins * 60
    if rel then
		untilTime = ""
	else
		if os.date("%d", current) == os.date("%d", snooze) then
			untilTime = " (" .. os.date(timeFormat, snooze) .. ")"
		else
			untilTime = " (" .. os.date(dateFormat .. " " .. timeFormat, snooze) .. ")"
		end
	end
	
    if days == 1 then
      text = text .. " " ..days .. " " .. Rainlendar_GetString("day") .. untilTime
    elseif days > 1 then
      text = text .. " " ..days .. " " .. Rainlendar_GetString("days") .. untilTime
    end

    if hours == 1 then
      text = text .. " " ..hours .. " " .. Rainlendar_GetString("hour") .. untilTime
    elseif hours > 1 then
      text = text .. " " ..hours .. " " .. Rainlendar_GetString("hours") .. untilTime
    end

    if mins == 1 then
      text = text .. " " ..mins .. " " .. Rainlendar_GetString("minute") .. untilTime
    elseif (mins > 1) or (days == 0 and hours == 0 and mins == 0) then
      text = text .. " " .. mins .. " " .. Rainlendar_GetString("minutes") .. untilTime
    end

    if rel then
      text = text .. " " .. Rainlendar_GetString("before target")
    end
    
    -- Store the menu text and the snooze value (as minutes) 
    if hours >= 0 or mins >= 0 or days >= 0 then
      menu[#menu + 1] = text
      values[#values + 1] = tonumber(value) * 60
      relative[#relative + 1] = rel
    end
  end

  if dismiss then
      menu[#menu + 1] = "---"
      menu[#menu + 1] = Rainlendar_GetString("Dismiss")
  end

  -- Open the menu on the mouse position
  result = Rainlendar_ShowMenu(-1, -1, menu)

  -- Snooze all items for the given amount of time 
  result = tonumber(result)
  if result > 0 and result <= #values then
    return values[result], relative[result]
  end

  if result > #values then
    return -2   -- Dismiss
  end

  return -1     -- Nothing selected  
end
