--
-- Changes the task's status to COMPLETED or to NEEDSACTION
-- if it already is set as COMPLETED.
--
-- Parameters: 
--    strGuid - The unique identifier of the task.
-- Return:
--    Nothing
--
function Global_ToggleTaskStatus(strGuid)
  strStatus = Rainlendar_GetTaskStatus(strGuid)

  if (strStatus) then
	if (strStatus == "COMPLETED") then
		Rainlendar_SetTaskStatus(strGuid, "NEEDSACTION")
	else
		Rainlendar_SetTaskStatus(strGuid, "COMPLETED")
	end
  
    -- Redraw the windows if there were changes that need to be shown
    Rainlendar_Redraw(1)
  end
end

--
-- Hides the task's subtasks if it has any
--
-- Parameters: 
--    strGuid - The unique identifier of the task.
-- Return:
--    Nothing
--
function Global_CollapseTask(strGuid)
  Rainlendar_CollapseTask(strGuid)

  -- Redraw the windows if there were changes that need to be shown
  Rainlendar_Redraw(1)
end

--
-- Shows the task's subtasks if it has any
--
-- Parameters: 
--    strGuid - The unique identifier of the task.
-- Return:
--    Nothing
--
function Global_ExpandTask(strGuid)
  Rainlendar_ExpandTask(strGuid)
  
  -- Redraw the windows if there were changes that need to be shown
  Rainlendar_Redraw(1)
end

---------------------------------------------
-- Private functions. Don't call directly! --
---------------------------------------------

--
-- Returns the given property from the iCalendar data. If the property
-- is not found Nil is returned.
--
function Private_GetIcalProperty(strComponent, strProperty)
  s, e, result = string.find(strComponent, strProperty .. ".-:(.-)\r\n")
  return result
end

--
-- Set the property to the iCalendar data. If the property is already in the data
-- its value is replaced. Otherwise the property is added to the data.
--
function Private_SetIcalProperty(strComponent, strProperty, strValue)
  s, e = string.find(strComponent, strProperty .. ":.-\r\n")
  if (s and e) then
    -- The property was found -> replace the value
    return string.gsub(strComponent, strProperty .. ":(.-)\r\n", strProperty .. ":" .. strValue .. "\r\n")
  else
    -- The property is missing -> create a new one
    return string.gsub(strComponent, "END:", strProperty .. ":" .. strValue .. "\r\nEND:")
  end
end

--
-- Converts the time to iCal datetime representation 
-- 19970714T173000Z
--
function Private_GetCurrentTime()
  arrayTime = os.date("!*t")
  return string.format("%04i%02i%02iT%02i%02i%02iZ", arrayTime["year"], arrayTime["month"], arrayTime["day"], arrayTime["hour"], arrayTime["min"], arrayTime["sec"])
end
