local AtlasLoot = _G.AtlasLoot
local Profession = {}
AtlasLoot.Data.Profession = Profession
local Recipe, ContentPhase
local AL = AtlasLoot.Locales
local ALIL = AtlasLoot.IngameLocales

local format = string.format

local LOC_STRING_DESC = AL["|cff00ff00L-Click:|r %s"]
local LOC_STRING_DESC2 = AL["|cff00ff00Left-Click:|r Show reagents."]
local FORMAT_STRING_SKILL = "|cffff8040%d|r |cffffff00%d|r |cff40bf40%d|r |cff808080%d|r"
local FORMAT_STRING_SKILL2 = "|cffffff00%d|r |cff40bf40%d|r |cff808080%d|r"

local PROFESSION_DEFAULT = 0
local PROFESSION_TEXT = {
	[0]  = LOC_STRING_DESC2,	                            -- UNKNOWN
	[1]  = format(LOC_STRING_DESC, ALIL["First Aid"]),      -- First Aid
	[2]  = format(LOC_STRING_DESC, ALIL["Blacksmithing"]),  -- Blacksmithing
	[3]  = format(LOC_STRING_DESC, ALIL["Leatherworking"]), -- Leatherworking
	[4]  = format(LOC_STRING_DESC, ALIL["Alchemy"]),        -- Alchemy
	[5]  = format(LOC_STRING_DESC, ALIL["Herbalism"]),      -- Herbalism
	[6]  = format(LOC_STRING_DESC, ALIL["Cooking"]),        -- Cooking
	[7]  = format(LOC_STRING_DESC, ALIL["Mining"]),         -- Mining
	[8]  = format(LOC_STRING_DESC, ALIL["Tailoring"]),      -- Tailoring
	[9]  = format(LOC_STRING_DESC, ALIL["Engineering"]),    -- Engineering
	[10] = format(LOC_STRING_DESC, ALIL["Enchanting"]),     -- Enchanting
	[11] = format(LOC_STRING_DESC, ALIL["Fishing"]),        -- Fishing
    [12] = format(LOC_STRING_DESC, ALIL["Skinning"]),       -- Skinning
    [13] = format(LOC_STRING_DESC, ALIL["Poisons"]),        -- Poisons
}
Profession.PROFESSION_TEXT = PROFESSION_TEXT

local DUMMY_ICON = "Interface\\Icons\\INV_Misc_QuestionMark";
local PROFESSION_ICON = {
	[0]  = DUMMY_ICON,	          -- UNKNOWN
	[1]  = GetSpellTexture(3273), -- First Aid
	[2]  = GetSpellTexture(2018), -- Blacksmithing
	[3]  = GetSpellTexture(2108), -- Leatherworking
	[4]  = GetSpellTexture(2259), -- Alchemy
	[5]  = GetSpellTexture(2366), -- Herbalism
	[6]  = GetSpellTexture(2550), -- Cooking
	[7]  = GetSpellTexture(2575), -- Mining
	[8]  = GetSpellTexture(3908), -- Tailoring
	[9]  = GetSpellTexture(4036), -- Engineering
	[10] = GetSpellTexture(7411), -- Enchanting
	[11] = GetSpellTexture(7732), -- Fishing
    [12] = GetSpellTexture(8618), -- Skinning
    [13] = GetSpellTexture(2842), -- Rogue: Poisons
}

local PROFESSION = {
    -- [spellID] = { createdItemID, prof, minLvl, lowLvl, highLvl, reagents{}, reagentsCount{}, numCreatedItems }
    [10015] =  	{ 7960,  	2,  	1,  	285,  	310,  	{3860,6037,7910,7081,7966,4304}, {30,16,6,4,8,6} }, -- Truesilver Champion
    [2544] =  	{ 2683,  	6,  	75,  	115,  	155,  	{2674,2678}, {1,1} }, -- Crab Cake
    [2795] =  	{ 2888,  	6,  	25,  	60,  	100,  	{2886,2894}, {1,1} }, -- Beer Basted Boar Ribs
    [2541] =  	{ 2684,  	6,  	65,  	90,  	130,  	{2673}, {1} }, -- Coyote Steak
    [2542] =  	{ 724,  	6,  	50,  	90,  	130,  	{723,2678}, {1,1} }, -- Goretusk Liver Pie
    [2543] =  	{ 733,  	6,  	75,  	115,  	155,  	{729,730,731}, {1,1,1} }, -- Westfall Stew
    [2399] =  	{ 2582,  	8,  	85,  	110,  	145,  	{2997,2321,2605}, {2,2,1} }, -- Green Woolen Vest
    [2539] =  	{ 2680,  	6,  	30,  	50,  	90,  	{2672,2678}, {1,1} }, -- Spiced Wolf Meat
    [2540] =  	{ 2681,  	6,  	1,  	45,  	85,  	{769}, {1} }, -- Roasted Boar Meat
    [2333] =  	{ 3390,  	4,  	140,  	165,  	205,  	{3355,2452,3372}, {1,1,1} }, -- Elixir of Lesser Agility
    [2334] =  	{ 2458,  	4,  	50,  	80,  	120,  	{2449,2447,3371}, {2,1,1} }, -- Elixir of Minor Fortitude
    [2335] =  	{ 2459,  	4,  	60,  	90,  	130,  	{2452,2450,3371}, {1,1,1} }, -- Swiftness Potion
    [2336] =  	{ 2460,  	4,  	70,  	100,  	140,  	{2449,785,3371}, {2,2,1} }, -- Elixir of Tongues
    [2337] =  	{ 858,  	4,  	55,  	85,  	125,  	{118,2450}, {1,1} }, -- Lesser Healing Potion
    [8880] =  	{ 7166,  	2,  	30,  	70,  	110,  	{2840,2880,3470,2318}, {6,1,1,1} }, -- Copper Dagger
    [2663] =  	{ 2853,  	2,  	1,  	20,  	60,  	{2840}, {2} }, -- Copper Bracers
    [2664] =  	{ 2854,  	2,  	65,  	115,  	140,  	{2840,3470}, {10,3} }, -- Runed Copper Bracers
    [2665] =  	{ 2863,  	2,  	75,  	65,  	80,  	{2836}, {1} }, -- Coarse Sharpening Stone
    [2162] =  	{ 2310,  	3,  	65,  	90,  	120,  	{2318,2320}, {5,2} }, -- Embossed Leather Cloak
    [2163] =  	{ 2311,  	3,  	60,  	90,  	120,  	{2318,2320,2324}, {8,2,1} }, -- White Leather Jerkin
    [2158] =  	{ 2307,  	3,  	90,  	120,  	150,  	{2318,2320}, {7,2} }, -- Fine Leather Boots
    [2159] =  	{ 2308,  	3,  	85,  	105,  	135,  	{2318,2321}, {10,2} }, -- Fine Leather Cloak
    [2666] =  	{ 2857,  	2,  	80,  	110,  	150,  	{2840}, {10} }, -- Runed Copper Belt
    [2837] =  	{ 2893,  	13,  	1,  	215,  	265,  	{5173,3372}, {2,1} }, -- Deadly Poison II
    [3297] =  	{ 3492,  	2,  	145,  	175,  	205,  	{3575,3466,3391,1705,3478,2319}, {6,2,1,2,2,2} }, -- Mighty Iron Hammer
    [3515] =  	{ 3847,  	2,  	200,  	225,  	250,  	{3859,3577,3486,3864}, {10,4,4,1} }, -- Golden Scale Boots
    [3816] =  	{ 4231,  	3,  	35,  	55,  	75,  	{783,4289}, {1,1} }, -- Cured Light Hide
    [3817] =  	{ 4233,  	3,  	100,  	115,  	130,  	{4232,4289}, {1,1} }, -- Cured Medium Hide
    [3818] =  	{ 4236,  	3,  	150,  	160,  	170,  	{4235,4289}, {1,3} }, -- Cured Heavy Hide
    [3295] =  	{ 3490,  	2,  	125,  	155,  	185,  	{2841,3466,2459,1210,3478,2319}, {4,1,1,2,2,2} }, -- Deadly Bronze Poniard
    [3296] =  	{ 3491,  	2,  	130,  	160,  	190,  	{2841,3466,1206,1210,3478,2319}, {8,1,1,1,2,2} }, -- Heavy Bronze Mace
    [3495] =  	{ 3852,  	2,  	170,  	195,  	220,  	{3575,3577,1705,3466,4234,3486}, {10,4,2,2,2,2} }, -- Golden Iron Destroyer
    [2164] =  	{ 2312,  	3,  	75,  	105,  	135,  	{4231,2318,2320}, {1,4,2} }, -- Fine Leather Gloves
    [3973] =  	{ 4404,  	9,  	90,  	110,  	140,  	{2842}, {1}, 5 }, -- Silver Contact
    [3496] =  	{ 3853,  	2,  	180,  	205,  	230,  	{3859,3466,3486,1705,4234}, {8,2,2,3,3} }, -- Moonsteel Broadsword
    [3955] =  	{ 4384,  	9,  	150,  	175,  	200,  	{4382,4375,4377,2592}, {1,1,2,2} }, -- Explosive Sheep
    [3956] =  	{ 4385,  	9,  	150,  	175,  	200,  	{2319,1206,4368}, {4,2,1} }, -- Green Tinted Goggles
    [3957] =  	{ 4386,  	9,  	155,  	175,  	195,  	{4375,3829}, {1,1} }, -- Ice Deflector
    [3958] =  	{ 4387,  	9,  	160,  	160,  	180,  	{3575}, {2} }, -- Iron Strut
    [3502] =  	{ 3836,  	2,  	170,  	195,  	220,  	{3575,3864,2605}, {12,1,1} }, -- Green Iron Helm
    [3494] =  	{ 3851,  	2,  	155,  	180,  	205,  	{3575,3466,3486,2842,4234}, {8,2,1,4,2} }, -- Solid Iron Maul
    [3503] =  	{ 3837,  	2,  	190,  	215,  	240,  	{3859,3577,3486}, {8,2,2} }, -- Golden Scale Coif
    [3959] =  	{ 4388,  	9,  	160,  	180,  	200,  	{4375,4306,1529,4371}, {3,2,1,1} }, -- Discombobulator Ray
    [3960] =  	{ 4403,  	9,  	165,  	185,  	205,  	{4371,4387,4377,2319}, {4,1,4,4} }, -- Portable Bronze Mortar
    [3961] =  	{ 4389,  	9,  	170,  	170,  	210,  	{3575,10558}, {1,1} }, -- Gyrochronatom
    [2165] =  	{ 2313,  	3,  	75,  	115,  	130,  	{2319,2320}, {4,1} }, -- Medium Armor Kit
    [3504] =  	{ 3840,  	2,  	160,  	185,  	210,  	{3575,3486,2605}, {7,1,1} }, -- Green Iron Shoulders
    [3505] =  	{ 3841,  	2,  	175,  	200,  	225,  	{3859,3577,3486}, {6,2,1} }, -- Golden Scale Shoulders
    [3333] =  	{ 3483,  	2,  	135,  	165,  	195,  	{2841,2842,3478}, {8,1,2} }, -- Silvered Bronze Gauntlets
    [3938] =  	{ 4371,  	9,  	105,  	105,  	155,  	{2841,2880}, {2,1} }, -- Bronze Tube
    [2385] =  	{ 2568,  	8,  	10,  	45,  	70,  	{2996,2320}, {1,1} }, -- Brown Linen Vest
    [3491] =  	{ 3848,  	2,  	100,  	135,  	165,  	{2841,2880,3470,818,2319}, {6,4,2,1,1} }, -- Big Bronze Knife
    [3492] =  	{ 3849,  	2,  	160,  	185,  	210,  	{3575,3466,3486,1705,4234}, {6,2,1,2,3} }, -- Hardened Iron Shortsword
    [3493] =  	{ 3850,  	2,  	175,  	200,  	225,  	{3575,3466,3486,1529,4234}, {8,2,2,2,3} }, -- Jade Serpentblade
    [2403] =  	{ 2585,  	8,  	105,  	130,  	165,  	{2997,2321,4340}, {4,3,1} }, -- Gray Woolen Robe
    [2406] =  	{ 2587,  	8,  	100,  	110,  	130,  	{2997,2321,4340}, {2,1,1} }, -- Gray Woolen Shirt
    [2389] =  	{ 2572,  	8,  	40,  	65,  	100,  	{2996,2320,2604}, {3,2,2} }, -- Red Linen Robe
    [2392] =  	{ 2575,  	8,  	40,  	65,  	100,  	{2996,2320,2604}, {2,1,1} }, -- Red Linen Shirt
    [3932] =  	{ 4366,  	9,  	85,  	115,  	145,  	{4363,4359,2841,2592}, {1,2,1,1} }, -- Target Dummy
    [3336] =  	{ 3485,  	2,  	150,  	180,  	210,  	{3575,5498,3478,2605}, {4,2,2,1} }, -- Green Iron Gauntlets
    [3337] =  	{ 3486,  	2,  	125,  	125,  	150,  	{2838}, {3} }, -- Heavy Grinding Stone
    [3454] =  	{ 3829,  	4,  	200,  	220,  	260,  	{3358,3819,3372}, {4,2,1} }, -- Frost Oil
    [2393] =  	{ 2576,  	8,  	1,  	35,  	60,  	{2996,2320,2324}, {1,1,1} }, -- White Linen Shirt
    [2331] =  	{ 2455,  	4,  	30,  	65,  	105,  	{785,765,3371}, {1,1,1} }, -- Minor Mana Potion
    [2332] =  	{ 2456,  	4,  	40,  	70,  	110,  	{785,2447,3371}, {2,1,1} }, -- Minor Rejuvenation Potion
    [2402] =  	{ 2584,  	8,  	75,  	100,  	135,  	{2997,2321}, {1,1} }, -- Woolen Cape
    [2330] =  	{ 118,  	4,  	1,  	55,  	95,  	{2447,765,3371}, {1,1,1} }, -- Minor Healing Potion
    [2160] =  	{ 2300,  	3,  	50,  	70,  	100,  	{2318,2320}, {8,4} }, -- Embossed Leather Vest
    [2161] =  	{ 2309,  	3,  	65,  	85,  	115,  	{2318,2320}, {8,5} }, -- Embossed Leather Boots
    [2835] =  	{ 2892,  	13,  	1,  	175,  	225,  	{5173,3372}, {1,1} }, -- Deadly Poison
    [3933] =  	{ 4367,  	9,  	100,  	130,  	160,  	{4364,4363,2318,159}, {2,1,1,1} }, -- Small Seaforium Charge
    [3934] =  	{ 4368,  	9,  	100,  	130,  	160,  	{2318,818}, {6,2} }, -- Flying Tiger Goggles
    [3936] =  	{ 4369,  	9,  	105,  	130,  	155,  	{4361,4359,4399,2319}, {2,4,1,2} }, -- Deadly Blunderbuss
    [3294] =  	{ 3489,  	2,  	70,  	110,  	150,  	{2840,2880,2842,3470,2318}, {10,2,2,2,2} }, -- Thick War Axe
    [12044] =  	{ 10045,  	8,  	1,  	35,  	60,  	{2996,2320}, {1,1} }, -- Simple Linen Pants
    [2673] =  	{ 2869,  	2,  	130,  	160,  	190,  	{2841,2842,3478,1705}, {10,2,2,1} }, -- Silvered Bronze Breastplate
    [2674] =  	{ 2871,  	2,  	125,  	125,  	140,  	{2838}, {1} }, -- Heavy Sharpening Stone
    [2675] =  	{ 2870,  	2,  	135,  	175,  	205,  	{2841,1206,1705,5500,2842}, {20,2,2,2,4} }, -- Shining Silver Breastplate
    [2169] =  	{ 2317,  	3,  	100,  	125,  	150,  	{2319,2321,4340}, {6,1,1} }, -- Dark Leather Tunic
    [2662] =  	{ 2852,  	2,  	40,  	50,  	90,  	{2840}, {4} }, -- Copper Chain Pants
    [2963] =  	{ 2996,  	8,  	1,  	25,  	50,  	{2589}, {2} }, -- Bolt of Linen Cloth
    [2964] =  	{ 2997,  	8,  	75,  	90,  	105,  	{2592}, {3} }, -- Bolt of Woolen Cloth
    [2401] =  	{ 2583,  	8,  	95,  	120,  	155,  	{2997,2321,2318}, {4,2,2} }, -- Woolen Boots
    [2545] =  	{ 2682,  	6,  	85,  	125,  	165,  	{2675,2678}, {1,1} }, -- Cooked Crab Claw
    [2546] =  	{ 2687,  	6,  	110,  	120,  	160,  	{2677,2678}, {1,1} }, -- Dry Pork Ribs
    [2547] =  	{ 1082,  	6,  	100,  	135,  	175,  	{1081,1080}, {1,1} }, -- Redridge Goulash
    [2548] =  	{ 2685,  	6,  	110,  	130,  	170,  	{2677,2692}, {2,1} }, -- Succulent Pork Ribs
    [2549] =  	{ 1017,  	6,  	100,  	140,  	180,  	{1015,2665}, {2,1}, 3 }, -- Seasoned Wolf Kabob
    [2386] =  	{ 2569,  	8,  	65,  	90,  	125,  	{2996,2320,2318}, {3,1,1} }, -- Linen Boots
    [2387] =  	{ 2570,  	8,  	1,  	35,  	60,  	{2996,2320}, {1,1} }, -- Linen Cloak
    [2657] =  	{ 2840,  	7,  	1,  	25,  	70,  	{2770}, {1} }, -- Smelt Copper
    [2658] =  	{ 2842,  	7,  	75,  	100,  	125,  	{2775}, {1} }, -- Smelt Silver
    [2659] =  	{ 2841,  	7,  	65,  	65,  	115,  	{2840,3576}, {1,1}, 2 }, -- Smelt Bronze
    [3774] =  	{ 4257,  	3,  	160,  	180,  	200,  	{4236,4234,2321,2605,7071}, {1,5,1,1,1} }, -- Green Leather Belt
    [3776] =  	{ 4259,  	3,  	180,  	200,  	220,  	{4236,4234,2605,2321}, {2,6,1,1} }, -- Green Leather Bracers
    [2660] =  	{ 2862,  	2,  	1,  	15,  	55,  	{2835}, {1} }, -- Rough Sharpening Stone
    [3777] =  	{ 4260,  	3,  	195,  	215,  	235,  	{4234,4236,4291}, {6,2,1} }, -- Guardian Leather Bracers
    [3778] =  	{ 4262,  	3,  	185,  	205,  	225,  	{4236,5500,1529,3864,2321}, {4,2,2,1,1} }, -- Gem-studded Leather Belt
    [3779] =  	{ 4264,  	3,  	200,  	220,  	240,  	{4234,4236,4096,5633,4291,7071}, {6,2,2,1,1,1} }, -- Barbaric Belt
    [2668] =  	{ 2865,  	2,  	95,  	145,  	175,  	{2841}, {6} }, -- Rough Bronze Leggings
    [2670] =  	{ 2866,  	2,  	105,  	145,  	175,  	{2841}, {7} }, -- Rough Bronze Cuirass
    [2881] =  	{ 2318,  	3,  	1,  	20,  	40,  	{2934}, {3} }, -- Light Leather
    [2149] =  	{ 2302,  	3,  	1,  	40,  	70,  	{2318,2320}, {2,1} }, -- Handstitched Leather Boots
    [2152] =  	{ 2304,  	3,  	1,  	30,  	60,  	{2318}, {1} }, -- Light Armor Kit
    [2394] =  	{ 2577,  	8,  	40,  	65,  	100,  	{2996,2320,6260}, {2,1,1} }, -- Blue Linen Shirt
    [2395] =  	{ 2578,  	8,  	70,  	95,  	130,  	{2996,2318,2321}, {4,1,1} }, -- Barbaric Linen Vest
    [2396] =  	{ 2579,  	8,  	70,  	95,  	130,  	{2996,2321,2605}, {3,1,1} }, -- Green Linen Shirt
    [2397] =  	{ 2580,  	8,  	60,  	85,  	120,  	{2996,2320}, {2,3} }, -- Reinforced Linen Cape
    [2153] =  	{ 2303,  	3,  	30,  	45,  	75,  	{2318,2320}, {4,1} }, -- Handstitched Leather Pants
    [2671] =  	{ 2867,  	2,  	100,  	145,  	175,  	{2841}, {4} }, -- Rough Bronze Bracers
    [2672] =  	{ 2868,  	2,  	120,  	150,  	180,  	{2841,3478}, {5,2} }, -- Patterned Bronze Bracers
    [2166] =  	{ 2314,  	3,  	125,  	145,  	170,  	{2319,4231,2321}, {10,2,2} }, -- Toughened Leather Armor
    [2167] =  	{ 2315,  	3,  	100,  	125,  	150,  	{2319,2321,4340}, {4,2,1} }, -- Dark Leather Boots
    [2168] =  	{ 2316,  	3,  	110,  	135,  	160,  	{2319,2321,4340}, {8,1,1} }, -- Dark Leather Cloak
    [2661] =  	{ 2851,  	2,  	55,  	75,  	115,  	{2840}, {6} }, -- Copper Chain Belt
    [2667] =  	{ 2864,  	2,  	80,  	120,  	160,  	{2840,1210,3470}, {12,1,2} }, -- Runed Copper Breastplate
    [2329] =  	{ 2454,  	4,  	1,  	55,  	95,  	{2449,765,3371}, {1,1,1} }, -- Elixir of Lion's Strength
    [3397] =  	{ 3726,  	6,  	110,  	150,  	190,  	{3730,2692}, {1,1} }, -- Big Bear Steak
    [3856] =  	{ 4321,  	8,  	140,  	160,  	190,  	{4305,3182,2321}, {3,1,2} }, -- Spider Silk Slippers
    [3922] =  	{ 4359,  	9,  	30,  	45,  	60,  	{2840}, {1} }, -- Handful of Copper Bolts
    [3923] =  	{ 4360,  	9,  	30,  	60,  	90,  	{2840,4359,4357,2589}, {1,1,2,1}, 2 }, -- Rough Copper Bomb
    [3924] =  	{ 4361,  	9,  	50,  	80,  	110,  	{2840,2880}, {2,1} }, -- Copper Tube
    [3925] =  	{ 4362,  	9,  	50,  	80,  	110,  	{4361,4359,4399}, {1,1,1} }, -- Rough Boomstick
    [3926] =  	{ 4363,  	9,  	65,  	95,  	125,  	{4359,2840,2589}, {2,1,2} }, -- Copper Modulator
    [3398] =  	{ 3727,  	6,  	125,  	175,  	215,  	{3731,2692}, {1,1} }, -- Hot Lion Chops
    [3177] =  	{ 3389,  	4,  	130,  	155,  	195,  	{3355,3820,3372}, {1,1,1} }, -- Elixir of Defense
    [3841] =  	{ 4308,  	8,  	60,  	85,  	120,  	{2996,2320,2605}, {3,2,1} }, -- Green Linen Bracers
    [3842] =  	{ 4309,  	8,  	70,  	95,  	130,  	{2996,2321}, {4,2} }, -- Handstitched Linen Britches
    [3930] =  	{ 8068,  	9,  	75,  	85,  	95,  	{4364,2840}, {1,1}, 200 }, -- Crafted Heavy Shot
    [3870] =  	{ 4333,  	8,  	155,  	165,  	175,  	{4305,4340,2321}, {2,2,1} }, -- Dark Silk Shirt
    [3962] =  	{ 4390,  	9,  	175,  	175,  	215,  	{3575,4377,4306}, {1,1,1}, 2 }, -- Iron Grenade
    [3321] =  	{ 3471,  	2,  	35,  	75,  	115,  	{2840,774,3470}, {8,1,2} }, -- Copper Chain Vest
    [3868] =  	{ 4331,  	8,  	125,  	150,  	185,  	{2997,5500,2321,2324}, {4,1,4,2} }, -- Phoenix Gloves
    [3869] =  	{ 4332,  	8,  	135,  	145,  	155,  	{4305,4341,2321}, {1,1,1} }, -- Bright Yellow Shirt
    [3843] =  	{ 4310,  	8,  	85,  	110,  	145,  	{2997,2321}, {3,1} }, -- Heavy Woolen Gloves
    [3844] =  	{ 4311,  	8,  	100,  	125,  	160,  	{2997,2321,5498}, {3,2,2} }, -- Heavy Woolen Cloak
    [3400] =  	{ 3729,  	6,  	175,  	215,  	255,  	{3712,3713}, {1,1} }, -- Soothing Turtle Bisque
    [3839] =  	{ 4305,  	8,  	125,  	135,  	145,  	{4306}, {4} }, -- Bolt of Silk Cloth
    [3840] =  	{ 4307,  	8,  	35,  	60,  	95,  	{2996,2320}, {2,1} }, -- Heavy Linen Gloves
    [3845] =  	{ 4312,  	8,  	80,  	105,  	140,  	{2996,2318,2321}, {5,2,1} }, -- Soft-soled Linen Boots
    [9269] =  	{ 7506,  	9,  	125,  	150,  	175,  	{2841,4375,814,818,774}, {6,1,2,1,1} }, -- Gnomish Universal Remote
    [9271] =  	{ 6533,  	9,  	150,  	150,  	170,  	{2841,6530,4364}, {2,1,1}, 3 }, -- Aquadynamic Fish Attractor
    [3847] =  	{ 4313,  	8,  	95,  	120,  	155,  	{2997,2318,2321,2604}, {4,2,1,2} }, -- Red Woolen Boots
    [3848] =  	{ 4314,  	8,  	110,  	135,  	170,  	{2997,2321}, {3,2} }, -- Double-stitched Woolen Shoulders
    [3849] =  	{ 4315,  	8,  	120,  	145,  	180,  	{2997,2319,2321}, {6,2,2} }, -- Reinforced Woolen Shoulders
    [3850] =  	{ 4316,  	8,  	110,  	135,  	170,  	{2997,2321}, {5,4} }, -- Heavy Woolen Pants
    [3979] =  	{ 4407,  	9,  	180,  	200,  	220,  	{4371,1529,3864}, {1,1,1} }, -- Accurate Scope
    [3188] =  	{ 3391,  	4,  	150,  	175,  	215,  	{2449,3356,3372}, {1,1,1} }, -- Elixir of Ogre's Strength
    [3773] =  	{ 4256,  	3,  	175,  	195,  	215,  	{4236,4234,3824,2321}, {2,12,1,2} }, -- Guardian Armor
    [3453] =  	{ 3828,  	4,  	195,  	215,  	255,  	{3358,3818,3372}, {1,1,1} }, -- Elixir of Detect Lesser Invisibility
    [3871] =  	{ 4334,  	8,  	170,  	180,  	190,  	{4305,2324,2321}, {3,2,1} }, -- Formal White Shirt
    [3173] =  	{ 3385,  	4,  	1,  	145,  	185,  	{785,3820,3371}, {1,1,1} }, -- Lesser Mana Potion
    [3447] =  	{ 929,  	4,  	110,  	135,  	175,  	{2453,2450,3372}, {1,1,1} }, -- Healing Potion
    [3448] =  	{ 3823,  	4,  	165,  	185,  	225,  	{3818,3355,3372}, {1,1,1} }, -- Lesser Invisibility Potion
    [3174] =  	{ 3386,  	4,  	120,  	145,  	185,  	{1288,2453,3372}, {1,1,1} }, -- Elixir of Poison Resistance
    [3866] =  	{ 4330,  	8,  	110,  	135,  	170,  	{2997,2604,2321}, {3,2,1} }, -- Stylish Red Shirt
    [3914] =  	{ 4343,  	8,  	30,  	55,  	90,  	{2996,2320}, {2,1} }, -- Brown Linen Pants
    [3915] =  	{ 4344,  	8,  	1,  	35,  	60,  	{2996,2320}, {1,1} }, -- Brown Linen Shirt
    [3275] =  	{ 1251,  	1,  	1,  	30,  	60,  	{2589}, {1} }, -- Linen Bandage
    [3276] =  	{ 2581,  	1,  	40,  	50,  	100,  	{2589}, {2} }, -- Heavy Linen Bandage
    [3277] =  	{ 3530,  	1,  	80,  	80,  	150,  	{2592}, {1} }, -- Wool Bandage
    [3278] =  	{ 3531,  	1,  	115,  	115,  	185,  	{2592}, {2} }, -- Heavy Wool Bandage
    [3449] =  	{ 3824,  	4,  	165,  	190,  	230,  	{3818,3369,3372}, {4,4,1} }, -- Shadow Oil
    [3450] =  	{ 3825,  	4,  	175,  	195,  	235,  	{3355,3821,3372}, {1,1,1} }, -- Elixir of Fortitude
    [3175] =  	{ 3387,  	4,  	250,  	275,  	315,  	{8839,8845,8925}, {2,1,1} }, -- Limited Invulnerability Potion
    [3176] =  	{ 3388,  	4,  	125,  	150,  	190,  	{2453,2450,3372}, {2,2,1} }, -- Strong Troll's Blood Potion
    [3928] =  	{ 4401,  	9,  	75,  	105,  	135,  	{4363,4359,2840,774}, {1,1,1,2} }, -- Mechanical Squirrel
    [3929] =  	{ 4364,  	9,  	65,  	85,  	95,  	{2836}, {1} }, -- Coarse Blasting Powder
    [3451] =  	{ 3826,  	4,  	180,  	200,  	240,  	{3357,2453,3372}, {1,1,1} }, -- Mighty Troll's Blood Potion
    [3452] =  	{ 3827,  	4,  	160,  	180,  	220,  	{3820,3356,3372}, {1,1,1} }, -- Mana Potion
    [3172] =  	{ 3384,  	4,  	110,  	135,  	175,  	{785,3355,3371}, {3,1,1} }, -- Minor Magic Resistance Potion
    [3399] =  	{ 3728,  	6,  	150,  	190,  	230,  	{3731,3713}, {2,1} }, -- Tasty Lion Steak
    [2737] =  	{ 2844,  	2,  	30,  	55,  	95,  	{2840,2880,2589}, {6,1,2} }, -- Copper Mace
    [2738] =  	{ 2845,  	2,  	35,  	60,  	100,  	{2840,2880,2589}, {6,1,2} }, -- Copper Axe
    [2739] =  	{ 2847,  	2,  	40,  	65,  	105,  	{2840,2880,2589}, {6,1,2} }, -- Copper Shortsword
    [2740] =  	{ 2848,  	2,  	75,  	140,  	170,  	{2841,2880,2319}, {6,4,1} }, -- Bronze Mace
    [3506] =  	{ 3842,  	2,  	155,  	180,  	205,  	{3575,3486,2605}, {8,1,1} }, -- Green Iron Leggings
    [3292] =  	{ 3487,  	2,  	95,  	135,  	175,  	{2840,2880,818,2319}, {14,2,2,2} }, -- Heavy Copper Broadsword
    [3511] =  	{ 3845,  	2,  	195,  	220,  	245,  	{3859,3577,3486,1529}, {12,2,4,2} }, -- Golden Scale Cuirass
    [3972] =  	{ 4398,  	9,  	200,  	200,  	240,  	{10505,4234,159}, {2,2,1} }, -- Large Seaforium Charge
    [3756] =  	{ 4239,  	3,  	55,  	85,  	115,  	{2318,2320}, {3,2} }, -- Embossed Leather Gloves
    [3813] =  	{ 4245,  	8,  	150,  	170,  	200,  	{4305,4234,2321}, {3,2,3} }, -- Small Silk Pack
    [3293] =  	{ 3488,  	2,  	35,  	75,  	115,  	{2840,2880,774,3470,2318}, {12,2,2,2,2} }, -- Copper Battle Axe
    [3857] =  	{ 4322,  	8,  	165,  	185,  	215,  	{4305,2321,4337}, {3,2,2} }, -- Enchanter's Cowl
    [3858] =  	{ 4323,  	8,  	170,  	190,  	220,  	{4305,4291,3824}, {4,1,1} }, -- Shadow Hood
    [3334] =  	{ 3484,  	2,  	145,  	175,  	205,  	{3575,1705,3478,2605}, {4,2,2,1} }, -- Green Iron Boots
    [3308] =  	{ 3577,  	7,  	155,  	170,  	185,  	{2776}, {1} }, -- Smelt Gold
    [3864] =  	{ 4329,  	8,  	200,  	220,  	250,  	{4339,4234,3864,7071,4291}, {4,4,1,1,1} }, -- Star Belt
    [3865] =  	{ 4339,  	8,  	175,  	180,  	185,  	{4338}, {5} }, -- Bolt of Mageweave
    [3965] =  	{ 4392,  	9,  	185,  	185,  	225,  	{4387,4382,4389,4234}, {1,1,1,4} }, -- Advanced Target Dummy
    [3966] =  	{ 4393,  	9,  	185,  	205,  	225,  	{4234,3864}, {6,2} }, -- Craftsman's Monocle
    [3859] =  	{ 4324,  	8,  	150,  	170,  	200,  	{4305,6260}, {5,4} }, -- Azure Silk Vest
    [3860] =  	{ 4325,  	8,  	175,  	195,  	225,  	{4305,4291,4337}, {4,1,2} }, -- Boots of the Enchanter
    [3861] =  	{ 4326,  	8,  	185,  	205,  	235,  	{4305,3827,4291}, {4,1,1} }, -- Long Silken Cloak
    [3947] =  	{ 8069,  	9,  	125,  	125,  	145,  	{4377,2841}, {1,1}, 200 }, -- Crafted Solid Shot
    [3949] =  	{ 4379,  	9,  	130,  	155,  	180,  	{4371,4375,4400,2842}, {2,2,1,3} }, -- Silver-plated Shotgun
    [3937] =  	{ 4370,  	9,  	105,  	105,  	155,  	{2840,4364,4404}, {3,4,1}, 2 }, -- Large Copper Bomb
    [3952] =  	{ 4381,  	9,  	140,  	165,  	190,  	{4371,4375,2319,1206}, {1,2,2,1} }, -- Minor Recombobulator
    [3953] =  	{ 4382,  	9,  	145,  	145,  	195,  	{2841,2319,2592}, {2,1,1} }, -- Bronze Framework
    [3954] =  	{ 4383,  	9,  	145,  	170,  	195,  	{4371,4375,4400,1705}, {3,3,1,2} }, -- Moonsight Rifle
    [2741] =  	{ 2849,  	2,  	85,  	145,  	175,  	{2841,2880,2319}, {7,4,1} }, -- Bronze Axe
    [3950] =  	{ 4380,  	9,  	140,  	140,  	190,  	{4377,2841,4404}, {2,3,1}, 2 }, -- Big Bronze Bomb
    [3323] =  	{ 3472,  	2,  	40,  	80,  	120,  	{2840,3470}, {8,2} }, -- Runed Copper Gauntlets
    [3170] =  	{ 3382,  	4,  	15,  	60,  	100,  	{2447,2449,3371}, {1,2,1} }, -- Weak Troll's Blood Potion
    [3171] =  	{ 3383,  	4,  	90,  	120,  	160,  	{785,2450,3371}, {1,2,1} }, -- Elixir of Wisdom
    [3971] =  	{ 4397,  	9,  	200,  	220,  	240,  	{4389,1529,1705,3864,7191}, {4,2,2,2,1} }, -- Gnomish Cloaking Device
    [3330] =  	{ 3481,  	2,  	125,  	155,  	185,  	{2841,2842,3478}, {8,2,2} }, -- Silvered Bronze Shoulders
    [3331] =  	{ 3482,  	2,  	130,  	160,  	190,  	{2841,2842,3478}, {6,1,2} }, -- Silvered Bronze Boots
    [3304] =  	{ 3576,  	7,  	1,  	50,  	75,  	{2771}, {1} }, -- Smelt Tin
    [3967] =  	{ 4394,  	9,  	190,  	190,  	230,  	{3575,4377,4404}, {3,3,1}, 2 }, -- Big Iron Bomb
    [3968] =  	{ 4395,  	9,  	195,  	215,  	235,  	{4377,3575,4389}, {3,2,1} }, -- Goblin Land Mine
    [3969] =  	{ 4396,  	9,  	200,  	220,  	240,  	{4382,4387,4389,3864,7191}, {1,4,4,2,1} }, -- Mechanical Dragonling
    [3370] =  	{ 3662,  	6,  	80,  	120,  	160,  	{2924,2678}, {1,1} }, -- Crocolisk Steak
    [3862] =  	{ 4327,  	8,  	200,  	220,  	250,  	{4339,4291,3829,4337}, {3,2,1,2} }, -- Icy Cloak
    [3863] =  	{ 4328,  	8,  	180,  	200,  	230,  	{4305,4337,7071}, {4,2,1} }, -- Spider Belt
    [3307] =  	{ 3575,  	7,  	125,  	130,  	140,  	{2772}, {1} }, -- Smelt Iron
    [3507] =  	{ 3843,  	2,  	170,  	195,  	220,  	{3575,3577,3486}, {10,2,1} }, -- Golden Scale Leggings
    [3508] =  	{ 3844,  	2,  	180,  	205,  	230,  	{3575,3486,1529,1206,4255}, {20,4,2,2,1} }, -- Green Iron Hauberk
    [3420] =  	{ 3775,  	13,  	1,  	125,  	175,  	{2930,3371}, {1,1} }, -- Crippling Poison
    [3421] =  	{ 3776,  	13,  	1,  	275,  	325,  	{8923,8925}, {3,1} }, -- Crippling Poison II
    [3855] =  	{ 4320,  	8,  	125,  	150,  	185,  	{4305,2319,3182,5500}, {2,4,4,2} }, -- Spidersilk Boots
    [3569] =  	{ 3859,  	7,  	165,  	165,  	165,  	{3575,3857}, {1,1} }, -- Smelt Steel
    [3872] =  	{ 4335,  	8,  	185,  	195,  	205,  	{4305,4342,4291}, {4,1,1} }, -- Rich Purple Silk Shirt
    [3873] =  	{ 4336,  	8,  	200,  	210,  	220,  	{4305,2325,4291}, {5,1,1} }, -- Black Swashbuckler's Shirt
    [3963] =  	{ 4391,  	9,  	175,  	175,  	215,  	{4387,4382,4389,4234}, {2,1,2,4} }, -- Compact Harvest Reaper Kit
    [3764] =  	{ 4247,  	3,  	145,  	170,  	195,  	{2319,2321}, {14,4} }, -- Hillman's Leather Gloves
    [3513] =  	{ 3846,  	2,  	185,  	210,  	235,  	{3859,3864,1705,3486}, {8,1,1,2} }, -- Polished Steel Boots
    [3772] =  	{ 4255,  	3,  	155,  	175,  	195,  	{4234,2605,2321}, {9,2,4} }, -- Green Leather Armor
    [3931] =  	{ 4365,  	9,  	68,  	90,  	105,  	{4364,2589}, {3,1} }, -- Coarse Dynamite
    [3780] =  	{ 4265,  	3,  	150,  	170,  	190,  	{4234,2321}, {5,1} }, -- Heavy Armor Kit
    [3497] =  	{ 3854,  	2,  	200,  	225,  	250,  	{3859,3466,3486,1529,3829,4234}, {8,2,2,2,1,4} }, -- Frost Tiger Blade
    [3498] =  	{ 3855,  	2,  	185,  	210,  	235,  	{3575,3466,3486,3577,4234}, {14,2,2,4,2} }, -- Massive Iron Axe
    [3500] =  	{ 3856,  	2,  	200,  	225,  	250,  	{3859,3466,3486,3864,3824,4234}, {10,2,3,2,1,3} }, -- Shadow Crescent Axe
    [3765] =  	{ 4248,  	3,  	120,  	155,  	180,  	{2312,4233,2321,4340}, {1,1,1,1} }, -- Dark Leather Gloves
    [3766] =  	{ 4249,  	3,  	125,  	150,  	175,  	{4246,4233,2321,4340}, {1,1,2,1} }, -- Dark Leather Belt
    [3767] =  	{ 4250,  	3,  	120,  	145,  	170,  	{2319,3383,2321}, {8,1,2} }, -- Hillman's Belt
    [3768] =  	{ 4251,  	3,  	130,  	155,  	180,  	{4233,2319,2321}, {1,4,1} }, -- Hillman's Shoulders
    [3944] =  	{ 4376,  	9,  	125,  	125,  	175,  	{4375,4402}, {1,1} }, -- Flame Deflector
    [3945] =  	{ 4377,  	9,  	125,  	125,  	145,  	{2838}, {1} }, -- Heavy Blasting Powder
    [3946] =  	{ 4378,  	9,  	125,  	125,  	145,  	{4377,2592}, {2,1} }, -- Heavy Dynamite
    [3319] =  	{ 3469,  	2,  	20,  	60,  	100,  	{2840}, {8} }, -- Copper Chain Boots
    [3320] =  	{ 3470,  	2,  	25,  	45,  	85,  	{2835}, {2} }, -- Rough Grinding Stone
    [3759] =  	{ 4242,  	3,  	75,  	105,  	135,  	{4231,2318,2320}, {1,6,2} }, -- Embossed Leather Pants
    [3760] =  	{ 3719,  	3,  	150,  	170,  	190,  	{4234,2321}, {5,2} }, -- Hillman's Cloak
    [3324] =  	{ 3473,  	2,  	45,  	85,  	125,  	{2840,2321,3470}, {8,2,3} }, -- Runed Copper Pants
    [3939] =  	{ 4372,  	9,  	120,  	145,  	170,  	{4371,4359,4400,1206}, {2,2,1,3} }, -- Lovingly Crafted Boomstick
    [3940] =  	{ 4373,  	9,  	120,  	145,  	170,  	{2319,1210}, {4,2} }, -- Shadow Goggles
    [3761] =  	{ 4243,  	3,  	85,  	115,  	145,  	{4231,2318,2320}, {3,6,4} }, -- Fine Leather Tunic
    [3230] =  	{ 2457,  	4,  	50,  	80,  	120,  	{2452,765,3371}, {1,1,1} }, -- Elixir of Minor Agility
    [3371] =  	{ 3220,  	6,  	60,  	100,  	140,  	{3173,3172,3174}, {1,1,1}, 2 }, -- Blood Sausage
    [3372] =  	{ 3663,  	6,  	90,  	130,  	170,  	{1468,2692}, {2,1} }, -- Murloc Fin Soup
    [3373] =  	{ 3664,  	6,  	120,  	160,  	200,  	{3667,2692}, {1,1} }, -- Crocolisk Gumbo
    [3377] =  	{ 3666,  	6,  	110,  	150,  	190,  	{2251,2692}, {2,1} }, -- Gooey Spider Cake
    [3753] =  	{ 4237,  	3,  	25,  	55,  	85,  	{2318,2320}, {6,1} }, -- Handstitched Leather Belt
    [3755] =  	{ 4238,  	8,  	45,  	70,  	105,  	{2996,2320}, {3,3} }, -- Linen Bag
    [3762] =  	{ 4244,  	3,  	100,  	125,  	150,  	{4243,4231,2320}, {1,2,2} }, -- Hillman's Leather Vest
    [3763] =  	{ 4246,  	3,  	80,  	110,  	140,  	{2318,2320}, {6,2} }, -- Fine Leather Belt
    [3115] =  	{ 3239,  	2,  	1,  	15,  	55,  	{2835,2589}, {1,1} }, -- Rough Weightstone
    [3854] =  	{ 4319,  	8,  	145,  	165,  	195,  	{4305,4234,6260,2321}, {3,2,2,2} }, -- Azure Silk Gloves
    [3769] =  	{ 4252,  	3,  	140,  	165,  	190,  	{2319,3390,4340,2321}, {12,1,1,2} }, -- Dark Leather Shoulders
    [3770] =  	{ 4253,  	3,  	135,  	160,  	185,  	{2319,4233,3389,3182,2321}, {4,2,2,2,2} }, -- Toughened Leather Gloves
    [3771] =  	{ 4254,  	3,  	150,  	170,  	190,  	{4234,5637,2321}, {6,2,1} }, -- Barbaric Gloves
    [3116] =  	{ 3240,  	2,  	65,  	65,  	80,  	{2836,2592}, {1,1} }, -- Coarse Weightstone
    [3117] =  	{ 3241,  	2,  	125,  	125,  	140,  	{2838,2592}, {1,1} }, -- Heavy Weightstone
    [2742] =  	{ 2850,  	2,  	95,  	150,  	180,  	{2841,2880,2319}, {5,4,2} }, -- Bronze Shortsword
    [3941] =  	{ 4374,  	9,  	120,  	120,  	170,  	{4364,2841,4404,2592}, {4,2,1,1} }, -- Small Bronze Bomb
    [3942] =  	{ 4375,  	9,  	125,  	125,  	175,  	{2841,2592}, {2,1} }, -- Whirring Bronze Gizmo
    [3325] =  	{ 3474,  	2,  	60,  	100,  	140,  	{2840,818,774}, {8,1,1} }, -- Gemmed Copper Gauntlets
    [3326] =  	{ 3478,  	2,  	75,  	75,  	100,  	{2836}, {2} }, -- Coarse Grinding Stone
    [3328] =  	{ 3480,  	2,  	110,  	140,  	170,  	{2841,1210,3478}, {5,1,1} }, -- Rough Bronze Shoulders
    [4096] =  	{ 4455,  	3,  	165,  	185,  	205,  	{4461,4234,2321}, {6,4,2} }, -- Raptor Hide Harness
    [4097] =  	{ 4456,  	3,  	165,  	185,  	205,  	{4461,4234,2321}, {4,4,2} }, -- Raptor Hide Belt
    [3851] =  	{ 4317,  	8,  	125,  	150,  	185,  	{2997,5500,2321}, {6,1,3} }, -- Phoenix Pants
    [3501] =  	{ 3835,  	2,  	165,  	190,  	215,  	{3575,2605}, {6,1} }, -- Green Iron Bracers
    [3977] =  	{ 4405,  	9,  	60,  	90,  	120,  	{4361,774,4359}, {1,1,1} }, -- Crude Scope
    [3978] =  	{ 4406,  	9,  	110,  	135,  	160,  	{4371,1206}, {1,1} }, -- Standard Scope
    [4508] =  	{ 4596,  	4,  	50,  	80,  	120,  	{3164,2447,3371}, {1,1,1} }, -- Discolored Healing Potion
    [3918] =  	{ 4357,  	9,  	1,  	20,  	40,  	{2835}, {1} }, -- Rough Blasting Powder
    [3919] =  	{ 4358,  	9,  	1,  	30,  	60,  	{4357,2589}, {2,1}, 2 }, -- Rough Dynamite
    [3920] =  	{ 8067,  	9,  	1,  	30,  	60,  	{4357,2840}, {1,1}, 200 }, -- Crafted Light Shot
    [3852] =  	{ 4318,  	8,  	130,  	150,  	180,  	{2997,2321,3383}, {4,3,1} }, -- Gloves of Meditation
    [5244] =  	{ 5081,  	3,  	40,  	70,  	100,  	{5082,2318,2320}, {3,4,1} }, -- Kodo Hide Bag
    [4094] =  	{ 4457,  	6,  	175,  	215,  	255,  	{3404,2692}, {1,1} }, -- Barbecued Buzzard Wing
    [14293] =  	{ 11287,  	10,  	10,  	75,  	115,  	{4470,10938}, {1,1} }, -- Lesser Magic Wand
    [4942] =  	{ 4623,  	4,  	215,  	230,  	270,  	{3858,3821,3372}, {1,1,1} }, -- Lesser Stoneshield Potion
    [6500] =  	{ 5527,  	6,  	125,  	165,  	205,  	{5504,2692}, {1,1} }, -- Goblin Deviled Clams
    [6501] =  	{ 5526,  	6,  	90,  	130,  	170,  	{5503,1179,2678}, {1,1,1} }, -- Clam Chowder
    [7149] =  	{ 5963,  	3,  	170,  	190,  	210,  	{4234,2321,1206}, {10,2,1} }, -- Barbaric Leggings
    [6499] =  	{ 5525,  	6,  	50,  	90,  	130,  	{5503,159}, {1,1} }, -- Boiled Clams
    [7255] =  	{ 6051,  	4,  	100,  	130,  	170,  	{2453,2452,3371}, {1,1,1} }, -- Holy Protection Potion
    [7256] =  	{ 6048,  	4,  	135,  	160,  	200,  	{3369,3356,3372}, {1,1,1} }, -- Shadow Protection Potion
    [7257] =  	{ 6049,  	4,  	165,  	210,  	250,  	{4402,6371,3372}, {1,1,1} }, -- Fire Protection Potion
    [7258] =  	{ 6050,  	4,  	190,  	205,  	245,  	{3819,3821,3372}, {1,1,1} }, -- Frost Protection Potion
    [6458] =  	{ 5507,  	9,  	135,  	160,  	185,  	{4371,4375,4363,1206}, {2,2,1,1} }, -- Ornate Spyglass
    [6695] =  	{ 5765,  	8,  	185,  	205,  	235,  	{4305,2325,2321}, {5,1,4} }, -- Black Silk Pack
    [6686] =  	{ 5762,  	8,  	70,  	95,  	130,  	{2996,2321,2604}, {4,1,1} }, -- Red Linen Bag
    [5763] =  	{ 5237,  	13,  	1,  	150,  	200,  	{2928,2930,3371}, {1,1,1} }, -- Mind-numbing Poison
    [6688] =  	{ 5763,  	8,  	115,  	140,  	175,  	{2997,2604,2321}, {4,1,1} }, -- Red Woolen Bag
    [6517] =  	{ 5540,  	2,  	115,  	140,  	170,  	{2841,3466,5498,3478}, {6,1,2,2} }, -- Pearl-handled Dagger
    [6619] =  	{ 5632,  	4,  	125,  	150,  	190,  	{5636,3356,3372}, {1,1,1} }, -- Cowardly Flight Potion
    [7151] =  	{ 5964,  	3,  	175,  	195,  	215,  	{4234,4236,2321}, {8,1,2} }, -- Barbaric Shoulders
    [6518] =  	{ 5541,  	2,  	140,  	170,  	200,  	{2841,3466,5500,3478,2319}, {10,1,1,2,2} }, -- Iridescent Hammer
    [7153] =  	{ 5965,  	3,  	125,  	205,  	225,  	{4234,4305,4291}, {14,2,2} }, -- Guardian Cloak
    [7818] =  	{ 6338,  	2,  	100,  	105,  	110,  	{2842,3470}, {1,2} }, -- Silver Rod
    [7179] =  	{ 5996,  	4,  	90,  	120,  	160,  	{3820,6370,3371}, {1,2,1} }, -- Elixir of Water Breathing
    [7181] =  	{ 1710,  	4,  	155,  	175,  	215,  	{3357,3356,3372}, {1,1,1} }, -- Greater Healing Potion
    [6661] =  	{ 5739,  	3,  	190,  	210,  	230,  	{4234,2321,7071}, {14,2,1} }, -- Barbaric Harness
    [6521] =  	{ 5542,  	8,  	90,  	115,  	150,  	{2997,2321,5498}, {3,2,1} }, -- Pearl-clasped Cloak
    [7183] =  	{ 5997,  	4,  	1,  	55,  	95,  	{765,3371}, {2,1} }, -- Elixir of Minor Defense
    [6703] =  	{ 5781,  	3,  	95,  	125,  	155,  	{5784,4231,2318,2321}, {12,1,8,1} }, -- Murloc Scale Breastplate
    [6704] =  	{ 5782,  	3,  	170,  	190,  	210,  	{5785,4236,4234,2321}, {12,1,10,3} }, -- Thick Murloc Armor
    [6705] =  	{ 5783,  	3,  	190,  	210,  	230,  	{5785,4236,4234,4291}, {16,1,14,1} }, -- Murloc Scale Bracers
    [7259] =  	{ 6052,  	4,  	190,  	210,  	250,  	{3357,3820,3372}, {1,1,1} }, -- Nature Protection Potion
    [6510] =  	{ 5530,  	13,  	1,  	170,  	220,  	{3818}, {1}, 3 }, -- Blinding Powder
    [7223] =  	{ 6040,  	2,  	185,  	210,  	235,  	{3859,3486}, {5,2} }, -- Golden Scale Bracers
    [7224] =  	{ 6041,  	2,  	190,  	215,  	240,  	{3859,3486,4234}, {8,2,4} }, -- Steel Weapon Chain
    [7126] =  	{ 5957,  	3,  	1,  	40,  	70,  	{2318,2320}, {3,1} }, -- Handstitched Leather Vest
    [7147] =  	{ 5962,  	3,  	160,  	180,  	200,  	{4234,4305,2321}, {12,2,2} }, -- Guardian Pants
    [6690] =  	{ 5766,  	8,  	135,  	155,  	185,  	{4305,2321,3182}, {2,2,2} }, -- Lesser Wizard's Robe
    [6692] =  	{ 5770,  	8,  	150,  	170,  	200,  	{4305,2321,3182}, {4,2,2} }, -- Robes of Arcana
    [6693] =  	{ 5764,  	8,  	175,  	195,  	225,  	{4305,4234,2321,2605}, {4,3,3,1} }, -- Green Silk Pack
    [7133] =  	{ 5958,  	3,  	105,  	130,  	155,  	{2319,2997,2321}, {8,1,1} }, -- Fine Leather Pants
    [7135] =  	{ 5961,  	3,  	115,  	140,  	165,  	{2319,4340,2321}, {12,1,1} }, -- Dark Leather Pants
    [6702] =  	{ 5780,  	3,  	90,  	120,  	150,  	{5784,2318,2321}, {8,6,1} }, -- Murloc Scale Belt
    [7430] =  	{ 6219,  	9,  	1,  	70,  	90,  	{2840}, {6} }, -- Arclight Spanner
    [7624] =  	{ 6241,  	8,  	30,  	55,  	90,  	{2996,2320,2324}, {3,1,1} }, -- White Linen Robe
    [7629] =  	{ 6239,  	8,  	55,  	80,  	115,  	{2996,2320,2604}, {3,1,1} }, -- Red Linen Vest
    [7793] =  	{ nil,  	10,  	100,  	130,  	170,  	{10939}, {3} }, -- Enchant 2H Weapon - Lesser Intellect
    [7421] =  	{ 6218,  	10,  	1,  	5,  	10,  	{6217,10940,10938}, {1,1,1} }, -- Runed Copper Rod
    [7776] =  	{ nil,  	10,  	80,  	115,  	155,  	{10939,10938}, {1,1} }, -- Enchant Chest - Lesser Mana
    [7745] =  	{ nil,  	10,  	100,  	130,  	170,  	{10940,10978}, {4,1} }, -- Enchant 2H Weapon - Minor Impact
    [7934] =  	{ 6452,  	1,  	80,  	80,  	150,  	{1475}, {1}, 3 }, -- Anti-Venom
    [7935] =  	{ 6453,  	1,  	130,  	130,  	200,  	{1288}, {1}, 3 }, -- Strong Anti-Venom
    [7643] =  	{ 6264,  	8,  	115,  	140,  	175,  	{2997,2321,2604}, {5,3,3} }, -- Greater Adept's Robe
    [7786] =  	{ nil,  	10,  	90,  	120,  	160,  	{10940,10939}, {4,2} }, -- Enchant Weapon - Minor Beastslayer
    [7953] =  	{ 6466,  	3,  	90,  	120,  	150,  	{6470,4231,2321}, {8,1,1} }, -- Deviate Scale Cloak
    [7788] =  	{ nil,  	10,  	90,  	120,  	160,  	{10940,10939,10978}, {2,1,1} }, -- Enchant Weapon - Minor Striking
    [7633] =  	{ 6242,  	8,  	70,  	95,  	130,  	{2996,2320,6260}, {4,2,2} }, -- Blue Linen Robe
    [3775] =  	{ 4258,  	3,  	170,  	190,  	210,  	{4236,4234,2321,7071}, {2,4,1,1} }, -- Guardian Belt
    [8776] =  	{ 7026,  	8,  	15,  	50,  	85,  	{2996,2320}, {1,1} }, -- Linen Belt
    [8681] =  	{ 6947,  	13,  	1,  	125,  	175,  	{2928,3371}, {1,1} }, -- Instant Poison
    [7408] =  	{ 6214,  	2,  	65,  	105,  	145,  	{2840,2880,2318}, {12,2,2} }, -- Heavy Copper Maul
    [7845] =  	{ 6373,  	4,  	140,  	165,  	205,  	{6371,3356,3372}, {2,1,1} }, -- Elixir of Firepower
    [6415] =  	{ 5476,  	6,  	50,  	90,  	130,  	{5468,2678}, {1,1}, 2 }, -- Fillet of Frenzy
    [7639] =  	{ 6263,  	8,  	100,  	125,  	160,  	{2997,2321,6260}, {4,2,2} }, -- Blue Overalls
    [7928] =  	{ 6450,  	1,  	150,  	150,  	210,  	{4306}, {1} }, -- Silk Bandage
    [6618] =  	{ 5633,  	4,  	175,  	195,  	235,  	{5637,3356,3372}, {1,1,1} }, -- Great Rage Potion
    [7859] =  	{ nil,  	10,  	120,  	145,  	185,  	{10998}, {2} }, -- Enchant Bracer - Lesser Spirit
    [7623] =  	{ 6238,  	8,  	30,  	55,  	90,  	{2996,2320}, {3,1} }, -- Brown Linen Robe
    [7795] =  	{ 6339,  	10,  	100,  	130,  	170,  	{6338,10940,10939,1210}, {1,6,3,1} }, -- Runed Silver Rod
    [7954] =  	{ 6467,  	3,  	105,  	130,  	155,  	{6471,6470,2321}, {2,6,2} }, -- Deviate Scale Gloves
    [7955] =  	{ 6468,  	3,  	115,  	140,  	165,  	{6471,6470,2321}, {10,10,2} }, -- Deviate Scale Belt
    [7817] =  	{ 6350,  	2,  	95,  	125,  	155,  	{2841,3470}, {6,6} }, -- Rough Bronze Boots
    [7636] =  	{ 6243,  	8,  	90,  	115,  	150,  	{2997,2321,2605}, {3,2,1} }, -- Green Woolen Robe
    [3376] =  	{ 3665,  	6,  	130,  	170,  	210,  	{3685,2692}, {1,1} }, -- Curiously Tasty Omelet
    [7841] =  	{ 6372,  	4,  	1,  	130,  	170,  	{2452,6370,3371}, {1,1,1} }, -- Swim Speed Potion
    [7863] =  	{ nil,  	10,  	125,  	150,  	190,  	{10940}, {8} }, -- Enchant Boots - Minor Stamina
    [6624] =  	{ 5634,  	4,  	150,  	175,  	215,  	{6370,3820,3372}, {2,1,1} }, -- Free Action Potion
    [7748] =  	{ nil,  	10,  	60,  	105,  	145,  	{10940,10938}, {2,2} }, -- Enchant Chest - Lesser Health
    [7420] =  	{ nil,  	10,  	15,  	70,  	110,  	{10940}, {1} }, -- Enchant Chest - Minor Health
    [7867] =  	{ nil,  	10,  	125,  	150,  	190,  	{10940,10998}, {6,2} }, -- Enchant Boots - Minor Agility
    [7221] =  	{ 6042,  	2,  	150,  	180,  	210,  	{3575,3478}, {6,4} }, -- Iron Shield Spike
    [8762] =  	{ 7050,  	8,  	160,  	170,  	180,  	{4305,2321}, {3,2} }, -- Silk Headband
    [6413] =  	{ 5473,  	6,  	20,  	60,  	100,  	{5466}, {1} }, -- Scorpid Surprise
    [6414] =  	{ 5474,  	6,  	35,  	75,  	115,  	{5467,2678}, {1,1}, 2 }, -- Roasted Kodo Meat
    [6418] =  	{ 5479,  	6,  	100,  	140,  	180,  	{5470,2692}, {1,1}, 2 }, -- Crispy Lizard Tail
    [6419] =  	{ 5480,  	6,  	110,  	150,  	190,  	{5471,2678}, {1,4}, 2 }, -- Lean Venison
    [7222] =  	{ 6043,  	2,  	165,  	190,  	215,  	{3575,3478,1705}, {4,2,1} }, -- Iron Counterweight
    [7428] =  	{ nil,  	10,  	1,  	80,  	120,  	{10938,10940}, {1,1} }, -- Enchant Bracer - Minor Deflect
    [7771] =  	{ nil,  	10,  	90,  	110,  	150,  	{10940,10939}, {3,1} }, -- Enchant Cloak - Minor Protection
    [7861] =  	{ nil,  	10,  	125,  	150,  	190,  	{6371,10998}, {1,1} }, -- Enchant Cloak - Lesser Fire Resistance
    [7892] =  	{ 6384,  	8,  	120,  	145,  	180,  	{2997,6260,4340,2321}, {4,2,1,1} }, -- Stylish Blue Shirt
    [7893] =  	{ 6385,  	8,  	120,  	145,  	180,  	{2997,2605,4340,2321}, {4,2,1,1} }, -- Stylish Green Shirt
    [7857] =  	{ nil,  	10,  	120,  	145,  	185,  	{10940,10998}, {4,1} }, -- Enchant Chest - Health
    [7630] =  	{ 6240,  	8,  	55,  	80,  	115,  	{2996,2320,6260}, {3,1,1} }, -- Blue Linen Vest
    [7156] =  	{ 5966,  	3,  	190,  	210,  	230,  	{4234,4236,4291}, {4,1,1} }, -- Guardian Gloves
    [7213] =  	{ 6038,  	6,  	175,  	215,  	255,  	{4655,2692}, {1,1} }, -- Giant Clam Scorcho
    [6417] =  	{ 5478,  	6,  	90,  	130,  	170,  	{5051}, {1}, 2 }, -- Dig Rat Stew
    [8607] =  	{ 6890,  	6,  	40,  	80,  	120,  	{3173}, {1} }, -- Smoked Bear Meat
    [8795] =  	{ 7060,  	8,  	190,  	210,  	240,  	{4305,7072,6260,4291}, {6,2,2,2} }, -- Azure Shoulders
    [8804] =  	{ 7064,  	8,  	210,  	225,  	255,  	{4305,7068,6371,4304,2604,4291}, {6,2,2,2,4,2} }, -- Crimson Silk Gloves
    [8483] =  	{ 6795,  	8,  	160,  	170,  	180,  	{4305,2324,4291}, {3,2,1} }, -- White Swashbuckler's Shirt
    [8797] =  	{ 7061,  	8,  	195,  	215,  	245,  	{4305,7067,4234,7071,4291}, {5,4,4,1,2} }, -- Earthen Silk Belt
    [8789] =  	{ 7056,  	8,  	180,  	200,  	230,  	{4305,2604,6371,4291}, {5,2,2,1} }, -- Crimson Silk Cloak
    [8243] =  	{ 4852,  	9,  	185,  	185,  	225,  	{4611,4377,4306}, {1,1,1} }, -- Flash Bomb
    [3757] =  	{ 4240,  	8,  	80,  	105,  	140,  	{2997,2321}, {3,1} }, -- Woolen Bag
    [9062] =  	{ 7279,  	3,  	30,  	60,  	90,  	{2318,2320}, {3,4} }, -- Small Leather Ammo Pouch
    [9064] =  	{ 7280,  	3,  	35,  	65,  	95,  	{2318,2320}, {5,5} }, -- Rugged Leather Pants
    [7454] =  	{ nil,  	10,  	45,  	95,  	135,  	{10940,10938}, {1,2} }, -- Enchant Cloak - Minor Resistance
    [7457] =  	{ nil,  	10,  	50,  	100,  	140,  	{10940}, {3} }, -- Enchant Bracer - Minor Stamina
    [7828] =  	{ 4594,  	6,  	175,  	190,  	230,  	{6362}, {1} }, -- Rockscale Cod
    [8895] =  	{ 7189,  	9,  	130,  	245,  	265,  	{10026,10559,4234,9061,10560}, {1,2,4,2,1} }, -- Goblin Rocket Boots
    [8339] =  	{ 6714,  	9,  	100,  	115,  	130,  	{4364,2592}, {4,1} }, -- EZ-Thro Dynamite
    [8691] =  	{ 6950,  	13,  	1,  	205,  	255,  	{8924,3372}, {1,1} }, -- Instant Poison III
    [6416] =  	{ 5477,  	6,  	50,  	90,  	130,  	{5469,4536}, {1,1}, 2 }, -- Strider Stew
    [8768] =  	{ 7071,  	2,  	150,  	150,  	155,  	{3575}, {1}, 2 }, -- Iron Buckle
    [7753] =  	{ 4592,  	6,  	50,  	90,  	130,  	{6289}, {1} }, -- Longjaw Mud Snapper
    [7754] =  	{ 6316,  	6,  	50,  	90,  	130,  	{6317,2678}, {1,1} }, -- Loch Frenzy Delight
    [7755] =  	{ 4593,  	6,  	100,  	140,  	180,  	{6308}, {1} }, -- Bristle Whisker Catfish
    [9065] =  	{ 7281,  	3,  	70,  	100,  	130,  	{2318,2320}, {6,4} }, -- Light Leather Bracers
    [8694] =  	{ 6951,  	13,  	1,  	215,  	265,  	{2928,2930,3372}, {4,4,1} }, -- Mind-numbing Poison II
    [8770] =  	{ 7054,  	8,  	190,  	210,  	240,  	{4339,7067,7070,7068,7069,4291}, {2,2,2,2,2,2} }, -- Robe of Power
    [7752] =  	{ 787,  	6,  	1,  	45,  	85,  	{6303}, {1} }, -- Slitherskin Mackerel
    [8791] =  	{ 7058,  	8,  	185,  	205,  	225,  	{4305,2604,2321}, {4,2,2} }, -- Crimson Silk Vest
    [8793] =  	{ 7059,  	8,  	190,  	210,  	240,  	{4305,6371,2604,4291}, {5,2,2,2} }, -- Crimson Silk Shoulders
    [7779] =  	{ nil,  	10,  	80,  	115,  	155,  	{10940,10939}, {2,1} }, -- Enchant Bracer - Minor Agility
    [7766] =  	{ nil,  	10,  	60,  	105,  	145,  	{10938}, {2} }, -- Enchant Bracer - Minor Spirit
    [8489] =  	{ 6796,  	8,  	175,  	185,  	195,  	{4305,2604,4291}, {3,2,1} }, -- Red Swashbuckler's Shirt
    [8465] =  	{ 6786,  	8,  	40,  	65,  	100,  	{2996,2320,6260,2324}, {2,1,1,1} }, -- Simple Dress
    [8238] =  	{ 6657,  	6,  	85,  	125,  	165,  	{6522,2678}, {1,1} }, -- Savory Deviate Delight
    [8240] =  	{ 6662,  	4,  	90,  	120,  	160,  	{6522,2449,3371}, {1,1,1} }, -- Elixir of Giant Growth
    [8758] =  	{ 7046,  	8,  	140,  	160,  	190,  	{4305,6260,2321}, {4,2,3} }, -- Azure Silk Pants
    [7426] =  	{ nil,  	10,  	40,  	90,  	130,  	{10940,10938}, {2,1} }, -- Enchant Chest - Minor Absorption
    [7418] =  	{ nil,  	10,  	1,  	70,  	110,  	{10940}, {1} }, -- Enchant Bracer - Minor Health
    [6412] =  	{ 5472,  	6,  	10,  	50,  	90,  	{5465}, {1} }, -- Kaldorei Spider Kabob
    [8467] =  	{ 6787,  	8,  	110,  	135,  	170,  	{2997,2324,2321}, {3,4,1} }, -- White Woolen Dress
    [8760] =  	{ 7048,  	8,  	145,  	155,  	165,  	{4305,6260,2321}, {2,2,1} }, -- Azure Silk Hood
    [7751] =  	{ 6290,  	6,  	1,  	45,  	85,  	{6291}, {1} }, -- Brilliant Smallfish
    [8772] =  	{ 7055,  	8,  	175,  	195,  	225,  	{4305,7071,2604,4291}, {4,1,2,1} }, -- Crimson Silk Belt
    [8774] =  	{ 7057,  	8,  	180,  	200,  	230,  	{4305,4291}, {5,2} }, -- Green Silken Shoulders
    [8784] =  	{ 7065,  	8,  	165,  	185,  	215,  	{4305,2605,4291}, {5,2,1} }, -- Green Silk Armor
    [8786] =  	{ 7053,  	8,  	175,  	195,  	225,  	{4305,6260,2321}, {3,2,2} }, -- Azure Silk Cloak
    [8604] =  	{ 6888,  	6,  	1,  	45,  	85,  	{6889,2678}, {1,1} }, -- Herb Baked Egg
    [8782] =  	{ 7049,  	8,  	150,  	170,  	200,  	{4305,4234,929,2321}, {3,2,4,1} }, -- Truefaith Gloves
    [3758] =  	{ 4241,  	8,  	95,  	120,  	155,  	{2997,2605,2321}, {4,1,1} }, -- Green Woolen Bag
    [7782] =  	{ nil,  	10,  	80,  	115,  	155,  	{10940}, {5} }, -- Enchant Bracer - Minor Strength
    [7827] =  	{ 5095,  	6,  	50,  	90,  	130,  	{6361}, {1} }, -- Rainbow Fin Albacore
    [7836] =  	{ 6370,  	4,  	80,  	80,  	100,  	{6358,3371}, {2,1} }, -- Blackmouth Oil
    [7837] =  	{ 6371,  	4,  	130,  	150,  	170,  	{6359,3371}, {2,1} }, -- Fire Oil
    [8766] =  	{ 7052,  	8,  	175,  	195,  	225,  	{4305,7070,6260,2321,7071}, {4,1,2,2,1} }, -- Azure Silk Belt
    [8322] =  	{ 6709,  	3,  	90,  	115,  	145,  	{2318,4231,2320,5498}, {6,1,4,1} }, -- Moonglow Vest
    [8687] =  	{ 6949,  	13,  	1,  	165,  	215,  	{2928,3372}, {3,1} }, -- Instant Poison II
    [8334] =  	{ 6712,  	9,  	100,  	115,  	130,  	{2841,4359,2880}, {1,2,1} }, -- Practice Lock
    [8764] =  	{ 7051,  	8,  	170,  	190,  	220,  	{4305,7067,2321}, {3,1,2} }, -- Earthen Vest
    [9196] =  	{ 7374,  	3,  	175,  	195,  	215,  	{4234,3824,2321}, {10,1,2} }, -- Dusky Leather Armor
    [9197] =  	{ 7375,  	3,  	175,  	195,  	215,  	{7392,4234,2321}, {4,10,2} }, -- Green Whelp Armor
    [9926] =  	{ 7918,  	2,  	1,  	225,  	245,  	{3860,4234}, {8,6} }, -- Heavy Mithril Shoulder
    [9928] =  	{ 7919,  	2,  	1,  	225,  	245,  	{3860,4338}, {6,4} }, -- Heavy Mithril Gauntlet
    [9942] =  	{ 7925,  	2,  	220,  	240,  	260,  	{3860,4234,4338}, {8,6,4} }, -- Mithril Scale Gloves
    [9931] =  	{ 7920,  	2,  	210,  	230,  	250,  	{3860}, {12} }, -- Mithril Scale Pants
    [9201] =  	{ 7378,  	3,  	185,  	205,  	225,  	{4234,2325,4291}, {16,1,2} }, -- Dusky Bracers
    [9202] =  	{ 7386,  	3,  	190,  	210,  	230,  	{7392,4234,4291}, {6,8,2} }, -- Green Whelp Bracers
    [8366] =  	{ 6730,  	2,  	70,  	110,  	150,  	{2840,774,3470}, {12,2,2} }, -- Ironforge Chain
    [9811] =  	{ 7913,  	2,  	160,  	185,  	210,  	{3575,5635,1210,3486}, {8,4,2,2} }, -- Barbaric Iron Shoulders
    [27725] =  	{ 22252,  	8,  	300,  	315,  	345,  	{14048,14342,13468,14227}, {6,2,1,4} }, -- Satchel of Cenarius
    [9959] =  	{ 7930,  	2,  	1,  	250,  	270,  	{3860}, {16} }, -- Heavy Mithril Breastplate
    [9997] =  	{ 7943,  	2,  	225,  	250,  	275,  	{3860,6037,7966,4304}, {14,4,1,2} }, -- Wicked Mithril Blade
    [9957] =  	{ 7929,  	2,  	230,  	250,  	270,  	{3860,7067}, {12,1} }, -- Orcish War Leggings
    [9206] =  	{ 7387,  	3,  	195,  	215,  	235,  	{4234,4305,2325,7071}, {10,2,2,1} }, -- Dusky Belt
    [9813] =  	{ 7914,  	2,  	160,  	185,  	210,  	{3575,3486}, {20,4} }, -- Barbaric Iron Breastplate
    [9814] =  	{ 7915,  	2,  	175,  	200,  	225,  	{3575,5637,5635}, {10,2,2} }, -- Barbaric Iron Helm
    [8780] =  	{ 7047,  	8,  	145,  	165,  	195,  	{4305,4234,6048,2321}, {3,2,2,2} }, -- Hands of Darkness
    [9194] =  	{ 7372,  	3,  	150,  	170,  	190,  	{4234,2321}, {8,2} }, -- Heavy Leather Ammo Pouch
    [9979] =  	{ 7936,  	2,  	245,  	265,  	285,  	{3860,6037,4304,7966,7909}, {14,2,4,1,1} }, -- Ornate Mithril Boots
    [9980] =  	{ 7937,  	2,  	245,  	265,  	285,  	{3860,6037,7971,7966}, {16,2,1,1} }, -- Ornate Mithril Helm
    [9939] =  	{ 7967,  	2,  	215,  	235,  	255,  	{3860,6037,7966}, {4,2,4} }, -- Mithril Shield Spike
    [8778] =  	{ 7027,  	8,  	140,  	160,  	190,  	{4305,2319,6048,2321}, {3,2,1,2} }, -- Boots of Darkness
    [7929] =  	{ 6451,  	1,  	180,  	180,  	240,  	{4306}, {2} }, -- Heavy Silk Bandage
    [9950] =  	{ 7927,  	2,  	220,  	240,  	260,  	{3860,4338,6037,7966}, {10,6,1,1} }, -- Ornate Mithril Gloves
    [9145] =  	{ 7348,  	3,  	125,  	150,  	175,  	{2319,5116,2321}, {8,4,2} }, -- Fletcher's Gloves
    [9964] =  	{ 7969,  	2,  	235,  	255,  	275,  	{3860,7966}, {4,3} }, -- Mithril Spurs
    [8367] =  	{ 6731,  	2,  	100,  	140,  	180,  	{2840,818,3470}, {16,2,3} }, -- Ironforge Breastplate
    [9818] =  	{ 7916,  	2,  	180,  	205,  	230,  	{3575,5637,818,3486}, {12,4,4,2} }, -- Barbaric Iron Boots
    [9820] =  	{ 7917,  	2,  	185,  	210,  	235,  	{3575,3486,5637}, {14,3,2} }, -- Barbaric Iron Gloves
    [9058] =  	{ 7276,  	3,  	1,  	40,  	70,  	{2318,2320}, {2,1} }, -- Handstitched Leather Cloak
    [9059] =  	{ 7277,  	3,  	1,  	40,  	70,  	{2318,2320}, {2,3} }, -- Handstitched Leather Bracers
    [9060] =  	{ 7278,  	3,  	30,  	60,  	90,  	{2318,2320}, {4,2} }, -- Light Leather Quiver
    [7443] =  	{ nil,  	10,  	20,  	80,  	120,  	{10938}, {1} }, -- Enchant Chest - Minor Mana
    [9935] =  	{ 7922,  	2,  	1,  	235,  	255,  	{3859,7966}, {14,1} }, -- Steel Plate Helm
    [9937] =  	{ 7924,  	2,  	215,  	235,  	255,  	{3860,3864}, {8,2} }, -- Mithril Scale Bracers
    [9983] =  	{ 7955,  	2,  	30,  	70,  	110,  	{2840,2880,3470,2318}, {10,2,1,1} }, -- Copper Claymore
    [9198] =  	{ 7377,  	3,  	180,  	200,  	220,  	{4234,7067,7070,2321}, {6,2,2,2} }, -- Frost Leather Cloak
    [9068] =  	{ 7282,  	3,  	95,  	125,  	155,  	{2318,4231,2321}, {10,1,1} }, -- Light Leather Pants
    [9995] =  	{ 7942,  	2,  	220,  	245,  	270,  	{3860,7909,7966,4304}, {16,2,1,4} }, -- Blue Glittering Axe
    [9146] =  	{ 7349,  	3,  	135,  	160,  	185,  	{2319,3356,2321}, {8,4,2} }, -- Herbalist's Gloves
    [9966] =  	{ 7932,  	2,  	235,  	255,  	275,  	{3860,4304,3864}, {14,4,4} }, -- Mithril Scale Shoulders
    [9968] =  	{ 7933,  	2,  	1,  	255,  	275,  	{3860,4304}, {14,4} }, -- Heavy Mithril Boots
    [9970] =  	{ 7934,  	2,  	245,  	255,  	275,  	{3860,7909}, {14,1} }, -- Heavy Mithril Helm
    [9972] =  	{ 7935,  	2,  	240,  	260,  	280,  	{3860,6037,7077,7966}, {16,6,1,1} }, -- Ornate Mithril Breastplate
    [8802] =  	{ 7063,  	8,  	205,  	220,  	250,  	{4305,7068,3827,2604,4291}, {8,4,2,4,1} }, -- Crimson Silk Robe
    [9193] =  	{ 7371,  	3,  	150,  	170,  	190,  	{4234,2321}, {8,2} }, -- Heavy Quiver
    [9974] =  	{ 7939,  	2,  	1,  	265,  	285,  	{3860,6037,7910,7971,7966}, {12,24,4,4,2} }, -- Truesilver Breastplate
    [9993] =  	{ 7941,  	2,  	210,  	235,  	260,  	{3860,3864,7966,4234}, {12,2,1,4} }, -- Heavy Mithril Axe
    [9954] =  	{ 7938,  	2,  	1,  	245,  	265,  	{3860,6037,7909,3864,5966,7966}, {10,8,3,3,1,2} }, -- Truesilver Gauntlets
    [9933] =  	{ 7921,  	2,  	210,  	230,  	250,  	{3860,1705}, {10,2} }, -- Heavy Mithril Pants
    [8799] =  	{ 7062,  	8,  	195,  	215,  	235,  	{4305,2604,4291}, {4,2,2} }, -- Crimson Silk Pantaloons
    [9961] =  	{ 7931,  	2,  	1,  	250,  	270,  	{3860,4338}, {10,6} }, -- Mithril Coif
    [10550] =  	{ 8195,  	3,  	230,  	250,  	270,  	{4304,4291}, {12,4} }, -- Nightscape Cloak
    [10007] =  	{ 7961,  	2,  	225,  	270,  	295,  	{3860,7081,6037,3823,7909,7966,4304}, {28,6,8,2,6,4,2} }, -- Phantom Blade
    [10009] =  	{ 7946,  	2,  	245,  	270,  	295,  	{3860,7075,7966,4304}, {18,2,1,4} }, -- Runed Mithril Hammer
    [10011] =  	{ 7959,  	2,  	1,  	275,  	300,  	{3860,7972,6037,7966,4304}, {28,10,10,6,6} }, -- Blight
    [10499] =  	{ 8175,  	3,  	205,  	225,  	245,  	{4304,4291}, {7,2} }, -- Nightscape Tunic
    [9207] =  	{ 7390,  	3,  	200,  	220,  	240,  	{4234,7428,3824,4291}, {8,2,1,2} }, -- Dusky Boots
    [9208] =  	{ 7391,  	3,  	200,  	220,  	240,  	{4234,2459,4337,4291}, {10,2,2,1} }, -- Swift Boots
    [10621] =  	{ 8345,  	3,  	225,  	245,  	265,  	{4304,8368,8146,8343,8172}, {18,2,8,4,2} }, -- Wolfshead Helm
    [9195] =  	{ 7373,  	3,  	165,  	185,  	205,  	{4234,2325,2321}, {10,1,2} }, -- Dusky Leather Leggings
    [10560] =  	{ 8202,  	3,  	240,  	260,  	280,  	{4304,8152,8343}, {10,6,2} }, -- Big Voodoo Pants
    [10841] =  	{ 8545,  	1,  	240,  	240,  	300,  	{4338}, {2} }, -- Heavy Mageweave Bandage
    [10516] =  	{ 8192,  	3,  	210,  	230,  	250,  	{4304,4338,4291}, {8,6,3} }, -- Nightscape Shoulders
    [9147] =  	{ 7352,  	3,  	135,  	160,  	185,  	{2319,7067,2321}, {6,1,2} }, -- Earthen Leather Shoulders
    [10572] =  	{ 8212,  	3,  	250,  	270,  	290,  	{4304,8153,8172}, {16,6,2} }, -- Wild Leather Leggings
    [10840] =  	{ 8544,  	1,  	210,  	210,  	270,  	{4338}, {1} }, -- Mageweave Bandage
    [8368] =  	{ 6733,  	2,  	140,  	170,  	200,  	{2841,1210,3478}, {8,3,4} }, -- Ironforge Gauntlets
    [10013] =  	{ 7947,  	2,  	255,  	280,  	305,  	{3860,6037,7910,7966,4304}, {12,6,2,1,2} }, -- Ebon Shiv
    [10487] =  	{ 8173,  	3,  	200,  	220,  	240,  	{4304,4291}, {5,1} }, -- Thick Armor Kit
    [10518] =  	{ 8198,  	3,  	210,  	230,  	250,  	{4304,8167,8343}, {8,12,1} }, -- Turtle Scale Bracers
    [10574] =  	{ 8215,  	3,  	250,  	270,  	290,  	{4304,8153,8172}, {16,6,2} }, -- Wild Leather Cloak
    [12584] =  	{ 10558,  	9,  	150,  	150,  	190,  	{3577}, {1}, 3 }, -- Gold Power Core
    [10507] =  	{ 8176,  	3,  	205,  	225,  	245,  	{4304,4291}, {5,2} }, -- Nightscape Headband
    [10570] =  	{ 8208,  	3,  	250,  	270,  	290,  	{4304,8154,8343}, {10,20,2} }, -- Tough Scorpid Helm
    [9918] =  	{ 7964,  	2,  	200,  	200,  	210,  	{7912}, {1} }, -- Solid Sharpening Stone
    [9921] =  	{ 7965,  	2,  	200,  	200,  	210,  	{7912,4306}, {1,1} }, -- Solid Weightstone
    [9273] =  	{ 7148,  	9,  	165,  	160,  	200,  	{3575,4375,814,4306,1210,7191}, {6,2,2,2,2,1} }, -- Goblin Jumper Cables
    [9916] =  	{ 7963,  	2,  	200,  	225,  	250,  	{3859,3486}, {16,3} }, -- Steel Breastplate
    [9952] =  	{ 7928,  	2,  	225,  	245,  	265,  	{3860,6037,4304}, {12,1,6} }, -- Ornate Mithril Shoulders
    [9920] =  	{ 7966,  	2,  	200,  	200,  	210,  	{7912}, {4} }, -- Solid Grinding Stone
    [9513] =  	{ 7676,  	6,  	60,  	100,  	140,  	{2452,159}, {1,1} }, -- Thistle Tea
    [12585] =  	{ 10505,  	9,  	175,  	175,  	195,  	{7912}, {2} }, -- Solid Blasting Powder
    [9985] =  	{ 7956,  	2,  	125,  	155,  	185,  	{2841,3466,2319}, {8,1,1} }, -- Bronze Warhammer
    [9986] =  	{ 7957,  	2,  	130,  	160,  	190,  	{2841,3466,2319}, {12,2,2} }, -- Bronze Greatsword
    [9987] =  	{ 7958,  	2,  	135,  	165,  	195,  	{2841,3466,2319}, {14,1,2} }, -- Bronze Battle Axe
    [9148] =  	{ 7358,  	3,  	140,  	165,  	190,  	{2319,5373,2321}, {10,2,2} }, -- Pilferer's Gloves
    [9149] =  	{ 7359,  	3,  	145,  	170,  	195,  	{2319,7067,2997,2321}, {12,2,2,2} }, -- Heavy Earthen Gloves
    [9072] =  	{ 7284,  	3,  	120,  	145,  	170,  	{7287,2319,2321}, {6,4,1} }, -- Red Whelp Gloves
    [9074] =  	{ 7285,  	3,  	120,  	145,  	170,  	{2457,2319,2321}, {1,6,1} }, -- Nimble Leather Gloves
    [10098] =  	{ 6037,  	7,  	230,  	230,  	230,  	{7911}, {1} }, -- Smelt Truesilver
    [10509] =  	{ 8187,  	3,  	205,  	225,  	245,  	{4304,8167,8343}, {6,8,1} }, -- Turtle Scale Gloves
    [9945] =  	{ 7926,  	2,  	220,  	240,  	260,  	{3860,6037,7966,7909}, {12,1,1,1} }, -- Ornate Mithril Pants
    [10619] =  	{ 8347,  	3,  	1,  	245,  	265,  	{4304,8165,8343,8172}, {24,12,4,2} }, -- Dragonscale Gauntlets
    [10544] =  	{ 8211,  	3,  	225,  	245,  	265,  	{4304,8153,8172}, {12,2,1} }, -- Wild Leather Vest
    [10482] =  	{ 8172,  	3,  	200,  	200,  	200,  	{8169,8150}, {1,1} }, -- Cured Thick Hide
    [10533] =  	{ 8205,  	3,  	220,  	240,  	260,  	{4304,8154,4291}, {10,4,2} }, -- Tough Scorpid Bracers
    [11448] =  	{ 6149,  	4,  	205,  	220,  	260,  	{3358,3821,3372}, {1,1,1} }, -- Greater Mana Potion
    [11449] =  	{ 8949,  	4,  	1,  	205,  	245,  	{3820,3821,3372}, {1,1,1} }, -- Elixir of Agility
    [12621] =  	{ 10513,  	9,  	245,  	245,  	285,  	{3860,10505}, {2,2}, 200 }, -- Mithril Gyro-Shot
    [12599] =  	{ 10561,  	9,  	215,  	215,  	255,  	{3860}, {3} }, -- Mithril Casing
    [10529] =  	{ 8210,  	3,  	220,  	240,  	260,  	{4304,8153,8172}, {10,1,1} }, -- Wild Leather Shoulders
    [12596] =  	{ 10512,  	9,  	210,  	210,  	250,  	{3860,10505}, {1,1}, 200 }, -- Hi-Impact Mithril Slugs
    [12597] =  	{ 10546,  	9,  	210,  	230,  	250,  	{10559,7909,4304}, {1,2,2} }, -- Deadly Scope
    [11447] =  	{ 8827,  	4,  	1,  	190,  	230,  	{6370,3357,3372}, {1,1,1} }, -- Elixir of Waterwalking
    [12619] =  	{ 10562,  	9,  	235,  	235,  	275,  	{10561,10560,10505}, {2,1,2}, 4 }, -- Hi-Explosive Bomb
    [11342] =  	{ 8927,  	13,  	1,  	285,  	335,  	{8924,8925}, {3,1} }, -- Instant Poison V
    [11341] =  	{ 8926,  	13,  	1,  	245,  	295,  	{8924,8925}, {2,1} }, -- Instant Poison IV
    [9070] =  	{ 7283,  	3,  	100,  	125,  	150,  	{7286,2319,2321}, {12,4,1} }, -- Black Whelp Cloak
    [12048] =  	{ 9998,  	8,  	205,  	220,  	250,  	{4339,4291}, {2,3} }, -- Black Mageweave Vest
    [10564] =  	{ 8207,  	3,  	240,  	260,  	280,  	{4304,8154,8343}, {12,16,2} }, -- Tough Scorpid Shoulders
    [11459] =  	{ 9149,  	4,  	225,  	240,  	280,  	{3575,9262,8831,4625}, {4,1,4,4} }, -- Philosophers' Stone
    [11452] =  	{ 9030,  	4,  	215,  	225,  	265,  	{7067,3821,8925}, {1,1,1} }, -- Restorative Potion
    [10632] =  	{ 8348,  	3,  	250,  	270,  	290,  	{4304,7077,7075,8172,8343}, {40,8,4,2,4} }, -- Helm of Fire
    [10630] =  	{ 8346,  	3,  	230,  	250,  	270,  	{4304,7079,7075,8172,8343}, {20,8,2,1,4} }, -- Gauntlets of the Sea
    [10490] =  	{ 8174,  	3,  	200,  	220,  	240,  	{4234,4236,4291}, {12,2,2} }, -- Comfortable Leather Hat
    [10525] =  	{ 8203,  	3,  	220,  	240,  	260,  	{4304,8154,4291}, {12,12,4} }, -- Tough Scorpid Breastplate
    [10650] =  	{ 8367,  	3,  	1,  	275,  	295,  	{4304,8165,8343,8172}, {40,30,4,4} }, -- Dragonscale Breastplate
    [11643] =  	{ 9366,  	2,  	205,  	225,  	245,  	{3859,3577,3486,3864}, {10,4,4,1} }, -- Golden Scale Gauntlets
    [11343] =  	{ 8928,  	13,  	1,  	325,  	375,  	{8924,8925}, {4,1} }, -- Instant Poison VI
    [11466] =  	{ 9088,  	4,  	240,  	255,  	295,  	{8836,8839,8925}, {1,1,1} }, -- Gift of Arthas
    [10511] =  	{ 8189,  	3,  	1,  	230,  	250,  	{4304,8167,8343}, {6,12,1} }, -- Turtle Scale Breastplate
    [12622] =  	{ 10504,  	9,  	245,  	265,  	285,  	{4304,1529,7909,10286,8153}, {8,3,3,2,2} }, -- Green Lens
    [10556] =  	{ 8185,  	3,  	1,  	255,  	275,  	{4304,8167,8343}, {14,28,1} }, -- Turtle Scale Leggings
    [10558] =  	{ 8197,  	3,  	235,  	255,  	275,  	{4304,8343}, {16,2} }, -- Nightscape Boots
    [10562] =  	{ 8216,  	3,  	240,  	260,  	280,  	{4304,8152,8343}, {14,4,2} }, -- Big Voodoo Cloak
    [10531] =  	{ 8201,  	3,  	220,  	240,  	260,  	{4304,8151,8343}, {8,6,1} }, -- Big Voodoo Mask
    [10546] =  	{ 8214,  	3,  	225,  	245,  	265,  	{4304,8153,8172}, {10,2,1} }, -- Wild Leather Helmet
    [10554] =  	{ 8209,  	3,  	235,  	255,  	275,  	{4304,8154,4291}, {12,12,6} }, -- Tough Scorpid Boots
    [10568] =  	{ 8206,  	3,  	245,  	265,  	285,  	{4304,8154,8343}, {14,8,2} }, -- Tough Scorpid Leggings
    [10542] =  	{ 8204,  	3,  	225,  	245,  	265,  	{4304,8154,4291}, {6,8,2} }, -- Tough Scorpid Gloves
    [10005] =  	{ 7944,  	2,  	240,  	265,  	290,  	{3860,7909,1705,1206,7966,4338}, {14,1,2,2,1,2} }, -- Dazzling Mithril Rapier
    [12620] =  	{ 10548,  	9,  	240,  	260,  	280,  	{10559,7910,6037}, {1,1,2} }, -- Sniper Scope
    [10548] =  	{ 8193,  	3,  	230,  	250,  	270,  	{4304,4291}, {14,4} }, -- Nightscape Pants
    [10520] =  	{ 8200,  	3,  	215,  	235,  	255,  	{4304,8151,8343}, {10,4,1} }, -- Big Voodoo Robe
    [10552] =  	{ 8191,  	3,  	1,  	250,  	270,  	{4304,8167,8343}, {14,24,1} }, -- Turtle Scale Helm
    [12056] =  	{ 10007,  	8,  	215,  	230,  	260,  	{4339,2604,8343}, {3,2,1} }, -- Red Mageweave Vest
    [12903] =  	{ 10721,  	9,  	215,  	235,  	255,  	{7387,3860,6037,10560,7909}, {1,4,2,1,2} }, -- Gnomish Harm Prevention Belt
    [12085] =  	{ 10034,  	8,  	240,  	245,  	255,  	{4339,8343}, {4,2} }, -- Tuxedo Shirt
    [12087] =  	{ 10038,  	8,  	245,  	260,  	290,  	{4339,7079,8343}, {5,6,3} }, -- Stormcloth Shoulders
    [12089] =  	{ 10035,  	8,  	245,  	250,  	260,  	{4339,8343}, {4,3} }, -- Tuxedo Pants
    [12090] =  	{ 10039,  	8,  	250,  	265,  	295,  	{4339,7079,8343,4304}, {6,6,3,2} }, -- Stormcloth Boots
    [12720] =  	{ 10580,  	9,  	1,  	235,  	255,  	{10561,10505,10558,3860}, {1,2,1,2} }, -- Goblin "Boom" Box
    [12068] =  	{ 10020,  	8,  	225,  	240,  	270,  	{4339,7079,8343}, {5,3,2} }, -- Stormcloth Vest
    [12069] =  	{ 10042,  	8,  	225,  	240,  	270,  	{4339,7077,8343}, {5,2,2} }, -- Cindercloth Robe
    [12064] =  	{ 10052,  	8,  	220,  	225,  	235,  	{4339,6261,8343}, {2,2,1} }, -- Orange Martial Shirt
    [12065] =  	{ 10050,  	8,  	225,  	240,  	270,  	{4339,4291}, {4,2} }, -- Mageweave Bag
    [12259] =  	{ 10423,  	2,  	155,  	180,  	205,  	{2841,2842,3478}, {12,4,2} }, -- Silvered Bronze Leggings
    [12091] =  	{ 10040,  	8,  	250,  	255,  	265,  	{4339,8343}, {5,3} }, -- White Wedding Dress
    [12586] =  	{ 10507,  	9,  	175,  	175,  	195,  	{10505,4306}, {1,1}, 2 }, -- Solid Dynamite
    [12591] =  	{ 10560,  	9,  	200,  	200,  	240,  	{3860,4338,10505}, {1,1,1} }, -- Unstable Trigger
    [12081] =  	{ 10030,  	8,  	240,  	255,  	285,  	{4339,4589,8343}, {3,6,2} }, -- Admiral's Hat
    [12088] =  	{ 10044,  	8,  	245,  	260,  	290,  	{4339,7077,8343,4304}, {5,1,3,2} }, -- Cindercloth Boots
    [12070] =  	{ 10021,  	8,  	225,  	240,  	270,  	{4339,8153,10286,8343}, {6,6,2,2} }, -- Dreamweave Vest
    [11458] =  	{ 9144,  	4,  	225,  	240,  	280,  	{8153,8831,8925}, {1,1,1} }, -- Wildvine Potion
    [11450] =  	{ 8951,  	4,  	195,  	215,  	255,  	{3355,3821,3372}, {1,1,1} }, -- Elixir of Greater Defense
    [11451] =  	{ 8956,  	4,  	205,  	220,  	260,  	{4625,3821,8925}, {1,1,1} }, -- Oil of Immolation
    [10001] =  	{ 7945,  	2,  	1,  	255,  	280,  	{3860,7971,1210,7966,4304}, {16,1,4,1,2} }, -- Big Black Mace
    [10003] =  	{ 7954,  	2,  	1,  	260,  	285,  	{3860,7075,6037,3864,1529,7966,4304}, {24,4,6,5,5,4,4} }, -- The Shatterer
    [11453] =  	{ 9036,  	4,  	210,  	225,  	265,  	{3358,8831,8925}, {1,1,1} }, -- Magic Resistance Potion
    [11454] =  	{ 9060,  	2,  	200,  	225,  	250,  	{3860,3577,6037}, {5,1,1} }, -- Inlaid Mithril Cylinder
    [11456] =  	{ 9061,  	4,  	210,  	225,  	265,  	{4625,9260,3372}, {1,1,1} }, -- Goblin Rocket Fuel
    [11457] =  	{ 3928,  	4,  	215,  	230,  	270,  	{8838,3358,8925}, {1,1,1} }, -- Superior Healing Potion
    [12758] =  	{ 10588,  	9,  	245,  	265,  	285,  	{10543,9061,3860,10560}, {1,4,4,1} }, -- Goblin Rocket Helmet
    [11479] =  	{ 3577,  	4,  	225,  	240,  	280,  	{3575}, {1} }, -- Transmute: Iron to Gold
    [12055] =  	{ 10004,  	8,  	215,  	230,  	260,  	{4339,10285,8343}, {3,2,1} }, -- Shadoweave Robe
    [17181] =  	{ 12810,  	10,  	250,  	250,  	260,  	{8170,16202}, {1,1} }, -- Enchanted Leather
    [12066] =  	{ 10018,  	8,  	225,  	240,  	270,  	{4339,2604,8343}, {3,2,2} }, -- Red Mageweave Gloves
    [12082] =  	{ 10031,  	8,  	240,  	255,  	285,  	{4339,10285,8343,4304}, {6,6,3,2} }, -- Shadoweave Boots
    [12900] =  	{ 10719,  	9,  	1,  	205,  	245,  	{10559,10560,3860}, {1,1,4} }, -- Mobile Alarm
    [12760] =  	{ 10646,  	9,  	205,  	205,  	245,  	{4338,10505,10560}, {1,3,1} }, -- Goblin Sapper Charge
    [12083] =  	{ 10032,  	8,  	240,  	255,  	285,  	{4339,7079,8343}, {4,4,2} }, -- Stormcloth Headband
    [12084] =  	{ 10033,  	8,  	240,  	255,  	285,  	{4339,2604,8343}, {4,2,2} }, -- Red Mageweave Headband
    [12603] =  	{ 10514,  	9,  	215,  	215,  	255,  	{10561,10560,10505}, {1,1,1}, 3 }, -- Mithril Frag Bomb
    [12718] =  	{ 10543,  	9,  	205,  	225,  	245,  	{3860,3864,7068}, {8,1,4} }, -- Goblin Construction Helmet
    [12062] =  	{ 10010,  	8,  	220,  	235,  	265,  	{4339,7079,8343}, {4,2,2} }, -- Stormcloth Pants
    [11472] =  	{ 9206,  	4,  	245,  	260,  	300,  	{8838,8846,8925}, {1,1,1} }, -- Elixir of Giants
    [10647] =  	{ 8349,  	3,  	250,  	270,  	290,  	{4304,8168,7971,8172,8343}, {40,40,2,4,4} }, -- Feathered Breastplate
    [12050] =  	{ 10001,  	8,  	210,  	225,  	255,  	{4339,8343}, {3,1} }, -- Black Mageweave Robe
    [11465] =  	{ 9179,  	4,  	1,  	250,  	290,  	{8839,3358,8925}, {1,1,1} }, -- Elixir of Greater Intellect
    [11473] =  	{ 9210,  	4,  	245,  	260,  	300,  	{8845,4342,8925}, {2,1,1} }, -- Ghost Dye
    [12086] =  	{ 10025,  	8,  	245,  	260,  	290,  	{4339,10285,8343}, {2,8,2} }, -- Shadoweave Mask
    [12589] =  	{ 10559,  	9,  	195,  	195,  	235,  	{3860}, {3} }, -- Mithril Tube
    [12590] =  	{ 10498,  	9,  	175,  	175,  	215,  	{3859}, {4} }, -- Gyromatic Micro-Adjustor
    [12614] =  	{ 10510,  	9,  	220,  	240,  	260,  	{10559,10560,4400,3860,3864}, {2,1,1,6,2} }, -- Mithril Heavy-bore Rifle
    [10566] =  	{ 8213,  	3,  	245,  	265,  	285,  	{4304,8153,8172}, {14,4,2} }, -- Wild Leather Boots
    [12587] =  	{ 10499,  	9,  	175,  	195,  	215,  	{4234,3864}, {6,2} }, -- Bright-Eye Goggles
    [11358] =  	{ 8985,  	13,  	1,  	295,  	345,  	{5173,8925}, {5,1} }, -- Deadly Poison IV
    [11460] =  	{ 9154,  	4,  	1,  	245,  	285,  	{8836,8925}, {1,1} }, -- Elixir of Detect Undead
    [11461] =  	{ 9155,  	4,  	1,  	250,  	290,  	{8839,3821,8925}, {1,1,1} }, -- Arcane Elixir
    [11478] =  	{ 9233,  	4,  	1,  	265,  	305,  	{8846,8925}, {2,1} }, -- Elixir of Detect Demon
    [11464] =  	{ 9172,  	4,  	235,  	250,  	290,  	{8845,8838,8925}, {1,1,1} }, -- Invisibility Potion
    [11357] =  	{ 8984,  	13,  	1,  	255,  	305,  	{5173,8925}, {3,1} }, -- Deadly Poison III
    [12063] =  	{ 10011,  	8,  	220,  	235,  	265,  	{4339,7079,8343}, {3,2,2} }, -- Stormcloth Gloves
    [11480] =  	{ 6037,  	4,  	225,  	240,  	280,  	{3860}, {1} }, -- Transmute: Mithril to Truesilver
    [12045] =  	{ 10046,  	8,  	20,  	50,  	85,  	{2996,2318,2320}, {2,1,1} }, -- Simple Linen Boots
    [12046] =  	{ 10047,  	8,  	75,  	100,  	135,  	{2996,2321}, {4,1} }, -- Simple Kilt
    [12047] =  	{ 10048,  	8,  	120,  	145,  	180,  	{2997,2604,2321}, {5,3,1} }, -- Colorful Kilt
    [12049] =  	{ 9999,  	8,  	205,  	220,  	250,  	{4339,4291}, {2,3} }, -- Black Mageweave Leggings
    [12052] =  	{ 10002,  	8,  	210,  	225,  	255,  	{4339,10285,8343}, {3,2,1} }, -- Shadoweave Pants
    [12902] =  	{ 10720,  	9,  	210,  	230,  	250,  	{10559,10285,4337,10505,3860}, {1,2,4,2,4} }, -- Gnomish Net-o-Matic Projector
    [15628] =  	{ 11825,  	9,  	205,  	205,  	205,  	{4394,7077,7191,3860}, {1,1,1,6} }, -- Pet Bombling
    [12905] =  	{ 10724,  	9,  	225,  	245,  	265,  	{10026,10559,4234,10505,4389}, {1,2,4,8,4} }, -- Gnomish Rocket Boots
    [12615] =  	{ 10502,  	9,  	225,  	245,  	265,  	{4304,7910}, {4,2} }, -- Spellpower Goggles Xtreme
    [13631] =  	{ nil,  	10,  	155,  	175,  	215,  	{11134,11083}, {1,1} }, -- Enchant Shield - Lesser Stamina
    [13695] =  	{ nil,  	10,  	200,  	220,  	260,  	{11137,11139}, {4,1} }, -- Enchant 2H Weapon - Impact
    [13522] =  	{ nil,  	10,  	135,  	160,  	200,  	{11082,6048}, {1,1} }, -- Enchant Cloak - Lesser Shadow Resistance
    [12092] =  	{ 10041,  	8,  	250,  	265,  	295,  	{4339,8153,10286,8343,6037,1529}, {8,4,2,3,1,1} }, -- Dreamweave Circlet
    [12899] =  	{ 10716,  	9,  	205,  	225,  	245,  	{10559,10560,3860,8151,1529}, {1,1,4,4,2} }, -- Gnomish Shrink Ray
    [12075] =  	{ 10054,  	8,  	230,  	235,  	245,  	{4339,4342,8343}, {2,2,2} }, -- Lavender Mageweave Shirt
    [13529] =  	{ nil,  	10,  	145,  	170,  	210,  	{11083,11084}, {3,1} }, -- Enchant 2H Weapon - Lesser Impact
    [13935] =  	{ nil,  	10,  	235,  	255,  	295,  	{11175}, {2} }, -- Enchant Boots - Agility
    [13887] =  	{ nil,  	10,  	225,  	245,  	285,  	{11174,11137}, {2,3} }, -- Enchant Gloves - Strength
    [13646] =  	{ nil,  	10,  	170,  	190,  	230,  	{11134,11083}, {1,2} }, -- Enchant Bracer - Lesser Deflection
    [13620] =  	{ nil,  	10,  	145,  	170,  	210,  	{11083,6370}, {1,3} }, -- Enchant Gloves - Fishing
    [13628] =  	{ 11130,  	10,  	150,  	175,  	215,  	{11128,5500,11082,11083}, {1,1,2,2} }, -- Runed Golden Rod
    [13622] =  	{ nil,  	10,  	150,  	175,  	215,  	{11082}, {2} }, -- Enchant Bracer - Lesser Intellect
    [13648] =  	{ nil,  	10,  	170,  	190,  	230,  	{11083}, {6} }, -- Enchant Bracer - Stamina
    [19072] =  	{ 15093,  	3,  	280,  	300,  	320,  	{8170,14047,14341}, {12,10,1} }, -- Runic Leather Belt
    [11467] =  	{ 9187,  	4,  	1,  	255,  	295,  	{8838,3821,8925}, {1,1,1} }, -- Elixir of Greater Agility
    [11468] =  	{ 9197,  	4,  	240,  	255,  	295,  	{8831,8925}, {3,1} }, -- Elixir of Dream Vision
    [12061] =  	{ 10056,  	8,  	215,  	220,  	230,  	{4339,6261,8343}, {1,1,1} }, -- Orange Mageweave Shirt
    [13890] =  	{ nil,  	10,  	225,  	245,  	285,  	{11177,7909,11174}, {1,1,1} }, -- Enchant Boots - Minor Speed
    [13905] =  	{ nil,  	10,  	230,  	250,  	290,  	{11175,11176}, {1,2} }, -- Enchant Shield - Greater Spirit
    [12754] =  	{ 10586,  	9,  	235,  	235,  	275,  	{10561,9061,10507,10560}, {1,1,6,1}, 2 }, -- The Big One
    [13501] =  	{ nil,  	10,  	130,  	155,  	195,  	{11083}, {2} }, -- Enchant Bracer - Lesser Stamina
    [12907] =  	{ 10726,  	9,  	235,  	255,  	275,  	{3860,6037,10558,7910,4338}, {10,4,1,2,4} }, -- Gnomish Mind Control Cap
    [13380] =  	{ nil,  	10,  	110,  	135,  	175,  	{10998,10940}, {1,6} }, -- Enchant 2H Weapon - Lesser Spirit
    [13503] =  	{ nil,  	10,  	140,  	165,  	205,  	{11083,11084}, {2,1} }, -- Enchant Weapon - Lesser Striking
    [12906] =  	{ 10725,  	9,  	230,  	250,  	270,  	{10561,6037,3860,9060,10558,1529}, {1,6,6,2,1,2} }, -- Gnomish Battle Chicken
    [12077] =  	{ 10053,  	8,  	235,  	240,  	250,  	{4339,2325,8343,2324}, {3,1,1,1} }, -- Simple Black Dress
    [12078] =  	{ 10029,  	8,  	235,  	250,  	280,  	{4339,2604,8343}, {4,2,3} }, -- Red Mageweave Shoulders
    [12080] =  	{ 10055,  	8,  	235,  	240,  	250,  	{4339,10290,8343}, {3,1,1} }, -- Pink Mageweave Shirt
    [12072] =  	{ 10024,  	8,  	230,  	245,  	275,  	{4339,8343}, {3,2} }, -- Black Mageweave Headband
    [12073] =  	{ 10026,  	8,  	230,  	245,  	275,  	{4339,8343,4304}, {3,2,2} }, -- Black Mageweave Boots
    [13939] =  	{ nil,  	10,  	240,  	260,  	300,  	{11176,11175}, {2,1} }, -- Enchant Bracer - Greater Strength
    [12079] =  	{ 10051,  	8,  	235,  	250,  	280,  	{4339,2604,8343}, {4,2,2} }, -- Red Mageweave Bag
    [12067] =  	{ 10019,  	8,  	225,  	240,  	270,  	{4339,8153,10286,8343}, {4,4,2,2} }, -- Dreamweave Gloves
    [10097] =  	{ 3860,  	7,  	175,  	175,  	175,  	{3858}, {1} }, -- Smelt Mithril
    [12908] =  	{ 10727,  	9,  	240,  	260,  	280,  	{10559,9061,3860,6037,10560}, {2,4,6,6,1} }, -- Goblin Dragon Gun
    [12897] =  	{ 10545,  	9,  	210,  	230,  	250,  	{10500,10559,10558,8151,4234}, {1,1,2,2,2} }, -- Gnomish Goggles
    [13378] =  	{ nil,  	10,  	105,  	130,  	170,  	{10998,10940}, {1,2} }, -- Enchant Shield - Minor Stamina
    [12609] =  	{ 10592,  	4,  	200,  	220,  	260,  	{3821,3818,3372}, {1,1,1} }, -- Catseye Elixir
    [13229] =  	{ 10921,  	13,  	1,  	265,  	315,  	{8923,5173,8925}, {1,2,1} }, -- Wound Poison III
    [11477] =  	{ 9224,  	4,  	250,  	265,  	305,  	{8846,8845,8925}, {1,1,1} }, -- Elixir of Demonslaying
    [12624] =  	{ 10576,  	9,  	250,  	270,  	290,  	{3860,7077,6037,9060,9061,7910}, {14,4,4,2,2,2} }, -- Mithril Mechanical Dragonling
    [12093] =  	{ 10036,  	8,  	250,  	265,  	295,  	{4339,8343}, {5,3} }, -- Tuxedo Jacket
    [12260] =  	{ 10421,  	2,  	1,  	15,  	55,  	{2840}, {4} }, -- Rough Copper Vest
    [12594] =  	{ 10500,  	9,  	205,  	225,  	245,  	{4385,3864,7068,4234}, {1,2,2,4} }, -- Fire Goggles
    [12595] =  	{ 10508,  	9,  	205,  	225,  	245,  	{10559,10560,4400,3860,7068}, {1,1,1,4,2} }, -- Mithril Blunderbuss
    [13028] =  	{ 10841,  	6,  	175,  	215,  	255,  	{3821,159}, {1,1}, 4 }, -- Goldthorn Tea
    [14379] =  	{ 11128,  	2,  	150,  	155,  	160,  	{3577,3478}, {1,2} }, -- Golden Rod
    [14380] =  	{ 11144,  	2,  	200,  	205,  	210,  	{6037,3486}, {1,1} }, -- Truesilver Rod
    [12074] =  	{ 10027,  	8,  	230,  	245,  	275,  	{4339,8343}, {3,2} }, -- Black Mageweave Shoulders
    [12076] =  	{ 10028,  	8,  	235,  	250,  	280,  	{4339,10285,8343}, {5,4,2} }, -- Shadoweave Shoulders
    [13612] =  	{ nil,  	10,  	145,  	170,  	210,  	{11083,2772}, {1,3} }, -- Enchant Gloves - Mining
    [15633] =  	{ 11826,  	9,  	205,  	205,  	205,  	{7075,4389,7191,3860,6037}, {1,2,1,2,1} }, -- Lil' Smoky
    [13635] =  	{ nil,  	10,  	155,  	175,  	215,  	{11138,11083}, {1,3} }, -- Enchant Cloak - Defense
    [12607] =  	{ 10501,  	9,  	220,  	240,  	260,  	{4304,7909,10592}, {4,2,1} }, -- Catseye Ultra Goggles
    [11400] =  	{ 9186,  	13,  	1,  	285,  	335,  	{8924,8923,8925}, {2,2,1} }, -- Mind-numbing Poison III
    [12071] =  	{ 10023,  	8,  	225,  	240,  	270,  	{4339,10285,8343}, {5,5,2} }, -- Shadoweave Gloves
    [12617] =  	{ 10506,  	9,  	230,  	250,  	270,  	{3860,10561,6037,818,774}, {8,1,1,4,4} }, -- Deepdive Helmet
    [12618] =  	{ 10503,  	9,  	230,  	250,  	270,  	{4304,7910}, {6,2} }, -- Rose Colored Goggles
    [11476] =  	{ 9264,  	4,  	250,  	265,  	305,  	{8845,8925}, {3,1} }, -- Elixir of Shadow Power
    [13228] =  	{ 10920,  	13,  	1,  	225,  	275,  	{2930,5173,3372}, {1,2,1} }, -- Wound Poison II
    [12616] =  	{ 10518,  	9,  	225,  	245,  	265,  	{4339,10285,10560,10505}, {4,2,1,4} }, -- Parachute Cloak
    [13230] =  	{ 10922,  	13,  	1,  	305,  	355,  	{8923,5173,8925}, {2,2,1} }, -- Wound Poison IV
    [13841] =  	{ nil,  	10,  	215,  	235,  	275,  	{11137,6037}, {3,3} }, -- Enchant Gloves - Advanced Mining
    [13815] =  	{ nil,  	10,  	210,  	230,  	270,  	{11174,11137}, {1,1} }, -- Enchant Gloves - Agility
    [13607] =  	{ nil,  	10,  	145,  	170,  	210,  	{11082,10998}, {1,2} }, -- Enchant Chest - Mana
    [13941] =  	{ nil,  	10,  	245,  	265,  	305,  	{11178,11176,11175}, {1,3,2} }, -- Enchant Chest - Stats
    [13419] =  	{ nil,  	10,  	110,  	135,  	175,  	{10998}, {1} }, -- Enchant Cloak - Minor Agility
    [13626] =  	{ nil,  	10,  	150,  	175,  	215,  	{11082,11083,11084}, {1,1,1} }, -- Enchant Chest - Minor Stats
    [13817] =  	{ nil,  	10,  	210,  	230,  	270,  	{11137}, {5} }, -- Enchant Shield - Stamina
    [13485] =  	{ nil,  	10,  	130,  	155,  	195,  	{10998,10940}, {2,4} }, -- Enchant Shield - Lesser Spirit
    [13464] =  	{ nil,  	10,  	115,  	140,  	180,  	{10998,10940,10978}, {1,1,1} }, -- Enchant Shield - Lesser Protection
    [13421] =  	{ nil,  	10,  	115,  	140,  	180,  	{10940,10978}, {6,1} }, -- Enchant Cloak - Lesser Protection
    [13947] =  	{ nil,  	10,  	250,  	270,  	310,  	{11178,11176}, {2,3} }, -- Enchant Gloves - Riding Skill
    [13661] =  	{ nil,  	10,  	180,  	200,  	240,  	{11137}, {1} }, -- Enchant Bracer - Strength
    [12053] =  	{ 10003,  	8,  	215,  	230,  	260,  	{4339,8343}, {2,2} }, -- Black Mageweave Gloves
    [12895] =  	{ 10713,  	9,  	205,  	205,  	205,  	{10648,10647}, {1,1} }, -- Inlaid Mithril Cylinder Plans
    [12059] =  	{ 10008,  	8,  	215,  	220,  	230,  	{4339,2324,8343}, {1,1,1} }, -- White Bandit Mask
    [12060] =  	{ 10009,  	8,  	215,  	230,  	260,  	{4339,2604,8343}, {3,2,1} }, -- Red Mageweave Pants
    [13822] =  	{ nil,  	10,  	210,  	230,  	270,  	{11174}, {2} }, -- Enchant Bracer - Intellect
    [13898] =  	{ nil,  	10,  	265,  	285,  	325,  	{11177,7078}, {4,1} }, -- Enchant Weapon - Fiery Weapon
    [13794] =  	{ nil,  	10,  	205,  	225,  	265,  	{11174}, {1} }, -- Enchant Cloak - Resistance
    [13663] =  	{ nil,  	10,  	185,  	205,  	245,  	{11135}, {1} }, -- Enchant Chest - Greater Mana
    [13836] =  	{ nil,  	10,  	215,  	235,  	275,  	{11137}, {5} }, -- Enchant Boots - Stamina
    [13933] =  	{ nil,  	10,  	235,  	255,  	295,  	{11178,3829}, {1,1} }, -- Enchant Shield - Frost Resistance
    [13700] =  	{ nil,  	10,  	200,  	220,  	260,  	{11135,11137,11139}, {2,2,1} }, -- Enchant Chest - Lesser Stats
    [13687] =  	{ nil,  	10,  	190,  	210,  	250,  	{11135,11134}, {1,2} }, -- Enchant Boots - Lesser Spirit
    [13536] =  	{ nil,  	10,  	140,  	165,  	205,  	{11083}, {2} }, -- Enchant Bracer - Lesser Strength
    [13917] =  	{ nil,  	10,  	230,  	250,  	290,  	{11175,11174}, {1,2} }, -- Enchant Chest - Superior Mana
    [12904] =  	{ 10723,  	9,  	1,  	240,  	260,  	{10561,3860,4389,10560}, {1,2,1,1} }, -- Gnomish Ham Radio
    [13943] =  	{ nil,  	10,  	1,  	265,  	305,  	{11178,11175}, {2,2} }, -- Enchant Weapon - Greater Striking
    [12722] =  	{ 10585,  	9,  	1,  	240,  	260,  	{10561,3860,4389,10560}, {1,2,1,1} }, -- Goblin Radio
    [13538] =  	{ nil,  	10,  	140,  	165,  	205,  	{10940,11082,11084}, {2,1,1} }, -- Enchant Chest - Lesser Absorption
    [13931] =  	{ nil,  	10,  	235,  	255,  	295,  	{11175,11176}, {1,2} }, -- Enchant Bracer - Deflection
    [13945] =  	{ nil,  	10,  	245,  	265,  	305,  	{11176}, {5} }, -- Enchant Bracer - Greater Stamina
    [13637] =  	{ nil,  	10,  	160,  	180,  	220,  	{11083,11134}, {1,1} }, -- Enchant Boots - Lesser Agility
    [13640] =  	{ nil,  	10,  	160,  	180,  	220,  	{11083}, {3} }, -- Enchant Chest - Greater Health
    [12716] =  	{ 10577,  	9,  	1,  	225,  	245,  	{10559,3860,10505,10558,7068}, {2,4,5,1,1} }, -- Goblin Mortar
    [12755] =  	{ 10587,  	9,  	230,  	230,  	270,  	{10561,10505,6037,10560,4407}, {2,4,6,1,2} }, -- Goblin Bomb Dispenser
    [12759] =  	{ 10645,  	9,  	240,  	260,  	280,  	{10559,10560,12808,7972,9060}, {2,1,1,4,1} }, -- Gnomish Death Ray
    [13693] =  	{ nil,  	10,  	195,  	215,  	255,  	{11135,11139}, {2,1} }, -- Enchant Weapon - Striking
    [13220] =  	{ 10918,  	13,  	1,  	185,  	235,  	{2930,5173,3372}, {1,1,1} }, -- Wound Poison
    [13689] =  	{ nil,  	10,  	195,  	215,  	255,  	{11135,11137,11139}, {2,2,1} }, -- Enchant Shield - Lesser Block
    [13642] =  	{ nil,  	10,  	165,  	185,  	225,  	{11134}, {1} }, -- Enchant Bracer - Spirit
    [13240] =  	{ 10577,  	9,  	1,  	nil,  	nil,  	{10577,3860,10505}, {1,1,3} }, -- The Mortar: Reloaded
    [13915] =  	{ nil,  	10,  	230,  	250,  	290,  	{11177,11176,9224}, {1,2,1} }, -- Enchant Weapon - Demonslaying
    [12715] =  	{ 10644,  	9,  	205,  	205,  	205,  	{10648,10647}, {1,1} }, -- Goblin Rocket Fuel Recipe
    [12717] =  	{ 10542,  	9,  	205,  	225,  	245,  	{3860,3864,7067}, {8,1,4} }, -- Goblin Mining Helmet
    [13846] =  	{ nil,  	10,  	220,  	240,  	280,  	{11174,11137}, {3,1} }, -- Enchant Bracer - Greater Spirit
    [12719] =  	{ 10579,  	9,  	1,  	210,  	250,  	{3030,10505,3860}, {100,2,2}, 100 }, -- Explosive Arrow
    [13617] =  	{ nil,  	10,  	145,  	170,  	210,  	{11083,3356}, {1,3} }, -- Enchant Gloves - Herbalism
    [13937] =  	{ nil,  	10,  	240,  	260,  	300,  	{11178,11176}, {2,2} }, -- Enchant 2H Weapon - Greater Impact
    [13644] =  	{ nil,  	10,  	170,  	190,  	230,  	{11083}, {4} }, -- Enchant Boots - Lesser Stamina
    [15255] =  	{ 11590,  	9,  	200,  	200,  	240,  	{3860,4338,10505}, {1,1,1} }, -- Mechanical Repair Kit
    [14930] =  	{ 8217,  	3,  	225,  	245,  	265,  	{4304,8172,8949,4291}, {12,1,1,4} }, -- Quickdraw Quiver
    [14932] =  	{ 8218,  	3,  	225,  	245,  	265,  	{4304,8172,8951,4291}, {10,1,1,6} }, -- Thick Leather Ammo Pouch
    [13882] =  	{ nil,  	10,  	225,  	245,  	285,  	{11174}, {2} }, -- Enchant Cloak - Lesser Agility
    [13702] =  	{ 11145,  	10,  	200,  	220,  	260,  	{11144,7971,11135,11137}, {1,1,2,2} }, -- Runed Truesilver Rod
    [14810] =  	{ 11290,  	10,  	175,  	195,  	235,  	{11291,11135,11137}, {1,1,1} }, -- Greater Mystic Wand
    [13746] =  	{ nil,  	10,  	205,  	225,  	265,  	{11137}, {3} }, -- Enchant Cloak - Greater Defense
    [13653] =  	{ nil,  	10,  	175,  	195,  	235,  	{11134,5637,11138}, {1,2,1} }, -- Enchant Weapon - Lesser Beastslayer
    [13655] =  	{ nil,  	10,  	175,  	195,  	235,  	{11134,7067,11138}, {1,1,1} }, -- Enchant Weapon - Lesser Elemental Slayer
    [14807] =  	{ 11288,  	10,  	70,  	110,  	150,  	{4470,10939}, {1,1} }, -- Greater Magic Wand
    [14809] =  	{ 11289,  	10,  	155,  	175,  	215,  	{11291,11134,11083}, {1,1,1} }, -- Lesser Mystic Wand
    [13858] =  	{ nil,  	10,  	220,  	240,  	280,  	{11137}, {6} }, -- Enchant Chest - Superior Health
    [14891] =  	{ 11371,  	7,  	230,  	230,  	230,  	{11370}, {8} }, -- Smelt Dark Iron
    [15973] =  	{ 12260,  	2,  	190,  	215,  	240,  	{3859,3577,7068,4234}, {10,4,2,2} }, -- Searing Golden Blade
    [13948] =  	{ nil,  	10,  	250,  	270,  	310,  	{11178,8153}, {2,2} }, -- Enchant Gloves - Minor Haste
    [15906] =  	{ 12217,  	6,  	200,  	240,  	280,  	{12037,4402,2692}, {1,1,1} }, -- Dragonbreath Chili
    [13868] =  	{ nil,  	10,  	225,  	245,  	285,  	{11137,8838}, {3,3} }, -- Enchant Gloves - Advanced Herbalism
    [13657] =  	{ nil,  	10,  	175,  	195,  	235,  	{11134,7068}, {1,1} }, -- Enchant Cloak - Fire Resistance
    [13659] =  	{ nil,  	10,  	180,  	200,  	240,  	{11135,11137}, {1,1} }, -- Enchant Shield - Spirit
    [13698] =  	{ nil,  	10,  	200,  	220,  	260,  	{11137,7392}, {1,3} }, -- Enchant Gloves - Skinning
    [15293] =  	{ 11606,  	2,  	270,  	290,  	310,  	{11371,7077}, {10,2} }, -- Dark Iron Mail
    [15294] =  	{ 11607,  	2,  	275,  	295,  	315,  	{11371,7077}, {26,4} }, -- Dark Iron Sunderer
    [15295] =  	{ 11605,  	2,  	280,  	300,  	320,  	{11371,7077}, {6,1} }, -- Dark Iron Shoulders
    [15296] =  	{ 11604,  	2,  	285,  	305,  	325,  	{11371,7077}, {20,8} }, -- Dark Iron Plate
    [15596] =  	{ 11811,  	10,  	265,  	285,  	325,  	{11382,7078,14343}, {1,1,3} }, -- Smoking Heart of the Mountain
    [15915] =  	{ 12216,  	6,  	225,  	265,  	305,  	{12206,2692}, {1,2} }, -- Spiced Chili Crab
    [16654] =  	{ 12418,  	2,  	285,  	305,  	325,  	{12359,7077}, {18,4} }, -- Radiant Gloves
    [16655] =  	{ 12631,  	2,  	290,  	310,  	330,  	{12359,12655,7078,7910}, {20,6,2,4} }, -- Fiery Plate Gauntlets
    [16639] =  	{ 12644,  	2,  	1,  	255,  	260,  	{12365}, {4} }, -- Dense Grinding Stone
    [16726] =  	{ 12612,  	2,  	300,  	320,  	340,  	{12359,12360,6037,12364}, {30,2,2,1} }, -- Runic Plate Helm
    [16728] =  	{ 12636,  	2,  	300,  	320,  	340,  	{12359,12655,8168,12799,12364}, {40,4,60,6,2} }, -- Helm of the Great Chief
    [15933] =  	{ 12218,  	6,  	225,  	265,  	305,  	{12207,3713}, {1,2} }, -- Monster Omelet
    [15935] =  	{ 12224,  	6,  	1,  	45,  	85,  	{12223,2678}, {1,1} }, -- Crispy Bat Wing
    [6617] =  	{ 5631,  	4,  	60,  	90,  	130,  	{5635,2450,3371}, {1,1,1} }, -- Rage Potion
    [15863] =  	{ 12213,  	6,  	175,  	215,  	255,  	{12037,2692}, {1,1} }, -- Carrion Surprise
    [15865] =  	{ 12214,  	6,  	175,  	215,  	255,  	{12037,2596}, {1,1} }, -- Mystery Stew
    [15855] =  	{ 12210,  	6,  	175,  	215,  	255,  	{12184,2692}, {1,1} }, -- Roast Raptor
    [15856] =  	{ 13851,  	6,  	175,  	215,  	255,  	{12203,2692}, {1,1} }, -- Hot Wolf Ribs
    [16664] =  	{ 12610,  	2,  	300,  	320,  	340,  	{12359,12360,3577}, {20,2,6} }, -- Runic Plate Shoulders
    [16153] =  	{ 12359,  	7,  	250,  	250,  	250,  	{10620}, {1} }, -- Smelt Thorium
    [15833] =  	{ 12190,  	4,  	245,  	245,  	285,  	{8831,8925}, {3,1} }, -- Dreamless Sleep Potion
    [15972] =  	{ 12259,  	2,  	180,  	205,  	230,  	{3859,3466,1206,7067,4234}, {10,2,1,1,1} }, -- Glinting Steel Dagger
    [2538] =  	{ 2679,  	6,  	1,  	45,  	85,  	{2672}, {1} }, -- Charred Wolf Meat
    [16640] =  	{ 12643,  	2,  	1,  	255,  	260,  	{12365,14047}, {1,1} }, -- Dense Weightstone
    [16641] =  	{ 12404,  	2,  	1,  	255,  	260,  	{12365}, {1} }, -- Dense Sharpening Stone
    [16642] =  	{ 12405,  	2,  	250,  	270,  	290,  	{12359,12361,11188}, {16,1,4} }, -- Thorium Armor
    [16643] =  	{ 12406,  	2,  	250,  	270,  	290,  	{12359,11186}, {12,4} }, -- Thorium Belt
    [16652] =  	{ 12409,  	2,  	280,  	300,  	320,  	{12359,8170,11185}, {20,8,4} }, -- Thorium Boots
    [16967] =  	{ 12772,  	2,  	270,  	295,  	320,  	{12359,3577,6037,12361,8170}, {30,4,2,2,4} }, -- Inlaid Thorium Hammer
    [17187] =  	{ 12360,  	4,  	275,  	275,  	290,  	{12359,12363}, {1,1} }, -- Transmute: Arcanite
    [16745] =  	{ 12618,  	2,  	300,  	320,  	340,  	{12360,12655,7076,7080,12364,12800}, {8,24,4,4,2,2} }, -- Enchanted Thorium Breastplate
    [16746] =  	{ 12641,  	2,  	300,  	320,  	340,  	{12360,12655,12364,12800}, {30,30,6,6} }, -- Invulnerable Mail
    [16969] =  	{ 12773,  	2,  	275,  	300,  	325,  	{12359,12799,12644,8170}, {20,2,2,4} }, -- Ornate Thorium Handaxe
    [16742] =  	{ 12620,  	2,  	300,  	320,  	340,  	{12360,12655,7076,12799,12800}, {6,16,6,2,1} }, -- Enchanted Thorium Helm
    [17559] =  	{ 7078,  	4,  	275,  	275,  	290,  	{7082}, {1} }, -- Transmute: Air to Fire
    [16730] =  	{ 12429,  	2,  	300,  	320,  	340,  	{12359,7910}, {44,2} }, -- Imperial Plate Leggings
    [16994] =  	{ 12784,  	2,  	300,  	320,  	340,  	{12360,12810,12644}, {20,6,2} }, -- Arcanite Reaper
    [16995] =  	{ 12783,  	2,  	300,  	320,  	340,  	{12360,12655,12810,7910,12800,12799,12644}, {10,10,2,6,6,6,4} }, -- Heartseeker
    [17560] =  	{ 7076,  	4,  	275,  	275,  	290,  	{7078}, {1} }, -- Transmute: Fire to Earth
    [17561] =  	{ 7080,  	4,  	275,  	275,  	290,  	{7076}, {1} }, -- Transmute: Earth to Water
    [16724] =  	{ 12633,  	2,  	300,  	320,  	340,  	{12359,12655,6037,3577,12800}, {20,4,6,6,2} }, -- Whitesoul Helm
    [16731] =  	{ 12613,  	2,  	300,  	320,  	340,  	{12359,12360,7910}, {40,2,1} }, -- Runic Breastplate
    [16732] =  	{ 12614,  	2,  	300,  	320,  	340,  	{12359,12360,7910}, {40,2,1} }, -- Runic Plate Leggings
    [15910] =  	{ 12215,  	6,  	200,  	240,  	280,  	{12204,3713,159}, {2,1,1}, 2 }, -- Heavy Kodo Stew
    [16665] =  	{ 12611,  	2,  	300,  	320,  	340,  	{12359,12360,2842}, {20,2,10} }, -- Runic Plate Boots
    [18242] =  	{ 13929,  	6,  	240,  	280,  	320,  	{13756,2692}, {1,2} }, -- Hot Smoked Bass
    [16661] =  	{ 12632,  	2,  	295,  	315,  	335,  	{12359,12655,7080,12361}, {20,4,4,4} }, -- Storm Gauntlets
    [16988] =  	{ 12796,  	2,  	300,  	320,  	340,  	{12359,12360,12809,12810,7076}, {50,15,4,6,10} }, -- Hammer of the Titans
    [16662] =  	{ 12414,  	2,  	300,  	320,  	340,  	{12359,11186}, {26,4} }, -- Thorium Leggings
    [16663] =  	{ 12422,  	2,  	300,  	320,  	340,  	{12359,7910}, {40,2} }, -- Imperial Plate Chest
    [17562] =  	{ 7082,  	4,  	275,  	275,  	290,  	{7080}, {1} }, -- Transmute: Water to Air
    [17563] =  	{ 7080,  	4,  	275,  	275,  	290,  	{12808}, {1} }, -- Transmute: Undeath to Water
    [18243] =  	{ 13931,  	6,  	250,  	290,  	330,  	{13759,159}, {1,1} }, -- Nightfin Soup
    [16991] =  	{ 12798,  	2,  	300,  	320,  	340,  	{12359,12360,12808,12364,12644,12810}, {40,12,10,8,2,4} }, -- Annihilator
    [16650] =  	{ 12624,  	2,  	270,  	290,  	310,  	{12359,12655,12803,8153,12364}, {40,2,4,4,1} }, -- Wildthorn Mail
    [16973] =  	{ 12776,  	2,  	280,  	305,  	330,  	{12359,12655,12364,12804,8170}, {20,6,2,4,4} }, -- Enchanted Battlehammer
    [16992] =  	{ 12797,  	2,  	300,  	320,  	340,  	{12360,12361,12800,7080,12644,12810}, {18,8,8,4,2,4} }, -- Frostguard
    [16993] =  	{ 12794,  	2,  	300,  	320,  	340,  	{12655,12364,12799,7076,12810}, {20,8,8,6,4} }, -- Masterwork Stormhammer
    [16646] =  	{ 12428,  	2,  	265,  	285,  	305,  	{12359,8170,3864}, {24,6,2} }, -- Imperial Plate Shoulders
    [18246] =  	{ 13934,  	6,  	275,  	315,  	355,  	{13893,2692,3713}, {1,1,1} }, -- Mightfish Steak
    [16651] =  	{ 12645,  	2,  	275,  	295,  	315,  	{12359,12644,7076}, {4,4,2} }, -- Thorium Shield Spike
    [16660] =  	{ 12625,  	2,  	290,  	310,  	330,  	{12359,12360,12364,7080}, {20,4,2,2} }, -- Dawnbringer Shoulders
    [16741] =  	{ 12639,  	2,  	300,  	320,  	340,  	{12360,12655,7076,12361,12799}, {15,20,10,4,4} }, -- Stronghold Gauntlets
    [17180] =  	{ 12655,  	10,  	250,  	250,  	260,  	{12359,11176}, {1,3} }, -- Enchanted Thorium
    [15292] =  	{ 11608,  	2,  	265,  	285,  	305,  	{11371,7077}, {18,4} }, -- Dark Iron Pulverizer
    [16645] =  	{ 12416,  	2,  	260,  	280,  	300,  	{12359,7077}, {10,2} }, -- Radiant Belt
    [16658] =  	{ 12427,  	2,  	295,  	315,  	335,  	{12359,7910}, {34,2} }, -- Imperial Plate Helm
    [15853] =  	{ 12209,  	6,  	125,  	165,  	205,  	{1015,2678}, {1,1} }, -- Lean Wolf Steak
    [16978] =  	{ 12777,  	2,  	280,  	305,  	330,  	{12655,7078,7077,12800,12644}, {10,4,4,2,2} }, -- Blazing Rapier
    [16656] =  	{ 12419,  	2,  	290,  	310,  	330,  	{12359,7077}, {14,4} }, -- Radiant Boots
    [16657] =  	{ 12426,  	2,  	295,  	315,  	335,  	{12359,7910,7909}, {34,1,1} }, -- Imperial Plate Boots
    [16990] =  	{ 12790,  	2,  	300,  	320,  	340,  	{12360,12800,12811,12799,12810,12644}, {15,8,1,4,8,2} }, -- Arcanite Champion
    [16960] =  	{ 12764,  	2,  	260,  	285,  	310,  	{12359,12644,8170}, {16,2,4} }, -- Thorium Greatsword
    [16965] =  	{ 12769,  	2,  	270,  	295,  	320,  	{12359,12803,8153,12799,12644,8170}, {30,6,6,6,2,8} }, -- Bleakwood Hew
    [16971] =  	{ 12775,  	2,  	280,  	305,  	330,  	{12359,12644,8170}, {40,6,6} }, -- Huge Thorium Battleaxe
    [15861] =  	{ 12212,  	6,  	175,  	215,  	255,  	{12202,159,4536}, {1,1,2}, 2 }, -- Jungle Stew
    [16648] =  	{ 12415,  	2,  	270,  	290,  	310,  	{12359,7077,7910}, {18,2,1} }, -- Radiant Breastplate
    [16649] =  	{ 12425,  	2,  	270,  	290,  	310,  	{12359,7910}, {20,1} }, -- Imperial Plate Bracers
    [16980] =  	{ 12779,  	2,  	285,  	310,  	335,  	{12359,12799,12644,8170}, {30,2,2,4} }, -- Rune Edge
    [16659] =  	{ 12417,  	2,  	295,  	315,  	335,  	{12359,7077}, {18,4} }, -- Radiant Circlet
    [16644] =  	{ 12408,  	2,  	255,  	275,  	295,  	{12359,11184}, {12,4} }, -- Thorium Bracers
    [16667] =  	{ 12628,  	2,  	285,  	305,  	325,  	{12359,12662,12361,7910}, {40,10,4,4} }, -- Demon Forged Breastplate
    [16647] =  	{ 12424,  	2,  	265,  	285,  	305,  	{12359,8170,7909}, {22,6,1} }, -- Imperial Plate Belt
    [16729] =  	{ 12640,  	2,  	300,  	320,  	340,  	{12359,12360,8146,12361,12800}, {80,12,40,10,4} }, -- Lionheart Helm
    [16744] =  	{ 12619,  	2,  	300,  	320,  	340,  	{12360,12655,7080,12361,12364}, {10,20,6,2,1} }, -- Enchanted Thorium Leggings
    [16970] =  	{ 12774,  	2,  	275,  	300,  	325,  	{12359,12655,7910,12361,12644,8170}, {30,4,4,4,2,4} }, -- Dawn's Edge
    [16986] =  	{ 12795,  	2,  	300,  	325,  	350,  	{12655,12360,12662,7910,12644}, {10,10,8,10,2} }, -- Blood Talon
    [16987] =  	{ 12802,  	2,  	300,  	325,  	350,  	{12655,12804,12364,12800,12644}, {20,20,2,2,2} }, -- Darkspear
    [17557] =  	{ 13453,  	4,  	275,  	290,  	330,  	{8846,13466,8925}, {2,2,1} }, -- Elixir of Brute Force
    [17576] =  	{ 13458,  	4,  	290,  	305,  	345,  	{7067,13463,8925}, {1,1,1} }, -- Greater Nature Protection Potion
    [23653] =  	{ 19169,  	2,  	300,  	320,  	340,  	{17011,17010,12360,11371,12364}, {8,5,10,12,4} }, -- Nightfall
    [17577] =  	{ 13461,  	4,  	290,  	305,  	345,  	{11176,13463,8925}, {1,1,1} }, -- Greater Arcane Protection Potion
    [17579] =  	{ 13460,  	4,  	290,  	305,  	345,  	{7069,13463,8925}, {1,1,1} }, -- Greater Holy Protection Potion
    [17580] =  	{ 13444,  	4,  	295,  	310,  	350,  	{13463,13467,8925}, {3,2,1} }, -- Major Mana Potion
    [17555] =  	{ 13447,  	4,  	270,  	285,  	325,  	{13463,13466,8925}, {1,2,1} }, -- Elixir of the Sages
    [17556] =  	{ 13446,  	4,  	275,  	290,  	330,  	{13464,13465,8925}, {2,1,1} }, -- Major Healing Potion
    [17553] =  	{ 13443,  	4,  	260,  	275,  	315,  	{8838,8839,8925}, {2,2,1} }, -- Superior Mana Potion
    [17565] =  	{ 7076,  	4,  	275,  	275,  	290,  	{12803}, {1} }, -- Transmute: Life to Earth
    [18420] =  	{ 14103,  	8,  	275,  	290,  	320,  	{14048,3577,14341}, {4,2,1} }, -- Brightcloth Cloak
    [18421] =  	{ 14132,  	8,  	275,  	290,  	320,  	{14048,11176,14341}, {6,1,1} }, -- Wizardweave Leggings
    [18422] =  	{ 14134,  	8,  	275,  	290,  	320,  	{14048,7078,7077,7068,14341}, {6,4,4,4,1} }, -- Cloak of Fire
    [16983] =  	{ 12781,  	2,  	285,  	310,  	335,  	{12655,12360,12804,12799,12361,12364}, {6,2,4,2,2,1} }, -- Serenity
    [16984] =  	{ 12792,  	2,  	290,  	315,  	340,  	{12359,7077,7910,8170}, {30,4,4,4} }, -- Volcanic Hammer
    [16653] =  	{ 12410,  	2,  	280,  	300,  	320,  	{12359,7910,11188}, {24,1,4} }, -- Thorium Helm
    [16985] =  	{ 12782,  	2,  	290,  	315,  	340,  	{12359,12360,12662,12808,12361,12644,8170}, {40,2,16,8,2,2,4} }, -- Corruption
    [16725] =  	{ 12420,  	2,  	300,  	320,  	340,  	{12359,7077}, {20,4} }, -- Radiant Leggings
    [17554] =  	{ 13445,  	4,  	265,  	280,  	320,  	{13423,8838,8925}, {2,1,1} }, -- Elixir of Superior Defense
    [17632] =  	{ 13503,  	4,  	300,  	315,  	330,  	{7078,7076,7082,7080,12803,9262,13468}, {8,8,8,8,8,2,4} }, -- Alchemist's Stone
    [18446] =  	{ 14128,  	8,  	300,  	315,  	345,  	{14048,11176,14341}, {8,2,1} }, -- Wizardweave Robe
    [17634] =  	{ 13506,  	4,  	300,  	315,  	330,  	{13423,13465,13468,8925}, {30,10,1,1} }, -- Flask of Petrification
    [18245] =  	{ 13933,  	6,  	275,  	315,  	355,  	{13888,159}, {1,1} }, -- Lobster Stew
    [17551] =  	{ 13423,  	4,  	1,  	250,  	260,  	{13422,3372}, {1,1} }, -- Stonescale Oil
    [17552] =  	{ 13442,  	4,  	255,  	270,  	310,  	{8846,8925}, {3,1} }, -- Mighty Rage Potion
    [18241] =  	{ 13930,  	6,  	225,  	265,  	305,  	{13758}, {1} }, -- Filet of Redgill
    [18247] =  	{ 13935,  	6,  	275,  	315,  	355,  	{13889,3713}, {1,1} }, -- Baked Salmon
    [18244] =  	{ 13932,  	6,  	250,  	290,  	330,  	{13760}, {1} }, -- Poached Sunscale Salmon
    [18629] =  	{ 14529,  	1,  	260,  	260,  	320,  	{14047}, {1} }, -- Runecloth Bandage
    [18630] =  	{ 14530,  	1,  	290,  	290,  	350,  	{14047}, {2} }, -- Heavy Runecloth Bandage
    [18416] =  	{ 14141,  	8,  	275,  	290,  	320,  	{14048,9210,14227,14341}, {6,4,1,1} }, -- Ghostweave Vest
    [18413] =  	{ 14142,  	8,  	270,  	285,  	315,  	{14048,9210,14227,14341}, {4,2,1,1} }, -- Ghostweave Gloves
    [18452] =  	{ 14140,  	8,  	300,  	315,  	345,  	{14048,14342,12800,12810,14341}, {4,6,1,2,2} }, -- Mooncloth Circlet
    [18453] =  	{ 14112,  	8,  	300,  	315,  	345,  	{14048,14256,12662,8170,14341}, {7,6,4,4,2} }, -- Felcloth Shoulders
    [18454] =  	{ 14146,  	8,  	300,  	315,  	345,  	{14048,14342,9210,13926,12364,12810,14341}, {10,10,10,6,6,8,2} }, -- Gloves of Spell Mastery
    [18455] =  	{ 14156,  	8,  	300,  	315,  	345,  	{14048,14342,14344,17012,14341}, {8,12,2,2,2} }, -- Bottomless Bag
    [19062] =  	{ 15067,  	3,  	270,  	290,  	310,  	{8170,15420,1529,14341}, {24,80,2,1} }, -- Ironfeather Shoulders
    [19058] =  	{ 15564,  	3,  	250,  	250,  	270,  	{8170}, {5} }, -- Rugged Armor Kit
    [18239] =  	{ 13927,  	6,  	225,  	265,  	305,  	{13754,3713}, {1,1} }, -- Cooked Glossy Mightfish
    [18434] =  	{ 14045,  	8,  	280,  	295,  	325,  	{14048,7078,14341}, {6,1,1} }, -- Cindercloth Pants
    [19796] =  	{ 16004,  	9,  	275,  	295,  	315,  	{16000,11371,10546,12361,12799,8170}, {2,6,2,2,2,4} }, -- Dark Iron Rifle
    [19068] =  	{ 15064,  	3,  	275,  	295,  	315,  	{8170,15419,14341}, {28,12,1} }, -- Warbear Harness
    [19070] =  	{ 15082,  	3,  	280,  	300,  	320,  	{8170,15408,14341}, {6,8,1} }, -- Heavy Scorpid Belt
    [19071] =  	{ 15086,  	3,  	280,  	300,  	320,  	{8170,2325,14341}, {12,1,1} }, -- Wicked Leather Headband
    [18560] =  	{ 14342,  	8,  	250,  	290,  	320,  	{14256}, {2} }, -- Mooncloth
    [18448] =  	{ 14139,  	8,  	300,  	315,  	345,  	{14048,14342,14341}, {5,5,1} }, -- Mooncloth Shoulders
    [18449] =  	{ 13867,  	8,  	300,  	315,  	345,  	{14048,14227,8170,14341}, {7,2,4,1} }, -- Runecloth Shoulders
    [18410] =  	{ 14143,  	8,  	265,  	280,  	310,  	{14048,9210,14227,14341}, {3,2,1,1} }, -- Ghostweave Belt
    [18411] =  	{ 13870,  	8,  	265,  	280,  	310,  	{14048,7080,14341}, {3,1,1} }, -- Frostweave Gloves
    [18412] =  	{ 14043,  	8,  	270,  	285,  	315,  	{14048,7077,14341}, {4,3,1} }, -- Cindercloth Gloves
    [19073] =  	{ 15072,  	3,  	280,  	300,  	320,  	{8170,15423,14341}, {8,8,1} }, -- Chimeric Leggings
    [18240] =  	{ 13928,  	6,  	240,  	280,  	320,  	{13755,3713}, {1,1} }, -- Grilled Squid
    [17566] =  	{ 12803,  	4,  	275,  	275,  	290,  	{7076}, {1} }, -- Transmute: Earth to Life
    [19799] =  	{ 16005,  	9,  	285,  	305,  	325,  	{15994,11371,15992,14047}, {2,1,3,3}, 3 }, -- Dark Iron Bomb
    [17564] =  	{ 12808,  	4,  	275,  	275,  	290,  	{7080}, {1} }, -- Transmute: Water to Undeath
    [18414] =  	{ 14100,  	8,  	270,  	285,  	315,  	{14048,3577,14341}, {5,2,1} }, -- Brightcloth Robe
    [17637] =  	{ 13512,  	4,  	300,  	315,  	330,  	{13463,13465,13468,8925}, {30,10,1,1} }, -- Flask of Supreme Power
    [18439] =  	{ 14104,  	8,  	290,  	305,  	335,  	{14048,3577,14227,14341}, {6,4,1,1} }, -- Brightcloth Pants
    [18441] =  	{ 14144,  	8,  	290,  	305,  	335,  	{14048,9210,14341}, {6,4,1} }, -- Ghostweave Pants
    [18445] =  	{ 14155,  	8,  	300,  	315,  	345,  	{14048,14342,14341}, {4,1,1} }, -- Mooncloth Bag
    [17573] =  	{ 13454,  	4,  	285,  	300,  	340,  	{13463,13465,8925}, {3,1,1} }, -- Greater Arcane Elixir
    [17574] =  	{ 13457,  	4,  	290,  	305,  	345,  	{7068,13463,8925}, {1,1,1} }, -- Greater Fire Protection Potion
    [21143] =  	{ 17197,  	6,  	1,  	45,  	85,  	{6889,17194}, {1,1} }, -- Gingerbread Cookie
    [17575] =  	{ 13456,  	4,  	290,  	305,  	345,  	{7070,13463,8925}, {1,1,1} }, -- Greater Frost Protection Potion
    [18415] =  	{ 14101,  	8,  	270,  	285,  	315,  	{14048,3577,14341}, {4,2,1} }, -- Brightcloth Gloves
    [23633] =  	{ 19057,  	2,  	300,  	320,  	340,  	{12360,6037,12811}, {2,10,1} }, -- Gloves of the Dawn
    [18437] =  	{ 14108,  	8,  	285,  	300,  	330,  	{14048,14256,8170,14341}, {6,4,4,1} }, -- Felcloth Boots
    [18438] =  	{ 13865,  	8,  	285,  	300,  	330,  	{14048,14227,14341}, {6,2,1} }, -- Runecloth Pants
    [18440] =  	{ 14137,  	8,  	290,  	305,  	335,  	{14048,14342,14341}, {6,4,1} }, -- Mooncloth Leggings
    [18442] =  	{ 14111,  	8,  	290,  	305,  	335,  	{14048,14256,14341}, {5,4,1} }, -- Felcloth Hood
    [18444] =  	{ 13866,  	8,  	295,  	310,  	340,  	{14048,14227,14341}, {4,2,1} }, -- Runecloth Headband
    [18418] =  	{ 14044,  	8,  	275,  	290,  	320,  	{14048,7078,14341}, {5,1,1} }, -- Cindercloth Cloak
    [18423] =  	{ 13864,  	8,  	280,  	295,  	325,  	{14048,14227,8170,14341}, {4,2,4,1} }, -- Runecloth Boots
    [18424] =  	{ 13871,  	8,  	280,  	295,  	325,  	{14048,7080,14341}, {6,1,1} }, -- Frostweave Pants
    [18419] =  	{ 14107,  	8,  	275,  	290,  	320,  	{14048,14256,14341}, {5,4,1} }, -- Felcloth Pants
    [18417] =  	{ 13863,  	8,  	275,  	290,  	320,  	{14048,8170,14341}, {4,4,1} }, -- Runecloth Gloves
    [17572] =  	{ 13462,  	4,  	285,  	300,  	340,  	{13467,13466,8925}, {2,2,1} }, -- Purification Potion
    [19814] =  	{ 16023,  	9,  	275,  	295,  	315,  	{10561,16000,15994,6037,8170,14047}, {1,1,2,1,2,4} }, -- Masterwork Target Dummy
    [17571] =  	{ 13452,  	4,  	280,  	295,  	335,  	{13465,13466,8925}, {2,2,1} }, -- Elixir of the Mongoose
    [23078] =  	{ 18587,  	9,  	265,  	285,  	305,  	{15994,18631,7191,14227,7910}, {2,2,2,2,2} }, -- Goblin Jumper Cables XL
    [17635] =  	{ 13510,  	4,  	300,  	315,  	330,  	{8846,13423,13468,8925}, {30,10,1,1} }, -- Flask of the Titans
    [17636] =  	{ 13511,  	4,  	300,  	315,  	330,  	{13463,13467,13468,8925}, {30,10,1,1} }, -- Flask of Distilled Wisdom
    [17578] =  	{ 13459,  	4,  	290,  	305,  	345,  	{3824,13463,8925}, {1,1,1} }, -- Greater Shadow Protection Potion
    [17570] =  	{ 13455,  	4,  	280,  	295,  	335,  	{13423,10620,8925}, {3,1,1} }, -- Greater Stoneshield Potion
    [19669] =  	{ 15872,  	2,  	1,  	275,  	285,  	{12360,12644}, {1,1}, 2 }, -- Arcanite Skeleton Key
    [22808] =  	{ 18294,  	4,  	215,  	230,  	270,  	{7972,8831,8925}, {1,2,1} }, -- Elixir of Greater Water Breathing
    [20016] =  	{ nil,  	10,  	280,  	300,  	340,  	{16203,16204}, {2,4} }, -- Enchant Shield - Superior Spirit
    [19793] =  	{ 15996,  	9,  	265,  	285,  	305,  	{12803,15994,10558,8170}, {1,4,1,1} }, -- Lifelike Mechanical Toad
    [19794] =  	{ 15999,  	9,  	270,  	290,  	310,  	{10502,7910,12810,14047}, {1,4,2,8} }, -- Spellpower Goggles Xtreme Plus
    [19098] =  	{ 15085,  	3,  	300,  	320,  	340,  	{8170,15407,14256,2325,14341}, {20,2,6,4,2} }, -- Wicked Leather Armor
    [19065] =  	{ 15092,  	3,  	275,  	295,  	315,  	{8170,7971,14047,14341}, {6,1,6,1} }, -- Runic Leather Bracers
    [19066] =  	{ 15071,  	3,  	275,  	295,  	315,  	{8170,15422,14341}, {4,6,1} }, -- Frostsaber Boots
    [21144] =  	{ 17198,  	6,  	35,  	75,  	115,  	{6889,1179,17196,17194}, {1,1,1,1} }, -- Egg Nog
    [18238] =  	{ 6887,  	6,  	225,  	265,  	305,  	{4603}, {1} }, -- Spotted Yellowtail
    [19081] =  	{ 15075,  	3,  	290,  	310,  	330,  	{8170,15423,14341}, {10,10,1} }, -- Chimeric Vest
    [19082] =  	{ 15094,  	3,  	290,  	310,  	330,  	{8170,14047,14341}, {14,10,1} }, -- Runic Leather Headband
    [19091] =  	{ 15095,  	3,  	300,  	320,  	340,  	{8170,14047,12810,14341}, {18,12,2,1} }, -- Runic Leather Pants
    [19095] =  	{ 15059,  	3,  	300,  	320,  	340,  	{8170,12803,14342,15407,14341}, {16,8,2,1,2} }, -- Living Breastplate
    [20010] =  	{ nil,  	10,  	295,  	315,  	355,  	{16204,16203}, {6,6} }, -- Enchant Bracer - Superior Strength
    [19083] =  	{ 15087,  	3,  	290,  	310,  	330,  	{8170,15407,2325,14341}, {16,1,3,1} }, -- Wicked Leather Pants
    [19078] =  	{ 15060,  	3,  	285,  	305,  	325,  	{8170,12803,15407,14341}, {16,6,1,1} }, -- Living Leggings
    [19079] =  	{ 15056,  	3,  	285,  	305,  	325,  	{8170,7080,7082,15407,14341}, {16,3,3,1,1} }, -- Stormshroud Armor
    [19080] =  	{ 15065,  	3,  	285,  	305,  	325,  	{8170,15419,14341}, {24,14,1} }, -- Warbear Woolies
    [20015] =  	{ nil,  	10,  	285,  	305,  	345,  	{16204}, {8} }, -- Enchant Cloak - Superior Defense
    [19051] =  	{ 15076,  	3,  	265,  	285,  	305,  	{8170,15408,14341}, {6,6,1} }, -- Heavy Scorpid Vest
    [19075] =  	{ 15079,  	3,  	285,  	305,  	325,  	{8170,15408,14341}, {8,12,1} }, -- Heavy Scorpid Leggings
    [19077] =  	{ 15048,  	3,  	285,  	305,  	325,  	{8170,15415,15407,14341}, {28,30,1,1} }, -- Blue Dragonscale Breastplate
    [19052] =  	{ 15084,  	3,  	265,  	285,  	305,  	{8170,2325,14341}, {8,1,1} }, -- Wicked Leather Bracers
    [19053] =  	{ 15074,  	3,  	265,  	285,  	305,  	{8170,15423,14341}, {6,6,1} }, -- Chimeric Gloves
    [17638] =  	{ 13513,  	4,  	300,  	315,  	330,  	{13467,13465,13468,8925}, {30,10,1,1} }, -- Flask of Chromatic Resistance
    [19093] =  	{ 15138,  	3,  	300,  	320,  	340,  	{15410,14044,14341}, {1,1,1} }, -- Onyxia Scale Cloak
    [19094] =  	{ 15051,  	3,  	300,  	320,  	340,  	{8170,15416,12810,15407,14341}, {44,45,2,1,1} }, -- Black Dragonscale Shoulders
    [19097] =  	{ 15062,  	3,  	300,  	320,  	340,  	{8170,15417,15407,14341}, {30,14,1,1} }, -- Devilsaur Leggings
    [18447] =  	{ 14138,  	8,  	300,  	315,  	345,  	{14048,14342,14341}, {6,4,1} }, -- Mooncloth Vest
    [18457] =  	{ 14152,  	8,  	300,  	315,  	345,  	{14048,7078,7082,7076,7080,14341}, {12,10,10,10,10,2} }, -- Robe of the Archmage
    [18458] =  	{ 14153,  	8,  	300,  	315,  	345,  	{14048,12662,14256,7078,12808,14341}, {12,20,40,12,12,2} }, -- Robe of the Void
    [19815] =  	{ 16006,  	9,  	285,  	305,  	325,  	{12360,14227}, {1,1} }, -- Delicate Arcanite Converter
    [19825] =  	{ 16008,  	9,  	290,  	310,  	330,  	{10500,12364,12810}, {1,2,4} }, -- Master Engineer's Goggles
    [19567] =  	{ 15846,  	9,  	250,  	270,  	290,  	{10561,12359,10558,10560}, {1,6,1,4} }, -- Salt Shaker
    [19059] =  	{ 15054,  	3,  	270,  	290,  	310,  	{8170,7078,7075,14341}, {6,1,1,1} }, -- Volcanic Leggings
    [18436] =  	{ 14136,  	8,  	285,  	300,  	330,  	{14048,14256,12808,7080,14341}, {10,12,4,4,1} }, -- Robe of Winter Night
    [19795] =  	{ 16000,  	9,  	275,  	295,  	315,  	{12359}, {6} }, -- Thorium Tube
    [19060] =  	{ 15046,  	3,  	270,  	290,  	310,  	{8170,15412,14341}, {20,25,1} }, -- Green Dragonscale Leggings
    [19061] =  	{ 15061,  	3,  	270,  	290,  	310,  	{8170,12803,14341}, {12,4,1} }, -- Living Shoulders
    [19063] =  	{ 15073,  	3,  	275,  	295,  	315,  	{8170,15423,14341}, {4,8,1} }, -- Chimeric Boots
    [18405] =  	{ 14046,  	8,  	260,  	275,  	305,  	{14048,8170,14341}, {5,2,1} }, -- Runecloth Bag
    [19054] =  	{ 15047,  	3,  	300,  	320,  	340,  	{8170,15414,14341}, {40,30,1} }, -- Red Dragonscale Breastplate
    [19084] =  	{ 15063,  	3,  	290,  	310,  	330,  	{8170,15417,14341}, {30,8,1} }, -- Devilsaur Gauntlets
    [19085] =  	{ 15050,  	3,  	290,  	310,  	330,  	{8170,15416,15407,14341}, {40,60,1,2} }, -- Black Dragonscale Breastplate
    [19086] =  	{ 15066,  	3,  	290,  	310,  	330,  	{8170,15420,1529,15407,14341}, {40,120,1,1,1} }, -- Ironfeather Breastplate
    [19790] =  	{ 15993,  	9,  	260,  	280,  	300,  	{15994,12359,15992,14047}, {1,3,3,3}, 3 }, -- Thorium Grenade
    [19791] =  	{ 15994,  	9,  	260,  	280,  	300,  	{12359,14047}, {3,1} }, -- Thorium Widget
    [19074] =  	{ 15069,  	3,  	285,  	305,  	325,  	{8170,15422,14341}, {6,8,1} }, -- Frostsaber Leggings
    [18401] =  	{ 14048,  	8,  	250,  	255,  	260,  	{14047}, {5} }, -- Bolt of Runecloth
    [19102] =  	{ 15090,  	3,  	300,  	320,  	340,  	{8170,12810,14047,15407,14341}, {22,4,16,1,2} }, -- Runic Leather Armor
    [19064] =  	{ 15078,  	3,  	275,  	295,  	315,  	{8170,15408,14341}, {6,8,1} }, -- Heavy Scorpid Gauntlets
    [19067] =  	{ 15057,  	3,  	275,  	295,  	315,  	{8170,7080,7082,14341}, {16,2,2,1} }, -- Stormshroud Pants
    [20017] =  	{ nil,  	10,  	265,  	285,  	325,  	{11176}, {10} }, -- Enchant Shield - Greater Stamina
    [19788] =  	{ 15992,  	9,  	250,  	250,  	260,  	{12365}, {2} }, -- Dense Blasting Powder
    [19792] =  	{ 15995,  	9,  	260,  	280,  	300,  	{10559,10561,15994,12359,10546}, {2,2,2,4,1} }, -- Thorium Rifle
    [18451] =  	{ 14106,  	8,  	300,  	315,  	345,  	{14048,14256,12662,14341}, {8,8,4,2} }, -- Felcloth Robe
    [19089] =  	{ 15049,  	3,  	295,  	315,  	335,  	{8170,15415,12810,15407,14341}, {28,30,2,1,1} }, -- Blue Dragonscale Shoulders
    [19090] =  	{ 15058,  	3,  	295,  	315,  	335,  	{8170,7080,7082,12810,14341}, {12,3,3,2,1} }, -- Stormshroud Shoulders
    [19092] =  	{ 15088,  	3,  	300,  	320,  	340,  	{8170,2325,14341}, {14,2,2} }, -- Wicked Leather Belt
    [18406] =  	{ 13858,  	8,  	260,  	275,  	305,  	{14048,14227,14341}, {5,1,1} }, -- Runecloth Robe
    [18407] =  	{ 13857,  	8,  	260,  	275,  	305,  	{14048,14227,14341}, {5,1,1} }, -- Runecloth Tunic
    [18408] =  	{ 14042,  	8,  	260,  	275,  	305,  	{14048,7077,14341}, {5,3,1} }, -- Cindercloth Vest
    [18409] =  	{ 13860,  	8,  	265,  	280,  	310,  	{14048,14227,14341}, {4,1,1} }, -- Runecloth Cloak
    [19087] =  	{ 15070,  	3,  	295,  	315,  	335,  	{8170,15422,14341}, {6,10,1} }, -- Frostsaber Gloves
    [18456] =  	{ 14154,  	8,  	300,  	315,  	345,  	{14048,14342,12811,13926,9210,14341}, {12,10,4,4,10,2} }, -- Truefaith Vestments
    [19088] =  	{ 15080,  	3,  	295,  	315,  	335,  	{8170,15408,15407,14341}, {8,12,1,1} }, -- Heavy Scorpid Helm
    [19103] =  	{ 15096,  	3,  	300,  	320,  	340,  	{8170,12810,14047,15407,14341}, {16,4,18,1,2} }, -- Runic Leather Shoulders
    [19106] =  	{ 15141,  	3,  	300,  	320,  	340,  	{8170,15410,15416,14341}, {40,12,60,2} }, -- Onyxia Scale Breastplate
    [18450] =  	{ 14130,  	8,  	300,  	315,  	345,  	{14048,11176,7910,14341}, {6,4,1,1} }, -- Wizardweave Turban
    [19076] =  	{ 15053,  	3,  	285,  	305,  	325,  	{8170,7078,7076,14341}, {8,1,1,1} }, -- Volcanic Breastplate
    [20026] =  	{ nil,  	10,  	275,  	295,  	335,  	{16204,14343}, {6,1} }, -- Enchant Chest - Major Health
    [20028] =  	{ nil,  	10,  	290,  	310,  	350,  	{16203,14343}, {3,1} }, -- Enchant Chest - Major Mana
    [20035] =  	{ nil,  	10,  	300,  	320,  	360,  	{16203,14344}, {12,2} }, -- Enchant 2H Weapon - Major Spirit
    [20013] =  	{ nil,  	10,  	295,  	315,  	355,  	{16203,16204}, {4,4} }, -- Enchant Gloves - Greater Strength
    [20036] =  	{ nil,  	10,  	300,  	320,  	360,  	{16203,14344}, {12,2} }, -- Enchant 2H Weapon - Major Intellect
    [19800] =  	{ 15997,  	9,  	285,  	305,  	325,  	{12359,15992}, {2,1}, 200 }, -- Thorium Shells
    [18402] =  	{ 13856,  	8,  	255,  	270,  	300,  	{14048,14341}, {3,1} }, -- Runecloth Belt
    [18403] =  	{ 13869,  	8,  	255,  	270,  	300,  	{14048,7079,14341}, {5,2,1} }, -- Frostweave Tunic
    [18404] =  	{ 13868,  	8,  	255,  	270,  	300,  	{14048,7079,14341}, {5,2,1} }, -- Frostweave Robe
    [20029] =  	{ nil,  	10,  	285,  	305,  	345,  	{14343,7080,7082,13467}, {4,1,1,1} }, -- Enchant Weapon - Icy Chill
    [20025] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,16204,16203}, {4,15,10} }, -- Enchant Chest - Greater Stats
    [20051] =  	{ 16207,  	10,  	290,  	310,  	350,  	{16206,13926,16204,16203,14343,14344}, {1,1,10,4,4,2} }, -- Runed Arcanite Rod
    [24846] =  	{ 20481,  	3,  	300,  	320,  	340,  	{20500,20498,7078}, {1,20,2} }, -- Spitfire Bracers
    [19100] =  	{ 15081,  	3,  	300,  	320,  	340,  	{8170,15408,15407,14341}, {14,14,1,2} }, -- Heavy Scorpid Shoulders
    [20008] =  	{ nil,  	10,  	255,  	275,  	315,  	{16202}, {3} }, -- Enchant Bracer - Greater Intellect
    [20009] =  	{ nil,  	10,  	270,  	290,  	330,  	{16202,11176}, {3,10} }, -- Enchant Bracer - Superior Spirit
    [19101] =  	{ 15055,  	3,  	300,  	320,  	340,  	{8170,7078,7076,14341}, {10,1,1,2} }, -- Volcanic Shoulders
    [20012] =  	{ nil,  	10,  	270,  	290,  	330,  	{16202,16204}, {3,3} }, -- Enchant Gloves - Greater Agility
    [19104] =  	{ 15068,  	3,  	300,  	320,  	340,  	{8170,15422,15407,14341}, {12,12,1,2} }, -- Frostsaber Tunic
    [19107] =  	{ 15052,  	3,  	300,  	320,  	340,  	{8170,15416,12810,15407,14341}, {40,60,4,1,2} }, -- Black Dragonscale Leggings
    [20023] =  	{ nil,  	10,  	295,  	315,  	355,  	{16203}, {8} }, -- Enchant Boots - Greater Agility
    [19666] =  	{ 15869,  	2,  	100,  	100,  	120,  	{2842,3470}, {1,1}, 2 }, -- Silver Skeleton Key
    [20014] =  	{ nil,  	10,  	265,  	285,  	325,  	{16202,7077,7075,7079,7081,7972}, {2,1,1,1,1,1} }, -- Enchant Cloak - Greater Resistance
    [19819] =  	{ 16009,  	9,  	290,  	310,  	330,  	{16006,10558,15994,12799}, {2,1,1,1} }, -- Voice Amplification Modulator
    [19830] =  	{ 16022,  	9,  	300,  	320,  	340,  	{10576,16006,12655,15994,10558,12810}, {1,8,10,6,4,6} }, -- Arcanite Dragonling
    [20024] =  	{ nil,  	10,  	275,  	295,  	335,  	{16203,16202}, {2,1} }, -- Enchant Boots - Spirit
    [19055] =  	{ 15091,  	3,  	270,  	290,  	310,  	{8170,14047,14341}, {10,6,1} }, -- Runic Leather Gauntlets
    [19435] =  	{ 15802,  	8,  	290,  	295,  	325,  	{14048,14342,7971,14341}, {6,4,2,1} }, -- Mooncloth Boots
    [19047] =  	{ 15407,  	3,  	250,  	250,  	260,  	{8171,15409}, {1,1} }, -- Cured Rugged Hide
    [19048] =  	{ 15077,  	3,  	255,  	275,  	295,  	{8170,15408,14341}, {4,4,1} }, -- Heavy Scorpid Bracers
    [20020] =  	{ nil,  	10,  	260,  	280,  	320,  	{11176}, {10} }, -- Enchant Boots - Greater Stamina
    [20011] =  	{ nil,  	10,  	300,  	320,  	360,  	{16204}, {15} }, -- Enchant Bracer - Superior Stamina
    [19049] =  	{ 15083,  	3,  	260,  	280,  	300,  	{8170,2325,14341}, {8,1,1} }, -- Wicked Leather Gauntlets
    [19050] =  	{ 15045,  	3,  	260,  	280,  	300,  	{8170,15412,14341}, {20,25,2} }, -- Green Dragonscale Breastplate
    [20626] =  	{ 16766,  	6,  	225,  	265,  	305,  	{7974,2692,1179}, {2,1,1}, 2 }, -- Undermine Clam Chowder
    [19668] =  	{ 15871,  	2,  	200,  	200,  	220,  	{6037,7966}, {1,1}, 2 }, -- Truesilver Skeleton Key
    [19831] =  	{ 16040,  	9,  	300,  	320,  	340,  	{16006,12359,14047}, {1,3,1}, 3 }, -- Arcane Bomb
    [19833] =  	{ 16007,  	9,  	300,  	320,  	340,  	{12360,16000,7078,7076,12800,12810}, {10,2,2,2,2,2} }, -- Flawless Arcanite Rifle
    [20650] =  	{ 4304,  	3,  	200,  	200,  	205,  	{4234}, {6} }, -- Thick Leather
    [20033] =  	{ nil,  	10,  	295,  	315,  	355,  	{14344,12808}, {4,4} }, -- Enchant Weapon - Unholy Weapon
    [20030] =  	{ nil,  	10,  	295,  	315,  	355,  	{14344,16204}, {4,10} }, -- Enchant 2H Weapon - Superior Impact
    [20031] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,16203}, {2,10} }, -- Enchant Weapon - Superior Striking
    [20648] =  	{ 2319,  	3,  	100,  	100,  	110,  	{2318}, {4} }, -- Medium Leather
    [20649] =  	{ 4234,  	3,  	150,  	150,  	160,  	{2319}, {5} }, -- Heavy Leather
    [20848] =  	{ 16980,  	8,  	300,  	315,  	345,  	{14048,17010,17011,12810,14341}, {12,4,4,6,2} }, -- Flarecore Mantle
    [20897] =  	{ 17016,  	2,  	300,  	320,  	340,  	{11371,17011,11382,12810}, {18,12,2,2} }, -- Dark Iron Destroyer
    [20032] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,12808,12803}, {6,6,6} }, -- Enchant Weapon - Lifestealing
    [20890] =  	{ 17015,  	2,  	300,  	320,  	340,  	{11371,17010,11382,12810}, {16,12,2,2} }, -- Dark Iron Reaver
    [23629] =  	{ 19048,  	2,  	300,  	320,  	340,  	{12360,7076,12803}, {4,6,6} }, -- Heavy Timbermaw Boots
    [20034] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,12811}, {4,2} }, -- Enchant Weapon - Crusader
    [19667] =  	{ 15870,  	2,  	150,  	150,  	170,  	{3577,3486}, {1,1}, 2 }, -- Golden Skeleton Key
    [22480] =  	{ 18045,  	6,  	225,  	265,  	305,  	{12208,3713}, {1,1} }, -- Tender Wolf Steak
    [20201] =  	{ 16206,  	2,  	1,  	275,  	285,  	{12360,12644}, {3,1} }, -- Arcanite Rod
    [20853] =  	{ 16982,  	3,  	295,  	315,  	335,  	{17012,17010,17011,14341}, {20,6,2,2} }, -- Corehound Boots
    [20854] =  	{ 16983,  	3,  	300,  	320,  	340,  	{17012,17010,17011,14341}, {15,3,6,2} }, -- Molten Helm
    [20849] =  	{ 16979,  	8,  	300,  	315,  	345,  	{14048,17010,7078,12810,14341}, {8,6,4,2,2} }, -- Flarecore Gloves
    [20872] =  	{ 16989,  	2,  	295,  	315,  	335,  	{11371,17010,17011}, {6,3,3} }, -- Fiery Chain Girdle
    [20916] =  	{ 8364,  	6,  	175,  	215,  	255,  	{8365}, {1} }, -- Mithril Headed Trout
    [21940] =  	{ 17716,  	9,  	190,  	190,  	230,  	{3860,4389,17202,3829}, {8,4,4,1} }, -- SnowMaster 9000
    [21943] =  	{ 17721,  	3,  	190,  	210,  	230,  	{4234,7067,4291}, {8,4,1} }, -- Gloves of the Greatfather
    [22793] =  	{ 18283,  	9,  	300,  	320,  	340,  	{17011,7076,16006,11371,16000}, {2,2,4,6,1} }, -- Biznicks 247x128 Accurascope
    [23705] =  	{ 19052,  	3,  	290,  	310,  	330,  	{8170,12809,7080,15407,14341}, {30,2,4,2,2} }, -- Dawn Treaders
    [22868] =  	{ 18408,  	8,  	300,  	315,  	345,  	{14048,7078,7910,14341}, {12,10,2,2} }, -- Inferno Gloves
    [23632] =  	{ 19051,  	2,  	290,  	310,  	330,  	{12359,6037,12811}, {8,6,1} }, -- Girdle of the Dawn
    [22921] =  	{ 18504,  	3,  	300,  	320,  	340,  	{8170,12804,15407,14341}, {12,12,2,4} }, -- Girdle of Insight
    [22732] =  	{ 18253,  	4,  	300,  	310,  	330,  	{10286,13464,13463,18256}, {1,4,4,1} }, -- Major Rejuvenation Potion
    [23666] =  	{ 19156,  	8,  	300,  	315,  	345,  	{14342,17010,17011,7078,14227}, {10,2,3,6,4} }, -- Flarecore Robe
    [22750] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,16203,12803,7080,12811}, {4,8,6,6,1} }, -- Enchant  Weapon - Healing Power
    [22704] =  	{ 18232,  	9,  	300,  	320,  	340,  	{12359,8170,7191,7067,7068}, {12,4,1,2,1} }, -- Field Repair Bot 74A
    [20855] =  	{ 16984,  	3,  	300,  	320,  	340,  	{12810,15416,17010,17011,14341}, {6,30,4,3,2} }, -- Black Dragonscale Boots
    [23704] =  	{ 19049,  	3,  	300,  	320,  	340,  	{12810,12804,12803,15407,14227}, {8,6,6,2,2} }, -- Timbermaw Brawlers
    [23706] =  	{ 19058,  	3,  	300,  	320,  	340,  	{12810,12803,12809,15407,14341}, {8,4,4,2,2} }, -- Golden Mantle of the Dawn
    [22434] =  	{ 17968,  	10,  	1,  	320,  	310,  	{17967,16204,16203}, {1,2,2} }, -- Charged Scale of Onyxia
    [21161] =  	{ 17193,  	2,  	300,  	325,  	350,  	{17203,11371,12360,7078,11382,17011,17010}, {8,20,50,25,10,10,10} }, -- Sulfuron Hammer
    [21923] =  	{ 17708,  	4,  	190,  	210,  	250,  	{3819,3358,3372}, {2,1,1} }, -- Elixir of Frost Power
    [22711] =  	{ 18238,  	3,  	200,  	210,  	230,  	{4304,7428,7971,4236,1210,8343}, {6,8,2,2,4,1} }, -- Shadowskin Gloves
    [21175] =  	{ 17222,  	6,  	200,  	240,  	280,  	{12205}, {2} }, -- Spider Sausage
    [22749] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,16203,7078,7080,7082,13926}, {4,12,4,4,4,2} }, -- Enchant  Weapon - Spell Power
    [21945] =  	{ 17723,  	8,  	190,  	200,  	210,  	{4305,2605,4291}, {5,4,1} }, -- Green Holiday Shirt
    [20876] =  	{ 17013,  	2,  	300,  	320,  	340,  	{11371,17010,17011}, {16,4,6} }, -- Dark Iron Leggings
    [21931] =  	{ nil,  	10,  	190,  	210,  	250,  	{11135,11137,11139,3819}, {3,3,1,2} }, -- Enchant Weapon - Winter's Might
    [22813] =  	{ 18258,  	8,  	1,  	285,  	295,  	{14048,8170,18240,14341}, {2,4,1,1} }, -- Gordok Ogre Suit
    [20873] =  	{ 16988,  	2,  	300,  	320,  	340,  	{11371,17010,17011}, {16,4,5} }, -- Fiery Chain Shoulders
    [20874] =  	{ 17014,  	2,  	295,  	315,  	335,  	{11371,17010,17011}, {4,2,2} }, -- Dark Iron Bracers
    [21913] =  	{ 17704,  	2,  	190,  	215,  	240,  	{3859,3829,7070,7069,4234}, {10,1,2,2,2} }, -- Edge of Winter
    [22926] =  	{ 18509,  	3,  	300,  	320,  	340,  	{8170,12607,15416,15414,15407,14341}, {30,12,30,30,5,8} }, -- Chromatic Cloak
    [22430] =  	{ 17967,  	4,  	1,  	315,  	330,  	{15410}, {1} }, -- Refined Scale of Onyxia
    [23628] =  	{ 19043,  	2,  	290,  	310,  	330,  	{12359,7076,12803}, {12,3,3} }, -- Heavy Timbermaw Belt
    [23799] =  	{ nil,  	10,  	290,  	310,  	350,  	{14344,16203,16204,7076}, {6,6,4,2} }, -- Enchant Weapon - Strength
    [23800] =  	{ nil,  	10,  	290,  	310,  	350,  	{14344,16203,16204,7082}, {6,6,4,2} }, -- Enchant Weapon - Agility
    [24136] =  	{ 19690,  	2,  	300,  	320,  	340,  	{12359,19774,19726,7910}, {20,10,2,2} }, -- Bloodsoul Breastplate
    [23489] =  	{ 18986,  	9,  	1,  	285,  	305,  	{3860,18631,7075,7079,7909,9060}, {12,2,4,2,4,1} }, -- Ultrasafe Transporter - Gadgetzan
    [23652] =  	{ 19168,  	2,  	300,  	320,  	340,  	{17011,17010,12360,11371,12809}, {6,6,10,6,12} }, -- Blackguard
    [23708] =  	{ 19157,  	3,  	300,  	320,  	340,  	{17010,17011,17012,12607,15407,14227}, {5,2,4,4,4,4} }, -- Chromatic Gauntlets
    [23079] =  	{ 18637,  	9,  	275,  	285,  	295,  	{16000,18631,14047}, {2,1,2} }, -- Major Recombobulator
    [23709] =  	{ 19162,  	3,  	300,  	320,  	340,  	{17010,17012,12810,15407,14227}, {8,12,10,4,4} }, -- Corehound Belt
    [23801] =  	{ nil,  	10,  	290,  	310,  	350,  	{16204,16203,7080}, {16,4,2} }, -- Enchant Bracer - Mana Regeneration
    [23703] =  	{ 19044,  	3,  	290,  	310,  	330,  	{8170,12804,12803,15407,14341}, {30,2,4,2,2} }, -- Might of the Timbermaw
    [23486] =  	{ 18984,  	9,  	1,  	285,  	305,  	{3860,18631,7077,7910,10586}, {10,1,4,2,1} }, -- Dimensional Ripper - Everlook
    [23636] =  	{ 19148,  	2,  	300,  	320,  	340,  	{17011,17010,11371}, {4,2,4} }, -- Dark Iron Helm
    [23637] =  	{ 19164,  	2,  	300,  	320,  	340,  	{17011,17010,17012,11371,11382}, {3,5,4,4,2} }, -- Dark Iron Gauntlets
    [22902] =  	{ 18486,  	8,  	300,  	315,  	345,  	{14048,14342,13926,14341}, {6,4,2,2} }, -- Mooncloth Robe
    [23804] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,16203,16204}, {15,12,20} }, -- Enchant Weapon - Mighty Intellect
    [22967] =  	{ 17771,  	7,  	300,  	310,  	320,  	{18562,12360,17010,18567}, {1,10,1,3} }, -- Smelt Elementium
    [22869] =  	{ 18409,  	8,  	300,  	315,  	345,  	{14048,14342,13926,14341}, {12,6,2,2} }, -- Mooncloth Gloves
    [22928] =  	{ 18511,  	3,  	300,  	320,  	340,  	{8170,7082,12753,12809,15407,14341}, {30,12,4,8,4,8} }, -- Shifting Cloak
    [23667] =  	{ 19165,  	8,  	300,  	315,  	345,  	{14342,17010,17011,7078,14227}, {8,5,3,10,4} }, -- Flarecore Leggings
    [22727] =  	{ 18251,  	3,  	300,  	320,  	340,  	{17012,14341}, {3,2} }, -- Core Armor Kit
    [23803] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,16203,16204}, {10,8,15} }, -- Enchant Weapon - Mighty Spirit
    [23071] =  	{ 18631,  	9,  	260,  	270,  	280,  	{6037,7067,7069}, {2,2,1} }, -- Truesilver Transformer
    [23507] =  	{ 19026,  	9,  	250,  	250,  	270,  	{15992,14047,8150}, {2,2,1}, 4 }, -- Snake Burst Firework
    [23707] =  	{ 19149,  	3,  	300,  	320,  	340,  	{17011,15407,14227}, {5,4,4} }, -- Lava Belt
    [23069] =  	{ 18588,  	9,  	200,  	200,  	220,  	{10505,4338}, {1,2} }, -- EZ-Thro Dynamite II
    [23070] =  	{ 18641,  	9,  	250,  	250,  	270,  	{15992,14047}, {2,3}, 2 }, -- Dense Dynamite
    [23190] =  	{ 18662,  	3,  	150,  	150,  	160,  	{4234,2321}, {2,1} }, -- Heavy Leather Ball
    [23710] =  	{ 19163,  	3,  	300,  	320,  	340,  	{17010,17011,7076,15407,14227}, {2,7,6,4,4} }, -- Molten Belt
    [23080] =  	{ 18594,  	9,  	275,  	275,  	295,  	{15994,15992,8170,159}, {2,3,2,1} }, -- Powerful Seaforium Charge
    [23081] =  	{ 18638,  	9,  	290,  	310,  	330,  	{11371,18631,7080,7910,12800}, {4,3,6,4,2} }, -- Hyper-Radiant Flame Reflector
    [23082] =  	{ 18639,  	9,  	300,  	320,  	340,  	{11371,18631,12803,12808,12800,12799}, {8,4,6,4,2,2} }, -- Ultra-Flash Shadow Reflector
    [22757] =  	{ 18262,  	2,  	300,  	300,  	320,  	{7067,12365}, {2,3} }, -- Elemental Sharpening Stone
    [23077] =  	{ 18634,  	9,  	260,  	280,  	300,  	{15994,18631,12361,7078,3829,13467}, {6,2,2,4,2,4} }, -- Gyrofreeze Ice Reflector
    [23638] =  	{ 19166,  	2,  	300,  	320,  	340,  	{17011,17010,12360,11382,11371}, {3,6,12,1,4} }, -- Black Amnesty
    [23639] =  	{ 19167,  	2,  	300,  	320,  	340,  	{17011,17010,12360,11371}, {5,2,16,6} }, -- Blackfury
    [23068] =  	{ 9313,  	9,  	150,  	150,  	175,  	{4377,4234}, {1,1}, 3 }, -- Green Firework
    [23662] =  	{ 19047,  	8,  	290,  	305,  	335,  	{14048,7076,12803,14227}, {8,3,3,2} }, -- Wisdom of the Timbermaw
    [23663] =  	{ 19050,  	8,  	300,  	315,  	345,  	{14342,7076,12803,14227}, {5,5,5,2} }, -- Mantle of the Timbermaw
    [23664] =  	{ 19056,  	8,  	290,  	305,  	335,  	{14048,12810,13926,12809,14227}, {6,4,2,2,2} }, -- Argent Boots
    [22795] =  	{ 18282,  	9,  	300,  	320,  	340,  	{17010,17011,12360,16006,16000}, {4,2,6,2,2} }, -- Core Marksman Rifle
    [22923] =  	{ 18508,  	3,  	300,  	320,  	340,  	{8170,18512,15420,15407,14341}, {12,8,60,4,4} }, -- Swift Flight Bracers
    [22797] =  	{ 18168,  	9,  	300,  	320,  	340,  	{12360,16006,7082,12803,7076}, {6,2,8,12,8} }, -- Force Reactive Disk
    [23096] =  	{ 18645,  	9,  	265,  	275,  	285,  	{12359,15994,8170,7910,7191}, {4,2,4,1,1} }, -- Alarm-O-Bot
    [22761] =  	{ 18254,  	6,  	275,  	315,  	355,  	{18255,3713}, {1,1} }, -- Runn Tum Tuber Surprise
    [23665] =  	{ 19059,  	8,  	300,  	315,  	345,  	{14342,12809,14227}, {5,2,2} }, -- Argent Shoulders
    [22815] =  	{ 18258,  	3,  	1,  	285,  	295,  	{8170,14048,18240,14341}, {4,2,1,1} }, -- Gordok Ogre Suit
    [22331] =  	{ 8170,  	3,  	250,  	250,  	250,  	{4304}, {6} }, -- Rugged Leather
    [22759] =  	{ 18263,  	8,  	300,  	320,  	350,  	{14342,17010,7078,12810,14341}, {6,8,2,6,4} }, -- Flarecore Wraps
    [24912] =  	{ 20549,  	2,  	300,  	320,  	340,  	{12359,20520,6037,12810}, {12,6,6,2} }, -- Darkrune Gauntlets
    [24399] =  	{ 20039,  	2,  	300,  	320,  	340,  	{17011,17010,17012,11371}, {3,3,4,6} }, -- Dark Iron Boots
    [24137] =  	{ 19691,  	2,  	300,  	320,  	340,  	{12359,19774,19726,7910}, {16,8,2,1} }, -- Bloodsoul Shoulders
    [24901] =  	{ 20538,  	8,  	300,  	315,  	345,  	{14048,20520,14256,14227}, {6,8,6,2} }, -- Runed Stygian Leggings
    [24847] =  	{ 20480,  	3,  	300,  	320,  	340,  	{20500,20498,7078,15407}, {2,30,2,1} }, -- Spitfire Gauntlets
    [24141] =  	{ 19695,  	2,  	300,  	320,  	340,  	{12359,19774,12799}, {16,10,1} }, -- Darksoul Shoulders
    [22927] =  	{ 18510,  	3,  	300,  	320,  	340,  	{8170,12803,7080,18512,15407,14341}, {30,12,10,8,3,8} }, -- Hide of the Wild
    [23650] =  	{ 19170,  	2,  	300,  	320,  	340,  	{17011,17010,12360,11371,12800}, {4,7,12,8,4} }, -- Ebon Hand
    [23802] =  	{ nil,  	10,  	300,  	320,  	360,  	{14344,16204,16203,12803}, {2,20,4,6} }, -- Enchant Bracer - Healing Power
    [22922] =  	{ 18506,  	3,  	300,  	320,  	340,  	{8170,7082,11754,15407,14341}, {12,6,4,2,4} }, -- Mongoose Boots
    [23129] =  	{ 18660,  	9,  	260,  	260,  	270,  	{10561,15994,10558,10560,3864}, {1,2,1,1,1} }, -- World Enlarger
    [24138] =  	{ 19692,  	2,  	300,  	320,  	340,  	{12359,19774,19726,12810}, {12,6,2,4} }, -- Bloodsoul Gauntlets
    [23066] =  	{ 9318,  	9,  	150,  	150,  	175,  	{4377,4234}, {1,1}, 3 }, -- Red Firework
    [23067] =  	{ 9312,  	9,  	150,  	150,  	175,  	{4377,4234}, {1,1}, 3 }, -- Blue Firework
    [24139] =  	{ 19693,  	2,  	300,  	320,  	340,  	{12359,19774,12799}, {20,14,2} }, -- Darksoul Breastplate
    [24140] =  	{ 19694,  	2,  	300,  	320,  	340,  	{12359,19774,12799}, {18,12,2} }, -- Darksoul Leggings
    [24365] =  	{ 20007,  	4,  	275,  	290,  	330,  	{13463,13466,8925}, {1,2,1} }, -- Mageblood Potion
    [24356] =  	{ 19999,  	9,  	300,  	320,  	340,  	{19726,19774,16006,12804,12810}, {4,5,2,8,4} }, -- Bloodvine Goggles
    [23399] =  	{ 18948,  	3,  	155,  	175,  	195,  	{4234,4236,5498,4461,5637}, {8,2,4,1,4} }, -- Barbaric Bracers
    [24902] =  	{ 20539,  	8,  	300,  	315,  	345,  	{14048,20520,14256,12810,14227}, {2,6,2,2,2} }, -- Runed Stygian Belt
    [24903] =  	{ 20537,  	8,  	300,  	315,  	345,  	{14048,20520,14256,12810,14227}, {4,6,4,2,2} }, -- Runed Stygian Boots
    [24121] =  	{ 19685,  	3,  	300,  	320,  	340,  	{19767,15407,12803,14341}, {14,5,4,4} }, -- Primal Batskin Jerkin
    [24122] =  	{ 19686,  	3,  	300,  	320,  	340,  	{19767,15407,12803,14341}, {10,4,4,3} }, -- Primal Batskin Gloves
    [24125] =  	{ 19689,  	3,  	300,  	320,  	340,  	{19768,19726,15407,14341}, {25,2,3,3} }, -- Blood Tiger Shoulders
    [22866] =  	{ 18405,  	8,  	300,  	315,  	345,  	{14048,9210,14342,7080,7078,14344,14341}, {16,10,10,12,12,6,6} }, -- Belt of the Archmage
    [22867] =  	{ 18407,  	8,  	300,  	315,  	345,  	{14048,14256,12662,12808,14341}, {12,20,6,8,2} }, -- Felcloth Gloves
    [22870] =  	{ 18413,  	8,  	300,  	315,  	345,  	{14048,12809,12360,14341}, {12,4,1,2} }, -- Cloak of Warding
    [24418] =  	{ 20074,  	6,  	150,  	160,  	200,  	{3667,3713}, {2,1} }, -- Heavy Crocolisk Stew
    [24940] =  	{ 20575,  	3,  	100,  	125,  	150,  	{2319,7286,4231,2321}, {8,8,1,2} }, -- Black Whelp Tunic
    [24654] =  	{ 20295,  	3,  	1,  	320,  	340,  	{8170,15415,15407,14341}, {28,36,2,2} }, -- Blue Dragonscale Leggings
    [27659] =  	{ 22248,  	8,  	275,  	290,  	320,  	{14048,16203,14341}, {5,2,2} }, -- Enchanted Runecloth Bag
    [24357] =  	{ 19998,  	9,  	300,  	320,  	340,  	{19726,19774,16006,12804,12810}, {5,5,1,8,4} }, -- Bloodvine Lens
    [25127] =  	{ 20747,  	10,  	250,  	260,  	280,  	{11176,8831,8925}, {3,2,1} }, -- Lesser Mana Oil
    [25128] =  	{ 20750,  	10,  	275,  	285,  	305,  	{16204,4625,8925}, {3,2,1} }, -- Wizard Oil
    [23787] =  	{ 19440,  	1,  	300,  	300,  	360,  	{19441}, {1} }, -- Powerful Anti-Venom
    [25347] =  	{ 20844,  	13,  	1,  	300,  	350,  	{5173,8925}, {7,1} }, -- Deadly Poison V
    [24266] =  	{ 19931,  	4,  	1,  	315,  	330,  	{12938,19943,12804,13468}, {1,1,6,1}, 3 }, -- Gurubashi Mojo Madness
    [24124] =  	{ 19688,  	3,  	300,  	320,  	340,  	{19768,19726,15407,14341}, {35,2,3,3} }, -- Blood Tiger Breastplate
    [24367] =  	{ 20008,  	4,  	285,  	300,  	340,  	{13467,13465,10286,8925}, {2,2,2,1} }, -- Living Action Potion
    [24123] =  	{ 19687,  	3,  	300,  	320,  	340,  	{19767,15407,12803,14341}, {8,3,4,3} }, -- Primal Batskin Bracers
    [24850] =  	{ 20477,  	3,  	300,  	320,  	340,  	{20501,20498,18512,15407}, {2,30,2,1} }, -- Sandstalker Gauntlets
    [24655] =  	{ 20296,  	3,  	1,  	300,  	320,  	{8170,15412,15407,14341}, {20,30,1,2} }, -- Green Dragonscale Gauntlets
    [24366] =  	{ 20002,  	4,  	275,  	290,  	330,  	{13463,13464,8925}, {2,1,1} }, -- Greater Dreamless Sleep Potion
    [24703] =  	{ 20380,  	3,  	300,  	320,  	340,  	{12810,20381,12803,15407,14227}, {12,6,4,4,6} }, -- Dreamscale Breastplate
    [24092] =  	{ 19683,  	8,  	300,  	315,  	345,  	{14342,19726,12804,14048,14227}, {4,4,4,4,2} }, -- Bloodvine Leggings
    [24093] =  	{ 19684,  	8,  	300,  	315,  	345,  	{14342,19726,12810,14048,14227}, {3,3,4,4,4} }, -- Bloodvine Boots
    [25129] =  	{ 20749,  	10,  	300,  	310,  	330,  	{14344,4625,18256}, {2,3,1} }, -- Brilliant Wizard Oil
    [25130] =  	{ 20748,  	10,  	300,  	310,  	330,  	{14344,8831,18256}, {2,3,1} }, -- Brilliant Mana Oil
    [24091] =  	{ 19682,  	8,  	300,  	315,  	345,  	{14342,19726,12804,14048,14227}, {3,5,4,4,2} }, -- Bloodvine Vest
    [24801] =  	{ 20452,  	6,  	285,  	325,  	365,  	{20424,3713}, {1,1} }, -- Smoked Desert Dumplings
    [25083] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,13468}, {3,8,2} }, -- Enchant Cloak - Stealth
    [25954] =  	{ 21217,  	6,  	175,  	215,  	255,  	{21153,2692}, {1,1} }, -- Sagefish Delight
    [24851] =  	{ 20478,  	3,  	300,  	320,  	340,  	{20501,20498,18512,15407}, {3,40,2,2} }, -- Sandstalker Breastplate
    [24848] =  	{ 20479,  	3,  	300,  	320,  	340,  	{20500,20498,7078,15407}, {3,40,2,2} }, -- Spitfire Breastplate
    [26011] =  	{ 21277,  	9,  	250,  	320,  	340,  	{15407,15994,7079,18631,10558}, {1,4,2,2,1} }, -- Tranquil Mechanical Yeti
    [24368] =  	{ 20004,  	4,  	290,  	305,  	345,  	{8846,13466,8925}, {1,2,1} }, -- Major Troll's Blood Potion
    [24849] =  	{ 20476,  	3,  	300,  	320,  	340,  	{20501,20498,18512}, {1,20,2} }, -- Sandstalker Bracers
    [25086] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,12809}, {3,8,8} }, -- Enchant Cloak - Dodge
    [25146] =  	{ 7068,  	4,  	300,  	301,  	310,  	{7077}, {1}, 3 }, -- Transmute: Elemental Fire
    [25081] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,7078}, {3,8,4} }, -- Enchant Cloak - Greater Fire Resistance
    [26085] =  	{ 21340,  	8,  	260,  	275,  	305,  	{14048,8170,7972,14341}, {6,4,2,1} }, -- Soul Pouch
    [26086] =  	{ 21341,  	8,  	285,  	300,  	330,  	{14256,12810,20520,14227}, {12,6,2,4} }, -- Felcloth Bag
    [25084] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,11754}, {4,6,2} }, -- Enchant Cloak - Subtlety
    [25079] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,12811}, {3,8,1} }, -- Enchant Gloves - Healing Power
    [25080] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,7082}, {3,8,4} }, -- Enchant Gloves - Superior Agility
    [25082] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,12803}, {2,8,4} }, -- Enchant Cloak - Greater Nature Resistance
    [26087] =  	{ 21342,  	8,  	300,  	315,  	345,  	{14256,17012,19726,7078,14227}, {20,16,8,4,4} }, -- Core Felcloth Bag
    [24913] =  	{ 20551,  	2,  	300,  	320,  	340,  	{12359,20520,6037,11754}, {16,8,8,1} }, -- Darkrune Helm
    [25072] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,18512}, {4,6,8} }, -- Enchant Gloves - Threat
    [25073] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,12808}, {3,10,6} }, -- Enchant Gloves - Shadow Power
    [25074] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,7080}, {3,10,4} }, -- Enchant Gloves - Frost Power
    [25704] =  	{ 21072,  	6,  	80,  	120,  	160,  	{21071,2678}, {1,1} }, -- Smoked Sagefish
    [25078] =  	{ nil,  	10,  	300,  	320,  	360,  	{20725,14344,7078}, {2,10,4} }, -- Enchant Gloves - Fire Power
    [25124] =  	{ 20744,  	10,  	45,  	55,  	75,  	{10940,17034,3371}, {2,1,1} }, -- Minor Wizard Oil
    [25125] =  	{ 20745,  	10,  	150,  	160,  	180,  	{11083,17034,3372}, {3,2,1} }, -- Minor Mana Oil
    [25126] =  	{ 20746,  	10,  	200,  	210,  	230,  	{11137,17035,3372}, {3,2,1} }, -- Lesser Wizard Oil
    [24914] =  	{ 20550,  	2,  	300,  	320,  	340,  	{12359,20520,6037}, {20,10,10} }, -- Darkrune Breastplate
    [26424] =  	{ 21574,  	9,  	225,  	225,  	250,  	{10505,4304}, {1,1}, 3 }, -- Green Rocket Cluster
    [26425] =  	{ 21576,  	9,  	225,  	225,  	250,  	{10505,4304}, {1,1}, 3 }, -- Red Rocket Cluster
    [26423] =  	{ 21571,  	9,  	225,  	225,  	250,  	{10505,4304}, {1,1}, 3 }, -- Blue Rocket Cluster
    [27586] =  	{ 22198,  	2,  	300,  	320,  	340,  	{22203,22202,12655,7076}, {8,24,8,4} }, -- Jagged Obsidian Shield
    [26418] =  	{ 21557,  	9,  	125,  	125,  	150,  	{4364,2319}, {1,1}, 3 }, -- Small Red Rocket
    [26420] =  	{ 21589,  	9,  	175,  	175,  	200,  	{4377,4234}, {1,1}, 3 }, -- Large Blue Rocket
    [26421] =  	{ 21590,  	9,  	175,  	175,  	200,  	{4377,4234}, {1,1}, 3 }, -- Large Green Rocket
    [26426] =  	{ 21714,  	9,  	275,  	275,  	285,  	{15992,8170}, {1,1}, 3 }, -- Large Blue Rocket Cluster
    [27589] =  	{ 22194,  	2,  	300,  	320,  	340,  	{22203,22202,12810,13512}, {8,24,8,1} }, -- Black Grasp of the Destroyer
    [26403] =  	{ 21154,  	8,  	250,  	265,  	295,  	{14048,4625,2604,14341}, {4,2,2,1} }, -- Festive Red Dress
    [26407] =  	{ 21542,  	8,  	250,  	265,  	295,  	{14048,4625,2604,14341}, {4,2,2,1} }, -- Festive Red Pant Suit
    [26422] =  	{ 21592,  	9,  	175,  	175,  	200,  	{4377,4234}, {1,1}, 3 }, -- Large Red Rocket
    [26416] =  	{ 21558,  	9,  	125,  	125,  	150,  	{4364,2319}, {1,1}, 3 }, -- Small Blue Rocket
    [26417] =  	{ 21559,  	9,  	125,  	125,  	150,  	{4364,2319}, {1,1}, 3 }, -- Small Green Rocket
    [26427] =  	{ 21716,  	9,  	275,  	275,  	285,  	{15992,8170}, {1,1}, 3 }, -- Large Green Rocket Cluster
    [26428] =  	{ 21718,  	9,  	275,  	275,  	285,  	{15992,8170}, {1,1}, 3 }, -- Large Red Rocket Cluster
    [26277] =  	{ 21546,  	4,  	250,  	265,  	305,  	{6371,4625,8925}, {3,3,1} }, -- Elixir of Greater Firepower
    [27585] =  	{ 22197,  	2,  	300,  	320,  	340,  	{22202,12655,7076}, {14,4,2} }, -- Heavy Obsidian Belt
    [27587] =  	{ 22196,  	2,  	300,  	320,  	340,  	{22203,22202,12655,7076,12364}, {18,40,12,10,4} }, -- Thick Obsidian Breastplate
    [25659] =  	{ 21023,  	6,  	300,  	325,  	365,  	{2692,9061,8150,21024}, {1,1,1,1}, 5 }, -- Dirge's Kickin' Chimaerok Chops
    [27588] =  	{ 22195,  	2,  	300,  	320,  	340,  	{22202,12810}, {14,4} }, -- Light Obsidian Belt
    [27590] =  	{ 22191,  	2,  	300,  	320,  	340,  	{22203,22202,12810,12809,12800}, {15,36,12,10,4} }, -- Obsidian Mail Tunic
    [26279] =  	{ 21278,  	3,  	300,  	320,  	340,  	{12810,7080,7082,15407,14227}, {6,4,4,2,2} }, -- Stormshroud Gloves
    [26443] =  	{ 21570,  	9,  	275,  	295,  	315,  	{9060,9061,18631,10561}, {4,4,2,1} }, -- Firework Cluster Launcher
    [26442] =  	{ 21569,  	9,  	225,  	245,  	265,  	{9060,9061,10560,10561}, {1,1,1,1} }, -- Firework Launcher
    [28209] =  	{ 22655,  	8,  	300,  	315,  	345,  	{22682,14048,7080,14227}, {4,2,2,4} }, -- Glacial Wrists
    [28219] =  	{ 22661,  	3,  	300,  	320,  	340,  	{22682,12810,7080,15407,14227}, {7,16,2,4,4} }, -- Polar Tunic
    [28220] =  	{ 22662,  	3,  	300,  	320,  	340,  	{22682,12810,7080,15407,14227}, {5,12,2,3,4} }, -- Polar Gloves
    [28205] =  	{ 22654,  	8,  	300,  	315,  	345,  	{22682,14048,7080,14227}, {5,4,4,4} }, -- Glacial Gloves
    [28242] =  	{ 22669,  	2,  	300,  	320,  	340,  	{22682,12359,12360,7080}, {7,16,2,4} }, -- Icebane Breastplate
    [28243] =  	{ 22670,  	2,  	300,  	320,  	340,  	{22682,12359,12360,7080}, {5,12,2,2} }, -- Icebane Gauntlets
    [28221] =  	{ 22663,  	3,  	300,  	320,  	340,  	{22682,12810,7080,15407,14227}, {4,12,2,2,4} }, -- Polar Bracers
    [28327] =  	{ 22728,  	9,  	275,  	295,  	315,  	{15994,10561,10558}, {2,1,1} }, -- Steam Tonk Controller
    [28207] =  	{ 22652,  	8,  	300,  	315,  	345,  	{22682,14048,7080,14227}, {7,8,6,8} }, -- Glacial Vest
    [28208] =  	{ 22658,  	8,  	300,  	315,  	345,  	{22682,14048,7080,14227}, {5,4,2,4} }, -- Glacial Cloak
    [27724] =  	{ 22251,  	8,  	275,  	290,  	320,  	{14048,8831,11040,14341}, {5,10,8,2} }, -- Cenarion Herb Bag
    [28210] =  	{ 22660,  	8,  	300,  	315,  	345,  	{19726,14342,12803,14227}, {1,2,4,4} }, -- Gaea's Embrace
    [27837] =  	{ nil,  	10,  	290,  	310,  	350,  	{14344,16203,16204,7082}, {10,6,14,4} }, -- Enchant 2H Weapon - Agility
    [28224] =  	{ 22665,  	3,  	300,  	320,  	340,  	{22682,15408,7080,15407,14227}, {4,16,2,2,4} }, -- Icy Scale Bracers
    [28222] =  	{ 22664,  	3,  	300,  	320,  	340,  	{22682,15408,7080,15407,14227}, {7,24,2,4,4} }, -- Icy Scale Breastplate
    [28223] =  	{ 22666,  	3,  	300,  	320,  	340,  	{22682,15408,7080,15407,14227}, {5,16,2,3,4} }, -- Icy Scale Gauntlets
    [27658] =  	{ 22246,  	8,  	225,  	240,  	270,  	{4339,11137,8343}, {4,4,2} }, -- Enchanted Mageweave Pouch
    [27832] =  	{ 22383,  	2,  	300,  	320,  	340,  	{12360,20725,13512,12810}, {12,2,2,4} }, -- Sageblade
    [27829] =  	{ 22385,  	2,  	300,  	320,  	340,  	{12360,12655,7076,13510}, {12,20,10,2} }, -- Titanic Leggings
    [27830] =  	{ 22384,  	2,  	300,  	320,  	340,  	{12360,11371,12808,20520,15417,12753}, {15,10,20,20,10,2} }, -- Persuader
    [27660] =  	{ 22249,  	8,  	300,  	315,  	345,  	{14048,14344,12810,14227}, {6,4,4,4} }, -- Big Bag of Enchantment
    [28480] =  	{ 22756,  	8,  	300,  	315,  	345,  	{14048,19726,12803,14227}, {4,2,2,2} }, -- Sylvan Vest
    [28474] =  	{ 22761,  	3,  	300,  	320,  	340,  	{12810,12803,15407}, {4,2,1} }, -- Bramblewood Belt
    [28481] =  	{ 22757,  	8,  	300,  	315,  	345,  	{14048,14342,12803,14227}, {4,2,2,2} }, -- Sylvan Crown
    [28482] =  	{ 22758,  	8,  	300,  	315,  	345,  	{14048,12803,14227}, {2,4,2} }, -- Sylvan Shoulders
    [28472] =  	{ 22759,  	3,  	300,  	320,  	340,  	{12810,19726,12803,15407}, {12,2,2,2} }, -- Bramblewood Helm
    [28473] =  	{ 22760,  	3,  	300,  	320,  	340,  	{12810,18512,12803,15407}, {6,2,2,2} }, -- Bramblewood Boots
    [28462] =  	{ 22763,  	2,  	300,  	320,  	340,  	{12655,19726,12803}, {8,1,2} }, -- Ironvine Gloves
    [28461] =  	{ 22762,  	2,  	300,  	320,  	340,  	{12655,19726,12360,12803}, {12,2,2,2} }, -- Ironvine Breastplate
    [28463] =  	{ 22764,  	2,  	300,  	320,  	340,  	{12655,12803}, {6,2} }, -- Ironvine Belt
    [28244] =  	{ 22671,  	2,  	300,  	320,  	340,  	{22682,12359,12360,7080}, {4,12,2,2} }, -- Icebane Bracers
    [30047] =  	{ 23683,  	6,  	300,  	325,  	365,  	{23567,8150}, {1,1}, 2 }, -- Crystal Throat Lozenge
    [30021] =  	{ 23684,  	1,  	300,  	300,  	360,  	{23567,14047}, {1,10}, 4 }, -- Crystal Infused Bandage
}

local PROFESSION_ITEM_SKILL = {
    -- Herb
    [8838] = { 230, 255, 330 }, -- Sungrass
    [8839] = { 235, 260, 335 }, -- Blindweed
    [8845] = { 245, 270, 345 }, -- Ghost Mushroom
    [8846] = { 250, 275, 350 }, -- Gromsblood
    [13464] = { 260, 285, 360 }, -- Golden Sansam
    [13463] = { 270, 295, 370 }, -- Dreamfoil
    [13465] = { 280, 305, 380 }, -- Mountain Silversage
    [13466] = { 285, 310, 385 }, -- Plaguebloom
    [13467] = { 290, 315, 390 }, -- Icecap
    [13468] = { 300, 325, 400 }, -- Black Lotus
    --[19726] = { 0, 0, 0 }, -- Bloodvine
    [3818] = { 160, 185, 260 }, -- Fadeleaf
    [3821] = { 170, 195, 270 }, -- Goldthorn
    [3358] = { 185, 210, 285 }, -- Khadgar's Whisker
    [3819] = { 195, 220, 295 }, -- Wintersbite
    [4625] = { 205, 230, 305 }, -- Firebloom
    [8831] = { 210, 235, 310 }, -- Purple Lotus
    --[8153] = { 0, 0, 0 }, -- Wildvine
    [8836] = { 220, 245, 320 }, -- Arthas' Tears
    [3820] = { 85, 110, 185 }, -- Stranglekelp
    [2453] = { 100, 125, 200 }, -- Bruiseweed
    [3355] = { 115, 140, 215 }, -- Wild Steelbloom
    [3369] = { 120, 145, 220 }, -- Grave Moss
    [3356] = { 125, 150, 225 }, -- Kingsblood
    [3357] = { 150, 175, 250 }, -- Liferoot
    [2447] = { 1, 25, 100 }, -- Peacebloom
    [765] = { 1, 25, 100 }, -- Silverleaf
    [2449] = { 15, 40,115 }, -- Earthroot
    [785] = { 50, 75, 150 }, -- Mageroyal
    [2450] = { 70, 95, 170 }, -- Briarthorn
    --[2452] = { 0, 0, 0 }, -- Swiftthistle
}

-- maybe weak table?
local ProfessionCache = {}
local ContentPhaseCache = {}

local function OnInit()
    Recipe = AtlasLoot.Data.Recipe
    ContentPhase = AtlasLoot.Data.ContentPhase
end
AtlasLoot:AddInitFunc(OnInit)

function Profession.IsProfessionSpell(spellID)
	return PROFESSION[spellID or 0] and true or false
end

function Profession.GetProfessionData(spellID)
	return PROFESSION[spellID or 0] and PROFESSION[spellID or 0] or nil
end

function Profession.GetDataForExtraFrame(spellID)
    local prof = Profession.GetProfessionData(spellID)
    if not prof then return end

    if not ProfessionCache[spellID] then
        local ret
        if prof[1] then
            if prof[1] and prof[8] then
                ret = { { prof[1], prof[8] } }
            else
                ret = { prof[1] }
            end
		else
			ret = {}
        end
        local recipe = Recipe.GetRecipeForSpell(spellID)
        if recipe then
            ret[#ret+1] = recipe
            ret[#ret+1] = 0
        elseif #ret > 0 then
            ret[#ret+1] = 0
        end
		for i = 1, #prof[6] do
			ret[#ret+1] = {prof[6][i], prof[7][i]}
		end
		ProfessionCache[spellID] = ret
    end

    return ProfessionCache[spellID]
end

function Profession.GetCreatedItemID(spellID)
	return PROFESSION[spellID or 0] and PROFESSION[spellID or 0][1] or nil
end

function Profession.GetNumCreatedItems(spellID)
	return PROFESSION[spellID or 0] and ( PROFESSION[spellID or 0][8] or 1 ) or nil
end

function Profession.GetSpellDescription(spellID)
	return ( spellID and PROFESSION[spellID] ) and PROFESSION_TEXT[PROFESSION[spellID][2] or PROFESSION_DEFAULT] or nil
end

function Profession.GetColorSkillRankNoSpell(min, low, high)
    return min <= 1 and format(FORMAT_STRING_SKILL2, low, ((high - low) * 0.5)+low, high) or format(FORMAT_STRING_SKILL, min, low, ((high - low) * 0.5)+low, high)
end

function Profession.GetColorSkillRank(spellID)
    local spell = Profession.GetProfessionData(spellID)
    if not spell then return end
    return  Profession.GetColorSkillRankNoSpell(spell[3], spell[4], spell[5]) --format(FORMAT_STRING_SKILL, spell[3], spell[4], ((spell[5] - spell[4]) * 0.5)+spell[4], spell[5])
end

function Profession.GetSpellDescriptionWithRank(spellID)
    if not spellID or not PROFESSION[spellID] then return end
    return Profession.GetSpellDescription(spellID).."  "..(Profession.GetColorSkillRank(spellID) or "")
end

function Profession.GetColorSkillRankItem(itemID)
    local itemData = PROFESSION_ITEM_SKILL[itemID or 0]
    if not itemData then return end
    return  Profession.GetColorSkillRankNoSpell(itemData[1], itemData[2], itemData[3]) --format(FORMAT_STRING_SKILL, spell[3], spell[4], ((spell[5] - spell[4]) * 0.5)+spell[4], spell[5])
end

function Profession.GetIcon(spellID)
    local prof = Profession.GetProfessionData(spellID)
    if not prof then return PROFESSION_ICON[0] end
    return PROFESSION_ICON[prof[2] or 0] or PROFESSION_ICON[0]
end

function Profession.GetSpellIDPhase(spellID)
    if not PROFESSION[spellID] then return end
    if not ContentPhaseCache[spellID] then
        local content = PROFESSION[spellID][6]
        local recipe = Recipe.GetRecipeForSpell(spellID)
        local phase = recipe and ContentPhase:GetForItemID(recipe) or 0
        local createdItemPhase = ContentPhase:GetForItemID(PROFESSION[spellID][1])
        phase = ( createdItemPhase and createdItemPhase > phase ) and createdItemPhase or phase
        for i = 1, #content do
            local c = ContentPhase:GetForItemID(content[i])
            phase = ( c and c > phase ) and c or phase
        end

        ContentPhaseCache[spellID] = phase
    end
    return ContentPhaseCache[spellID]
end

function Profession.GetPhaseTextureForSpellID(spellID)
    local phase = ContentPhaseCache[spellID] or Profession.GetSpellIDPhase(spellID)
    if not phase then return end
    return ContentPhase:GetPhaseTexture(phase)
end

function Profession.GetProfessionID(spellID)
    return PROFESSION[spellID or 0] and PROFESSION[spellID][2] or nil
end