local _, FieldGuide = ...

local portalTrainers = {
    ["milstaff_stormeye"] = {
        ["name"] = "Milstaff Stormeye",
        ["rep"] = FieldGuide.factions.ironforge,
        ["map"] = FieldGuide.maps.ironforge,
        ["x"] = 25.5,
        ["y"] = 7.07
    },
    ["larimaine_purdue"] = {
        ["name"] = "Larimaine Purdue",
        ["rep"] = FieldGuide.factions.stormwind,
        ["map"] = FieldGuide.maps.stormwind,
        ["x"] = 39.84,
        ["y"] = 79.45
    },
    ["elissa_dumas"] = {
        ["name"] = "Elissa Dumas",
        ["rep"] = FieldGuide.factions.darnassus,
        ["map"] = FieldGuide.maps.darnassus,
        ["x"] = 40.6,
        ["y"] = 82.13
    },
    ["thuul"] = {
        ["name"] = "Thuul",
        ["rep"] = FieldGuide.factions.orgrimmar,
        ["map"] = FieldGuide.maps.orgrimmar,
        ["x"] = 38.68,
        ["y"] = 85.41
    },
    ["lexington_mortaim"] = {
        ["name"] = "Lexington Mortaim",
        ["rep"] = FieldGuide.factions.undercity,
        ["map"] = FieldGuide.maps.undercity,
        ["x"] = 84.19,
        ["y"] = 15.58
    },
    ["birgitte_cranston"] = {
        ["name"] = "Birgitte Cranston",
        ["rep"] = FieldGuide.factions.undercity,
        ["map"] = FieldGuide.maps.thunder_bluff,
        ["x"] = 22.5,
        ["y"] = 16.91
    },
}

FieldGuide.WEAPON_TRAINERS = {
    ["ALLIANCE"] = {
        [1] = {
            ["name"] = "Ilyenia Moonfire",
            ["rep"] = FieldGuide.factions.darnassus,
            ["map"] = FieldGuide.maps.darnassus,
            ["x"] = 57.8,
            ["y"] = 46.8,
            [264] = true,
            [1180] = true,
            [15590] = true,
            [227] = true,
            [2567] = true
        },
        [2] = {
            ["name"] = "Bixi Wobblebonk",
            ["rep"] = FieldGuide.factions.ironforge,
            ["map"] = FieldGuide.maps.ironforge,
            ["x"] = 62.0,
            ["y"] = 89.8,
            [5011] = true,
            [1180] = true,
            [2567] = true,
        },
        [3] = {
            ["name"] = "Buliwyf Stonehand",
            ["rep"] = FieldGuide.factions.ironforge,
            ["map"] = FieldGuide.maps.ironforge,
            ["x"] = 61.6,
            ["y"] = 89.4,
            [15590] = true,
            [266] = true,
            [196] = true,
            [197] = true,
            [198] = true,
            [199] = true,
        },
        [4] = {
            ["name"] = "Woo Ping",
            ["rep"] = FieldGuide.factions.stormwind,
            ["map"] = FieldGuide.maps.stormwind,
            ["x"] = 57.0,
            ["y"] = 57.6,
            [5011] = true,
            [1180] = true,
            [201] = true,
            [200] = true,
            [227] = true,
            [202] = true,
        }
    },
    ["HORDE"] = {
        [1] = {
            ["name"] = "Hanashi",
            ["rep"] = FieldGuide.factions.darkspear_trolls,
            ["map"] = FieldGuide.maps.orgrimmar,
            ["x"] = 81.6,
            ["y"] = 19.4,
            [264] = true,
            [196] = true,
            [227] = true,
            [2567] = true,
            [197] = true,
        },
        [2] = {
            ["name"] = "Sayoc",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.orgrimmar,
            ["x"] = 81.6,
            ["y"] = 19.4,
            [264] = true,
            [1180] = true,
            [15590] = true,
            [196] = true,
            [227] = true,
            [2567] = true,
            [197] = true
        },
        [3] = {
            ["name"] = "Ansekhwa",
            ["rep"] = FieldGuide.factions.thunder_bluff,
            ["map"] = FieldGuide.maps.thunder_bluff,
            ["x"] = 41.2,
            ["y"] = 61.4,
            [266] = true,
            [198] = true,
            [227] = true,
            [199] = true
        },
        [4] = {
            ["name"] = "Archibald",
            ["rep"] = FieldGuide.factions.undercity,
            ["map"] = FieldGuide.maps.undercity,
            ["x"] = 57.8,
            ["y"] = 31.6,
            [5011] = true,
            [1180] = true,
            [201] = true,
            [200] = true,
            [202] = true
        }
    }
}

FieldGuide.PORTAL_TRAINERS = {
    [3562] = portalTrainers.milstaff_stormeye,
    [3561] = portalTrainers.larimaine_purdue,
    [3565] = portalTrainers.elissa_dumas,
    [3567] = portalTrainers.thuul,
    [3563] = portalTrainers.lexington_mortaim,
    [3566] = portalTrainers.birgitte_cranston,
    [11416] = portalTrainers.milstaff_stormeye,
    [10059] = portalTrainers.larimaine_purdue,
    [11419] = portalTrainers.elissa_dumas,
    [11417] = portalTrainers.thuul,
    [11418] = portalTrainers.lexington_mortaim,
    [11420] = portalTrainers.birgitte_cranston
}

FieldGuide.HUNTER_PET_TRAINERS = {
    ["ALLIANCE"] = {
        [1] = {
            ["name"] = "Belia Thundergranite",
            ["rep"] = FieldGuide.factions.ironforge,
            ["map"] = FieldGuide.maps.ironforge,
            ["x"] = 70.86,
            ["y"] = 85.83
        },
        [2] = {
            ["name"] = "Bolyun",
            ["rep"] = FieldGuide.factions.darnassus,
            ["map"] = FieldGuide.maps.ashenvale,
            ["x"] = 18.0,
            ["y"] = 60.0
        },
        [3] = {
            ["name"] = "Caelyb",
            ["rep"] = FieldGuide.factions.darnassus,
            ["map"] = FieldGuide.maps.ashenvale,
            ["x"] = 49.7,
            ["y"] = 67.0
        },
        [4] = {
            ["name"] = "Claude Erksine",
            ["rep"] = FieldGuide.factions.ironforge,
            ["map"] = FieldGuide.maps.loch_modan,
            ["x"] = 82.22,
            ["y"] = 62.84
        },
        [5] = {
            ["name"] = "Karrina Mekenda",
            ["rep"] = FieldGuide.factions.ironforge,
            ["map"] = FieldGuide.maps.stormwind,
            ["x"] = 61.58,
            ["y"] = 15.97
        },
        [6] = {
            ["name"] = "Keldas",
            ["rep"] = FieldGuide.factions.darnassus,
            ["map"] = FieldGuide.maps.teldrassil,
            ["x"] = 56.79,
            ["y"] = 59.78
        },
        [7] = {
            ["name"] = "Nalesette Wildbringer",
            ["rep"] = FieldGuide.factions.darnassus,
            ["map"] = FieldGuide.maps.felwood,
            ["x"] = 22.79,
            ["y"] = 49.32
        },
        [8] = {
            ["name"] = "Peria Lamenur",
            ["rep"] = FieldGuide.factions.ironforge,
            ["map"] = FieldGuide.maps.dun_morogh,
            ["x"] = 46.68,
            ["y"] = 54.0
        },
        [9] = {
            ["name"] = "Silvaria",
            ["rep"] = FieldGuide.factions.darnassus,
            ["map"] = FieldGuide.maps.darnassus,
            ["x"] = 42.47,
            ["y"] = 9.17
        },
    },
    ["HORDE"] = {
        [1] = {
            ["name"] = "Grokor",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.swamp_of_sorrows,
            ["x"] = 47.4,
            ["y"] = 52.9
        },
        [2] = {
            ["name"] = "Harruk",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.durotar,
            ["x"] = 52.0,
            ["y"] = 43.5
        },
        [3] = {
            ["name"] = "Hesuwa Thunderhorn",
            ["rep"] = FieldGuide.factions.thunder_bluff,
            ["map"] = FieldGuide.maps.thunder_bluff,
            ["x"] = 54.09,
            ["y"] = 83.99
        },
        [4] = {
            ["name"] = "Reban Freerunner",
            ["rep"] = FieldGuide.factions.thunder_bluff,
            ["map"] = FieldGuide.maps.mulgore,
            ["x"] = 47.71,
            ["y"] = 55.73
        },
        [5] = {
            ["name"] = "Xao'tsu",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.orgrimmar,
            ["x"] = 66.32,
            ["y"] = 14.81
        },
        [6] = {
            ["name"] = "Zudd",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.stranglethorn_vale,
            ["x"] = 31.11,
            ["y"] = 28.94
        },
    }
}

FieldGuide.WARLOCK_PET_TRAINERS = {
    ["ALLIANCE"] = {
        [1] = {
            ["name"] = "Wren Darkspring",
            ["rep"] = FieldGuide.factions.gnomeregan_exiles,
            ["map"] = FieldGuide.maps.dun_morogh,
            ["x"] = 28.8,
            ["y"] = 66.2,
            ["Blood Pact"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true
        },
        [2] = {
            ["name"] = "Dane Winslow",
            ["rep"] = FieldGuide.factions.stormwind,
            ["map"] = FieldGuide.maps.elwynn_forest,
            ["x"] = 50.0,
            ["y"] = 42.6,
            ["Blood Pact"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true
        },
        [3] = {
            ["name"] = "Dannie Fizzwizzle",
            ["rep"] = FieldGuide.factions.gnomeregan_exiles,
            ["map"] = FieldGuide.maps.dun_morogh,
            ["x"] = 47.2,
            ["y"] = 53.6,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Suffering"] = true,
            ["Torment"] = true
        },
        [4] = {
            ["name"] = "Dannie Fizzwizzle",
            ["rep"] = FieldGuide.factions.stormwind,
            ["map"] = FieldGuide.maps.elwynn_forest,
            ["x"] = 44.4,
            ["y"] = 66.0,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Suffering"] = true,
            ["Torment"] = true
        },
        [5] = {
            ["name"] = "Jubahl Corpseseeker",
            ["rep"] = FieldGuide.factions.gnomeregan_exiles,
            ["map"] = FieldGuide.maps.ironforge,
            ["x"] = 52.7,
            ["y"] = 6.1,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Devour Magic"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Lash of Pain"] = true,
            ["Lesser Invisibility"] = true,
            ["Paranoia"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Seduction"] = true,
            ["Soothing Kiss"] = true,
            ["Spell Lock"] = true,
            ["Suffering"] = true,
            ["Tainted Blood"] = true,
            ["Torment"] = true
        },
        [6] = {
            ["name"] = "Spackle Thornberry",
            ["rep"] = FieldGuide.factions.gnomeregan_exiles,
            ["map"] = FieldGuide.maps.stormwind,
            ["x"] = 25.7,
            ["y"] = 77.7,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Devour Magic"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Lash of Pain"] = true,
            ["Lesser Invisibility"] = true,
            ["Paranoia"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Seduction"] = true,
            ["Soothing Kiss"] = true,
            ["Spell Lock"] = true,
            ["Suffering"] = true,
            ["Tainted Blood"] = true,
            ["Torment"] = true
        }
    },
    ["HORDE"] = {
        [1] = {
            ["name"] = "Kayla Smithe",
            ["rep"] = FieldGuide.factions.undercity,
            ["map"] = FieldGuide.maps.tirisfal_glades,
            ["x"] = 30.8,
            ["y"] = 66.2,
            ["Blood Pact"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true
        },
        [2] = {
            ["name"] = "Hraug",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.durotar,
            ["x"] = 40.6,
            ["y"] = 68.4,
            ["Blood Pact"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true
        },
        [3] = {
            ["name"] = "Gina Lang",
            ["rep"] = FieldGuide.factions.undercity,
            ["map"] = FieldGuide.maps.tirisfal_glades,
            ["x"] = 61.6,
            ["y"] = 52.6,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Suffering"] = true,
            ["Torment"] = true
        },
        [4] = {
            ["name"] = "Kitha",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.durotar,
            ["x"] = 54.6,
            ["y"] = 41.4,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Suffering"] = true,
            ["Torment"] = true
        },
        [5] = {
            ["name"] = "Kurgul",
            ["rep"] = FieldGuide.factions.orgrimmar,
            ["map"] = FieldGuide.maps.orgrimmar,
            ["x"] = 47.6,
            ["y"] = 47.6,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Devour Magic"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Lash of Pain"] = true,
            ["Lesser Invisibility"] = true,
            ["Paranoia"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Seduction"] = true,
            ["Soothing Kiss"] = true,
            ["Spell Lock"] = true,
            ["Suffering"] = true,
            ["Tainted Blood"] = true,
            ["Torment"] = true
        },
        [6] = {
            ["name"] = "Martha Strain",
            ["rep"] = FieldGuide.factions.undercity,
            ["map"] = FieldGuide.maps.undercity,
            ["x"] = 85.6,
            ["y"] = 15.8,
            ["Blood Pact"] = true,
            ["Consume Shadows"] = true,
            ["Devour Magic"] = true,
            ["Fire Shield"] = true,
            ["Firebolt"] = true,
            ["Lash of Pain"] = true,
            ["Lesser Invisibility"] = true,
            ["Paranoia"] = true,
            ["Phase Shift"] = true,
            ["Sacrifice"] = true,
            ["Seduction"] = true,
            ["Soothing Kiss"] = true,
            ["Spell Lock"] = true,
            ["Suffering"] = true,
            ["Tainted Blood"] = true,
            ["Torment"] = true
        }
    }
}

FieldGuide.SPELL_TRAINERS = {
    ["WARRIOR"] = {
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Alyissia",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 59.64,
                ["y"] = 38.44,
                ["noob"] = true
            },
            [2] = {
                ["name"] = "Ander Germaine",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 78.21,
                ["y"] = 47.59
            },
            [3] = {
                ["name"] = "Arias'ta Bladesinger",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 58.71,
                ["y"] = 34.9
            },
            [4] = {
                ["name"] = "Bilban Tosslespanner",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 65.9,
                ["y"] = 88.4
            },
            [5] = {
                ["name"] = "Captain Evencane",
                ["rep"] = FieldGuide.factions.theramore,
                ["map"] = FieldGuide.maps.dustwallow_marsh,
                ["x"] = 67.9,
                ["y"] = 48.4
            },
            [6] = {
                ["name"] = "Darnath Bladesinger",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 58.94,
                ["y"] = 35.35
            },
            [7] = {
                ["name"] = "Granis Swiftaxe",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 47.36,
                ["y"] = 52.65
            },
            [8] = {
                ["name"] = "Ilsa Corbin",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 78.5,
                ["y"] = 45.71
            },
            [9] = {
                ["name"] = "Kelstrum Stonebreaker",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 66.97,
                ["y"] = 90.15
            },
            [10] = {
                ["name"] = "Kelv Sternhammer",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 70.34,
                ["y"] = 90.65
            },
            [11] = {
                ["name"] = "Kyra Windblade",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 56.22,
                ["y"] = 59.2
            },
            [12] = {
                ["name"] = "Llane Beshere",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 50.24,
                ["y"] = 42.29,
                ["noob"] = true
            },
            [13] = {
                ["name"] = "Lyria Du Lac",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 41.1,
                ["y"] = 65.8
            },
            [14] = {
                ["name"] = "Sildanair",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 61.78,
                ["y"] = 42.22
            },
            [15] = {
                ["name"] = "Thran Khorman",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 28.83,
                ["y"] = 67.24,
                ["noob"] = true
            },
            [16] = {
                ["name"] = "Wu Shen",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 78.68,
                ["y"] = 45.79
            }
        },
        ["HORDE"] = {
            [1] = {
                ["name"] = "Angela Curthas",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 48.32,
                ["y"] = 15.96
            },
            [2] = {
                ["name"] = "Austil de Mon",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 61.85,
                ["y"] = 52.54
            },
            [3] = {
                ["name"] = "Baltus Fowler",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 47.4,
                ["y"] = 17.29
            },
            [4] = {
                ["name"] = "Christoph Walker",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 46.93,
                ["y"] = 15.23
            },
            [5] = {
                ["name"] = "Dannal Stern",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 32.69,
                ["y"] = 65.56,
                ["noob"] = true
            },
            [6] = {
                ["name"] = "Frang",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 42.9,
                ["y"] = 69.4,
                ["noob"] = true
            },
            [7] = {
                ["name"] = "Grezz Ragefist",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 79.79,
                ["y"] = 31.42
            },
            [8] = {
                ["name"] = "Harutt Thunderhorn",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 44.0,
                ["y"] = 76.1
            },
            [9] = {
                ["name"] = "Ker Ragetotem",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 57.58,
                ["y"] = 85.5
            },
            [10] = {
                ["name"] = "Krang Stonehoof",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 49.52,
                ["y"] = 60.59
            },
            [11] = {
                ["name"] = "Malosh",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.dustwallow_marsh,
                ["x"] = 44.9,
                ["y"] = 57.6
            },
            [12] = {
                ["name"] = "Sark Ragetotem",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 56.99,
                ["y"] = 89.51
            },
            [13] = {
                ["name"] = "Sorek",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 80.39,
                ["y"] = 32.38
            },
            [14] = {
                ["name"] = "Tarshaw Jaggedscar",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 54.2,
                ["y"] = 42.5
            },
            [15] = {
                ["name"] = "Torm Ragetotem",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 57.24,
                ["y"] = 87.37
            },
            [16] = {
                ["name"] = "Zel'mak",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 80.38,
                ["y"] = 29.5
            }
        }
    },
    ["PALADIN"] = {
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Arthur the Faithful",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 38.69,
                ["y"] = 32.93
            },
            [2] = {
                ["name"] = "Azar Stronghammer",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 47.6,
                ["y"] = 52.07
            },
            [3] = {
                ["name"] = "Beldruk Doombrow",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 24.55,
                ["y"] = 4.47
            },
            [4] = {
                ["name"] = "Brandur Ironhammer",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 23.13,
                ["y"] = 6.14
            },
            [5] = {
                ["name"] = "Bromos Grummner",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 28.83,
                ["y"] = 68.33,
                ["noob"] = true
            },
            [6] = {
                ["name"] = "Brother Karman",
                ["rep"] = FieldGuide.factions.theramore,
                ["map"] = FieldGuide.maps.dustwallow_marsh,
                ["x"] = 67.4,
                ["y"] = 47.4
            },
            [7] = {
                ["name"] = "Brother Sammuel",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 50.43,
                ["y"] = 42.12,
                ["noob"] = true
            },
            [8] = {
                ["name"] = "Brother Wilhelm",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 41.1,
                ["y"] = 66.0
            },
            [9] = {
                ["name"] = "Katherine the Pure",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 37.25,
                ["y"] = 31.92
            },
            [10] = {
                ["name"] = "Lord Grayson Shadowbreaker",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 37.14,
                ["y"] = 33.26
            },
            [11] = {
                ["name"] = "Valgar Highforge",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 23.7,
                ["y"] = 5.1
            }
        }
    },
    ["HUNTER"] = {
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Alenndaar Lapidaar",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.ashenvale,
                ["x"] = 18.0,
                ["y"] = 59.8
            },
            [2] = {
                ["name"] = "Ayanna Everstride",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 58.66,
                ["y"] = 40.45,
                ["noob"] = true
            },
            [3] = {
                ["name"] = "Daera Brightspear",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 70.97,
                ["y"] = 89.8
            },
            [4] = {
                ["name"] = "Danlaar Nightstride",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.ashenvale,
                ["x"] = 50.1,
                ["y"] = 68.0
            },
            [5] = {
                ["name"] = "Dargh Trueaim",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.loch_modan,
                ["x"] = 82.39,
                ["y"] = 62.4
            },
            [6] = {
                ["name"] = "Dazalar",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 56.68,
                ["y"] = 59.49
            },
            [7] = {
                ["name"] = "Dorion",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 42.21,
                ["y"] = 7.27
            },
            [8] = {
                ["name"] = "Einris Brightspear",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 61.58,
                ["y"] = 15.19
            },
            [9] = {
                ["name"] = "Grif Wildheart",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 45.81,
                ["y"] = 53.04
            },
            [10] = {
                ["name"] = "Jeen'ra Nightrunner",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 39.72,
                ["y"] = 5.38
            },
            [11] = {
                ["name"] = "Jocaste",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 40.38,
                ["y"] = 8.54
            },
            [12] = {
                ["name"] = "Kaerbrus",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.felwood,
                ["x"] = 61.9,
                ["y"] = 23.6
            },
            [13] = {
                ["name"] = "Olmin Burningbeard",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 70.89,
                ["y"] = 83.61
            },
            [14] = {
                ["name"] = "Regnus Thundergranite",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 69.87,
                ["y"] = 82.89
            },
            [15] = {
                ["name"] = "Thorfin Stoneshield",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 62.45,
                ["y"] = 14.97
            },
            [16] = {
                ["name"] = "Thorgas Grimson",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 29.18,
                ["y"] = 67.45,
                ["noob"] = true
            },
            [17] = {
                ["name"] = "Ulfir Ironbeard",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 61.92,
                ["y"] = 14.63
            }
        },
        ["HORDE"] = {
            [1] = {
                ["name"] = "Holt Thunderhorn",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 57.3,
                ["y"] = 89.79
            },
            [2] = {
                ["name"] = "Jen'shan",
                ["rep"] = FieldGuide.factions.darkspear_trolls,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 42.8,
                ["y"] = 69.3,
                ["noob"] = true
            },
            [3] = {
                ["name"] = "Kary Thunderhorn",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 58.49,
                ["y"] = 88.33
            },
            [4] = {
                ["name"] = "Kragg",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.stranglethorn_vale,
                ["x"] = 31.23,
                ["y"] = 28.68
            },
            [5] = {
                ["name"] = "Lanka Farshot",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 81.55,
                ["y"] = 10.76,
                ["noob"] = true
            },
            [6] = {
                ["name"] = "Ogromm",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.swamp_of_sorrows,
                ["x"] = 47.3,
                ["y"] = 53.4
            },
            [7] = {
                ["name"] = "Ormak Grimshot",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 66.05,
                ["y"] = 18.53
            },
            [8] = {
                ["name"] = "Sian'dur",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 67.96,
                ["y"] = 17.8
            },
            [9] = {
                ["name"] = "Thotar",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 51.9,
                ["y"] = 43.5
            },
            [10] = {
                ["name"] = "Urek Thunderhorn",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 59.13,
                ["y"] = 86.87
            },
            [11] = {
                ["name"] = "Xor'juul",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 67.24,
                ["y"] = 20.2
            },
            [12] = {
                ["name"] = "Yaw Sharpmane",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 47.82,
                ["y"] = 55.69
            }
        }
    },
    ["ROGUE"] = {
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Anishar",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 37.92,
                ["y"] = 20.92
            },
            [2] = {
                ["name"] = "Erion Shadewhisper",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 34.52,
                ["y"] = 25.93
            },
            [3] = {
                ["name"] = "Fenthwick",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 51.5,
                ["y"] = 15.33
            },
            [4] = {
                ["name"] = "Frahun Shadewhisper",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 59.64,
                ["y"] = 38.66,
                ["noob"] = true
            },
            [5] = {
                ["name"] = "Hogral Bakkan",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 47.56,
                ["y"] = 52.61
            },
            [6] = {
                ["name"] = "Hulfdan Blackbeard",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 51.96,
                ["y"] = 14.84
            },
            [7] = {
                ["name"] = "Jannok Breezesong",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 56.38,
                ["y"] = 60.14
            },
            [8] = {
                ["name"] = "Jorik Kerridan",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 50.31,
                ["y"] = 39.92,
                ["noob"] = true
            },
            [9] = {
                ["name"] = "Keryn Sylvius",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 43.9,
                ["y"] = 65.9
            },
            [10] = {
                ["name"] = "Lord Tony Romano",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 78.33,
                ["y"] = 57.05
            },
            [11] = {
                ["name"] = "Ormyr Flinteye",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 52.89,
                ["y"] = 15.01
            },
            [12] = {
                ["name"] = "Osborne the Night Man",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 74.64,
                ["y"] = 52.82
            },
            [13] = {
                ["name"] = "Solm Hargrin",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 28.37,
                ["y"] = 67.51,
                ["noob"] = true
            },
            [14] = {
                ["name"] = "Syurna",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 36.99,
                ["y"] = 21.91
            },
            [15] = {
                ["name"] = "Ian Strom",
                ["rep"] = FieldGuide.factions.booty_bay,
                ["map"] = FieldGuide.maps.stranglethorn_vale,
                ["x"] = 26.82,
                ["y"] = 77.15
            }
        },
        ["HORDE"] = {
            [1] = {
                ["name"] = "Carolyn Ward",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 83.86,
                ["y"] = 72.07
            },
            [2] = {
                ["name"] = "David Trias",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 32.53,
                ["y"] = 65.65
            },
            [3] = {
                ["name"] = "Gest",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 42.69,
                ["y"] = 51.48
            },
            [4] = {
                ["name"] = "Gregory Charles",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 84.88,
                ["y"] = 73.53
            },
            [5] = {
                ["name"] = "Kaplak",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 52.0,
                ["y"] = 43.7
            },
            [6] = {
                ["name"] = "Marion Call",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 61.75,
                ["y"] = 52.0
            },
            [7] = {
                ["name"] = "Miles Dexter",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 85.21,
                ["y"] = 71.57
            },
            [8] = {
                ["name"] = "Ormok",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 43.9,
                ["y"] = 54.63
            },
            [9] = {
                ["name"] = "Rwag",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 66.79,
                ["y"] = 32.58,
                ["noob"] = true
            },
            [10] = {
                ["name"] = "Shenthul",
                ["rep"] = FieldGuide.factions.darkspear_trolls,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 43.05,
                ["y"] = 53.74
            },
            [11] = {
                ["name"] = "Ian Strom",
                ["rep"] = FieldGuide.factions.booty_bay,
                ["map"] = FieldGuide.maps.stranglethorn_vale,
                ["x"] = 26.82,
                ["y"] = 77.15
            }
        }
    },
    ["PRIEST"] = {
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Astarii Starseeker",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 38.33,
                ["y"] = 80.95
            },
            [2] = {
                ["name"] = "Braenna Flintcrag",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 24.42,
                ["y"] = 9.17
            },
            [3] = {
                ["name"] = "Branstock Khalder",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 28.6,
                ["y"] = 66.39,
                ["noob"] = true
            },
            [4] = {
                ["name"] = "Brother Benjamin",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 42.13,
                ["y"] = 30.0
            },
            [5] = {
                ["name"] = "Brother Joshua",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 38.5,
                ["y"] = 26.79
            },
            [6] = {
                ["name"] = "High Priest Rohan",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 23.23,
                ["y"] = 7.19
            },
            [7] = {
                ["name"] = "High Priestess Laurena",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 38.58,
                ["y"] = 26.01
            },
            [8] = {
                ["name"] = "Jandria",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 37.89,
                ["y"] = 82.74
            },
            [9] = {
                ["name"] = "Lariia",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 40.35,
                ["y"] = 88.68
            },
            [10] = {
                ["name"] = "Laurna Morninglight",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 55.56,
                ["y"] = 56.75
            },
            [11] = {
                ["name"] = "Maxan Anvol",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 47.34,
                ["y"] = 52.19
            },
            [12] = {
                ["name"] = "Nara Meideros",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 20.68,
                ["y"] = 50.11
            },
            [13] = {
                ["name"] = "Priestess Alathea",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 39.52,
                ["y"] = 81.2
            },
            [14] = {
                ["name"] = "Priestess Anetta",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 49.81,
                ["y"] = 39.49,
                ["noob"] = true
            },
            [15] = {
                ["name"] = "Priestess Josetta",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 43.3,
                ["y"] = 65.7
            },
            [16] = {
                ["name"] = "Shanda",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 59.17,
                ["y"] = 40.44,
                ["noob"] = true
            },
            [17] = {
                ["name"] = "Theodrus Frostbeard",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 24.08,
                ["y"] = 8.41
            },
            [18] = {
                ["name"] = "Toldren Deepiron",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 25.21,
                ["y"] = 10.76
            }
        },
        ["HORDE"] = {
            [1] = {
                ["name"] = "Dark Cleric Beryl",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 61.57,
                ["y"] = 52.19
            },
            [2] = {
                ["name"] = "Dark Cleric Duesten",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 31.11,
                ["y"] = 66.03,
                ["noob"] = true
            },
            [3] = {
                ["name"] = "Father Cobb",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 25.64,
                ["y"] = 20.7
            },
            [4] = {
                ["name"] = "Father Lankester",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 49.14,
                ["y"] = 14.61
            },
            [5] = {
                ["name"] = "Father Lazarus",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 47.57,
                ["y"] = 18.9
            },
            [6] = {
                ["name"] = "Ken'jai",
                ["rep"] = FieldGuide.factions.darkspear_trolls,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 42.4,
                ["y"] = 68.8,
                ["noob"] = true
            },
            [7] = {
                ["name"] = "Malakai Cross",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 24.56,
                ["y"] = 22.57
            },
            [8] = {
                ["name"] = "Miles Welsh",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 25.32,
                ["y"] = 15.27
            },
            [9] = {
                ["name"] = "Tai'jin",
                ["rep"] = FieldGuide.factions.darkspear_trolls,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 54.3,
                ["y"] = 42.9
            },
            [10] = {
                ["name"] = "Ur'kyo",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 35.59,
                ["y"] = 87.82
            },
            [11] = {
                ["name"] = "X'yera",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 36.01,
                ["y"] = 87.73
            }
        } 
    },
    ["SHAMAN"] = {
        ["HORDE"] = {
            [1] = {
                ["name"] = "Beram Skychaser",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 21.99,
                ["y"] = 18.8
            },
            [2] = {
                ["name"] = "Haromm",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.swamp_of_sorrows,
                ["x"] = 48.2,
                ["y"] = 57.9
            },
            [3] = {
                ["name"] = "Kardris Dreamseeker",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 38.8,
                ["y"] = 36.37
            },
            [4] = {
                ["name"] = "Meela Dawnstrider",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 45.0,
                ["y"] = 75.9,
                ["noob"] = true
            },
            [5] = {
                ["name"] = "Narm Skychaser",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 48.38,
                ["y"] = 59.15
            },
            [6] = {
                ["name"] = "Sagorne Creststrider",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 38.66,
                ["y"] = 35.92
            },
            [7] = {
                ["name"] = "Shikrik",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 42.4,
                ["y"] = 69.0,
                ["noob"] = true
            },
            [8] = {
                ["name"] = "Sian'tsu",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 37.84,
                ["y"] = 36.45
            },
            [9] = {
                ["name"] = "Siln Skychaser",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 22.82,
                ["y"] = 21.12
            },
            [10] = {
                ["name"] = "Swart",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 54.4,
                ["y"] = 42.6
            },
            [11] = {
                ["name"] = "Tigor Skychaser",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 23.64,
                ["y"] = 18.79
            }
        }
    },
    ["MAGE"] = { -- Naela Trance <Bowyer> <- wtf
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Bink",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 27.25,
                ["y"] = 8.3
            },
            [2] = {
                ["name"] = "Dink",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 27.16,
                ["y"] = 8.57
            },
            [3] = {
                ["name"] = "Elsharin",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 36.88,
                ["y"] = 81.23
            },
            [4] = {
                ["name"] = "Jennea Cannon",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 38.54,
                ["y"] = 79.34
            },
            [5] = {
                ["name"] = "Juli Stormkettle",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 26.3,
                ["y"] = 6.77
            },
            [6] = {
                ["name"] = "Khelden Bremen",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 49.66,
                ["y"] = 39.4,
                ["noob"] = true
            },
            [7] = {
                ["name"] = "Maginor Dumas",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 38.19,
                ["y"] = 81.79
            },
            [8] = {
                ["name"] = "Magis Sparkmantle",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 47.5,
                ["y"] = 52.08
            },
            [9] = {
                ["name"] = "Marryk Nurribit",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 28.71,
                ["y"] = 66.37,
                ["noob"] = true
            },
            [10] = {
                ["name"] = "Nittlebur Sparkfizzle",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 25.93,
                ["y"] = 6.17
            },
            [11] = {
                ["name"] = "Theocritus",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 65.22,
                ["y"] = 69.71
            },
            [12] = {
                ["name"] = "Zaldimar Wefhellt",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 43.3,
                ["y"] = 66.2
            }
        },
        ["HORDE"] = {
            [1] = {
                ["name"] = "Anastasia Hartwell",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 85.14,
                ["y"] = 10.03
            },
            [2] = {
                ["name"] = "Archmage Shymm",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 22.76,
                ["y"] = 14.53
            },
            [3] = {
                ["name"] = "Cain Firesong",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 61.97,
                ["y"] = 52.47
            },
            [4] = {
                ["name"] = "Deino",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 38.45,
                ["y"] = 86.13
            },
            [5] = {
                ["name"] = "Enyo",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 38.78,
                ["y"] = 85.67
            },
            [6] = {
                ["name"] = "Isabella",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 30.93,
                ["y"] = 66.06,
                ["noob"] = true
            },
            [7] = {
                ["name"] = "Mai'ah",
                ["rep"] = FieldGuide.factions.darkspear_trolls,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 42.5,
                ["y"] = 69.0,
                ["noob"] = true
            },
            [8] = {
                ["name"] = "Pephredo",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 38.35,
                ["y"] = 85.56
            },
            [9] = {
                ["name"] = "Pierce Shackleton",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 85.45,
                ["y"] = 13.51
            },
            [10] = {
                ["name"] = "Thurston Xane",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 25.18,
                ["y"] = 20.96
            },
            [11] = {
                ["name"] = "Un'Thuwa",
                ["rep"] = FieldGuide.factions.darkspear_trolls,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 56.3,
                ["y"] = 75.1
            },
            [12] = {
                ["name"] = "Ursyn Ghull",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 25.7,
                ["y"] = 14.19
            },
            [13] = {
                ["name"] = "Uthel'nay",
                ["rep"] = FieldGuide.factions.darkspear_trolls,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 39.16,
                ["y"] = 86.27
            }
        }
    },
    ["WARLOCK"] = {
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Alamar Grimm",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 28.65,
                ["y"] = 66.14,
                ["noob"] = true
            },
            [2] = {
                ["name"] = "Alexander Calder",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 50.08,
                ["y"] = 7.45
            },
            [3] = {
                ["name"] = "Briarthorn",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 50.35,
                ["y"] = 5.66
            },
            [4] = {
                ["name"] = "Demisette Cloyce",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 25.28,
                ["y"] = 78.22
            },
            [5] = {
                ["name"] = "Drusilla La Salle",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 49.87,
                ["y"] = 42.65,
                ["noob"] = true
            },
            [6] = {
                ["name"] = "Gimrizz Shadowcog",
                ["rep"] = FieldGuide.factions.gnomeregan_exiles,
                ["map"] = FieldGuide.maps.dun_morogh,
                ["x"] = 47.33,
                ["y"] = 53.69
            },
            [7] = {
                ["name"] = "Maximillian Crowe",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.elwynn_forest,
                ["x"] = 44.4,
                ["y"] = 66.2
            },
            [8] = {
                ["name"] = "Sandahl",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 25.82,
                ["y"] = 79.23
            },
            [9] = {
                ["name"] = "Thistleheart",
                ["rep"] = FieldGuide.factions.ironforge,
                ["map"] = FieldGuide.maps.ironforge,
                ["x"] = 51.09,
                ["y"] = 6.61
            },
            [10] = {
                ["name"] = "Ursula deline",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 26.12,
                ["y"] = 77.22
            },
        },
        ["HORDE"] = {
            [1] = {
                ["name"] = "Dhugru Gorelust",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 54.4,
                ["y"] = 41.2
            },
            [2] = {
                ["name"] = "Grol'dar",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 47.98,
                ["y"] = 45.93
            },
            [3] = {
                ["name"] = "Kaal Soulreaper",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 86.21,
                ["y"] = 15.93
            },
            [4] = {
                ["name"] = "Kartosh",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.swamp_of_sorrows,
                ["x"] = 48.65,
                ["y"] = 55.64
            },
            [5] = {
                ["name"] = "Luther Pickman",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 86.43,
                ["y"] = 15.25
            },
            [6] = {
                ["name"] = "Maximillion",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 30.91,
                ["y"] = 66.34,
                ["noob"] = true
            },
            [7] = {
                ["name"] = "Mirket",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 48.62,
                ["y"] = 46.95
            },
            [8] = {
                ["name"] = "Nartok",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.durotar,
                ["x"] = 40.6,
                ["y"] = 68.5
            },
            [9] = {
                ["name"] = "Richard Kerwin",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.undercity,
                ["x"] = 88.91,
                ["y"] = 15.86
            },
            [10] = {
                ["name"] = "Rupert Boch",
                ["rep"] = FieldGuide.factions.undercity,
                ["map"] = FieldGuide.maps.tirisfal_glades,
                ["x"] = 61.59,
                ["y"] = 52.4
            },
            [11] = {
                ["name"] = "Zevrost",
                ["rep"] = FieldGuide.factions.orgrimmar,
                ["map"] = FieldGuide.maps.orgrimmar,
                ["x"] = 48.47,
                ["y"] = 45.43
            }
        }
    },
    ["DRUID"] = {
        ["ALLIANCE"] = {
            [1] = {
                ["name"] = "Denatharion",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 34.77,
                ["y"] = 7.37
            },
            [2] = {
                ["name"] = "Fylerian Nightwing",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 33.51,
                ["y"] = 8.35
            },
            [3] = {
                ["name"] = "Golhine the Hooded",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.felwood,
                ["x"] = 61.9,
                ["y"] = 24.5
            },
            [4] = {
                ["name"] = "Kal",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 55.95,
                ["y"] = 61.56
            },
            [5] = {
                ["name"] = "Maldryn",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 19.08,
                ["y"] = 52.67
            },
            [6] = {
                ["name"] = "Mardant Strongoak",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.teldrassil,
                ["x"] = 58.63,
                ["y"] = 40.29,
                ["noob"] = true
            },
            [7] = {
                ["name"] = "Mathrengyl Bearwalker",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.darnassus,
                ["x"] = 35.37,
                ["y"] = 8.4
            },
            [8] = {
                ["name"] = "Sheldras Moontree",
                ["rep"] = FieldGuide.factions.stormwind,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 20.89,
                ["y"] = 55.46
            },
            [9] = {
                ["name"] = "Theridran",
                ["rep"] = FieldGuide.factions.darnassus,
                ["map"] = FieldGuide.maps.stormwind,
                ["x"] = 21.24,
                ["y"] = 51.67
            },
            [10] = {
                ["name"] = "Loganaar",
                ["rep"] = FieldGuide.factions.cenarion_circle,
                ["map"] = FieldGuide.maps.moonglade,
                ["x"] = 52.5,
                ["y"] = 40.6
            }
        },
        ["HORDE"] = {
            [1] = {
                ["name"] = "Gart Mistrunner",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 45.1,
                ["y"] = 75.9,
                ["noob"] = true
            },
            [2] = {
                ["name"] = "Gennia Runetotem",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.mulgore,
                ["x"] = 48.48,
                ["y"] = 59.64
            },
            [3] = {
                ["name"] = "Jannos Lighthoof",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.feralas,
                ["x"] = 75.99,
                ["y"] = 42.28
            },
            [4] = {
                ["name"] = "Kym Wildmane",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 77.15,
                ["y"] = 29.82
            },
            [5] = {
                ["name"] = "Sheal Runetotem",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 77.14,
                ["y"] = 27.02
            },
            [6] = {
                ["name"] = "Turak Runetotem",
                ["rep"] = FieldGuide.factions.thunder_bluff,
                ["map"] = FieldGuide.maps.thunder_bluff,
                ["x"] = 76.48,
                ["y"] = 27.22
            },
            [7] = {
                ["name"] = "Loganaar",
                ["rep"] = FieldGuide.factions.cenarion_circle,
                ["map"] = FieldGuide.maps.moonglade,
                ["x"] = 52.5,
                ["y"] = 40.6
            }
        }
    }
}
