--------------------------------------------------------------------------
-- GTFO_Spells_LGN.lua 
--------------------------------------------------------------------------
--[[
GTFO Spell List - Legion
]]--

if (not GTFO.ClassicMode) then

--- ********************
--- * The Broken Isles *
--- ********************

GTFO.SpellID["226512"] = {
  --desc = "Sanguine Ichor (Mythic+ Keystone)";
  sound = 1;
};

GTFO.SpellID["203114"] = {
  --desc = "Twilight Whirl (Twilight Bladetwister)";
  sound = 1;
};

GTFO.SpellID["193009"] = {
  --desc = "The Jailer's Prison (Niskaran Executioner)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["206702"] = {
  --desc = "Choking Fog";
  sound = 1;
};

GTFO.SpellID["219044"] = {
  --desc = "Ennervating Field (Senegos Drawing)";
  applicationOnly = true;
  sound = 2;
};

GTFO.SpellID["208069"] = {
  --desc = "Arrow Barrage (Nathanos Blightcaller)";
  sound = 1;
  tankSound = 2;
};

GTFO.SpellID["190364"] = {
  --desc = "Plague-Dipped Arrows (Nathanos Blightcaller)";
  sound = 1;
};

GTFO.SpellID["180675"] = {
  --desc = "Guardian Gaze (Vault Guardian)";
  sound = 1;
};

GTFO.SpellID["195824"] = {
  --desc = "Lightforged Defense Matrix (Yotnar)";
  sound = 1;
};

GTFO.SpellID["187117"] = {
  --desc = "Static Charge";
  sound = 1;
};

GTFO.SpellID["193907"] = {
  --desc = "Fel Winds (Fel Commander Igrius)";
  sound = 1;
};

GTFO.SpellID["202809"] = {
  --desc = "Fury of the Illidari (Varedis Felsoul)";
  sound = 1;
};

GTFO.SpellID["192754"] = {
  --desc = "Nightmare Breath (Ysera)";
  sound = 1;
};

GTFO.SpellID["220053"] = {
  --desc = "Conductive Charge (Akama)";
  sound = 1;
};

GTFO.SpellID["215604"] = {
  --desc = "Dragon's Breath (Vision of Deathwing)";
  sound = 1;
};

GTFO.SpellID["191187"] = {
  --desc = "Storm Nova (Swirling Storms)";
  sound = 2;
};

GTFO.SpellID["212203"] = {
  --desc = "Fusion Press (Mimiron)";
  sound = 1;
};

GTFO.SpellID["212016"] = {
  --desc = "Lightning Bolt (Prustaga)";
  sound = 1;
};

GTFO.SpellID["190620"] = {
  --desc = "Felblaze Orb (Fel Orb)";
  sound = 2;
  tankSound = 0;
};

GTFO.SpellID["182815"] = {
  --desc = "Stoneblood Poison (Stoneblood Elderwitch)";
  applicationOnly = true;
	minimumStacks = 1;
	sound = 1;
};

GTFO.SpellID["186227"] = {
  --desc = "Raging Fire (Heathrow House)";
  sound = 1;
};

GTFO.SpellID["186237"] = {
  --desc = "Raging Fire (Heathrow House)";
  sound = 1;
};

GTFO.SpellID["215707"] = {
  --desc = "Burning (Tenpak Flametotem)";
  sound = 1;
};

GTFO.SpellID["214421"] = {
  --desc = "Searing Gaze (Inquisitor Tivos)";
  sound = 1;
};

GTFO.SpellID["222136"] = {
  --desc = "Corrosive Maw";
  sound = 1;
};

GTFO.SpellID["218866"] = {
  --desc = "Plagued Ground";
  sound = 1;
};

GTFO.SpellID["210584"] = {
  --desc = "Holy Ground";
  sound = 1;
};

GTFO.SpellID["219859"] = {
  --desc = "Claw Flurry (Bahagar)";
  sound = 1;
};

GTFO.SpellID["216498"] = {
  --desc = "Energy Smash (Orbyth)";
  sound = 1;
};

GTFO.SpellID["216495"] = {
  --desc = "Energy Smash (Orbyth)";
  sound = 1;
};

GTFO.SpellID["208639"] = {
  --desc = "Echo (Nameless King)";
  sound = 1;
};

GTFO.SpellID["219173"] = {
  --desc = "Echo (Nameless King)";
  sound = 1;
};

GTFO.SpellID["211022"] = {
  --desc = "Echo (Nameless King)";
  sound = 1;
};

GTFO.SpellID["219177"] = {
  --desc = "Echo (Nameless King)";
  sound = 1;
};

GTFO.SpellID["217529"] = {
  --desc = "Overflowing Taint (Infernal Lord)";
  sound = 1;
};

GTFO.SpellID["216149"] = {
  --desc = "Barrage (Huntress Estrid)";
  sound = 1;
};

GTFO.SpellID["219120"] = {
  --desc = "Doomfire (Archimonde)";
  sound = 1;
};

GTFO.SpellID["214491"] = {
  --desc = "Hindering Anomaly";
  sound = 1;
};

GTFO.SpellID["214123"] = {
  --desc = "Translocate Field (Arcavellus)";
  sound = 1;
};

GTFO.SpellID["225682"] = {
  --desc = "Furious Swipes (Bahagar)";
  sound = 1;
};

GTFO.SpellID["215717"] = {
  --desc = "Murky Secretion (Congealed Corruption)";
  sound = 1;
};

GTFO.SpellID["155865"] = {
  --desc = "Ravaging Whirl (Urgev the Flayer)";
  sound = 1;
};

GTFO.SpellID["220478"] = {
  --desc = "Boil Back (Boilback Bristlefur)";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["204478"] = {
  --desc = "Spray Plague (Forsaken Plaguebringer)";
  sound = 1;
};

GTFO.SpellID["206564"] = {
  --desc = "Fel Storm (Eredar Portal-Lord)";
  sound = 1;
};

GTFO.SpellID["202544"] = {
  --desc = "Burning Rush (Herald Xarbizuld)";
  sound = 1;
};

GTFO.SpellID["169002"] = {
  --desc = "Torrent of Blades (Legion Battlematron)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["206777"] = {
  --desc = "Nightmare Void";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["209008"] = {
  --desc = "Fel Firestorm (Destromath)";
  sound = 1;
};

GTFO.SpellID["199568"] = {
  --desc = "Grasping Spirits";
  sound = 1;
};

GTFO.SpellID["201832"] = {
  --desc = "Fel Immolation (Ariden)";
  sound = 1;
};

GTFO.SpellID["215876"] = {
  --desc = "Burning Earth (Shar'thos)";
  sound = 1;
};

GTFO.SpellID["231948"] = {
  --desc = "Arcfence";
  sound = 1;
};

GTFO.SpellID["222405"] = {
  --desc = "Solar Radiance (Kobold Drawing)";
  sound = 1;
  alwaysAlert = true;
  ignoreApplication = true;
};

GTFO.SpellID["219032"] = {
  --desc = "Arcane Breath (Senegos Drawing)";
  sound = 1;
  tankSound = 2;
};

GTFO.SpellID["216476"] = {
  --desc = "Blizzard (Humongris)";
  sound = 1;
};

GTFO.SpellID["215921"] = {
  --desc = "Guardian Nova (Guardian Orb)";
  sound = 1;
};

GTFO.SpellID["202704"] = {
  --desc = "Defiled Consecration (Eredar Enforcer)";
  sound = 1;
};

GTFO.SpellID["217907"] = {
  --desc = "Wrathful Flames (Calamir)";
  sound = 1;
};

GTFO.SpellID["242873"] = {
  --desc = "The Felstorm";
  sound = 1;
};

GTFO.SpellID["239085"] = {
  --desc = "Shadow Conduit (Lord Kalgorath)";
  sound = 1;
};

GTFO.SpellID["237671"] = {
  --desc = "Fel-Fire Ejection (Fel Fire Ejector 1-Piece)";
  sound = 1;
};

GTFO.SpellID["239180"] = {
  --desc = "Fel Burn";
  sound = 1;
};

GTFO.SpellID["239176"] = {
  --desc = "Rain of Fire (Fel Commander Erixtol)";
  sound = 1;
};

GTFO.SpellID["240865"] = {
  --desc = "Sentinax Destruction Zone";
  sound = 1;
};

GTFO.SpellID["233850"] = {
  --desc = "Virulent Infection";
  sound = 1;
};

GTFO.SpellID["239863"] = {
  --desc = "A Mother's Love (Mother Mirenda)";
  sound = 1;
};

GTFO.SpellID["233868"] = {
  --desc = "Fel Fire";
  sound = 1;
};

GTFO.SpellID["209931"] = {  
	--desc = "Watery Globules (Lady Zithreen)";
	sound = 1;
};

GTFO.SpellID["247307"] = {
  --desc = "Volatile Vials (Apothecary Tillings)";
  sound = 1;
};

-- Inflicts Shadow damage to any enemies within an area every 1 sec.
GTFO.SpellID["246941"] = {
  --desc = "Looming Shadows";
  sound = 1;
};

GTFO.SpellID["248591"] = {
  --desc = "Tangled Web (Nezar'Azret)";
  sound = 1;
};

GTFO.SpellID["248599"] = {
  --desc = "Lava (Fiery Behemoth)";
  sound = 1;
};

GTFO.SpellID["52117"] = {
  --desc = "Pulsing Shards (Iceshatter)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["234422"] = {
  --desc = "Aura of Decay (Inquisitor Variss)";
  applicationOnly = true;
	minimumStacks = 3;
  sound = 2;
};

GTFO.SpellID["199349"] = {
  --desc = "Fel Flames";
  sound = 1;
};

GTFO.SpellID["234441"] = {
  --desc = "Shadow Sweep";
  sound = 2;
};

GTFO.SpellID["234675"] = {
  --desc = "Netherstomp";
  sound = 1;
};

GTFO.SpellID["243091"] = {
  --desc = "Fel Lava";
  sound = 1;
};

GTFO.SpellID["236161"] = {
  --desc = "Plague Zone";
  sound = 1;
};

GTFO.SpellID["235263"] = {
  --desc = "Fel Lava";
  sound = 1;
};

GTFO.SpellID["238443"] = {
  --desc = "Gas Cloud";
  sound = 1;
};



-- **********
-- * Mardum *
-- **********

GTFO.SpellID["194811"] = {
	--desc = "Fel Beam";
	sound = 2;
};

GTFO.SpellID["200511"] = {
	--desc = "Anguished Soul (Anguish Jailer)";
	sound = 1;
};

GTFO.SpellID["195054"] = {
	--desc = "Beaming Gaze (Inquisitor Baleful)";
	sound = 1;
};

GTFO.SpellID["195401"] = {
	--desc = "Shadow Blaze (Doom Commander Beliash)";
	sound = 1;
};

GTFO.SpellID["192603"] = {
	--desc = "Spire of Woe (Doom Commander Beliash)";
	sound = 1;
};

GTFO.SpellID["197747"] = {
	--desc = "Fel Burning (General Volroth)";
	sound = 1;
};

GTFO.SpellID["197243"] = {
  --desc = "Gaseous Cloud (Prolifica)";
  sound = 1;
};

GTFO.SpellID["197609"] = {
  --desc = "Demon's Blood (Brood Queen Tyranna)";
  sound = 1;
};

GTFO.SpellID["224679"] = {
  --desc = "Condensed Fel Energy (Vizuul the Twisted)";
  sound = 1;
};

-- ************************
-- * Vault of the Wardens *
-- ************************

GTFO.SpellID["201037"] = {
  --desc = "Seeping Shadows (Kethrazor)";
  sound = 1;
};

GTFO.SpellID["214625"] = {
  --desc = "Fel Chain (Tirathon Saltheril)";
  sound = 1;
};

GTFO.SpellID["196502"] = {
  --desc = "Lingering Gaze (Glazer)";
  sound = 2;
};

GTFO.SpellID["191853"] = {
  --desc = "Furious Flames (Tirathon Saltheril)";
  sound = 1;
};

GTFO.SpellID["216319"] = {
  --desc = "A Mother's Love (Grimoira)";
  sound = 1;
};

GTFO.SpellID["222631"] = {
  --desc = "Chaos Pyre (Lysanis Shadesoul)";
  sound = 1;
};

GTFO.SpellID["199229"] = {
  --desc = "Fel Fire Wall";
  sound = 1;
};

GTFO.SpellID["211834"] = {
  --desc = "Hellfire";
  sound = 1;
};

GTFO.SpellID["238691"] = {
  --desc = "Spear of Vengeance";
  sound = 1;
};


-- ********************
-- * The Broken Shore *
-- ********************


GTFO.SpellID["211195"] = {
  --desc = "Burn (Captain Naranoth)";
  sound = 1;
};

GTFO.SpellID["183623"] = {
  --desc = "Felsoul Inferno";
  sound = 1;
};

GTFO.SpellID["222588"] = {
  --desc = "Fel Immolation (Infernal Siegebreaker)";
  sound = 1;
};

GTFO.SpellID["183737"] = {
  --desc = "Felblaze (Felblaze Infernal)";
  sound = 1;
};

GTFO.SpellID["234636"] = {
  --desc = "Fel Discharge";
  sound = 1;
};


-- *********************
-- * Darkheart Thicket *
-- *********************

GTFO.SpellID["198408"] = {
  --desc = "Nightfall (Archdruid Glaidalis)";
  sound = 1;
};

GTFO.SpellID["218759"] = {
  --desc = "Corruption Pool (Festerhide Grizzly)";
  sound = 1;
};

GTFO.SpellID["191326"] = {
  --desc = "Breath of Corruption (Dresaron)";
  sound = 1;
  test = true;
};

GTFO.SpellID["199460"] = {
  --desc = "Falling Rocks (Dresaron)";
  sound = 1;
};

GTFO.SpellID["204976"] = {
  --desc = "Noxious Spit (Kudzilla)";
  sound = 1;
};



-- ******************
-- * Eye of Azshara *
-- ******************

GTFO.SpellID["196871"] = {
  --desc = "Storm (Hatecoil Stormweaver)";
  sound = 1;
};

GTFO.SpellID["192053"] = {
  --desc = "Quicksand (Warlord Parjesh)";
  sound = 1;
};

GTFO.SpellID["199948"] = {
  --desc = "Tempest (Channeler Varisz)";
  sound = 1;
};

GTFO.SpellID["195473"] = {
  --desc = "Abrasive Slime (Gritslime Snail)";
  sound = 1;
  applicationOnly = true;
};

GTFO.SpellID["191858"] = {
  --desc = "Toxic Puddle (Serpentrix)";
  sound = 1;
};

GTFO.SpellID["193055"] = {
  --desc = "Call the Seas (Call the Seas)";
  sound = 1;
  negatingDebuffSpellID = 193018; -- Gaseous Bubbles
};

-- *********************
-- * Neltharion's Lair *
-- *********************

GTFO.SpellID["183407"] = {
  --desc = "Acid Splatter";
  soundFunction = function() -- Warn only on multiple hits to keep it from being too spammy
		if (GTFO_FindEvent("AcidSplatter")) then
			return 1;
		end
		GTFO_AddEvent("AcidSplatter", 1);
		return 0;
	end
};

GTFO.SpellID["192800"] = {
  --desc = "Choking Dust (Rokmora)";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["183566"] = {
  --desc = "Rancid Pool (Tarspitter Lurker)";
  sound = 1;
};

GTFO.SpellID["186576"] = {
  --desc = "Petrifying Cloud";
  applicationOnly = true;
  sound = 1;
  test = true; -- Doesn't appear to be restricted to application only for some reason
};

GTFO.SpellID["188494"] = {
  --desc = "Rancid Maw (Naraxas)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["226388"] = {
  --desc = "Rancid Ooze";
  sound = 1;
};

GTFO.SpellID["188493"] = {
  --desc = "Rancid Maw (Naraxas)";
  sound = 1;
};

GTFO.SpellID["210166"] = {
  --desc = "Toxic Wretch (Naraxas)";
  sound = 1;
};

GTFO.SpellID["217090"] = {
  --desc = "Magma Wave (Dargrul)";
  sound = 1;
};

-- *************
-- * The Nexus *
-- *************

GTFO.SpellID["209848"] = {
  --desc = "Icicle Barrage (Scion of Ice)";
  sound = 1;
};

GTFO.SpellID["207556"] = {
  --desc = "Heated Ground";
  sound = 1;
};

GTFO.SpellID["209839"] = {
  --desc = "Burning Diffusion (Diffusion)";
  sound = 1;
};

-- ******************
-- * Halls of Valor *
-- ******************

GTFO.SpellID["198903"] = {
  --desc = "Crackling Storm (Storm Drake)";
  sound = 1;
};

GTFO.SpellID["193234"] = {
  --desc = "Dancing Blade (Hymdall)";
  sound = 1;
};

GTFO.SpellID["199818"] = {
  --desc = "Crackle (Valarjar Thundercaller)";
  sound = 1;
};

GTFO.SpellID["200682"] = {
  --desc = "Eye of the Storm (Solsten)";
  sound = 1;
  negatingDebuffSpellID = 203963; -- Eye of the Storm
};

GTFO.SpellID["193702"] = {
  --desc = "Infernal Flames (God-King Skovald)";
  sound = 1;
};

GTFO.SpellID["193827"] = {
  --desc = "Ragnarok (God-King Skovald)";
  sound = 1;
};

-- *******************
-- * The Violet Hold *
-- *******************

GTFO.SpellID["205014"] = {
  --desc = "Seeping Shadows (Lord Malgath)";
  sound = 1;
};

GTFO.SpellID["205014"] = {
  --desc = "Frost Breath (Shivermaw)";
  sound = 1;
  tankSound = 0;
  applicationOnly = true;
};

GTFO.SpellID["201957"] = {
  --desc = "Frostbite (Shivermaw)";
  sound = 1;
};

GTFO.SpellID["204762"] = {
  --desc = "Violent Fel Energy (Portal Keeper)";
  sound = 1;
};

GTFO.SpellID["202266"] = {
  --desc = "Icky Goo (Festerface)";
  sound = 1;
};



-- **************
-- * The Arcway *
-- **************

-- TODO: Suppression Protocol (Corstilax)
-- TODO: Force Nova (Advisor Vandros)
-- TODO: Unstable Mana (Advisor Vandros) - FF when not the target

GTFO.SpellID["194006"] = {
  --desc = "Ooze Puddle (Unstable Amalgamation)";
  sound = 1;
};

GTFO.SpellID["200040"] = {
  --desc = "Nether Venom (Nal'tira)";
  sound = 1;
};

GTFO.SpellID["199812"] = {
  --desc = "Blink Strikes (Nal'tira)";
  sound = 1;
};

GTFO.SpellID["210750"] = {
  --desc = "Collapsing Rift (Withered Manawraith)";
  sound = 1;
};

GTFO.SpellID["220500"] = {
  --desc = "Destabilized Orb (Corstilax)";
  sound = 1;
};

GTFO.SpellID["211209"] = {
  --desc = "Arcane Slicer (Arcane Anomaly)";
  sound = 1;
};

GTFO.SpellID["196824"] = {
  --desc = "Nether Link (Ivanyr)";
  sound = 1;
};

GTFO.SpellID["220597"] = {
  --desc = "Charged Bolt (Ivanyr)";
  sound = 1;
};

GTFO.SpellID["211745"] = {
  --desc = "Fel Strike (Wrathguard Felblade)";
  sound = 1;
};

GTFO.SpellID["220443"] = {
  --desc = "Wake of Shadows (General Xakal)";
  sound = 1;
};


-- ****************
-- * Maw of Souls *
-- ****************

GTFO.SpellID["216107"] = {
  --desc = "Convulsive Shadows (Shroudseeker)";
  sound = 1;
};

GTFO.SpellID["194102"] = {
  --desc = "Poisonous Sludge (The Grimewalker)";
  sound = 1;
};

GTFO.SpellID["195035"] = {
  --desc = "Defiant Strike - Charge (Seacursed Soulkeeper)";
  sound = 1;
};

GTFO.SpellID["194235"] = {
  --desc = "Nether Rip (Harbaron)";
  sound = 1;
};

GTFO.SpellID["227234"] = {
  --desc = "Corrupted Bellow (Helya)";
  sound = 1;
};

-- ******************
-- * Court of Stars *
-- ******************

GTFO.SpellID["207278"] = {
	--desc = "Arcane Lockdown (Patrol Captain Gerdo)";
	test = true;
	alwaysAlert = true;
	soundFunction = function() 
		-- Alert if hit more than 3 times
		if (not GTFO.VariableStore.ArcaneLockdownHitCount) then
			GTFO.VariableStore.ArcaneLockdownHitCount = 0;
			GTFO.VariableStore.ArcaneLockdownStackCount = 0;
		end
		GTFO_AddEvent("ResetArcaneLockdownCounter", 5, function() GTFO.VariableStore.ArcaneLockdownHitCount = 0; GTFO.VariableStore.ArcaneLockdownStackCount = 0; end);
		GTFO.VariableStore.ArcaneLockdownHitCount = GTFO.VariableStore.ArcaneLockdownHitCount + 1;
		local stackCount = GTFO_DebuffStackCount("player", 207278);
		if (GTFO.VariableStore.ArcaneLockdownStackCount == stackCount) then
			if (GTFO.VariableStore.ArcaneLockdownHitCount > 2) then
				return 1;
			end			
		else
			GTFO.VariableStore.ArcaneLockdownStackCount = stackCount;
			if (stackCount < 3) then			
				GTFO.VariableStore.ArcaneLockdownHitCount = 1;
			end
		end
	end;
};

GTFO.SpellID["209027"] = {
  --desc = "Disrupting Energy (Guardian Construct)";
  sound = 1;
};

GTFO.SpellID["211391"] = {
  --desc = "Felblaze Puddle (Legion Hound)";
  sound = 1;
};

-- ************************
-- * Vault of the Wardens *
-- ************************

-- TODO: Tormenting Orb (Inquisitor Tormentorum)

GTFO.SpellID["202862"] = {
  --desc = "Hatred (Tirathon Saltheril)";
  sound = 1;
};

GTFO.SpellID["202919"] = {
  --desc = "Furious Flames (Tirathon Saltheril)";
  sound = 1;
};

GTFO.SpellID["194071"] = {
  --desc = "A Mother's Love (Foul Mother)";
  sound = 1;
};

GTFO.SpellID["199916"] = {
  --desc = "Shadow Crash (Faceless Voidcaster)";
  sound = 1;
};

GTFO.SpellID["194945"] = {
  --desc = "Lingering Gaze (Glazer)";
  sound = 1;
};

GTFO.SpellID["202046"] = {
  --desc = "Beam (Glazer)";
  sound = 1;
};

GTFO.SpellID["202608"] = {
  --desc = "Anguished Souls (Grimhorn the Enslaver)";
  sound = 1;
};

GTFO.SpellID["213395"] = {
  --desc = "Deepening Shadows (Cordana Felsong)";
  sound = 1;
};

-- *******************
-- * Black Rook Hold *
-- *******************

GTFO.SpellID["200344"] = {
  --desc = "Arrow Barrage (Risen Archer)";
  sound = 1;
};

GTFO.SpellID["221131"] = {
  --desc = "Arcane Overcharge (Archmage Galeorn)";
  sound = 4;
  negatingDebuffSpellID = 221132; -- Arcane Overcharge
};

GTFO.SpellID["220922"] = {
  --desc = "Overwhelming Release (Archmage Galeorn)";
  sound = 1;
};

GTFO.SpellID["197521"] = {
  --desc = "Blazing Trail (Illysanna Ravencrest)";
  sound = 1;
};

GTFO.SpellID["197821"] = {
  --desc = "Felblazed Ground (Illysanna Ravencrest)";
  sound = 1;
};

GTFO.SpellID["198501"] = {
  --desc = "Fel Vomitus (Smashspite the Hateful)";
  sound = 1;
};

GTFO.SpellID["221680"] = {
  --desc = "Fel Residue (Braxas the Fleshcarver)";
  sound = 1;
};

GTFO.SpellID["221866"] = {
  --desc = "Blade Barrage (Kelorn Nightblade)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["198245"] = {
  --desc = "Brutal Haymaker (Smashspite the Hateful)";
  sound = 1;
};

-- *************************
-- * The Emerald Nightmare *
-- *************************

GTFO.SpellID["221036"] = {
  --desc = "Putrid Swarm (Corrupted Vermin)";
  sound = 1;
};

GTFO.SpellID["203646"] = {
  --desc = "Burst of Corruption (Corrupted Vermin)";
  sound = 1;
};

GTFO.SpellID["220916"] = {
  --desc = "Tainted Ground";
  sound = 1;
};

GTFO.SpellID["213124"] = {
  --desc = "Venomous Pool";
  sound = 1;
};

GTFO.SpellID["215489"] = {
  --desc = "Venomous Pool";
  sound = 1;
  test = true;
};

GTFO.SpellID["212886"] = {
  --desc = "Nightmare Corruption (Il'gynoth)";
  sound = 1;
};

GTFO.SpellID["213936"] = {
  --desc = "Dark Storm (Elerethe Renferal)";
  sound = 2;
  test = true; -- may be spammy?
};

GTFO.SpellID["203045"] = {
  --desc = "Infested Ground (Nythendra)";
  sound = 1;
};

GTFO.SpellID["202978"] = {
  --desc = "Infested Breath (Nythendra)";
  sound = 1;
};

GTFO.SpellID["203097"] = {
  --desc = "Rot (Nythendra)";
  sound = 4;
  negatingDebuffSpellID = 203096; -- Rot
};

GTFO.SpellID["223946"] = {
  --desc = "Dark Lightning (Guardian Rurson)";
  sound = 1;
};

GTFO.SpellID["205611"] = {
  --desc = "Miasma (Ursoc)";
  sound = 1;
};

GTFO.SpellID["212238"] = {
  --desc = "Miasma (Ursoc)";
  sound = 1;
};

GTFO.SpellID["223596"] = {
  --desc = "Darkfall (Dreadsoul Corruptor)";
  sound = 1;
};

GTFO.SpellID["203788"] = {
  --desc = "Volatile Infection (Emeriss)";
  sound = 4;
};

GTFO.SpellID["211196"] = {
  --desc = "Rotten Breath (Rotten Drake - Cenarius)";
  sound = 1;
};

GTFO.SpellID["210337"] = {
  --desc = "Nightmare Brambles (Cenarius)";
  sound = 1;
};

GTFO.SpellID["214712"] = {
  --desc = "Nightmares (Cenarius)";
  sound = 1;
};

GTFO.SpellID["211634"] = {
  --desc = "The Infinite Dark (Xavius)";
  sound = 1;
};

-- *************
-- * Nighthold *
-- *************

-- TODO: Volatile Fragment (Skorpyron)
-- TODO: Arcing Bonds (Trilliax) -- FF Damage
-- TODO: Fel Stomp (Spellblade Aluriel)
-- TODO: Isolated Rage (Krosus)
-- TODO: Call of Night (High Botanist Tel'arn) -- when marked and not standing by someone unmarked
-- TODO: Collapse of Night (High Botanist Tel'arn) -- when marked and not standing by someone unmarked
-- TODO: Solar Collapse (High Botanist Tel'arn) -- Any ticks avoidable?
-- TODO: Frigid Pulse (Star Augur Etaeus)
-- TODO: Flames of Sargeras (Gul'dan) -- FF 

GTFO.SpellID["204744"] = {
  --desc = "Toxic Chitin (Skorpyron)";
  sound = 1;
};

GTFO.SpellID["211659"] = {
  --desc = "Arcane Tether (Skorpyron)";
  sound = 1;
  tankSound = 0;
  test = true;
};

GTFO.SpellID["230254"] = {
  --desc = "Coalesced Soul (Ariadne)";
  sound = 1;
};

GTFO.SpellID["230488"] = {
  --desc = "Rumbling Ground (Torm the Brute)";
  sound = 1;
};

GTFO.SpellID["205707"] = {
  --desc = "Temporal Orb (Chronomatic Anomaly)";
  sound = 1;
};

GTFO.SpellID["226205"] = {
  --desc = "Slime Pool (Sludgerax)";
  sound = 1;
};

GTFO.SpellID["223718"] = {
  --desc = "Bursting Slime (Sludgerax)";
  sound = 1;
  negatingDebuffSpellID = 234585; -- Oozing Rush
};

GTFO.SpellID["206488"] = {
  --desc = "Arcane Seepage (Trilliax)";
  sound = 1;
};

GTFO.SpellID["208501"] = {
  --desc = "Sterilize (Trilliax)";
  sound = 4;
  ignoreSelfInflicted = true;
  negatingDebuffSpellID = 208499; -- Sterilize
};

GTFO.SpellID["224572"] = {
  --desc = "Disrupting Energy (Nighthold Protector)";
  sound = 1;
};

GTFO.SpellID["225390"] = {
  --desc = "Stellar Dust";
  sound = 1;
};

GTFO.SpellID["212736"] = {
  --desc = "Pool of Frost (Spellblade Aluriel)";
  sound = 1;
};

GTFO.SpellID["213504"] = {
  --desc = "Arcane Fog (Spellblade Aluriel)";
  sound = 1;
};

GTFO.SpellID["213278"] = {
  --desc = "Burning Ground (Spellblade Aluriel)";
  sound = 1;
};

GTFO.SpellID["213624"] = {
  --desc = "Mark of Frost (Spellblade Aluriel)";
  sound = 4;
  negatingDebuffSpellID = 212587; -- Mark of Frost
};

GTFO.SpellID["213520"] = {
  --desc = "Arcane Orb (Spellblade Aluriel)";
  sound = 1;
};

GTFO.SpellID["212494"] = {
  --desc = "Annihilated (Spellblade Aluriel)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["222111"] = {
  --desc = "Roiling Flame";
  sound = 1;
};

GTFO.SpellID["225856"] = {
  --desc = "Poison Brambles (Shal'dorei Naturalist)";
  sound = 1;
};

GTFO.SpellID["216027"] = {
  --desc = "Nether Zone (Tichondrius)";
  sound = 1;
};

GTFO.SpellID["216685"] = {
  --desc = "Flames of Argus (Tichondrius)";
  sound = 1;
};

GTFO.SpellID["216726"] = {
  --desc = "Ring of Shadows (Tichondrius)";
  sound = 1;
};

GTFO.SpellID["224978"] = {
  --desc = "Infinite Abyss (Abyss Watcher)";
  sound = 1;
};

GTFO.SpellID["224984"] = {
  --desc = "Fel Glare (Abyss Watcher)";
  sound = 1;
  negatingDebuffSpellID = 224982; -- Fel Glare
};

GTFO.SpellID["213534"] = {
  --desc = "Echoes of the Void (Tichondrius)";
  sound = 1;
};

GTFO.SpellID["206398"] = {
  --desc = "Felflame (Star Augur Etaeus)";
  sound = 1;
  negatingDebuffSpellID = 214167; -- Gravitational Pull
  applicationOnly = true;
};

GTFO.SpellID["206921"] = {
  --desc = "Iceburst (Star Augur Etraeus)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["224561"] = {
  --desc = "Celestial Brand (Astrologer Jarin)";
  sound = 4;
  negatingDebuffSpellID = 224560; -- Celestial Brand
  test = true;
};

GTFO.SpellID["209433"] = {
  --desc = "Spanning Singularity (Grand Magistrix Elisande)";
  sound = 1;
  affirmingDebuffSpellID = 209166; -- Fast Time
};

GTFO.SpellID["208659"] = {
  --desc = "Arcanetic Ring (Grand Magistrix Elisande)";
  sound = 1;
};

GTFO.SpellID["206515"] = {
  --desc = "Fel Efflux (Gul'dan)";
  sound = 1;
};

GTFO.SpellID["217770"] = {
  --desc = "Gaze of Vethriz (Gul'dan)";
  sound = 1;
};

GTFO.SpellID["209191"] = {
  --desc = "Empowered Liquid Hellfire (Gul'dan)";
  sound = 1;
};

GTFO.SpellID["221781"] = {
  --desc = "Desolate Ground (Gul'dan)";
  sound = 1;
};

GTFO.SpellID["206896"] = {
  --desc = "Torn Soul (Gul'dan)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["227550"] = {
  --desc = "Fel Scythe (Gul'dan)";
	soundFunction = function() 
		if (GTFO.TankMode) then
			if (not GTFO_FindEvent("FelScythe")) then
				GTFO_AddEvent("FelScythe", 4);
				return 0;
			end
			if (UnitIsUnit("Boss1Target", "player")) then
				return 4;
			end
		end
		return 1;
	end;
};

GTFO.SpellID["231008"] = {
  --desc = "Explosive Trap (Flightmaster Volnath)";
  sound = 1;
};

--- ******************
--- * Trial of Valor *
--- ******************

GTFO.SpellID["228007"] = {
  --desc = "Dancing Blade (Odyn)";
  sound = 1;
};

GTFO.SpellID["228683"] = {
  --desc = "Cleansing Flame (Odyn)";
  sound = 1;
};

GTFO.SpellID["227998"] = {
  --desc = "Bilewater Corrosion (Helya)";
  sound = 1;
};

GTFO.SpellID["228127"] = {
  --desc = "Decay (Helya)";
  sound = 1;
};

GTFO.SpellID["227930"] = {
  --desc = "Orb of Corruption (Helya)";
  sound = 1;
};

GTFO.SpellID["228063"] = {
  --desc = "Orb of Corrosion (Helya)";
  sound = 1;
};

GTFO.SpellID["228371"] = {
  --desc = "Breath of Dread (Helhound)";
  sound = 1;
};

GTFO.SpellID["230197"] = {
  --desc = "Dark Waters (Helya)";
  sound = 1;
};


--- **********************
--- * Return to Karazhan *
--- **********************

-- TODO: Flame Gale (Toe Knee)
-- TODO: Flashing Forks (Coggleston)
-- TODO: Iron Whirlwind (Baron Rafe Dreuger) -- tank avoidable?


GTFO.SpellID["228200"] = {
  --desc = "Burning Blaze (Luminore)";
  sound = 1;
  test = true; -- Not when drenched?
};

GTFO.SpellID["227465"] = {
  --desc = "Power Discharge (Curator)";
  sound = 1;
};

GTFO.SpellID["228808"] = {
  --desc = "Charred Earth (Nightbane)";
  sound = 1;
  negatingDebuffSpellID = 228796; -- Ignite Soul
};

GTFO.SpellID["228001"] = {
  --desc = "Pennies From Heaven (Ghostly Philanthropist)";
  sound = 1;
};

GTFO.SpellID["227848"] = {
  --desc = "Sacred Ground (Maiden of Virtue)";
  applicationOnly = true;
	minimumStacks = 1;
  sound = 1;
};

GTFO.SpellID["227473"] = {
  --desc = "Whirling Edge (Lord Robin Daris)";
  sound = 1;
};

GTFO.SpellID["229682"] = {
  --desc = "Gleeful Immolation (Gleeful Immoliator)";
  sound = 1;
};

GTFO.SpellID["229677"] = {
  --desc = "Fel Bomb (Infused Pyromancer)";
  sound = 1;
};

GTFO.SpellID["227806"] = {
  --desc = "Ceaseless Winter (Shade of Medivh)";
  applicationOnly = true;
  sound = 1;
	minimumStacks = 2;
};

GTFO.SpellID["227524"] = {
  --desc = "Energy Void (Mana Devourer)";
  sound = 1;
  test = true; -- Does it work?
  negatingDebuffSpellID = 227502; -- Unstable Mana
};

GTFO.SpellID["229905"] = {
  --desc = "Soul Harvest (Viz'aduum the Watcher)";
  sound = 1;
};

GTFO.SpellID["230431"] = {
  --desc = "Seeping Fel Power (Viz'aduum the Watcher)";
  sound = 1;
};

GTFO.SpellID["229250"] = {
  --desc = "Fel Flames (Viz'aduum the Watcher)";
  sound = 1;
};

GTFO.SpellID["229248"] = {
  --desc = "Fel Beam (Viz'aduum the Watcher)";
  damageMinimum = 1;
  sound = 1;
};

GTFO.SpellID["228993"] = {
  --desc = "Caustic Pool (Coldmist Stalker)";
  sound = 1;
};

-- **************************
-- * Cathedral of the Night *
-- **************************

GTFO.SpellID["238656"] = {
  --desc = "Shadow Wave (Dul'zak)";
  sound = 1;
};

GTFO.SpellID["237325"] = {
  --desc = "Toxic Pollen (Felborne Botanist)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["240556"] = {
  --desc = "Tome of Everlasting Silence";
  sound = 1;
  test = true;
};

GTFO.SpellID["240951"] = {
  --desc = "Destructive Rampage (Thrashbite the Scornful)";
  sound = 3;
  tankSound = 1;
};

GTFO.SpellID["239326"] = {
  --desc = "Felblaze Orb (Nal'asha)";
  sound = 1;
  test = true;
};

GTFO.SpellID["233177"] = {
  --desc = "Carrion Swarm (Mephistroth)";
  sound = 1;
};

GTFO.SpellID["237583"] = {
  --desc = "Burning Celerity";
  sound = 1;
};

GTFO.SpellID["240295"] = {
  --desc = "Searing Rend (nil)";
  sound = 1;
};

-- ********************
-- * Tomb of Sargeras *
-- ********************

GTFO.SpellID["231363"] = {
  --desc = "Burning Armor (Goroth)";
  sound = 4;
  negatingDebuffSpellID = 231363; -- Burning Armor
  negatingIgnoreTime = 2;
};

GTFO.SpellID["241265"] = {
  --desc = "Shocking Squall (Tidescale Witch)";
  sound = 1;
};

GTFO.SpellID["231768"] = {
  --desc = "Drenching Waters (Harjatan)";
  sound = 1;
};

GTFO.SpellID["240176"] = {
  --desc = "Lightning Storm (Undersea Custodian)";
  sound = 1;
};

GTFO.SpellID["230959"] = {
  --desc = "Concealing Murk (Mistress Sassz'ine)";
  sound = 2;
};

GTFO.SpellID["236241"] = {
  --desc = "Soul Rot (Engine of Souls)";
  sound = 1;
};

GTFO.SpellID["236464"] = {
  --desc = "Soulbind (Engine of Souls)";
  sound = 4;
  negatingDebuffSpellID = 236459; -- Soulbind
};

GTFO.SpellID["235989"] = {
  --desc = "Tormented Cries (Engine of Souls)";
  sound = 1;
};

GTFO.SpellID["235907"] = {
  --desc = "Collapsing Fissure (Engine of Souls)";
  sound = 1;
};

GTFO.SpellID["236011"] = {
  --desc = "Tormented Cries (Engine of Souls)";
  sound = 1;
  alwaysAlert = true;
};

GTFO.SpellID["234550"] = {
  --desc = "Bone Saw (Atrigan)";
  sound = 1;
};

GTFO.SpellID["235237"] = {
  --desc = "Fel Squall (Belac)";
  sound = 1;
};

GTFO.SpellID["241032"] = {
  --desc = "Desolation of the Moon (Lunar Guard)";
  sound = 1;
};

GTFO.SpellID["241169"] = {
  --desc = "Umbra Destruction (Umbral Guard)";
  sound = 1;
};

GTFO.SpellID["237351"] = {
  --desc = "Lunar Barrage (Sisters of the Moon)";
  sound = 1;
};

GTFO.SpellID["236516"] = {
  --desc = "Twilight Volley (Sisters of the Moon)";
  sound = 1;
};

GTFO.SpellID["218004"] = {
  --desc = "Kil'jaeden's Perdition (Kil'jaeden)";
  sound = 1;
};

GTFO.SpellID["240109"] = {
  --desc = "Fel Spike (Targuz)";
  sound = 1;
};

GTFO.SpellID["240249"] = {
  --desc = "Molten Fel (Fallen Avatar)";
  sound = 1;
};

GTFO.SpellID["234062"] = {
  --desc = "Unbound Chaos (Fallen Avatar)";
  sound = 1;
};

GTFO.SpellID["241703"] = {
  --desc = "Blood Siphon (The Dread Stalker)";
  sound = 1;
	alwaysAlert = true;
};

GTFO.SpellID["239409"] = {
  --desc = "Soul Burst";
  sound = 1;
};

GTFO.SpellID["245509"] = {
  --desc = "Felclaws (Kil'jaeden)";
  applicationOnly = true;
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["242700"] = {
  --desc = "Capacitant Burst (Deepmaw)";
  sound = 1;
};

GTFO.SpellID["230348"] = {
  --desc = "Fel Pool (Goroth)";
  sound = 1;
};

GTFO.SpellID["241262"] = {
  --desc = "Felburn (Rez the Tombwatching)";
  sound = 1;
};

GTFO.SpellID["233901"] = {
  --desc = "Suffocating Dark";
  sound = 1;
};

GTFO.SpellID["234129"] = {
  --desc = "Splashy Cleave (Razorjaw Gladiator)";
  sound = 4;
  negatingDebuffSpellID = 234016; -- Driven Assault
  soundLFR = 0;  
};

GTFO.SpellID["245087"] = {
  --desc = "Wake of Shadows";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["245253"] = {
  --desc = "Unstable Rift";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["238028"] = {
  --desc = "Light Remanence (Maiden of Vigiliance)";
  sound = 1;
};

GTFO.SpellID["238408"] = {
  --desc = "Fel Remanence (Maiden of Vigiliance)";
  sound = 1;
};

GTFO.SpellID["239212"] = {
  --desc = "Lingering Darkness (Fallen Avatar)";
  sound = 1;
};

GTFO.SpellID["242017"] = {
  --desc = "Black Winds (Fallen Avatar)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["243294"] = {
  --desc = "Fel Slicer (Accusator Gnazh)";
  sound = 1;
};

GTFO.SpellID["240262"] = {
  --desc = "Burning (Kil'jaeden)";
  sound = 1;
};


--- *********
--- * Argus *
--- *********

GTFO.SpellID["250885"] = {
  --desc = "Felshock Bombardment (Antaen Light-Breaker)";
  sound = 1;
  negatingBuffSpellID = 250895; -- Light's Protection
};

GTFO.SpellID["241557"] = {
  --desc = "Molten Fel (Aggonar)";
  sound = 1;
};

GTFO.SpellID["251701"] = {
  --desc = "Fel Lava";
  sound = 1;
};

GTFO.SpellID["243842"] = {
  --desc = "Laser Field";
  sound = 1;
};

GTFO.SpellID["252122"] = {
  --desc = "Maddening Spores";
  sound = 1;
};

GTFO.SpellID["252119"] = {
  --desc = "Spore Pool";
  sound = 1;
};

GTFO.SpellID["239281"] = {
  --desc = "Viscous Webs";
  sound = 2;
};

GTFO.SpellID["250686"] = {
  --desc = "Crush (Deep Terror)";
  sound = 3;
  damageMinimum = 1;
};

GTFO.SpellID["251564"] = {
  --desc = "Crippling Cold";
  applicationOnly = true;
	minimumStacks = 14;
  sound = 1;
};

GTFO.SpellID["249398"] = {
  --desc = "Rain of Fire (Vel'thrak the Punisher)";
  sound = 1;
};

GTFO.SpellID["242973"] = {
  --desc = "Fel Infused";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["251682"] = {
  --desc = "Blizzard";
  tankSound = 2;
  sound = 1;
};

GTFO.SpellID["249263"] = {
  --desc = "Wake of Blood";
  sound = 1;
};

GTFO.SpellID["251901"] = {
  --desc = "Molten Lava";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["249067"] = {
  --desc = "Eye of Darkness (Harbinger Drel'nathar)";
  sound = 1;
};

GTFO.SpellID["248700"] = {
  --desc = "Fel Lightning (Fel Spike)";
  sound = 1;
};

GTFO.SpellID["247330"] = {
  --desc = "Eye Sore";
  sound = 1;
};

GTFO.SpellID["247372"] = {
  --desc = "Phantasm";
  sound = 1;
};

GTFO.SpellID["248504"] = {
  --desc = "Fel Flames";
  sound = 1;
};

GTFO.SpellID["253989"] = {
  --desc = "Kicking Up Dust";
  sound = 2;
};

GTFO.SpellID["248770"] = {
  --desc = "Flame Fissure (Flameweaver Verathix)";
  sound = 1;
};

GTFO.SpellID["248759"] = {
  --desc = "Lava Waves (Flameweaver Verathix)";
  sound = 1;
};

GTFO.SpellID["253990"] = {
  --desc = "Beaming Gaze (Beaming Eye)";
  sound = 1;
};

--- ***************************
--- * Seat of the Triumvirate *
--- ***************************

GTFO.SpellID["244588"] = {
  --desc = "Void Sludge (Zuraal the Ascended)";
  sound = 1;
};

GTFO.SpellID["244906"] = {
  --desc = "Collapsing Void (Viceroy Nezhar)";
  sound = 1;
};

GTFO.SpellID["250820"] = {
  --desc = "Growing Pressure";
  applicationOnly = true;
  sound = 1;
};

-- *******************************
-- * Antorus, the Burning Throne *
-- *******************************

GTFO.SpellID["245861"] = {
  --desc = "Searing Rend";
  sound = 1;
};

GTFO.SpellID["244590"] = {
  --desc = "Molten Hot Fel";
  sound = 1;
};

GTFO.SpellID["244131"] = {
  --desc = "Consuming Sphere (Shatug)";
  sound = 1;
};

GTFO.SpellID["254403"] = {
  --desc = "Consuming Sphere (Shatug)";
  sound = 1;
};

GTFO.SpellID["253039"] = {
  --desc = "Bladestorm (Felblade Shocktrooper)";
  sound = 1;
  tankSound = 2;
};

GTFO.SpellID["258021"] = {
  --desc = "Purging Protocol (Kin'garoth)";
  sound = 1;
};

GTFO.SpellID["246840"] = {
  --desc = "Ruiner (Kin'garoth)";
  sound = 1;
};

GTFO.SpellID["249297"] = {
  --desc = "Flames of Reorigination";
  spellType = "SPELL_AURA_REFRESH";
  sound = 4;
};

GTFO.SpellID["243963"] = {
  --desc = "Alone in the Darkness (Varimathras)";
  sound = 1;
};

GTFO.SpellID["245674"] = {
  --desc = "Flames of Khaz'goroth (Torment of Khaz'goroth)";
  sound = 1;
};

GTFO.SpellID["245921"] = {
  --desc = "Spectral Army of Norgannon (Norgannon)";
  sound = 1;
};

GTFO.SpellID["245634"] = {
  --desc = "Whirling Saber (Noura)";
  sound = 1;
};

GTFO.SpellID["248167"] = {
  --desc = "Death Fog (Argus the Unmaker)";
  sound = 1;
};

GTFO.SpellID["246199"] = {
  --desc = "Burning Winds (Dark Keeper Aedis)";
  sound = 1;
};

GTFO.SpellID["255646"] = {
  --desc = "Golganneth's Wrath (Argus the Unmaker)";
  sound = 1;
};

GTFO.SpellID["248795"] = {
  --desc = "Fel Wake (Eonar)";
  sound = 1;
};

GTFO.SpellID["253020"] = {
  --desc = "Storm of Darkness (Asara, Mother of Night)";
  sound = 1;
};

GTFO.SpellID["253538"] = {
  --desc = "Fulimating Pulse (Noura, Mother of Flames)";
  soundFunction = function() -- Prevent Fulminating Burst
    GTFO_AddEvent("Fulminating", 3);
    return 0;
  end
};

GTFO.SpellID["245916"] = {
  --desc = "Molten Remnants (Aggramar)";
  sound = 1;
};

end