-- AUTO GENERATED FILE! DO NOT EDIT!

-------------------------
--Import modules.
-------------------------
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB");

QuestieDB.npcKeys = {
    ['name'] = 1, -- string
    ['minLevelHealth'] = 2, -- int
    ['maxLevelHealth'] = 3, -- int
    ['minLevel'] = 4, -- int
    ['maxLevel'] = 5, -- int
    ['rank'] = 6, -- int, see https://github.com/cmangos/issues/wiki/creature_template#rank
    ['spawns'] = 7, -- table {[zoneID(int)] = {coordPair(floatVector2D),...},...}
    ['waypoints'] = 8, -- table {[zoneID(int)] = {coordPair(floatVector2D),...},...}
    ['zoneID'] = 9, -- guess as to where this NPC is most common
    ['questStarts'] = 10, -- table {questID(int),...}
    ['questEnds'] = 11, -- table {questID(int),...}
    ['factionID'] = 12, -- int, see https://github.com/cmangos/issues/wiki/FactionTemplate.dbc
    ['friendlyToFaction'] = 13, -- string, Contains "A" and/or "H" depending on NPC being friendly towards those factions. nil if hostile to both.
}

QuestieDB.npcData = {
[1] = {'Waypoint (Only GM can see it)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[2] = {'Spawn Point (Only GM can see it)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[3] = {'Flesh Eater',664,713,24,25,0,{[10]={{25.06,38.2},{25.37,36.04},{25.69,34.45},{23.81,39.21},{22.81,39.09},{22.04,32.62},{21.7,38.3},{22.2,36.96},{25.37,39.03},},},nil,10,nil,nil,21,nil,},
[6] = {'Kobold Vermin',42,55,1,2,0,{[12]={{48.89,36.44},{49.55,36.06},{49.15,36.93},{48.1,36.96},{48.37,36.74},{49.32,35.81},{48.87,35.14},{49.87,36.3},{48.52,36.13},{49.17,36.55},{46.93,35.67},{47.58,35.94},{47.65,36.91},{47.86,36.26},{47.57,36.37},{47.62,35.75},{47.91,35.49},{47.36,36.31},{47.22,36.0},{47.55,34.98},{49.79,35.17},{49.44,35.34},{49.73,35.8},{50.04,35.46},{51.3,36.5},{51.23,36.02},{51.61,35.68},{50.49,37.61},{50.98,37.58},{51.29,37.43},{50.76,37.47},{51.36,37.02},{51.68,37.01},},},nil,12,nil,nil,25,nil,},
[30] = {'Forest Spider',102,120,5,6,0,{[12]={{36.43,55.89},{31.43,57.03},{35.98,62.7},{38.47,62.4},{28.46,66.71},{31.95,68.46},{35.76,69.07},{37.96,69.98},{38.2,72.85},{33.54,73.76},{39.54,78.66},{43.87,76.69},{40.76,75.13},{41.86,72.16},{38.79,73.3},{44.59,71.23},},},nil,12,nil,nil,22,nil,},
[36] = {'Harvest Golem',222,247,11,12,0,{[40]={{47.11,67.64},{35.81,45.9},{34.46,46.05},{32.51,36.36},{48.98,33.82},{32.92,37.29},{56.84,35.72},{36.13,46.93},{47.88,33.47},{46.54,69.08},{50.32,33.96},{34.33,47.79},{35.35,47.2},{33.42,36.19},{48.74,32.34},{47.46,66.53},{46.7,65.92},{46.87,67.03},{56.85,34.26},{33.56,46.66},{32.93,35.52},{57.29,35.37},{57.16,33.97},{56.52,35.1},{56.34,35.94},{56.97,36.27},{49.67,32.97},{48.67,32.19},},},nil,40,nil,nil,14,nil,},
[38] = {'Defias Thug',71,86,3,4,0,{[12]={{53.24,45.58},{54.05,44.86},{53.87,44.27},{54.59,42.87},{53.01,47.18},{52.93,47.28},{52.47,47.14},{51.95,48.53},{52.8,47.03},{51.87,47.52},{51.06,49.25},{52.28,49.48},{52.55,48.77},{52.25,50.09},{52.01,51.01},{51.38,49.26},{51.29,50.67},{53.22,50.57},{53.56,51.48},{52.36,51.66},{52.62,51.93},{52.92,49.41},{52.87,49.34},{53.29,49.55},{53.77,49.73},{53.86,49.17},{53.81,49.07},{53.78,49.19},{53.99,50.58},{53.22,48.17},{53.62,48.33},{53.59,47.76},{51.83,51.44},{54.47,51.35},{55.11,49.16},{55.1,49.0},{54.07,52.2},{54.86,52.08},{55.45,51.21},{55.69,49.73},{54.47,48.92},{54.49,49.87},{54.55,50.25},{55.04,47.84},{54.61,47.02},{54.05,46.92},{54.88,48.46},{54.14,47.84},{56.38,49.75},{56.07,48.13},{55.48,45.76},{54.71,45.96},{55.7,47.29},{55.3,47.02},{56.1,44.99},{56.63,43.72},{56.41,43.92},{56.66,44.02},{55.47,43.95},{55.22,42.27},{54.91,44.22},{55.01,40.17},{54.78,41.74},{54.63,41.56},{55.54,40.92},{57.07,40.9},{57.07,42.54},{56.08,40.56},{55.7,41.04},{54.94,40.19},{55.86,42.22},{54.98,43.14},{54.65,42.05},{54.51,42.78},{55.46,42.07},{53.98,44.76},{57.44,48.07},},},{[12]={{53.47,46.2},{53.96,43.55},{54.24,41.99},{54.4,40.77},{54.22,41.95},{54.49,40.69},{54.38,42.05},{54.0,43.5},{53.89,45.0},{53.47,46.2},{52.93,47.28},{52.55,47.31},{52.27,47.33},{51.88,47.75},{51.36,48.8},{50.84,49.18},{50.61,49.64},{50.35,50.63},{50.15,50.77},{50.64,49.84},{50.65,49.53},{50.54,49.06},{50.79,48.38},{51.24,47.5},{52.05,46.98},{52.64,46.47},{52.81,46.54},{52.87,46.92},{52.29,50.04},{52.7,50.0},{53.04,50.63},{53.39,51.62},{54.02,51.9},{54.81,51.74},{55.23,51.79},{55.7,50.72},{55.82,49.91},{55.25,49.88},{55.02,50.25},{54.92,50.84},{54.21,51.35},{54.09,51.62},{53.76,51.54},{53.45,51.2},{52.73,51.41},{52.27,51.24},{51.9,50.83},{52.01,51.01},{51.72,50.57},{51.83,50.66},{52.18,51.01},{53.22,51.14},{54.02,51.79},{54.98,51.22},{55.16,51.21},{53.28,51.55},{53.08,51.49},{52.92,49.41},{52.92,49.41},{53.86,49.17},{53.86,49.17},{53.79,49.16},{53.48,49.32},{53.0,49.28},{52.94,49.32},{53.3,48.79},{53.72,49.22},{55.1,49.0},{54.09,50.88},{53.79,50.94},{53.47,50.51},{53.05,49.63},{52.83,49.59},{52.76,49.47},{52.43,48.81},{52.43,48.51},{52.72,48.01},{53.16,47.43},{53.69,46.73},{53.97,46.77},{54.32,47.18},{54.81,48.0},{55.23,48.64},{55.29,49.11},{54.9,49.71},{55.54,45.27},{55.32,45.99},{54.78,45.69},{54.29,45.74},{54.07,45.25},{54.08,43.43},{54.37,42.93},{54.62,41.58},{55.03,40.85},{55.54,44.5},{55.32,43.66},{55.24,42.85},{55.48,42.16},{55.53,40.62},{55.24,40.19},{55.01,40.19},{56.08,40.56},{55.74,40.63},{55.52,41.42},{55.5,42.12},{55.06,42.72},{55.01,44.04},{55.1,42.42},{54.8,41.89},{54.94,40.2},{56.08,40.56},{56.08,40.56},},[46]={{2.42,98.17},{2.75,96.31},{2.94,94.87},{2.73,96.28},{3.04,94.78},{2.92,96.39},{2.47,98.11},{2.34,99.89},{2.56,98.03},{2.9,97.43},{3.2,95.83},{3.68,94.97},{4.29,99.3},{4.03,98.3},{3.94,97.34},{4.22,96.53},{4.28,94.69},{3.94,94.18},{3.67,94.18},{4.93,94.62},{4.53,94.71},{4.26,95.64},{4.25,96.47},{3.72,97.18},{3.66,98.75},{3.76,96.83},{3.42,96.2},{3.58,94.2},{4.93,94.62},{4.93,94.62},},},12,nil,nil,17,nil,},
[40] = {'Kobold Miner',120,137,6,7,0,{[12]={{40.45,80.26},{40.87,80.68},{40.71,81.4},{40.84,80.42},{41.09,80.96},{39.86,81.01},{39.95,78.62},{40.22,79.6},{39.77,79.09},{39.97,80.12},{41.43,79.87},{41.27,79.26},{41.64,80.09},{41.87,81.35},{41.04,78.16},{41.02,79.92},{41.6,80.04},{40.32,77.69},{40.35,78.16},{41.48,77.93},{41.71,78.67},{40.84,77.46},{64.78,59.93},{63.69,61.13},{64.5,57.42},{64.3,56.83},{64.79,56.41},{64.63,56.88},{63.58,55.35},{63.8,58.17},{63.12,56.56},{62.9,59.97},{61.97,58.32},{62.04,55.31},{62.82,53.82},{60.07,57.4},{61.12,56.36},{60.71,52.8},{61.5,51.92},{61.41,51.51},{61.51,53.26},{61.01,49.23},{61.11,50.9},{60.84,49.5},{60.27,49.55},{61.22,49.61},{61.48,50.2},{60.62,50.85},{61.14,49.89},{60.91,59.71},{58.02,59.83},},},nil,12,nil,nil,26,nil,},
[43] = {'Mine Spider',156,176,8,9,0,{[12]={{62.01,47.92},{60.03,48.68},{61.11,47.28},{61.75,47.45},{60.2,47.56},{61.91,47.12},{61.6,46.9},{60.53,46.9},},},nil,12,nil,nil,22,nil,},
[46] = {'Murloc Forager',176,198,9,10,0,{[12]={{68.64,85.46},{68.62,85.39},{65.78,84.42},{64.73,83.0},{61.87,80.56},{56.36,85.21},{52.34,86.73},{57.0,84.24},{59.3,82.43},{61.17,82.38},{63.36,82.8},{67.93,83.69},{69.98,84.08},{76.72,82.77},{76.79,85.94},{76.6,85.57},{77.25,85.18},{77.56,85.95},{76.16,84.87},{77.78,86.13},{79.34,57.2},{79.26,56.87},{79.65,55.22},{79.43,56.36},{78.8,55.73},{78.44,56.65},{78.45,56.16},{78.93,55.01},{79.34,54.08},{79.24,54.22},{79.46,50.74},{79.42,47.96},{79.46,48.2},{79.16,47.39},{79.36,47.7},{80.31,45.24},{79.19,45.21},{79.12,45.99},{79.48,45.36},{79.34,45.25},{79.54,47.18},{79.51,46.31},{79.96,46.28},{78.83,44.53},{77.95,45.11},{78.6,44.91},{78.23,44.87},{79.47,43.52},{78.57,43.17},{77.9,44.36},{77.74,44.28},{77.31,44.1},{78.56,42.09},{79.39,58.05},{75.56,86.58},{76.27,86.46},{75.86,85.94},{74.74,85.27},},},{[12]={{79.44,56.34},{79.43,55.93},{79.33,55.62},{79.32,55.37},{79.47,55.3},{79.57,55.48},{79.71,55.72},{79.84,55.93},{80.06,56.3},{80.17,56.55},{80.28,56.9},{80.23,57.3},{80.14,57.63},{79.95,57.91},{79.71,58.08},{79.53,58.19},{78.99,58.56},{78.53,58.61},{78.35,58.39},{78.45,57.97},{78.61,57.69},{78.89,57.26},{79.27,56.69},{79.19,45.21},{79.0,45.47},{78.86,45.64},{79.0,45.46},{78.6,44.91},{78.57,44.53},{78.61,45.06},{78.64,45.45},{78.6,44.93},},[46]={{31.62,99.78},{31.58,99.33},{31.63,99.96},{31.62,99.81},},},12,nil,nil,18,nil,},
[48] = {'Skeletal Warrior',531,573,21,22,0,{[10]={{77.41,73.76},{76.91,72.2},{78.96,69.68},{80.34,72.03},{77.68,71.76},{76.88,70.25},{78.63,70.85},{80.57,70.2},{79.78,68.75},{82.14,68.7},{80.84,73.82},{79.75,73.0},{80.61,66.66},{81.03,69.32},{78.03,67.01},},},nil,10,nil,nil,21,nil,},
[54] = {'Corina Steele',396,396,10,10,0,{[12]={{41.53,65.9},},},nil,12,nil,nil,12,"A",},
[60] = {'Ruklar the Trapper',148,148,8,8,0,{[12]={{64.64,56.65},},},nil,12,nil,nil,26,nil,},
[61] = {'Thuros Lightfingers',222,222,11,11,4,{[12]={{52.66,58.91},{28.58,59.92},{29.23,58.0},{30.81,57.12},{50.51,82.93},{50.94,83.1},{89.94,79.45},{89.3,79.28},},},{[12]={{52.66,58.91},{52.67,58.99},{52.68,59.35},{52.73,59.83},{52.67,58.99},{52.66,58.91},{52.58,58.84},},},12,nil,nil,17,nil,},
[66] = {'Tharynn Bouden',396,396,10,10,0,{[12]={{41.82,67.16},},},nil,12,nil,nil,12,"A",},
[68] = {'Stormwind City Guard',3921,3921,55,55,0,{[1519]={{51.47,27.87},{42.55,40.68},{32.96,64.5},{42.45,60.04},{38.6,58.48},{38.37,58.03},{62.46,64.18},{57.06,60.93},{60.61,67.98},{64.18,73.56},{59.93,68.81},{62.76,74.91},{55.43,67.88},{62.4,61.82},{55.1,68.14},{55.22,44.3},{59.93,45.25},{55.42,44.69},{59.69,45.56},{42.96,59.66},{48.95,62.23},{63.55,76.54},{64.85,74.89},{69.96,89.21},{71.48,87.39},},[12]={{32.08,49.95},{32.47,49.51},},},{[12]={{26.54,38.27},{26.99,37.53},{27.56,38.17},{26.96,37.53},{26.56,38.27},{28.64,38.56},{28.02,37.87},{27.31,37.1},{28.1,37.93},{28.59,38.58},{30.96,47.81},{30.86,47.39},{30.7,47.13},{30.45,46.61},{30.17,46.07},{29.94,45.63},{29.71,45.23},{29.47,44.76},{29.31,44.49},{29.18,44.34},{29.08,44.33},{31.06,48.29},{31.4,48.95},{31.06,48.29},{30.96,47.8},{30.86,47.39},{30.7,47.13},{30.45,46.61},{30.17,46.06},{29.94,45.63},{29.71,45.23},{29.47,44.76},{29.31,44.49},{31.35,47.06},{31.67,46.72},{31.77,46.74},{31.75,46.92},{31.49,47.31},{31.53,47.45},{31.66,47.62},{31.85,47.96},{31.99,48.23},{31.85,47.96},{31.66,47.62},{31.53,47.45},{31.49,47.31},{31.75,46.92},{31.77,46.74},{31.67,46.72},{31.35,47.06},{31.21,47.1},{31.05,46.8},{30.93,46.59},{30.81,46.34},{30.63,46.02},{30.46,45.68},{30.28,45.37},{30.11,45.05},{29.85,44.56},{29.66,44.21},{29.57,44.02},{29.56,43.86},{29.58,43.67},{31.21,47.1},{31.05,46.8},{30.93,46.59},{30.81,46.34},{30.63,46.02},{30.46,45.68},{30.28,45.37},{30.11,45.05},{29.85,44.56},{29.66,44.21},{29.57,44.02},{29.56,43.86},},[1519]={{57.04,60.98},{58.19,59.05},{59.67,60.7},{58.12,59.07},{57.09,60.98},{62.47,61.72},{60.85,59.93},{59.01,57.95},{61.06,60.09},{62.34,61.78},{68.46,85.6},{68.19,84.53},{67.79,83.85},{67.13,82.5},{66.41,81.11},{65.82,79.99},{65.22,78.96},{64.6,77.73},{64.18,77.02},{63.86,76.66},{63.59,76.62},{68.7,86.86},{69.58,88.54},{68.7,86.86},{68.45,85.57},{68.19,84.53},{67.79,83.85},{67.13,82.5},{66.4,81.1},{65.82,79.99},{65.22,78.96},{64.6,77.73},{64.18,77.02},{69.46,83.67},{70.28,82.79},{70.54,82.85},{70.5,83.3},{69.81,84.32},{69.93,84.69},{70.25,85.12},{70.75,85.98},{71.12,86.68},{70.75,85.98},{70.25,85.12},{69.93,84.69},{69.81,84.32},{70.5,83.3},{70.54,82.85},{70.28,82.79},{69.46,83.67},{69.08,83.78},{68.68,83.0},{68.38,82.46},{68.06,81.81},{67.6,80.99},{67.15,80.11},{66.69,79.31},{66.24,78.48},{65.58,77.22},{65.1,76.32},{64.86,75.81},{64.84,75.41},{64.88,74.92},{69.08,83.78},{68.68,83.0},{68.38,82.46},{68.06,81.81},{67.6,80.99},{67.15,80.11},{66.69,79.31},{66.24,78.48},{65.58,77.22},{65.1,76.32},{64.86,75.81},{64.84,75.41},},},1519,nil,nil,11,"A",},
[69] = {'Timber Wolf',55,55,2,2,0,{[12]={{45.91,40.31},{49.16,45.38},{46.66,39.39},{49.41,37.75},{48.17,37.37},{48.15,34.91},{45.96,36.37},{46.6,35.13},{46.15,35.53},{46.25,36.73},{48.51,33.67},{46.34,34.42},{45.2,35.15},{45.69,34.96},{46.96,34.46},{50.93,35.71},{52.74,35.14},{50.16,37.41},{51.24,40.45},{52.51,39.15},{52.65,38.37},{52.63,40.48},{53.07,38.74},{51.88,41.56},{52.53,42.19},{51.53,43.7},{50.92,44.14},{50.89,44.37},{51.71,43.13},{51.61,42.38},{49.9,46.59},{49.48,49.26},{49.35,47.46},{48.98,47.04},{51.45,45.58},{50.38,44.94},},},nil,12,nil,nil,32,"AH",},
[74] = {'Kurran Steele',396,396,10,10,0,{[12]={{41.37,65.59},},},nil,12,nil,nil,12,"A",},
[78] = {'Janos Hammerknuckle',204,204,5,5,0,{[12]={{47.24,41.9},},},nil,12,nil,nil,12,"A",},
[79] = {'Narg the Taskmaster',257,257,10,10,4,{[12]={{40.93,77.5},},},nil,12,nil,nil,26,nil,},
[80] = {'Kobold Laborer',71,86,3,4,0,{[12]={{49.97,25.68},{47.79,31.64},{48.38,29.93},{48.37,29.24},{48.37,30.27},{47.5,30.29},{47.42,30.06},{47.83,31.03},{48.07,30.22},{47.9,30.91},{48.65,29.13},{49.18,29.0},{49.25,28.36},{48.31,28.93},{48.22,28.59},{48.48,28.06},{48.94,26.39},{49.19,27.79},{48.57,27.39},{48.54,26.61},{50.3,26.79},{49.55,25.86},{50.21,26.32},{50.51,26.85},{50.11,27.02},},},nil,12,nil,nil,26,nil,},
[89] = {'Infernal',4209,4209,50,50,0,nil,nil,0,nil,nil,954,nil,},
[92] = {'Rock Elemental',1678,1753,39,40,0,{[3]={{45.45,81.39},{44.34,83.94},{42.79,88.19},{44.23,85.82},{43.02,86.27},{44.51,82.25},{43.32,84.2},{42.92,82.01},{46.1,77.64},{44.43,80.59},{42.62,78.39},{36.64,74.08},{36.11,75.73},{35.08,75.42},{39.04,77.75},{41.8,77.06},{40.44,75.76},{38.46,73.51},{40.51,78.29},{40.97,79.29},{41.8,83.65},{41.3,82.19},{37.42,75.92},{15.04,35.29},{13.86,36.28},{11.98,34.27},{14.8,33.85},{13.44,33.43},{15.52,32.21},{16.56,36.15},},},nil,3,nil,nil,91,nil,},
[94] = {'Defias Cutpurse',102,120,5,6,0,{[12]={{40.83,56.62},{37.55,55.21},{39.09,53.89},{41.85,53.78},{41.8,52.83},{41.7,52.67},{41.51,52.84},{40.92,53.76},{39.94,55.22},{42.81,56.55},{42.61,51.94},{42.83,53.58},{41.93,55.07},{44.63,56.65},{43.8,55.08},{42.93,51.14},{43.77,50.84},{38.38,57.87},{37.29,55.25},{36.13,58.22},{36.9,66.21},{36.25,66.84},{36.29,65.9},{35.25,66.97},{30.4,65.89},{29.46,65.4},{31.07,67.23},{30.68,66.54},{31.96,65.68},{29.99,68.19},},},{[12]={{42.4,52.14},{41.89,53.67},},[1519]={{97.98,96.8},},},12,nil,nil,17,nil,},
[95] = {'Defias Smuggler',222,247,11,12,0,{[40]={{46.59,19.56},{44.18,25.77},{44.73,25.64},{44.92,25.16},{44.01,25.93},{48.36,20.29},{48.42,19.86},{46.34,39.69},{41.42,40.59},{46.49,37.63},{46.58,37.82},{41.14,41.77},{46.6,53.36},{48.23,47.04},{48.23,46.61},{45.49,21.72},{46.0,19.42},{45.35,21.2},{44.53,21.54},{44.72,26.27},{45.28,26.9},{45.82,39.63},{40.8,40.87},{41.84,40.47},{46.19,39.06},{45.74,20.5},{43.92,26.84},{45.52,20.99},{44.67,19.41},{46.0,18.88},{44.55,24.81},{45.53,18.06},{44.08,23.34},{45.8,26.58},{45.85,25.62},{50.09,18.43},{49.41,19.19},{50.58,47.31},{51.59,46.65},{50.33,40.82},{50.77,40.08},{51.24,40.44},{49.52,46.43},{48.54,45.12},},},nil,40,nil,nil,17,nil,},
[97] = {'Riverpaw Runt',156,176,8,9,0,{[12]={{26.46,86.65},{25.07,88.88},{27.73,86.64},{27.7,86.13},{25.27,89.35},{26.2,91.7},{26.07,91.71},{27.66,88.32},{28.34,87.38},{24.34,93.62},{30.85,89.13},{30.76,82.85},{31.6,80.64},{68.59,46.46},{67.83,46.44},{68.37,45.35},{68.41,44.9},{68.09,39.41},{68.82,39.53},{65.94,39.3},{66.63,39.45},{66.4,41.32},{66.33,40.62},{70.81,39.2},{69.24,38.98},{68.68,38.24},},},nil,12,nil,nil,20,nil,},
[98] = {'Riverpaw Taskmaster',386,417,17,18,0,{[40]={{56.51,70.11},{56.32,74.38},{56.45,74.05},{56.39,74.48},{59.98,69.15},{60.42,70.85},{59.43,74.1},{60.94,74.47},{61.02,74.22},{60.9,74.07},{60.8,74.49},{61.84,77.83},{60.9,77.47},{60.8,77.59},{61.03,77.81},{62.78,77.03},{61.62,76.45},{62.67,75.93},{61.94,77.11},{62.26,76.2},{64.07,76.59},{63.34,77.45},{63.56,77.45},{63.37,77.17},{62.84,77.36},{63.67,70.19},{63.82,72.99},{63.48,72.81},{63.68,72.71},{66.7,75.44},{65.34,75.18},{65.3,75.28},{65.27,75.45},{65.08,75.36},{64.59,76.61},{63.88,74.96},{63.54,75.81},{64.69,69.04},{62.56,67.77},{61.21,70.38},{61.82,73.04},{61.7,72.2},{62.87,72.08},{60.5,72.99},{59.39,72.84},{60.9,76.62},},},nil,40,nil,nil,20,nil,},
[99] = {'Morgaine the Sly',198,198,10,10,4,{[12]={{30.81,64.73},},},nil,12,nil,nil,17,nil,},
[100] = {'Gruff Swiftbite',247,247,12,12,4,{[12]={{25.39,89.75},{26.09,91.92},{27.93,88.21},{26.35,86.68},{27.72,86.03},},},nil,12,nil,nil,20,nil,},
[103] = {'Garrick Padfoot',102,102,5,5,0,{[12]={{57.52,48.25},},},nil,12,nil,nil,17,nil,},
[113] = {'Stonetusk Boar',102,120,5,6,0,{[12]={{44.11,69.38},{40.92,69.51},{39.87,69.69},{38.85,68.7},{37.62,70.78},{38.09,75.42},{30.94,84.12},{31.68,80.07},{32.35,81.45},{31.14,81.0},{31.32,82.62},{31.46,85.96},{32.19,83.91},{32.03,86.65},{31.92,85.85},{33.4,86.63},{33.37,85.14},{33.31,89.71},{33.78,89.39},{35.2,89.81},{35.34,87.78},{33.98,81.31},{33.03,80.16},{38.75,78.61},{37.07,76.83},{40.95,85.03},{41.55,85.84},{38.56,86.16},{41.7,77.71},{39.05,76.8},{41.77,75.27},{38.11,89.25},{36.97,88.58},{37.37,89.93},{38.78,90.08},{37.81,90.69},{36.23,91.34},{39.59,90.76},{40.95,91.92},{40.84,89.92},{40.95,88.34},{39.74,88.46},{41.76,86.51},{40.99,86.78},{41.76,88.12},{42.9,86.56},{42.56,73.22},{40.97,75.3},{43.72,72.28},{42.66,71.46},{40.65,70.75},},},nil,12,nil,nil,189,"AH",},
[114] = {'Harvest Watcher',300,328,14,15,0,{[40]={{38.0,47.84},{38.99,54.81},{49.88,21.29},{39.01,49.31},{50.09,22.56},{52.99,23.11},{40.76,52.19},{51.48,24.89},{38.14,50.79},{37.44,49.32},{50.98,23.16},{38.05,53.51},{36.14,50.85},{40.01,50.99},{39.14,52.09},{39.89,53.5},{52.01,23.44},{37.15,52.26},{51.7,21.73},{51.09,20.12},{43.65,35.13},{45.04,33.28},{45.61,33.21},{46.91,35.12},{45.9,36.14},{43.8,36.52},{53.9,35.16},{52.23,32.39},{54.01,30.98},{43.04,36.02},{54.35,32.19},{53.15,30.63},{53.29,33.63},{44.66,37.98},{55.29,33.7},},},nil,40,nil,nil,14,nil,},
[115] = {'Harvest Reaper',386,417,17,18,0,{[40]={{65.74,61.1},{65.64,62.08},{64.61,61.86},{65.56,62.11},{60.92,60.91},{62.97,57.68},{62.29,59.2},{65.03,60.33},{63.64,61.35},{61.58,62.0},},},nil,40,nil,nil,14,nil,},
[116] = {'Defias Bandit',156,176,8,9,0,{[12]={{31.02,57.51},{29.19,58.33},{29.54,57.91},{29.09,58.94},{29.88,58.22},{30.7,64.89},{30.59,65.04},{30.23,64.73},{30.34,64.53},{30.92,65.16},{31.34,64.88},{31.23,65.08},{44.37,74.93},{45.95,73.8},{46.35,75.41},{45.56,76.24},{47.48,74.13},{47.52,81.24},{46.79,82.98},{48.73,83.26},{46.6,85.53},{47.8,83.12},{49.69,83.85},{49.67,80.93},{50.6,82.99},{50.54,83.13},{68.28,77.72},{67.75,77.99},{68.12,80.49},{68.44,81.96},{71.31,76.71},{70.67,78.95},{68.46,77.36},{68.63,76.67},{70.71,81.53},{55.27,59.94},{52.51,59.06},{52.08,59.17},{52.21,59.39},{88.84,78.2},{89.19,79.2},{88.81,80.02},{89.6,79.35},{89.4,80.17},{89.94,78.21},{89.96,79.99},{90.2,79.09},},},{[12]={{52.09,59.18},{52.42,59.57},{52.75,59.48},{52.39,59.57},},},12,nil,nil,17,nil,},
[117] = {'Riverpaw Gnoll',222,247,11,12,0,{[40]={{57.87,13.24},{56.32,12.73},{56.56,12.95},{56.92,12.96},{56.29,13.38},{56.48,13.48},{52.33,14.06},{51.95,15.11},{52.11,14.79},{52.16,14.11},{44.74,13.95},{44.9,13.62},{44.63,16.24},{44.58,14.84},{44.98,14.35},{41.0,20.69},{41.93,20.52},{40.83,22.04},{45.61,16.6},{42.32,19.93},{41.7,19.38},{45.32,13.06},{57.9,13.45},{57.17,14.21},},},nil,40,nil,nil,20,nil,},
[118] = {'Prowler',176,198,9,10,0,{[12]={{75.49,76.54},{75.46,74.18},{76.63,63.67},{72.28,65.76},{72.39,65.15},{71.83,65.29},{72.26,64.82},{66.65,45.18},{64.61,43.33},{69.9,40.85},{70.53,41.86},{70.71,39.24},{71.43,37.45},{72.13,41.06},{77.45,74.47},{76.17,77.89},{76.16,75.97},{77.26,76.48},{77.76,78.09},{80.19,83.25},{80.28,81.12},{82.06,83.82},{80.72,81.38},{80.51,80.74},{80.81,81.16},{80.56,80.23},{81.29,82.53},{83.63,84.12},{83.01,85.51},{85.02,82.92},{80.58,78.82},{80.29,78.2},{81.48,77.9},{81.81,77.18},{79.03,76.18},{79.18,61.81},{78.38,62.72},{81.93,60.72},{79.99,60.74},{77.7,61.68},{78.58,60.85},{78.92,41.52},{77.46,40.88},{75.22,40.41},{76.58,40.56},{75.16,39.68},{73.67,40.46},{73.61,39.99},{75.41,37.33},{73.62,38.11},{74.06,37.59},{83.2,59.68},{80.32,78.12},{79.26,79.7},{79.17,82.75},{85.82,85.21},{85.66,83.94},{87.11,79.37},{87.14,77.41},{85.92,72.31},{83.83,71.99},{88.02,72.11},{87.36,68.46},{86.87,66.06},{88.67,68.58},{88.72,70.87},{87.76,63.75},{85.06,61.96},{85.02,61.97},{86.36,64.18},{86.35,63.78},{84.56,61.23},{85.9,61.25},{87.29,68.79},{87.86,78.32},{88.78,77.4},{89.63,75.0},{87.4,81.83},{87.6,81.27},{89.98,82.38},{91.14,78.83},{90.51,77.71},{87.05,69.21},},},nil,12,nil,nil,38,nil,},
[119] = {'Longsnout',198,222,10,11,0,{[10]={{6.75,7.02},{7.04,3.83},{6.15,10.28},{5.69,13.08},{5.28,8.96},{7.95,7.12},{5.21,7.56},{5.56,15.07},{6.09,11.6},},[12]={{25.48,82.24},{25.7,79.76},{25.01,84.77},{24.65,86.95},{24.33,83.75},{26.42,82.31},{24.28,82.66},{24.56,88.49},{24.97,85.8},},[40]={{67.59,18.99},{67.81,16.53},{67.13,21.5},{66.77,23.66},{66.45,20.48},{68.52,19.06},{66.4,19.41},{66.67,25.19},{67.08,22.52},},},nil,10,nil,nil,189,"AH",},
[121] = {'Defias Pathstalker',328,356,15,16,0,{[40]={{38.73,69.91},{38.98,69.39},{36.99,75.22},{37.41,75.38},{37.36,75.7},{49.33,77.33},{52.75,73.48},{51.2,75.18},{50.36,78.45},{46.18,79.2},{36.02,76.93},},},nil,40,nil,nil,17,nil,},
[122] = {'Defias Highwayman',386,417,17,18,0,{[40]={{46.38,78.29},{52.15,75.26},{52.55,73.76},{52.06,72.87},{52.66,78.42},{53.27,78.97},{53.05,78.75},{53.13,79.1},{50.84,75.21},{49.36,76.58},{46.91,81.1},{43.3,79.74},{39.02,79.31},{42.05,80.53},{41.01,79.47},{36.82,82.39},{37.1,82.52},{37.06,82.02},{37.08,80.48},{38.02,81.27},{38.09,80.64},{37.37,80.41},{48.14,77.25},{51.66,77.21},{60.76,58.23},{60.61,58.2},},},nil,40,nil,nil,17,nil,},
[123] = {'Riverpaw Mongrel',273,300,13,14,0,{[40]={{34.08,25.71},{32.8,29.37},{34.41,26.77},{34.31,26.6},{34.16,26.88},{34.28,27.26},{33.94,26.4},{37.49,34.1},{35.47,31.78},{36.61,31.59},{36.62,32.14},{39.13,31.74},{38.15,28.55},{30.13,49.41},{30.22,49.34},{30.09,49.8},{30.18,49.86},{30.46,50.74},{29.77,48.06},{30.42,47.99},{29.84,50.7},{30.39,52.4},{30.41,52.01},{30.68,51.85},{29.97,56.58},{30.26,57.93},{30.41,57.91},{30.32,58.1},{30.41,57.74},{28.93,64.71},{28.63,65.43},{29.19,66.08},{29.39,65.43},{29.46,65.31},{29.75,63.79},{29.93,66.25},{31.5,72.37},{31.32,72.09},{31.49,72.07},{35.51,61.52},{35.94,61.59},{36.79,31.7},{36.8,32.01},{29.91,59.6},{29.48,49.67},},},nil,40,nil,nil,20,nil,},
[124] = {'Riverpaw Brute',328,356,15,16,0,{[40]={{30.72,69.83},{32.15,69.03},{31.35,67.68},{31.02,69.34},{31.2,69.4},{32.63,68.52},{32.65,68.16},{32.52,68.52},{32.53,68.29},{32.83,69.14},{31.51,71.32},{31.23,72.94},{31.28,72.39},{48.17,61.92},{48.24,60.9},{48.35,60.83},{48.64,62.36},{53.32,60.79},{52.96,62.27},{52.9,62.79},{28.99,49.11},{64.93,73.16},{57.31,70.52},{30.37,67.77},{49.54,61.95},{52.14,63.12},},},nil,40,nil,nil,20,nil,},
[125] = {'Riverpaw Overseer',449,449,19,19,0,{[40]={{60.89,77.79},{63.48,77.56},},},nil,40,nil,nil,20,nil,},
[126] = {'Murloc Coastrunner',247,273,12,13,0,{[40]={{43.92,7.93},{44.9,8.18},{53.24,11.12},{53.13,8.86},{54.11,9.58},{45.37,8.21},{55.91,7.58},{44.47,8.75},{42.0,12.12},{47.41,9.38},{47.38,9.94},{44.69,7.87},{42.48,12.34},{42.7,12.33},{56.47,8.81},{41.97,9.71},{43.23,8.14},{42.78,8.99},{53.7,11.33},{45.02,8.89},{42.54,11.38},{55.72,8.95},{56.28,9.59},{55.82,8.23},{51.99,9.26},},},nil,40,nil,nil,18,nil,},
[127] = {'Murloc Tidehunter',377,404,18,19,0,{[40]={{28.44,70.33},{26.85,73.17},{25.9,73.72},{27.93,74.54},{26.63,73.84},{26.22,71.7},{26.46,74.78},{27.99,69.19},{28.19,69.29},{34.14,86.33},{34.58,84.31},{34.85,84.49},{34.77,84.22},{25.51,74.04},{26.77,72.12},{27.06,71.73},{26.59,71.99},{27.99,75.67},{35.35,84.24},{35.05,85.29},{35.04,85.41},{34.58,86.19},},},nil,40,nil,nil,18,nil,},
[151] = {'Brog Hamfist',396,396,10,10,0,{[12]={{43.96,65.92},},},nil,12,nil,nil,12,"A",},
[152] = {'Brother Danil',204,204,5,5,0,{[12]={{47.49,41.56},},},nil,12,nil,nil,12,"A",},
[154] = {'Greater Fleshripper',356,386,16,17,0,{[40]={{27.08,42.4},{26.58,44.1},{26.41,42.57},{61.93,49.25},{62.69,50.6},{59.4,52.32},{61.14,54.85},{63.86,55.1},{58.66,60.42},{59.41,62.69},{58.84,64.2},{62.56,60.65},{59.07,59.33},},},nil,40,nil,nil,73,nil,},
[157] = {'Goretusk',300,328,14,15,0,{[40]={{33.74,31.0},{39.13,27.87},{37.83,41.02},{41.18,33.18},{35.37,36.62},{33.63,37.86},{61.28,44.95},{60.91,47.67},{60.09,45.48},{59.75,42.52},{59.08,43.65},{45.11,50.54},{44.37,45.09},{38.1,42.55},{41.92,38.77},{43.87,52.16},{44.71,56.93},{48.3,52.61},{45.58,55.42},{43.97,39.63},{42.95,48.95},{57.12,59.2},{47.19,62.19},{46.43,55.97},{45.35,62.1},{51.2,59.03},{54.13,59.03},{53.88,64.89},{45.58,57.42},{41.28,57.62},{37.25,71.95},{39.44,60.89},{31.71,75.85},{37.18,63.65},{35.68,80.79},{35.21,69.35},{37.17,60.18},{43.71,62.16},{38.11,66.32},{46.33,51.78},{44.76,49.21},{42.86,43.57},{40.91,44.82},{31.68,78.15},{42.35,64.14},{34.73,79.4},{34.26,77.81},{40.79,39.81},{59.7,44.57},{56.09,63.73},{49.52,57.45},{44.59,59.08},{35.37,57.95},{51.4,60.62},},},nil,40,nil,nil,189,"AH",},
[167] = {'Morhan Coppertongue',656,656,15,15,0,{[38]={{34.02,46.54},},},nil,38,nil,nil,55,"A",},
[171] = {'Murloc Warrior',328,356,15,16,0,{[40]={{29.26,32.94},{31.76,26.12},{26.52,40.58},{27.69,39.08},{28.8,35.47},{28.98,35.57},{28.42,33.41},{28.44,32.85},{28.36,32.99},{29.37,27.27},{30.42,26.66},{29.39,28.62},{28.99,27.64},{25.34,48.01},{24.62,48.33},{24.72,48.89},{25.24,49.79},{26.01,47.4},{32.18,26.65},{29.31,34.44},{26.69,38.13},{27.72,33.68},{28.2,33.18},{28.33,29.42},{28.26,28.19},{24.99,48.88},{25.91,50.07},{25.79,47.95},{26.15,49.53},{35.37,21.8},{29.16,31.86},{35.65,20.76},{34.9,20.92},},},nil,40,nil,nil,18,nil,},
[190] = {'Dermot Johns',204,204,5,5,0,{[12]={{47.56,41.4},},},nil,12,nil,nil,12,"A",},
[193] = {'Blue Dragonspawn',6645,6876,50,51,1,{[16]={{39.5,76.38},{36.88,78.69},{36.88,75.82},{37.54,73.74},{36.36,72.88},{36.39,73.71},{36.37,74.64},},},nil,16,nil,nil,60,nil,},
[196] = {'Eagan Peltskinner',142,142,3,3,0,{[12]={{48.94,40.16},},},nil,12,{33,},{33,5261,},12,"A",},
[197] = {'Marshal McBride',968,968,20,20,0,{[12]={{48.92,41.61},},},nil,12,{7,15,21,54,3100,3101,3102,3103,3104,3105,},{7,15,21,783,},12,"A",},
[198] = {'Khelden Bremen',204,204,5,5,0,{[12]={{49.66,39.4},},},nil,12,nil,{3104,},12,"A",},
[199] = {'Young Fleshripper',198,222,10,11,0,{[40]={{52.43,18.72},{55.21,17.64},{49.53,24.7},{56.21,24.6},{58.83,13.86},{44.64,20.09},{47.82,18.22},{48.4,27.78},{59.85,32.32},{60.04,39.8},{61.29,40.17},{60.93,27.97},{61.0,29.33},{61.84,35.31},{62.83,27.84},{60.12,24.21},{48.93,35.86},{51.87,27.69},{52.73,35.7},{45.99,29.02},{49.41,37.23},{51.36,42.23},{43.58,18.8},{38.16,19.92},{38.08,32.12},{42.94,25.12},{54.17,39.78},{48.79,30.91},{53.68,43.89},{50.58,16.31},{42.97,33.75},{36.26,26.47},{41.95,16.46},{48.45,39.97},{57.15,39.72},{48.41,30.19},{52.42,27.74},},},nil,40,nil,nil,73,nil,},
[202] = {'Skeletal Horror',617,664,23,24,0,{[10]={{79.67,61.87},{81.71,60.52},{81.09,56.2},{81.99,57.14},{81.01,61.74},{17.79,47.89},{21.55,48.3},{22.29,47.59},{23.06,47.11},{14.53,47.91},{16.35,48.33},{14.06,42.2},{17.65,47.14},{24.19,43.29},{24.58,41.87},{14.38,46.23},{79.4,59.15},{16.29,45.54},{80.14,60.49},{21.26,42.93},{80.64,59.42},{79.23,57.54},{81.15,58.01},{20.58,47.5},{20.56,47.92},},},nil,10,nil,nil,21,nil,},
[203] = {'Skeletal Mage',472,504,22,23,0,{[10]={{78.15,75.64},{82.02,70.24},{82.04,71.97},{79.54,71.24},{79.71,69.33},{78.85,71.84},{79.58,74.45},{78.59,73.01},{79.77,66.05},{80.93,72.73},{76.92,68.16},{78.25,68.18},},},nil,10,nil,nil,21,nil,},
[205] = {'Nightbane Dark Runner',896,950,28,29,0,{[10]={{65.44,67.81},{65.64,66.97},{66.42,76.4},{66.01,69.17},{66.07,76.5},{65.62,67.22},{66.35,76.9},{65.43,67.68},{65.92,69.41},{65.45,75.72},{66.23,73.96},{66.09,75.06},{65.14,67.42},{65.56,77.48},{67.25,77.5},{63.69,73.44},{64.39,73.12},{63.95,73.72},{62.23,74.27},{60.55,75.31},{62.78,75.67},{61.61,75.49},{61.22,76.11},{60.92,75.19},{64.06,72.65},{60.38,74.47},{63.7,75.48},{61.1,73.35},{64.82,65.99},{65.58,65.92},{66.31,67.88},{64.59,69.21},{67.3,69.24},{65.15,70.01},{66.31,44.84},{67.59,45.86},{67.13,49.61},{66.24,47.75},{63.85,40.9},{62.14,42.74},{60.75,41.01},{60.09,40.91},{60.44,42.24},{60.03,39.6},{64.14,51.65},{62.19,38.8},{61.17,41.26},{60.75,41.5},{60.57,39.92},{60.0,45.24},{63.98,49.83},{64.28,50.85},{64.66,51.87},{63.24,50.77},{60.92,39.76},{60.89,41.69},{63.61,51.67},},},nil,10,nil,nil,24,nil,},
[206] = {'Nightbane Vile Fang',950,1003,29,30,0,{[10]={{62.64,79.82},{61.62,82.22},{62.69,79.23},{61.82,80.97},{61.9,81.86},{73.5,68.49},{72.41,67.38},{71.57,71.66},{71.94,72.31},{71.06,71.49},{71.76,72.84},{72.93,72.09},{72.04,74.71},{73.73,69.9},{72.45,69.58},{73.31,70.68},{72.32,70.19},{72.3,68.41},{73.01,72.72},{72.55,73.61},{73.38,72.59},},},nil,10,nil,nil,24,nil,},
[210] = {'Bone Chewer',788,840,26,27,0,{[10]={{25.54,28.1},{19.3,26.44},{18.15,27.3},{22.41,35.66},{25.8,32.88},{22.9,34.22},{24.34,37.54},{23.22,32.79},{24.76,34.69},{25.1,35.94},},},{[10]={{24.89,29.27},{24.71,30.97},{25.29,31.07},{25.74,30.27},{24.27,28.11},{24.19,27.4},{24.79,27.11},{25.3,27.21},{25.54,28.1},},[12]={{39.59,99.54},{39.11,98.64},{39.05,98.08},{39.51,97.86},{39.91,97.94},{40.1,98.63},},[40]={{81.58,36.15},{81.45,37.47},{81.89,37.54},{82.24,36.92},{81.1,35.25},{81.04,34.71},{81.5,34.49},{81.9,34.56},{82.08,35.25},},},10,nil,nil,21,nil,},
[212] = {'Splinter Fist Warrior',950,1003,29,30,0,{[10]={{35.3,79.35},{36.76,78.82},{36.57,80.01},{34.05,76.84},{33.08,75.21},{33.67,76.02},{34.68,75.65},{32.89,71.11},{32.37,70.27},{32.24,69.06},{32.88,69.56},},},nil,10,nil,nil,45,nil,},
[213] = {'Starving Dire Wolf',449,484,19,20,0,{[10]={{12.55,66.75},{86.21,16.15},{38.95,19.64},{36.72,21.57},{35.63,24.52},{35.82,20.94},{35.29,21.55},{37.72,19.21},{29.12,28.34},{40.03,19.12},{30.49,25.57},{31.57,27.15},{31.55,24.37},{43.93,20.35},{42.46,18.66},{41.26,20.49},{33.64,24.48},{45.01,18.51},{32.41,22.62},{33.56,26.75},{16.48,22.94},{10.82,29.53},{12.63,28.3},{22.0,28.96},{23.38,27.99},{22.58,25.95},{19.28,24.01},{17.36,23.26},{28.16,26.08},{25.38,25.99},{27.33,26.35},{77.09,19.09},{80.4,18.72},{57.81,15.58},{58.77,16.9},{63.93,17.11},{10.69,47.85},{46.55,16.77},},},nil,10,nil,nil,38,nil,},
[215] = {'Defias Night Runner',664,713,24,25,0,{[10]={{21.19,65.52},{21.3,65.47},{24.78,69.29},{22.86,68.35},{22.0,70.69},{20.12,67.97},{23.92,64.33},{50.73,71.37},{50.04,74.02},{49.0,72.2},{48.54,70.15},{48.98,74.3},{56.38,72.56},{53.08,74.66},{50.85,74.97},{52.09,76.84},},},nil,10,nil,nil,17,nil,},
[217] = {'Venom Web Spider',449,484,19,20,0,{[10]={{73.77,20.04},{56.25,14.55},{15.66,66.84},{17.25,67.56},{15.0,68.09},{70.81,21.59},{14.48,67.5},{78.0,24.25},{68.62,20.24},{15.7,72.62},{15.25,71.3},{66.7,20.77},{54.15,16.65},{60.21,18.62},{13.11,47.46},{10.47,44.65},{41.79,20.83},{47.62,17.9},{31.89,26.58},{18.85,27.31},{10.72,37.97},{9.25,40.01},{12.1,46.0},{62.49,18.47},{52.24,16.93},{22.09,28.19},{16.91,25.82},{57.47,18.56},{76.03,19.94},{49.81,18.31},{10.76,46.63},{11.2,54.81},{66.61,18.78},{66.2,18.1},},},nil,10,nil,nil,22,nil,},
[218] = {'Grave Robber',664,713,24,25,0,{[10]={{14.78,44.39},{14.54,44.4},{14.6,44.53},},},nil,10,nil,nil,17,nil,},
[222] = {'Nillen Andemar',898,898,19,19,0,{[38]={{42.87,9.89},},},nil,38,nil,nil,55,"A",},
[223] = {'Dan Golthas',617,617,23,23,0,{[1497]={{70.93,58.41},},},nil,1497,nil,nil,68,"H",},
[225] = {'Gavin Gnarltree',1003,1003,30,30,0,{[10]={{73.6,50.04},},},{[10]={{73.48,50.0},{73.64,49.6},{73.73,49.37},{73.81,49.09},{73.69,48.86},{73.61,48.9},{73.79,49.17},{73.71,49.41},{73.65,49.61},{73.6,50.04},},[41]={{12.7,45.0},{12.86,44.56},{12.96,44.32},{13.05,44.02},{12.92,43.77},{12.83,43.81},{13.03,44.1},{12.94,44.36},{12.87,44.58},{12.82,45.04},},},10,nil,nil,12,"A",},
[226] = {'Morg Gnarltree',1454,1454,28,28,0,{[10]={{73.97,48.89},},},{[10]={{73.98,48.87},{73.71,48.55},{73.68,48.55},{73.68,48.53},{73.97,48.89},},[41]={{13.23,43.78},{12.94,43.44},{12.9,43.43},{12.91,43.41},{13.22,43.8},},},10,nil,nil,12,"A",},
[227] = {'Mabel Solaj',788,788,26,26,0,{[10]={{74.21,44.81},},},nil,10,nil,nil,12,"A",},
[228] = {'Avette Fellwood',1172,1172,24,24,0,{[10]={{73.03,44.47},},},nil,10,nil,nil,12,"A",},
[232] = {'Farmer Ray',617,617,23,23,0,{[267]={{33.22,34.76},},},nil,267,nil,nil,88,"A",},
[233] = {'Farmer Saldean',919,919,20,20,0,{[40]={{56.04,31.23},},},nil,40,{9,109,},{9,},12,"A",},
[234] = {'Gryan Stoutmantle',1700,1700,35,35,1,{[40]={{56.33,47.52},},},nil,40,{12,13,14,65,135,142,144,166,},{12,13,14,109,132,141,142,143,155,166,},11,"A",},
[235] = {'Salma Saldean',919,919,20,20,0,{[40]={{56.42,30.52},},},nil,40,{22,38,},{22,36,38,},12,"A",},
[237] = {'Farmer Furlbrow',919,919,20,20,0,{[40]={{59.95,19.36},},},nil,40,{64,109,},{64,184,},12,"A",},
[238] = {'Verna Furlbrow',919,919,20,20,0,{[40]={{59.92,19.42},},},nil,40,{36,151,},{151,},12,"A",},
[239] = {'Grimbooze Thunderbrew',919,919,20,20,0,{[40]={{44.62,80.25},},},nil,40,{48,49,50,51,53,117,},{48,49,50,51,53,117,},55,"A",},
[240] = {'Marshal Dughan',1240,1240,25,25,0,{[12]={{42.11,65.93},},},nil,12,{35,59,62,76,109,147,239,},{39,40,54,62,76,123,147,176,},12,"A",},
[241] = {'Remy "Two Times"',166,166,5,5,0,{[12]={{42.14,67.26},},},nil,12,{40,47,},{47,},12,"A",},
[244] = {'Ma Stonefield',112,112,3,3,0,{[12]={{34.66,84.48},},},nil,12,{88,},{88,},12,"A",},
[246] = {'"Auntie" Bernice Stonefield',196,196,6,6,0,{[12]={{34.49,84.25},},},nil,12,{84,85,},{86,87,},12,"A",},
[247] = {'Billy Maclure',64,64,1,1,0,{[12]={{43.13,85.72},},},nil,12,{86,87,},{84,85,},12,"A",},
[248] = {'Gramma Stonefield',112,112,3,3,0,{[12]={{34.94,83.86},},},nil,12,{107,},{111,},12,"A",},
[250] = {'Pa Maclure',196,196,6,6,0,{[12]={{42.72,89.24},},},nil,12,nil,nil,12,"A",},
[251] = {'Maybell Maclure',87,87,2,2,0,{[12]={{43.15,89.62},},},nil,12,{106,},{114,},12,"A",},
[252] = {'Tommy Joe Stonefield',87,87,2,2,0,{[12]={{29.84,86.0},},},nil,12,{111,},{106,},12,"A",},
[253] = {'William Pestle',196,196,6,6,0,{[12]={{43.32,65.7},},},nil,12,{60,61,112,114,},{60,107,112,},12,"A",},
[255] = {'Gerard Tiller',196,196,6,6,0,{[12]={{43.1,85.5},},},nil,12,{16,},{16,},12,"A",},
[257] = {'Kobold Worker',70,70,3,3,0,{[12]={{48.83,35.59},{49.18,35.31},{48.22,35.87},{47.5,35.82},{47.29,36.61},{47.63,35.88},{47.45,35.78},{47.17,35.12},{48.73,33.79},{48.4,33.61},{48.9,32.8},{49.31,34.68},{48.09,34.03},{47.98,33.12},{47.64,32.91},{47.07,33.66},{47.53,32.64},{47.22,32.64},{46.84,33.43},{47.36,33.18},{46.55,32.47},{46.3,32.2},{46.27,32.79},{47.35,32.27},{47.7,32.02},{47.4,33.97},{47.59,31.44},{49.82,34.64},{49.93,34.27},{50.23,33.83},{50.17,34.24},{51.02,35.55},{51.57,36.23},{52.15,36.37},{52.09,35.84},{51.27,37.75},{50.83,37.92},{51.51,36.61},{51.06,38.19},{51.52,38.02},{51.66,37.66},{50.05,33.1},},},{[12]={{47.5,35.82},{47.48,36.3},},},12,nil,nil,25,nil,},
[258] = {'Joshua Maclure',166,166,5,5,0,{[12]={{42.36,89.38},},},nil,12,nil,nil,12,"A",},
[261] = {'Guard Thomas',1605,1605,30,30,0,{[12]={{73.97,72.18},},},nil,12,{37,39,46,52,109,},{35,46,52,71,},12,"A",},
[263] = {'Lord Ello Ebonlocke',1605,1605,30,30,0,{[10]={{71.93,46.42},},},nil,10,{146,251,253,},{145,160,252,253,},12,"A",},
[264] = {'Commander Althea Ebonlocke',2972,2972,45,45,0,{[10]={{73.59,46.9},},},nil,10,{56,57,58,80,98,228,229,},{56,57,58,79,97,227,228,},53,"A",},
[265] = {'Madame Eva',1240,1240,25,25,0,{[10]={{75.81,45.3},},},nil,10,{66,101,149,157,265,},{98,101,148,154,262,},12,"A",},
[266] = {'Wiley the Black',1309,1309,26,26,0,{[44]={{26.48,45.35},},},nil,44,{132,},{65,},12,"A",},
[267] = {'Clerk Daltry',1684,1684,31,31,0,{[10]={{72.53,46.85},},},nil,10,{67,69,97,266,1042,},{66,68,80,265,1041,},12,"A",},
[268] = {'Sirra Von\'Indi',1172,1172,24,24,0,{[10]={{72.64,47.61},},},nil,10,{227,252,401,},{225,251,401,},12,"A",},
[269] = {'Role Dreuger',2471,2471,40,40,0,{[10]={{71.98,46.7},},},nil,10,nil,nil,12,"A",},
[270] = {'Councilman Millstipe',1454,1454,28,28,0,{[10]={{71.92,47.79},},},nil,10,{377,},{377,},12,"A",},
[271] = {'Ambassador Berrybuck',1605,1605,30,30,0,{[10]={{72.14,47.31},},},nil,10,nil,nil,12,"A",},
[272] = {'Chef Grual',1605,1605,30,30,0,{[10]={{73.75,43.48},},},{[10]={{73.83,43.19},{73.84,43.44},{73.89,43.45},{73.87,43.45},{73.9,43.95},{73.83,44.06},{73.85,44.05},{73.89,43.92},{73.8,43.48},{73.75,43.48},},[41]={{13.07,37.65},{13.08,37.92},{13.13,37.93},{13.12,37.93},{13.15,38.46},{13.07,38.58},{13.09,38.58},{13.14,38.43},{13.04,37.96},{12.99,37.96},},},10,{90,93,240,},{5,90,93,},12,"A",},
[273] = {'Tavernkeep Smitts',1042,1042,22,22,0,{[10]={{73.78,44.49},},},nil,10,{79,156,159,453,},{78,156,158,266,},12,"A",},
[274] = {'Barkeep Hann',1309,1309,26,26,0,{[10]={{73.66,44.05},},},nil,10,nil,nil,12,"A",},
[275] = {'Whit Wantmal',1380,1380,27,27,0,{[10]={{78.97,44.33},},},nil,10,nil,nil,12,"A",},
[276] = {'Viktori Prism\'Antras',1454,1454,28,28,0,{[10]={{79.8,48.02},},},nil,10,{174,175,181,},{174,177,181,},12,"A",},
[277] = {'Roberto Pupellyverbos',1605,1605,30,30,0,{[1519]={{52.15,67.75},},},nil,1519,nil,nil,12,"A",},
[278] = {'Sara Timberlain',166,166,5,5,0,{[12]={{79.46,68.79},},},nil,12,{83,},{59,83,},12,"A",},
[279] = {'Morgan Pestle',1605,1605,30,30,0,{[1519]={{56.2,64.58},},},nil,1519,{9025,},{61,9024,},12,"A",},
[284] = {'Brown Horse',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[285] = {'Murloc',120,137,6,7,0,{[12]={{56.67,66.28},{56.65,66.54},{56.43,66.73},{56.75,67.45},{56.04,66.79},{56.85,66.86},{53.7,66.76},{53.8,65.53},{49.83,66.41},{50.6,66.21},{56.97,67.25},{56.37,66.72},{56.69,65.91},{55.85,67.64},{55.3,66.16},{55.64,66.73},{55.43,66.8},{54.9,66.75},{55.31,66.26},{54.95,66.44},{55.17,66.14},{54.64,66.27},{54.58,66.87},{54.44,66.79},{54.33,66.81},{54.41,66.33},{54.82,65.31},{53.97,66.36},{52.73,65.22},{52.0,68.73},{51.16,67.09},{50.7,67.13},{50.29,67.63},{50.38,66.2},{50.18,66.83},},},{[12]={{56.04,66.79},{56.35,66.74},{56.36,66.6},{56.38,66.31},{56.39,66.09},{54.41,66.32},{54.29,66.22},{54.19,66.25},{54.12,66.19},{54.19,66.26},{54.31,66.23},{54.49,66.42},{54.56,66.3},{54.7,66.04},{54.8,65.89},{54.52,66.51},{54.56,66.39},},[40]={{97.9,3.66},{98.2,3.61},{98.21,3.47},{98.23,3.19},{98.24,2.97},{96.28,3.2},{96.16,3.1},{96.06,3.13},{95.99,3.07},{96.06,3.14},{96.18,3.11},{96.36,3.3},{96.43,3.18},{96.56,2.92},{96.67,2.77},{96.39,3.39},{96.42,3.27},},},12,nil,nil,18,nil,},
[288] = {'Jitters',1240,1240,25,25,0,{[10]={{18.38,56.37},},},{[10]={{18.38,56.37},{18.31,56.26},{18.21,56.24},{18.14,56.36},{18.16,56.53},{18.25,56.59},{18.34,56.51},},[40]={{76.56,57.06},{76.51,56.97},{76.43,56.96},{76.38,57.05},{76.39,57.18},{76.46,57.23},{76.53,57.17},},},10,{5,268,},{163,240,453,},12,"A",},
[289] = {'Abercrombie',2016,2016,35,35,0,{[10]={{28.11,31.46},},},nil,10,{133,134,148,158,160,},{133,134,157,159,165,},12,"A",},
[294] = {'Marshal Haggard',919,919,20,20,0,{[12]={{84.61,69.38},},},nil,12,{75,78,1667,},{74,75,1666,1667,},12,"A",},
[295] = {'Innkeeper Farley',1605,1605,30,30,0,{[12]={{43.77,65.8},},},nil,12,{70,},{69,2158,},12,"A",},
[297] = {'Caretaker Folsom',1605,1605,30,30,0,{[1519]={{29.57,61.93},},},nil,1519,{72,},{70,},12,"A",},
[299] = {'Young Wolf',42,42,1,1,0,{[12]={{42.72,62.81},{41.55,58.29},{42.9,55.38},{45.38,55.41},{44.53,58.34},{47.52,46.91},{45.64,43.81},{45.76,44.57},{46.1,44.94},{46.76,44.53},{46.66,43.74},{47.98,45.92},{45.67,43.14},{45.34,42.61},{45.76,42.33},{48.67,45.55},{48.32,46.81},{46.25,40.1},{45.69,40.6},{46.37,42.3},{45.94,40.78},{46.7,40.93},{47.55,40.46},{48.83,38.33},{46.77,39.8},{47.42,37.85},{46.86,38.04},{45.53,39.09},{47.3,39.54},{47.12,38.35},{46.53,38.05},{46.24,38.42},{48.03,39.61},{48.08,38.84},{49.4,37.62},{48.36,37.44},{45.93,38.23},{46.87,37.54},{46.27,37.14},{52.07,41.64},{50.86,44.44},{49.39,45.26},{44.83,57.55},{42.81,62.26},{42.61,60.99},},},nil,12,nil,nil,32,"AH",},
[300] = {'Zzarc\' Vul',1050,1050,33,33,0,{[10]={{36.81,83.79},},},nil,10,nil,nil,45,nil,},
[302] = {'Blind Mary',1847,1847,40,40,0,{[10]={{81.99,59.09},},},nil,10,{154,177,},{149,175,},12,"A",},
[304] = {'Felsteed',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[305] = {'Riding Horse (White Stallion)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[306] = {'Riding Horse (Palomino)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[307] = {'Pinto',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[308] = {'Black Stallion',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[311] = {'Sven Yorgen',919,919,20,20,0,{[10]={{7.78,34.07},},},nil,10,{55,95,262,269,323,},{55,164,230,268,323,325,},12,"A",},
[313] = {'Theocritus',1172,1172,24,24,0,{[12]={{65.22,69.71},},},nil,12,{94,},{178,249,},12,"A",},
[314] = {'Eliza',2309,2309,31,31,1,nil,nil,0,nil,nil,14,nil,},
[315] = {'Stalvan Mistmantle',1586,1586,32,32,0,{[10]={{77.35,36.19},},},nil,10,nil,nil,14,nil,},
[325] = {'Hogan Ference',919,919,20,20,0,{[10]={{72.26,48.16},},},nil,10,nil,nil,12,"A",},
[327] = {'Goldtooth',156,156,8,8,0,{[12]={{41.71,78.04},},},nil,12,nil,nil,26,nil,},
[328] = {'Zaldimar Wefhellt',546,546,13,13,0,{[12]={{43.25,66.19},},},nil,12,{1860,},nil,12,"A",},
[329] = {'Earth Elemental',2571,2675,54,55,0,nil,nil,0,nil,nil,7,"AH",},
[330] = {'Princess',176,176,9,9,0,{[12]={{69.66,79.25},},},{[10]={{63.57,4.02},{63.68,3.46},{63.75,2.65},{63.59,2.19},{63.01,2.09},{62.64,2.69},{62.57,3.53},{62.77,3.99},{63.2,4.31},},[12]={{69.68,79.9},{69.77,79.47},{69.82,78.84},{69.7,78.48},{69.24,78.4},{68.96,78.87},{68.9,79.52},{69.06,79.88},{69.39,80.13},},},12,nil,nil,7,"AH",},
[331] = {'Maginor Dumas',3139,3139,60,60,0,{[1519]={{38.19,81.79},},},nil,1519,nil,nil,12,"A",},
[332] = {'Master Mathias Shaw',4079,4079,62,62,0,{[1519]={{75.78,59.84},},},nil,1519,{141,350,395,2206,2360,2607,6183,6184,},{135,393,394,2205,2206,2359,6182,6183,},12,"A",},
[334] = {'Gath\'Ilzogg',2250,2250,26,26,1,{[44]={{69.61,55.79},},},nil,44,nil,nil,40,nil,},
[335] = {'Singe',1584,1584,24,24,1,{[44]={{69.75,56.07},},},nil,44,nil,nil,40,nil,},
[338] = {'Mazen Mac\'Nadir',2868,2868,44,44,0,{[1519]={{41.52,64.39},},},nil,1519,{1363,},nil,12,"A",},
[340] = {'Kendor Kabonka',3517,3517,50,50,0,{[1519]={{74.69,36.51},},},nil,1519,nil,nil,12,"A",},
[341] = {'Foreman Oslow',919,919,20,20,0,{[44]={{32.14,48.64},},},nil,44,{89,125,347,},{89,125,345,},12,"A",},
[342] = {'Martie Jainrose',919,919,20,20,0,{[44]={{21.86,46.33},},},nil,44,{34,131,},{34,130,},12,"A",},
[343] = {'Chef Breanna',860,860,19,19,0,{[44]={{22.68,43.84},},},nil,44,{92,},{92,},12,"A",},
[344] = {'Magistrate Solomon',2100,2100,36,36,0,{[44]={{29.99,44.45},},},nil,44,{120,143,145,4184,4223,},{121,144,146,169,180,4183,4186,},12,"A",},
[345] = {'Bellygrub',1139,1139,24,24,0,{[44]={{15.68,49.31},},},nil,44,nil,nil,14,nil,},
[346] = {'Barkeep Daniels',980,980,21,21,0,{[44]={{26.48,43.96},},},nil,44,{116,},{116,},12,"A",},
[347] = {'Grizzle Halfmane',9563,9563,61,61,1,{[1497]={{56.13,85.3},},},nil,1497,nil,nil,1214,"H",},
[348] = {'Zem Leeward',1240,1240,25,25,0,{[44]={{26.25,50.81},},},nil,44,nil,nil,12,"A",},
[349] = {'Corporal Keeshan',2199,2199,25,25,1,{[44]={{28.39,12.55},},},nil,44,{219,},nil,12,"A",},
[352] = {'Dungar Longdrink',7842,7842,55,55,1,{[1519]={{66.27,62.13},},},nil,1519,{6285,},{6261,},12,"A",},
[356] = {'Black Wolf',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[358] = {'Timber Wolf',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[359] = {'Riding Wolf (Winter)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[372] = {'Karm Ironquill',695,695,16,16,0,{[38]={{37.13,47.16},},},nil,38,nil,nil,12,"A",},
[374] = {'Cog Glitzspinner',1605,1605,30,30,0,{[10]={{77.3,48.7},},},nil,10,nil,nil,875,"A",},
[375] = {'Priestess Anetta',166,166,5,5,0,{[12]={{49.81,39.49},},},nil,12,{5623,},{3103,},12,"A",},
[376] = {'High Priestess Laurena',3139,3139,60,60,0,{[1519]={{38.58,26.01},},},nil,1519,{5641,5673,8254,},{5634,5635,5636,5637,5638,5639,5676,5677,},12,"A",},
[377] = {'Priestess Josetta',546,546,13,13,0,{[12]={{43.28,65.72},},},nil,12,{5624,5628,5637,},{5623,5624,},12,"A",},
[379] = {'Darcy',644,644,15,15,0,{[44]={{26.62,44.3},},},{[44]={{26.91,44.82},{27.12,45.03},{26.91,44.82},{26.62,44.3},{26.91,44.82},{26.59,45.44},{27.09,45.65},{26.59,45.44},{27.12,45.03},{26.62,44.3},},},44,{129,},{131,},12,"A",},
[381] = {'Dockmaster Baren',919,919,20,20,0,{[44]={{27.72,47.38},},},nil,44,{127,150,},{127,150,},12,"A",},
[382] = {'Marshal Marris',1389,1389,35,35,0,{[44]={{33.5,48.97},},},nil,44,{19,20,115,},{19,20,115,219,},12,"A",},
[383] = {'Jason Mathers',228,228,7,7,0,{[12]={{47.46,62.18},},},nil,12,nil,nil,12,"A",},
[384] = {'Katie Hunter',413,413,10,10,0,{[12]={{84.15,65.49},},},nil,12,{7677,7678,},{7677,7678,},12,"A",},
[385] = {'Horse',164,164,5,5,0,{[44]={{88.36,70.92},{88.2,70.07},},[12]={{83.48,63.78},},},nil,44,nil,nil,35,"AH",},
[390] = {'Porcine Entourage',137,137,7,7,0,{[12]={{69.61,79.15},{69.73,79.18},},},nil,12,nil,nil,7,"AH",},
[391] = {'Old Murk-Eye',581,581,20,20,0,{[40]={{34.0,84.03},},},{[33]={{6.56,5.23},{6.69,5.41},{6.84,5.36},{6.91,5.23},{6.87,4.8},{6.65,4.41},{6.23,4.27},{5.0,3.6},{3.98,2.21},{3.59,1.13},{3.52,0.57},{3.47,0.11},{3.53,0.59},{3.63,1.34},{4.17,2.49},{4.49,3.17},{5.21,3.89},{5.83,4.36},{6.1,4.49},{6.56,5.23},{6.56,5.23},{6.69,5.41},{6.84,5.36},{6.91,5.23},{6.87,4.8},{6.65,4.41},{6.23,4.27},{5.0,3.6},{3.98,2.21},{3.59,1.13},{3.52,0.57},{3.47,0.11},{3.53,0.59},{3.63,1.34},{4.17,2.49},{4.49,3.17},{5.21,3.89},{5.83,4.36},{6.1,4.49},{6.56,5.23},},[40]={{34.7,85.34},{34.93,85.68},{35.21,85.57},{35.34,85.34},{35.26,84.55},{34.86,83.84},{34.09,83.58},{31.85,82.36},{29.99,79.83},{29.29,77.86},{29.16,76.83},{28.55,73.47},{28.55,73.47},{27.79,72.26},{27.36,70.18},{27.06,68.45},{27.13,66.93},{26.73,65.99},{26.38,66.04},{26.28,66.55},{26.47,67.48},{26.75,68.42},{27.26,70.65},{28.29,72.18},{28.44,74.75},{29.07,76.0},{29.18,76.88},{29.36,78.24},{30.34,80.34},{30.92,81.57},{32.23,82.9},{33.37,83.75},{33.86,83.98},{34.7,85.34},{34.7,85.34},{34.93,85.68},{35.21,85.57},{35.34,85.34},{35.26,84.55},{34.86,83.84},{34.09,83.58},{31.85,82.36},{29.99,79.83},{29.29,77.86},{29.16,76.83},{28.55,73.47},{28.55,73.47},{27.79,72.26},{27.36,70.18},{27.06,68.45},{27.13,66.93},{26.73,65.99},{26.38,66.04},{26.28,66.55},{26.47,67.48},{26.75,68.42},{27.26,70.65},{28.29,72.18},{28.44,74.75},{29.07,76.0},{29.18,76.88},{29.36,78.24},{30.34,80.34},{30.92,81.57},{32.23,82.9},{33.37,83.75},{33.86,83.98},{34.7,85.34},},},40,nil,nil,18,nil,},
[392] = {'Captain Grayson',1605,1605,30,30,0,{[40]={{30.01,86.02},},},nil,40,{103,104,152,},{103,104,152,},35,"AH",},
[395] = {'Markus',64,64,1,1,0,{[12]={{34.28,57.8},},},nil,12,nil,nil,12,"A",},
[397] = {'Morganth',1794,1794,26,26,1,{[44]={{80.11,49.49},},},nil,44,nil,nil,39,nil,},
[412] = {'Stitches',12200,12200,35,35,1,nil,nil,0,nil,nil,7,"AH",},
[415] = {'Verner Osgood',1240,1240,25,25,0,{[44]={{30.97,47.27},},},nil,44,{118,122,124,126,},{119,122,124,126,1618,},12,"A",},
[416] = {'Imp',177,177,5,5,0,nil,nil,0,nil,nil,14,nil,},
[417] = {'Felhunter',2529,2529,60,60,0,nil,nil,0,nil,nil,115,"A",},
[422] = {'Murloc Flesheater',417,449,18,19,0,{[44]={{60.93,61.57},{59.39,61.07},{60.21,62.09},{59.99,62.75},{46.58,51.48},{57.72,62.06},{58.51,59.45},{60.0,62.36},{43.87,54.24},{55.95,60.3},{57.53,61.97},{57.87,60.83},{50.35,70.88},{47.7,71.22},{40.13,48.2},{40.17,45.03},{41.88,49.43},{42.54,50.47},{40.76,55.64},{39.14,47.09},},},nil,44,nil,nil,18,nil,},
[423] = {'Redridge Mongrel',328,356,15,16,0,{[44]={{43.62,71.07},{15.63,59.53},{29.41,84.35},{34.46,82.9},{15.06,60.98},{14.84,61.47},{15.57,66.59},{44.4,72.3},{14.51,65.82},{32.44,82.82},{31.05,84.02},{29.86,84.12},{16.74,63.0},{32.05,82.49},{40.13,73.01},{30.35,81.2},{15.3,63.92},{16.74,62.18},},},{[12]={{99.76,68.1},{99.24,69.11},{98.76,68.94},{98.45,66.94},{98.11,66.54},{98.45,66.94},{98.76,68.94},{99.24,69.11},{99.7,66.19},{99.65,65.95},{99.5,65.72},{99.26,65.64},{99.01,65.71},{98.78,67.07},{99.89,67.88},{99.96,66.35},},[44]={{16.41,64.98},{15.57,66.59},{14.82,66.32},{14.31,63.12},{13.77,62.48},{14.31,63.12},{14.82,66.32},{15.57,66.59},{44.52,71.58},{43.87,70.55},{43.42,70.49},{43.07,69.32},{43.42,70.49},{43.87,70.55},{44.52,71.58},{44.4,72.3},{43.74,72.93},{42.52,72.62},{42.01,71.88},{41.79,70.83},{42.01,71.88},{42.52,72.62},{43.74,72.93},{44.4,72.3},{42.2,71.25},{42.93,70.95},{42.26,71.46},{40.44,72.57},{40.13,73.01},{16.31,61.92},{16.24,61.54},{16.0,61.17},{15.61,61.05},{15.21,61.16},{14.85,63.34},{16.63,64.62},{17.23,65.58},{17.78,65.52},{17.83,64.47},{17.57,63.36},{17.23,62.52},{16.74,62.18},},[8]={{13.59,0.07},{12.97,0.66},{11.82,0.37},{11.82,0.37},{12.97,0.66},{13.59,0.07},{9.84,0.32},{9.55,0.74},},},44,nil,nil,19,nil,},
[424] = {'Redridge Poacher',356,386,16,17,0,{[44]={{43.17,70.63},{43.34,71.27},{29.27,83.65},{29.07,84.38},{35.34,83.82},{34.69,83.09},{34.69,82.84},{32.28,82.28},{32.01,82.73},{32.1,82.9},{30.91,84.22},{42.99,71.19},{41.44,72.35},{31.3,81.14},{32.39,79.49},{30.97,79.5},{28.34,79.41},},},{[44]={{43.04,72.03},{43.51,72.48},{43.97,73.47},{43.56,72.76},{43.01,71.87},{42.99,71.19},{43.28,70.97},{42.99,71.19},{42.26,71.46},{42.2,71.25},{42.93,70.95},{42.26,71.46},{41.44,72.35},{40.44,72.57},{41.44,72.35},},[8]={{12.75,0.24},{13.19,1.17},{12.8,0.5},{10.79,0.11},{9.84,0.32},{10.79,0.11},},},44,nil,nil,19,nil,},
[426] = {'Redridge Brute',386,417,17,18,0,{[44]={{24.0,34.91},{21.49,36.22},{21.24,36.09},{21.21,36.41},{20.14,33.25},{24.12,32.62},{24.05,37.29},{29.52,37.88},{22.59,38.32},{20.84,40.03},{38.89,31.77},{38.54,31.75},{38.81,31.58},{40.65,32.02},{39.54,31.44},{40.34,35.01},},},{[44]={{21.87,38.31},{21.36,38.75},{21.87,38.31},{22.59,38.32},{23.18,36.43},{23.15,34.95},{23.61,33.58},{23.15,34.95},{23.18,36.43},{22.59,38.32},{40.04,34.08},{39.78,33.22},{38.99,32.35},{39.77,33.2},{40.04,34.08},{40.28,34.92},{40.37,35.93},{40.34,35.01},},},44,nil,nil,19,nil,},
[428] = {'Dire Condor',417,449,18,19,0,{[44]={{59.79,76.07},{55.26,76.78},{57.06,76.24},{60.79,78.28},{61.51,76.42},{64.12,76.42},{54.34,40.28},{55.18,46.11},{52.41,38.79},{57.28,44.92},{35.46,70.23},{45.96,77.49},{55.26,73.4},{42.16,32.38},{45.77,35.81},{50.08,33.94},{47.28,32.49},{48.61,34.95},{50.67,74.67},{57.1,41.58},},},nil,44,nil,nil,14,nil,},
[429] = {'Shadowhide Darkweaver',640,684,25,26,0,{[44]={{80.02,49.78},{80.29,49.48},{79.05,48.69},{75.76,30.32},{80.28,54.3},{81.29,56.46},{80.44,55.16},{83.41,57.92},{82.42,53.35},{79.81,54.29},{84.8,52.67},{81.06,54.83},{78.98,49.42},{74.01,35.88},{85.47,48.07},{80.22,52.75},{79.81,46.35},{79.68,45.17},{79.52,48.83},{79.09,47.63},{76.24,34.67},{79.95,38.63},{79.96,44.25},},},nil,44,nil,nil,39,nil,},
[430] = {'Redridge Mystic',354,379,18,19,0,{[44]={{32.07,29.43},{33.56,22.56},{28.58,28.25},{24.76,31.74},{28.06,28.89},{22.67,26.51},{20.24,32.95},{26.83,35.66},{24.01,37.28},{26.98,37.23},{16.9,17.73},{36.09,37.38},{28.47,27.93},{34.46,25.44},{34.49,25.15},{37.29,36.0},{27.05,23.0},{31.11,23.51},{27.69,21.98},{25.63,22.95},{21.66,35.28},{23.35,27.36},{23.91,29.81},{41.81,33.98},{39.21,30.81},{39.73,35.01},{29.38,21.99},{33.12,25.53},},},{[44]={{20.83,35.81},{21.66,35.28},{22.56,36.14},{22.28,37.73},{22.56,36.14},{21.66,35.28},},},44,nil,nil,19,nil,},
[431] = {'Shadowhide Slayer',734,788,25,26,0,{[44]={{83.88,57.98},{83.61,57.52},{82.8,59.27},{81.81,55.94},{81.68,54.91},{84.69,56.36},{84.64,57.4},{74.27,36.16},{75.9,30.05},{74.21,35.54},{82.18,47.78},{81.01,48.61},{80.98,49.05},{79.72,49.5},{80.26,48.56},{77.12,53.86},{77.53,55.46},{78.59,52.95},{80.18,37.06},},},{[44]={{80.26,48.54},{80.08,47.9},{79.54,47.7},{79.06,48.15},{79.0,49.05},{79.25,49.61},{79.95,49.56},{80.23,48.85},},},44,nil,nil,39,nil,},
[432] = {'Shadowhide Brute',617,664,23,24,0,{[44]={{73.48,54.93},{80.31,40.59},{76.56,37.38},{79.0,41.01},{75.14,46.32},{77.06,45.46},{80.28,35.11},{78.96,40.45},{79.21,40.91},{78.87,37.01},{79.94,37.88},{81.38,44.2},{81.22,36.3},},},nil,44,nil,nil,39,nil,},
[433] = {'Shadowhide Gnoll',573,617,22,23,0,{[44]={{73.29,54.82},{73.38,55.71},{73.54,55.36},{75.67,47.17},{75.82,47.53},{77.37,54.54},{75.23,49.82},{75.92,51.06},{74.91,52.17},{72.28,51.47},{71.51,58.9},{72.54,58.95},{76.57,45.29},{74.25,49.17},{68.72,45.71},{76.84,45.67},{74.13,40.75},{74.69,44.13},{71.94,43.86},},},nil,44,nil,nil,39,nil,},
[434] = {'Rabid Shadowhide Gnoll',530,570,21,22,0,{[44]={{75.48,47.66},{73.41,53.94},{75.9,46.84},{75.64,46.87},{75.02,49.97},{75.01,49.65},{73.01,58.41},{71.35,54.24},{72.74,54.84},{72.27,40.37},},},{[44]={{76.9,49.52},{76.58,50.81},{76.61,53.06},{77.85,55.35},{76.61,53.06},{76.58,50.81},{76.9,49.52},{75.48,47.66},},},44,nil,nil,39,nil,},
[435] = {'Blackrock Champion',664,713,24,25,0,{[44]={{27.25,16.42},{27.48,16.27},{29.62,14.14},{27.24,9.96},{26.95,9.73},{26.58,8.19},{35.7,7.65},{34.44,7.85},{34.43,6.72},{30.36,9.93},{30.95,7.22},{31.45,5.66},{30.46,8.81},{29.52,8.53},{29.34,12.05},{28.58,11.69},{29.6,11.22},{31.44,12.83},{28.56,15.4},{28.6,17.25},{28.16,16.83},{28.69,13.88},{30.59,15.45},{31.68,13.12},},},{[44]={{27.53,10.88},{27.48,11.82},{27.53,10.88},{27.24,9.96},{27.23,8.38},{28.16,8.12},{28.79,8.71},{30.26,8.82},{30.87,9.55},{31.32,10.89},{30.87,9.55},{30.26,8.82},{28.79,8.71},{28.16,8.12},{27.23,8.38},{27.24,9.96},},[46]={{64.92,87.15},{64.89,87.85},{64.92,87.15},{64.71,86.47},{64.7,85.3},{65.39,85.11},{65.86,85.55},{66.95,85.63},{67.4,86.16},{67.74,87.16},{67.4,86.16},{66.95,85.63},{65.86,85.55},{65.39,85.11},{64.7,85.3},{64.71,86.47},},},44,nil,nil,40,nil,},
[436] = {'Blackrock Shadowcaster',1389,1482,22,23,1,{[44]={{69.73,54.1},{69.34,55.5},{66.55,56.49},{66.96,56.25},{66.14,56.93},{67.08,54.1},{69.95,57.39},{68.22,54.62},{68.97,55.54},{69.58,54.27},{68.31,56.34},{69.05,56.81},{69.0,55.39},{65.44,54.76},{69.54,58.36},{63.69,59.07},{68.16,59.01},},},nil,44,nil,nil,40,nil,},
[437] = {'Blackrock Renegade',531,573,21,22,0,{[44]={{77.84,66.98},{79.72,64.5},{76.99,67.24},{78.79,69.16},{76.09,69.11},{77.14,67.01},{44.38,12.42},{48.17,16.5},{43.54,18.4},{43.49,18.19},{60.32,65.44},{59.99,65.74},},},nil,44,nil,nil,40,nil,},
[440] = {'Blackrock Grunt',449,484,19,20,0,{[44]={{76.71,74.32},{70.72,78.65},{73.85,78.31},{73.57,79.05},{76.54,80.59},{77.57,86.11},{60.99,42.82},{61.14,43.4},{75.11,84.09},{75.62,82.95},{76.39,82.95},{74.88,81.61},{62.4,45.33},{62.55,45.65},{59.02,43.7},{59.43,44.33},{59.78,41.95},{59.6,42.21},{62.45,41.4},{38.94,40.66},{39.04,40.82},{40.6,41.38},{38.24,41.16},},},nil,44,nil,nil,40,nil,},
[441] = {'Black Dragon Whelp',330,354,17,18,0,{[44]={{66.91,76.61},{43.51,77.96},{51.78,74.68},{53.83,76.22},{54.61,73.69},{58.64,74.77},{57.65,78.38},{57.89,77.32},{60.55,75.18},{61.36,78.62},{23.88,63.18},{65.94,76.3},{62.24,75.13},{48.34,77.37},{27.74,63.28},{50.08,78.09},{30.75,75.67},{23.8,35.21},{36.39,72.7},{42.4,33.02},{31.98,74.76},{34.25,73.37},{42.65,29.58},{43.65,40.86},{46.27,35.37},{34.85,68.44},{33.26,66.97},{37.0,63.0},{33.13,63.27},{33.92,76.45},{37.75,72.77},{35.97,73.87},{27.41,74.53},{35.84,63.34},},},nil,44,nil,nil,14,nil,},
[442] = {'Tarantula',328,356,15,16,0,{[44]={{11.42,93.26},{13.33,93.07},{12.85,85.19},{10.73,80.6},{11.16,79.63},{9.83,76.68},{13.76,82.14},{8.95,85.07},{10.03,86.4},{12.62,78.16},{12.41,76.98},{20.15,65.41},{22.43,66.36},{14.11,75.69},{11.66,72.67},{8.78,77.02},{35.02,75.08},{22.8,76.34},{19.51,71.69},{18.15,71.73},{26.57,75.84},{22.22,67.25},},},nil,44,nil,nil,22,nil,},
[445] = {'Redridge Alpha',458,494,21,22,0,{[44]={{17.24,17.83},{27.55,21.36},{27.97,21.6},{27.24,23.11},{26.46,21.25},{27.43,21.75},{25.72,23.41},},},nil,44,nil,nil,19,nil,},
[446] = {'Redridge Basher',417,449,19,20,0,{[44]={{32.44,29.17},{32.29,29.38},{28.32,30.49},{28.89,30.16},{27.49,27.37},{27.38,29.43},{29.87,31.19},{28.55,31.48},{19.53,21.68},{23.73,29.13},{19.51,23.92},{21.94,15.29},{17.57,19.85},{18.63,18.15},{19.38,25.88},{23.11,18.3},{18.35,23.13},{16.7,21.92},{20.47,29.91},{17.9,19.45},{28.26,28.43},{28.31,27.8},{28.7,25.63},{34.09,25.26},{34.3,25.0},{35.22,25.76},{31.91,24.02},{23.56,25.24},{23.38,25.38},{23.51,26.23},{23.3,26.75},{23.46,24.15},{35.33,27.98},{30.98,22.78},{34.04,24.8},},},{[44]={{23.51,26.77},{23.73,29.13},{24.21,30.93},{23.73,29.13},{19.82,30.28},{19.44,30.78},{19.42,31.63},{19.44,30.78},{19.82,30.28},{20.47,29.91},{20.82,29.36},{20.88,28.23},{20.11,27.76},{19.3,25.56},{18.8,24.44},{19.04,23.74},{19.45,21.99},{19.04,23.74},{18.8,24.44},{19.29,25.52},{20.11,27.76},{20.88,28.23},{20.82,29.36},{20.47,29.91},{18.53,20.34},{19.18,20.53},{19.72,20.45},{20.24,20.71},{20.45,21.2},{20.42,21.78},{20.45,21.21},{20.24,20.71},{19.72,20.45},{19.18,20.53},{18.53,20.34},{17.9,19.45},{16.72,19.28},{15.8,18.95},{15.85,20.7},{16.37,21.75},{17.54,22.69},{16.37,21.75},{15.85,20.7},{15.8,18.95},{16.72,19.28},{17.9,19.45},},[46]={{61.95,98.94},{59.42,99.67},{58.83,98.04},{58.46,97.21},{58.64,96.69},{58.93,95.39},{58.64,96.69},{58.46,97.21},{58.82,98.01},{59.42,99.67},{58.25,94.17},{58.74,94.31},{59.14,94.25},{59.52,94.44},{59.68,94.81},{59.66,95.23},{59.68,94.81},{59.52,94.44},{59.14,94.25},{58.74,94.31},{58.26,94.17},{57.79,93.51},{56.91,93.38},{56.24,93.14},{56.27,94.44},{56.65,95.22},{57.52,95.91},{56.65,95.22},{56.27,94.44},{56.24,93.14},{56.91,93.38},{57.79,93.51},},[12]={{99.95,39.52},{99.38,39.31},{99.41,40.4},{99.73,41.06},{99.73,41.06},{99.41,40.4},{99.38,39.31},{99.95,39.52},},},44,nil,nil,19,nil,},
[448] = {'Hogger',666,666,11,11,1,{[12]={{26.83,86.69},},},{[10]={{8.48,12.74},{7.69,14.05},{7.2,15.54},{6.93,16.33},{6.42,18.86},{6.29,20.44},{5.56,21.53},{6.83,22.18},{8.15,21.37},{7.79,19.55},{8.16,18.72},{7.57,14.76},},[12]={{26.83,86.69},{26.21,87.7},{25.83,88.86},{25.62,89.48},{25.22,91.44},{25.12,92.67},{24.56,93.52},{25.54,94.03},{26.57,93.4},{26.29,91.98},{26.58,91.33},{26.12,88.25},},[40]={{68.93,23.4},{68.31,24.41},{67.93,25.56},{67.72,26.17},{67.34,28.12},{67.23,29.34},{66.67,30.18},{67.65,30.68},{68.67,30.06},{68.39,28.65},{68.68,28.01},{68.22,24.95},},},12,nil,nil,20,nil,},
[449] = {'Defias Knuckleduster',356,386,15,17,0,{[40]={{36.94,75.84},{37.23,75.33},{38.72,73.44},{35.2,71.83},{49.54,78.92},{49.26,78.89},{51.59,78.18},{46.63,81.43},{36.25,80.28},{37.66,75.15},{50.87,78.62},{50.48,78.75},{36.41,74.57},{60.66,58.78},{60.5,59.25},},},nil,40,nil,nil,17,nil,},
[450] = {'Defias Renegade Mage',354,379,18,19,0,{[40]={{37.36,75.23},{36.93,82.64},},[33]={{7.78,3.75},},},nil,40,nil,nil,17,nil,},
[452] = {'Riverpaw Bandit',356,386,16,17,0,{[40]={{47.71,62.43},{48.17,61.22},{48.4,61.28},{53.44,63.35},{53.1,62.69},{52.81,62.37},{54.32,62.28},{57.22,70.68},{56.52,69.27},{55.81,69.73},{56.23,71.0},{56.35,70.17},{56.3,70.02},{56.37,69.76},{56.52,69.78},{56.25,73.49},{57.22,73.03},{56.27,74.19},{56.55,74.31},{60.56,70.5},{60.66,70.68},{59.98,69.93},{59.39,74.4},{59.51,74.3},{59.3,74.06},{59.27,74.3},{63.97,70.09},{63.8,70.41},{63.92,70.34},{63.8,70.03},{64.6,70.53},{63.01,69.58},{60.79,69.14},{62.6,70.77},{61.1,71.17},{58.71,73.87},{56.32,75.3},{51.96,63.05},{49.65,60.81},{50.12,60.34},},},nil,40,nil,nil,20,nil,},
[453] = {'Riverpaw Mystic',377,404,18,19,0,{[40]={{60.76,74.11},{61.46,77.07},{61.05,77.57},{62.74,77.68},{61.77,75.73},{63.06,76.51},{63.58,77.22},{63.53,73.16},{65.81,76.68},{65.08,75.08},{60.84,72.59},{60.58,75.45},},},nil,40,nil,nil,20,nil,},
[454] = {'Young Goretusk',247,273,12,13,0,{[40]={{49.75,23.52},{54.15,26.72},{52.39,17.55},{55.27,19.55},{46.62,19.34},{48.71,19.14},{56.09,20.77},{58.36,12.38},{58.86,13.66},{56.92,16.1},{59.99,33.57},{63.17,38.22},{61.92,27.84},{60.6,30.0},{62.91,23.58},{61.17,36.45},{60.26,32.3},{53.88,40.91},{57.07,39.22},{54.18,42.2},{44.32,30.45},{52.7,39.86},{56.22,42.48},{42.77,28.23},{42.18,23.68},{39.41,33.77},{40.94,30.05},{37.35,30.68},{37.77,25.94},{34.31,34.79},{36.16,34.96},{33.54,34.46},{51.35,23.27},{52.11,20.52},{51.19,20.25},{49.17,41.61},{55.22,43.72},{49.88,36.76},{50.42,29.35},{49.51,42.21},{52.96,46.17},{53.71,45.05},{52.09,41.17},{52.3,44.9},{43.85,32.24},},},nil,40,nil,nil,189,"AH",},
[456] = {'Murloc Minor Oracle',253,276,12,14,0,{[40]={{34.12,17.17},{34.24,15.86},{33.94,16.12},{34.41,16.13},{42.95,11.67},{42.23,11.47},{38.5,14.29},{38.87,14.7},{33.89,16.72},{33.54,17.08},{33.99,16.78},{33.45,15.14},{34.38,15.71},{33.9,16.37},{33.52,17.65},{34.67,18.42},{34.28,15.91},{34.01,17.41},{44.79,7.65},{44.97,8.06},{43.02,8.18},{41.24,10.19},{43.53,9.24},},},nil,40,nil,nil,18,nil,},
[458] = {'Murloc Hunter',356,386,16,17,0,{[40]={{28.85,35.84},{29.08,27.4},{28.73,27.18},{30.34,28.6},{30.2,27.52},{30.26,25.39},{26.58,60.33},{25.22,56.56},{25.25,56.23},{26.57,48.26},{24.83,48.27},{25.53,46.98},{27.59,35.11},{27.78,37.98},{29.62,27.75},{29.26,26.43},{27.48,59.94},{27.75,59.91},{27.71,58.61},{27.4,57.94},{25.8,49.06},{25.19,48.64},{25.66,46.85},{25.43,48.9},{27.58,40.66},{26.6,36.51},{26.69,39.0},{25.19,55.33},{25.21,55.03},{23.69,57.32},{27.83,53.98},{27.83,54.24},{27.3,54.78},},},nil,40,nil,nil,18,nil,},
[459] = {'Drusilla La Salle',166,166,5,5,0,{[12]={{49.87,42.65},},},nil,12,{1598,},{1598,3105,},12,"A",},
[460] = {'Alamar Grimm',166,166,5,5,0,{[1]={{28.65,66.14},},},nil,1,{1599,},{1599,3115,},875,"A",},
[461] = {'Demisette Cloyce',3139,3139,60,60,0,{[1519]={{25.28,78.22},},},nil,1519,{4488,4738,4968,8419,},nil,12,"A",},
[462] = {'Vultros',788,788,26,26,4,{[40]={{50.64,43.55},{40.62,60.52},{36.77,62.52},{46.12,57.69},{45.66,60.08},{44.15,46.17},{45.44,43.95},{46.81,44.19},{51.08,23.81},{54.8,23.2},{63.25,57.03},{63.93,58.17},{65.52,58.72},{62.05,75.5},{61.53,73.9},{62.59,74.19},},},nil,40,nil,nil,73,nil,},
[464] = {'Guard Parker',1605,1605,30,30,0,{[44]={{15.27,71.46},},},nil,44,{130,244,},{129,},11,"A",},
[465] = {'Barkeep Dobbins',413,413,10,10,0,{[12]={{44.0,65.69},},},nil,12,nil,nil,12,"A",},
[466] = {'General Marcus Jonathan',9835,9835,60,60,1,{[1519]={{63.97,75.32},},},nil,1519,{121,},{120,},12,"A",},
[467] = {'The Defias Traitor',329,329,15,15,0,{[40]={{55.68,47.5},},},nil,40,{155,},nil,10,"A",},
[468] = {'Town Crier',2016,2016,35,35,0,{[10]={{74.96,46.77},},},{[10]={{74.93,46.78},{74.94,45.58},{75.42,45.4},{74.94,45.5},{74.6,46.58},{73.85,46.37},{73.81,45.58},{73.84,46.14},{73.71,46.66},{73.33,46.72},{73.14,46.76},{72.56,46.87},{73.14,46.76},{73.33,46.72},{73.59,46.72},{74.12,47.84},{74.97,47.32},{75.13,47.57},{75.2,48.1},{75.14,47.02},{74.93,46.78},{74.94,45.58},{75.42,45.4},{74.94,45.5},{74.6,46.58},{73.85,46.37},{73.81,45.58},{73.84,46.14},{73.71,46.66},{73.33,46.72},{73.14,46.76},{72.56,46.87},{73.14,46.76},{73.33,46.72},{73.59,46.72},{74.12,47.84},{74.97,47.32},{75.13,47.57},{75.2,48.1},{75.14,47.02},},[41]={{14.26,41.52},{14.26,40.23},{14.79,40.03},{14.27,40.14},{13.9,41.31},{13.09,41.08},{13.05,40.23},{13.08,40.83},{12.94,41.39},{12.53,41.46},{12.33,41.5},{11.7,41.62},{12.33,41.5},{12.53,41.46},{12.81,41.46},{13.38,42.67},{14.3,42.1},{14.48,42.38},{14.54,42.94},{14.49,41.78},{14.26,41.52},{14.26,40.23},{14.79,40.03},{14.27,40.14},{13.9,41.31},{13.09,41.08},{13.05,40.23},{13.08,40.83},{12.94,41.39},{12.53,41.46},{12.33,41.5},{11.7,41.62},{12.33,41.5},{12.53,41.46},{12.81,41.46},{13.38,42.67},{14.3,42.1},{14.48,42.38},{14.54,42.94},{14.49,41.78},},},10,nil,nil,12,"A",},
[469] = {'Lieutenant Doren',61040,61040,60,60,1,{[33]={{38.04,3.01},},},nil,33,{200,202,330,},{202,215,329,331,574,},12,"A",},
[471] = {'Mother Fang',198,198,10,10,4,{[12]={{62.14,48.05},},},nil,12,nil,nil,22,nil,},
[472] = {'Fedfennel',247,247,12,12,4,{[12]={{68.13,44.87},{66.48,40.89},{67.94,39.57},{69.12,38.86},},},nil,12,nil,nil,20,nil,},
[473] = {'Morgan the Collector',198,198,10,10,0,{[12]={{71.09,80.65},},},nil,12,nil,nil,17,nil,},
[474] = {'Defias Rogue Wizard',160,178,9,10,0,{[12]={{29.13,60.88},{28.89,62.18},{28.99,62.65},{28.33,59.69},{29.72,61.03},{50.65,83.23},{52.72,59.04},{72.57,46.36},{71.66,49.74},{74.44,46.97},{73.37,49.76},{71.74,52.03},{74.46,49.3},{73.63,51.16},{73.38,52.48},{74.16,50.94},{74.07,51.78},{72.5,56.41},{72.33,55.03},{73.12,54.16},{74.52,53.95},{74.56,52.39},{74.89,52.09},{73.95,55.64},{77.17,51.68},{76.59,53.38},{76.83,48.63},{76.04,47.44},},},nil,12,nil,nil,17,nil,},
[475] = {'Kobold Tunneler',105,124,5,6,0,{[12]={{36.03,82.7},{36.19,79.12},{38.81,81.85},{37.3,80.58},{38.51,82.26},{39.01,80.66},{39.02,81.19},{38.02,81.63},{38.5,81.47},{37.57,79.01},{38.71,78.57},{38.87,81.5},{38.1,82.6},{37.7,84.86},{37.4,83.45},{37.98,83.81},{38.74,83.81},{36.73,84.02},{38.58,84.05},{39.06,82.63},{39.04,81.36},{39.33,83.2},{40.77,81.09},{40.51,81.22},{40.65,81.56},{39.08,85.03},{39.81,84.19},{39.42,80.36},{39.6,82.13},{40.34,82.53},{39.7,82.86},{40.72,78.29},{41.07,78.24},{41.25,80.41},{41.08,80.29},{41.79,79.67},{40.77,78.35},{40.23,77.54},{37.82,87.05},},},{[10]={{24.14,5.8},{24.14,5.33},{24.19,5.01},{24.33,4.77},{24.52,4.64},{24.76,4.57},{24.94,4.52},{25.15,4.45},{25.29,4.27},{25.34,4.05},{25.21,4.36},{24.97,4.5},{24.79,4.53},{24.52,4.6},{24.24,4.81},{24.13,5.15},{24.14,5.45},{23.58,9.37},{23.13,9.91},{22.76,10.55},{22.66,11.05},{22.48,11.9},{22.35,12.45},{22.49,11.85},{22.65,11.09},{22.73,10.72},{23.14,9.88},{23.59,9.35},{23.99,8.74},{24.22,8.0},{24.18,7.54},{24.08,7.2},{23.96,6.98},{23.8,6.78},{23.99,7.0},{24.1,7.21},{24.19,7.57},{24.23,8.04},{23.99,8.75},{26.24,6.16},{26.14,6.55},{26.05,6.87},{25.91,7.23},{25.7,7.45},{25.49,7.46},{25.21,7.34},{24.99,7.4},{24.89,7.71},{25.0,7.3},{25.26,7.36},{25.44,7.44},{25.65,7.5},{25.88,7.37},{26.04,7.03},{26.12,6.74},{26.16,6.48},{26.25,6.15},{26.31,5.79},{26.79,1.9},{26.88,2.37},{27.01,2.85},{27.11,3.27},{27.18,3.6},{27.27,3.86},{27.34,4.01},{27.46,4.27},{27.59,4.73},{27.42,4.19},{27.32,3.93},{27.26,3.79},{27.17,3.55},{27.07,3.04},{26.94,2.63},{26.88,2.35},{26.8,1.93},{26.75,1.69},{26.68,1.16},{26.75,1.68},{26.38,2.0},{26.1,1.86},{25.93,1.83},{25.76,1.9},{25.95,1.84},{26.11,1.87},{26.36,2.0},{26.61,2.03},{26.8,1.92},{27.15,1.73},{27.44,1.64},{27.59,1.87},{27.56,2.11},{27.48,2.6},{27.33,2.9},{27.17,3.17},{27.13,3.4},{27.2,3.19},{27.35,2.91},{27.5,2.58},{27.55,2.35},{27.59,1.9},{27.38,1.58},{27.03,1.79},{26.81,1.96},{26.54,2.07},},[12]={{39.01,81.29},{39.0,80.92},{39.04,80.67},{39.16,80.49},{39.3,80.39},{39.49,80.33},{39.63,80.3},{39.79,80.23},{39.9,80.1},{39.94,79.93},{39.84,80.16},{39.65,80.27},{39.51,80.3},{39.3,80.35},{39.08,80.52},{39.0,80.78},{39.0,81.02},{38.57,84.06},{38.22,84.48},{37.93,84.98},{37.86,85.37},{37.72,86.03},{37.62,86.46},{37.73,86.0},{37.85,85.41},{37.91,85.12},{38.23,84.46},{38.58,84.05},{38.89,83.57},{39.07,83.0},{39.04,82.64},{38.96,82.38},{38.86,82.21},{38.74,82.05},{38.89,82.22},{38.98,82.39},{39.04,82.66},{39.07,83.03},{38.89,83.58},{40.64,81.57},{40.56,81.87},{40.49,82.12},{40.39,82.4},{40.22,82.57},{40.06,82.58},{39.84,82.49},{39.67,82.53},{39.59,82.78},{39.67,82.45},{39.88,82.5},{40.02,82.57},{40.18,82.61},{40.36,82.51},{40.49,82.24},{40.55,82.02},{40.58,81.82},{40.65,81.56},{40.69,81.28},{41.07,78.25},{41.14,78.62},{41.24,78.99},{41.32,79.32},{41.37,79.58},{41.44,79.78},{41.5,79.9},{41.59,80.1},{41.69,80.46},{41.56,80.04},{41.48,79.83},{41.44,79.72},{41.37,79.54},{41.29,79.15},{41.19,78.82},{41.14,78.61},{41.08,78.28},{41.04,78.09},{40.99,77.68},{41.04,78.08},{40.75,78.33},{40.53,78.23},{40.4,78.2},{40.26,78.26},{40.41,78.21},{40.54,78.23},{40.73,78.34},{40.93,78.36},{41.08,78.27},{41.35,78.12},{41.57,78.05},{41.69,78.23},{41.67,78.42},{41.61,78.8},{41.49,79.03},{41.37,79.24},{41.33,79.42},{41.39,79.26},{41.5,79.04},{41.62,78.78},{41.66,78.61},{41.69,78.26},{41.52,78.01},{41.26,78.17},{41.09,78.3},{40.87,78.39},},[40]={{81.01,18.05},{81.0,17.68},{81.04,17.44},{81.15,17.25},{81.3,17.15},{81.48,17.1},{81.62,17.06},{81.78,17.0},{81.89,16.87},{81.93,16.69},{81.83,16.93},{81.64,17.04},{81.51,17.07},{81.29,17.12},{81.08,17.28},{80.99,17.54},{81.0,17.78},{80.57,20.8},{80.22,21.22},{79.94,21.71},{79.86,22.1},{79.72,22.75},{79.63,23.18},{79.73,22.72},{79.86,22.13},{79.92,21.84},{80.23,21.2},{80.58,20.78},{80.89,20.31},{81.07,19.74},{81.04,19.39},{80.96,19.13},{80.86,18.96},{80.74,18.81},{80.89,18.97},{80.97,19.14},{81.04,19.41},{81.07,19.77},{80.89,20.32},{82.63,18.32},{82.55,18.63},{82.48,18.87},{82.37,19.15},{82.21,19.32},{82.04,19.33},{81.83,19.23},{81.66,19.28},{81.58,19.52},{81.66,19.2},{81.87,19.25},{82.01,19.31},{82.17,19.36},{82.34,19.25},{82.47,18.99},{82.53,18.77},{82.56,18.57},{82.63,18.32},{82.67,18.04},{83.05,15.03},{83.12,15.4},{83.22,15.77},{83.29,16.09},{83.35,16.35},{83.41,16.55},{83.47,16.66},{83.57,16.86},{83.66,17.22},{83.53,16.8},{83.45,16.6},{83.41,16.49},{83.34,16.31},{83.27,15.92},{83.17,15.6},{83.12,15.38},{83.06,15.06},{83.02,14.87},{82.97,14.47},{83.02,14.87},{82.73,15.11},{82.51,15.01},{82.39,14.99},{82.25,15.04},{82.4,14.99},{82.53,15.02},{82.71,15.12},{82.91,15.14},{83.06,15.05},{83.33,14.9},{83.55,14.84},{83.66,15.01},{83.64,15.2},{83.58,15.58},{83.46,15.81},{83.34,16.01},{83.31,16.19},{83.37,16.03},{83.48,15.81},{83.59,15.56},{83.63,15.39},{83.66,15.04},{83.5,14.79},{83.23,14.95},{83.07,15.09},{82.85,15.17},},},12,nil,nil,26,nil,},
[476] = {'Kobold Geomancer',126,142,7,8,0,{[12]={{64.75,56.89},{63.53,58.32},{64.49,56.55},{64.5,56.72},{62.2,55.74},{60.97,56.51},{61.26,51.66},{61.15,49.26},},},{[12]={{64.75,56.89},{64.56,56.64},{64.41,56.44},{64.01,55.87},{63.48,55.33},{63.15,54.98},{62.83,54.65},{62.59,54.42},{62.84,54.67},{63.34,55.19},{63.59,55.44},{63.93,55.77},{64.36,56.27},{64.58,56.62},{61.22,51.63},{61.35,51.57},{61.45,51.97},{61.34,52.26},{61.35,52.65},{61.47,53.0},{61.65,53.68},{61.6,53.46},{61.46,53.09},{61.36,52.73},{61.3,52.37},{61.44,52.09},{61.43,51.7},{61.15,49.26},{60.91,49.4},{60.55,49.8},{60.5,50.3},{60.62,50.84},{60.51,50.45},{60.46,49.87},{60.77,49.65},},},12,nil,nil,26,nil,},
[478] = {'Riverpaw Outrunner',176,198,9,10,0,{[12]={{27.45,79.89},{26.28,84.99},{27.3,82.43},{26.35,81.43},{26.5,86.84},{26.32,86.84},{25.4,88.62},{27.42,86.25},{27.56,86.06},{25.13,87.04},{25.63,90.48},{25.31,89.11},{25.14,89.24},{26.69,90.19},{27.49,89.48},{26.11,92.1},{25.99,92.09},{28.03,88.22},{27.76,88.45},{28.45,88.2},{28.55,87.28},{25.41,94.21},{25.97,92.69},{23.75,94.09},{24.28,93.78},{24.46,94.11},{24.82,92.9},{26.48,95.37},{27.71,94.51},{28.6,92.99},{28.04,81.29},{68.64,54.77},{68.17,50.88},{68.19,48.88},{67.8,45.66},{68.1,45.13},{67.83,44.94},{68.87,45.19},{68.82,43.22},{67.7,42.3},{66.73,43.79},{69.07,40.38},{67.85,40.19},{68.19,38.75},{67.62,39.24},{67.99,39.75},{66.02,41.0},{65.73,42.13},{66.9,40.61},{66.61,40.35},{66.67,40.95},{66.66,41.32},{68.85,38.82},{69.66,39.28},{69.61,38.66},{69.23,38.37},{76.8,40.2},{72.92,38.3},},},nil,12,nil,nil,20,nil,},
[480] = {'Rusty Harvest Golem',176,198,9,10,0,{[40]={{53.9,25.11},{57.13,21.18},{55.32,24.57},{54.39,25.59},{57.41,19.83},{57.09,20.08},{54.37,24.37},{56.58,20.99},{54.98,25.08},{53.38,25.56},{53.42,24.99},{58.25,16.64},{59.06,18.25},{57.47,18.15},{58.19,19.01},{57.46,20.78},},},nil,40,nil,nil,14,nil,},
[481] = {'Defias Footpad',198,222,10,11,0,{[40]={{56.1,19.17},{56.52,19.29},{56.66,18.91},{56.83,19.16},{56.75,19.79},},},nil,40,nil,nil,17,nil,},
[482] = {'Elling Trias',1605,1605,30,30,0,{[1519]={{59.91,64.18},},},nil,1519,{394,1243,1246,1248,2745,},{350,434,1242,1245,1247,},12,"A",},
[483] = {'Elaine Trias',1605,1605,30,30,0,{[1519]={{60.59,63.24},},},nil,1519,nil,nil,12,"A",},
[485] = {'Blackrock Outrunner',494,531,20,21,0,{[44]={{77.7,69.43},{75.65,63.64},{77.69,67.33},{78.03,67.43},{68.94,78.36},{71.49,74.83},{69.93,76.74},{75.1,74.3},{75.35,72.57},{72.87,74.64},{77.88,73.25},{77.19,67.16},{72.39,80.07},{72.3,81.67},{74.38,78.76},{77.39,85.68},{77.79,85.69},{77.01,83.37},{60.64,43.04},{76.01,84.63},{62.7,45.54},{60.23,42.13},{62.65,41.45},{44.53,19.42},{42.53,17.95},{64.55,62.05},{37.06,45.23},{37.09,45.58},{37.21,45.75},{63.0,63.41},{38.31,41.25},{45.39,38.89},{40.17,40.68},},},{[44]={{63.04,63.3},{64.39,61.95},{63.4,62.94},{62.29,64.05},{40.16,40.55},{40.59,39.05},{41.09,37.14},{41.52,36.77},{41.76,37.0},{41.48,36.98},{41.09,37.64},{40.66,38.73},{40.52,40.0},{40.17,40.68},},},44,nil,nil,40,nil,},
[486] = {'Tharil\'zun',1800,1800,24,24,1,{[44]={{69.26,59.89},},},nil,44,nil,nil,40,nil,},
[487] = {'Protector Bialon',1905,1905,30,30,0,{[40]={{55.71,47.41},},},nil,40,nil,nil,11,"A",},
[488] = {'Protector Weaver',1605,1605,30,30,0,{[40]={{56.8,46.89},},},nil,40,nil,nil,11,"A",},
[489] = {'Protector Dutfield',3141,3141,30,30,0,{[40]={{56.62,47.91},},},{[40]={{56.62,47.95},{56.88,48.0},{57.27,47.87},{57.47,47.28},{57.35,46.63},{56.83,46.31},{56.37,46.8},{56.32,47.33},{56.56,47.88},{56.62,47.95},{56.88,48.0},{57.27,47.87},{57.47,47.28},{57.35,46.63},{56.83,46.31},{56.37,46.8},{56.32,47.33},{56.56,47.88},},},40,nil,nil,11,"A",},
[490] = {'Protector Gariel',1901,1901,30,30,0,{[40]={{55.96,48.2},},},nil,40,nil,nil,11,"A",},
[491] = {'Quartermaster Lewis',919,919,20,20,0,{[40]={{57.0,47.17},},},nil,40,{6181,},{6285,},12,"A",},
[494] = {'Watcher Bukouris',2016,2016,35,35,0,{[10]={{73.21,45.87},},},nil,10,nil,nil,11,"A",},
[495] = {'Watcher Keefer',2284,2284,38,38,0,{[10]={{74.64,46.39},},},{[10]={{74.64,46.46},{73.91,46.54},{73.72,47.0},{73.9,47.56},{74.34,47.78},{74.64,47.06},{74.64,46.46},{73.91,46.54},{73.72,47.0},{73.9,47.56},{74.34,47.78},{74.64,47.06},},[41]={{13.94,41.18},{13.16,41.26},{12.95,41.76},{13.15,42.36},{13.62,42.6},{13.94,41.83},{13.94,41.18},{13.16,41.26},{12.95,41.76},{13.15,42.36},{13.62,42.6},{13.94,41.83},},},10,nil,nil,11,"A",},
[499] = {'Watcher Paige',896,896,28,28,0,{[10]={{45.01,67.66},},},nil,10,nil,nil,56,"A",},
[500] = {'Riverpaw Scout',247,273,12,13,0,{[40]={{56.5,12.59},{56.3,13.59},{52.14,15.2},{52.21,14.87},{44.95,14.04},{45.02,13.69},{43.87,16.57},{44.72,14.16},{46.41,15.11},{42.16,22.01},{41.76,20.69},{41.95,20.9},{41.82,20.45},{36.46,31.7},{36.61,31.89},{38.99,31.95},{40.17,33.19},{37.12,28.26},{38.1,28.32},{34.0,29.19},{33.72,28.25},{42.91,14.89},{45.05,12.62},},},nil,40,nil,nil,20,nil,},
[501] = {'Riverpaw Herbalist',300,328,14,15,0,{[40]={{30.35,49.58},{31.3,48.96},{29.57,50.82},{31.49,50.85},{30.51,51.75},{30.66,52.1},{31.63,52.32},{30.56,58.04},{30.25,57.51},{29.12,65.28},{29.16,65.53},{31.27,70.63},{32.75,68.42},{32.8,67.98},{32.47,73.72},{31.55,72.27},{32.3,72.23},{35.75,61.14},{31.75,73.38},{31.04,69.63},{29.64,52.27},{30.39,53.69},},},nil,40,nil,nil,20,nil,},
[502] = {'Benny Blaanco',328,328,15,15,0,{[40]={{49.47,18.99},},},nil,40,nil,nil,17,nil,},
[503] = {'Lord Malathrom',935,935,31,31,4,{[10]={{21.14,27.19},{20.31,28.83},{22.07,28.35},{22.77,28.87},{24.67,29.37},{24.51,31.24},{25.92,30.9},},},nil,10,nil,nil,21,nil,},
[504] = {'Defias Trapper',247,273,12,13,0,{[40]={{43.94,25.19},{44.52,24.59},{48.8,20.36},{48.32,19.21},{48.72,20.86},{48.83,20.68},{31.71,32.93},{31.41,33.82},{31.33,33.72},{31.32,33.62},{31.32,32.55},{30.93,33.09},{32.03,33.89},{41.55,41.05},{46.82,39.06},{45.99,38.19},{46.4,36.92},{47.39,36.32},{50.64,39.32},{48.17,46.72},{44.79,22.04},{46.64,27.33},{44.82,22.4},{46.11,39.06},{46.7,52.51},{44.68,24.0},{49.83,19.76},{48.56,47.7},{47.15,46.18},{40.77,39.55},{32.24,34.62},{31.67,34.58},{32.54,33.4},{47.73,43.36},{51.07,39.42},{51.4,46.79},{50.67,47.22},{47.76,45.85},{48.53,45.24},},},nil,40,nil,nil,17,nil,},
[505] = {'Greater Tarantula',449,484,19,20,0,{[44]={{67.21,76.56},{53.71,36.38},{52.9,38.98},{53.8,38.16},{53.88,43.18},{53.81,43.6},{55.13,43.15},{55.92,43.36},{52.63,38.4},{51.86,41.23},{50.59,40.6},{57.13,46.63},{47.83,38.46},{52.4,42.09},},},nil,44,nil,nil,22,nil,},
[506] = {'Sergeant Brashclaw',417,417,18,18,4,{[40]={{36.88,31.85},},},nil,40,nil,nil,20,nil,},
[507] = {'Fenros',1404,1404,32,32,4,{[10]={{61.72,36.85},{61.52,38.99},{60.68,40.7},{60.78,43.71},{62.19,45.92},{61.21,49.87},{63.88,51.77},{63.75,47.13},},},nil,10,nil,nil,24,nil,},
[510] = {'Water Elemental',2998,2998,60,60,0,nil,nil,0,nil,nil,115,"A",},
[511] = {'Insane Ghoul',788,788,26,26,0,{[10]={{80.9,71.96},},},{[4]={{3.26,19.94},{3.22,19.77},{3.18,19.59},{3.16,19.49},{3.16,19.49},{3.16,19.75},{3.13,19.56},{3.21,19.64},{3.25,19.61},{3.18,19.42},{3.18,19.43},{3.28,19.54},{3.22,19.47},{3.19,19.43},{3.24,19.34},{3.29,19.54},{3.16,19.56},{3.2,19.54},{3.22,19.63},{3.23,19.64},{3.32,19.79},{3.22,19.9},{3.16,19.77},{3.15,19.39},{3.17,19.41},{3.2,19.45},{3.25,19.51},{3.4,19.73},{3.23,19.77},{2.93,19.37},{2.5,19.0},{2.33,18.27},{1.86,17.95},{1.59,17.24},{1.09,18.31},{1.1,19.22},{1.49,19.55},{1.38,19.93},{1.82,20.67},{2.34,20.8},{2.56,20.45},{2.26,19.97},{2.54,19.07},{3.0,19.4},},[10]={{80.9,71.96},{80.85,71.75},{80.8,71.53},{80.77,71.41},{80.77,71.41},{80.78,71.72},{80.74,71.49},{80.84,71.59},{80.88,71.56},{80.79,71.32},{80.8,71.32},{80.92,71.46},{80.85,71.37},{80.8,71.32},{80.88,71.21},{80.93,71.47},{80.78,71.49},{80.82,71.46},{80.84,71.57},{80.86,71.59},{80.97,71.77},{80.84,71.92},{80.77,71.75},{80.76,71.29},{80.79,71.3},{80.82,71.35},{80.88,71.42},{81.07,71.71},{80.86,71.75},{80.49,71.25},{79.95,70.8},{79.74,69.89},{79.16,69.5},{78.82,68.61},{78.2,69.95},{78.22,71.07},{78.7,71.47},{78.57,71.95},{79.11,72.86},{79.75,73.03},{80.03,72.59},{79.65,72.0},{80.01,70.88},{80.57,71.29},},[41]={{20.7,68.72},{20.65,68.49},{20.6,68.25},{20.57,68.12},{20.57,68.12},{20.57,68.46},{20.53,68.2},{20.64,68.31},{20.69,68.28},{20.59,68.02},{20.6,68.03},{20.73,68.18},{20.65,68.08},{20.6,68.03},{20.68,67.91},{20.74,68.19},{20.57,68.21},{20.62,68.18},{20.64,68.3},{20.67,68.32},{20.78,68.52},{20.64,68.67},{20.56,68.49},{20.56,67.99},{20.58,68.01},{20.62,68.06},{20.69,68.14},{20.89,68.44},{20.66,68.49},{20.26,67.95},{19.68,67.46},{19.46,66.48},{18.83,66.06},{18.46,65.1},{17.79,66.54},{17.81,67.75},{18.33,68.19},{18.19,68.71},{18.78,69.69},{19.47,69.87},{19.76,69.4},{19.36,68.76},{19.74,67.55},{20.35,67.99},},},10,nil,nil,21,nil,},
[513] = {'Murloc Netter',300,328,14,15,0,{[40]={{34.3,16.71},{33.73,16.72},{34.1,16.67},{34.56,15.89},{33.54,17.93},{38.06,16.31},{37.19,15.79},{39.02,15.41},{37.7,15.25},{38.79,16.19},{38.33,15.29},{37.39,16.46},{34.58,21.99},{35.82,22.58},{34.55,22.66},{32.92,17.54},{35.03,16.94},{33.93,18.72},{32.42,26.63},{32.5,26.25},{34.83,20.43},{33.65,17.45},{33.49,17.08},{34.11,16.18},{34.52,15.65},{33.44,17.24},{35.54,22.1},{35.8,21.57},{32.25,25.4},{33.71,16.45},},},nil,40,nil,nil,18,nil,},
[514] = {'Smith Argus',1172,1172,24,24,0,{[12]={{41.71,65.54},},},nil,12,{119,1097,},{118,},12,"A",},
[515] = {'Murloc Raider',222,247,11,12,0,{[40]={{52.17,10.26},{52.97,11.3},{53.16,10.61},{55.6,8.02},{55.71,7.31},{55.72,8.63},{52.69,9.59},{55.3,9.53},{53.89,9.63},{55.27,10.1},},},nil,40,nil,nil,18,nil,},
[517] = {'Murloc Oracle',350,377,16,18,0,{[40]={{27.72,68.77},{26.97,55.34},{26.92,54.21},{33.75,83.18},{27.69,70.02},{26.76,70.21},{27.39,52.47},{26.12,74.44},{28.03,73.06},{27.11,72.74},{26.0,72.25},{27.93,59.99},{28.17,69.0},{26.81,59.46},{26.09,58.99},{26.92,53.44},{27.26,58.75},{27.28,75.54},{26.08,73.65},{27.18,74.38},{23.66,57.09},{33.93,84.84},{26.69,58.18},{27.53,53.64},{34.6,85.32},{27.74,52.89},{35.52,85.91},{34.54,85.94},},},nil,40,nil,nil,18,nil,},
[518] = {'Yowler',494,494,25,25,0,{[44]={{27.65,21.38},},},nil,44,nil,nil,19,nil,},
[519] = {'Slark',328,328,15,15,4,{[40]={{31.56,25.95},},},{[40]={{31.26,26.4},{30.84,27.31},{30.07,29.21},{29.44,30.3},{29.0,32.2},{28.67,33.63},{28.23,34.89},{28.34,35.7},{28.53,36.06},{28.74,36.21},{28.94,36.05},{29.09,35.76},{29.13,35.32},{29.08,34.51},{29.36,33.0},{29.51,32.16},{30.17,30.9},{30.86,29.56},{31.33,27.95},{31.88,27.46},{32.14,25.92},{32.31,24.91},{32.65,24.1},{33.41,23.34},{34.21,22.8},{34.97,22.83},{35.44,22.65},{35.88,22.1},{35.97,21.69},{35.99,20.54},{36.17,20.04},{37.07,18.38},{37.56,17.48},{38.35,16.73},{38.76,16.14},{39.19,14.97},{39.72,13.52},{40.26,12.61},{41.06,12.56},{41.76,12.02},{43.14,10.76},{44.1,9.88},{45.06,9.75},{45.62,10.24},{46.53,11.05},{47.31,11.31},{48.16,11.29},{49.34,11.55},{50.52,11.39},{51.8,11.21},{52.35,11.14},{53.1,10.81},{53.62,11.83},{54.31,11.63},{54.98,11.6},{55.87,11.47},{56.64,10.76},{56.79,10.03},{56.65,9.2},{56.3,8.64},{56.11,8.64},{55.57,9.29},{54.57,9.99},{53.52,9.77},{53.1,9.82},{51.95,10.24},{51.22,10.24},{49.46,10.26},{42.35,10.64},{41.63,11.29},{40.4,11.29},{40.01,12.0},{39.06,13.73},{38.37,14.99},{37.52,16.55},{36.29,18.48},{35.72,19.38},{34.6,20.91},{33.38,21.96},{32.62,22.61},{32.13,23.77},},[12]={{0.83,73.94},{1.8,73.06},{2.76,72.93},{3.33,73.42},{4.25,74.23},{5.03,74.5},{5.89,74.48},{7.07,74.74},{8.26,74.58},{9.56,74.4},{10.12,74.32},{10.87,73.99},{11.39,75.02},{12.09,74.82},{12.76,74.79},{13.66,74.66},{14.44,73.95},{14.59,73.21},{14.45,72.37},{14.09,71.8},{13.91,71.8},{13.36,72.46},{12.36,73.17},{11.29,72.95},{10.86,73.0},{9.71,73.42},{8.97,73.42},{7.19,73.44},{0.03,73.82},},},40,nil,nil,18,nil,},
[520] = {'Brack',449,449,19,19,4,{[40]={{27.27,44.54},},},{[40]={{27.28,44.53},{27.03,45.15},{26.91,46.19},{26.85,46.81},{26.98,47.44},{26.93,47.82},{26.85,48.42},{26.83,48.93},{26.89,49.33},{27.0,49.78},{27.08,50.21},{27.22,50.7},{27.4,51.63},{27.41,52.07},{27.36,52.53},{27.31,53.03},{27.28,54.5},{27.27,54.85},{27.2,55.38},{27.11,55.8},{27.05,56.2},{27.01,56.78},{26.94,57.62},{26.92,57.93},{26.89,58.48},{26.61,58.61},{26.2,58.79},{26.34,58.23},{26.39,57.79},{26.4,57.12},{26.36,55.87},{26.68,55.24},{27.03,54.55},{27.09,54.24},{27.05,53.78},{26.95,53.23},{26.94,52.54},{26.87,52.27},{26.77,51.92},{26.82,51.57},{26.89,51.14},{26.95,50.83},{26.98,50.5},{26.99,50.24},{26.98,49.88},{26.96,49.5},{26.92,49.28},{26.81,48.9},{26.8,48.48},{26.8,47.79},{26.84,47.46},{27.05,46.91},{27.15,46.45},{27.24,45.83},{27.32,45.24},{27.35,44.88},{27.36,44.39},{27.33,43.8},{27.3,43.2},{27.32,42.78},{27.4,42.03},{27.54,41.32},{27.73,40.74},{27.71,40.13},{28.0,39.22},{28.1,38.83},{28.22,38.44},{28.22,37.79},{28.27,36.85},{27.9,36.9},{27.51,37.15},{27.35,37.62},{27.17,39.12},{27.19,39.98},{27.38,40.86},{27.34,41.37},{27.29,41.99},{27.27,42.44},{27.22,43.25},{27.21,43.55},{27.11,44.42},},},40,nil,nil,18,nil,},
[521] = {'Lupos',617,617,23,23,4,{[10]={{32.63,25.84},{70.63,26.64},{67.26,26.85},{64.5,26.75},{61.98,24.9},{61.18,22.82},{38.27,25.29},{36.31,24.37},{34.23,29.59},{31.64,29.12},{29.6,29.75},{27.13,27.2},{24.86,28.39},{23.59,26.96},{19.99,26.39},{21.52,26.54},},},nil,10,nil,nil,38,nil,},
[522] = {'Mor\'Ladim',3660,3660,35,35,1,{[10]={{16.67,37.35},},},{[10]={{16.57,36.95},{16.17,36.76},{15.81,37.07},{15.47,37.56},{15.13,38.11},{14.91,39.19},{14.96,40.0},{14.82,40.92},{14.58,41.87},{14.59,42.14},{14.82,42.6},{15.1,42.84},{15.45,43.04},{16.29,43.36},{17.3,43.32},{17.98,42.86},{18.73,42.09},{19.32,41.67},{19.68,40.72},{19.82,39.96},{19.59,38.89},{19.3,38.45},{18.96,38.29},{18.47,38.25},{18.05,38.24},{17.52,37.92},{17.29,37.96},{17.07,38.26},{16.95,38.54},{16.8,38.65},{16.67,38.58},{16.62,38.45},{16.73,37.94},{16.69,37.51},},[40]={{75.17,42.08},{74.86,41.93},{74.58,42.17},{74.32,42.55},{74.05,42.97},{73.88,43.8},{73.92,44.43},{73.81,45.14},{73.63,45.87},{73.63,46.08},{73.82,46.43},{74.03,46.62},{74.3,46.77},{74.95,47.02},{75.72,46.99},{76.25,46.64},{76.83,46.04},{77.29,45.72},{77.56,44.99},{77.67,44.4},{77.49,43.57},{77.27,43.23},{77.01,43.11},{76.63,43.08},{76.31,43.07},{75.9,42.83},{75.72,42.86},{75.55,43.08},{75.46,43.3},{75.34,43.39},{75.24,43.33},{75.2,43.23},{75.29,42.84},{75.26,42.51},},},10,nil,nil,21,nil,},
[523] = {'Thor',7842,7842,55,55,1,{[40]={{56.55,52.64},},},nil,40,{6281,},{6181,},12,"A",},
[524] = {'Rockhide Boar',137,156,7,8,0,{[12]={{61.64,78.29},{62.93,79.83},{60.54,81.37},{60.21,78.15},{60.61,79.74},{60.09,75.39},{59.3,74.54},{58.55,74.76},{58.38,72.76},{42.95,82.01},{44.01,80.95},{44.1,79.3},{43.32,77.87},{44.5,83.76},{44.49,79.23},{46.59,78.58},{47.27,75.77},{47.98,75.99},{47.19,79.43},{46.41,80.22},{47.85,78.61},{48.34,80.92},{46.63,81.01},{45.88,82.86},{46.55,85.12},{44.56,87.24},{45.59,87.99},{44.97,89.58},{50.14,79.68},{50.09,78.75},{52.13,77.99},{52.52,75.79},{49.5,75.68},{48.97,76.07},{51.86,74.69},{53.06,73.99},{54.18,77.94},{54.58,75.25},{53.41,76.45},{54.85,79.86},{54.67,80.9},{52.65,81.46},{53.21,82.37},{53.41,79.89},{55.52,76.64},{53.57,85.37},{52.66,84.37},{54.37,83.67},{56.45,83.92},{54.93,85.86},{57.16,82.43},{57.17,76.38},{56.43,75.24},{55.58,73.78},{58.52,74.71},{59.1,76.53},{59.12,74.32},{58.34,72.45},{57.14,73.76},{57.99,80.76},{60.32,78.2},{61.69,78.31},{60.97,79.67},{60.99,77.16},{64.06,78.38},{64.61,79.64},{63.95,80.61},{62.88,76.28},{65.78,77.74},{65.55,75.61},{64.95,76.74},{63.89,75.79},{62.06,75.43},{65.66,81.26},{66.93,79.86},{67.27,76.91},{66.93,82.47},{70.74,82.61},{72.67,79.61},{73.0,76.52},{71.78,75.24},{70.78,73.67},{73.79,78.49},{71.37,83.61},{72.86,82.66},{73.54,80.83},{69.53,75.51},{74.43,80.13},{69.72,72.59},{74.44,81.92},},},nil,12,nil,nil,189,"AH",},
[525] = {'Mangy Wolf',102,120,5,6,0,{[12]={{57.09,69.72},{52.06,63.68},{47.53,68.15},{41.56,57.99},{32.18,55.5},{42.81,54.97},{44.56,57.82},{45.79,55.44},{33.37,58.17},{34.17,59.33},{36.78,60.83},{35.87,62.59},{35.4,61.21},{38.45,63.81},{38.3,62.19},{36.91,63.15},{35.29,63.35},{37.52,64.88},{42.52,62.51},{43.09,61.05},{45.9,68.54},{34.96,66.74},{34.41,65.2},{34.7,62.39},{32.1,56.18},{30.64,69.09},{30.58,68.1},{32.54,67.71},{28.26,67.43},{34.89,67.54},{36.1,69.25},{35.03,70.01},{35.41,70.69},{35.64,73.61},{35.12,72.39},{33.86,73.61},{33.61,73.38},{34.72,75.48},{33.47,76.13},{33.07,75.67},{30.36,71.93},{31.09,71.29},{30.28,72.14},{29.65,72.85},{29.23,72.87},{29.56,72.24},{29.3,72.2},{29.15,74.29},{29.11,69.63},{28.76,72.22},{27.71,71.29},{27.61,74.25},{26.36,75.31},{28.7,75.53},{28.48,74.82},{23.55,77.02},{22.49,75.53},{22.22,75.49},{21.71,76.39},{21.41,74.3},{32.39,76.75},{52.29,71.08},{51.38,69.69},{53.13,69.71},{56.08,71.12},{57.28,69.81},{55.25,69.98},{54.25,71.18},{56.49,61.47},{56.8,60.36},{58.37,60.57},{56.45,58.98},{57.14,59.78},{55.24,61.49},{55.04,59.38},{52.05,63.76},{50.88,70.54},{49.71,69.36},{52.37,71.17},{47.56,68.02},{49.61,60.96},{50.43,61.71},{50.35,61.68},{49.5,58.3},{52.37,62.67},{52.36,62.02},{52.09,62.96},{53.77,60.39},},},nil,12,nil,nil,38,nil,},
[531] = {'Skeletal Fiend',664,713,24,25,0,{[10]={{16.24,42.81},{21.81,47.42},{22.65,40.49},{23.78,44.0},{22.39,43.04},{22.93,43.46},{23.34,42.65},{15.28,46.38},{15.98,47.14},{16.81,47.1},{15.04,42.0},{20.65,46.4},{22.24,42.32},},},nil,10,nil,nil,21,nil,},
[533] = {'Nightbane Shadow Weaver',724,769,27,28,0,{[10]={{65.48,69.13},{67.22,75.57},{66.22,71.06},{65.0,74.99},{67.33,70.77},{66.4,66.44},{64.32,66.16},{65.08,66.37},{60.68,70.91},{62.49,72.4},{63.3,70.26},{64.24,67.74},{60.09,72.17},{63.39,44.21},{64.95,45.75},{64.7,42.86},{59.74,52.8},{62.0,47.77},{61.43,45.87},{63.46,37.17},{58.28,29.32},{62.56,35.0},{65.11,38.64},{57.32,30.42},{61.07,37.3},{61.94,52.05},{62.03,30.22},},},nil,10,nil,nil,24,nil,},
[534] = {'Nefaru',1279,1279,34,34,4,{[10]={{63.48,83.67},{74.33,77.9},{61.85,81.38},},},nil,10,nil,nil,24,nil,},
[539] = {'Pygmy Venom Web Spider',417,449,18,19,0,{[10]={{46.53,16.7},{74.76,17.52},{84.69,18.36},{69.61,18.63},{10.14,66.12},{68.25,15.94},{66.26,17.05},{11.94,68.91},{13.18,70.34},{9.23,60.82},{60.82,16.61},{66.69,17.92},{53.87,13.31},{54.53,14.24},{47.65,15.87},{40.14,21.76},{33.96,24.6},{28.79,27.62},{72.08,19.0},{37.15,21.27},{10.75,55.39},{11.63,62.66},{10.4,59.06},{10.79,53.0},{7.91,44.81},{7.86,40.81},{11.97,59.19},{9.53,53.77},{9.42,57.19},{12.0,51.24},{23.85,27.8},{12.45,28.79},{9.53,49.65},{8.99,46.18},{9.36,42.83},{66.38,17.96},},},nil,10,nil,nil,22,nil,},
[541] = {'Riding Gryphon',1528,1528,29,29,0,nil,nil,0,nil,nil,35,"AH",},
[543] = {'Nalesette Wildbringer',2471,2471,40,40,0,{[361]={{62.2,24.37},},},nil,361,nil,nil,80,"A",},
[544] = {'Murloc Nightcrawler',531,573,21,22,0,{[44]={{80.8,58.54},{81.21,59.61},{81.1,59.7},{81.74,60.09},},},nil,44,nil,nil,18,nil,},
[545] = {'Murloc Tidecaller',404,433,19,20,0,{[44]={{58.21,51.83},{55.64,53.91},{57.91,51.68},{56.68,53.9},{54.4,55.67},{80.8,61.53},{81.23,60.42},{81.13,59.33},{81.29,61.2},{81.95,61.16},{54.09,52.76},{56.94,51.1},},},nil,44,nil,nil,18,nil,},
[547] = {'Great Goretusk',356,386,16,17,0,{[44]={{15.02,49.55},{17.22,46.93},{46.22,17.11},{46.85,14.27},{46.37,10.43},{48.54,25.27},{18.51,43.63},{19.83,39.97},{45.18,20.49},{24.73,78.45},{31.39,72.22},{29.01,73.33},{42.27,16.33},{27.73,75.36},{26.83,79.36},{33.32,65.78},{33.94,61.07},{33.89,71.26},{30.27,78.31},{38.39,73.29},{28.32,79.34},{25.42,60.53},{17.68,55.26},{15.59,53.98},{18.32,53.98},{16.81,52.3},{32.08,71.09},{19.44,72.77},{17.91,71.07},{31.16,67.88},},[40]={{54.59,68.3},{67.54,70.91},{58.78,58.98},{62.43,51.51},{49.66,68.72},{58.11,62.34},{57.06,67.67},{58.59,68.01},{60.83,67.56},{54.51,68.08},{51.69,67.59},{60.25,50.49},{58.95,49.09},{64.26,66.67},{66.7,68.11},{63.94,55.07},{58.96,56.92},},},nil,44,nil,nil,189,"AH",},
[548] = {'Murloc Minor Tidecaller',350,377,17,18,0,{[44]={{59.87,61.46},{60.24,62.36},{57.46,61.79},{57.91,60.57},{58.08,60.37},{55.29,61.74},{55.93,60.06},{58.61,60.32},{48.83,72.2},{48.5,72.2},{47.31,70.65},{50.22,68.54},{48.71,69.44},{48.26,67.38},{57.72,65.35},},},nil,44,nil,nil,18,nil,},
[550] = {'Defias Messenger',300,328,14,15,0,{[40]={{45.1,69.33},},},{[40]={{45.1,69.33},{45.59,68.72},{45.82,68.16},{45.86,67.68},{45.5,66.54},{45.48,65.86},{45.6,64.98},{44.81,64.29},{44.43,63.5},{44.02,61.83},{43.71,60.33},{43.47,59.15},{43.31,57.58},{43.23,56.35},{43.19,54.62},{42.99,54.02},{42.34,53.21},{42.07,52.61},{41.84,51.89},{41.72,51.27},{41.67,50.35},{41.11,49.3},{40.79,48.46},{40.06,47.56},{38.97,46.27},{38.71,45.64},{38.48,45.34},{37.82,45.59},{37.29,44.79},{36.59,44.37},{35.7,44.04},{34.83,43.49},{33.98,43.11},{33.03,42.96},{32.09,43.34},{31.68,43.86},{31.24,44.87},{30.76,45.87},{30.47,45.81},{30.32,45.62},{29.68,46.18},{29.85,46.74},{29.87,47.3},{30.12,47.65},{30.54,47.88},{30.69,48.33},{30.54,49.03},{30.16,49.68},{29.71,50.26},{29.65,50.08},{30.22,49.53},{30.54,48.96},{30.69,48.21},{30.51,47.85},{29.82,47.28},{29.76,46.1},{30.25,45.6},{30.81,45.93},{30.98,45.34},{31.44,44.43},{31.78,43.65},{32.25,43.28},{32.54,43.15},{32.94,42.88},{33.85,43.06},{34.57,43.42},{35.56,43.89},{36.26,43.94},{36.61,43.34},{36.88,42.34},{36.91,40.81},{37.08,39.59},{37.44,38.56},{37.83,37.11},{38.33,36.3},{39.27,35.29},{40.33,34.5},{40.87,33.67},{41.27,32.75},{41.75,31.01},{42.14,30.36},{42.87,29.36},{43.73,28.62},{44.26,27.98},{44.49,26.34},{44.52,25.35},{44.56,24.69},{44.63,23.49},{45.0,22.85},{44.95,22.45},{44.53,21.44},{44.76,20.65},{44.75,20.37},{44.53,19.7},{44.65,19.28},{44.88,19.01},{45.52,18.16},{45.83,18.08},{46.0,18.28},{46.13,18.68},{46.3,18.95},{45.86,18.13},{45.6,18.1},{45.17,18.63},{44.59,19.42},{44.61,20.15},{44.8,20.67},{44.57,21.37},{44.63,21.71},{45.01,22.83},{44.59,23.61},{44.59,24.3},{44.52,25.34},{44.29,26.24},{44.17,27.89},{43.62,28.71},{42.8,29.55},{41.81,30.92},{41.34,32.51},{40.92,33.66},{40.32,34.46},{39.53,35.09},{38.49,36.1},{37.92,36.95},{37.61,37.82},{37.29,39.05},{36.99,40.11},{36.85,42.07},{36.96,43.24},{37.39,43.94},{37.94,44.61},{38.66,45.55},{39.09,46.39},{39.94,47.42},{40.67,48.25},{40.99,49.0},{41.19,49.46},{41.7,50.43},{41.75,51.49},{42.02,52.51},{42.38,53.27},{43.04,54.15},{43.19,54.7},{43.22,55.98},{42.84,56.38},{42.43,56.36},{42.1,55.87},{41.78,54.16},{41.8,53.34},{41.94,52.98},{42.23,53.0},{42.85,53.82},{43.15,54.48},{43.25,55.31},{43.23,56.54},{43.3,57.5},{43.46,59.1},{43.77,60.62},{44.09,62.03},{44.4,63.23},{44.63,63.92},{44.97,64.48},{45.34,64.81},{45.62,64.98},{45.48,66.11},{45.56,66.76},{45.86,67.7},{45.83,68.24},{45.43,69.06},{44.98,69.49},{44.48,69.61},},[12]={{0.55,92.7},{1.42,91.95},{1.96,91.3},{2.18,89.65},{2.21,88.65},{2.26,87.99},{2.33,86.77},{2.7,86.14},{2.65,85.73},{2.23,84.71},{2.46,83.92},{2.45,83.63},{2.23,82.95},{2.35,82.53},{2.58,82.26},{3.23,81.4},{3.54,81.32},{3.71,81.52},{3.84,81.93},{4.01,82.2},{3.57,81.37},{3.31,81.34},{2.87,81.88},{2.29,82.68},{2.3,83.41},{2.5,83.93},{2.26,84.64},{2.32,84.99},{2.71,86.11},{2.28,86.9},{2.29,87.59},{2.22,88.64},{1.98,89.55},{1.87,91.21},{1.31,92.04},{0.48,92.88},},},40,nil,nil,34,nil,},
[565] = {'Rabid Dire Wolf',494,531,20,21,0,{[10]={{12.94,69.16},{11.57,33.56},{9.65,40.52},{11.02,32.27},{16.14,29.69},{20.25,28.95},{40.1,22.06},{37.63,25.71},{35.08,26.01},{33.14,29.35},{25.21,29.88},{38.98,23.82},{34.04,28.12},{18.92,25.29},{20.45,25.36},{19.32,28.05},{21.52,30.46},{20.39,28.09},{15.57,26.06},{54.83,18.42},{56.2,19.62},{66.04,18.04},{61.48,19.46},{10.71,51.57},{10.61,60.96},{11.55,57.26},{14.27,27.24},{13.16,30.51},{16.34,27.24},{13.84,27.61},{10.04,46.42},{67.32,20.1},{67.05,22.61},},},nil,10,nil,nil,38,nil,},
[568] = {'Shadowhide Warrior',664,713,24,25,0,{[44]={{75.5,30.27},{75.64,29.99},{82.38,55.47},{84.32,54.4},{85.77,58.62},{78.86,47.37},{75.92,36.75},{79.91,45.29},{79.81,44.99},{81.6,46.63},{81.42,48.42},{76.25,37.77},{76.65,37.82},{76.38,38.15},{76.6,35.37},{77.73,44.96},{75.73,31.34},{77.72,34.76},{74.87,38.9},{76.44,41.65},{76.87,41.01},{79.18,40.46},{78.16,39.23},{81.78,40.39},{80.89,36.63},{80.84,35.53},},},nil,44,nil,nil,39,nil,},
[569] = {'Green Recluse',531,573,21,22,0,{[10]={{16.55,69.51},{68.09,22.69},{54.18,20.37},{69.04,22.56},{71.33,23.72},{72.84,21.53},{13.88,64.76},{64.85,22.38},{62.55,20.44},{13.22,58.41},{66.8,22.5},{10.26,41.5},{11.04,41.94},{50.82,20.34},{51.35,19.28},{75.47,22.73},{56.1,20.44},{59.93,21.9},{58.09,21.04},{57.3,22.33},{54.91,22.04},{61.85,23.21},{12.37,55.07},{13.02,50.98},{68.64,21.95},},},nil,10,nil,nil,22,nil,},
[570] = {'Brain Eater',896,950,28,29,0,{[10]={{24.48,30.44},{24.79,27.95},{22.31,29.66},{25.44,27.27},{20.7,28.79},{21.38,29.83},{21.67,28.31},{22.08,26.98},{20.56,30.05},{20.21,27.31},{25.67,29.09},{25.92,36.04},{26.87,34.28},{24.43,29.07},{24.93,29.8},{25.01,34.67},},},nil,10,nil,nil,21,nil,},
[572] = {'Leprithus',404,404,19,19,4,{[40]={{43.04,27.0},{41.93,29.24},{42.15,30.13},{64.71,66.7},{64.93,67.92},},},nil,40,nil,nil,21,nil,},
[573] = {'Foe Reaper 4000',484,484,20,20,4,{[40]={{44.82,35.38},{51.38,68.38},{50.52,69.26},{50.09,67.11},{47.67,68.93},{47.29,67.04},{46.4,66.04},{46.21,63.24},{53.94,63.06},{50.76,65.24},{40.61,49.56},{40.09,51.93},{38.39,54.29},{37.9,52.0},{36.03,51.34},{38.03,49.4},{33.24,52.89},{34.33,51.3},{44.47,45.52},{44.68,38.92},{43.92,36.71},{42.57,35.49},{44.7,32.66},{46.34,33.36},{46.94,35.53},{48.59,30.1},{49.24,27.43},{50.46,26.61},{51.39,25.42},{52.46,22.89},{51.09,22.2},{49.42,21.94},{50.66,19.3},{53.52,27.56},{54.3,25.78},{62.41,58.04},{63.78,59.55},{64.95,61.32},{63.38,62.02},{62.12,62.38},{61.25,60.14},},},nil,40,nil,nil,14,nil,},
[574] = {'Naraxis',840,840,27,27,4,{[10]={{86.36,47.57},},},nil,10,nil,nil,22,nil,},
[575] = {'Fire Elemental',1220,1277,35,36,0,nil,nil,0,nil,nil,67,nil,},
[576] = {'Watcher Ladimore',1454,1454,28,28,0,{[10]={{74.02,47.82},},},{[10]={{74.3,48.05},{74.59,48.19},{74.78,47.61},{75.0,47.41},{75.28,47.36},{75.52,46.37},{75.05,46.26},{75.05,45.47},{74.54,46.09},{74.12,46.18},{73.58,46.53},{73.61,47.18},{74.02,47.82},},[41]={{13.58,42.9},{13.89,43.04},{14.1,42.42},{14.34,42.2},{14.63,42.15},{14.9,41.08},{14.38,40.96},{14.38,40.11},{13.84,40.77},{13.39,40.87},{12.8,41.25},{12.84,41.95},{13.27,42.65},},},10,{231,},{229,},12,"A",},
[578] = {'Murloc Scout',449,484,19,20,0,{[44]={{56.91,52.81},{58.06,57.38},{58.27,52.37},{57.96,52.03},{58.26,53.42},{56.26,55.39},{57.13,54.6},{57.12,50.91},{57.02,50.92},{57.13,51.15},{45.37,50.95},{38.95,53.91},{40.13,48.22},{40.42,44.68},{40.86,46.38},{41.03,46.19},{42.33,47.01},{43.42,48.54},{39.22,49.13},{39.11,51.62},{40.55,49.1},},},nil,44,nil,nil,18,nil,},
[579] = {'Shadowhide Assassin',617,664,23,24,0,{[44]={{79.0,54.34},{80.18,49.06},},},nil,44,nil,nil,39,nil,},
[580] = {'Redridge Drudger',494,531,20,21,0,{[44]={{16.07,17.13},{20.29,21.05},{15.89,21.17},{15.96,18.87},{19.96,27.48},{21.63,23.63},{21.28,17.37},{22.35,20.55},{20.2,13.23},{18.73,15.3},{22.26,16.55},{18.82,24.3},{17.04,17.92},{18.54,15.22},},},{[44]={{17.73,15.61},{18.54,15.22},{18.88,14.35},{19.46,13.61},{20.55,13.37},{21.62,14.63},{22.28,15.88},{21.62,14.63},{20.55,13.37},{19.46,13.61},{18.88,14.35},{18.54,15.22},},[46]={{57.66,90.66},{58.27,90.37},{58.52,89.72},{58.95,89.18},{59.75,89.0},{60.55,89.93},{61.04,90.86},{60.55,89.93},{59.75,89.0},{58.95,89.18},{58.52,89.72},{58.27,90.37},},},44,nil,nil,19,nil,},
[582] = {'Old Blanchy',101,101,2,2,0,{[40]={{59.77,19.42},},},nil,40,nil,nil,35,"AH",},
[583] = {'Defias Ambusher',156,176,8,9,0,nil,nil,0,nil,nil,27,nil,},
[584] = {'Kazon',840,840,27,27,4,{[44]={{34.9,8.27},{36.87,11.98},{36.4,9.38},{35.01,6.72},},},nil,44,nil,nil,40,nil,},
[587] = {'Bloodscalp Warrior',1221,1279,33,34,0,{[33]={{29.82,19.1},{33.43,13.77},{29.76,21.62},{34.26,14.57},{34.04,16.78},},},nil,33,nil,nil,28,nil,},
[588] = {'Bloodscalp Scout',1279,1342,34,35,0,{[33]={{22.26,13.08},{25.94,12.21},{24.15,13.13},{25.55,9.33},{24.7,12.3},{24.8,12.32},{24.65,12.68},{25.46,13.43},{24.45,12.59},{24.8,12.56},{24.49,12.28},{26.14,9.31},{26.13,10.11},{25.9,9.0},{25.5,8.99},{25.6,10.59},{27.6,11.65},{25.66,12.14},{25.25,12.83},{24.07,13.3},{25.09,13.41},{25.33,12.93},{24.4,11.18},{23.13,12.26},{23.05,12.57},{22.67,12.07},{23.08,11.99},{23.0,12.09},},},nil,33,nil,nil,28,nil,},
[589] = {'Defias Pillager',263,285,14,15,0,{[40]={{29.24,51.04},{28.83,49.53},{29.76,49.81},{38.76,69.61},{45.4,70.35},{44.43,67.35},{44.3,68.62},{44.84,68.73},{43.6,68.1},{43.74,66.41},{43.58,68.25},{43.9,68.36},{41.98,69.56},{43.31,69.58},{43.46,70.8},{43.0,70.82},{41.85,69.5},{42.27,69.47},{31.74,43.9},{32.09,43.98},{30.91,43.04},{31.59,44.87},{33.23,58.59},{33.71,56.86},{33.16,56.64},{32.78,56.66},{32.08,57.71},{38.79,56.85},{38.81,57.75},{37.11,55.94},{36.68,53.79},{35.87,53.15},{36.04,53.09},{35.11,53.78},{35.0,53.77},{29.64,47.25},{30.4,45.99},{46.26,67.35},{42.98,68.13},{43.39,68.83},{44.17,68.2},{43.1,70.12},{41.51,71.24},{42.58,69.17},{45.62,69.39},},},{[40]={{44.17,68.16},{44.18,67.27},{44.17,68.01},{44.18,68.65},{44.07,68.78},{43.76,68.81},{43.57,68.98},{43.47,69.23},{43.38,69.26},{43.13,69.11},{42.99,68.87},{42.89,68.23},{42.89,67.89},{42.89,67.38},{42.89,66.55},{42.9,67.44},{42.9,67.79},{42.9,68.09},{42.9,68.54},{42.96,68.87},{43.1,69.12},{43.37,69.27},{43.48,69.15},{43.66,68.94},{43.83,68.83},{44.13,68.73},{44.18,68.51},{42.58,69.17},{42.93,69.61},{42.75,70.02},{42.65,70.3},{42.62,70.55},{42.61,70.81},{42.55,71.14},{42.15,71.23},{41.89,71.22},{41.75,71.21},{41.67,71.21},{41.52,71.2},{41.53,70.77},{41.53,70.32},{41.57,70.08},{41.66,69.66},{41.75,69.21},{41.95,69.11},{42.46,69.09},{45.62,69.39},{45.46,69.54},{45.27,69.75},{45.18,69.94},{45.18,70.04},{45.13,70.09},{45.32,70.76},{45.5,70.87},{45.68,70.77},{45.85,70.66},{45.99,70.65},{45.9,70.45},{45.79,70.08},{45.73,69.85},{45.67,69.59},},},40,nil,nil,17,nil,},
[590] = {'Defias Looter',273,300,13,14,0,{[40]={{29.69,47.08},{29.86,46.14},{30.76,48.44},{29.62,50.19},{28.93,50.14},{46.0,70.65},{46.01,71.12},{45.5,70.37},{44.04,69.24},{44.37,67.71},{44.98,67.44},{43.81,67.75},{43.67,67.54},{43.48,66.89},{43.43,68.07},{43.93,68.07},{42.12,69.46},{42.24,70.52},{41.51,69.84},{41.95,69.63},{31.73,43.03},{31.22,44.64},{37.95,57.36},{38.65,56.86},{38.53,57.63},{38.81,57.98},{38.65,58.11},{37.09,58.02},{37.21,54.53},{36.04,54.71},{35.98,54.63},{36.34,55.46},{36.54,54.07},{36.73,54.0},{35.75,53.72},{29.94,45.87},{30.1,49.7},{45.8,69.29},{43.7,69.26},{44.46,65.73},},},nil,40,nil,nil,17,nil,},
[594] = {'Defias Henchman',984,1068,15,16,1,{[40]={{42.88,72.6},{41.84,78.44},{43.94,73.51},{43.82,77.02},{42.2,74.49},},[33]={{10.48,1.44},{11.56,0.67},},},{[40]={{42.89,72.6},{43.1,72.73},{43.26,72.97},{43.34,73.21},{43.36,73.35},{43.32,73.82},{43.22,74.07},{43.04,74.39},{42.9,74.6},{42.74,74.82},{42.95,74.58},{43.06,74.41},{43.24,74.04},{43.33,73.8},{43.36,73.39},{43.34,73.25},{43.25,72.98},{43.1,72.75},{43.04,72.66},{41.83,78.43},{41.61,78.08},{41.49,77.85},{41.36,77.64},{41.24,77.38},{41.09,77.1},{41.05,76.71},{41.07,77.02},{41.15,77.27},{41.3,77.63},{41.46,77.83},{41.56,77.98},{41.66,78.16},{43.82,77.02},{43.86,76.91},{44.02,76.53},{43.91,76.81},{43.85,76.94},{43.77,77.14},{43.72,77.28},{43.75,77.46},{43.78,77.7},{43.8,77.89},{43.81,78.07},{43.84,78.22},{43.8,78.07},{43.81,77.84},{43.78,77.61},{43.74,77.43},{43.71,77.28},{43.56,77.3},{43.41,77.31},{43.32,77.29},{43.16,77.2},{43.05,77.16},{43.19,77.19},{43.3,77.23},{43.46,77.27},{43.57,77.25},{43.66,77.26},{43.73,77.46},{43.78,77.66},{43.82,77.88},{43.8,78.1},{43.85,78.24},{43.81,78.08},{43.81,77.83},{43.78,77.65},{43.74,77.45},{43.74,77.26},{43.77,77.12},{42.2,74.49},{42.05,74.54},{41.92,74.72},{41.79,74.87},{41.59,75.09},{41.45,75.18},{41.35,75.33},{41.32,75.45},{41.31,75.74},{41.33,75.41},{41.38,75.29},{41.46,75.18},{41.58,75.08},{41.72,74.97},{41.91,74.74},{42.06,74.53},{42.19,74.51},{42.26,74.52},{42.44,74.66},{42.57,74.8},{42.43,74.66},},[33]={{10.47,1.44},{10.35,1.25},{10.28,1.12},{10.21,1.01},{10.15,0.86},{10.07,0.71},{10.04,0.49},{10.06,0.67},{10.1,0.8},{10.18,1.0},{10.27,1.11},{10.32,1.19},{10.38,1.29},{11.56,0.67},{11.59,0.61},{11.67,0.4},{11.61,0.55},{11.58,0.62},{11.54,0.73},{11.51,0.81},{11.53,0.91},{11.54,1.04},{11.55,1.14},{11.56,1.24},{11.58,1.33},{11.55,1.24},{11.56,1.12},{11.54,0.99},{11.52,0.89},{11.5,0.81},{11.42,0.82},{11.34,0.83},{11.29,0.81},{11.2,0.77},{11.14,0.74},{11.22,0.76},{11.28,0.78},{11.37,0.81},{11.43,0.8},{11.47,0.8},{11.52,0.91},{11.54,1.02},{11.56,1.14},{11.55,1.26},{11.58,1.33},{11.56,1.25},{11.56,1.11},{11.54,1.01},{11.52,0.9},{11.52,0.8},{11.53,0.72},},},40,nil,nil,17,nil,},
[595] = {'Bloodscalp Hunter',1279,1342,34,35,0,{[33]={{22.69,11.96},{22.35,12.8},{25.98,9.81},{26.0,9.41},{25.91,12.67},{26.09,12.39},{25.56,13.21},{26.13,12.69},{25.93,8.4},{25.72,9.32},{26.05,8.64},{25.05,9.45},{25.08,9.9},{22.94,11.02},{24.46,12.32},{26.31,11.32},{23.85,13.16},{23.34,12.05},},},nil,33,nil,nil,28,nil,},
[596] = {'Brainwashed Noble',1061,1061,18,18,2,{[33]={{11.65,1.39},},[40]={{43.98,78.33},},},nil,33,nil,nil,17,nil,},
[597] = {'Bloodscalp Berserker',1469,1536,36,37,0,{[33]={{20.26,12.2},{19.89,11.87},{19.98,12.07},{23.09,11.25},{24.72,9.39},{20.7,11.15},{19.37,12.84},{19.52,11.95},{24.42,9.11},{24.31,9.47},{23.92,9.92},{23.77,9.4},{22.99,8.81},{22.71,9.18},{23.14,10.7},{23.66,9.89},{23.56,9.7},{24.08,10.7},{24.93,8.66},},},nil,33,nil,nil,28,nil,},
[598] = {'Defias Miner',417,417,18,18,0,{[1581]={{-1, -1}},},nil,1581,nil,nil,17,nil,},
[599] = {'Marisa du\'Paige',1062,1062,18,18,2,{[33]={{10.68,2.24},},[40]={{42.2,79.89},},},nil,33,nil,nil,17,nil,},
[603] = {'Grimtooth',7552,7552,59,59,4,{[2597]={{-1, -1}},},nil,2597,nil,nil,14,nil,},
[604] = {'Plague Spreader',840,896,27,28,0,{[10]={{22.91,28.22},{24.11,27.52},{22.48,28.24},{20.12,28.38},{17.86,34.21},{23.71,34.07},{24.06,35.05},{15.78,34.64},{16.83,32.66},{16.44,34.12},{25.59,32.74},{25.45,31.86},{25.89,35.23},{25.45,30.65},{24.14,36.05},{23.61,36.73},{23.41,35.02},{23.36,35.71},{24.47,34.72},{25.78,34.35},{25.67,33.66},{26.31,34.2},},},{[10]={{23.47,28.06},{22.91,28.22},{22.22,28.11},{21.54,28.23},{21.36,28.88},{20.88,29.09},{20.34,28.97},{20.25,28.47},{20.39,27.38},{20.42,27.17},{20.38,26.95},{20.27,26.67},{20.03,26.62},{19.45,26.87},{20.03,26.62},{20.27,26.67},{20.38,26.95},{20.42,27.17},{20.39,27.38},{20.25,28.47},{20.34,28.97},{20.88,29.09},{21.36,28.88},{21.54,28.23},{22.22,28.11},{22.91,28.22},},[12]={{38.49,98.6},{38.05,98.73},{37.51,98.64},{36.98,98.73},{36.85,99.24},{36.47,99.4},{36.05,99.31},{35.98,98.92},{36.09,98.07},{36.11,97.91},{36.08,97.73},{36.0,97.52},{35.81,97.48},{35.36,97.68},{35.81,97.48},{36.0,97.52},{36.08,97.73},{36.11,97.91},{36.09,98.07},{35.98,98.92},{36.05,99.31},{36.47,99.4},{36.85,99.24},{36.98,98.73},{37.51,98.64},{38.05,98.73},},[40]={{80.49,35.22},{80.06,35.34},{79.52,35.26},{78.99,35.35},{78.86,35.85},{78.49,36.01},{78.07,35.92},{78.0,35.53},{78.11,34.69},{78.13,34.53},{78.11,34.36},{78.02,34.14},{77.83,34.11},{77.39,34.3},{77.83,34.11},{78.02,34.14},{78.11,34.36},{78.13,34.53},{78.11,34.69},{78.0,35.53},{78.07,35.92},{78.49,36.01},{78.86,35.85},{78.99,35.35},{79.52,35.26},{80.06,35.34},},},10,nil,nil,21,nil,},
[615] = {'Blackrock Tracker',617,664,23,24,0,{[44]={{26.14,12.87},{37.02,10.43},{39.19,14.85},{38.99,14.36},{36.7,12.64},{35.53,9.92},{35.9,10.8},{37.32,12.76},{34.93,9.12},{27.44,8.47},{35.94,7.87},{32.18,7.05},{29.65,8.78},{31.11,10.62},},},{[44]={{36.86,10.02},{36.48,9.64},{35.79,9.09},{35.3,8.27},{34.93,7.35},{34.46,7.03},{34.12,7.42},{34.26,8.04},{34.73,8.44},{35.37,8.95},{35.91,9.52},{36.91,12.16},{37.28,12.72},{38.43,13.73},{37.88,13.28},{37.29,12.58},{37.15,11.69},{37.22,11.08},{37.02,10.43},},[46]={{71.84,86.51},{71.56,86.23},{71.05,85.83},{70.69,85.22},{70.41,84.54},{70.06,84.3},{69.81,84.58},{69.91,85.04},{70.26,85.34},{70.74,85.72},{71.13,86.15},{71.88,88.1},{72.16,88.51},{73.0,89.27},{72.6,88.93},{72.16,88.41},{72.06,87.75},{72.11,87.3},{71.96,86.82},},},44,nil,nil,40,nil,},
[616] = {'Chatter',617,617,23,23,4,{[44]={{52.13,45.24},{52.13,32.58},{50.57,34.63},{51.42,38.66},{52.47,36.15},{55.21,37.74},{54.8,41.76},{58.3,48.29},{56.49,47.08},{53.37,49.12},{52.49,43.11},{48.21,41.11},{50.3,36.88},{53.35,46.07},},},nil,44,nil,nil,22,nil,},
[619] = {'Defias Conjurer',855,921,15,16,1,{[40]={{43.7,74.32},{40.49,78.25},{41.69,76.08},},[33]={{9.74,1.34},{10.4,0.15},},},{[40]={{43.54,74.33},{43.47,74.28},{43.42,74.23},{43.19,74.01},{43.1,73.95},{43.05,73.81},{42.96,73.58},{42.85,73.34},{42.75,73.13},{42.65,72.91},{42.73,73.12},{42.82,73.28},{42.94,73.53},{43.09,73.89},{43.17,73.99},{43.44,74.22},{43.51,74.28},{43.69,74.31},{43.84,74.19},{43.9,73.98},{43.91,73.81},{43.9,73.63},{43.9,73.73},{43.91,73.96},{43.85,74.18},{43.7,74.32},{40.2,78.22},{39.94,78.22},{40.21,78.21},{40.37,78.21},{40.49,78.27},{40.64,78.43},{40.72,78.68},{40.74,78.9},{40.75,79.01},{40.8,79.24},{40.93,79.47},{41.1,79.56},{41.27,79.62},{41.49,79.67},{41.68,79.54},{41.75,79.21},{41.8,78.9},{41.84,78.71},{41.9,78.5},{41.99,78.3},{42.14,78.18},{42.29,78.24},{42.4,78.32},{42.29,78.23},{42.17,78.15},{42.01,78.3},{41.93,78.47},{41.86,78.65},{41.79,78.87},{41.73,79.13},{41.69,79.32},{41.65,79.54},{41.51,79.66},{41.28,79.64},{41.14,79.59},{40.95,79.47},{40.78,79.24},{40.72,78.94},{40.71,78.72},{40.67,78.49},{40.49,78.25},{41.42,76.02},{41.54,76.0},{41.67,76.06},{41.83,76.15},{41.95,76.21},{42.09,76.28},{42.2,75.92},{42.48,75.91},{42.65,75.99},{42.7,76.25},{42.71,76.37},{42.75,76.64},{42.87,76.96},{42.75,76.62},{42.73,76.42},{42.69,76.25},{42.61,76.06},{42.53,75.94},{42.23,75.91},{42.15,76.11},{42.09,76.29},{41.85,76.15},{41.69,76.08},{41.58,76.03},},[33]={{9.58,1.32},{9.43,1.33},{9.58,1.32},{9.67,1.32},{9.73,1.35},{9.82,1.44},{9.86,1.58},{9.87,1.7},{9.88,1.76},{9.91,1.88},{9.98,2.01},{10.07,2.06},{10.16,2.09},{10.28,2.12},{10.39,2.05},{10.43,1.87},{10.45,1.7},{10.48,1.59},{10.51,1.48},{10.56,1.37},{10.64,1.3},{10.72,1.34},{10.78,1.38},{10.72,1.33},{10.66,1.29},{10.57,1.37},{10.53,1.46},{10.49,1.56},{10.45,1.68},{10.42,1.83},{10.4,1.93},{10.37,2.05},{10.3,2.11},{10.17,2.1},{10.09,2.08},{9.99,2.01},{9.9,1.89},{9.86,1.72},{9.86,1.6},{9.83,1.47},{9.74,1.34},{10.25,0.12},{10.31,0.11},{10.38,0.14},{10.47,0.19},{10.54,0.22},{10.61,0.26},{10.68,0.06},{10.83,0.06},{10.92,0.1},{10.95,0.25},{10.95,0.31},{10.98,0.46},{11.04,0.64},{10.98,0.45},{10.96,0.34},{10.94,0.24},{10.9,0.14},{10.86,0.08},{10.69,0.06},{10.65,0.17},{10.61,0.27},{10.48,0.19},{10.4,0.15},{10.33,0.13},},},40,nil,nil,17,nil,},
[620] = {'Chicken',1,1,1,1,0,{[1]={{62.11,6.21},{58.97,7.93},{58.95,7.31},{58.75,7.59},{62.34,6.0},{62.57,6.54},{65.96,4.96},{66.02,4.42},{66.25,4.29},{67.1,3.78},{67.58,2.65},},[11]={{20.97,70.13},{17.24,72.18},{17.21,71.45},{16.98,71.78},{21.24,69.89},{21.52,70.53},{25.56,68.64},{25.63,68.0},{25.9,67.84},{26.91,67.24},{27.49,65.9},},[10]={{78.01,48.04},{72.73,54.34},{77.16,55.54},{79.77,46.94},{75.73,56.33},{76.54,53.72},{77.87,44.25},{73.57,53.09},},[44]={{20.31,47.08},{22.31,45.84},{20.24,46.36},},[17]={{61.63,23.74},{61.78,23.91},{62.56,56.77},{61.76,53.64},{61.77,23.89},{61.63,24.27},{60.76,55.49},{62.7,56.72},{61.73,23.75},{62.25,54.05},{62.04,24.2},{61.29,53.53},{61.69,53.32},{61.97,23.89},},[267]={{78.93,42.47},{52.6,56.95},{52.24,55.79},{79.39,44.44},{63.31,61.35},{64.56,61.11},{33.18,41.23},{29.87,40.46},{32.77,43.41},{36.04,40.48},{51.25,54.09},{34.98,47.13},{50.12,57.02},},[15]={{66.42,48.52},{63.93,50.06},{66.81,46.11},{65.34,50.66},{64.41,47.47},{65.52,49.47},{67.63,50.77},},[85]={{38.04,48.91},{52.17,56.23},{52.95,56.31},{38.08,51.71},{60.26,51.27},{60.87,53.59},{37.21,50.15},},[12]={{36.02,60.55},{36.46,59.87},{36.31,59.79},{36.39,60.17},{36.01,60.13},{40.52,64.27},{40.52,64.38},{42.87,66.23},{42.68,66.13},{48.49,86.53},{48.57,86.63},{48.39,86.73},{79.08,67.74},{79.33,67.62},{77.72,66.36},{78.22,66.24},{77.65,66.56},{77.6,66.19},{77.84,66.49},{77.68,65.54},},[40]={{48.73,21.32},{55.64,30.85},{55.92,31.95},{51.71,31.23},{38.23,57.08},{38.84,57.0},{45.34,69.59},{38.94,56.69},{45.68,39.19},{45.77,38.72},{49.75,19.49},{45.14,69.93},{51.52,31.28},{49.19,20.47},{48.96,20.8},{49.31,19.76},{44.73,68.08},{38.48,56.67},{49.91,18.97},{45.42,69.6},{45.64,39.6},{44.73,68.46},{56.24,31.82},{55.66,31.46},{56.1,29.71},{56.21,29.61},{56.1,30.05},{51.51,31.6},},},nil,40,{3861,},{3861,},31,"AH",},
[622] = {'Goblin Engineer',1251,1347,18,19,1,{[1581]={{-1, -1}},},nil,1581,nil,nil,17,nil,},
[623] = {'Skeletal Miner',1158,1251,17,18,1,{[33]={{9.85,3.29},{10.3,3.04},{10.35,3.22},{10.65,3.05},{10.22,4.05},{9.85,3.56},{9.94,2.74},{10.14,4.06},{9.88,2.96},},[40]={{40.71,81.81},{41.52,81.35},{41.61,81.67},{42.15,81.36},{41.37,83.19},{40.69,82.29},{40.86,80.81},{41.22,83.21},{40.74,81.2},},},{[33]={{10.65,3.05},{10.51,3.06},{10.4,3.05},{10.38,3.07},{10.3,3.04},{10.23,2.93},{10.15,2.88},{10.06,2.87},{10.01,2.87},{9.94,2.92},{10.0,2.86},{10.14,2.89},{10.22,2.94},{10.3,3.03},{10.38,3.06},{10.42,3.06},{10.53,3.06},{10.22,4.05},{10.34,4.11},{10.43,4.13},{10.54,4.1},{10.63,4.03},{10.67,3.95},{10.67,3.85},{10.62,3.74},{10.51,3.67},{10.45,3.66},{10.38,3.69},{10.5,3.67},{10.59,3.69},{10.68,3.83},{10.69,3.93},{10.65,4.05},{10.55,4.11},{10.47,4.12},{10.35,4.11},},[40]={{42.15,81.36},{41.89,81.39},{41.7,81.37},{41.67,81.4},{41.51,81.34},{41.38,81.14},{41.24,81.05},{41.08,81.03},{40.99,81.04},{40.86,81.13},{40.98,81.03},{41.23,81.07},{41.36,81.17},{41.52,81.33},{41.66,81.39},{41.74,81.38},{41.94,81.39},{41.37,83.19},{41.6,83.31},{41.76,83.33},{41.96,83.28},{42.11,83.15},{42.2,83.0},{42.19,82.83},{42.1,82.62},{41.91,82.49},{41.79,82.48},{41.67,82.54},{41.89,82.49},{42.05,82.53},{42.21,82.78},{42.22,82.96},{42.15,83.19},{41.97,83.29},{41.82,83.31},{41.61,83.31},},},33,nil,nil,21,nil,},
[624] = {'Undead Excavator',1158,1251,17,18,1,{[33]={{10.64,3.93},{9.78,2.8},{9.91,3.72},{10.59,3.66},{9.95,3.11},},[40]={{42.14,82.98},{40.56,80.91},{40.8,82.58},{42.04,82.48},{40.87,81.47},},},nil,33,nil,nil,21,nil,},
[625] = {'Undead Dynamiter',1158,1251,17,18,1,{[33]={{10.06,2.83},{10.02,3.81},{10.42,4.09},{10.48,3.09},{10.81,4.11},{10.32,3.69},},[40]={{41.08,80.96},{41.0,82.74},{41.74,83.26},{41.85,81.44},{42.44,83.31},{41.55,82.54},},},nil,33,nil,nil,21,nil,},
[626] = {'Foreman Thistlenettle',1452,1452,20,20,1,{[33]={{10.68,3.73},},[40]={{42.22,82.61},},},nil,33,nil,nil,21,nil,},
[628] = {'Black Ravager',664,713,24,25,0,{[10]={{48.55,61.55},{69.98,35.41},{66.1,28.73},{63.74,27.8},{52.74,63.16},{64.13,25.65},{67.34,31.79},{68.37,33.3},{59.72,57.79},{59.33,58.84},},},nil,10,nil,nil,38,nil,},
[633] = {'Elaine Carevin',804,804,18,18,0,{[10]={{75.33,48.69},},},nil,10,{163,164,165,},nil,12,"A",},
[634] = {'Defias Overseer',1158,1251,17,18,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[636] = {'Defias Blackguard',1347,1452,19,20,1,{[1581]={{-1, -1}},},nil,1581,nil,nil,17,nil,},
[639] = {'Edwin VanCleef',4168,4168,21,21,1,{[1581]={{-1, -1}},},nil,1581,nil,nil,17,nil,},
[641] = {'Goblin Woodcarver',1251,1347,18,19,1,{[1581]={{-1, -1}},},nil,1581,nil,nil,17,nil,},
[642] = {'Sneed\'s Shredder',3872,3872,20,20,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[643] = {'Sneed',2420,2420,20,20,1,nil,nil,0,nil,nil,17,nil,},
[644] = {'Rhahk\'Zor',4490,4490,19,19,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[645] = {'Cookie',2904,2904,20,20,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[646] = {'Mr. Smite',3872,3872,20,20,1,{[1581]={{-1, -1}},},nil,1581,nil,nil,27,nil,},
[647] = {'Captain Greenskin',2904,2904,20,20,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[656] = {'Wilder Thistlenettle',919,919,20,20,0,{[1519]={{65.44,21.21},},},nil,1519,{167,168,},{167,168,},55,"A",},
[657] = {'Defias Pirate',1347,1452,19,20,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[658] = {'Sten Stoutarm',166,166,5,5,0,{[1]={{29.93,71.2},},},nil,1,{179,233,3106,3107,3108,3109,3110,3112,3113,3114,3115,},{179,},55,"A",},
[659] = {'El Pollo Grande',2685,2685,50,50,0,nil,nil,0,nil,nil,128,nil,},
[660] = {'Bloodscalp Witch Doctor',1257,1257,37,37,0,{[33]={{20.26,11.79},{20.09,11.94},{19.87,12.13},{20.87,15.38},{20.87,12.96},{21.01,13.54},{20.89,12.12},{20.5,14.3},{19.38,11.39},{20.42,12.94},{24.15,9.79},{24.03,9.98},{24.24,8.85},{23.57,8.19},{24.05,9.45},{23.37,8.41},{24.57,10.65},{24.69,10.31},},},nil,33,nil,nil,28,nil,},
[661] = {'Jonathan Carevin',1240,1240,25,25,0,{[10]={{75.32,49.02},},},nil,10,{1043,1044,},{223,1042,1043,},12,"A",},
[663] = {'Calor',919,919,20,20,0,{[10]={{75.75,47.57},},},{[10]={{75.31,48.07},{75.3,48.05},{75.75,47.57},},[41]={{14.67,42.91},{14.66,42.89},{15.15,42.37},},},10,{173,221,222,223,},{173,221,222,},12,"A",},
[664] = {'Benjamin Carevin',87,87,2,2,0,{[10]={{74.99,48.59},},},nil,10,nil,nil,12,"A",},
[667] = {'Skullsplitter Warrior',1678,1753,39,40,0,{[33]={{47.32,35.43},{47.26,35.45},{46.48,39.09},{48.52,40.87},{48.45,41.58},{45.0,38.06},{46.57,40.44},{45.16,33.62},{48.51,38.35},{44.08,40.07},{44.17,39.45},{45.04,40.22},{43.79,40.17},{47.64,41.02},{47.05,32.49},{47.54,33.3},{46.41,32.0},{45.19,32.34},{42.71,35.51},{42.67,35.58},{48.57,38.4},{42.18,35.79},{42.3,36.11},{42.12,36.29},{44.0,37.16},{43.34,36.39},{42.45,33.27},{43.51,33.01},{43.45,34.74},},},nil,33,nil,nil,30,nil,},
[669] = {'Skullsplitter Hunter',1902,1981,41,42,0,{[33]={{46.16,42.97},{46.03,41.61},{45.98,43.06},{45.04,44.09},{45.14,42.82},{44.92,41.72},{45.35,42.9},{45.79,43.54},{45.93,42.4},},},nil,33,nil,nil,30,nil,},
[670] = {'Skullsplitter Witch Doctor',1522,1585,41,42,0,{[33]={{45.6,42.78},{44.3,41.7},{44.32,42.21},{45.8,41.79},{45.55,42.22},{44.98,41.84},},},nil,33,nil,nil,30,nil,},
[671] = {'Bloodscalp Headhunter',1469,1536,36,37,0,{[33]={{20.04,11.67},{20.06,13.52},{23.69,8.83},{24.69,10.51},{21.33,10.2},{21.45,10.29},{22.74,8.62},{22.72,9.65},{23.37,10.92},{23.21,10.85},{22.7,10.79},{22.94,10.16},{24.46,9.9},{23.4,9.54},{23.44,8.78},{23.54,8.44},{23.68,10.88},{24.22,10.42},{24.39,10.57},{24.88,9.07},},},nil,33,nil,nil,28,nil,},
[672] = {'Skullsplitter Spiritchaser',1711,1711,44,44,0,{[33]={{48.01,42.58},{47.68,43.19},{48.05,43.24},{47.66,42.18},{44.32,44.85},{47.52,43.69},},},{[33]={{44.66,44.15},{44.76,43.91},{44.89,43.51},{45.0,43.07},{45.08,42.72},{45.44,41.96},{46.09,40.88},{46.58,40.93},{46.09,40.88},{45.44,41.96},{45.08,42.72},{45.0,43.07},{44.89,43.51},{44.76,43.91},{44.66,44.15},{44.32,44.85},},},33,nil,nil,30,nil,},
[674] = {'Venture Co. Strip Miner',1829,1902,40,41,0,{[33]={{41.67,43.91},{41.81,44.53},{42.29,45.09},{41.58,44.62},{42.17,46.22},{42.29,44.33},{42.06,46.11},{41.77,45.17},{42.02,46.3},{41.94,43.11},{42.05,42.57},{42.11,41.8},{42.38,41.41},{41.58,41.41},{41.43,43.83},{41.18,41.92},{40.35,43.27},{40.78,43.12},{40.35,43.79},{41.63,42.31},{41.21,43.01},{41.65,42.88},{41.32,42.43},{41.55,43.48},{41.3,43.62},},},nil,33,nil,nil,47,nil,},
[675] = {'Venture Co. Foreman',1981,1981,42,42,0,{[33]={{41.87,42.61},},},nil,33,nil,nil,47,nil,},
[676] = {'Venture Co. Surveyor',1522,1585,41,42,0,{[33]={{42.06,44.54},{42.09,46.2},{41.0,43.61},},},nil,33,nil,nil,47,nil,},
[677] = {'Venture Co. Tinkerer',1292,1332,40,41,0,{[33]={{41.97,44.64},{42.2,44.77},{41.82,41.6},{41.2,43.87},},},nil,33,nil,nil,47,nil,},
[678] = {'Mosh\'Ogg Mauler',5148,5346,43,44,1,{[33]={{51.5,28.54},{51.48,27.13},{50.77,27.72},{50.63,27.84},{50.19,27.73},{51.57,26.64},{52.52,28.18},},},nil,33,nil,nil,45,nil,},
[679] = {'Mosh\'Ogg Shaman',4119,4278,43,44,1,{[33]={{50.31,30.45},{50.26,30.58},{50.42,30.55},{50.4,30.4},{52.17,27.63},{51.23,27.87},{50.85,27.12},{51.0,26.61},{50.14,27.94},},},nil,33,nil,nil,45,nil,},
[680] = {'Mosh\'Ogg Lord',5544,5544,45,45,1,{[33]={{52.79,27.68},{52.88,27.85},{52.12,26.66},{50.57,31.28},},},nil,33,nil,nil,45,nil,},
[681] = {'Young Stranglethorn Tiger',1050,1107,30,31,0,{[33]={{38.7,15.36},{37.35,14.33},{39.21,14.45},{38.84,13.64},{36.11,15.31},{37.29,11.56},{40.19,9.93},{33.91,12.98},{35.07,12.11},{34.73,17.51},{35.98,12.93},{35.13,16.52},{35.65,12.14},{31.43,8.39},{32.41,9.57},{30.64,7.56},{33.06,9.57},{31.54,9.94},{33.36,9.94},{33.57,11.15},{34.07,11.33},{40.41,8.3},{34.54,14.0},},},nil,33,nil,nil,16,nil,},
[682] = {'Stranglethorn Tiger',1163,1221,32,33,0,{[33]={{47.4,11.43},{46.6,17.51},{47.17,18.47},{30.18,13.58},{29.73,11.29},{30.4,9.02},{42.88,15.25},{47.13,16.81},{28.96,9.54},{30.34,15.24},{29.36,10.41},{30.75,16.05},{46.0,16.89},{46.53,12.93},{48.07,13.69},{46.58,14.4},{47.59,12.85},{48.19,12.18},{46.08,15.32},{46.57,16.09},{47.13,15.25},{44.0,13.68},{45.47,14.54},},},nil,33,nil,nil,16,nil,},
[683] = {'Young Panther',1050,1107,30,31,0,{[33]={{37.33,8.25},{36.08,7.24},{35.08,15.12},{41.27,8.08},{36.62,13.76},{39.13,6.59},{39.22,8.06},{35.03,14.16},{38.29,13.45},{37.75,12.77},{42.91,10.5},{42.07,10.14},{41.39,10.46},{42.47,9.56},{43.06,12.31},{42.31,13.2},{41.78,12.75},{41.27,13.44},{40.54,11.4},{40.65,11.19},{41.77,12.98},{41.35,12.82},{42.36,13.22},{42.86,13.63},},},nil,33,nil,nil,16,nil,},
[684] = {'Shadowmaw Panther',1536,1604,37,38,0,{[33]={{37.28,45.25},{39.29,45.54},{39.55,44.17},{46.09,26.19},{46.45,22.54},{47.23,23.07},{49.68,24.06},{49.71,25.47},{48.88,23.86},{46.52,28.44},{50.25,24.68},{48.66,20.75},{48.69,22.22},{50.66,20.61},{49.74,20.77},{48.09,20.2},{39.37,33.31},{38.7,32.86},{39.14,39.9},{39.22,37.91},{36.59,37.8},{45.94,27.72},{46.53,26.89},{38.33,34.67},{39.57,42.56},},},nil,33,nil,nil,16,nil,},
[685] = {'Stranglethorn Raptor',1221,1279,33,34,0,{[33]={{24.17,16.16},{23.72,15.41},{24.53,15.69},{24.06,15.67},{24.51,16.19},{24.76,16.07},{27.29,16.65},{26.75,17.61},{26.01,17.09},{25.72,15.81},{26.55,16.03},{27.39,15.45},{27.55,17.67},{27.79,14.32},},},nil,33,nil,nil,48,nil,},
[686] = {'Lashtail Raptor',1403,1469,35,36,0,{[33]={{39.34,19.1},{38.55,19.79},{39.07,22.09},{38.87,21.64},{38.24,20.49},{35.95,27.15},{38.28,19.16},{35.62,26.33},{38.88,24.59},{37.57,27.9},{37.82,19.75},{37.73,21.48},{38.44,25.24},{38.77,26.17},{38.1,27.02},{30.6,24.0},{30.69,23.72},{30.27,24.66},{30.66,23.5},{30.55,22.47},{30.8,23.22},{32.5,21.42},{31.97,20.68},{32.4,23.17},{32.4,24.59},{32.06,23.79},{32.97,23.89},{33.96,25.47},{33.4,24.55},},},nil,33,nil,nil,48,nil,},
[687] = {'Jungle Stalker',1829,1902,40,41,0,{[33]={{23.35,48.24},{28.28,46.47},{27.31,43.38},{32.56,37.21},{34.65,38.92},{34.63,40.15},{32.44,41.72},{32.0,42.36},{31.21,44.64},{32.11,43.06},{31.35,41.96},{30.64,44.1},{31.88,40.79},{33.43,37.21},{31.55,40.7},{30.45,41.83},{32.95,36.54},{31.48,43.36},{30.14,43.56},{28.91,44.16},{28.88,42.63},{29.95,44.07},{28.83,45.6},{28.33,43.49},{30.92,42.54},{27.45,48.11},{27.95,47.22},{29.33,43.56},{28.22,44.96},{27.3,49.72},{27.8,48.93},{27.6,50.28},{24.9,51.2},{23.68,48.93},{26.14,51.36},{26.92,48.69},{23.43,50.3},{26.05,49.89},{26.63,50.53},{23.0,49.68},{24.11,49.64},{23.15,51.5},{32.7,39.17},},},nil,33,nil,nil,48,nil,},
[688] = {'Stone Maw Basilisk',1107,1163,31,32,0,{[33]={{34.68,6.74},{35.69,6.75},{33.67,6.36},{36.6,8.27},{30.83,2.44},},},nil,33,nil,nil,49,nil,},
[689] = {'Crystal Spine Basilisk',1279,1342,34,35,0,{[33]={{49.23,9.64},{47.99,6.46},{48.73,10.44},{47.4,5.88},{46.57,5.84},{48.2,8.15},{23.71,16.98},{23.06,17.65},{24.19,17.72},{24.52,16.84},{24.64,18.16},{24.66,16.99},{27.36,18.39},{25.11,17.68},{27.27,18.48},{26.25,18.09},{48.68,8.96},},},nil,33,nil,nil,49,nil,},
[690] = {'Cold Eye Basilisk',1678,1753,39,40,0,{[33]={{28.73,40.88},{31.36,37.3},{30.87,37.14},{29.93,37.61},{28.77,38.8},{29.27,38.05},{28.3,39.63},{27.69,42.68},{27.7,41.0},{28.22,41.83},{36.99,41.74},{36.21,42.03},{38.15,40.36},{37.18,40.21},{36.56,42.59},{36.18,43.57},{35.66,42.62},{35.53,39.42},{36.46,41.15},},},nil,33,nil,nil,49,nil,},
[691] = {'Lesser Water Elemental',1469,1536,36,37,0,{[33]={{19.9,24.49},{19.83,23.84},{21.88,23.9},{21.87,24.36},{21.43,23.19},{21.53,24.67},{21.39,23.77},{20.95,23.68},{21.01,23.12},{20.39,23.9},{20.4,23.17},{20.97,24.59},{21.01,23.32},{20.36,24.58},{20.48,22.26},{22.53,23.13},{22.16,23.14},{21.44,22.41},{22.04,22.41},{21.02,22.13},{20.31,21.57},{19.94,21.61},{19.43,22.31},{20.0,22.8},},},nil,33,nil,nil,91,nil,},
[694] = {'Bloodscalp Axe Thrower',1221,1279,33,34,0,{[33]={{29.69,19.62},{28.98,19.12},{28.81,19.95},{29.34,20.0},{33.73,15.64},{33.48,17.02},{33.94,15.88},{33.56,15.61},{34.56,16.0},{33.95,15.43},},},nil,33,nil,nil,28,nil,},
[696] = {'Skullsplitter Axe Thrower',1678,1753,39,40,0,{[33]={{47.28,35.27},{45.92,38.0},{46.45,38.82},{47.33,39.9},{47.46,39.77},{47.05,41.81},{45.98,40.36},{47.1,39.46},{45.02,33.63},{48.53,38.38},{43.41,39.5},{48.71,40.1},{46.51,30.01},{47.1,34.09},{45.99,32.34},{42.72,35.59},{41.93,36.28},},},nil,33,nil,nil,30,nil,},
[697] = {'Bloodscalp Shaman',1021,1064,33,34,0,{[33]={{29.82,19.46},{29.89,19.72},{29.66,19.12},{29.57,19.25},{30.71,19.35},{30.31,20.73},{30.57,18.09},{30.45,16.77},{29.52,19.43},{29.5,19.65},},},nil,33,nil,nil,28,nil,},
[698] = {'Bloodscalp Tiger',1279,1342,34,35,0,nil,nil,0,nil,nil,28,nil,},
[699] = {'Bloodscalp Beastmaster',1279,1342,34,35,0,{[33]={{26.27,13.39},{25.27,9.05},{25.1,10.62},{22.92,11.32},{22.55,8.37},{27.54,11.32},},},nil,33,nil,nil,28,nil,},
[701] = {'Bloodscalp Mystic',1064,1110,34,35,0,{[33]={{22.54,13.37},{24.23,13.24},{26.28,12.16},{26.27,12.41},{26.11,13.42},{24.79,12.18},{26.35,13.24},{23.89,12.2},{26.11,12.17},{25.43,9.2},{26.11,8.95},{26.02,8.73},{25.68,9.11},{25.39,9.96},{25.12,9.3},{25.05,9.72},{25.45,9.59},{25.72,10.03},{27.21,11.26},{26.46,11.42},{27.58,11.0},{25.88,11.03},{26.0,11.5},{25.35,12.24},{24.7,11.5},{25.18,11.27},{23.9,13.22},{23.13,13.15},{23.38,12.61},{22.93,12.23},},},nil,33,nil,nil,28,nil,},
[702] = {'Bloodscalp Scavenger',1221,1297,33,34,0,{[33]={{31.16,12.42},{31.3,12.89},{31.41,11.43},{31.57,12.08},{31.46,14.36},{32.99,13.67},{31.95,13.65},{32.64,12.93},},},nil,33,nil,nil,28,nil,},
[703] = {'Lieutenant Fangore',788,788,26,26,0,{[44]={{80.18,37.06},},},nil,44,nil,nil,39,nil,},
[704] = {'Ragged Timber Wolf',55,55,2,2,0,{[1]={{23.26,78.74},{23.22,77.69},{24.01,79.74},{24.84,78.22},{25.5,79.51},{26.89,78.02},{25.96,75.3},{26.88,76.22},{28.1,78.07},{27.66,77.03},{27.96,76.08},{27.41,75.39},{26.8,75.08},{29.66,74.8},{28.76,76.92},{29.8,74.74},},},nil,1,nil,nil,32,"AH",},
[705] = {'Ragged Young Wolf',42,42,1,1,0,{[1]={{32.28,70.8},{31.42,70.05},{31.3,73.97},{29.93,73.41},{30.31,74.18},{30.91,73.17},{30.76,74.59},{31.14,69.04},{28.73,72.36},{28.56,72.15},{26.68,69.85},{27.6,72.36},{27.35,71.1},{27.97,73.25},{25.97,70.9},{26.48,70.81},{26.05,69.19},{22.57,78.23},{23.87,77.86},{25.58,78.07},{27.61,74.19},{26.39,74.74},{28.05,74.97},{28.22,75.5},{28.54,75.85},{28.84,73.81},{28.48,75.06},{28.68,72.67},{28.41,73.89},{27.85,73.22},{28.41,74.35},{28.31,71.75},{28.98,74.51},{30.32,75.04},{29.23,75.89},{29.66,74.27},{29.32,74.7},{29.23,77.98},{29.49,77.15},{29.77,75.91},{29.25,73.41},{28.81,73.63},{29.03,74.65},{29.24,73.92},{29.87,74.49},{30.46,73.74},{30.02,73.7},{30.79,72.95},{31.37,73.87},{30.9,75.82},{28.79,74.16},},},nil,1,nil,nil,32,"AH",},
[706] = {'Frostmane Troll Whelp',71,86,3,4,0,{[1]={{20.78,75.93},{21.29,76.03},{21.0,75.33},{20.84,76.26},{21.03,76.44},{20.21,75.89},{21.42,76.97},{21.39,77.96},{20.39,77.17},{20.83,76.63},{22.31,78.12},{22.09,78.84},{22.61,78.94},{22.32,79.32},{23.34,79.96},{23.77,80.33},{22.99,79.35},{22.76,80.8},{22.66,79.97},{22.85,79.96},{22.85,80.13},{22.67,80.19},{25.86,78.26},{25.77,79.27},{26.42,79.37},{26.84,79.92},{26.14,79.97},{27.13,80.46},{27.16,78.44},{27.7,78.82},{26.39,78.34},{26.83,78.96},{28.47,80.76},{28.68,79.19},{28.46,79.61},{26.98,81.08},{27.98,81.06},{28.08,80.25},{28.01,80.56},{27.63,80.87},{28.44,80.77},{28.68,82.98},{29.16,81.96},{28.73,83.02},{28.68,81.04},{28.96,80.9},{28.8,80.58},{28.76,80.09},{28.29,82.15},{29.57,80.37},{29.49,79.99},{29.32,79.05},{29.57,79.12},{29.79,79.86},{29.85,80.43},{29.26,80.71},{30.59,81.9},{30.53,81.29},{30.1,79.32},{30.59,80.02},{30.08,79.82},{30.46,80.71},{30.17,79.36},},},{[1]={{28.43,80.77},{28.58,80.85},{28.76,81.03},{28.93,81.06},{28.87,80.82},{28.82,80.63},{28.79,80.45},{28.75,80.21},{28.66,79.84},{28.74,80.12},{28.79,80.39},{28.82,80.61},{28.88,80.86},{28.92,81.05},{28.74,81.09},{28.63,80.9},{30.17,79.36},{29.96,79.23},{29.75,79.12},{29.64,79.08},{29.57,79.06},{29.44,79.03},{29.28,78.86},{29.23,78.83},{29.12,78.84},{28.96,78.91},{29.13,78.85},{29.23,78.83},{29.3,78.86},{29.45,79.04},{29.58,79.06},{29.65,79.08},{29.77,79.11},{29.98,79.24},{30.18,79.36},{30.32,79.46},{30.41,79.61},{30.49,79.85},{30.43,80.06},{30.34,80.18},{30.24,80.25},{30.12,80.34},{29.99,80.4},{29.89,80.43},{29.77,80.43},{29.71,80.45},{29.62,80.57},{29.6,80.66},{29.59,80.82},{29.57,80.93},{29.44,81.02},{29.56,80.91},{29.59,80.8},{29.6,80.63},{29.63,80.53},{29.71,80.44},{29.78,80.42},{29.9,80.41},{30.0,80.38},{30.12,80.33},{30.25,80.24},{30.35,80.16},{30.44,80.04},{30.49,79.83},{30.41,79.6},{30.32,79.44},},},1,nil,nil,107,nil,},
[707] = {'Rockjaw Trogg',42,55,1,2,0,{[1]={{32.35,74.47},{31.13,74.74},{31.05,73.95},{30.62,74.56},{24.31,71.0},{23.83,73.48},{21.82,72.42},{20.12,73.23},{19.42,74.44},{21.8,73.37},{22.75,76.27},{23.21,78.39},{24.12,77.29},{23.04,73.71},{29.26,75.5},{28.84,76.47},{30.07,74.49},{29.92,75.01},{28.96,77.11},{28.86,77.64},{29.64,76.26},{29.9,77.96},{30.35,77.57},{29.78,77.66},{30.72,77.02},{30.04,76.63},{30.47,74.91},{30.75,74.46},{30.68,75.71},{31.81,75.75},{31.56,76.17},{31.81,74.62},{32.11,75.11},{31.25,75.97},{31.11,74.78},{31.33,76.61},{31.98,76.38},{31.67,77.59},{32.84,75.21},{32.25,75.86},{33.34,75.43},},},nil,1,nil,nil,36,"AH",},
[708] = {'Small Crag Boar',71,71,3,3,0,{[1]={{32.28,71.68},{31.22,69.24},{28.21,73.04},{26.58,69.66},{27.43,71.62},{25.99,69.17},{26.18,71.19},{26.59,68.57},{25.41,70.23},{24.67,70.9},{24.62,69.16},{25.5,68.37},{24.39,68.11},{23.41,69.15},{24.03,72.5},{23.58,68.55},{22.7,70.19},{22.71,69.56},{22.2,69.45},{22.35,71.61},{22.82,72.48},{21.3,69.13},{20.38,74.24},{20.76,73.4},{20.71,69.12},{19.86,73.42},{20.09,71.08},{19.9,72.29},{20.14,71.37},{20.21,74.51},{19.47,75.15},{21.39,70.23},{20.7,70.28},{21.81,71.44},{21.43,71.27},{21.34,72.22},{22.02,72.32},{20.73,74.12},{20.66,73.3},{20.06,73.32},{21.25,69.14},{20.69,69.18},{21.92,70.12},{21.95,71.26},{22.11,72.2},{21.98,69.3},{22.6,69.33},{22.61,70.15},{22.74,72.42},{20.75,75.28},{21.46,78.02},{19.75,76.42},{23.46,78.77},{24.02,78.82},{23.98,76.46},{24.69,79.28},{28.01,73.07},},},nil,1,nil,nil,1094,"AH",},
[709] = {'Mosh\'Ogg Warmonger',4755,4953,41,42,1,{[33]={{50.24,31.0},{47.13,24.77},{49.21,26.95},{48.14,30.93},{48.76,31.47},{49.24,30.8},{49.71,29.95},{49.91,28.21},{48.85,30.08},{49.99,27.81},{46.4,25.34},{48.04,29.62},{47.91,29.73},{48.77,28.63},{50.07,27.56},},},{[33]={{49.91,28.23},{49.9,28.44},{49.86,28.69},{49.74,28.99},{49.7,29.2},{49.57,29.32},{49.39,29.47},{49.15,29.75},{49.05,30.08},{49.15,29.75},{49.39,29.47},{49.57,29.32},{49.7,29.2},{49.74,28.99},{49.86,28.69},{49.9,28.44},{49.99,27.8},{49.44,27.3},{49.04,26.81},{48.69,26.3},{48.21,25.92},{47.58,25.56},{47.2,25.34},{47.58,25.56},{48.21,25.92},{48.69,26.3},{49.04,26.81},{49.44,27.3},{50.08,27.55},{50.27,27.09},{50.41,26.91},{50.5,26.75},{50.53,26.6},{50.57,26.39},{50.49,26.12},{50.31,25.85},{50.24,25.19},{50.31,25.85},{50.49,26.12},{50.57,26.39},{50.53,26.6},{50.5,26.75},{50.41,26.91},{50.27,27.09},},},33,nil,nil,45,nil,},
[710] = {'Mosh\'Ogg Spellcrafter',3603,3741,43,44,1,{[33]={{51.76,27.38},{51.21,26.78},{51.89,26.57},{51.57,28.25},{51.37,27.89},{50.34,31.03},{51.96,27.67},},},nil,33,nil,nil,45,nil,},
[711] = {'Ardo Dirtpaw',582,582,24,24,0,{[44]={{17.06,17.43},},},nil,44,nil,nil,19,nil,},
[712] = {'Redridge Thrasher',300,328,14,15,0,{[44]={{28.86,81.22},{13.6,67.77},{15.13,61.33},{15.07,67.19},{15.46,66.29},{16.88,65.7},{16.5,63.54},{16.71,63.53},{27.26,80.56},{14.95,61.73},{15.04,61.82},{15.95,67.44},},},nil,44,nil,nil,19,nil,},
[713] = {'Balir Frosthammer',166,166,5,5,0,{[1]={{29.71,71.25},},},nil,1,{170,},{170,},55,"A",},
[714] = {'Talin Keeneye',166,166,5,5,0,{[1]={{22.6,71.43},},},nil,1,{183,234,},{183,233,},55,"A",},
[715] = {'Hemet Nesingwary',2471,2471,40,40,0,{[33]={{35.66,10.81},},},nil,33,{194,195,196,197,208,},{194,195,196,197,208,583,5762,5763,},35,"AH",},
[716] = {'Barnil Stonepot',2471,2471,40,40,0,{[33]={{35.66,10.53},},},nil,33,{338,339,340,341,342,583,},{338,339,340,341,342,},35,"AH",},
[717] = {'Ajeck Rouack',2471,2471,40,40,0,{[33]={{35.62,10.62},},},nil,33,{185,186,187,188,},{185,186,187,188,},35,"AH",},
[718] = {'Sir S. J. Erlgadin',2471,2471,40,40,0,{[33]={{35.55,10.55},},},nil,33,{190,191,192,193,},{190,191,192,193,},35,"AH",},
[721] = {'Rabbit',1,1,1,1,0,{[1]={{50.15,38.79},{47.54,39.81},{47.24,44.59},{46.98,47.62},{47.52,55.37},{48.03,57.91},{48.1,59.35},{45.17,60.33},{43.36,66.81},{40.86,65.59},{38.67,61.58},{36.87,60.94},{34.83,59.97},{31.06,74.35},{30.41,71.83},{30.35,72.21},{29.23,71.64},{29.17,72.87},{28.55,70.13},{28.25,70.71},{27.86,70.09},{27.84,72.86},{25.58,70.95},{23.64,72.6},{21.54,71.53},{22.49,72.18},{25.19,73.63},{25.01,76.51},{24.61,76.49},{26.24,74.03},{27.72,75.27},{28.34,75.81},{29.06,71.14},{30.1,73.57},{29.44,74.2},{30.69,72.03},{30.34,75.49},{38.8,61.96},{48.18,57.71},{48.92,45.7},{47.27,44.31},{47.58,39.41},{50.15,39.09},{52.05,42.01},{48.16,63.16},{43.85,37.94},{44.07,33.81},{44.36,31.51},{41.3,30.74},{39.39,32.83},{36.91,32.42},{34.46,30.64},{32.96,31.76},{30.64,35.54},{28.24,36.29},{27.58,45.11},{26.64,48.09},{27.15,51.65},{28.37,54.4},{27.88,52.61},{27.92,41.09},{30.16,45.22},{29.78,48.97},{32.21,52.85},{30.31,52.69},{31.11,54.68},{31.45,58.5},{32.07,56.19},{34.27,55.64},{37.54,52.13},{38.72,46.86},{40.94,47.21},{37.07,45.31},{37.45,43.86},{34.43,46.65},{32.29,49.07},{35.72,36.52},{40.2,42.43},{40.35,40.86},{38.63,38.08},{86.99,50.31},{41.97,46.88},{43.89,52.48},{66.1,13.2},{41.16,56.17},{44.5,57.01},{40.29,58.91},{38.91,61.03},{40.68,65.26},{49.4,54.22},{46.58,47.4},{49.04,46.0},{50.34,47.62},{50.92,49.21},{47.93,59.85},{50.63,59.07},{56.27,56.65},{56.88,51.57},{57.96,46.06},{61.68,53.56},{56.84,60.65},{60.68,58.5},{67.13,56.01},{65.78,53.72},{67.42,51.31},{69.83,52.35},{70.96,52.84},{69.82,50.75},{73.71,49.72},{75.47,49.82},{80.36,55.64},{81.56,54.97},{81.48,52.92},{80.12,51.75},{84.55,50.39},{85.12,47.33},{78.87,49.74},{80.24,47.15},{80.0,42.99},{81.22,43.66},{65.73,12.79},{67.48,16.11},{68.2,16.93},{70.01,19.31},{70.28,25.14},{71.15,29.37},{66.93,2.89},{64.54,3.57},{62.4,4.54},{58.69,6.68},},[11]={{25.73,78.47},{25.29,77.97},{27.37,81.92},{28.22,82.9},{30.38,85.74},{30.7,92.69},{31.74,97.72},{26.71,66.18},{23.87,66.99},{21.31,68.14},{16.89,70.69},},[44]={{78.56,65.38},{72.49,46.96},{76.79,73.28},{59.41,67.07},{81.23,36.06},{65.17,76.44},{86.03,55.37},{46.2,78.82},{84.17,46.11},{82.69,45.25},{81.49,52.81},{55.57,78.11},{40.65,35.96},{73.46,48.2},{48.1,78.27},{32.97,80.09},{25.5,45.97},{19.54,61.36},{12.77,83.07},{33.7,42.45},{11.54,73.97},{38.61,75.24},{24.83,67.48},{14.87,50.25},{73.39,73.42},{76.83,79.79},{76.73,82.07},{26.84,79.5},{50.81,74.94},{61.98,72.54},{62.42,73.71},{22.42,45.44},{72.59,45.64},{70.32,45.57},{42.8,78.85},{43.46,77.38},{66.08,41.38},{71.91,40.73},{48.35,75.53},{14.87,67.66},{25.59,63.84},{53.61,36.93},{31.39,71.69},{61.96,73.25},{68.15,45.19},{23.77,75.15},{31.74,46.14},{34.13,62.45},{34.29,60.12},{30.5,60.41},{19.22,56.94},{27.37,65.82},{10.81,80.22},{24.27,41.97},{48.48,33.11},{32.67,43.3},{36.94,74.95},{26.3,71.7},{18.4,47.39},},[267]={{52.48,60.27},{42.13,59.46},{44.6,48.34},{47.26,54.18},{53.86,56.81},{52.86,54.46},{36.15,57.71},{37.27,45.49},{42.02,63.41},},[130]={{47.4,31.99},{54.61,55.01},{51.63,76.83},},[85]={{61.58,38.68},{61.05,32.51},{30.83,64.28},{30.8,49.82},{68.86,34.55},{51.25,53.93},{56.88,36.69},{58.98,36.16},{64.5,33.86},{45.98,58.06},{36.93,63.8},{62.13,58.24},{56.71,58.33},{46.17,57.98},{69.85,54.83},},[406]={{83.05,84.61},{83.38,87.71},{76.79,54.02},{60.42,48.75},{83.06,84.37},{74.99,85.42},{74.14,44.92},{79.07,85.67},{63.19,59.44},{57.54,66.5},{46.84,43.29},{49.55,46.25},{48.34,36.0},{67.43,37.54},{63.11,83.88},{52.35,53.0},},[148]={{40.33,53.45},{43.89,86.52},{40.45,88.66},{43.36,72.96},{38.3,63.68},{42.3,77.96},{42.42,39.02},{40.81,78.62},{39.97,91.0},{41.08,46.63},{45.74,35.14},{38.2,45.71},{40.84,60.61},{58.12,26.23},{41.81,44.19},{46.5,27.17},},[796]={{-1, -1}},[493]={{36.58,57.39},{57.07,72.45},{49.8,65.86},{67.54,55.39},{33.83,59.95},{62.11,47.85},{63.97,50.03},{37.85,51.62},{61.21,67.79},{44.73,70.4},{37.29,30.56},{32.72,46.57},{59.4,65.8},{64.11,60.89},{35.83,40.52},{37.98,40.42},{41.49,44.54},{45.18,43.21},{55.39,32.34},{40.79,68.43},{65.38,70.23},{50.93,31.23},{53.87,31.17},{35.84,30.05},{41.2,53.04},{66.13,62.78},{49.07,70.85},{39.03,62.05},{63.53,64.36},{65.29,44.18},{69.05,53.97},{58.7,71.61},{50.87,39.29},{48.51,31.16},},[141]={{63.89,52.38},{62.85,66.54},{63.23,54.62},{60.9,35.94},{55.19,76.23},{49.66,77.74},{65.15,51.01},{55.24,45.74},{53.88,77.39},{44.21,47.64},{48.51,62.46},{47.39,63.88},{62.34,44.11},{43.28,47.93},{40.02,61.22},{61.77,69.9},{38.51,43.23},{42.9,45.44},{68.11,52.95},{50.83,75.61},{38.21,35.22},{48.28,64.96},{44.91,75.6},{41.74,70.23},{55.28,43.8},{46.55,78.08},{52.4,78.16},{66.91,63.45},{40.99,53.89},{48.11,63.93},{41.51,29.75},{63.55,37.39},{64.38,70.64},{54.68,41.85},{61.41,33.74},{64.69,41.58},{40.87,68.35},{65.71,67.1},{58.29,63.89},{59.56,32.54},{68.12,60.85},{59.61,38.82},{49.16,59.62},{60.97,43.82},{50.99,61.55},{56.41,38.81},{55.31,63.88},{59.39,46.17},{55.66,62.15},{55.24,60.9},{67.1,50.72},{37.88,56.98},{58.84,41.88},{57.43,32.99},{50.95,61.59},{51.97,60.37},{61.3,39.9},{58.25,46.06},{55.66,62.21},{58.77,43.71},{58.29,63.94},{57.62,61.4},{55.2,60.86},{66.38,53.36},{51.98,60.44},{50.96,61.6},{58.43,59.89},{60.46,55.64},{61.29,39.92},},[357]={{50.34,27.53},{46.15,25.19},{67.48,45.38},{61.95,69.54},{75.73,61.63},{61.53,55.67},},[12]={{59.93,79.26},{62.97,78.37},{45.08,65.47},{40.73,60.86},{33.28,49.11},{32.2,52.12},{30.71,53.26},{34.0,51.83},{34.31,55.08},{36.35,55.06},{38.68,55.13},{41.16,55.36},{48.88,43.85},{48.19,42.86},{50.41,41.06},{50.39,38.46},{49.94,35.11},{46.65,32.0},{47.48,33.63},{49.69,31.72},{50.14,33.16},{44.16,35.18},{44.55,38.7},{44.1,37.71},{52.68,32.56},{50.45,35.15},{43.88,39.91},{51.4,38.74},{51.46,38.94},{52.79,36.98},{51.32,48.33},{46.74,47.02},{52.48,50.38},{50.64,50.34},{51.62,49.53},{52.76,50.95},{52.96,51.6},{54.16,49.02},{53.77,47.47},{54.93,52.4},{53.97,46.43},{56.25,49.12},{57.08,48.53},{55.32,46.06},{55.39,47.05},{56.29,43.08},{55.53,43.15},{56.3,41.98},{55.4,41.23},{55.47,40.44},{57.21,40.86},{44.24,46.24},{37.65,58.71},{34.92,59.11},{36.46,59.64},{40.58,60.85},{45.01,64.79},{41.65,68.94},{42.38,70.16},{39.04,69.01},{26.66,74.67},{26.76,77.41},{24.13,75.57},{22.04,79.15},{26.44,82.63},{26.78,86.24},{26.52,91.23},{26.78,93.11},{31.73,81.35},{32.07,84.3},{32.53,87.23},{36.02,86.03},{39.9,90.31},{41.4,87.68},{42.32,86.02},{43.7,70.92},{47.98,84.45},{51.66,71.28},{54.24,73.21},{53.92,78.26},{54.52,79.46},{56.82,75.15},{55.56,75.09},{60.07,78.96},{67.7,77.2},{68.5,81.87},{69.7,78.47},{72.46,80.18},{57.35,48.57},{51.42,71.9},{82.81,69.64},{85.13,71.5},{84.21,67.8},{87.87,79.84},},[2557]={{-1, -1}},},nil,1,nil,nil,31,"AH",},
[723] = {'Mosh\'Ogg Butcher',5346,5346,44,44,2,{[33]={{49.83,30.87},},},{[33]={{49.54,30.82},{50.23,30.8},{49.83,30.87},},},33,nil,nil,45,nil,},
[724] = {'Burly Rockjaw Trogg',55,55,2,2,0,{[1]={{31.63,73.69},{27.22,72.14},{27.21,73.02},{26.87,73.14},{27.42,73.41},{26.3,73.16},{26.92,72.95},{26.16,72.22},{26.56,72.57},{26.19,71.9},{26.19,72.14},{26.1,72.68},{26.59,71.91},{27.02,72.63},{25.65,72.46},{25.37,73.1},{24.8,72.38},{23.91,72.56},{22.7,73.16},{22.98,73.56},{20.78,72.12},{21.19,71.78},{21.44,74.68},{20.81,74.3},{20.61,70.45},{20.24,71.51},{19.99,75.41},{19.42,72.24},{21.45,73.32},{21.84,72.66},{21.36,75.37},{21.32,77.31},{21.9,76.25},{20.01,77.52},{21.96,78.23},{22.86,77.55},{23.96,79.6},{23.33,76.68},{22.92,75.39},{23.91,75.21},{24.19,74.24},{23.89,73.04},{23.14,74.16},{22.9,74.45},{25.99,74.23},{26.64,73.4},{24.83,74.18},{27.69,76.51},{30.32,74.52},{29.25,75.0},{29.22,77.74},{28.57,78.02},{30.11,75.63},{29.96,77.42},{30.29,76.27},{30.69,75.13},{31.67,75.98},{31.25,75.35},{30.89,76.23},{31.72,76.76},{32.38,75.86},},},nil,1,nil,nil,36,"AH",},
[727] = {'Ironforge Mountaineer',1918,1918,30,30,0,{[1]={{46.94,41.9},{46.98,42.25},{47.01,42.36},{47.65,45.58},{46.93,47.89},{46.39,55.01},{46.54,52.8},{46.15,51.42},{45.97,50.98},{46.02,52.12},{46.54,52.22},{48.07,55.29},{47.53,57.54},{36.03,61.85},{43.34,65.14},{37.97,61.89},{67.22,3.29},{67.32,2.92},{35.12,32.92},{35.12,32.86},{75.84,49.2},{75.81,49.25},{75.83,49.13},{49.58,46.61},{50.14,49.16},{57.95,52.56},{69.86,40.93},{69.72,40.73},{71.74,31.34},{71.44,23.99},{71.66,24.38},{71.46,24.12},{70.12,25.76},{71.65,23.28},{70.11,20.77},{70.99,22.22},{68.77,18.87},{69.6,40.63},{70.07,41.66},{70.02,41.85},{72.01,32.27},{70.81,29.86},{71.79,31.28},{69.68,30.27},{70.0,26.64},{71.11,22.33},{70.14,20.71},{68.74,18.69},{68.88,18.55},{54.8,20.57},},[11]={{27.06,66.66},{27.17,66.21},{32.09,91.31},{32.34,91.78},{32.11,91.47},{30.52,93.43},{32.33,90.47},{30.5,87.48},{31.55,89.21},{28.9,85.21},{31.33,98.3},{29.99,98.8},{30.37,94.47},{31.69,89.33},{30.53,87.41},{28.87,85.0},{29.04,84.83},{12.26,87.24},},},{[1]={{47.05,41.77},{47.24,41.69},{47.53,41.63},{47.79,41.59},{48.07,41.59},{48.21,41.52},{48.21,41.1},{48.08,41.0},{48.21,41.1},{48.21,41.52},{48.07,41.59},{47.79,41.59},{47.53,41.63},{47.24,41.69},{46.39,54.78},{46.4,54.48},{46.4,54.22},{46.4,53.9},{46.41,53.59},{46.41,53.12},{46.42,52.66},{46.43,52.27},{46.39,51.93},{46.39,51.49},{46.39,50.98},{46.43,50.46},{46.61,50.09},{46.88,49.93},{47.08,49.52},{47.09,49.0},{47.11,48.35},{47.09,47.52},{47.08,47.02},{47.06,46.43},{47.16,45.67},{47.15,44.94},{47.05,44.2},{47.15,44.94},{47.16,45.67},{47.06,46.43},{47.08,47.02},{47.09,47.52},{47.11,48.35},{47.09,49.0},{47.08,49.52},{46.88,49.93},{46.61,50.09},{46.43,50.46},{46.39,50.98},{46.39,51.49},{46.39,51.93},{46.43,52.27},{46.42,52.66},{46.41,53.12},{46.41,53.59},{46.4,53.9},{46.4,54.22},{46.4,54.48},{47.83,55.87},{47.9,55.57},{48.01,55.24},{48.29,55.09},{48.29,55.62},{48.1,55.91},{47.77,56.13},{35.95,61.83},{35.85,61.82},{35.72,61.89},{35.55,62.04},{35.46,62.2},{35.36,62.39},{35.3,62.7},{35.32,62.96},{35.34,63.23},{35.36,63.5},{35.37,63.76},{35.39,64.02},{35.35,64.28},{35.39,64.52},{35.43,64.83},{35.49,65.13},{35.54,65.37},{35.6,65.76},{35.54,65.37},{35.49,65.13},{35.43,64.83},{35.39,64.52},{35.35,64.28},{35.39,64.02},{35.37,63.76},{35.36,63.5},{35.34,63.23},{35.32,62.96},{35.3,62.7},{35.36,62.39},{35.46,62.2},{35.55,62.04},{35.72,61.89},{35.85,61.82},{35.12,32.91},{35.8,32.7},{37.17,32.75},{38.59,32.55},{39.26,31.88},{40.79,31.66},{42.84,31.58},{43.46,32.02},{44.18,33.3},{44.39,37.82},{45.03,39.98},{46.2,41.27},{46.39,41.87},{46.2,41.27},{45.03,39.98},{44.39,37.82},{44.18,33.3},{43.46,32.02},{42.84,31.58},{40.79,31.66},{39.26,31.88},{38.59,32.55},{37.17,32.75},{35.8,32.7},{35.12,32.86},{37.29,32.65},{38.64,32.45},{39.21,31.75},{42.75,31.48},{43.48,31.91},{44.28,33.32},{44.47,37.71},{45.13,39.98},{46.25,41.21},{46.46,41.82},{46.25,41.21},{44.47,37.71},{44.28,33.32},{43.48,31.91},{42.75,31.48},{39.21,31.75},{38.64,32.45},{37.29,32.65},{76.53,49.7},{77.2,49.75},{77.88,49.64},{77.76,49.67},{77.2,49.75},{76.53,49.7},{75.84,49.2},{75.17,49.24},{74.48,49.81},{73.83,49.88},{73.14,49.83},{72.47,49.73},{71.78,49.79},{71.11,50.07},{70.91,50.46},{70.77,50.73},{70.42,50.8},{69.74,50.99},{69.34,51.26},{68.76,51.1},{68.13,51.52},{67.95,52.5},{67.34,52.88},{67.43,52.85},{67.95,52.5},{68.13,51.52},{68.76,51.1},{69.34,51.26},{69.74,50.99},{70.42,50.8},{70.77,50.73},{70.91,50.46},{71.11,50.07},{71.78,49.79},{72.47,49.73},{73.14,49.83},{73.83,49.88},{74.48,49.81},{75.17,49.24},{75.84,49.2},{70.12,25.76},{70.1,25.01},{70.11,24.2},{70.1,23.64},{70.12,22.82},{70.06,22.35},{69.92,22.01},{69.77,21.57},{69.73,21.22},{69.73,20.86},{69.73,21.22},{69.77,21.57},{69.92,22.01},{70.06,22.35},{70.12,22.82},{70.1,23.64},{70.11,24.2},{70.1,25.01},{54.8,20.57},{54.79,21.15},{54.9,21.71},{55.22,22.35},{55.45,23.09},{55.5,23.63},{55.66,24.19},{55.64,24.87},{55.53,25.35},{55.01,26.17},{54.8,26.79},{54.86,27.41},{54.92,28.25},{55.07,28.86},{55.37,29.38},{55.89,29.72},{56.51,29.72},{56.67,29.49},{56.63,29.12},{56.67,28.87},{56.73,28.38},{56.83,28.17},{56.73,28.38},{56.67,28.87},{56.63,29.12},{56.67,29.49},{56.51,29.72},{55.89,29.72},{55.37,29.38},{55.07,28.86},{54.92,28.25},{54.86,27.41},{54.8,26.79},{55.01,26.17},{55.53,25.35},{55.64,24.87},{55.66,24.19},{55.5,23.63},{55.45,23.09},{55.22,22.35},{54.9,21.71},{54.79,21.15},},[38]={{0.23,55.61},{1.45,55.42},{1.23,55.48},{0.23,55.61},},[11]={{30.52,93.43},{30.48,92.53},{30.5,91.56},{30.49,90.89},{30.51,89.92},{30.44,89.37},{30.28,88.96},{30.09,88.43},{30.04,88.02},{30.04,87.59},{30.04,88.02},{30.09,88.43},{30.28,88.96},{30.44,89.37},{30.51,89.92},{30.49,90.89},{30.5,91.56},{30.48,92.53},{12.26,87.24},{12.25,87.93},{12.39,88.6},{12.76,89.36},{13.04,90.24},{13.1,90.89},{13.29,91.55},{13.27,92.36},{13.13,92.94},{12.52,93.91},{12.27,94.65},{12.34,95.39},{12.4,96.39},{12.59,97.12},{12.94,97.74},{13.56,98.14},{14.31,98.14},{14.49,97.87},{14.45,97.42},{14.49,97.13},{14.56,96.54},{14.68,96.29},{14.56,96.54},{14.49,97.13},{14.45,97.42},{14.49,97.87},{14.31,98.14},{13.56,98.14},{12.94,97.74},{12.59,97.12},{12.4,96.39},{12.34,95.39},{12.27,94.65},{12.52,93.91},{13.13,92.94},{13.27,92.36},{13.29,91.55},{13.1,90.89},{13.04,90.24},{12.76,89.36},{12.39,88.6},{12.25,87.93},},[1537]={{23.1,0.41},{23.81,3.93},{25.77,7.88},{27.21,12.51},{27.51,15.87},{28.56,19.33},{28.43,23.57},{27.69,26.57},{24.5,31.66},{23.19,35.55},{23.54,39.4},{23.9,44.61},{24.86,48.42},{26.71,51.65},{29.96,53.77},{33.86,53.78},{34.8,52.36},{34.58,50.01},{34.83,48.48},{35.19,45.4},{35.83,44.1},{35.19,45.4},{34.83,48.48},{34.58,50.01},{34.8,52.36},{33.86,53.78},{29.96,53.77},{26.71,51.65},{24.86,48.42},{23.9,44.61},{23.54,39.4},{23.19,35.55},{24.5,31.66},{27.69,26.57},{28.43,23.57},{28.56,19.33},{27.51,15.87},{27.21,12.51},{25.77,7.88},{23.81,3.93},{23.1,0.41},},},1,nil,nil,57,"A",},
[728] = {'Bhag\'thera',4572,4572,40,40,1,{[33]={{49.61,24.03},},},nil,33,nil,nil,16,nil,},
[729] = {'Sin\'Dall',1609,1609,37,37,0,{[33]={{32.21,17.39},},},nil,33,nil,nil,16,nil,},
[730] = {'Tethis',5235,5235,43,43,1,{[33]={{28.74,44.85},},},nil,33,nil,nil,48,nil,},
[731] = {'King Bangalash',5809,5809,43,43,1,{[33]={{38.21,35.58},},},nil,33,nil,nil,16,nil,},
[732] = {'Murloc Lurker',176,198,9,10,0,{[12]={{76.53,79.69},{75.85,83.67},{76.91,82.66},{76.46,81.97},{77.55,80.95},{78.48,83.99},{77.11,85.84},{77.03,84.21},{77.22,85.01},{77.75,85.92},{76.3,84.39},{78.55,82.08},{79.49,85.3},{79.96,85.48},{76.91,86.43},{81.08,86.88},{82.92,87.24},{84.79,86.63},{78.52,60.2},{79.16,56.36},{79.39,55.28},{79.76,56.82},{77.81,58.04},{78.24,57.86},{78.07,57.66},{79.66,54.98},{80.42,53.31},{77.69,56.28},{78.47,55.8},{77.7,56.87},{76.56,58.95},{79.35,46.25},{78.68,45.9},{78.71,44.51},{78.08,45.34},{78.73,45.07},{77.65,44.1},{78.27,57.48},{75.95,86.04},{88.54,84.16},{89.92,82.42},{91.64,82.32},},},{[12]={{78.08,57.64},{78.12,57.11},{78.44,56.68},{78.76,56.3},{79.09,55.76},{79.3,55.34},{79.45,55.01},{79.55,54.76},{79.83,54.74},{79.95,54.98},{79.95,55.28},{79.83,55.65},{79.66,55.76},{79.36,55.87},{79.16,56.01},{78.91,56.39},{78.77,56.72},{78.69,57.04},{78.65,57.41},{78.61,57.84},{78.57,57.97},{78.44,58.12},{78.26,58.14},{78.12,58.01},{78.73,45.07},{79.28,45.49},{78.73,45.08},{78.03,44.61},},[46]={{31.77,99.97},{31.77,99.98},{30.94,99.43},},},12,nil,nil,18,nil,},
[733] = {'Sergeant Yohwa',2471,2471,40,40,0,{[33]={{38.02,3.33},},},nil,33,{203,204,574,},{203,204,},12,"A",},
[734] = {'Corporal Bluth',2471,2471,40,40,0,{[33]={{37.96,2.99},},},nil,33,nil,nil,12,"A",},
[735] = {'Murloc Streamrunner',120,137,6,7,0,{[12]={{57.19,69.45},{53.58,63.59},{51.98,66.25},{51.45,69.45},{53.14,70.04},{58.27,67.92},{58.32,65.25},{57.72,67.37},{55.22,69.39},{57.26,63.69},{57.14,62.29},{55.5,63.25},{54.17,62.92},{53.26,63.53},{52.8,65.19},{54.18,62.73},{52.96,67.93},{51.97,64.45},{51.55,65.11},{51.98,68.67},{50.45,62.32},},},{[12]={{51.98,66.25},{51.81,66.51},{51.69,67.05},{51.79,66.43},{51.98,66.24},{52.26,66.02},{52.54,65.67},{52.51,65.17},{52.83,64.76},{53.09,64.41},{53.36,64.05},{53.53,63.82},{54.0,63.29},{54.41,62.66},{54.66,63.17},{54.84,63.73},{54.67,64.43},{54.63,65.14},{54.67,65.47},{54.7,65.92},{54.68,66.42},{54.96,66.27},{55.24,66.46},{55.49,66.67},{55.8,67.01},{56.01,67.15},{56.26,67.2},{56.77,67.02},{56.98,67.23},{57.46,67.26},{57.73,67.09},{57.97,66.6},{58.05,66.07},{57.86,65.43},{57.56,64.77},{57.2,64.38},{56.8,63.82},{56.37,63.47},{56.05,63.74},{55.73,63.61},{55.38,63.43},{54.98,63.37},{54.55,62.98},{54.12,62.83},{53.76,63.24},{53.47,63.58},{53.15,63.95},{52.92,64.54},{52.85,64.68},{52.61,65.17},{52.51,65.51},{52.41,65.75},{52.23,65.99},{52.96,67.93},{53.12,68.46},{53.4,68.7},{53.77,68.92},{54.23,68.76},{54.71,68.6},{54.83,68.69},{55.21,68.96},{55.6,69.1},{56.02,69.13},{56.4,69.14},{56.74,69.01},{57.09,68.7},{57.34,68.29},{57.58,67.84},{57.72,67.17},{58.06,66.33},{58.02,65.91},{57.86,65.52},{57.61,64.81},{57.38,64.38},{56.95,63.82},{56.57,63.56},{56.3,63.56},{56.0,63.55},{55.46,63.54},{55.08,63.51},{54.68,63.4},{53.95,63.22},{53.72,63.39},{53.46,63.62},{53.03,64.13},{52.88,64.72},{52.67,65.22},{52.55,65.52},{52.46,65.76},{52.21,65.98},{51.99,66.19},{51.77,66.05},{51.46,65.91},{51.12,65.7},{50.7,65.38},{50.57,66.15},{50.45,66.48},{50.29,66.77},{49.97,66.6},{49.71,66.46},{49.42,66.32},{49.31,66.26},{49.06,66.01},{48.87,65.81},{48.83,66.41},{48.81,67.7},{48.85,68.0},{49.19,68.2},{49.72,68.51},{50.05,68.64},{50.55,68.69},{50.98,68.9},{51.37,68.86},{51.81,68.74},{52.27,68.58},{52.53,68.35},{52.76,68.14},},[40]={{93.87,3.12},{93.7,3.39},{93.58,3.92},{93.68,3.3},{93.87,3.12},{94.15,2.9},{94.42,2.55},{94.4,2.06},{94.71,1.65},{94.97,1.3},{95.23,0.95},{95.41,0.72},{95.87,0.19},{96.53,0.07},{96.71,0.63},{96.53,1.32},{96.5,2.02},{96.53,2.35},{96.57,2.8},{96.54,3.3},{96.82,3.15},{97.1,3.34},{97.35,3.55},{97.65,3.88},{97.87,4.02},{98.11,4.07},{98.62,3.89},{98.83,4.1},{99.31,4.13},{99.57,3.96},{99.8,3.48},{99.89,2.95},{99.7,2.32},{99.4,1.66},{99.05,1.28},{98.65,0.71},{98.22,0.37},{97.9,0.64},{97.59,0.51},{97.24,0.33},{96.84,0.27},{95.63,0.14},{95.34,0.48},{95.03,0.85},{94.8,1.43},{94.73,1.57},{94.5,2.05},{94.39,2.4},{94.3,2.63},{94.11,2.87},{94.84,4.79},{95.0,5.32},{95.27,5.56},{95.65,5.78},{96.1,5.62},{96.57,5.46},{96.69,5.55},{97.07,5.82},{97.46,5.96},{97.87,5.98},{98.26,5.99},{98.59,5.87},{98.93,5.56},{99.18,5.15},{99.42,4.71},{99.56,4.04},{99.9,3.21},{99.86,2.79},{99.7,2.4},{99.45,1.7},{99.23,1.27},{98.79,0.72},{98.42,0.46},{98.15,0.46},{97.85,0.45},{97.32,0.44},{96.94,0.41},{96.54,0.31},{95.82,0.12},{95.6,0.29},{95.34,0.52},{94.91,1.03},{94.77,1.61},{94.55,2.1},{94.44,2.4},{94.34,2.64},{94.1,2.86},{93.87,3.07},{93.66,2.93},{93.36,2.79},{93.02,2.58},{92.6,2.27},{92.47,3.03},{92.35,3.36},{92.19,3.64},{91.88,3.48},{91.61,3.34},{91.33,3.19},{91.22,3.14},{90.97,2.89},{90.78,2.69},{90.75,3.29},{90.72,4.57},{90.76,4.86},{91.1,5.07},{91.63,5.37},{91.95,5.5},{92.45,5.55},{92.88,5.76},{93.26,5.72},{93.7,5.6},{94.16,5.44},{94.41,5.21},{94.64,5.0},},},12,nil,nil,18,nil,},
[736] = {'Panther',1163,1221,32,33,0,{[33]={{45.69,10.32},{45.79,10.3},{28.88,15.94},{28.36,13.43},{29.77,16.11},{28.17,16.55},{30.97,14.59},{29.99,9.78},{30.9,11.29},{28.37,10.55},{28.79,14.6},{30.47,10.67},{29.4,9.07},{28.39,12.3},{29.45,13.59},},},nil,33,nil,nil,16,nil,},
[737] = {'Kebok',2016,2016,35,35,0,{[33]={{27.0,77.13},},},nil,33,{189,209,213,},{189,209,213,},120,"AH",},
[738] = {'Private Thorsen',1110,1110,30,30,0,{[33]={{37.98,3.41},},},{[10]={{38.44,88.79},{38.51,89.76},{38.7,91.29},{38.88,92.14},{39.66,92.42},{40.37,92.76},{41.16,93.06},{41.51,95.49},{41.66,97.16},{41.72,97.19},{41.63,95.26},{41.35,93.19},{40.28,92.64},{38.91,92.21},{38.67,90.97},{38.53,89.66},{38.44,88.79},},[33]={{38.01,3.43},{38.04,3.85},{38.12,4.49},{38.19,4.85},{38.53,4.97},{38.83,5.12},{39.16,5.24},{39.31,6.27},{39.37,6.98},{39.4,6.99},{39.36,6.17},{39.24,5.29},{38.79,5.06},{38.21,4.88},{38.1,4.36},{38.05,3.8},{38.01,3.43},},[40]={{92.04,82.06},{92.09,82.82},{92.23,83.99},{92.37,84.65},{92.98,84.87},{93.53,85.13},{94.13,85.36},{94.4,87.24},{94.52,88.52},{94.56,88.55},{94.49,87.06},{94.28,85.46},{93.46,85.03},{92.39,84.71},{92.21,83.75},{92.1,82.74},{92.04,82.06},},},33,{215,},{198,},123,"A",},
[739] = {'Brother Nimetz',1747,1747,40,40,0,{[33]={{37.83,3.56},},},nil,33,{205,206,207,},{205,206,207,},12,"A",},
[740] = {'Adolescent Whelp',950,983,34,35,0,{[8]={{16.24,64.54},{15.29,66.57},{14.31,61.27},{17.25,59.81},{13.91,59.36},{11.12,62.67},{12.86,66.81},},},nil,8,nil,nil,50,nil,},
[741] = {'Dreaming Whelp',1037,1075,35,36,0,{[8]={{14.52,64.18},{12.6,58.98},{12.71,64.75},{12.57,59.3},{11.41,57.32},{16.7,56.23},},},nil,8,nil,nil,50,nil,},
[742] = {'Green Wyrmkin',4755,4953,41,42,1,{[8]={{72.44,69.51},{60.01,52.35},{66.33,64.22},{89.15,65.75},},},nil,8,nil,nil,50,nil,},
[743] = {'Wyrmkin Dreamwalker',3963,4119,42,43,1,{[8]={{60.25,57.21},{64.1,63.59},{62.04,59.96},{71.32,66.72},{60.52,53.15},{90.41,56.93},{89.67,61.51},},},nil,8,nil,nil,50,nil,},
[744] = {'Green Scalebane',4953,5148,42,43,1,{[8]={{76.59,68.8},{77.55,70.66},{60.59,39.33},{64.51,42.03},{63.69,39.22},{61.82,37.46},{62.2,41.72},{60.71,43.26},{79.73,58.76},},},nil,8,nil,nil,50,nil,},
[745] = {'Scalebane Captain',5148,5346,43,44,1,{[8]={{77.97,68.2},{77.07,65.29},{76.57,46.86},{75.57,67.0},{62.08,44.55},{59.47,40.86},{75.33,41.11},{73.53,38.84},{80.95,42.36},{82.12,40.97},{87.76,45.33},{81.27,51.83},{83.94,51.89},},},nil,8,nil,nil,50,nil,},
[746] = {'Elder Dragonkin',6468,6468,45,45,1,{[8]={{86.05,45.85},{83.01,46.0},{80.15,45.46},{87.0,44.05},{86.95,47.83},{85.4,49.79},{78.45,54.96},},},nil,8,nil,nil,50,nil,},
[747] = {'Marsh Murloc',1711,1774,41,42,0,{[8]={{82.64,94.14},{86.47,84.51},{86.88,85.02},{83.69,88.54},{86.5,87.25},{85.93,84.97},{83.56,93.7},{87.1,80.66},{84.28,85.38},},},nil,8,nil,nil,18,nil,},
[750] = {'Marsh Inkspewer',1981,2059,42,43,0,{[8]={{62.32,81.0},{95.93,58.23},{68.88,96.89},{92.71,69.28},{92.73,68.68},{88.53,81.96},{90.12,75.52},{95.53,61.15},{95.59,62.98},{90.2,80.12},{86.73,83.41},{85.6,87.2},{87.12,82.72},{85.15,88.73},{90.99,71.2},{95.36,54.73},{95.95,52.63},{95.64,49.99},{93.16,66.79},{94.14,63.31},{91.5,67.39},{91.46,69.74},{67.09,75.84},{66.25,86.21},{63.95,88.18},{64.7,87.09},{64.3,80.62},{66.01,80.95},{64.09,80.32},{64.48,81.6},{84.41,87.23},{82.95,90.54},{81.15,91.2},{82.78,93.53},{81.2,94.14},{82.78,93.81},{83.53,90.92},{85.33,82.92},{83.94,90.0},{88.47,76.39},{89.43,77.75},{82.79,89.65},{94.74,58.51},{94.35,60.0},{92.44,65.72},{94.28,49.95},{94.34,54.14},{88.19,80.18},},},nil,8,nil,nil,18,nil,},
[751] = {'Marsh Flesheater',2059,2138,43,44,0,{[8]={{62.09,81.2},{72.55,97.58},{70.98,97.59},{60.6,84.65},{95.05,51.28},{66.44,83.11},{64.73,88.96},{63.15,91.26},{63.32,88.49},{62.87,89.71},{62.0,82.56},{63.22,84.91},{62.32,81.12},{66.06,77.62},{94.41,52.52},{88.11,78.24},},},nil,8,nil,nil,18,nil,},
[752] = {'Marsh Oracle',1704,1787,44,45,0,{[8]={{63.15,80.42},{61.41,84.34},{60.9,83.58},{94.18,30.52},{95.05,51.06},{94.89,60.05},{94.86,61.0},{62.37,88.13},{61.99,87.28},{60.48,86.56},{62.76,87.05},{63.59,86.78},{89.05,78.45},},},nil,8,nil,nil,18,nil,},
[754] = {'Rebel Watchman',1312,1338,31,32,0,{[33]={{38.15,3.65},},},nil,33,nil,nil,11,"A",},
[755] = {'Lost One Mudlurker',1279,1342,34,35,0,{[8]={{50.16,34.18},{43.46,34.52},{46.05,27.6},{49.0,31.9},{51.78,33.53},{45.92,31.14},{51.72,28.83},{49.59,27.36},},},nil,8,nil,nil,51,nil,},
[756] = {'Skullsplitter Panther',1829,1902,41,42,0,nil,nil,0,nil,nil,30,nil,},
[757] = {'Lost One Fisherman',1403,1469,35,36,0,{[8]={{44.03,31.34},{50.59,32.33},{59.95,28.19},{56.58,30.73},{48.66,30.44},{43.36,38.54},{53.73,30.65},{54.81,29.97},{56.75,27.33},},},nil,8,nil,nil,51,nil,},
[759] = {'Lost One Hunter',1469,1536,36,37,0,{[8]={{64.75,23.02},{55.15,25.15},{55.13,30.32},{57.63,23.97},{55.78,29.12},{57.79,24.74},{56.81,25.23},{57.27,24.65},{62.0,23.53},{61.93,22.74},{62.62,24.07},{58.08,26.76},},},nil,8,nil,nil,51,nil,},
[760] = {'Lost One Muckdweller',1469,1536,36,37,0,{[8]={{58.41,28.46},{60.87,28.44},{56.06,31.86},{57.7,29.92},{63.45,21.88},{64.66,26.17},{62.34,26.7},{63.45,17.41},{62.25,19.42},{59.02,23.56},{61.17,25.27},{46.55,38.6},{46.43,38.56},},},nil,8,nil,nil,51,nil,},
[761] = {'Lost One Seer',1257,1305,37,38,0,{[8]={{60.41,22.43},{65.06,20.41},},},nil,8,nil,nil,51,nil,},
[762] = {'Lost One Riftseeker',1103,1107,37,38,0,{[8]={{64.18,22.65},{64.08,23.16},{61.91,20.9},{60.94,23.86},},},nil,8,nil,nil,51,nil,},
[763] = {'Lost One Chieftain',1678,1678,39,39,4,{[8]={{61.96,21.16},{60.54,22.93},{60.06,20.31},{61.59,22.78},{63.81,20.85},},},nil,8,nil,nil,51,nil,},
[764] = {'Swampwalker',1308,1351,38,39,0,{[8]={{46.88,37.1},{49.28,35.27},{51.17,36.76},{54.74,32.1},{14.92,38.73},{15.81,36.55},{16.87,38.78},{14.37,34.71},{11.43,38.66},{13.0,37.04},{15.77,40.78},},},nil,8,nil,nil,14,nil,},
[765] = {'Swampwalker Elder',1116,1155,39,40,0,{[8]={{12.92,32.51},{10.07,32.31},},},nil,8,nil,nil,14,nil,},
[766] = {'Tangled Horror',1433,1474,40,41,0,{[8]={{74.06,71.51},{78.82,71.91},{71.28,23.54},{68.05,32.09},{58.99,45.42},{73.62,31.62},{76.77,30.88},{62.75,33.74},{58.28,55.48},{60.47,36.19},{73.85,27.14},{57.96,35.95},{67.5,24.54},{57.33,50.29},{57.26,41.49},{85.06,67.28},{83.83,72.9},{11.21,30.74},{8.56,30.45},{8.43,34.34},{11.49,34.74},{10.11,36.59},{76.78,73.14},{77.54,77.62},{77.2,81.09},{72.41,73.65},},},nil,8,nil,nil,14,nil,},
[767] = {'Swamp Jaguar',1469,1536,36,37,0,{[8]={{37.48,37.62},{14.59,46.08},{33.39,35.54},{28.66,43.62},{36.89,39.88},{36.3,39.58},{26.43,47.42},{25.28,41.28},{43.54,41.24},{40.44,37.32},{39.92,31.23},{37.42,30.95},{41.03,38.82},{35.88,53.94},{23.52,38.67},{20.23,42.84},{33.16,43.18},{23.06,42.36},{34.69,30.28},{39.19,39.25},{39.86,41.0},{31.66,29.4},{26.98,39.57},{26.44,34.3},{22.42,57.9},{23.48,60.08},{33.58,54.37},{27.16,63.96},{53.79,41.56},{55.54,45.24},{56.86,43.81},{47.71,40.75},{26.33,60.73},{16.74,60.14},{12.04,59.42},{30.02,52.49},{32.03,49.96},{36.51,48.45},{37.24,45.15},{39.14,47.32},{41.9,43.38},{40.35,45.26},{43.31,45.13},{44.73,43.4},{53.2,38.43},{29.06,34.26},},},nil,8,nil,nil,14,nil,},
[768] = {'Shadow Panther',1678,1753,39,40,0,{[8]={{83.81,59.0},{69.33,11.65},{69.89,26.33},{71.02,10.48},{74.12,25.29},{65.4,67.87},{87.28,28.61},{88.65,36.33},{92.96,44.63},{87.79,31.41},{70.64,11.03},{90.65,48.95},},},nil,8,nil,nil,14,nil,},
[769] = {'Deathstrike Tarantula',1829,1902,40,41,0,{[8]={{60.62,68.9},{61.87,65.31},{60.65,62.1},{56.91,64.42},{59.4,60.17},{59.61,65.9},{58.03,62.47},{56.43,61.82},{63.73,66.4},{65.34,69.9},{55.37,62.33},{56.36,60.99},{76.9,86.67},{56.88,62.14},{76.19,88.86},{76.5,77.43},{81.09,89.13},{55.86,62.12},{65.98,69.56},{67.43,78.85},{60.94,68.66},{77.44,86.04},{80.24,83.89},{70.22,79.93},{59.27,63.56},{56.52,65.65},{69.37,67.32},{67.77,68.41},{71.32,68.79},{65.54,65.13},{62.87,67.6},{60.54,60.28},{62.09,65.48},{60.45,61.88},{75.05,82.85},{72.75,82.81},{72.81,79.92},{73.18,80.17},},},nil,8,nil,nil,22,nil,},
[770] = {'Corporal Kaleb',2471,2471,40,40,0,{[33]={{37.74,3.3},},},nil,33,{210,},{622,},12,"A",},
[771] = {'Commander Felstrom',1163,1163,32,32,4,{[10]={{18.01,37.9},{13.18,36.19},{14.79,36.54},{16.3,37.36},{18.55,35.73},{16.51,35.68},{16.77,34.32},{14.85,33.31},{14.38,32.7},{14.04,34.61},},},nil,10,nil,nil,21,nil,},
[772] = {'Stranglethorn Tigress',1536,1604,37,38,0,{[33]={{41.3,34.76},{36.19,35.67},{40.34,40.99},{46.44,26.92},{39.49,41.75},{49.26,23.21},{50.21,23.04},{49.26,20.39},{50.28,21.79},{48.16,21.6},{48.07,23.01},{48.03,27.81},{47.67,22.32},{49.27,24.51},{46.97,29.57},{47.02,27.74},{36.55,39.1},{35.62,36.22},{49.23,21.6},{45.47,25.29},{41.23,36.34},{35.49,38.01},{38.67,38.61},{39.86,37.6},{40.29,39.62},{40.73,40.21},{41.95,38.89},{42.25,38.15},{41.38,38.22},{37.15,38.86},{38.07,39.32},{36.5,36.11},{37.22,35.55},{36.03,33.95},{39.59,35.55},{41.33,39.76},{41.19,40.88},{35.15,36.96},{40.52,37.73},{39.22,34.84},{39.7,40.72},{36.16,37.17},{38.73,37.12},{38.18,36.91},{37.61,36.4},{37.63,33.03},{47.58,27.41},{45.46,26.77},{38.61,35.69},{36.59,34.82},{40.33,31.7},{39.2,41.03},},},nil,33,nil,nil,16,nil,},
[773] = {'Krazek',2016,2016,35,35,0,{[33]={{26.94,77.21},},},nil,33,{198,201,616,622,627,1116,1117,2864,},{201,210,627,1115,1116,},120,"AH",},
[775] = {'Kurzen\'s Agent',1163,1221,32,33,0,nil,nil,0,nil,nil,39,nil,},
[777] = {'Amy Davenport',919,919,20,20,0,{[44]={{29.13,47.32},},},nil,44,nil,nil,12,"A",},
[780] = {'Skullsplitter Mystic',1357,1410,39,40,0,{[33]={{46.58,38.86},{48.37,41.73},{46.94,39.71},{45.13,33.53},{44.29,39.68},{43.75,39.42},{47.58,38.83},{48.16,39.57},{46.05,32.0},{46.24,32.45},{46.22,32.0},{45.06,34.07},{45.55,31.7},{42.41,35.05},{41.91,35.96},{43.92,34.37},{43.96,35.43},{42.44,35.29},},},nil,33,nil,nil,30,nil,},
[781] = {'Skullsplitter Headhunter',2059,2138,43,44,0,{[33]={{43.59,45.56},{47.92,43.06},{47.88,43.69},{46.1,44.67},{47.58,42.9},{47.68,42.53},},},nil,33,nil,nil,30,nil,},
[782] = {'Skullsplitter Scout',1902,1981,41,42,0,{[33]={{46.25,42.61},{46.06,42.09},{44.57,43.69},{45.8,43.02},{46.01,42.63},{44.98,41.58},{44.47,41.95},{44.65,41.96},{46.88,41.85},},},nil,33,nil,nil,30,nil,},
[783] = {'Skullsplitter Berserker',2059,2138,43,44,0,{[33]={{43.22,44.34},{47.66,44.31},{48.02,44.33},{46.92,45.07},{47.85,42.96},{46.55,44.74},{44.25,44.84},{47.21,44.03},{47.48,44.32},{47.78,43.69},},},nil,33,nil,nil,30,nil,},
[784] = {'Skullsplitter Beastmaster',1902,1981,41,42,0,{[33]={{44.35,42.67},{44.49,40.9},{44.55,41.61},{45.02,41.76},},},nil,33,nil,nil,30,nil,},
[785] = {'Skeletal Warder',768,811,28,29,0,{[10]={{18.27,35.66},{17.41,35.5},{13.84,34.46},{13.46,33.39},{14.05,32.57},{16.79,28.03},{17.17,28.09},{17.3,37.39},{16.83,28.59},{16.12,31.37},{16.28,32.7},{16.8,30.12},{15.96,34.65},{13.73,36.16},{16.43,31.61},{16.05,37.28},{16.84,37.56},},},nil,10,nil,nil,21,nil,},
[786] = {'Grelin Whitebeard',166,166,5,5,0,{[1]={{25.08,75.71},},},nil,1,{182,218,282,},{182,218,234,},55,"A",},
[787] = {'Skeletal Healer',684,724,26,27,0,{[10]={{17.33,37.43},{16.9,35.0},{19.84,26.71},{16.84,28.99},{14.9,34.17},{16.28,32.15},{13.96,36.42},{13.51,36.3},{16.66,37.75},{17.01,39.19},{14.95,40.47},{15.87,41.04},{16.86,40.42},},},nil,10,nil,nil,21,nil,},
[789] = {'Kimberly Hiett',919,919,20,20,0,{[44]={{27.08,45.55},},},nil,44,nil,nil,12,"A",},
[790] = {'Karen Taylor',1042,1042,22,22,0,{[44]={{29.9,47.36},},},nil,44,nil,nil,12,"A",},
[791] = {'Lindsay Ashlock',919,919,20,20,0,{[44]={{28.77,47.33},},},nil,44,nil,nil,12,"A",},
[793] = {'Kara Adams',1240,1240,25,25,0,{[44]={{30.57,46.46},},},nil,44,nil,nil,12,"A",},
[794] = {'Matt',64,64,1,1,0,{[12]={{47.63,62.54},},},nil,12,nil,nil,12,"A",},
[795] = {'Mark',64,64,1,1,0,{[12]={{40.53,64.17},},},nil,12,nil,nil,12,"A",},
[796] = {'Joshua',64,64,1,1,0,{[12]={{40.52,64.06},},},nil,12,nil,nil,12,"A",},
[797] = {'Bo',64,64,1,1,0,{[12]={{40.5,64.23},},},{[12]={{40.32,65.02},{40.79,65.9},{40.96,65.92},{41.41,65.84},{41.56,65.66},{41.47,65.65},{41.45,65.77},{41.52,65.62},{41.51,65.77},{41.41,65.79},{41.43,65.67},{41.53,65.68},{41.42,65.68},{41.48,65.79},{41.4,65.91},{41.36,65.73},{41.4,65.64},{41.51,65.74},{41.54,65.63},{41.42,65.73},{41.32,65.86},{40.73,65.91},{40.4,65.09},{40.52,64.07},{40.46,63.74},{40.54,63.8},{40.55,63.97},{40.35,64.04},{40.31,63.84},{40.45,63.91},{40.64,63.98},{40.32,65.02},{40.79,65.9},{40.96,65.92},{41.41,65.84},{41.56,65.66},{41.47,65.65},{41.45,65.77},{41.52,65.62},{41.51,65.77},{41.41,65.79},{41.43,65.67},{41.53,65.68},{41.42,65.68},{41.48,65.79},{41.4,65.91},{41.36,65.73},{41.4,65.64},{41.51,65.74},{41.54,65.63},{41.42,65.73},{41.32,65.86},{40.73,65.91},{40.4,65.09},{40.52,64.07},{40.46,63.74},{40.54,63.8},{40.55,63.97},{40.35,64.04},{40.31,63.84},{40.45,63.91},{40.64,63.98},},[40]={{82.31,1.9},{82.77,2.78},{82.94,2.81},{83.39,2.72},{83.53,2.54},{83.44,2.53},{83.43,2.66},{83.49,2.5},{83.49,2.65},{83.39,2.68},{83.4,2.55},{83.51,2.56},{83.4,2.56},{83.45,2.67},{83.37,2.79},{83.34,2.62},{83.38,2.52},{83.49,2.62},{83.52,2.52},{83.4,2.61},{83.29,2.74},{82.71,2.79},{82.39,1.98},{82.5,0.96},{82.45,0.64},{82.52,0.7},{82.54,0.86},{82.34,0.94},{82.29,0.74},{82.43,0.81},{82.62,0.87},{82.31,1.9},{82.77,2.78},{82.94,2.81},{83.39,2.72},{83.53,2.54},{83.44,2.53},{83.43,2.66},{83.49,2.5},{83.49,2.65},{83.39,2.68},{83.4,2.55},{83.51,2.56},{83.4,2.56},{83.45,2.67},{83.37,2.79},{83.34,2.62},{83.38,2.52},{83.49,2.62},{83.52,2.52},{83.4,2.61},{83.29,2.74},{82.71,2.79},{82.39,1.98},{82.5,0.96},{82.45,0.64},{82.52,0.7},{82.54,0.86},{82.34,0.94},{82.29,0.74},{82.43,0.81},{82.62,0.87},},},12,nil,nil,12,"A",},
[798] = {'Solomon',64,64,1,1,0,{[12]={{80.94,67.29},},},nil,12,nil,nil,12,"A",},
[799] = {'Kevin',64,64,1,1,0,{[12]={{80.37,66.86},},},nil,12,nil,nil,12,"A",},
[800] = {'Kyle',64,64,1,1,0,{[12]={{81.29,67.59},},},nil,12,nil,nil,12,"A",},
[801] = {'Eric',64,64,1,1,0,{[12]={{81.28,67.91},},},nil,12,nil,nil,12,"A",},
[802] = {'Jay',64,64,1,1,0,{[12]={{81.29,67.89},},},nil,12,nil,nil,12,"A",},
[804] = {'Dana',64,64,1,1,0,{[12]={{46.08,61.87},},},nil,12,nil,nil,12,"A",},
[805] = {'Cameron',64,64,1,1,0,{[12]={{46.15,61.93},},},nil,12,nil,nil,12,"A",},
[806] = {'John',64,64,1,1,0,{[12]={{46.09,62.02},},},nil,12,nil,nil,12,"A",},
[807] = {'Lisa',64,64,1,1,0,{[12]={{46.19,62.05},},},nil,12,nil,nil,12,"A",},
[808] = {'Grik\'nir the Cold',98,98,5,5,0,{[1]={{30.48,80.15},},},nil,1,nil,nil,37,nil,},
[810] = {'Aaron',64,64,1,1,0,{[12]={{46.24,61.92},},},nil,12,nil,nil,12,"A",},
[811] = {'Jose',64,64,1,1,0,{[12]={{46.17,61.8},},},nil,12,nil,nil,12,"A",},
[812] = {'Alma Jainrose',919,919,20,20,0,{[44]={{21.69,45.77},},},nil,44,nil,nil,12,"A",},
[813] = {'Colonel Kurzen',4377,4572,39,40,1,{[33]={{49.94,3.95},},},nil,33,nil,nil,46,nil,},
[814] = {'Sergeant Malthus',1302,1302,38,38,0,{[33]={{47.27,5.66},},},nil,33,nil,nil,46,nil,},
[815] = {'Bookie Herod',992,992,35,35,0,{[33]={{45.0,8.45},{44.26,7.87},{44.66,11.01},},[10]={{53.22,99.28},},},nil,33,nil,nil,46,nil,},
[818] = {'Mai\'Zoth',6830,6830,47,47,1,{[33]={{52.93,27.6},},},nil,33,nil,nil,45,nil,},
[819] = {'Servant of Ilgalar',589,626,24,25,0,{[44]={{79.01,49.64},{78.83,49.33},{79.56,48.18},{79.06,48.41},{80.18,48.71},{80.16,48.89},{79.74,47.89},{79.56,47.82},{80.1,48.26},{79.16,47.43},{78.93,47.72},},},nil,44,nil,nil,39,nil,},
[820] = {'Scout Riell',1605,1605,30,30,0,{[40]={{56.67,47.35},},},nil,40,{214,},{214,},12,"A",},
[821] = {'Captain Danuvin',1846,1846,33,33,0,{[40]={{56.42,47.62},},},nil,40,{102,},{102,},12,"A",},
[822] = {'Young Forest Bear',195,220,8,9,0,{[12]={{60.18,79.54},{63.2,79.18},{22.43,75.77},{24.51,83.38},{25.52,90.7},{28.76,81.61},{43.4,81.24},{38.27,89.37},{36.34,89.15},{44.97,78.13},{46.32,75.83},{48.28,76.75},{47.02,79.67},{45.93,85.05},{49.22,82.79},{49.22,75.92},{53.95,75.54},{53.46,84.74},{56.89,75.92},{60.83,79.1},{63.27,77.05},{66.1,78.8},{70.64,74.9},{72.86,80.89},{75.79,67.54},{71.3,61.31},{68.86,63.86},{68.58,66.31},{62.92,65.88},{64.71,63.04},{59.11,66.91},{74.6,66.78},{77.2,76.69},{78.07,79.17},{83.55,84.72},{79.77,83.27},{81.13,77.25},{82.18,59.22},{77.93,61.68},{78.75,61.41},{86.38,78.45},{86.72,65.13},{86.61,65.16},{88.32,65.67},{86.21,63.21},{87.21,69.34},{88.86,77.54},{87.81,81.11},},},nil,12,nil,nil,44,nil,},
[823] = {'Deputy Willem',804,804,18,18,0,{[12]={{48.17,42.94},},},nil,12,{6,18,783,3903,5261,},{6,18,},12,"A",},
[824] = {'Defias Digger',328,356,15,16,0,{[40]={{43.36,74.64},{42.43,72.41},{42.27,75.56},{43.69,73.48},{42.68,78.32},{43.41,77.46},{42.15,74.43},{42.69,75.73},{43.73,76.53},{41.51,75.33},{42.8,77.1},{43.2,77.08},{41.5,76.2},{42.96,73.74},{43.64,74.22},{41.95,74.97},{41.43,74.73},{41.82,77.81},{41.23,75.69},{40.96,77.28},{42.24,77.99},{43.99,74.01},{42.77,72.12},{41.0,76.53},{42.46,74.89},{43.53,76.96},{41.5,76.76},{42.98,74.76},{42.19,76.83},{41.93,76.57},{42.93,74.23},{43.72,78.04},{43.83,77.49},{41.64,78.86},{42.46,76.86},{42.82,76.47},{41.81,75.81},{44.17,77.08},{43.0,72.42},{41.2,77.79},},[33]={{10.94,1.38},{11.34,0.91},{11.51,0.4},{11.0,0.71},{11.22,0.7},{10.29,0.22},{10.47,1.1},{9.99,0.81},{10.7,1.2},{10.02,0.4},{11.4,0.64},{10.29,0.52},{10.67,0.57},{10.52,0.42},{11.51,1.23},{11.57,0.92},{10.36,1.67},{10.82,0.58},{11.01,0.36},{10.46,0.01},{11.75,0.7},{10.13,1.09},},},nil,40,nil,nil,17,nil,},
[826] = {'Watcher Jan',2192,2192,37,37,0,{[10]={{76.99,47.13},},},nil,10,nil,nil,11,"A",},
[827] = {'Watcher Mocarski',2100,2100,36,36,0,{[10]={{73.67,50.74},},},nil,10,nil,nil,11,"A",},
[828] = {'Watcher Petras',2284,2284,38,38,0,{[10]={{77.1,46.5},},},nil,10,nil,nil,56,"A",},
[829] = {'Adlin Pridedrift',166,166,5,5,0,{[1]={{30.09,71.52},},},nil,1,nil,nil,55,"A",},
[830] = {'Sand Crawler',273,300,13,14,0,{[40]={{47.53,10.63},{47.94,10.27},{50.29,11.01},{46.09,9.58},{50.52,10.25},{50.74,11.03},{49.86,10.41},{46.68,10.63},{49.84,11.79},{46.44,10.22},{39.58,12.94},{39.62,12.34},{41.0,12.17},{40.77,11.54},{40.05,12.18},{41.08,11.17},{40.09,11.73},},},nil,40,nil,nil,7,"AH",},
[831] = {'Sea Crawler',328,356,15,16,0,{[40]={{32.56,22.01},{35.95,16.68},{31.68,22.65},{31.13,24.21},{34.94,18.47},{31.81,23.46},{36.57,16.2},{31.4,23.35},{31.61,24.13},{32.97,21.79},{32.47,21.41},{32.34,22.65},},},nil,40,nil,nil,7,"AH",},
[832] = {'Dust Devil',417,449,18,19,0,{[40]={{68.62,73.38},{63.22,51.76},{54.62,41.21},{38.22,62.28},{42.73,41.73},{34.3,67.81},{42.08,59.43},{39.87,21.22},},},nil,40,nil,nil,14,nil,},
[833] = {'Coyote Packleader',222,247,11,12,0,{[40]={{46.42,20.47},{47.47,14.81},{61.84,23.41},{62.27,41.99},{41.72,26.7},{39.74,26.53},{41.13,18.08},{41.11,26.23},{35.9,29.82},{30.5,38.19},{33.04,30.27},{36.55,36.47},{36.0,33.6},{34.97,39.11},{33.27,31.62},{32.59,40.17},{30.47,36.4},{62.06,32.45},{51.96,35.11},{60.08,36.42},{35.22,42.73},{37.27,25.11},},},nil,40,nil,nil,38,nil,},
[834] = {'Coyote',198,222,10,11,0,{[40]={{47.5,26.48},{59.63,12.28},{59.03,10.83},{56.03,22.37},{47.39,15.34},{58.42,14.68},{61.14,39.67},{59.35,30.45},{60.17,37.68},{61.55,26.32},{62.68,42.34},{58.83,28.09},{61.71,29.1},{58.76,22.45},{55.03,40.7},{41.45,34.99},{53.31,38.22},{50.74,29.17},{54.57,27.69},{46.23,31.14},{40.87,27.74},{36.42,26.04},{39.93,29.31},{39.56,20.84},{36.87,27.13},{38.19,23.8},{41.63,18.97},{41.2,26.39},{35.97,28.89},{30.81,39.28},{53.32,22.48},{43.39,29.15},{41.87,31.98},{62.68,36.39},{59.79,15.27},{56.98,18.22},{58.02,16.66},{35.36,42.15},{56.24,26.76},{55.37,30.17},{50.52,45.08},{51.29,46.14},{55.09,29.49},{61.85,20.76},},},nil,40,nil,nil,38,nil,},
[836] = {'Durnan Furcutter',166,166,5,5,0,{[1]={{28.77,66.37},},},nil,1,{3365,},{3364,},55,"A",},
[837] = {'Branstock Khalder',166,166,5,5,0,{[1]={{28.6,66.39},},},nil,1,{5626,},{3110,},55,"A",},
[840] = {'Watcher Backus',3712,3712,42,42,0,{[10]={{72.56,33.55},},},{[10]={{72.44,34.12},{73.35,32.51},{73.23,32.67},{72.26,34.97},{72.18,37.22},{72.56,38.36},{73.84,39.56},{74.25,40.44},{74.53,41.33},{74.81,44.29},{74.63,41.75},{74.1,39.95},{73.68,39.43},{72.51,38.31},{72.22,37.31},{71.96,35.71},{72.03,35.67},{71.89,35.7},{72.44,34.12},{73.35,32.51},{73.23,32.67},{72.26,34.97},{72.18,37.22},{72.56,38.36},{73.84,39.56},{74.25,40.44},{74.53,41.33},{74.81,44.29},{74.63,41.75},{74.1,39.95},{73.68,39.43},{72.51,38.31},{72.22,37.31},{71.96,35.71},{72.03,35.67},{71.89,35.7},},[41]={{11.57,27.85},{12.56,26.11},{12.43,26.28},{11.37,28.77},{11.29,31.2},{11.7,32.43},{13.08,33.73},{13.53,34.68},{13.83,35.64},{14.13,38.83},{13.94,36.09},{13.37,34.15},{12.9,33.58},{11.65,32.37},{11.33,31.29},{11.05,29.56},{11.12,29.53},{10.98,29.55},{11.57,27.85},{12.56,26.11},{12.43,26.28},{11.37,28.77},{11.29,31.2},{11.7,32.43},{13.08,33.73},{13.53,34.68},{13.83,35.64},{14.13,38.83},{13.94,36.09},{13.37,34.15},{12.9,33.58},{11.65,32.37},{11.33,31.29},{11.05,29.56},{11.12,29.53},{10.98,29.55},},},10,{1244,1245,},{1243,1244,},56,"A",},
[842] = {'Lumberjack',166,166,5,5,0,{[40]={{52.45,51.95},{53.58,53.37},{54.54,52.47},{53.5,50.78},},},{[40]={{52.45,51.95},{52.46,52.06},{52.69,52.52},{53.05,53.0},{53.2,53.31},{53.25,53.61},{53.38,53.7},{53.58,53.54},{53.71,53.65},{53.96,54.01},{54.07,54.0},{54.13,53.88},{54.18,53.74},{54.24,53.6},{54.18,53.74},{54.12,53.88},{53.97,54.01},{53.84,53.88},{53.62,53.54},{53.53,53.58},{53.37,53.7},{53.27,53.64},{53.22,53.5},{53.2,53.28},{52.98,52.87},{52.68,52.51},{52.41,52.13},{52.45,51.95},{54.05,52.64},{53.63,52.8},{53.28,52.71},{53.14,52.49},{53.03,51.32},{53.14,52.11},{53.22,52.49},{53.64,52.77},{54.1,52.62},{54.57,52.44},{54.74,52.46},{54.8,52.56},{54.79,52.72},{54.65,53.0},{54.6,53.09},{54.56,53.33},{54.55,53.19},{54.6,53.07},{54.64,52.99},{54.79,52.72},{54.81,52.57},{54.76,52.48},{54.71,52.44},{54.56,52.46},{53.5,50.78},{53.6,50.67},{53.7,50.72},{54.25,51.39},{54.61,51.91},{54.81,52.42},{54.82,52.66},{54.76,52.87},{54.69,53.03},{54.64,53.13},{54.58,53.33},{54.64,53.13},{54.68,53.01},{54.82,52.64},{54.74,52.17},{54.58,51.86},{54.21,51.33},{53.67,50.67},{53.58,50.67},{53.52,50.7},},},40,nil,nil,12,"A",},
[843] = {'Gina MacGregor',644,644,15,15,0,{[40]={{57.64,54.05},},},nil,40,nil,nil,12,"A",},
[844] = {'Antonio Perelli',2016,2016,35,35,0,{[12]={{78.12,72.96},},},{[12]={{75.43,72.31},{73.05,72.7},{70.32,70.94},{69.33,71.31},{66.65,74.11},{63.98,73.72},{61.62,72.76},{58.03,71.46},{54.25,72.77},{50.24,71.5},{48.12,69.92},{45.09,68.97},{42.59,67.23},{78.12,72.96},{77.74,72.69},{76.81,72.41},{75.5,72.34},{74.77,72.44},{74.61,72.46},{74.33,72.5},{73.94,72.56},{73.21,72.66},{72.63,72.64},{72.1,72.3},{70.94,71.1},{69.88,70.89},{69.14,71.28},{68.01,72.79},{67.15,73.8},{66.81,73.93},{65.6,74.1},{65.12,74.06},{63.69,73.6},{63.16,73.35},{62.73,72.97},{62.21,72.7},{61.09,72.63},{60.01,72.41},{59.05,71.71},{58.39,71.29},{57.81,71.31},{56.61,72.18},{55.87,72.48},{54.33,72.64},{53.02,72.56},{52.59,72.43},{51.94,72.21},{50.98,71.78},{50.3,71.46},{48.93,70.57},{48.27,69.84},{47.69,69.6},{46.31,69.48},{45.29,69.12},{44.01,68.14},{42.97,67.43},{42.58,66.99},{42.42,66.47},{42.48,65.84},{42.71,65.63},{43.19,65.71},{43.18,66.0},{43.36,66.01},{43.5,66.02},{43.68,66.06},{43.79,65.97},{43.7,66.07},{43.55,66.03},{43.37,66.01},{43.2,66.04},{43.19,65.71},{42.77,65.62},{42.5,65.74},{42.25,66.75},{41.94,66.87},{40.88,66.63},{39.68,66.63},{38.97,66.76},{38.11,67.54},{37.45,68.45},{37.11,69.26},{37.02,71.75},{36.86,73.91},{36.44,74.95},{35.87,75.82},{34.98,76.79},{33.95,77.64},{32.61,78.34},{31.53,78.51},{30.28,78.19},{29.42,78.02},{28.71,77.92},{28.26,77.85},{26.85,77.76},{25.17,78.48},{24.65,78.63},{23.84,78.52},{23.27,78.31},{22.46,78.39},{21.4,79.01},{20.79,79.7},{20.15,80.52},{19.39,81.49},{18.68,82.1},{18.14,82.5},{17.45,83.42},{17.01,83.53},{16.49,83.57},{15.9,84.28},{15.81,84.8},{15.8,85.39},{15.5,86.54},{15.35,86.87},{15.29,87.56},{15.45,88.33},{15.82,89.55},{15.96,90.4},{15.67,91.11},{15.31,91.86},{15.19,92.38},{15.31,92.97},{15.51,93.45},{15.71,93.99},{15.72,95.02},{15.82,96.5},{15.82,97.37},{15.6,98.47},{15.6,99.8},{77.52,99.45},{77.47,98.71},{77.27,97.56},{77.32,96.27},{77.62,95.29},{78.09,94.6},{78.57,94.38},{79.24,93.76},{80.73,92.85},{81.35,92.69},{82.17,92.59},{83.72,92.32},{84.34,92.6},{85.09,92.65},{86.6,92.57},{87.11,92.22},{87.64,91.86},{88.4,90.82},{88.85,89.99},{89.81,89.23},{90.89,88.37},{92.28,86.92},{93.11,85.81},{93.53,84.57},{93.96,83.37},{94.73,82.63},{95.58,81.53},{96.17,79.96},{96.99,78.46},{97.83,77.57},{98.38,76.9},{98.74,75.89},{98.97,74.37},{99.18,72.77},{99.91,71.58},{99.32,71.03},{97.71,71.91},{96.99,72.36},{95.96,72.46},{94.88,72.26},{94.42,72.21},{93.51,72.14},{92.08,72.68},{91.25,73.5},{90.77,73.72},{89.65,73.68},{88.87,73.74},{87.58,73.92},{86.86,74.06},{85.73,73.89},{84.64,74.29},{83.64,74.46},{82.64,74.25},{81.64,73.88},{80.77,73.85},{79.74,73.95},{79.13,73.88},{78.69,73.58},},[40]={{99.87,8.3},{96.12,9.59},{92.15,8.34},{90.04,6.77},{87.04,5.83},{84.55,4.1},{99.65,8.14},{98.46,9.01},{97.72,9.31},{96.2,9.46},{94.9,9.39},{94.47,9.26},{93.83,9.04},{92.87,8.61},{92.2,8.3},{90.85,7.41},{90.19,6.69},{89.61,6.45},{88.25,6.33},{87.24,5.97},{85.96,5.0},{84.93,4.3},{84.54,3.87},{84.39,3.35},{84.45,2.72},{84.67,2.51},{85.15,2.59},{85.14,2.88},{85.32,2.89},{85.46,2.9},{85.64,2.94},{85.75,2.85},{85.65,2.95},{85.51,2.91},{85.33,2.89},{85.16,2.92},{85.16,2.59},{84.74,2.51},{84.46,2.63},{84.22,3.62},{83.91,3.74},{82.87,3.51},{81.67,3.5},{80.97,3.63},{80.12,4.41},{79.46,5.31},{79.13,6.11},{79.03,8.58},{78.87,10.73},{78.46,11.76},{77.89,12.62},{77.01,13.58},{75.99,14.42},{74.66,15.12},{73.59,15.29},{72.35,14.97},{71.5,14.81},{70.79,14.71},{70.34,14.63},{68.95,14.54},{67.28,15.26},{66.77,15.41},{65.96,15.3},{65.4,15.09},{64.6,15.17},{63.54,15.79},{62.93,16.47},{62.31,17.29},{61.55,18.25},{60.85,18.85},{60.31,19.24},{59.63,20.16},{59.19,20.27},{58.67,20.31},{58.09,21.01},{58.0,21.53},{57.99,22.11},{57.69,23.25},{57.54,23.59},{57.49,24.27},{57.64,25.03},{58.01,26.25},{58.15,27.09},{57.86,27.79},{57.5,28.53},{57.39,29.05},{57.5,29.64},{57.7,30.11},{57.9,30.64},{57.91,31.66},{58.01,33.13},{58.01,34.0},{57.79,35.09},{57.8,36.41},{57.94,36.9},{58.39,37.48},{58.64,38.0},{58.54,38.94},{58.23,39.93},{58.16,41.85},{57.81,42.94},{57.82,43.5},{58.09,44.22},{58.94,45.95},{58.92,47.55},{58.51,49.25},{58.19,50.24},{57.54,52.37},{57.43,53.04},{57.61,53.65},{57.59,53.85},{57.33,53.96},{56.86,54.04},{56.51,53.74},{55.75,52.9},{55.0,52.79},{54.68,52.43},{53.49,52.87},{53.08,53.22},{53.0,53.36},{52.9,53.53},{53.0,53.36},{53.05,53.27},{53.51,52.87},{54.63,52.44},{55.02,52.81},{55.72,52.92},{56.74,54.04},{56.61,56.06},{56.93,57.3},{57.12,57.96},{57.13,60.31},{57.37,61.3},{57.45,62.73},{57.49,63.67},{57.67,64.41},{57.81,65.1},{58.46,65.98},{59.1,66.36},{59.43,66.37},{59.78,65.9},{60.29,64.99},{60.81,64.84},{61.43,65.04},{61.89,65.42},{62.45,65.51},{62.92,65.37},{63.51,64.91},{64.27,63.96},{64.87,63.37},{67.08,62.85},{68.23,62.79},{69.3,62.76},{70.43,62.4},{71.89,61.74},{73.02,61.15},{74.45,60.82},{75.92,60.65},{77.07,60.55},{77.79,60.27},{78.81,60.05},{80.2,59.58},{80.75,59.27},{81.44,58.79},{82.25,58.14},{82.69,58.01},{83.64,58.01},{84.06,58.08},{84.98,58.55},{86.1,59.26},{87.05,59.66},{88.14,60.15},{89.51,60.92},{89.94,61.12},{90.48,61.39},{90.84,61.55},{91.4,61.78},{92.35,62.14},{93.36,62.42},{94.22,62.74},{95.01,63.19},{95.65,63.6},{95.95,63.78},{96.78,64.41},{97.77,64.47},{98.54,64.5},{99.33,64.7},},[10]={{18.96,0.01},{17.64,1.1},{15.92,2.01},{14.52,2.22},{12.92,1.81},{11.82,1.6},{10.9,1.47},{10.32,1.38},{8.51,1.26},{6.35,2.19},{5.69,2.39},{4.64,2.24},{3.91,1.97},{2.87,2.07},{1.5,2.87},{0.72,3.76},{0.1,67.32},{0.7,67.15},{1.47,66.55},{2.45,65.32},{3.22,64.55},{6.09,63.88},{7.58,63.81},{8.97,63.76},{10.43,63.3},{12.32,62.45},{13.79,61.68},{15.64,61.25},{17.55,61.03},{19.04,60.9},{19.98,60.54},{21.29,60.25},{23.1,59.64},{23.81,59.24},{24.7,58.62},{25.76,57.77},{26.33,57.6},{27.56,57.61},{28.1,57.7},{29.29,58.3},{30.75,59.22},{31.98,59.75},{33.39,60.38},{35.16,61.37},{35.72,61.64},{36.43,61.99},{36.89,62.19},{37.62,62.5},{38.85,62.96},{40.15,63.32},{41.27,63.74},{42.29,64.32},{43.13,64.85},{43.51,65.08},{44.59,65.91},{45.87,65.99},{46.87,66.02},{47.89,66.27},{49.46,66.36},{50.21,66.52},{51.13,66.86},{52.03,67.5},{52.94,68.52},{54.01,69.03},{54.86,68.91},{56.01,67.74},{57.31,66.63},{58.29,65.66},{59.96,63.2},{61.06,62.14},{62.06,61.41},{63.19,60.73},{64.71,60.07},{65.64,60.09},{66.72,60.6},{67.66,60.61},{68.99,60.53},{69.8,60.18},{70.58,59.57},{72.18,59.1},{73.05,58.21},{74.0,56.41},{74.79,54.36},{75.06,53.01},{75.03,51.89},{74.6,49.24},{74.48,48.2},{74.16,47.64},{73.79,47.01},{73.83,46.12},{73.82,45.56},{74.1,45.46},{74.02,45.14},{74.01,44.87},{73.98,44.5},{73.99,44.74},{74.02,45.13},{74.1,45.47},{73.81,45.53},{73.84,46.2},{74.46,46.71},{74.87,46.43},{74.81,44.55},{74.62,41.72},{74.16,40.05},{73.72,39.47},{72.85,38.8},{72.45,38.11},{72.22,37.3},{72.2,35.42},{72.52,33.95},{73.29,32.47},{73.6,31.21},{73.65,29.15},{73.58,28.21},{73.33,26.72},{73.39,25.07},{73.78,23.81},{74.39,22.91},{74.99,22.64},{75.87,21.84},{77.77,20.66},{78.57,20.46},{79.63,20.34},{81.62,19.99},{82.41,20.35},{83.38,20.41},{85.32,20.31},{85.97,19.86},{86.66,19.39},{87.64,18.05},{88.22,16.99},{89.45,16.02},{90.83,14.91},{92.62,13.04},{93.69,11.62},{94.23,10.02},{94.78,8.47},{95.77,7.52},{96.87,6.12},{97.62,4.09},{98.68,2.16},{99.75,1.02},},[41]={{0.36,57.33},{1.58,56.59},{3.22,55.88},{4.23,55.89},{5.39,56.44},{6.41,56.46},{7.84,56.37},{8.72,55.99},{9.56,55.34},{11.29,54.82},{12.23,53.87},{13.26,51.92},{14.1,49.71},{14.4,48.25},{14.36,47.04},{13.9,44.18},{13.77,43.05},{13.42,42.45},{13.03,41.77},{13.07,40.81},{13.06,40.2},{13.36,40.09},{13.27,39.75},{13.26,39.46},{13.23,39.06},{13.24,39.32},{13.27,39.74},{13.36,40.11},{13.05,40.17},{13.08,40.89},{13.76,41.45},{14.19,41.14},{14.13,39.12},{13.93,36.06},{13.43,34.25},{12.95,33.63},{12.01,32.9},{11.58,32.16},{11.34,31.29},{11.31,29.25},{11.65,27.66},{12.48,26.07},{12.82,24.71},{12.87,22.48},{12.8,21.46},{12.53,19.86},{12.6,18.07},{13.02,16.71},{13.67,15.75},{14.33,15.45},{15.27,14.59},{17.33,13.32},{18.19,13.1},{19.33,12.96},{21.48,12.59},{22.34,12.97},{23.39,13.04},{25.47,12.93},{26.18,12.45},{26.93,11.94},{27.98,10.5},{28.61,9.35},{29.93,8.3},{31.43,7.1},{33.36,5.08},{34.52,3.55},{35.1,1.82},{35.69,0.15},},[44]={{0.5,98.76},{2.22,97.38},{4.45,95.06},{5.78,93.29},{6.45,91.31},{7.13,89.38},{8.36,88.2},{9.73,86.45},{10.67,83.94},{11.99,81.53},{13.32,80.11},{14.2,79.05},{14.78,77.43},{15.14,75.0},{15.49,72.45},{16.65,70.55},{17.81,69.21},{18.9,69.37},{20.14,70.12},{22.41,69.9},{22.77,70.33},{23.12,72.11},{23.71,72.86},{24.48,72.39},{26.19,69.78},{27.21,68.91},{28.69,68.02},{29.19,67.58},{29.73,67.01},{31.14,64.97},{31.7,63.55},{32.38,59.53},{32.45,57.32},{32.59,54.72},{32.71,51.66},{32.8,49.44},{32.6,48.38},{31.44,48.11},{30.97,48.1},{29.37,48.02},{29.12,47.63},{28.58,47.62},{27.8,46.98},{26.83,46.97},{26.62,46.42},{26.62,45.8},{27.0,45.75},{26.93,45.34},{26.92,44.99},{26.91,44.55},{26.85,44.27},{26.91,44.53},{26.92,44.92},{26.92,45.32},{26.99,45.74},{26.62,45.8},{26.61,46.56},{27.01,47.15},{27.97,47.21},{28.58,47.64},{30.92,48.13},{31.96,48.21},{32.57,48.32},{32.84,49.4},{32.71,51.66},{32.56,54.49},{32.41,57.24},{32.24,59.48},{31.85,62.22},{31.13,64.68},{29.52,67.02},{29.23,67.33},{28.75,67.73},{26.65,69.11},{25.76,70.19},{24.21,72.49},{23.73,72.59},{23.39,72.21},{22.85,70.28},{22.39,69.73},{20.17,69.91},{18.57,69.12},{17.65,69.09},{15.7,69.67},{13.14,71.06},{11.98,71.79},{10.34,71.95},{8.61,71.62},{7.88,71.55},{6.42,71.43},{4.13,72.29},{2.8,73.62},{2.04,73.97},{0.24,73.9},},},12,nil,nil,12,"A",},
[846] = {'Ghoul',300,328,14,15,0,{[40]={{40.47,68.07},{40.37,66.81},{40.18,67.56},{39.82,68.15},{39.74,66.96},},},nil,40,nil,nil,21,nil,},
[847] = {'Nathan',166,166,5,5,0,{[44]={{29.19,47.47},},},nil,44,nil,nil,35,"AH",},
[848] = {'Madison',166,166,5,5,0,{[44]={{29.08,51.98},},},{[44]={{21.86,46.52},{20.84,46.51},{21.8,46.48},{22.41,45.89},{23.69,46.19},{24.58,46.3},{25.15,46.53},{25.82,47.49},{26.1,47.81},{27.68,48.78},{29.27,49.23},{29.43,49.62},{29.37,51.12},{29.08,51.98},{22.91,45.93},{23.84,45.99},{24.38,46.31},{25.34,46.46},{26.48,46.93},{28.31,46.99},{28.7,48.06},{29.52,48.43},{29.59,49.66},{29.43,51.24},{29.08,51.98},},},44,nil,nil,35,"AH",},
[849] = {'Rachel',112,112,3,3,0,{[44]={{29.19,47.47},},},{[44]={{25.6,46.56},{25.91,47.61},{26.8,48.01},{27.84,48.74},{29.14,49.16},{29.4,49.61},{29.49,51.87},{29.28,52.98},{28.27,52.38},{28.21,53.17},{29.39,53.04},{29.59,51.19},{29.57,48.87},{29.19,47.47},{26.06,43.81},{26.05,42.52},{26.43,42.12},{28.19,41.68},{28.96,42.62},{28.05,43.03},{27.83,43.69},{27.85,45.87},{28.38,46.48},{28.54,47.5},},},44,nil,nil,35,"AH",},
[850] = {'Erin',166,166,5,5,0,{[44]={{24.82,41.39},},},{[44]={{24.82,41.39},{24.32,42.65},{23.94,43.73},{23.9,44.61},{23.71,45.58},{24.2,46.1},{25.4,46.6},{26.21,47.04},{26.58,46.92},{26.63,45.85},{26.8,45.76},{26.93,44.47},{26.77,44.3},{26.57,44.29},{26.57,44.29},{26.9,44.44},{26.92,45.37},{27.04,45.72},{26.66,45.78},{26.61,46.53},{26.15,47.06},{25.37,46.69},{24.95,46.84},{24.7,47.38},{25.0,46.74},{25.65,46.37},{26.03,46.52},{26.6,46.92},{27.09,48.08},{27.04,48.55},{26.61,50.76},{26.75,50.11},{27.05,48.57},{27.02,47.41},{26.21,46.79},{25.3,46.25},{24.17,46.07},{23.7,45.49},{23.92,44.53},{23.93,43.66},{24.02,43.08},{24.82,41.39},},},44,nil,nil,12,"A",},
[851] = {'Hannah',166,166,5,5,0,{[44]={{21.36,45.85},},},nil,44,nil,nil,12,"A",},
[852] = {'Feral Spirit',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[853] = {'Coldridge Mountaineer',5121,5121,55,55,0,{[1]={{34.01,71.54},{34.14,71.66},{34.2,71.78},{33.89,71.53},{34.04,72.11},{31.84,72.7},{29.82,71.15},{30.06,71.31},{29.57,71.6},{28.95,70.23},{29.72,71.94},{28.6,69.85},{29.03,68.16},{28.65,67.29},{28.53,68.1},{29.18,70.04},{71.03,37.97},},},{[1]={{30.1,72.0},{30.13,72.16},{30.18,72.32},{30.31,72.43},{30.48,72.41},{30.77,72.39},{31.1,72.38},{31.43,72.48},{31.65,72.55},{31.95,72.64},{32.21,72.69},{32.45,72.74},{32.7,72.72},{32.92,72.47},{33.1,72.26},{33.28,72.02},{33.1,72.26},{32.92,72.47},{32.7,72.72},{32.45,72.74},{32.21,72.69},{31.95,72.64},{31.65,72.55},{31.43,72.48},{31.1,72.38},{30.77,72.39},{30.48,72.41},{30.31,72.43},{30.18,72.32},{30.13,72.16},{30.1,72.0},{29.54,71.51},{29.44,71.47},{29.31,71.4},{29.2,71.36},{29.06,71.27},{28.97,70.98},{28.93,70.74},{28.89,70.49},{28.85,70.21},{28.89,70.49},{28.93,70.74},{28.97,70.98},{29.06,71.27},{29.2,71.36},{29.31,71.4},{29.44,71.47},{29.54,71.51},{29.51,72.1},{29.63,72.01},{29.82,71.9},{29.63,72.01},{29.15,67.75},{29.12,67.39},{28.94,67.12},{28.79,66.99},{28.78,66.74},{28.8,67.0},{28.64,67.13},{28.48,67.39},{28.48,67.72},{28.52,68.09},{29.12,70.02},{29.04,70.01},{28.92,69.95},{28.79,69.78},{28.78,69.35},{28.78,69.05},{28.77,68.73},{28.77,68.63},{28.97,68.57},{28.99,68.29},{29.02,68.01},{29.04,67.75},{28.98,67.46},{28.83,67.31},{28.62,67.49},{28.55,67.75},{28.57,67.96},{28.59,68.18},{28.61,68.43},{28.79,68.64},{28.79,68.9},{28.8,69.32},{28.8,69.74},{28.94,69.97},{29.12,70.02},},},1,nil,nil,57,"A",},
[854] = {'Young Jungle Stalker',1469,1536,36,37,0,{[33]={{31.99,42.48},{31.31,44.65},{32.1,43.14},{30.72,43.97},},},nil,33,nil,nil,48,nil,},
[855] = {'Young Stranglethorn Raptor',1051,1107,30,31,0,{[33]={{24.16,16.26},{24.01,15.73},{24.75,16.04},},},nil,33,nil,nil,48,nil,},
[856] = {'Young Lashtail Raptor',1221,1279,33,34,0,{[33]={{30.58,23.48},},},nil,33,nil,nil,48,nil,},
[857] = {'Donal Osgood',7776,7776,61,61,1,{[1537]={{69.92,88.95},},},nil,1537,nil,nil,1577,"A",},
[858] = {'Sorrow Spinner',1469,1536,36,37,0,{[8]={{25.97,49.55},{47.77,33.77},{27.67,43.37},{36.55,30.86},{43.24,29.04},{28.34,62.04},{39.5,30.81},{40.84,29.78},{37.14,28.61},{33.21,28.93},{37.47,32.08},{71.44,29.97},{31.6,50.54},{34.48,55.15},{22.54,37.72},{38.84,37.48},{26.75,48.64},{26.45,45.89},{29.34,53.26},{22.31,58.98},{19.79,52.86},{22.67,62.2},{24.86,64.01},{25.38,59.33},{26.13,61.95},{17.62,53.42},{21.26,42.52},},},nil,8,nil,nil,22,nil,},
[859] = {'Guard Berton',2434,2434,33,33,0,{[44]={{26.26,46.58},},},nil,44,{386,},{386,},11,"A",},
[861] = {'Stonard Scout',1456,1463,36,37,0,{[8]={{17.33,50.42},{38.14,56.41},{20.53,50.33},{35.06,58.85},{14.84,52.22},},},{[8]={{17.33,50.42},{16.89,50.57},{16.72,50.73},{16.94,50.31},{16.95,50.46},{37.13,56.21},{35.83,57.28},{35.59,58.42},{35.86,59.29},{35.83,61.98},{35.86,59.29},{35.59,58.42},{35.83,57.28},{37.13,56.21},{38.14,56.41},{39.2,56.19},{38.14,56.41},{20.53,50.33},{23.61,54.56},{24.99,55.57},{26.72,57.2},{28.49,57.55},{29.51,58.45},{30.4,58.71},{31.52,58.13},{32.16,58.04},{35.1,59.51},{32.16,58.04},{31.52,58.13},{30.4,58.71},{29.51,58.45},{28.49,57.55},{26.72,57.2},{24.99,55.57},{23.61,54.56},{20.53,50.33},{18.88,49.98},{34.03,58.77},{31.85,57.74},{30.24,58.53},{28.37,57.17},{26.7,56.89},{25.3,55.52},{23.51,54.7},{22.39,52.39},{21.38,51.15},{20.99,50.1},{20.99,50.1},{19.92,49.59},{20.99,50.1},{20.99,50.1},{21.38,51.15},{22.39,52.39},{23.51,54.7},{25.3,55.52},{26.7,56.89},{28.37,57.17},{30.24,58.53},{31.85,57.74},{34.03,58.77},{35.06,58.85},{14.84,52.22},{13.39,52.54},{10.62,50.23},{9.03,49.99},{10.62,50.23},{13.39,52.54},{14.84,52.22},{16.07,50.04},{17.39,49.76},{18.27,50.16},{17.39,49.76},{16.07,50.04},},[41]={{71.49,31.51},{71.08,31.65},{70.92,31.8},{71.13,31.41},{71.14,31.54},{89.65,36.82},{88.46,37.81},{88.23,38.85},{88.48,39.65},{88.45,42.12},{88.48,39.65},{88.23,38.85},{88.46,37.81},{89.65,36.82},{90.58,37.0},{91.55,36.81},{90.58,37.0},{74.42,31.43},{77.24,35.31},{78.51,36.24},{80.1,37.73},{81.72,38.05},{82.65,38.88},{83.47,39.12},{84.5,38.58},{85.09,38.5},{87.79,39.85},{85.09,38.5},{84.5,38.58},{83.47,39.12},{82.65,38.88},{81.72,38.05},{80.1,37.73},{78.51,36.24},{77.24,35.31},{74.42,31.43},{72.91,31.11},{86.8,39.18},{84.81,38.23},{83.33,38.95},{81.61,37.71},{80.08,37.45},{78.8,36.19},{77.15,35.44},{76.12,33.32},{75.2,32.18},{74.84,31.22},{74.84,31.22},{73.86,30.75},{74.84,31.22},{74.84,31.22},{75.2,32.18},{76.12,33.32},{77.15,35.44},{78.8,36.19},{80.08,37.45},{81.61,37.71},{83.33,38.95},{84.81,38.23},{86.8,39.18},{87.75,39.25},{69.2,33.16},{67.87,33.45},{65.33,31.33},{63.86,31.12},{65.33,31.33},{67.87,33.45},{69.2,33.16},{70.32,31.17},{71.54,30.91},{72.35,31.27},{71.54,30.91},{70.32,31.17},},[4]={{53.82,0.09},},},8,nil,nil,29,"H",},
[862] = {'Stonard Explorer',1476,1601,37,38,0,{[8]={{79.95,74.42},{76.59,8.92},{60.22,56.12},{55.48,24.82},{50.99,30.37},{67.43,14.84},},},{[4]={{83.45,8.94},{83.82,9.7},{84.41,10.59},{83.95,9.87},{83.45,9.33},{84.02,8.62},{84.33,7.51},{84.55,6.53},{84.98,5.69},{85.38,4.74},{85.65,3.08},{86.07,2.29},{86.25,1.36},{86.33,0.95},{86.68,0.1},{86.71,0.1},{86.36,1.02},{85.97,2.23},{85.66,3.11},{85.4,4.43},{85.19,5.21},{84.95,5.98},{84.82,7.04},{84.63,7.42},{84.06,8.56},},[8]={{79.1,74.91},{79.64,76.01},{80.5,77.32},{79.82,76.27},{79.09,75.48},{79.94,74.44},{80.38,72.83},{80.7,71.39},{81.33,70.17},{81.92,68.78},{82.31,66.35},{82.93,65.2},{83.19,63.84},{83.31,63.24},{83.82,61.99},{84.48,61.22},{84.67,59.94},{84.96,58.62},{85.71,57.49},{86.4,56.4},{86.6,56.02},{87.0,55.12},{87.51,54.0},{87.33,54.41},{86.97,55.19},{86.4,56.5},{85.78,57.38},{85.04,58.57},{84.88,59.49},{84.55,61.2},{83.85,61.99},{83.35,63.34},{82.78,65.11},{82.32,66.39},{81.95,68.33},{81.65,69.47},{81.29,70.59},{81.11,72.14},{80.83,72.68},{79.99,74.35},{76.65,8.93},{78.44,9.79},{79.07,12.13},{80.42,14.03},{81.27,14.08},{81.59,15.4},{82.4,16.58},{83.23,17.89},{83.35,18.68},{82.88,19.29},{83.26,20.32},{86.13,24.79},{85.1,27.4},{86.39,29.93},{86.13,31.61},{89.24,34.43},{90.01,36.45},{89.92,38.37},{91.1,42.71},{92.16,44.33},{91.31,47.25},{92.12,48.44},{91.11,50.58},{75.21,7.51},{91.11,50.58},{92.12,48.44},{91.31,47.25},{92.16,44.33},{91.1,42.71},{89.92,38.37},{90.01,36.45},{89.24,34.43},{86.13,31.61},{86.39,29.93},{85.1,27.4},{86.13,24.79},{83.26,20.32},{82.88,19.29},{83.35,18.68},{83.23,17.89},{82.4,16.58},{81.59,15.4},{81.27,14.08},{80.42,14.03},{79.07,12.13},{78.44,9.79},{55.48,24.82},{55.69,25.08},{56.43,25.06},{56.71,25.17},{57.0,25.19},{57.27,25.06},{57.33,24.82},{54.37,30.15},{54.27,29.24},{54.98,27.81},{55.23,26.82},{55.18,25.91},{55.61,24.99},},[44]={{88.66,98.44},{88.89,98.72},{89.67,98.7},{89.96,98.81},{90.27,98.83},{90.56,98.69},{90.62,98.44},{88.35,99.59},{88.8,98.62},},},8,nil,nil,125,"H",},
[863] = {'Stonard Hunter',4108,4108,55,55,0,{[8]={{82.19,81.04},{80.88,80.2},{81.68,79.6},{81.02,81.08},{82.47,79.89},},},nil,8,nil,nil,125,"H",},
[864] = {'Stonard Orc',3294,3294,48,48,0,{[8]={{44.42,54.9},{48.35,57.72},{43.04,53.41},},},{[8]={{44.42,54.9},{44.37,54.75},{44.2,54.94},{44.23,55.13},{44.32,55.27},{44.42,55.32},{44.42,55.42},{43.24,55.11},{43.05,55.53},{42.97,55.71},{42.98,55.64},{43.18,55.56},{43.55,54.98},{44.32,54.65},{48.35,57.72},{48.32,57.51},{49.3,55.58},{49.32,53.99},{48.73,53.36},{47.24,53.09},{47.16,52.46},{46.44,52.01},{46.42,51.42},{46.91,51.44},{47.3,51.44},{46.92,51.39},{46.84,51.52},{46.7,51.37},{46.46,51.4},{46.51,52.03},{46.57,52.44},{46.49,52.69},{46.38,52.79},{46.56,53.01},{46.29,53.86},{46.45,54.2},{46.41,54.48},{46.47,54.71},{46.55,55.06},{46.72,54.9},{46.7,54.78},{46.73,54.82},{46.69,54.96},{46.55,55.03},{46.48,54.88},{46.54,54.84},{46.49,55.19},{47.42,57.53},{47.8,57.96},{47.92,57.69},{48.21,57.51},{48.46,57.51},{43.04,53.41},{43.28,53.47},{43.16,55.01},{44.03,54.88},{45.23,53.73},{45.56,53.01},{45.15,51.84},{45.23,52.0},{45.84,51.37},{46.78,51.54},{46.24,51.62},{46.31,52.59},{46.51,53.11},{43.63,55.0},{43.09,54.95},{43.09,54.3},{43.19,54.16},{43.25,53.96},{43.25,53.46},},[41]={{96.34,35.62},{96.3,35.48},{96.14,35.65},{96.17,35.83},{96.25,35.96},{96.34,36.01},{96.34,36.1},{95.26,35.81},{95.08,36.2},{95.01,36.37},{95.02,36.3},{95.2,36.23},{95.54,35.7},{96.25,35.39},{99.94,38.21},{99.91,38.02},{98.92,33.96},{98.85,33.39},{98.19,32.97},{98.17,32.43},{98.62,32.45},{98.98,32.44},{98.64,32.4},{98.56,32.52},{98.43,32.38},{98.21,32.41},{98.25,32.99},{98.32,33.36},{98.24,33.59},{98.14,33.69},{98.3,33.88},{98.05,34.66},{98.2,34.98},{98.17,35.23},{98.22,35.45},{98.29,35.77},{98.45,35.62},{98.43,35.51},{98.46,35.55},{98.43,35.67},{98.29,35.74},{98.23,35.6},{98.28,35.56},{98.23,35.89},{99.09,38.04},{99.44,38.43},{99.55,38.18},{99.81,38.02},{95.07,34.25},{95.29,34.31},{95.18,35.72},{95.98,35.6},{97.08,34.54},{97.38,33.88},{97.01,32.82},{97.09,32.96},{97.64,32.38},{98.5,32.53},{98.01,32.61},{98.07,33.5},{98.25,33.97},{95.61,35.71},{95.12,35.67},{95.12,35.07},{95.21,34.95},{95.27,34.75},{95.26,34.3},},},8,nil,nil,125,"H",},
[865] = {'Stonard Wayfinder',2033,2978,50,51,0,{[8]={{50.0,48.19},{50.17,49.87},},},nil,8,nil,nil,125,"H",},
[866] = {'Stonard Grunt',4231,4231,56,56,0,{[8]={{44.41,49.49},{47.32,49.72},{41.49,52.62},{47.59,58.42},{48.94,51.47},{41.4,56.46},{44.89,49.04},{48.02,58.11},{43.37,55.51},{43.3,54.44},},},{[8]={{47.35,49.86},{46.82,50.2},{47.34,49.87},{48.16,49.66},{42.32,51.57},{42.48,51.44},{42.32,51.52},{41.94,51.99},{41.93,52.16},{41.77,52.12},{41.47,52.75},{41.4,54.38},{41.49,52.62},{48.85,51.46},{48.57,50.18},{48.85,51.46},{48.83,52.59},{41.37,55.17},{41.38,56.83},{41.35,56.98},{41.54,57.23},{41.6,57.55},{41.83,57.83},{42.02,57.92},{41.79,57.81},{41.37,56.87},{41.37,56.68},{41.4,56.46},},[41]={{99.03,31.0},{98.54,31.31},{99.01,31.0},{99.77,30.81},{94.41,32.56},{94.56,32.44},{94.41,32.52},{94.06,32.95},{94.05,33.11},{93.91,33.07},{93.64,33.64},{93.57,35.14},{93.65,33.53},{93.54,35.86},{93.55,37.39},{93.52,37.53},{93.7,37.75},{93.76,38.05},{93.96,38.31},{94.13,38.4},{93.92,38.29},{93.54,37.43},{93.54,37.25},{93.57,37.05},},},8,nil,nil,85,"H",},
[867] = {'Stonard Cartographer',3748,3748,52,52,0,{[8]={{49.55,49.0},},},nil,8,nil,nil,125,"H",},
[868] = {'Stonard Shaman',3866,3866,53,53,0,{[8]={{81.68,80.85},},},nil,8,nil,nil,125,"H",},
[869] = {'Protector Dorana',2843,2843,30,30,0,{[40]={{57.31,53.88},},},{[40]={{57.14,53.26},{57.59,52.29},{57.96,51.17},{58.31,49.91},{58.71,48.55},{58.97,47.15},{58.94,45.72},{58.13,44.28},{57.77,43.31},{57.83,42.87},{58.07,42.29},{58.17,41.46},{58.23,40.01},{58.6,38.58},{58.65,37.95},{58.46,37.45},{58.09,37.18},{57.91,36.9},{57.73,35.74},{57.78,34.97},{57.92,34.29},{58.05,33.86},{58.0,32.86},{57.89,31.44},{57.9,30.72},{57.64,30.01},{57.9,30.72},{57.89,31.44},{58.0,32.86},{58.05,33.86},{57.92,34.29},{57.78,34.97},{57.73,35.74},{57.91,36.9},{58.09,37.18},{58.46,37.45},{58.65,37.95},{58.6,38.58},{58.23,40.01},{58.17,41.46},{58.07,42.29},{57.83,42.87},{57.77,43.31},{58.13,44.28},{58.94,45.72},{58.97,47.15},{58.71,48.55},{58.31,49.91},{57.96,51.17},{57.59,52.29},{57.14,53.26},{57.27,53.46},},[12]={{15.53,99.13},{15.58,98.35},{15.73,97.66},{15.86,97.23},{15.81,96.23},{15.7,94.79},{15.71,94.06},{15.45,93.35},{15.71,94.06},{15.7,94.79},{15.81,96.23},{15.86,97.23},{15.73,97.66},{15.58,98.35},{15.53,99.13},},},40,nil,nil,11,"A",},
[870] = {'Protector Deni',1879,1879,30,30,0,{[40]={{55.03,53.89},},},nil,40,nil,nil,11,"A",},
[871] = {'Saltscale Warrior',3660,3831,35,36,1,{[33]={{24.41,24.76},{24.94,23.25},{24.71,24.51},{27.01,24.25},{26.96,22.41},},},nil,33,nil,nil,18,nil,},
[873] = {'Saltscale Oracle',3150,3279,36,37,1,{[33]={{24.56,23.99},{24.29,24.28},{24.8,23.42},{24.52,25.01},{25.1,23.79},},},nil,33,nil,nil,18,nil,},
[874] = {'Protector Korelor',1892,1892,30,30,0,{[40]={{55.11,52.84},},},{[40]={{55.17,52.89},{55.56,52.89},{56.0,53.18},{56.51,53.79},{56.79,54.15},{56.66,55.71},{56.69,56.56},{56.85,57.11},{57.09,57.72},{57.13,58.66},{57.09,59.74},{57.34,61.43},{57.43,62.76},{57.63,64.23},{57.81,65.13},{58.54,66.11},{59.31,66.39},{59.5,66.29},{60.43,64.91},{61.37,64.98},{61.84,65.41},{62.4,65.54},{63.33,65.13},{63.97,64.32},{64.78,63.44},{65.25,63.3},{66.2,63.07},{67.18,62.87},{66.2,63.07},{65.25,63.3},{64.78,63.44},{63.97,64.32},{63.33,65.13},{62.4,65.54},{61.84,65.41},{61.37,64.98},{60.43,64.91},{59.5,66.29},{59.31,66.39},{58.54,66.11},{57.81,65.13},{57.63,64.23},{57.43,62.76},{57.34,61.43},{57.09,59.73},{57.13,58.66},{57.09,57.72},{56.85,57.11},{56.69,56.56},{56.66,55.71},{56.79,54.15},{56.51,53.79},{56.0,53.18},{55.56,52.89},},[10]={{0.02,67.36},{1.23,66.84},{2.07,65.78},{3.11,64.65},{3.72,64.47},{4.94,64.17},{6.22,63.9},{4.94,64.17},{3.72,64.47},{3.11,64.65},{2.07,65.78},{1.23,66.84},{0.02,67.36},},},40,nil,nil,11,"A",},
[875] = {'Saltscale Tide Lord',3279,3279,37,37,1,{[33]={{25.02,24.06},{24.91,24.77},},},nil,33,nil,nil,18,nil,},
[876] = {'Protector Leick',1908,1908,30,30,0,{[40]={{54.95,53.21},},},nil,40,nil,nil,11,"A",},
[877] = {'Saltscale Forager',3660,3831,35,36,1,{[33]={{24.04,25.35},{24.23,25.28},},},nil,33,nil,nil,18,nil,},
[878] = {'Scout Galiaan',1605,1605,30,30,0,{[40]={{53.98,52.98},},},nil,40,{153,},{153,},12,"A",},
[879] = {'Saltscale Hunter',3660,3831,35,36,1,{[33]={{23.58,24.94},{23.17,25.02},{23.44,25.51},{24.23,23.83},{25.27,24.17},},},nil,33,nil,nil,18,nil,},
[880] = {'Erlan Drudgemoor',156,156,8,8,0,{[12]={{70.95,80.63},},},nil,12,nil,nil,17,nil,},
[881] = {'Surena Caledon',160,160,9,9,0,{[12]={{71.01,80.77},},},nil,12,nil,nil,17,nil,},
[883] = {'Deer',1,1,1,1,0,{[36]={{79.59,51.51},{63.71,53.04},{77.58,45.18},{82.3,63.38},{57.75,60.13},{80.47,38.28},},[130]={{55.28,24.8},{47.18,19.11},},[406]={{40.91,16.34},{37.76,14.64},},[331]={{27.13,21.82},{47.11,62.24},{62.48,49.95},{38.27,36.59},{30.04,16.29},{55.73,53.3},{26.17,30.5},{42.85,55.37},{50.43,45.54},{48.73,66.71},{31.27,46.18},{30.4,32.35},{31.44,57.73},{26.86,42.06},{17.86,32.02},{61.02,64.68},{22.04,40.75},{33.98,34.68},{76.15,52.35},{57.85,64.48},{76.0,65.73},{73.55,61.17},},[148]={{55.51,26.68},{39.98,70.07},{44.17,52.55},{43.15,74.9},{56.11,22.41},{42.85,83.19},},[493]={{35.17,62.83},{35.23,58.41},{42.46,60.16},{38.33,34.34},{65.24,46.59},{68.05,63.77},{45.72,63.79},{40.84,60.11},{42.2,46.26},{34.14,43.25},{37.2,53.81},{66.9,56.02},{37.06,34.89},{37.02,43.69},{65.4,69.27},{69.06,55.76},{39.86,28.83},{45.4,60.77},{31.23,48.45},{57.56,75.53},{52.18,38.39},{66.33,68.22},{39.44,47.69},{58.09,68.84},{43.51,58.23},{34.19,61.3},{33.21,35.47},{61.1,47.81},{70.37,51.79},{63.71,44.34},{56.96,31.24},{65.8,60.81},{35.86,50.9},{43.5,51.27},{65.03,64.62},{55.27,33.18},{66.73,48.25},{51.01,71.53},{69.29,52.47},{62.36,67.03},{64.33,54.37},{43.21,47.15},{39.63,67.31},{37.11,27.0},{49.72,63.69},{52.86,74.01},{31.5,55.12},{32.01,39.6},{65.58,52.04},{64.22,67.34},{65.22,66.98},{67.52,53.42},{33.84,51.4},{41.46,67.41},{38.88,46.84},{60.78,72.12},{58.11,65.71},{65.53,48.08},{34.33,40.31},{63.9,49.23},{38.13,65.66},{47.12,68.15},{33.18,32.72},{65.15,71.66},{40.65,55.1},{41.54,42.23},{63.83,69.68},{31.93,60.51},{46.6,68.55},{48.92,71.67},{34.92,56.03},{39.38,42.17},{47.52,32.95},},[28]={{44.6,83.25},},[141]={{42.5,72.04},{47.91,74.32},{46.64,33.32},{65.02,53.6},{41.21,28.7},{45.2,36.79},{53.89,76.62},{55.84,45.17},{54.18,58.8},{38.39,44.77},{41.03,38.59},{64.64,61.53},{55.51,66.97},{55.63,38.59},{60.59,74.55},{63.33,64.12},{43.26,74.01},{53.04,62.7},{40.08,69.73},{40.38,60.29},{61.68,42.12},{63.38,71.21},{61.78,36.12},{60.37,34.06},{62.23,60.4},{68.0,53.7},{53.61,59.8},},[1657]={{76.48,55.13},{54.94,8.53},{40.64,18.79},{48.47,92.69},{52.32,0.21},{55.43,16.47},{68.37,55.63},{66.76,35.71},{54.19,85.35},{49.71,5.74},{36.64,18.32},{28.65,36.9},{45.84,4.21},{26.02,85.02},{58.38,66.87},{66.64,23.44},},[357]={{42.73,22.35},{75.56,51.26},{40.03,8.55},},[12]={{40.55,56.85},{32.12,53.95},{34.43,54.67},{36.92,55.94},{44.66,50.01},{47.07,31.99},{49.92,32.28},{44.46,38.08},{43.81,40.53},{51.35,48.58},{54.7,50.64},{54.99,46.74},{56.36,45.91},{56.8,42.68},{40.22,57.28},{32.28,53.64},{32.95,58.78},{44.98,66.14},{36.74,66.42},{25.24,82.97},{36.14,81.31},{35.47,78.0},{41.2,79.91},{43.35,78.33},{40.17,91.41},{38.47,74.16},{46.21,78.61},{48.29,83.42},{45.81,86.99},{45.06,87.34},{51.52,77.71},{49.32,75.82},{54.01,79.49},{56.87,74.13},{73.36,80.49},{69.65,72.13},{56.85,70.75},{45.21,67.01},{81.05,84.24},{80.83,64.29},{80.37,64.7},{76.81,39.49},{86.95,83.73},{86.94,72.06},{88.65,80.62},},[40]={{59.25,19.7},{59.8,20.27},},[2557]={{-1, -1}},},{[148]={{79.43,19.57},{79.37,19.72},{79.3,19.95},{79.29,20.06},{79.27,20.23},{79.27,20.44},{79.36,20.56},{79.46,20.61},{79.57,20.61},{79.67,20.62},{79.76,20.62},{79.88,20.6},{80.01,20.57},{80.14,20.53},{80.25,20.46},{80.33,20.27},{80.39,20.07},{80.43,19.9},{80.45,19.71},{80.42,19.52},{80.34,19.41},{80.19,19.35},{80.05,19.34},{79.91,19.33},{79.77,19.32},{79.63,19.32},{79.56,19.38},},[493]={{38.1,65.8},{37.94,66.22},{37.75,66.86},{37.7,67.19},{37.66,67.67},{37.67,68.25},{37.9,68.59},{38.21,68.74},{38.5,68.73},{38.79,68.76},{39.05,68.77},{39.39,68.72},{39.77,68.63},{40.11,68.5},{40.43,68.32},{40.66,67.77},{40.85,67.21},{40.95,66.72},{41.0,66.2},{40.93,65.65},{40.7,65.35},{40.27,65.15},{39.86,65.13},{39.48,65.1},{39.09,65.08},{38.67,65.08},{38.48,65.25},},[618]={{27.38,22.28},{27.33,22.42},{27.27,22.63},{27.25,22.73},{27.24,22.89},{27.24,23.08},{27.32,23.19},{27.42,23.24},{27.51,23.24},{27.61,23.25},{27.69,23.25},{27.8,23.23},{27.92,23.2},{28.04,23.16},{28.14,23.1},{28.21,22.92},{28.27,22.74},{28.31,22.58},{28.32,22.41},{28.3,22.23},{28.23,22.14},{28.09,22.07},{27.95,22.06},{27.83,22.06},{27.7,22.05},{27.57,22.05},{27.5,22.1},},},493,nil,nil,31,"AH",},
[885] = {'Watcher Keller',2192,2192,37,37,0,{[10]={{78.26,44.68},},},nil,10,nil,nil,11,"A",},
[886] = {'Watcher Hartin',2100,2100,36,36,0,{[10]={{75.2,44.77},},},nil,10,nil,nil,11,"A",},
[887] = {'Watcher Jordan',2918,2918,39,39,0,{[10]={{74.77,50.44},},},{[10]={{74.74,50.42},{74.56,49.29},{74.45,48.27},{74.64,47.15},{75.71,46.74},{74.88,46.32},{74.8,44.57},{74.78,46.25},{73.69,46.62},{74.26,47.87},{74.58,49.08},{74.74,50.42},{74.56,49.29},{74.45,48.27},{74.64,47.15},{75.71,46.74},{74.88,46.32},{74.8,44.57},{74.78,46.25},{73.69,46.62},{74.26,47.87},{74.58,49.08},},[41]={{14.06,45.45},{13.86,44.23},{13.74,43.13},{13.94,41.92},{15.1,41.47},{14.21,41.03},{14.12,39.13},{14.1,40.95},{12.92,41.35},{13.53,42.7},{13.88,44.01},{14.06,45.45},{13.86,44.23},{13.74,43.13},{13.94,41.92},{15.1,41.47},{14.21,41.03},{14.12,39.13},{14.1,40.95},{12.92,41.35},{13.53,42.7},{13.88,44.01},},},10,nil,nil,56,"A",},
[888] = {'Watcher Dodds',950,950,29,29,0,{[10]={{45.12,67.03},},},nil,10,{245,},{245,},53,"A",},
[889] = {'Splinter Fist Ogre',734,788,25,26,0,{[10]={{38.72,70.5},{40.37,71.98},{40.45,70.49},{37.51,72.0},{38.48,72.57},{38.68,74.86},{39.33,75.97},},},nil,10,nil,nil,45,nil,},
[890] = {'Fawn',16,16,1,1,0,{[12]={{32.29,53.64},{36.94,55.81},{43.84,40.53},{51.27,49.21},{55.85,45.08},{32.3,53.7},{45.01,66.25},{25.32,83.05},{35.55,77.95},{45.18,67.09},{80.4,64.64},{86.98,71.99},{88.64,80.72},},},nil,12,nil,nil,31,"AH",},
[891] = {'Splinter Fist Fire Weaver',628,665,26,27,0,{[10]={{36.26,75.22},{35.03,70.65},{36.27,70.91},{39.98,74.01},{39.3,74.51},{40.39,75.17},{34.86,72.06},},},nil,10,nil,nil,45,nil,},
[892] = {'Splinter Fist Taskmaster',840,896,27,28,0,{[10]={{33.75,68.21},{39.51,74.99},{36.57,72.44},{33.84,70.49},},},nil,10,nil,nil,45,nil,},
[893] = {'Lars',804,804,18,18,0,{[10]={{7.71,33.2},},},nil,10,{226,},{226,},12,"A",},
[894] = {'Homer Stonefield',166,166,5,5,0,{[12]={{33.69,82.9},},},nil,12,nil,nil,12,"A",},
[895] = {'Thorgas Grimson',166,166,5,5,0,{[1]={{29.18,67.45},},},nil,1,{6074,},{3108,},55,"A",},
[896] = {'Veldan Lightfoot',413,413,10,10,0,{[12]={{25.18,73.89},},},nil,12,nil,nil,12,"A",},
[898] = {'Nightbane Worgen',787,840,26,27,0,{[10]={{60.89,32.79},{59.93,68.89},{62.64,31.05},{62.56,54.97},{61.18,66.41},{62.78,68.57},{58.5,25.61},{59.46,27.49},{61.25,30.27},{66.08,40.62},{58.83,50.27},{66.9,42.85},{59.07,53.7},{57.38,51.88},{61.2,53.21},{57.41,27.57},{58.51,29.94},{58.39,31.17},{62.59,42.27},{67.28,38.69},{62.08,27.86},{66.31,37.47},{63.74,33.57},{64.88,34.4},{57.82,29.86},{58.07,30.54},{61.44,50.29},{60.31,47.96},},},nil,10,nil,nil,24,nil,},
[900] = {'Bailiff Conacher',1605,1605,30,30,0,{[44]={{29.72,44.26},},},nil,44,{91,},{91,},11,"A",},
[903] = {'Guard Howe',1605,1605,30,30,0,{[44]={{31.54,57.85},},},nil,44,{128,},{128,},11,"A",},
[905] = {'Sharptooth Frenzy',1107,1163,31,32,0,{[33]={{40.92,16.84},{41.91,20.04},{40.89,18.39},{41.33,17.48},{39.4,29.61},{39.82,25.64},{40.43,21.51},{35.59,33.25},{40.22,22.14},{42.33,18.41},{39.03,30.57},{36.05,33.11},{40.81,16.03},{37.65,10.22},{37.43,32.1},{39.29,11.9},{40.55,14.38},{32.9,8.27},},},nil,33,nil,nil,16,nil,},
[906] = {'Maximillian Crowe',413,413,10,10,0,{[12]={{44.39,66.24},},},nil,12,nil,nil,12,"A",},
[907] = {'Keras Wolfheart',9563,9563,61,61,1,{[1657]={{58.02,37.29},},},nil,1657,nil,nil,1577,"A",},
[908] = {'Flora Silverwind',2868,2868,44,44,0,{[33]={{27.72,77.86},},},nil,33,nil,nil,120,"AH",},
[909] = {'Defias Night Blade',734,788,25,26,0,{[10]={{22.57,71.59},{21.63,73.32},{21.62,73.0},{20.51,72.66},{23.37,73.31},{47.79,76.85},{48.12,75.49},{48.81,77.48},{21.81,71.94},{19.93,70.78},{23.01,73.84},{49.92,77.27},{50.51,77.05},{50.71,76.93},{23.9,71.38},{24.04,72.1},},},nil,10,nil,nil,17,nil,},
[910] = {'Defias Enchanter',628,665,26,27,0,{[10]={{48.81,77.5},{21.35,73.36},{21.47,73.02},{21.27,71.96},{50.43,77.36},{23.65,71.95},},},nil,10,nil,nil,17,nil,},
[911] = {'Llane Beshere',166,166,5,5,0,{[12]={{50.24,42.29},},},nil,12,nil,{3100,},12,"A",},
[912] = {'Thran Khorman',166,166,5,5,0,{[1]={{28.83,67.24},},},nil,1,nil,{3106,3112,},55,"A",},
[913] = {'Lyria Du Lac',500,500,12,12,0,{[12]={{41.09,65.77},},},nil,12,{1638,},nil,12,"A",},
[914] = {'Ander Germaine',6139,6139,60,60,0,{[1519]={{78.21,47.59},},},nil,1519,nil,nil,12,"A",},
[915] = {'Jorik Kerridan',166,166,5,5,0,{[12]={{50.31,39.92},},},nil,12,nil,{3102,},12,"A",},
[916] = {'Solm Hargrin',166,166,5,5,0,{[1]={{28.37,67.51},},},nil,1,nil,{3109,3113,},55,"A",},
[917] = {'Keryn Sylvius',456,456,11,11,0,{[12]={{43.87,65.94},},},nil,12,{2205,2300,},nil,12,"A",},
[918] = {'Osborne the Night Man',3139,3139,60,60,0,{[1519]={{74.64,52.82},},},nil,1519,nil,nil,12,"A",},
[920] = {'Nightbane Tainted One',892,935,30,31,0,{[10]={{63.14,80.34},{61.24,81.67},{60.91,80.91},{63.57,83.62},{62.37,81.1},{62.33,82.2},{63.6,84.2},{63.48,83.67},{73.61,78.95},{73.53,77.04},{74.06,79.59},{74.11,78.7},{73.85,77.21},{73.09,75.61},},},nil,10,nil,nil,24,nil,},
[921] = {'Venture Co. Lumberjack',1279,1342,34,35,0,{[33]={{43.32,19.09},},},nil,33,nil,nil,47,nil,},
[922] = {'Silt Crawler',1829,1902,40,41,0,{[8]={{78.91,5.28},{80.36,7.38},{84.71,13.88},{75.99,5.19},{81.85,9.57},{89.1,18.29},{77.49,5.22},{80.47,93.89},{76.04,3.02},{78.68,8.0},{84.37,11.85},{73.66,5.34},{81.16,9.25},{82.68,12.63},{86.5,86.38},{85.63,82.53},{84.51,83.07},{88.05,78.3},{84.39,14.77},{83.03,15.49},{90.21,23.77},{88.02,20.5},{86.98,18.18},{83.23,84.65},{89.82,80.37},},},nil,8,nil,nil,7,"AH",},
[923] = {'Young Black Ravager',617,664,23,24,0,{[10]={{26.27,70.96},{27.63,74.34},{24.41,78.04},{28.33,62.84},{20.11,77.7},{43.5,77.37},{46.85,63.32},{24.85,64.01},{17.76,65.05},{47.82,73.9},{52.31,76.16},{18.23,71.99},{25.71,74.82},{28.44,65.44},{30.66,62.57},{26.72,67.59},{53.42,73.11},{49.97,69.14},{21.97,78.31},{37.47,65.45},{52.07,72.85},{47.75,70.27},{40.41,64.95},{54.06,74.12},{48.99,65.24},{32.47,62.42},{22.07,68.76},{42.93,70.82},{69.47,30.81},{55.5,65.75},{66.11,23.99},{69.34,30.09},{54.58,63.75},{67.2,28.05},{55.95,64.34},{56.45,62.1},{53.51,65.06},{51.19,64.09},{59.78,60.8},{60.98,59.26},},},nil,10,nil,nil,38,nil,},
[925] = {'Brother Sammuel',166,166,5,5,0,{[12]={{50.43,42.12},},},nil,12,nil,{3101,},12,"A",},
[926] = {'Bromos Grummner',166,166,5,5,0,{[1]={{28.83,68.33},},},nil,1,nil,{3107,},55,"A",},
[927] = {'Brother Wilhelm',456,456,11,11,0,{[12]={{41.1,66.04},},},nil,12,{2998,},nil,12,"A",},
[928] = {'Lord Grayson Shadowbreaker',3139,3139,60,60,0,{[1519]={{37.14,33.26},},},nil,1519,{3000,7637,7640,7641,7643,7646,7647,7666,8415,},{7638,7639,7640,7644,7646,7648,7666,},12,"A",},
[930] = {'Black Widow Hatchling',664,713,24,25,0,{[10]={{26.39,47.0},{87.08,52.11},{27.42,47.28},{28.11,44.69},{85.49,51.73},{83.79,57.6},{35.02,32.35},{81.64,52.09},{82.15,53.35},{86.92,53.06},{85.96,52.09},{86.27,50.29},{80.69,62.77},{30.1,48.37},{29.63,46.6},{30.11,51.19},{29.6,49.39},{26.23,52.29},{26.73,52.04},{26.86,50.25},{29.48,53.49},{34.35,54.14},{37.3,59.5},{37.24,57.47},{30.81,36.04},{31.98,34.06},{32.82,36.01},{33.57,34.14},{32.83,32.74},{32.94,39.52},{31.56,42.44},{31.83,46.6},{33.82,49.71},{31.32,49.46},{32.57,48.22},{30.39,55.17},{35.59,54.7},{31.27,56.51},{32.42,54.75},{31.21,54.92},{32.82,51.72},{31.36,57.11},{34.91,45.96},{33.44,45.91},{31.93,34.27},{79.29,51.43},{80.39,54.13},{77.81,58.35},{27.69,40.79},{34.65,59.1},{35.14,58.2},{32.31,39.35},{35.72,55.84},{30.14,55.19},{30.11,51.41},},},nil,10,nil,nil,22,nil,},
[931] = {'Ariena Stormfeather',7842,7842,55,55,1,{[44]={{30.59,59.41},},},nil,44,nil,nil,12,"A",},
[932] = {'Guard Ashlock',2016,2016,35,35,0,{[44]={{31.9,57.77},},},nil,44,nil,nil,11,"A",},
[933] = {'Guard Hiett',2016,2016,35,35,0,{[44]={{33.36,58.42},},},nil,44,nil,nil,11,"A",},
[934] = {'Guard Clarke',2100,2100,36,36,0,{[44]={{28.15,47.75},},},{[44]={{28.98,47.88},{30.02,47.98},{31.09,48.04},{32.02,48.07},{32.37,48.37},{31.77,48.77},{31.0,48.94},{30.22,48.97},{29.72,49.05},{29.57,49.82},{29.47,50.86},{29.44,51.62},{29.35,52.49},{29.28,53.14},{29.35,52.49},{29.44,51.62},{29.47,50.86},{29.57,49.88},{29.72,49.05},{30.22,48.97},{31.0,48.94},{31.77,48.77},{32.37,48.37},{32.02,48.07},{31.09,48.04},{30.02,47.98},{28.98,47.88},{28.16,47.75},},},44,nil,nil,11,"A",},
[935] = {'Guard Pearce',2016,2016,35,35,0,{[44]={{33.12,58.12},},},nil,44,nil,nil,11,"A",},
[936] = {'Guard Adams',2016,2016,35,35,0,{[44]={{27.49,46.33},},},{[44]={{27.48,46.32},{27.66,46.29},{27.79,44.04},{27.17,42.28},{26.15,42.3},{26.01,44.01},{25.79,45.39},{25.24,46.38},{24.33,46.33},{23.78,45.59},{24.12,42.41},{23.87,43.62},{23.87,44.59},{23.62,45.52},{23.13,45.54},{23.25,45.92},{24.33,46.17},{25.08,46.38},{26.03,46.9},{27.47,46.87},},},44,nil,nil,11,"A",},
[937] = {'Kurzen Jungle Fighter',1163,1221,32,33,0,{[33]={{44.51,10.0},{43.92,9.71},{43.7,9.55},{44.95,8.29},{45.03,8.36},{44.64,9.98},{44.85,8.61},{44.13,9.66},{43.57,9.73},{44.55,11.49},{46.16,12.6},{44.67,11.0},{45.3,11.27},{46.98,10.45},{46.07,11.27},{45.96,12.05},},},nil,33,nil,nil,46,nil,},
[938] = {'Kurzen Commando',1279,1342,33,35,0,{[33]={{44.15,7.91},{48.35,7.13},{44.37,7.97},{44.2,8.01},{45.96,8.66},{45.46,8.42},{44.56,8.5},{47.28,7.61},{46.7,7.06},{46.45,6.93},{45.93,7.9},{46.26,7.78},{46.34,7.43},{45.99,8.09},{45.73,8.1},},},nil,33,nil,nil,46,nil,},
[939] = {'Kurzen Elite',1469,1536,36,37,0,{[33]={{46.81,6.52},{47.88,6.4},{47.35,6.58},{47.68,6.87},{46.69,6.21},{47.88,6.86},{46.77,6.57},{49.27,7.51},{49.35,8.37},{49.33,7.86},{48.87,8.56},{49.57,7.73},{49.14,8.03},{48.4,8.65},},},nil,33,nil,nil,46,nil,},
[940] = {'Kurzen Medicine Man',977,1021,32,33,0,{[33]={{43.89,7.13},{44.72,11.43},{43.96,9.41},{44.51,9.92},{43.89,9.79},{43.7,9.53},{43.89,9.53},{44.45,9.79},{43.88,9.42},{44.86,11.39},{44.9,9.46},{46.58,9.52},{44.11,9.35},{44.07,8.74},{43.97,12.02},{44.0,11.31},{43.96,10.56},{44.76,11.16},{45.17,11.06},{45.15,10.98},{45.24,11.35},{46.51,11.28},{47.13,7.43},},},nil,33,nil,nil,46,nil,},
[941] = {'Kurzen Headshrinker',1064,1110,34,35,0,{[33]={{48.12,7.21},{48.41,7.33},{47.74,7.78},{48.11,8.39},{46.94,7.29},{46.33,6.96},{46.39,6.69},{46.43,7.87},},},nil,33,nil,nil,46,nil,},
[942] = {'Kurzen Witch Doctor',1208,1257,36,37,0,{[33]={{47.9,6.09},{47.64,6.63},{47.52,5.95},{47.54,5.55},{47.4,5.7},{46.88,5.92},{47.92,7.24},{49.35,7.15},{48.68,8.73},{49.53,8.32},{49.73,7.47},{47.85,7.02},{49.38,7.16},},},nil,33,nil,nil,46,nil,},
[943] = {'Kurzen Wrangler',1064,1064,34,34,0,{[33]={{45.75,10.38},{45.82,9.44},{45.81,9.68},{45.84,9.93},},},nil,33,nil,nil,46,nil,},
[944] = {'Marryk Nurribit',166,166,5,5,0,{[1]={{28.71,66.37},},},nil,1,nil,{3114,},875,"A",},
[945] = {'Rybrad Coldbank',166,166,5,5,0,{[1]={{28.66,67.74},},},nil,1,nil,nil,55,"A",},
[946] = {'Frostmane Novice',69,83,3,4,0,{[1]={{28.99,82.57},{28.69,83.14},{29.05,81.17},{29.38,81.06},{30.1,82.38},{30.41,80.87},{30.23,80.27},{30.48,79.54},{66.49,40.88},{66.49,40.88},},},nil,1,nil,nil,107,nil,},
[947] = {'Rohh the Silent',788,788,26,26,4,{[44]={{75.47,39.59},{83.93,59.33},{83.85,57.52},{82.45,56.21},{81.29,55.68},{82.68,53.91},{84.25,51.01},{78.81,40.75},{78.69,35.54},{76.45,37.75},{73.89,35.5},{75.8,29.71},{76.07,47.29},},},nil,44,nil,nil,39,nil,},
[948] = {'Rotted One',734,788,25,26,0,{[10]={{21.53,35.95},{25.64,33.53},{21.85,34.09},{24.03,37.96},{21.6,37.54},{24.78,34.36},{25.43,37.86},},},nil,10,nil,nil,21,nil,},
[949] = {'Carrion Recluse',734,788,25,26,0,{[10]={{21.47,46.26},{21.04,39.11},{18.92,42.11},{16.96,39.6},{18.14,43.68},{23.42,36.7},},},nil,10,nil,nil,22,nil,},
[950] = {'Swamp Talker',2880,2880,50,50,0,{[8]={{62.6,88.07},},},nil,8,nil,nil,18,nil,},
[951] = {'Brother Paxton',1380,1380,27,27,0,{[12]={{49.61,40.41},},},nil,12,{345,346,},{344,347,},12,"A",},
[952] = {'Brother Neals',3517,3517,50,50,0,{[12]={{49.47,41.59},},},nil,12,nil,{3905,},12,"A",},
[954] = {'Kat Sampson',748,748,17,17,0,{[38]={{82.65,64.11},},},nil,38,nil,nil,55,"A",},
[955] = {'Sergeant De Vries',413,413,10,10,0,{[12]={{24.08,73.2},},},nil,12,nil,nil,12,"A",},
[956] = {'Dorin Songblade',1042,1042,22,22,0,{[44]={{30.88,46.44},},},nil,44,nil,nil,12,"A",},
[957] = {'Dane Lindgren',1605,1605,30,30,0,{[1519]={{57.44,16.3},},},nil,1519,nil,nil,12,"A",},
[958] = {'Dawn Brightstar',2016,2016,35,35,0,{[12]={{64.88,69.19},},},nil,12,nil,nil,12,"A",},
[959] = {'Morley Eberlein',334,334,8,8,0,{[12]={{64.69,69.51},},},nil,12,nil,nil,12,"A",},
[960] = {'Gunder Thornbush',1605,1605,30,30,0,{[10]={{73.8,45.1},},},nil,10,nil,nil,12,"A",},
[963] = {'Deputy Rainer',413,413,10,10,0,{[12]={{24.23,74.45},},},nil,12,{11,109,},{11,239,},12,"A",},
[976] = {'Kurzen War Tiger',1163,1221,32,33,0,{[33]={{45.86,9.58},{45.88,9.97},},},nil,33,nil,nil,46,nil,},
[977] = {'Kurzen War Panther',1163,1221,32,33,0,{[33]={{45.75,9.66},{45.75,9.43},},},nil,33,nil,nil,46,nil,},
[978] = {'Kurzen Subchief',1305,1305,35,36,0,{[33]={{49.66,6.02},{49.28,3.94},{49.3,4.1},{48.8,4.55},{49.65,3.84},{49.56,4.09},{49.91,4.04},{48.95,5.87},{48.71,5.37},{49.13,5.73},{48.72,5.81},{49.17,6.34},{49.43,6.16},{49.35,6.77},},},nil,33,nil,nil,46,nil,},
[979] = {'Kurzen Shadow Hunter',1604,1604,36,38,0,{[33]={{49.65,5.76},{49.95,3.68},{48.98,5.64},{48.58,5.55},{48.74,4.95},},},nil,33,nil,nil,46,nil,},
[980] = {'Grimnal',2972,2972,45,45,0,{[8]={{45.08,50.43},},},nil,8,nil,nil,29,"H",},
[981] = {'Hartash',2972,2972,45,45,0,{[8]={{45.67,50.92},},},nil,8,nil,nil,29,"H",},
[982] = {'Thultash',2972,2972,45,45,0,{[8]={{46.53,54.29},},},nil,8,nil,nil,29,"H",},
[983] = {'Thultazor',2972,2972,45,45,0,{[8]={{45.78,52.82},},},nil,8,nil,nil,29,"H",},
[984] = {'Thralosh',2972,2972,45,45,0,{[8]={{45.06,51.4},},},nil,8,nil,nil,29,"H",},
[985] = {'Malosh',3517,3517,50,50,0,{[8]={{44.89,57.62},},},nil,8,nil,nil,29,"H",},
[986] = {'Haromm',3517,3517,50,50,0,{[8]={{48.19,57.94},},},nil,8,{8410,},nil,29,"H",},
[987] = {'Ogromm',3517,3517,50,50,0,{[8]={{47.26,53.43},},},nil,8,nil,nil,29,"H",},
[988] = {'Kartosh',3517,3517,50,50,0,{[8]={{48.65,55.64},},},nil,8,{8419,},nil,29,"H",},
[989] = {'Banalash',3517,3517,50,50,0,{[8]={{44.77,56.63},},},nil,8,nil,nil,29,"H",},
[999] = {'Watcher Royce',2016,2016,35,35,0,{[10]={{79.47,46.16},},},nil,10,nil,nil,11,"A",},
[1000] = {'Watcher Blomberg',484,484,20,20,0,nil,nil,0,nil,nil,56,"A",},
[1001] = {'Watcher Hutchins',484,484,20,20,0,nil,nil,0,nil,nil,56,"A",},
[1007] = {'Mosshide Gnoll',494,531,20,21,0,{[11]={{60.33,73.77},{62.63,74.97},{60.51,63.71},{63.91,63.8},{61.21,73.1},{61.78,73.08},{62.58,72.74},{62.13,72.0},{61.89,71.88},{55.55,75.18},{55.69,75.37},{56.06,74.6},{55.93,75.93},{55.48,75.0},{56.73,75.04},{55.91,75.23},{63.17,69.09},{55.17,75.39},{55.43,74.09},{61.23,72.24},{62.7,69.1},{62.55,69.85},{62.38,68.99},{62.9,69.81},{61.56,66.77},{60.29,71.44},{54.37,73.73},{66.67,70.09},{64.22,64.06},{64.25,63.4},{64.12,62.47},{63.78,62.42},},},nil,11,nil,nil,61,nil,},
[1008] = {'Mosshide Mongrel',531,573,21,22,0,{[11]={{59.53,72.67},{60.95,75.13},{64.05,63.68},{63.81,63.64},{61.68,72.15},{61.64,72.34},{61.84,72.23},{61.54,72.67},{61.77,72.53},{61.85,72.44},{55.74,74.78},{62.78,69.33},{62.54,69.49},{62.8,68.39},{62.82,69.61},{62.12,69.82},{62.6,69.63},{61.27,67.88},{61.53,59.13},{60.74,64.31},{61.72,61.45},{60.49,59.36},{61.28,57.88},{60.62,58.55},{61.08,57.08},{63.93,63.17},{63.79,63.21},{63.96,63.38},{63.54,59.88},{61.86,57.98},{63.64,60.52},{61.2,55.57},{65.43,64.85},{64.99,60.64},},},nil,11,nil,nil,61,nil,},
[1009] = {'Mosshide Mistweaver',472,504,22,23,0,{[11]={{61.27,58.42},{61.13,58.65},{62.68,69.3},{61.2,58.26},{45.16,31.89},{45.59,34.45},{38.98,34.05},},},nil,11,nil,nil,61,nil,},
[1010] = {'Mosshide Fenrunner',573,617,22,23,0,{[11]={{61.13,58.23},{34.56,34.42},{51.23,30.82},{35.43,31.55},{52.74,27.63},{51.5,30.79},{61.03,58.64},{43.68,34.73},{45.7,35.38},{45.65,31.71},{45.28,34.15},{39.41,33.96},{45.91,34.7},{43.74,34.07},{44.01,34.93},{38.7,34.39},{52.47,28.2},{53.2,27.16},{39.66,34.7},{44.67,31.67},{45.34,32.49},{43.63,35.28},{26.47,37.18},{53.12,28.0},{52.18,27.19},{45.57,34.8},{43.24,34.17},{45.23,35.02},{43.18,34.7},{38.84,34.08},{61.35,58.59},{61.04,58.44},{65.13,55.11},{40.04,32.04},{32.34,35.77},{64.9,56.45},{63.47,58.41},{64.5,56.87},{64.46,55.48},{59.62,58.18},{60.67,54.3},{59.62,55.59},{62.74,57.05},},},nil,11,nil,nil,61,nil,},
[1011] = {'Mosshide Trapper',617,664,23,24,0,{[11]={{26.68,35.44},{32.49,31.16},{33.33,33.1},{31.82,32.58},{31.62,33.27},{31.01,32.29},{32.2,33.64},{28.02,34.91},{51.09,30.88},{32.8,28.85},{52.85,27.41},{51.54,30.95},{28.55,37.52},{43.56,34.58},{42.83,32.34},{33.12,35.07},{43.06,32.88},{42.57,31.85},{40.97,30.76},{36.16,34.66},{42.72,32.64},{40.92,34.03},{44.0,34.55},{39.37,34.39},{45.05,31.78},{42.99,32.0},{29.51,35.16},{29.91,37.24},},},nil,11,nil,nil,61,nil,},
[1012] = {'Mosshide Brute',664,713,24,25,0,{[11]={{35.4,27.55},{35.23,27.09},{34.81,27.57},{39.46,27.41},{40.1,26.49},{40.51,27.81},{40.75,27.01},{39.91,27.49},{31.01,29.13},{30.81,33.12},{31.35,28.75},{31.11,30.23},{31.91,30.08},{31.55,29.85},{32.03,29.46},{28.3,29.52},{37.01,30.2},{28.59,29.8},{38.68,30.4},{38.73,29.59},{38.28,28.6},{38.33,30.54},{35.01,29.85},{37.13,29.22},{42.95,32.37},{42.55,32.1},{29.31,32.35},},},nil,11,nil,nil,61,nil,},
[1013] = {'Mosshide Mystic',640,684,25,26,0,{[11]={{35.09,27.56},{37.66,29.8},{37.89,29.86},{40.19,27.46},{31.36,32.75},{31.31,33.02},{31.36,29.67},},},nil,11,nil,nil,61,nil,},
[1014] = {'Mosshide Alpha',840,840,27,27,0,{[11]={{35.03,27.36},{37.75,29.47},{40.06,27.29},{31.28,32.72},{31.44,29.54},},},nil,11,nil,nil,61,nil,},
[1015] = {'Highland Raptor',617,664,23,24,0,{[11]={{56.18,28.74},{55.72,29.99},{57.03,37.06},{53.11,30.38},{55.58,26.13},{56.79,28.7},{39.96,24.53},{49.92,27.58},{57.48,33.49},{52.41,25.45},{52.46,23.36},{55.52,24.69},{54.38,23.24},{51.41,28.94},{41.63,24.13},{54.82,27.7},{54.7,25.7},{38.54,24.11},{40.08,21.89},{41.66,21.81},{40.96,23.16},{57.85,37.65},},},nil,11,nil,nil,48,nil,},
[1016] = {'Highland Lashtail',664,713,24,25,0,{[11]={{61.36,22.14},{61.73,23.14},{56.31,27.28},{39.0,23.59},{38.53,23.15},{57.81,35.44},{57.33,25.38},{56.24,22.55},{57.4,23.44},{39.62,20.98},{30.16,21.64},{30.59,20.73},{35.58,25.0},{30.27,21.15},{30.66,20.35},{30.12,20.77},{32.19,19.53},{59.53,30.33},},},nil,11,nil,nil,48,nil,},
[1017] = {'Highland Scytheclaw',734,788,25,26,0,{[11]={{58.74,21.52},{58.94,21.18},{59.58,21.33},{56.88,27.62},{31.22,16.16},{37.56,23.45},{37.33,22.79},{37.87,22.83},{37.69,22.4},{58.18,26.79},{57.48,27.66},{56.36,31.43},{38.22,19.57},{36.58,22.54},{37.44,20.16},{37.58,19.37},{30.38,16.8},{33.01,18.14},{35.37,21.9},{34.53,20.66},},},nil,11,nil,nil,48,nil,},
[1018] = {'Highland Razormaw',840,896,27,28,0,{[11]={{70.65,29.21},{67.29,36.28},{67.17,37.98},{68.1,32.93},{69.35,32.07},{67.33,29.53},{67.07,30.88},{67.35,28.62},{69.06,28.83},{68.74,27.81},{69.68,30.37},{68.41,33.13},{70.3,29.99},{67.84,30.74},{32.15,14.62},{65.79,31.3},{66.37,32.79},{68.0,35.8},{65.32,30.15},{70.17,37.86},{66.83,32.87},{66.53,31.9},{65.93,28.61},{65.13,28.68},{71.75,39.08},{72.02,39.88},{69.77,37.36},{68.02,36.3},{69.21,34.78},{69.61,33.49},{69.47,34.36},{69.98,38.72},{32.68,15.31},{35.17,20.42},{33.63,17.02},{35.4,18.75},{35.5,19.55},},},nil,11,nil,nil,48,nil,},
[1019] = {'Elder Razormaw',950,950,29,29,0,{[11]={{69.06,31.62},{40.1,18.36},{67.58,31.59},{67.94,27.54},{69.67,29.12},{69.3,29.79},{69.09,28.25},{70.2,28.37},{68.68,31.29},{69.89,32.03},{70.7,30.82},{67.88,32.39},{39.69,17.08},{38.55,16.94},{38.06,15.69},{33.69,14.94},{69.89,32.76},{70.22,31.83},{69.3,32.9},{38.17,15.9},{33.03,13.01},{33.95,12.44},},},nil,11,nil,nil,48,nil,},
[1020] = {'Mottled Raptor',573,617,22,23,0,{[11]={{23.02,59.84},{22.51,58.96},{24.31,46.31},{23.89,47.15},{24.16,48.27},{23.35,51.17},{22.96,50.09},{24.11,50.43},{22.19,53.49},{21.37,51.91},{25.22,49.77},{23.06,59.56},{23.24,54.11},{29.48,46.49},{19.77,52.47},{31.51,42.1},{27.21,46.76},{26.38,46.34},{28.85,42.41},{26.0,47.47},{29.67,46.16},{20.72,48.8},{27.18,43.48},{29.46,42.39},{37.07,42.24},{28.06,42.81},{24.57,46.77},},},nil,11,nil,nil,48,nil,},
[1021] = {'Mottled Screecher',664,713,24,25,0,{[11]={{24.11,53.03},{23.92,52.37},{24.22,52.53},{22.77,50.71},{23.45,56.02},{30.2,44.06},{23.04,55.55},{22.97,56.49},{29.87,44.44},{29.76,45.21},{23.65,60.45},{25.8,48.85},{26.19,49.15},{26.13,48.57},{29.38,45.37},{22.62,55.86},},},nil,11,nil,nil,48,nil,},
[1022] = {'Mottled Scytheclaw',734,788,25,26,0,{[11]={{31.84,46.9},{30.58,48.73},{32.82,51.02},{35.7,44.07},{33.61,44.62},{31.32,48.49},{35.9,49.44},{34.43,43.67},{35.14,50.84},{35.3,49.49},{34.45,45.76},{35.62,51.85},{34.44,50.91},{36.05,48.37},},},nil,11,nil,nil,48,nil,},
[1023] = {'Mottled Razormaw',788,840,26,27,0,{[11]={{33.85,48.27},{35.18,46.26},{34.68,47.09},{33.31,46.95},{34.33,49.55},{33.62,46.19},{32.87,48.26},{33.71,49.84},{32.21,48.69},},},nil,11,nil,nil,48,nil,},
[1024] = {'Bluegill Murloc',494,531,20,21,0,{[11]={{12.21,39.06},{10.94,39.86},{19.06,38.64},{11.87,41.21},{12.7,42.32},{12.51,39.78},{17.78,40.85},{13.99,40.73},{13.51,42.05},{13.24,41.15},{13.49,39.91},{18.48,38.3},{16.94,39.92},{18.62,40.27},{14.21,41.25},{15.26,39.83},{14.89,39.57},{15.31,38.95},{15.06,38.72},{15.43,38.63},{15.61,38.93},{15.75,40.79},{20.69,41.15},{18.95,41.1},{19.82,40.05},},},nil,11,nil,nil,18,nil,},
[1025] = {'Bluegill Puddlejumper',531,573,21,22,0,{[11]={{12.1,36.22},{10.29,38.63},{10.12,36.25},{11.17,37.56},{11.04,35.2},{13.62,41.18},{13.51,34.06},{18.55,39.09},{18.02,39.77},{18.41,39.5},{13.28,38.18},{15.2,38.45},{13.53,37.93},{13.73,38.37},{15.18,33.94},{13.58,36.61},{14.38,35.29},{12.84,34.96},{12.68,37.02},},},nil,11,nil,nil,18,nil,},
[1026] = {'Bluegill Forager',573,617,22,23,0,{[11]={{25.03,38.46},{25.49,40.01},{22.29,41.03},{13.51,38.34},{14.54,35.45},},},nil,11,nil,nil,18,nil,},
[1027] = {'Bluegill Warrior',664,713,24,25,0,{[11]={{14.26,20.91},{16.99,21.69},{15.6,20.82},{12.81,22.98},{13.76,22.29},{12.45,25.36},{11.65,28.59},{17.67,20.71},{21.52,36.52},{12.58,27.55},{13.58,26.95},{16.53,30.35},{16.35,30.03},{16.2,30.76},{13.49,34.49},{19.15,32.82},{13.9,35.09},{14.01,32.8},},},nil,11,nil,nil,18,nil,},
[1028] = {'Bluegill Muckdweller',504,539,23,24,0,{[11]={{13.1,32.77},{11.07,32.69},{11.25,30.5},{11.96,31.55},{10.43,33.65},{11.89,33.75},{21.9,37.72},{20.13,36.27},{24.85,37.32},{23.3,39.79},{22.31,38.98},{16.61,31.56},{20.82,35.36},{16.25,35.95},{16.45,36.18},{22.56,35.54},{23.06,37.35},{24.37,36.37},{21.55,33.79},{15.18,31.56},{16.0,36.34},{16.25,36.42},{20.81,37.85},},},nil,11,nil,nil,18,nil,},
[1029] = {'Bluegill Oracle',640,684,25,26,0,{[11]={{16.55,30.73},{16.07,30.45},},},nil,11,nil,nil,18,nil,},
[1030] = {'Black Slime',494,531,20,21,0,{[11]={{61.76,78.98},{61.8,78.53},{66.42,61.25},{53.34,50.36},{54.94,54.67},{55.26,72.96},{56.71,79.08},{61.57,65.39},{60.61,77.47},{54.04,72.43},{57.71,73.89},{57.21,65.88},{54.64,66.57},{59.12,70.84},{59.79,65.62},{66.22,61.4},{56.27,66.69},{56.72,73.36},{59.44,69.2},{59.12,73.22},{65.4,58.5},{55.36,63.09},{65.37,61.57},{54.37,78.57},},},nil,11,nil,nil,14,nil,},
[1031] = {'Crimson Ooze',664,713,24,25,0,{[11]={{44.31,24.7},{44.58,24.19},{44.23,25.43},{44.63,24.76},{44.75,24.26},{44.0,24.18},{44.73,25.38},{43.81,25.23},},},nil,11,nil,nil,14,nil,},
[1032] = {'Black Ooze',617,664,23,24,0,{[11]={{58.89,28.89},{65.55,51.6},{64.19,49.65},{22.93,59.48},{56.01,25.13},{56.79,29.48},{56.78,33.74},{56.98,31.17},{47.45,25.44},{46.42,24.78},{44.05,27.79},{61.88,37.46},{59.55,40.13},{57.08,44.49},{63.66,44.57},{64.96,46.1},{44.82,25.48},{44.15,25.63},{43.2,29.18},{43.33,27.95},{58.77,44.85},{61.74,44.27},{48.14,24.6},{44.93,24.37},{23.92,48.4},{43.53,24.6},{42.87,26.35},{43.7,26.71},{44.42,24.36},{43.51,25.53},{21.31,52.16},{28.25,45.7},{47.44,27.67},{44.97,26.51},{46.67,26.61},{44.21,26.53},},},nil,11,nil,nil,14,nil,},
[1033] = {'Monstrous Ooze',734,788,25,26,0,{[11]={{69.01,52.58},{70.17,51.14},{44.78,24.8},{44.5,24.91},{44.58,24.52},{62.55,35.13},{69.86,47.25},{67.08,42.93},{66.67,46.28},{67.87,46.66},{69.91,43.52},{64.87,36.91},{65.24,42.08},{43.86,25.48},{43.85,24.27},{44.03,24.68},{43.8,24.14},{43.98,25.25},},},nil,11,nil,nil,14,nil,},
[1034] = {'Dragonmaw Raider',635,684,26,27,0,{[11]={{45.83,45.42},{46.16,45.96},{46.1,45.61},{45.34,42.53},{46.61,46.55},{46.55,46.35},{46.32,46.44},{45.42,43.0},{45.11,42.6},{46.06,42.01},{47.02,48.35},{47.67,48.1},{47.37,47.33},{46.28,45.19},{47.42,47.26},{47.35,46.96},{46.26,43.26},{52.14,44.82},{50.49,48.24},{52.28,45.98},{51.17,46.24},{49.86,48.41},{51.12,47.34},{48.9,48.55},{46.79,45.31},{48.43,47.6},{39.47,46.97},{40.21,46.72},{45.34,43.49},{45.17,46.51},{44.63,46.37},{45.5,47.49},{41.0,39.96},{41.87,40.63},{42.37,43.47},{41.57,45.58},{40.99,45.47},{42.16,44.58},{41.01,46.43},{44.91,42.96},{42.42,42.65},{44.84,42.04},{42.53,39.93},{43.69,42.85},{44.12,43.1},{43.23,40.92},{44.1,43.58},{44.61,43.78},{43.7,43.46},{44.29,44.68},{44.8,45.35},{45.77,45.14},{44.93,44.7},{46.2,44.22},{47.68,44.94},{47.76,46.29},{47.14,46.14},},},nil,11,nil,nil,62,nil,},
[1035] = {'Dragonmaw Swamprunner',635,684,27,28,0,{[11]={{45.81,45.77},{50.11,46.72},{45.87,46.94},{45.39,42.87},{53.52,54.19},{47.91,48.62},{38.23,45.85},{38.52,46.27},{49.84,44.73},{50.38,44.47},{50.71,49.55},},},nil,11,nil,nil,62,nil,},
[1036] = {'Dragonmaw Centurion',600,640,28,29,0,{[11]={{49.5,46.13},{49.41,46.21},{53.43,54.12},{53.72,54.61},{52.52,53.61},{53.25,54.08},},},nil,11,nil,nil,62,nil,},
[1037] = {'Dragonmaw Battlemaster',684,734,30,30,4,{[11]={{45.34,44.41},},},nil,11,nil,nil,62,nil,},
[1038] = {'Dragonmaw Shadowwarder',519,554,28,29,0,{[11]={{49.63,46.43},{53.68,54.41},{53.95,54.41},{53.09,53.2},{52.54,53.88},{52.95,55.33},},},nil,11,nil,nil,62,nil,},
[1039] = {'Fen Dweller',494,531,20,21,0,{[11]={{62.37,59.48},{63.76,65.38},{60.17,50.76},{60.88,70.0},{17.15,41.98},{21.07,45.26},{29.45,28.1},{19.72,48.37},{22.75,45.11},{20.48,42.08},{60.1,61.81},{17.94,46.72},{32.02,27.33},{31.34,22.23},{16.61,41.36},{60.02,56.78},{16.07,47.69},},},nil,11,nil,nil,14,nil,},
[1040] = {'Fen Creeper',664,713,24,25,0,{[11]={{27.38,37.12},{33.01,25.67},{25.33,35.52},{46.41,29.19},{18.52,27.74},{23.58,32.0},{22.47,30.0},{25.85,31.87},{47.59,32.79},{27.15,39.15},{53.19,36.5},{54.98,37.16},{55.03,46.43},{54.0,41.37},{35.56,33.45},{40.64,32.92},{37.41,33.39},{20.79,28.35},{28.88,20.45},},},nil,11,nil,nil,14,nil,},
[1041] = {'Fen Lord',734,788,25,26,0,{[11]={{29.63,28.19},{32.25,26.74},{31.22,22.27},},},nil,11,nil,nil,14,nil,},
[1042] = {'Red Whelp',617,664,23,24,0,{[11]={{63.43,48.8},{63.65,50.85},{59.51,39.19},{64.31,52.0},{65.83,53.36},{62.72,51.64},{63.47,48.74},{66.74,54.24},{61.96,46.65},{60.37,40.47},{59.6,44.11},{59.76,40.89},{59.65,45.84},},},nil,11,nil,nil,60,nil,},
[1043] = {'Lost Whelp',582,622,24,25,0,{[11]={{66.5,48.51},{67.09,51.91},{64.21,47.56},{69.06,51.38},{68.08,50.69},{64.75,48.7},{65.12,49.49},{66.91,49.26},{65.91,51.16},{63.75,47.53},{67.45,52.47},{61.03,40.5},{61.79,40.1},{61.94,41.62},{62.4,44.22},{62.56,37.35},{59.54,32.7},{61.27,38.26},{62.23,45.79},{61.03,36.79},{60.87,44.31},},},nil,11,nil,nil,60,nil,},
[1044] = {'Flamesnorting Whelp',684,724,26,27,0,{[11]={{70.81,48.54},{70.36,45.01},{63.43,36.52},{64.16,37.9},{66.55,41.5},{71.6,47.43},{67.61,43.13},{66.57,42.86},{64.15,31.75},{64.26,39.68},},},nil,11,nil,nil,60,nil,},
[1045] = {'Red Dragonspawn',8352,8613,57,58,1,{[11]={{79.54,48.35},{78.75,47.32},},},nil,11,nil,nil,60,nil,},
[1046] = {'Red Wyrmkin',6891,7107,58,59,1,{[11]={{78.95,44.43},{77.93,46.27},{82.14,49.49},},},nil,11,nil,nil,60,nil,},
[1047] = {'Red Scalebane',8883,9156,59,60,1,{[11]={{85.5,49.98},{85.19,51.63},{85.89,50.65},{81.96,47.06},{81.14,48.48},{84.73,51.1},{83.69,49.53},{82.96,48.48},},},nil,11,nil,nil,60,nil,},
[1048] = {'Scalebane Lieutenant',9156,9432,60,61,1,{[11]={{88.52,62.93},{89.36,64.29},{86.94,52.51},{87.66,61.53},{86.22,53.09},{87.06,51.34},{87.65,64.04},},},nil,11,nil,nil,60,nil,},
[1049] = {'Wyrmkin Firebrand',7545,7770,61,62,1,{[11]={{86.96,53.5},{87.67,52.07},{89.18,56.76},{87.2,58.0},{88.41,60.44},{87.66,59.31},{88.77,58.23},{87.16,55.57},{88.33,56.21},{89.42,59.49},{87.6,56.56},},},{[11]={{87.61,56.53},{87.63,55.98},{87.64,55.52},{87.72,54.71},{87.76,53.68},{87.75,53.14},{87.5,52.65},{87.14,52.23},{86.72,51.77},{87.01,52.04},{87.37,52.49},{87.71,53.21},{87.75,53.84},{87.73,54.55},{87.64,55.48},{87.63,56.16},{87.65,56.94},{87.74,57.47},{87.97,57.88},{88.32,58.3},{88.41,58.88},{88.42,59.74},{88.28,60.48},{88.15,61.12},{88.29,60.55},{88.44,59.74},{88.42,59.08},{88.29,58.31},{88.02,57.91},{87.71,57.31},{87.67,56.77},},},11,nil,nil,60,nil,},
[1050] = {'Scalebane Royal Guard',9432,9711,61,62,1,{[11]={{86.63,69.51},{82.82,71.36},{85.41,67.82},{86.34,66.3},{87.65,66.32},{84.36,69.06},{86.07,70.5},{83.64,71.39},{82.02,69.25},{82.84,69.2},{87.12,65.43},{83.52,69.39},{86.98,66.95},{87.44,65.74},{84.57,71.11},{84.98,69.07},{82.01,71.38},},},nil,11,nil,nil,60,nil,},
[1051] = {'Dark Iron Dwarf',2400,2559,27,28,1,{[11]={{59.93,23.02},{48.05,17.3},{48.17,17.67},{48.87,17.44},{47.59,16.97},{47.19,15.69},{48.01,16.61},{48.47,16.19},{62.35,29.56},{63.02,29.57},{62.01,28.66},{49.03,17.11},{60.45,24.86},{59.81,25.32},{60.27,23.61},{59.49,23.77},},},nil,11,nil,nil,54,nil,},
[1052] = {'Dark Iron Saboteur',2559,2715,28,29,1,{[11]={{59.93,24.46},{61.88,25.98},{61.96,26.58},{62.05,27.57},{62.93,27.43},{63.27,28.78},{48.1,18.09},{48.12,18.62},{48.11,15.66},{47.06,17.1},{48.1,15.17},{47.67,16.13},{46.44,16.18},{46.74,17.21},{46.81,16.44},{50.85,8.24},{50.93,8.0},},},nil,11,nil,nil,54,nil,},
[1053] = {'Dark Iron Tunneler',2715,2865,29,30,1,{[11]={{60.27,24.3},{59.98,24.14},{60.11,24.64},{62.48,25.83},{61.53,26.17},{59.84,24.62},{61.95,25.44},{61.56,27.25},{47.98,18.85},{46.79,17.89},{47.03,18.45},{48.2,14.97},{47.55,15.46},{47.46,15.13},{46.08,16.6},{45.95,16.85},{45.65,16.85},{45.94,16.29},{46.26,16.59},{47.08,17.48},{47.11,17.92},{45.68,16.19},{46.88,18.1},},},{[11]={{46.06,16.62},{46.06,16.38},{45.98,16.18},{45.84,16.16},{45.65,16.24},{45.58,16.66},{45.82,16.89},{45.95,16.87},{46.03,16.73},},},11,nil,nil,54,nil,},
[1054] = {'Dark Iron Demolitionist',2865,3018,30,31,1,{[11]={{60.1,24.36},{62.0,26.08},{62.11,26.31},{61.83,26.57},{62.51,28.99},{62.18,28.01},{46.69,18.63},{46.57,18.63},{46.5,18.74},{47.39,14.99},{47.57,14.73},},},{[11]={{47.59,14.72},{47.59,14.78},{47.58,14.97},{47.57,15.15},{47.39,15.14},{47.56,15.14},{47.59,14.97},{47.59,14.78},{47.54,14.67},{47.44,14.69},{47.39,14.71},{47.45,15.05},{47.37,14.7},{47.44,14.7},{47.55,14.71},},},11,nil,nil,54,nil,},
[1057] = {'Dragonmaw Bonewarder',519,554,27,27,0,{[11]={{45.48,45.39},{45.99,45.81},{46.17,47.05},{46.57,47.17},{45.66,43.32},{45.62,42.48},{49.44,46.88},{47.78,47.43},{47.6,46.95},{49.85,45.68},{51.55,48.4},{49.87,47.83},{50.52,50.83},{51.4,50.81},{51.83,49.5},{48.92,46.83},{49.8,50.99},{48.64,46.04},{49.28,47.47},{49.12,45.19},},},nil,11,nil,nil,62,nil,},
[1059] = {'Ana\'thek the Cruel',2218,2218,45,45,0,{[33]={{44.3,45.0},},},nil,33,nil,nil,30,nil,},
[1060] = {'Mogh the Undying',4278,4278,44,44,1,{[33]={{47.74,44.25},},},nil,33,nil,nil,30,nil,},
[1061] = {'Gan\'zulah',1900,1900,41,41,4,{[33]={{23.44,8.12},},},nil,33,nil,nil,28,nil,},
[1062] = {'Nezzliok the Dire',1410,1410,40,40,0,{[33]={{23.52,9.53},},},nil,33,nil,nil,28,nil,},
[1063] = {'Jade',6467,6467,47,47,2,{[8]={{69.5,55.85},{69.89,53.89},},},nil,8,nil,nil,50,nil,},
[1064] = {'Grom\'gol Grunt',5317,5317,55,55,0,{[33]={{32.75,28.36},{32.74,28.83},{32.03,27.4},{31.75,27.76},{32.73,28.69},{32.12,27.39},{31.24,28.56},{31.13,28.36},{31.81,27.36},{32.5,28.58},{31.29,28.17},{31.13,28.54},},},{[33]={{31.26,28.51},{31.7,28.72},{32.12,28.83},{32.61,28.81},{32.41,28.67},{32.19,28.14},{32.11,27.58},{32.01,27.98},{31.6,28.18},{31.39,28.3},},},33,nil,nil,85,"H",},
[1065] = {'Riverpaw Shaman',230,253,13,13,0,{[40]={{41.65,20.79},},},nil,40,nil,nil,20,nil,},
[1068] = {'Gorn',2471,2471,40,40,0,{[3]={{2.91,45.6},},},nil,3,{782,793,},{782,793,},29,"H",},
[1069] = {'Crimson Whelp',603,681,25,26,0,{[11]={{63.67,35.32},{67.85,48.26},{67.7,45.03},{69.9,49.98},{63.64,42.06},{69.87,45.82},{62.96,37.39},{68.47,48.82},{68.84,51.0},{62.07,41.14},{63.69,40.2},{61.3,33.87},{61.99,33.13},{66.57,44.44},{65.99,45.94},{64.2,41.47},{65.95,44.51},{64.62,44.24},{62.04,34.76},{65.15,43.48},{62.89,36.48},{62.8,34.07},{68.09,46.28},{64.29,43.12},{64.61,42.2},{69.1,48.4},},},nil,11,nil,nil,60,nil,},
[1070] = {'Deputy Feldon',1846,1846,33,33,0,{[44]={{30.73,60.0},},},nil,44,{246,},{244,246,},11,"A",},
[1071] = {'Longbraid the Grim',2016,2016,35,35,0,{[11]={{49.8,18.26},},},nil,11,{304,},{304,472,},55,"A",},
[1072] = {'Roggo Harlbarrow',1605,1605,30,30,0,{[11]={{49.85,18.09},},},nil,11,nil,nil,55,"A",},
[1073] = {'Ashlan Stonesmirk',1380,1380,27,27,0,{[11]={{50.05,18.17},},},nil,11,{274,},{161,},55,"A",},
[1074] = {'Motley Garmason',1605,1605,30,30,0,{[11]={{49.67,18.23},},},nil,11,{303,378,},{303,378,},55,"A",},
[1075] = {'Rhag Garmason',1240,1240,25,25,0,{[11]={{49.92,18.22},},},nil,11,{631,633,634,},{632,633,},55,"A",},
[1076] = {'Merrin Rockweaver',1605,1605,30,30,0,{[11]={{38.91,52.34},},},nil,11,{306,},{305,},55,"A",},
[1077] = {'Prospector Whelgar',1605,1605,30,30,0,{[11]={{38.81,52.39},},},nil,11,{299,},{299,},55,"A",},
[1078] = {'Ormer Ironbraid',1240,1240,25,25,0,{[11]={{38.18,50.89},},},nil,11,{294,295,296,},{294,295,296,},55,"A",},
[1081] = {'Mire Lord',2476,2476,42,42,0,{[8]={{5.5,31.38},},},nil,8,nil,nil,14,nil,},
[1082] = {'Sawtooth Crocolisk',1604,1678,38,39,0,{[8]={{53.6,55.99},{56.07,56.47},{71.96,19.83},{69.84,18.63},{69.63,15.22},{72.15,15.27},{53.64,55.65},{56.12,56.77},{63.34,31.95},{62.29,30.27},{59.58,35.06},{60.49,32.19},{55.05,49.57},{56.56,48.02},{57.69,46.09},{56.53,52.28},{53.41,47.29},{53.5,42.39},{55.17,41.34},{48.41,39.12},{54.47,36.39},{56.54,34.56},{56.89,39.01},{47.55,43.03},{52.19,41.5},},},nil,8,nil,nil,16,nil,},
[1083] = {'Murloc Shorestriker',356,386,16,17,0,{[44]={{49.78,65.84},{48.33,71.55},{47.74,68.32},{48.82,70.1},{50.17,70.33},{50.95,69.33},{46.21,69.1},{47.29,66.22},{49.86,72.06},},},nil,44,nil,nil,18,nil,},
[1084] = {'Young Sawtooth Crocolisk',1403,1469,35,36,0,{[8]={{30.44,38.94},{35.72,36.86},{29.32,36.4},{31.09,33.79},{32.72,38.9},{25.53,35.95},{42.13,34.43},{38.61,35.27},{24.61,42.55},{32.0,47.18},{24.57,39.23},{34.09,33.01},{27.1,55.13},{37.61,51.23},{34.41,51.77},{25.88,52.18},{24.1,50.33},{30.32,54.77},{28.6,55.96},{23.26,44.94},},},nil,8,nil,nil,16,nil,},
[1085] = {'Elder Stranglethorn Tiger',1279,1342,34,35,0,{[33]={{33.97,19.43},{36.04,18.86},{35.52,18.47},{35.02,19.2},{35.46,19.73},{32.43,18.44},{31.31,18.21},{33.53,18.31},{34.02,17.57},{32.09,18.99},{32.91,19.02},{31.51,20.14},{31.29,16.62},{31.94,16.08},},},nil,33,nil,nil,16,nil,},
[1087] = {'Sawtooth Snapper',1902,1981,41,42,0,{[8]={{76.75,5.84},{72.57,99.97},{83.8,95.42},{76.42,0.4},{79.68,7.38},{83.36,36.28},{77.97,14.56},{77.03,13.18},{75.53,19.4},{78.03,19.92},{75.11,14.55},{78.01,23.26},{86.55,34.09},{82.66,30.88},{80.99,19.79},{86.23,19.98},{84.25,15.29},{79.44,26.73},{77.98,28.41},{81.22,23.68},{79.74,30.56},{81.26,32.72},{84.07,33.3},{87.32,38.59},{76.27,97.38},{80.59,96.77},{82.58,99.54},{78.14,99.99},{82.79,12.33},{82.48,26.06},{86.67,56.18},{83.97,64.79},{85.38,63.35},},},nil,8,nil,nil,16,nil,},
[1088] = {'Monstrous Crawler',1716,1782,43,44,0,{[8]={{73.8,98.46},{91.38,19.73},{93.67,62.3},{93.13,69.93},{92.77,30.05},{94.09,32.69},{95.96,46.26},{78.94,98.14},{94.98,56.08},{93.57,35.53},{79.33,2.37},},},nil,8,nil,nil,7,"AH",},
[1089] = {'Mountaineer Cobbleflint',1605,1605,30,30,0,{[38]={{22.07,73.13},},},nil,38,{224,},{224,},55,"A",},
[1090] = {'Mountaineer Wallbang',1605,1605,30,30,0,{[38]={{23.47,74.51},},},nil,38,{263,},{263,},55,"A",},
[1091] = {'Mountaineer Gravelgaw',1605,1605,30,30,0,{[38]={{23.54,76.4},},},nil,38,{237,},{237,},55,"A",},
[1092] = {'Captain Rugelfuss',2471,2471,40,40,0,{[38]={{23.23,73.68},},},nil,38,{217,267,},{217,267,},55,"A",},
[1093] = {'Chief Engineer Hinderweir VII',1635,1635,40,40,0,{[38]={{46.05,13.61},},},nil,38,{161,250,278,280,},{199,274,278,283,},55,"A",},
[1094] = {'Venture Co. Miner',1279,1342,34,35,0,{[33]={{28.76,6.85},{27.81,7.76},{28.88,6.79},{28.93,7.65},{28.66,7.93},{28.94,7.37},{29.34,7.4},{29.14,7.22},{27.12,7.97},{27.22,7.45},{28.22,8.04},{28.32,8.15},},},nil,33,nil,nil,47,nil,},
[1095] = {'Venture Co. Workboss',1469,1469,36,36,0,{[33]={{43.11,19.01},},},nil,33,nil,nil,47,nil,},
[1096] = {'Venture Co. Geologist',1160,1208,34,36,0,{[33]={{28.86,6.9},{28.75,7.62},{28.67,7.69},{47.72,18.96},{46.75,19.21},{44.67,22.17},{42.68,18.35},{44.23,20.09},{43.08,19.51},{43.16,19.32},{43.04,19.06},{45.98,18.43},{44.0,21.05},{44.91,23.58},{45.13,23.67},{44.81,22.69},{46.35,22.81},{46.49,23.89},{43.79,23.15},{44.49,20.6},{45.17,20.36},{46.92,19.85},{43.17,20.91},{43.57,22.4},{42.4,18.56},{45.42,20.79},{44.24,18.63},{43.49,23.48},{42.69,23.09},{42.35,22.22},{27.62,8.09},{42.62,18.57},{42.46,19.1},{46.3,21.43},{46.43,20.66},{45.89,19.61},{44.47,17.58},{44.76,16.42},{43.96,17.44},{44.82,16.32},},},nil,33,nil,nil,47,nil,},
[1097] = {'Venture Co. Mechanic',1279,1342,34,35,0,{[33]={{28.63,7.6},{43.04,19.31},{43.13,19.23},{42.64,18.56},{42.16,18.72},{42.05,18.29},{42.5,18.52},},},nil,33,nil,nil,47,nil,},
[1098] = {'Watcher Merant',484,484,20,20,0,nil,nil,0,nil,nil,56,"A",},
[1099] = {'Watcher Gelwin',484,484,20,20,0,nil,nil,0,nil,nil,56,"A",},
[1100] = {'Watcher Selkin',484,484,20,20,0,nil,nil,0,nil,nil,56,"A",},
[1101] = {'Watcher Thayer',484,484,20,20,0,nil,nil,0,nil,nil,56,"A",},
[1103] = {'Eldrin',1042,1042,22,22,0,{[12]={{79.22,69.03},},},nil,12,nil,nil,12,"A",},
[1104] = {'Grundel Harkin',166,166,5,5,0,{[1]={{28.79,67.84},},},nil,1,nil,nil,55,"A",},
[1105] = {'Jern Hornhelm',644,644,15,15,0,{[38]={{37.24,47.38},},},nil,38,{273,301,436,},{298,302,},55,"A",},
[1106] = {'Lost One Cook',1257,1257,37,37,4,{[8]={{65.23,22.8},{63.98,22.8},{62.5,23.31},{61.82,21.85},{60.93,24.28},{62.39,20.9},},},nil,8,nil,nil,51,nil,},
[1108] = {'Mistvale Gorilla',1427,1498,32,33,0,{[33]={{36.58,16.75},{39.22,17.66},{38.75,18.27},{38.28,15.74},{38.74,16.83},{37.5,16.8},{36.66,18.33},{37.66,18.3},{37.29,16.18},{37.23,17.76},{38.04,17.59},},},nil,33,nil,nil,72,nil,},
[1109] = {'Fleshripper',273,300,13,14,0,{[40]={{51.15,24.91},{40.47,68.07},{40.37,66.81},{40.18,67.56},{38.22,34.54},{39.06,25.04},{39.85,24.03},{29.93,38.28},{36.16,38.04},{33.09,36.84},{39.19,29.28},{35.48,41.2},{61.13,46.17},{60.68,43.63},{59.81,46.68},{39.66,39.82},{41.86,39.18},{39.47,38.49},{39.31,42.04},{46.89,51.27},{48.74,50.79},{44.72,53.71},{48.43,54.83},{50.22,61.85},{52.32,59.1},{55.71,60.94},{36.95,69.07},{39.02,62.32},{40.13,59.2},{35.17,65.0},{37.54,65.96},{39.64,62.08},{40.93,59.67},{39.93,42.9},{43.22,49.08},{42.75,50.78},{45.74,63.68},{43.56,46.37},{45.88,45.42},{43.59,43.8},{43.94,42.04},{39.82,68.15},{39.74,66.96},{33.32,39.22},{49.43,56.35},{50.46,59.17},{50.51,62.26},{45.83,63.51},},},nil,40,nil,nil,73,nil,},
[1110] = {'Skeletal Raider',840,895,27,28,0,{[10]={{16.89,31.34},{15.26,33.59},{17.16,34.94},{17.22,33.56},{17.38,33.36},{16.37,38.55},{15.15,36.85},{17.45,34.22},{14.37,36.21},{15.37,39.2},{16.13,39.47},{15.2,38.31},{15.78,38.02},{17.72,32.66},{17.56,37.0},{18.14,39.42},},},{[10]={{17.56,37.0},{17.45,37.77},{17.93,38.29},{18.83,38.37},{19.34,38.55},{20.28,40.91},{19.34,38.55},{18.83,38.37},{17.93,38.29},{17.45,37.77},{18.14,39.42},{18.7,39.55},{18.99,39.8},{19.22,39.82},{18.77,40.53},{17.55,40.96},{18.77,40.53},{19.22,39.82},{18.99,39.8},{18.7,39.55},},[40]={{75.93,42.11},{75.84,42.71},{76.21,43.11},{76.91,43.17},{77.3,43.31},{78.03,45.13},{77.3,43.31},{76.91,43.17},{76.21,43.11},{75.84,42.71},{76.37,43.98},{76.81,44.08},{77.03,44.27},{77.21,44.29},{76.86,44.84},{75.92,45.17},{76.86,44.84},{77.21,44.29},{77.03,44.27},{76.81,44.08},},},10,nil,nil,21,nil,},
[1111] = {'Leech Stalker',531,573,21,22,0,{[11]={{50.03,58.81},{55.31,63.74},{53.79,65.22},{53.01,65.36},{50.28,60.95},{56.98,62.81},{57.32,66.53},{54.72,64.72},{54.78,66.66},{54.82,66.56},{56.69,61.69},{57.27,65.34},{56.13,67.94},{56.26,65.43},{55.54,62.97},{56.18,60.94},{54.79,62.79},{54.04,63.31},{55.96,61.6},{52.4,62.81},{52.66,63.02},{51.71,63.02},{51.15,61.84},{51.56,62.13},{49.01,62.72},{50.36,62.9},{49.01,61.42},{50.26,59.57},{47.92,59.84},{46.2,59.39},{46.46,62.04},{46.76,63.57},{46.92,62.9},{46.09,62.26},{46.82,61.97},},},nil,11,nil,nil,22,nil,},
[1112] = {'Leech Widow',664,664,24,24,4,{[11]={{47.27,59.22},},},nil,11,nil,nil,22,nil,},
[1114] = {'Jungle Thunderer',1804,1883,37,38,0,{[33]={{49.14,35.39},{48.62,37.93},{41.76,24.44},{42.33,28.46},{46.48,36.5},{43.92,30.9},{46.6,34.72},{44.47,27.21},{43.46,31.72},{46.09,34.18},{44.07,32.27},{44.65,36.39},{47.08,37.22},{48.09,37.16},{48.6,36.22},{49.25,34.04},{42.8,30.98},{42.26,31.87},{46.09,29.57},{43.41,28.71},{43.04,26.2},{43.0,27.68},{42.34,27.05},{41.79,26.01},{40.75,26.01},{48.17,32.72},{49.22,32.42},{44.98,29.34},{44.96,27.81},{45.48,28.63},{40.79,28.13},{44.53,28.66},{41.22,28.53},{48.1,34.02},{41.87,27.6},{41.9,32.59},{41.89,30.94},{44.37,37.84},{45.53,36.55},{48.2,35.71},{47.68,38.04},{45.57,34.86},},},nil,33,nil,nil,72,nil,},
[1115] = {'Rockjaw Skullthumper',156,176,8,9,0,{[1]={{67.09,59.71},{67.18,58.58},{67.55,59.51},{67.55,60.18},{69.65,57.08},{70.81,53.95},{70.05,52.73},{70.32,53.27},{70.3,57.14},{69.96,57.85},{69.81,58.25},{69.4,58.32},{69.55,58.81},{70.49,57.12},{70.95,55.98},{68.63,58.08},{67.93,60.54},{68.69,59.72},{68.95,59.35},{68.88,59.8},{67.35,59.67},{68.0,59.35},{67.94,60.74},{70.51,58.88},{70.34,59.29},{70.51,58.37},{70.5,58.49},{71.18,55.29},{70.99,55.24},{71.14,53.9},{70.71,52.56},{72.49,53.47},{72.16,52.25},{71.59,51.82},{71.39,51.61},{72.63,52.41},{71.18,50.58},{71.54,51.56},{72.25,50.99},{71.49,50.29},{72.9,52.69},{72.44,51.0},{72.65,51.86},{73.23,52.02},{73.23,53.32},},},{[1]={{67.95,60.74},{68.0,60.69},{68.19,60.59},{68.14,60.29},{68.19,60.59},{67.99,60.7},{67.9,60.77},{67.72,60.83},{67.53,60.73},{67.72,60.83},{67.9,60.77},},},1,nil,nil,59,nil,},
[1116] = {'Rockjaw Ambusher',176,198,9,10,0,{[1]={{70.79,53.08},{70.35,52.31},{72.1,55.02},{71.33,54.29},{70.95,53.29},{72.58,53.85},{73.52,52.8},{73.41,51.31},{73.93,51.52},{72.61,55.85},{73.41,55.08},{75.75,58.76},{77.25,59.8},{77.21,58.29},{75.65,57.72},{74.94,56.64},{74.74,56.43},{74.46,56.18},},},nil,1,nil,nil,59,nil,},
[1117] = {'Rockjaw Bonesnapper',176,198,9,10,0,{[1]={{70.6,55.3},{70.63,54.61},{70.41,53.27},{70.22,52.69},{70.73,53.3},{70.97,54.61},{70.67,56.64},{71.18,55.62},{71.15,52.71},{70.59,52.6},{70.95,53.3},{70.45,52.32},{70.36,52.2},{70.77,52.37},{72.41,52.9},{71.99,52.16},{71.8,52.36},{71.73,52.16},{71.69,51.27},{71.94,50.54},{71.59,50.33},{72.9,52.16},{72.16,50.71},{72.55,51.44},{72.03,49.94},{71.92,50.28},{72.45,51.53},{72.94,54.14},{75.7,61.81},{76.17,60.3},{77.04,60.85},{78.0,58.96},{78.14,59.58},{74.69,56.29},{74.98,56.16},{74.66,55.93},{79.63,55.1},{79.64,54.56},{79.65,53.99},{79.76,58.05},{78.83,58.77},{78.44,60.13},{77.33,59.54},},[38]={{0.45,73.09},},},{[1]={{70.96,53.31},{71.05,53.65},{71.22,53.93},{71.46,54.24},{71.78,54.47},{72.09,54.58},{72.48,54.51},{72.83,54.3},{73.09,54.05},{73.3,53.69},{73.41,53.32},{73.48,52.88},{73.55,52.39},{73.6,51.97},{73.63,51.53},{73.65,51.14},{73.61,51.63},{73.58,52.19},{73.49,52.74},{73.4,53.22},{73.34,53.6},{73.17,53.89},{72.93,54.22},{72.61,54.34},{72.28,54.36},{72.05,54.3},{71.8,54.21},{71.57,54.11},{71.28,53.92},{71.07,53.66},{70.77,52.36},{70.72,52.48},{70.6,52.65},{70.69,52.84},{70.89,52.76},{71.11,52.64},{71.21,52.61},{71.25,52.76},{71.1,52.92},{70.94,53.03},{70.77,53.15},{70.57,53.23},{70.8,53.13},{70.93,53.04},{71.1,52.91},{71.22,52.77},{71.24,52.58},{71.08,52.66},{70.89,52.75},{70.76,52.81},{70.62,52.79},{70.61,52.66},{70.71,52.53},{71.95,50.54},{71.99,50.24},{71.94,50.57},{71.84,50.78},{71.76,50.93},{71.66,51.14},{71.6,51.25},{71.5,51.47},{71.33,51.83},{71.24,51.96},{71.12,52.09},{70.95,52.18},{71.1,52.08},{71.22,51.97},{71.33,51.82},{71.43,51.63},{71.53,51.43},{71.61,51.24},{71.77,50.91},{71.85,50.76},{72.45,51.54},{72.5,51.87},{72.54,52.21},{72.57,52.45},{72.54,52.11},{72.49,51.8},{72.44,51.54},{72.33,51.27},{72.21,51.02},{72.1,50.84},{71.96,50.67},{71.82,50.58},{71.66,50.49},{71.47,50.39},{71.32,50.44},{71.46,50.38},{71.64,50.45},{71.78,50.57},{71.97,50.77},{72.09,50.9},{72.17,51.0},{72.35,51.27},{72.4,51.35},{77.33,59.54},{77.59,59.61},{77.78,59.63},{78.1,59.64},{78.29,59.6},{78.59,59.47},{78.7,59.2},{78.88,58.99},{79.07,58.79},{79.11,58.51},{79.18,58.14},{79.39,57.95},{79.54,58.05},{79.37,57.96},{79.16,58.07},{79.11,58.42},{79.09,58.79},{78.95,58.95},{78.77,59.09},{78.65,59.43},{78.44,59.6},{78.23,59.63},{77.97,59.64},{77.68,59.62},{77.38,59.56},{77.16,59.51},{76.96,59.4},{76.77,59.22},{76.57,58.94},{76.39,58.67},{76.27,58.49},{76.08,58.23},{76.18,58.37},{76.3,58.55},{76.46,58.75},{76.63,58.96},{76.79,59.16},{76.92,59.3},{77.11,59.45},},[38]={{0.45,73.09},{0.92,73.22},{1.26,73.25},{1.83,73.26},{2.18,73.2},{2.71,72.97},{2.91,72.49},{3.23,72.11},{3.57,71.75},{3.64,71.25},{3.76,70.59},{4.13,70.25},{4.41,70.42},{4.1,70.27},{3.73,70.46},{3.63,71.08},{3.61,71.74},{3.36,72.03},{3.02,72.28},{2.82,72.88},{2.44,73.19},{2.07,73.25},{1.6,73.26},{1.08,73.22},{0.55,73.11},{0.16,73.04},{0.06,72.93},},},1,nil,nil,59,nil,},
[1118] = {'Rockjaw Backbreaker',222,247,11,12,0,{[1]={{79.38,54.11},{79.5,55.67},{79.35,54.7},{79.64,54.4},{80.52,57.1},{79.39,57.77},},},nil,1,nil,nil,59,nil,},
[1119] = {'Hammerspine',321,321,12,12,4,{[1]={{71.45,51.29},},},nil,1,nil,nil,59,nil,},
[1120] = {'Frostmane Troll',137,156,7,8,0,{[1]={{26.17,49.91},{26.06,51.29},{26.08,51.5},{25.36,51.08},{25.85,52.85},{26.69,51.43},{26.7,52.13},{66.53,41.06},{66.53,41.06},{70.61,39.31},{71.05,37.86},},},nil,1,nil,nil,37,nil,},
[1121] = {'Frostmane Snowstrider',148,166,8,9,0,{[1]={{25.38,50.07},{26.17,51.35},{26.09,50.61},{25.37,52.05},{23.65,51.43},{23.14,52.01},{22.62,50.46},{21.59,50.83},{22.87,54.49},{41.27,44.19},{41.56,36.64},{41.9,35.82},{40.75,35.12},{38.99,35.19},{66.38,41.06},{66.38,41.06},{70.52,39.3},{70.96,38.09},},},{[1]={{21.59,50.83},{21.71,50.64},{21.78,50.51},{22.01,50.32},{22.21,50.3},{22.37,50.39},{22.56,50.47},{22.72,50.56},{22.53,50.46},{22.29,50.33},{22.11,50.27},{21.95,50.32},{21.8,50.47},{21.71,50.65},{21.61,50.81},{21.38,51.08},{21.24,51.31},{21.18,51.56},{21.18,51.81},{21.18,52.02},{21.23,52.38},{21.28,52.58},{21.32,52.8},{21.34,53.06},{21.28,53.29},{21.35,53.08},{21.32,52.8},{21.27,52.57},{21.24,52.41},{21.19,52.06},{21.18,51.77},{21.22,51.46},{21.27,51.26},{21.48,50.95},},},1,nil,nil,37,nil,},
[1122] = {'Frostmane Hideskinner',176,198,9,10,0,{[1]={{23.91,52.23},{23.81,53.57},{22.78,52.03},{21.98,51.29},{21.61,50.64},{21.39,53.07},{21.71,52.95},{21.63,54.76},{21.93,54.97},{23.22,54.81},{23.46,53.86},{23.1,50.89},},},{[1]={{23.1,50.89},{22.9,50.66},{22.74,50.52},{22.52,50.38},{22.3,50.29},{22.11,50.26},{21.92,50.3},{21.74,50.46},{21.61,50.59},{21.39,50.87},{21.28,51.07},{21.18,51.35},{21.16,51.61},{21.18,51.91},{21.24,52.31},{21.27,52.52},{21.33,52.84},{21.32,53.06},{21.28,53.3},{21.22,53.49},{21.18,53.75},{21.21,53.98},{21.25,54.22},{21.29,54.36},{21.4,54.57},{21.49,54.63},{21.67,54.75},{21.84,54.84},{22.02,54.9},{22.2,54.9},{22.35,54.86},{22.46,54.8},{22.62,54.68},{22.76,54.56},{22.91,54.44},{23.11,54.25},{23.19,54.18},{23.37,54.01},{23.44,53.94},{23.58,53.82},{23.66,53.74},{23.78,53.63},{23.86,53.5},{23.96,53.3},{24.1,52.97},{24.12,52.76},{24.12,52.52},{24.07,52.34},{23.97,52.19},{23.91,52.1},{23.87,51.97},{23.8,51.72},{23.76,51.61},{23.66,51.47},{23.55,51.39},{23.39,51.28},{23.31,51.2},{23.18,51.05},},},1,nil,nil,37,nil,},
[1123] = {'Frostmane Headhunter',156,176,8,9,0,{[1]={{25.99,51.49},{26.15,51.45},{23.42,51.4},{25.5,50.86},{23.17,50.88},{23.57,50.93},{24.29,50.88},{24.6,50.94},{26.03,52.2},{23.9,53.25},{22.03,50.13},{22.37,51.78},{21.17,50.95},{21.07,51.63},{21.25,54.48},{22.63,54.62},{40.94,43.84},{39.34,35.87},},},{[1]={{22.37,51.78},{22.2,52.02},{22.12,52.23},{22.0,52.55},{22.1,52.29},{22.18,52.11},{22.25,51.97},{22.37,51.79},{22.5,51.77},{22.63,51.85},{22.75,51.99},{22.8,52.11},{22.83,52.18},{22.88,52.38},{23.0,52.54},{23.13,52.59},{23.3,52.52},{23.4,52.39},{23.46,52.3},{23.32,52.51},{23.13,52.59},{22.96,52.52},{22.89,52.38},{22.81,52.16},{22.71,51.95},{22.53,51.81},{40.94,43.84},{41.2,43.88},{41.5,43.84},{41.59,43.76},{41.66,43.52},{41.59,43.82},{41.56,44.2},{41.65,44.35},{41.81,44.44},{41.91,44.48},{42.14,44.62},{42.21,44.64},{42.13,44.79},{42.03,45.12},{41.9,45.43},{41.76,45.69},{41.7,45.79},{41.55,45.68},{41.43,45.58},{41.33,45.48},{41.22,45.39},{41.13,45.28},{41.03,45.15},{40.87,44.93},{40.87,44.75},{40.93,44.58},{40.97,44.34},{41.01,44.02},},},1,nil,nil,37,nil,},
[1124] = {'Frostmane Shadowcaster',160,178,9,10,0,{[1]={{26.0,51.14},{23.26,52.55},{22.38,50.24},{21.63,52.17},{22.11,52.35},{21.09,53.57},{22.83,53.84},{66.46,41.14},{66.46,41.14},{70.58,39.2},{70.9,37.84},},},{[1]={{66.3,41.26},{66.2,41.25},{65.95,41.27},{66.05,41.27},{66.15,41.45},{66.11,41.38},{66.18,41.3},{66.32,41.29},{66.52,41.33},{66.78,41.2},{67.33,41.24},{67.65,41.24},{67.95,41.32},{68.26,41.38},{69.5,40.6},{66.3,41.26},{66.2,41.25},{65.95,41.27},{66.05,41.27},{66.15,41.45},{66.11,41.38},{66.18,41.3},{66.32,41.29},{66.52,41.33},{67.89,42.15},{68.12,42.17},{68.37,42.34},{69.03,42.5},{69.71,41.53},{69.81,41.34},{70.58,39.2},{71.04,38.03},},},1,nil,nil,37,nil,},
[1125] = {'Crag Boar',102,120,5,6,0,{[1]={{48.1,49.07},{45.71,50.24},{48.47,50.51},{45.77,57.02},{46.05,59.05},{48.57,58.65},{48.5,60.13},{47.38,61.23},{44.91,62.06},{45.91,61.73},{47.66,64.05},{45.39,64.15},{46.21,63.83},{44.28,63.19},{45.68,65.96},{45.07,65.35},{44.36,67.14},{43.31,66.31},{42.4,66.8},{42.16,67.58},{39.34,64.32},{38.62,64.58},{36.5,63.04},{36.16,62.15},{36.63,59.96},{34.99,59.6},{36.48,62.95},{37.85,59.76},{39.36,63.38},{39.92,67.84},{49.05,54.75},{45.48,50.59},{30.99,53.67},{30.05,54.35},{32.67,57.11},{31.35,57.91},{34.42,57.17},{34.72,58.43},{33.66,59.49},{45.45,49.98},{44.24,52.89},{42.35,56.82},{43.94,55.83},{43.39,55.89},{43.07,56.43},{44.0,55.6},{44.76,57.58},{41.18,58.3},{39.49,57.78},{41.88,60.37},{40.46,60.5},{39.18,59.52},{42.36,65.43},{43.31,65.82},{44.76,65.61},{46.11,64.48},{45.35,64.04},{44.24,59.37},{42.31,59.92},{46.2,61.95},{46.58,59.35},{47.11,61.47},{48.67,62.87},{46.24,65.39},{49.71,61.8},{49.19,59.3},{49.44,50.48},{49.31,50.33},{50.11,51.88},{51.45,53.33},{51.27,51.12},{50.99,52.29},{51.81,58.52},{40.67,68.3},},},nil,1,nil,nil,189,"AH",},
[1126] = {'Large Crag Boar',120,137,6,7,0,{[1]={{45.23,45.32},{45.36,41.69},{48.1,47.25},{48.03,56.69},{47.26,63.92},{48.08,47.01},{50.38,43.24},{45.28,41.75},{45.06,41.59},{43.51,38.02},{43.5,34.3},{43.91,29.7},{41.22,30.54},{34.33,55.63},{36.39,54.22},{35.64,54.71},{37.28,52.73},{36.33,52.17},{36.98,51.05},{38.12,51.13},{38.14,50.98},{38.66,48.64},{39.57,46.9},{39.15,48.12},{38.56,46.73},{41.65,39.53},{45.19,45.33},{41.22,47.18},{49.44,62.61},{49.5,58.45},{48.42,56.76},{49.25,54.76},{48.48,47.33},{50.49,52.07},{50.53,60.0},{56.82,52.67},{56.16,47.74},{55.9,47.8},{58.72,54.08},{65.35,50.23},{64.16,53.9},{62.39,55.14},{59.77,55.26},{66.97,50.31},},},nil,1,nil,nil,189,"AH",},
[1127] = {'Elder Crag Boar',137,156,7,8,0,{[1]={{45.38,42.85},{45.2,42.16},{45.32,42.57},{44.18,32.04},{43.58,29.62},{42.07,30.0},{40.06,30.54},{39.48,33.99},{36.99,34.34},{37.37,35.63},{36.79,31.17},{35.47,34.95},{34.63,31.47},{33.86,31.09},{34.11,35.23},{32.39,34.4},{33.14,37.54},{31.71,38.72},{31.02,35.7},{30.13,38.39},{29.2,39.98},{27.55,39.31},{26.72,42.94},{26.25,44.74},{25.95,46.41},{27.49,45.74},{26.62,55.08},{27.53,53.94},{28.31,53.34},{27.73,47.37},{28.03,42.69},{28.36,44.29},{29.59,42.45},{32.23,47.09},{29.59,49.68},{32.11,48.83},{32.0,49.8},{30.14,51.94},{37.72,51.88},{40.46,47.22},{37.83,45.95},{33.52,48.02},{35.57,36.8},{37.52,37.36},{42.36,38.9},{53.36,58.16},{55.56,57.37},{55.51,57.38},{55.77,58.99},{56.56,60.04},{55.66,55.76},{56.68,54.3},{55.31,54.33},{57.92,50.43},{58.23,51.29},{59.21,50.06},{60.81,53.9},{61.3,56.71},{59.02,57.88},{57.32,56.67},{58.48,59.72},{59.57,60.06},{58.72,58.88},{59.94,58.56},{61.44,58.37},{60.93,60.25},{63.08,59.19},{62.78,56.15},{63.87,60.45},{66.14,53.3},{66.17,52.72},{67.43,51.66},{68.68,51.72},{66.8,49.35},{71.54,55.61},{70.82,51.57},{70.52,51.98},{69.72,50.17},{73.5,52.1},{72.43,60.98},{70.7,61.62},{74.66,61.34},{73.39,48.69},{75.76,48.21},{79.21,57.25},{80.21,46.26},{79.82,43.27},{81.48,35.63},},},nil,1,nil,nil,189,"AH",},
[1128] = {'Young Black Bear',122,144,5,6,0,{[1]={{45.39,49.35},{44.89,50.16},{44.75,55.26},{45.56,58.22},{41.9,66.79},{38.85,61.96},{38.67,61.09},{35.54,60.0},{34.44,59.5},{39.05,60.52},{45.28,58.12},{48.1,49.92},{30.37,55.63},{32.34,56.05},{30.76,57.22},{32.47,57.87},{43.73,44.88},{43.07,45.9},{44.27,47.81},{44.23,50.95},{43.74,51.9},{45.04,55.2},{43.52,58.95},{39.86,60.86},{40.47,60.81},{41.56,59.9},{39.62,59.06},{41.7,60.9},{48.12,49.88},{49.17,51.0},{50.55,51.77},{65.48,12.7},{65.56,12.72},},[11]={{24.98,77.87},{25.08,77.89},},},nil,1,nil,nil,44,nil,},
[1129] = {'Black Bear',144,164,6,6,0,{[1]={{65.43,12.89},},[11]={{24.93,78.09},},},nil,1,nil,nil,44,nil,},
[1130] = {'Bjarn',247,247,12,12,4,{[1]={{55.64,58.51},{62.57,58.45},{59.45,58.43},{52.83,58.52},},},nil,1,nil,nil,44,nil,},
[1131] = {'Winter Wolf',137,156,7,8,0,{[1]={{45.69,42.3},{45.08,43.31},{45.99,47.19},{45.9,47.09},{48.92,44.61},{45.58,42.15},{45.09,41.82},{44.88,42.36},{33.47,43.61},{33.83,43.65},{33.97,41.29},{33.96,42.23},{34.58,42.24},{33.99,42.8},{33.95,41.02},{34.51,41.32},{44.93,41.41},{45.77,47.21},{43.25,47.06},{49.01,44.62},{50.96,44.95},{51.61,46.41},{52.06,48.65},{51.54,49.62},{50.68,52.54},},},nil,1,nil,nil,38,nil,},
[1132] = {'Timber',198,198,10,10,4,{[1]={{34.21,41.79},{33.5,43.75},{34.11,42.56},},},nil,1,nil,nil,38,nil,},
[1133] = {'Starving Winter Wolf',156,176,8,9,0,{[1]={{34.2,41.86},{34.16,41.76},},},nil,1,nil,nil,38,nil,},
[1134] = {'Young Wendigo',102,120,5,6,0,{[1]={{39.18,49.31},{40.25,46.16},{43.03,54.87},{42.89,55.25},{42.78,55.19},{42.59,55.53},{42.12,55.48},{42.94,54.63},{42.57,55.42},{42.49,54.97},{42.12,54.81},{41.92,55.17},{41.8,54.59},{41.96,55.35},},},nil,1,nil,nil,24,nil,},
[1135] = {'Wendigo',120,137,6,7,0,{[1]={{39.69,48.69},{39.42,48.12},{39.7,47.71},{39.32,47.36},{39.05,48.8},{38.88,48.39},{40.26,47.78},{39.93,47.24},{40.5,46.63},{40.52,46.89},{39.19,46.44},{42.07,46.28},{41.12,47.17},{41.28,45.37},{42.71,46.84},{42.24,46.08},{43.57,49.61},{43.17,48.88},{43.29,49.2},{42.33,49.24},{42.68,49.19},{42.75,49.93},{43.04,50.01},{42.22,48.55},{42.03,46.97},{42.14,47.69},{42.19,46.51},{41.57,48.98},{41.9,46.0},{41.95,45.97},{41.99,48.39},{40.99,45.63},{41.86,45.21},{42.24,53.48},{42.2,52.56},{42.71,51.88},{42.4,55.2},{41.93,54.04},{41.98,51.47},{42.61,50.41},{40.21,53.25},{41.39,51.09},{41.18,50.63},{41.1,49.52},{41.25,49.36},{40.96,49.23},{41.6,48.35},{41.15,50.55},{41.16,49.29},{41.89,51.5},{42.3,52.01},{42.19,53.36},{42.18,52.6},{42.68,51.82},{41.92,52.74},{42.46,53.68},{41.09,49.82},{42.46,54.52},},},{[1]={{39.32,47.37},{39.5,47.4},{39.72,47.42},{39.54,47.41},{39.32,47.37},{39.12,47.31},{38.99,47.18},{38.91,46.97},{38.98,47.16},{39.15,47.3},{39.25,47.35},{39.19,46.44},{39.29,46.3},{39.43,46.18},{39.58,46.13},{39.73,46.1},{39.85,46.1},{39.96,46.12},{40.06,46.15},{39.93,46.11},{39.75,46.12},{39.56,46.15},{39.42,46.22},{39.31,46.29},{42.07,46.28},{42.13,46.59},{42.15,46.88},{42.15,47.09},{42.15,47.34},{42.13,47.55},{42.09,47.84},{42.14,47.52},{42.15,47.35},{42.15,47.03},{42.15,46.82},{42.12,46.58},{42.08,46.29},{42.01,46.14},{41.8,45.79},{41.94,46.02},{41.12,47.17},{40.96,47.15},{40.8,47.06},{40.6,46.9},{40.47,46.72},{40.37,46.51},{40.51,46.8},{40.7,46.99},{40.89,47.14},{40.98,47.15},{40.99,45.63},{40.87,45.77},{40.72,45.94},{40.62,46.1},{40.54,46.28},{40.5,46.47},{40.46,46.68},{40.43,46.85},{40.39,47.05},{40.35,47.26},{40.31,47.46},{40.29,47.65},{40.27,47.81},{40.29,47.62},{40.32,47.44},{40.35,47.24},{40.39,47.04},{40.43,46.83},{40.46,46.66},{40.5,46.45},{40.54,46.27},{40.63,46.08},{40.74,45.92},{40.88,45.75},{41.38,51.09},{41.3,50.93},{41.21,50.71},{41.19,50.67},{41.26,50.85},{41.37,51.05},{41.45,51.19},{41.58,51.32},{41.66,51.37},{41.8,51.44},{41.87,51.47},{42.02,51.58},{42.23,51.75},{42.01,51.57},{41.87,51.47},{41.67,51.39},{41.54,51.28},{41.47,51.23},{41.6,48.36},{41.51,48.53},{41.42,48.77},{41.37,48.96},{41.29,49.26},{41.2,49.55},{41.15,49.75},{41.11,49.91},{41.12,50.19},{41.12,49.86},{41.14,49.71},{41.2,49.51},{41.29,49.21},{41.36,48.98},{41.41,48.82},{41.47,48.61},{41.57,48.4},{41.69,48.26},{41.9,48.06},{41.76,48.2},{47.05,41.77},{47.24,41.69},{47.53,41.63},{47.79,41.59},{48.07,41.59},{48.21,41.52},{48.21,41.1},{48.08,41.0},{48.21,41.1},{48.21,41.52},{48.07,41.59},{47.79,41.59},{47.53,41.63},{47.24,41.69},{42.46,54.52},{42.38,54.71},{42.18,54.79},{42.03,54.69},{41.91,54.46},{41.9,54.31},{41.9,54.2},{41.94,53.97},{42.01,53.8},{42.06,53.59},{42.08,53.35},{42.09,52.97},{42.14,52.76},{42.18,52.63},{42.25,52.43},{42.34,52.23},{42.48,51.84},{42.65,51.69},{42.72,51.81},{42.69,52.01},{42.56,52.17},{42.49,52.26},{42.42,52.36},{42.27,52.65},{42.2,52.8},{42.19,53.04},{42.28,53.37},{42.34,53.61},{42.36,53.78},{42.38,53.89},{42.41,54.01},{42.45,54.2},{42.47,54.36},},},1,nil,nil,24,nil,},
[1137] = {'Edan the Howler',176,176,9,9,4,{[1]={{38.98,47.48},{42.21,49.43},},},{[1]={{38.98,47.47},{39.15,47.46},{39.49,47.43},{39.75,47.41},{40.01,47.34},{40.24,47.12},{40.34,46.76},{40.41,46.53},{40.5,46.24},{40.64,46.01},{40.77,45.84},{40.9,45.68},{41.03,45.52},{40.9,45.83},{40.75,45.96},{40.7,46.04},{40.56,46.24},{40.51,46.62},{40.46,46.93},{40.41,47.17},{40.34,47.5},{40.32,47.73},{40.3,47.95},{40.19,48.05},{40.06,48.18},{39.88,48.38},{39.63,48.53},{39.4,48.66},{39.14,48.81},{38.98,48.9},{38.82,48.8},{38.69,48.52},{38.67,48.18},{38.75,47.89},{38.87,47.67},{42.2,49.42},{42.35,49.43},{42.56,49.46},{42.62,49.76},{42.63,50.1},{42.6,50.29},{42.81,50.22},{42.93,50.11},{43.04,50.07},{43.21,49.99},{43.3,49.81},{43.38,49.56},{43.44,49.32},{43.47,49.04},{43.4,48.94},{43.28,48.79},{43.15,48.75},{43.13,48.83},{43.07,49.03},{42.98,49.1},{42.82,49.22},{42.74,49.21},{42.62,49.13},{42.56,48.98},{42.51,48.8},{42.44,48.85},{42.39,48.93},{42.38,49.13},{42.36,49.33},{42.28,49.37},},},1,nil,nil,24,nil,},
[1138] = {'Snow Tracker Wolf',120,137,6,7,0,{[1]={{45.81,46.09},{45.55,46.18},{45.68,46.17},{45.74,46.0},{44.36,45.26},{43.31,46.32},{45.69,46.66},{44.56,47.3},{43.26,46.5},{44.61,47.07},{45.95,46.16},{49.73,44.51},{51.33,45.35},{51.3,45.72},},},nil,1,nil,nil,38,nil,},
[1139] = {'Magistrate Bluntnose',919,919,20,20,0,{[38]={{34.6,44.47},},},nil,38,{255,},{255,256,},55,"A",},
[1140] = {'Razormaw Matriarch',1106,1106,31,31,4,{[11]={{69.93,29.22},},},{[11]={{69.93,29.21},{69.73,28.98},{69.32,28.78},{69.08,28.77},{68.76,28.75},{68.59,28.43},{68.62,28.1},{68.67,27.66},{68.41,27.54},{68.08,27.65},{67.95,27.69},{67.79,27.83},{67.63,28.13},{67.45,28.47},{67.35,28.85},{67.18,29.36},{67.29,29.8},{67.4,30.28},{67.41,30.62},{67.18,30.74},{67.1,31.06},{67.21,31.36},{67.35,31.53},{67.52,31.8},{67.7,32.19},{67.75,32.26},{67.74,32.06},{67.72,31.79},{67.83,31.49},{67.87,31.15},{67.91,30.85},{67.9,30.41},{67.89,30.07},{67.85,29.92},{67.78,29.82},{67.64,29.61},{67.44,29.2},{67.41,29.03},{67.45,28.67},{67.47,28.57},{67.57,28.34},{67.85,27.73},{68.08,27.6},{68.3,27.68},{68.58,27.82},{68.64,28.04},{68.6,28.31},{68.72,28.82},{69.03,28.88},{69.32,28.94},{69.55,29.08},{69.76,29.21},{69.95,29.33},},},11,nil,nil,48,nil,},
[1141] = {'Angus Stern',3857,3857,60,60,0,{[1519]={{41.5,89.43},},},nil,1519,{212,1260,1271,},{212,1271,},12,"A",},
[1142] = {'Mosh\'Ogg Brute',1469,1536,36,37,0,{[33]={{35.55,30.92},{37.17,30.63},{37.89,30.24},{37.49,30.89},{37.33,31.34},{37.16,31.36},},},nil,33,nil,nil,45,nil,},
[1144] = {'Mosh\'Ogg Witch Doctor',1208,1257,36,37,0,{[33]={{37.01,28.69},{38.16,30.05},{37.17,30.81},{37.49,31.04},{36.12,31.69},{37.07,31.06},},},nil,33,nil,nil,45,nil,},
[1146] = {'Vharr',2471,2471,40,40,0,{[33]={{32.36,27.95},},},nil,33,nil,nil,29,"H",},
[1147] = {'Hragran',4100,4100,40,40,0,{[33]={{31.61,29.18},},},nil,33,nil,nil,29,"H",},
[1148] = {'Nerrist',2471,2471,40,40,0,{[33]={{32.7,29.23},},},nil,33,nil,nil,29,"H",},
[1149] = {'Uthok',2471,2471,40,40,0,{[33]={{31.55,27.95},},},nil,33,nil,nil,29,"H",},
[1150] = {'River Crocolisk',1050,1107,30,31,0,{[33]={{35.64,8.1},{34.56,8.1},{39.88,14.44},{41.18,14.13},{36.85,10.51},{39.9,11.47},{38.72,11.32},{40.39,12.26},{34.04,9.62},{34.58,10.46},{32.46,8.92},{41.01,13.72},{35.7,8.2},},},nil,33,nil,nil,14,nil,},
[1151] = {'Saltwater Crocolisk',1403,1469,35,36,0,{[33]={{14.97,10.02},{17.8,12.08},{21.6,17.74},{22.02,18.46},{21.91,16.59},{21.59,15.98},{34.04,31.75},{26.12,19.03},{22.68,17.65},{22.48,19.26},{28.35,20.57},{27.41,20.72},{29.82,23.12},},},nil,33,nil,nil,14,nil,},
[1152] = {'Snapjaw Crocolisk',1403,1469,35,36,0,{[33]={{41.42,20.72},{41.35,19.11},{39.72,21.51},{40.15,22.88},{40.87,17.66},{39.74,17.5},{41.77,17.46},{39.42,24.98},{39.15,31.89},{38.42,31.36},{40.39,19.41},{39.84,15.97},{37.86,32.63},{38.81,28.54},{39.94,30.66},{40.14,28.39},{40.2,27.22},{40.11,29.51},{40.77,24.66},{40.74,22.18},{41.32,21.52},{42.17,21.2},{39.45,28.72},{38.64,29.79},{42.46,16.67},{41.93,15.91},{41.32,15.34},},},nil,33,nil,nil,14,nil,},
[1153] = {'Torren Squarejaw',644,644,15,15,0,{[38]={{37.27,47.77},},},nil,38,nil,nil,55,"A",},
[1154] = {'Marek Ironheart',644,644,15,15,0,{[38]={{81.76,61.66},},},nil,38,{385,},{385,},55,"A",},
[1155] = {'Kelt Thomasin',644,644,15,15,0,{[38]={{81.93,64.61},},},nil,38,nil,nil,55,"A",},
[1156] = {'Vyrin Swiftwind',644,644,15,15,0,{[38]={{81.73,64.14},},},nil,38,{271,},{531,},84,"A",},
[1157] = {'Cursed Sailor',791,850,26,27,0,{[11]={{15.03,23.74},{14.13,30.6},{13.51,30.32},{13.84,30.75},{13.56,30.54},{13.74,29.75},{13.93,30.47},{14.03,28.9},{13.99,30.18},{13.18,30.72},{13.89,29.26},{14.11,29.32},{13.61,29.81},{14.03,30.28},},},nil,11,nil,nil,21,nil,},
[1158] = {'Cursed Marine',860,888,27,28,0,{[11]={{15.42,23.37},{15.33,23.44},{15.11,23.63},{15.5,24.07},{15.07,23.96},{15.16,23.53},{14.07,24.9},{14.33,24.46},{15.0,23.45},{14.61,24.36},{14.83,24.27},{14.48,23.81},{14.59,23.68},{14.25,23.96},{13.9,28.66},{13.32,29.63},{14.81,24.64},{14.4,23.31},{13.7,24.11},{14.25,23.98},{14.55,24.11},{13.52,30.95},{14.52,29.04},{14.11,28.99},{13.95,29.96},},},nil,11,nil,nil,21,nil,},
[1159] = {'First Mate Snellig',950,950,29,29,0,{[11]={{13.79,30.18},},},nil,11,nil,nil,21,nil,},
[1160] = {'Captain Halyndor',1003,1003,30,30,0,{[11]={{15.45,23.61},},},nil,11,nil,nil,21,nil,},
[1161] = {'Stonesplinter Trogg',222,247,11,12,0,{[38]={{27.19,57.08},{26.98,56.54},{27.32,50.19},{26.57,50.17},{26.15,49.04},{26.58,49.02},{27.15,46.69},{26.28,48.41},{26.07,51.8},{27.13,54.2},{28.33,48.89},{32.11,79.59},{30.17,72.66},{32.78,79.34},{33.47,70.36},{31.55,80.75},{31.25,79.95},{33.36,70.26},{29.63,72.54},{32.05,79.15},{30.06,71.91},{33.07,70.0},{31.65,75.35},{31.44,76.49},{30.94,75.16},{30.81,74.34},{32.07,77.88},{31.56,77.17},{30.84,74.03},{31.54,75.71},{30.7,75.49},{34.93,72.48},{32.12,70.49},{35.24,71.92},{33.36,77.84},{34.71,73.95},{33.8,71.16},{32.37,72.36},{34.74,71.32},{33.14,70.92},},},nil,38,nil,nil,59,nil,},
[1162] = {'Stonesplinter Scout',222,247,11,12,0,{[38]={{26.11,49.37},{25.92,49.04},{25.83,48.62},{26.37,57.33},{26.54,56.74},{27.58,57.78},{26.71,57.42},{27.39,55.94},{27.76,48.55},{34.5,76.19},{35.12,76.54},{34.7,76.78},{34.96,76.29},{29.57,72.89},{30.78,80.83},{32.72,80.04},{31.86,74.4},{31.29,74.43},{32.0,74.93},{33.85,70.8},{31.37,80.9},{32.57,79.89},{30.55,75.23},{31.01,71.74},{31.69,76.66},{28.43,59.36},{33.3,75.89},{35.41,71.04},{33.45,74.21},{33.73,71.84},{35.26,70.99},},},nil,38,nil,nil,59,nil,},
[1163] = {'Stonesplinter Skullthumper',273,300,13,14,0,{[38]={{27.98,81.18},{51.25,23.66},{27.51,85.89},{50.52,23.98},{48.25,20.65},{48.12,20.93},{48.31,21.18},{48.13,29.1},{28.19,86.9},{28.31,87.03},{28.71,86.22},{31.31,85.37},{36.18,86.53},{35.47,87.48},{35.98,84.66},{35.91,84.2},{37.12,85.35},{36.3,83.63},{36.11,83.55},{29.02,81.22},{28.93,84.93},{47.79,28.49},{36.5,81.42},{35.64,80.86},{35.34,82.93},{35.15,84.03},{34.15,85.91},{32.76,89.86},{34.9,88.73},{34.38,87.63},{36.35,88.36},},},nil,38,nil,nil,59,nil,},
[1164] = {'Stonesplinter Bonesnapper',328,356,15,16,0,{[38]={{37.27,93.22},{37.33,92.38},{52.23,24.09},{53.12,22.83},{52.17,21.79},{54.41,26.71},{54.54,26.99},{52.69,24.94},{52.81,26.77},{52.16,24.74},{35.87,93.93},{35.47,94.08},{35.85,92.09},{37.88,87.01},{34.56,91.52},{33.34,90.99},{32.99,91.27},},},nil,38,nil,nil,59,nil,},
[1165] = {'Stonesplinter Geomancer',330,354,17,18,0,{[38]={{72.69,61.99},{69.97,66.48},{69.23,66.04},{69.05,59.73},{70.84,63.54},{70.03,62.68},{72.28,68.25},{72.59,64.71},{69.01,63.3},{69.11,63.29},{67.02,59.41},},},{[38]={{69.01,63.24},{68.72,63.21},{68.18,63.16},{67.49,63.11},{68.38,63.19},{69.03,63.21},{69.27,63.15},{69.98,62.75},{69.29,63.2},},},38,nil,nil,59,nil,},
[1166] = {'Stonesplinter Seer',253,276,13,14,0,{[38]={{27.88,81.45},{34.98,90.9},{34.57,89.78},{51.04,23.32},{27.97,86.05},{27.45,85.55},{50.87,24.05},{48.83,29.46},{48.9,29.92},{50.59,25.05},{48.61,29.93},{47.69,21.08},{49.03,21.96},{49.59,29.96},{48.66,20.99},{46.5,21.2},{47.84,23.08},{49.96,23.57},{48.04,19.11},{29.22,87.61},{29.01,87.71},{28.08,83.46},{27.93,83.39},{36.36,85.99},{33.74,87.41},{29.42,86.72},{30.09,83.99},{33.55,88.46},{36.75,77.75},{36.65,84.19},{36.33,82.98},{29.58,81.46},{28.49,83.71},{29.05,80.89},{50.11,27.24},{48.67,28.88},{34.75,82.41},{34.37,81.78},{35.3,82.56},{35.45,80.1},{36.61,79.71},{34.63,84.87},{34.01,85.01},{35.23,87.46},{33.75,89.06},{35.64,89.5},{34.87,90.05},},},nil,38,nil,nil,59,nil,},
[1167] = {'Stonesplinter Digger',417,449,18,19,0,{[38]={{67.99,66.05},{69.06,66.06},{70.1,66.09},{68.27,62.62},{67.87,59.1},{70.61,59.97},{69.62,59.33},{70.63,64.78},{69.39,67.19},{70.94,66.0},{71.2,68.53},{72.62,66.79},{72.48,64.21},{70.14,67.38},{71.65,68.55},},},{[38]={{69.01,66.1},{68.91,66.09},{68.45,66.02},{68.99,66.07},{69.16,66.54},{69.36,66.97},{69.51,67.2},{69.68,67.59},{69.92,67.59},{69.67,67.55},{69.53,67.36},{69.36,66.99},{69.17,66.51},{72.5,64.24},{72.2,64.2},{71.83,64.19},{71.52,64.18},{71.14,64.15},{70.76,64.12},{70.48,64.26},{70.76,64.19},{71.14,64.15},{71.52,64.22},{71.88,64.2},{72.18,64.24},},},38,nil,nil,59,nil,},
[1169] = {'Dark Iron Insurgent',417,449,18,19,0,{[38]={{57.57,16.56},{57.55,19.28},{58.72,18.66},{60.27,15.77},{59.03,13.35},{58.95,13.51},{59.22,13.68},},[11]={{63.36,77.57},{63.22,77.29},{63.64,77.94},{63.82,78.24},{63.76,78.42},},},{[1]={{97.75,12.47},{97.79,12.56},{97.86,12.69},{97.92,12.81},{98.0,12.95},{98.06,13.08},{97.99,12.93},{97.92,12.78},{97.83,12.61},{97.74,12.46},{97.56,12.19},{97.49,12.14},},[11]={{63.41,77.6},{63.47,77.7},{63.55,77.85},{63.62,77.99},{63.71,78.17},{63.78,78.32},{63.7,78.14},{63.62,77.96},{63.51,77.75},{63.4,77.58},{63.19,77.26},{63.1,77.2},},},38,nil,nil,54,nil,},
[1172] = {'Tunnel Rat Vermin',198,218,10,11,0,{[38]={{36.02,14.65},{40.0,18.04},{39.26,20.94},{40.68,19.45},{38.44,14.3},{38.33,19.68},{27.69,43.61},{36.88,18.11},{38.64,22.93},{27.4,44.59},{27.33,41.7},{26.74,41.48},{37.01,29.51},{28.3,44.83},{39.81,25.1},{40.38,23.34},{38.43,25.73},{38.01,27.4},{36.93,26.88},{23.94,34.35},{34.55,17.08},{33.47,12.67},{36.61,11.87},{35.5,15.46},{35.84,26.76},{34.58,10.45},{38.35,16.0},{38.93,10.56},{40.47,10.0},{38.02,12.56},{25.91,34.66},{37.33,10.97},{22.44,28.54},{38.2,17.8},{26.19,31.47},{26.24,31.84},{23.68,26.08},{23.86,30.19},{25.07,32.73},{24.68,30.42},{24.69,30.01},{25.01,28.6},{34.55,17.44},},},nil,38,nil,nil,26,nil,},
[1173] = {'Tunnel Rat Scout',198,222,10,11,0,{[38]={{37.43,25.89},{36.56,18.3},{36.41,25.03},{23.34,28.53},{26.45,26.85},{24.49,29.49},{27.64,32.14},{24.89,29.64},{25.41,29.83},{26.05,31.9},},},{[1]={{97.46,32.65},{97.46,32.48},{97.45,32.27},{97.44,32.13},{97.45,31.94},{97.55,31.85},{97.64,31.99},{97.58,31.88},{97.44,31.79},{97.41,31.97},{97.45,32.19},{97.46,32.39},{97.46,32.67},{97.43,32.91},{97.38,33.1},{97.29,33.24},{97.36,33.07},{97.44,32.92},{97.47,32.73},},[38]={{36.41,25.1},{36.4,24.79},{36.38,24.41},{36.36,24.17},{36.38,23.82},{36.56,23.66},{36.72,23.91},{36.62,23.72},{36.36,23.56},{36.31,23.87},{36.38,24.28},{36.4,24.62},{36.39,25.13},{36.35,25.55},{36.26,25.89},{36.1,26.14},{36.21,25.84},{36.36,25.57},{36.43,25.24},},},38,nil,nil,26,nil,},
[1174] = {'Tunnel Rat Geomancer',219,241,12,13,0,{[38]={{36.64,25.14},{35.55,27.92},{36.59,25.65},{35.58,21.07},{35.55,22.63},{35.8,22.33},{36.18,24.31},{35.41,21.57},{35.32,23.04},{35.15,23.93},},},nil,38,nil,nil,26,nil,},
[1175] = {'Tunnel Rat Digger',247,273,12,13,0,{[38]={{35.99,27.07},{36.41,26.13},{35.56,19.52},{36.42,20.53},{35.03,23.46},{35.53,23.93},{36.27,23.41},{35.15,24.31},{35.91,22.31},{35.61,24.7},{35.16,24.89},{35.56,22.03},{35.37,24.61},},},{[1]={{96.96,30.92},{96.89,30.81},{96.9,30.58},{97.03,30.33},{97.07,30.04},{97.04,29.87},{97.01,29.69},{97.06,30.02},{97.07,30.23},{96.98,30.46},{96.92,30.72},{97.02,31.01},{97.14,31.19},{97.35,31.46},{97.39,31.6},{97.36,31.85},{97.34,32.1},{97.36,31.83},{97.38,31.55},{97.27,31.35},{97.14,31.16},},[11]={{62.47,99.57},{62.4,99.44},{62.4,99.17},{62.56,98.87},{62.6,98.53},{62.57,98.32},{62.54,98.11},{62.6,98.5},{62.61,98.74},{62.5,99.03},{62.43,99.33},{62.55,99.68},{62.69,99.89},{62.68,99.86},},[38]={{35.51,22.01},{35.39,21.81},{35.4,21.41},{35.63,20.96},{35.7,20.44},{35.65,20.13},{35.6,19.81},{35.69,20.41},{35.71,20.77},{35.54,21.19},{35.44,21.65},{35.62,22.17},{35.83,22.48},{36.2,22.96},{36.27,23.23},{36.22,23.67},{36.19,24.11},{36.22,23.63},{36.26,23.12},{36.06,22.78},{35.82,22.44},},},38,nil,nil,26,nil,},
[1176] = {'Tunnel Rat Forager',222,247,11,12,0,{[38]={{37.0,24.87},{37.15,24.82},{37.31,24.5},{25.73,43.83},{26.28,43.21},{26.45,44.04},{35.27,16.31},{35.59,16.0},{36.33,23.46},{37.53,16.19},{37.35,16.42},},},nil,38,nil,nil,26,nil,},
[1177] = {'Tunnel Rat Surveyor',300,300,14,14,0,{[38]={{35.02,27.21},{34.91,26.28},{34.43,26.81},},},nil,38,nil,nil,26,nil,},
[1178] = {'Mo\'grosh Ogre',1251,1347,18,19,1,{[38]={{68.57,31.82},{68.75,28.37},{67.13,33.89},{69.67,25.54},{70.8,25.59},{69.62,26.85},{75.67,32.33},{73.57,25.9},{72.23,23.25},{63.58,21.38},{69.33,21.05},{63.62,25.06},{69.48,22.55},{65.98,21.59},{68.54,21.33},},},nil,38,nil,nil,45,nil,},
[1179] = {'Mo\'grosh Enforcer',1131,1212,18,19,1,{[38]={{66.41,32.21},{67.37,30.23},{70.83,23.85},{73.43,28.77},{72.06,25.23},{73.93,24.7},{68.27,30.34},{67.37,23.21},{69.32,22.34},{64.85,19.88},{72.03,19.78},{73.72,33.4},{68.93,24.54},{70.72,22.79},{70.47,20.58},{76.87,16.17},{78.35,15.68},{75.96,15.3},{75.89,15.08},{76.87,13.83},},},nil,38,nil,nil,45,nil,},
[1180] = {'Mo\'grosh Brute',1347,1452,19,20,1,{[38]={{74.73,25.18},{75.09,15.98},{75.84,17.51},{77.29,13.78},{77.47,13.91},{79.51,14.95},{79.79,15.2},{68.84,20.25},{75.63,18.42},},},{[38]={{74.64,25.13},{74.5,25.2},{74.36,25.21},{73.89,25.15},{74.37,25.2},{74.62,25.18},{74.92,25.09},{75.07,25.02},{75.23,24.96},{74.97,25.06},{74.73,25.14},{68.86,20.43},{68.9,20.9},{68.83,20.13},{68.72,19.7},{68.53,19.16},{68.66,19.45},{68.73,19.71},{68.84,20.19},{75.53,18.55},{75.43,18.88},{75.26,19.45},{75.13,19.61},{74.87,19.84},{75.16,19.64},{75.33,19.43},{75.47,18.86},{75.59,18.17},{75.39,17.34},{75.08,16.68},{75.25,16.01},{75.95,15.87},{76.72,16.09},{77.01,16.66},{76.74,17.16},{76.62,17.43},{76.33,18.21},{76.02,18.09},{75.93,17.66},{75.79,17.41},{75.52,17.51},{75.56,18.28},},[11]={{84.72,98.52},{84.75,98.83},{84.7,98.32},{84.63,98.03},{84.5,97.67},{84.59,97.86},{84.64,98.04},{84.71,98.36},{89.17,97.27},{89.1,97.48},{88.99,97.86},{88.9,97.97},{88.73,98.13},{88.92,97.99},{89.03,97.85},{89.13,97.47},{89.21,97.01},{89.08,96.46},{88.87,96.01},{88.99,95.57},{89.45,95.47},{89.97,95.62},{90.16,96.0},{89.98,96.34},{89.9,96.52},{89.7,97.04},{89.49,96.95},{89.44,96.67},{89.35,96.5},{89.16,96.57},{89.19,97.08},},},38,nil,nil,45,nil,},
[1181] = {'Mo\'grosh Shaman',1131,1212,18,19,1,{[38]={{70.29,17.82},{74.56,30.56},{68.56,22.21},{67.26,21.61},{73.36,19.75},{75.31,29.93},{73.5,25.09},{72.08,21.01},{65.08,20.3},{74.0,19.71},{76.54,18.07},{77.48,17.59},{75.13,16.72},{79.19,15.41},},},nil,38,nil,nil,45,nil,},
[1182] = {'Brother Anton',2972,2972,45,45,0,{[405]={{66.52,7.91},},},nil,405,{261,1052,},{261,6141,},12,"A",},
[1183] = {'Mo\'grosh Mystic',1212,1299,19,20,1,{[38]={{75.2,25.15},{75.45,24.84},{76.77,14.3},{68.34,18.68},{68.61,18.89},},},nil,38,nil,nil,45,nil,},
[1184] = {'Cliff Lurker',273,300,18,18,0,{[38]={{49.05,72.99},{71.18,50.86},{69.74,51.63},{55.25,78.3},{58.12,77.27},{60.23,77.5},{48.71,72.4},{62.64,54.41},{65.63,50.95},{62.62,64.13},{64.66,53.34},{50.54,73.76},{62.5,55.68},{57.07,65.18},{46.34,72.4},{56.6,65.86},{67.46,52.41},},},nil,38,nil,nil,22,nil,},
[1185] = {'Wood Lurker',386,417,17,18,0,{[38]={{75.79,38.0},{80.76,40.03},{80.36,40.31},{77.49,34.26},{77.83,36.4},{76.15,37.98},{74.31,34.68},{78.91,40.91},{75.63,35.93},{74.32,37.81},{59.31,23.32},},},nil,38,nil,nil,22,nil,},
[1186] = {'Elder Black Bear',266,296,11,12,0,{[38]={{30.55,10.38},{29.08,13.4},{27.19,10.52},{27.42,14.19},{40.82,52.53},{40.44,71.73},{39.72,33.25},{23.78,25.37},{35.98,32.11},{30.13,24.67},{18.94,75.46},{26.32,40.27},{30.57,53.86},{39.45,74.48},{33.44,30.06},{20.74,77.43},{24.76,36.45},{34.14,29.77},{38.11,55.97},{37.21,52.83},{29.39,40.28},{32.46,29.75},{37.2,32.83},{27.53,28.69},},},nil,38,nil,nil,44,nil,},
[1187] = {'Daryl the Youngling',644,644,15,15,0,{[38]={{83.47,65.46},},},nil,38,{257,258,531,},{257,258,271,},55,"A",},
[1188] = {'Grizzled Black Bear',328,360,13,14,0,{[38]={{67.9,49.29},{63.19,80.21},{68.42,72.63},{74.61,50.65},{78.05,68.74},{75.82,54.93},{76.13,51.74},{73.93,55.33},{58.61,75.04},{65.9,74.21},{66.2,76.04},{67.91,73.28},{64.4,73.49},{65.48,69.75},{58.44,69.06},{62.54,43.27},{66.34,45.47},{65.79,47.34},{66.19,42.74},{43.13,63.73},{43.86,61.3},{64.98,45.29},{40.89,62.26},{40.78,66.71},},},{[1]={{99.99,53.56},{99.82,54.68},{99.73,55.04},{99.51,55.48},{99.32,55.82},{99.37,55.93},{99.63,56.03},{99.36,56.02},{99.34,55.81},{99.54,55.42},{99.74,54.96},{99.84,54.67},{99.87,53.23},{99.75,53.03},{99.52,53.04},{99.31,53.28},{99.12,53.55},{98.81,53.38},{98.66,53.41},{98.82,53.38},{98.99,53.47},{99.16,53.63},{99.32,53.33},{99.59,53.08},{99.81,53.17},{99.95,53.36},},[38]={{40.91,62.41},{40.99,62.86},{40.95,63.73},{40.62,64.41},{40.45,65.05},{40.05,65.83},{39.72,66.44},{39.81,66.65},{40.27,66.82},{39.79,66.81},{39.75,66.43},{40.12,65.73},{40.47,64.91},{40.65,64.4},{40.95,63.73},{41.01,62.64},{40.7,61.82},{40.49,61.46},{40.07,61.49},{39.71,61.91},{39.36,62.39},{38.82,62.09},{38.54,62.15},{38.83,62.1},{39.13,62.24},{39.44,62.53},{39.73,62.0},{40.2,61.55},{40.59,61.71},{40.84,62.06},},},38,nil,nil,44,nil,},
[1189] = {'Black Bear Patriarch',427,463,16,17,0,{[38]={{68.29,42.79},{71.72,40.28},{73.2,35.54},{71.81,40.47},{72.85,44.73},{68.51,36.41},{76.42,41.79},{78.03,41.6},{75.75,44.32},{74.18,44.73},{64.89,34.47},{62.11,33.05},{64.44,29.45},{71.89,36.68},{68.63,41.46},{63.62,33.64},{72.24,37.73},{58.82,32.33},{60.04,26.93},{59.0,25.23},{58.95,28.75},},},nil,38,nil,nil,44,nil,},
[1190] = {'Mountain Boar',198,222,10,11,0,{[38]={{30.6,16.56},{30.53,15.36},{35.49,33.96},{31.82,24.1},{25.27,13.89},{29.91,46.84},{38.5,36.13},{37.19,39.9},{36.96,34.52},{33.85,31.8},{37.44,38.42},{33.34,33.45},{24.27,21.43},{27.25,39.1},{27.74,26.64},{29.13,32.8},{39.52,29.22},{29.91,36.48},{34.81,36.43},{37.23,36.18},{37.2,34.39},{32.92,35.1},{28.62,23.23},{38.16,37.94},{34.35,30.52},{38.18,34.24},},},nil,38,nil,nil,1094,"AH",},
[1191] = {'Mangy Mountain Boar',300,328,14,15,0,{[38]={{52.16,73.45},{59.94,59.48},{52.5,74.69},{61.59,57.35},{62.98,57.51},{77.89,73.65},{74.51,52.44},{74.67,72.54},{63.78,65.71},{60.08,61.82},{66.41,68.89},{65.0,63.36},{58.48,61.26},{62.67,59.95},{65.64,58.02},{64.16,59.3},{62.58,60.28},{63.42,50.66},{65.23,48.43},{63.52,47.05},{50.79,71.56},{38.99,51.25},{58.72,65.85},{44.22,62.81},{59.8,63.75},{64.33,56.92},{34.16,62.62},{56.51,63.61},{45.59,66.43},{41.8,55.27},{49.07,68.57},{60.24,65.58},},},nil,38,nil,nil,189,"AH",},
[1192] = {'Elder Mountain Boar',356,386,16,17,0,{[38]={{70.12,37.77},{61.18,39.62},{64.94,38.83},{67.37,41.3},{67.08,39.42},{66.14,38.31},{66.33,40.12},{65.37,41.94},{62.38,38.38},{63.2,35.1},{61.33,41.4},{62.98,39.95},{60.0,37.89},{77.29,47.08},{60.21,33.91},{74.77,42.14},{75.72,46.64},{74.78,50.69},{60.35,36.22},},},nil,38,nil,nil,1094,"AH",},
[1193] = {'Loch Frenzy',247,273,12,13,0,{[38]={{49.07,17.44},{44.38,17.36},{48.01,16.92},{54.04,14.19},{51.39,17.78},{43.54,14.85},{51.59,14.26},{53.92,19.88},{53.87,14.29},{50.37,16.92},{52.78,14.3},{45.59,26.95},{44.43,16.13},{44.3,21.6},{54.07,15.92},{43.0,24.05},{46.86,17.63},{43.4,26.54},{43.14,17.9},{43.25,19.85},{44.72,22.16},{56.95,27.99},{45.62,23.46},{56.61,25.2},{52.98,18.13},{54.68,21.57},},},nil,38,nil,nil,16,nil,},
[1194] = {'Mountain Buzzard',328,356,15,16,0,{[38]={{71.08,74.81},{70.56,74.11},{71.08,72.42},{70.86,52.61},{68.38,50.52},{76.77,63.67},{76.27,74.78},{79.2,63.69},{77.09,58.32},{76.86,55.59},{78.52,57.96},{77.18,57.33},{78.87,59.18},{76.97,74.0},{75.89,72.33},{75.79,70.46},{74.73,67.67},{74.45,72.53},{79.33,66.86},{78.55,76.86},{78.16,76.03},{77.32,75.27},{68.47,75.83},{78.04,72.44},{74.48,64.27},},},nil,38,nil,nil,14,nil,},
[1195] = {'Forest Lurker',198,222,10,11,0,{[38]={{28.71,16.83},{27.37,18.34},{39.48,72.96},{36.63,30.8},{38.53,31.57},{25.34,37.75},{28.57,57.0},{29.58,46.82},{28.58,49.1},{19.29,83.47},{30.01,44.65},{27.75,41.89},{32.13,17.08},{39.45,74.69},{28.81,51.94},{29.89,50.69},{31.1,30.61},{34.31,54.19},{36.91,73.91},{21.15,71.59},{31.08,41.56},{29.9,22.63},{29.73,18.47},{27.73,21.25},{30.01,19.82},{31.13,52.19},{33.92,40.86},{28.71,30.77},{32.81,30.61},{33.56,40.53},{32.39,32.6},{36.56,31.13},{35.95,34.44},{35.64,52.82},{30.5,45.07},},},nil,38,nil,nil,22,nil,},
[1196] = {'Ice Claw Bear',164,187,7,8,0,{[1]={{46.35,63.35},{43.84,28.78},{41.24,29.17},{37.77,33.92},{36.18,30.46},{34.57,30.3},{34.22,32.05},{33.35,36.8},{31.79,38.64},{30.6,35.08},{25.5,46.37},{26.88,46.91},{25.32,55.76},{25.98,55.19},{26.7,56.19},{28.05,54.51},{28.1,52.24},{28.34,47.54},{27.62,47.63},{28.05,43.1},{29.06,42.68},{29.3,41.51},{30.19,42.26},{30.95,40.81},{32.37,47.18},{29.72,51.71},{32.27,49.9},{30.48,59.6},{37.14,43.93},{35.9,46.93},{35.2,35.91},{38.12,42.91},{38.52,43.45},{37.73,41.59},{38.91,40.29},{46.71,63.3},{49.28,62.28},{51.16,43.14},{50.34,53.8},{50.24,59.37},{56.26,43.27},{59.27,51.98},{60.97,56.87},{58.71,61.27},{64.93,59.95},{66.5,50.47},{74.78,48.09},{80.07,48.61},},},nil,1,nil,nil,44,nil,},
[1197] = {'Stonesplinter Shaman',301,325,15,16,0,{[38]={{35.07,91.42},{36.77,93.89},{36.44,93.54},{52.55,23.89},{51.92,23.54},{54.15,25.98},{53.68,25.08},{54.51,26.43},{54.03,27.17},{51.78,24.63},{55.17,26.96},{34.49,94.57},{34.76,94.35},{34.67,94.81},{36.15,94.15},{36.1,92.53},{37.52,90.07},{36.25,91.02},{37.47,86.23},{38.23,87.7},{38.1,87.73},{33.8,93.87},{34.27,91.62},},},nil,38,nil,nil,59,nil,},
[1198] = {'Rallic Finn',804,804,18,18,0,{[12]={{83.28,66.09},},},nil,12,nil,nil,12,"A",},
[1199] = {'Juvenile Snow Leopard',102,120,5,6,0,{[1]={{45.25,58.46},{40.53,62.04},{38.65,60.68},{38.83,60.98},{36.68,60.47},{35.54,60.59},{38.31,60.87},{43.02,56.46},{42.43,57.92},{40.22,58.87},{39.81,60.07},{41.51,60.05},{43.26,60.27},{43.64,59.65},{45.37,58.75},},},nil,1,nil,nil,66,nil,},
[1200] = {'Morbent Fel',3609,3609,32,32,1,{[10]={{16.9,33.4},},},nil,10,nil,nil,21,nil,},
[1201] = {'Snow Leopard',137,156,7,8,0,{[1]={{48.52,59.13},{47.29,63.32},{47.94,63.16},{42.73,30.96},{43.97,30.25},{40.11,30.76},{38.3,33.53},{37.58,30.89},{36.67,31.87},{35.2,35.01},{34.08,35.27},{34.91,35.73},{33.15,37.82},{31.2,39.56},{31.2,39.38},{29.33,39.59},{30.13,40.08},{27.6,42.51},{26.82,46.94},{25.7,46.92},{26.76,47.83},{27.55,54.76},{29.1,54.19},{28.64,53.56},{28.29,53.58},{29.09,49.7},{28.17,48.92},{28.15,44.98},{28.23,39.97},{29.49,50.82},{34.39,47.66},{32.59,48.46},{35.36,36.37},{37.56,36.76},{36.74,37.57},{38.39,38.39},{48.45,61.94},{49.55,61.8},{49.94,60.21},{48.29,56.53},{49.31,60.56},{53.81,57.75},{54.66,57.2},{53.91,56.54},{55.23,58.96},{56.47,57.98},{55.85,60.42},{56.48,54.94},{57.07,56.26},{56.08,52.66},{56.34,52.21},{59.46,55.87},{57.81,55.81},{58.49,59.65},{59.54,61.02},{59.44,60.81},{59.09,58.64},{60.06,58.83},{60.35,60.02},{61.24,59.62},{59.96,58.02},{61.84,57.01},{62.66,59.16},{62.34,56.58},{62.95,57.33},{63.58,60.22},{82.22,37.6},{80.36,35.94},{78.96,36.29},{79.23,35.36},{79.05,37.2},},},{[1]={{27.35,42.31},{27.2,42.48},{27.23,42.78},{26.47,43.12},{25.9,43.27},{25.46,44.46},{25.29,44.94},{25.31,44.05},{26.42,42.37},{26.97,42.07},},},1,nil,nil,66,nil,},
[1202] = {'Tunnel Rat Kobold',222,247,11,11,0,{[38]={{37.0,24.66},{25.48,43.71},{25.53,43.36},{26.21,43.96},{25.71,42.8},{26.46,43.81},{26.21,44.13},{35.77,16.62},{35.46,17.15},{35.19,17.08},{39.44,12.96},{37.69,16.99},{39.77,12.36},{39.3,12.06},},},nil,38,nil,nil,26,nil,},
[1203] = {'Watcher Sarys',3660,3660,35,35,0,nil,nil,0,nil,nil,56,"A",},
[1204] = {'Watcher Corwin',4185,4185,38,38,0,nil,nil,0,nil,nil,56,"A",},
[1205] = {'Grawmug',386,386,17,17,0,{[38]={{34.77,90.45},},},nil,38,nil,nil,59,nil,},
[1206] = {'Gnasher',354,354,16,16,0,{[38]={{34.71,90.82},},},nil,38,nil,nil,59,nil,},
[1207] = {'Brawler',340,340,16,16,0,{[38]={{34.64,90.55},},},nil,38,nil,nil,59,nil,},
[1210] = {'Chok\'sul',1686,1686,22,22,1,{[38]={{79.59,14.7},},},nil,38,nil,nil,14,nil,},
[1211] = {'Leper Gnome',156,198,8,10,0,{[1]={{27.62,36.41},{28.05,36.68},{27.19,36.84},{27.25,36.39},{27.65,36.43},{27.69,36.92},{27.25,37.31},{27.39,35.81},{28.1,35.94},{26.84,36.35},{26.13,37.01},{26.65,36.59},{25.94,37.86},{26.87,35.69},{26.31,35.65},{24.71,39.38},{25.31,39.78},{26.7,41.85},{24.89,40.07},{26.04,40.76},{24.25,39.63},{24.24,39.91},{24.7,41.69},{26.13,42.71},{24.79,42.89},{25.69,42.98},{24.7,42.98},{27.25,42.99},{26.77,43.79},{26.7,42.78},{26.02,43.69},{24.44,43.08},{24.75,43.82},{24.43,43.63},{25.5,43.71},{24.78,42.81},{25.18,44.38},{25.56,45.29},{25.46,44.83},{24.71,44.65},{23.98,43.41},},},{[1]={{27.19,36.84},{27.39,37.02},{27.44,37.93},{27.2,37.19},{27.47,36.76},{27.22,36.97},{26.86,36.76},{27.16,37.18},{24.24,39.64},{25.58,39.93},{26.56,39.77},{27.46,38.15},{27.2,37.2},{27.46,38.15},{26.56,39.77},{25.58,39.93},{24.7,42.97},{25.73,41.91},{26.06,42.15},{26.08,42.54},{26.32,42.78},{26.28,43.21},{25.99,43.78},{26.02,44.09},{25.9,44.48},{25.67,44.79},{25.79,45.07},{25.6,45.69},{25.43,45.79},{24.93,45.37},{24.52,45.1},{24.41,44.94},{24.44,44.65},{24.76,43.9},{24.77,43.44},{24.78,42.81},{24.69,43.09},{24.97,44.3},{24.69,43.14},{24.77,42.8},{25.32,42.38},{25.87,41.59},{25.96,40.43},{25.87,41.59},{25.32,42.38},},},1,nil,nil,63,nil,},
[1212] = {'Bishop Farthing',2471,2471,40,40,0,{[1519]={{39.1,27.91},},},nil,1519,{270,},{269,},12,"A",},
[1213] = {'Godric Rothgar',166,166,5,5,0,{[12]={{47.69,41.42},},},nil,12,nil,nil,12,"A",},
[1214] = {'Aldren Cordon',804,804,18,18,0,{[38]={{64.82,66.05},},},nil,38,nil,nil,55,"A",},
[1215] = {'Alchemist Mallory',1309,1309,26,26,0,{[12]={{39.84,48.23},},},nil,12,nil,nil,12,"A",},
[1216] = {'Shore Crawler',386,417,17,18,0,{[40]={{25.56,64.67},{25.78,63.68},{25.72,67.26},{25.32,63.91},{25.75,65.5},{25.27,64.73},{25.69,66.77},{26.3,66.96},{25.93,66.19},{25.41,65.71},{30.71,81.88},{32.03,82.69},{29.93,81.51},{29.46,79.28},{35.85,87.9},{30.64,83.0},{30.05,80.51},{29.5,78.42},{29.16,80.52},{28.77,77.79},{28.96,78.66},{36.73,88.41},},},nil,40,nil,nil,7,"AH",},
[1217] = {'Glorin Steelbrow',1240,1240,25,25,0,{[11]={{10.58,60.59},},},nil,11,{293,321,322,526,},{270,292,324,526,},55,"A",},
[1218] = {'Herbalist Pomeroy',413,413,10,10,0,{[12]={{39.96,48.41},},},nil,12,nil,nil,12,"A",},
[1222] = {'Dark Iron Sapper',386,386,17,17,0,{[38]={{56.25,12.89},{56.4,13.15},},},nil,38,nil,nil,54,nil,},
[1224] = {'Young Threshadon',439,507,19,20,0,{[38]={{53.67,46.91},{51.62,61.54},{54.24,60.96},{59.83,50.22},{49.17,46.93},{48.73,61.96},{58.57,54.72},{58.92,46.93},{51.53,47.19},{57.9,50.35},{56.63,46.84},{48.79,33.75},{57.56,43.85},{50.66,50.44},{48.29,38.35},{48.11,50.69},{50.24,57.89},{44.81,39.84},{45.56,50.52},{45.13,41.02},{48.07,39.84},},},nil,38,nil,nil,16,nil,},
[1225] = {'Ol\' Sooty',1452,1452,20,20,1,{[38]={{37.92,63.38},},},{[38]={{42.47,64.67},{41.82,65.0},{40.5,66.79},{39.85,66.79},{39.75,66.58},{39.83,66.21},{40.49,64.92},{40.91,63.71},{41.0,62.63},{40.5,61.46},{39.97,61.64},{39.33,62.23},{38.51,62.1},{37.82,62.77},{36.73,60.99},{37.8,62.85},{38.55,62.12},{38.85,62.1},{39.32,62.37},{40.14,61.59},{40.72,61.81},{41.01,62.92},{40.89,63.78},{40.53,64.62},{40.21,65.47},{39.69,66.55},{40.07,66.87},{41.28,66.19},{41.82,65.0},{42.47,64.67},{43.19,64.77},},[1]={{99.75,56.01},{99.39,56.01},{99.34,55.89},{99.38,55.69},{99.75,54.97},{99.99,54.29},{99.76,53.03},{99.46,53.13},{99.1,53.46},{98.64,53.38},{98.25,53.76},{97.64,52.76},{98.24,53.8},{98.66,53.39},{98.83,53.38},{99.1,53.54},{99.56,53.1},{99.88,53.22},{99.97,54.32},{99.77,54.8},{99.6,55.27},{99.3,55.88},{99.51,56.06},},},38,nil,nil,44,nil,},
[1226] = {'Maxan Anvol',413,413,10,10,0,{[1]={{47.34,52.19},},},nil,1,{5625,5630,5635,},{5625,5626,},55,"A",},
[1228] = {'Magis Sparkmantle',413,413,10,10,0,{[1]={{47.5,52.08},},},nil,1,{1879,},nil,875,"A",},
[1229] = {'Granis Swiftaxe',413,413,10,10,0,{[1]={{47.36,52.65},},},nil,1,{1679,},nil,55,"A",},
[1231] = {'Grif Wildheart',500,500,12,12,0,{[1]={{45.81,53.04},},},nil,1,{6064,6084,6085,6086,},{6064,6074,6075,6076,6084,6085,},55,"A",},
[1232] = {'Azar Stronghammer',500,500,12,12,0,{[1]={{47.6,52.07},},},nil,1,{2997,},nil,55,"A",},
[1234] = {'Hogral Bakkan',500,500,12,12,0,{[1]={{47.56,52.61},},},nil,1,{2218,2299,},nil,55,"A",},
[1236] = {'Kobold Digger',271,292,12,13,0,{[40]={{44.8,23.12},{45.33,18.46},{44.76,20.61},{44.62,19.99},{45.32,20.46},{46.15,19.4},{46.07,18.29},},},nil,40,nil,nil,26,nil,},
[1237] = {'Kazan Mogosh',334,334,8,8,0,{[1]={{68.61,54.64},},},nil,1,nil,nil,55,"A",},
[1238] = {'Gamili Frosthide',372,372,9,9,0,{[1]={{45.18,51.93},},},nil,1,nil,nil,55,"A",},
[1239] = {'First Mate Fitzsimmons',1605,1605,30,30,0,{[11]={{10.89,59.67},},},nil,11,{288,289,290,463,},{288,289,},12,"A",},
[1240] = {'Boran Ironclink',372,372,9,9,0,{[1]={{45.16,51.75},},},nil,1,nil,nil,55,"A",},
[1241] = {'Tognus Flintfire',1605,1605,30,30,0,{[1]={{45.34,51.94},},},{[1]={{45.34,51.94},{45.32,51.92},},},1,nil,nil,55,"A",},
[1242] = {'Karl Boran',1605,1605,30,30,0,{[11]={{8.31,58.53},},},nil,11,{279,281,},{279,286,},12,"A",},
[1243] = {'Hegnar Rumbleshot',372,372,9,9,0,{[1]={{40.68,65.13},},},nil,1,nil,{5541,},55,"A",},
[1244] = {'Rethiel the Greenwarden',1041,1041,30,30,0,{[11]={{56.37,40.4},},},nil,11,{275,276,277,},{275,276,277,463,},12,"A",},
[1245] = {'Kogan Forgestone',413,413,10,10,0,{[1]={{45.32,51.75},},},{[1]={{45.35,51.73},{45.32,51.75},},},1,nil,nil,57,"A",},
[1246] = {'Vosur Brakthel',1605,1605,30,30,0,{[1537]={{66.33,55.69},},},nil,1537,nil,nil,55,"A",},
[1247] = {'Innkeeper Belm',1605,1605,30,30,0,{[1]={{47.38,52.52},},},nil,1,nil,nil,55,"A",},
[1249] = {'Quartermaster Hudson',334,334,8,8,0,{[12]={{25.23,74.07},},},nil,12,nil,nil,12,"A",},
[1250] = {'Drake Lindgren',413,413,10,10,0,{[12]={{83.31,66.69},},},nil,12,nil,nil,12,"A",},
[1251] = {'Splinter Fist Firemonger',702,739,28,29,0,{[10]={{36.5,77.37},{37.78,79.69},{37.06,82.4},{37.34,84.15},{33.93,71.92},{33.96,73.94},},},nil,10,nil,nil,45,nil,},
[1252] = {'Senir Whitebeard',334,334,8,8,0,{[1]={{46.73,53.83},},},nil,1,{287,291,},{287,420,},55,"A",},
[1253] = {'Father Gavin',644,644,15,15,0,{[1]={{57.73,44.88},},},nil,1,nil,nil,794,"AH",},
[1254] = {'Foreman Stonebrow',500,500,12,12,0,{[1]={{69.08,56.33},},},nil,1,{432,},{432,},55,"A",},
[1255] = {'Prospector Gehn',500,500,12,12,0,{[1]={{68.96,54.61},},},nil,1,nil,nil,55,"A",},
[1256] = {'Quarrymaster Thesten',413,413,10,10,0,{[1]={{69.16,54.8},},},nil,1,nil,nil,55,"A",},
[1257] = {'Keldric Boucher',1605,1605,30,30,0,{[1519]={{55.73,65.39},},},nil,1519,nil,nil,12,"A",},
[1258] = {'Black Ravager Mastiff',734,788,25,26,0,{[10]={{69.5,38.23},{67.24,35.11},{65.98,32.83},{65.5,31.25},{63.33,27.72},{50.81,60.54},},},nil,10,nil,nil,38,nil,},
[1259] = {'Gobbler',573,573,22,22,0,{[11]={{18.07,39.84},},},nil,11,nil,nil,18,nil,},
[1260] = {'Great Father Arctikus',208,208,11,11,4,{[1]={{22.78,52.08},{21.59,51.79},{22.49,54.24},{23.81,51.02},{24.15,52.56},{23.45,54.63},},},nil,1,nil,nil,37,nil,},
[1261] = {'Veron Amberstill',413,413,10,10,0,{[1]={{63.47,50.56},},},{[1]={{63.47,50.56},{63.46,50.63},},},1,{7673,7674,},{7673,7674,},55,"A",},
[1263] = {'Yarlyn Amberstill',64,64,1,1,0,{[1]={{63.12,50.88},},},nil,1,nil,nil,55,"A",},
[1265] = {'Rudra Amberstill',197,197,10,10,0,{[1]={{63.08,49.85},},},nil,1,{314,},{314,},55,"A",},
[1266] = {'Tundra MacGrann',919,919,20,20,0,{[1]={{34.57,51.65},},},nil,1,{312,},{312,},57,"A",},
[1267] = {'Ragnar Thunderbrew',1605,1605,30,30,0,{[1]={{46.83,52.36},},},nil,1,{384,4126,},{384,4126,4128,},55,"A",},
[1268] = {'Ozzie Togglevolt',413,413,10,10,0,{[1]={{45.89,49.39},},},nil,1,{2926,2962,},{2926,2927,2962,},875,"A",},
[1269] = {'Razzle Sprysprocket',919,919,20,20,0,{[1]={{45.85,49.37},},},nil,1,{412,},{412,},875,"A",},
[1270] = {'Fetid Corpse',950,1003,29,30,0,{[10]={{78.92,33.65},{76.34,37.15},{78.18,34.92},{78.72,36.07},{75.54,35.72},{75.23,36.79},{77.86,33.54},{75.82,33.96},{77.37,35.1},{76.94,32.71},{76.69,30.47},{79.19,31.25},{81.38,32.51},{79.85,32.94},},},nil,10,nil,nil,21,nil,},
[1271] = {'Old Icebeard',666,666,11,11,1,{[1]={{38.54,54.18},},},{[1]={{38.52,54.16},{38.45,54.13},{38.52,54.17},{38.59,54.23},{38.47,54.12},{38.05,53.84},{37.8,53.68},{37.59,53.54},{37.48,53.44},{37.37,52.94},{37.29,52.57},{37.32,52.18},{37.4,51.75},{37.68,51.36},{37.97,50.82},{37.81,51.16},{37.55,51.61},{37.32,51.92},{37.22,52.51},{37.2,52.91},{37.14,53.23},{37.3,53.28},{37.78,53.69},{38.25,53.98},},},1,nil,nil,16,nil,},
[1273] = {'Grawn Thromwyn',413,413,10,10,0,{[1]={{45.29,52.19},},},nil,1,nil,nil,55,"A",},
[1274] = {'Senator Barin Redstone',3517,3517,50,50,0,{[1537]={{39.55,57.49},},},nil,1537,nil,{291,},55,"A",},
[1275] = {'Kyra Boucher',1605,1605,30,30,0,{[1519]={{56.13,65.27},},},nil,1519,nil,nil,12,"A",},
[1276] = {'Mountaineer Brokk',1892,1892,30,30,0,{[38]={{26.02,16.78},},},{[1]={{91.65,28.03},{91.65,28.54},{91.65,28.93},{91.67,29.3},{91.74,29.94},{91.91,30.8},{92.09,31.61},{92.43,32.24},{92.81,32.95},{93.14,34.07},{93.35,34.83},{93.13,34.04},{92.8,32.92},{92.45,32.25},{92.05,31.64},{91.59,31.02},{91.33,30.72},{91.61,31.03},{92.0,31.53},{91.98,31.17},{91.84,30.41},{91.71,29.74},{91.66,29.02},{91.65,28.27},{91.65,27.55},{91.61,26.99},{91.53,26.48},{91.42,25.83},{91.39,25.34},{91.39,24.59},{91.39,25.24},{91.43,25.83},{91.56,26.66},{91.64,27.22},},[11]={{56.15,96.13},{56.15,96.74},{56.15,97.2},{56.18,97.64},{56.26,98.4},{56.46,99.43},{56.09,99.69},{55.77,99.33},{56.1,99.7},{56.54,99.87},{56.37,98.96},{56.23,98.16},{56.16,97.3},{56.15,96.41},{56.16,95.56},{56.1,94.88},{56.0,94.28},{55.87,93.5},{55.84,92.93},{55.84,92.03},{55.84,92.8},{55.89,93.5},{56.05,94.49},{56.14,95.17},},[38]={{26.03,16.85},{26.02,17.76},{26.02,18.45},{26.07,19.12},{26.2,20.26},{26.49,21.8},{26.82,23.24},{27.42,24.36},{28.1,25.62},{28.68,27.63},{29.05,28.98},{28.66,27.58},{28.08,25.57},{27.45,24.38},{26.74,23.28},{25.93,22.19},{25.46,21.64},{25.95,22.21},{26.65,23.1},{26.62,22.46},{26.36,21.09},{26.14,19.9},{26.04,18.61},{26.03,17.27},{26.03,15.99},{25.95,14.98},{25.81,14.08},{25.61,12.92},{25.57,12.05},{25.56,10.71},{25.57,11.87},{25.63,12.91},{25.87,14.39},{26.01,15.41},},},38,nil,nil,57,"A",},
[1277] = {'Mountaineer Ganin',1902,1902,30,30,0,{[38]={{24.16,20.27},},},{[1]={{90.67,29.99},{90.97,30.31},{91.34,30.73},{91.62,31.1},{91.91,31.5},{91.65,31.17},{91.29,30.73},{91.01,30.41},{90.68,30.01},{90.32,29.7},{89.86,29.34},{89.5,29.01},{89.03,28.66},{88.54,28.27},{88.29,28.16},{87.97,28.16},{88.3,28.13},{88.79,28.48},{89.15,28.78},{89.76,29.25},{90.22,29.63},{90.56,29.89},},[11]={{54.98,98.47},{55.34,98.84},{55.78,99.34},{56.11,99.79},{56.15,99.86},{55.72,99.35},{55.4,98.96},{55.0,98.49},{54.56,98.11},{54.02,97.69},{53.59,97.29},{53.03,96.87},{52.45,96.41},{52.15,96.28},{51.77,96.28},{52.16,96.25},{52.75,96.67},{53.17,97.02},{53.91,97.58},{54.45,98.03},{54.85,98.34},},[38]={{24.27,20.35},{24.81,20.92},{25.48,21.66},{25.97,22.33},{26.49,23.03},{26.03,22.44},{25.38,21.67},{24.89,21.1},{24.3,20.38},{23.65,19.82},{22.83,19.18},{22.18,18.59},{21.35,17.96},{20.48,17.27},{20.03,17.08},{19.46,17.08},{20.04,17.03},{20.92,17.66},{21.56,18.18},{22.66,19.02},{23.48,19.69},{24.07,20.16},},},38,nil,nil,57,"A",},
[1278] = {'Mountaineer Stenn',1454,1454,28,28,0,{[38]={{32.5,49.65},},},{[1]={{95.27,46.41},{95.22,46.46},{95.15,46.46},{95.1,46.29},{94.96,45.94},{94.82,45.66},{94.69,45.39},{94.64,45.11},{94.62,44.76},{94.66,44.19},{94.85,43.3},{94.66,44.19},{94.63,44.74},{94.66,45.17},{94.68,45.36},{94.76,45.54},{94.96,45.94},{95.15,46.2},{95.25,46.28},{95.29,46.39},{95.29,46.39},},[38]={{32.5,49.65},{32.41,49.74},{32.28,49.74},{32.19,49.44},{31.94,48.82},{31.68,48.31},{31.46,47.83},{31.37,47.33},{31.33,46.71},{31.4,45.69},{31.74,44.11},{31.4,45.69},{31.34,46.66},{31.4,47.43},{31.44,47.77},{31.58,48.1},{31.95,48.81},{32.28,49.27},{32.46,49.42},{32.52,49.61},{32.52,49.61},},},38,nil,nil,57,"A",},
[1279] = {'Mountaineer Flint',1890,1890,30,30,0,{[38]={{29.57,30.2},},},{[1]={{93.64,35.54},{93.77,35.86},{93.88,36.26},{94.08,37.31},{94.15,37.97},{94.25,38.64},{94.35,39.34},{94.47,40.1},{94.63,40.59},{94.72,40.8},{94.52,40.44},{94.43,39.91},{94.37,39.49},{94.19,38.24},{94.09,37.35},{94.02,36.94},{93.85,36.13},{93.72,35.75},{93.36,34.84},{93.14,34.1},{93.06,33.69},{92.8,32.85},{92.63,32.51},{92.32,31.95},{92.13,31.62},{92.02,31.34},{91.92,31.29},{91.94,31.49},{92.11,31.83},{92.4,32.27},{92.67,32.82},{92.86,33.3},{93.05,33.99},{93.25,34.69},{93.52,35.23},},[38]={{29.59,30.25},{29.81,30.83},{30.0,31.54},{30.37,33.41},{30.49,34.59},{30.66,35.78},{30.85,37.03},{31.07,38.38},{31.34,39.27},{31.51,39.63},{31.16,38.99},{31.0,38.05},{30.89,37.31},{30.57,35.08},{30.39,33.48},{30.25,32.74},{29.96,31.3},{29.72,30.63},{29.07,29.0},{28.69,27.67},{28.54,26.95},{28.09,25.44},{27.78,24.84},{27.22,23.84},{26.89,23.25},{26.68,22.75},{26.5,22.67},{26.54,23.03},{26.85,23.64},{27.37,24.42},{27.86,25.39},{28.18,26.25},{28.54,27.48},{28.89,28.73},{29.37,29.7},},},38,nil,nil,57,"A",},
[1280] = {'Mountaineer Droken',1454,1454,28,28,0,{[38]={{32.28,51.43},},},{[1]={{95.05,48.09},{94.99,48.44},{94.95,48.72},{94.92,49.05},{94.88,49.4},{94.82,49.72},{94.78,50.04},{94.73,50.26},{94.69,50.46},{94.55,50.68},{94.43,50.83},{94.3,51.0},{94.1,51.26},{93.92,51.52},{93.82,51.69},{93.73,51.87},{93.61,52.21},{93.88,51.59},{94.15,51.2},{94.48,50.82},{94.68,50.53},{94.74,50.33},{94.87,49.42},{94.93,48.84},{95.04,48.15},{95.15,47.41},{95.16,46.93},{95.2,46.81},{95.27,46.75},{95.2,46.81},{95.16,46.93},{95.15,47.41},},[38]={{32.11,52.65},{31.99,53.28},{31.93,53.77},{31.88,54.36},{31.79,54.99},{31.69,55.57},{31.62,56.13},{31.53,56.53},{31.45,56.88},{31.21,57.28},{30.99,57.54},{30.76,57.84},{30.41,58.31},{30.08,58.77},{29.9,59.07},{29.75,59.4},{29.53,60.0},{30.01,58.89},{30.5,58.21},{31.07,57.53},{31.43,57.01},{31.54,56.65},{31.77,55.03},{31.89,53.98},{32.09,52.75},{32.28,51.43},{32.29,50.58},{32.37,50.36},{32.48,50.26},{32.37,50.36},{32.29,50.58},{32.28,51.43},},},38,nil,nil,57,"A",},
[1281] = {'Mountaineer Zaren',1454,1454,28,28,0,{[38]={{22.78,70.76},},},{[1]={{89.9,58.16},{90.1,58.04},{90.31,57.74},{90.56,57.35},{90.84,56.93},{90.69,57.15},{90.41,57.58},{90.21,57.88},{90.03,58.13},{89.76,58.04},{89.61,57.88},{89.68,58.21},{89.61,58.63},{89.37,59.0},{89.14,59.39},{88.93,59.82},{88.57,60.63},{88.77,60.21},{89.02,59.64},{89.26,59.21},{89.53,58.83},{89.91,58.29},},[38]={{22.91,70.62},{23.26,70.4},{23.63,69.87},{24.08,69.18},{24.58,68.43},{24.31,68.83},{23.82,69.58},{23.45,70.12},{23.13,70.57},{22.66,70.4},{22.39,70.13},{22.51,70.71},{22.38,71.46},{21.96,72.12},{21.55,72.82},{21.17,73.59},{20.52,75.04},{20.89,74.28},{21.33,73.27},{21.76,72.49},{22.24,71.83},{22.93,70.85},},},38,nil,nil,57,"A",},
[1282] = {'Mountaineer Veek',1605,1605,30,30,0,{[38]={{21.4,67.33},},},{[1]={{89.09,56.15},{89.13,55.86},{89.11,55.52},{88.96,55.03},{88.8,54.68},{88.68,54.51},{88.44,54.16},{88.29,53.95},{88.17,53.84},{88.42,54.11},{88.59,54.36},{88.79,54.64},{88.95,54.91},{89.07,55.38},{89.13,55.71},{89.12,56.0},{89.03,56.46},{89.02,56.81},{89.12,57.1},{89.37,57.37},{89.53,57.78},{89.43,57.5},{89.19,57.15},{89.01,56.75},{89.04,56.44},},[38]={{21.46,67.04},{21.54,66.52},{21.5,65.92},{21.23,65.03},{20.93,64.4},{20.73,64.11},{20.3,63.49},{20.03,63.1},{19.82,62.9},{20.26,63.39},{20.56,63.85},{20.93,64.33},{21.21,64.83},{21.41,65.66},{21.53,66.25},{21.51,66.77},{21.35,67.59},{21.33,68.22},{21.52,68.73},{21.95,69.21},{22.24,69.94},{22.06,69.45},{21.64,68.81},{21.32,68.11},{21.36,67.55},},},38,nil,nil,57,"A",},
[1283] = {'Mountaineer Kalmir',1605,1605,30,30,0,{[38]={{21.31,73.29},},},{[1]={{89.17,59.36},{89.37,59.04},{89.64,58.66},{89.32,59.12},{89.06,59.56},{88.93,59.8},{88.68,60.41},{88.53,60.71},{88.35,61.03},{88.21,61.33},{88.12,61.57},{88.07,61.79},{88.02,62.17},{88.01,62.58},{87.97,62.93},{87.92,63.38},{87.84,63.8},{87.77,64.21},{87.64,64.65},{87.5,64.97},{87.39,65.22},{87.18,65.36},{87.36,65.27},{87.56,64.85},{87.66,64.56},{87.75,64.24},{87.85,63.72},{87.95,63.08},{88.0,62.62},{88.02,62.09},{88.07,61.77},{88.14,61.52},{88.22,61.28},{88.53,60.71},{88.69,60.38},{88.84,59.99},{89.01,59.66},},[38]={{21.6,72.77},{21.96,72.2},{22.45,71.52},{21.86,72.34},{21.41,73.12},{21.16,73.54},{20.72,74.63},{20.46,75.17},{20.13,75.75},{19.88,76.28},{19.73,76.71},{19.64,77.1},{19.55,77.79},{19.52,78.51},{19.46,79.13},{19.36,79.94},{19.23,80.69},{19.09,81.42},{18.87,82.22},{18.62,82.78},{18.41,83.22},{18.04,83.47},{18.38,83.31},{18.73,82.57},{18.91,82.05},{19.07,81.47},{19.24,80.55},{19.42,79.41},{19.52,78.59},{19.55,77.63},{19.64,77.06},{19.76,76.62},{19.9,76.19},{20.46,75.18},{20.75,74.58},{21.02,73.89},{21.31,73.29},},[3]={{18.61,0.07},{18.44,0.55},{18.34,0.98},{18.24,1.74},{18.21,2.55},{18.15,3.23},{18.03,4.13},{17.89,4.97},{17.74,5.77},{17.49,6.65},{17.22,7.28},{16.98,7.76},{16.57,8.04},{16.94,7.87},{17.34,7.05},{17.54,6.47},{17.71,5.83},{17.9,4.81},{18.1,3.54},{18.21,2.63},{18.24,1.57},{18.34,0.93},{18.47,0.44},},},38,nil,nil,57,"A",},
[1284] = {'Archbishop Benedictus',466400,466400,63,63,3,{[1519]={{39.59,27.24},},},nil,1519,{3636,},{293,3636,},12,"A",},
[1285] = {'Thurman Mullby',1605,1605,30,30,0,{[1519]={{58.37,61.68},},},nil,1519,nil,nil,12,"A",},
[1286] = {'Edna Mullby',1605,1605,30,30,0,{[1519]={{58.23,60.51},},},nil,1519,nil,nil,12,"A",},
[1287] = {'Marda Weller',1605,1605,30,30,0,{[1519]={{57.38,56.77},},},nil,1519,nil,nil,12,"A",},
[1289] = {'Gunther Weller',1605,1605,30,30,0,{[1519]={{57.55,57.07},},},nil,1519,nil,nil,12,"A",},
[1291] = {'Carla Granger',1605,1605,30,30,0,{[1519]={{54.73,56.03},},},nil,1519,nil,nil,12,"A",},
[1292] = {'Maris Granger',2016,2016,35,35,0,{[1519]={{67.81,48.82},},},nil,1519,nil,nil,12,"A",},
[1294] = {'Aldric Moore',1605,1605,30,30,0,{[1519]={{54.58,55.24},},},nil,1519,nil,nil,12,"A",},
[1295] = {'Lara Moore',1605,1605,30,30,0,{[1519]={{54.66,55.62},},},nil,1519,nil,nil,12,"A",},
[1296] = {'Felder Stover',3748,3748,52,52,0,{[46]={{85.21,68.39},},},nil,46,nil,nil,12,"A",},
[1297] = {'Lina Stover',1605,1605,30,30,0,{[1519]={{50.46,57.23},},},nil,1519,nil,nil,12,"A",},
[1298] = {'Frederick Stover',1605,1605,30,30,0,{[1519]={{49.98,57.64},},},nil,1519,nil,nil,12,"A",},
[1299] = {'Lisbeth Schneider',1605,1605,30,30,0,{[1519]={{49.92,55.2},},},nil,1519,nil,nil,12,"A",},
[1300] = {'Lawrence Schneider',1240,1240,25,25,0,{[1519]={{43.69,73.71},},},nil,1519,nil,nil,12,"A",},
[1301] = {'Julia Gallina',1605,1605,30,30,0,{[1519]={{52.02,68.83},},},nil,1519,nil,nil,12,"A",},
[1302] = {'Bernard Gump',1605,1605,30,30,0,{[1519]={{64.06,61.26},},},nil,1519,nil,nil,12,"A",},
[1303] = {'Felicia Gump',1605,1605,30,30,0,{[1519]={{64.19,60.6},},},nil,1519,nil,nil,12,"A",},
[1304] = {'Darian Singh',1605,1605,30,30,0,{[1519]={{29.42,67.85},},},nil,1519,nil,nil,12,"A",},
[1305] = {'Jarel Moor',1605,1605,30,30,0,{[1519]={{28.81,75.32},},},nil,1519,nil,nil,12,"A",},
[1307] = {'Charys Yserian',3517,3517,50,50,0,{[1519]={{32.19,79.9},},},nil,1519,nil,nil,12,"A",},
[1308] = {'Owen Vaughn',1605,1605,30,30,0,{[1519]={{35.85,74.99},},},nil,1519,nil,nil,12,"A",},
[1309] = {'Wynne Larson',1605,1605,30,30,0,{[1519]={{41.54,76.33},},},nil,1519,{1941,1942,},{1921,1940,1941,1942,},12,"A",},
[1310] = {'Evan Larson',1605,1605,30,30,0,{[1519]={{42.62,76.55},},},nil,1519,nil,nil,12,"A",},
[1311] = {'Joachim Brenlow',1605,1605,30,30,0,{[1519]={{41.06,90.05},},},nil,1519,nil,nil,12,"A",},
[1312] = {'Ardwyn Cailen',1605,1605,30,30,0,{[1519]={{42.84,65.17},},},nil,1519,nil,nil,12,"A",},
[1313] = {'Maria Lumere',1605,1605,30,30,0,{[1519]={{46.81,79.09},},},nil,1519,nil,nil,12,"A",},
[1314] = {'Duncan Cullen',1605,1605,30,30,0,{[1519]={{43.3,74.45},},},nil,1519,nil,nil,12,"A",},
[1315] = {'Allan Hafgan',1605,1605,30,30,0,{[1519]={{43.08,65.22},},},nil,1519,nil,nil,12,"A",},
[1316] = {'Adair Gilroy',3857,3857,60,60,0,{[1519]={{41.56,65.5},},},nil,1519,nil,nil,12,"A",},
[1317] = {'Lucan Cordell',2016,2016,35,35,0,{[1519]={{42.94,64.65},},},nil,1519,nil,nil,12,"A",},
[1318] = {'Jessara Cordell',1605,1605,30,30,0,{[1519]={{42.81,64.39},},},nil,1519,nil,nil,12,"A",},
[1319] = {'Bryan Cross',1605,1605,30,30,0,{[1519]={{63.99,42.91},},},nil,1519,nil,nil,12,"A",},
[1320] = {'Seoman Griffith',1605,1605,30,30,0,{[1519]={{67.45,48.53},},},nil,1519,nil,nil,12,"A",},
[1321] = {'Alyssa Griffith',1605,1605,30,30,0,{[1519]={{67.22,48.81},},},nil,1519,nil,nil,12,"A",},
[1322] = {'Maxton Strang',2471,2471,40,40,0,{[405]={{67.93,8.31},},},nil,405,nil,nil,12,"A",},
[1323] = {'Osric Strang',1605,1605,30,30,0,{[1519]={{74.31,47.24},},},nil,1519,{6261,},{6281,},12,"A",},
[1324] = {'Heinrich Stone',1605,1605,30,30,0,{[1519]={{74.37,42.56},},},nil,1519,nil,nil,12,"A",},
[1325] = {'Jasper Fel',1605,1605,30,30,0,{[1519]={{78.32,58.98},},},nil,1519,nil,nil,12,"A",},
[1326] = {'Sloan McCoy',1240,1240,25,25,0,{[1519]={{76.19,59.99},},},nil,1519,nil,nil,12,"A",},
[1327] = {'Reese Langston',1605,1605,30,30,0,{[1519]={{74.14,36.53},},},nil,1519,nil,nil,12,"A",},
[1328] = {'Elly Langston',3481,3481,60,60,0,{[1519]={{73.41,38.6},},},{[12]={{33.06,28.96},{33.17,29.18},{33.12,29.37},{32.87,29.6},{32.88,29.72},{33.0,29.73},{33.18,29.51},{33.37,29.28},{33.44,29.21},{33.42,29.02},{33.08,28.53},{33.02,28.52},{32.84,28.73},{32.63,29.01},{32.61,29.19},{32.7,29.21},{32.95,28.92},},[1519]={{73.87,36.93},{74.16,37.5},{74.01,37.99},{73.37,38.59},{73.41,38.9},{73.71,38.93},{74.18,38.35},{74.68,37.76},{74.84,37.57},{74.79,37.09},{73.93,35.83},{73.76,35.79},{73.31,36.33},{72.76,37.06},{72.71,37.54},{72.93,37.58},{73.58,36.83},},},1519,nil,nil,12,"A",},
[1329] = {'Mountaineer Naarh',1605,1605,30,30,0,{[38]={{23.24,76.04},},},nil,38,nil,nil,57,"A",},
[1330] = {'Mountaineer Tyraw',1605,1605,30,30,0,{[38]={{22.85,74.06},},},nil,38,nil,nil,57,"A",},
[1331] = {'Mountaineer Luxst',1605,1605,30,30,0,{[38]={{24.17,17.57},},},nil,38,nil,nil,57,"A",},
[1332] = {'Mountaineer Morran',1605,1605,30,30,0,{[38]={{23.36,17.07},},},nil,38,nil,nil,57,"A",},
[1333] = {'Gerik Koen',1605,1605,30,30,0,{[1519]={{68.92,42.67},},},nil,1519,nil,nil,12,"A",},
[1334] = {'Mountaineer Hammerfall',1605,1605,30,30,0,{[38]={{24.49,18.5},},},nil,38,nil,nil,57,"A",},
[1335] = {'Mountaineer Yuttha',1605,1605,30,30,0,{[38]={{24.74,17.71},},},nil,38,nil,nil,57,"A",},
[1336] = {'Mountaineer Zwarn',1605,1605,30,30,0,{[38]={{25.62,18.11},},},nil,38,nil,nil,57,"A",},
[1337] = {'Mountaineer Gwarth',1454,1454,28,28,0,{[38]={{35.93,44.49},},},{[1]={{97.19,43.51},{97.23,43.16},{97.19,43.53},{97.13,43.72},{96.97,43.92},{96.76,43.86},{96.58,43.61},{96.59,43.84},{96.63,44.43},{96.67,44.83},{96.62,44.46},{96.63,43.93},{96.77,43.95},{96.98,43.94},{97.14,43.69},},[38]={{35.93,44.47},{35.99,43.85},{35.91,44.51},{35.81,44.86},{35.53,45.2},{35.15,45.1},{34.83,44.65},{34.84,45.07},{34.92,46.12},{34.98,46.82},{34.9,46.16},{34.93,45.23},{35.17,45.25},{35.54,45.25},{35.83,44.79},},},38,nil,nil,57,"A",},
[1338] = {'Mountaineer Dalk',1454,1454,28,28,0,{[38]={{36.27,41.69},},},nil,38,nil,nil,57,"A",},
[1339] = {'Mayda Thane',3294,3294,48,48,0,{[1519]={{67.22,43.62},},},nil,1519,nil,nil,12,"A",},
[1340] = {'Mountaineer Kadrell',1605,1605,30,30,0,{[38]={{34.26,47.71},},},{[1]={{96.22,45.38},{96.0,45.72},{95.6,46.27},{95.3,46.54},{95.55,46.31},{95.76,46.06},{96.15,45.5},{96.43,45.1},{96.4,44.92},{96.24,44.78},{96.41,44.88},{96.52,45.16},{96.52,45.46},{96.53,45.04},{96.8,44.92},{97.02,44.82},{97.18,45.13},{97.4,45.5},{97.22,45.2},{97.15,44.76},{97.25,44.52},{97.38,44.56},{97.72,44.58},{97.74,44.67},{97.76,44.81},{97.76,44.65},{97.66,44.58},{97.27,44.53},{96.81,44.86},{96.74,44.68},{96.7,44.42},{96.68,44.04},{96.62,43.74},{96.56,43.54},{96.55,43.88},{96.6,44.29},{96.63,44.6},{96.53,44.89},{96.34,45.14},},[38]={{34.19,47.82},{33.79,48.42},{33.07,49.4},{32.55,49.89},{33.0,49.48},{33.36,49.02},{34.05,48.03},{34.57,47.31},{34.5,47.0},{34.23,46.75},{34.53,46.91},{34.72,47.43},{34.73,47.95},{34.74,47.21},{35.22,46.99},{35.62,46.82},{35.91,47.36},{36.3,48.04},{35.98,47.49},{35.85,46.71},{36.02,46.27},{36.26,46.34},{36.87,46.38},{36.91,46.55},{36.94,46.79},{36.93,46.51},{36.75,46.38},{36.06,46.3},{35.24,46.88},{35.11,46.57},{35.05,46.09},{35.02,45.43},{34.9,44.89},{34.79,44.52},{34.77,45.13},{34.86,45.87},{34.91,46.43},{34.75,46.94},{34.4,47.39},},},38,{416,467,468,1339,},{414,416,},55,"A",},
[1341] = {'Wilhelm Strang',1605,1605,30,30,0,{[1519]={{74.75,47.64},},},nil,1519,nil,nil,12,"A",},
[1342] = {'Mountaineer Rockgar',1904,1904,30,30,0,{[38]={{25.44,10.38},},},nil,38,{455,},{468,},55,"A",},
[1343] = {'Mountaineer Stormpike',1605,1605,30,30,0,{[38]={{24.76,18.4},},},nil,38,{307,1338,},{307,353,1339,},55,"A",},
[1344] = {'Prospector Ironband',644,644,15,15,0,{[38]={{65.93,65.62},},},nil,38,{298,704,738,},{309,704,707,739,},55,"A",},
[1345] = {'Magmar Fellhew',644,644,15,15,0,{[38]={{64.9,66.66},},},nil,38,{297,},{297,436,},55,"A",},
[1346] = {'Georgio Bolero',3077,3077,46,46,0,{[1519]={{43.17,73.55},},},nil,1519,nil,nil,12,"A",},
[1347] = {'Alexandra Bolero',1605,1605,30,30,0,{[1519]={{43.25,74.08},},},nil,1519,nil,nil,12,"A",},
[1348] = {'Gregory Ardus',1605,1605,30,30,0,{[1519]={{36.77,39.51},},},nil,1519,nil,nil,12,"A",},
[1349] = {'Agustus Moulaine',1605,1605,30,30,0,{[1519]={{43.73,42.81},},},nil,1519,nil,nil,12,"A",},
[1350] = {'Theresa Moulaine',1605,1605,30,30,0,{[1519]={{43.34,43.29},},},nil,1519,nil,nil,12,"A",},
[1351] = {'Brother Cassius',1605,1605,30,30,0,{[1519]={{43.38,26.79},},},nil,1519,nil,nil,12,"A",},
[1352] = {'Fluffy',1,1,1,1,0,{[1]={{63.02,50.83},},},{[1]={{62.9,50.92},{62.72,51.11},{62.61,51.37},{62.66,51.61},{62.83,51.69},{63.32,50.97},{63.38,50.63},{63.3,50.27},{63.19,49.75},{63.14,49.32},{63.33,49.0},{63.57,48.91},{64.02,49.34},{64.24,49.62},{64.63,49.81},{64.78,50.15},{64.85,50.41},{65.02,50.54},{65.17,50.47},{65.22,50.23},{65.13,49.93},{64.62,49.8},{64.24,49.6},{64.02,49.34},{63.57,48.91},{63.33,49.0},{63.15,49.31},{63.19,49.76},{63.3,50.27},{63.3,50.56},{63.17,50.75},},},1,nil,nil,55,"A",},
[1353] = {'Sarltooth',950,950,29,29,0,{[11]={{33.26,51.51},},},nil,11,nil,nil,48,nil,},
[1354] = {'Apprentice Soren',112,112,3,3,0,{[1]={{25.18,75.89},},},nil,1,nil,nil,55,"A",},
[1355] = {'Cook Ghilm',372,372,9,9,0,{[1]={{68.38,54.49},},},{[1]={{68.38,54.49},{68.4,54.45},},},1,nil,nil,55,"A",},
[1356] = {'Prospector Stormpike',1605,1605,30,30,0,{[1537]={{74.64,11.74},},},nil,1537,{302,525,707,2398,},{301,514,554,2240,},55,"A",},
[1358] = {'Miner Grothor',334,334,8,8,0,{[1]={{69.15,55.2},},},nil,1,nil,nil,57,"A",},
[1360] = {'Miner Grumnal',372,372,9,9,0,{[1]={{69.01,55.08},},},nil,1,nil,nil,57,"A",},
[1362] = {'Gothor Brumn',804,804,18,18,0,{[38]={{24.13,18.21},},},nil,38,nil,nil,55,"A",},
[1364] = {'Balgaras the Foul',4487,4487,34,34,1,{[11]={{62.49,28.42},},},nil,11,nil,nil,54,nil,},
[1365] = {'Goli Krumn',413,413,10,10,0,{[1537]={{30.24,59.41},},},nil,1537,{7062,},nil,55,"A",},
[1366] = {'Adam',64,64,1,1,0,{[1519]={{62.9,52.26},},},nil,1519,nil,nil,12,"A",},
[1367] = {'Billy',64,64,1,1,0,{[1519]={{62.95,52.11},},},nil,1519,nil,nil,12,"A",},
[1368] = {'Justin',64,64,1,1,0,{[1519]={{35.09,44.25},},},{[12]={{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},{25.98,27.76},},[1519]={{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},{55.59,33.82},},},1519,nil,nil,12,"A",},
[1370] = {'Brandon',64,64,1,1,0,{[1519]={{34.98,44.16},},},{[12]={{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},{25.94,27.69},},[1519]={{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},{55.48,33.65},},},1519,nil,nil,12,"A",},
[1371] = {'Roman',64,64,1,1,0,{[1519]={{34.9,44.01},},},{[12]={{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},{26.0,27.84},},[1519]={{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},{55.63,34.03},},},1519,nil,nil,12,"A",},
[1373] = {'Jarven Thunderbrew',644,644,15,15,0,{[1]={{47.65,52.66},},},{[1]={{47.58,52.52},{47.6,52.41},{47.73,52.41},{47.74,52.64},{47.69,52.7},{47.53,52.4},{47.36,52.4},{47.35,52.59},{47.35,52.59},{47.36,52.4},{47.53,52.4},{47.69,52.7},{47.74,52.64},{47.73,52.41},{47.6,52.41},{47.58,52.52},{47.65,52.66},{47.65,52.66},},},1,{308,},{308,},55,"A",},
[1374] = {'Rejold Barleybrew',413,413,10,10,0,{[1]={{30.19,45.73},},},nil,1,{315,319,320,413,},{315,318,319,415,},55,"A",},
[1375] = {'Marleth Barleybrew',500,500,12,12,0,{[1]={{30.19,45.53},},},nil,1,{310,},{311,},55,"A",},
[1376] = {'Beldin Steelgrill',500,500,12,12,0,{[1]={{50.44,49.09},},},nil,1,nil,{400,},55,"A",},
[1377] = {'Pilot Stonegear',919,919,20,20,0,{[1]={{49.62,48.61},},},nil,1,{313,466,},{313,466,467,},55,"A",},
[1378] = {'Pilot Bellowfiz',804,804,18,18,0,{[1]={{49.43,48.41},},},nil,1,{317,318,415,},{317,320,},55,"A",},
[1379] = {'Miran',644,644,15,15,0,{[38]={{52.21,69.43},},},nil,38,{309,},{454,},1618,"A",},
[1380] = {'Saean',196,196,10,10,0,{},nil,0,nil,nil,55,"A",},
[1381] = {'Krakk',2284,2284,38,38,0,{[33]={{32.57,27.95},},},nil,33,nil,nil,29,"H",},
[1382] = {'Mudduk',2471,2471,40,40,0,{[33]={{31.34,27.97},},},nil,33,nil,nil,29,"H",},
[1383] = {'Snarl',1684,1684,31,31,0,{[1637]={{79.6,23.31},},},nil,1637,nil,nil,29,"H",},
[1385] = {'Brawn',2016,2016,35,35,0,{[33]={{31.74,28.9},},},nil,33,nil,nil,29,"H",},
[1386] = {'Rogvar',3866,3866,53,53,0,{[8]={{48.53,55.85},},},nil,8,nil,nil,29,"H",},
[1387] = {'Thysta',7842,7842,55,55,1,{[33]={{32.54,29.35},},},nil,33,nil,nil,29,"H",},
[1388] = {'Vagash',666,666,11,11,1,{[1]={{62.62,46.05},},},{[1]={{62.59,46.09},{62.43,46.41},{62.28,46.73},{62.18,47.06},{62.11,47.28},{62.39,48.45},{62.32,48.89},{62.4,48.23},{62.22,47.6},{62.16,47.4},{61.89,47.17},{61.59,47.11},{62.05,47.13},{62.22,46.89},{62.44,46.4},{62.53,46.19},{62.65,45.99},},},1,nil,nil,24,nil,},
[1393] = {'Berserk Trogg',449,484,19,20,0,{[38]={{68.0,65.78},{68.69,62.41},{68.23,62.55},{70.87,64.28},{72.62,63.3},},},nil,38,nil,nil,59,nil,},
[1395] = {'Ol\' Beasley',413,413,10,10,0,{[1519]={{69.68,46.08},},},nil,1519,nil,nil,12,"A",},
[1397] = {'Frostmane Seer',148,166,8,9,0,{[1]={{43.06,35.86},{40.34,42.86},{41.09,44.87},{41.48,45.01},{41.39,44.38},{41.16,44.47},{41.62,43.82},{42.1,45.52},{42.11,44.59},{41.14,45.54},{40.75,34.91},{40.67,34.98},{41.28,34.34},{41.85,35.84},{41.81,35.62},{41.54,35.32},{42.25,36.6},{42.82,36.59},{42.07,34.35},{42.31,34.93},{42.46,35.79},{41.76,35.23},{42.55,33.75},},},nil,1,nil,nil,37,nil,},
[1398] = {'Boss Galgosh',573,573,22,22,4,{[38]={{68.07,65.93},},},nil,38,nil,nil,59,nil,},
[1399] = {'Magosh',473,473,21,21,4,{[38]={{70.12,66.39},},},nil,38,nil,nil,59,nil,},
[1400] = {'Wetlands Crocolisk',617,664,23,24,0,{[11]={{20.55,56.72},{19.27,58.23},{21.27,58.11},{18.18,51.4},{38.58,27.66},{44.97,30.45},{18.98,55.63},{33.68,26.78},{17.48,55.77},{34.31,31.33},{19.11,56.66},{36.46,29.33},{43.82,32.95},{37.0,28.0},{36.15,27.51},{41.0,28.39},{21.72,25.63},{32.62,31.58},{48.57,34.65},{46.57,33.5},{17.16,54.38},{39.32,29.53},{33.62,27.98},{47.46,31.27},{33.52,29.51},{18.41,53.66},{24.81,26.88},{34.68,26.89},{34.59,28.95},{35.25,30.22},{37.86,26.64},{28.65,27.49},{17.76,53.43},{25.39,44.57},{42.19,35.82},{46.22,36.83},{44.55,35.87},{38.81,33.23},{41.66,32.78},{29.52,32.56},{36.18,31.57},{39.74,31.27},{37.49,31.53},{40.49,30.84},{23.99,30.2},{24.79,29.26},{41.0,34.59},{32.02,25.32},{28.06,25.35},{41.78,36.63},{29.84,26.1},{20.12,27.21},},},nil,11,nil,nil,14,nil,},
[1402] = {'Topper McNabb',64,64,1,1,0,{[1519]={{52.5,57.61},},},nil,1519,nil,nil,12,"A",},
[1404] = {'Kragg',2471,2471,40,40,0,{[33]={{31.23,28.68},},},nil,33,nil,nil,29,"H",},
[1405] = {'Morris Lawry',64,64,1,1,0,{[1519]={{43.13,48.51},},},nil,1519,nil,nil,12,"A",},
[1407] = {'Sranda',2471,2471,40,40,0,{[3]={{2.91,47.25},},},nil,3,nil,nil,29,"H",},
[1411] = {'Ian Strom',3184,3184,47,47,0,{[33]={{26.82,77.15},},},nil,33,nil,nil,120,"AH",},
[1412] = {'Squirrel',8,8,1,1,0,{[38]={{60.27,17.7},{21.1,70.99},{39.85,46.84},{39.84,45.66},{33.48,51.81},{33.58,45.85},{30.2,10.85},{66.31,37.62},{58.75,15.86},{66.01,41.38},{21.09,72.76},{58.95,77.87},{57.73,70.01},{47.97,72.32},{38.85,42.45},{29.08,39.41},{28.17,29.04},{31.23,32.0},{39.3,35.34},{39.34,48.59},{62.44,36.19},{61.17,23.62},{62.48,28.94},{28.43,17.46},{43.23,65.06},{21.07,17.44},{20.68,71.68},{39.38,48.99},{28.41,58.65},{19.44,76.07},{40.21,29.53},{29.92,41.07},{35.82,36.18},{28.36,43.48},{64.82,43.27},{35.52,50.86},{26.25,33.11},{24.82,26.7},{22.17,75.55},{34.61,46.49},{20.0,77.82},{36.02,44.8},{30.93,50.75},{36.25,47.07},{32.45,55.97},{36.46,45.26},},[130]={{53.12,43.82},{35.26,16.04},{51.57,62.29},},[15]={{65.3,52.23},{63.69,49.87},{65.85,52.46},{66.45,52.23},{66.94,45.61},{68.36,49.56},{64.18,47.51},{65.9,44.6},{68.01,47.01},{67.09,49.23},{66.99,50.84},{65.82,50.47},{64.71,46.95},{64.95,50.55},},[406]={{39.73,7.78},{71.11,45.55},{68.09,48.0},{80.06,95.39},{76.81,90.12},{59.36,70.66},{30.88,11.34},{74.94,84.15},{51.97,45.77},{65.43,37.85},{34.14,9.87},{34.39,17.91},{75.81,50.33},{51.44,42.77},{62.01,59.91},{77.76,86.12},{82.01,88.24},{81.24,84.81},{52.68,59.34},{81.89,91.04},{78.02,43.08},{51.38,36.4},{69.56,40.97},{78.7,94.83},{66.87,85.8},{53.7,61.93},{68.62,89.17},{72.34,94.53},{59.51,76.95},{47.35,32.97},{43.45,16.87},{60.51,81.69},{77.06,90.69},},[331]={{40.68,61.76},{27.74,47.85},{52.0,66.17},{44.45,42.02},{66.75,50.82},{20.82,59.46},{65.34,44.31},{43.84,45.32},{55.32,33.68},{81.74,52.48},{32.76,39.03},{69.1,66.16},{19.01,22.25},},[148]={{61.17,11.34},{45.91,55.48},{43.37,56.46},{48.38,37.25},{41.0,38.16},{41.25,50.09},},[493]={{37.02,69.62},{35.82,56.23},{36.14,59.57},{34.8,58.41},{33.04,62.18},{38.8,31.91},{65.63,56.56},{35.61,54.3},{57.85,27.98},{54.69,75.11},{48.01,63.0},{65.22,50.51},{62.04,49.92},{33.42,44.65},{36.99,53.95},{34.53,59.89},{68.08,53.73},{39.41,56.31},{52.14,71.55},{30.62,53.42},{42.32,34.87},{37.67,62.61},{48.51,31.93},{70.61,50.39},{56.27,66.14},{38.99,44.23},{64.56,69.05},{32.02,58.13},{41.35,32.76},{41.0,62.89},{49.14,42.92},{37.18,43.6},{70.67,56.55},{37.13,45.19},{31.5,48.71},{33.69,58.11},{39.19,34.39},{37.14,36.58},{39.69,60.78},{40.68,57.17},{35.57,64.71},{52.6,31.08},{32.05,56.3},{51.88,64.14},{63.59,46.29},{32.42,32.24},{42.35,53.47},{62.82,64.57},{32.31,52.96},{36.05,65.4},{51.46,66.89},{50.57,36.15},{52.11,39.19},{41.63,58.55},{44.77,60.26},{40.05,44.64},{36.4,51.78},{47.69,64.59},{32.7,40.21},{62.3,69.74},{33.42,54.8},{35.66,47.97},{35.18,39.4},{71.45,60.28},{64.52,62.94},{39.17,68.13},{47.87,34.1},{60.96,65.82},{51.81,46.31},{50.49,32.58},{40.74,40.28},{55.23,30.3},{45.96,44.62},{38.69,65.89},{43.95,58.72},{66.24,50.11},{31.0,54.52},{59.21,33.42},{34.93,33.01},{37.13,69.63},{38.67,47.53},{47.77,65.85},{35.11,43.94},{48.66,31.72},},[1657]={{68.78,51.78},{34.41,60.01},{65.19,65.04},{72.82,49.86},{30.75,40.46},{38.13,45.18},{52.61,16.26},{66.04,30.41},{41.95,15.93},{65.89,74.88},{49.0,76.57},{35.3,52.38},{61.79,74.95},{69.86,57.71},{56.42,48.09},{59.03,74.05},{53.98,30.72},{59.59,51.38},{54.21,9.48},{52.57,88.68},{60.39,6.15},{68.49,55.82},{52.34,87.44},{47.43,68.37},{49.49,31.12},{37.99,18.0},{64.12,73.62},{74.15,31.33},{54.31,72.39},{53.43,21.07},{67.84,57.95},{58.47,10.93},{61.69,25.45},{35.33,12.76},{59.46,29.96},{47.36,29.46},{58.3,72.0},{53.48,71.5},{62.25,11.35},{44.94,21.91},{39.29,9.4},{59.34,56.05},{39.05,37.76},{51.67,82.34},{50.44,19.53},{50.65,75.56},{49.7,10.2},{58.56,64.52},{41.54,42.75},{40.35,36.91},{49.54,10.28},},[357]={{54.5,67.36},{54.28,69.75},{54.79,46.05},{46.92,9.01},{73.26,39.22},{56.79,56.34},{55.65,53.82},{73.7,56.21},{71.16,53.24},{56.1,61.75},},[1519]={{39.29,80.57},{38.85,77.33},{37.24,75.88},{31.54,73.98},{31.35,69.52},{36.63,68.74},},[2557]={{-1, -1}},},nil,493,nil,nil,31,"AH",},
[1413] = {'Janey Anship',1240,1240,25,25,0,{[1519]={{38.82,79.61},},},{[12]={{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.49,45.49},{19.76,45.4},{20.52,45.6},{21.17,45.4},{21.67,44.99},{22.03,44.14},{21.96,42.8},{21.64,42.28},{21.47,41.91},{22.43,40.67},{22.34,40.23},{23.01,39.39},{23.81,38.83},{24.73,38.28},{24.87,38.66},{25.24,39.33},{26.5,37.86},{27.23,36.89},{26.88,36.31},{26.48,35.58},{26.15,35.41},{25.6,35.47},{24.92,36.15},{24.05,34.46},{23.8,34.7},{23.62,34.5},{23.35,34.09},{22.98,33.48},{22.51,33.98},{22.29,34.15},{22.06,34.17},{21.64,33.75},{21.31,33.62},{20.96,33.86},{20.61,34.04},{20.18,33.92},{19.7,33.47},{19.48,33.36},{18.96,34.0},{18.49,34.59},{18.54,35.16},{18.44,35.77},{16.77,37.89},{17.34,39.07},{17.41,39.59},{17.64,40.21},{18.03,41.24},{18.49,40.98},{18.83,41.07},{19.29,41.35},{19.74,41.88},{19.52,42.88},{19.39,43.82},},[1519]={{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{39.52,79.39},{41.49,79.89},{43.16,79.39},{44.47,78.33},{45.39,76.12},{45.22,72.68},{44.37,71.32},{43.95,70.38},{46.42,67.17},{46.2,66.02},{47.92,63.87},{49.99,62.41},{52.36,60.99},{52.71,61.98},{53.67,63.7},{56.94,59.9},{58.81,57.4},{57.92,55.91},{56.89,54.04},{56.03,53.58},{54.6,53.73},{52.86,55.49},{50.61,51.14},{49.95,51.75},{49.5,51.24},{48.79,50.19},{47.83,48.59},{46.64,49.89},{46.07,50.33},{45.46,50.38},{44.39,49.31},{43.54,48.97},{42.62,49.59},{41.72,50.06},{40.61,49.73},{39.37,48.57},{38.8,48.3},{37.47,49.96},{36.26,51.48},{36.37,52.95},{36.11,54.52},{31.8,60.0},{33.29,63.04},{33.46,64.38},{34.05,65.98},{35.05,68.65},{36.25,67.98},{37.13,68.2},{38.32,68.91},{39.48,70.31},{38.91,72.88},{38.57,75.31},},},1519,nil,nil,12,"A",},
[1414] = {'Lisan Pierce',1240,1240,25,25,0,{[1519]={{38.89,79.29},},},nil,1519,nil,nil,12,"A",},
[1415] = {'Suzanne',1240,1240,25,25,0,{[1519]={{39.04,79.63},},},nil,1519,nil,nil,12,"A",},
[1416] = {'Grimand Elmore',3517,3517,50,50,0,{[1519]={{51.76,12.07},},},{[12]={{24.43,19.59},{24.59,19.91},{25.6,19.4},{26.43,20.85},{26.43,20.84},{25.6,19.4},{24.59,19.91},{24.43,19.59},{24.5,19.33},{24.5,19.33},},[1519]={{51.59,12.74},{52.01,13.57},{54.61,12.26},{56.75,16.0},{56.76,15.97},{54.61,12.26},{52.01,13.57},{51.59,12.74},{51.76,12.07},{51.76,12.07},},},1519,{325,353,1705,1706,7642,7648,},{322,1097,1700,1705,1706,7641,7642,},55,"A",},
[1417] = {'Young Wetlands Crocolisk',531,573,21,22,0,{[11]={{65.39,71.01},{63.98,73.57},{13.35,54.72},{63.95,72.57},{65.9,72.1},{65.51,68.91},{64.69,68.88},{62.18,74.89},{14.43,59.86},{54.74,31.16},{57.01,48.31},{63.45,66.44},{53.79,32.55},{64.04,72.22},{63.6,65.58},{53.06,33.31},{50.29,31.97},{53.16,32.72},{53.14,37.43},{50.5,33.84},{64.13,75.3},{66.0,72.49},{63.44,75.33},{66.33,72.72},{58.91,51.06},{58.48,50.8},{61.02,54.69},{61.35,53.08},{60.96,61.66},{61.86,61.79},{60.46,63.57},{27.96,32.61},{40.33,36.07},{19.15,47.12},{21.38,44.62},{62.6,59.39},{20.19,47.18},{28.0,34.37},{28.66,36.22},{62.09,61.38},{59.66,53.3},{61.83,56.78},{60.63,54.74},{18.59,47.18},{53.12,42.35},{57.31,47.1},{51.91,35.4},{59.41,49.44},{52.2,36.23},{52.42,32.67},{55.11,45.65},{37.31,34.62},{51.5,38.43},{52.41,39.56},{38.63,35.88},{30.42,38.96},{35.06,35.92},{27.85,39.57},{29.03,38.75},{37.31,37.11},{26.47,41.15},{18.66,49.31},{18.55,51.65},{14.58,53.22},{15.37,52.24},{19.76,45.07},{50.9,37.08},{28.75,33.8},{26.67,32.46},{34.46,37.64},{14.39,51.59},{33.68,35.42},{53.21,41.26},{15.77,46.39},{15.13,47.74},{16.85,52.05},{53.84,42.49},},},nil,11,nil,nil,14,nil,},
[1418] = {'Bluegill Raider',896,950,28,29,0,{[11]={{25.67,16.95},{28.94,14.56},{24.14,16.87},{28.0,13.59},{27.02,16.89},{26.13,16.3},{29.8,13.16},{28.17,16.12},{24.82,18.19},{23.28,18.53},{21.83,17.82},{19.97,17.97},{29.15,12.26},{19.17,19.51},{20.65,16.97},{31.41,12.24},{26.38,18.47},{12.37,65.21},{12.62,64.32},{12.72,65.3},{10.22,66.31},{11.31,65.55},{11.82,65.45},{11.76,64.38},{9.52,66.71},{12.92,63.63},{10.26,71.29},{11.04,71.58},{8.73,67.94},{12.38,66.55},{9.59,69.02},{13.66,64.01},{9.55,72.52},{11.98,63.55},{9.52,71.5},{9.44,70.13},{8.73,70.31},{9.52,67.86},{8.68,71.35},{11.87,66.42},{8.64,69.0},{10.18,70.4},},[45]={{23.02,94.66},{21.6,96.88},},},nil,11,nil,nil,18,nil,},
[1419] = {'Fizzles',8,8,1,1,0,{[1519]={{32.28,79.81},},},nil,1519,nil,nil,12,"A",},
[1420] = {'Toad',8,8,1,1,0,{[8]={{62.95,65.24},{46.84,45.12},{53.35,49.48},{22.59,48.78},{76.6,80.11},{83.89,27.43},{50.98,57.01},{67.1,67.38},{89.69,46.16},{10.68,35.42},{14.9,59.38},},[11]={{22.1,26.77},{67.31,71.83},{35.06,28.51},{42.03,31.46},{61.56,67.91},{58.68,49.57},{13.16,53.9},{21.32,32.68},{48.14,33.7},{25.02,25.03},{24.65,33.6},{51.95,38.87},{56.04,47.48},{59.59,59.56},{31.19,36.6},{10.87,53.0},{38.35,36.34},{49.87,37.89},{33.87,37.21},{15.49,46.95},{9.7,61.76},{60.54,69.64},{18.59,46.26},{26.29,40.83},{33.19,39.83},{7.22,57.66},{11.7,56.04},{9.89,54.33},{10.0,58.58},{32.0,38.22},},[45]={{31.16,82.56},{33.77,81.37},},[130]={{59.51,18.11},{65.02,12.79},{65.57,19.02},{56.51,21.64},{59.13,36.63},{64.02,31.34},{66.73,44.42},{67.88,37.8},},[15]={{43.55,62.69},{42.06,65.36},{44.58,40.55},{42.31,46.16},{33.85,42.31},{34.75,49.14},{40.96,51.51},{44.32,41.59},{36.66,60.02},{47.4,52.87},{45.57,62.07},{53.09,28.3},{36.89,12.93},{43.07,68.49},{52.73,72.2},{51.07,21.21},{39.0,69.59},{34.17,70.69},{54.25,24.35},{41.52,41.25},{39.03,45.95},{37.7,50.48},{37.32,18.39},{35.06,50.34},{47.26,72.73},{40.65,32.28},{51.08,73.11},{54.8,32.79},{44.45,69.61},{40.95,38.32},{38.01,30.84},{51.18,68.91},{52.45,73.02},{56.72,69.01},{46.34,70.1},{50.23,77.14},{49.91,57.83},{56.45,35.8},{37.38,21.79},{43.31,73.12},{47.26,75.11},{40.84,46.28},{45.29,49.15},{55.19,74.82},{47.85,76.59},{38.26,19.63},{36.34,40.27},{48.17,60.09},{56.29,22.29},{49.17,22.91},{38.65,52.79},{51.08,18.86},{43.17,70.6},{35.53,71.03},{41.42,67.64},{42.5,47.68},{39.0,28.06},{43.22,23.16},{35.91,67.92},{44.24,47.72},{41.59,24.44},{46.0,73.87},{43.04,60.4},{36.48,42.51},{41.65,18.5},{45.65,73.71},{39.33,65.13},{47.66,53.76},{40.11,34.95},{43.75,25.18},{38.12,25.46},{47.27,17.85},{46.98,20.91},{40.95,61.84},{38.98,41.58},},[490]={{75.36,55.56},{44.49,40.65},{69.14,42.65},{73.76,60.75},{35.67,22.49},{61.78,68.0},{43.6,31.91},{59.37,43.03},{71.87,64.65},{64.37,72.86},{69.22,73.01},{71.38,48.41},{65.29,58.89},{56.93,41.72},{69.14,46.01},{30.88,24.87},{43.99,37.41},{73.15,48.6},{72.62,55.59},{61.5,43.22},{66.77,55.11},{49.24,39.56},{65.4,74.38},{69.98,70.41},{45.13,42.38},{70.97,55.9},{63.56,56.42},{69.21,65.44},{64.76,43.92},{53.8,37.35},{66.5,69.89},{68.77,52.37},{64.18,68.44},{64.71,40.66},{66.81,74.68},{35.73,26.63},{41.51,29.51},},[141]={{42.95,28.2},{57.4,38.77},{42.3,42.21},{55.32,69.46},{39.7,65.92},{57.92,66.34},{56.1,68.33},{40.49,65.32},{59.5,69.08},{44.36,27.47},{57.86,38.22},{50.16,71.9},{57.18,67.78},{40.46,63.86},{43.71,40.79},{52.84,70.71},{43.03,39.42},{42.96,35.21},{59.63,66.62},{44.28,26.32},{51.29,70.54},{43.44,31.67},{41.29,67.84},{43.47,26.67},{50.58,73.59},{40.65,67.32},{52.39,72.7},{42.66,31.8},{42.18,38.78},{58.58,36.51},{57.05,37.4},},[1657]={{54.44,58.2},{37.44,36.47},{47.33,48.51},{47.23,50.58},{48.34,39.57},{42.13,23.86},{45.37,23.42},{54.16,34.78},{49.95,43.69},{52.07,69.9},{40.06,49.94},{53.58,46.22},{34.55,43.51},{46.85,29.69},{52.31,30.74},{46.98,54.8},{27.08,45.78},{46.63,30.35},{44.2,22.56},{29.93,25.03},{44.56,48.03},{31.93,44.82},{56.33,26.9},{45.75,55.83},{54.72,49.25},{52.28,31.67},{29.87,23.71},{59.76,31.3},{30.7,34.82},{25.94,29.62},{46.19,56.72},{36.79,37.02},},[1977]={{-1, -1}},},{[141]={{25.06,54.5},{24.95,54.6},{24.83,54.45},{24.65,54.2},{24.85,54.44},{27.01,57.2},{27.19,56.92},{27.08,57.14},{27.2,57.66},{27.04,57.53},{27.05,57.85},{27.23,58.19},{27.07,57.87},{27.03,57.55},{23.84,55.96},{23.84,56.23},{23.87,56.52},{23.85,56.21},},[1657]={{37.78,36.36},{37.23,36.83},{36.64,36.11},{35.82,34.95},{36.77,36.1},{47.14,49.37},{48.04,48.0},{47.47,49.05},{48.07,51.56},{47.31,50.95},{47.33,52.49},{48.23,54.13},{47.44,52.58},{47.25,51.02},{31.89,43.38},{31.91,44.69},{32.04,46.09},{31.94,44.6},},},15,nil,nil,188,"AH",},
[1421] = {'Private Merle',1107,1107,31,31,0,nil,nil,0,nil,nil,11,"A",},
[1422] = {'Corporal Sethman',1863,1863,40,40,0,{[33]={{37.66,3.39},},},nil,33,{331,},{330,},11,"A",},
[1423] = {'Stormwind Guard',1106,1106,23,23,0,{[12]={{20.74,79.48},{35.3,53.67},{45.56,49.1},{42.09,66.61},{42.13,65.44},{24.93,72.01},{24.34,72.9},{24.81,73.19},{25.86,72.22},{25.13,72.69},{25.89,72.23},{25.75,72.33},{25.66,72.43},{28.17,77.69},{28.14,77.98},{24.47,80.56},{24.2,80.31},{23.79,80.18},{23.63,80.49},{23.89,80.4},{24.35,81.03},{75.12,72.21},{75.04,72.54},{74.17,72.66},{74.17,72.41},{83.68,78.95},{83.92,78.44},{84.1,79.36},{84.5,79.72},{84.75,79.59},{84.42,79.37},{20.91,79.84},{24.73,72.91},{25.02,72.32},{25.02,71.76},{24.57,71.59},{25.59,72.88},{24.65,71.5},{24.49,71.46},},[40]={{67.99,9.06},},},{[12]={{46.88,51.67},{47.47,53.23},{47.41,54.73},{46.91,56.59},{46.21,57.81},{45.54,60.75},{42.54,64.65},{43.61,63.44},{45.38,61.14},{45.66,60.46},{46.1,58.31},{47.02,56.52},{47.26,55.68},{47.54,53.91},{47.47,53.31},{47.13,52.26},{46.66,51.11},{45.81,49.61},{45.56,49.1},{24.58,72.15},{24.76,72.28},{24.93,72.39},{25.06,72.49},{25.18,72.57},{25.36,72.66},{25.45,72.73},{25.44,72.85},{25.41,73.08},{25.29,73.4},{25.19,73.42},{25.06,73.38},{24.92,73.29},{24.81,73.2},{24.68,73.12},{24.47,72.99},{24.36,72.86},{24.35,72.69},{24.41,72.47},{24.47,72.27},{25.74,72.32},{25.61,72.74},{25.4,73.49},{25.3,73.86},{25.4,73.49},{25.48,73.19},{25.61,72.74},{23.22,79.69},{23.84,79.53},{23.51,79.49},{24.11,79.86},{23.09,79.97},{23.04,80.41},{23.15,80.83},{23.39,81.13},{23.73,81.16},{24.04,80.94},{23.73,81.16},{23.39,81.13},{23.15,80.83},{23.04,80.41},{23.09,79.97},{23.22,79.69},{23.51,79.49},{23.84,79.53},{24.11,79.86},{24.21,80.31},{23.68,79.94},{23.68,79.94},{23.38,80.24},{23.38,80.24},{23.57,80.71},{23.57,80.71},{23.89,80.4},{23.89,80.4},{84.39,80.22},{84.67,80.36},{84.96,80.27},{85.16,80.0},{85.23,79.55},{85.21,79.16},{84.92,78.76},{84.65,78.68},{84.34,78.81},{84.65,78.68},{84.92,78.76},{85.21,79.16},{85.23,79.55},{85.16,80.0},{84.96,80.27},{84.67,80.36},{84.39,80.22},{84.13,79.82},{84.1,79.37},{84.13,79.82},{84.42,79.37},{84.42,79.37},{84.77,79.14},{84.77,79.14},{84.92,79.67},{84.92,79.67},{84.57,79.88},{84.57,79.88},{24.57,71.59},{24.44,72.03},{24.35,72.37},{24.26,72.65},{24.14,73.09},{24.26,72.65},{24.35,72.37},{24.44,72.03},{25.58,72.88},{25.48,72.8},{25.55,73.09},{25.5,73.22},{25.43,73.29},{25.32,73.29},{25.04,73.12},{24.81,72.97},{24.43,72.68},{24.32,72.58},{24.31,72.46},{24.31,72.33},{24.34,72.26},{24.41,72.24},{24.54,72.22},{24.98,72.49},{25.28,72.69},},[40]={{84.51,1.54},{85.57,0.34},{66.69,8.98},{66.87,9.11},{67.05,9.22},{67.17,9.32},{67.29,9.39},{67.47,9.48},{67.56,9.56},{67.55,9.68},{67.52,9.91},{67.4,10.22},{67.31,10.24},{67.17,10.2},{67.03,10.11},{66.92,10.02},{66.79,9.94},{66.58,9.82},{66.48,9.68},{66.47,9.52},{66.52,9.3},{66.59,9.1},{67.85,9.15},{67.72,9.57},{67.51,10.31},{67.41,10.67},{67.51,10.31},{67.59,10.01},{67.72,9.57},{65.34,16.46},{65.97,16.3},{65.63,16.26},{66.23,16.63},{65.21,16.74},{65.17,17.18},{65.27,17.59},{65.51,17.89},{65.85,17.92},{66.16,17.7},{65.85,17.92},{65.51,17.89},{65.27,17.59},{65.17,17.18},{65.21,16.74},{65.34,16.46},{65.63,16.26},{65.96,16.3},{66.23,16.63},{66.33,17.08},{65.8,16.71},{65.8,16.71},{65.51,17.01},{65.51,17.01},{65.7,17.47},{65.7,17.47},{66.01,17.16},{66.01,17.16},{66.68,8.43},{66.56,8.87},{66.47,9.2},{66.38,9.48},{66.26,9.91},{66.38,9.48},{66.47,9.2},{66.56,8.87},{67.69,9.71},{67.59,9.63},{67.66,9.91},{67.61,10.04},{67.54,10.11},{67.43,10.11},{67.15,9.94},{66.93,9.79},{66.54,9.51},{66.44,9.41},{66.42,9.29},{66.43,9.16},{66.46,9.09},{66.53,9.07},{66.66,9.05},{67.1,9.32},{67.39,9.51},},[10]={{3.84,3.75},{4.65,3.54},{4.21,3.48},{4.99,3.96},{3.67,4.11},{3.62,4.67},{3.75,5.21},{4.06,5.6},{4.5,5.63},{4.9,5.35},{4.5,5.63},{4.06,5.6},{3.75,5.21},{3.62,4.67},{3.67,4.11},{3.84,3.75},{4.21,3.48},{4.64,3.54},{4.99,3.96},{5.12,4.54},{4.43,4.06},{4.43,4.06},{4.05,4.45},{4.05,4.45},{4.3,5.06},{4.3,5.06},{4.7,4.65},{4.7,4.65},{82.48,4.43},{82.84,4.61},{83.21,4.49},{83.47,4.14},{83.56,3.57},{83.53,3.07},{83.16,2.55},{82.82,2.45},{82.42,2.61},{82.82,2.45},{83.16,2.55},{83.53,3.07},{83.56,3.57},{83.47,4.14},{83.21,4.49},{82.84,4.61},{82.48,4.43},{82.15,3.92},{82.11,3.33},{82.15,3.92},{82.52,3.33},{82.52,3.33},{82.97,3.04},{82.97,3.04},{83.16,3.71},{83.16,3.71},{82.71,3.99},{82.71,3.99},},},12,nil,nil,11,"A",},
[1424] = {'Master Digger',328,328,15,15,4,{[40]={{46.46,18.99},},},nil,40,nil,nil,26,nil,},
[1425] = {'Grizlak',301,301,15,15,4,{[38]={{34.58,27.07},},},nil,38,nil,nil,26,nil,},
[1426] = {'Riverpaw Miner',300,328,14,15,0,{[40]={{28.94,48.71},{30.35,45.38},{29.31,46.07},{28.94,50.64},{29.65,50.58},{30.26,47.55},{30.77,46.19},{30.27,49.65},},},nil,40,nil,nil,20,nil,},
[1427] = {'Harlan Bagley',500,500,12,12,0,{[1519]={{55.11,56.23},},},nil,1519,{333,},nil,12,"A",},
[1428] = {'Rema Schneider',2016,2016,35,35,0,{[1519]={{49.65,55.64},},},nil,1519,{334,},{333,},12,"A",},
[1429] = {'Thurman Schneider',87,87,2,2,0,{[1519]={{42.5,76.21},},},nil,1519,nil,{334,},12,"A",},
[1430] = {'Tomas',413,413,10,10,0,{[12]={{44.37,65.99},},},nil,12,nil,nil,12,"A",},
[1431] = {'Suzetta Gallina',1605,1605,30,30,0,{[1519]={{52.48,67.61},},},nil,1519,nil,{332,},12,"A",},
[1432] = {'Renato Gallina',2972,2972,45,45,0,{[1519]={{56.98,63.53},},},nil,1519,{332,},nil,12,"A",},
[1433] = {'Corbett Schneider',166,166,5,5,0,nil,nil,0,nil,nil,12,"A",},
[1434] = {'Menethil Sentry',2187,3570,41,42,0,{[11]={{4.47,57.47},{10.29,58.08},{11.18,62.03},{9.37,57.22},{11.22,57.28},{11.96,55.12},{5.21,63.71},{10.78,54.39},{9.77,55.99},{11.15,54.68},{9.93,57.08},{4.85,57.8},{9.13,60.74},{12.28,49.97},{9.89,57.17},{9.36,57.34},{4.83,57.04},{12.27,50.59},{10.35,57.56},{10.56,59.09},{9.3,55.94},{10.11,57.41},{4.98,63.07},{4.96,62.31},{12.7,50.15},{8.95,57.94},{7.77,52.79},{8.37,56.78},{9.71,60.49},},},{[11]={{11.18,62.03},{11.67,61.85},{11.89,61.6},{12.47,60.86},{11.89,61.6},{11.67,61.85},{10.05,61.17},{10.46,61.98},{10.68,61.97},{10.46,61.98},{10.05,61.17},{9.4,61.32},{9.39,61.14},{9.35,61.07},{9.13,60.74},{9.4,61.32},{9.39,61.14},{9.35,61.07},{9.13,60.74},{9.09,60.19},{9.89,57.21},{10.16,57.41},{10.43,57.59},{10.59,57.18},{10.3,56.98},{10.21,56.91},{10.01,56.74},{9.89,56.65},{9.62,56.47},{9.47,56.91},{12.33,50.46},{12.16,50.95},{11.96,51.54},{11.72,52.22},{11.49,52.91},{11.33,53.36},{11.11,54.02},{10.92,54.58},{11.09,54.1},{11.24,53.67},{11.41,53.17},{11.62,52.55},{11.88,51.77},{12.07,51.21},{12.28,50.57},{10.11,57.41},{9.81,57.17},{9.74,57.31},{9.66,57.51},{9.61,57.63},{9.7,57.71},{9.8,57.8},{9.9,57.88},{9.8,57.8},{9.7,57.71},{9.61,57.63},{9.66,57.51},{9.74,57.31},{9.81,57.17},{7.77,52.79},{7.66,53.18},{7.76,53.43},{7.76,53.65},{7.85,53.67},{8.08,53.69},{7.85,53.67},{7.76,53.65},{7.76,53.43},{7.66,53.18},{7.77,52.79},{7.46,53.5},{7.38,54.32},{7.5,53.45},{8.37,56.78},{8.41,57.02},{8.04,56.78},{7.98,56.7},{7.85,56.68},{7.79,56.61},{7.4,55.94},{7.79,56.61},{7.85,56.68},{7.98,56.7},{8.04,56.78},{8.41,57.02},},},11,nil,nil,57,"A",},
[1435] = {'Zardeth of the Black Claw',3857,3857,60,60,0,{[1519]={{26.44,78.67},},},nil,1519,{335,336,397,},{335,},12,"A",},
[1436] = {'Watcher Cutford',1469,1469,36,36,0,nil,nil,0,nil,nil,56,"A",},
[1437] = {'Thomas Booker',919,919,20,20,0,{[11]={{8.84,54.31},},},{[11]={{8.83,54.31},{8.85,54.54},{8.76,54.67},{8.62,54.7},{8.42,54.56},{8.33,54.45},{8.46,54.08},},},11,nil,nil,11,"A",},
[1439] = {'Lord Baurles K. Wishock',413,413,10,10,0,{[1519]={{75.23,31.68},},},nil,1519,nil,{336,},12,"A",},
[1440] = {'Milton Sheaf',644,644,15,15,0,{[1519]={{74.17,7.49},},},nil,1519,{344,538,},{337,343,542,},12,"A",},
[1441] = {'Brak Durnad',1240,1240,25,25,0,{[11]={{11.44,59.69},},},{[11]={{11.44,59.69},{11.58,59.54},},},11,nil,nil,55,"A",},
[1442] = {'Helgrum the Swift',3857,3857,60,60,0,{[8]={{47.74,55.2},},},nil,8,{1418,},{1420,},29,"H",},
[1443] = {'Fel\'zerul',3857,3857,60,60,0,{[8]={{47.93,54.78},},},nil,8,{1424,1429,1445,},{1424,1444,1445,},29,"H",},
[1444] = {'Brother Kristoff',2471,2471,40,40,0,{[1519]={{45.7,38.42},},},nil,1519,{343,},{346,},12,"A",},
[1445] = {'Jesse Halloran',87,87,2,2,0,{[11]={{8.32,55.13},},},nil,11,nil,nil,12,"A",},
[1446] = {'Regina Halloran',87,87,2,2,0,{[11]={{8.26,55.33},},},nil,11,nil,nil,12,"A",},
[1447] = {'Gimlok Rumdnul',87,87,2,2,0,{[11]={{12.07,57.81},},},nil,11,nil,nil,55,"A",},
[1448] = {'Neal Allen',919,919,20,20,0,{[11]={{10.75,56.75},},},nil,11,nil,nil,11,"A",},
[1449] = {'Witch Doctor Unbagwa',2666,2666,42,42,0,{[33]={{35.27,60.41},},},nil,33,{349,},{349,},35,"AH",},
[1450] = {'Brahnmar',1240,1240,25,25,0,{[11]={{11.54,59.86},},},{[11]={{11.54,59.86},{11.47,59.77},},},11,nil,nil,55,"A",},
[1451] = {'Camerick Jongleur',1240,1240,25,25,0,{[11]={{9.87,59.09},},},{[11]={{9.87,59.09},{9.95,59.17},{10.1,59.16},{10.12,59.07},{10.08,59.04},{10.11,58.96},{10.05,58.87},{9.91,58.8},{9.85,58.93},{9.79,58.86},{9.74,58.94},{9.73,59.03},{9.76,59.09},{9.88,59.05},},},11,nil,nil,12,"A",},
[1452] = {'Gruham Rumdnul',1240,1240,25,25,0,{[11]={{12.07,57.98},},},nil,11,nil,nil,55,"A",},
[1453] = {'Dewin Shimmerdawn',1240,1240,25,25,0,{[11]={{7.96,56.34},},},nil,11,nil,nil,55,"A",},
[1454] = {'Jennabink Powerseam',1240,1240,25,25,0,{[11]={{8.12,55.84},},},nil,11,nil,nil,875,"A",},
[1456] = {'Kersok Prond',1240,1240,25,25,0,{[11]={{10.38,60.62},},},nil,11,nil,nil,55,"A",},
[1457] = {'Samor Festivus',1240,1240,25,25,0,{[11]={{10.5,60.2},},},nil,11,nil,nil,12,"A",},
[1458] = {'Telurinon Moonshadow',1240,1240,25,25,0,{[11]={{7.99,55.84},},},nil,11,nil,nil,55,"A",},
[1459] = {'Naela Trance',1240,1240,25,25,0,{[11]={{11.27,58.43},},},{[11]={{11.27,58.43},{11.26,58.41},{11.32,58.31},{11.24,58.16},{11.22,58.18},{11.31,58.27},{11.26,58.41},},},11,nil,nil,12,"A",},
[1460] = {'Unger Statforth',1240,1240,25,25,0,{[11]={{8.57,54.34},},},nil,11,nil,nil,12,"A",},
[1461] = {'Murndan Derth',2766,2766,43,43,0,{[11]={{11.34,59.58},},},nil,11,nil,nil,55,"A",},
[1462] = {'Edwina Monzor',1240,1240,25,25,0,{[11]={{11.12,58.32},},},nil,11,nil,nil,12,"A",},
[1463] = {'Falkan Armonis',1240,1240,25,25,0,{[11]={{8.35,56.47},},},nil,11,nil,nil,12,"A",},
[1464] = {'Innkeeper Helbrek',1605,1605,30,30,0,{[11]={{10.7,60.95},},},nil,11,nil,nil,55,"A",},
[1465] = {'Drac Roughcut',644,644,15,15,0,{[38]={{35.57,49.15},},},nil,38,nil,nil,55,"A",},
[1466] = {'Gretta Finespindle',1172,1172,24,24,0,{[1537]={{38.81,32.88},},},nil,1537,nil,nil,55,"A",},
[1469] = {'Vrok Blunderblast',644,644,15,15,0,{[38]={{35.83,43.46},},},nil,38,nil,nil,55,"A",},
[1470] = {'Ghak Healtouch',1240,1240,25,25,0,{[38]={{37.07,49.38},},},nil,38,{17,2500,2501,},{17,2500,2501,},55,"A",},
[1471] = {'Jannos Ironwill',3077,3077,46,46,0,{[45]={{45.98,47.72},},},nil,45,nil,nil,55,"A",},
[1472] = {'Morgg Stormshot',3866,3866,53,53,0,{[1519]={{59.37,21.21},},},nil,1519,nil,nil,55,"A",},
[1473] = {'Kali Healtouch',594,594,14,14,0,{[38]={{36.47,48.54},},},nil,38,nil,nil,55,"A",},
[1474] = {'Rann Flamespinner',644,644,15,15,0,{[38]={{35.95,45.87},},},nil,38,nil,nil,55,"A",},
[1475] = {'Menethil Guard',3184,3184,47,47,0,nil,nil,0,nil,nil,57,"A",},
[1476] = {'Hargin Mundar',919,919,20,20,0,{[11]={{10.68,60.52},},},{[11]={{10.63,60.52},{10.63,60.75},{10.74,60.92},{10.63,60.75},{10.63,60.52},{10.68,60.52},{10.67,60.53},{10.42,60.47},{10.45,60.48},{10.63,60.56},{10.63,60.33},{10.62,60.1},{10.78,60.09},{10.79,59.76},{10.78,60.09},{10.62,60.1},{10.63,60.33},},},11,nil,nil,57,"A",},
[1477] = {'Christoph Faral',1605,1605,30,30,0,{[1519]={{73.92,36.66},},},nil,1519,nil,nil,12,"A",},
[1478] = {'Aedis Brom',1605,1605,30,30,0,{[1519]={{73.84,36.49},},},nil,1519,nil,nil,12,"A",},
[1479] = {'Timothy Clark',919,919,20,20,0,{[11]={{10.21,56.82},},},nil,11,nil,nil,11,"A",},
[1480] = {'Caitlin Grassman',919,919,20,20,0,{[11]={{11.88,58.82},},},nil,11,nil,nil,12,"A",},
[1481] = {'Bart Tidewater',919,919,20,20,0,{[11]={{9.41,58.76},},},{[11]={{9.41,58.76},{9.34,58.71},{9.08,58.75},{8.79,58.7},{8.64,58.24},{8.64,57.88},{8.76,58.63},{8.7,58.75},{8.6,58.83},{8.37,58.52},{8.02,57.75},{7.92,57.51},{7.92,57.64},{8.4,58.75},{8.63,59.32},{8.85,59.84},{9.05,59.35},{9.0,59.19},{9.17,58.92},},},11,nil,nil,12,"A",},
[1482] = {'Andrea Halloran',919,919,20,20,0,{[11]={{8.33,55.38},},},nil,11,nil,nil,11,"A",},
[1483] = {'Murphy West',919,919,20,20,0,{[11]={{9.87,57.88},},},{[11]={{9.87,57.88},{9.9,57.88},{10.08,57.33},{9.81,57.15},{9.76,57.26},{9.61,57.69},{9.73,57.75},{9.9,57.69},{9.73,57.75},{9.61,57.69},{9.76,57.26},{9.81,57.15},{10.08,57.33},},},11,nil,nil,11,"A",},
[1484] = {'Derina Rumdnul',919,919,20,20,0,{[11]={{12.03,57.89},},},nil,11,nil,nil,55,"A",},
[1487] = {'Splinter Fist Enslaver',1050,1107,30,31,0,{[10]={{38.14,80.82},{35.04,81.27},{37.78,84.32},},},nil,10,nil,nil,45,nil,},
[1488] = {'Zanzil Zombie',2047,2139,43,44,0,{[33]={{41.32,57.01},{39.55,58.29},{35.23,50.99},{38.89,57.62},{38.62,58.54},{34.46,50.98},{40.83,59.12},{34.84,51.44},{34.65,51.78},{39.1,58.25},},},{[33]={{39.1,58.25},{39.2,57.96},{39.28,57.73},{39.4,57.69},{39.72,57.99},{39.74,58.12},{39.66,58.31},{39.55,58.44},{39.35,58.47},},},33,nil,nil,16,nil,},
[1489] = {'Zanzil Hunter',2052,2115,43,44,0,{[33]={{39.33,58.77},{34.39,52.21},},},nil,33,nil,nil,16,nil,},
[1490] = {'Zanzil Witch Doctor',1701,1701,44,44,0,{[33]={{34.88,51.68},{38.68,56.61},{39.63,57.87},{39.78,57.71},{39.19,59.25},{40.07,58.01},},},nil,33,nil,nil,16,nil,},
[1491] = {'Zanzil Naga',2116,2116,44,44,0,{[33]={{41.75,56.5},{40.74,58.04},{35.01,52.11},{35.19,51.84},{40.21,59.07},{35.13,51.14},{38.66,59.78},{39.68,59.25},{39.55,59.01},{34.97,50.57},{39.9,57.26},},},nil,33,nil,nil,16,nil,},
[1492] = {'Gorlash',7960,7960,47,47,1,{[33]={{36.95,69.73},},},nil,33,nil,nil,778,nil,},
[1493] = {'Mok\'rash',7676,7676,50,50,1,{[33]={{23.25,72.1},},},nil,33,nil,nil,778,nil,},
[1494] = {'Negolash',6604,6604,52,52,1,nil,nil,0,nil,nil,14,nil,},
[1495] = {'Deathguard Linnea',1042,1042,22,22,0,{[85]={{65.49,60.25},},},nil,85,{356,360,},{356,359,},68,"H",},
[1496] = {'Deathguard Dillinger',1042,1042,22,22,0,{[85]={{58.2,51.45},},},nil,85,{404,426,1819,1820,},{404,426,1818,1819,},68,"H",},
[1497] = {'Gunther Arcanus',3165,3165,53,53,0,{[85]={{68.2,41.92},},},nil,85,{409,411,},{366,409,},68,"H",},
[1498] = {'Bethor Iceshard',3857,3857,60,60,0,{[1497]={{84.07,17.45},},},nil,1497,{357,366,446,},{357,405,411,444,491,},68,"H",},
[1499] = {'Magistrate Sevren',594,594,14,14,0,{[85]={{61.26,50.84},},},nil,85,{358,359,405,408,441,},{355,358,360,408,440,},68,"H",},
[1500] = {'Coleman Farthing',644,644,15,15,0,{[85]={{61.72,52.29},},},nil,85,{354,355,362,1821,1822,},{354,362,1820,1821,1822,},68,"H",},
[1501] = {'Mindless Zombie',42,42,1,1,0,{[85]={{34.59,62.77},{31.47,62.02},{34.92,62.8},{34.92,64.75},{34.77,64.15},{31.58,62.2},{31.49,62.16},{34.12,64.24},{34.07,64.39},{33.56,63.88},{30.7,64.17},{33.86,65.24},{30.67,61.75},{32.54,62.96},{31.86,63.56},{33.19,63.84},{33.38,64.27},{33.04,64.53},{33.48,64.71},{31.69,64.14},{31.07,62.98},{31.2,63.67},{30.9,62.12},{30.8,61.55},{32.34,64.25},{32.8,64.31},{32.36,63.01},{32.28,63.63},},},{[85]={{33.22,63.74},{32.66,63.65},{32.3,63.42},{32.3,63.32},{32.18,63.49},{31.83,63.26},{31.56,63.23},{31.91,63.29},{32.03,63.57},{32.12,63.27},{32.61,63.57},{33.41,64.71},{33.18,64.65},{33.17,64.12},{32.96,63.74},{33.21,63.44},{33.53,63.54},{33.53,64.26},{32.02,64.67},{31.99,63.8},{32.21,63.16},{32.61,63.59},{32.82,63.71},{32.84,64.09},{32.8,64.31},},},85,nil,nil,7,"AH",},
[1502] = {'Wretched Zombie',42,55,1,2,0,{[85]={{34.2,65.85},{33.6,61.78},{31.75,62.15},{31.52,62.58},{31.78,61.87},{34.16,64.18},{33.89,63.88},{33.84,64.19},{34.21,63.62},{31.64,62.27},{33.78,62.82},{32.76,62.45},{31.39,61.4},{33.77,65.89},{32.12,60.54},{32.45,60.7},{31.92,62.8},{33.96,63.29},{32.87,63.55},{30.33,63.31},{33.34,64.94},{33.83,64.36},{33.31,65.49},{33.31,65.7},{33.52,63.18},{31.64,63.36},{32.83,61.31},{32.56,64.12},{33.21,61.16},{33.44,63.43},{34.42,60.71},{32.18,63.18},{32.81,62.17},{32.61,62.23},{32.58,62.76},},},{[85]={{32.86,63.58},{32.54,63.77},{32.63,63.27},{32.65,63.12},{32.78,63.32},{32.8,63.48},{32.85,63.75},{32.58,63.62},{32.46,63.23},{32.29,62.69},{32.05,62.42},{31.87,62.59},{32.09,62.74},{32.29,63.11},{32.3,63.46},{32.15,63.42},{32.03,63.65},{32.02,64.38},{31.98,64.77},{32.15,63.31},{32.57,64.04},{32.35,63.54},{32.07,63.43},{31.97,63.95},{32.0,64.49},{34.01,61.98},{33.81,62.34},{33.49,63.2},{33.24,63.7},{32.89,63.71},{32.65,63.61},{32.2,63.11},{32.05,62.65},{32.09,62.07},{32.27,61.8},{32.66,61.21},{32.83,61.06},{33.14,60.88},{33.42,60.74},{33.9,60.81},{34.01,60.97},{34.08,61.4},{34.19,61.72},{34.28,62.1},{34.94,60.8},{35.37,60.78},{35.72,60.61},{35.02,60.65},{34.55,60.22},{34.29,60.11},{33.65,59.84},{32.99,59.86},{32.62,59.51},{32.4,59.15},{32.11,58.77},{31.88,59.01},{31.68,59.52},{31.61,60.34},{31.56,60.8},{31.5,61.18},{31.53,61.3},{31.67,61.38},{31.79,61.18},{32.14,61.39},{32.15,61.49},{32.66,60.97},{33.29,60.83},{33.54,60.7},{34.42,60.72},{31.82,61.9},{31.84,61.91},{32.01,62.05},{32.0,62.62},{32.16,63.04},{32.02,63.58},{32.01,64.17},{32.06,64.53},},},85,nil,nil,7,"AH",},
[1504] = {'Young Night Web Spider',55,71,2,3,0,{[85]={{27.76,56.98},{30.57,56.47},{28.32,57.43},{27.89,55.17},{28.2,57.09},{29.66,58.45},{28.51,56.53},{29.84,56.96},{29.94,57.43},{27.94,60.46},{28.21,55.62},{27.39,57.95},{28.16,59.83},{27.41,55.93},{26.83,56.16},{27.05,56.63},{27.71,59.6},{29.12,56.13},{29.35,55.6},{29.79,55.88},{27.1,59.18},{27.53,58.86},{29.4,59.42},{28.86,59.45},{29.15,58.13},{29.18,57.66},{29.03,57.07},{28.36,58.29},{28.5,59.08},{28.1,59.16},},},nil,85,nil,nil,7,"AH",},
[1505] = {'Night Web Spider',71,86,3,4,0,{[85]={{23.97,60.61},{23.26,59.94},{23.41,58.93},{23.56,58.3},{24.48,59.71},{23.48,60.25},{23.48,59.11},{23.74,58.43},{23.16,59.64},{23.97,58.43},{26.23,60.2},{26.13,60.42},{24.79,59.4},{24.8,59.69},{24.18,60.73},{26.25,59.66},{26.21,59.75},{25.62,59.44},{25.42,59.85},{25.16,59.53},{25.16,60.36},{24.97,59.22},{24.84,60.33},{24.48,60.64},{24.64,60.05},{25.91,59.54},{26.6,59.5},},},nil,85,nil,nil,22,nil,},
[1506] = {'Scarlet Convert',71,71,3,3,0,{[85]={{38.27,65.12},{37.75,65.56},{37.62,67.49},{37.68,71.66},{37.36,67.95},{37.47,66.44},{38.28,68.46},{36.96,70.87},{38.37,67.7},{38.69,67.15},{38.56,66.15},{38.74,69.38},{36.59,65.58},{37.0,65.2},{36.92,66.42},{37.01,67.28},{36.88,63.01},{37.81,69.2},{37.76,70.01},{37.55,68.67},{36.66,68.63},{36.25,67.16},{35.94,68.59},},},nil,85,nil,nil,67,nil,},
[1507] = {'Scarlet Initiate',67,81,3,4,0,{[85]={{38.49,70.3},{38.51,68.26},{38.67,65.06},{37.41,67.77},{37.75,66.65},{37.58,67.98},{36.86,69.95},{37.41,69.58},{36.47,68.37},{36.47,69.43},},},nil,85,nil,nil,67,nil,},
[1508] = {'Young Scavenger',42,42,1,1,0,{[85]={{33.01,67.36},{33.55,68.62},{31.04,55.61},{34.26,67.15},{30.15,63.98},{34.88,57.89},{34.21,56.95},{32.0,57.53},{31.44,58.43},{30.91,62.15},{29.47,61.88},{28.93,68.22},{29.42,67.23},{29.4,65.67},{28.85,64.68},{30.09,62.92},{30.77,60.78},{31.9,59.63},},},nil,85,nil,nil,32,"AH",},
[1509] = {'Ragged Scavenger',55,71,2,3,0,{[85]={{36.88,63.46},{37.39,58.74},{37.79,62.96},{38.23,63.89},{36.63,60.8},{37.68,60.64},{35.9,55.99},{37.6,55.98},{36.86,56.9},{35.68,59.48},{35.66,57.25},{34.56,65.18},{35.6,65.78},{34.56,62.55},{35.7,62.32},{36.5,63.58},{34.57,58.86},{35.07,57.41},{34.47,56.83},},},nil,85,nil,nil,32,"AH",},
[1511] = {'Enraged Silverback Gorilla',1902,1981,41,42,0,nil,nil,0,nil,nil,41,nil,},
[1512] = {'Duskbat',42,55,1,2,0,{[85]={{32.39,69.47},{34.31,70.69},{35.66,69.26},{35.69,71.43},{28.37,62.56},{31.46,72.55},{28.3,63.63},{28.61,69.07},{35.14,70.37},{35.81,70.75},{34.33,69.45},{28.32,63.92},{34.95,69.55},{35.08,71.4},{27.9,64.82},{27.78,63.56},{27.85,67.42},{32.02,71.62},{29.37,72.48},{31.54,56.23},{34.2,68.22},{33.41,66.75},{30.19,65.53},{34.03,58.23},{33.77,57.27},{32.48,56.2},{32.78,58.07},{31.11,57.96},{30.92,59.73},{29.59,62.2},{29.79,63.6},{29.7,64.07},{30.08,61.51},{29.46,61.04},{29.94,70.33},{29.3,69.17},{29.03,67.83},{29.14,66.71},{29.94,66.22},{30.68,69.29},},},nil,85,nil,nil,7,"AH",},
[1513] = {'Mangy Duskbat',71,86,3,4,0,{[85]={{36.77,56.51},{37.07,61.96},{37.7,57.99},{37.22,59.77},{36.92,64.38},{37.85,61.98},{35.13,58.97},{34.93,61.38},{37.63,59.44},{35.63,61.76},{36.46,58.59},{35.62,58.26},{35.18,56.74},{33.91,61.73},{34.08,65.37},{35.23,64.69},{35.1,66.2},{34.89,66.77},{35.41,62.98},{34.43,59.56},{34.05,57.34},},},nil,85,nil,nil,7,"AH",},
[1514] = {'Mokk the Savage',2138,2138,44,44,0,nil,nil,0,nil,nil,41,nil,},
[1515] = {'Executor Zygand',298,298,14,14,0,{[85]={{60.59,51.76},},},nil,85,{370,371,372,427,},{370,371,372,383,398,427,},68,"H",},
[1516] = {'Konda',2059,2059,43,43,0,nil,nil,0,nil,nil,41,nil,},
[1518] = {'Apothecary Johaan',919,919,20,20,0,{[85]={{59.45,52.4},},},nil,85,{367,368,369,407,445,492,},{365,367,368,369,},68,"H",},
[1519] = {'Deathguard Simmer',1106,1106,23,23,0,{[85]={{40.91,54.17},},},nil,85,{365,},nil,68,"H",},
[1520] = {'Rattlecage Soldier',120,137,6,7,0,{[85]={{48.74,44.24},{46.11,34.26},{48.67,44.1},{45.95,43.34},{43.89,39.83},{44.56,41.29},{47.66,37.06},{45.84,40.43},{46.06,39.07},{46.06,38.8},{45.41,38.33},{49.28,42.32},{50.08,43.19},{49.31,42.81},{50.72,43.96},{49.37,43.41},{49.03,38.12},{49.52,36.83},{46.82,43.92},{46.15,36.1},{49.26,35.94},},},nil,85,nil,nil,21,nil,},
[1521] = {'Gretchen Dedmar',334,334,8,8,0,{[85]={{61.89,52.73},},},nil,85,{375,},{375,},68,"H",},
[1522] = {'Darkeye Bonecaster',126,143,7,8,0,{[85]={{42.39,33.63},{47.74,29.22},{47.88,34.06},{51.01,34.0},{43.32,32.55},{46.17,29.41},{46.6,31.97},{48.27,37.54},{44.88,35.97},{47.72,30.75},{48.21,30.36},{47.11,32.3},{50.45,31.51},{42.83,34.22},{47.33,30.18},{49.16,27.88},{43.59,28.6},{42.68,35.15},{43.87,30.53},{43.93,34.96},{45.63,30.43},{46.99,42.0},{45.27,42.87},{45.39,41.47},{47.44,38.28},{46.75,37.54},{44.39,38.28},{45.36,39.61},{48.33,39.46},{47.41,40.68},{46.77,39.86},{45.42,40.52},{45.15,37.54},{44.42,37.6},{45.26,32.42},{46.19,31.68},{45.27,34.88},{44.59,40.5},{48.91,42.83},{49.18,43.49},{49.88,36.82},{48.3,41.65},{47.58,42.83},{49.59,36.02},{49.22,33.88},{48.73,34.09},{49.02,34.13},{47.67,31.24},{49.02,35.26},{49.21,33.54},{46.87,33.38},{46.91,34.88},{49.24,36.25},{47.48,36.08},{42.69,32.27},{49.82,36.21},},},{[85]={{42.84,34.22},{43.09,33.99},{43.33,33.82},{43.47,33.72},{43.67,33.59},{43.37,33.79},{43.14,33.97},{43.0,34.08},{49.24,33.83},{49.12,33.63},{49.23,33.39},{49.37,33.53},{49.22,33.88},{49.16,33.97},{49.07,33.87},{49.17,33.97},},},85,nil,nil,21,nil,},
[1523] = {'Cracked Skull Soldier',148,166,8,9,0,{[85]={{49.08,31.62},{48.8,29.11},{46.04,30.2},{45.43,28.48},{51.31,33.19},{48.29,27.9},{47.09,28.02},{46.13,33.54},{49.47,32.91},{44.85,29.29},{43.79,35.37},{44.85,31.49},{43.83,32.63},{47.64,34.36},{45.05,34.62},{44.68,33.89},{46.96,30.16},{48.23,32.94},{48.91,33.72},{49.15,33.28},{48.45,32.85},{48.36,34.99},{43.33,31.32},{49.62,34.94},},},{[85]={{48.29,35.07},{47.84,34.91},{47.87,34.3},{48.17,33.69},{48.66,34.07},{48.65,35.03},},},85,nil,nil,21,nil,},
[1525] = {'Rotting Dead',102,120,5,6,0,{[85]={{56.35,46.37},{51.28,53.81},{56.05,47.63},{51.27,51.61},{54.53,54.3},{52.89,54.0},{55.21,48.11},{53.54,46.32},{55.37,51.36},{54.63,49.63},{54.41,50.06},{52.15,46.36},{53.35,50.23},{51.91,47.45},{52.1,50.39},{53.57,47.36},{52.76,49.34},{54.98,57.29},{49.78,56.03},{51.86,58.05},{49.82,53.77},{54.05,55.98},{53.63,55.87},{54.38,56.91},{52.72,57.1},{54.38,59.65},{53.57,58.27},{52.8,59.37},{53.0,53.51},{54.23,50.31},{54.93,50.51},{54.28,55.87},{53.16,54.23},{52.01,58.3},{53.05,56.42},{53.36,56.23},},},nil,85,nil,nil,21,nil,},
[1526] = {'Ravaged Corpse',120,136,6,7,0,{[85]={{54.82,59.18},{50.64,54.16},{51.36,52.78},{51.9,53.79},{52.25,52.31},{53.94,45.04},{53.57,54.11},{54.7,54.15},{55.51,48.8},{52.93,52.85},{54.2,51.54},{52.1,48.68},{52.62,50.47},{52.0,45.41},{52.73,45.92},{52.74,47.25},{54.17,48.52},{53.55,48.59},{52.67,48.11},{55.82,57.12},{51.96,59.54},{49.24,55.57},{53.38,57.0},{53.74,57.6},{52.2,56.53},{52.15,59.68},{53.62,60.6},{52.95,51.68},{54.54,53.62},{54.07,51.25},{54.52,50.33},{52.24,52.22},{49.3,55.15},{51.62,57.69},},},nil,85,nil,nil,21,nil,},
[1527] = {'Hungering Dead',137,156,7,8,0,{[85]={{68.1,43.54},{68.15,42.53},{67.54,43.75},{67.76,42.17},{67.62,42.49},{69.55,41.75},{69.67,41.12},{67.3,42.27},{67.51,43.05},{68.45,41.47},},},nil,85,nil,nil,21,nil,},
[1528] = {'Shambling Horror',156,176,8,9,0,{[85]={{66.7,45.11},{66.71,44.8},{67.96,43.97},{68.74,43.56},},},nil,85,nil,nil,21,nil,},
[1529] = {'Bleeding Horror',183,202,9,10,0,{[85]={{77.83,59.47},{76.51,59.59},{75.59,59.55},{76.74,60.11},{76.84,62.78},{76.2,62.66},{74.58,59.51},{74.16,62.79},{76.14,61.08},{74.87,61.64},{78.54,60.25},{77.12,61.22},},},{[28]={{19.16,47.76},{19.12,47.1},{19.08,46.4},{18.97,46.14},{18.4,45.91},{17.98,45.91},{17.83,46.51},{18.17,46.81},{18.36,47.15},{18.24,47.83},{18.19,48.38},{18.37,48.76},{18.78,49.07},{18.36,48.75},{18.19,48.36},{18.25,47.82},{18.35,47.15},{18.16,46.79},{17.84,46.49},{17.97,45.88},{18.42,45.9},{18.97,46.12},{19.08,46.4},{19.13,47.1},{19.16,47.76},{18.64,47.78},{18.43,47.59},{18.04,47.57},{17.75,47.59},{17.69,48.17},{17.69,48.5},{17.74,48.76},{18.23,48.92},{18.59,48.99},{18.62,48.38},{18.66,47.98},{18.83,47.58},{18.85,46.87},{19.21,46.54},{19.51,46.3},{19.59,46.77},{19.58,47.52},{19.56,48.13},{19.5,48.98},{19.12,49.01},{18.84,48.6},{19.03,48.43},{18.87,48.63},{19.13,49.01},{19.47,48.96},{19.55,48.14},{19.59,47.53},{19.59,46.76},{19.49,46.28},{19.19,46.51},{18.87,46.84},{18.84,47.57},{18.66,47.98},{18.62,48.4},{18.23,48.92},{17.74,48.77},{17.69,48.48},{17.69,48.17},{17.76,47.57},{18.04,47.54},{18.45,47.59},{18.83,47.6},},[85]={{76.14,61.08},{76.1,60.44},{76.06,59.79},{75.96,59.54},{75.41,59.31},{75.01,59.32},{74.87,59.89},{75.19,60.17},{75.37,60.5},{75.27,61.14},{75.21,61.67},{75.39,62.03},{75.78,62.32},{75.38,62.02},{75.21,61.65},{75.27,61.14},{75.37,60.49},{75.19,60.15},{74.89,59.86},{75.01,59.29},{75.43,59.31},{75.96,59.52},{76.07,59.78},{76.11,60.45},{76.13,61.08},{75.65,61.09},{75.45,60.92},{75.07,60.9},{74.8,60.92},{74.74,61.47},{74.74,61.78},{74.79,62.03},{75.26,62.18},{75.6,62.25},{75.62,61.66},{75.66,61.28},{75.83,60.91},{75.84,60.23},{76.18,59.92},{76.47,59.69},{76.55,60.14},{76.54,60.85},{76.52,61.43},{76.47,62.24},{76.11,62.27},{75.84,61.88},{76.01,61.72},{75.86,61.9},{76.11,62.26},{76.44,62.22},{76.51,61.44},{76.54,60.86},{76.55,60.12},{76.46,59.67},{76.17,59.89},{75.86,60.2},{75.83,60.9},{75.67,61.29},{75.63,61.69},{75.26,62.19},{74.79,62.04},{74.74,61.76},{74.74,61.47},{74.81,60.9},{75.08,60.87},{75.46,60.92},{75.82,60.92},},},85,nil,nil,21,nil,},
[1530] = {'Rotting Ancestor',198,222,10,11,0,{[85]={{51.31,28.1},{54.72,31.34},{53.41,30.39},{52.1,32.85},{49.76,30.26},{53.26,31.03},{49.73,28.59},{54.36,29.2},{52.67,26.02},{51.58,33.43},{50.58,29.08},{48.6,31.98},{52.31,26.87},{52.4,26.48},{51.28,31.46},{52.69,26.13},{52.6,26.67},{52.02,30.57},{52.24,26.36},{51.99,26.9},{52.66,26.42},{51.73,27.04},{51.81,25.72},},},nil,85,nil,nil,21,nil,},
[1531] = {'Lost Soul',120,137,6,7,4,{[85]={{53.18,48.37},{53.34,45.6},},},nil,85,nil,nil,21,nil,},
[1532] = {'Wandering Spirit',198,222,10,11,0,{[85]={{76.54,60.48},{76.48,60.74},{78.46,59.38},{77.37,58.65},{76.5,58.73},{75.23,58.2},{75.08,59.13},{75.58,61.39},{74.22,61.47},{75.01,60.48},{77.94,61.29},{76.84,61.55},},},{[28]={{19.89,48.26},{20.44,48.24},{20.57,48.27},{20.57,48.97},{20.57,48.6},{20.04,48.58},{19.96,48.61},{19.94,49.25},{20.03,49.34},{20.27,49.35},{19.95,49.32},{19.97,48.61},{20.58,48.61},{20.57,48.97},{20.58,48.24},{20.14,48.27},{19.76,48.26},{19.77,47.63},{19.76,47.14},{19.36,47.15},{18.71,47.14},{19.19,47.14},{19.77,47.12},{19.77,47.59},{19.77,48.18},},[85]={{76.84,61.55},{77.35,61.54},{77.48,61.57},{77.48,62.23},{77.48,61.88},{76.97,61.86},{76.9,61.89},{76.89,62.49},{76.97,62.58},{77.2,62.59},{76.89,62.56},{76.91,61.88},{77.49,61.88},{77.48,62.23},{77.49,61.54},{77.07,61.56},{76.71,61.56},{76.72,60.96},{76.71,60.49},{76.33,60.5},{75.71,60.49},{76.17,60.49},{76.72,60.47},{76.72,60.91},{76.72,61.48},},},85,nil,nil,21,nil,},
[1533] = {'Tormented Spirit',155,176,8,9,4,{[85]={{45.59,31.62},},},{[85]={{44.16,31.71},{44.37,31.39},{44.78,31.21},{45.55,31.18},{45.93,31.16},{46.15,31.09},{46.5,30.85},{46.61,30.84},{46.74,30.97},{46.87,31.19},{46.94,31.39},{47.48,32.3},{47.8,32.91},{47.99,33.69},{48.07,34.27},{48.02,34.68},{47.95,34.91},{47.56,35.64},{47.21,36.03},{46.92,36.26},{46.27,36.57},{46.05,36.63},{45.78,36.63},{45.61,36.56},{45.43,36.16},{45.25,35.77},{45.05,35.53},{44.87,35.43},{44.62,35.34},{44.39,35.31},{44.06,34.76},{44.15,34.11},{44.17,33.63},{44.16,33.13},{44.07,32.67},{44.04,32.4},{44.16,31.71},},},85,nil,nil,21,nil,},
[1534] = {'Wailing Ancestor',176,198,9,10,0,{[85]={{52.68,29.32},{55.16,29.96},{52.87,27.04},{54.74,29.53},{53.96,29.82},{51.87,31.48},{53.52,28.0},{51.97,26.58},{52.11,26.33},{50.98,30.53},{51.42,29.26},{52.23,27.45},{51.87,28.76},{52.59,25.78},{51.99,26.15},{52.03,25.63},},},nil,85,nil,nil,21,nil,},
[1535] = {'Scarlet Warrior',120,137,6,7,0,{[85]={{31.83,51.09},{30.87,46.57},{30.39,49.13},{33.62,45.29},{30.64,47.61},{29.95,49.97},{29.72,49.47},{31.39,50.4},{30.46,51.27},{32.15,45.0},{34.14,51.4},{32.98,50.33},{31.28,48.43},{32.62,51.2},{32.12,49.34},{33.64,49.24},{37.4,47.71},{36.93,48.18},{33.53,47.36},{36.17,47.41},{32.95,46.63},{30.75,46.19},{34.25,47.84},{34.47,49.43},{32.77,48.22},{32.21,46.72},{33.6,48.4},{31.73,46.42},{31.68,46.3},{32.08,47.4},{31.81,46.45},{31.88,46.04},{31.68,45.88},{31.68,46.24},{31.98,45.91},},},{[85]={{36.91,48.18},{36.55,48.18},{36.15,48.18},{35.78,48.19},{35.37,48.2},{34.9,48.22},{34.56,48.21},{34.21,48.08},{33.83,47.89},{33.44,47.78},{33.09,47.73},{32.82,47.72},{32.47,47.73},{32.23,47.89},{32.26,48.06},{32.4,48.21},{32.57,48.09},{32.77,47.9},{32.96,47.76},{33.53,47.81},{33.96,48.0},{34.39,48.19},{34.86,48.23},{35.54,48.25},{36.17,48.24},{36.79,48.24},{37.36,48.21},{37.68,48.21},{37.97,48.26},{38.28,48.38},{38.52,48.5},{38.73,48.6},{38.46,48.47},{38.06,48.29},{37.77,48.19},{37.36,48.17},},},85,nil,nil,67,nil,},
[1536] = {'Scarlet Missionary',137,156,7,8,0,{[85]={{43.23,65.17},{46.13,65.07},{48.85,66.77},{44.46,64.99},{46.68,64.05},{48.19,66.38},{50.15,68.82},{50.54,67.75},{53.37,68.11},{52.78,67.42},{51.05,69.71},{50.23,66.93},{51.65,66.7},},},{[85]={{46.13,65.07},{45.87,65.13},{45.59,65.41},{45.46,65.64},{45.38,65.79},{45.24,66.01},{45.04,66.29},{44.88,66.51},{44.46,66.45},{44.29,66.46},{44.01,66.59},{43.79,66.57},{43.63,66.56},{43.48,66.52},{43.2,66.46},{42.96,66.37},{42.7,66.37},{42.54,66.42},{42.42,66.45},{42.28,66.44},{42.46,66.38},{42.69,66.23},{42.99,66.0},{43.08,65.66},{43.13,65.48},{43.33,65.18},{43.64,65.25},{43.87,65.25},{44.05,65.14},{44.2,64.86},{44.21,64.53},{44.37,64.37},{44.62,64.17},{44.85,63.96},{45.08,63.78},{45.35,63.67},{45.56,63.61},{45.76,63.63},{45.82,64.09},{45.92,64.45},{46.01,64.65},{46.27,64.72},{46.38,65.05},{46.82,65.15},{47.19,65.41},{47.43,65.73},{47.65,66.0},{47.88,66.2},{48.1,66.5},{48.46,66.96},{48.82,67.43},{49.09,67.55},{49.56,67.49},{49.75,67.48},{49.99,67.45},{50.14,67.47},{50.47,67.55},{50.07,67.49},{49.88,67.46},{49.68,67.47},{49.38,67.5},{49.22,67.52},{48.99,67.54},{48.81,67.47},{48.62,67.23},{48.47,67.03},{48.24,66.72},{48.07,66.49},{47.89,66.25},{47.77,66.14},{47.65,66.02},{47.49,65.78},{47.34,65.59},{47.16,65.41},{46.96,65.27},{46.73,65.17},{46.53,65.11},{46.38,65.1},{46.68,64.06},{47.0,64.23},{47.19,64.34},{47.31,64.45},{47.48,64.7},{47.62,64.8},{47.72,64.89},{47.84,65.04},{47.9,65.17},{47.95,65.33},{47.83,65.04},{47.69,64.88},{47.52,64.75},{47.39,64.53},{47.29,64.39},{47.13,64.25},{46.94,64.19},{46.67,64.09},{46.5,64.13},{46.34,64.19},{46.53,64.15},},[1497]={{0.36,5.44},{1.4,6.82},{3.07,9.01},{4.77,11.21},{6.06,11.78},{8.28,11.51},{9.19,11.44},{10.3,11.32},{10.98,11.38},{12.54,11.8},{10.69,11.51},{9.78,11.38},{8.86,11.42},{7.4,11.56},{6.67,11.62},{5.58,11.72},{4.75,11.39},{3.83,10.25},{3.15,9.31},{2.06,7.86},{1.24,6.77},{0.42,5.68},{0.47,0.59},{0.67,1.35},},},85,nil,nil,67,nil,},
[1537] = {'Scarlet Zealot',156,176,8,9,0,{[85]={{88.22,42.58},{87.44,42.91},{87.12,43.24},{87.45,43.43},{87.09,42.4},{86.83,42.25},{79.91,56.36},{80.29,57.09},{86.83,43.39},{86.99,41.51},{86.06,41.84},{85.8,43.46},{87.84,43.93},{87.35,41.71},{81.0,55.39},{48.82,66.18},{80.98,56.86},{53.66,66.0},{50.6,67.96},{81.67,54.78},{51.96,69.55},{54.34,69.28},{53.81,66.82},{52.66,67.36},{51.18,67.6},{50.46,64.71},{79.59,55.17},{77.13,55.12},{76.62,54.76},{76.25,55.21},{76.88,56.2},{77.18,56.77},{78.38,56.03},{85.34,42.75},{52.91,69.04},{52.15,68.56},{51.75,66.09},{52.15,67.13},{51.15,65.71},{51.52,67.59},{52.05,68.13},},[1497]={{19.98,14.53},},},{[85]={{52.05,68.13},{52.49,67.85},{52.76,67.71},{52.97,67.63},{53.21,67.69},{53.63,67.9},{53.8,67.36},{53.92,66.91},{53.5,67.02},{53.19,67.08},{52.77,67.18},{52.49,67.3},{52.25,67.63},},[1497]={{19.98,14.53},{22.07,13.21},{23.33,12.51},{24.33,12.16},{25.47,12.42},{27.43,13.43},{28.22,10.9},{28.8,8.78},{26.82,9.28},{25.38,9.58},{23.39,10.05},{22.08,10.59},{20.92,12.17},},},85,nil,nil,67,nil,},
[1538] = {'Scarlet Friar',166,186,9,10,0,{[85]={{86.94,42.29},{86.76,43.06},{87.02,43.81},{87.15,43.46},{81.6,53.1},{86.58,44.92},{87.16,42.73},{79.35,24.58},{79.32,26.08},{80.96,57.25},{80.65,55.12},{81.11,56.9},{77.1,54.88},{79.49,25.98},{78.32,56.26},{76.11,57.23},{78.86,56.23},{78.65,55.38},{79.02,31.23},{79.45,55.51},{79.4,56.24},{78.49,56.04},{78.88,36.1},},},{[28]={{22.68,10.88},{22.68,10.62},{22.66,10.45},{22.53,10.42},{22.67,10.51},{22.67,10.84},{22.53,10.79},{22.31,10.51},{22.23,10.14},{22.3,9.74},{22.47,9.53},{22.68,9.44},{22.84,9.48},{23.05,9.67},{23.13,10.04},{23.06,10.44},{22.91,10.69},{22.8,10.78},{22.71,10.84},{22.71,11.02},{22.7,11.41},{22.69,10.95},{22.72,10.82},{22.82,10.76},{23.08,10.48},{23.13,10.12},{23.09,9.73},{22.9,9.46},{22.71,9.44},{22.46,9.52},{22.29,9.75},{22.22,10.14},{22.29,10.47},{22.47,10.73},{22.55,10.79},},[85]={{79.49,25.98},{79.49,25.73},{79.47,25.57},{79.35,25.54},{79.48,25.64},{79.48,25.94},{79.35,25.89},{79.14,25.63},{79.06,25.28},{79.12,24.9},{79.28,24.7},{79.48,24.62},{79.64,24.65},{79.84,24.83},{79.92,25.19},{79.85,25.57},{79.71,25.8},{79.6,25.89},{79.52,25.95},{79.52,26.12},{79.5,26.49},{79.5,26.05},{79.52,25.92},{79.62,25.87},{79.87,25.6},{79.92,25.26},{79.88,24.89},{79.69,24.63},{79.51,24.61},{79.28,24.69},{79.11,24.9},{79.05,25.27},{79.11,25.59},{79.29,25.84},{79.37,25.9},},},85,nil,nil,67,nil,},
[1539] = {'Scarlet Neophyte',186,208,10,11,0,{[85]={{79.12,27.09},{79.72,24.67},{79.02,28.53},{79.05,25.6},{78.46,32.49},},},{[28]={{22.92,9.49},{22.73,9.21},{23.07,9.65},{23.17,10.06},{23.09,10.48},{22.83,10.86},{23.14,10.38},{23.09,9.67},{22.22,10.49},{22.52,10.88},{22.21,10.52},{22.16,10.15},{22.24,9.72},{22.34,9.49},{22.18,9.96},},[85]={{79.72,24.66},{79.53,24.4},{79.86,24.81},{79.96,25.21},{79.88,25.6},{79.63,25.96},{79.92,25.51},{79.88,24.83},{79.05,25.61},{79.34,25.98},{79.04,25.64},{78.99,25.28},{79.07,24.88},{79.16,24.66},{79.01,25.11},},},85,nil,nil,67,nil,},
[1540] = {'Scarlet Vanguard',198,222,10,11,0,{[85]={{77.65,32.79},{79.26,24.44},{78.13,32.1},{79.39,29.67},{78.45,32.82},{79.64,26.07},{77.87,35.44},{78.67,36.09},{77.61,34.71},},},{[28]={{21.23,17.36},{21.1,17.6},{21.01,17.78},{20.94,17.99},{20.95,18.29},{20.98,18.57},{20.94,18.09},{21.0,17.79},{21.1,17.58},{21.3,17.3},{21.49,17.17},{21.64,17.08},{21.78,17.0},{21.99,16.87},{22.09,16.56},{21.99,16.81},{21.82,17.02},{21.63,17.13},{21.43,17.25},{22.58,14.76},{22.58,15.09},{22.55,15.47},{22.49,15.84},{22.41,16.27},{22.23,16.86},{22.07,17.29},{21.92,17.68},{21.69,18.28},{21.59,18.57},{21.44,18.93},{21.33,19.23},{21.22,19.62},{21.2,19.94},{21.24,20.31},{21.29,20.77},{21.33,21.13},{21.36,21.39},{21.4,21.75},{21.44,22.06},{21.5,22.41},{21.44,22.03},{21.38,21.5},{21.34,21.06},{21.31,20.58},{21.3,20.22},{21.33,19.62},{21.39,19.32},{21.49,18.98},{21.56,18.76},{21.73,18.25},{21.88,17.83},{22.09,17.26},{22.16,17.08},{22.32,16.65},{22.43,16.25},{22.5,15.92},{22.55,15.54},{22.58,15.27},{22.58,14.85},{22.58,14.48},{22.54,14.05},{22.5,13.72},{22.47,13.33},{22.46,13.08},{22.46,12.59},{22.49,12.26},{22.5,11.95},{22.37,11.96},{22.47,12.14},{22.44,12.64},{22.44,12.94},{22.44,13.26},{22.49,13.74},{22.52,13.98},{22.57,14.37},},[85]={{78.11,32.14},{77.99,32.38},{77.9,32.55},{77.84,32.75},{77.84,33.04},{77.88,33.3},{77.84,32.84},{77.89,32.56},{77.98,32.36},{78.17,32.09},{78.35,31.97},{78.5,31.89},{78.63,31.81},{78.84,31.69},{78.93,31.39},{78.83,31.62},{78.67,31.83},{78.49,31.93},{78.3,32.04},{79.39,29.68},{79.4,29.99},{79.36,30.35},{79.31,30.7},{79.23,31.11},{79.06,31.68},{78.9,32.09},{78.77,32.46},{78.55,33.02},{78.45,33.3},{78.31,33.65},{78.2,33.92},{78.1,34.3},{78.08,34.61},{78.12,34.96},{78.17,35.4},{78.2,35.74},{78.23,35.98},{78.27,36.33},{78.31,36.63},{78.37,36.95},{78.31,36.59},{78.25,36.08},{78.22,35.67},{78.19,35.21},{78.17,34.87},{78.2,34.3},{78.26,34.01},{78.36,33.69},{78.42,33.48},{78.58,33.0},{78.73,32.6},{78.93,32.06},{78.99,31.89},{79.14,31.48},{79.25,31.09},{79.31,30.77},{79.37,30.42},{79.39,30.16},{79.4,29.76},{79.39,29.41},{79.36,29.0},{79.32,28.69},{79.29,28.31},{79.27,28.08},{79.28,27.61},{79.3,27.3},{79.32,27.0},{79.2,27.01},{79.29,27.18},{79.26,27.66},{79.26,27.95},{79.26,28.24},{79.31,28.7},{79.34,28.93},{79.38,29.3},},},85,nil,nil,67,nil,},
[1543] = {'Vile Fin Puddlejumper',137,156,7,8,0,{[85]={{34.31,44.17},{30.12,43.61},{34.91,44.7},{30.7,44.6},{36.14,43.03},{29.65,44.95},{63.12,27.52},{35.92,43.02},{30.34,45.59},{30.45,43.29},{35.61,42.16},{60.71,27.18},{61.84,26.94},{34.59,41.28},{30.13,44.64},{63.21,27.91},{34.66,40.92},{30.65,45.02},{29.44,45.08},{36.18,39.21},{61.66,27.86},{58.51,28.79},{58.57,28.83},{37.0,41.93},{57.7,28.3},{61.57,29.4},{62.63,30.69},{57.69,26.06},{58.58,26.86},{58.11,26.5},{58.91,27.1},{58.56,28.13},{60.77,28.36},{59.71,28.85},},},nil,85,nil,nil,18,nil,},
[1544] = {'Vile Fin Minor Oracle',148,198,8,9,0,{[85]={{75.13,26.54},{34.73,40.81},{63.4,27.82},{34.45,41.6},{29.83,44.78},{36.36,44.57},{35.97,42.89},{29.16,45.85},{30.81,44.94},{62.94,28.8},{63.09,29.49},{60.93,27.21},{26.24,46.34},{35.6,43.33},{35.79,39.49},{75.15,26.93},{67.42,24.47},{67.34,24.85},{31.07,43.17},{37.01,40.78},{30.65,43.62},{34.96,40.76},{35.83,43.5},{62.26,28.28},{62.76,28.28},{33.66,42.8},{31.37,43.75},{70.54,25.74},{67.48,25.78},{35.56,44.27},{34.62,43.51},{30.47,43.37},{36.83,45.09},{30.69,43.22},{64.03,28.69},{26.07,47.28},{64.54,29.79},{64.86,29.74},{67.9,25.4},{70.45,25.27},{58.34,28.13},{36.53,35.95},{36.43,40.6},{36.7,42.02},{64.04,30.62},{61.3,29.99},{61.73,28.2},{57.89,26.3},{58.45,27.59},{58.85,27.08},{60.15,27.28},{59.43,29.07},{59.75,28.88},{59.39,28.35},{60.86,27.58},{60.07,28.38},},},nil,85,nil,nil,18,nil,},
[1545] = {'Vile Fin Muckdweller',176,198,9,10,0,{[85]={{70.06,24.97},{68.7,25.42},{73.46,24.98},{67.7,28.47},{64.54,29.07},{67.57,27.31},{66.88,26.26},{74.56,26.4},{72.69,26.41},{34.81,44.96},{38.08,29.5},{72.01,27.25},{74.08,26.17},{66.72,28.12},{65.21,30.43},{66.16,29.79},{67.54,29.5},{65.31,28.61},{65.96,27.37},{72.34,25.62},{74.8,27.09},{34.84,42.43},{29.85,41.5},{25.3,47.35},{26.0,48.35},{75.45,26.39},{74.97,27.63},{68.01,28.64},{75.66,26.13},{72.54,26.1},{73.31,27.16},{69.61,26.01},{30.51,42.77},{34.29,43.59},{75.09,26.76},{75.57,26.38},{64.56,29.62},{64.66,30.38},{64.72,30.36},{75.17,27.39},{69.06,25.45},{70.17,25.63},{35.76,41.45},{26.81,46.77},{25.48,48.47},{75.39,26.91},{64.44,29.68},{70.42,27.12},{71.23,26.17},{66.99,26.17},{72.01,25.22},{68.22,26.06},{67.8,25.84},{38.58,30.57},{39.55,34.75},{38.01,35.1},{40.88,34.96},{36.53,38.39},{36.53,40.63},{36.44,42.63},},},nil,85,nil,nil,18,nil,},
[1547] = {'Decrepit Darkhound',101,113,5,6,0,{[85]={{38.64,40.26},{40.67,42.86},{41.33,49.62},{40.69,52.67},{50.0,47.35},{64.41,48.26},{40.75,44.96},{38.71,43.68},{51.09,50.53},{60.52,40.44},{64.54,53.54},{37.49,45.14},{49.96,49.76},{62.84,38.09},{66.09,50.33},{38.97,40.74},{41.51,48.8},{44.46,57.02},{38.78,44.65},{39.91,46.25},{38.47,47.3},{65.15,49.15},{61.01,44.43},{38.6,41.76},{48.97,58.95},{61.62,40.44},{67.54,52.64},{37.96,41.45},{38.74,45.46},{41.87,42.43},{62.83,40.52},{39.98,43.74},{61.48,43.88},{39.36,51.99},{39.1,42.58},{62.57,39.4},{40.44,41.24},{40.27,39.69},{41.8,56.22},{48.62,53.68},{44.37,53.33},{45.01,54.17},{67.46,55.03},{61.82,45.6},{64.58,43.12},{63.7,43.46},{69.6,63.78},{64.37,40.14},{70.62,65.06},{62.91,47.94},{63.53,46.33},{42.62,40.64},{40.18,56.35},{55.31,53.39},{63.64,41.67},{68.59,54.4},{68.4,57.8},{65.13,37.39},{66.47,56.88},{66.13,55.62},{42.66,50.05},{41.02,55.73},{46.12,57.35},{47.98,58.58},{59.49,56.9},{59.89,55.65},{61.08,55.61},{64.84,61.79},{65.88,40.01},{67.21,63.51},{64.13,58.88},{62.37,46.95},{63.05,54.02},{57.81,52.71},{56.56,53.64},{62.58,54.92},{66.16,57.86},{49.29,54.31},{63.33,50.83},{64.14,56.57},},},nil,85,nil,nil,38,nil,},
[1548] = {'Cursed Darkhound',122,172,7,8,0,{[85]={{68.27,30.71},{68.22,36.18},{45.3,68.49},{41.98,67.46},{47.72,63.34},{40.58,58.42},{40.99,61.61},{42.77,62.4},{46.87,50.13},{74.55,37.64},{72.84,61.52},{77.19,73.85},{81.36,64.7},{75.82,54.27},{65.03,32.77},{75.57,33.04},{73.27,31.66},{72.07,29.47},{69.68,28.53},{74.44,35.97},{66.73,34.78},{48.48,63.9},{49.7,65.81},{50.12,60.92},{45.81,64.22},{53.43,63.3},{47.97,48.4},{47.39,49.09},{74.56,54.33},{81.35,72.07},{71.78,37.99},{68.94,31.68},{70.37,36.06},{72.76,28.47},{66.1,34.96},{42.82,58.13},{41.54,64.48},{45.08,60.83},{50.89,63.4},{49.95,49.88},{47.0,45.44},{80.05,67.21},{72.58,49.24},{75.44,64.58},{71.48,36.14},{71.11,32.65},{69.02,29.64},{67.6,31.61},{76.74,34.8},{43.73,42.92},{42.29,46.98},{42.19,42.79},{46.36,67.73},{48.34,59.02},{44.18,61.89},{52.4,71.35},{43.86,60.57},{46.26,46.11},{45.14,47.69},{74.82,69.88},{72.99,41.41},{69.06,35.61},{76.46,31.02},{68.93,33.94},{74.04,28.66},{44.67,66.98},{46.74,60.64},{43.81,62.01},{71.93,61.83},{79.89,69.31},{70.36,29.51},{68.05,34.65},{44.96,43.88},{44.59,40.39},{43.34,45.23},{40.56,60.87},{50.62,62.26},{49.18,62.89},{43.21,68.06},{41.47,65.51},{44.52,45.21},{78.55,66.53},{73.2,38.06},{74.88,46.04},{77.85,72.55},{72.61,47.61},{79.21,61.57},{75.78,73.55},{71.14,59.5},{77.53,71.35},{79.02,63.99},{72.86,56.89},{79.7,66.08},{76.52,70.21},{76.94,68.05},{71.84,47.24},{80.86,63.99},{76.92,64.87},{77.52,68.54},{72.68,46.47},{74.64,44.25},{41.25,44.38},{75.64,45.37},{75.01,68.77},{45.07,47.84},{45.94,46.91},{40.26,42.53},{80.5,72.54},{80.23,58.62},{54.34,63.68},{52.47,74.61},{46.08,50.86},{47.33,50.98},{44.78,54.38},{48.25,50.0},{54.06,66.91},{56.62,64.36},{68.06,36.98},{72.63,32.62},{78.03,32.68},{74.14,35.26},{70.52,31.53},{53.99,65.72},{72.61,43.66},{72.01,52.09},{80.59,60.6},{74.95,72.64},{78.89,59.09},{57.47,63.0},{51.19,70.22},{52.01,72.34},{55.6,66.1},{44.26,58.24},{54.91,71.44},{53.01,65.15},{52.84,72.48},{58.3,58.28},{63.38,33.72},{51.45,60.03},{57.94,60.62},{76.19,52.4},{69.03,59.87},{41.87,45.03},{57.35,62.38},{60.21,62.17},{58.42,62.67},{58.42,59.95},{57.06,59.58},{72.21,40.24},{77.75,63.4},{76.44,29.6},{59.43,60.73},{48.61,56.67},{55.69,65.66},{55.26,69.82},{55.69,73.58},},},nil,85,nil,nil,38,nil,},
[1549] = {'Ravenous Darkhound',176,198,9,10,0,{[85]={{88.25,41.72},{86.79,39.09},{84.43,41.47},{85.85,39.47},{83.2,47.36},{81.96,47.03},{82.99,50.38},{88.87,44.94},{83.28,41.74},{87.4,46.03},{89.79,41.8},{90.3,47.12},{89.51,43.89},{90.35,40.61},{86.08,37.85},{82.98,48.81},{88.21,43.81},{88.16,46.39},{89.42,47.86},{79.59,49.52},{86.97,45.34},{88.93,46.73},{88.16,48.5},{82.23,48.32},{83.89,44.2},{83.63,46.04},{83.9,41.45},{85.13,44.04},{85.07,45.99},{85.97,45.06},{81.48,45.15},{80.17,42.44},{82.11,43.56},},},nil,85,nil,nil,38,nil,},
[1550] = {'Thrashtail Basilisk',1902,1981,41,42,0,{[33]={{39.1,49.48},{40.43,52.14},{39.08,50.42},{39.08,52.02},{38.26,50.5},{37.85,49.87},{39.28,47.1},{40.41,48.69},{40.38,50.63},{40.78,49.95},{40.91,51.33},{41.35,50.57},{38.8,44.94},},},nil,33,nil,nil,49,nil,},
[1551] = {'Ironjaw Basilisk',2059,2138,43,44,0,{[33]={{42.67,47.82},{42.4,48.41},{43.39,47.9},{42.67,48.27},{43.69,48.33},{43.84,47.8},{42.6,49.37},{43.01,49.16},{43.48,49.14},{44.01,48.36},{43.9,49.11},{44.19,47.83},{43.63,46.21},{43.46,47.04},{43.63,46.73},{42.71,45.84},{43.5,45.92},{42.77,48.94},{41.87,46.96},{42.27,47.25},{42.08,47.01},},},nil,33,nil,nil,49,nil,},
[1552] = {'Scale Belly',2218,2218,45,45,4,{[33]={{43.44,45.71},{42.61,46.49},{41.79,48.36},{43.74,47.5},},},nil,33,nil,nil,49,nil,},
[1553] = {'Greater Duskbat',120,137,6,7,0,{[85]={{41.71,57.42},{41.77,40.32},{44.6,49.41},{49.98,48.54},{65.88,53.24},{67.04,56.56},{62.48,41.77},{62.49,43.54},{65.42,38.58},{50.89,59.33},{49.21,59.63},{41.13,47.43},{41.45,56.92},{51.36,49.55},{46.81,50.28},{46.75,50.84},{65.18,41.74},{67.08,51.8},{65.49,56.61},{63.28,47.06},{40.06,52.66},{36.49,47.27},{37.93,43.91},{37.31,43.48},{44.46,50.13},{45.23,51.2},{62.9,35.81},{64.29,46.01},{64.17,44.13},{46.67,60.16},{49.49,49.69},{62.3,43.91},{62.97,45.96},{64.77,50.15},{60.45,43.15},{64.04,54.89},{64.73,40.44},{41.08,42.21},{42.32,44.19},{63.16,38.69},{63.28,41.72},{61.77,41.38},{43.28,56.19},{37.44,46.4},{62.21,36.85},{60.91,38.49},{64.33,36.57},{37.5,38.75},{64.88,38.2},{62.87,44.02},{64.09,37.77},{66.67,62.26},{41.9,53.66},{40.13,55.64},{38.48,38.57},{40.31,48.65},{42.47,42.37},{59.98,41.84},{65.07,54.57},{45.54,58.9},{39.14,47.79},{66.53,53.61},{39.31,42.22},{53.63,64.97},{63.67,49.22},{66.83,55.91},{55.75,61.0},{56.59,62.94},{51.87,48.39},{46.8,52.52},{55.05,64.03},{55.5,63.43},{47.25,46.41},{54.22,65.86},{47.93,45.09},{45.69,52.54},{42.98,57.33},{61.65,38.76},{43.26,41.51},{66.28,54.51},{63.27,47.58},{71.01,63.81},{64.46,57.33},{68.26,62.85},{45.42,57.32},{46.58,58.0},{69.05,53.87},{42.75,47.67},{48.81,57.69},{53.38,64.14},{45.84,54.41},{45.86,56.37},{54.08,61.72},{54.99,62.57},{52.49,63.5},{43.1,46.2},{61.1,56.3},{67.99,54.12},{43.77,55.87},{58.55,56.18},{57.98,55.23},{58.01,57.08},{58.82,58.43},{62.22,56.57},{60.34,60.85},{58.44,57.0},{56.86,55.74},{47.36,55.25},{45.33,54.6},{57.43,59.72},{56.33,57.46},{59.32,61.61},{57.09,54.21},{63.19,49.72},{45.79,54.81},{48.86,55.02},{47.41,56.25},{59.26,56.08},{63.79,61.45},{64.72,58.45},},},nil,85,nil,nil,15,"AH",},
[1554] = {'Vampiric Duskbat',156,176,8,9,0,{[85]={{71.91,33.74},{65.79,34.95},{66.16,31.68},{73.69,33.91},{76.39,30.31},{72.81,30.56},{49.12,59.82},{44.43,62.56},{43.12,67.06},{71.24,46.76},{80.08,62.34},{78.58,73.42},{81.94,74.25},{74.75,44.22},{83.58,48.38},{67.49,34.01},{69.66,34.79},{41.63,63.35},{47.52,62.19},{48.62,63.57},{44.72,60.3},{78.7,69.73},{75.65,55.78},{82.23,66.0},{71.15,36.91},{73.44,36.09},{72.68,65.31},{83.74,51.59},{71.06,34.61},{70.44,33.73},{68.55,28.26},{76.8,31.63},{43.95,68.04},{44.93,63.15},{48.38,63.21},{45.34,66.28},{45.55,62.82},{72.77,58.29},{78.19,70.24},{80.68,66.42},{70.96,58.38},{90.39,44.81},{74.16,32.65},{71.84,31.55},{69.7,30.47},{45.88,67.28},{42.07,59.36},{44.88,69.1},{80.18,64.27},{74.19,71.5},{72.64,37.19},{74.58,58.68},{78.61,71.69},{88.7,42.83},{71.24,30.5},{68.19,32.83},{69.71,32.85},{65.48,33.81},{64.49,36.56},{41.63,60.87},{46.27,61.55},{43.24,63.05},{76.14,63.72},{75.78,51.26},{79.34,70.72},{69.79,60.66},{74.99,52.96},{78.84,62.44},{82.82,46.29},{87.29,38.45},{84.85,39.1},{73.27,29.22},{40.62,60.04},{47.95,67.82},{73.04,39.29},{82.03,64.61},{76.41,66.18},{71.18,48.21},{79.58,69.23},{70.52,61.23},{80.5,59.27},{81.28,66.52},{72.69,47.08},{75.45,47.13},{83.06,44.32},{73.97,67.34},{75.72,47.92},{83.65,66.33},{80.7,70.51},{72.08,59.83},{75.47,72.43},{72.77,62.58},{80.08,72.81},{87.28,40.63},{90.37,42.78},{84.63,40.78},{71.7,49.04},{74.55,47.25},{76.95,71.27},{80.36,67.74},{71.26,50.06},{73.37,59.35},{78.73,64.6},{73.26,40.59},{46.85,66.39},{48.71,61.97},{72.86,42.64},{75.38,35.09},{50.71,61.71},{79.25,58.98},{80.66,46.27},{73.2,44.29},{76.61,72.33},{73.67,57.12},{42.17,58.58},{51.39,61.76},{52.88,63.65},{51.92,63.37},{70.18,53.68},{75.44,46.14},{84.13,43.06},{79.28,48.69},{82.9,42.61},{82.52,42.77},{84.37,44.89},{78.98,45.89},{82.22,52.76},{78.64,44.93},{81.14,48.19},{80.04,44.52},{74.89,64.03},{77.67,46.19},{76.79,48.29},{74.88,33.72},},},nil,85,nil,nil,16,nil,},
[1555] = {'Vicious Night Web Spider',176,198,9,10,0,{[85]={{85.97,52.54},{83.68,52.4},{87.51,53.85},{87.31,51.21},{89.51,52.54},{91.75,49.54},{85.67,52.55},{83.41,55.56},{90.32,49.28},{84.49,50.11},{87.44,56.06},{86.76,57.01},{88.89,53.73},{85.88,57.29},{85.95,53.68},{83.77,55.38},{89.69,51.7},{87.98,53.67},{91.05,50.53},{86.62,53.76},{84.68,52.83},{85.42,55.1},{89.06,49.81},{86.74,53.2},{89.8,50.44},{85.11,50.97},{88.18,54.95},{84.47,51.01},{85.18,48.34},{84.54,47.17},{87.38,49.29},{85.91,49.26},{86.72,48.38},{86.73,50.53},{88.13,50.41},{82.43,54.77},},},nil,85,nil,nil,22,nil,},
[1557] = {'Elder Mistvale Gorilla',1829,1902,40,41,0,{[33]={{34.4,62.52},{31.35,60.7},{34.99,64.44},{34.46,66.73},{34.62,65.42},{34.13,66.37},{33.54,67.02},{33.86,67.52},{33.05,67.58},{32.33,68.43},{32.11,66.14},{31.43,65.37},{32.57,66.64},{31.9,67.57},{30.88,66.73},{31.15,67.93},{32.42,57.97},{30.85,60.03},{33.6,62.23},{33.17,63.43},{33.51,63.62},{33.03,66.12},{33.05,64.84},{32.59,65.45},{34.01,64.54},{33.48,65.45},{32.01,59.82},{32.45,59.13},},},nil,33,nil,nil,72,nil,},
[1558] = {'Silverback Patriarch',1981,2059,42,43,0,{[33]={{35.51,62.7},{35.15,63.43},{37.85,60.84},{37.14,62.25},{37.76,62.16},{36.41,62.4},{35.48,63.33},{36.28,63.87},{37.89,59.95},},},nil,33,nil,nil,72,nil,},
[1559] = {'King Mukla',11368,11368,51,51,1,{[33]={{40.95,83.9},},},nil,33,nil,nil,16,nil,},
[1560] = {'Yvette Farthing',644,644,15,15,0,{[85]={{61.58,52.6},},},nil,85,nil,{361,},68,"H",},
[1561] = {'Bloodsail Raider',1829,1902,39,41,0,{[33]={{32.34,71.67},{33.07,73.96},{33.46,73.28},{32.44,73.12},{28.06,70.35},{27.6,69.44},{27.52,69.63},{27.29,69.97},},},nil,33,nil,nil,119,nil,},
[1562] = {'Bloodsail Mage',1292,1332,39,41,0,{[33]={{32.05,72.53},{27.94,69.91},{27.52,69.26},{27.4,69.76},{26.04,67.18},{26.84,67.52},{25.76,66.03},{28.89,70.72},},},nil,33,nil,nil,119,nil,},
[1563] = {'Bloodsail Swashbuckler',1829,1902,41,43,0,{[33]={{24.49,53.96},{24.38,54.06},{24.44,53.82},{23.16,52.79},{23.86,53.8},{33.85,86.16},{28.23,82.4},{27.02,83.01},{26.86,83.85},{26.91,82.98},{26.53,83.51},{27.2,83.37},{26.67,82.84},{32.98,77.25},{31.95,79.47},{30.96,81.07},{30.1,87.5},{24.08,55.96},},},nil,33,nil,nil,119,nil,},
[1564] = {'Bloodsail Warlock',1292,1332,41,43,0,{[33]={{22.77,53.91},{24.51,54.06},{24.48,52.78},{22.86,53.39},{23.48,53.58},{33.53,86.52},{26.84,82.6},{29.88,81.21},{29.67,81.54},{29.62,80.93},{29.65,80.81},{29.39,81.33},{27.65,82.52},{27.32,82.48},{27.18,82.74},{29.99,80.57},{29.73,87.47},{29.97,87.95},{23.09,54.66},{24.24,54.55},},},nil,33,nil,nil,119,nil,},
[1565] = {'Bloodsail Sea Dog',1902,1981,43,45,0,{[33]={{31.51,54.26},{31.98,54.43},{29.38,88.62},{29.44,89.02},{29.25,89.07},{30.69,90.34},{30.71,89.95},{29.22,88.35},{29.42,88.91},{30.7,90.25},{30.7,90.02},{30.65,89.57},},},{[33]={{30.7,90.02},{30.7,89.94},{30.63,89.91},{30.63,89.89},{30.63,89.9},{30.71,89.9},{30.78,89.92},{30.7,89.94},{30.7,90.02},{30.77,90.05},{30.58,90.05},{30.57,90.04},{30.56,89.93},{30.48,89.92},{30.54,89.89},{30.56,89.76},{30.54,89.66},{30.48,89.65},{30.53,89.65},{30.53,89.52},{30.48,89.51},{30.76,89.52},{30.71,89.53},{30.71,89.64},{30.75,89.65},{30.71,89.64},{30.7,89.58},{30.76,89.52},{30.53,89.52},{30.53,89.65},{30.48,89.65},{30.54,89.66},{30.56,89.76},{30.54,89.89},{30.48,89.92},{30.56,89.93},{30.57,90.04},{30.49,90.04},{30.58,90.05},{30.77,90.05},{30.65,89.57},{30.65,89.45},{30.65,89.31},{30.62,89.24},{30.58,89.49},{30.59,89.24},{30.65,89.24},{30.65,89.31},{30.65,89.45},},},33,nil,nil,119,nil,},
[1568] = {'Undertaker Mordo',166,166,5,5,0,{[85]={{30.22,71.65},},},nil,85,{363,},nil,68,"H",},
[1569] = {'Shadow Priest Sarvis',166,166,5,5,0,{[85]={{30.84,66.2},},},nil,85,{364,3095,3096,3097,3098,3099,3901,},{363,364,3901,},68,"H",},
[1570] = {'Executor Arren',166,166,5,5,0,{[85]={{32.15,66.01},},},nil,85,{380,381,382,383,},{380,381,382,},68,"H",},
[1571] = {'Shellei Brondir',7842,7842,55,55,1,{[11]={{9.49,59.69},},},nil,11,nil,nil,12,"A",},
[1572] = {'Thorgrum Borrelson',7842,7842,55,55,1,{[38]={{33.94,50.95},},},nil,38,{6391,},{6387,},55,"A",},
[1573] = {'Gryth Thurden',7842,7842,55,55,1,{[1537]={{55.5,47.74},},},nil,1537,{6392,},{6388,},55,"A",},
[1632] = {'Adele Fielder',1042,1042,22,22,0,{[12]={{46.38,62.05},},},nil,12,nil,nil,12,"A",},
[1642] = {'Northshire Guard',3866,3866,55,55,0,{[12]={{47.15,47.87},{46.12,47.88},{45.59,48.46},{45.36,48.43},{44.03,47.31},{44.16,46.8},{48.11,42.12},},},{[12]={{45.52,47.83},{45.55,47.8},{46.1,47.86},{46.69,48.05},{46.99,47.87},{47.16,47.47},{47.1,46.88},{46.85,46.42},{46.59,46.15},{46.64,46.15},{47.03,46.69},{47.17,47.26},{47.05,47.82},{46.75,48.09},{46.22,47.89},{45.46,47.78},{44.95,47.67},{44.26,47.44},{44.09,47.15},{44.14,46.66},{44.59,46.34},{45.28,46.24},{46.45,46.16},{46.51,46.11},{45.9,46.21},{44.97,46.31},{44.36,46.4},{44.11,46.86},{44.19,47.36},{44.47,47.57},{45.1,47.62},{48.11,42.12},{47.73,42.44},{47.54,42.92},{47.5,43.53},{47.53,44.27},{47.38,44.79},{47.0,45.35},{46.73,45.82},{46.71,45.88},{47.06,45.22},{47.47,44.58},{47.49,43.32},{47.56,42.73},{47.97,42.21},},},12,nil,nil,11,"A",},
[1645] = {'Quartermaster Hicks',413,413,10,10,0,{[12]={{25.37,74.0},},},nil,12,nil,nil,12,"A",},
[1646] = {'Baros Alexston',1605,1605,30,30,0,{[1519]={{49.19,30.28},},},nil,1519,{389,393,396,399,},{373,392,395,399,},12,"A",},
[1650] = {'Terry Palin',456,456,11,11,0,{[12]={{82.95,63.31},},},nil,12,nil,nil,12,"A",},
[1651] = {'Lee Brown',334,334,8,8,0,{[12]={{47.61,62.32},},},nil,12,nil,nil,12,"A",},
[1652] = {'Deathguard Burgess',1172,1172,24,24,0,{[85]={{60.93,52.01},},},nil,85,{374,},{374,},68,"H",},
[1653] = {'Bloodsail Elder Magus',1110,1156,44,45,0,{[33]={{31.88,53.9},{32.07,54.62},{32.0,54.28},{31.8,54.51},{31.94,54.41},{29.4,88.79},{31.76,54.24},{33.6,88.12},{32.9,88.32},{33.63,88.11},{30.57,89.69},{29.28,88.57},{30.71,89.45},{29.27,89.03},},},{[33]={{29.27,89.03},{29.22,88.87},{29.2,88.76},{29.23,88.56},{29.31,88.52},{29.23,88.56},{29.2,88.76},{29.22,88.87},{29.27,89.03},{29.3,89.19},{29.36,89.39},{29.3,89.19},},},33,nil,nil,119,nil,},
[1654] = {'Gregor Agamand',198,198,10,10,0,{[85]={{46.74,29.31},},},nil,85,nil,nil,21,nil,},
[1655] = {'Nissa Agamand',198,198,10,10,0,{[85]={{49.74,36.34},},},{[85]={{49.74,36.34},{49.65,36.18},{49.48,36.1},{49.45,35.97},{49.45,35.88},{49.51,35.64},{49.55,35.62},{49.61,35.68},{49.63,35.81},{49.59,36.03},{49.42,36.06},{49.35,36.03},{49.64,36.15},{49.79,36.22},{49.64,36.15},{49.42,36.06},{49.35,36.03},{49.59,36.03},{49.63,35.81},{49.61,35.68},{49.55,35.62},{49.51,35.64},{49.45,35.88},{49.45,35.97},{49.48,36.1},{49.65,36.18},{49.74,36.34},},},85,nil,nil,21,nil,},
[1656] = {'Thurman Agamand',197,197,10,10,0,{[85]={{44.0,33.64},},},nil,85,nil,nil,21,nil,},
[1657] = {'Devlin Agamand',176,176,9,9,0,{[85]={{47.34,40.78},},},nil,85,nil,nil,21,nil,},
[1658] = {'Captain Dargol',273,273,13,13,0,{[85]={{52.81,26.35},},},nil,85,nil,nil,21,nil,},
[1660] = {'Scarlet Bodyguard',156,156,8,8,0,{[85]={{79.44,25.12},{79.46,25.25},},},nil,85,nil,nil,67,nil,},
[1661] = {'Novice Elreth',112,112,3,3,0,{[85]={{30.86,66.05},},},nil,85,{376,6395,},{376,6395,},68,"H",},
[1662] = {'Captain Perrine',176,176,9,9,0,{[85]={{51.14,67.8},},},nil,85,nil,nil,67,nil,},
[1663] = {'Dextren Ward',2250,2250,26,26,1,{[717]={{-1, -1}},},nil,717,nil,nil,41,nil,},
[1664] = {'Captain Vachon',222,222,11,11,0,{[85]={{78.82,56.13},},},nil,85,nil,nil,67,nil,},
[1665] = {'Captain Melrache',247,247,12,12,0,{[85]={{79.52,25.15},},},nil,85,nil,nil,67,nil,},
[1666] = {'Kam Deepfury',2400,2400,27,27,1,{[717]={{-1, -1}},},nil,717,nil,nil,41,nil,},
[1667] = {'Meven Korgal',103,103,5,5,0,{[85]={{36.57,68.54},},},{[85]={{36.57,68.54},{36.48,68.85},},},85,nil,nil,67,nil,},
[1668] = {'William MacGregor',644,644,15,15,0,{[40]={{57.71,53.94},},},nil,40,nil,nil,12,"A",},
[1669] = {'Defias Profiteer',484,484,20,20,0,{[40]={{43.47,66.76},},},nil,40,nil,nil,35,"AH",},
[1670] = {'Mike Miller',919,919,20,20,0,{[40]={{57.75,53.71},},},nil,40,nil,nil,12,"A",},
[1671] = {'Lamar Veisilli',1240,1240,25,25,0,{[44]={{21.07,46.25},},},nil,44,nil,nil,12,"A",},
[1672] = {'Lohgan Eva',166,166,5,5,0,{[10]={{75.72,44.56},},},nil,10,nil,nil,12,"A",},
[1673] = {'Alyssa Eva',228,228,7,7,0,{[10]={{76.28,45.27},},},nil,10,nil,nil,12,"A",},
[1674] = {'Rot Hide Gnoll',120,137,6,7,0,{[85]={{58.8,33.74},{57.12,33.84},{58.77,42.73},{57.59,39.38},{59.41,44.22},{58.5,44.0},{56.94,38.22},{56.71,35.4},{57.89,37.2},{57.35,36.15},{60.0,34.02},{59.47,35.01},{58.69,41.96},{59.22,39.27},{58.78,38.53},{58.5,40.59},{59.35,44.21},},},{[85]={{57.89,37.23},{57.85,37.53},{58.05,37.62},{58.35,37.7},{58.91,37.85},{59.34,37.95},{59.72,38.04},{60.13,38.13},{60.25,37.61},{60.33,36.98},{60.39,36.46},{60.46,36.03},{60.54,35.43},{60.59,35.07},{60.59,34.64},{60.41,34.31},{60.28,34.07},{60.23,33.73},{60.14,33.23},{60.08,32.83},{60.08,32.43},{60.08,32.21},{59.79,32.01},{59.45,31.89},{59.2,31.8},{58.87,31.69},{58.72,31.64},{58.4,31.88},{58.36,32.28},{58.3,32.95},{58.25,33.57},{58.21,33.97},{58.14,34.57},{58.07,35.18},{58.04,35.79},{58.03,36.02},{57.97,36.46},{57.93,36.76},},[28]={{0.15,23.11},{0.47,23.19},{1.06,23.35},{1.5,23.46},{1.9,23.55},{2.33,23.64},{2.46,23.09},{2.55,22.43},{2.61,21.89},{2.68,21.44},{2.77,20.8},{2.82,20.42},{2.82,19.97},{2.63,19.63},{2.5,19.38},{2.44,19.02},{2.35,18.49},{2.28,18.08},{2.29,17.65},{2.28,17.43},{1.98,17.21},{1.62,17.09},{1.36,17.0},{1.01,16.88},{0.86,16.82},{0.52,17.08},{0.48,17.5},{0.42,18.2},{0.36,18.85},{0.32,19.27},{0.25,19.9},{0.17,20.54},{0.14,21.19},{0.13,21.43},{0.07,21.89},{0.03,22.21},},},85,nil,nil,70,nil,},
[1675] = {'Rot Hide Mongrel',137,156,7,8,0,{[85]={{57.97,35.17},{59.92,36.09},{56.34,33.71},{57.84,31.54},{57.91,32.51},{59.53,32.68},{58.61,36.11},{59.4,37.09},{59.35,33.69},{58.24,34.0},{60.89,32.48},{60.94,37.35},{60.47,38.82},{60.18,38.37},{60.79,33.68},{57.66,32.59},{58.73,31.02},{59.51,31.94},{58.54,31.34},},},{[28]={{0.07,20.52},{0.11,20.04},{0.16,19.56},{0.22,18.93},{0.17,19.43},{0.13,19.86},{0.08,20.4},{0.03,20.88},{2.7,24.37},{2.95,23.82},{3.1,23.34},{3.23,22.72},{3.33,21.72},{3.38,20.74},{3.41,19.99},{3.41,19.54},{3.35,18.91},{3.29,18.66},{3.21,19.07},{3.28,19.69},{3.4,20.23},{3.39,21.04},{3.31,21.85},{3.23,22.57},{3.15,23.13},{3.0,23.68},{2.79,24.21},{2.46,24.85},{2.17,25.39},{1.87,25.94},{2.17,25.38},{2.5,24.8},{0.23,16.84},{0.45,16.52},{0.65,16.54},{0.8,16.6},{1.03,16.68},{1.48,16.84},{1.79,16.95},{2.11,17.06},{2.38,17.16},{2.39,17.95},{2.45,18.55},{2.52,18.9},{2.59,19.31},{2.64,19.41},{2.8,19.62},{2.9,19.55},{3.03,19.26},{3.05,18.98},{3.02,18.7},{2.9,18.28},{2.78,17.99},{2.66,17.75},{2.53,17.44},{2.37,17.15},{2.18,17.1},{1.86,16.98},{1.52,16.86},{1.08,16.7},{0.8,16.61},{0.64,16.55},{0.44,16.53},{0.25,16.82},},[85]={{57.97,35.15},{58.01,34.7},{58.06,34.24},{58.12,33.64},{58.07,34.12},{58.04,34.53},{57.98,35.04},{57.94,35.5},{57.88,36.07},{57.81,36.7},{57.75,37.28},{57.7,37.74},{57.72,37.73},{57.78,37.2},{57.83,36.59},{57.89,35.88},{60.47,38.82},{60.71,38.29},{60.86,37.84},{60.98,37.25},{61.07,36.3},{61.12,35.37},{61.15,34.65},{61.15,34.23},{61.09,33.62},{61.04,33.38},{60.96,33.77},{61.03,34.37},{61.14,34.88},{61.13,35.65},{61.06,36.42},{60.98,37.11},{60.91,37.64},{60.76,38.17},{60.56,38.66},{60.24,39.27},{59.97,39.79},{59.69,40.31},{59.97,39.78},{60.29,39.23},{57.66,32.59},{57.69,32.35},{57.86,32.07},{58.13,31.65},{58.34,31.35},{58.53,31.37},{58.66,31.42},{58.89,31.5},{59.31,31.65},{59.61,31.76},{59.91,31.87},{60.18,31.96},{60.18,32.71},{60.24,33.28},{60.3,33.62},{60.37,34.0},{60.42,34.1},{60.57,34.3},{60.67,34.23},{60.79,33.96},{60.81,33.69},{60.78,33.43},{60.66,33.03},{60.56,32.74},{60.44,32.52},{60.31,32.23},{60.16,31.95},{59.98,31.9},{59.68,31.79},{59.35,31.67},{58.94,31.52},{58.67,31.43},{58.52,31.38},{58.33,31.36},{58.15,31.63},{57.88,32.04},{57.69,32.38},},},85,nil,nil,70,nil,},
[1676] = {'Finbus Geargrind',1684,1684,31,31,0,{[10]={{77.38,48.82},},},nil,10,nil,nil,875,"A",},
[1678] = {'Vernon Hale',413,413,10,10,0,{[44]={{27.49,47.83},},},nil,44,nil,nil,12,"A",},
[1679] = {'Avarus Kharag',622,622,23,23,0,{[1]={{68.14,56.12},},},nil,1,nil,nil,57,"A",},
[1680] = {'Matthew Hooper',413,413,10,10,0,{[44]={{26.99,51.13},},},nil,44,nil,nil,12,"A",},
[1681] = {'Brock Stoneseeker',644,644,15,15,0,{[38]={{37.02,47.81},},},nil,38,{6387,},{6392,},55,"A",},
[1682] = {'Yanni Stoutheart',644,644,15,15,0,{[38]={{34.76,48.62},},},nil,38,nil,nil,55,"A",},
[1683] = {'Warg Deepwater',644,644,15,15,0,{[38]={{40.59,39.69},},},nil,38,nil,nil,55,"A",},
[1684] = {'Khara Deepwater',644,644,15,15,0,{[38]={{40.28,39.28},},},nil,38,nil,nil,55,"A",},
[1685] = {'Xandar Goodbeard',644,644,15,15,0,{[38]={{82.47,63.35},},},nil,38,nil,nil,55,"A",},
[1686] = {'Irene Sureshot',644,644,15,15,0,{[38]={{83.15,63.42},},},nil,38,nil,nil,55,"A",},
[1687] = {'Cliff Hadin',644,644,15,15,0,{[38]={{83.02,62.96},},},nil,38,nil,nil,55,"A",},
[1688] = {'Night Web Matriarch',102,102,5,5,0,{[85]={{23.97,58.19},},},nil,85,nil,nil,22,nil,},
[1689] = {'Scarred Crag Boar',176,198,9,10,0,{[1]={{71.17,54.04},{73.48,50.64},{73.99,52.99},{73.49,55.17},{72.96,59.89},{70.87,61.35},{74.93,60.83},{75.67,57.8},{75.7,49.85},{74.94,48.9},{74.14,49.0},{79.61,51.88},{79.38,55.81},{78.73,59.32},{79.71,57.59},{81.59,55.43},{81.35,53.09},{84.89,50.67},{84.7,48.26},{86.67,50.24},{86.27,47.51},{78.88,49.51},{80.16,47.54},{79.79,46.36},{81.04,43.92},{80.07,43.86},{83.21,38.13},{82.45,37.78},{82.7,35.5},{80.83,35.26},{80.16,34.7},{83.12,33.14},},},nil,1,nil,nil,1094,"AH",},
[1690] = {'Thrawn Boltar',1528,1528,29,29,0,{[1]={{45.3,51.53},},},nil,1,nil,nil,55,"A",},
[1691] = {'Kreg Bilmn',413,413,10,10,0,{[1]={{47.19,52.4},},},nil,1,nil,nil,55,"A",},
[1692] = {'Golorn Frostbeard',413,413,10,10,0,{[1]={{46.67,53.49},},},{[1]={{46.66,53.57},{46.72,53.74},{46.77,53.72},{46.72,53.74},{46.68,53.7},{46.66,53.57},{46.67,53.49},{46.67,53.49},},},1,nil,nil,55,"A",},
[1693] = {'Loch Crocolisk',300,328,14,15,0,{[38]={{51.19,34.87},{54.24,56.22},{56.1,37.8},{58.76,36.85},{54.54,41.69},{56.87,39.12},{54.03,39.3},{62.44,51.52},{56.55,36.4},{53.57,37.42},{53.15,39.24},{53.76,40.41},{55.51,33.84},{55.68,35.96},{56.29,37.56},{58.76,57.55},{59.98,41.76},{57.43,31.63},{56.45,52.59},{55.34,52.72},{55.08,52.89},{55.47,53.48},{61.31,43.67},{53.99,55.2},{61.86,45.41},{57.32,21.74},{58.33,23.97},},},nil,38,nil,nil,14,nil,},
[1694] = {'Loslor Rudge',413,413,10,10,0,{[1]={{50.08,49.42},},},nil,1,{5541,},nil,55,"A",},
[1695] = {'Rendow',2972,2972,45,45,0,{[357]={{89.35,45.86},},},nil,357,nil,nil,80,"A",},
[1696] = {'Targorr the Dread',1953,1953,24,24,1,{[717]={{-1, -1}},},nil,717,nil,nil,41,nil,},
[1697] = {'Keeg Gibn',413,413,10,10,0,{[1]={{30.45,46.01},},},nil,1,nil,nil,55,"A",},
[1698] = {'Frast Dokner',334,334,8,8,0,{[1]={{69.0,55.89},},},{[1]={{69.0,55.89},{68.95,55.84},{68.88,55.86},{68.86,55.95},{68.88,55.87},{68.95,55.85},},},1,nil,nil,55,"A",},
[1699] = {'Gremlock Pilsnor',413,413,10,10,0,{[1]={{47.67,52.31},},},nil,1,nil,nil,55,"A",},
[1700] = {'Paxton Ganter',413,413,10,10,0,{[1]={{35.48,40.22},},},nil,1,nil,nil,55,"A",},
[1701] = {'Dank Drizzlecut',413,413,10,10,0,{[1]={{69.32,55.46},},},nil,1,nil,nil,55,"A",},
[1702] = {'Bronk Guzzlegear',1172,1172,24,24,0,{[1]={{50.18,50.38},},},nil,1,nil,nil,55,"A",},
[1703] = {'Uthrar Threx',1172,1172,24,24,0,{[1537]={{43.82,27.86},},},nil,1537,nil,nil,55,"A",},
[1706] = {'Defias Prisoner',1815,1953,23,24,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1707] = {'Defias Captive',1815,1815,23,23,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1708] = {'Defias Inmate',1953,2097,24,25,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1711] = {'Defias Convict',1953,2097,24,25,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1713] = {'Elder Shadowmaw Panther',1981,2059,42,43,0,{[33]={{35.43,55.67},{36.21,56.74},{36.07,58.39},{35.65,57.77},{31.16,58.55},{36.72,55.93},{36.63,55.25},{36.28,55.26},{29.76,58.01},},},nil,33,nil,nil,16,nil,},
[1715] = {'Defias Insurgent',2097,2250,25,26,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1716] = {'Bazil Thredd',2715,2715,29,29,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1717] = {'Hamhock',2196,2196,28,28,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1718] = {'Rockjaw Raider',71,86,3,4,0,{[1]={{35.56,69.24},{34.98,68.4},{34.1,68.85},{34.87,69.4},{33.83,69.77},{34.56,70.92},{35.61,69.31},{35.62,68.05},{35.69,65.9},{35.77,66.9},},},nil,1,nil,nil,59,nil,},
[1719] = {'Warden Thelwater',1605,1605,30,30,0,{[1519]={{41.16,58.03},},},nil,1519,{387,391,392,},{387,389,391,},12,"A",},
[1720] = {'Bruegal Ironknuckle',2250,2250,26,26,1,{[717]={{-1, -1}},},nil,717,nil,nil,17,nil,},
[1721] = {'Nikova Raskol',166,166,5,5,0,{[1519]={{69.93,39.05},},},{[12]={{31.66,30.27},{31.92,30.57},{32.13,30.92},{32.4,31.33},{32.6,31.6},{32.73,31.99},{32.83,32.29},{32.81,32.55},{32.94,32.68},{32.94,32.68},{32.67,32.79},{32.52,33.61},{32.52,33.91},{32.86,34.29},{32.86,34.29},{32.86,34.29},{32.56,33.98},{32.05,33.9},{31.1,33.5},{30.26,32.05},{29.89,31.42},{30.23,30.8},{30.83,30.1},{31.08,29.93},{31.27,30.21},{31.27,30.21},{31.48,29.97},},[1519]={{70.26,40.3},{70.93,41.1},{71.47,42.0},{72.18,43.06},{72.69,43.74},{73.02,44.76},{73.28,45.54},{73.22,46.21},{73.57,46.53},{73.57,46.53},{72.85,46.81},{72.47,48.95},{72.47,49.72},{73.34,50.7},{73.34,50.7},{73.34,50.7},{72.57,49.9},{71.26,49.69},{68.81,48.66},{66.63,44.9},{65.69,43.28},{66.57,41.67},{68.1,39.87},{68.76,39.44},{69.25,40.16},{69.25,40.16},{69.8,39.55},},},1519,{388,},{388,},12,"A",},
[1725] = {'Defias Watchman',1068,1158,16,17,1,{[1581]={{-1, -1}},[33]={{9.02,1.76},{9.25,0.96},{9.45,1.18},{9.44,1.47},{11.14,2.33},},[40]={{39.19,79.01},{39.6,77.55},{39.97,77.95},{39.95,78.48},{43.05,80.05},},},{[33]={{9.02,1.75},{9.11,1.68},{9.19,1.57},{9.26,1.44},{9.21,1.55},{9.13,1.64},{9.08,1.71},{9.0,1.77},{8.94,1.82},{8.9,1.85},{8.84,1.85},{8.79,1.74},{8.79,1.62},{8.81,1.5},{8.87,1.4},{8.99,1.34},{9.02,1.33},{9.08,1.32},{9.17,1.32},{9.25,1.32},{9.31,1.33},{9.39,1.33},{9.33,1.32},{9.24,1.32},{9.17,1.32},{9.07,1.33},{9.01,1.34},{8.93,1.35},{8.85,1.43},{8.8,1.55},{8.79,1.69},{8.82,1.83},{8.91,1.85},{8.94,1.84},{9.25,0.96},{9.26,0.91},{9.28,0.74},{9.3,0.64},{9.31,0.53},{9.36,0.42},{9.37,0.3},{9.34,0.2},{9.29,0.09},{9.22,0.03},{9.29,0.08},{9.35,0.21},{9.37,0.32},{9.36,0.43},{9.3,0.57},{9.29,0.69},{9.28,0.82},{9.25,0.97},{9.24,1.08},{9.25,1.16},{9.25,1.09},},[40]={{39.19,79.0},{39.34,78.86},{39.49,78.67},{39.62,78.44},{39.53,78.64},{39.39,78.79},{39.3,78.92},{39.16,79.04},{39.04,79.13},{38.97,79.18},{38.85,79.18},{38.76,78.97},{38.76,78.75},{38.79,78.54},{38.92,78.35},{39.12,78.24},{39.17,78.23},{39.29,78.21},{39.46,78.21},{39.59,78.22},{39.72,78.22},{39.86,78.22},{39.74,78.22},{39.58,78.21},{39.45,78.21},{39.27,78.23},{39.17,78.24},{39.01,78.26},{38.88,78.41},{38.79,78.63},{38.76,78.89},{38.82,79.13},{38.98,79.17},{39.03,79.15},{39.6,77.55},{39.62,77.46},{39.66,77.16},{39.69,76.97},{39.72,76.77},{39.81,76.56},{39.82,76.35},{39.77,76.17},{39.68,75.97},{39.54,75.87},{39.67,75.96},{39.78,76.19},{39.82,76.38},{39.8,76.59},{39.69,76.84},{39.68,77.07},{39.66,77.3},{39.59,77.57},{39.59,77.76},{39.61,77.92},{39.6,77.79},},},33,nil,nil,17,nil,},
[1726] = {'Defias Magician',921,990,16,17,1,{[33]={{10.66,1.87},{10.91,1.78},},[40]={{42.17,79.2},{42.63,79.05},},},{[33]={{10.66,1.87},{10.74,1.91},{10.84,1.86},{10.94,1.74},{11.0,1.66},{11.06,1.57},{11.16,1.48},{11.22,1.48},{11.3,1.51},{11.36,1.56},{11.43,1.65},{11.51,1.75},{11.58,1.79},{11.68,1.81},{11.53,1.76},{11.46,1.68},{11.38,1.58},{11.29,1.5},{11.23,1.48},{11.16,1.49},{11.11,1.51},{11.06,1.59},{11.0,1.68},{10.92,1.8},{10.85,1.88},{10.8,1.9},{10.7,1.9},{10.64,1.85},{10.56,1.76},{10.53,1.72},{10.59,1.79},},[40]={{42.17,79.2},{42.31,79.29},{42.5,79.2},{42.69,78.97},{42.8,78.82},{42.91,78.67},{43.08,78.51},{43.19,78.49},{43.35,78.55},{43.45,78.66},{43.59,78.81},{43.72,79.0},{43.85,79.06},{44.04,79.11},{43.76,79.01},{43.63,78.87},{43.49,78.69},{43.33,78.54},{43.21,78.51},{43.08,78.52},{42.99,78.57},{42.9,78.69},{42.79,78.86},{42.65,79.09},{42.53,79.23},{42.43,79.26},{42.24,79.27},{42.14,79.17},{41.99,79.02},{41.93,78.94},{42.05,79.06},},},33,nil,nil,17,nil,},
[1727] = {'Defias Worker',356,386,16,17,0,{[33]={{9.76,1.5},{10.69,1.63},{9.38,0.18},{10.63,2.4},{9.04,2.18},{9.15,0.12},{9.91,1.68},{9.35,0.95},{10.37,2.23},{11.67,1.91},{11.06,1.51},{11.21,2.55},{10.16,2.18},{11.23,1.41},{9.61,1.24},{8.97,0.94},{9.09,1.16},{9.3,1.51},{8.69,1.72},{9.84,1.98},{8.87,2.11},{10.77,2.3},{11.15,1.67},{11.42,1.79},{9.25,0.61},{11.0,2.03},{9.18,1.72},{11.26,2.09},},[40]={{40.53,78.54},{42.22,78.77},{39.84,76.12},{42.11,80.19},{39.22,79.79},{39.43,76.02},{40.8,78.87},{39.79,77.53},{41.64,79.87},{44.01,79.28},{42.91,78.56},{43.17,80.46},{41.26,79.77},{43.21,78.37},{40.26,78.06},{39.09,77.51},{39.31,77.91},{39.7,78.55},{38.58,78.93},{40.67,79.41},{38.92,79.65},{42.37,80.0},{43.08,78.86},{43.56,79.08},{39.6,76.92},{42.8,79.51},{39.47,78.94},{43.27,79.61},},},nil,33,nil,nil,17,nil,},
[1729] = {'Defias Evoker',990,1062,17,18,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[1731] = {'Goblin Craftsman',1251,1347,18,19,1,{[1581]={{-1, -1}},},nil,1581,nil,nil,17,nil,},
[1732] = {'Defias Squallshaper',1137,1215,19,20,1,{[1581]={{-1, -1}},},{[1581]={{-1, -1}},},1581,nil,nil,17,nil,},
[1733] = {'Zggi',166,166,5,5,0,{[1519]={{26.54,78.67},},},nil,1519,nil,{397,},12,"A",},
[1735] = {'Deathguard Abraham',1114,1114,22,22,0,{[85]={{53.63,53.02},},},nil,85,nil,nil,71,"H",},
[1736] = {'Deathguard Randolph',4231,4231,55,55,0,{[85]={{31.92,64.88},},},nil,85,nil,nil,71,"H",},
[1737] = {'Deathguard Oliver',4108,4108,55,55,0,{[85]={{31.51,66.72},},},{[85]={{31.93,66.99},{31.82,67.67},{31.7,67.71},{31.63,67.49},{31.69,67.73},{31.83,67.69},{31.92,66.94},{31.47,66.69},{30.74,66.76},{31.77,66.72},{31.77,66.72},},},85,nil,nil,71,"H",},
[1738] = {'Deathguard Terrence',1200,1200,21,21,0,{[85]={{63.47,56.55},},},{[28]={{5.84,43.01},{5.95,43.34},{6.05,43.76},{6.08,43.99},{6.11,44.26},{6.12,44.63},{6.12,44.88},{6.11,45.18},{6.07,45.45},{5.97,45.88},{6.07,45.43},{6.11,45.19},{6.13,44.68},{6.09,44.06},{6.05,43.74},{5.95,43.33},{5.86,43.03},{5.73,42.64},{5.63,42.37},{5.51,42.13},{5.33,42.04},{5.09,42.03},{4.93,42.03},{4.7,41.99},{4.56,41.86},{4.33,41.46},{4.15,41.05},{4.04,40.72},{3.93,40.36},{3.86,40.14},{3.8,39.79},{3.77,39.92},{3.86,40.15},{3.94,40.44},{4.01,40.66},{4.17,41.08},{4.37,41.53},{4.52,41.81},{4.65,41.95},{4.82,42.0},{5.1,42.03},{5.24,42.04},{5.41,42.07},{5.58,42.25},{5.72,42.6},},[85]={{63.47,56.55},{63.57,56.87},{63.66,57.27},{63.7,57.49},{63.72,57.75},{63.73,58.1},{63.73,58.33},{63.72,58.63},{63.68,58.88},{63.58,59.28},{63.68,58.86},{63.72,58.64},{63.74,58.14},{63.71,57.56},{63.66,57.25},{63.57,56.86},{63.49,56.58},{63.36,56.21},{63.26,55.95},{63.15,55.72},{62.98,55.63},{62.75,55.63},{62.59,55.62},{62.38,55.59},{62.25,55.46},{62.03,55.08},{61.86,54.69},{61.75,54.38},{61.65,54.03},{61.58,53.83},{61.52,53.5},{61.49,53.62},{61.58,53.84},{61.66,54.11},{61.72,54.32},{61.88,54.72},{62.07,55.15},{62.21,55.41},{62.34,55.55},{62.5,55.6},{62.76,55.63},{62.9,55.63},{63.05,55.66},{63.22,55.84},{63.35,56.16},},},85,nil,nil,71,"H",},
[1739] = {'Deathguard Phillip',4108,4108,55,55,0,{[85]={{32.34,66.07},},},{[85]={{32.31,66.02},{32.15,65.91},{32.0,65.79},{32.0,65.25},{32.01,64.54},{31.98,65.62},{31.97,66.58},{31.94,67.19},{31.96,66.71},{31.98,66.07},{32.15,66.1},{32.56,66.06},{32.57,65.95},{32.15,65.87},{31.97,65.55},{31.98,65.0},{31.92,65.17},{31.88,66.61},{32.09,67.07},{32.1,67.03},{32.34,67.05},{32.42,66.95},{32.5,66.7},{32.22,66.64},{32.06,66.44},{32.08,66.11},{32.35,66.07},},},85,nil,nil,71,"H",},
[1740] = {'Deathguard Saltain',228,228,7,7,0,{[85]={{31.61,65.6},},},nil,85,{3902,},{3902,},83,"H",},
[1741] = {'Deathguard Bartrand',4108,4108,55,55,0,{[85]={{32.11,65.11},},},nil,85,nil,nil,71,"H",},
[1742] = {'Deathguard Bartholomew',919,919,20,20,0,{[85]={{58.47,51.39},},},{[28]={{0.59,37.58},{0.59,37.58},{0.48,37.37},{0.43,36.67},{0.45,35.92},{0.64,35.71},{0.92,35.42},{1.08,35.35},{1.31,35.38},{1.58,35.43},{1.77,35.46},{1.95,35.5},{2.05,35.52},{2.18,35.34},{2.3,35.14},{2.42,34.91},{2.5,34.67},{2.55,34.5},{2.47,34.12},{2.41,33.85},{2.27,33.47},{2.09,33.27},{1.94,33.15},{1.78,33.02},{1.62,32.9},{1.41,32.74},{1.25,33.04},{1.16,33.2},{0.95,33.44},{0.7,33.67},{0.48,33.84},{0.24,33.98},{0.09,34.07},{0.02,35.78},{0.21,35.86},{0.37,35.92},{0.41,36.15},{0.42,36.58},{0.44,37.06},{0.47,37.37},},[85]={{58.47,51.39},{58.47,51.39},{58.36,51.19},{58.32,50.52},{58.34,49.81},{58.52,49.61},{58.79,49.33},{58.94,49.27},{59.15,49.29},{59.41,49.34},{59.59,49.37},{59.76,49.41},{59.86,49.43},{59.98,49.26},{60.1,49.07},{60.21,48.85},{60.29,48.62},{60.33,48.46},{60.26,48.1},{60.2,47.84},{60.07,47.48},{59.9,47.28},{59.75,47.18},{59.6,47.05},{59.44,46.94},{59.25,46.79},{59.1,47.07},{59.01,47.22},{58.81,47.45},{58.57,47.67},{58.37,47.83},{58.14,47.97},{57.99,48.05},{57.8,48.2},{57.66,48.47},{57.59,48.76},{57.47,48.84},{57.37,48.96},{57.3,49.14},{57.43,49.32},{57.63,49.32},{57.78,49.53},{57.92,49.68},{58.11,49.75},{58.26,49.81},{58.3,50.03},{58.31,50.44},{58.33,50.89},{58.36,51.19},},},85,nil,nil,71,"H",},
[1743] = {'Deathguard Lawrence',1042,1042,22,22,0,{[85]={{58.54,51.42},},},nil,85,nil,nil,71,"H",},
[1744] = {'Deathguard Mort',1172,1172,24,24,0,{[85]={{61.43,53.05},},},{[28]={{3.71,39.32},{3.77,39.52},{4.04,39.58},{4.26,39.59},{4.64,39.45},{4.8,39.3},{4.9,38.85},{4.9,38.32},{4.77,37.71},{4.6,37.14},{4.41,36.6},{4.23,36.06},{4.08,35.6},{3.98,35.07},{3.91,34.6},{3.83,33.92},{3.6,33.32},{3.33,32.68},{3.1,32.21},{2.95,31.89},{3.18,32.4},{3.47,33.01},{3.65,33.42},{3.8,34.0},{3.92,34.75},{4.02,35.3},{4.18,35.87},{4.47,36.74},{4.69,37.39},{4.85,38.04},{4.89,38.67},{4.84,39.21},{4.64,39.47},{4.33,39.61},{4.06,39.64},{3.72,39.54},},[85]={{61.43,53.05},{61.49,53.24},{61.75,53.3},{61.96,53.3},{62.33,53.17},{62.48,53.03},{62.57,52.6},{62.57,52.1},{62.45,51.51},{62.28,50.97},{62.1,50.46},{61.93,49.94},{61.79,49.51},{61.7,49.01},{61.62,48.55},{61.55,47.9},{61.34,47.34},{61.07,46.73},{60.85,46.28},{60.72,45.98},{60.93,46.46},{61.21,47.04},{61.38,47.43},{61.52,47.98},{61.64,48.7},{61.73,49.22},{61.88,49.76},{62.16,50.59},{62.37,51.21},{62.52,51.83},{62.56,52.43},{62.51,52.94},{62.32,53.19},{62.02,53.32},{61.77,53.35},{61.45,53.25},},},85,nil,nil,71,"H",},
[1745] = {'Deathguard Morris',1042,1042,22,22,0,{[85]={{60.21,52.38},},},nil,85,nil,nil,71,"H",},
[1746] = {'Deathguard Cyrus',980,980,21,21,0,{[85]={{60.7,51.93},},},nil,85,nil,nil,71,"H",},
[1747] = {'Anduin Wrynn',166,166,5,5,0,{[1519]={{78.11,17.95},},},nil,1519,nil,nil,12,"A",},
[1748] = {'Highlord Bolvar Fordragon',999300,999300,63,63,3,{[1519]={{78.23,17.98},},},nil,1519,{4185,4186,6182,6187,6501,7496,7782,},{4184,4185,6186,6187,6403,7495,7781,},12,"A",},
[1749] = {'Lady Katrana Prestor',4743,4743,62,62,0,{[1519]={{78.11,17.75},},},nil,1519,nil,{396,},12,"A",},
[1750] = {'Grand Admiral Jes-Tereth',4079,4079,62,62,0,{[1519]={{81.77,12.85},},},nil,1519,nil,nil,12,"A",},
[1751] = {'Mithras Ironhill',4079,4079,62,62,0,{[1519]={{82.14,13.74},},},nil,1519,nil,nil,12,"A",},
[1752] = {'Caledra Dawnbreeze',3857,3857,60,60,0,{[1519]={{75.42,28.47},},},nil,1519,nil,nil,1576,"A",},
[1753] = {'Maggot Eye',198,198,11,11,0,{[85]={{58.66,30.77},},},nil,85,nil,nil,70,nil,},
[1754] = {'Lord Gregor Lescovar',1881,1881,31,31,0,{[1519]={{73.37,6.15},},},{[12]={{32.76,17.15},{32.61,17.17},{32.28,17.57},{32.44,18.08},{31.39,19.34},{31.21,19.56},{30.89,19.93},{31.39,19.33},{32.41,18.08},{32.3,17.53},{32.65,17.13},{32.87,17.04},},[1519]={{73.1,6.42},{72.71,6.48},{71.86,7.53},{72.26,8.82},{69.57,12.08},{69.09,12.67},{68.26,13.61},{69.56,12.06},{72.19,8.85},{71.92,7.42},{72.81,6.38},{73.37,6.15},},},1519,nil,nil,12,"A",},
[1755] = {'Marzon the Silent Blade',992,992,30,30,0,nil,nil,0,nil,nil,12,"A",},
[1756] = {'Stormwind Royal Guard',6209,6209,60,60,1,{[1519]={{68.74,28.35},{73.56,28.24},{70.07,28.16},{74.06,27.57},{69.66,27.35},{75.85,21.33},{75.43,20.54},{78.47,19.76},{77.51,19.58},{79.23,18.86},{76.92,18.45},{79.34,17.4},{77.03,17.03},{78.73,16.27},{77.73,15.86},{80.68,15.52},{80.24,14.74},{69.33,12.85},{69.04,12.29},{72.38,9.39},{71.91,8.5},{69.87,27.77},{73.99,28.26},{77.77,16.13},{69.24,29.27},},},{[12]={{31.51,25.41},{31.95,24.88},{32.21,24.57},{32.61,24.09},{32.96,23.68},{33.34,23.22},{33.76,22.72},{33.34,23.22},{32.96,23.68},{32.61,24.09},{32.21,24.57},{31.95,24.88},{33.1,25.6},{32.84,25.11},{32.59,24.65},{32.57,24.32},{32.76,24.1},{32.73,23.73},{32.6,23.5},{32.34,23.0},{32.09,22.53},{31.85,22.09},{31.69,21.75},{31.85,22.09},{32.09,22.53},{32.34,23.0},{32.6,23.5},{32.73,23.73},{32.76,24.1},{32.57,24.32},{32.59,24.65},{32.84,25.11},},[1519]={{69.87,27.77},{71.02,26.39},{71.68,25.6},{72.71,24.35},{73.6,23.3},{74.58,22.12},{75.68,20.83},{74.58,22.12},{73.6,23.3},{72.71,24.35},{71.68,25.6},{71.02,26.39},{73.99,28.26},{73.31,26.99},{72.66,25.8},{72.6,24.94},{73.09,24.38},{73.01,23.44},{72.69,22.84},{72.01,21.53},{71.36,20.32},{70.76,19.2},{70.32,18.31},{70.76,19.2},{71.36,20.32},{72.01,21.53},{72.69,22.84},{73.01,23.44},{73.09,24.38},{72.6,24.94},{72.66,25.8},{73.31,26.99},},},1519,nil,nil,11,"A",},
[1763] = {'Gilnid',2904,2904,20,20,1,{[1581]={{-1, -1}},},nil,1581,nil,nil,17,nil,},
[1764] = {'Greater Feral Spirit',5000,5000,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[1765] = {'Worg',198,222,10,11,0,{[130]={{64.8,5.89},{44.22,47.87},{45.76,50.18},{65.01,11.2},{68.93,5.49},{65.97,10.37},{43.19,52.38},{68.31,6.3},{69.09,7.8},{63.7,7.43},{63.83,11.1},{65.69,5.53},{66.37,8.98},{67.58,8.4},{64.41,7.96},{66.57,6.32},{57.96,8.3},{47.91,48.1},{64.85,7.28},{66.06,8.77},{70.2,7.1},{46.45,45.86},{69.31,7.42},{65.76,5.35},{68.81,4.9},{64.8,5.48},{68.26,6.61},{69.84,6.88},},[85]={{55.83,76.39},{53.19,74.74},{55.78,76.08},},},nil,130,nil,nil,38,nil,},
[1766] = {'Mottled Worg',222,247,11,12,0,{[130]={{59.24,13.59},{46.71,23.35},{47.55,25.71},{46.4,25.62},{49.37,15.38},{44.54,25.39},{61.01,9.04},{61.25,11.94},{48.95,20.05},{50.54,17.89},{50.05,13.6},{52.27,17.46},{55.52,17.32},{58.91,10.53},{57.41,15.81},{57.92,14.09},{59.75,10.38},{63.13,10.94},{62.13,8.51},{57.86,9.86},{44.52,26.8},{57.09,10.79},{49.16,22.46},{47.67,24.73},{47.49,21.82},{59.53,8.94},{61.79,8.8},{56.41,7.99},{58.47,6.8},{57.03,10.09},{57.68,8.77},{56.43,16.21},{54.49,12.79},{50.86,19.5},{50.85,21.78},{59.53,16.04},{56.16,10.23},{56.18,12.48},{54.88,13.61},{55.32,12.65},},},nil,130,nil,nil,38,nil,},
[1767] = {'Vile Fin Shredder',247,273,12,13,0,{[130]={{58.94,18.02},{63.56,12.85},{61.11,14.49},{62.99,12.57},{63.84,12.58},{64.16,12.92},{57.73,21.2},{57.85,24.64},{62.21,12.57},{63.76,12.1},{65.13,13.4},{66.57,12.99},{61.29,15.94},{56.48,25.95},{62.34,13.89},{57.36,21.2},{57.59,22.47},{56.92,19.32},{58.46,18.35},{64.24,11.21},{66.59,12.51},{67.03,11.72},{65.58,12.92},{55.67,28.18},{60.07,14.88},{65.82,12.54},{57.43,25.83},{57.02,23.8},{64.63,12.42},{65.1,11.77},{61.65,13.52},{60.75,13.47},{58.57,17.37},{60.15,16.55},{59.93,17.45},{60.46,15.55},{59.36,17.46},{56.09,27.72},{56.1,28.41},{56.76,25.31},{56.08,28.01},{57.13,22.03},{57.74,23.49},},},nil,130,nil,nil,18,nil,},
[1768] = {'Vile Fin Tidehunter',253,276,13,14,0,{[130]={{60.51,17.51},{59.09,18.11},{59.62,18.61},{59.1,17.78},{67.04,12.58},{62.93,13.01},{61.71,14.22},{57.34,18.99},{57.81,19.98},{66.63,12.66},{66.53,13.17},{57.57,18.41},{58.03,17.9},{66.22,13.18},{66.31,12.67},{66.15,12.97},{65.2,13.03},{60.89,16.4},{60.67,16.73},{59.91,17.67},{59.62,17.82},{55.98,27.17},{56.26,27.66},{56.21,27.5},},},nil,130,nil,nil,18,nil,},
[1769] = {'Moonrage Whitescalp',186,208,10,11,0,{[130]={{54.53,23.78},{55.67,19.75},{55.56,20.41},{55.8,19.87},{55.06,19.97},{55.46,19.97},{56.69,19.48},{56.25,18.63},{55.8,19.16},{54.93,21.71},{52.68,26.22},{53.63,22.53},{54.76,20.83},{55.41,23.11},{55.88,25.39},{53.0,26.69},{55.55,20.83},{52.2,24.8},{53.45,24.4},{55.87,20.66},{54.52,26.71},{54.11,41.38},{52.28,26.93},{48.52,31.77},{53.86,43.24},{52.04,26.26},{52.41,28.02},{51.92,28.17},{52.8,28.53},{51.36,26.47},{54.23,24.58},{52.86,37.98},{55.26,40.33},{51.49,43.09},{51.78,46.56},{52.2,41.75},{48.13,40.62},{49.78,40.49},{50.21,39.2},{47.79,34.1},{48.87,36.7},{49.14,39.61},{49.33,34.17},{49.44,34.93},{48.45,35.19},{50.74,47.78},{51.79,44.93},},},{[85]={{39.69,96.39},{39.35,96.35},{39.16,96.3},{39.32,95.86},{39.76,95.95},{39.98,96.4},{39.97,96.7},{39.72,97.02},{39.49,97.05},{39.34,96.7},{39.61,96.58},{39.78,96.9},{39.89,97.23},{40.03,97.49},{40.28,97.44},{40.24,96.98},{39.98,96.63},},[130]={{52.62,26.18},{52.26,26.13},{52.05,26.08},{52.22,25.6},{52.7,25.7},{52.93,26.19},{52.93,26.51},{52.65,26.85},{52.4,26.88},{52.25,26.51},{52.54,26.38},{52.72,26.73},{52.84,27.08},{52.99,27.36},{53.25,27.3},{53.21,26.81},{52.94,26.43},},},130,nil,nil,24,nil,},
[1770] = {'Moonrage Darkrunner',222,247,11,12,0,{[130]={{52.73,26.04},{52.84,24.28},{53.62,24.48},{53.86,27.16},{53.2,25.09},{48.84,24.02},{48.86,24.91},{48.33,24.52},{48.68,23.18},{47.72,25.25},{48.48,24.51},{52.88,28.38},{52.89,27.65},{52.68,27.99},},},nil,130,nil,nil,24,nil,},
[1772] = {'Rot Hide Gladerunner',222,247,11,12,0,{[130]={{44.2,23.55},{43.93,19.98},{44.73,22.59},{44.42,23.01},{44.93,23.75},{46.17,23.48},{46.47,21.8},{45.66,18.99},{45.67,23.43},{44.71,20.36},{45.43,19.76},},},nil,130,nil,nil,70,nil,},
[1773] = {'Rot Hide Mystic',230,253,12,13,0,{[130]={{44.37,19.59},{44.09,21.71},{44.12,22.38},{44.3,21.68},{45.7,22.74},{45.09,23.64},{44.99,22.89},{45.57,19.31},},},nil,130,nil,nil,70,nil,},
[1775] = {'Zun\'dartha',3857,3857,60,60,0,{[8]={{45.02,54.83},},},nil,8,nil,nil,29,"H",},
[1776] = {'Magtoor',2666,2666,42,42,0,{[8]={{25.98,31.4},},},nil,8,{1389,},{1389,1392,},35,"AH",},
[1777] = {'Dakk Blunderblast',644,644,15,15,0,{[38]={{35.43,42.82},},},nil,38,nil,nil,57,"A",},
[1778] = {'Ferocious Grizzled Bear',266,296,11,12,0,{[130]={{46.33,49.63},{44.6,50.39},{49.05,14.22},{51.03,14.94},{45.04,51.87},{44.09,52.0},{44.9,47.26},{44.24,48.15},{50.41,18.5},{49.37,17.4},{51.33,16.65},{44.5,24.65},{49.97,19.93},{46.01,26.03},{51.91,21.56},{52.16,19.59},{48.79,26.26},{47.95,23.26},{48.31,19.29},{48.2,20.32},{47.46,19.71},{51.28,38.75},{49.71,22.7},{51.22,18.6},{51.02,38.39},{50.58,40.84},{50.78,44.9},{54.54,43.89},{50.22,43.39},{51.07,42.46},{51.29,45.37},{50.12,36.18},{48.75,32.91},{47.32,32.99},{54.27,38.18},{53.52,39.5},{46.91,33.46},{55.18,44.15},{46.97,46.47},},},nil,130,nil,nil,44,nil,},
[1779] = {'Moonrage Glutton',247,273,12,13,0,{[130]={{42.93,32.67},{40.74,24.41},{41.13,25.54},{41.37,23.07},{39.57,27.8},{38.7,21.97},{37.89,23.22},{38.84,29.36},{39.63,25.84},{39.19,26.96},{49.57,17.02},{46.63,28.36},{43.55,29.08},{42.99,28.93},{42.15,29.4},{41.27,28.39},{39.65,23.41},{41.18,30.21},{40.53,28.97},{40.79,29.68},{49.8,18.76},{50.03,20.33},{51.03,16.9},{44.66,32.0},{44.18,31.61},{43.54,31.69},{43.5,31.32},{48.04,18.01},{50.7,14.54},{46.54,27.46},{45.29,27.26},{44.12,27.95},{55.6,46.64},{55.86,45.92},{56.5,46.45},{56.27,45.48},{56.21,45.88},{55.99,47.23},{51.46,19.76},{58.16,44.65},{56.93,45.91},{58.31,45.28},{48.8,24.59},{48.34,24.26},{56.42,47.69},{52.76,17.48},{55.53,49.31},{54.81,49.3},{54.62,48.3},},},{[85]={{36.15,94.85},{36.17,94.56},{36.24,94.22},{36.18,93.87},{36.11,93.5},{36.0,93.25},{35.86,92.92},{35.74,92.66},{35.56,92.68},{35.37,92.78},{35.23,92.73},{35.05,92.5},{35.44,92.97},{35.65,92.94},{35.78,92.94},{36.02,93.11},{36.16,93.43},{36.19,94.21},},[130]={{48.81,24.52},{48.84,24.2},{48.91,23.84},{48.85,23.47},{48.77,23.07},{48.66,22.79},{48.5,22.44},{48.38,22.16},{48.18,22.18},{47.98,22.29},{47.82,22.24},{47.63,21.99},{48.05,22.5},{48.28,22.46},{48.41,22.47},{48.67,22.64},{48.82,22.99},{48.85,23.83},},},130,nil,nil,24,nil,},
[1780] = {'Moss Stalker',247,273,12,13,0,{[130]={{34.8,12.72},{34.89,12.64},{35.05,14.52},{34.17,15.22},{37.2,15.91},{35.69,15.03},{36.44,14.95},{36.12,14.09},{35.9,13.71},{35.63,14.14},{35.55,13.08},{35.4,12.48},{34.16,17.33},{35.69,16.06},{35.02,16.16},},},nil,130,nil,nil,22,nil,},
[1781] = {'Mist Creeper',273,300,13,14,0,{[130]={{35.89,8.62},{35.43,8.86},{35.29,8.32},{34.76,7.85},{34.48,8.34},{35.85,8.16},{36.01,8.96},{34.33,9.18},{34.25,9.72},{34.52,9.94},{35.09,9.86},{34.7,10.22},{35.24,9.63},{35.34,10.38},{35.39,10.82},{35.53,10.52},{35.08,10.31},{35.28,10.05},{35.5,11.61},{35.11,11.47},},},nil,130,nil,nil,22,nil,},
[1782] = {'Moonrage Darksoul',273,300,13,14,0,{[130]={{58.61,42.27},{60.42,41.23},{60.4,41.4},{43.24,31.99},{58.7,41.09},{59.43,42.4},{43.73,30.84},{38.32,27.13},{40.18,26.93},{38.75,24.59},{36.78,21.9},{38.36,25.49},{37.6,24.51},{43.14,31.11},{43.53,32.14},{43.26,31.68},{39.69,30.3},{45.52,29.17},{57.19,45.71},{58.21,44.96},{57.26,45.71},{57.83,44.67},{57.52,44.97},{58.02,45.08},{56.03,48.59},},},{[130]={{57.24,45.69},{57.14,45.78},{56.86,45.89},{57.15,45.75},{57.29,45.66},{57.38,45.46},{57.44,45.01},{57.65,44.66},{57.83,44.71},{57.99,44.82},{57.74,44.7},{57.54,44.74},{57.41,45.01},{57.37,45.38},},[267]={{0.65,0.59},{0.51,0.72},{0.15,0.86},{0.54,0.68},{0.72,0.55},{0.83,0.3},{0.82,0.18},},},130,nil,nil,24,nil,},
[1783] = {'Skeletal Flayer',2880,2980,50,51,0,{[28]={{38.29,56.44},{38.12,53.81},{49.27,81.3},{49.61,76.62},{48.12,82.81},{49.4,77.07},{50.79,76.1},{54.54,80.88},{54.63,79.67},{53.92,80.17},{53.99,79.94},{38.11,55.11},{37.83,55.15},{47.37,81.79},{49.47,77.79},{54.66,81.03},{53.98,80.28},{53.95,80.99},{38.82,56.75},{37.07,58.36},{36.85,54.54},{37.61,58.49},{36.58,55.66},{48.06,80.72},{48.93,81.79},{48.15,78.6},{50.77,80.55},{50.43,75.35},{38.6,57.11},{39.05,55.9},{37.28,59.38},{36.79,56.77},{47.37,84.3},{47.3,80.5},{38.99,54.47},{36.05,58.49},{37.4,55.12},{37.56,56.55},{38.35,54.13},{38.88,54.93},{37.65,58.05},{36.64,57.74},{36.52,54.8},{35.95,55.87},{35.63,57.01},},},{[28]={{54.6,80.98},{54.61,80.72},{54.61,80.65},{54.61,80.19},{54.61,80.11},{54.53,79.87},{54.42,79.87},{54.21,79.87},{53.97,79.89},{53.94,80.09},{53.96,80.46},{53.97,80.76},{53.98,81.05},{54.22,80.99},{54.38,80.99},{54.5,80.99},{53.95,80.05},{53.96,80.28},{53.96,80.54},{53.96,80.96},{54.05,80.97},{54.22,80.98},{54.5,80.99},{54.58,80.96},{54.61,80.71},{54.61,80.61},{54.61,80.2},{54.61,80.08},{54.52,79.88},{54.37,79.87},{54.21,79.87},{54.05,79.88},},[36]={{96.94,24.37},{96.96,23.97},{96.96,23.86},{96.95,23.15},{96.96,23.03},{96.83,22.66},{96.67,22.65},{96.35,22.66},{95.98,22.7},{95.93,23.0},{95.96,23.56},{95.98,24.03},{95.99,24.46},{96.36,24.38},{96.6,24.38},{96.8,24.37},{95.95,22.93},{95.96,23.29},{95.96,23.69},{95.96,24.33},{96.1,24.35},{96.36,24.36},{96.79,24.38},{96.91,24.33},{96.96,23.94},{96.96,23.79},{96.96,23.17},{96.95,22.99},{96.83,22.67},{96.59,22.66},{96.34,22.66},{96.1,22.68},},[47]={{9.25,16.42},{9.26,16.13},{9.26,16.05},{9.26,15.54},{9.26,15.45},{9.17,15.18},{9.05,15.18},{8.82,15.18},{8.55,15.21},{8.51,15.43},{8.53,15.84},{8.54,16.17},{8.56,16.49},{8.82,16.43},{9.0,16.43},{9.14,16.43},{8.53,15.38},{8.53,15.64},{8.53,15.93},{8.54,16.4},{8.63,16.41},{8.83,16.42},{9.14,16.43},{9.22,16.39},{9.26,16.11},{9.26,16.0},{9.26,15.55},{9.26,15.42},{9.17,15.19},{8.99,15.18},{8.81,15.18},{8.64,15.19},},},28,nil,nil,21,nil,},
[1784] = {'Skeletal Sorcerer',2384,2466,51,52,0,{[28]={{35.74,56.2},{35.57,56.52},{39.28,54.91},{38.54,53.96},{37.52,54.08},{54.21,79.83},{54.14,79.4},{53.97,80.34},{36.95,57.12},{37.38,57.25},{36.22,57.38},{54.7,80.17},{53.92,79.92},{54.72,79.92},{53.95,79.97},{37.14,54.43},{54.78,79.75},{54.78,79.93},{53.91,80.92},{54.8,80.87},{54.62,79.89},{38.76,55.96},{37.36,56.33},{37.99,54.17},{37.57,59.56},{38.68,55.03},{38.52,57.47},{37.75,54.56},{36.59,54.31},},},{[28]={{53.96,80.3},{53.97,80.11},{53.98,79.88},{54.2,79.88},{54.32,79.89},{54.5,79.89},{54.57,79.9},{54.59,80.13},{54.59,80.2},{54.6,80.65},{54.6,80.73},{54.52,80.99},{54.36,80.98},{54.2,80.98},{53.92,80.96},{53.95,80.73},{53.97,80.49},},[36]={{95.97,23.31},{95.98,23.03},{96.0,22.67},{96.32,22.68},{96.51,22.68},{96.8,22.69},{96.89,22.71},{96.94,23.05},{96.94,23.17},{96.95,23.86},{96.95,23.98},{96.83,24.38},{96.57,24.37},{96.33,24.36},{95.9,24.33},{95.95,23.98},{95.97,23.6},},[47]={{8.54,15.65},{8.55,15.45},{8.56,15.19},{8.8,15.19},{8.93,15.2},{9.14,15.2},{9.21,15.22},{9.24,15.47},{9.24,15.55},{9.25,16.06},{9.25,16.14},{9.17,16.43},{8.98,16.42},{8.8,16.41},{8.49,16.4},{8.53,16.14},{8.54,15.87},},},28,nil,nil,21,nil,},
[1785] = {'Skeletal Terror',3082,3292,52,54,0,{[28]={{45.04,52.0},{48.1,51.2},{47.74,49.94},{47.25,50.09},{45.82,51.67},{45.89,50.53},{47.54,51.36},{47.11,50.51},{47.91,50.59},{46.55,51.53},{47.37,49.82},{46.11,49.47},{45.17,51.17},{47.67,51.06},{47.25,49.42},},},nil,28,nil,nil,21,nil,},
[1787] = {'Skeletal Executioner',3293,3398,53,55,0,{[28]={{45.75,67.23},{39.38,72.27},{44.48,68.65},{44.6,68.54},{44.52,68.87},{45.86,69.43},{45.88,69.13},{44.7,69.88},{44.54,69.82},{45.67,75.03},{50.4,67.93},{46.63,69.32},{48.8,69.07},{40.22,65.64},{46.65,70.95},{49.65,66.82},{48.76,70.24},{41.5,72.87},{38.72,68.27},{42.68,69.99},{43.95,62.37},{45.8,62.63},{48.64,69.65},{44.1,64.59},{43.17,63.59},{41.84,61.99},{45.74,72.48},{44.5,71.18},{47.26,69.12},{41.82,68.36},{39.69,67.57},{48.08,63.19},{48.01,69.26},{42.64,74.93},{41.12,69.22},{44.99,66.93},{38.85,71.15},{44.44,64.98},{48.05,71.25},{38.69,70.07},},},nil,28,nil,nil,21,nil,},
[1788] = {'Skeletal Warlord',8097,8352,56,57,1,{[28]={{45.12,68.75},{45.15,69.56},{43.83,63.07},{42.65,65.71},{46.72,71.66},{40.44,71.85},},},nil,28,nil,nil,21,nil,},
[1789] = {'Skeletal Acolyte',2823,2915,55,56,0,{[28]={{49.54,63.51},{39.87,67.93},{47.13,71.69},{45.94,69.28},{44.51,69.62},{42.61,71.34},{46.74,74.23},{43.46,64.5},{39.9,71.37},{48.99,64.84},{42.17,66.47},{48.76,63.44},{48.2,65.44},{43.4,74.87},{41.89,68.2},{41.74,73.18},{41.8,74.9},{47.16,61.19},{40.22,69.12},{46.21,71.8},{41.83,69.35},{47.24,72.48},{41.11,74.9},{44.65,72.59},{44.33,67.1},{43.77,63.74},{42.68,67.08},{41.82,64.57},{42.85,65.16},{47.37,63.47},{42.67,62.72},{49.51,68.09},{41.49,65.86},{45.91,70.31},{39.56,67.92},{49.54,65.78},{39.5,70.43},{46.82,66.39},{45.07,65.54},{44.34,65.73},{47.46,62.44},{42.6,69.21},{45.79,73.39},{45.68,61.02},{45.55,61.81},{44.27,74.91},{46.58,64.56},{48.05,66.78},},},{[28]={{43.77,63.78},{43.96,63.75},{44.12,63.67},{44.25,63.47},{44.37,63.25},{44.34,63.03},{44.21,62.65},{44.09,62.49},{43.93,62.38},{43.71,62.36},{43.6,62.45},{43.44,62.7},{43.41,62.94},{43.43,63.35},{43.59,63.65},{43.65,63.71},},[85]={{99.56,76.33},{99.73,76.29},{99.89,76.22},{99.98,75.25},{99.86,75.1},{99.71,74.99},{99.5,74.97},{99.4,75.06},{99.25,75.29},{99.22,75.52},{99.24,75.92},{99.39,76.19},{99.44,76.25},},},28,nil,nil,21,nil,},
[1791] = {'Slavering Ghoul',2880,3082,50,52,0,{[28]={{38.86,55.24},{37.08,56.19},{36.75,54.9},{50.35,80.48},{49.91,76.25},{50.28,76.87},{49.61,82.77},{50.06,77.68},{54.83,81.05},{53.79,80.45},{54.68,80.96},{38.92,57.32},{37.59,56.95},{38.47,55.65},{39.11,55.45},{38.49,54.61},{51.22,76.39},{49.54,76.04},{48.7,80.4},{50.27,74.97},{49.98,80.05},{48.44,80.05},{51.07,76.69},{49.79,77.61},{54.03,80.88},{54.09,80.17},{53.9,80.12},{38.16,54.56},{37.08,57.55},{37.13,54.1},{37.78,53.96},{48.8,79.49},{49.9,77.09},{50.36,80.05},{49.93,76.67},{50.92,75.65},{53.99,80.64},{37.61,59.15},{35.99,56.46},{48.87,80.16},{49.9,80.59},{49.89,78.04},{50.13,81.15},{36.95,53.97},{38.15,54.56},},},nil,28,nil,nil,21,nil,},
[1793] = {'Rotting Ghoul',3293,3398,54,55,0,{[28]={{54.61,66.07},{53.76,65.31},{53.96,65.81},{52.7,64.29},{53.15,64.63},{52.34,64.69},{54.12,67.05},{53.82,67.9},{51.94,65.44},{53.34,66.16},{51.98,66.73},{53.63,67.53},{52.75,67.9},{53.31,63.55},{54.28,64.8},},},nil,28,nil,nil,21,nil,},
[1794] = {'Soulless Ghoul',2634,2718,54,55,0,{[28]={{39.46,69.38},{37.97,68.0},{44.6,68.73},{45.07,68.19},{42.58,72.81},{40.81,72.38},{45.1,69.93},{44.92,74.96},{42.64,73.92},{41.87,71.3},{48.75,65.59},{43.28,61.14},{45.79,63.52},{37.92,70.55},{48.03,70.29},{48.05,68.05},{42.95,66.15},{46.58,63.44},{44.84,73.83},{40.39,70.26},{45.82,65.77},{38.69,69.38},{48.64,62.54},{39.56,66.81},{42.12,72.4},{50.26,65.82},{48.3,62.03},{42.58,67.91},{46.52,65.75},{44.51,63.45},{44.12,73.69},{44.12,68.28},{40.27,73.96},{40.12,72.49},{40.24,67.02},{43.49,73.95},{45.0,64.6},{49.61,69.07},{41.07,67.59},},},nil,28,nil,nil,21,nil,},
[1795] = {'Searing Ghoul',2823,2915,55,56,0,{[28]={{42.73,68.57},{46.37,74.81},{50.49,66.74},{45.39,68.82},{44.64,69.68},{38.71,66.88},{42.07,69.03},{46.22,73.28},{49.47,64.75},{47.89,64.52},{45.83,69.28},{41.01,70.57},{40.78,71.54},{46.49,62.1},{42.52,70.56},{46.74,72.33},{40.94,66.39},{46.05,68.25},{48.96,68.1},{42.93,72.07},{40.68,66.43},{43.37,72.48},{45.09,67.84},{44.89,62.02},{41.84,70.35},{47.38,67.95},{41.81,74.06},{48.82,65.15},{42.19,65.44},{41.47,69.86},{44.85,70.95},{47.27,64.5},{44.02,72.37},{45.78,61.87},{41.03,73.74},{40.6,68.35},{45.63,71.65},{43.42,62.97},{43.44,71.69},{47.44,70.42},},},nil,28,nil,nil,21,nil,},
[1796] = {'Freezing Ghoul',3529,3644,55,56,0,{[28]={{53.05,67.24},{52.63,66.89},{53.98,62.97},{53.34,67.98},{55.32,66.49},{53.23,65.18},{54.65,65.59},{53.41,67.05},{52.73,65.94},{52.95,63.73},{52.15,63.99},},},nil,28,nil,nil,21,nil,},
[1797] = {'Giant Grizzled Bear',296,328,12,13,0,{[130]={{36.68,21.51},{35.18,19.55},{39.02,13.54},{43.59,18.79},{35.44,17.23},{37.09,17.67},{44.39,17.03},{45.28,16.14},{39.71,14.91},{39.11,15.94},{37.36,17.23},{37.68,16.62},{37.91,15.55},{39.85,16.48},{47.02,18.07},{34.46,15.27},{45.97,18.26},{42.51,19.49},{41.6,17.99},{42.48,18.14},{42.09,21.73},{41.16,18.24},{50.93,67.88},{55.61,51.68},{56.1,67.09},{54.68,69.48},{55.37,65.03},{55.54,70.98},{52.47,61.27},{52.92,51.77},{54.24,56.22},{51.54,53.92},{53.16,53.98},{51.6,59.05},{52.88,67.06},{51.34,55.28},{51.77,58.12},{51.47,52.82},{49.38,70.31},{51.57,62.48},{50.53,67.2},{51.62,66.73},{50.18,69.37},{53.44,64.98},{53.1,60.59},},},nil,130,nil,nil,44,nil,},
[1800] = {'Cold Wraith',9302,9302,58,58,1,nil,nil,0,nil,nil,21,nil,},
[1801] = {'Blood Wraith',8522,8522,55,55,1,nil,nil,0,nil,nil,67,nil,},
[1802] = {'Hungering Wraith',3644,3876,56,58,0,{[28]={{62.49,60.25},{63.55,55.87},{60.68,58.28},{64.85,59.37},{64.38,59.19},{64.04,57.58},{62.69,58.03},{63.45,57.75},{65.14,59.07},{64.36,57.47},{64.4,58.61},{63.88,55.71},{62.2,60.19},{64.71,59.04},{64.67,57.69},{62.38,58.9},{62.24,59.61},{62.76,57.03},{61.84,59.12},{64.71,59.19},{64.22,55.88},},},nil,28,nil,nil,21,nil,},
[1804] = {'Wailing Death',3643,3758,56,57,0,{[28]={{64.05,56.25},{62.42,60.86},{64.31,57.91},{64.84,59.98},{63.42,56.62},{62.47,57.9},{63.0,60.59},{63.1,59.69},{61.76,57.72},{63.31,60.82},{65.1,59.65},{61.68,58.24},{62.77,60.12},{64.37,56.68},{64.58,57.34},{64.77,58.55},{60.79,57.91},{63.26,56.01},{64.6,59.39},{62.97,55.83},{64.66,59.22},},},nil,28,nil,nil,21,nil,},
[1805] = {'Flesh Golem',8097,8352,56,57,1,{[28]={{47.58,69.3},{41.78,68.47},},},{[28]={{47.61,69.2},{47.6,68.99},{47.6,68.7},{47.7,68.52},{47.83,68.35},{48.03,68.31},{48.24,68.33},{48.36,68.55},{48.29,68.37},{48.35,68.18},{48.49,68.0},{48.39,68.13},{48.24,68.33},{48.05,68.26},{47.87,68.28},{47.75,68.41},{47.63,68.6},{47.59,68.8},{47.59,69.04},{47.57,69.3},{47.5,69.46},{47.37,69.53},{47.21,69.63},{47.02,69.77},{47.08,69.97},{47.18,70.14},{47.31,70.31},{47.47,70.53},{47.61,70.8},{47.71,70.97},{47.86,71.07},{48.01,71.24},{48.11,71.37},{48.34,71.69},{48.17,71.41},{47.94,71.14},{47.76,71.05},{47.62,70.82},{47.51,70.56},{47.3,70.29},{47.03,70.05},{46.91,69.64},{46.73,69.53},{46.47,69.68},{46.48,70.3},{46.49,69.61},{46.3,69.21},{46.48,69.05},{46.68,68.83},{46.74,68.48},{46.74,68.11},{46.68,67.73},{46.6,67.43},{46.43,67.15},{46.24,66.87},{46.09,66.65},{45.96,66.27},{46.12,66.09},{45.96,66.23},{45.98,66.48},{46.09,66.66},{46.24,66.89},{46.41,67.17},{46.61,67.49},{46.68,67.72},{46.71,68.05},{46.73,68.38},{46.71,68.69},{46.55,68.93},{46.36,69.23},{46.48,69.54},{46.67,69.52},{46.86,69.57},{47.13,69.61},{47.35,69.61},{47.51,69.5},{41.74,68.47},{41.87,68.31},{42.01,68.14},{42.06,68.07},{42.01,67.81},{41.95,67.58},{41.89,67.41},{41.8,67.2},{41.66,66.98},{41.82,67.08},{41.87,67.24},{41.93,67.49},{42.0,67.79},{42.09,68.11},{42.3,68.06},{42.52,67.9},{42.73,67.76},{42.97,67.63},{43.17,67.64},{43.37,67.66},{43.53,67.52},{43.68,67.24},{43.71,66.91},{43.72,66.57},{43.73,66.25},{43.73,65.88},{43.72,65.62},{43.66,65.23},{43.59,64.93},{43.47,64.57},{43.28,64.02},{43.41,64.27},{43.5,64.62},{43.59,65.03},{43.66,65.47},{43.67,65.96},{43.68,66.51},{43.68,66.98},{43.73,67.29},{43.5,67.44},{43.36,67.66},{43.16,67.62},{42.9,67.64},{42.69,67.73},{42.41,67.97},{42.06,68.21},},[36]={{86.21,6.28},{86.19,5.96},{86.19,5.5},{86.36,5.23},{86.55,4.96},{86.85,4.91},{87.18,4.93},{87.36,5.27},{87.26,5.0},{87.34,4.71},{87.55,4.43},{87.4,4.63},{87.17,4.93},{86.89,4.82},{86.61,4.86},{86.43,5.06},{86.25,5.36},{86.19,5.66},{86.18,6.02},{86.15,6.42},{86.04,6.67},{85.84,6.78},{85.59,6.94},{85.3,7.14},{85.39,7.46},{85.55,7.72},{85.76,7.98},{86.0,8.32},{86.22,8.72},{86.36,8.98},{86.6,9.15},{86.82,9.4},{86.98,9.61},{87.33,10.1},{87.08,9.67},{86.71,9.26},{86.44,9.11},{86.22,8.76},{86.06,8.36},{85.74,7.95},{85.33,7.58},{85.13,6.95},{84.86,6.79},{84.46,7.0},{84.48,7.96},{84.49,6.9},{84.2,6.28},{84.48,6.05},{84.78,5.7},{84.88,5.16},{84.87,4.61},{84.78,4.02},{84.65,3.56},{84.39,3.13},{84.1,2.69},{83.87,2.35},{83.67,1.77},{83.92,1.5},{83.68,1.71},{83.7,2.1},{83.88,2.36},{84.11,2.72},{84.37,3.15},{84.68,3.65},{84.79,3.99},{84.83,4.51},{84.85,5.01},{84.83,5.49},{84.58,5.85},{84.3,6.33},{84.48,6.79},{84.77,6.77},{85.06,6.85},{85.47,6.91},{85.81,6.9},{86.06,6.73},{77.2,5.15},{77.39,4.91},{77.61,4.65},{77.69,4.54},{77.62,4.14},{77.51,3.79},{77.43,3.52},{77.29,3.2},{77.07,2.86},{77.32,3.01},{77.39,3.26},{77.48,3.64},{77.6,4.11},{77.73,4.59},{78.05,4.52},{78.4,4.28},{78.71,4.06},{79.09,3.85},{79.39,3.88},{79.7,3.91},{79.94,3.69},{80.18,3.27},{80.22,2.75},{80.24,2.24},{80.25,1.74},{80.25,1.18},{80.24,0.78},{80.15,0.18},{80.15,0.55},{80.16,1.3},{80.17,2.14},{80.18,2.86},{80.25,3.33},{79.89,3.57},{79.68,3.9},{79.38,3.85},{78.98,3.87},{78.65,4.01},{78.23,4.38},{77.68,4.76},},[47]={{1.44,3.27},{1.43,3.03},{1.43,2.7},{1.55,2.51},{1.69,2.31},{1.91,2.27},{2.15,2.29},{2.28,2.53},{2.2,2.34},{2.27,2.12},{2.42,1.92},{2.31,2.07},{2.14,2.29},{1.94,2.21},{1.74,2.24},{1.6,2.38},{1.47,2.6},{1.43,2.82},{1.42,3.08},{1.4,3.37},{1.32,3.55},{1.17,3.63},{0.99,3.75},{0.78,3.9},{0.85,4.12},{0.96,4.32},{1.11,4.5},{1.29,4.75},{1.45,5.04},{1.55,5.24},{1.73,5.36},{1.89,5.54},{2.01,5.69},{2.26,6.04},{2.07,5.73},{1.81,5.43},{1.61,5.33},{1.45,5.07},{1.33,4.78},{1.1,4.48},{0.8,4.21},{0.66,3.75},{0.46,3.64},{0.17,3.79},{0.18,4.49},{0.19,3.72},{0.18,3.1},{0.41,2.85},{0.48,2.46},{0.47,2.05},{0.4,1.63},{0.31,1.29},{0.12,0.98},{0.1,0.99},{0.33,1.36},{0.41,1.61},{0.44,1.98},{0.46,2.34},{0.44,2.69},{0.26,2.96},{0.05,3.3},{0.18,3.64},{0.39,3.62},{0.6,3.68},{0.9,3.72},{1.15,3.72},{1.33,3.6},},[85]={{97.63,80.79},{97.75,80.63},{97.88,80.47},{97.93,80.41},{97.89,80.16},{97.82,79.94},{97.77,79.77},{97.68,79.58},{97.55,79.36},{97.7,79.46},{97.75,79.62},{97.8,79.85},{97.88,80.14},{97.96,80.44},{98.15,80.4},{98.37,80.24},{98.57,80.11},{98.8,79.98},{98.99,80.0},{99.18,80.01},{99.33,79.88},{99.48,79.62},{99.5,79.3},{99.51,78.98},{99.52,78.67},{99.52,78.32},{99.51,78.08},{99.46,77.7},{99.38,77.41},{99.27,77.07},{99.09,76.55},{99.21,76.79},{99.3,77.12},{99.39,77.51},{99.46,77.93},{99.46,78.4},{99.47,78.92},{99.47,79.37},{99.52,79.66},{99.3,79.81},{99.17,80.01},{98.98,79.98},{98.73,79.99},{98.53,80.08},{98.26,80.31},{97.93,80.54},},},28,nil,nil,21,nil,},
[1806] = {'Vile Slime',3293,3398,54,55,0,{[28]={{63.19,37.53},{66.06,42.18},{65.36,39.59},{65.93,40.3},{64.9,38.73},{65.03,41.25},{63.54,36.34},{66.64,41.04},{63.82,37.82},{63.55,37.18},{65.78,38.01},{64.31,38.36},},},nil,28,nil,nil,14,nil,},
[1808] = {'Devouring Ooze',3529,3644,55,56,0,{[28]={{63.85,35.87},{61.95,34.93},{63.39,35.78},{62.46,35.92},{64.46,33.4},{64.6,34.18},{61.31,34.95},{63.89,36.04},{61.47,36.72},{61.8,37.42},},},{[28]={{61.49,36.79},{61.52,36.97},{61.6,37.09},{61.8,37.3},{61.61,37.08},{61.54,36.79},{61.71,36.66},{61.89,36.54},{62.12,36.44},{62.33,36.32},{62.21,36.14},{62.02,36.17},{61.76,36.09},{61.5,36.01},{61.38,35.76},{61.18,35.86},{61.1,36.33},{61.25,36.46},{61.82,37.45},{61.94,37.5},{62.1,37.51},{62.31,37.53},{62.48,37.54},{62.58,37.54},{62.75,37.53},{62.96,37.53},{62.82,37.55},{62.63,37.53},{62.16,37.47},},[139]={{1.08,57.65},{1.12,57.84},{1.2,57.98},{1.43,58.22},{1.21,57.97},{1.14,57.64},{1.33,57.5},{1.53,57.37},{1.79,57.26},{2.02,57.13},{1.89,56.92},{1.68,56.96},{1.38,56.87},{1.1,56.78},{0.96,56.5},{0.74,56.61},{0.65,57.14},{0.81,57.28},{1.45,58.37},{1.58,58.43},{1.76,58.45},{1.99,58.47},{2.19,58.48},{2.29,58.48},{2.49,58.47},{2.72,58.46},{2.56,58.49},{2.35,58.47},{1.83,58.4},},},28,nil,nil,14,nil,},
[1809] = {'Carrion Vulture',2880,3082,50,52,0,{[28]={{29.89,54.68},{32.26,62.39},},},nil,28,nil,nil,73,nil,},
[1812] = {'Rotting Behemoth',3529,3644,55,56,0,{[28]={{64.03,34.38},{61.77,35.52},{64.49,36.66},{66.56,39.09},{63.59,32.55},{61.45,36.88},{61.2,35.64},{61.99,33.21},{63.81,33.18},{62.11,37.56},{62.34,32.35},{62.51,34.97},{62.4,35.45},{61.2,36.24},{62.48,37.52},},},nil,28,nil,nil,14,nil,},
[1813] = {'Decaying Horror',3601,3765,56,57,0,{[28]={{61.98,33.84},{61.63,36.21},},},nil,28,nil,nil,14,nil,},
[1815] = {'Diseased Black Bear',3438,3556,51,52,0,{[28]={{37.24,62.33},{37.92,65.52},{36.46,63.59},{32.67,55.22},{34.22,62.1},{36.35,65.62},{37.07,66.92},{31.86,61.68},{31.81,56.64},{33.91,52.76},{37.92,63.22},{29.33,61.59},{36.33,67.98},{33.43,56.21},{34.78,54.2},{31.28,60.13},{30.18,54.44},{28.68,58.91},{31.66,54.08},{33.43,65.75},{38.97,62.34},{33.43,63.6},{31.04,55.18},{34.87,63.52},{34.82,58.78},{39.37,62.69},{32.64,57.55},},},nil,28,nil,nil,44,nil,},
[1816] = {'Diseased Grizzly',3921,4048,55,56,0,{[28]={{67.55,46.1},{66.25,47.78},{55.8,63.56},{65.72,53.62},{68.11,48.47},{55.8,58.59},{57.85,52.95},{52.86,49.52},{58.05,60.12},{60.47,51.95},{56.73,62.08},{60.44,54.11},{54.96,45.82},{65.5,55.13},{66.57,56.44},{63.73,49.75},{57.14,51.0},{66.68,47.79},{54.39,51.88},{61.88,47.03},{52.24,54.3},{57.12,53.45},{66.74,53.38},{64.45,47.71},{59.01,51.61},{61.89,51.83},{62.86,49.89},{67.44,55.32},{65.02,53.03},{57.71,58.44},{58.16,62.14},{64.39,47.01},{56.59,50.71},{53.4,60.05},{52.53,58.41},{58.99,61.01},{60.53,49.43},{55.37,53.0},{55.16,64.54},{65.3,50.29},{65.87,44.02},{53.41,48.3},{60.17,50.52},},},nil,28,nil,nil,44,nil,},
[1817] = {'Diseased Wolf',3189,3293,53,54,0,{[28]={{52.53,70.45},{44.95,40.28},{51.14,53.08},{43.46,55.16},{48.03,47.27},{45.79,46.0},{47.42,43.73},{51.84,46.96},{44.97,32.12},{42.59,56.29},{45.68,43.87},{44.39,45.87},{45.88,36.71},{44.78,47.03},{49.38,59.55},{47.36,39.04},{45.7,48.29},{47.28,28.28},{42.53,54.11},{43.5,40.18},{49.65,37.78},{48.12,27.24},{47.25,48.33},{46.58,29.67},{50.33,46.94},{49.64,27.25},{48.76,26.11},{50.34,34.49},{46.6,40.22},{44.88,49.51},{39.64,48.46},{51.95,61.01},},},nil,28,nil,nil,38,nil,},
[1821] = {'Carrion Lurker',3082,3189,52,53,0,{[28]={{46.41,59.88},{48.95,36.7},{51.09,64.35},{44.95,59.83},{51.51,60.52},{46.47,42.65},{47.23,46.01},{48.58,60.24},{43.14,46.77},{44.91,42.5},{48.78,39.0},{44.95,37.63},{49.81,35.61},{51.23,50.64},{51.02,32.93},{46.62,37.81},{48.57,58.47},{41.13,48.4},{44.82,44.78},{48.92,28.33},{46.57,47.1},{47.35,41.27},{48.05,40.12},{50.31,63.45},{48.89,61.92},{50.38,36.44},{52.03,34.21},{51.18,30.95},{46.52,44.91},{44.14,56.51},{45.74,41.42},},},nil,28,nil,nil,22,nil,},
[1822] = {'Venom Mist Lurker',2880,2980,50,51,0,{[28]={{33.42,61.43},{35.77,62.25},{33.19,54.07},{37.93,61.3},{35.55,66.85},{29.99,60.96},{28.94,56.0},{37.14,64.7},{32.43,62.26},{34.24,64.47},{39.88,62.07},{34.24,66.77},{38.64,64.49},{35.56,64.65},{33.43,59.0},{32.57,64.64},{32.14,63.51},{29.13,59.24},{31.14,62.42},{34.28,57.56},{29.78,56.68},{34.05,55.36},},},nil,28,nil,nil,22,nil,},
[1824] = {'Plague Lurker',3293,3398,54,55,0,{[28]={{67.2,48.19},{63.3,46.42},{54.98,50.7},{60.85,51.04},{53.37,50.55},{55.65,54.0},{59.11,59.56},{52.68,51.68},{54.93,62.23},{62.21,48.48},{58.88,53.91},{58.82,50.54},{63.55,45.17},{56.56,59.99},{55.99,53.44},{62.71,50.32},{65.12,46.43},{60.79,53.54},{55.81,49.58},{66.8,49.94},{54.27,47.12},{54.33,49.41},{56.04,51.39},{55.93,60.97},{64.38,49.72},{65.97,57.43},{54.16,61.15},{53.36,62.03},{56.63,57.52},{66.41,54.55},{66.11,45.81},{68.05,45.53},},},nil,28,nil,nil,312,nil,},
[1826] = {'Scarlet Mage',2470,2550,55,56,0,{[28]={{57.57,35.65},{51.3,40.48},{52.83,36.65},{51.03,40.21},{52.77,37.56},{53.6,37.67},{57.41,36.09},},},nil,28,nil,nil,67,nil,},
[1827] = {'Scarlet Sentinel',7842,8097,55,56,1,{[28]={{46.91,20.42},{42.15,13.8},{43.54,19.86},{43.17,16.28},{47.16,15.92},{42.03,13.7},{42.19,15.91},{48.94,21.38},{42.11,15.85},{48.23,20.46},{48.37,21.58},{41.57,15.54},{43.12,16.5},{42.72,14.34},{47.35,21.89},{48.09,22.03},{48.01,22.75},{47.68,14.9},{44.99,16.4},{41.89,14.92},{41.98,14.87},{47.11,20.07},{41.43,15.43},{42.65,14.29},},},nil,28,nil,nil,67,nil,},
[1831] = {'Scarlet Hunter',3082,3188,52,53,0,{[28]={{41.01,52.43},{40.73,52.62},{38.64,55.97},{47.33,51.38},{40.69,52.18},{51.45,44.14},{51.7,44.03},{51.63,44.53},{52.24,44.6},{52.2,43.96},{43.67,67.8},},},nil,28,nil,nil,89,nil,},
[1832] = {'Scarlet Magus',5667,5847,56,57,1,{[28]={{44.99,15.71},{45.21,15.4},{46.34,13.78},{46.62,14.08},{46.82,13.1},{45.02,15.55},{45.16,15.31},{47.31,13.81},{44.84,15.25},},},nil,28,nil,nil,67,nil,},
[1833] = {'Scarlet Knight',3293,3398,54,55,0,{[28]={{50.43,41.06},{53.26,37.43},{49.61,33.19},{45.77,34.44},{48.77,34.46},{50.33,40.45},{50.72,41.26},{49.83,41.61},{53.18,36.97},{50.76,40.47},{57.7,36.41},{50.23,42.22},{47.05,34.4},{47.35,31.89},{53.19,36.28},},},{[28]={{53.27,37.49},{53.13,37.72},{52.99,37.94},{52.83,38.19},{52.64,38.45},{52.43,38.73},{52.57,38.47},{52.75,38.23},{52.98,37.93},{53.17,37.64},{53.31,37.37},{53.42,37.11},{53.58,36.75},{53.76,36.41},{53.87,36.21},{53.73,36.54},{53.59,36.81},{53.47,37.08},{53.35,37.33},{49.58,33.14},{49.52,33.04},{49.33,32.7},{49.25,32.56},{49.1,32.3},{48.98,32.62},{48.86,33.06},{48.74,33.46},{48.68,33.88},{48.8,34.22},{49.13,34.39},{49.36,34.55},{49.65,34.74},{49.85,34.78},{50.05,34.59},{50.11,34.23},{50.01,33.91},{49.88,33.57},{49.65,33.42},},},28,nil,nil,67,nil,},
[1834] = {'Scarlet Paladin',6273,6477,55,56,1,{[28]={{42.5,16.06},{42.7,18.21},{46.07,19.09},{43.26,20.69},{43.01,18.36},{46.16,18.2},{46.93,13.59},{43.16,19.63},{47.0,13.89},{43.01,16.36},{42.75,13.42},{43.47,13.24},{46.55,13.68},{45.38,17.94},{45.23,18.27},{42.61,17.65},{44.86,16.16},{43.56,13.75},{46.64,13.74},{42.84,16.1},{42.69,18.57},{42.77,16.34},{45.37,18.97},{46.57,13.47},{42.99,16.14},{42.53,18.2},{42.43,19.14},{47.09,13.53},{41.56,15.35},{42.06,13.94},{43.49,13.56},{44.89,16.37},{43.37,13.44},{42.92,14.56},{43.49,13.89},{46.81,14.06},{42.6,19.02},},},{[28]={{46.54,13.72},{46.55,13.88},{46.56,13.98},{46.63,14.1},{46.68,14.17},{46.77,14.23},{46.89,14.24},{46.99,14.12},{46.94,14.04},{46.89,13.95},{46.79,13.79},{46.82,13.72},{46.87,13.66},{46.98,13.5},{46.99,13.45},{46.95,13.39},{46.86,13.32},{46.79,13.35},{46.71,13.38},{46.61,13.48},{46.58,13.61},{46.56,13.49},{46.53,13.67},{46.51,13.9},{46.56,14.04},{46.68,14.23},{46.81,14.27},{46.98,14.2},{47.12,14.0},{47.16,13.81},{47.11,13.53},{46.98,13.36},{46.82,13.31},{46.7,13.26},{46.64,13.36},},},28,nil,nil,67,nil,},
[1835] = {'Scarlet Invoker',2551,2634,53,54,0,{[28]={{40.42,52.57},{38.65,55.99},{47.36,51.33},{40.34,51.74},{51.86,43.75},{52.17,44.2},{43.67,67.8},{40.87,51.47},},},nil,28,nil,nil,89,nil,},
[1836] = {'Scarlet Cavalier',8097,8613,56,58,1,{[28]={{41.67,15.43},{41.88,14.96},{42.01,14.47},{41.91,15.41},{42.15,15.01},{42.22,14.83},},},{[28]={{41.9,15.45},{41.96,15.24},{42.04,15.02},{42.09,14.88},{42.17,14.65},{42.08,14.57},{41.94,14.46},{41.85,14.39},{41.81,14.49},{41.77,14.66},{41.73,14.83},{41.82,14.84},{41.75,14.8},{41.78,14.65},{41.84,14.5},{41.87,14.39},{41.94,14.48},{42.07,14.58},{42.18,14.68},{42.26,14.35},{42.2,14.55},{42.1,14.83},{42.02,15.08},},[85]={{97.77,30.33},{97.84,30.13},{97.91,29.92},{97.96,29.79},{98.03,29.57},{97.95,29.5},{97.82,29.39},{97.73,29.32},{97.69,29.42},{97.65,29.58},{97.62,29.74},{97.7,29.76},{97.64,29.71},{97.67,29.57},{97.72,29.43},{97.75,29.33},{97.82,29.41},{97.94,29.51},{98.05,29.6},{98.13,29.29},{98.06,29.47},{97.97,29.74},{97.89,29.98},},},28,nil,nil,67,nil,},
[1837] = {'Scarlet Judge',7326,7326,60,60,2,{[28]={{42.21,18.5},},},nil,28,nil,nil,16,nil,},
[1838] = {'Scarlet Interrogator',9432,9432,61,61,2,{[28]={{45.15,15.27},},},nil,28,nil,nil,16,nil,},
[1839] = {'Scarlet High Clerist',7995,7995,63,63,2,{[28]={{56.94,34.81},{44.5,19.3},{42.34,18.9},},[85]={{98.2,33.61},},},{[28]={{44.83,19.74},{44.48,19.28},{44.07,18.75},{43.68,18.2},{43.28,17.63},{43.91,18.55},{44.39,19.14},{44.83,19.78},{44.72,20.02},{44.41,20.04},{44.03,19.91},{44.29,20.0},{44.75,20.04},},[85]={{99.84,33.48},{99.47,32.95},{99.09,32.41},{99.69,33.28},{99.81,34.58},},},28,nil,nil,16,nil,},
[1840] = {'Grand Inquisitor Isillien',66625,66625,63,63,1,nil,nil,0,nil,nil,14,nil,},
[1841] = {'Scarlet Executioner',9156,9156,60,60,1,{[28]={{45.71,18.78},},},nil,28,nil,nil,67,nil,},
[1842] = {'Highlord Taelan Fordring',26650,26650,63,63,1,{[28]={{42.02,14.79},},},nil,28,{5944,},{5862,},67,nil,},
[1843] = {'Foreman Jerris',9711,9711,62,62,2,{[28]={{45.56,9.21},},},nil,28,nil,nil,16,nil,},
[1844] = {'Foreman Marcrid',3876,3876,58,58,4,{[28]={{49.04,32.73},},},nil,28,nil,nil,14,nil,},
[1845] = {'High Protector Tarsen',3198,3198,59,59,0,{[28]={{48.79,33.59},},},{[28]={{48.83,33.71},{48.67,33.75},{48.46,33.61},{48.19,33.44},{48.03,33.17},{47.81,32.96},{47.6,32.76},{47.33,32.65},{47.09,32.68},{46.84,32.71},{46.58,32.82},{46.31,32.97},{46.09,33.22},{45.95,33.52},{45.93,33.99},{45.96,34.33},{46.02,34.79},{46.17,35.11},{46.43,35.19},{46.76,35.35},{47.04,35.39},{47.22,35.36},{47.51,35.37},{47.75,35.52},{47.91,35.78},{48.11,35.99},{48.33,36.25},{48.55,36.37},{48.84,36.49},{49.0,36.22},{49.15,35.71},{49.23,35.43},{49.32,34.86},{49.16,34.5},{48.96,34.42},{48.89,34.07},},},28,nil,nil,67,nil,},
[1846] = {'High Protector Lorik',7545,7545,61,61,1,{[28]={{44.93,17.76},},},{[28]={{44.91,17.72},{44.77,17.62},{44.56,17.51},{44.43,17.79},{44.3,18.09},{44.27,18.41},{44.34,18.98},{44.14,18.9},{43.98,18.7},{43.86,18.48},{43.69,18.23},{43.55,18.02},{43.39,17.78},{43.31,17.51},{43.28,17.21},{43.31,16.87},{43.34,16.51},{43.38,16.25},{43.41,15.99},{43.31,15.78},{43.17,15.68},{43.28,15.78},{43.47,15.98},{43.61,15.92},{43.79,15.84},{44.05,15.73},{44.22,16.0},{44.39,16.24},{44.57,16.43},{44.6,16.74},{44.59,17.06},{44.6,17.37},{44.74,17.55},{45.01,17.8},{45.14,17.93},{45.28,18.07},{45.42,18.22},{45.29,18.07},{45.02,17.76},},[85]={{99.91,33.61},{99.76,33.42},{99.65,33.21},{99.48,32.97},{99.35,32.78},{99.19,32.55},{99.12,32.3},{99.09,32.0},{99.12,31.68},{99.15,31.34},{99.19,31.09},{99.22,30.85},{99.12,30.65},{98.99,30.55},{99.09,30.64},{99.27,30.84},{99.41,30.78},{99.57,30.7},{99.82,30.6},{99.99,30.86},},},28,nil,nil,67,nil,},
[1847] = {'Foulmane',3082,3082,52,52,4,{[28]={{46.27,52.43},},},nil,28,nil,nil,21,nil,},
[1848] = {'Lord Maldazzar',2915,2915,56,56,4,{[28]={{54.16,80.43},},},nil,28,nil,nil,16,nil,},
[1849] = {'Dreadwhisper',3876,3876,58,58,4,nil,nil,0,nil,nil,21,nil,},
[1850] = {'Putridius',3589,3589,58,58,2,{[28]={{48.05,67.39},},},nil,28,nil,nil,14,nil,},
[1851] = {'The Husk',4370,4370,62,62,4,{[28]={{62.15,36.31},},},nil,28,nil,nil,91,nil,},
[1852] = {'Araj the Summoner',8300,8300,61,61,1,{[28]={{45.27,69.21},},},nil,28,nil,nil,21,nil,},
[1853] = {'Darkmaster Gandling',50300,50300,61,61,1,nil,nil,0,nil,nil,14,nil,},
[1854] = {'High Priest Thel\'danis',4352,4352,62,62,0,{[28]={{52.05,83.27},},},{[28]={{52.01,83.34},{51.92,83.52},{51.91,83.76},{52.01,83.94},{52.15,84.04},{52.29,83.95},{52.4,83.76},{52.4,83.52},{52.31,83.34},{52.16,83.31},{52.03,83.36},},[36]={{92.97,27.99},{92.83,28.26},{92.82,28.62},{92.97,28.91},{93.18,29.05},{93.4,28.92},{93.57,28.63},{93.56,28.27},{93.43,27.98},{93.19,27.93},{93.01,28.02},},[47]={{6.36,19.06},{6.25,19.25},{6.25,19.52},{6.36,19.72},{6.51,19.83},{6.67,19.73},{6.8,19.52},{6.79,19.26},{6.69,19.05},{6.52,19.02},{6.38,19.08},},},28,{8416,},{8414,},12,"A",},
[1855] = {'Tirion Fordring',9563,9563,61,61,1,{[139]={{7.57,43.7},},},nil,139,{5542,5543,5544,5742,5781,5845,5846,5861,},{5542,5543,5544,5742,5781,5845,5848,5944,},250,"AH",},
[1860] = {'Voidwalker',490,490,17,17,0,nil,nil,0,nil,nil,14,nil,},
[1863] = {'Succubus',303,303,20,20,0,nil,nil,0,nil,nil,14,nil,},
[1865] = {'Ravenclaw Raider',247,273,12,13,0,{[130]={{46.68,54.2},{46.22,54.13},{46.04,54.15},{47.48,55.83},{45.59,56.39},{45.83,55.04},{46.14,55.66},{46.93,55.54},{46.56,53.23},{47.53,54.58},{47.98,52.91},},},{[130]={{46.62,54.14},{46.72,54.46},{46.93,54.52},{47.12,54.56},{47.28,54.57},{47.36,54.33},{47.43,54.08},{47.53,53.79},{47.62,53.53},{47.69,53.31},{47.79,52.98},{47.63,52.81},{47.49,52.67},{47.28,52.46},{47.18,52.59},{46.98,52.91},{46.95,53.25},{46.91,53.48},{46.75,53.52},{46.57,53.61},{46.52,53.98},},},130,nil,nil,21,nil,},
[1866] = {'Ravenclaw Slave',222,247,11,12,0,{[130]={{46.24,54.63},{45.68,54.45},{45.83,54.42},{46.96,54.1},{53.02,16.19},{52.91,15.3},{53.41,14.99},{53.99,15.44},{52.22,14.49},{53.7,14.67},{47.15,53.61},{46.95,52.97},{53.0,14.14},{52.32,13.55},{51.68,13.7},{51.73,14.08},{52.04,13.92},{51.94,13.71},{52.06,15.23},{47.46,54.18},{53.65,14.04},{52.72,14.58},{48.06,51.27},{47.64,53.0},{48.02,52.6},{48.24,50.19},},},nil,130,nil,nil,21,nil,},
[1867] = {'Dalaran Apprentice',241,263,13,14,0,{[130]={{51.77,65.83},{52.16,66.4},{51.58,64.26},{56.69,65.85},{56.44,62.84},{49.31,67.14},{50.9,63.45},{50.57,60.92},{55.19,62.89},{49.47,69.09},{51.45,69.28},{50.29,69.8},{52.57,70.87},{53.12,68.72},{51.42,71.04},{53.15,70.43},{52.52,68.14},{53.01,65.69},{50.58,61.6},{51.98,57.9},{52.33,56.73},{50.91,59.56},{50.25,58.7},{50.21,59.78},{49.97,59.75},{50.16,60.28},{49.82,60.24},{52.4,63.79},{49.54,60.75},{53.11,62.86},{55.57,68.36},{49.37,69.54},{51.51,61.5},{50.59,66.34},{54.65,67.45},},},{[130]={{51.92,57.86},{51.7,57.75},{51.36,57.75},{51.02,57.91},{50.7,58.24},{50.62,58.77},{50.79,59.29},{51.14,59.48},{51.5,59.43},{51.92,59.27},{52.17,58.78},{52.09,58.3},},},130,nil,nil,76,"AH",},
[1868] = {'Ravenclaw Servant',253,276,13,14,0,{[130]={{55.05,35.58},{53.11,35.97},{52.47,35.83},{52.93,34.09},{52.46,34.99},{51.68,34.11},{53.92,32.65},{52.52,30.62},{52.4,32.9},},},nil,130,nil,nil,21,nil,},
[1869] = {'Ravenclaw Champion',300,328,14,15,0,{[130]={{56.59,32.14},{57.27,32.59},{56.1,33.26},{55.54,31.88},{53.09,31.73},{54.07,35.56},{54.84,32.43},{53.72,33.7},},},nil,130,nil,nil,21,nil,},
[1870] = {'Hand of Ravenclaw',300,313,15,16,0,{[130]={{58.55,36.48},{56.64,34.65},{57.75,34.91},{56.99,33.88},{56.13,35.21},},},nil,130,nil,nil,21,nil,},
[1871] = {'Eliza\'s Guard',896,950,28,29,0,nil,nil,0,nil,nil,14,nil,},
[1872] = {'Tharek Blackstone',500,500,12,12,0,{[1]={{46.02,51.68},},},nil,1,{400,415,},nil,55,"A",},
[1880] = {'Berte',64,64,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[1883] = {'Scarlet Worker',3529,3758,55,57,0,{[28]={{46.12,12.36},{45.45,12.65},{45.77,10.84},{45.82,11.65},{45.96,16.16},{45.67,10.61},{45.92,17.26},{45.55,8.87},{45.51,12.7},{45.29,9.37},{45.86,10.97},{45.62,16.27},{43.63,17.19},{45.65,9.73},{45.31,9.28},{44.05,16.98},{44.88,12.04},{45.87,17.2},{45.5,9.51},{45.6,10.77},{44.13,17.36},{44.87,12.84},{45.91,16.58},{44.2,13.53},{43.87,17.32},{44.9,13.84},{44.49,12.57},{46.11,16.96},{46.04,12.38},{44.05,17.77},{43.88,16.76},{45.66,9.45},{44.91,11.97},{44.93,12.76},{45.62,16.39},{46.18,16.97},{45.7,9.72},{44.44,13.38},{46.02,16.18},{46.2,17.47},{45.35,9.97},{45.28,10.54},{45.16,9.95},{46.38,16.55},{44.42,12.56},{44.44,13.65},{44.91,12.72},{45.19,10.44},{45.23,10.3},{45.87,11.11},{45.68,16.65},{46.11,12.42},{45.52,8.76},{45.03,13.97},{45.79,15.96},{44.28,13.4},},},nil,28,nil,nil,67,nil,},
[1884] = {'Scarlet Lumberjack',3420,3644,54,56,0,{[28]={{46.53,32.18},{44.6,33.4},{47.66,32.57},{47.59,30.84},{44.11,33.93},{48.5,32.0},{46.27,33.44},{44.22,35.39},{45.28,35.02},{49.41,31.36},{48.27,31.8},{48.59,33.04},{45.09,34.18},{44.31,34.25},{45.03,34.29},{46.58,33.49},{44.84,33.84},{45.4,33.21},{48.23,32.2},{46.34,35.49},{49.39,34.27},{44.37,34.36},{44.83,33.73},{48.52,35.78},{47.99,32.97},},},nil,28,nil,nil,67,nil,},
[1885] = {'Scarlet Smith',8883,8883,59,59,2,{[28]={{44.36,13.54},},},nil,28,nil,nil,14,nil,},
[1888] = {'Dalaran Watcher',354,379,18,19,0,{[130]={{64.66,61.87},{64.6,63.65},{63.75,57.07},{63.45,58.24},{63.34,59.33},{64.45,57.95},{66.3,59.08},{65.17,56.32},{65.11,58.78},{63.02,60.96},{64.17,59.56},{65.78,57.68},{63.88,57.3},{64.42,56.36},{62.66,75.43},{62.88,76.46},{58.9,80.57},{63.63,77.22},{63.24,76.41},{62.63,73.4},{57.77,78.71},{61.2,75.87},{59.83,79.76},{61.18,79.74},{61.92,77.05},{62.49,76.72},{63.07,77.29},{62.33,77.19},{62.14,80.08},{60.06,76.04},{59.44,76.28},{55.96,78.03},{57.76,77.61},{62.39,74.36},{60.44,74.81},},},{[36]={{1.18,80.57},{1.51,80.88},{1.9,81.25},{2.28,81.36},{2.47,80.66},{2.71,80.03},{2.95,79.4},{2.91,78.68},{2.86,77.89},{2.49,77.62},{2.02,77.88},{1.54,78.41},{1.19,79.06},{0.97,79.76},{0.91,80.12},},[130]={{64.28,59.66},{64.5,59.87},{64.76,60.12},{65.01,60.19},{65.14,59.73},{65.3,59.31},{65.46,58.89},{65.43,58.41},{65.4,57.88},{65.15,57.7},{64.84,57.87},{64.52,58.23},{64.29,58.66},{64.14,59.12},{64.1,59.36},{57.65,77.61},{57.88,77.67},{58.21,77.77},{58.52,77.84},{58.9,77.92},{59.24,77.98},{59.59,78.05},{59.82,78.09},{59.97,78.1},{59.73,78.07},{59.4,78.03},{59.07,77.99},{58.71,77.93},{58.35,77.83},{57.99,77.72},{57.66,77.61},{57.31,77.46},{57.06,77.34},{56.75,77.15},{56.47,76.96},{56.15,76.75},{56.36,76.88},{56.6,77.04},{56.92,77.24},{57.2,77.41},{57.4,77.51},},[267]={{9.89,18.93},{10.17,19.21},{10.52,19.54},{10.85,19.63},{11.02,19.02},{11.22,18.47},{11.43,17.91},{11.4,17.28},{11.36,16.59},{11.03,16.35},{10.62,16.58},{10.2,17.05},{9.9,17.61},{9.71,18.22},{9.65,18.54},{1.18,42.49},{1.49,42.57},{1.92,42.69},{2.33,42.79},{2.82,42.89},{3.27,42.98},{3.73,43.07},{4.04,43.11},{4.23,43.13},{3.91,43.09},{3.49,43.04},{3.05,42.99},{2.57,42.9},{2.1,42.77},{1.63,42.63},{1.2,42.49},{0.74,42.3},{0.41,42.13},{0.0,41.88},{0.23,42.0},{0.59,42.22},{0.86,42.36},},},130,nil,nil,76,"AH",},
[1889] = {'Dalaran Wizard',379,405,19,20,0,{[130]={{66.1,49.62},{65.8,50.67},{64.85,49.82},{65.15,52.32},{64.03,56.82},{63.4,57.11},{63.43,58.81},{63.4,58.87},{63.22,58.23},{63.77,58.93},{63.87,58.74},{65.01,58.49},{63.81,58.78},{65.37,56.44},{64.24,59.67},{62.86,76.16},{62.94,76.26},{63.41,65.29},{63.39,65.58},{63.15,65.5},{65.91,75.7},{64.12,73.94},{64.56,75.45},{65.04,74.04},{64.81,76.34},{62.47,76.62},{62.31,76.44},{57.61,77.46},{63.0,72.74},{65.19,77.98},{66.31,78.2},{63.51,58.13},},},{[130]={{57.7,77.39},{57.97,77.47},{58.22,77.54},{58.45,77.59},{58.71,77.64},{59.02,77.71},{59.26,77.76},{59.51,77.81},{59.6,77.82},{59.83,77.85},{59.55,77.8},{59.24,77.75},{58.87,77.69},{58.54,77.62},{58.2,77.54},{57.91,77.46},{57.64,77.36},{57.41,77.27},{57.07,77.11},{56.74,76.92},{56.38,76.68},{56.04,76.44},{55.86,76.31},{56.13,76.49},{56.45,76.71},{56.76,76.9},{57.03,77.06},{57.28,77.19},{63.01,72.85},{63.1,73.17},{63.2,73.53},{63.29,73.88},{63.41,74.28},{63.54,74.68},{63.74,75.32},{63.58,74.82},{63.46,74.41},{63.3,73.88},{63.17,73.42},{63.01,72.75},{62.91,72.3},{62.83,71.71},{62.73,71.29},{62.54,70.64},{62.7,71.04},{62.78,71.52},{62.87,72.1},{62.95,72.52},},[267]={{1.25,42.2},{1.61,42.3},{1.94,42.39},{2.24,42.46},{2.57,42.53},{2.98,42.62},{3.3,42.69},{3.63,42.74},{3.75,42.76},{4.05,42.8},{3.68,42.74},{3.27,42.67},{2.79,42.6},{2.36,42.5},{1.91,42.39},{1.53,42.29},{1.17,42.16},{0.88,42.05},{0.42,41.83},{0.02,41.56},{0.37,41.76},{0.7,41.94},{8.22,36.24},{8.34,36.67},{8.46,37.13},{8.6,37.59},{8.75,38.11},{8.92,38.65},{9.18,39.48},{8.97,38.83},{8.81,38.29},{8.6,37.59},{8.44,36.98},{8.22,36.1},{8.1,35.52},{7.99,34.75},{7.86,34.2},{7.6,33.34},{7.81,33.86},{7.93,34.49},{8.04,35.26},{8.14,35.8},},},130,nil,nil,76,"AH",},
[1890] = {'Rattlecage Skeleton',55,71,2,3,0,{[85]={{34.65,64.38},{34.19,64.67},{34.36,65.06},{32.21,59.25},{32.98,63.0},{33.55,62.5},{34.27,62.88},{31.92,61.66},{31.02,60.8},{31.49,60.3},{32.05,60.09},{31.98,61.04},{32.74,60.47},{33.06,59.64},{33.24,60.14},{33.85,60.78},{32.2,61.74},{32.91,61.62},{33.29,61.66},{33.94,61.85},},},nil,85,nil,nil,7,"AH",},
[1891] = {'Pyrewood Watcher',819,900,13,14,1,{[130]={{47.41,73.99},{47.65,72.04},{44.61,72.77},{46.62,73.01},{42.78,73.14},{48.29,72.18},{45.68,74.97},{43.88,72.05},{44.6,74.39},{46.0,75.22},{45.76,72.31},{44.9,75.0},{45.35,72.52},{44.0,71.85},},},{[130]={{44.54,72.72},{44.45,72.86},{44.3,73.06},{44.2,73.32},{44.33,73.58},{44.55,73.59},{44.75,73.46},{44.75,73.17},{44.71,73.09},},},130,nil,nil,123,"A",},
[1892] = {'Moonrage Watcher',819,900,13,14,1,nil,nil,0,nil,nil,16,nil,},
[1893] = {'Moonrage Sentry',900,984,14,15,1,nil,nil,0,nil,nil,16,nil,},
[1894] = {'Pyrewood Sentry',900,984,14,15,1,{[130]={{47.54,74.2},{47.36,73.95},{45.28,71.42},{45.29,71.63},{45.16,71.73},{47.97,73.12},{42.71,73.03},{46.21,74.23},{47.22,73.47},{44.01,73.51},{44.52,72.21},{45.49,75.32},{43.23,73.44},{43.61,73.29},{43.26,73.3},{44.98,73.25},{45.37,74.54},{43.78,72.82},},},{[130]={{45.29,74.4},{45.17,74.83},{45.21,74.65},{45.32,74.36},{45.45,74.34},{45.54,74.51},{45.67,74.69},{45.82,74.87},{45.66,74.67},{45.51,74.4},{45.38,74.13},{45.22,73.83},{45.1,73.53},{45.12,73.37},{45.38,73.45},{45.59,73.53},{45.55,73.84},{45.4,74.19},},},130,nil,nil,123,"A",},
[1895] = {'Pyrewood Elder',828,903,14,15,1,{[130]={{45.23,71.11},{47.59,74.09},{48.04,73.52},{46.33,71.81},{45.34,71.29},{44.5,74.31},{44.53,74.3},{44.56,74.63},{46.01,74.24},{45.38,74.67},{45.39,73.72},{43.44,73.04},},},{[130]={{45.79,74.22},{46.15,74.19},{46.17,74.02},{46.19,73.75},{46.3,73.71},{46.17,73.71},{46.17,74.2},{46.01,74.22},},},130,nil,nil,123,"A",},
[1896] = {'Moonrage Elder',828,903,14,15,1,nil,nil,0,nil,nil,16,nil,},
[1901] = {'Kelstrum Stonebreaker',2972,2972,45,45,0,{[1537]={{66.97,90.15},},},nil,1537,nil,nil,55,"A",},
[1907] = {'Naga Explorer',2077,2141,43,44,0,{[33]={{27.92,61.59},{27.9,64.57},{28.21,64.41},{28.04,63.4},{27.99,63.11},{27.84,62.32},{27.26,62.98},{27.05,62.46},{26.94,63.7},{27.05,59.73},{27.0,60.62},{26.2,62.42},{26.32,60.65},{25.07,63.69},{24.69,62.95},{25.67,61.32},{25.66,63.19},{24.48,64.39},{23.97,63.62},{25.04,60.48},{24.12,62.29},{26.4,59.99},{27.06,59.69},},},nil,33,nil,nil,74,nil,},
[1908] = {'Vile Fin Oracle',404,433,19,20,0,{[130]={{64.9,42.22},{69.88,18.23},{68.28,20.61},{72.77,17.46},{72.92,18.58},{64.16,41.86},{73.1,16.25},{73.21,16.9},{72.03,18.28},{71.32,18.41},{73.61,18.34},{71.11,17.29},{65.09,41.11},{65.29,43.46},{67.38,45.26},{66.94,48.62},{67.43,19.53},{73.12,16.71},},},nil,130,nil,nil,18,nil,},
[1909] = {'Vile Fin Lakestalker',377,404,18,19,0,{[130]={{65.91,45.98},{67.61,49.39},{65.74,47.05},{75.6,17.54},{67.35,17.45},{73.03,16.07},{75.32,15.87},{69.76,17.41},{70.61,17.5},{72.26,21.95},{70.56,22.25},{69.94,22.19},{71.37,21.83},{73.33,16.03},{64.44,19.72},{66.42,18.53},{65.27,18.63},{65.89,42.2},{65.17,42.65},{69.72,21.04},{65.48,21.69},{65.96,19.88},{64.56,21.3},{66.79,21.24},{65.08,20.89},{70.59,19.41},{68.87,17.14},{68.25,17.62},{68.05,18.78},{69.12,19.76},{72.55,16.59},{73.59,19.5},{73.71,17.52},{64.49,43.23},{73.05,16.6},{74.21,18.94},{65.92,43.39},{66.68,43.43},{65.57,44.92},{66.7,45.8},{66.91,45.62},{66.92,46.23},{67.3,44.53},{67.01,44.91},{66.78,47.24},{64.56,41.27},{73.82,16.06},{74.58,17.6},{74.96,18.66},{74.67,16.26},{75.39,17.04},{73.01,15.92},{74.68,16.31},{73.89,15.91},{73.86,17.43},{74.52,17.71},},},nil,130,nil,nil,18,nil,},
[1910] = {'Muad',186,186,10,10,4,{[85]={{36.49,42.39},},},{[85]={{36.51,42.38},{36.08,42.07},{35.5,41.76},{35.04,41.28},{35.11,41.03},{35.29,40.63},{35.3,40.26},{34.73,40.23},{34.34,40.46},{34.5,41.0},{34.74,40.99},{34.49,41.41},{33.78,42.25},{33.57,43.01},{33.67,43.59},{34.34,44.27},{34.64,44.3},{34.67,44.66},{34.95,44.79},{35.48,44.58},{36.3,44.49},{35.73,43.53},{35.83,43.26},{35.97,43.13},{36.05,42.97},{36.08,43.07},{36.0,43.04},{36.08,42.87},{36.22,42.81},{36.41,42.54},{36.41,42.25},{36.32,42.67},{36.47,42.75},{36.54,42.44},},},85,nil,nil,18,nil,},
[1911] = {'Deeb',230,230,12,12,4,{[85]={{63.29,27.48},},},nil,85,nil,nil,18,nil,},
[1912] = {'Dalaran Protector',300,328,14,15,0,{[130]={{56.68,54.37},{60.14,66.46},{62.08,61.42},{61.96,62.8},{60.11,65.95},{60.93,63.25},{60.18,65.9},{58.53,66.46},{57.56,67.49},{58.82,65.18},{58.04,65.63},{59.65,65.23},{60.88,65.01},{62.79,68.49},{54.95,60.41},{55.46,61.16},{57.27,63.54},{58.03,62.59},{58.65,63.2},{58.04,61.86},{59.11,61.87},{59.86,62.27},{60.75,62.5},{56.46,58.75},{55.47,56.31},{54.85,54.4},{61.68,66.9},{57.99,64.37},{55.17,67.8},},},{[130]={{61.69,66.9},{61.74,67.22},{61.81,67.64},{61.9,68.07},{62.01,68.56},{62.11,68.99},{62.22,69.41},{62.37,69.99},{62.44,70.24},{62.31,69.8},{62.17,69.27},{62.06,68.78},{61.95,68.28},{61.83,67.79},{61.74,67.4},{61.68,66.89},{61.62,66.45},{61.56,65.95},{61.53,65.5},{61.52,65.1},{61.52,64.78},{61.52,65.46},{61.54,65.91},{61.59,66.32},{61.61,66.52},{57.97,64.21},{58.21,64.23},{58.55,64.24},{58.96,64.25},{59.31,64.25},{59.72,64.24},{60.07,64.23},{59.55,64.25},{59.11,64.26},{58.73,64.28},{58.32,64.29},{57.88,64.29},{57.51,64.29},{57.27,64.29},{56.95,64.29},{56.6,64.3},{56.33,64.3},{56.65,64.29},{56.99,64.28},{57.36,64.28},{57.68,64.27},},[267]={{6.49,28.43},{6.56,28.86},{6.65,29.4},{6.77,29.97},{6.91,30.61},{7.04,31.17},{7.18,31.72},{7.39,32.49},{7.47,32.82},{7.31,32.23},{7.12,31.54},{6.98,30.9},{6.82,30.24},{6.67,29.6},{6.55,29.09},{6.47,28.42},{6.4,27.84},{6.32,27.18},{6.28,26.59},{6.27,26.07},{6.27,25.65},{6.27,26.54},{6.3,27.13},{6.36,27.67},{6.39,27.93},{1.61,24.9},{1.93,24.92},{2.36,24.94},{2.9,24.95},{3.37,24.95},{3.91,24.94},{4.36,24.93},{3.69,24.95},{3.1,24.97},{2.61,24.99},{2.07,25.0},{1.49,25.01},{1.01,25.01},{0.69,25.01},{0.26,25.01},{0.32,24.99},{0.8,24.99},{1.22,24.98},},},130,nil,nil,76,"AH",},
[1913] = {'Dalaran Warder',356,386,16,17,0,{[130]={{62.99,62.32},{63.5,63.1},{63.58,64.04},{63.55,65.44},{62.73,62.38},{62.73,63.39},{62.5,63.92},{62.97,62.24},{64.01,63.91},},},nil,130,nil,nil,76,"AH",},
[1914] = {'Dalaran Mage',285,307,15,16,0,{[130]={{62.15,71.8},{61.62,69.05},{60.41,66.54},{60.41,66.67},{62.69,67.63},{62.61,67.45},{61.3,62.56},{59.04,67.09},{58.04,66.32},{59.24,65.64},{60.18,65.25},{59.74,66.55},{62.81,69.62},{58.95,62.4},{59.05,61.85},{59.4,61.89},{59.87,62.39},{59.6,63.25},{59.8,62.35},{60.81,62.5},{57.64,64.3},},},{[130]={{57.94,64.48},{58.19,64.47},{58.45,64.47},{58.76,64.45},{59.07,64.44},{59.35,64.43},{59.65,64.42},{60.01,64.43},{59.59,64.43},{59.32,64.43},{59.06,64.43},{58.71,64.43},{58.37,64.44},{58.06,64.45},{57.74,64.45},{57.41,64.46},{57.26,64.46},{56.89,64.47},{56.58,64.48},{56.27,64.49},{55.94,64.5},{55.59,64.51},{55.9,64.45},{56.23,64.44},{56.61,64.44},{56.98,64.44},{57.26,64.42},},[267]={{1.57,25.25},{1.89,25.25},{2.24,25.24},{2.65,25.22},{3.05,25.2},{3.42,25.19},{3.81,25.17},{4.29,25.19},{3.73,25.18},{3.38,25.18},{3.03,25.19},{2.58,25.19},{2.13,25.2},{1.72,25.21},{1.3,25.22},{0.87,25.22},{0.67,25.23},{0.19,25.24},{0.3,25.2},{0.68,25.18},},},130,nil,nil,76,"AH",},
[1915] = {'Dalaran Conjuror',330,354,17,18,0,{[130]={{62.96,62.09},{63.44,63.75},{63.34,63.4},{63.54,65.3},{62.75,63.46},{63.23,62.54},{63.83,65.81},{62.7,64.63},{63.16,65.31},},},nil,130,nil,nil,76,"AH",},
[1916] = {'Stephen Bhartec',55,71,2,3,0,{[85]={{36.44,61.93},},},nil,85,nil,nil,7,"AH",},
[1917] = {'Daniel Ulfman',71,80,2,3,0,{[85]={{36.71,62.06},},},nil,85,nil,nil,7,"AH",},
[1918] = {'Karrel Grayves',64,71,2,3,0,{[85]={{36.78,61.91},},},nil,85,nil,nil,7,"AH",},
[1919] = {'Samuel Fipps',102,102,5,5,0,{[85]={{36.68,61.56},},},nil,85,nil,nil,7,"AH",},
[1920] = {'Dalaran Spellscribe',441,441,21,21,4,{[130]={{63.54,63.35},},},nil,130,nil,nil,76,"AH",},
[1921] = {'Combat Dummy',64,64,1,1,0,nil,nil,0,nil,nil,914,"AH",},
[1922] = {'Gray Forest Wolf',137,156,7,8,0,{[12]={{74.01,68.91},{73.78,66.15},{72.81,67.57},{74.19,64.95},{71.59,66.46},{71.83,63.21},{72.77,63.23},{73.77,63.62},{71.39,61.07},{70.52,61.83},{70.4,63.58},{69.79,61.85},{69.78,61.14},{68.99,62.94},{69.01,57.41},{68.15,57.88},{68.39,59.51},{69.31,64.13},{67.59,62.24},{68.64,65.13},{67.56,64.09},{68.17,65.85},{66.87,62.81},{69.87,69.54},{66.19,67.77},{66.15,65.65},{62.23,70.94},{63.12,68.96},{61.37,66.37},{61.3,66.81},{65.11,64.36},{65.55,63.62},{63.19,63.69},{64.59,60.31},{66.39,58.25},{61.83,61.13},{60.41,59.7},{60.91,64.3},{60.86,63.56},{60.58,63.7},{61.03,63.37},{60.55,63.99},{60.87,61.5},{60.2,66.73},{60.07,64.3},{59.7,65.41},{59.77,65.88},{60.13,65.8},{58.44,62.13},{58.68,63.94},{59.07,64.74},{61.08,70.14},{59.87,68.59},{59.25,69.43},{59.37,66.85},{60.44,71.34},},},nil,12,nil,nil,38,nil,},
[1923] = {'Bloodsnout Worg',356,386,16,17,0,{[130]={{45.92,79.34},{48.91,81.96},{49.43,82.56},{44.59,80.7},{51.57,76.42},{51.47,77.91},{51.8,76.69},{49.83,73.97},{50.23,84.85},{51.67,79.47},{49.78,77.69},{49.67,84.2},{52.47,81.85},{47.48,80.8},{46.69,77.11},{48.28,77.33},{48.41,80.33},{52.16,78.18},{50.02,76.44},{48.73,80.8},{49.67,75.36},{55.03,80.31},},},nil,130,nil,nil,38,nil,},
[1924] = {'Moonrage Bloodhowler',328,356,15,16,0,{[130]={{54.74,78.25},{58.71,42.3},{58.49,42.33},{59.58,40.99},{60.49,41.35},{50.77,76.96},{48.06,78.28},{57.9,41.38},{60.27,41.38},{48.32,82.26},{44.49,79.16},{45.18,80.49},{49.08,76.32},{48.11,75.69},{46.89,82.47},{51.74,78.86},{50.8,79.61},{49.85,80.55},{53.1,82.47},{46.64,78.2},{47.29,77.53},{46.78,79.48},{49.11,79.0},{51.57,85.38},{52.49,86.38},{53.49,84.73},{54.12,76.98},{53.12,75.36},{52.25,74.51},{51.09,74.26},{49.74,73.78},{50.95,75.18},{55.01,81.35},},},nil,130,nil,nil,24,nil,},
[1931] = {'Captured Scarlet Zealot',176,176,9,9,0,{[85]={{61.97,51.29},},},nil,85,nil,{407,},68,"H",},
[1933] = {'Sheep',14,14,3,3,0,{[38]={{63.87,31.29},{39.25,26.72},{19.32,82.38},{62.58,61.7},{31.4,58.25},},[44]={{19.13,47.13},{34.31,42.26},{29.9,62.92},{34.28,60.13},},[267]={{37.41,64.08},{47.03,60.41},},[36]={{56.59,65.47},},[12]={{34.58,54.79},{30.97,58.04},{40.0,61.7},{41.87,69.78},{44.17,70.62},{39.2,68.08},{31.2,81.05},{35.34,87.27},{47.31,80.71},{52.71,84.5},{56.69,75.04},{65.5,79.05},{64.18,75.76},{78.09,70.66},{77.96,81.99},{80.56,52.37},{89.37,73.33},},},nil,12,nil,nil,31,"AH",},
[1934] = {'Tirisfal Farmer',135,159,6,7,0,{[85]={{37.89,50.65},{37.97,49.93},{38.1,50.35},{37.97,51.86},{38.24,51.78},{35.78,50.68},{36.54,51.8},{37.49,51.63},{34.63,50.67},},},nil,85,nil,nil,67,nil,},
[1935] = {'Tirisfal Farmhand',101,120,5,6,0,{[85]={{38.12,51.73},{35.13,51.57},{37.16,50.48},{35.33,49.34},{36.57,49.48},{38.77,50.58},{37.9,48.96},{38.61,49.23},},},{[85]={{38.08,51.72},{38.13,51.08},{38.16,50.6},{38.0,51.27},},},85,nil,nil,67,nil,},
[1936] = {'Farmer Solliden',156,156,8,8,4,{[85]={{38.03,52.21},},},nil,85,nil,nil,67,nil,},
[1937] = {'Apothecary Renferrel',594,594,14,14,0,{[130]={{42.8,40.86},},},nil,130,{430,444,447,448,451,493,1359,},{429,443,445,446,450,3221,},68,"H",},
[1938] = {'Dalar Dawnweaver',980,980,21,21,0,{[130]={{44.19,39.78},},},nil,130,{99,421,422,423,424,482,1014,},{99,421,422,423,424,481,1014,},68,"H",},
[1939] = {'Rot Hide Brute',356,386,16,17,0,{[130]={{69.44,34.93},{64.59,23.26},{67.7,25.45},{67.11,23.73},{67.56,25.48},{68.21,31.5},{66.72,30.28},{66.67,33.01},{66.42,34.03},{68.41,35.72},{67.9,33.54},{67.43,34.0},{69.04,36.19},{67.01,25.97},{66.86,26.48},{66.93,24.5},{66.25,25.8},{65.43,27.61},{64.73,25.07},{64.66,24.03},{65.63,29.1},{65.05,30.84},{65.79,30.42},{65.67,28.39},{65.97,27.11},{66.31,30.59},{66.31,26.76},{65.8,31.16},{67.77,35.71},},},{[36]={{5.21,29.81},{5.29,29.32},{5.31,28.69},{5.35,27.97},{5.31,28.57},{5.34,29.22},{5.55,29.24},{5.32,29.23},{3.74,29.89},{4.08,29.76},{4.42,29.49},{4.64,28.96},{4.62,28.06},{4.65,28.9},{4.48,29.44},{4.29,29.73},{1.82,28.54},{2.01,28.99},{2.26,29.39},{2.57,29.74},{3.16,29.85},{2.9,29.9},{2.49,29.8},{2.21,29.36},{1.97,28.96},{1.77,27.07},{1.79,27.52},{1.84,28.26},{1.79,27.72},{1.78,27.09},{1.77,26.4},{1.74,26.17},{4.26,31.19},{3.99,31.47},{3.71,31.57},{3.48,31.61},{3.76,31.57},{3.96,31.51},{4.27,31.22},{4.57,30.8},{4.81,30.49},{4.55,30.91},{3.44,37.86},{3.47,38.45},{3.5,39.05},{3.49,39.65},{3.34,40.37},{2.93,40.57},{2.39,40.76},{2.82,40.57},{3.32,40.35},{3.47,39.63},{3.5,39.03},{3.47,38.14},{3.44,37.39},{3.42,37.09},{3.41,37.46},},[85]={{53.02,96.06},{53.07,95.76},{53.08,95.37},{53.11,94.93},{53.08,95.3},{53.1,95.7},{53.23,95.71},{53.09,95.71},{52.11,96.11},{52.32,96.03},{52.53,95.86},{52.67,95.54},{52.66,94.98},{52.68,95.5},{52.57,95.84},{52.45,96.01},{50.92,95.28},{51.04,95.55},{51.19,95.8},{51.38,96.02},{51.75,96.09},{51.59,96.12},{51.33,96.06},{51.16,95.79},{51.01,95.54},{50.89,94.36},{50.9,94.64},{50.93,95.11},{50.9,94.77},{50.89,94.38},{50.89,93.95},{50.87,93.81},{52.43,96.92},{52.26,97.1},{52.09,97.15},{51.95,97.18},{52.12,97.16},{52.24,97.12},{52.44,96.94},{52.63,96.68},{52.77,96.48},{52.61,96.75},},[130]={{66.97,25.82},{67.02,25.5},{67.03,25.08},{67.06,24.6},{67.03,25.0},{67.05,25.43},{67.19,25.45},{67.04,25.44},{65.98,25.88},{66.21,25.79},{66.44,25.61},{66.58,25.26},{66.57,24.66},{66.59,25.22},{66.48,25.58},{66.35,25.77},{64.71,24.98},{64.83,25.28},{65.0,25.54},{65.2,25.78},{65.6,25.85},{65.42,25.89},{65.15,25.82},{64.97,25.53},{64.8,25.26},{64.67,24.0},{64.69,24.3},{64.72,24.79},{64.69,24.43},{64.68,24.01},{64.67,23.55},{64.66,23.4},{66.33,26.75},{66.15,26.93},{65.97,27.0},{65.81,27.03},{66.0,27.0},{66.13,26.96},{66.34,26.77},{66.54,26.49},{66.7,26.28},{66.53,26.56},{65.78,31.19},{65.81,31.59},{65.83,31.99},{65.82,32.39},{65.72,32.86},{65.44,33.0},{65.09,33.12},{65.37,33.0},{65.7,32.85},{65.8,32.37},{65.83,31.98},{65.81,31.38},{65.78,30.88},{65.77,30.68},{65.76,30.93},},},130,nil,nil,70,nil,},
[1940] = {'Rot Hide Plague Weaver',350,377,17,18,0,{[130]={{69.77,37.09},{64.44,23.59},{64.67,23.15},{68.23,25.73},{67.52,25.55},{66.97,23.31},{67.67,25.37},{68.3,33.13},{69.01,33.92},{67.6,31.44},{65.02,26.4},{66.45,34.98},{67.38,36.31},{66.84,26.38},{67.67,24.46},{67.89,24.98},{65.28,27.1},{66.2,27.97},{65.45,25.61},{65.9,34.01},{68.23,35.02},},},nil,130,nil,nil,70,nil,},
[1941] = {'Rot Hide Graverobber',120,137,6,7,0,{[85]={{56.5,46.09},{55.21,43.88},{56.82,44.99},{57.72,41.91},{54.89,42.39},{56.25,43.56},{58.26,42.92},{53.29,41.5},{55.19,42.2},{55.22,42.56},{55.52,42.81},{54.98,41.38},{57.14,40.32},{55.77,40.54},{55.44,41.9},{55.65,39.19},{56.62,39.74},{53.8,43.93},{55.42,41.03},{56.38,41.14},{54.31,42.77},{57.18,44.69},{56.3,43.7},{56.09,43.97},{56.62,46.15},{55.78,42.27},},},{[85]={{55.78,42.27},{55.69,41.91},{55.51,41.35},{55.39,40.93},{55.31,40.66},{55.24,40.32},{55.33,40.11},{55.04,40.62},{54.73,41.01},{54.65,41.16},{54.53,41.37},{54.37,41.6},{54.17,41.84},{53.96,42.09},{53.8,42.27},{53.54,42.56},{53.67,43.07},{53.79,43.54},{53.8,43.58},{53.74,44.07},{53.73,44.23},{53.74,44.43},{53.73,44.7},{53.92,44.35},{54.08,43.95},{54.17,43.77},{54.37,43.45},{54.62,43.35},{54.83,43.27},{54.63,43.39},{54.44,43.48},{54.38,43.51},{54.52,43.45},{54.75,43.46},{54.96,43.2},{55.08,42.96},{55.18,42.85},{55.24,42.72},{55.32,42.49},{55.38,42.32},{55.56,42.3},},},85,nil,nil,70,nil,},
[1942] = {'Rot Hide Savage',417,449,18,19,0,{[130]={{66.36,23.5},{66.26,24.7},{66.23,23.14},{66.42,25.07},{65.3,24.97},{65.08,25.13},{66.32,24.35},{65.56,23.98},{65.71,24.03},{65.32,23.52},{65.27,23.42},{65.25,24.83},{65.85,25.04},{65.64,25.07},{66.25,24.75},{65.57,23.32},{65.9,23.31},},},{[36]={{2.75,26.33},{2.75,26.28},{2.74,25.99},{2.73,25.88},{2.67,25.88},{2.46,25.91},{2.67,25.89},{2.74,25.89},{2.73,25.99},{2.73,26.27},{2.73,26.37},{2.66,26.37},{2.42,26.36},{2.68,26.35},},[85]={{51.5,93.91},{51.5,93.88},{51.49,93.69},{51.49,93.63},{51.45,93.63},{51.32,93.65},{51.45,93.63},{51.49,93.64},{51.49,93.7},{51.49,93.87},{51.49,93.93},{51.44,93.93},{51.29,93.93},{51.45,93.92},},[130]={{65.33,23.5},{65.32,23.47},{65.32,23.28},{65.31,23.21},{65.27,23.21},{65.13,23.23},{65.27,23.21},{65.32,23.21},{65.31,23.28},{65.31,23.47},{65.31,23.53},{65.27,23.53},{65.11,23.52},{65.28,23.52},},},130,nil,nil,70,nil,},
[1943] = {'Raging Rot Hide',415,446,18,19,0,{[130]={{65.75,23.39},{65.71,23.78},{65.49,23.61},{66.33,23.33},{66.25,25.06},{66.18,24.78},{66.37,23.24},{65.31,23.46},{66.34,25.03},{65.21,24.92},{65.58,23.55},{65.89,23.86},{65.16,23.21},{66.2,24.61},{65.25,24.67},{65.2,23.87},{66.05,23.93},{66.11,23.81},},},{[36]={{4.03,28.23},{4.17,28.26},{4.16,27.76},{4.14,27.23},{4.12,26.61},{4.11,26.21},{4.12,26.58},{4.13,27.06},{4.16,28.1},{3.64,26.9},{3.34,26.91},{3.04,26.93},{2.72,26.95},{2.92,26.95},{3.57,26.89},{3.57,26.69},{3.56,26.32},{3.54,26.07},{3.45,26.08},{3.29,26.1},{3.15,26.11},{3.15,26.71},{3.17,26.26},{3.28,26.09},{3.46,26.08},{3.58,26.16},{3.6,26.31},{3.58,26.67},{2.56,26.91},{2.58,27.31},{2.58,28.03},{2.59,27.36},{2.57,26.61},{2.56,26.46},{2.45,26.28},{2.54,26.37},},[85]={{52.29,95.09},{52.38,95.1},{52.37,94.79},{52.36,94.47},{52.35,94.08},{52.34,93.83},{52.34,94.06},{52.35,94.36},{52.37,95.01},{52.05,94.26},{51.86,94.27},{51.68,94.28},{51.48,94.29},{51.6,94.29},{52.0,94.25},{52.0,94.13},{52.0,93.9},{51.98,93.75},{51.93,93.75},{51.83,93.76},{51.75,93.77},{51.75,94.14},{51.76,93.86},{51.82,93.76},{51.94,93.75},{52.01,93.8},{52.02,93.89},{52.01,94.12},{51.38,94.27},{51.39,94.52},{51.39,94.96},{51.4,94.55},{51.39,94.08},{51.38,93.99},{51.31,93.87},{51.37,93.93},},[130]={{66.18,24.77},{66.27,24.79},{66.26,24.46},{66.25,24.11},{66.24,23.69},{66.23,23.42},{66.24,23.67},{66.24,23.99},{66.26,24.69},{65.92,23.89},{65.72,23.89},{65.52,23.91},{65.31,23.92},{65.44,23.92},{65.87,23.88},{65.87,23.74},{65.86,23.5},{65.85,23.33},{65.79,23.34},{65.68,23.35},{65.59,23.36},{65.59,23.76},{65.6,23.46},{65.68,23.35},{65.8,23.34},{65.88,23.39},{65.89,23.49},{65.88,23.73},{65.2,23.89},{65.21,24.16},{65.21,24.64},{65.22,24.19},{65.21,23.69},{65.2,23.59},{65.12,23.47},{65.19,23.53},},},130,nil,nil,70,nil,},
[1944] = {'Rot Hide Bruiser',573,573,22,22,4,{[130]={{64.67,23.05},},},nil,130,nil,nil,70,nil,},
[1946] = {'Lillith Nefara',247,247,12,12,0,nil,nil,0,nil,nil,14,nil,},
[1947] = {'Thule Ravenclaw',1584,1584,24,24,1,{[130]={{65.71,23.67},},},nil,130,nil,nil,70,nil,},
[1948] = {'Snarlmane',726,726,23,23,4,{[130]={{65.1,25.1},},},nil,130,nil,nil,70,nil,},
[1949] = {'Servant of Azora',156,176,10,10,0,{[12]={{65.07,70.11},{65.42,70.11},{64.78,70.57},{64.6,69.78},{63.99,69.62},{64.78,69.93},{64.42,69.95},{65.1,69.53},{64.74,69.61},{64.43,68.41},},},nil,12,nil,nil,12,"A",},
[1950] = {'Rane Yorick',644,644,15,15,0,{[130]={{53.46,13.43},},},nil,130,{425,429,449,},{425,428,435,},68,"H",},
[1951] = {'Quinn Yorick',594,594,14,14,0,{[130]={{53.43,12.59},},},nil,130,nil,{430,},68,"H",},
[1952] = {'High Executor Hadrec',1605,1605,30,30,0,{[130]={{43.42,40.86},},},nil,130,{428,437,438,440,442,443,1098,3221,},{437,439,442,448,449,},68,"H",},
[1953] = {'Lake Skulker',328,356,15,16,0,{[130]={{70.0,33.56},{72.77,38.01},{71.53,36.0},{70.57,37.32},{68.62,37.41},{69.74,38.3},{72.13,37.5},{73.16,36.09},{72.23,34.71},{71.24,34.15},{70.56,35.27},{73.15,34.47},},},nil,130,nil,nil,14,nil,},
[1954] = {'Elder Lake Skulker',325,350,16,16,0,{[130]={{73.76,35.26},{74.29,34.86},{75.1,32.86},{73.96,35.13},{75.0,34.5},{72.0,36.8},},},{[28]={{1.74,93.59},{1.95,93.79},{2.01,94.18},{1.94,94.59},{1.75,94.94},{1.52,94.89},{1.4,94.59},{1.14,94.29},{0.75,94.22},{0.65,93.86},{0.73,93.44},{0.85,92.95},{1.11,93.0},{1.35,93.2},{1.32,93.54},{1.25,93.87},{1.2,94.25},{1.37,94.66},{1.45,94.19},{1.58,93.68},},[36]={{15.77,43.73},{16.09,44.03},{16.19,44.64},{16.07,45.27},{15.78,45.81},{15.44,45.72},{15.24,45.26},{14.84,44.81},{14.25,44.69},{14.09,44.14},{14.21,43.49},{14.39,42.74},{14.81,42.83},{15.17,43.13},{15.12,43.65},{15.02,44.15},{14.94,44.74},{15.2,45.38},{15.32,44.65},{15.52,43.87},},[130]={{74.01,35.11},{74.22,35.31},{74.28,35.71},{74.21,36.13},{74.01,36.49},{73.78,36.43},{73.65,36.12},{73.39,35.83},{72.99,35.75},{72.89,35.38},{72.97,34.95},{73.09,34.44},{73.36,34.5},{73.61,34.7},{73.57,35.05},{73.5,35.39},{73.45,35.78},{73.63,36.2},{73.7,35.72},{73.84,35.2},},},130,nil,nil,14,nil,},
[1955] = {'Lake Creeper',386,417,17,18,0,{[130]={{77.57,29.13},{76.54,26.1},{76.55,27.65},{76.63,28.72},{77.42,27.71},{78.32,25.19},{77.03,26.58},{77.29,28.73},{78.02,27.02},{78.26,26.11},{77.54,25.23},},},nil,130,nil,nil,14,nil,},
[1956] = {'Elder Lake Creeper',417,449,18,19,0,{[130]={{75.19,20.67},{73.8,20.96},{75.48,19.74},{74.06,20.36},{78.52,22.41},{76.95,20.75},{76.4,19.36},{79.02,23.89},{76.96,24.73},{77.25,22.98},{74.63,21.76},{76.23,22.54},{75.43,23.13},{77.95,23.15},{76.7,23.41},},},nil,130,nil,nil,14,nil,},
[1957] = {'Vile Fin Shorecreeper',356,386,16,17,0,{[130]={{78.15,31.12},{77.75,31.49},{77.57,30.75},{78.5,31.08},{77.57,31.09},{76.06,32.72},{76.84,34.29},{77.31,33.91},{77.27,34.26},{76.56,30.2},{76.22,34.99},},},nil,130,nil,nil,18,nil,},
[1958] = {'Vile Fin Tidecaller',350,377,17,18,0,{[130]={{81.3,31.47},{79.98,32.41},{80.88,28.06},{78.42,32.56},{77.55,32.55},{78.06,32.03},{77.56,33.52},{78.28,31.43},{77.9,31.14},{78.07,30.56},{78.46,30.49},{78.32,30.85},{80.89,31.77},{80.24,28.62},{80.47,28.69},{80.14,28.3},{80.83,29.6},{77.74,30.03},{78.5,29.24},{79.13,28.23},{80.34,28.25},{79.86,28.12},{80.49,28.36},{78.83,31.91},{80.14,31.53},{80.48,29.52},{79.31,30.28},{80.26,27.7},{80.07,29.3},{77.24,32.06},{77.14,33.79},{76.23,33.85},{80.45,32.45},{80.18,26.97},{76.82,32.94},{75.26,31.39},{75.78,30.11},{75.27,32.84},},[36]={{27.25,34.92},{27.19,34.9},},},nil,130,nil,nil,18,nil,},
[1959] = {'Mountaineer Barleybrew',919,919,20,20,0,{[1]={{86.28,48.81},},},nil,1,{414,},{413,},57,"A",},
[1960] = {'Pilot Hammerfoot',748,748,17,17,0,{[1]={{83.89,39.19},},},nil,1,{419,},{417,},55,"A",},
[1961] = {'Mangeclaw',222,222,11,11,0,{[1]={{78.31,37.76},},},nil,1,nil,nil,44,nil,},
[1963] = {'Vidra Hearthstove',413,413,10,10,0,{[38]={{34.83,49.28},},},nil,38,{418,},{418,},55,"A",},
[1964] = {'Treant',9250,9250,60,60,0,nil,nil,0,nil,nil,91,nil,},
[1965] = {'Mountaineer Thalos',644,644,15,15,0,{[1]={{33.48,71.84},},},nil,1,{420,},{282,},55,"A",},
[1971] = {'Ivar the Foul',273,273,13,13,0,{[130]={{51.52,13.9},},},nil,130,nil,nil,21,nil,},
[1972] = {'Grimson the Pale',328,328,15,15,0,{[130]={{58.58,44.86},},},nil,130,nil,nil,24,nil,},
[1973] = {'Ravenclaw Guardian',494,531,20,21,0,{[130]={{57.12,71.02},{57.58,71.53},{57.4,70.88},{57.76,69.82},{57.28,69.89},{58.76,71.75},{58.68,71.61},{58.96,70.86},{58.66,71.29},{60.03,71.11},{59.66,69.88},{59.58,71.76},},},nil,130,nil,nil,21,nil,},
[1974] = {'Ravenclaw Drudger',449,484,19,20,0,{[130]={{60.34,74.01},{57.44,70.81},{57.73,69.81},{56.75,70.43},{58.06,69.89},{58.3,72.01},{59.64,70.76},{59.14,70.5},{60.58,72.37},{60.01,72.09},{60.66,72.6},},},{[130]={{60.6,72.53},{60.5,72.45},{60.28,72.23},{60.14,72.11},{59.94,71.99},{59.72,71.87},{59.91,71.96},{60.18,72.15},{60.36,72.3},{60.54,72.48},},[267]={{5.06,35.82},{4.93,35.71},{4.64,35.43},{4.46,35.27},{4.19,35.11},{3.9,34.95},{4.15,35.07},{4.51,35.32},{4.74,35.51},{4.98,35.75},},},130,nil,nil,21,nil,},
[1975] = {'Eastvale Lumberjack',334,334,8,8,0,{[12]={{82.76,63.13},{82.59,63.26},{83.05,63.58},},},nil,12,nil,nil,11,"A",},
[1976] = {'Stormwind City Patroller',5079,5079,55,55,0,{[1519]={{50.99,28.06},{38.54,36.48},{64.96,70.28},{60.32,75.31},{60.18,51.3},{60.11,67.9},{50.12,37.49},{46.83,31.81},{33.24,64.1},},},{[12]={{25.38,28.1},{25.62,27.98},{25.86,27.87},{25.64,27.96},{25.28,28.12},{25.3,28.11},{24.93,27.14},{23.61,24.32},{24.2,25.52},{19.38,28.78},{19.64,28.52},{19.91,28.67},{20.21,29.27},{20.59,29.8},{21.11,29.95},{21.57,29.69},{21.82,29.41},{22.06,29.13},{22.34,28.41},{22.35,27.65},{22.17,26.99},{22.01,26.61},{22.23,26.31},{22.58,27.05},{22.99,27.66},{23.42,28.09},{23.84,28.8},{23.86,29.27},{23.32,29.85},{22.58,30.82},{22.3,31.12},{22.09,31.14},{21.81,30.6},{21.57,30.15},{21.4,30.15},{20.99,30.69},{20.67,31.09},{20.47,31.11},{20.14,30.49},{19.69,29.67},{19.4,29.14},{29.99,43.04},{29.52,43.54},{29.3,44.15},{28.9,43.94},{28.6,44.42},{28.05,44.35},{28.16,43.51},{28.57,42.99},{28.55,42.5},{28.25,41.95},{27.9,41.31},{27.99,41.21},{28.33,41.85},{28.62,42.41},{28.79,42.52},{29.14,42.04},{29.41,41.91},{30.12,42.65},{29.95,42.3},{29.79,42.03},{29.6,41.88},{29.37,44.13},{29.38,43.55},{29.5,43.26},{29.77,42.97},{29.78,42.19},{29.33,42.16},{28.84,42.66},{28.55,42.74},{28.14,41.93},{27.82,41.3},{27.75,41.39},{27.88,41.65},{28.07,42.01},{28.45,42.64},{28.48,42.92},{28.19,43.37},{28.56,44.7},{28.27,45.03},{27.97,44.52},{27.76,44.1},{27.81,43.82},{28.98,44.1},{27.76,34.52},{27.21,33.67},{27.13,33.38},{26.87,33.16},{26.61,32.94},{26.26,33.01},{26.15,33.0},{25.5,33.27},{24.92,33.74},{24.05,34.47},{23.86,34.65},{23.66,34.64},{23.43,34.17},{23.12,33.64},{23.13,33.37},{23.53,32.91},{24.02,32.35},{24.47,31.73},{24.87,31.3},{25.24,30.92},{25.33,30.04},{25.38,28.96},{25.27,28.24},{25.06,27.31},{24.6,26.41},{24.44,25.89},{24.51,25.58},{24.88,25.21},{25.32,24.77},{25.54,24.73},{25.98,25.66},{26.51,26.77},{26.55,27.04},{26.88,27.53},{27.6,27.95},{28.04,27.87},{28.44,27.67},{28.67,27.72},{29.07,28.44},{29.39,28.94},{29.36,29.21},{29.1,29.55},{28.71,30.2},{28.61,30.32},{28.28,31.04},{28.37,31.59},{28.35,31.6},{28.38,31.78},{28.6,32.29},{28.92,32.8},{29.07,33.0},{29.25,33.43},{29.22,33.48},{28.61,34.22},{28.18,34.8},{27.94,34.78},{27.88,34.67},{27.7,40.72},{27.42,40.93},{27.06,40.09},{26.5,38.97},{26.16,38.87},{25.65,39.29},{25.75,39.78},{25.65,40.06},{25.45,39.99},{25.27,39.56},{24.94,38.94},{24.69,38.24},{24.51,37.46},{24.6,36.65},{24.98,36.12},{25.41,35.61},{25.87,35.42},{26.45,35.57},{27.17,36.72},{27.56,37.42},{28.13,38.01},{28.54,38.52},{28.4,38.8},{27.86,38.23},{27.06,37.29},{26.8,37.63},{26.31,38.3},{26.47,38.67},{26.92,39.27},{27.31,39.91},{22.14,26.48},{22.09,26.8},{22.26,27.25},{22.37,27.63},{22.34,28.41},{22.06,29.12},{21.82,29.41},{21.55,29.72},{21.08,29.88},{20.59,29.76},{20.21,29.26},{19.85,28.61},{19.64,28.57},{19.45,28.83},{19.46,29.27},{19.86,29.99},{20.31,30.83},{20.46,31.11},{20.72,31.2},{21.6,30.07},{21.78,30.25},{22.21,31.06},{22.34,31.09},{22.99,30.38},{23.3,29.66},{23.66,29.22},{23.68,28.95},{23.61,28.79},{23.45,28.56},{23.17,28.12},{22.8,27.38},{22.47,26.74},{22.31,26.52},{23.66,32.79},{23.12,33.37},{22.69,33.81},{22.22,34.31},{21.9,34.07},{21.39,33.59},{21.24,33.59},{20.82,33.99},{20.28,34.04},{19.84,33.7},{19.45,33.11},{19.13,32.52},{18.94,32.08},{19.47,31.46},{20.15,30.63},{20.33,30.66},{20.53,31.06},{20.69,31.1},{21.13,30.53},{21.68,29.8},{22.22,29.11},{22.49,28.26},{22.86,27.84},{23.05,27.84},{23.47,28.31},{23.66,28.28},{24.43,27.37},{24.75,26.98},{24.9,27.02},{25.07,27.33},{25.27,28.0},{25.32,28.47},{25.38,29.42},{25.35,29.91},{25.32,30.24},{25.21,30.87},{24.85,31.33},{24.7,31.55},{24.54,31.7},{24.19,32.13},{23.93,32.49},{17.33,39.48},{17.67,40.44},{17.98,41.27},{18.45,40.92},{18.98,41.2},{19.4,41.41},{19.9,41.94},{20.42,41.42},{20.47,41.37},{21.07,41.51},{21.16,41.53},{21.63,42.3},{21.97,42.86},{22.02,43.93},{22.03,44.22},{21.69,44.8},{21.46,45.16},{21.42,45.19},{21.38,45.28},{20.88,45.48},{20.43,45.66},{20.16,45.75},{20.14,45.34},{19.59,44.74},{19.5,44.18},{19.39,43.5},{19.51,42.84},{19.58,42.51},{19.86,41.92},{19.49,41.5},{19.41,41.41},{18.93,41.16},{18.44,40.94},{18.27,41.05},{17.99,41.28},{17.79,40.76},{17.54,40.08},},[1519]={{54.05,34.7},{54.67,34.39},{55.29,34.11},{54.7,34.36},{53.78,34.75},{53.82,34.73},{52.89,32.23},{49.47,24.94},{50.98,28.05},{38.54,36.48},{39.21,35.81},{39.91,36.18},{40.7,37.74},{41.67,39.11},{43.0,39.49},{44.2,38.82},{44.86,38.09},{45.47,37.37},{46.2,35.51},{46.23,33.54},{45.74,31.84},{45.35,30.85},{45.9,30.08},{46.8,31.99},{47.87,33.58},{48.98,34.69},{50.06,36.52},{50.11,37.74},{48.73,39.24},{46.81,41.73},{46.09,42.51},{45.54,42.56},{44.81,41.16},{44.19,39.99},{43.76,40.01},{42.69,41.39},{41.87,42.43},{41.37,42.47},{40.5,40.87},{39.34,38.77},{38.6,37.4},{65.95,73.29},{64.74,74.59},{64.15,76.14},{63.13,75.61},{62.36,76.85},{60.94,76.68},{61.22,74.5},{62.27,73.17},{62.23,71.9},{61.45,70.48},{60.56,68.81},{60.78,68.56},{61.65,70.22},{62.42,71.65},{62.84,71.95},{63.75,70.72},{64.46,70.38},{66.27,72.29},{65.85,71.38},{65.43,70.67},{64.95,70.28},{64.34,76.11},{64.36,74.62},{64.69,73.85},{65.38,73.11},{65.41,71.1},{64.23,71.01},{62.97,72.31},{62.23,72.52},{61.16,70.42},{60.34,68.79},{60.15,69.04},{60.5,69.71},{61.0,70.64},{61.97,72.25},{62.05,72.97},{61.3,74.13},{62.26,77.57},{61.5,78.44},{60.72,77.11},{60.19,76.03},{60.32,75.31},{63.33,76.02},{60.18,51.3},{58.77,49.1},{58.56,48.34},{57.88,47.77},{57.21,47.21},{56.31,47.39},{56.02,47.36},{54.35,48.05},{52.84,49.27},{50.61,51.16},{50.11,51.63},{49.61,51.59},{49.01,50.39},{48.21,49.02},{48.22,48.31},{49.25,47.13},{50.52,45.68},{51.69,44.09},{52.74,42.98},{53.67,41.99},{53.92,39.72},{54.04,36.94},{53.76,35.08},{53.21,32.67},{52.03,30.36},{51.62,29.0},{51.79,28.21},{52.74,27.24},{53.89,26.1},{54.44,26.02},{55.59,28.42},{56.95,31.29},{57.05,31.98},{57.92,33.23},{59.76,34.32},{60.92,34.11},{61.95,33.61},{62.54,33.74},{63.57,35.59},{64.4,36.88},{64.31,37.57},{63.65,38.46},{62.63,40.13},{62.39,40.44},{61.54,42.29},{61.75,43.71},{61.71,43.75},{61.78,44.22},{62.35,45.54},{63.19,46.84},{63.57,47.36},{64.04,48.48},{63.96,48.61},{62.38,50.5},{61.28,52.02},{60.66,51.96},{60.5,51.68},{60.02,67.31},{59.3,67.83},{58.38,65.68},{56.93,62.78},{56.06,62.52},{54.74,63.62},{55.01,64.88},{54.73,65.6},{54.22,65.41},{53.76,64.31},{52.91,62.7},{52.26,60.9},{51.79,58.87},{52.02,56.79},{53.0,55.43},{54.11,54.09},{55.31,53.61},{56.79,53.99},{58.66,56.98},{59.66,58.78},{61.14,60.29},{62.19,61.62},{61.84,62.35},{60.43,60.87},{58.39,58.43},{57.71,59.33},{56.45,61.06},{56.86,62.0},{58.01,63.56},{59.02,65.2},{45.66,30.52},{45.55,31.37},{45.99,32.51},{46.28,33.5},{46.18,35.5},{45.47,37.33},{44.86,38.09},{44.15,38.89},{42.95,39.32},{41.67,38.99},{40.7,37.7},{39.78,36.04},{39.22,35.92},{38.74,36.59},{38.76,37.72},{39.8,39.6},{40.96,41.76},{41.33,42.48},{42.0,42.72},{44.29,39.79},{44.75,40.27},{45.86,42.36},{46.2,42.42},{47.88,40.6},{48.68,38.75},{49.61,37.61},{49.66,36.9},{49.48,36.49},{49.06,35.9},{48.33,34.77},{47.37,32.86},{46.53,31.2},{46.12,30.63},{49.6,46.83},{48.21,48.31},{47.1,49.46},{45.88,50.74},{45.05,50.12},{43.75,48.88},{43.35,48.88},{42.26,49.92},{40.87,50.04},{39.72,49.16},{38.72,47.64},{37.9,46.12},{37.4,44.98},{38.79,43.4},{40.54,41.25},{41.0,41.31},{41.53,42.34},{41.92,42.46},{43.07,40.99},{44.5,39.11},{45.89,37.32},{46.57,35.12},{47.54,34.05},{48.04,34.05},{49.1,35.26},{49.61,35.18},{51.58,32.82},{52.42,31.82},{52.81,31.93},{53.25,32.73},{53.75,34.45},{53.88,35.65},{54.05,38.13},{53.96,39.38},{53.89,40.23},{53.61,41.87},{52.68,43.06},{52.29,43.61},{51.87,44.0},{50.98,45.12},{50.3,46.05},{33.24,64.1},{34.14,66.58},{34.94,68.72},{36.14,67.83},{37.52,68.54},{38.61,69.08},{39.9,70.45},{41.24,69.1},{41.36,68.97},{42.9,69.34},{43.15,69.38},{44.37,71.39},{45.23,72.82},{45.38,75.6},{45.4,76.34},{44.53,77.83},{43.93,78.75},{43.83,78.84},{43.7,79.08},{42.43,79.58},{41.27,80.04},{40.55,80.3},{40.5,79.24},{39.09,77.69},{38.86,76.24},{38.58,74.47},{38.88,72.77},{39.06,71.92},{39.79,70.41},{38.83,69.3},{38.64,69.08},{37.39,68.44},{36.13,67.86},{35.69,68.15},{34.96,68.74},{34.45,67.41},{33.8,65.63},},},1519,nil,nil,11,"A",},
[1977] = {'Senator Mehr Stonehallow',3517,3517,50,50,0,{[1]={{68.67,55.97},},},nil,1,{433,},{433,},55,"A",},
[1978] = {'Deathstalker Erland',456,456,11,11,0,{[130]={{56.18,9.18},},},nil,130,{435,},nil,98,"H",},
[1981] = {'Dark Iron Ambusher',198,198,10,10,0,nil,nil,0,nil,nil,54,nil,},
[1983] = {'Nightlash',300,300,14,14,0,nil,nil,0,nil,nil,70,nil,},
[1984] = {'Young Thistle Boar',42,55,1,2,0,{[141]={{56.72,42.19},{55.6,41.92},{57.77,42.42},{55.49,42.26},{55.07,43.42},{63.23,42.23},{63.3,42.44},{55.54,43.44},{55.87,41.25},{62.08,41.23},{60.61,46.26},{56.57,42.22},{57.63,39.54},{57.44,45.02},{56.68,44.25},{57.05,45.62},{61.29,43.71},{61.53,42.94},{61.17,45.66},{62.03,42.45},{59.1,43.34},{59.5,45.26},{58.51,45.66},{59.0,44.37},},},nil,141,nil,nil,189,"AH",},
[1985] = {'Thistle Boar',55,71,2,3,0,{[141]={{55.34,37.07},{56.35,37.88},{55.5,39.44},{56.36,36.94},{56.33,38.36},{57.19,35.71},{61.83,38.65},{60.15,39.09},{59.81,37.6},{60.21,34.85},{58.24,34.84},{60.04,31.59},{59.43,34.61},{60.28,34.15},{60.34,34.04},{59.64,36.91},{61.37,36.04},{61.37,35.3},{61.8,34.25},{62.2,35.87},},},nil,141,nil,nil,189,"AH",},
[1986] = {'Webwood Spider',71,86,3,4,0,{[141]={{57.68,27.4},{57.92,26.95},{57.35,26.01},{57.86,26.06},{57.91,26.42},{58.0,27.26},{56.89,28.2},{57.25,27.49},{57.77,28.01},{57.95,28.36},{58.02,28.6},{57.55,29.13},{57.23,29.38},{57.23,29.65},{56.04,26.41},{55.73,25.22},{56.07,24.86},{56.26,24.92},{56.44,25.87},{56.88,26.28},{58.76,33.43},{57.79,32.63},{57.55,32.7},{56.77,31.37},{56.76,31.3},{56.55,30.55},{56.37,30.25},{56.48,29.51},{55.94,29.02},{55.72,28.44},{55.81,27.22},{55.85,27.25},{55.52,27.59},{56.08,26.92},{56.28,26.51},{55.95,26.2},{55.71,25.14},{56.42,24.84},{57.19,32.28},{56.57,34.34},{56.5,25.29},{56.8,25.57},{56.46,26.79},{57.59,33.87},{56.37,33.2},{56.9,27.75},{56.9,28.42},{56.56,29.4},{56.37,30.31},{56.58,30.73},{56.73,31.29},{57.24,33.93},{56.21,32.54},{56.77,31.82},{56.12,29.11},{55.69,28.47},{57.8,32.5},{57.75,33.1},{55.54,27.65},{55.77,27.5},{56.11,26.96},{55.88,27.09},},},nil,141,nil,nil,22,nil,},
[1988] = {'Grell',55,71,2,3,0,{[141]={{55.92,45.15},{56.16,45.81},{55.71,46.45},{56.13,45.36},{55.81,45.51},{56.03,45.56},{55.69,46.0},{55.86,45.95},{55.97,45.97},{56.2,46.25},{56.4,46.13},{55.77,41.55},},},nil,141,nil,nil,189,"AH",},
[1989] = {'Grellkin',71,86,3,4,0,{[141]={{54.0,39.74},{62.3,35.66},{64.16,42.24},{54.02,39.0},{54.18,39.19},{56.16,38.54},{54.02,38.38},{54.13,39.32},{54.23,39.22},{54.25,39.33},{54.9,39.78},{54.4,39.43},{54.68,38.47},{54.28,38.86},{56.32,34.61},{59.64,35.03},{54.53,44.06},{54.75,44.34},{54.54,44.77},{54.68,44.17},{54.63,44.05},{54.9,38.8},{54.56,43.83},{54.67,43.45},{54.41,43.57},{54.23,44.19},{54.87,43.51},{54.91,44.13},},},nil,141,nil,nil,189,"AH",},
[1992] = {'Tarindrella',228,228,7,7,0,{[141]={{57.83,45.21},},},nil,141,{459,},{458,459,},80,"A",},
[1993] = {'Greenpaw',186,186,10,10,0,{[141]={{44.56,62.54},},},nil,141,nil,nil,82,nil,},
[1994] = {'Githyiss the Vile',102,102,5,5,0,{[141]={{56.65,26.31},},},nil,141,nil,nil,22,nil,},
[1995] = {'Strigid Owl',102,120,5,6,0,{[141]={{52.05,56.36},{64.75,51.47},{68.71,62.4},{53.47,59.37},{64.2,54.37},{65.37,52.65},{67.2,61.41},{45.85,47.5},{53.03,54.48},{67.48,53.56},{68.13,62.15},{65.69,54.48},{46.31,48.63},{54.07,60.12},{50.02,58.69},{52.21,59.33},{49.78,58.08},{52.39,62.72},{54.81,63.96},{55.42,65.99},{64.0,64.1},{57.94,60.77},{64.88,61.47},{63.03,64.17},{62.66,63.06},{57.6,56.33},{58.86,60.29},{62.0,51.42},{61.21,50.61},{63.36,53.59},{63.41,51.73},{58.72,56.19},{52.75,56.88},{54.23,57.0},{54.11,60.38},{53.71,59.35},},},nil,141,nil,nil,15,"AH",},
[1996] = {'Strigid Screecher',137,156,7,8,0,{[141]={{58.06,76.21},{64.25,69.24},{39.55,54.54},{39.1,51.36},{39.73,53.71},{43.77,77.43},{41.86,71.53},{42.35,72.25},{41.25,49.65},{51.91,77.36},{53.06,77.89},{42.79,48.93},{65.55,66.45},{65.88,67.03},{57.61,75.01},{53.71,77.07},{38.43,62.47},{48.16,74.19},{38.82,51.46},{37.6,51.29},{53.29,76.63},{64.2,67.23},{52.46,77.78},{38.75,63.36},{46.2,75.54},{58.88,76.96},{58.47,75.0},{38.2,55.58},{45.58,76.52},{41.05,68.39},{42.17,75.34},{42.91,77.12},{39.28,65.31},{39.48,53.03},{43.9,50.57},{42.67,52.08},},},nil,141,nil,nil,15,"AH",},
[1997] = {'Strigid Hunter',156,176,8,9,0,{[141]={{40.82,44.97},{46.25,31.44},{45.57,40.55},{37.56,29.3},{39.28,46.07},{46.12,39.67},{38.07,39.51},{38.48,46.22},{37.69,37.93},{37.97,38.31},{39.04,30.72},{38.54,47.81},{44.39,39.85},},},nil,141,nil,nil,15,"AH",},
[1998] = {'Webwood Lurker',102,120,5,6,0,{[141]={{68.04,64.07},{67.22,62.04},{69.51,60.35},{45.86,46.71},{69.52,57.15},{51.02,53.85},{70.06,60.25},{67.05,66.29},{68.47,63.57},{60.86,54.53},{53.52,61.89},{47.05,46.96},{54.23,62.51},{51.61,59.39},{51.01,65.25},{54.27,64.24},{52.92,64.28},{52.58,67.4},{51.67,66.3},{53.33,66.71},{60.93,55.2},{61.43,54.6},{60.77,54.58},{60.77,57.13},{60.08,58.24},{63.34,63.16},{63.91,60.84},{59.55,59.7},{64.05,61.77},{61.13,61.25},{60.23,59.51},{58.17,55.84},{52.25,55.58},{53.61,61.35},{51.76,58.49},{60.14,60.26},{52.24,55.71},},},nil,141,nil,nil,22,nil,},
[1999] = {'Webwood Venomfang',135,156,7,8,0,{[141]={{44.81,77.47},{38.86,61.67},{61.0,73.45},{41.83,75.01},{40.74,48.78},{54.35,74.2},{65.2,69.14},{45.76,78.9},{59.61,76.11},{55.03,73.22},{38.73,47.9},{37.17,47.36},{54.48,77.37},{41.17,76.03},{44.68,74.47},{45.07,77.91},{48.51,75.11},{49.01,76.05},{38.85,59.6},{54.3,76.13},{60.18,75.04},{61.54,75.04},{45.35,70.18},{45.29,73.07},{39.78,59.96},{40.39,48.62},{46.51,71.6},{42.86,74.69},{43.75,54.32},{42.77,52.56},},},nil,141,nil,nil,22,nil,},
[2000] = {'Webwood Silkspinner',156,176,8,9,0,{[141]={{43.69,47.28},{43.24,45.49},{47.95,32.09},{34.61,32.65},{45.09,35.14},{43.85,44.48},{33.31,31.02},{45.81,43.41},{47.36,34.09},{39.93,31.42},{36.31,32.26},{48.57,44.94},{42.44,46.28},{33.58,32.3},{47.82,44.5},{43.09,43.54},},},nil,141,nil,nil,22,nil,},
[2001] = {'Giant Webwood Spider',198,222,10,11,0,{[141]={{45.71,27.47},{41.2,28.93},{40.15,25.4},{38.03,27.91},},},nil,141,nil,nil,22,nil,},
[2002] = {'Rascal Sprite',98,115,5,6,0,{[141]={{53.68,51.46},{52.95,51.28},{52.91,52.06},{53.17,48.8},{53.59,48.81},{53.6,49.05},{53.82,50.8},{53.58,50.0},},},{[141]={{52.95,51.28},{52.93,51.68},{52.95,51.28},{52.95,51.08},{52.97,50.85},{53.04,50.66},{53.11,50.59},{53.28,50.69},{53.38,50.89},{53.28,50.75},{53.18,50.62},{53.05,50.58},{52.95,50.68},{52.9,50.92},},},141,nil,nil,90,nil,},
[2003] = {'Shadow Sprite',98,115,5,6,0,{[141]={{53.54,51.15},{52.97,50.88},{53.0,50.31},{52.94,51.48},{53.41,51.75},{53.28,50.77},{54.04,51.17},{54.71,51.39},{54.6,52.62},{54.48,51.88},},},nil,141,nil,nil,90,nil,},
[2004] = {'Dark Sprite',120,137,6,7,0,{[141]={{52.38,50.2},{51.22,51.04},{53.03,49.31},{52.6,49.81},{51.74,48.92},{51.65,50.03},{51.4,49.99},{52.76,50.03},},},nil,141,nil,nil,90,nil,},
[2005] = {'Vicious Grell',137,137,7,7,0,{[141]={{51.78,50.47},{51.64,51.64},{52.22,51.08},{52.01,50.59},{52.2,50.71},{51.47,51.47},{52.1,52.12},{51.3,50.56},{52.06,48.53},{51.55,48.85},{52.66,49.46},},},nil,141,nil,nil,90,nil,},
[2006] = {'Gnarlpine Ursa',102,120,5,6,0,{[141]={{66.7,63.34},{65.8,63.83},{65.38,64.09},{64.99,63.87},{66.67,60.36},{68.08,58.43},{68.84,58.18},{65.44,57.62},{64.73,57.5},{66.67,64.41},},},nil,141,nil,nil,82,nil,},
[2007] = {'Gnarlpine Gardener',102,120,5,6,0,{[141]={{65.26,65.56},{65.92,63.77},{64.68,64.07},{66.07,60.4},{67.4,55.41},{65.47,63.22},{65.35,61.63},{67.37,60.52},{65.5,59.11},{65.82,64.26},{65.3,58.29},{66.82,56.42},{67.26,59.12},},},nil,141,nil,nil,82,nil,},
[2008] = {'Gnarlpine Warrior',120,137,6,7,0,{[141]={{70.48,52.37},{69.3,52.8},{70.17,52.68},{70.27,53.09},{69.73,53.92},{65.65,64.87},{65.86,63.66},{65.6,64.71},{66.97,59.71},{49.69,66.37},{49.74,68.12},{49.98,65.63},{50.31,66.17},{50.06,66.77},{50.93,62.04},{50.29,62.11},{65.73,64.75},{65.96,59.62},{49.78,61.37},{50.37,61.24},{68.64,53.16},{67.84,60.15},{67.96,52.59},{68.31,52.49},{65.89,57.37},{66.47,57.24},{66.3,58.62},{66.34,58.99},{67.05,57.59},{67.41,57.0},{65.8,58.24},{66.42,59.33},{66.61,58.2},{68.0,59.4},},},nil,141,nil,nil,82,nil,},
[2009] = {'Gnarlpine Shaman',131,148,7,8,0,{[141]={{37.4,66.99},{37.92,66.19},{49.55,66.79},{49.39,66.63},{49.26,67.37},{56.83,76.48},{57.2,75.97},{56.87,75.01},{56.54,77.24},{49.03,78.05},{47.88,77.63},{46.83,77.95},{48.63,78.76},{46.37,77.34},{38.34,65.6},{47.29,76.92},{47.94,77.92},{47.55,78.49},{47.35,77.39},{45.23,57.79},{44.39,57.07},{50.55,62.92},{49.96,62.69},{44.53,57.43},{44.22,58.25},{44.63,57.63},{44.49,60.47},{44.27,58.49},{44.19,60.31},{44.41,61.24},{45.56,59.06},{45.47,59.9},{45.09,60.09},{45.31,58.79},{45.02,58.34},{43.69,60.46},{43.79,61.74},{44.01,61.1},{43.26,60.74},{43.6,59.98},{44.18,59.38},{44.07,59.55},{44.36,58.54},{42.88,61.24},{44.88,57.33},{45.23,58.68},{45.57,59.0},},},{[141]={{44.53,57.44},{44.51,57.61},{44.54,57.36},{44.59,57.01},{44.64,56.68},{44.66,56.19},{44.65,55.97},{44.64,55.57},{44.66,56.06},{44.66,56.4},{44.62,56.78},{44.57,57.08},{44.27,58.48},{44.27,58.32},{44.22,58.22},{44.06,58.16},{43.97,58.23},{43.92,58.32},{43.86,58.45},{43.78,58.52},{43.87,58.44},{43.93,58.3},{43.96,58.24},{44.07,58.15},{44.21,58.2},{44.28,58.33},{44.26,58.54},{44.18,58.66},{44.06,58.67},{43.96,58.57},{43.92,58.41},{43.97,58.24},{44.08,58.15},{43.96,58.24},{43.92,58.41},{43.96,58.58},{44.06,58.67},{44.18,58.66},{44.27,58.53},{45.23,58.68},{45.26,58.49},{45.29,58.35},{45.3,58.29},{45.32,58.17},{45.3,57.98},{45.26,57.9},{45.2,57.81},{45.12,57.7},{45.06,57.61},{45.0,57.53},{44.94,57.45},{45.01,57.54},{45.11,57.7},{45.16,57.77},{45.26,57.91},{45.35,57.99},{45.46,58.07},{45.51,58.11},{45.59,58.14},{45.68,58.17},{45.77,58.21},{45.82,58.24},{45.9,58.27},{45.96,58.29},{45.81,58.23},{45.67,58.17},{45.57,58.12},{45.46,58.08},{45.38,58.12},{45.33,58.21},{45.3,58.3},{45.27,58.45},{45.24,58.57},},},141,nil,nil,82,nil,},
[2010] = {'Gnarlpine Defender',137,156,7,8,0,{[141]={{41.43,71.94},{39.3,66.24},{37.83,67.13},{38.23,66.79},{38.54,66.22},{39.08,67.05},{38.52,67.19},{38.36,67.86},{37.45,66.28},{44.04,56.6},{44.75,58.72},{45.11,57.55},{49.35,66.82},{49.36,66.08},{54.94,75.2},{56.23,76.57},{55.63,75.76},{48.56,78.06},{48.18,77.68},{47.13,77.71},{48.01,77.81},{45.79,78.05},{49.04,76.92},{43.8,61.31},{44.45,57.12},{43.87,57.69},{43.9,61.14},{49.99,62.47},{49.56,62.65},{49.98,63.16},{44.78,56.08},{43.13,59.64},{43.34,58.78},{43.72,58.55},{44.44,60.35},{44.63,56.7},{44.33,57.46},{43.0,59.07},{43.93,61.41},{44.49,60.0},{44.3,61.74},{44.33,60.58},{43.33,61.92},{43.86,59.96},{43.95,60.23},{43.88,57.37},{44.08,57.06},{46.19,58.39},{43.87,57.97},{45.36,58.06},{45.63,57.74},},},{[141]={{43.87,57.69},{43.88,57.9},{43.95,58.12},{44.05,58.21},{44.11,58.25},{44.22,58.35},{44.32,58.44},{44.39,58.61},{44.36,58.77},{44.31,58.94},{44.29,59.0},{44.28,59.1},{44.26,59.15},{44.21,59.27},{44.18,59.37},{44.23,59.22},{44.27,59.13},{44.3,59.06},{44.33,58.95},{44.35,58.8},{44.37,58.62},{44.33,58.46},{44.24,58.34},{44.16,58.28},{44.08,58.2},{43.99,58.13},{43.91,58.04},{43.88,57.94},{43.86,57.85},{43.87,57.68},{43.87,57.58},{43.87,57.44},{43.88,57.34},{43.89,57.28},{43.97,57.15},{44.02,57.12},{44.17,57.04},{44.3,57.06},{44.42,57.05},{44.47,57.05},{44.54,57.06},{44.62,57.12},{44.7,57.21},{44.77,57.28},{44.81,57.32},{44.73,57.25},{44.7,57.2},{44.61,57.11},{44.54,57.06},{44.48,57.07},{44.32,57.04},{44.19,57.06},{44.07,57.1},{43.99,57.16},{43.91,57.29},{43.89,57.4},{43.87,57.48},},},141,nil,nil,82,nil,},
[2011] = {'Gnarlpine Augur',148,166,8,9,0,{[141]={{41.75,72.5},{41.37,73.88},{41.3,72.33},{41.31,72.68},{40.82,72.79},{56.3,75.29},{56.43,75.61},{56.56,75.5},{47.47,77.89},{46.22,58.38},{41.47,73.18},{45.03,61.3},{44.61,61.34},{44.94,61.48},{44.47,62.33},{44.53,62.71},{44.84,58.68},{44.88,58.64},{45.78,57.11},{45.86,57.02},{46.06,58.33},{46.22,58.19},{45.17,57.68},{44.68,59.0},{45.64,58.38},},},{[141]={{44.61,61.34},{44.55,61.37},{44.39,61.46},{44.28,61.52},{44.16,61.59},{44.08,61.64},{44.14,61.6},{44.28,61.52},{44.37,61.47},{44.48,61.4},{44.55,61.38},{44.47,62.33},{44.44,62.22},{44.4,62.12},{44.35,61.98},{44.32,61.82},{44.35,61.63},{44.38,61.48},{44.4,61.34},{44.42,61.08},{44.41,60.91},{44.38,60.73},{44.39,60.86},{44.4,61.12},{44.39,61.27},{44.35,61.56},{44.32,61.73},{44.34,61.9},{44.39,62.08},{44.43,62.2},{46.22,58.19},{46.25,58.06},{46.26,57.87},{46.22,57.61},{46.18,57.5},{46.14,57.42},{46.07,57.33},{46.03,57.28},{45.94,57.19},{46.04,57.28},{46.14,57.4},{46.17,57.45},{46.22,57.6},{46.24,57.7},{46.26,57.82},{46.26,57.92},{46.25,58.02},},},141,nil,nil,82,nil,},
[2012] = {'Gnarlpine Pathfinder',166,186,9,10,0,{[141]={{42.13,79.99},{42.4,79.89},{42.4,79.15},{38.79,78.39},{38.15,81.3},{38.16,80.38},{41.96,79.7},{42.01,80.16},{41.85,80.05},{38.62,80.25},{39.87,80.34},{40.27,80.1},{38.58,80.07},{41.36,77.94},},},nil,141,nil,nil,82,nil,},
[2013] = {'Gnarlpine Avenger',176,198,9,10,0,{[141]={{43.31,78.98},{38.7,79.52},{38.79,79.04},{41.28,79.03},{41.3,77.01},{41.51,79.44},{40.62,79.59},{40.63,79.1},{40.26,79.36},{40.05,79.68},{39.97,79.84},},},{[141]={{38.79,79.04},{38.73,79.43},{38.71,79.8},{38.69,80.04},{38.72,79.53},},},141,nil,nil,82,nil,},
[2014] = {'Gnarlpine Totemic',186,208,10,11,0,{[141]={{37.87,81.19},{38.4,80.78},{38.77,78.91},{39.37,80.2},{39.06,79.87},},},nil,141,nil,nil,82,nil,},
[2015] = {'Bloodfeather Harpy',156,176,8,9,0,{[141]={{37.87,43.67},{37.73,41.07},{37.21,42.97},{37.48,41.25},{38.56,40.54},{35.95,38.85},{36.75,38.86},{34.35,35.14},{37.32,43.68},{34.07,35.45},{35.03,34.9},},},nil,141,nil,nil,514,nil,},
[2017] = {'Bloodfeather Rogue',156,176,8,9,0,{[141]={{37.31,43.32},{37.8,44.69},{37.2,40.44},{36.57,41.75},{37.32,37.79},{35.99,37.82},{35.59,38.55},{35.47,36.98},{36.41,39.9},{35.44,37.75},{34.42,35.53},{35.18,35.08},{34.75,35.02},{34.33,34.08},{33.77,35.41},{35.47,34.95},{34.19,34.76},{37.34,41.67},{36.43,38.1},{36.75,37.67},},},nil,141,nil,nil,514,nil,},
[2018] = {'Bloodfeather Sorceress',160,160,9,9,0,{[141]={{37.88,43.01},{35.75,37.28},{34.37,34.42},{38.73,42.86},{35.23,38.9},},},nil,141,nil,nil,514,nil,},
[2019] = {'Bloodfeather Fury',176,198,9,10,0,{[141]={{32.67,29.58},{36.4,25.87},{33.37,29.33},{34.77,27.02},{34.31,28.34},},},nil,141,nil,nil,514,nil,},
[2020] = {'Bloodfeather Wind Witch',176,198,9,10,0,{[141]={{33.51,29.87},{33.11,30.01},{34.05,27.66},{37.31,28.03},{36.39,27.28},{36.75,27.9},{31.77,32.3},{33.1,29.25},{34.28,28.0},{32.58,32.61},},},nil,141,nil,nil,514,nil,},
[2021] = {'Bloodfeather Matriarch',208,208,11,11,0,{[141]={{32.82,30.49},{32.19,32.9},{32.86,29.99},{32.72,31.97},{31.44,31.59},{32.89,28.8},{36.24,28.3},{35.23,26.29},{34.18,27.25},{34.57,28.07},{34.14,29.86},{34.26,28.86},{32.21,32.37},},},nil,141,nil,nil,514,nil,},
[2022] = {'Timberling',102,120,5,6,0,{[141]={{60.02,72.16},{60.7,71.31},{60.08,70.0},{59.55,72.21},{61.53,69.35},{60.95,70.26},{62.21,68.64},{58.93,72.22},{59.67,64.32},{60.27,66.39},{60.81,67.76},{60.16,65.29},{58.45,64.29},{60.77,65.94},{57.61,66.02},{61.04,65.26},{60.92,67.77},{61.76,66.06},{57.62,65.12},{56.77,65.54},{60.06,64.47},{55.52,68.13},{57.03,64.67},{55.87,67.18},{55.25,66.48},{54.95,67.16},{54.26,66.18},{57.21,64.18},},},nil,141,nil,nil,14,nil,},
[2025] = {'Timberling Bark Ripper',137,156,7,8,0,{[141]={{54.47,69.84},{52.39,74.32},{52.51,69.26},{50.1,72.08},{52.61,72.23},{53.44,70.69},{51.17,73.56},{51.6,70.06},{52.53,73.41},{52.94,68.38},{48.71,72.52},{47.69,72.58},},},nil,141,nil,nil,14,nil,},
[2027] = {'Timberling Trampler',156,176,8,9,0,{[141]={{41.77,37.85},{42.48,38.68},{42.47,42.71},{53.71,75.32},{53.17,74.65},{41.85,41.79},{43.91,42.69},{43.76,40.71},{42.45,40.71},{43.91,39.19},{52.97,74.14},{52.84,74.66},},},{[141]={{53.17,74.65},{53.31,74.79},{53.41,74.89},{53.55,75.03},{53.55,75.04},{53.38,74.86},{53.3,74.79},},},141,nil,nil,14,nil,},
[2029] = {'Timberling Mire Beast',176,198,9,10,0,{[141]={{41.87,33.92},{43.87,34.89},{42.48,36.78},{42.97,33.65},{43.19,30.12},{42.49,32.96},{43.39,35.83},{43.17,31.91},{42.49,34.52},},},nil,141,nil,nil,14,nil,},
[2030] = {'Elder Timberling',186,208,10,11,0,{[141]={{45.02,26.56},{43.87,26.99},{44.49,26.01},{44.43,27.86},{42.53,28.86},{43.19,26.01},{43.89,25.94},{43.21,27.89},{43.86,28.94},},},nil,141,nil,nil,14,nil,},
[2031] = {'Young Nightsaber',42,42,1,1,0,{[141]={{63.35,42.14},{64.37,40.47},{61.48,39.3},{64.32,42.03},{61.99,42.93},{62.64,42.31},{58.39,46.73},{56.62,44.52},{62.02,42.89},{61.58,44.19},{61.61,40.94},{62.56,41.7},{62.18,45.44},{62.3,44.3},{61.97,42.82},{58.81,45.95},{58.43,45.56},{60.3,45.99},{60.61,45.03},{61.09,45.13},{61.38,44.51},{57.86,38.95},{61.86,44.22},{57.87,44.69},{61.48,41.62},},},nil,141,nil,nil,7,"AH",},
[2032] = {'Mangy Nightsaber',55,55,2,2,0,{[141]={{60.0,36.04},{63.44,38.79},{62.36,39.03},{62.3,37.99},{62.16,39.01},{62.04,36.87},{62.73,37.86},{62.38,37.04},{63.01,37.01},{61.25,39.08},{59.52,35.79},{58.93,35.87},{59.18,31.46},{59.84,34.21},{60.69,35.54},{60.98,34.68},{62.56,34.43},{61.73,35.17},{62.86,36.47},{60.55,34.34},{60.31,36.12},{60.82,35.68},{62.47,38.25},},},nil,141,nil,nil,7,"AH",},
[2033] = {'Elder Nightsaber',156,176,8,9,0,{[141]={{45.16,42.64},{39.79,44.49},{45.72,40.97},{45.13,36.66},{39.65,35.41},{45.8,37.85},{35.29,29.79},{45.8,33.76},{44.57,37.67},{35.87,29.2},{46.34,44.53},{39.51,35.16},{46.9,45.56},{34.72,30.96},{46.02,40.95},},},nil,141,nil,nil,66,nil,},
[2034] = {'Feral Nightsaber',198,222,10,11,0,{[141]={{40.65,27.37},{38.03,29.32},{41.34,25.13},{39.91,28.69},{38.34,26.77},{37.37,24.78},},},nil,141,nil,nil,66,nil,},
[2038] = {'Lord Melenas',148,148,8,8,0,{[141]={{51.23,50.8},{51.31,50.19},{52.82,50.21},},},nil,141,nil,nil,90,nil,},
[2039] = {'Ursal the Mauler',247,247,12,12,0,{[141]={{38.83,79.81},},},{[141]={{38.82,79.69},{38.8,79.58},{38.79,79.48},{38.81,79.56},{38.85,79.8},{38.92,79.91},{39.11,80.03},{39.24,80.1},{39.24,80.14},{39.04,80.18},{38.92,80.32},{38.77,80.45},{38.71,80.32},{38.76,80.2},{38.85,79.89},},},141,nil,nil,82,nil,},
[2041] = {'Ancient Protector',6075,6075,60,60,0,{[141]={{57.24,57.41},{36.83,55.27},},[1657]={{84.4,36.08},},},{[141]={{57.23,58.2},{57.05,58.63},{57.1,59.15},{57.2,59.8},{57.09,60.44},{57.13,59.51},{56.92,59.02},{56.8,58.36},{56.76,57.93},{56.82,57.43},{34.73,54.46},{34.73,54.46},{34.81,55.34},{34.81,55.34},{34.21,55.86},{33.72,55.7},{33.25,55.71},{32.53,55.66},{32.53,55.66},{32.58,54.89},{32.58,54.89},{33.18,54.99},{33.54,54.96},{33.86,54.96},{34.16,55.08},},[1657]={{84.31,36.17},{84.31,36.17},{84.66,40.4},{84.66,40.4},{81.81,42.92},{79.42,42.13},{77.17,42.2},{73.73,41.96},{73.73,41.96},{73.96,38.23},{73.96,38.23},{76.83,38.72},{78.59,38.57},{80.12,38.6},{81.55,39.16},},},141,nil,nil,80,"A",},
[2042] = {'Nightsaber',102,120,5,6,0,{[141]={{67.25,51.25},{66.2,51.18},{65.6,53.46},{49.73,52.44},{68.76,55.38},{64.14,56.04},{48.49,49.96},{49.71,55.3},{51.5,62.28},{50.83,57.26},{51.49,60.22},{48.69,50.41},{49.32,51.11},{52.86,58.53},{50.97,59.17},{54.27,63.29},{52.8,62.3},{54.8,65.15},{50.96,61.37},{62.79,61.04},{66.97,54.31},{68.0,53.98},{61.53,59.02},{62.16,61.69},{62.11,60.1},{59.55,62.99},{59.37,61.72},{53.63,55.61},{49.84,55.82},{62.77,60.29},{50.98,57.43},{52.95,62.61},{50.87,61.49},{51.66,59.27},{53.68,63.21},{51.77,62.32},{51.64,60.23},{58.69,58.28},{59.61,63.33},{59.54,61.4},{57.64,54.67},},},nil,141,nil,nil,66,nil,},
[2043] = {'Nightsaber Stalker',137,156,7,8,0,{[141]={{38.89,58.14},{63.42,72.17},{46.59,71.34},{62.19,72.1},{63.53,71.26},{53.9,72.51},{50.94,77.15},{56.93,73.92},{38.24,58.56},{44.96,74.6},{43.15,74.32},{40.44,69.86},{61.46,73.32},{47.09,70.9},{40.42,69.13},{39.89,69.3},{62.57,72.75},{50.63,79.0},{45.81,75.68},{55.79,72.27},{50.31,76.14},{50.0,79.15},{46.97,75.11},{38.49,56.22},{49.71,77.11},{40.13,55.84},{45.19,72.09},{41.17,70.15},{40.79,57.03},{40.5,55.57},{40.66,59.46},{63.42,70.18},},},nil,141,nil,nil,66,nil,},
[2044] = {'Forlorn Spirit',597,681,25,26,0,nil,nil,0,nil,nil,77,nil,},
[2046] = {'Andrew Krighton',334,334,8,8,0,{[12]={{41.7,65.86},},},{[12]={{41.7,65.86},{41.67,65.87},{41.67,65.87},},[40]={{83.68,2.75},{83.64,2.76},{83.64,2.76},},},12,nil,nil,12,"A",},
[2050] = {'Raleigh Andrean',594,594,14,14,0,{[1497]={{62.01,42.75},},},nil,1497,{530,},{441,530,},68,"H",},
[2053] = {'Haggard Refugee',414,522,18,19,0,{[130]={{44.4,84.48},{44.33,84.41},{46.08,85.63},{45.54,85.99},{45.63,86.03},{46.39,86.63},{47.18,86.32},{46.32,86.49},{45.3,84.76},{46.81,85.59},{47.63,86.09},{46.75,85.7},{46.52,85.49},{45.94,84.05},},},nil,130,nil,nil,123,"A",},
[2054] = {'Sickly Refugee',400,432,19,20,0,{[130]={{44.45,84.36},{44.2,83.52},{45.57,86.14},{45.58,86.06},{46.37,86.54},{46.35,85.96},{44.98,82.79},{47.12,86.31},{46.47,85.57},{45.24,84.75},{46.73,85.59},{45.96,85.77},{46.93,85.21},},},nil,130,nil,nil,123,"A",},
[2055] = {'Master Apothecary Faranell',3517,3517,50,50,0,{[1497]={{48.82,69.28},},},nil,1497,{450,515,1109,1113,},{447,451,513,1109,1113,2938,},68,"H",},
[2056] = {'Ravenclaw Apparition',1172,1172,24,24,0,nil,nil,0,nil,nil,35,"AH",},
[2057] = {'Huldar',644,644,15,15,0,{[38]={{52.19,69.32},},},nil,38,{454,},{273,},57,"A",},
[2058] = {'Deathstalker Faerleia',1251,1251,18,18,0,{[130]={{46.5,74.39},},},nil,130,{452,},{452,},68,"H",},
[2060] = {'Councilman Smithers',741,741,12,12,1,nil,nil,0,nil,nil,16,nil,},
[2061] = {'Councilman Thatcher',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,},
[2062] = {'Councilman Hendricks',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,},
[2063] = {'Councilman Wilhelm',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,},
[2064] = {'Councilman Hartin',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,},
[2065] = {'Councilman Cooper',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,},
[2066] = {'Councilman Higarth',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,},
[2067] = {'Councilman Brunswick',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,},
[2068] = {'Lord Mayor Morrison',984,984,15,15,1,nil,nil,0,nil,nil,16,nil,},
[2069] = {'Moonstalker',300,328,14,15,0,{[148]={{55.12,21.43},{55.42,20.85},{55.51,21.55},{54.67,21.93},{44.35,67.39},{43.59,69.93},{44.55,68.7},{40.15,67.45},{42.66,72.09},{40.58,70.03},{40.02,69.35},{39.02,72.43},{39.7,69.32},{39.93,70.62},{52.74,29.42},{43.53,67.77},{37.47,63.38},{41.0,67.37},{39.19,69.23},{40.04,65.98},{37.47,78.99},{39.44,67.76},{44.64,24.76},{38.98,66.76},{38.6,64.52},{41.87,67.67},{37.97,59.74},{43.14,67.5},{44.08,66.05},{55.5,23.29},{50.55,27.04},{38.05,77.46},{39.02,70.64},{48.98,27.75},{49.36,26.65},{41.77,71.48},{39.38,63.84},{37.54,77.25},{42.36,64.22},{53.26,27.2},{53.79,27.85},{54.94,30.1},{50.78,28.56},{43.81,65.65},{48.87,25.47},{42.2,67.37},{38.55,77.51},{49.2,32.46},{51.74,25.63},},},nil,148,nil,nil,14,nil,},
[2070] = {'Moonstalker Runt',356,386,16,17,0,{[148]={{47.21,40.85},{61.04,13.04},{47.25,44.52},{44.13,43.82},{44.82,42.65},{43.57,28.95},{45.17,28.01},{42.9,90.32},{39.41,39.07},{41.0,43.04},{37.47,92.99},{47.92,40.12},{44.31,27.66},{44.75,41.21},{48.66,24.26},{40.49,41.22},{46.5,54.2},{48.26,38.8},{40.26,41.08},{46.41,52.43},{42.64,43.19},{39.62,33.44},{42.01,48.18},{46.38,42.13},{43.96,55.73},{45.25,58.79},{40.07,33.21},{35.17,89.68},{44.59,55.68},{45.02,57.24},{42.04,54.49},{39.73,40.42},{39.4,39.69},{40.08,50.06},{45.26,57.61},{44.53,58.19},{42.99,26.12},{46.17,23.72},{42.66,25.9},{39.18,34.29},{43.15,54.65},{39.58,37.76},{44.66,24.31},{45.49,33.28},{39.76,91.77},{39.55,90.54},{42.06,45.27},{45.1,24.77},{45.69,31.72},{44.86,29.28},{46.26,23.99},{45.16,56.13},{38.77,50.73},{38.06,36.86},{43.55,24.25},{38.87,48.78},{38.04,50.06},{61.0,11.86},{59.61,11.75},{62.61,6.99},},},nil,148,nil,nil,14,nil,},
[2071] = {'Moonstalker Matriarch',449,484,19,20,0,{[148]={{60.92,13.41},{43.03,90.77},{37.21,93.4},{34.99,88.84},{36.47,90.45},{36.89,89.68},{39.41,91.8},{39.85,90.34},{59.9,11.78},{60.96,11.87},{62.92,7.31},{62.5,6.67},},},nil,148,nil,nil,14,nil,},
[2077] = {'Melithar Staghelm',166,166,5,5,0,{[141]={{59.92,42.47},},},nil,141,{458,},nil,80,"A",},
[2078] = {'Athridas Bearmantle',456,456,11,11,0,{[141]={{55.96,57.27},},},nil,141,{475,483,486,},{476,483,486,},80,"A",},
[2079] = {'Conservator Ilthalaine',138,138,4,4,0,{[141]={{58.69,44.27},},},nil,141,{456,457,3116,3117,3118,3119,3120,},{456,457,},80,"A",},
[2080] = {'Denalan',456,456,11,11,0,{[141]={{60.9,68.49},},},nil,141,{918,919,922,941,2499,},{918,919,927,930,931,997,2498,2499,},80,"A",},
[2081] = {'Sentinel Kyra Starsong',500,500,12,12,0,{[141]={{56.0,59.52},},},nil,141,nil,nil,80,"A",},
[2082] = {'Gilshalan Windwalker',372,372,9,9,0,{[141]={{57.81,41.65},},},nil,141,{916,917,920,},{916,917,},80,"A",},
[2083] = {'Syral Bladeleaf',500,500,12,12,0,{[141]={{56.08,57.72},},},nil,141,{489,997,1581,},{1581,},80,"A",},
[2084] = {'Natheril Raincaller',3749,3749,57,57,0,{[618]={{51.45,30.83},},},nil,618,nil,nil,80,"A",},
[2086] = {'Valstag Ironjaw',1240,1240,25,25,0,{[11]={{10.1,56.9},},},nil,11,{473,},{455,},55,"A",},
[2089] = {'Giant Wetlands Crocolisk',734,768,25,26,0,{[11]={{18.37,27.04},{17.61,29.11},{19.22,22.95},{22.42,20.87},{21.73,20.02},{19.03,24.79},{16.98,26.86},{16.19,26.23},{17.49,23.54},{15.25,29.22},{26.13,22.57},{20.58,24.17},{27.01,19.36},},},nil,11,nil,nil,14,nil,},
[2090] = {'Ma\'ruk Wyrmscale',617,617,23,23,4,{[11]={{48.06,74.7},},},nil,11,nil,nil,62,nil,},
[2091] = {'Chieftain Nek\'rosh',3171,3171,32,32,1,{[11]={{53.47,54.65},},},nil,11,nil,nil,62,nil,},
[2092] = {'Pilot Longbeard',1106,1106,23,23,0,{[1537]={{72.73,94.01},},},nil,1537,{1179,},{708,},55,"A",},
[2093] = {'Einar Stonegrip',919,919,20,20,0,{[11]={{49.92,39.37},},},nil,11,{469,},nil,55,"A",},
[2094] = {'James Halloran',1240,1240,25,25,0,{[11]={{8.55,55.74},},},nil,11,{471,484,},{469,471,484,},12,"A",},
[2096] = {'Tarrel Rockweaver',633,633,25,25,0,{[11]={{11.5,52.13},},},nil,11,{305,},{306,},55,"A",},
[2097] = {'Harlo Barnaby',1240,1240,25,25,0,{[11]={{10.85,55.9},},},nil,11,{472,},nil,55,"A",},
[2098] = {'Ram',164,164,5,5,0,{[1]={{58.17,7.75},{57.99,8.09},},[11]={{16.28,71.97},{16.06,72.38},{50.3,73.2},{52.42,68.67},{48.28,65.63},{50.61,74.84},{49.01,72.35},{56.39,84.19},{49.97,68.03},{48.28,70.72},{47.86,67.69},},[38]={{52.57,71.9},{31.78,15.93},{27.25,12.18},{30.26,12.36},{38.36,32.48},{28.63,57.76},{58.94,63.8},},[36]={{72.35,42.96},{67.66,42.7},{48.03,29.26},{40.08,35.01},{66.43,53.66},{36.82,44.73},{61.94,29.09},},[45]={{91.35,70.01},{91.01,70.2},},},nil,11,nil,nil,190,"AH",},
[2099] = {'Maiden\'s Virtue Crewman',484,484,20,20,0,{[11]={{4.89,57.44},{5.57,64.08},{9.78,61.33},{8.26,61.74},{10.23,62.06},{5.76,64.12},{8.42,61.49},{5.06,62.46},{5.57,63.73},{8.74,59.4},{7.49,57.43},{6.56,63.28},{5.84,58.34},},},nil,11,nil,nil,57,"A",},
[2102] = {'Dragonmaw Grunt',494,531,20,21,0,{[11]={{48.52,65.97},{47.61,66.49},{49.27,82.64},{48.06,75.52},{47.17,77.07},{49.99,77.01},{48.72,77.26},{51.5,78.47},{47.81,74.71},{47.84,74.35},{49.13,80.09},{48.2,75.83},{47.61,75.58},{47.37,75.76},{47.47,75.12},{47.23,76.07},{49.86,69.58},},},nil,11,nil,nil,62,nil,},
[2103] = {'Dragonmaw Scout',449,484,19,20,0,{[11]={{49.93,76.12},{50.7,76.92},{51.2,79.52},{49.3,76.95},{47.47,76.46},{47.67,76.82},{48.23,74.72},{48.19,74.03},{47.77,74.24},{50.08,79.55},{49.64,79.02},{48.92,78.94},{48.24,78.24},{49.34,79.75},{47.89,77.19},{47.95,76.2},{47.88,75.88},},},{[1]={{85.62,13.52},{85.41,13.39},{85.14,13.09},{84.95,12.77},{84.83,12.38},{84.76,11.95},{84.72,11.59},{84.47,11.25},{84.48,10.87},{84.68,11.22},{84.71,11.64},{84.77,12.04},{84.81,12.39},{84.96,12.82},{85.16,13.13},{85.37,13.35},},[11]={{48.97,78.84},{48.73,78.69},{48.4,78.33},{48.17,77.95},{48.03,77.48},{47.95,76.97},{47.89,76.54},{47.6,76.14},{47.62,75.68},{47.85,76.11},{47.89,76.6},{47.96,77.08},{48.01,77.49},{48.18,78.01},{48.42,78.38},{48.67,78.64},},},11,nil,nil,62,nil,},
[2104] = {'Captain Stoutfist',2016,2016,35,35,0,{[11]={{9.86,57.49},},},nil,11,{464,465,},{464,473,474,},55,"A",},
[2105] = {'Mountaineer Dokkin',2081,2081,30,30,0,{[38]={{25.28,0.17},},},{[1]={{91.24,18.66},{91.24,18.93},{91.25,19.33},{91.27,19.9},{91.28,20.46},{91.29,20.92},{91.32,21.47},{91.33,22.02},{91.34,22.56},{91.35,23.08},{91.37,23.58},{91.38,23.99},{91.39,24.31},{91.38,23.98},{91.37,23.61},{91.36,23.14},{91.34,22.59},{91.33,22.01},{91.31,21.49},{91.3,20.98},{91.28,20.39},{91.27,19.84},{91.25,19.31},},[11]={{55.66,84.97},{55.67,85.29},{55.68,85.77},{55.7,86.44},{55.71,87.1},{55.73,87.66},{55.75,88.31},{55.77,88.97},{55.78,89.61},{55.8,90.23},{55.82,90.83},{55.83,91.31},{55.84,91.69},{55.83,91.3},{55.82,90.87},{55.81,90.3},{55.79,89.65},{55.77,88.96},{55.75,88.34},{55.73,87.73},{55.72,87.02},{55.7,86.37},{55.68,85.74},},[38]={{25.29,0.12},{25.3,0.61},{25.32,1.32},{25.35,2.33},{25.37,3.33},{25.39,4.16},{25.43,5.13},{25.46,6.13},{25.48,7.08},{25.5,8.01},{25.53,8.91},{25.55,9.64},{25.56,10.2},{25.55,9.61},{25.53,8.97},{25.51,8.11},{25.48,7.14},{25.45,6.11},{25.42,5.17},{25.4,4.26},{25.37,3.21},{25.34,2.23},{25.32,1.28},},},38,nil,nil,57,"A",},
[2106] = {'Apothecary Berard',1068,1068,16,16,1,{[130]={{42.89,73.36},},},nil,130,nil,nil,14,nil,},
[2107] = {'Gaerolas Talvethren',228,228,7,7,0,{[141]={{66.26,58.52},},},nil,141,{476,},{475,},80,"A",},
[2108] = {'Garneg Charskull',812,812,29,29,4,{[11]={{38.42,46.06},},},nil,11,nil,nil,62,nil,},
[2110] = {'Black Rat',1,1,1,1,0,{[10]={{24.46,59.89},{58.81,69.22},{57.22,78.87},{66.57,54.77},{21.81,54.42},{15.41,63.73},{73.99,30.91},{75.56,57.84},{65.07,59.18},{77.27,54.03},{70.16,61.14},{73.69,54.32},{19.35,60.46},{68.66,52.29},{43.79,71.82},{51.17,67.34},{36.05,64.97},{41.62,64.37},{41.67,64.34},{43.97,71.98},{71.69,37.61},{30.66,61.32},},[209]={{-1, -1}},[722]={{-1, -1}},[28]={{45.73,69.62},{42.08,61.15},{37.69,55.68},{63.89,58.34},{50.0,75.47},{49.4,66.74},{49.7,78.2},{53.78,44.76},{43.7,66.35},{46.19,53.32},{52.71,78.63},{61.68,58.45},{47.54,64.33},{47.28,69.82},{49.76,45.46},{38.24,72.13},{53.24,66.57},{41.12,70.54},{41.21,72.8},{49.84,45.63},},[2057]={{-1, -1}},[1583]={{-1, -1}},[1]={{58.29,7.12},{61.51,5.21},},[11]={{16.43,71.22},{20.26,68.95},},},nil,10,nil,nil,31,"AH",},
[2111] = {'Sida',919,919,20,20,0,{[11]={{11.8,57.99},},},nil,11,{470,},{470,},55,"A",},
[2112] = {'Farrin Daris',804,804,18,18,0,{[10]={{73.63,43.46},},},nil,10,nil,nil,12,"A",},
[2113] = {'Archibald Kava',166,166,5,5,0,{[85]={{32.41,65.66},},},nil,85,nil,nil,68,"H",},
[2114] = {'Faruza',166,166,5,5,0,{[85]={{59.79,52.12},},},nil,85,nil,nil,68,"H",},
[2115] = {'Joshua Kien',166,166,5,5,0,{[85]={{32.29,65.44},},},nil,85,nil,nil,68,"H",},
[2116] = {'Blacksmith Rand',166,166,5,5,0,{[85]={{32.38,66.23},},},nil,85,nil,nil,68,"H",},
[2117] = {'Harold Raims',166,166,5,5,0,{[85]={{32.4,66.43},},},nil,85,nil,nil,68,"H",},
[2118] = {'Abigail Shiel',372,372,9,9,0,{[85]={{61.03,52.37},},},nil,85,nil,nil,68,"H",},
[2119] = {'Dannal Stern',166,166,5,5,0,{[85]={{32.69,65.56},},},nil,85,nil,{3095,},68,"H",},
[2120] = {'Archmage Ataeric',472,472,22,22,0,{[130]={{63.4,64.27},},},nil,130,nil,nil,76,"AH",},
[2121] = {'Shadow Priest Allister',919,919,20,20,0,{[130]={{43.98,40.93},},},nil,130,{477,479,480,481,516,},{478,479,480,482,516,},68,"H",},
[2122] = {'David Trias',166,166,5,5,0,{[85]={{32.53,65.65},},},nil,85,nil,{3096,},68,"H",},
[2123] = {'Dark Cleric Duesten',166,166,5,5,0,{[85]={{31.11,66.03},},},nil,85,{5651,},{3097,},68,"H",},
[2124] = {'Isabella',166,166,5,5,0,{[85]={{30.93,66.06},},},nil,85,nil,{3098,},68,"H",},
[2126] = {'Maximillion',166,166,5,5,0,{[85]={{30.91,66.34},},},nil,85,nil,{3099,},68,"H",},
[2127] = {'Rupert Boch',644,644,15,15,0,{[85]={{61.59,52.4},},},nil,85,nil,nil,68,"H",},
[2128] = {'Cain Firesong',594,594,14,14,0,{[85]={{61.97,52.47},},},nil,85,{1881,},nil,68,"H",},
[2129] = {'Dark Cleric Beryl',748,748,17,17,0,{[85]={{61.57,52.19},},},nil,85,{5650,5663,},{5650,5651,},68,"H",},
[2130] = {'Marion Call',546,546,13,13,0,{[85]={{61.75,52.0},},},nil,85,{1885,},nil,68,"H",},
[2131] = {'Austil de Mon',695,695,16,16,0,{[85]={{61.85,52.54},},},nil,85,{1818,},nil,68,"H",},
[2132] = {'Carolai Anise',1240,1240,25,25,0,{[85]={{59.43,52.19},},},nil,85,nil,nil,68,"H",},
[2134] = {'Mrs. Winters',413,413,10,10,0,{[85]={{61.16,52.6},},},nil,85,nil,nil,68,"H",},
[2135] = {'Abe Winters',500,500,12,12,0,{[85]={{60.22,53.1},},},nil,85,nil,nil,68,"H",},
[2136] = {'Oliver Dwor',546,546,13,13,0,{[85]={{60.13,53.4},},},nil,85,nil,nil,68,"H",},
[2137] = {'Eliza Callen',500,500,12,12,0,{[85]={{60.31,52.82},},},nil,85,nil,nil,68,"H",},
[2140] = {'Edwin Harly',860,860,19,19,0,{[130]={{43.98,39.9},},},nil,130,nil,nil,68,"H",},
[2142] = {'Watcher Callahan',1764,1764,32,32,0,{[10]={{81.92,19.69},},},nil,10,nil,nil,12,"A",},
[2149] = {'Dark Iron Raider',300,300,14,14,0,nil,nil,0,nil,nil,54,nil,},
[2150] = {'Zenn Foulhoof',228,228,7,7,0,{[141]={{60.46,56.3},},},nil,141,{488,},{488,489,},80,"A",},
[2151] = {'Moon Priestess Amara',709,709,25,25,0,{[141]={{54.63,58.46},},},{[141]={{54.47,58.44},{53.92,58.13},{53.64,57.63},{53.36,57.44},{53.08,57.4},{52.91,57.2},{52.68,56.69},{52.38,56.47},{52.06,56.37},{51.69,56.42},{51.45,56.58},{51.26,56.63},{51.03,56.58},{50.66,56.25},{50.53,56.0},{50.47,55.74},{50.45,55.42},{50.49,54.72},{50.47,54.36},{50.37,54.06},{50.2,53.82},{49.77,53.37},{50.2,53.82},{50.37,54.06},{50.47,54.36},{50.49,54.72},{50.45,55.42},{50.47,55.74},{50.53,56.0},{50.66,56.25},{51.03,56.58},{51.26,56.63},{51.45,56.58},{51.69,56.42},{52.06,56.37},{52.38,56.47},{52.68,56.69},{52.91,57.2},{53.08,57.4},{53.36,57.44},{53.64,57.63},{53.92,58.13},{54.47,58.44},{54.63,58.46},{54.96,58.47},{55.25,58.47},{55.58,58.43},{55.23,58.46},{54.96,58.47},{54.63,58.45},},},141,{487,},{487,},79,"A",},
[2152] = {'Gnarlpine Ambusher',120,137,6,7,0,{[141]={{46.15,51.14},{46.3,52.16},{45.9,52.46},{45.86,54.52},{47.86,53.26},{45.21,54.63},{45.51,52.91},{46.7,52.47},{46.33,52.75},{45.75,53.59},{48.46,54.1},{46.27,54.22},{48.29,53.55},{46.47,53.42},{46.8,54.39},},},{[141]={{46.3,52.17},{46.29,51.83},{46.27,51.57},{46.28,51.42},{46.28,51.73},{46.29,51.89},},},141,nil,nil,82,nil,},
[2153] = {'Terl Arakor',1240,1240,25,25,0,{[11]={{27.43,41.2},},},nil,11,nil,nil,123,"A",},
[2155] = {'Sentinel Shayla Nightbreeze',334,334,8,8,0,{[141]={{42.22,51.27},},},{[141]={{42.29,51.38},{42.1,51.33},{41.81,51.17},{41.43,50.96},{41.0,50.8},{40.55,50.76},{40.15,50.85},{39.85,51.24},{39.58,51.67},{39.39,52.24},{39.19,52.82},{38.96,53.3},{38.6,53.94},{38.18,54.42},{37.84,54.51},{37.33,54.45},{36.77,54.47},{36.49,54.5},{36.48,54.41},{36.93,54.38},{37.46,54.4},{37.9,54.43},{38.36,54.24},{38.73,53.67},{39.08,53.12},{39.32,52.4},{39.43,51.93},{39.66,51.46},{39.95,51.05},{40.17,50.77},{40.44,50.74},{40.84,50.75},{41.32,50.89},{41.73,51.1},{42.02,51.26},},[1657]={{99.24,36.39},{96.79,36.11},{94.1,36.24},{92.74,36.35},{92.73,35.95},{94.88,35.81},{97.44,35.87},{99.55,36.04},},},141,nil,nil,80,"A",},
[2156] = {'Cracked Golem',354,382,18,19,0,{[148]={{35.99,85.97},{36.0,85.5},{35.09,84.93},{35.57,84.08},{35.34,84.5},{35.68,85.67},},},nil,148,nil,nil,14,nil,},
[2157] = {'Stone Behemoth',382,411,19,20,0,{[148]={{36.18,86.39},{36.23,85.9},{35.49,85.03},},},{[148]={{36.25,85.92},{36.23,86.09},{36.13,86.22},{36.02,86.19},{36.02,86.19},{35.89,85.93},{35.68,85.5},{35.68,85.5},{35.82,85.75},{36.04,86.17},{36.15,86.23},{36.21,86.09},{36.22,85.9},{36.2,85.64},{36.23,85.71},},[331]={{19.64,2.37},{19.62,2.57},{19.5,2.72},{19.38,2.68},{19.38,2.68},{19.23,2.39},{19.0,1.9},{19.0,1.9},{19.15,2.18},{19.41,2.66},{19.53,2.73},{19.6,2.58},{19.61,2.35},{19.59,2.06},{19.62,2.14},},[361]={{18.68,66.56},{18.66,66.77},{18.54,66.91},{18.42,66.88},{18.42,66.88},{18.28,66.58},{18.04,66.09},{18.04,66.09},{18.19,66.37},{18.45,66.85},{18.57,66.93},{18.64,66.77},{18.65,66.55},{18.63,66.25},{18.66,66.33},},},148,nil,nil,14,nil,},
[2158] = {'Gravelflint Scout',417,449,18,19,0,nil,nil,0,nil,nil,59,nil,},
[2159] = {'Gravelflint Bonesnapper',449,484,19,20,0,nil,nil,0,nil,nil,22,nil,},
[2160] = {'Gravelflint Geomancer',413,441,21,21,0,nil,nil,0,nil,nil,22,nil,},
[2162] = {'Agal',155,155,8,8,0,{[141]={{46.27,51.04},},},nil,141,nil,nil,82,nil,},
[2163] = {'Thistle Bear',278,309,11,12,0,{[148]={{44.44,31.62},{44.85,27.16},{45.84,41.74},{43.19,44.2},{45.07,32.29},{45.68,28.86},{44.63,28.64},{47.26,23.73},{44.6,43.21},{44.55,33.37},{42.56,55.8},{47.64,23.77},{41.09,34.13},{45.68,41.52},{45.68,55.29},{48.68,22.19},{43.2,56.42},{40.16,36.5},{40.2,36.84},{41.56,33.88},{39.91,39.49},{38.4,38.59},{40.5,38.41},{38.65,38.26},{43.68,29.42},{43.42,34.66},{40.35,40.32},{44.14,32.45},{49.04,38.33},{43.75,42.7},{41.61,34.8},{46.31,54.79},{45.58,43.55},{47.05,41.85},{43.18,42.62},{44.4,25.94},{45.06,43.77},{43.71,42.74},{43.52,41.89},{38.35,38.77},{41.12,41.88},{45.54,29.86},{43.75,32.36},{44.65,60.2},{45.98,26.56},{44.27,31.05},{43.37,33.37},{43.5,29.97},{45.82,22.97},{41.96,47.07},{42.93,24.93},{43.51,25.79},{42.64,47.9},{43.39,26.92},{44.58,29.85},{44.82,30.82},{45.93,26.4},{43.08,22.92},{45.64,23.85},{46.78,22.6},{45.18,23.64},{41.57,47.97},{43.47,22.59},{42.93,54.81},{38.03,48.63},{45.25,26.37},{44.95,33.93},{44.45,24.67},{39.16,37.16},{39.5,36.34},{40.48,38.02},{43.56,54.94},{45.58,26.0},{46.75,25.43},{40.37,35.0},{48.16,40.78},{47.96,23.44},{46.17,24.88},{41.64,56.94},{41.02,48.47},{38.09,47.02},},},nil,148,nil,nil,44,nil,},
[2164] = {'Rabid Thistle Bear',341,375,13,14,0,{[148]={{44.73,32.97},{44.99,66.82},{39.79,75.81},{51.23,35.52},{46.73,33.51},{48.44,35.61},{44.7,29.35},{43.74,25.43},{40.61,75.84},{48.6,35.21},{49.38,33.44},{45.53,31.14},{46.75,34.42},{38.08,67.73},{50.87,31.09},{44.64,63.0},{47.5,34.09},{47.69,24.52},{38.88,66.05},{38.51,68.24},{44.04,31.09},{38.66,72.84},{52.8,25.58},{46.56,24.93},{49.21,35.44},{52.84,27.68},{38.58,65.76},{51.18,34.45},{53.8,25.64},{38.98,61.5},{39.21,59.71},{40.09,58.31},{47.9,34.57},{50.07,30.98},{38.08,56.59},{38.27,61.66},{52.58,28.78},{50.82,30.16},{38.47,60.73},{39.58,61.81},{38.33,58.37},{37.69,73.97},{49.23,29.28},{39.05,76.7},{38.06,69.5},{53.36,28.97},{39.59,68.31},{38.16,70.61},{39.22,65.34},{40.52,76.43},{39.48,60.81},{39.48,59.49},{47.46,28.51},{43.01,22.76},{39.31,63.3},{50.37,27.82},{47.59,33.05},{48.43,33.43},{48.38,26.26},{47.14,31.22},{47.14,32.38},{45.94,24.41},{48.95,31.07},{38.54,79.01},{50.19,25.67},{44.38,23.57},{51.84,32.5},{37.61,73.19},{48.61,27.11},{38.72,58.88},{38.62,70.19},{45.14,26.48},{41.03,66.24},{44.1,70.56},{42.99,64.7},{37.85,72.3},{44.12,69.19},{42.41,68.3},{49.65,27.4},{39.54,71.01},{49.71,25.61},{42.33,65.5},{38.42,74.42},{47.25,28.2},{38.21,52.59},{38.41,74.97},{38.21,65.52},{48.37,30.96},{43.1,70.68},{38.37,71.79},{39.03,64.27},{40.49,71.05},{43.14,69.05},{38.55,57.72},{41.67,65.21},{41.41,63.24},{38.57,54.62},{54.38,29.47},{51.78,31.77},{42.11,66.07},{53.22,26.31},},},nil,148,nil,nil,44,nil,},
[2165] = {'Grizzled Thistle Bear',445,482,16,17,0,{[148]={{45.05,81.41},{40.29,75.88},{38.04,82.05},{37.54,82.03},{40.47,81.77},{40.08,79.78},{40.43,81.13},{38.61,82.44},{38.23,71.1},{39.07,69.96},{39.8,80.77},{39.72,82.05},{39.3,81.36},{39.14,76.33},{37.83,78.61},{38.6,80.49},{41.06,81.28},{37.67,79.82},{42.96,82.45},},},nil,148,nil,nil,44,nil,},
[2166] = {'Oakenscowl',528,528,9,9,1,{[141]={{53.76,75.12},},},nil,141,nil,nil,14,nil,},
[2167] = {'Blackwood Pathfinder',230,253,12,13,0,{[148]={{39.58,56.3},{40.23,56.31},{39.16,56.38},{39.34,52.24},{39.63,53.1},{39.89,56.37},{39.21,53.01},{39.33,53.67},{39.81,53.4},{39.08,53.41},{39.66,54.35},{39.84,53.94},},},{[148]={{39.35,52.22},{39.25,52.37},{39.19,52.58},{39.26,52.31},{39.3,52.13},{39.24,51.87},{39.13,51.59},{39.2,51.78},{39.31,52.08},},[361]={{22.21,28.18},{22.11,28.35},{22.03,28.59},{22.11,28.29},{22.16,28.08},{22.09,27.79},{21.97,27.46},{22.04,27.68},{22.17,28.02},},},148,nil,nil,82,nil,},
[2168] = {'Blackwood Warrior',356,386,16,17,0,{[148]={{42.84,84.46},{42.52,86.36},{42.67,85.48},{50.8,34.5},{50.56,34.3},{50.36,34.56},{51.23,35.19},{51.11,34.54},{50.98,35.0},{39.89,79.11},{39.88,77.6},{40.21,78.85},{52.78,34.09},{52.43,34.21},{52.03,33.9},{53.08,33.49},{52.52,33.53},{52.12,33.1},{52.76,32.98},{51.78,33.25},{39.54,77.97},{39.36,78.51},{40.19,77.91},{39.71,78.76},{40.69,77.76},{52.37,32.71},{50.7,35.2},},},{[148]={{40.67,77.82},{40.53,77.78},{40.35,77.73},{40.21,77.54},{40.13,77.34},{40.07,77.06},{40.16,76.87},{40.28,76.91},{40.36,77.08},{40.5,77.26},{40.66,77.27},{40.8,77.29},{40.96,77.37},{40.97,77.53},{40.93,77.76},{40.85,77.91},},[361]={{23.72,57.34},{23.56,57.3},{23.35,57.24},{23.19,57.03},{23.1,56.8},{23.04,56.48},{23.14,56.26},{23.28,56.31},{23.36,56.51},{23.53,56.71},{23.71,56.71},{23.87,56.74},{24.05,56.83},{24.07,57.01},{24.01,57.27},{23.92,57.44},},},148,nil,nil,82,nil,},
[2169] = {'Blackwood Totemic',350,377,17,18,0,{[148]={{42.54,85.56},{42.67,86.57},{45.05,89.09},{44.52,89.01},{44.88,88.42},{51.16,34.87},{52.51,33.1},{52.21,33.32},{52.81,33.62},{52.3,33.9},{51.93,33.57},{40.64,77.99},{39.72,78.4},{50.57,34.76},},},{[148]={{44.53,89.02},{44.46,89.19},{44.35,89.39},{44.21,89.58},{44.0,89.68},{44.18,89.6},{44.36,89.5},{44.49,89.32},{44.6,89.19},{44.71,89.04},{44.86,88.91},{44.68,89.0},},[331]={{29.05,5.9},{28.97,6.09},{28.84,6.32},{28.68,6.54},{28.45,6.65},{28.64,6.55},{28.85,6.44},{29.0,6.24},{29.13,6.09},{29.26,5.93},{29.42,5.78},{29.22,5.88},},[361]={{28.12,70.1},{28.04,70.29},{27.91,70.52},{27.75,70.74},{27.52,70.86},{27.71,70.76},{27.92,70.64},{28.07,70.44},{28.2,70.3},{28.33,70.13},{28.49,69.98},{28.29,70.08},},},148,nil,nil,82,nil,},
[2170] = {'Blackwood Ursa',377,404,18,19,0,{[148]={{42.39,86.41},{42.79,86.58},{44.82,87.39},{44.06,83.62},{44.3,84.09},{44.73,87.88},{44.6,86.98},{43.93,85.14},{43.65,84.53},{44.23,85.56},{44.24,84.86},{44.49,84.82},},},{[148]={{43.6,84.54},{43.72,84.61},{43.85,84.61},{43.92,84.62},{44.01,84.68},{44.11,84.75},{44.01,84.7},{43.91,84.66},{43.76,84.61},{43.68,84.58},{43.6,84.49},{43.51,84.38},{43.44,84.26},{43.37,84.11},{43.38,84.0},{43.41,83.85},{43.37,83.99},{43.39,84.18},{43.44,84.33},{43.52,84.46},},[331]={{27.99,0.81},{28.13,0.88},{28.27,0.89},{28.36,0.91},{28.45,0.97},{28.57,1.04},{28.46,1.0},{28.35,0.95},{28.18,0.89},{28.08,0.86},{27.99,0.75},{27.88,0.62},{27.8,0.5},{27.72,0.32},{27.74,0.2},{27.78,0.02},{27.73,0.18},{27.76,0.4},{27.81,0.57},{27.9,0.73},},[361]={{27.06,65.0},{27.19,65.07},{27.34,65.08},{27.43,65.09},{27.52,65.16},{27.64,65.23},{27.53,65.18},{27.42,65.14},{27.25,65.08},{27.15,65.04},{27.06,64.94},{26.95,64.81},{26.87,64.68},{26.79,64.51},{26.8,64.38},{26.84,64.21},{26.8,64.37},{26.82,64.59},{26.87,64.76},{26.96,64.91},},},148,nil,nil,82,nil,},
[2171] = {'Blackwood Shaman',404,433,19,20,0,{[148]={{44.82,87.08},{44.68,87.3},{42.68,86.15},{42.61,86.81},{43.98,84.8},{44.25,84.42},},},nil,148,nil,nil,82,nil,},
[2172] = {'Strider Clutchmother',484,484,20,20,4,{[148]={{34.82,87.31},},},{[148]={{35.63,87.4},{36.19,87.35},{36.59,87.65},{36.9,88.15},{37.33,88.35},{37.48,88.65},{37.52,88.98},{37.6,89.73},{37.82,90.64},{38.18,91.18},{38.5,91.31},{38.74,91.46},{38.84,91.85},{38.74,92.37},{38.6,92.74},{38.32,92.91},{38.07,92.87},{37.55,92.38},{36.66,90.77},{36.29,89.98},{35.96,89.49},{35.65,89.38},{35.37,89.22},{35.14,88.81},{34.73,88.36},{34.31,87.79},{34.13,87.47},{34.16,87.14},{34.37,86.98},{34.83,87.32},},[331]={{18.94,4.06},{19.57,4.0},{20.03,4.34},{20.39,4.91},{20.87,5.14},{21.04,5.48},{21.09,5.85},{21.18,6.71},{21.42,7.74},{21.83,8.36},{22.19,8.5},{22.48,8.67},{22.59,9.12},{22.47,9.7},{22.32,10.12},{22.0,10.32},{21.71,10.27},{21.12,9.72},{20.11,7.89},{19.69,6.99},{19.31,6.43},{18.96,6.31},{18.65,6.13},{18.39,5.66},{17.92,5.15},{17.44,4.5},{17.23,4.14},{17.26,3.76},{17.51,3.58},{18.02,3.97},},[361]={{17.98,68.26},{18.62,68.2},{19.07,68.54},{19.43,69.11},{19.92,69.33},{20.09,69.68},{20.13,70.05},{20.22,70.91},{20.47,71.95},{20.88,72.56},{21.24,72.71},{21.53,72.88},{21.64,73.33},{21.52,73.91},{21.37,74.33},{21.05,74.53},{20.75,74.49},{20.17,73.93},{19.15,72.1},{18.73,71.19},{18.35,70.63},{18.0,70.51},{17.69,70.33},{17.42,69.86},{16.95,69.35},{16.47,68.69},{16.26,68.34},{16.3,67.96},{16.55,67.78},{17.06,68.16},},},148,nil,nil,7,"AH",},
[2173] = {'Reef Frenzy',300,328,14,15,0,{[130]={{34.57,36.0},{38.87,75.65},{34.53,37.34},{34.88,36.15},{35.45,49.84},{34.15,47.78},{35.07,50.6},{37.08,82.63},{34.88,48.78},{37.42,76.72},{38.03,77.41},{34.17,23.52},{33.38,24.7},{34.84,29.83},{36.64,32.94},{34.84,44.8},},},nil,130,nil,nil,16,nil,},
[2174] = {'Coastal Frenzy',300,356,14,15,0,{[148]={{31.96,62.98},{33.02,70.46},{33.97,76.36},{34.99,73.72},{32.51,71.6},{39.57,21.76},{32.16,75.14},{31.43,70.6},{40.04,25.07},{31.98,61.35},{32.94,67.63},{41.01,18.89},{31.44,63.1},{35.07,67.84},{35.1,70.25},{31.83,64.43},{44.21,15.48},{33.53,69.25},{32.3,66.26},{41.11,24.77},{31.44,79.46},{37.35,25.4},{38.6,22.52},{46.14,15.61},{37.69,24.83},{41.56,16.89},{33.6,64.56},{32.96,63.9},{33.08,65.66},{33.05,61.04},{31.86,73.63},{42.84,15.6},{33.81,61.14},{31.28,72.54},{40.95,16.74},{34.12,73.58},{38.88,24.73},{38.85,20.25},{45.17,15.66},{31.94,76.24},{44.27,17.03},{30.91,64.55},{40.59,19.66},{34.58,65.61},{39.45,23.88},{42.07,18.72},},},nil,148,nil,nil,16,nil,},
[2175] = {'Shadowclaw',205,205,13,13,4,{[148]={{40.29,40.52},},},nil,148,nil,nil,14,nil,},
[2176] = {'Cursed Highborne',222,226,10,11,0,{[148]={{41.68,59.19},{41.62,59.63},{43.22,57.6},{41.48,58.64},{41.69,57.76},{42.05,58.42},{42.23,57.86},{42.54,57.35},{41.91,57.32},{42.71,57.76},{43.17,58.43},{43.69,58.23},{43.72,59.02},},},nil,148,nil,nil,14,nil,},
[2177] = {'Writhing Highborne',221,245,11,12,0,{[148]={{42.59,58.82},{42.22,59.28},{41.78,60.25},{42.46,63.44},{42.79,63.44},{43.38,61.98},{43.28,63.37},{43.61,62.74},{42.31,62.86},{42.78,62.79},{41.69,62.06},{41.94,62.53},{41.29,61.71},{41.7,60.84},{41.62,61.34},{42.96,58.92},{43.43,59.65},{42.56,58.42},{42.68,59.63},{41.08,62.83},{43.57,60.44},},},{[148]={{42.57,58.8},{42.66,58.59},{42.77,58.37},{42.97,58.32},{43.14,58.34},{43.22,58.57},{43.2,58.79},{43.05,58.97},{42.9,59.11},{42.72,59.29},{42.55,59.23},{42.54,59.05},{41.75,60.25},{41.7,60.08},{41.63,59.86},{41.63,59.86},{41.7,59.53},{41.84,59.15},{41.84,59.15},{41.72,59.56},{41.69,59.79},{41.76,60.18},{41.83,60.34},{42.02,60.44},{42.25,60.68},{42.07,60.55},{41.89,60.48},},[361]={{25.89,35.67},{25.99,35.44},{26.11,35.18},{26.34,35.13},{26.54,35.15},{26.62,35.42},{26.61,35.67},{26.43,35.87},{26.26,36.03},{26.05,36.24},{25.86,36.17},{25.85,35.96},{24.96,37.33},{24.89,37.13},{24.82,36.89},{24.82,36.89},{24.89,36.51},{25.05,36.08},{25.05,36.08},{24.91,36.54},{24.88,36.8},{24.96,37.25},{25.04,37.43},{25.26,37.55},{25.52,37.82},{25.32,37.67},{25.1,37.59},},},148,nil,nil,14,nil,},
[2178] = {'Wailing Highborne',247,275,12,13,0,{[148]={{42.81,60.18},{44.03,61.4},{44.03,62.0},{42.39,60.62},{42.22,61.2},{42.71,60.93},{43.18,58.71},{43.74,59.98},{44.08,60.53},{43.32,60.91},{43.91,60.96},{42.17,61.98},{43.14,61.78},{42.7,61.7},{42.51,61.75},},},nil,148,nil,nil,14,nil,},
[2179] = {'Stormscale Wave Rider',328,356,15,16,0,{[148]={{56.25,34.61},{54.68,36.77},{55.57,35.83},{55.02,35.2},{55.5,34.75},{57.0,34.44},{56.65,33.71},{55.59,34.07},{55.2,35.0},{55.12,34.26},{55.32,35.37},{54.87,35.69},{55.42,36.61},{55.9,34.8},{55.02,33.46},{55.65,35.91},{54.99,32.94},},},{[148]={{55.23,35.1},{55.09,35.25},{54.96,35.45},{54.9,35.59},{54.82,35.78},{54.76,35.95},{54.86,35.68},{54.9,35.59},{54.97,35.43},{55.08,35.24},{55.15,35.12},{55.43,35.84},{55.26,35.71},{55.12,35.51},{55.01,35.09},{55.02,34.7},{55.1,34.2},{55.21,33.92},{55.35,33.89},{55.77,34.15},{55.89,34.45},{55.92,34.74},{55.87,35.01},{55.78,35.18},{55.61,35.4},{55.41,35.44},{55.26,35.33},{55.19,35.05},{55.2,34.8},{55.27,34.57},{55.42,34.49},{55.53,34.6},{55.58,34.79},{55.51,34.94},{55.3,34.91},{55.2,35.01},{55.21,35.25},{55.37,35.42},{55.5,35.44},{55.61,35.41},{55.81,35.17},{55.93,34.85},{55.91,34.54},{55.84,34.28},{55.76,34.14},{55.52,33.97},{55.33,33.87},{55.22,33.9},{55.12,34.08},{55.03,34.44},{55.01,34.68},{54.99,34.94},{55.02,35.15},{55.16,35.61},{55.3,35.78},{55.65,35.91},{54.97,32.92},{55.01,32.76},{55.01,32.48},{54.98,32.16},{54.98,31.96},{54.85,31.84},{55.0,32.0},{55.0,32.21},{54.98,32.43},{54.98,32.43},{54.99,32.75},{54.99,32.93},},[361]={{40.3,8.68},{40.14,8.85},{40.0,9.07},{39.93,9.24},{39.83,9.46},{39.77,9.65},{39.89,9.34},{39.93,9.24},{40.01,9.06},{40.14,8.84},{40.21,8.71},{40.53,9.53},{40.34,9.37},{40.18,9.14},{40.05,8.67},{40.06,8.22},{40.16,7.65},{40.28,7.34},{40.45,7.3},{40.92,7.6},{41.05,7.94},{41.09,8.27},{41.04,8.58},{40.93,8.78},{40.74,9.02},{40.52,9.06},{40.34,8.94},{40.25,8.62},{40.27,8.34},{40.35,8.08},{40.52,7.99},{40.65,8.11},{40.7,8.32},{40.62,8.5},{40.38,8.47},{40.27,8.57},{40.28,8.86},{40.46,9.04},{40.62,9.07},{40.74,9.03},{40.97,8.76},{41.1,8.4},{41.08,8.04},{41.0,7.74},{40.91,7.58},{40.64,7.39},{40.42,7.28},{40.29,7.31},{40.18,7.52},{40.07,7.93},{40.05,8.2},{40.04,8.5},{40.07,8.74},{40.22,9.26},{40.39,9.46},{40.78,9.6},{40.01,6.2},{40.05,6.01},{40.06,5.7},{40.03,5.33},{40.02,5.1},{39.87,4.97},{40.04,5.15},{40.04,5.39},{40.02,5.64},{40.02,5.64},{40.03,6.0},{40.03,6.2},},[618]={{5.06,36.61},{4.93,36.75},{4.81,36.93},{4.75,37.06},{4.68,37.24},{4.63,37.39},{4.72,37.15},{4.76,37.06},{4.82,36.91},{4.92,36.74},{4.99,36.63},{5.24,37.29},{5.08,37.17},{4.96,36.98},{4.86,36.6},{4.86,36.23},{4.94,35.78},{5.04,35.52},{5.17,35.49},{5.55,35.73},{5.67,36.01},{5.7,36.27},{5.65,36.52},{5.57,36.68},{5.41,36.88},{5.23,36.92},{5.09,36.81},{5.02,36.56},{5.03,36.33},{5.1,36.12},{5.24,36.05},{5.34,36.14},{5.38,36.32},{5.31,36.46},{5.12,36.43},{5.03,36.52},{5.04,36.75},{5.19,36.9},{5.31,36.92},{5.41,36.89},{5.6,36.67},{5.7,36.38},{5.69,36.09},{5.62,35.85},{5.55,35.72},{5.33,35.56},{5.15,35.47},{5.05,35.49},{4.96,35.66},{4.87,36.0},{4.85,36.22},{4.84,36.46},{4.87,36.66},{4.99,37.08},{5.13,37.24},{5.44,37.36},{4.82,34.6},{4.85,34.44},{4.86,34.19},{4.83,33.9},{4.83,33.71},{4.71,33.6},{4.84,33.75},{4.85,33.94},{4.83,34.14},{4.83,34.14},{4.84,34.44},{4.84,34.6},},},148,nil,nil,74,nil,},
[2180] = {'Stormscale Siren',325,350,16,17,0,{[148]={{55.23,34.84},{54.73,36.21},{54.98,37.0},{55.42,36.03},{55.23,35.67},{55.63,36.2},{56.51,35.01},{56.79,34.75},{56.49,34.18},{55.32,34.45},{56.58,34.79},{55.84,34.7},{57.01,33.91},{55.82,34.28},{55.72,35.23},{54.68,33.36},{55.02,34.65},{55.22,33.81},},},{[148]={{55.23,34.82},{55.41,34.71},{55.54,34.69},{55.69,34.67},{55.52,34.59},{55.35,34.53},{55.24,34.78},{55.94,34.66},{56.21,34.62},{56.39,34.46},{56.46,34.18},{56.6,33.9},{56.79,33.8},{56.95,33.91},{57.04,34.1},{57.04,34.36},{56.98,34.58},{56.81,34.81},{56.64,34.98},{56.56,34.91},{55.69,34.7},{56.03,34.65},{56.25,34.61},{56.4,34.46},{56.55,34.05},{56.68,33.91},{56.83,33.9},{56.99,34.07},{57.01,34.3},{56.94,34.51},{56.81,34.67},{56.59,34.78},},[361]={{40.3,8.36},{40.51,8.24},{40.66,8.21},{40.83,8.19},{40.64,8.09},{40.45,8.02},{40.32,8.32},{41.11,8.18},{41.42,8.13},{41.62,7.95},{41.7,7.63},{41.87,7.32},{42.08,7.19},{42.27,7.32},{42.36,7.54},{42.37,7.83},{42.29,8.08},{42.11,8.35},{41.92,8.54},{41.82,8.47},{40.83,8.23},{41.21,8.17},{41.47,8.12},{41.64,7.95},{41.81,7.48},{41.96,7.32},{42.13,7.32},{42.31,7.51},{42.33,7.77},{42.25,8.0},{42.1,8.18},{41.86,8.32},},[618]={{5.06,36.35},{5.22,36.25},{5.35,36.22},{5.48,36.21},{5.33,36.13},{5.17,36.08},{5.07,36.32},{5.71,36.2},{5.97,36.16},{6.13,36.01},{6.19,35.76},{6.32,35.5},{6.49,35.4},{6.65,35.5},{6.73,35.68},{6.73,35.92},{6.67,36.12},{6.52,36.34},{6.36,36.49},{6.28,36.43},{5.49,36.24},{5.8,36.19},{6.0,36.15},{6.14,36.01},{6.27,35.64},{6.4,35.51},{6.53,35.5},{6.68,35.66},{6.7,35.87},{6.64,36.06},{6.51,36.21},{6.32,36.31},},},148,nil,nil,74,nil,},
[2181] = {'Stormscale Myrmidon',417,449,18,19,0,{[148]={{58.99,24.79},{60.34,23.56},{60.61,23.01},{58.24,22.65},{59.76,16.47},{57.99,20.48},{58.21,18.77},{59.49,24.86},{59.33,23.56},{58.82,24.15},{59.36,21.67},{59.91,21.88},{58.93,20.9},{58.45,21.35},{58.64,19.61},{57.91,19.26},{57.67,21.33},{57.19,19.64},{57.33,20.88},{57.31,21.76},{60.12,15.43},{59.51,14.56},{60.68,16.81},{60.22,16.72},{60.4,15.59},{61.14,16.98},{56.85,22.46},{57.67,24.38},{57.35,22.76},{58.24,23.82},{58.5,23.58},{58.56,25.03},{58.07,24.59},{57.34,23.6},{58.0,17.89},{57.48,18.45},{58.89,15.85},{58.26,17.03},{58.96,16.95},{57.61,17.22},},},{[148]={{57.31,22.78},{57.21,22.88},{57.03,23.05},{57.19,22.91},{57.33,22.76},{57.44,22.6},{57.55,22.41},{57.63,22.23},{57.7,22.07},{57.6,22.29},{57.6,22.29},{57.47,22.54},{57.34,23.66},{57.3,23.52},{57.24,23.33},{57.31,23.59},{57.34,23.74},{57.34,23.74},{57.35,24.06},{57.36,24.38},{57.37,24.79},{57.36,24.64},{57.36,24.42},{57.35,23.93},},[618]={{6.98,25.24},{6.89,25.33},{6.72,25.49},{6.87,25.36},{7.0,25.23},{7.1,25.07},{7.2,24.9},{7.27,24.74},{7.34,24.59},{7.25,24.79},{7.25,24.79},{7.13,25.02},{7.01,26.05},{6.97,25.92},{6.91,25.75},{6.98,25.99},{7.0,26.13},{7.0,26.13},{7.02,26.43},{7.02,26.72},{7.03,27.1},{7.02,26.96},{7.03,26.75},{7.01,26.3},},},148,nil,nil,74,nil,},
[2182] = {'Stormscale Sorceress',379,405,19,20,0,{[148]={{59.83,23.54},{60.96,22.34},{60.15,22.85},{61.6,21.16},{59.53,15.42},{59.89,22.51},{59.98,18.94},{58.02,20.05},{59.93,19.86},{59.42,24.16},{58.5,22.98},{58.68,22.1},{61.99,20.98},{58.73,20.39},{57.45,19.4},{57.76,21.9},{60.22,16.14},{61.42,17.3},{61.85,19.49},{61.57,22.36},{57.02,21.67},{58.35,24.4},{58.46,24.7},{58.5,18.26},},},{[148]={{58.7,20.43},{58.6,20.38},{58.5,20.33},{58.37,20.29},{58.23,20.23},{58.12,20.28},{58.09,20.46},{58.22,20.45},{58.46,20.38},{58.55,20.38},{58.61,20.38},{58.68,20.39},{58.75,20.4},{58.84,20.41},{58.77,20.44},{57.73,21.92},{57.6,21.81},{57.57,21.57},{57.6,21.37},{57.82,21.45},{57.83,21.68},{60.18,16.13},{60.05,15.94},{59.86,15.67},{59.7,15.43},{59.64,15.16},{59.63,14.91},{59.6,15.32},{59.4,15.37},{59.57,15.4},{59.75,15.53},{59.83,15.65},{59.97,15.89},{60.14,16.17},},[618]={{8.26,23.08},{8.17,23.03},{8.08,22.98},{7.96,22.95},{7.83,22.89},{7.73,22.93},{7.69,23.1},{7.82,23.09},{8.04,23.02},{8.13,23.02},{8.18,23.03},{8.25,23.04},{8.31,23.04},{8.39,23.05},{8.33,23.08},{7.37,24.45},{7.25,24.34},{7.22,24.13},{7.24,23.94},{7.45,24.01},{7.46,24.23},{9.62,19.1},{9.5,18.93},{9.33,18.68},{9.19,18.46},{9.13,18.21},{9.12,17.98},{9.09,18.36},{8.9,18.4},{9.07,18.43},{9.23,18.56},{9.3,18.66},{9.43,18.88},{9.59,19.14},},},148,nil,nil,74,nil,},
[2183] = {'Stormscale Warrior',494,531,20,21,0,{[148]={{61.27,22.06},{62.02,22.04},{61.28,20.81},{60.29,22.34},{60.1,18.78},{60.47,19.59},{60.46,18.94},{60.28,20.21},{61.02,21.5},{60.62,21.84},{61.96,21.43},{62.18,20.46},{61.35,18.07},{61.41,19.2},{61.02,17.73},{61.25,19.78},{61.19,18.61},{61.66,19.99},{61.09,23.12},},},{[148]={{61.31,22.08},{61.15,22.07},{61.03,22.09},{60.81,22.12},{60.69,21.96},{60.7,21.66},{60.84,21.55},{60.97,21.61},{61.08,21.79},{61.18,21.96},{60.27,22.17},{60.29,22.48},{60.29,22.72},{60.3,22.97},{60.26,23.33},{60.28,23.01},{60.27,22.71},{60.27,22.51},{60.18,22.16},{60.01,22.17},{59.91,22.18},{60.12,22.22},},[618]={{10.67,24.6},{10.52,24.58},{10.41,24.6},{10.2,24.63},{10.1,24.49},{10.11,24.21},{10.24,24.11},{10.36,24.16},{10.46,24.33},{10.55,24.49},{9.71,24.68},{9.73,24.97},{9.73,25.18},{9.73,25.42},{9.7,25.75},{9.71,25.45},{9.71,25.18},{9.7,24.99},{9.63,24.67},{9.47,24.68},{9.38,24.69},{9.57,24.72},},},148,nil,nil,74,nil,},
[2184] = {'Lady Moongazer',386,386,17,17,4,{[148]={{42.98,61.11},},},nil,148,nil,nil,14,nil,},
[2185] = {'Darkshore Thresher',253,301,12,14,0,{[148]={{30.82,59.25},{34.52,35.36},{35.81,38.24},{29.51,46.34},{31.91,59.99},{33.61,35.62},{33.4,59.97},{31.82,38.46},{33.77,38.38},{35.47,57.55},{34.85,37.09},{33.54,32.6},{32.42,56.97},{30.88,55.37},{32.51,33.89},{31.49,60.29},{32.67,35.93},{33.64,35.74},{34.88,52.68},{34.94,31.06},{33.57,28.69},{34.64,58.77},{32.51,36.0},{34.4,37.04},{34.58,36.05},{34.35,56.49},{31.45,56.84},{32.06,58.31},{32.7,58.47},{34.0,58.95},{32.2,38.49},{33.22,40.16},{31.96,39.39},{35.9,24.24},{34.56,53.69},{33.93,34.16},{36.44,29.24},{36.8,27.65},{34.96,34.0},{36.05,30.86},{34.39,29.63},{33.85,31.08},{35.92,28.07},{33.9,39.97},{32.25,43.24},{32.57,41.25},{33.59,41.55},{35.44,29.47},{35.97,36.49},{39.66,29.76},{33.94,59.3},},},nil,148,nil,nil,16,nil,},
[2186] = {'Carnivous the Breaker',356,356,16,16,4,{[148]={{40.16,56.57},{39.89,78.52},},},nil,148,nil,nil,82,nil,},
[2187] = {'Elder Darkshore Thresher',354,417,16,18,0,{[148]={{30.94,82.66},{29.96,88.72},{55.91,10.45},{57.69,9.57},{30.41,85.14},{51.63,18.83},{30.86,81.25},{30.44,79.03},{30.76,80.41},{53.85,17.09},{31.01,72.91},{31.49,81.96},{30.49,76.54},{30.6,88.22},{30.84,79.23},{30.16,74.45},{33.01,86.0},{30.72,84.77},{49.23,10.49},{48.39,12.52},{48.76,12.79},{49.4,11.27},{48.27,11.7},{48.58,10.9},{47.67,18.62},{49.3,12.13},{49.43,9.39},},},nil,148,nil,nil,16,nil,},
[2188] = {'Deep Sea Threshadon',1240,1240,25,25,0,nil,nil,0,nil,nil,14,nil,},
[2189] = {'Vile Sprite',197,226,10,11,0,{[148]={{44.46,37.54},{44.49,39.07},{44.69,38.61},{44.87,38.98},{44.87,39.71},{45.14,37.9},{44.75,37.69},{44.41,38.11},{44.04,38.44},{44.82,36.21},{44.69,37.17},{46.91,36.17},{47.51,36.12},{47.01,37.08},{44.56,36.59},{46.09,36.52},{45.22,36.32},},},{[148]={{44.78,37.71},{44.92,37.67},{45.13,37.62},{45.22,37.46},{45.17,37.08},{45.04,37.04},{44.95,37.14},{44.84,37.21},{44.63,37.11},{44.61,37.28},{44.61,37.49},{44.61,37.67},{44.8,36.24},{44.74,36.11},{44.67,35.97},{44.59,35.77},{44.51,35.53},{44.44,35.35},{44.34,35.17},{44.24,34.99},{44.37,35.21},{44.49,35.47},{44.49,35.47},{44.65,35.87},{44.77,36.22},{47.03,37.09},{47.1,37.31},{47.17,37.53},{47.09,37.27},{47.02,37.01},{46.98,36.84},{46.93,36.63},{46.88,36.41},{46.95,36.59},{46.98,36.77},{47.01,36.92},},[361]={{28.4,11.65},{28.56,11.61},{28.8,11.55},{28.9,11.37},{28.85,10.94},{28.69,10.88},{28.6,11.0},{28.47,11.08},{28.23,10.97},{28.21,11.17},{28.21,11.4},{28.21,11.6},{28.43,9.98},{28.36,9.83},{28.28,9.67},{28.19,9.44},{28.1,9.17},{28.02,8.96},{27.9,8.76},{27.78,8.56},{27.93,8.8},{28.07,9.1},{28.07,9.1},{28.25,9.55},{28.38,9.96},{30.97,10.95},{31.04,11.2},{31.12,11.45},{31.04,11.15},{30.95,10.86},{30.9,10.66},{30.85,10.43},{30.8,10.17},{30.87,10.38},{30.91,10.59},{30.94,10.75},},},148,nil,nil,81,nil,},
[2190] = {'Wild Grell',222,247,11,12,0,{[148]={{45.39,40.13},{45.76,40.17},{46.31,39.62},{45.94,39.62},{45.59,38.76},{45.29,39.4},{46.91,38.61},{46.92,39.21},{47.16,38.21},{45.27,38.71},{46.46,38.7},{46.0,39.05},{46.54,38.12},{46.21,37.9},{46.0,38.32},{46.67,36.88},{48.24,36.62},{47.45,37.08},{47.48,37.75},{47.91,36.65},{47.81,37.45},{47.15,37.59},{45.58,36.15},},},{[148]={{45.31,38.77},{45.22,38.62},{45.1,38.44},{45.02,38.29},{45.12,38.45},{45.23,38.65},{45.36,38.78},{45.36,38.78},{45.69,39.13},{45.88,39.29},{45.72,39.2},{45.57,39.06},{45.45,38.95},},[361]={{29.01,12.86},{28.9,12.69},{28.77,12.48},{28.67,12.31},{28.79,12.5},{28.92,12.72},{29.06,12.88},{29.06,12.88},{29.44,13.27},{29.66,13.45},{29.48,13.35},{29.3,13.19},{29.17,13.06},},},148,nil,nil,81,nil,},
[2191] = {'Licillin',263,263,14,14,4,{[148]={{45.66,36.38},},},nil,148,nil,nil,81,nil,},
[2192] = {'Firecaller Radison',379,379,19,19,4,{[148]={{38.69,87.64},},},{[148]={{38.7,87.72},{38.54,87.68},{38.42,87.57},{38.24,87.4},{37.95,87.08},{37.96,86.76},{37.92,87.07},{37.92,87.07},{38.2,87.41},{38.38,87.53},{38.63,87.77},{38.91,87.94},{39.19,87.9},{39.19,87.9},{38.83,87.85},},[331]={{22.42,4.42},{22.24,4.38},{22.1,4.26},{21.9,4.06},{21.57,3.7},{21.59,3.33},{21.54,3.68},{21.54,3.68},{21.86,4.07},{22.06,4.21},{22.34,4.48},{22.66,4.67},{22.99,4.63},{22.99,4.63},{22.57,4.57},},[361]={{21.47,68.62},{21.29,68.58},{21.15,68.45},{20.95,68.25},{20.62,67.89},{20.63,67.52},{20.59,67.88},{20.59,67.88},{20.91,68.27},{21.11,68.41},{21.39,68.68},{21.71,68.87},{22.04,68.83},{22.04,68.83},{21.62,68.77},},},148,nil,nil,16,nil,},
[2198] = {'Crier Goodman',112,112,3,3,0,{[1519]={{47.45,64.17},},},{[12]={{22.77,39.54},{22.31,40.24},{22.51,40.63},{21.46,41.88},{21.97,42.99},{22.02,43.4},{21.95,44.33},{21.65,44.86},{21.44,45.19},{20.92,45.45},{20.21,45.76},{19.88,45.02},{19.5,44.8},{18.99,44.77},{18.28,45.99},{17.61,46.46},{17.15,46.31},{16.72,46.01},{16.57,45.33},{16.58,44.79},{16.68,43.49},{16.69,43.0},{16.72,42.64},{17.32,41.92},{17.87,41.41},{17.82,40.84},{17.39,39.64},{17.23,38.88},{16.73,37.89},{17.37,37.12},{18.06,36.25},{18.55,35.57},{18.53,34.56},{18.95,33.92},{19.47,33.28},{18.96,32.14},{20.07,30.79},{20.26,30.57},{21.5,29.99},{22.23,31.3},{23.08,30.33},{22.33,28.96},{22.39,28.12},{22.98,27.64},{23.58,28.37},{24.83,26.88},{24.39,25.87},{24.89,25.27},{25.51,24.64},{26.03,25.78},{26.5,26.76},{27.01,27.7},{27.85,28.02},{28.51,27.5},{28.51,27.5},{29.0,26.99},{29.49,26.5},{30.19,25.7},{30.71,26.29},{30.82,27.03},{30.37,27.77},{29.62,28.84},{30.49,30.56},{30.96,30.01},{31.44,29.97},{32.05,30.76},{32.75,31.97},{32.76,32.57},{32.3,33.16},{31.79,33.84},{31.06,33.34},{30.56,32.61},{29.49,33.82},{29.2,33.52},{28.77,34.07},{28.09,34.92},{27.67,34.49},{26.69,35.93},{27.28,37.0},{26.2,38.43},{25.26,39.45},{24.85,38.63},{24.7,38.3},{24.14,38.66},{23.41,39.15},},[1519]={{47.31,64.25},{46.11,66.05},{46.63,67.06},{43.91,70.3},{45.25,73.15},{45.35,74.22},{45.17,76.61},{44.41,77.99},{43.87,78.83},{42.54,79.51},{40.69,80.32},{39.85,78.39},{38.85,77.83},{37.54,77.75},{35.72,80.91},{33.98,82.11},{32.78,81.73},{31.69,80.95},{31.29,79.19},{31.33,77.82},{31.57,74.45},{31.61,73.19},{31.68,72.24},{33.22,70.4},{34.64,69.09},{34.52,67.6},{33.42,64.51},{33.01,62.54},{31.7,60.0},{33.35,58.0},{35.14,55.75},{36.4,54.01},{36.36,51.38},{37.44,49.75},{38.78,48.09},{37.45,45.13},{40.32,41.66},{40.83,41.1},{44.04,39.6},{45.9,42.98},{48.11,40.47},{46.16,36.94},{46.33,34.77},{47.84,33.52},{49.39,35.4},{52.62,31.55},{51.47,28.94},{52.76,27.41},{54.37,25.78},{55.73,28.72},{56.94,31.26},{58.24,33.67},{60.42,34.5},{62.13,33.17},{62.13,33.17},{63.38,31.85},{64.65,30.58},{66.47,28.51},{67.79,30.03},{68.08,31.96},{66.92,33.87},{64.98,36.62},{67.23,41.06},{68.44,39.63},{69.68,39.55},{71.26,41.59},{73.06,44.71},{73.1,46.25},{71.9,47.78},{70.58,49.54},{68.71,48.23},{67.42,46.36},{64.65,49.47},{63.91,48.71},{62.78,50.13},{61.04,52.33},{59.95,51.22},{57.41,54.92},{58.94,57.69},{56.15,61.39},{53.73,64.03},{52.67,61.9},{52.28,61.05},{50.83,61.98},{48.95,63.24},},},1519,{1015,5066,},nil,12,"A",},
[2201] = {'Greymist Raider',222,247,11,12,0,{[148]={{36.12,50.61},},},nil,148,nil,nil,18,nil,},
[2202] = {'Greymist Coastrunner',247,273,12,13,0,{[148]={{38.67,21.84},{40.94,26.9},{38.6,28.94},{39.86,27.34},{42.02,31.07},{42.12,31.7},{42.15,32.18},{35.97,50.78},{40.33,27.19},{40.12,27.28},{38.71,29.19},{38.48,28.99},{38.49,28.96},{38.31,28.9},{38.69,29.63},{38.09,28.49},{41.72,31.17},{40.16,27.39},{38.26,29.85},{36.43,50.69},{36.61,51.0},{36.16,50.99},{36.4,51.08},{36.92,61.66},{36.75,61.66},{36.92,62.24},{37.26,62.28},},},nil,148,nil,nil,18,nil,},
[2203] = {'Greymist Seer',253,276,13,14,0,{[148]={{39.72,27.22},{39.99,26.51},{40.04,28.09},{39.77,27.5},{40.12,27.39},{40.31,27.36},{35.85,71.09},{41.86,30.86},{39.81,27.51},{38.75,29.8},{38.24,28.85},{38.68,29.18},{38.84,29.6},{38.67,29.52},{39.27,27.79},{41.78,31.59},{41.89,31.96},{38.87,30.33},{37.12,61.82},{36.79,61.96},{36.15,70.74},{35.89,71.43},{35.72,71.59},},},nil,148,nil,nil,18,nil,},
[2204] = {'Greymist Netter',300,328,14,15,0,{[148]={{44.19,20.35},{43.83,20.34},{36.24,71.04},{35.98,70.49},{35.81,71.27},},},nil,148,nil,nil,18,nil,},
[2205] = {'Greymist Warrior',328,356,15,16,0,{[148]={{32.49,80.21},{44.25,20.75},{43.88,20.07},{44.08,20.18},{43.85,20.72},{36.49,76.21},{33.2,81.45},{44.08,21.03},{36.73,76.63},{36.75,76.34},{36.68,76.86},},},nil,148,nil,nil,18,nil,},
[2206] = {'Greymist Hunter',356,386,16,17,0,{[148]={{32.59,80.89},{32.63,80.38},{36.65,76.6},{36.54,76.68},{32.86,80.76},{32.96,81.17},{36.52,76.48},{36.35,76.51},},},nil,148,nil,nil,18,nil,},
[2207] = {'Greymist Oracle',377,404,18,19,0,{[148]={{54.66,11.79},{54.88,11.59},{31.04,87.67},{30.85,85.57},{31.02,85.72},{31.44,87.19},{30.96,85.28},{55.46,12.62},{55.01,12.52},{31.63,83.91},{31.42,83.89},{31.13,85.22},{31.13,87.89},{31.4,87.52},},},nil,148,nil,nil,18,nil,},
[2208] = {'Greymist Tidehunter',404,433,19,20,0,{[148]={{54.88,11.87},{54.83,12.19},{31.39,83.17},{31.35,83.48},{31.08,87.19},{31.61,83.29},{55.28,12.58},{55.2,12.88},{55.16,12.18},{54.99,12.09},{31.72,83.48},{31.82,83.76},{31.25,85.75},{31.32,85.51},{31.46,87.95},{31.26,87.93},},},nil,148,nil,nil,18,nil,},
[2209] = {'Deathguard Gavin',1172,1172,24,24,0,{[85]={{61.74,51.41},},},nil,85,nil,nil,71,"H",},
[2210] = {'Deathguard Royann',1172,1172,24,24,0,{[85]={{61.67,51.18},},},nil,85,nil,nil,71,"H",},
[2211] = {'Captured Mountaineer',372,372,9,9,0,{[85]={{61.94,51.4},},},nil,85,nil,{492,},68,"H",},
[2212] = {'Deth\'ryll Satyr',247,273,12,13,0,{[148]={{45.4,39.73},{46.64,39.19},{47.48,36.66},{47.95,37.08},{47.28,37.68},{45.46,36.5},},},{[148]={{45.41,39.71},{45.55,39.72},{45.69,39.73},{45.82,39.61},{45.93,39.44},{46.19,39.4},{46.19,39.4},{45.89,39.41},{45.7,39.37},{45.54,39.26},{45.35,39.19},{45.24,39.37},{45.25,39.64},{45.33,39.74},{45.5,36.52},{45.62,36.68},{45.59,36.84},{45.47,37.03},{45.3,37.18},{45.17,37.01},{45.17,36.79},{45.29,36.61},},[361]={{29.12,13.93},{29.28,13.94},{29.44,13.95},{29.59,13.81},{29.71,13.63},{30.0,13.58},{30.0,13.58},{29.66,13.59},{29.45,13.54},{29.27,13.42},{29.05,13.34},{28.93,13.54},{28.94,13.85},{29.03,13.97},{29.22,10.3},{29.36,10.48},{29.33,10.66},{29.19,10.88},{29.0,11.05},{28.85,10.86},{28.85,10.61},{28.98,10.4},},},148,nil,nil,90,nil,},
[2214] = {'Deathstalker Lesh',1240,1240,25,25,0,{[267]={{20.79,47.4},},},nil,267,{494,},nil,68,"H",},
[2215] = {'High Executor Darthalia',6830,6830,50,50,1,{[267]={{62.33,20.45},},},nil,267,{527,528,529,532,539,541,550,},{494,527,528,529,532,539,541,549,566,567,},68,"H",},
[2216] = {'Apothecary Lydon',2016,2016,35,35,0,{[267]={{61.44,19.06},},},nil,267,{496,499,501,502,509,513,517,524,1066,1067,2934,2935,2938,},{493,496,501,509,515,517,1065,1066,2933,2934,2937,},68,"H",},
[2224] = {'Wind Rider',1528,1528,29,29,0,nil,nil,0,nil,nil,35,"AH",},
[2225] = {'Zora Guthrek',3300,3300,55,55,0,{[2597]={{-1, -1}},},nil,2597,nil,nil,1215,"H",},
[2226] = {'Karos Razok',7842,7842,55,55,1,{[130]={{45.62,42.6},},},nil,130,{6323,},{6321,},68,"H",},
[2227] = {'Sharlindra',1240,1240,25,25,0,{[1497]={{57.63,93.8},},},nil,1497,{495,},{521,},68,"H",},
[2228] = {'Lieutenant Farren Orinelle',1240,1240,25,25,0,{[267]={{51.46,58.39},},},nil,267,{536,559,560,562,563,},{536,559,561,562,},12,"A",},
[2229] = {'Krusk',1240,1240,25,25,0,{[267]={{63.24,20.66},},},nil,267,{498,503,507,533,1361,},{498,506,508,533,},29,"H",},
[2230] = {'Umpi',64,64,1,1,0,{[267]={{61.54,19.15},},},nil,267,nil,{499,},68,"H",},
[2231] = {'Pygmy Tide Crawler',176,198,9,10,0,{[148]={{37.42,40.32},{35.44,51.16},{36.85,41.8},{37.22,40.63},{36.7,36.34},{36.84,35.88},{36.88,40.51},{36.53,39.38},{35.5,41.17},{36.43,37.66},{36.49,37.53},{35.16,43.02},{36.31,40.39},{35.91,41.34},{36.08,39.8},{35.09,49.38},{35.69,49.96},{34.99,44.4},{35.44,44.64},{35.56,50.73},{36.0,50.09},{35.42,49.43},{35.06,48.46},{35.64,47.12},{35.0,46.72},{35.64,48.08},{35.29,46.19},{35.86,48.31},{36.68,48.4},{36.38,49.11},{35.39,47.51},{37.0,36.61},{36.44,38.84},{37.0,35.53},{34.69,47.98},{36.62,36.84},{36.48,49.14},{37.74,35.77},{36.56,49.79},{36.2,44.48},{37.37,39.69},{35.96,46.96},{35.93,45.92},{36.73,36.27},{36.43,47.76},{37.19,38.66},{37.11,37.06},},},nil,148,nil,nil,7,"AH",},
[2232] = {'Tide Crawler',247,300,13,14,0,{[148]={{35.53,65.23},{41.48,26.88},{43.1,19.77},{42.21,21.01},{41.61,25.35},{35.48,68.94},{41.19,28.59},{42.13,24.79},{41.58,24.18},{41.88,26.75},{42.57,23.25},{42.26,22.58},{41.65,23.05},{42.78,20.56},{42.33,28.3},{41.6,30.08},{35.98,62.72},{42.14,29.39},{36.26,63.2},{36.89,66.63},{36.61,69.83},{35.59,65.76},{36.69,68.16},{36.72,65.81},{37.15,67.24},{35.77,64.65},{36.41,65.86},},},nil,148,nil,nil,7,"AH",},
[2233] = {'Encrusted Tide Crawler',417,484,18,20,0,{[148]={{32.95,82.88},{32.33,83.71},{52.84,17.76},{54.03,18.94},{52.23,18.56},{53.33,18.56},{52.24,20.89},{51.72,20.97},{51.3,23.21},{51.73,22.54},{52.81,19.52},{32.7,81.41},{31.73,81.91},{32.04,80.71},{52.3,23.31},},},nil,148,nil,nil,7,"AH",},
[2234] = {'Young Reef Crawler',198,222,10,11,0,{[148]={{38.88,30.72},{36.97,34.32},{37.44,32.95},{40.15,31.42},{34.86,54.4},{40.85,31.14},{39.53,31.55},{35.24,52.65},{35.06,56.09},{35.22,54.41},{35.88,53.66},{40.59,31.83},{34.51,53.71},{37.81,33.92},{38.07,32.41},{38.53,31.54},{37.03,52.02},{35.69,60.19},{36.77,60.27},{36.72,57.01},{36.99,55.45},{35.74,54.62},{35.75,55.48},{35.89,58.18},{36.69,58.0},{36.09,59.13},{37.11,61.06},{36.45,52.8},{36.99,53.92},{36.48,54.52},},},nil,148,nil,nil,7,"AH",},
[2235] = {'Reef Crawler',328,386,15,17,0,{[148]={{34.89,72.28},{45.37,20.02},{44.76,21.8},{50.67,22.52},{48.27,20.69},{50.56,22.44},{46.52,21.04},{48.9,20.08},{48.19,20.95},{47.57,21.52},{46.78,20.34},{46.14,20.6},{45.54,20.71},{35.18,72.36},{35.82,72.84},{35.65,73.56},{35.47,77.54},{36.01,75.19},},},nil,148,nil,nil,7,"AH",},
[2236] = {'Raging Reef Crawler',494,531,20,21,0,{[148]={{29.56,90.35},{31.42,89.55},{29.69,91.08},{30.59,90.49},{30.99,88.96},{30.59,89.66},{29.53,90.83},{29.65,89.62},{28.62,90.81},{29.77,91.13},{56.57,11.4},{57.48,14.53},{56.39,12.51},{56.37,16.26},{56.9,13.05},{55.8,16.63},{56.01,17.45},{55.95,14.89},{56.41,17.0},{55.35,17.08},{56.3,14.51},{54.76,18.28},{55.54,19.23},{32.9,88.97},},},nil,148,nil,nil,7,"AH",},
[2237] = {'Moonstalker Sire',386,417,17,18,0,{[148]={{43.75,81.85},{36.17,82.11},{39.32,94.5},{44.65,92.03},{60.07,13.37},{36.59,91.5},{39.8,70.69},{37.6,83.9},{39.89,81.36},{40.14,82.87},{44.08,81.33},{41.67,83.34},{43.82,83.12},{43.98,79.96},{38.53,90.5},{40.39,90.82},{42.55,88.09},{37.53,91.93},{61.4,11.16},{43.24,81.99},{43.2,82.85},{38.32,77.17},},},nil,148,nil,nil,14,nil,},
[2238] = {'Tog\'thar',1106,1106,23,23,0,{[267]={{79.75,39.64},},},nil,267,nil,nil,29,"H",},
[2239] = {'Drull',712,712,23,23,0,{[267]={{75.36,41.55},},},nil,267,nil,nil,29,"H",},
[2240] = {'Syndicate Footpad',1163,1221,32,33,0,{[36]={{57.71,67.64},{56.48,66.05},{59.49,68.04},{58.35,66.7},{58.68,68.42},{59.0,67.22},{57.77,66.16},{47.69,81.85},{47.77,81.19},{48.34,79.29},{47.75,82.9},},},nil,36,nil,nil,87,nil,},
[2241] = {'Syndicate Thief',1213,1275,33,34,0,{[36]={{59.02,69.33},{58.17,68.44},{57.6,68.54},{58.36,67.71},{58.89,69.46},{58.44,70.0},{47.81,82.37},{48.03,81.88},{47.29,81.87},{46.56,81.49},{48.32,80.78},{48.74,82.99},},},nil,36,nil,nil,87,nil,},
[2242] = {'Syndicate Spy',1403,1469,35,36,0,{[36]={{64.2,41.62},{57.91,48.79},{58.69,42.91},{64.07,45.8},{64.01,44.28},{57.56,44.21},{58.76,41.16},{57.83,41.61},{62.87,42.08},{59.99,46.21},{56.61,46.96},{56.79,45.3},{62.33,47.0},{60.17,41.82},{61.03,43.49},{60.63,43.86},{61.38,43.36},{61.41,43.11},{60.76,43.88},{63.41,45.07},{63.51,43.72},{63.49,43.77},{62.38,45.26},},},nil,36,nil,nil,87,nil,},
[2243] = {'Syndicate Sentry',1469,1536,36,37,0,{[36]={{51.88,30.63},{51.14,29.58},{60.12,32.39},{56.03,34.37},{58.33,36.14},{56.12,26.08},{55.48,26.39},{58.42,29.29},{57.29,30.97},{58.28,30.68},{57.55,29.37},{58.85,29.27},{59.1,29.94},{57.9,28.83},{52.95,25.43},{55.56,27.46},{55.39,30.52},{52.75,23.17},{56.17,27.8},{47.68,18.19},{47.36,17.42},{48.18,16.79},{46.88,18.03},{46.07,19.77},{47.35,16.86},{48.43,17.76},{47.78,16.0},{53.27,20.25},{53.34,21.22},{53.9,21.6},{46.32,20.4},},},nil,36,nil,nil,87,nil,},
[2244] = {'Syndicate Shadow Mage',441,472,21,22,0,{[267]={{67.92,47.23},{83.44,40.59},{78.23,38.54},{64.85,47.08},{66.65,46.0},{65.37,48.68},{66.73,50.05},{81.9,39.61},{79.77,43.42},{77.68,39.28},{79.77,46.87},{75.8,40.74},{78.99,41.2},{81.55,44.37},{80.1,39.73},{75.3,40.3},{79.61,41.71},{76.75,41.87},{76.01,42.03},{75.62,42.73},{78.73,43.51},{80.48,42.66},{81.04,45.0},{81.66,45.49},{80.88,45.75},{80.83,46.95},},},{[45]={{18.4,17.76},{18.26,17.99},{18.28,18.25},{18.37,18.65},{18.27,18.38},{18.15,18.07},{18.13,17.7},{18.42,17.56},{18.64,17.2},{18.89,16.78},{19.11,16.32},{19.23,16.05},{19.34,15.78},{19.56,15.39},{19.43,15.89},{19.25,16.48},{19.0,16.66},{18.81,17.04},{18.66,17.5},{18.46,17.92},},[267]={{81.12,44.98},{80.96,45.24},{80.98,45.54},{81.08,45.98},{80.98,45.67},{80.84,45.33},{80.81,44.92},{81.14,44.76},{81.39,44.35},{81.67,43.88},{81.91,43.36},{82.05,43.06},{82.18,42.75},{82.42,42.32},{82.27,42.87},{82.08,43.55},{81.79,43.74},{81.57,44.17},{81.41,44.69},{81.19,45.16},},},267,nil,nil,87,nil,},
[2245] = {'Syndicate Saboteur',1536,1604,37,38,0,{[36]={{56.96,26.02},{57.76,30.23},{54.4,20.94},{56.9,26.9},{55.59,27.99},{55.71,27.04},{48.13,18.13},{53.81,19.91},},},nil,36,nil,nil,87,nil,},
[2246] = {'Syndicate Assassin',1604,1678,38,39,0,{[36]={{38.44,14.58},{42.34,20.29},{41.18,21.04},{40.64,22.54},{40.73,19.92},{39.53,15.06},{38.91,15.43},{39.2,19.22},{39.94,15.39},{39.74,20.05},{39.62,15.8},{39.37,15.09},{40.51,16.8},{37.4,15.51},{38.51,15.43},{38.03,13.74},},},nil,36,nil,nil,87,nil,},
[2247] = {'Syndicate Enforcer',1678,1753,39,40,0,{[36]={{38.94,13.1},{39.36,21.07},{38.32,22.46},{41.63,19.49},{39.39,15.1},{40.32,18.56},{39.24,14.69},{41.26,17.92},{43.02,18.32},{38.32,16.53},{37.05,13.11},},},{[28]={{16.55,75.77},{16.39,75.55},{16.22,75.15},{16.04,75.13},{15.9,75.14},{15.76,75.23},{15.55,75.35},{15.74,75.25},{15.94,75.15},{16.12,75.12},{16.25,75.14},{16.36,75.47},{16.47,75.65},{16.63,75.79},{16.83,75.78},{17.04,75.72},{17.18,75.67},{17.24,75.5},{17.2,75.22},{17.26,75.59},{17.27,75.98},{17.35,76.27},{17.44,76.49},{17.57,76.84},{17.47,76.62},{17.29,76.19},{17.23,75.63},{17.01,75.69},{16.79,75.76},{16.61,75.74},},[36]={{38.51,16.36},{38.27,16.03},{38.01,15.41},{37.73,15.38},{37.52,15.4},{37.3,15.53},{36.98,15.72},{37.26,15.57},{37.57,15.41},{37.85,15.36},{38.06,15.39},{38.21,15.9},{38.39,16.18},{38.63,16.39},{38.94,16.37},{39.26,16.29},{39.48,16.2},{39.57,15.95},{39.5,15.51},{39.59,16.09},{39.62,16.68},{39.75,17.13},{39.88,17.46},{40.08,18.01},{39.92,17.66},{39.65,17.01},{39.56,16.14},{39.22,16.24},{38.88,16.34},{38.6,16.31},},[85]={{73.66,87.73},{73.51,87.52},{73.34,87.14},{73.17,87.12},{73.04,87.13},{72.91,87.22},{72.7,87.33},{72.88,87.24},{73.07,87.14},{73.24,87.11},{73.37,87.13},{73.47,87.44},{73.58,87.62},{73.73,87.75},{73.92,87.74},{74.12,87.69},{74.26,87.63},{74.31,87.48},{74.27,87.21},{74.33,87.56},{74.34,87.93},{74.42,88.21},{74.5,88.41},{74.63,88.75},{74.53,88.54},{74.36,88.13},{74.31,87.6},{74.09,87.66},{73.88,87.72},{73.71,87.7},},[130]={{89.17,16.86},{89.01,16.64},{88.83,16.22},{88.64,16.21},{88.5,16.22},{88.36,16.31},{88.14,16.43},{88.33,16.33},{88.54,16.22},{88.72,16.19},{88.86,16.21},{88.97,16.55},{89.09,16.74},{89.25,16.88},{89.45,16.87},{89.66,16.81},{89.81,16.75},{89.87,16.59},{89.83,16.29},{89.89,16.68},{89.9,17.07},{89.99,17.37},{90.08,17.59},{90.21,17.96},{90.11,17.73},{89.93,17.29},{89.87,16.71},{89.64,16.78},{89.41,16.85},{89.22,16.83},},},36,nil,nil,87,nil,},
[2248] = {'Cave Yeti',1050,1107,30,31,0,{[267]={{46.45,30.59},{44.92,25.09},{43.96,27.36},{46.37,34.01},{45.42,33.96},{47.4,30.88},{46.27,31.92},{42.78,32.65},{42.06,33.18},{42.84,31.77},{42.24,31.95},{44.55,29.36},{44.55,31.21},{45.28,31.24},{44.86,28.33},{45.25,33.57},{47.36,32.09},},},{[36]={{42.75,95.38},{42.59,95.25},{42.34,95.06},{42.04,94.82},{41.9,94.69},{42.43,95.12},{42.57,95.23},},[130]={{91.99,69.54},{91.89,69.45},{91.72,69.32},{91.52,69.16},{91.43,69.08},{91.78,69.36},{91.87,69.44},},[267]={{46.26,31.9},{46.12,31.78},{45.91,31.61},{45.64,31.4},{45.52,31.29},{45.98,31.67},{46.1,31.76},},},267,nil,nil,16,nil,},
[2249] = {'Ferocious Yeti',1107,1163,31,32,0,{[267]={{43.4,27.52},{45.14,27.18},{44.38,25.03},{43.64,26.85},{43.45,25.66},{42.88,33.47},{42.27,30.53},{43.46,30.59},{44.83,29.98},{43.97,30.2},{45.01,26.06},{43.58,29.78},{43.38,27.79},{43.91,28.73},{43.97,31.01},{45.27,29.61},{44.15,27.71},},},{[36]={{40.39,90.61},{40.62,90.68},{40.92,90.85},{41.2,91.13},{41.47,91.62},{41.66,92.35},{41.73,93.08},{41.78,93.85},{41.85,94.44},{41.93,94.72},{41.59,94.81},{41.3,94.73},{41.5,94.47},{41.79,94.22},{41.76,93.7},{41.7,93.07},{41.64,92.28},{41.44,91.62},{41.07,90.99},{40.65,90.69},},[130]={{90.42,66.36},{90.57,66.41},{90.77,66.52},{90.96,66.7},{91.14,67.03},{91.27,67.52},{91.31,68.0},{91.35,68.52},{91.39,68.91},{91.45,69.1},{91.22,69.16},{91.03,69.11},{91.16,68.93},{91.35,68.77},{91.33,68.42},{91.29,68.0},{91.25,67.47},{91.12,67.03},{90.87,66.61},{90.59,66.41},},[267]={{44.19,27.72},{44.4,27.79},{44.66,27.93},{44.9,28.17},{45.14,28.61},{45.31,29.24},{45.37,29.88},{45.41,30.56},{45.48,31.07},{45.55,31.31},{45.25,31.4},{44.99,31.33},{45.17,31.1},{45.42,30.88},{45.4,30.43},{45.34,29.87},{45.29,29.18},{45.12,28.6},{44.79,28.05},{44.42,27.79},},},267,nil,nil,16,nil,},
[2250] = {'Mountain Yeti',1163,1221,32,33,0,{[36]={{30.57,64.52},{31.3,65.67},{32.51,67.17},{39.15,67.27},{40.19,70.1},{40.58,73.74},{39.32,72.6},{39.36,68.25},{37.01,72.45},{38.68,74.01},{34.65,68.64},{34.6,72.11},{33.22,67.08},{33.22,70.25},{36.81,70.49},{29.75,63.35},{30.97,61.79},{30.9,58.08},},},nil,36,nil,nil,16,nil,},
[2251] = {'Giant Yeti',1221,1279,33,34,0,{[36]={{32.29,49.16},{32.17,45.43},{32.88,43.01},{41.86,63.29},{33.8,39.75},{35.83,37.76},{29.8,54.04},{37.33,66.21},{36.78,36.41},{37.52,67.25},{35.88,35.5},{37.67,65.99},{30.87,50.92},{29.64,49.21},{30.92,47.5},{30.94,54.51},{39.06,64.98},{40.51,63.26},{41.92,65.27},{42.75,62.55},{41.5,61.68},{43.96,64.95},{42.91,66.73},{41.35,69.21},{40.35,67.02},{39.46,65.3},{35.55,73.81},{35.8,70.46},{35.42,67.08},{36.85,69.0},{29.71,59.95},{29.81,56.07},{29.73,52.87},{32.01,53.03},},},{[36]={{37.52,67.06},{37.51,67.34},{37.52,67.73},{37.53,68.18},{37.53,67.69},{37.52,67.31},{37.53,66.53},{37.51,66.87},},[130]={{88.5,50.66},{88.5,50.85},{88.51,51.1},{88.52,51.41},{88.51,51.08},{88.5,50.82},{88.51,50.3},{88.5,50.53},},[267]={{41.68,7.12},{41.67,7.36},{41.68,7.7},{41.7,8.09},{41.69,7.67},{41.68,7.33},{41.69,6.65},{41.67,6.95},},},36,nil,nil,16,nil,},
[2252] = {'Crushridge Ogre',1163,1220,34,35,0,{[36]={{53.64,36.04},{51.74,45.41},{52.6,42.07},{52.47,38.16},{46.33,32.8},{45.18,29.41},{53.02,45.47},{54.84,54.53},{41.53,30.59},{55.75,54.32},{53.72,54.38},{49.15,39.08},{51.04,34.95},{49.98,31.5},{49.95,34.53},{49.91,32.81},{51.1,40.31},{45.33,37.86},{46.35,39.85},{55.5,40.57},{52.38,40.2},{53.59,41.89},{54.49,43.33},{51.21,46.76},{53.2,45.08},{54.53,52.75},{50.15,52.74},{52.49,52.61},{51.43,36.55},{48.61,54.25},{47.42,60.37},{43.92,32.81},{43.93,36.52},{44.92,60.2},{45.39,61.33},{46.47,35.21},{48.93,36.94},{49.93,42.09},{49.88,38.16},{48.9,43.25},{49.05,61.32},{49.96,59.63},{53.3,47.95},{47.54,63.59},{46.18,63.06},{51.75,45.23},{53.06,45.63},{51.0,56.38},{48.75,54.9},},},nil,36,nil,nil,45,nil,},
[2253] = {'Crushridge Brute',1220,1277,35,36,0,{[36]={{42.81,31.15},{47.68,38.64},{48.47,57.25},{47.34,36.39},{47.61,40.41},{52.37,47.46},{52.89,47.63},{47.46,44.51},{52.43,45.57},{46.48,58.37},{50.23,56.22},{51.4,52.67},{51.55,54.59},{51.21,38.28},{48.89,42.05},{51.28,58.03},{44.17,34.88},{45.67,34.93},{45.19,31.42},{47.83,33.39},{47.69,33.04},{48.09,43.55},{52.14,43.96},{50.69,45.28},{51.1,45.59},{53.61,45.58},{48.81,59.86},{46.55,60.9},{51.45,47.5},{49.64,54.2},},},{[36]={{50.24,56.5},{50.64,56.19},{51.08,55.83},{51.33,55.45},{51.5,54.97},{51.72,54.67},{52.19,54.44},{52.65,54.18},{52.21,54.35},{51.78,54.82},{51.28,55.59},{50.89,55.93},{50.3,56.51},{50.09,57.27},{49.89,58.35},{50.01,57.51},{50.22,56.43},{50.14,55.34},{49.97,54.89},{49.56,53.84},{49.84,54.54},{50.16,55.75},{47.86,33.56},{47.92,33.87},{47.93,34.45},{47.9,33.88},{47.86,33.52},{47.77,33.11},{47.65,32.72},{47.73,33.08},{47.81,33.34},{50.64,45.26},{50.52,45.18},{50.3,45.15},{49.93,45.2},{49.71,45.01},{49.5,44.68},{49.72,45.0},{49.97,45.18},{50.35,45.17},{50.76,45.23},{51.02,44.93},{51.19,44.6},{51.53,43.94},{51.94,43.83},{52.22,44.21},{51.98,43.87},{51.68,43.87},{51.39,44.05},{51.23,44.62},{51.09,44.99},},[130]={{96.99,43.62},{97.26,43.41},{97.54,43.17},{97.71,42.92},{97.83,42.6},{97.97,42.4},{98.28,42.24},{98.59,42.07},{98.3,42.19},{98.01,42.5},{97.68,43.01},{97.42,43.24},{97.02,43.62},{96.88,44.13},{96.76,44.85},{96.83,44.29},{96.97,43.57},{96.92,42.84},{96.8,42.54},{96.53,41.84},{96.72,42.31},{96.93,43.12},{95.4,28.33},{95.44,28.53},{95.45,28.92},{95.42,28.54},{95.4,28.3},{95.34,28.02},{95.26,27.77},{95.31,28.01},{95.36,28.18},{97.25,36.13},{97.17,36.07},{97.03,36.05},{96.78,36.08},{96.63,35.96},{96.49,35.74},{96.64,35.95},{96.81,36.07},{97.06,36.07},{97.33,36.11},{97.5,35.91},{97.62,35.69},{97.85,35.24},{98.12,35.18},{98.31,35.42},{98.15,35.2},{97.94,35.2},{97.76,35.32},{97.64,35.7},{97.55,35.95},},[28]={{22.64,86.97},{22.68,87.17},{22.69,87.55},{22.66,87.18},{22.64,86.94},{22.58,86.67},{22.5,86.42},{22.55,86.66},{22.6,86.82},{24.45,94.59},{24.37,94.53},{24.23,94.52},{23.99,94.55},{23.84,94.43},{23.71,94.21},{23.85,94.42},{24.01,94.54},{24.26,94.53},{24.53,94.57},{24.69,94.37},{24.8,94.16},{25.03,93.73},{25.3,93.66},{25.48,93.9},{25.32,93.68},{25.12,93.69},{24.94,93.8},{24.83,94.17},{24.74,94.41},},[85]={{79.45,98.39},{79.49,98.58},{79.49,98.94},{79.47,98.59},{79.45,98.36},{79.39,98.11},{79.32,97.87},{79.37,98.09},{79.42,98.25},},},36,nil,nil,45,nil,},
[2254] = {'Crushridge Mauler',3831,4008,36,37,1,{[36]={{39.33,40.12},{38.29,41.97},{39.46,38.78},{41.75,43.49},{41.7,44.87},{43.83,51.25},{40.38,45.67},{46.42,46.87},{43.94,46.65},{45.83,47.74},{43.11,46.89},{43.88,49.01},{43.25,50.17},{42.47,47.71},{41.41,48.67},{45.93,45.84},},},{[28]={{17.12,90.36},{17.45,90.99},{17.36,91.6},{17.55,91.86},{17.67,91.99},{17.68,92.65},{17.38,92.93},{16.81,92.9},{17.38,92.93},{17.68,92.65},{17.67,91.99},{17.55,91.86},{17.36,91.6},{17.45,90.99},{18.93,94.0},{18.74,94.38},{18.23,94.31},{17.76,94.22},{17.53,94.85},{17.39,95.0},{17.17,94.9},{16.95,94.75},{16.87,94.23},{16.95,94.75},{17.17,94.9},{17.39,95.0},{17.53,94.85},{17.76,94.22},{18.23,94.31},{18.74,94.38},{18.74,96.49},{18.71,95.85},{18.57,95.49},{17.99,95.68},{18.57,95.49},{18.71,95.85},{18.74,96.49},{18.86,96.72},{18.97,96.72},{19.24,96.64},{19.55,96.67},{19.6,96.91},{19.61,97.15},{19.71,97.87},{19.65,97.72},{19.61,97.47},{19.59,97.3},{19.61,97.15},{19.6,96.9},{19.55,96.67},{19.24,96.64},{18.97,96.72},{18.86,96.72},{19.59,97.3},{19.61,97.47},{19.65,97.72},{19.71,97.87},{19.77,98.33},{20.01,98.74},{19.77,98.32},},[36]={{39.39,38.77},{39.9,39.74},{39.76,40.68},{40.04,41.07},{40.24,41.27},{40.24,42.28},{39.79,42.71},{38.92,42.66},{39.79,42.71},{40.24,42.28},{40.24,41.27},{40.04,41.07},{39.76,40.68},{39.9,39.74},{42.16,44.36},{41.88,44.95},{41.09,44.84},{40.38,44.69},{40.01,45.67},{39.81,45.9},{39.46,45.74},{39.13,45.51},{39.0,44.71},{39.13,45.51},{39.46,45.74},{39.81,45.9},{40.01,45.67},{40.38,44.69},{41.09,44.84},{41.88,44.95},{41.88,48.18},{41.82,47.2},{41.62,46.65},{40.73,46.93},{41.62,46.65},{41.82,47.2},{41.88,48.18},{42.05,48.53},{42.23,48.53},{42.65,48.41},{43.12,48.46},{43.2,48.82},{43.22,49.19},{43.36,50.31},{43.27,50.07},{43.21,49.68},{43.19,49.42},{43.22,49.19},{43.2,48.81},{43.12,48.46},{42.65,48.41},{42.23,48.53},{42.05,48.53},{43.19,49.42},{43.21,49.68},{43.27,50.07},{43.36,50.31},{43.46,51.01},{43.82,51.63},{43.46,50.99},},[130]={{89.75,31.8},{90.09,32.44},{90.0,33.07},{90.19,33.33},{90.32,33.46},{90.32,34.14},{90.02,34.43},{89.44,34.39},{90.02,34.43},{90.32,34.14},{90.32,33.46},{90.19,33.33},{90.0,33.07},{90.09,32.44},{91.6,35.53},{91.41,35.92},{90.88,35.84},{90.41,35.75},{90.17,36.4},{90.03,36.55},{89.8,36.44},{89.58,36.29},{89.49,35.76},{89.58,36.29},{89.8,36.44},{90.03,36.55},{90.17,36.4},{90.41,35.75},{90.88,35.84},{91.41,35.92},{91.41,38.07},{91.37,37.42},{91.24,37.05},{90.64,37.24},{91.24,37.05},{91.37,37.42},{91.41,38.07},{91.53,38.31},{91.64,38.31},{91.92,38.23},{92.24,38.26},{92.29,38.5},{92.3,38.75},{92.4,39.49},{92.34,39.33},{92.3,39.07},{92.28,38.9},{92.3,38.75},{92.29,38.49},{92.24,38.26},{91.92,38.23},{91.64,38.31},{91.53,38.31},{92.28,38.9},{92.3,39.07},{92.34,39.33},{92.4,39.49},{92.46,39.96},{92.71,40.37},{92.46,39.94},},},36,nil,nil,45,nil,},
[2255] = {'Crushridge Mage',2910,3012,37,38,1,{[36]={{41.28,39.9},{38.44,40.18},{38.93,49.55},{40.3,47.53},{40.39,43.69},{42.82,45.8},{45.61,46.63},{43.33,48.01},},},nil,36,nil,nil,45,nil,},
[2256] = {'Crushridge Enforcer',4185,4377,38,39,1,{[36]={{40.5,51.05},{39.9,49.15},{38.19,51.28},{38.18,52.52},{36.85,51.01},{35.67,49.08},{37.89,49.21},{40.35,54.44},{39.5,56.18},{38.12,59.9},{38.18,54.54},{36.85,56.41},{39.24,54.7},},[130]={{89.65,42.42},},},{[36]={{38.08,53.66},{38.17,52.67},{38.76,51.56},{39.68,50.23},{39.84,48.3},{39.67,50.27},{38.75,51.61},{38.17,52.67},{34.8,50.98},{34.39,50.94},{34.48,49.78},{34.39,50.94},{34.8,50.92},{35.73,50.36},{36.57,49.58},{37.1,50.62},{37.46,51.26},{38.0,52.85},{38.38,54.35},{38.92,54.86},{39.23,54.72},{38.92,54.86},{38.38,54.35},{38.0,52.85},{37.46,51.26},{37.1,50.62},{36.57,49.58},{35.73,50.36},},[130]={{88.88,41.72},{88.94,41.07},{89.34,40.33},{89.94,39.44},{90.05,38.15},{89.94,39.47},{89.33,40.36},{88.94,41.07},{86.69,39.94},{86.42,39.91},{86.48,39.14},{86.42,39.91},{86.69,39.9},{87.31,39.53},{87.87,39.01},{88.22,39.7},{88.46,40.13},{88.83,41.19},{89.08,42.19},{89.44,42.52},{89.65,42.44},{89.44,42.52},{89.08,42.19},{88.83,41.19},{88.46,40.13},{88.22,39.7},{87.87,39.01},{87.31,39.53},},[28]={{16.32,99.42},{16.72,98.69},{17.31,97.82},{17.41,96.57},{17.31,97.85},{16.71,98.72},{16.32,99.42},{14.14,98.31},{13.87,98.29},{13.93,97.53},{13.87,98.29},{14.14,98.27},{14.74,97.91},{15.29,97.4},{15.63,98.08},{15.86,98.5},{16.22,99.53},{16.22,99.53},{15.86,98.5},{15.63,98.08},{15.29,97.4},{14.74,97.91},},},36,nil,nil,45,nil,},
[2257] = {'Mug\'thol',5148,5148,43,43,1,{[36]={{35.68,54.25},},},nil,36,nil,nil,45,nil,},
[2258] = {'Stone Fury',1536,1536,37,37,4,{[36]={{64.68,44.77},},},{[28]={{33.59,94.27},{33.7,94.63},{33.91,95.3},{34.24,95.73},{35.62,95.81},{36.01,95.56},{36.42,95.4},{37.42,95.47},{38.27,95.33},{39.26,95.3},{40.43,95.56},{41.68,95.49},{42.45,94.98},{43.12,94.12},{43.55,92.72},{43.64,91.43},{43.55,92.72},{43.12,94.14},{42.45,94.99},{41.67,95.49},{40.42,95.56},{39.25,95.3},{38.26,95.33},{37.41,95.47},{36.41,95.4},{35.99,95.57},{35.61,95.81},{34.22,95.74},{33.9,95.3},{33.7,94.63},},[36]={{64.68,44.77},{64.85,45.32},{65.17,46.36},{65.67,47.02},{67.79,47.13},{68.39,46.76},{69.02,46.5},{70.56,46.61},{71.87,46.39},{73.38,46.35},{75.18,46.75},{77.1,46.64},{78.29,45.86},{79.32,44.55},{79.97,42.39},{80.11,40.41},{79.97,42.39},{79.31,44.58},{78.28,45.87},{77.09,46.65},{75.18,46.75},{73.38,46.35},{71.85,46.39},{70.54,46.61},{69.01,46.5},{68.37,46.76},{67.79,47.14},{65.65,47.02},{65.16,46.35},{64.85,45.33},},},36,nil,nil,91,nil,},
[2260] = {'Syndicate Rogue',531,573,21,22,0,{[267]={{65.36,46.57},{66.08,45.6},{66.04,48.13},{66.08,48.73},{81.01,46.61},{79.28,46.37},{75.02,40.67},{67.1,50.91},{81.04,44.59},{78.71,41.78},{77.76,44.18},{75.57,42.22},{80.41,44.84},{81.84,45.21},{82.24,42.36},{80.53,46.89},},},nil,267,nil,nil,87,nil,},
[2261] = {'Syndicate Watchman',494,531,20,21,0,{[267]={{82.9,44.42},{78.8,47.58},{81.74,47.53},{81.76,44.62},{83.82,40.9},{82.88,40.33},{75.73,44.05},{74.37,40.5},{75.15,37.95},{74.77,39.11},{65.78,48.49},{67.05,46.24},{67.07,47.7},{67.2,50.21},{67.6,47.59},{77.25,39.01},{81.65,39.8},{82.07,39.63},{79.35,46.83},{79.16,40.19},{77.84,40.37},{77.91,41.35},{78.31,41.36},{79.61,39.37},{79.55,40.06},{79.83,40.76},{75.36,39.7},{80.41,40.72},{79.75,44.57},{78.75,45.24},{79.54,45.55},{78.19,44.45},{75.97,41.48},{76.39,41.16},{76.23,40.83},{76.67,42.74},{75.23,42.07},{76.74,44.19},{76.66,46.77},{76.36,46.41},{77.16,45.25},{78.18,43.19},{78.14,46.5},{79.71,43.17},{81.16,41.95},{81.68,41.27},{80.75,43.81},{80.6,46.02},{81.92,44.6},{82.68,41.52},{82.01,43.22},{80.08,45.39},},},{[45]={{5.79,18.98},{5.64,18.9},{5.45,18.86},{5.27,18.94},{5.07,19.16},{4.96,19.45},{4.98,19.77},{5.01,20.0},{5.09,20.25},{5.22,20.51},{5.39,20.54},{5.52,20.48},{5.76,20.39},{5.93,20.25},{6.0,20.03},{6.06,19.8},{6.09,19.57},{6.09,19.43},{6.05,19.28},{5.86,20.28},{5.94,20.14},{6.01,19.98},{6.07,19.82},{6.1,19.66},{6.09,19.43},{6.02,19.18},{5.89,19.05},{5.71,18.93},{5.49,18.86},{5.34,18.93},{5.16,19.02},{5.08,19.11},{4.97,19.39},{4.95,19.62},{4.97,19.85},{5.07,20.27},{5.21,20.51},{5.4,20.51},{5.72,20.43},{15.48,13.59},{15.44,13.39},{15.39,13.09},{15.37,12.95},{15.45,13.33},{15.5,13.69},{15.54,14.04},{15.61,14.38},{15.76,14.64},{15.93,14.8},{16.16,15.03},{16.35,15.17},{16.48,15.32},{16.65,15.58},{16.85,15.95},{16.72,15.69},{16.56,15.44},{16.41,15.26},{16.29,15.13},{16.02,14.95},{15.66,14.65},{15.57,14.42},{15.52,13.92},{17.22,17.42},{17.02,17.51},{16.84,17.66},{16.65,17.7},{16.33,17.64},{16.17,17.91},{16.31,18.16},{16.55,18.45},{16.75,18.57},{17.0,18.39},{17.19,18.02},{17.38,17.72},{17.59,17.4},{17.77,17.13},{17.93,16.96},{18.14,16.94},{18.35,16.9},{18.13,16.95},{17.93,16.99},{17.87,17.0},{17.79,17.14},{17.62,17.34},{17.46,17.38},{14.22,14.36},{14.29,14.1},{14.25,13.78},{14.12,13.48},{13.9,13.51},{13.65,13.68},{13.51,14.02},{13.54,14.44},{13.64,14.83},{13.78,15.13},{14.01,15.51},{14.1,15.88},{14.25,16.25},{14.51,16.31},{14.8,16.1},{14.76,15.74},{14.55,15.4},{14.4,14.98},{14.29,14.59},{14.87,18.18},{14.71,18.43},{14.52,18.79},{14.25,19.25},{14.45,18.95},{14.71,18.43},{14.87,18.15},{14.96,17.85},{15.01,17.73},{15.07,17.6},{15.15,17.39},{15.28,17.09},{15.44,16.75},{15.53,16.53},{15.58,16.43},{15.67,16.26},{15.58,16.45},{15.48,16.67},{15.35,16.93},{15.18,17.32},{15.05,17.58},{14.97,17.76},{14.95,17.82},{17.05,16.14},{17.26,16.09},{17.53,16.0},{17.87,15.88},{18.06,15.69},{18.24,15.46},{18.43,15.2},{18.66,15.05},{18.45,15.1},{18.22,15.34},{18.07,15.65},{17.88,15.94},{17.64,16.07},{17.47,16.09},{17.2,16.12},{16.97,16.23},{16.79,16.33},{16.53,16.43},{16.33,16.42},{16.1,16.38},{16.26,16.35},{16.51,16.38},{16.74,16.36},{16.92,16.18},},[267]={{66.93,46.36},{66.76,46.26},{66.55,46.22},{66.35,46.31},{66.12,46.56},{66.0,46.88},{66.02,47.24},{66.06,47.5},{66.14,47.78},{66.29,48.07},{66.48,48.11},{66.63,48.04},{66.9,47.94},{67.08,47.79},{67.17,47.54},{67.23,47.27},{67.27,47.02},{67.27,46.85},{67.23,46.69},{67.01,47.82},{67.1,47.65},{67.18,47.48},{67.24,47.29},{67.28,47.12},{67.26,46.86},{67.19,46.58},{67.05,46.43},{66.84,46.3},{66.59,46.22},{66.43,46.3},{66.23,46.39},{66.13,46.49},{66.01,46.81},{65.98,47.07},{66.01,47.33},{66.12,47.8},{66.27,48.08},{66.49,48.08},{66.85,47.98},{77.83,40.29},{77.79,40.07},{77.73,39.73},{77.71,39.57},{77.79,39.99},{77.86,40.4},{77.89,40.8},{77.98,41.18},{78.15,41.47},{78.33,41.65},{78.6,41.9},{78.81,42.06},{78.95,42.23},{79.15,42.53},{79.37,42.94},{79.22,42.65},{79.05,42.37},{78.88,42.17},{78.74,42.02},{78.44,41.82},{78.04,41.48},{77.94,41.23},{77.87,40.66},{79.78,44.59},{79.56,44.69},{79.36,44.86},{79.15,44.92},{78.79,44.84},{78.6,45.15},{78.76,45.43},{79.03,45.76},{79.26,45.89},{79.55,45.69},{79.76,45.27},{79.96,44.94},{80.2,44.57},{80.41,44.27},{80.59,44.08},{80.82,44.06},{81.05,44.01},{80.81,44.07},{80.59,44.11},{80.52,44.13},{80.43,44.28},{80.24,44.51},{80.06,44.55},{76.42,41.15},{76.49,40.86},{76.45,40.5},{76.3,40.16},{76.05,40.2},{75.77,40.39},{75.62,40.77},{75.64,41.24},{75.76,41.68},{75.92,42.02},{76.18,42.45},{76.28,42.86},{76.44,43.28},{76.74,43.35},{77.07,43.11},{77.02,42.71},{76.78,42.33},{76.61,41.85},{76.49,41.41},{77.14,45.45},{76.97,45.74},{76.75,46.14},{76.45,46.66},{76.67,46.32},{76.96,45.73},{77.15,45.42},{77.25,45.08},{77.31,44.95},{77.37,44.79},{77.46,44.57},{77.61,44.23},{77.78,43.84},{77.89,43.6},{77.94,43.48},{78.04,43.3},{77.95,43.5},{77.83,43.76},{77.69,44.05},{77.49,44.48},{77.35,44.77},{77.26,44.98},{77.23,45.05},{79.59,43.16},{79.84,43.1},{80.14,43.0},{80.52,42.86},{80.73,42.65},{80.93,42.39},{81.15,42.1},{81.41,41.94},{81.17,41.98},{80.92,42.26},{80.75,42.61},{80.53,42.93},{80.26,43.08},{80.07,43.1},{79.76,43.14},{79.5,43.26},{79.31,43.37},{79.01,43.48},{78.79,43.47},{78.53,43.43},{78.71,43.39},{78.99,43.43},{79.25,43.4},{79.45,43.2},},},267,nil,nil,87,nil,},
[2263] = {'Marshal Redpath',2568,2568,41,41,0,{[267]={{49.47,58.73},},},nil,267,{500,504,561,},{500,504,560,},12,"A",},
[2264] = {'Hillsbrad Tailor',664,713,24,25,0,{[267]={{36.82,44.26},{36.76,44.48},},},nil,267,nil,nil,123,"A",},
[2265] = {'Hillsbrad Apprentice Blacksmith',580,610,24,25,0,{[267]={{32.62,45.14},{31.15,46.72},{31.89,46.72},{31.96,45.83},{31.17,43.9},{31.61,44.48},},},nil,267,nil,nil,123,"A",},
[2266] = {'Hillsbrad Farmer',603,651,23,24,0,{[267]={{33.8,46.52},{33.88,42.42},{34.9,44.62},{35.8,45.18},{35.17,47.36},{35.59,41.35},{35.85,41.24},{34.79,38.52},{36.38,39.77},{35.46,40.35},{33.2,34.58},{35.13,37.43},{34.02,35.69},{30.74,34.99},{33.42,35.97},{30.53,35.26},{31.7,34.93},{32.79,34.58},{31.72,38.62},{31.4,38.59},{30.31,38.99},{29.68,37.49},{31.86,39.23},},},nil,267,nil,nil,123,"A",},
[2267] = {'Hillsbrad Peasant',664,713,24,25,0,{[267]={{29.77,43.77},{30.27,40.31},{29.85,41.07},{30.81,41.51},{33.66,47.35},{34.06,45.69},{35.41,42.01},{30.84,45.44},{36.44,45.43},{34.69,44.58},{34.76,46.11},{35.09,47.05},{34.78,47.16},{35.59,44.31},{35.48,46.2},},},nil,267,nil,nil,123,"A",},
[2268] = {'Hillsbrad Footman',734,788,25,26,0,{[267]={{29.98,44.2},{29.96,46.41},{33.07,45.72},{32.39,39.67},{31.36,42.22},{30.89,42.42},{32.2,42.93},{29.15,40.12},{34.3,44.23},{34.48,47.98},{36.48,46.92},{37.03,46.85},{32.83,36.69},{33.73,43.09},{29.15,45.72},{33.25,38.06},{32.81,48.53},},},{[130]={{82.87,78.95},{82.67,79.11},{82.48,79.45},{82.34,79.65},{82.14,79.85},{82.36,79.54},{82.59,79.24},{82.78,78.96},{83.03,78.79},{83.33,78.64},{83.66,78.53},{83.94,78.55},{84.17,78.74},{84.43,79.03},{84.51,79.04},{84.38,78.9},{84.12,78.61},{83.88,78.49},{83.52,78.55},{83.15,78.7},{82.97,78.81},},[267]={{34.29,44.25},{34.02,44.46},{33.77,44.9},{33.59,45.16},{33.33,45.43},{33.61,45.02},{33.92,44.62},{34.18,44.26},{34.49,44.04},{34.89,43.84},{35.32,43.69},{35.69,43.72},{36.0,43.98},{36.33,44.35},{36.44,44.36},{36.26,44.18},{35.93,43.8},{35.61,43.65},{35.15,43.72},{34.65,43.92},{34.42,44.06},},},267,nil,nil,123,"A",},
[2269] = {'Hillsbrad Miner',788,840,26,27,0,{[267]={{28.9,57.45},{28.45,57.23},{31.49,52.39},{32.4,52.05},{31.77,51.77},{32.01,53.17},{29.7,56.54},{28.14,51.16},{31.99,54.64},{31.23,53.1},{32.21,55.51},{28.45,51.94},{28.18,57.12},{26.99,58.02},{27.69,57.74},{28.72,55.96},{30.2,58.41},{31.28,57.85},{31.4,59.5},{30.85,58.15},{30.84,59.09},{31.6,58.53},{30.44,55.62},{30.14,56.47},{28.95,57.32},{31.36,54.08},{30.45,53.93},{30.77,55.08},{30.36,53.12},{29.67,54.99},{29.19,53.47},{30.01,53.96},{27.79,54.14},{28.2,56.32},{28.3,54.8},{27.59,56.65},{27.51,57.66},},},nil,267,nil,nil,123,"A",},
[2270] = {'Hillsbrad Sentry',840,896,27,28,0,{[267]={{26.47,61.81},{26.58,60.3},{25.81,59.45},{27.64,61.65},{27.45,60.37},{28.52,60.27},{27.13,58.94},},},{[130]={{76.85,92.34},{77.08,92.24},{77.29,92.09},{77.59,91.8},{77.91,91.42},{78.28,90.99},{78.65,90.98},{78.91,91.0},{78.61,90.94},{78.26,90.93},{78.04,91.26},{77.73,91.61},{77.45,91.96},{77.12,92.22},},[267]={{26.38,61.83},{26.69,61.68},{26.97,61.5},{27.36,61.11},{27.78,60.61},{28.27,60.06},{28.75,60.03},{29.1,60.06},{28.69,59.98},{28.24,59.97},{27.95,60.4},{27.54,60.86},{27.17,61.33},{26.74,61.67},},},267,nil,nil,123,"A",},
[2271] = {'Dalaran Shield Guard',1106,1162,31,32,0,{[36]={{22.1,60.33},{15.03,78.56},{15.15,78.68},{20.91,87.47},{21.63,87.41},{20.81,87.81},{20.96,83.89},{18.42,87.99},{21.22,84.06},{20.44,82.25},{17.66,83.59},{18.0,84.23},{18.11,83.78},{18.4,83.43},{18.77,86.19},{19.0,84.35},},},{[36]={{18.91,84.21},{19.06,83.44},{19.17,82.83},{19.03,83.61},{18.88,84.52},{18.79,84.46},{18.66,84.41},{18.79,84.43},{18.69,85.04},{18.88,84.6},},[130]={{76.1,62.1},{76.2,61.58},{76.27,61.17},{76.18,61.69},{76.08,62.3},{76.02,62.26},{75.93,62.23},{76.02,62.24},{75.95,62.65},{76.08,62.35},},[267]={{25.4,22.13},{25.53,21.45},{25.63,20.92},{25.51,21.6},{25.37,22.4},{25.3,22.34},{25.18,22.3},{25.3,22.32},{25.21,22.85},{25.37,22.47},},},36,nil,nil,76,"AH",},
[2272] = {'Dalaran Theurgist',882,919,32,33,0,{[36]={{22.2,60.36},{18.93,77.81},{20.42,87.43},{19.93,83.76},{17.87,83.11},{17.16,83.26},{18.25,84.28},{22.57,60.91},},},{[36]={{20.34,87.37},{20.59,86.74},{20.81,86.19},{20.66,85.49},{20.38,85.17},{19.8,84.82},{19.47,84.77},{19.24,85.29},{18.95,85.92},{19.25,86.4},{19.67,86.86},{20.09,87.24},},[130]={{77.05,64.2},{77.22,63.78},{77.36,63.42},{77.27,62.95},{77.08,62.73},{76.69,62.5},{76.47,62.46},{76.32,62.81},{76.12,63.23},{76.33,63.56},{76.6,63.86},{76.88,64.12},},[267]={{26.65,24.89},{26.87,24.33},{27.06,23.86},{26.93,23.24},{26.69,22.96},{26.18,22.65},{25.89,22.61},{25.68,23.06},{25.43,23.62},{25.7,24.04},{26.06,24.44},{26.43,24.78},},},36,nil,nil,76,"AH",},
[2274] = {'Stanley',664,664,24,24,0,{[267]={{32.66,35.32},},},nil,267,nil,{502,},35,"AH",},
[2275] = {'Enraged Stanley',664,664,24,24,0,nil,nil,0,nil,nil,32,"AH",},
[2276] = {'Magistrate Henry Maleb',2210,2210,30,30,1,{[267]={{48.14,59.11},},},nil,267,{505,512,523,537,},{505,510,512,522,523,525,537,},96,"A",},
[2277] = {'Loremaster Dibbs',1605,1605,30,30,0,{[267]={{50.57,57.09},},},nil,267,{514,540,542,554,},{511,538,540,551,},12,"A",},
[2278] = {'Melisara',1240,1240,25,25,0,{[267]={{62.63,20.65},},},nil,267,{518,519,520,521,},{495,518,519,520,},68,"H",},
[2283] = {'Ravenclaw Regent',508,508,22,22,4,{[130]={{56.83,70.18},},},nil,130,nil,nil,21,nil,},
[2284] = {'Captured Farmer',138,138,4,4,0,{[267]={{62.9,18.73},{62.81,19.11},{62.66,18.74},},},nil,267,nil,nil,35,"AH",},
[2285] = {'Count Remington Ridgewell',2471,2471,40,40,0,{[1519]={{74.01,30.24},},},nil,1519,{543,4766,},{543,4765,},12,"A",},
[2287] = {'Crushridge Warmonger',4377,4572,39,40,1,{[36]={{34.94,53.45},{35.56,53.19},{40.53,52.96},{36.25,53.62},{36.37,53.93},{35.69,55.52},{36.3,53.79},{36.37,52.31},{35.91,52.76},{35.57,53.23},{36.16,54.95},{36.32,52.51},{35.07,53.29},{35.88,55.57},{37.04,54.46},{35.77,53.86},{36.26,54.99},{35.83,54.31},{36.83,49.08},{35.71,51.04},{37.03,53.15},{39.16,54.5},{39.24,59.55},{38.36,57.8},{38.08,55.98},{36.75,58.02},},},nil,36,nil,nil,45,nil,},
[2299] = {'Borgus Stoutarm',7842,7842,55,55,1,{[46]={{84.33,68.33},},},nil,46,nil,nil,55,"A",},
[2302] = {'Aethalas',10626,10626,61,61,1,{[1657]={{58.98,37.03},},},nil,1657,nil,nil,1514,"A",},
[2303] = {'Lyranne Feathersong',3643,3643,56,56,0,{[618]={{51.96,29.29},},},nil,618,nil,nil,80,"A",},
[2304] = {'Captain Ironhill',3171,3171,32,32,1,{[267]={{71.13,80.29},},},nil,267,nil,nil,88,"A",},
[2305] = {'Foreman Bonds',852,852,30,30,0,{[267]={{31.21,56.01},},},nil,267,nil,nil,88,"A",},
[2306] = {'Baron Vardus',1239,1239,40,40,0,{[36]={{47.83,17.11},},},nil,36,nil,nil,16,nil,},
[2307] = {'Caretaker Caice',166,166,5,5,0,{[85]={{32.71,71.13},},},nil,85,nil,nil,68,"H",},
[2308] = {'Andrew Brownell',2471,2471,40,40,0,{[1497]={{74.05,33.31},},},nil,1497,{3341,},{3341,},68,"H",},
[2309] = {'Thomas Arlento',166,166,5,5,0,{[85]={{59.93,52.37},},},nil,85,nil,nil,68,"H",},
[2310] = {'Jamie Nore',166,166,5,5,0,{[85]={{60.78,50.51},},},nil,85,nil,nil,68,"H",},
[2311] = {'Doreen Beltis',166,166,5,5,0,{[85]={{60.32,52.53},},},nil,85,nil,nil,68,"H",},
[2314] = {'Sahvan Bloodshadow',166,166,5,5,0,{[85]={{59.55,51.65},},},{[28]={{1.8,37.89},{2.08,38.07},{2.52,38.39},{2.65,38.65},{2.63,39.2},{2.55,39.35},{2.43,39.55},{2.57,39.31},{2.65,39.19},{2.97,39.21},{3.29,39.14},{3.27,38.73},{2.99,38.36},{2.45,37.99},{1.99,37.88},},[85]={{59.62,51.68},{59.89,51.86},{60.3,52.16},{60.43,52.4},{60.41,52.93},{60.33,53.07},{60.22,53.26},{60.35,53.04},{60.43,52.92},{60.73,52.94},{61.04,52.88},{61.02,52.49},{60.75,52.14},{60.23,51.78},{59.8,51.67},},},85,nil,nil,68,"H",},
[2315] = {'Maquell Ebonwood',166,166,5,5,0,{[85]={{31.97,65.63},},},{[85]={{32.01,65.63},{32.15,65.63},{32.19,65.63},{32.54,65.58},{32.22,65.62},{32.15,65.62},{31.98,65.63},{31.98,66.19},{31.57,66.2},{31.46,66.2},{30.96,66.19},{31.45,66.2},{31.57,66.2},{31.99,66.19},{31.97,66.29},{32.17,66.3},{32.22,66.3},{32.32,66.3},{32.22,66.3},{32.17,66.3},{32.0,66.3},{32.0,65.94},{32.0,65.29},{32.2,65.62},{32.27,65.63},{32.27,65.76},{32.27,65.74},{32.27,65.65},{32.11,65.56},{32.05,65.58},{31.94,66.01},{31.72,66.23},{30.94,66.2},{31.45,66.2},{31.94,66.14},{31.97,65.64},},},85,nil,nil,68,"H",},
[2316] = {'Gol\'dir',711,711,25,25,0,{[36]={{59.96,43.74},},},nil,36,{506,},{503,},29,"H",},
[2317] = {'Elysa',1240,1240,25,25,0,{[36]={{39.3,14.31},},},nil,36,{508,},{507,},35,"AH",},
[2318] = {'Argus Shadow Mage',1034,1320,35,36,0,{[36]={{58.7,30.52},{56.11,27.3},{47.79,17.45},{53.28,20.73},{57.43,46.21},{60.26,43.98},{61.25,45.83},{63.63,43.7},{62.34,40.58},},},nil,36,nil,nil,16,nil,},
[2319] = {'Syndicate Wizard',954,992,34,35,0,{[36]={{58.15,67.29},{60.17,43.58},{59.91,43.47},{61.33,43.96},{63.15,43.96},{61.48,45.5},{63.23,44.02},{61.85,41.17},{62.34,41.19},{61.61,40.15},{62.25,44.02},},},nil,36,nil,nil,87,nil,},
[2320] = {'Nagaz',1753,1753,40,40,0,{[36]={{39.22,14.31},},},nil,36,nil,nil,16,nil,},
[2321] = {'Foreststrider Fledgling',222,273,11,13,0,{[148]={{45.38,27.44},{47.88,41.05},{44.27,55.8},{47.29,41.32},{39.01,68.82},{39.32,65.6},{43.82,70.67},{47.24,42.61},{47.16,44.79},{38.16,62.65},{44.55,28.84},{44.63,25.72},{44.58,44.35},{43.1,70.54},{48.92,22.78},{43.3,44.52},{39.87,39.77},{45.71,54.75},{46.1,53.02},{39.87,67.13},{45.56,42.9},{44.3,68.86},{47.64,40.14},{40.53,36.68},{43.91,67.28},{43.21,68.06},{45.38,22.93},{38.07,63.93},{43.42,40.68},{40.4,35.0},{40.35,41.27},{39.67,36.6},{41.32,41.46},{39.25,38.49},{41.54,34.66},{45.83,24.93},{39.52,62.52},{41.88,33.75},{44.74,42.58},{45.41,32.17},{42.35,35.1},{44.55,33.42},{42.82,42.64},{39.61,59.71},{42.64,39.71},{38.81,67.01},{42.21,70.12},{39.13,60.67},{41.65,65.77},{45.38,41.11},{43.91,43.24},{39.76,57.38},{41.67,67.5},{38.54,58.2},{44.17,26.34},{40.53,38.44},{44.36,41.4},{41.08,43.17},{39.28,34.83},{41.93,45.96},{43.35,53.45},{42.93,55.28},{43.99,31.55},{45.85,22.17},{44.55,29.9},{34.81,87.3},{42.8,33.47},{42.4,47.46},{38.2,56.62},{38.22,59.45},{41.4,68.56},{43.87,29.3},{38.41,68.13},{43.56,55.05},{45.18,58.04},{39.57,33.93},{38.49,64.66},{47.08,22.51},{46.8,25.76},{43.3,66.13},{38.51,65.39},{38.52,33.5},{44.55,24.5},{42.85,26.37},{45.61,23.43},{43.83,33.45},{43.75,25.75},{42.78,67.31},{41.96,65.5},{38.82,36.42},{42.3,68.46},{43.74,28.07},{46.89,24.48},{44.21,23.41},{38.95,48.68},{38.22,47.49},{47.94,23.62},{34.8,87.34},},[331]={{18.0,3.99},},[361]={{17.03,68.18},},},nil,148,nil,nil,189,"AH",},
[2322] = {'Foreststrider',300,356,14,16,0,{[148]={{48.88,27.32},{49.63,27.72},{49.6,28.42},{48.54,32.16},{48.32,30.63},{48.58,34.69},{43.69,70.51},{39.33,70.21},{53.45,28.86},{46.89,33.64},{48.95,31.15},{49.88,32.22},{47.99,33.67},{49.82,30.53},{54.07,30.51},{48.96,33.55},{46.89,31.07},{53.92,26.1},{52.61,35.36},{51.8,34.71},{51.12,33.78},{50.45,31.91},{47.38,28.47},{49.86,33.88},{47.21,31.91},{49.68,26.0},{48.79,29.1},{48.04,26.79},{37.61,78.84},{39.06,75.03},{39.89,76.39},{42.24,70.81},{38.38,76.6},{40.45,70.76},{42.45,69.04},{40.71,77.3},{52.71,27.89},{51.12,32.51},{50.43,30.27},{49.49,36.53},{50.57,29.27},{49.14,36.59},{49.4,34.95},{43.82,69.7},{52.66,26.15},{37.93,72.38},{38.21,73.73},{38.67,70.51},},},nil,148,nil,nil,189,"AH",},
[2323] = {'Giant Foreststrider',386,449,17,19,0,{[148]={{38.13,81.22},{43.34,82.21},{36.34,91.55},{34.78,88.05},{36.54,91.59},{44.91,91.78},{38.14,83.04},{36.48,94.28},{34.4,86.79},{37.05,88.17},{36.0,89.64},{37.75,89.11},{36.69,93.63},{44.61,91.56},{37.62,90.01},{37.0,94.59},{38.85,90.08},{35.83,80.03},{40.5,89.5},{43.2,80.19},{37.23,80.6},{37.86,89.83},{37.14,95.6},{35.93,89.1},{39.01,80.42},{38.53,92.29},{42.3,89.66},{45.97,91.36},{38.17,95.59},{40.07,91.89},{39.48,81.94},{36.88,92.79},{37.98,91.38},{40.46,93.56},{39.59,93.56},{37.01,83.59},{40.87,92.56},{37.05,81.59},{40.55,81.06},{39.57,94.62},{35.96,82.42},{37.56,92.93},{34.99,82.31},{40.6,92.01},{38.84,94.81},{39.1,91.29},{61.22,14.87},{61.64,14.21},{62.62,9.25},{61.82,11.95},{61.62,12.25},{42.26,80.47},{40.94,82.27},{60.87,10.31},{42.26,89.26},{41.2,83.31},{41.52,88.05},{61.62,8.89},{58.9,13.31},{58.41,14.21},{59.49,12.61},},},nil,148,nil,nil,7,"AH",},
[2324] = {'Blackwood Windtalker',273,300,13,14,0,{[148]={{39.36,56.68},{40.13,56.05},{39.92,54.37},{40.23,54.37},{39.94,55.51},{40.12,52.79},{39.75,56.14},{39.62,54.04},{39.06,52.63},{39.37,53.27},{39.53,53.59},{39.0,53.77},{40.12,53.84},{39.94,54.61},},},{[148]={{39.94,55.42},{39.98,55.62},{40.04,55.88},{40.0,56.03},{39.88,56.27},{39.96,56.07},{39.99,55.87},{39.96,55.56},{39.95,55.39},{39.94,55.19},{39.94,54.99},{39.95,55.17},{39.96,55.38},{39.92,54.61},{39.92,54.34},{39.99,54.14},{40.0,53.9},{39.95,53.64},{39.78,53.57},{39.61,53.57},{39.49,53.6},{39.45,53.83},{39.57,53.97},{39.73,54.17},{39.9,54.45},},[361]={{22.89,31.83},{22.94,32.05},{23.01,32.35},{22.96,32.52},{22.82,32.79},{22.91,32.57},{22.95,32.34},{22.91,31.99},{22.9,31.8},{22.89,31.56},{22.88,31.34},{22.9,31.54},{22.91,31.78},{22.87,30.9},{22.87,30.6},{22.95,30.37},{22.96,30.1},{22.89,29.79},{22.71,29.72},{22.51,29.72},{22.38,29.75},{22.33,30.02},{22.47,30.17},{22.65,30.4},{22.84,30.73},},},148,nil,nil,82,nil,},
[2326] = {'Thamner Pol',334,334,8,8,0,{[1]={{47.18,52.61},},},nil,1,nil,nil,55,"A",},
[2327] = {'Shaina Fuller',2016,2016,35,35,0,{[1519]={{43.08,26.12},},},nil,1519,nil,nil,12,"A",},
[2329] = {'Michelle Belle',456,456,11,11,0,{[12]={{43.39,65.55},},},nil,12,nil,nil,12,"A",},
[2330] = {'Karlee Chaddis',1240,1240,25,25,0,{[1519]={{47.54,64.42},},},{[12]={{23.3,39.22},{24.69,38.24},{25.19,39.4},{26.07,38.58},{27.25,36.98},{26.72,35.88},{27.63,34.5},{27.93,34.8},{28.19,34.81},{29.11,33.6},{29.26,33.44},{28.31,31.71},{28.3,31.02},{29.32,29.26},{29.38,28.96},{28.94,28.25},{28.58,27.59},{28.08,27.86},{27.35,27.83},{26.51,26.96},{26.51,26.69},{25.7,24.93},{25.46,24.66},{25.14,24.97},{24.67,25.44},{24.36,25.79},{24.82,26.85},{24.14,27.74},{23.56,28.3},{22.98,27.66},{22.43,28.19},{22.31,28.8},{21.55,29.93},{21.55,30.02},{22.17,31.14},{22.78,31.2},{23.62,32.81},{23.13,33.43},{22.59,33.93},{22.17,34.24},{21.69,33.79},{21.31,33.59},{20.8,34.0},{20.19,33.97},{19.64,33.38},{19.41,33.39},{19.03,33.85},{18.7,34.23},{18.52,34.45},{18.48,35.74},{18.04,36.19},{17.24,37.28},{17.09,37.35},{16.79,37.83},{16.77,37.96},{17.13,38.67},{17.42,39.29},{17.35,39.55},{17.71,40.52},{17.98,41.26},{17.71,41.54},{16.93,42.39},{16.77,43.99},{16.43,44.95},{16.39,45.12},{16.41,45.76},{16.52,46.02},{16.82,46.35},{16.94,46.35},{17.11,45.93},{17.14,45.77},{17.01,45.66},{17.16,45.74},{17.13,45.85},{17.0,46.18},{16.76,46.35},{16.43,45.79},{16.39,45.06},{16.75,44.36},{16.91,42.33},{17.55,41.68},{17.92,41.34},{18.38,41.01},{18.62,41.0},{19.08,41.21},{19.35,41.41},{19.87,41.72},{20.0,41.74},{20.42,41.45},{22.86,39.6},{22.69,39.78},{22.45,40.03},{22.33,40.22},{22.45,40.61},{22.39,40.78},{21.53,41.82},{21.35,41.77},{21.15,41.46},{20.76,41.49},},[1519]={{48.66,63.42},{52.25,60.9},{53.55,63.89},{55.83,61.78},{58.87,57.64},{57.49,54.79},{59.84,51.24},{60.62,52.01},{61.29,52.05},{63.68,48.91},{64.06,48.51},{61.6,44.04},{61.59,42.24},{64.22,37.71},{64.38,36.93},{63.23,35.09},{62.3,33.4},{61.02,34.09},{59.12,34.02},{56.95,31.77},{56.96,31.06},{54.86,26.53},{54.26,25.83},{53.42,26.64},{52.21,27.84},{51.4,28.75},{52.6,31.49},{50.83,33.78},{49.34,35.22},{47.85,33.56},{46.43,34.94},{46.11,36.52},{44.16,39.45},{44.16,39.66},{45.76,42.55},{47.33,42.7},{49.49,46.88},{48.24,48.47},{46.83,49.77},{45.74,50.58},{44.51,49.42},{43.53,48.9},{42.21,49.95},{40.65,49.87},{39.23,48.35},{38.63,48.36},{37.64,49.57},{36.8,50.55},{36.32,51.12},{36.23,54.43},{35.09,55.6},{33.03,58.41},{32.64,58.59},{31.86,59.83},{31.82,60.18},{32.73,62.0},{33.49,63.59},{33.3,64.27},{34.23,66.79},{34.93,68.69},{34.25,69.4},{32.24,71.6},{31.81,75.75},{30.92,78.22},{30.84,78.66},{30.88,80.3},{31.17,80.99},{31.93,81.84},{32.24,81.83},{32.68,80.75},{32.76,80.35},{32.42,80.05},{32.81,80.27},{32.74,80.55},{32.41,81.39},{31.79,81.83},{30.94,80.39},{30.84,78.49},{31.76,76.71},{32.17,71.46},{33.82,69.78},{34.79,68.89},{35.96,68.05},{36.58,68.02},{37.78,68.56},{38.46,69.09},{39.81,69.89},{40.14,69.93},{41.23,69.2},{47.54,64.42},{47.09,64.86},{46.47,65.52},{46.17,66.01},{46.48,67.01},{46.33,67.45},{44.09,70.13},{43.63,70.0},{43.13,69.2},{42.1,69.28},},},1519,nil,nil,12,"A",},
[2331] = {'Paige Chaddis',64,64,1,1,0,{[1519]={{47.66,64.4},},},nil,1519,nil,nil,12,"A",},
[2332] = {'Valdred Moray',531,531,21,21,0,{[130]={{44.65,84.7},},},nil,130,nil,nil,123,"A",},
[2333] = {'Henchman Valik',3286,3286,30,30,0,{[36]={{57.17,69.51},},},nil,36,{535,},{535,},83,"H",},
[2334] = {'Event Generator 001',166,166,5,5,0,{[1519]={{61.65,61.95},},},nil,1519,nil,nil,12,"A",},
[2335] = {'Magistrate Burnside',773,774,30,30,0,{[267]={{29.67,41.64},},},nil,267,nil,nil,88,"A",},
[2336] = {'Dark Strand Fanatic',356,386,16,17,0,{[148]={{55.78,26.16},{56.5,25.76},{55.75,25.91},{57.07,27.3},{56.14,25.41},{57.3,26.33},{56.84,27.56},{57.82,25.8},{57.87,25.61},{57.08,26.63},{57.02,26.2},{56.57,27.28},{55.8,26.97},{56.04,26.56},{56.19,27.04},{55.76,26.66},{56.78,26.86},{56.52,26.87},{56.94,26.46},{56.07,27.37},{56.55,26.52},{55.1,27.94},{54.98,27.72},{55.4,27.02},{55.2,26.55},{55.35,26.6},},},{[148]={{57.03,26.15},{57.08,25.93},{57.14,25.68},{57.12,25.85},{57.07,26.05},{57.17,26.17},{57.08,26.05},{57.02,26.17},{57.02,26.29},{57.02,26.42},{57.01,26.57},{57.04,26.43},{57.03,26.27},},[618]={{6.72,28.35},{6.76,28.15},{6.83,27.92},{6.8,28.07},{6.76,28.26},{6.85,28.36},{6.77,28.26},{6.71,28.36},{6.71,28.47},{6.71,28.6},{6.7,28.73},{6.73,28.61},{6.72,28.46},},},148,nil,nil,16,nil,},
[2337] = {'Dark Strand Voidcaller',702,739,28,29,0,{[148]={{56.09,26.03},{56.28,25.82},{55.99,26.15},{56.45,26.03},{55.93,26.0},{56.21,26.37},{56.13,25.66},{56.02,25.91},},},nil,148,nil,nil,16,nil,},
[2338] = {'Twilight Disciple',325,350,16,17,0,{[148]={{38.21,87.21},{38.24,86.33},{38.17,85.7},{39.5,88.05},{39.08,87.99},{38.74,85.35},},},nil,148,nil,nil,74,nil,},
[2339] = {'Twilight Thug',386,417,17,18,0,{[148]={{38.08,86.86},{38.03,86.23},{55.4,35.89},{55.49,35.96},{38.85,87.75},{39.34,87.65},{38.53,87.49},{39.43,85.65},{39.63,85.98},{39.28,85.2},{39.05,86.19},{39.14,86.57},{38.55,86.28},{38.47,86.09},{56.41,35.06},{56.55,35.13},},},{[148]={{39.62,85.94},{39.62,85.73},{39.62,85.73},{39.59,85.37},{39.6,85.6},{39.62,85.84},{39.64,86.04},{39.67,86.23},{39.7,86.43},{39.78,86.53},{39.89,86.44},{40.01,86.31},{40.2,86.22},{40.06,86.27},{39.99,86.33},{39.85,86.42},{39.75,86.44},{39.67,86.28},{39.65,86.11},{39.14,86.5},{39.23,86.81},{39.39,87.29},{39.33,87.3},{39.22,87.26},{39.1,86.95},{38.97,86.77},{38.71,86.49},{38.69,86.29},{38.82,86.25},{38.94,86.39},{39.06,86.49},},[331]={{23.47,2.4},{23.46,2.17},{23.46,2.17},{23.44,1.75},{23.44,2.01},{23.47,2.29},{23.5,2.52},{23.52,2.73},{23.56,2.96},{23.65,3.07},{23.77,2.97},{23.91,2.83},{24.13,2.71},{23.97,2.77},{23.89,2.85},{23.73,2.94},{23.62,2.97},{23.53,2.78},{23.5,2.59},{22.92,3.03},{23.03,3.4},{23.21,3.93},{23.15,3.95},{23.01,3.9},{22.88,3.55},{22.73,3.34},{22.44,3.03},{22.41,2.8},{22.57,2.75},{22.7,2.92},{22.83,3.02},},[361]={{22.52,66.59},{22.52,66.36},{22.52,66.36},{22.49,65.94},{22.5,66.2},{22.53,66.48},{22.55,66.71},{22.58,66.92},{22.61,67.15},{22.7,67.26},{22.83,67.17},{22.97,67.02},{23.18,66.91},{23.02,66.96},{22.94,67.04},{22.78,67.14},{22.67,67.16},{22.58,66.97},{22.56,66.78},{21.97,67.23},{22.08,67.59},{22.26,68.13},{22.2,68.15},{22.07,68.1},{21.93,67.74},{21.78,67.53},{21.49,67.22},{21.47,67.0},{21.62,66.94},{21.75,67.11},{21.89,67.22},},},148,nil,nil,74,nil,},
[2344] = {'Dun Garok Mountaineer',2379,2512,28,29,1,{[267]={{69.04,78.17},{69.53,77.94},{68.87,79.54},{72.67,81.89},{71.07,80.4},{72.53,81.7},{72.79,81.32},{71.83,79.36},{70.52,79.73},{71.6,81.33},{71.58,79.57},{71.98,79.8},{71.16,80.64},{72.1,80.5},{72.39,81.09},{72.15,79.03},{72.66,79.92},{72.14,81.14},{72.55,79.62},{71.05,78.14},{71.54,78.68},{70.22,77.89},{70.37,77.22},{70.0,75.04},{70.14,72.61},},},{[45]={{10.88,50.62},{10.88,50.62},{11.34,50.03},{11.43,49.79},{11.43,49.79},{11.16,49.37},{10.92,48.92},{10.52,48.2},{10.67,48.54},{10.92,48.99},{11.33,49.69},{11.41,49.87},{11.29,50.08},{11.29,50.08},{10.76,50.76},{10.57,50.97},{10.31,50.54},{10.31,50.54},{10.06,50.09},{9.64,49.37},{9.75,49.65},{10.0,50.09},{10.27,50.51},{10.57,50.94},{10.82,50.73},{9.5,49.46},{9.68,49.24},{9.68,49.24},{9.97,48.86},{10.26,48.47},{10.58,48.05},{10.58,48.05},{10.28,48.43},{9.99,48.81},{9.69,49.21},{8.6,42.42},{8.57,41.94},{8.57,41.27},{8.76,40.85},{9.02,40.41},{9.35,40.02},{9.65,39.8},{9.93,39.35},{9.93,39.35},{10.17,38.9},{10.4,38.43},{10.62,38.04},{11.26,37.21},{11.26,37.21},{11.73,36.33},{11.73,36.33},{11.49,36.79},{11.11,37.46},{10.68,38.0},{10.41,38.42},{10.04,39.2},{9.73,39.75},{9.55,39.88},{9.26,40.07},{8.62,41.01},{8.55,41.52},{8.57,42.04},{8.67,42.72},{8.67,42.72},{8.46,43.65},{8.28,44.07},{8.2,45.0},{8.4,45.47},{8.64,45.93},{8.76,46.22},{8.68,45.97},{8.46,45.49},{8.15,44.65},{8.2,44.32},{8.28,44.05},{8.62,43.17},{8.64,42.59},},[267]={{72.66,81.95},{72.66,81.95},{73.17,81.28},{73.28,81.01},{73.28,81.01},{72.98,80.54},{72.7,80.03},{72.25,79.23},{72.42,79.61},{72.7,80.11},{73.16,80.91},{73.26,81.11},{73.12,81.34},{73.12,81.34},{72.52,82.1},{72.31,82.34},{72.01,81.86},{72.01,81.86},{71.73,81.35},{71.26,80.54},{71.38,80.85},{71.67,81.36},{71.97,81.82},{72.3,82.31},{72.59,82.07},{71.11,80.65},{71.3,80.4},{71.3,80.4},{71.63,79.97},{71.96,79.53},{72.32,79.06},{72.32,79.06},{71.99,79.48},{71.65,79.91},{71.31,80.36},{70.09,72.72},{70.06,72.19},{70.05,71.42},{70.27,70.96},{70.56,70.47},{70.93,70.03},{71.27,69.77},{71.58,69.27},{71.58,69.27},{71.85,68.76},{72.12,68.24},{72.36,67.79},{73.09,66.86},{73.09,66.86},{73.61,65.87},{73.61,65.87},{73.34,66.39},{72.91,67.14},{72.43,67.74},{72.13,68.22},{71.71,69.1},{71.36,69.72},{71.16,69.86},{70.84,70.08},{70.11,71.14},{70.03,71.7},{70.06,72.3},{70.18,73.07},{70.18,73.07},{69.94,74.1},{69.74,74.58},{69.64,75.62},{69.86,76.15},{70.13,76.67},{70.28,77.0},{70.18,76.72},{69.94,76.17},{69.59,75.23},{69.64,74.86},{69.73,74.56},{70.11,73.56},{70.14,72.92},},},267,nil,nil,88,"A",},
[2345] = {'Dun Garok Rifleman',2941,3104,29,30,1,{[267]={{70.02,79.39},{71.54,75.08},{71.58,81.36},{70.12,78.45},{71.48,80.19},{72.62,80.23},{72.19,79.73},{71.49,78.59},{70.68,78.6},{69.97,76.53},{69.34,76.58},{71.3,74.23},},},{[45]={{9.94,47.49},{9.78,47.62},{9.73,47.69},{9.59,47.83},{9.26,47.23},{9.59,47.73},{9.72,47.68},{9.77,47.63},},[267]={{71.6,78.43},{71.41,78.58},{71.36,78.65},{71.2,78.81},{70.83,78.14},{71.2,78.7},{71.35,78.64},{71.41,78.59},},},267,nil,nil,88,"A",},
[2346] = {'Dun Garok Priest',2512,2636,29,30,1,{[267]={{70.7,75.78},{71.78,80.45},{72.09,80.05},{72.66,80.67},{72.46,80.7},{71.09,78.97},},},{[45]={{9.48,48.02},{9.48,48.02},{9.14,47.42},{9.48,47.98},{9.41,48.1},{9.35,48.2},{9.29,48.33},{9.35,48.19},{9.41,48.11},},[267]={{71.09,79.02},{71.09,79.02},{70.7,78.35},{71.08,78.98},{71.0,79.11},{70.94,79.23},{70.87,79.37},{70.94,79.21},{71.0,79.12},},},267,nil,nil,88,"A",},
[2347] = {'Wild Gryphon',1753,1753,40,40,0,{[267]={{78.7,34.86},{87.3,41.7},},},nil,267,nil,nil,15,"AH",},
[2348] = {'Elder Moss Creeper',788,840,26,27,0,{[267]={{66.36,77.6},{65.71,71.17},{63.37,70.84},{63.89,66.37},{62.78,72.24},{66.05,72.6},{63.94,73.57},{66.45,67.8},{69.19,60.47},{61.19,55.39},{73.24,67.92},{74.16,70.39},{60.72,68.59},{74.98,67.8},{59.38,55.5},{56.74,52.38},{60.16,52.72},{58.64,61.78},{60.41,57.93},{61.1,63.21},{72.52,69.49},{68.93,69.89},{66.6,72.8},{68.26,67.93},{61.96,53.96},{67.3,65.9},},},nil,267,nil,nil,22,nil,},
[2349] = {'Giant Moss Creeper',664,713,24,25,0,{[267]={{90.16,41.38},{23.49,53.98},{23.93,57.14},{24.7,58.57},{24.52,57.03},{29.12,32.27},{31.77,63.58},{32.03,64.67},{27.57,67.79},{26.56,33.34},{29.64,66.44},{33.04,66.01},{84.03,45.53},{73.49,63.11},{40.33,51.73},{38.44,55.51},{83.09,49.0},{80.58,52.12},{77.61,51.25},{84.53,50.39},{84.52,48.97},{79.01,31.74},{82.47,53.15},{86.86,45.61},{84.04,35.42},{88.1,41.3},{89.64,40.19},{40.17,49.62},{41.27,52.18},{85.56,36.13},{78.12,62.54},{32.91,52.72},{34.1,57.42},{60.87,47.84},{77.38,64.47},{33.8,63.19},{36.11,59.0},{66.09,57.04},{71.43,61.87},{23.51,50.98},{27.77,65.06},{76.45,59.9},{76.74,55.75},{71.26,20.7},{74.77,24.56},{32.15,62.68},{69.01,52.51},{70.25,52.05},{74.99,29.61},{73.49,53.8},{75.68,61.9},{66.7,58.79},{69.83,27.64},{69.47,32.14},{73.29,55.81},{75.33,33.96},{70.31,60.34},{62.95,55.62},{61.86,46.51},{63.71,44.76},{65.01,51.83},{73.02,50.46},{71.4,50.27},{28.51,28.69},{26.18,36.87},{26.07,35.27},{27.68,50.73},{26.63,49.03},{41.25,65.24},{78.4,60.62},{36.84,55.92},{68.72,48.87},{36.89,54.23},{38.07,51.58},{27.54,54.06},{35.71,56.66},{64.07,49.14},{81.47,31.98},{68.33,36.66},{30.97,61.27},{34.8,54.08},{72.06,21.05},{28.96,63.26},{33.32,64.95},{29.71,54.25},{29.2,56.49},{44.63,61.57},{32.73,55.8},{36.38,63.45},{40.28,58.31},{38.61,65.47},{39.56,59.86},{31.71,58.85},{42.67,61.13},{40.89,64.41},{34.59,29.59},{36.91,29.04},{67.21,55.62},{75.75,54.06},{64.92,57.84},{67.31,38.16},{28.7,54.15},{42.45,59.35},{37.04,33.17},{27.51,31.21},},[36]={{14.57,81.68},{18.39,91.81},{25.56,66.01},{23.7,56.58},{25.89,74.3},{14.56,86.27},{26.23,76.22},{26.55,83.61},{24.19,79.15},{24.15,87.98},{24.91,79.59},{23.35,77.73},{22.37,73.39},{28.84,79.46},{30.09,78.2},{22.57,82.03},{27.67,69.87},{28.46,73.52},{25.02,63.32},{15.79,88.77},},},nil,267,nil,nil,22,nil,},
[2350] = {'Forest Moss Creeper',494,531,20,21,0,{[267]={{18.12,52.92},{78.55,50.59},{19.66,53.43},{22.99,53.54},{71.77,41.16},{21.2,51.84},{20.52,43.43},{26.57,38.88},{27.83,38.88},{70.78,38.15},{71.41,36.62},{25.65,39.28},{23.55,43.07},{63.88,10.68},{68.34,13.33},{67.54,10.22},{70.06,8.98},{67.22,9.59},{62.62,13.7},{63.69,14.34},{59.38,13.68},{60.85,14.84},{56.51,9.96},{53.76,13.59},{56.65,16.86},{63.24,39.34},{65.68,27.23},{65.17,25.58},{57.11,13.53},{71.87,34.17},{63.3,36.3},{64.5,32.03},{61.04,38.16},{62.16,39.81},{61.79,31.45},{70.42,44.61},{59.56,35.19},{66.13,21.41},{57.81,24.2},{19.08,47.76},{58.06,28.91},{56.55,30.06},{59.0,35.34},{53.84,14.42},},},nil,267,nil,nil,22,nil,},
[2351] = {'Gray Bear',677,731,21,22,0,{[267]={{64.05,8.55},{19.95,52.23},{22.0,56.46},{20.19,53.57},{21.53,42.77},{23.35,43.9},{26.39,41.84},{24.41,40.07},{26.68,41.61},{26.29,38.24},{18.87,43.59},{19.01,49.85},{63.21,11.45},{68.77,9.48},{68.25,11.99},{66.8,15.73},{57.62,15.07},{56.16,8.61},{54.78,13.35},{55.4,15.99},{66.9,28.87},{67.01,23.0},{66.12,23.07},{67.18,26.01},{17.28,44.78},{64.4,37.79},{30.7,48.07},{66.47,34.25},{64.35,28.75},{57.63,23.63},{56.88,28.13},{59.07,32.75},{57.79,28.29},{61.51,35.96},{59.51,36.55},{64.35,33.97},{63.09,30.15},{65.39,35.93},{59.8,30.93},{67.08,19.47},{62.04,36.32},{58.08,34.06},{23.37,48.2},{57.03,28.98},{63.18,6.36},},[36]={{51.85,69.12},},},nil,267,nil,nil,14,nil,},
[2352] = {'Innkeeper Anderson',1605,1605,30,30,0,{[267]={{51.17,58.93},},},nil,267,nil,nil,12,"A",},
[2354] = {'Vicious Gray Bear',742,799,22,23,0,{[267]={{53.11,47.87},{54.85,46.43},{54.85,52.45},{76.5,49.11},{71.06,34.91},{74.05,34.47},{70.5,33.53},{52.31,46.04},{54.86,39.54},{56.87,40.32},{56.28,43.17},{45.71,46.78},{46.55,47.22},{53.32,42.47},{40.4,44.75},{40.89,39.49},{38.5,37.74},{40.58,42.61},{44.53,50.71},{49.94,33.49},{70.14,35.49},{48.58,46.24},{51.45,37.78},{49.08,36.97},{45.37,40.34},{46.53,38.76},{44.25,41.37},{49.85,44.68},{66.48,39.51},{49.24,43.03},{51.99,33.16},{40.11,36.77},{41.09,37.15},{56.62,39.55},{54.43,42.15},{41.04,34.46},{48.13,47.16},{38.79,41.83},{47.78,36.41},{45.35,34.88},{51.47,31.53},{52.94,30.87},{44.58,38.57},{44.68,37.09},{45.52,43.62},},},nil,267,nil,nil,44,nil,},
[2356] = {'Elder Gray Bear',944,1013,25,26,0,{[267]={{89.65,42.72},{78.5,50.5},{28.62,29.6},{85.62,47.55},{28.86,66.11},{27.0,34.26},{77.05,66.49},{29.57,65.58},{83.47,46.82},{82.93,36.63},{81.52,35.59},{79.33,36.07},{80.19,35.74},{81.84,52.43},{82.22,51.98},{77.84,55.13},{39.81,56.68},{29.45,32.23},{78.65,52.34},{35.29,61.55},{37.6,58.37},{35.03,64.37},{85.79,39.15},{87.79,39.8},{84.73,33.35},{34.49,56.61},{63.14,50.31},{85.04,35.2},{83.47,53.98},{89.99,43.19},{25.74,54.16},{30.58,65.18},{40.1,57.13},{71.93,66.88},{24.56,52.12},{72.24,65.58},{88.42,41.53},{69.36,28.97},{26.54,52.38},{25.19,51.32},{33.12,64.47},{72.14,52.66},{70.99,62.42},{87.69,40.94},{72.98,61.94},{73.42,22.62},{63.03,46.09},{74.77,52.4},{74.85,66.67},{26.7,36.29},{76.62,31.78},{70.26,21.97},{79.26,58.84},{70.68,22.39},{38.14,49.43},{38.96,50.64},{87.07,35.89},{34.88,54.3},{24.23,57.72},{36.14,50.9},{68.06,61.45},{62.38,48.94},{65.27,47.61},{78.58,32.85},{70.45,25.75},{37.71,65.69},{30.48,56.5},{29.35,55.4},{38.98,53.24},{74.79,27.46},{30.63,52.62},{29.42,62.92},{42.99,63.46},{42.96,52.38},{44.99,57.64},{87.04,37.93},{32.41,55.33},{37.2,30.83},{74.52,33.49},{41.58,58.34},{45.19,60.06},{73.78,29.55},{77.34,30.67},{63.42,48.26},{73.66,59.87},{75.05,57.47},{35.91,33.54},{70.25,50.67},{38.25,62.83},{46.74,56.41},{40.15,61.01},{34.91,60.2},{28.77,52.34},{41.2,47.72},{42.35,47.48},{28.21,30.83},},[36]={{23.33,75.98},{25.04,64.68},{23.76,82.8},{24.81,77.1},{28.28,69.09},{26.35,78.01},{26.91,81.93},{24.79,59.44},{21.63,72.99},{24.69,81.09},{21.31,75.7},{15.43,83.24},{21.24,69.14},},},nil,267,nil,nil,44,nil,},
[2357] = {'Merideth Carlson',1764,1764,32,32,0,{[267]={{52.19,55.48},},},nil,267,{7645,},{7645,},12,"A",},
[2358] = {'Dalaran Summoner',954,992,34,35,0,{[36]={{22.37,60.41},{18.79,77.12},{21.98,57.94},{19.63,57.82},{18.38,74.09},{18.88,74.92},{11.57,75.94},{10.95,78.67},{15.92,75.52},{15.12,76.41},{12.9,76.31},{17.88,76.16},{19.66,75.39},{21.33,63.78},{21.74,61.21},{20.72,54.27},{21.4,56.39},{19.4,54.98},{20.21,59.27},{14.98,78.56},},},nil,36,nil,nil,76,"AH",},
[2359] = {'Elemental Slave',1221,1279,33,34,0,{[36]={{22.91,59.49},{22.41,58.63},{19.01,57.74},{10.12,78.2},{12.41,76.99},{16.2,78.51},{11.79,74.53},{19.03,76.96},{15.14,77.23},{16.78,76.14},{19.91,76.17},{19.26,73.5},{21.78,64.34},{20.77,60.51},{23.07,60.36},{21.91,55.82},{19.95,54.05},{20.32,56.47},{18.38,55.92},{19.96,56.55},{21.61,61.88},{10.77,80.58},},},{[36]={{19.93,56.44},{19.77,56.1},{20.15,55.7},{19.76,55.94},{20.09,56.62},{20.27,56.94},{20.5,57.34},{20.88,57.96},{21.29,58.62},{21.66,58.92},{21.28,58.67},{20.9,58.04},{20.48,57.39},{20.32,57.13},{20.14,56.86},},[130]={{76.78,43.58},{76.67,43.35},{76.93,43.09},{76.67,43.24},{76.89,43.7},{77.01,43.91},{77.16,44.18},{77.41,44.59},{77.69,45.03},{77.93,45.23},{77.68,45.06},{77.43,44.65},{77.15,44.21},{77.04,44.04},{76.92,43.86},},},36,nil,nil,76,"AH",},
[2360] = {'Hillsbrad Farmhand',573,617,22,23,0,{[267]={{36.82,39.58},{36.78,41.34},{35.85,40.9},{34.84,40.57},{35.06,40.09},{35.2,41.32},{33.84,40.98},{33.83,40.09},{33.77,41.56},{35.6,39.69},{35.26,38.34},{34.36,41.26},{35.16,37.7},{33.36,35.55},{31.83,35.11},{30.79,36.51},{31.66,38.15},{32.21,36.17},{29.86,37.31},{30.47,37.69},{31.39,39.55},{30.19,38.08},{30.41,36.93},},},nil,267,nil,nil,123,"A",},
[2361] = {'Tamara Armstrong',644,644,15,15,0,{[267]={{50.92,58.43},},},nil,267,nil,nil,11,"A",},
[2362] = {'Hemmit Armstrong',644,644,15,15,0,{[267]={{50.87,58.56},},},nil,267,nil,nil,11,"A",},
[2363] = {'Apprentice Honeywell',1528,1528,29,29,0,{[267]={{50.84,56.91},},},nil,267,nil,nil,11,"A",},
[2364] = {'Neema',1846,1846,33,33,0,{[267]={{51.13,59.24},},},nil,267,nil,nil,12,"A",},
[2365] = {'Bront Coldcleave',2376,2376,39,39,0,{[267]={{48.75,57.2},},},nil,267,nil,nil,12,"A",},
[2366] = {'Barkeep Kelly',2471,2471,40,40,0,{[267]={{51.57,58.57},},},nil,267,nil,nil,12,"A",},
[2367] = {'Donald Rabonne',1684,1684,31,31,0,{[267]={{50.78,61.03},},},nil,267,nil,nil,12,"A",},
[2368] = {'Daggerspine Shorestalker',896,950,28,29,0,{[267]={{63.99,82.12},{67.03,86.55},{61.03,77.49},{61.66,78.64},{67.22,87.08},{66.05,85.29},{66.53,86.35},{65.03,80.34},{66.93,80.07},{66.0,82.23},{66.29,79.56},{66.44,83.28},{64.04,78.53},{61.53,76.37},{65.85,83.56},{60.09,75.65},{61.88,76.2},{64.43,77.45},},},nil,267,nil,nil,74,nil,},
[2369] = {'Daggerspine Shorehunter',1050,1107,30,31,0,{[267]={{58.9,77.56},{55.89,72.28},{57.8,75.95},{59.8,71.97},{58.73,74.01},{58.3,72.63},{60.57,74.73},{51.7,66.15},{52.73,65.51},{57.74,66.3},{54.48,64.37},{58.16,70.01},{57.84,69.11},{54.68,68.44},{53.7,66.75},{55.87,66.59},{53.7,63.47},},},nil,267,nil,nil,74,nil,},
[2370] = {'Daggerspine Screamer',812,852,29,30,0,{[267]={{60.77,80.9},{65.43,86.28},{66.82,86.12},{60.01,78.89},{62.94,84.11},{63.85,85.22},{66.72,80.44},{65.4,80.1},{66.51,82.88},{62.79,77.29},{64.12,76.71},{63.77,76.94},},},nil,267,nil,nil,74,nil,},
[2371] = {'Daggerspine Siren',935,977,31,32,0,{[267]={{57.03,77.33},{61.66,81.82},{56.91,73.77},{60.14,73.28},{55.95,69.87},{56.89,71.11},{57.24,68.35},{58.89,70.22},{58.37,68.61},{59.03,71.54},{54.39,61.98},{56.3,65.0},{55.2,61.43},{55.32,63.84},{56.53,66.2},{57.91,65.05},{58.69,66.03},{58.59,66.53},{53.21,64.23},},},nil,267,nil,nil,74,nil,},
[2372] = {'Mudsnout Gnoll',788,840,26,27,0,{[267]={{63.57,65.06},{64.65,65.64},{62.47,62.67},{65.0,63.12},{63.33,62.7},{62.54,61.84},{63.96,63.2},{61.95,62.92},{63.31,59.35},{62.17,61.55},{64.11,60.33},{64.95,61.83},},},nil,267,nil,nil,95,nil,},
[2373] = {'Mudsnout Shaman',665,702,27,28,0,{[267]={{62.96,63.71},{62.55,63.55},{63.25,61.63},{64.13,61.92},{63.72,59.22},{65.42,60.35},{62.93,62.22},{66.27,61.1},},},nil,267,nil,nil,95,nil,},
[2374] = {'Torn Fin Muckdweller',978,982,28,29,0,{[267]={{26.52,74.12},{25.6,76.43},{25.32,72.79},{33.86,72.8},{21.23,66.7},{23.44,72.69},{20.44,64.62},{24.54,64.95},{23.17,64.21},{24.63,66.18},{23.47,64.78},{32.98,72.54},{32.13,72.38},{25.06,70.48},{32.46,72.81},{25.34,71.2},{26.13,71.68},{30.12,73.9},{29.78,73.6},{27.9,72.49},{33.06,70.01},},},nil,267,nil,nil,18,nil,},
[2375] = {'Torn Fin Coastrunner',1016,1049,29,30,0,{[267]={{35.05,73.98},{34.56,70.72},{29.81,76.01},{30.87,74.21},{31.93,76.28},{22.11,68.46},{22.38,70.85},{24.22,69.43},{24.02,74.55},{28.51,74.18},{26.9,75.88},{23.11,64.36},{22.11,64.01},{23.74,66.34},{24.44,64.78},{32.67,72.29},{32.9,71.37},{25.14,69.49},{25.59,70.7},{32.67,74.36},{24.39,70.86},{24.83,67.23},{30.31,73.3},{24.58,70.41},{31.75,72.9},{27.57,72.43},{28.05,72.85},{26.98,71.79},{29.8,72.77},{33.29,69.74},{33.86,69.62},},},nil,267,nil,nil,18,nil,},
[2376] = {'Torn Fin Oracle',898,931,30,31,0,{[267]={{38.02,72.83},{40.4,71.23},{36.53,69.41},{48.29,66.37},{43.95,68.65},{44.15,71.11},{47.15,68.34},{36.06,68.74},{46.14,69.13},{35.68,66.4},{37.39,66.18},{37.24,69.14},{44.37,66.47},{45.98,66.75},{45.05,67.38},{44.34,67.87},{42.73,69.21},{40.88,68.81},{40.68,69.22},{46.25,63.04},},},nil,267,nil,nil,18,nil,},
[2377] = {'Torn Fin Tidehunter',931,978,31,32,0,{[267]={{42.69,70.71},{42.49,72.62},{38.58,71.12},{36.18,70.22},{49.4,67.63},{37.33,70.27},{39.95,72.82},{36.37,69.61},{40.33,68.82},{48.62,64.41},{46.42,66.47},{43.93,67.15},{44.62,66.99},{43.36,68.2},{41.11,67.95},{45.01,68.56},{40.67,69.86},{41.02,69.49},{47.4,64.7},{46.03,63.96},},},nil,267,nil,nil,18,nil,},
[2378] = {'Kundric Zanden',1930,1930,34,34,0,{[267]={{48.64,59.01},},},nil,267,nil,nil,11,"A",},
[2379] = {'Caretaker Smithers',2016,2016,35,35,0,{[267]={{51.28,51.86},},},nil,267,nil,nil,12,"A",},
[2380] = {'Nandar Branson',1930,1930,34,34,0,{[267]={{50.93,57.1},},},nil,267,nil,nil,12,"A",},
[2381] = {'Micha Yance',2471,2471,40,40,0,{[267]={{48.94,55.03},},},nil,267,nil,nil,12,"A",},
[2382] = {'Darren Malvew',1605,1605,30,30,0,{[267]={{52.42,55.96},},},nil,267,{564,},{564,},12,"A",},
[2383] = {'Lindea Rabonne',1528,1528,29,29,0,{[267]={{50.63,60.95},},},nil,267,nil,nil,12,"A",},
[2384] = {'Starving Mountain Lion',617,664,23,24,0,{[267]={{55.96,50.43},{50.01,41.23},{58.9,40.41},{47.61,26.09},{37.8,36.21},{49.75,30.89},{39.59,34.85},{53.42,39.28},{52.89,48.87},{53.6,36.42},{52.45,35.86},{54.68,31.22},{52.65,31.86},{39.04,38.21},{54.97,26.31},{51.87,44.7},{51.61,41.7},{54.31,42.94},{54.33,39.65},{55.67,42.06},{53.55,39.87},{55.62,44.43},{39.3,37.83},{57.78,41.59},{54.57,29.0},{53.87,44.31},{53.29,36.72},{54.5,32.17},{39.76,40.56},{44.54,48.85},{39.04,46.73},{50.21,31.76},{48.63,34.49},{42.52,40.36},{52.82,32.21},{44.62,45.85},{42.94,35.42},{37.95,44.46},{53.36,36.07},{38.99,45.64},{55.97,25.75},{50.99,35.46},},},nil,267,nil,nil,14,nil,},
[2385] = {'Feral Mountain Lion',840,896,27,28,0,{[267]={{65.09,72.99},{62.62,71.43},{64.87,69.26},{64.98,66.4},{66.33,75.32},{61.79,69.02},{67.97,80.87},{57.68,59.31},{58.98,56.53},{56.7,60.08},{60.16,58.47},{66.26,74.09},{57.56,49.97},{61.14,66.86},{70.35,67.98},{60.98,50.92},{58.52,55.59},{63.59,67.96},},},nil,267,nil,nil,14,nil,},
[2386] = {'Southshore Guard',3330,3330,55,55,0,{[267]={{47.52,60.18},{51.88,57.39},{47.49,56.58},{48.41,56.31},{46.85,50.16},{49.39,59.49},{53.24,58.23},{51.48,60.44},{49.54,62.17},{49.01,58.14},{48.73,59.85},{49.61,49.0},{52.05,56.17},{48.63,52.8},{46.58,50.54},{46.79,51.49},{47.2,49.9},{46.76,52.22},{52.26,51.17},{49.91,55.04},{49.75,52.51},{50.27,59.83},{51.88,50.5},{49.32,56.14},{50.13,58.32},{50.37,50.97},{50.89,59.89},{52.74,56.04},{51.56,55.37},{49.93,57.75},},[36]={{39.42,81.45},{40.54,79.58},},},{[130]={{92.34,84.53},{92.31,84.88},{92.29,85.08},{92.33,84.61},{92.34,84.16},{92.72,83.47},{92.65,83.11},{92.37,82.93},{92.05,83.05},{91.84,83.46},{91.89,83.96},{92.16,84.32},{92.38,84.41},{92.65,84.07},{92.8,83.5},{94.76,89.34},{94.66,89.4},{94.63,89.1},{94.66,88.82},{94.76,88.47},{94.96,88.04},{95.07,87.7},{95.14,87.46},{95.23,87.03},{95.23,86.42},{95.24,85.7},{95.34,85.39},{95.53,84.96},{95.75,84.65},{95.85,84.12},{95.73,83.76},{95.57,83.32},{95.54,82.88},{95.57,83.32},{95.7,83.73},{95.82,84.12},{95.69,84.69},{95.51,84.99},{95.32,85.33},{95.26,85.67},{95.25,86.2},{95.25,86.72},{95.2,87.28},{95.11,87.57},{94.99,87.98},{94.81,88.42},{94.66,88.74},{94.64,89.07},{94.66,89.42},},[267]={{46.72,51.58},{46.67,52.03},{46.66,52.29},{46.7,51.68},{46.72,51.09},{47.21,50.18},{47.13,49.71},{46.75,49.47},{46.33,49.62},{46.07,50.16},{46.12,50.83},{46.48,51.3},{46.78,51.42},{47.13,50.96},{47.32,50.22},{49.9,57.88},{49.76,57.96},{49.73,57.57},{49.76,57.21},{49.9,56.75},{50.16,56.17},{50.29,55.74},{50.39,55.42},{50.51,54.86},{50.51,54.05},{50.53,53.11},{50.66,52.7},{50.91,52.14},{51.19,51.72},{51.32,51.03},{51.17,50.56},{50.96,49.99},{50.91,49.4},{50.96,49.99},{51.12,50.53},{51.29,51.04},{51.12,51.78},{50.88,52.17},{50.63,52.62},{50.55,53.07},{50.53,53.77},{50.53,54.44},{50.47,55.18},{50.36,55.56},{50.2,56.1},{49.96,56.68},{49.77,57.09},{49.74,57.53},{49.76,57.98},},},267,nil,nil,11,"A",},
[2387] = {'Hillsbrad Councilman',590,628,25,26,0,{[267]={{29.59,39.72},{30.15,41.12},{32.38,46.42},{30.24,43.55},{29.47,43.14},{30.13,42.89},{30.19,42.16},{32.06,42.43},{29.3,40.88},},},{[130]={{81.09,77.5},{80.88,77.46},{80.7,77.43},{80.48,77.35},{80.24,77.37},{80.09,77.38},{79.88,77.37},{80.1,77.41},{80.22,77.43},{80.45,77.55},{80.67,77.48},{80.85,77.48},{81.0,77.51},{81.22,77.59},{81.49,77.7},{81.28,77.64},},[267]={{31.95,42.34},{31.67,42.29},{31.44,42.25},{31.15,42.15},{30.84,42.17},{30.64,42.18},{30.36,42.17},{30.65,42.23},{30.8,42.25},{31.11,42.41},{31.41,42.32},{31.64,42.31},{31.84,42.36},{32.12,42.46},{32.47,42.6},{32.2,42.53},},},267,nil,nil,123,"A",},
[2388] = {'Innkeeper Shay',1605,1605,30,30,0,{[267]={{62.78,19.03},},},nil,267,nil,nil,68,"H",},
[2389] = {'Zarise',7842,7842,55,55,1,{[267]={{60.14,18.62},},},nil,267,nil,nil,68,"H",},
[2390] = {'Aranae Venomblood',1528,1528,29,29,0,{[267]={{61.71,19.52},},},nil,267,nil,nil,68,"H",},
[2391] = {'Serge Hinott',1764,1764,32,32,0,{[267]={{61.63,19.19},},},nil,267,{2480,},{2479,2480,},68,"H",},
[2392] = {'Delia Verana',1162,1162,32,32,0,{[267]={{62.6,19.43},},},nil,267,nil,nil,71,"H",},
[2393] = {'Christoph Jeffcoat',1764,1764,32,32,0,{[267]={{62.29,19.04},},},nil,267,{7321,},{7321,},68,"H",},
[2394] = {'Mallen Swain',1764,1764,32,32,0,{[267]={{61.9,20.98},},},nil,267,nil,nil,68,"H",},
[2395] = {'Vinna Wayne',1764,1764,32,32,0,{[267]={{63.33,19.87},},},{[36]={{62.23,81.67},{61.98,81.6},{61.68,81.75},{61.54,81.87},{61.47,82.13},{61.3,82.21},{61.07,82.05},{61.27,81.53},{61.31,81.41},{61.39,81.18},{61.3,81.41},{61.27,81.51},{61.1,82.01},{60.88,81.86},{60.49,81.56},{60.21,81.61},{60.18,81.26},{60.17,81.12},{60.18,81.29},{60.14,81.77},{60.2,81.99},{60.23,82.36},{60.24,82.48},{60.23,82.36},{60.15,81.78},{59.82,81.64},{59.57,81.34},{59.46,80.89},{59.82,80.42},{60.16,80.18},{60.33,80.02},{60.69,80.07},{60.65,80.56},{60.63,80.96},{60.7,81.43},{60.83,81.96},{61.25,81.86},{61.38,81.85},{61.76,81.72},},[267]={{63.31,19.9},{63.09,19.84},{62.82,19.97},{62.7,20.07},{62.64,20.3},{62.49,20.37},{62.29,20.23},{62.46,19.78},{62.5,19.67},{62.57,19.47},{62.49,19.67},{62.46,19.76},{62.31,20.19},{62.12,20.07},{61.78,19.8},{61.54,19.84},{61.51,19.54},{61.5,19.42},{61.51,19.57},{61.48,19.98},{61.53,20.18},{61.55,20.5},{61.57,20.61},{61.56,20.51},{61.48,19.99},{61.19,19.87},{60.98,19.61},{60.88,19.21},{61.2,18.81},{61.5,18.6},{61.64,18.45},{61.96,18.5},{61.92,18.93},{61.9,19.28},{61.97,19.69},{62.08,20.15},{62.45,20.07},{62.56,20.05},{62.89,19.94},},},267,nil,nil,68,"H",},
[2396] = {'Hans Zandin',1764,1764,32,32,0,{[267]={{61.33,24.41},},},{[36]={{59.95,86.55},{59.8,87.43},{60.34,87.84},{60.42,86.8},{60.25,86.15},{59.94,85.46},{59.33,85.26},{59.22,85.57},{59.69,85.92},},[267]={{61.31,24.17},{61.18,24.94},{61.65,25.29},{61.72,24.39},{61.58,23.82},{61.3,23.21},{60.77,23.04},{60.67,23.31},{61.09,23.62},},[45]={{1.09,0.26},},},267,nil,nil,71,"H",},
[2397] = {'Derak Nightfall',1764,1764,32,32,0,{[267]={{63.09,19.41},},},nil,267,nil,nil,68,"H",},
[2398] = {'Tara Coldgaze',1764,1764,32,32,0,{[267]={{61.62,26.58},},},nil,267,nil,nil,71,"H",},
[2399] = {'Daryl Stack',4033,4033,56,56,0,{[267]={{63.75,20.79},},},nil,267,nil,nil,68,"H",},
[2400] = {'Craig Hewitt',1157,1157,32,32,0,{[267]={{61.26,26.36},},},nil,267,nil,nil,71,"H",},
[2401] = {'Kayren Soothallow',997,997,30,30,0,{[267]={{62.56,19.91},},},nil,267,nil,nil,68,"H",},
[2402] = {'Shara Blazen',1174,1174,32,32,0,{[267]={{63.66,21.16},},},nil,267,nil,nil,68,"H",},
[2403] = {'Farmer Getz',664,664,24,24,0,{[267]={{36.73,39.44},},},nil,267,nil,nil,88,"A",},
[2404] = {'Blacksmith Verringtan',788,788,26,26,0,{[267]={{32.11,44.42},},},nil,267,nil,nil,88,"A",},
[2405] = {'Tarren Mill Deathguard',3514,3514,50,50,0,{[267]={{61.69,27.6},{61.53,27.29},{62.71,19.27},{62.58,19.17},{59.55,24.34},{62.81,22.31},{64.03,22.34},{65.35,20.66},{63.57,21.66},{65.55,18.36},{63.99,17.52},{60.8,17.75},{60.36,26.08},{62.25,26.24},{62.03,22.7},{62.11,21.68},{61.81,20.76},{61.32,19.74},{61.21,21.66},{61.38,17.88},{59.74,18.48},{61.36,20.31},{62.11,18.69},{59.87,18.85},{58.41,21.87},{56.85,19.79},{56.62,19.66},{58.89,19.36},},[36]={{62.45,58.91},{63.76,60.96},{61.88,58.83},{63.72,60.69},},},{[36]={{60.81,84.85},{60.54,84.72},{60.14,84.71},{59.74,84.69},{59.25,84.74},{58.85,84.77},{58.37,84.81},{58.28,85.27},{58.16,85.97},{58.41,86.36},{58.67,86.57},{59.17,86.7},{59.43,87.06},{59.54,87.51},{59.54,87.91},{59.72,88.44},{59.89,88.55},{60.15,88.59},{60.66,88.57},{60.9,88.12},{60.93,87.44},{60.91,86.76},{60.95,85.96},{60.99,84.99},{54.62,81.58},{54.85,81.66},{55.11,81.72},{55.37,81.62},{55.74,81.51},{56.08,81.39},{56.44,81.42},{56.68,81.45},{56.85,81.71},{57.07,82.05},{57.19,82.41},{57.4,82.82},{57.64,83.13},{57.94,83.31},{58.3,83.41},{58.57,83.36},{58.91,83.19},{59.18,82.96},{59.37,82.7},{59.59,82.36},{59.81,82.01},{60.03,81.87},{59.78,82.02},{59.58,82.3},{59.37,82.67},{59.13,83.04},{58.84,83.28},{58.55,83.36},{58.22,83.36},{57.89,83.26},{57.61,83.09},{57.4,82.83},{57.23,82.5},{57.03,82.08},{56.81,81.68},{56.54,81.46},{56.23,81.33},{55.91,81.45},{55.62,81.59},{55.37,81.66},{55.07,81.74},{54.78,81.68},{54.5,81.54},{54.24,81.44},{54.07,81.45},{53.86,81.53},{53.67,81.66},{53.67,82.14},{53.69,82.86},{53.66,82.32},{53.6,81.65},{53.95,81.49},{54.27,81.42},{54.45,81.32},{54.63,81.39},{54.8,81.45},{55.05,81.48},{55.3,81.43},{55.51,81.35},{55.74,81.25},{55.95,81.17},{56.15,81.1},{56.39,81.12},{56.63,81.23},{56.81,81.41},{57.0,81.62},{57.15,81.91},{57.31,82.27},{57.48,82.61},{57.69,82.91},{58.13,83.13},{58.41,83.12},{58.76,82.99},{59.04,82.73},{59.35,82.26},{59.6,81.89},{60.03,81.69},{59.68,81.84},{59.42,82.16},{59.1,82.67},{58.73,83.03},{58.39,83.12},{57.92,83.06},{57.64,82.7},{57.38,82.19},{57.01,81.65},{56.73,81.34},{56.4,81.12},{56.01,81.13},{55.67,81.34},{55.3,81.46},{54.92,81.49},{54.59,81.33},{54.22,81.23},{53.75,81.26},{53.49,81.43},{53.48,81.91},{53.49,82.27},{53.5,82.93},{53.47,82.27},{53.53,81.56},{53.77,81.24},{54.22,81.21},},[267]={{62.06,22.68},{61.83,22.56},{61.48,22.56},{61.13,22.54},{60.7,22.58},{60.35,22.61},{59.93,22.64},{59.85,23.05},{59.75,23.66},{59.96,24.01},{60.19,24.18},{60.63,24.3},{60.86,24.61},{60.95,25.01},{60.95,25.36},{61.11,25.82},{61.26,25.92},{61.49,25.96},{61.93,25.93},{62.14,25.54},{62.17,24.95},{62.15,24.35},{62.18,23.65},{62.22,22.8},{56.64,19.82},{56.85,19.89},{57.08,19.94},{57.3,19.85},{57.63,19.76},{57.92,19.66},{58.24,19.68},{58.44,19.71},{58.59,19.93},{58.79,20.23},{58.89,20.55},{59.08,20.91},{59.29,21.18},{59.55,21.33},{59.86,21.42},{60.11,21.38},{60.4,21.23},{60.64,21.02},{60.8,20.8},{60.99,20.5},{61.19,20.19},{61.38,20.07},{61.16,20.2},{60.99,20.45},{60.8,20.77},{60.59,21.1},{60.34,21.3},{60.09,21.38},{59.79,21.38},{59.51,21.29},{59.26,21.14},{59.08,20.92},{58.93,20.63},{58.76,20.25},{58.56,19.9},{58.33,19.71},{58.06,19.6},{57.78,19.71},{57.52,19.82},{57.3,19.89},{57.04,19.96},{56.78,19.91},{56.54,19.79},{56.32,19.69},{56.17,19.7},{55.99,19.78},{55.81,19.89},{55.82,20.31},{55.84,20.94},{55.8,20.47},{55.76,19.88},{56.06,19.74},{56.34,19.68},{56.5,19.6},{56.66,19.66},{56.8,19.7},{57.03,19.74},{57.24,19.69},{57.42,19.62},{57.63,19.54},{57.81,19.46},{57.99,19.4},{58.2,19.42},{58.41,19.51},{58.56,19.67},{58.73,19.86},{58.86,20.11},{59.0,20.43},{59.15,20.72},{59.33,20.99},{59.72,21.18},{59.96,21.17},{60.27,21.05},{60.52,20.83},{60.79,20.42},{61.0,20.09},{61.38,19.91},{61.08,20.05},{60.84,20.33},{60.57,20.78},{60.25,21.09},{59.95,21.17},{59.53,21.12},{59.29,20.8},{59.06,20.36},{58.73,19.88},{58.49,19.61},{58.2,19.42},{57.87,19.43},{57.56,19.61},{57.25,19.72},{56.91,19.74},{56.62,19.6},{56.3,19.51},{55.89,19.54},{55.66,19.69},{55.65,20.11},{55.66,20.42},{55.66,21.0},{55.64,20.42},{55.69,19.8},{55.9,19.52},{56.3,19.5},},[45]={{0.48,0.01},{0.47,0.32},{0.62,0.73},{0.75,0.82},{0.95,0.85},{1.34,0.83},{1.54,0.48},},[130]={{99.9,60.34},{99.83,60.31},{99.65,60.24},{99.54,60.25},{99.4,60.31},{99.27,60.39},{99.27,60.71},{99.29,61.19},{99.26,60.83},{99.23,60.38},{99.46,60.28},{99.67,60.24},{99.79,60.17},{99.91,60.21},{99.88,60.17},{99.64,60.11},{99.33,60.12},{99.15,60.24},{99.15,60.56},{99.15,60.8},{99.16,61.24},{99.14,60.8},{99.18,60.32},{99.34,60.11},{99.64,60.09},},},267,nil,nil,71,"H",},
[2406] = {'Mountain Lion',1163,1121,32,33,0,{[36]={{64.71,48.64},{76.69,51.29},{78.7,50.09},{74.1,59.79},{83.12,58.17},{30.55,88.32},{29.71,86.56},{32.54,79.55},{33.02,80.06},{29.67,74.55},{29.43,70.37},{31.14,72.23},{29.68,84.71},{29.94,77.13},{31.74,81.14},{30.58,78.93},{33.64,83.9},{35.29,84.17},{49.05,75.2},{37.51,88.68},{39.35,88.11},{37.02,86.37},{38.2,91.93},{42.78,78.54},{40.34,91.87},{32.15,82.81},{35.93,84.76},{34.36,82.92},},[267]={{38.8,24.62},},},nil,36,nil,nil,14,nil,},
[2407] = {'Hulking Mountain Lion',1221,1279,33,34,0,{[36]={{52.76,30.65},{66.75,51.11},{51.75,23.72},{82.57,58.55},{75.55,51.67},{45.28,23.72},{74.4,54.72},{81.41,48.83},{78.39,52.91},{83.14,61.07},{83.2,64.86},{38.13,24.84},{39.6,25.77},{52.5,24.66},{56.19,32.72},{50.43,22.73},{48.88,83.09},{53.61,31.57},{53.51,30.56},{45.53,19.39},{44.21,76.66},{45.7,77.72},{43.7,80.72},{39.57,92.34},{30.92,84.74},{37.12,90.07},{39.82,84.69},},},nil,36,nil,nil,14,nil,},
[2408] = {'Snapjaw',1050,1107,30,31,0,{[36]={{72.49,68.57},{31.67,13.22},{29.7,7.89},{14.22,53.03},{19.88,46.77},{17.63,50.49},{35.93,21.73},{35.79,23.28},{33.38,11.92},{34.34,25.93},{90.81,45.88},{17.67,49.66},{36.63,20.12},{26.33,40.48},{21.19,45.85},{35.79,13.47},{10.57,54.52},{16.69,50.7},{35.45,25.75},{33.37,26.9},{29.13,38.45},{25.16,42.27},{27.91,40.29},{16.49,52.16},{15.3,52.61},{14.01,55.02},{12.38,54.7},{12.9,54.63},{31.9,30.03},{34.24,27.53},{32.91,29.26},{29.69,34.79},{31.13,35.44},{30.81,36.37},{30.67,31.99},{31.23,33.7},{29.71,37.05},{89.25,47.02},{82.93,52.43},{80.91,55.86},{82.68,53.91},{80.28,57.89},{80.28,58.69},{84.83,51.28},{86.95,48.83},{79.59,59.32},{77.21,63.18},{76.41,64.12},{28.77,39.67},{29.7,37.98},{36.82,19.04},{17.7,52.78},{19.31,49.64},{18.96,50.58},{20.23,49.05},{23.56,45.37},{24.16,43.79},{21.25,47.32},{22.86,45.81},{24.84,43.7},{31.9,31.35},{26.74,42.57},{72.77,68.04},{73.6,66.16},{74.98,65.04},{78.76,62.56},{29.41,8.05},},[267]={{68.11,28.94},{67.75,35.34},{67.75,32.01},{68.08,19.23},{68.29,16.93},{69.11,13.59},{68.41,25.66},{67.95,22.95},{66.06,38.25},{55.91,57.08},{56.39,50.59},{55.94,53.95},{61.69,42.82},{59.22,45.06},{56.83,47.22},{63.93,39.68},},},nil,36,nil,nil,7,"AH",},
[2409] = {'Felicia Maline',7842,7842,55,55,1,{[10]={{77.49,44.29},},},nil,10,nil,nil,12,"A",},
[2410] = {'Magus Wordeen Voidglare',2666,2666,42,42,0,{[267]={{61.6,20.85},},},nil,267,{544,545,},{544,545,},68,"H",},
[2411] = {'Ricter',1221,1221,33,33,0,{[36]={{20.16,84.28},},},nil,36,nil,nil,7,"AH",},
[2412] = {'Alina',1221,1221,33,33,0,{[36]={{20.34,86.4},},},nil,36,nil,nil,7,"AH",},
[2413] = {'Dermot',1279,1279,34,34,0,{[36]={{19.91,85.97},},},nil,36,nil,nil,7,"AH",},
[2414] = {'Kegan Darkmar',1365,1365,35,35,0,{[36]={{17.77,83.18},},},nil,36,nil,nil,7,"AH",},
[2415] = {'Warden Belamoore',1265,1265,36,36,0,{[36]={{17.75,82.98},},},nil,36,nil,nil,76,"AH",},
[2416] = {'Crushridge Plunderer',3831,4008,36,37,1,{[36]={{37.16,54.61},{37.15,54.2},},},nil,36,nil,nil,45,nil,},
[2417] = {'Grel\'borg the Miser',3540,3540,39,39,1,{[36]={{35.58,54.42},},},{[36]={{35.21,54.18},{35.71,53.79},{35.92,54.19},{36.25,55.08},{36.67,54.81},{36.27,53.73},{37.47,52.78},{38.27,52.85},{38.96,51.42},{39.31,50.96},{39.35,50.4},{39.76,48.85},{40.14,47.24},{40.91,46.29},{40.25,46.14},{40.13,47.74},{39.24,51.14},{38.71,51.72},{38.11,52.73},{37.47,52.75},{36.29,53.74},{35.91,52.73},{35.51,52.99},{35.78,53.74},{35.23,54.18},{35.31,54.37},{35.59,54.42},},[130]={{86.97,42.07},{87.3,41.81},{87.44,42.08},{87.66,42.67},{87.94,42.49},{87.67,41.77},{88.47,41.14},{89.01,41.18},{89.47,40.23},{89.7,39.93},{89.72,39.55},{90.0,38.52},{90.25,37.45},{90.76,36.81},{90.32,36.71},{90.25,37.78},{89.65,40.05},{89.3,40.43},{88.9,41.1},{88.47,41.12},{87.68,41.78},{87.43,41.1},{87.17,41.28},{87.35,41.78},{86.98,42.08},{87.03,42.2},{87.22,42.23},},[28]={{15.87,99.48},{16.4,99.53},{16.84,98.6},{17.07,98.3},{17.09,97.93},{17.36,96.92},{17.61,95.88},{18.11,95.26},{17.68,95.16},{17.6,96.2},{17.02,98.42},{16.68,98.8},{16.29,99.45},{15.87,99.47},{14.86,99.45},{14.6,99.62},},},36,nil,nil,45,nil,},
[2418] = {'Deathguard Samsa',1764,1764,32,32,0,{[267]={{62.11,19.7},},},nil,267,{546,},{546,},68,"H",},
[2419] = {'Deathguard Humbert',1764,1764,32,32,0,{[267]={{62.76,20.21},},},nil,267,{547,},{547,},68,"H",},
[2420] = {'Targ',8057,8057,41,41,1,{[36]={{39.57,52.89},},},nil,36,nil,nil,45,nil,},
[2421] = {'Muckrake',4572,4572,40,40,1,{[36]={{38.65,46.75},},},nil,36,nil,nil,45,nil,},
[2422] = {'Glommus',4377,4377,39,39,1,{[36]={{39.5,41.82},},},nil,36,nil,nil,45,nil,},
[2423] = {'Lord Aliden Perenolde',1522,1522,41,41,0,{[36]={{39.32,14.58},},},nil,36,nil,nil,16,nil,},
[2425] = {'Varimathras',983500,983500,62,62,1,{[1497]={{56.25,92.2},},},nil,1497,{1048,5725,6145,6521,},{550,1048,1978,5725,6144,6521,6522,},68,"H",},
[2427] = {'Jailor Eston',664,664,24,24,0,{[267]={{79.6,41.83},},},nil,267,nil,nil,16,nil,},
[2428] = {'Jailor Marlgen',664,664,24,24,0,{[267]={{79.49,40.57},},},nil,267,nil,nil,16,nil,},
[2429] = {'Novice Thaivand',1605,1605,30,30,0,{[267]={{63.88,19.66},},},nil,267,{552,553,},{552,},68,"H",},
[2430] = {'Chef Jessen',2016,2016,35,35,0,{[267]={{51.89,58.68},},},nil,267,{555,},{555,},12,"A",},
[2431] = {'Jailor Borhuin',1536,1536,37,37,0,{[36]={{63.14,43.42},},},nil,36,nil,nil,16,nil,},
[2432] = {'Darla Harris',7842,7842,55,55,1,{[267]={{49.34,52.27},},},nil,267,nil,nil,12,"A",},
[2433] = {'Helcular\'s Remains',4180,4180,44,44,1,nil,nil,0,nil,nil,83,"H",},
[2434] = {'Shadowy Assassin',1130,1156,37,38,0,nil,nil,0,nil,nil,108,"AH",},
[2435] = {'Southshore Crier',1764,1764,32,32,0,nil,nil,0,nil,nil,96,"A",},
[2436] = {'Farmer Kent',1240,1240,25,25,0,{[267]={{50.27,55.27},},},{[130]={{95.1,87.35},{94.99,87.73},{94.82,88.1},{94.68,88.5},{94.57,89.03},{94.6,89.37},{94.72,89.84},{94.71,90.16},{94.63,90.24},{94.4,90.27},{94.54,90.26},{94.8,90.1},{94.8,90.1},{94.93,90.4},{95.02,90.77},{95.03,91.34},{95.0,90.74},{94.87,90.21},{94.9,90.18},{95.11,89.92},{94.93,90.12},{94.73,89.89},{94.65,89.56},{94.56,89.21},{94.61,88.81},{94.76,88.37},{94.96,87.81},},[267]={{50.34,55.27},{50.2,55.77},{49.98,56.26},{49.79,56.79},{49.64,57.47},{49.69,57.93},{49.84,58.54},{49.83,58.96},{49.72,59.07},{49.41,59.1},{49.6,59.09},{49.94,58.89},{49.94,58.89},{50.11,59.27},{50.23,59.76},{50.24,60.51},{50.21,59.72},{50.03,59.03},{50.08,58.98},{50.35,58.64},{50.12,58.91},{49.86,58.6},{49.75,58.18},{49.63,57.71},{49.7,57.19},{49.89,56.6},{50.15,55.87},},},267,nil,nil,96,"A",},
[2437] = {'Keeper Bel\'varil',1930,1930,34,34,0,{[267]={{61.5,20.93},},},nil,267,{556,557,},{556,557,},68,"H",},
[2438] = {'Bartolo Ginsetti',1764,1764,32,32,0,{[267]={{49.43,55.53},},},nil,267,{565,},{565,},12,"A",},
[2439] = {'Major Samuelson',3517,3517,50,50,0,{[1519]={{72.6,15.86},},},nil,1519,nil,{563,},12,"A",},
[2440] = {'Drunken Footpad',1159,1411,32,33,0,{[36]={{59.3,69.76},{58.66,67.21},},},nil,36,nil,nil,16,nil,},
[2442] = {'Cow',1,1,1,1,0,{[45]={{32.65,28.39},{32.05,29.51},{32.68,29.49},{32.22,28.57},{32.31,28.02},{32.56,28.66},},[267]={{53.61,56.86},{54.15,56.48},{53.72,55.74},{54.09,55.8},{36.81,40.09},{35.0,37.88},{32.99,36.26},{36.88,45.39},{31.6,34.63},{34.98,37.51},},[44]={{24.73,58.84},},[12]={{62.77,78.27},{31.83,54.02},{36.77,55.55},{43.85,53.07},{43.84,52.62},{45.95,55.6},{32.14,54.92},{34.95,60.25},{37.71,63.68},{35.64,63.51},{29.06,69.47},{33.58,75.02},{28.54,73.62},{26.62,75.53},{22.59,76.6},{30.75,88.41},{31.38,77.25},{38.04,88.56},{46.47,76.15},{53.61,74.64},{53.17,70.97},{54.49,76.86},{54.4,79.28},{56.48,74.21},{56.92,71.19},{65.23,78.75},{70.93,82.91},{74.4,67.46},{71.8,66.69},{71.22,61.91},{69.16,60.8},{66.56,66.84},{61.92,70.98},{61.74,71.13},{61.16,57.6},{59.93,69.39},{47.24,58.6},{67.13,43.99},{70.5,40.35},{77.11,71.19},{80.0,77.15},{79.98,58.67},{77.68,61.3},{86.8,70.94},{86.88,65.84},{86.33,65.17},},[40]={{59.61,23.69},{59.65,14.89},},[1]={{60.7,5.38},{61.58,5.01},{61.91,5.45},},[11]={{19.3,69.14},{20.34,68.7},{20.74,69.22},},},nil,12,nil,nil,190,"AH",},
[2447] = {'Narillasanz',12121,12121,44,44,1,{[36]={{73.71,65.35},},},{[36]={{73.66,65.44},{73.24,65.89},{72.78,66.38},{72.18,66.87},{71.63,67.65},{71.15,68.5},{70.68,69.27},{69.98,70.22},{69.37,70.95},{68.78,71.41},{68.18,71.41},{67.54,70.55},{67.3,70.15},{67.0,69.63},{66.73,69.27},{66.61,69.06},{66.31,68.51},{65.89,67.91},{65.75,66.86},{65.61,65.83},{65.39,64.34},{65.24,63.82},{64.83,63.16},{64.43,62.45},{64.03,62.12},{63.46,62.29},{62.98,62.29},{62.4,62.18},{61.73,62.0},{61.1,61.73},{60.57,61.3},{59.94,60.85},{59.42,60.67},{58.68,60.39},{58.06,60.61},{57.56,61.07},{57.25,62.33},{57.09,63.31},{56.66,64.43},{55.98,64.87},{55.36,65.3},{54.72,65.23},{54.0,65.01},{53.31,64.89},{52.51,64.49},{51.67,64.22},{51.31,64.21},{51.02,64.71},{50.77,65.09},{50.29,65.16},{49.71,65.38},{49.43,65.99},{49.28,66.99},{49.36,67.33},{49.6,67.73},{49.48,68.67},{49.37,69.4},{49.18,70.29},{49.06,71.17},{48.91,72.07},{48.77,72.95},{48.64,73.76},{48.36,75.34},{47.84,76.29},{47.27,77.04},{46.41,77.45},{45.39,77.26},{44.52,77.7},{43.73,77.81},{42.87,78.07},{42.3,77.78},{41.87,77.04},{41.39,76.17},{40.93,75.33},{40.37,74.28},{39.95,73.4},{39.48,72.5},{39.02,71.88},{38.26,71.35},{37.35,70.36},{36.48,69.51},{36.03,68.82},{35.71,68.59},{35.09,68.34},{34.45,68.27},{33.77,68.22},{33.07,67.51},{32.72,67.11},{32.31,66.64},{31.85,66.16},{31.26,66.53},{30.98,66.44},{30.77,65.97},{30.59,65.43},{30.12,64.3},{29.75,63.75},{29.37,62.76},{28.78,61.51},{28.92,60.45},{28.88,59.31},{28.91,58.66},{28.97,57.58},{28.84,56.67},{28.69,56.15},{28.47,55.03},{28.7,53.85},{29.17,52.39},{29.65,50.46},{29.89,48.86},{29.36,49.0},{29.03,48.84},{28.86,48.5},{28.63,48.09},{28.33,48.1},{28.03,48.17},{27.75,48.53},{27.33,48.63},{27.16,48.14},{26.95,48.04},{26.54,48.08},{26.21,48.09},{26.0,47.79},{25.81,47.5},{25.66,47.22},{25.53,46.53},{25.65,46.22},{26.32,45.11},{26.98,43.99},{27.66,42.89},{28.31,41.74},{28.97,40.63},{29.66,39.54},{30.34,38.43},{30.91,37.19},{31.23,35.98},{31.42,34.53},{31.63,32.87},{31.8,32.33},{32.49,30.98},{33.21,29.94},{33.97,28.97},{34.77,28.05},{35.19,27.2},{35.71,25.92},{36.13,25.12},{36.93,24.4},{37.73,24.12},{39.21,23.83},{39.7,23.66},{41.04,22.76},{41.42,22.26},{42.33,21.11},{42.89,20.63},{43.27,20.14},{44.18,19.25},{44.66,19.07},{45.97,18.78},{46.41,19.14},{47.22,20.02},{48.01,20.94},{48.79,21.87},{49.17,22.36},{49.93,23.34},{50.31,23.83},{51.05,24.83},{51.74,25.87},{52.07,26.44},{53.04,28.15},{53.69,29.29},{54.37,30.39},{55.09,31.42},{55.7,32.29},{56.26,33.18},{56.62,33.63},{57.46,34.43},{58.25,35.34},{58.0,33.89},{58.31,34.47},{58.75,36.01},{59.02,36.77},{59.5,37.67},{60.19,38.54},{60.87,38.6},{61.19,38.28},{61.52,37.84},{61.91,37.37},{62.4,37.58},{62.89,37.93},{63.15,38.53},{63.56,38.97},{63.97,39.4},{64.41,40.2},{64.58,41.64},{64.77,43.14},{64.75,44.13},{64.72,44.65},{64.35,45.16},{63.85,46.03},{64.41,46.77},{65.08,46.84},{65.59,46.76},{66.72,47.14},{67.3,47.23},{68.23,46.97},{68.78,46.55},{69.28,46.53},{70.28,46.57},{71.07,46.56},{71.92,46.46},{72.42,46.43},{73.3,46.35},{73.79,46.53},{74.78,46.76},{75.46,46.78},{76.17,46.77},{76.78,46.77},{77.66,46.45},{78.21,46.35},{78.71,46.64},{79.91,47.06},{80.57,47.06},{81.04,47.94},{81.86,48.76},{82.34,49.56},{82.85,50.2},{82.59,51.47},{81.95,52.15},{81.13,52.86},{80.56,53.94},{80.11,55.11},{79.72,56.0},{79.29,57.17},{78.9,58.42},{78.48,59.89},{77.87,61.29},{77.08,61.83},{76.24,62.34},{75.48,62.91},{74.85,63.58},{74.26,64.45},},[267]={{73.31,5.69},{72.94,6.09},{72.53,6.52},{72.01,6.95},{71.53,7.63},{71.11,8.37},{70.7,9.05},{70.08,9.88},{69.55,10.52},{69.04,10.92},{68.52,10.92},{67.96,10.17},{67.75,9.81},{67.48,9.37},{67.25,9.05},{67.14,8.86},{66.87,8.39},{66.51,7.86},{66.39,6.94},{66.26,6.04},{66.07,4.73},{65.93,4.28},{65.58,3.7},{65.23,3.08},{64.88,2.79},{64.38,2.94},{63.96,2.94},{63.46,2.84},{62.87,2.69},{62.32,2.45},{61.86,2.07},{61.3,1.68},{60.84,1.53},{60.2,1.28},{59.65,1.47},{59.22,1.87},{58.95,2.97},{58.8,3.84},{58.43,4.81},{57.84,5.2},{57.3,5.57},{56.74,5.51},{56.1,5.32},{55.5,5.22},{54.8,4.87},{54.06,4.63},{53.75,4.62},{53.5,5.06},{53.28,5.39},{52.86,5.45},{52.35,5.64},{52.1,6.18},{51.98,7.05},{52.04,7.35},{52.25,7.7},{52.15,8.52},{52.05,9.16},{51.89,9.94},{51.78,10.71},{51.65,11.5},{51.53,12.27},{51.42,12.98},{51.17,14.36},{50.72,15.19},{50.22,15.85},{49.46,16.21},{48.57,16.04},{47.81,16.43},{47.11,16.52},{46.36,16.75},{45.87,16.49},{45.49,15.85},{45.07,15.08},{44.66,14.35},{44.17,13.43},{43.81,12.67},{43.4,11.88},{43.0,11.33},{42.33,10.87},{41.54,10.0},{40.77,9.26},{40.38,8.66},{40.1,8.46},{39.56,8.23},{39.0,8.17},{38.4,8.13},{37.79,7.51},{37.49,7.16},{37.13,6.75},{36.72,6.33},{36.21,6.65},{35.96,6.57},{35.78,6.16},{35.62,5.69},{35.21,4.7},{34.88,4.22},{34.55,3.36},{34.04,2.26},{34.16,1.33},{34.13,0.34},{77.53,0.84},{76.99,2.07},{76.3,2.54},{75.57,2.99},{74.9,3.48},{74.35,4.07},{73.83,4.83},},[130]={{99.97,49.44},{99.49,49.29},{99.03,49.21},{98.5,48.95},{97.94,48.77},{97.7,48.76},{97.51,49.09},{97.34,49.34},{97.02,49.39},{96.63,49.54},{96.44,49.95},{96.35,50.61},{96.4,50.84},{96.56,51.11},{96.48,51.73},{96.41,52.22},{96.28,52.81},{96.2,53.4},{96.1,54.0},{96.01,54.58},{95.92,55.13},{95.73,56.18},{95.39,56.81},{95.01,57.31},{94.43,57.59},{93.75,57.46},{93.17,57.75},{92.64,57.82},{92.07,58.0},{91.69,57.8},{91.4,57.31},{91.09,56.73},{90.78,56.17},{90.4,55.47},{90.12,54.89},{89.81,54.29},{89.5,53.87},{89.0,53.52},{88.39,52.86},{87.81,52.29},{87.51,51.83},{87.3,51.68},{86.88,51.51},{86.46,51.47},{86.01,51.43},{85.54,50.96},{85.31,50.7},{85.03,50.38},{84.73,50.06},{84.34,50.31},{84.14,50.25},{84.0,49.93},{83.89,49.57},{83.57,48.82},{83.33,48.45},{83.07,47.8},{82.68,46.96},{82.77,46.25},{82.75,45.49},{82.76,45.06},{82.81,44.34},{82.72,43.73},{82.62,43.38},{82.48,42.64},{82.63,41.85},{82.94,40.88},{83.26,39.59},{83.42,38.53},{83.07,38.62},{82.84,38.51},{82.73,38.28},{82.58,38.01},{82.38,38.02},{82.18,38.06},{81.99,38.31},{81.72,38.37},{81.6,38.04},{81.46,37.98},{81.18,38.01},{80.97,38.01},{80.82,37.81},{80.7,37.62},{80.6,37.43},{80.51,36.97},{80.59,36.76},{81.04,36.03},{81.48,35.28},{81.93,34.54},{82.36,33.78},{82.81,33.04},{83.27,32.31},{83.72,31.58},{84.1,30.74},{84.31,29.94},{84.44,28.97},{84.58,27.86},{84.69,27.5},{85.15,26.61},{85.63,25.91},{86.14,25.27},{86.67,24.65},{86.96,24.09},{87.3,23.23},{87.58,22.7},{88.11,22.22},{88.64,22.03},{89.63,21.84},{89.96,21.72},{90.85,21.12},{91.1,20.79},{91.71,20.03},{92.09,19.7},{92.34,19.38},{92.94,18.79},{93.27,18.66},{94.14,18.47},{94.43,18.71},{94.97,19.3},{95.5,19.91},{96.02,20.53},{96.27,20.86},{96.78,21.51},{97.03,21.84},{97.53,22.5},{97.99,23.2},{98.2,23.58},{98.85,24.72},{99.29,25.48},{99.74,26.21},},[28]={{10.47,99.23},{10.78,97.98},{10.94,96.93},{10.59,97.03},{10.38,96.92},{10.27,96.7},{10.11,96.43},{9.92,96.43},{9.73,96.48},{9.54,96.72},{9.27,96.78},{9.16,96.46},{9.02,96.4},{8.75,96.43},{8.54,96.43},{8.4,96.23},{8.28,96.05},{8.18,95.87},{8.1,95.42},{8.17,95.21},{8.61,94.49},{9.04,93.76},{9.49,93.04},{9.91,92.3},{10.34,91.57},{10.79,90.86},{11.23,90.14},{11.6,89.33},{11.81,88.55},{11.93,87.6},{12.07,86.52},{12.18,86.17},{12.63,85.29},{13.1,84.61},{13.6,83.98},{14.11,83.38},{14.39,82.83},{14.73,82.0},{15.0,81.47},{15.52,81.01},{16.04,80.82},{17.01,80.63},{17.32,80.52},{18.2,79.93},{18.44,79.61},{19.03,78.86},{19.4,78.55},{19.65,78.23},{20.24,77.65},{20.56,77.53},{21.41,77.34},{21.69,77.58},{22.22,78.15},{22.74,78.75},{23.24,79.36},{23.49,79.68},{23.98,80.32},{24.23,80.64},{24.72,81.28},{25.16,81.96},{25.38,82.33},{26.01,83.45},{26.44,84.19},{26.88,84.9},{27.35,85.58},{27.74,86.14},{28.11,86.72},{28.34,87.01},{28.89,87.54},{29.41,88.13},{29.24,87.18},{29.44,87.56},{29.73,88.57},{29.9,89.06},{30.22,89.65},{30.67,90.22},{31.11,90.25},{31.32,90.04},{31.53,89.76},{31.79,89.45},{32.1,89.59},{32.42,89.81},{32.59,90.21},{32.86,90.5},{33.13,90.77},{33.41,91.29},{33.52,92.23},{33.65,93.21},{33.64,93.85},{33.62,94.19},{33.37,94.53},{33.05,95.09},{33.42,95.57},{33.85,95.62},{34.18,95.57},{34.92,95.82},{35.3,95.87},{35.9,95.7},{36.26,95.42},{36.58,95.41},{37.23,95.44},{37.75,95.43},{38.3,95.37},{38.63,95.35},{39.21,95.3},{39.52,95.41},{40.17,95.56},{40.61,95.58},{41.07,95.57},{41.47,95.57},{42.04,95.36},{42.4,95.3},{42.73,95.48},{43.51,95.76},{43.94,95.76},{44.24,96.33},{44.78,96.86},{45.09,97.39},{45.42,97.8},{45.25,98.63},{44.83,99.08},{44.3,99.54},},[85]={{69.15,99.89},{69.26,98.99},{69.39,97.96},{69.5,97.62},{69.93,96.79},{70.37,96.15},{70.84,95.54},{71.33,94.98},{71.6,94.45},{71.92,93.66},{72.18,93.16},{72.67,92.71},{73.17,92.54},{74.09,92.36},{74.39,92.25},{75.23,91.69},{75.46,91.38},{76.02,90.67},{76.37,90.38},{76.61,90.08},{77.17,89.52},{77.47,89.41},{78.28,89.23},{78.55,89.45},{79.05,90.0},{79.54,90.57},{80.03,91.15},{80.26,91.45},{80.73,92.06},{80.96,92.36},{81.43,92.98},{81.85,93.62},{82.06,93.98},{82.66,95.04},{83.06,95.74},{83.48,96.42},{83.93,97.06},{84.31,97.6},{84.65,98.15},{84.87,98.43},{85.4,98.93},{85.89,99.49},{85.73,98.59},{85.93,98.95},{86.2,99.91},},},36,nil,nil,60,nil,},
[2448] = {'Clerk Horrace Whitesteed',783,783,26,26,0,{[267]={{29.51,42.41},},},nil,267,nil,nil,88,"A",},
[2449] = {'Citizen Wilkes',713,713,25,25,0,{[267]={{32.62,39.79},},},{[130]={{81.53,75.57},{81.54,75.2},{81.54,75.2},{81.56,74.45},{81.62,73.96},{81.65,73.46},{81.64,73.06},{81.55,72.48},{81.55,72.48},{81.63,72.95},{81.65,73.46},{81.58,74.18},{81.55,74.67},{81.54,74.93},{81.55,75.6},{81.77,75.49},{81.82,75.45},{82.31,74.95},{82.75,74.69},{82.75,74.69},{83.41,74.71},{83.75,74.73},{84.1,74.87},{84.29,75.08},{84.49,75.29},{84.32,75.11},{84.05,74.84},{83.75,74.74},{83.42,74.7},{82.93,74.69},{82.6,74.72},{82.32,75.02},{81.96,75.34},{81.65,75.71},},[267]={{32.53,39.81},{32.54,39.32},{32.54,39.32},{32.56,38.34},{32.65,37.7},{32.68,37.05},{32.68,36.52},{32.56,35.76},{32.56,35.76},{32.67,36.37},{32.69,37.05},{32.59,37.98},{32.56,38.63},{32.54,38.97},{32.55,39.85},{32.85,39.7},{32.91,39.65},{33.56,39.0},{34.13,38.65},{34.13,38.65},{35.0,38.68},{35.44,38.71},{35.9,38.89},{36.15,39.17},{36.42,39.45},{36.19,39.2},{35.83,38.85},{35.45,38.71},{35.01,38.67},{34.36,38.66},{33.93,38.69},{33.56,39.08},{33.09,39.51},{32.69,39.99},},[36]={{27.09,99.79},{27.09,99.79},},},267,nil,nil,88,"A",},
[2450] = {'Miner Hackett',943,943,29,29,0,{[267]={{31.12,58.63},},},nil,267,nil,nil,88,"A",},
[2451] = {'Farmer Kalaba',713,713,25,25,0,{[267]={{35.88,46.57},},},{[130]={{84.1,80.73},{84.14,80.49},{84.16,80.28},{84.19,79.91},{84.1,79.69},{83.89,79.34},{83.77,79.29},{83.59,79.7},{83.4,79.96},{83.18,80.2},{83.01,80.46},{82.84,80.74},{82.69,81.0},{82.73,81.15},{82.9,81.1},{83.09,81.46},{83.3,81.46},{83.45,81.59},{83.67,81.46},{83.84,81.37},{84.04,81.02},{84.2,80.85},},[267]={{35.9,46.58},{35.95,46.27},{35.98,46.0},{36.02,45.51},{35.9,45.21},{35.62,44.76},{35.47,44.7},{35.23,45.23},{34.98,45.58},{34.69,45.88},{34.47,46.23},{34.24,46.59},{34.05,46.94},{34.1,47.14},{34.33,47.07},{34.58,47.54},{34.85,47.55},{35.05,47.71},{35.33,47.54},{35.57,47.43},{35.82,46.97},{36.04,46.74},},},267,nil,nil,88,"A",},
[2452] = {'Skhowl',1469,1469,36,36,4,{[36]={{31.43,51.51},},},{[28]={{11.95,98.75},{12.23,98.44},{12.27,97.93},{12.28,97.43},{12.23,97.21},{12.06,96.96},{11.75,97.07},{11.2,97.33},{11.0,97.73},{10.75,98.33},{10.54,98.89},{10.54,98.89},{10.28,99.65},{10.51,99.85},{10.65,99.3},{10.97,99.16},{11.52,98.93},{11.75,99.02},},[36]={{31.44,51.65},{31.87,51.17},{31.94,50.39},{31.95,49.62},{31.88,49.29},{31.61,48.9},{31.13,49.07},{30.29,49.48},{29.99,50.09},{29.6,51.0},{29.28,51.86},{29.28,51.86},{28.88,53.03},{28.44,54.95},{28.7,55.85},{28.92,56.63},{29.12,57.17},{29.02,58.36},{28.95,59.08},{28.93,59.92},{28.87,60.69},{28.93,61.77},{29.45,62.63},{29.7,63.3},{30.18,64.05},{30.3,64.47},{30.65,64.98},{30.14,64.58},{30.14,63.95},{29.86,63.58},{29.39,63.17},{29.22,62.12},{29.05,61.06},{28.97,60.24},{28.98,59.47},{29.0,58.49},{29.0,57.23},{28.76,56.56},{28.69,56.11},{28.54,54.94},{28.67,53.84},{29.24,53.34},{29.45,52.49},{29.94,52.28},{30.79,51.93},{31.14,52.06},},[130]={{84.45,40.38},{84.74,40.06},{84.79,39.55},{84.79,39.03},{84.74,38.81},{84.56,38.55},{84.25,38.66},{83.69,38.94},{83.48,39.35},{83.22,39.95},{83.01,40.53},{83.01,40.53},{82.75,41.31},{82.45,42.59},{82.62,43.19},{82.77,43.7},{82.91,44.07},{82.84,44.86},{82.8,45.34},{82.78,45.9},{82.74,46.41},{82.78,47.13},{83.12,47.7},{83.29,48.15},{83.61,48.65},{83.69,48.93},{83.93,49.27},{83.58,49.0},{83.58,48.58},{83.4,48.34},{83.09,48.07},{82.97,47.37},{82.86,46.66},{82.8,46.11},{82.81,45.6},{82.83,44.95},{82.83,44.11},{82.66,43.66},{82.62,43.36},{82.52,42.58},{82.61,41.84},{82.98,41.51},{83.13,40.95},{83.45,40.81},{84.02,40.57},{84.25,40.66},},[267]={{34.19,0.14},{34.17,0.87},{34.12,1.54},{34.17,2.49},{34.62,3.24},{34.84,3.82},{35.26,4.48},{35.37,4.85},{35.68,5.29},{35.22,4.94},{35.23,4.39},{34.98,4.07},{34.57,3.71},{34.43,2.79},{34.27,1.87},{34.2,1.15},{34.21,0.47},},},36,nil,nil,16,nil,},
[2453] = {'Lo\'Grosh',1196,1196,39,39,4,{[36]={{52.09,46.94},{47.52,32.31},},[28]={{22.42,86.15},},[85]={{79.24,97.61},},[130]={{95.17,27.49},},},{[28]={{25.4,95.93},{25.59,96.08},{25.87,96.15},{26.07,96.27},{26.22,96.51},{26.35,96.94},{26.57,97.33},{26.37,96.99},{26.26,96.66},{26.2,96.48},{25.98,96.21},{25.89,96.02},{25.83,95.62},{25.67,95.34},{25.49,95.41},{25.39,95.67},},[36]={{52.1,47.32},{52.39,47.56},{52.82,47.66},{53.13,47.85},{53.36,48.21},{53.55,48.87},{53.9,49.47},{53.6,48.95},{53.42,48.44},{53.33,48.16},{52.99,47.75},{52.85,47.46},{52.76,46.85},{52.51,46.42},{52.23,46.53},{52.09,46.93},},[130]={{98.23,37.5},{98.42,37.66},{98.71,37.72},{98.91,37.85},{99.07,38.09},{99.2,38.53},{99.43,38.93},{99.22,38.58},{99.1,38.25},{99.04,38.06},{98.82,37.78},{98.73,37.59},{98.67,37.19},{98.5,36.9},{98.31,36.97},{98.22,37.24},},},36,nil,nil,45,nil,},
[2454] = {'Skeletal Fiend (Enraged Form)',300,400,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[2455] = {'Olivia Burnside',2972,2972,45,45,0,{[1519]={{57.66,72.78},},},nil,1519,nil,nil,12,"A",},
[2456] = {'Newton Burnside',2972,2972,45,45,0,{[1519]={{57.12,73.23},},},nil,1519,nil,nil,12,"A",},
[2457] = {'John Burnside',2972,2972,45,45,0,{[1519]={{56.57,73.68},},},nil,1519,nil,nil,12,"A",},
[2458] = {'Randolph Montague',2972,2972,45,45,0,{[1497]={{65.93,43.43},},},nil,1497,nil,nil,68,"H",},
[2459] = {'Mortimer Montague',2972,2972,45,45,0,{[1497]={{66.41,44.06},},},nil,1497,nil,nil,68,"H",},
[2460] = {'Barnum Stonemantle',2972,2972,45,45,0,{[1537]={{34.97,58.41},},},nil,1537,nil,nil,55,"A",},
[2461] = {'Bailey Stonemantle',2972,2972,45,45,0,{[1537]={{35.92,60.14},},},nil,1537,nil,nil,55,"A",},
[2462] = {'Flesh Eating Worm',60,60,25,25,0,nil,nil,0,nil,nil,21,nil,},
[2464] = {'Commander Aggro\'gosh',59535,59535,60,60,1,{[33]={{32.17,28.9},},},nil,33,{568,569,},{568,569,},29,"H",},
[2465] = {'Far Seer Mok\'thardin',2972,2972,45,45,0,{[33]={{32.12,29.24},},},nil,33,{570,571,572,573,},{570,571,572,573,},29,"H",},
[2466] = {'Mountaineer Grugelm',1100,1100,30,30,0,{[11]={{52.64,83.0},},},{[1]={{88.7,17.0},{88.56,16.98},{88.17,16.9},{87.84,16.83},{87.49,16.76},{87.04,16.66},{87.52,16.76},{87.84,16.82},{88.2,16.9},{88.54,16.98},{88.92,17.05},{89.25,17.13},{89.6,17.19},{89.96,17.27},{90.3,17.35},{90.56,17.4},{90.78,17.46},{90.48,17.4},{89.99,17.29},{89.65,17.21},{89.26,17.13},{88.91,17.05},},[11]={{52.64,82.99},{52.48,82.96},{52.01,82.87},{51.62,82.79},{51.2,82.7},{50.66,82.58},{51.23,82.71},{51.62,82.78},{52.05,82.87},{52.45,82.96},{52.9,83.05},{53.3,83.14},{53.71,83.22},{54.14,83.31},{54.55,83.4},{54.85,83.47},{55.12,83.53},{54.76,83.46},{54.18,83.33},{53.77,83.24},{53.31,83.14},{52.89,83.04},},},11,nil,nil,57,"A",},
[2468] = {'Mountaineer Thar',2065,2065,30,30,0,{[11]={{55.72,84.73},},},nil,11,nil,nil,57,"A",},
[2469] = {'Mountaineer Rharen',1987,1987,30,30,0,{[11]={{55.31,83.41},},},nil,11,nil,nil,57,"A",},
[2470] = {'Watcher Fraizer',2016,2016,35,35,0,{[10]={{74.76,47.97},},},nil,10,nil,nil,56,"A",},
[2473] = {'Granistad',1753,1753,40,40,0,{[267]={{84.25,32.82},},},nil,267,nil,nil,122,"A",},
[2474] = {'Kurdros',1750,1750,40,40,0,{[267]={{83.89,32.2},},},nil,267,nil,nil,122,"A",},
[2475] = {'Sloth',1684,1684,31,31,0,nil,nil,0,nil,nil,14,nil,},
[2476] = {'Large Loch Crocolisk',573,573,22,22,4,{[38]={{58.9,31.07},{60.3,39.59},},},nil,38,nil,nil,14,nil,},
[2477] = {'Gradok',1347,1563,19,21,1,{[38]={{55.45,66.87},},},{[38]={{55.79,66.73},{56.05,66.39},{56.39,65.71},{56.89,65.7},{57.47,65.02},{58.17,64.46},{58.91,64.21},{59.36,63.57},{59.96,62.52},{60.16,62.02},{60.53,61.1},{60.95,60.44},{61.23,60.11},{61.59,59.58},{62.54,58.21},{62.94,57.6},{63.19,56.8},{63.42,56.06},{63.59,55.46},{63.6,54.82},{63.74,54.27},{63.87,53.38},{64.16,51.78},{64.25,50.98},{64.3,50.52},{64.37,49.88},{64.35,48.58},{64.51,47.68},{64.49,46.1},{64.56,44.89},{64.56,43.86},{64.52,43.27},{64.43,42.54},{64.19,41.58},{64.21,40.34},{64.03,39.27},{63.96,38.51},{64.31,37.71},{64.57,37.2},{64.44,36.58},{64.19,35.86},{64.1,35.5},{63.98,34.99},{63.7,34.22},{63.44,33.67},{63.39,32.8},{63.21,32.12},{63.11,31.65},{62.76,31.01},{62.38,30.44},{61.84,29.77},{61.66,29.49},{61.41,28.89},{61.11,28.16},{60.8,27.48},{60.57,26.95},{60.38,26.48},{60.16,25.97},{59.89,25.31},{59.3,24.41},{58.8,23.43},{58.52,22.94},{58.29,22.39},{57.95,21.54},{57.75,21.05},{57.49,20.19},{57.27,19.36},{56.97,18.16},{57.13,17.47},{57.64,17.39},{58.26,17.65},{58.7,18.06},{59.37,18.88},{59.5,19.73},{59.66,20.77},{59.79,21.54},{60.21,22.39},{60.4,23.02},{61.07,24.29},{61.17,25.19},{61.6,26.08},{61.98,26.81},{62.25,27.51},{62.39,28.56},{62.59,29.04},{63.11,30.19},{63.44,30.93},{63.82,31.89},{64.01,32.56},{64.4,34.46},{64.63,35.35},{64.99,36.36},{65.36,37.2},{65.76,38.32},{65.63,39.02},{66.08,39.96},{65.66,40.96},{65.64,41.75},{65.71,42.55},{65.69,43.34},{65.51,44.34},{65.61,45.28},{65.78,45.9},{66.09,47.09},{66.38,48.09},{66.36,49.22},{66.66,50.26},{66.55,50.97},{66.38,51.86},{65.58,52.24},{65.14,52.42},{64.66,53.02},{64.03,54.05},{63.9,54.52},{63.65,55.15},{63.44,55.77},{63.3,56.56},{63.02,57.79},{62.54,58.44},{61.64,59.62},{61.16,59.72},{60.39,59.76},{59.78,60.41},{59.13,61.19},{58.53,62.01},{58.17,62.75},{57.89,63.49},{57.17,64.26},{56.56,65.01},{56.15,65.8},{55.49,66.69},},[11]={{77.67,99.83},{77.44,99.26},{77.31,98.93},{77.14,98.36},{76.99,97.8},{76.79,97.0},{76.9,96.54},{77.24,96.49},{77.65,96.66},{77.95,96.94},{78.39,97.48},{78.48,98.05},{78.58,98.75},{78.67,99.26},{78.95,99.83},},},38,nil,nil,83,"H",},
[2478] = {'Haren Swifthoof',1347,1563,20,21,1,{[38]={{55.45,67.06},},},{[38]={{55.79,66.73},{56.05,66.39},{56.39,65.71},{56.89,65.7},{57.47,65.02},{58.17,64.46},{58.91,64.21},{59.36,63.57},{59.96,62.52},{60.16,62.02},{60.53,61.1},{60.95,60.44},{61.23,60.11},{61.59,59.58},{62.54,58.21},{62.94,57.6},{63.19,56.8},{63.42,56.06},{63.59,55.46},{63.6,54.82},{63.74,54.27},{63.87,53.38},{64.16,51.78},{64.25,50.98},{64.3,50.52},{64.37,49.88},{64.35,48.58},{64.51,47.68},{64.49,46.1},{64.56,44.89},{64.56,43.86},{64.52,43.27},{64.43,42.54},{64.19,41.58},{64.21,40.34},{64.03,39.27},{63.96,38.51},{64.31,37.71},{64.57,37.2},{64.44,36.58},{64.19,35.86},{64.1,35.5},{63.98,34.99},{63.7,34.22},{63.44,33.67},{63.39,32.8},{63.21,32.12},{63.11,31.65},{62.76,31.01},{62.38,30.44},{61.84,29.77},{61.66,29.49},{61.41,28.89},{61.11,28.16},{60.8,27.48},{60.57,26.95},{60.38,26.48},{60.16,25.97},{59.89,25.31},{59.3,24.41},{58.8,23.43},{58.52,22.94},{58.29,22.39},{57.95,21.54},{57.75,21.05},{57.49,20.19},{57.27,19.36},{56.97,18.16},{57.13,17.47},{57.64,17.39},{58.26,17.65},{58.7,18.06},{59.37,18.88},{59.5,19.73},{59.66,20.77},{59.79,21.54},{60.21,22.39},{60.4,23.02},{61.07,24.29},{61.17,25.19},{61.6,26.08},{61.98,26.81},{62.25,27.51},{62.39,28.56},{62.59,29.04},{63.11,30.19},{63.44,30.93},{63.82,31.89},{64.01,32.56},{64.4,34.46},{64.63,35.35},{64.99,36.36},{65.36,37.2},{65.76,38.32},{65.63,39.02},{66.08,39.96},{65.66,40.96},{65.64,41.75},{65.71,42.55},{65.69,43.34},{65.51,44.34},{65.61,45.28},{65.78,45.9},{66.09,47.09},{66.38,48.09},{66.36,49.22},{66.66,50.26},{66.55,50.97},{66.38,51.86},{65.58,52.24},{65.14,52.42},{64.66,53.02},{64.03,54.05},{63.9,54.52},{63.65,55.15},{63.44,55.77},{63.3,56.56},{63.02,57.79},{62.54,58.44},{61.64,59.62},{61.16,59.72},{60.39,59.76},{59.78,60.41},{59.13,61.19},{58.53,62.01},{58.17,62.75},{57.89,63.49},{57.17,64.26},{56.56,65.01},{56.15,65.8},{55.49,66.69},},[11]={{77.67,99.83},{77.44,99.26},{77.31,98.93},{77.14,98.36},{76.99,97.8},{76.79,97.0},{76.9,96.54},{77.24,96.49},{77.65,96.66},{77.95,96.94},{78.39,97.48},{78.48,98.05},{78.58,98.75},{78.67,99.26},{78.95,99.83},},},38,nil,nil,83,"H",},
[2479] = {'Sludge',1684,1684,31,31,0,nil,nil,0,nil,nil,14,nil,},
[2480] = {'Bro\'kin',3404,3404,49,49,0,{[36]={{38.24,38.87},},},nil,36,nil,nil,120,"AH",},
[2481] = {'Bliztik',2100,2100,36,36,0,{[10]={{18.04,54.36},},},nil,10,nil,nil,120,"AH",},
[2482] = {'Zarena Cromwind',2766,2766,43,43,0,{[33]={{28.34,75.46},},},nil,33,nil,nil,120,"AH",},
[2483] = {'Jaquilina Dramet',2376,2376,39,39,0,{[33]={{35.75,10.66},},},nil,33,nil,nil,35,"AH",},
[2485] = {'Larimaine Purdue',3517,3517,50,50,0,{[1519]={{39.84,79.45},},},nil,1519,nil,nil,12,"A",},
[2486] = {'Fin Fizracket',2666,2666,42,42,0,{[33]={{27.61,76.74},},},nil,33,{348,},{348,},120,"AH",},
[2487] = {'Fleet Master Seahorn',3857,3857,60,60,0,{[33]={{27.17,77.01},},},nil,33,{604,608,670,},{599,604,608,669,},120,"AH",},
[2488] = {'Deeg',1930,1930,34,34,0,{[33]={{26.92,77.35},},},nil,33,{587,},{587,},120,"AH",},
[2489] = {'Milstaff Stormeye',2972,2972,45,45,0,{[1537]={{25.5,7.07},},},nil,1537,nil,nil,55,"A",},
[2490] = {'First Mate Crazz',2868,2868,44,44,0,{[33]={{28.1,76.22},},},nil,33,{595,599,},{597,},120,"AH",},
[2491] = {'Whiskey Slim',2284,2284,38,38,0,{[33]={{27.14,77.45},},},nil,33,{580,},{580,},120,"AH",},
[2492] = {'Lexington Mortaim',2016,2016,35,35,0,{[1497]={{84.19,15.58},},},nil,1497,nil,nil,68,"H",},
[2493] = {'Dizzy One-Eye',2568,2568,41,41,0,{[33]={{28.59,75.9},},},nil,33,{576,},{576,},120,"AH",},
[2494] = {'Privateer Bloads',2471,2471,40,40,0,{[33]={{26.76,76.38},},},nil,33,{617,623,},{617,},120,"AH",},
[2495] = {'Drizzlik',2972,2972,45,45,0,{[33]={{28.29,77.59},},},nil,33,{575,577,628,},{575,577,628,},120,"AH",},
[2496] = {'Baron Revilgaz',3857,3857,60,60,0,{[33]={{27.23,76.87},},},nil,33,{578,601,602,1182,1183,},{578,601,611,616,1181,1182,},120,"AH",},
[2497] = {'Nimboya',2568,2568,41,41,0,{[33]={{32.16,27.72},},},nil,33,{581,582,584,638,2932,},{581,582,592,2932,},126,"H",},
[2498] = {'Crank Fizzlebub',1930,1930,34,34,0,{[33]={{27.12,77.21},},},nil,33,{600,605,621,1119,1127,},{600,605,621,1118,1122,1127,},120,"AH",},
[2499] = {'Markel Smythe',2284,2284,38,38,0,{[33]={{28.01,74.92},},},nil,33,nil,nil,120,"AH",},
[2500] = {'Captain Hecklebury Smotts',2192,2192,37,37,0,{[33]={{26.69,73.61},},},nil,33,{8551,8553,},{8551,8552,8554,},120,"AH",},
[2501] = {'"Sea Wolf" MacKinley',2868,2868,44,44,0,{[33]={{27.78,77.07},},},nil,33,{606,609,613,2872,},{607,609,613,2874,},120,"AH",},
[2502] = {'"Shaky" Phillipe',2868,2868,44,44,0,{[33]={{26.9,73.59},},},nil,33,{607,},{606,},120,"AH",},
[2503] = {'Hillsbrad Foreman',840,896,27,28,0,{[267]={{31.89,52.4},{28.65,56.66},{30.9,56.26},{28.85,57.55},{31.13,54.43},{29.35,56.83},{29.56,52.99},{29.34,52.54},{29.63,55.33},{27.5,59.32},},},{[130]={{77.65,90.37},{77.55,90.22},{77.43,90.05},{77.5,89.95},{77.67,89.83},{77.71,89.67},{77.67,89.48},{77.56,89.27},{77.64,89.43},{77.67,89.61},{77.64,89.84},{77.53,89.95},{77.42,90.09},{77.29,90.24},{77.14,90.54},{77.26,90.3},{77.37,90.16},{77.52,90.24},},[267]={{27.44,59.23},{27.3,59.04},{27.14,58.81},{27.24,58.68},{27.46,58.52},{27.52,58.32},{27.46,58.07},{27.32,57.79},{27.42,58.01},{27.46,58.24},{27.42,58.54},{27.27,58.68},{27.13,58.86},{26.96,59.07},{26.76,59.45},{26.93,59.15},{27.07,58.96},{27.26,59.06},},},267,nil,nil,123,"A",},
[2504] = {'Donyal Tovald',644,644,15,15,0,{[1519]={{71.62,7.6},},},nil,1519,{579,},{579,},12,"A",},
[2505] = {'Saltwater Snapjaw',2672,2769,49,50,0,{[47]={{84.93,45.37},{85.31,41.85},{80.26,71.95},{85.15,57.75},{80.68,69.35},{80.56,77.29},{85.96,61.8},{77.37,86.47},{80.51,74.83},{85.12,55.02},{84.05,64.59},{82.75,41.34},{82.38,37.99},{83.52,39.89},{80.68,61.84},{83.05,50.4},{81.66,39.05},{84.4,61.93},{85.98,64.76},{83.17,44.84},{79.75,65.75},{82.57,46.11},{82.4,48.79},{83.08,47.61},{82.71,53.78},{82.99,52.89},{81.81,42.05},{82.14,43.14},{81.39,50.29},{83.48,55.32},{81.35,44.83},{82.61,59.19},{76.17,83.97},{83.36,42.12},{75.75,71.4},{81.54,55.12},{78.63,69.69},{81.87,52.95},{79.9,73.58},{82.33,51.34},{78.27,70.57},{76.74,68.34},{76.12,65.21},{78.17,68.48},{79.19,59.3},{78.19,60.65},{79.7,60.4},{83.61,57.81},{77.39,67.0},{84.2,59.09},{79.07,61.87},{81.48,60.46},{77.31,61.74},{77.31,64.19},{79.97,57.95},{78.52,65.2},{75.39,69.89},{74.74,70.98},{77.32,69.59},{74.63,68.29},{81.49,53.02},{81.66,54.61},{78.04,63.04},},},nil,47,nil,nil,7,"AH",},
[2506] = {'Mountaineer Harn',1605,1605,30,30,0,{[38]={{36.35,50.47},},},nil,38,nil,nil,57,"A",},
[2507] = {'Mountaineer Uthan',1454,1454,28,28,0,{[38]={{37.86,41.77},},},nil,38,nil,nil,57,"A",},
[2508] = {'Mountaineer Wuar',1605,1605,30,30,0,{[38]={{35.41,41.61},},},nil,38,nil,nil,57,"A",},
[2509] = {'Mountaineer Cragg',1605,1605,30,30,0,{[38]={{33.73,42.78},},},nil,38,nil,nil,57,"A",},
[2510] = {'Mountaineer Ozmok',1605,1605,30,30,0,{[38]={{35.11,46.72},},},nil,38,nil,nil,57,"A",},
[2511] = {'Mountaineer Bludd',1605,1605,30,30,0,{[38]={{38.96,43.37},},},nil,38,nil,nil,57,"A",},
[2512] = {'Mountaineer Roghan',1454,1454,28,28,0,{[38]={{34.85,51.25},},},nil,38,nil,nil,57,"A",},
[2513] = {'Mountaineer Janha',1605,1605,30,30,0,{[38]={{35.41,44.48},},},nil,38,nil,nil,57,"A",},
[2514] = {'Mountaineer Modax',1605,1605,30,30,0,{[38]={{37.56,44.88},},},{[1]={{98.03,43.69},{97.96,43.2},{97.88,42.56},{97.69,42.2},{97.55,41.83},{97.73,42.28},{97.92,42.7},{98.0,43.44},{97.94,44.06},{97.76,44.45},{97.45,44.49},{97.21,44.57},{97.46,44.52},{97.8,44.47},{97.91,44.19},},[38]={{37.42,44.81},{37.3,43.93},{37.15,42.78},{36.81,42.14},{36.57,41.47},{36.88,42.28},{37.22,43.03},{37.37,44.35},{37.25,45.45},{36.94,46.15},{36.38,46.22},{35.95,46.38},{36.41,46.28},{37.01,46.2},{37.21,45.69},},},38,nil,nil,57,"A",},
[2515] = {'Mountaineer Fazgard',1901,1901,30,30,0,{[38]={{39.06,46.66},},},nil,38,nil,nil,57,"A",},
[2516] = {'Mountaineer Kamdar',1454,1454,28,28,0,{[38]={{33.31,44.76},},},nil,38,nil,nil,57,"A",},
[2517] = {'Mountaineer Langarr',1605,1605,30,30,0,{[38]={{35.82,46.93},},},nil,38,nil,nil,57,"A",},
[2518] = {'Mountaineer Swarth',1605,1605,30,30,0,{[38]={{37.37,49.22},},},nil,38,nil,nil,57,"A",},
[2519] = {'Kin\'weelay',2376,2376,39,39,0,{[33]={{32.27,27.71},},},nil,33,{589,591,592,596,598,629,},{588,589,591,596,598,629,1240,},126,"H",},
[2520] = {'Remote-Controlled Golem',1234,1234,18,18,1,nil,nil,0,nil,nil,17,nil,},
[2521] = {'Skymane Gorilla',1902,1902,50,50,0,{[33]={{40.44,77.28},{41.87,77.92},{41.34,77.82},{40.3,79.45},{40.24,80.47},{40.73,79.14},{41.88,79.46},{39.13,86.56},{40.86,81.89},{39.24,78.71},{40.29,82.04},{41.87,81.11},{40.87,80.54},{40.36,83.86},{41.86,82.54},{40.26,86.52},{41.89,84.15},{41.31,85.02},{38.75,85.9},},},nil,33,nil,nil,72,nil,},
[2522] = {'Jaguero Stalker',1902,1902,50,50,0,{[33]={{36.49,80.89},{37.14,80.36},{38.65,86.58},{36.5,84.05},{36.6,85.69},{38.89,77.76},{37.09,83.3},{37.64,86.14},{37.53,82.85},{37.75,81.57},{37.64,83.55},{37.8,79.98},{37.28,78.58},{38.05,81.31},},},nil,33,nil,nil,16,nil,},
[2523] = {'Searing Totem',5,5,19,19,0,nil,nil,0,nil,nil,35,"AH",},
[2524] = {'Mountaineer Haggis',1605,1605,30,30,0,{[38]={{42.57,10.97},},},nil,38,nil,nil,57,"A",},
[2525] = {'Mountaineer Barn',1605,1605,30,30,0,{[38]={{43.44,11.3},},},{[11]={{67.69,92.36},{67.34,91.78},{67.08,92.1},{66.13,93.32},{66.39,92.98},{67.34,91.84},{67.59,92.18},{68.1,92.86},{68.63,93.49},{69.18,94.05},{69.68,94.38},{70.02,94.42},{70.8,94.48},{71.45,94.42},{71.91,94.21},{72.47,93.82},{73.05,93.29},{73.61,92.72},{74.28,91.93},{74.48,92.33},{75.23,93.31},{75.65,94.15},{75.48,93.71},{75.1,93.1},{74.6,92.42},{74.21,91.92},{73.71,92.62},{73.18,93.24},{72.59,93.74},{71.37,94.4},{70.62,94.48},{69.95,94.41},{69.24,94.2},{68.71,93.57},{68.19,92.92},{67.68,92.26},{67.28,91.75},},[38]={{43.33,11.21},{42.81,10.33},{42.42,10.82},{40.99,12.64},{41.37,12.14},{42.81,10.43},{43.18,10.94},{43.94,11.95},{44.73,12.9},{45.56,13.74},{46.31,14.23},{46.82,14.29},{47.99,14.39},{48.96,14.29},{49.66,13.98},{50.5,13.39},{51.37,12.6},{52.2,11.74},{53.2,10.56},{53.51,11.16},{54.64,12.63},{55.26,13.89},{55.01,13.23},{54.44,12.32},{53.69,11.29},{53.1,10.54},{52.36,11.59},{51.56,12.52},{50.68,13.27},{48.85,14.27},{47.72,14.38},{46.71,14.28},{45.66,13.96},{44.86,13.02},{44.08,12.04},{43.31,11.05},{42.71,10.29},},},38,nil,nil,57,"A",},
[2526] = {'Mountaineer Morlic',2039,2039,30,30,0,{[38]={{46.24,14.16},},},nil,38,nil,nil,57,"A",},
[2527] = {'Mountaineer Angst',1454,1454,28,28,0,{[38]={{48.56,14.44},},},nil,38,nil,nil,57,"A",},
[2528] = {'Mountaineer Haggil',1605,1605,30,30,0,{[38]={{53.03,10.98},},},nil,38,nil,nil,57,"A",},
[2529] = {'Son of Arugal',1953,2097,24,25,1,{[209]={{-1, -1}},[130]={{44.96,79.59},{38.14,15.17},{47.34,34.02},},},{[209]={{-1, -1}},[85]={{26.31,86.13},{26.61,86.18},{26.93,86.09},{27.37,86.18},{27.52,86.49},{27.59,86.89},{27.53,87.24},{27.26,87.2},{26.92,87.15},{26.41,87.07},{26.06,86.89},{25.84,86.6},{26.04,86.14},},[130]={{38.23,15.14},{38.55,15.19},{38.89,15.09},{39.36,15.19},{39.53,15.53},{39.61,15.95},{39.54,16.33},{39.25,16.29},{38.88,16.23},{38.34,16.15},{37.96,15.96},{37.72,15.64},{37.93,15.14},},},130,nil,nil,24,nil,},
[2530] = {'Yenniku',1902,1902,41,41,0,{[33]={{39.02,58.35},},},nil,33,{593,},{593,},28,nil,},
[2531] = {'Minion of Morganth',1432,1432,30,30,0,nil,nil,0,nil,nil,68,"H",},
[2532] = {'Donna',64,64,1,1,0,{[1519]={{61.36,51.97},},},nil,1519,nil,nil,12,"A",},
[2533] = {'William',64,64,1,1,0,{[1519]={{61.82,51.34},},},{[12]={{28.57,34.3},{28.83,33.95},{29.21,33.47},{29.13,33.16},{28.94,32.73},{28.6,32.33},{28.34,31.78},{28.3,31.04},{28.45,30.61},{29.18,29.61},{29.43,29.0},{29.25,28.74},{29.06,28.58},{28.93,28.13},{28.68,27.72},{28.49,27.63},{28.12,27.68},{27.67,28.06},{27.26,27.79},{26.63,27.1},{25.93,25.66},{25.68,24.82},{25.34,24.66},{25.05,24.96},{24.85,25.15},{24.77,25.27},{24.49,25.56},{24.42,26.02},{24.57,26.49},{25.18,27.54},{25.37,28.88},{25.41,29.79},{25.22,30.89},{24.92,31.37},{24.5,31.68},{23.67,32.78},{23.26,33.21},{23.08,33.66},{23.39,34.18},{23.42,34.39},{23.7,34.7},{24.06,34.51},{24.89,36.01},{25.09,36.0},{25.46,35.54},{25.92,35.38},{26.35,35.45},{26.72,35.82},{27.26,37.12},{26.79,37.57},{26.23,38.51},{25.8,38.5},{25.67,38.12},{25.79,37.75},{26.02,37.63},{26.29,37.9},{26.19,38.48},{25.63,39.18},{25.2,39.35},{24.84,38.55},{24.62,38.23},{23.47,39.11},{23.17,38.39},{22.77,37.22},{22.84,36.17},{23.14,35.55},{23.9,34.61},{24.31,34.18},{24.72,33.98},{25.06,33.41},{26.14,33.13},{26.6,33.0},{27.09,33.31},{27.3,33.93},{28.06,34.99},{28.22,34.91},{28.37,34.55},},[1519]={{62.28,50.71},{62.94,49.81},{63.94,48.57},{63.74,47.79},{63.24,46.68},{62.35,45.63},{61.69,44.22},{61.59,42.29},{61.98,41.19},{63.85,38.6},{64.5,37.05},{64.02,36.37},{63.55,35.96},{63.2,34.8},{62.56,33.74},{62.06,33.5},{61.13,33.63},{59.95,34.6},{58.91,33.9},{57.26,32.13},{55.45,28.42},{54.82,26.23},{53.93,25.83},{53.18,26.59},{52.68,27.1},{52.46,27.4},{51.74,28.16},{51.56,29.34},{51.95,30.55},{53.52,33.27},{54.02,36.74},{54.11,39.08},{53.62,41.92},{52.85,43.16},{51.76,43.95},{49.62,46.8},{48.55,47.91},{48.1,49.07},{48.9,50.4},{48.98,50.96},{49.71,51.76},{50.62,51.27},{52.79,55.15},{53.29,55.11},{54.24,53.91},{55.45,53.51},{56.55,53.68},{57.51,54.63},{58.9,58.0},{57.69,59.16},{56.22,61.6},{55.12,61.57},{54.79,60.58},{55.09,59.62},{55.7,59.32},{56.38,60.01},{56.14,61.52},{54.68,63.33},{53.59,63.76},{52.65,61.7},{52.08,60.87},{49.1,63.15},{48.34,61.29},{47.29,58.25},{47.49,55.55},{48.27,53.94},{50.22,51.51},{51.27,50.4},{52.35,49.88},{53.23,48.43},{56.01,47.71},{57.2,47.36},{58.45,48.16},{59.01,49.77},{60.97,52.49},{61.37,52.3},{61.77,51.36},},},1519,nil,nil,12,"A",},
[2534] = {'Zanzil the Outcast',1919,1919,46,46,0,{[33]={{39.59,58.57},},},nil,33,nil,nil,16,nil,},
[2535] = {'Maury "Club Foot" Wilkins',2059,2138,43,44,0,{[33]={{35.25,51.26},},},nil,33,nil,nil,16,nil,},
[2536] = {'Jon-Jon the Crow',2059,2138,43,44,0,{[33]={{34.92,51.84},},},nil,33,nil,nil,16,nil,},
[2537] = {'Chucky "Ten Thumbs"',2059,2138,43,44,0,{[33]={{40.0,58.24},},},nil,33,nil,nil,16,nil,},
[2540] = {'Dalaran Serpent',644,644,15,15,0,nil,nil,0,nil,nil,76,"AH",},
[2541] = {'Lord Sakrasis',1848,1848,45,45,4,{[33]={{28.33,62.56},{28.85,62.04},},},nil,33,nil,nil,14,nil,},
[2542] = {'Catelyn the Blade',3517,3517,50,50,0,{[33]={{27.28,77.53},},},nil,33,{610,611,},{603,610,},120,"AH",},
[2543] = {'Archmage Ansirem Runeweaver',1227,1227,40,40,0,{[36]={{18.84,78.49},},},nil,36,{603,},{602,},76,"AH",},
[2544] = {'Southern Sand Crawler',1829,1902,40,41,0,{[33]={{27.75,85.63},{30.75,81.73},{29.91,85.66},{32.24,82.53},{35.27,87.91},{33.8,76.48},{27.54,85.87},{28.81,87.53},{33.94,85.92},{35.12,87.79},{30.85,85.29},{26.92,84.36},{31.67,87.04},{29.26,82.28},{29.94,87.72},{28.73,87.56},{31.32,81.92},{29.93,87.31},{30.09,85.78},{31.35,85.93},{26.73,86.96},{31.24,88.09},{25.78,85.89},{26.3,84.11},},},nil,33,nil,nil,7,"AH",},
[2545] = {'"Pretty Boy" Duncan',1672,1672,39,39,0,{[33]={{27.38,69.41},},},nil,33,{1036,},nil,119,nil,},
[2546] = {'Fleet Master Firallon',2600,2600,48,48,0,{[33]={{30.58,90.63},},},nil,33,{4621,9272,},{1036,4621,9272,},119,nil,},
[2547] = {'Ironpatch',2059,2059,42,43,0,{[33]={{30.57,90.44},},},nil,33,nil,nil,119,nil,},
[2548] = {'Captain Keelhaul',2064,2064,46,47,0,{[33]={{29.32,88.29},},},nil,33,nil,nil,119,nil,},
[2549] = {'Garr Salthoof',1981,1981,41,43,0,{[33]={{29.2,88.79},},},nil,33,nil,nil,119,nil,},
[2550] = {'Captain Stillwater',1651,1651,45,46,0,{[33]={{32.87,88.2},},},nil,33,nil,nil,119,nil,},
[2551] = {'Brutus',2746,2746,43,43,0,{[33]={{32.92,88.27},},},nil,33,nil,nil,119,nil,},
[2552] = {'Witherbark Troll',1050,1107,30,31,0,{[45]={{35.1,46.16},{37.5,40.95},{35.61,49.41},{32.04,46.29},{74.15,45.78},{74.08,45.73},{74.12,45.69},},},nil,45,nil,nil,654,nil,},
[2553] = {'Witherbark Shadowcaster',847,882,31,32,0,{[45]={{34.6,39.5},{31.03,42.37},{74.08,45.83},},},{[45]={{74.55,37.48},{74.9,42.9},{74.08,45.83},{74.08,45.83},{74.08,45.83},},[47]={{51.31,97.39},},},45,nil,nil,654,nil,},
[2554] = {'Witherbark Axe Thrower',1163,1221,32,33,0,{[45]={{66.02,62.87},{65.56,64.49},{74.05,65.4},{70.87,61.66},{72.04,59.15},{73.71,63.76},{70.71,58.83},{73.2,60.33},{73.19,65.85},{73.03,64.75},{71.61,60.58},{70.77,60.51},{68.2,60.7},{66.78,63.69},{66.32,64.74},{66.88,61.7},{65.25,67.59},{62.79,67.63},{63.47,67.06},{63.96,68.19},{59.82,74.08},{64.13,73.57},{64.51,72.84},{65.08,74.0},{65.09,73.03},{62.94,68.5},{61.61,72.84},{61.68,71.48},{61.62,72.1},{60.46,72.52},{61.19,71.68},{63.5,72.83},},},{[45]={{65.26,67.39},{64.97,67.04},{64.69,66.68},{64.99,67.05},{65.4,67.4},{65.59,68.07},{65.86,68.61},{66.11,68.99},{66.21,69.35},{65.98,68.83},{65.69,68.28},{65.52,67.63},},},45,nil,nil,654,nil,},
[2555] = {'Witherbark Witch Doctor',1021,1064,33,34,0,{[45]={{64.73,71.64},{67.34,80.48},{30.52,43.56},{69.28,81.49},{73.74,64.62},{31.53,45.8},{69.61,66.59},{69.86,77.92},{72.85,65.83},{73.25,65.34},{71.6,61.84},{66.38,63.8},{65.25,68.93},{66.27,71.79},{63.11,67.77},{69.93,61.62},{71.75,64.56},{69.14,79.72},{68.12,79.36},{65.02,73.39},{64.5,73.04},{67.15,73.52},{70.55,70.47},{71.05,69.17},{71.56,67.11},{69.34,68.69},{68.04,78.63},{67.94,76.88},{32.62,44.43},{61.05,72.14},{64.42,71.74},},},nil,45,nil,nil,654,nil,},
[2556] = {'Witherbark Headhunter',1279,1342,34,35,0,{[45]={{69.75,78.01},{70.45,78.2},{68.99,78.68},{70.04,77.34},{67.18,80.83},{67.75,81.95},{68.17,79.5},{69.19,82.41},{69.17,81.66},{68.29,80.06},{69.55,81.58},{69.88,81.13},{66.28,82.24},{67.55,81.59},{66.03,81.88},{68.74,73.43},{64.28,68.95},{71.88,63.02},{72.68,64.43},{69.13,79.46},{69.03,71.98},{70.02,71.75},{70.64,69.64},{70.91,67.35},{71.25,69.92},{71.2,65.91},{69.97,68.65},{68.55,76.41},{67.93,76.49},{67.74,77.06},{67.65,77.23},{67.98,78.74},{62.55,73.17},{59.93,71.64},{67.08,70.15},{63.51,71.64},{74.16,45.89},},},nil,45,nil,nil,654,nil,},
[2557] = {'Witherbark Shadow Hunter',1160,1208,35,36,0,{[45]={{69.41,80.66},{69.87,78.79},{69.7,79.4},{70.24,79.01},{67.53,80.51},{68.58,80.89},{69.01,81.54},{68.61,82.26},{66.29,80.48},{66.99,82.33},{67.62,81.03},{66.77,81.28},{67.28,81.76},{66.73,80.5},{67.38,78.7},{66.95,79.12},},},nil,45,nil,nil,654,nil,},
[2558] = {'Witherbark Berserker',3831,4008,36,37,1,{[45]={{22.93,65.09},{24.27,66.25},{24.04,65.18},},},nil,45,nil,nil,654,nil,},
[2559] = {'Highland Strider',1050,1107,30,31,0,{[45]={{27.21,20.73},{28.3,17.27},{30.26,21.12},{39.99,61.87},{49.3,49.35},{44.91,65.49},{69.07,52.0},{42.84,79.6},{26.89,36.99},{25.19,40.13},{40.27,43.67},{42.17,46.94},{39.83,46.37},{41.03,44.8},{42.47,43.84},{70.58,51.04},{48.16,33.66},{74.0,48.29},{20.49,38.23},{41.09,74.24},{24.48,40.65},{32.7,36.13},{68.7,49.14},{29.94,19.89},{46.57,64.32},{20.62,45.01},{19.03,41.0},{19.62,42.21},{18.06,40.18},{18.89,38.15},{17.13,42.08},{19.51,34.2},{19.97,38.0},{43.08,39.21},{41.3,41.4},{43.24,41.2},{41.84,41.92},{44.12,41.0},{46.69,39.45},{26.44,34.97},{21.43,36.43},{21.92,39.19},{43.17,77.78},{49.55,52.11},{26.66,24.03},{40.1,58.92},{67.24,34.06},{54.12,47.64},{54.26,46.7},{53.28,45.93},{53.79,45.62},{60.34,37.25},{53.1,43.97},{69.79,27.0},{65.89,35.11},{67.58,36.92},{67.1,56.28},{63.97,50.49},{38.37,48.66},{38.42,51.66},{39.64,50.62},{41.75,49.44},{41.26,49.77},{42.05,50.81},{69.77,31.63},{37.31,50.34},{64.35,36.77},{70.02,30.35},{30.83,20.36},{41.42,53.39},{33.61,35.06},{51.39,39.65},{52.29,32.43},{51.33,40.55},{52.06,44.89},{51.09,47.39},{44.83,54.97},{46.75,50.51},{46.77,53.0},{39.57,47.77},{40.5,49.25},{69.0,36.61},{68.01,36.86},{69.84,35.81},{66.9,39.1},{65.28,45.22},{65.64,38.0},{66.11,43.66},{49.53,40.7},{46.76,41.11},{47.75,56.2},{69.06,38.58},{65.93,40.52},{67.56,42.26},{65.23,39.72},{61.59,42.25},{65.42,42.44},{23.68,39.65},{64.39,40.92},{63.42,42.22},{60.67,41.01},{76.3,31.12},{60.81,42.25},{58.73,41.12},{60.6,43.59},{58.73,43.67},{59.62,45.15},{62.51,46.49},{61.58,45.24},{63.28,45.12},{64.26,46.39},{56.88,46.63},{55.13,49.13},{56.03,48.03},{24.94,36.81},{23.66,35.37},{68.53,41.17},{17.18,42.71},},},nil,45,nil,nil,48,nil,},
[2560] = {'Highland Thrasher',1221,1279,33,34,0,{[45]={{21.11,54.86},{18.95,55.17},{34.1,61.82},{20.08,55.99},{31.29,65.2},{20.83,47.69},{41.02,64.79},{39.17,64.98},{20.1,48.21},{19.06,48.73},{22.03,47.68},{21.64,49.41},{21.86,53.57},{39.72,68.86},{18.53,46.34},{37.41,64.86},{36.91,66.65},{38.41,67.21},{36.17,65.11},{36.51,64.03},{39.49,65.88},{55.97,68.78},{40.09,67.05},{34.88,64.27},{40.99,69.92},{38.67,69.07},{36.96,38.15},{39.51,69.87},{36.52,36.72},{18.04,47.22},{23.15,49.7},{39.86,29.86},{43.94,34.03},{37.76,33.32},{36.32,33.07},{35.44,65.83},{32.51,56.89},{31.37,55.86},{62.44,65.27},{32.59,56.59},{20.05,45.01},{38.02,33.48},{38.07,38.68},{39.39,38.36},{36.73,35.22},{40.2,41.13},{41.74,39.62},{43.02,36.41},{30.5,56.37},{32.14,58.96},{32.37,63.99},{32.07,60.26},{37.37,67.89},{37.88,36.94},{41.19,35.32},{40.18,36.79},{43.85,38.43},{40.17,35.33},{37.07,29.87},{41.04,29.98},{54.5,59.61},{46.53,35.06},{39.87,34.2},{54.07,57.65},{58.82,67.31},{31.09,57.65},{30.07,56.1},},},nil,45,nil,nil,48,nil,},
[2561] = {'Highland Fleshstalker',1469,1536,36,37,0,{[45]={{47.49,80.66},{48.01,82.44},{45.66,76.65},{46.84,78.73},{45.59,79.5},{46.5,76.0},{47.6,75.21},{50.54,64.59},{49.61,69.12},{50.38,67.5},{53.09,68.78},{51.08,68.75},{55.11,67.46},{53.74,67.8},{52.28,68.14},{52.3,64.58},{54.03,64.64},{50.05,70.42},{50.16,63.87},},},nil,45,nil,nil,48,nil,},
[2562] = {'Boulderfist Ogre',1163,1221,32,33,0,{[45]={{32.87,50.28},{36.22,46.7},{36.21,47.62},{35.66,43.85},{35.7,45.27},{34.55,47.65},{32.88,47.83},{30.99,45.29},{34.01,49.49},{31.85,41.02},{31.16,48.05},{33.15,40.79},{35.61,41.29},{32.91,39.52},{37.18,43.6},{36.79,42.56},{37.64,46.19},{34.69,42.97},},},{[45]={{34.84,42.65},{35.0,42.41},{35.17,42.26},{34.94,42.56},{34.77,42.84},{34.73,43.2},{34.69,42.97},},[267]={{99.61,72.98},{99.79,72.71},{99.99,72.54},{99.72,72.89},{99.53,73.2},{99.49,73.6},{99.45,73.34},},},45,nil,nil,45,nil,},
[2563] = {'Plains Creeper',1163,1221,32,33,0,{[45]={{19.92,54.65},{34.95,66.18},{33.97,64.88},{19.87,50.53},{22.4,54.58},{39.74,70.93},{38.6,62.86},{32.72,60.91},{23.81,48.25},{62.83,30.08},{19.41,43.59},{18.05,52.29},{28.26,20.86},{20.81,53.06},{61.42,50.58},{45.14,64.83},{41.09,62.55},{42.59,61.51},{17.24,45.34},{18.07,50.71},{65.61,50.69},{48.27,37.99},{44.18,70.52},{45.31,67.44},{40.78,67.76},{66.98,52.57},{73.72,46.89},{42.0,75.58},{37.69,31.09},{44.67,39.24},{42.12,37.18},{41.21,38.17},{69.88,37.11},{61.63,50.59},{54.3,32.51},{63.38,38.26},{69.94,50.23},{20.74,36.27},{17.32,49.75},{41.73,61.72},{22.73,51.98},{45.84,40.88},{23.6,38.21},{69.91,49.3},{43.53,62.66},{71.09,54.25},{71.79,50.51},{69.74,55.14},{69.84,56.17},{68.04,53.15},{66.59,49.26},{69.0,50.63},{70.0,48.32},{68.99,47.92},{52.27,35.49},{64.25,43.69},{32.83,54.42},{43.09,57.42},{18.06,44.68},{22.6,45.19},{50.55,37.98},{19.95,40.99},{68.08,55.97},{18.19,35.47},{47.58,36.42},{39.12,35.41},{39.38,45.4},{26.36,37.96},{68.9,35.39},{20.85,42.17},{42.01,72.73},{70.52,46.72},{73.04,47.18},{68.37,46.49},{48.69,50.83},{26.55,25.74},{29.08,34.64},{41.24,58.83},{41.04,60.24},{42.97,58.96},{55.96,45.35},{71.83,48.46},{68.95,56.28},{58.68,50.69},{59.84,49.69},{61.58,49.24},{49.48,36.7},{47.93,35.03},{40.05,51.93},{41.44,48.66},{60.81,39.69},{49.94,35.58},{51.23,36.58},{17.18,42.3},{16.91,43.71},{56.43,33.23},{57.9,33.85},{55.32,33.67},{53.29,33.3},{50.56,41.84},{47.92,57.57},{47.88,61.16},{50.19,61.5},{36.1,33.87},{69.14,33.8},{62.24,42.63},{60.61,46.57},{57.83,45.16},{48.08,60.64},{45.65,64.47},{43.11,64.53},{71.08,46.97},{19.38,35.88},},},nil,45,nil,nil,22,nil,},
[2564] = {'Boulderfist Enforcer',1221,1279,33,34,0,{[45]={{33.01,46.61},{31.08,43.06},{31.05,43.67},{32.38,46.04},{33.58,44.59},{32.54,43.88},{33.3,43.88},{33.92,44.56},{34.52,44.2},{32.82,43.14},{32.39,44.74},{31.64,44.2},{32.8,45.44},{33.62,45.98},{33.09,46.08},{31.9,46.05},},},{[45]={{34.63,44.11},{34.81,44.14},{34.92,44.2},{35.07,44.37},{34.89,44.17},{34.65,44.01},{34.48,44.08},{34.21,44.28},{33.96,44.54},{33.82,44.95},{33.73,45.56},{33.6,46.05},{33.38,46.14},{32.9,45.62},{32.57,45.03},{32.63,44.51},{32.95,44.36},{33.07,44.33},{33.3,44.06},{33.55,44.07},{33.68,44.39},{33.58,44.59},{33.57,44.93},{33.77,45.01},{33.97,44.6},{34.22,44.34},{34.47,44.12},},[267]={{99.38,74.62},{99.57,74.66},{99.71,74.72},{99.87,74.92},{99.67,74.69},{99.4,74.52},{99.21,74.6},{98.91,74.82},{98.63,75.1},{98.46,75.57},{98.36,76.25},{98.22,76.81},{97.97,76.9},{97.43,76.33},{97.05,75.65},{97.13,75.07},{97.48,74.9},{97.62,74.88},{97.88,74.57},{98.16,74.58},{98.31,74.93},{98.2,75.16},{98.18,75.54},{98.41,75.64},{98.64,75.18},{98.91,74.88},{99.19,74.63},},},45,nil,nil,45,nil,},
[2565] = {'Giant Plains Creeper',1403,1469,35,36,0,{[45]={{42.94,32.55},{42.68,29.49},{37.31,24.57},{38.37,25.36},{39.27,27.77},{42.48,32.35},{57.55,65.83},{45.71,34.81},{40.33,31.69},{56.87,67.51},{47.79,77.23},{41.0,31.9},{60.39,64.35},{59.91,68.46},{57.04,69.0},{40.23,29.13},{61.74,69.01},{44.09,31.06},{44.56,31.64},{37.91,26.91},{41.97,34.13},{44.91,36.82},{38.44,29.26},{54.5,56.31},{56.47,57.85},{56.75,60.52},{46.56,36.74},{57.36,65.02},{51.2,66.57},{46.05,74.48},{55.84,54.59},{52.59,61.03},{53.19,58.88},{56.01,59.08},{53.41,56.45},{54.38,54.9},{53.52,65.96},{56.93,61.97},{58.79,64.58},{59.77,65.84},{60.68,67.19},{61.45,65.87},{60.48,64.53},},},nil,45,nil,nil,22,nil,},
[2566] = {'Boulderfist Brute',1403,1469,35,36,0,{[45]={{54.71,80.42},{54.31,81.0},{54.68,78.33},{51.99,76.85},{53.83,74.58},{52.86,74.0},{54.21,75.63},{53.58,76.15},{53.08,74.48},{53.1,75.93},{54.52,78.63},{55.15,72.74},{54.54,73.8},{53.45,72.89},{52.26,71.48},{51.91,73.98},{51.55,72.67},{50.61,79.81},{49.53,78.56},{50.83,76.56},{49.61,75.51},},},{[45]={{54.6,78.32},{54.37,78.76},{54.13,79.13},{53.9,79.44},{54.08,79.2},{54.32,78.83},{54.54,78.49},{54.62,78.29},{54.64,77.87},{54.49,77.77},{54.32,77.69},{54.06,77.68},{54.34,77.72},{54.49,77.86},{54.64,78.14},},},45,nil,nil,45,nil,},
[2567] = {'Boulderfist Magus',1075,1116,36,37,0,{[45]={{54.61,81.32},{54.24,77.74},{53.32,74.39},{52.96,77.02},{53.66,80.0},{54.05,71.76},{52.4,75.6},{51.39,77.82},{50.43,74.26},},},{[45]={{52.49,75.39},{52.34,75.03},{52.11,74.51},{51.91,74.11},{51.73,73.7},{51.49,73.27},{51.67,73.59},{51.89,74.07},{52.12,74.42},{52.35,74.86},{52.49,75.4},{52.69,75.93},{52.91,76.22},{53.2,76.51},{53.46,76.82},{53.15,76.52},{52.83,76.12},{52.52,75.59},},},45,nil,nil,45,nil,},
[2569] = {'Boulderfist Mauler',4008,4185,37,38,1,{[45]={{17.51,68.38},{21.9,65.39},{22.2,67.68},{20.77,69.07},{20.02,66.75},{23.0,66.84},{21.59,66.7},{23.74,65.78},{24.38,62.24},},},{[45]={{17.55,68.34},{17.65,68.12},{17.86,67.91},{18.08,67.9},{18.29,68.2},{18.31,68.66},{18.15,68.95},{17.81,69.05},{17.57,68.97},{17.46,68.5},{24.38,62.23},{24.38,62.76},{24.37,63.34},{24.36,64.06},{24.38,63.69},{24.37,62.96},{24.37,62.38},{24.38,61.6},{24.38,61.16},{24.38,61.16},},[267]={{87.84,95.01},{87.84,95.6},{87.83,96.26},{87.82,97.07},{87.84,96.66},{87.83,95.84},{87.84,95.18},{87.85,94.3},{87.85,93.81},{87.85,93.81},},},45,nil,nil,45,nil,},
[2570] = {'Boulderfist Shaman',3405,3540,38,39,1,{[45]={{18.68,66.54},{17.82,69.12},{17.65,68.78},{20.87,65.68},{20.49,66.67},{19.49,64.62},{20.92,67.44},{21.57,66.96},{19.97,67.51},{20.23,69.14},{19.88,68.5},{21.55,68.36},},},{[45]={{17.81,69.15},{18.02,69.14},{18.2,68.91},{18.3,68.65},{18.29,68.31},{18.16,68.07},{17.94,68.0},{17.63,68.13},{17.52,68.51},{17.58,68.8},{17.77,69.1},{21.54,66.88},{21.72,66.72},{21.67,66.4},{21.59,66.0},{21.55,65.68},{21.47,65.26},{21.65,65.32},{21.56,65.73},{21.65,66.24},{21.73,66.74},},[267]={{84.8,99.7},{84.71,99.25},{84.65,98.89},{84.57,98.41},{84.77,98.48},{84.68,98.95},{84.77,99.52},},},45,nil,nil,45,nil,},
[2571] = {'Boulderfist Lord',4377,4572,39,40,1,{[45]={{18.63,69.24},{18.21,68.24},{18.02,69.04},{19.93,65.72},{18.94,65.93},{20.63,68.28},{18.23,67.39},{19.51,69.06},{19.22,67.66},},},{[45]={{18.03,69.04},{18.12,68.96},{18.16,68.81},{18.25,68.74},{18.27,68.62},{18.25,68.4},{18.19,68.27},{18.11,68.09},{17.97,68.03},{17.87,68.03},{17.77,68.09},{17.87,68.03},{17.99,68.05},{18.08,68.12},{18.18,68.25},{18.24,68.4},{18.26,68.59},{18.23,68.77},{18.13,68.83},{18.12,68.95},{18.02,69.0},{17.9,69.01},{17.82,68.99},{17.75,68.93},{17.69,68.89},{17.74,68.95},{17.84,69.0},{17.97,69.03},},},45,nil,nil,45,nil,},
[2572] = {'Drywhisker Kobold',1403,1469,35,36,0,{[45]={{81.91,37.18},{81.82,35.85},{76.02,44.39},{76.91,44.34},{79.08,41.51},{77.22,43.53},{77.49,34.88},{78.45,41.15},{78.48,34.46},{79.16,34.92},{82.49,38.85},{80.04,39.97},{82.6,37.95},{78.02,39.89},{76.23,42.48},{78.28,36.86},{78.55,37.77},{78.87,34.38},{77.52,35.64},{79.47,33.08},{79.21,35.62},},},nil,45,nil,nil,26,nil,},
[2573] = {'Drywhisker Surveyor',1116,1155,37,38,0,{[45]={{84.39,30.8},{84.35,30.75},{83.07,33.03},{83.71,33.68},{85.57,32.55},{86.37,31.5},{86.54,30.23},{84.35,29.85},},},{[45]={{84.31,30.51},{84.38,30.05},{84.46,29.5},{84.36,28.87},{84.31,28.82},{84.16,28.62},{83.96,28.75},{84.2,28.64},{84.45,28.84},{84.38,29.39},{84.31,30.03},},[47]={{60.44,90.86},{60.5,90.44},{60.58,89.93},{60.48,89.34},{60.44,89.28},{60.3,89.1},{60.11,89.22},{60.34,89.12},{60.57,89.31},{60.5,89.82},{60.43,90.42},},},45,nil,nil,26,nil,},
[2574] = {'Drywhisker Digger',1469,1536,36,37,0,{[45]={{83.42,32.06},{82.1,36.12},{82.78,35.97},{83.9,34.14},{85.64,33.13},{85.04,34.33},{85.69,31.24},{85.21,31.22},{86.04,30.24},{85.47,30.05},{87.03,31.63},{84.24,28.91},{83.4,35.42},{84.58,31.43},},},nil,45,nil,nil,26,nil,},
[2575] = {'Dark Iron Supplier',935,977,31,32,0,{[45]={{48.41,87.46},},},nil,45,nil,nil,54,nil,},
[2577] = {'Dark Iron Shadowcaster',847,882,31,32,0,{[45]={{48.02,87.25},{48.82,87.69},{48.2,88.07},},},{[11]={{53.53,3.61},{53.46,3.61},{53.29,3.62},{52.89,3.65},{52.56,3.66},{52.24,3.67},{51.96,3.66},{51.68,3.65},{51.97,3.67},{52.25,3.67},{52.62,3.66},{52.9,3.66},{53.19,3.65},{53.43,3.64},},[45]={{48.24,88.09},{48.15,88.09},{47.97,88.1},{47.5,88.13},{47.13,88.14},{46.76,88.15},{46.43,88.15},{46.12,88.13},{46.44,88.15},{46.77,88.16},{47.19,88.15},{47.52,88.14},{47.85,88.13},{48.13,88.12},},},45,nil,nil,54,nil,},
[2578] = {'Young Mesa Buzzard',1189,1263,31,32,0,{[45]={{28.06,34.37},{29.15,19.8},{43.4,61.24},{17.91,43.6},{20.17,47.05},{66.51,40.79},{68.8,49.58},{73.94,46.6},{68.37,53.22},{69.27,52.43},{60.03,41.55},{25.31,35.12},{27.11,38.01},{19.84,37.45},{26.73,24.84},{69.32,37.2},{42.37,56.62},{50.25,41.97},},},nil,45,nil,nil,73,nil,},
[2579] = {'Mesa Buzzard',1279,1342,34,35,0,{[45]={{19.81,52.09},{33.94,66.08},{34.09,61.86},{37.71,26.69},{39.21,30.53},{36.51,66.29},{61.37,69.82},{40.36,66.94},{54.29,65.36},{50.31,70.91},{45.18,35.43},{43.28,38.75},{56.71,68.69},{55.96,55.73},},},nil,45,nil,nil,73,nil,},
[2580] = {'Elder Mesa Buzzard',1536,1604,37,38,0,{[45]={{23.8,71.17},{24.32,68.88},{21.54,72.62},{46.93,81.68},{27.39,67.91},{15.98,64.53},{15.26,69.74},{16.42,66.82},},},nil,45,nil,nil,73,nil,},
[2581] = {'Dabyrie Militia',1145,1199,31,32,0,{[45]={{53.41,38.05},{55.78,42.13},{55.54,38.56},{54.65,41.12},{57.23,40.32},{53.54,37.63},{57.02,36.36},{55.43,37.66},{57.13,36.14},},},{[45]={{53.8,37.53},{54.11,37.1},{54.36,36.95},{54.11,37.1},{53.8,37.53},{53.41,38.05},{53.17,38.53},{53.23,38.89},{53.27,39.23},{53.23,38.89},{53.17,38.53},{53.41,38.05},{55.5,38.47},{55.83,38.99},{56.12,39.43},{56.43,39.99},{56.77,40.7},{56.47,40.11},{56.13,39.44},{55.72,38.86},{55.39,38.38},{54.72,41.18},{55.03,41.61},{55.32,42.04},{55.06,41.63},{54.72,41.16},{54.32,40.63},{53.92,39.98},{54.24,40.64},{57.59,40.07},{57.53,39.03},{57.22,38.93},{56.97,39.07},{56.74,38.94},{56.52,38.65},{56.74,38.94},{56.97,39.07},{57.22,38.93},{57.53,39.03},{57.59,40.07},{57.23,40.32},{53.2,38.11},{53.54,37.63},{53.85,37.3},{54.22,36.99},{54.48,36.68},{54.73,36.24},{54.48,36.68},{54.22,36.99},{53.85,37.3},{53.54,37.63},{57.01,36.71},{57.21,37.25},{57.15,37.64},{57.21,37.25},{57.01,36.71},{57.02,36.36},{57.04,35.81},{56.65,35.2},{56.26,35.0},{55.96,35.31},{56.26,35.0},{56.65,35.2},{57.04,35.81},{57.02,36.36},{55.54,37.27},{55.74,36.89},{55.99,36.76},{55.74,36.89},{55.54,37.27},{55.43,37.66},{55.28,38.2},{55.43,37.66},{56.65,35.04},{56.3,34.93},{55.91,35.04},{56.3,34.93},{56.65,35.04},{57.13,36.14},{57.19,36.85},{57.23,37.54},{57.17,37.8},{57.23,37.54},{57.19,36.85},{57.13,36.14},},[47]={{31.91,97.43},{32.2,97.03},{32.43,96.89},{32.2,97.03},{31.91,97.43},{31.54,97.92},{31.32,98.37},{31.37,98.7},{31.41,99.02},{31.37,98.7},{31.32,98.37},{31.54,97.92},{33.5,98.31},{33.81,98.79},{34.08,99.21},{34.37,99.74},{34.41,99.84},{34.09,99.22},{33.71,98.68},{33.39,98.23},{32.02,99.73},{35.45,99.81},{35.39,98.84},{35.11,98.74},{34.87,98.87},{34.66,98.75},{34.45,98.48},{34.66,98.75},{34.87,98.87},{35.11,98.74},{35.39,98.84},{35.45,99.81},{31.34,97.98},{31.66,97.53},{31.96,97.22},{32.3,96.93},{32.54,96.63},{32.77,96.22},{32.54,96.63},{32.3,96.93},{31.96,97.22},{31.66,97.53},{34.91,96.67},{35.1,97.17},{35.04,97.53},{35.1,97.17},{34.91,96.67},{34.92,96.33},{34.94,95.82},{34.57,95.25},{34.21,95.07},{33.93,95.36},{34.21,95.07},{34.57,95.25},{34.94,95.82},{34.92,96.33},{33.54,97.19},{33.72,96.83},{33.96,96.71},{33.72,96.83},{33.54,97.19},{33.43,97.55},{33.29,98.06},{33.43,97.55},{34.57,95.1},{34.25,95.0},{33.88,95.1},{34.25,95.0},{34.57,95.1},{35.02,96.14},{35.08,96.79},{35.11,97.44},{35.06,97.69},{35.11,97.44},{35.08,96.79},{35.02,96.14},},},45,nil,nil,123,"A",},
[2582] = {'Dabyrie Laborer',1116,1128,30,31,0,{[45]={{55.2,38.93},{57.11,39.58},{57.28,39.65},{57.03,39.93},{54.48,38.47},{55.05,39.21},{55.73,39.98},{55.79,40.58},{55.3,41.08},{55.04,40.66},{55.05,39.91},{55.39,40.53},{55.44,39.86},{55.38,39.43},{56.18,35.66},{56.45,36.54},{53.95,39.03},{54.62,39.84},{54.72,39.34},{54.01,38.36},{56.51,40.04},{56.39,39.35},{56.17,36.4},{56.85,39.59},{54.41,37.82},{54.95,37.62},},},nil,45,nil,nil,123,"A",},
[2583] = {'Stromgarde Troll Hunter',3359,3453,37,38,1,{[45]={{22.11,59.61},{23.89,60.57},{22.06,62.99},{23.33,63.15},{21.79,61.48},{21.15,63.28},{23.56,59.57},{23.78,57.11},{24.82,57.89},{24.39,58.82},{25.18,58.7},{22.97,60.34},},},nil,45,nil,nil,123,"A",},
[2584] = {'Stromgarde Defender',4264,4450,38,39,1,{[45]={{23.39,57.75},{23.39,62.49},{27.92,58.99},{23.72,60.3},{23.71,60.73},{21.31,62.34},{25.21,58.1},{25.4,57.95},{25.38,58.36},{26.79,58.32},{26.79,57.95},{22.31,59.24},},},{[45]={{23.75,58.27},{23.41,58.84},{23.28,59.12},{23.12,59.67},{22.96,59.98},{22.77,59.84},{22.53,59.41},{22.31,59.25},{22.53,59.41},{22.77,59.84},{22.96,59.98},{23.12,59.67},{23.28,59.12},{23.41,58.84},{23.75,58.27},{23.39,57.75},{23.31,57.55},{23.39,57.75},{23.1,62.38},{22.93,62.18},{22.76,61.95},{22.64,61.73},{22.67,61.41},{22.69,61.12},{22.75,60.76},{22.83,60.56},{23.29,60.47},{23.51,60.46},{23.29,60.47},{22.83,60.56},{22.75,60.76},{22.69,61.12},{22.67,61.41},{22.64,61.73},{22.76,61.95},{22.93,62.18},{23.1,62.38},{23.39,62.49},{27.97,59.01},{28.25,59.01},{28.52,59.01},{28.65,59.02},{28.4,59.01},{28.16,59.01},{27.72,58.99},{25.28,58.12},{24.93,58.1},{25.2,58.11},{25.45,58.13},{25.68,58.14},{25.79,58.14},{26.09,58.15},{26.36,58.13},{26.58,58.13},{26.72,58.13},{27.4,58.14},{27.4,58.14},{26.7,58.13},{26.55,58.13},{26.38,58.13},{26.13,58.13},{25.79,58.13},{25.6,58.13},{25.43,58.13},},[267]={{87.14,90.55},{86.76,91.19},{86.61,91.51},{86.43,92.13},{86.24,92.48},{86.03,92.32},{85.76,91.84},{85.51,91.66},{85.76,91.84},{86.03,92.32},{86.24,92.48},{86.43,92.13},{86.61,91.51},{86.76,91.19},{87.14,90.55},{86.73,89.97},{86.65,89.74},{86.73,89.97},{86.4,95.17},{86.21,94.95},{86.02,94.7},{85.89,94.44},{85.92,94.09},{85.94,93.77},{86.01,93.36},{86.1,93.13},{86.62,93.03},{86.87,93.01},{86.62,93.03},{86.1,93.13},{86.01,93.36},{85.94,93.77},{85.92,94.09},{85.89,94.44},{86.02,94.7},{86.21,94.95},{86.4,95.17},{86.73,95.31},{91.88,91.38},{92.19,91.39},{92.51,91.39},{92.65,91.39},{92.37,91.39},{92.1,91.38},{91.6,91.36},{88.86,90.39},{88.46,90.37},{88.76,90.37},{89.05,90.39},{89.31,90.41},{89.43,90.41},{89.77,90.41},{90.07,90.4},{90.32,90.4},{90.47,90.4},{91.24,90.41},{91.24,90.41},{90.45,90.4},{90.28,90.4},{90.09,90.39},{89.81,90.39},{89.43,90.4},{89.22,90.4},{89.02,90.39},},},45,nil,nil,123,"A",},
[2585] = {'Stromgarde Vindicator',4438,4658,39,40,1,{[45]={{22.06,58.78},{28.9,58.89},{28.04,57.99},{27.51,57.66},{27.33,58.86},{28.22,58.3},{21.17,60.53},{22.86,58.12},{24.87,57.15},{27.68,58.75},},},nil,45,nil,nil,123,"A",},
[2586] = {'Syndicate Highwayman',1050,1107,30,31,0,{[45]={{32.21,31.87},{29.32,26.85},{31.59,31.21},{32.11,24.79},{30.37,28.87},{30.63,25.68},{29.05,28.38},{30.3,24.33},{30.3,27.97},{34.19,26.98},{31.22,25.48},{30.97,29.79},{33.51,31.47},{33.79,30.77},{31.78,32.98},{34.67,28.35},{34.0,29.55},{34.69,29.88},{32.94,32.38},{33.92,32.94},{34.66,31.69},{34.7,27.0},{33.91,26.51},},},nil,45,nil,nil,87,nil,},
[2587] = {'Syndicate Pathstalker',1163,1221,32,33,0,{[45]={{31.3,26.15},{31.08,26.28},{30.72,28.34},{32.27,28.3},{32.62,31.23},{32.11,31.2},{33.46,30.84},{31.47,28.26},{33.4,27.62},{32.06,26.82},},},{[45]={{32.18,28.35},{31.73,28.35},{31.73,29.04},{31.74,30.09},{32.28,30.14},{32.98,30.12},{33.15,29.82},{33.15,29.28},{33.13,28.51},{33.13,27.96},{33.13,27.26},{32.82,27.22},{32.51,27.15},{32.2,27.11},{31.81,27.11},{31.8,27.57},{31.79,28.39},},[47]={{11.69,88.85},{11.27,88.84},{11.27,89.49},{11.28,90.47},{11.78,90.52},{12.44,90.5},{12.6,90.23},{12.6,89.72},{12.58,88.99},{12.58,88.48},{12.58,87.83},{12.29,87.79},{12.0,87.72},{11.71,87.69},{11.35,87.69},{11.33,88.12},{11.32,88.88},},[267]={{96.62,56.89},{96.11,56.89},{96.11,57.67},{96.12,58.85},{96.73,58.91},{97.52,58.89},{97.71,58.55},{97.71,57.94},{97.69,57.07},{97.69,56.46},{97.68,55.67},{97.33,55.62},{96.99,55.54},{96.64,55.5},{96.21,55.5},{96.19,56.02},{96.18,56.93},},},45,nil,nil,87,nil,},
[2588] = {'Syndicate Prowler',3831,4008,36,37,1,{[45]={{25.39,63.4},{29.43,65.04},{28.33,63.36},{27.53,62.0},{28.15,66.16},{25.78,62.51},{29.17,62.27},{28.59,65.75},{25.39,64.52},{25.82,64.22},{26.75,65.62},{26.49,63.55},{29.54,64.39},{29.23,61.34},{29.22,62.75},},},nil,45,nil,nil,87,nil,},
[2589] = {'Syndicate Mercenary',1107,1163,31,32,0,{[45]={{30.9,26.16},{33.75,27.34},{32.11,25.35},{31.02,28.75},{32.11,30.91},{32.28,31.22},{31.86,25.64},{33.02,31.04},{33.66,29.8},{30.96,27.91},{33.6,29.25},{31.54,30.03},{32.47,26.75},{32.35,25.93},},},nil,45,nil,nil,87,nil,},
[2590] = {'Syndicate Conjuror',2706,2805,35,36,1,{[45]={{25.21,62.55},{27.44,65.56},{26.8,62.16},{29.44,65.15},{28.99,65.05},{28.54,62.65},{28.95,65.92},{25.38,65.86},{25.85,65.14},{26.02,63.76},{27.59,60.31},{26.78,60.86},},},nil,45,nil,nil,87,nil,},
[2591] = {'Syndicate Magus',2910,3012,37,38,1,{[45]={{29.25,63.02},{26.5,64.48},{26.45,65.2},{26.11,65.26},{25.97,65.43},{28.2,60.57},{29.24,62.29},},},{[45]={{26.55,64.61},{26.55,64.95},{26.55,65.2},{26.56,65.69},{26.55,65.44},{26.55,65.0},{26.55,64.6},{26.51,64.39},{26.37,64.39},{26.51,64.42},{26.39,65.19},{26.19,65.19},{25.88,65.19},{25.86,65.38},{25.86,65.66},{25.87,65.85},{25.94,65.84},{26.08,65.82},{26.12,65.81},{26.22,65.54},{26.15,65.73},{26.07,65.82},{25.93,65.83},{25.87,65.82},{25.85,65.65},{25.85,65.38},{25.87,65.2},{25.87,65.2},},[267]={{90.29,97.68},{90.29,98.07},{90.29,98.35},{90.29,98.91},{90.28,98.63},{90.28,98.13},{90.29,97.67},{90.24,97.44},{90.09,97.44},{90.24,97.47},{90.11,98.34},{89.88,98.34},{89.53,98.34},{89.51,98.55},{89.51,98.87},{89.52,99.08},{89.59,99.06},{89.76,99.04},{89.8,99.04},{89.92,98.73},{89.84,98.95},{89.74,99.05},{89.59,99.06},{89.52,99.05},{89.5,98.86},{89.5,98.56},{89.52,98.35},{89.52,98.35},},},45,nil,nil,87,nil,},
[2592] = {'Rumbling Exile',1604,1678,38,39,0,{[45]={{36.6,60.79},{37.65,60.51},{35.59,60.54},{34.79,60.47},{34.91,55.92},{34.61,59.12},{37.49,59.25},{35.69,58.83},{36.55,58.94},{35.79,55.61},{37.7,56.43},{36.45,56.13},{34.9,57.39},{35.67,57.51},{37.44,57.63},{36.56,57.64},},},nil,45,nil,nil,91,nil,},
[2594] = {'Sprogger',2192,2192,37,37,0,{[33]={{26.66,73.64},},},nil,33,{8554,},{8553,},120,"AH",},
[2595] = {'Daggerspine Raider',1604,1678,38,39,0,{[45]={{23.37,86.44},{19.13,86.8},{17.01,88.38},{21.86,86.45},{18.18,90.21},{25.52,91.39},{21.11,86.9},{20.2,87.05},{25.13,89.43},{22.39,90.09},{21.13,89.87},{22.57,86.91},{24.65,85.28},{20.7,86.74},{25.5,87.43},{25.42,85.23},{21.2,84.3},{22.61,86.76},{22.99,90.34},{23.49,84.95},{23.02,84.34},{23.26,84.78},{23.43,84.88},{23.31,86.52},{21.81,85.55},{23.24,88.1},{21.85,86.84},{21.19,84.31},{20.62,85.36},{20.07,86.93},{20.97,89.77},{21.05,90.04},{22.4,89.93},{24.14,88.51},{24.49,86.66},{18.98,86.8},{18.89,85.03},{19.07,83.86},{20.04,84.0},{21.93,83.92},{25.05,89.66},{25.51,91.22},},},nil,45,nil,nil,74,nil,},
[2596] = {'Daggerspine Sorceress',1196,1239,39,40,0,{[45]={{18.16,87.01},{21.87,89.93},{22.45,84.35},{23.75,84.84},{22.74,84.63},{20.55,84.8},{20.65,85.0},{21.27,84.08},{21.83,89.82},{23.78,89.85},},},nil,45,nil,nil,74,nil,},
[2597] = {'Lord Falconcrest',11034,11034,40,40,1,{[45]={{26.03,65.68},},},nil,45,nil,nil,87,nil,},
[2598] = {'Darbel Montrose',5900,5900,39,39,2,{[45]={{26.51,60.74},{28.01,60.51},{29.78,60.67},{29.27,63.03},{26.06,62.29},{25.23,62.19},{27.08,62.22},{28.03,62.38},{28.28,63.16},{29.71,64.61},{28.66,65.85},{27.71,65.7},{27.39,64.91},{25.27,63.16},},},nil,45,nil,nil,16,nil,},
[2599] = {'Otto',4185,4185,38,38,1,{[45]={{26.22,65.55},},},nil,45,nil,nil,87,nil,},
[2600] = {'Singer',1064,1064,34,34,4,{[45]={{32.31,30.99},},},nil,45,nil,nil,16,nil,},
[2601] = {'Foulbelly',6605,6605,42,42,2,{[45]={{20.41,66.87},{20.79,65.98},{19.44,68.63},{17.9,68.6},},},nil,45,nil,nil,45,nil,},
[2602] = {'Ruul Onestone',3540,3540,39,39,1,{[45]={{18.07,68.78},{17.96,68.56},},},nil,45,nil,nil,45,nil,},
[2603] = {'Kovork',1468,1468,36,36,4,{[45]={{30.37,43.77},{33.0,44.04},{31.76,46.21},},},nil,45,nil,nil,45,nil,},
[2604] = {'Molok the Crusher',1678,1678,39,39,4,{[45]={{54.62,79.71},{53.23,80.18},{54.88,81.51},},},nil,45,nil,nil,45,nil,},
[2605] = {'Zalas Witherbark',1410,1410,40,40,4,{[45]={{64.83,73.45},{61.09,72.35},{67.89,78.47},{70.23,77.85},{69.27,79.62},{66.37,81.78},{67.43,80.66},{66.77,81.73},{69.09,81.4},{68.33,79.4},},},nil,45,nil,nil,654,nil,},
[2606] = {'Nimar the Slayer',1536,1536,37,37,4,{[45]={{64.64,73.25},{64.36,74.68},{61.33,72.54},{60.2,72.26},{63.86,68.58},{63.23,67.67},{66.41,63.95},{65.64,63.48},{69.59,61.33},{73.5,64.91},{72.45,65.8},{69.65,66.18},{70.67,69.27},{70.28,70.24},{68.86,73.72},},},nil,45,nil,nil,654,nil,},
[2607] = {'Prince Galen Trollbane',4278,4278,44,44,1,{[45]={{28.36,58.11},},},nil,45,nil,nil,123,"A",},
[2608] = {'Commander Amaren',2972,2972,45,45,0,{[45]={{45.97,46.75},},},{[45]={{45.8,46.67},{45.39,47.04},{45.39,47.04},{44.96,47.54},{44.66,48.05},{44.34,48.64},{44.06,49.69},},},45,nil,nil,123,"A",},
[2609] = {'Geomancer Flintdagger',1239,1239,40,40,4,{[45]={{82.8,32.23},},},nil,45,nil,nil,26,nil,},
[2610] = {'Shakes O\'Breen',1753,1753,40,40,0,{[45]={{32.28,81.38},},},nil,45,{667,669,},{663,667,668,670,},390,"AH",},
[2611] = {'Fozruk',5102,5102,42,42,1,{[45]={{67.73,37.65},},},{[45]={{67.8,37.66},{67.28,38.15},{66.29,39.16},{65.44,40.06},{65.06,41.04},{64.69,41.25},{63.55,43.23},{63.66,41.81},{63.07,42.32},{62.21,42.87},{61.51,43.39},{60.49,44.35},{59.67,45.28},{58.86,46.0},{58.3,47.66},{57.13,47.69},{55.8,47.39},{54.74,47.76},{53.7,48.61},{52.76,49.96},{52.48,51.49},{52.42,52.68},{52.29,53.93},{51.82,55.0},{51.6,56.3},{51.45,57.5},{50.89,58.5},{50.16,59.57},{48.9,60.41},{48.28,61.82},{46.87,61.76},{45.97,61.44},{45.12,60.56},{44.2,59.76},{42.84,59.19},{41.91,58.86},{40.81,58.52},{40.23,58.18},{39.58,56.3},{38.78,56.06},{37.78,56.11},{36.12,55.69},{34.79,55.55},{33.57,55.63},{32.14,55.76},{31.14,55.53},{30.34,54.64},{30.21,53.89},{29.99,52.1},{29.91,51.07},{27.06,49.57},{25.99,48.1},{25.03,45.68},{23.65,43.11},{23.86,43.3},{23.6,42.17},{23.34,40.97},{23.13,39.69},{22.97,38.53},{22.93,36.92},{23.2,35.78},{23.36,35.26},{23.56,34.73},{23.93,33.59},{24.22,32.92},{24.6,31.7},{24.47,30.74},{25.06,30.54},{25.6,30.23},{25.56,29.97},{26.64,29.87},{26.86,29.42},{27.64,28.55},{28.11,28.97},{28.8,29.62},{29.67,30.93},{29.8,31.94},{31.77,33.37},{32.65,33.5},{33.67,33.39},{34.26,32.49},{34.93,30.97},{35.55,29.95},{35.98,29.05},{36.5,28.72},{37.2,28.35},{38.04,28.12},{38.82,28.36},{39.29,28.87},{39.91,29.2},{40.64,29.63},{41.18,29.99},{41.9,30.4},{42.41,31.18},{42.93,32.02},{43.78,32.66},{44.36,33.42},{44.94,33.93},{45.49,34.16},{45.91,34.29},{46.61,34.46},{47.59,34.89},{48.49,35.25},{48.93,35.64},{49.31,36.43},{49.85,37.07},{50.35,37.14},{51.23,37.24},{52.03,37.21},{53.18,36.17},{53.77,35.24},{54.5,34.52},{55.16,34.34},{55.95,34.26},{56.51,34.17},{57.24,33.96},{57.63,34.3},{58.19,34.93},{59.31,36.12},{60.25,36.07},{60.76,35.12},{61.0,34.73},{61.4,34.17},{62.14,33.7},{62.59,34.41},{63.39,35.36},{63.92,35.92},{64.83,36.44},{65.71,36.94},{66.51,37.41},{67.05,37.77},{67.46,38.3},},[47]={{45.0,97.55},{44.51,98.01},{43.59,98.96},{42.79,99.8},{3.23,99.45},{3.08,98.37},{3.05,96.86},{3.3,95.79},{3.45,95.31},{3.63,94.81},{3.98,93.75},{4.25,93.12},{4.6,91.98},{4.48,91.08},{5.03,90.9},{5.54,90.6},{5.5,90.36},{6.51,90.27},{6.71,89.84},{7.45,89.03},{7.89,89.43},{8.53,90.04},{9.34,91.26},{9.47,92.2},{11.31,93.54},{12.13,93.66},{13.09,93.56},{13.64,92.72},{14.26,91.3},{14.84,90.35},{15.24,89.51},{15.73,89.2},{16.38,88.84},{17.18,88.64},{17.9,88.85},{18.34,89.34},{18.92,89.64},{19.6,90.04},{20.11,90.38},{20.78,90.77},{21.26,91.49},{21.74,92.28},{22.54,92.88},{23.08,93.59},{23.63,94.07},{24.14,94.28},{24.53,94.4},{25.19,94.56},{26.1,94.96},{26.94,95.3},{27.35,95.66},{27.71,96.4},{28.22,97.0},{28.68,97.06},{29.51,97.16},{30.25,97.13},{31.33,96.16},{31.88,95.29},{32.56,94.62},{33.18,94.45},{33.92,94.37},{34.44,94.29},{35.12,94.09},{35.49,94.41},{36.01,95.0},{37.06,96.11},{37.94,96.06},{38.41,95.18},{38.64,94.81},{39.02,94.29},{39.7,93.85},{40.13,94.51},{40.88,95.4},{41.37,95.93},{42.22,96.42},{43.04,96.88},{43.8,97.32},{44.29,97.65},{44.68,98.15},},[267]={{99.55,87.49},{98.19,87.58},{96.58,87.73},{95.45,87.47},{94.55,86.48},{94.4,85.63},{94.15,83.61},{94.06,82.46},{90.86,80.76},{89.66,79.11},{88.57,76.38},{87.03,73.5},{87.26,73.71},{86.97,72.44},{86.68,71.1},{86.44,69.65},{86.26,68.35},{86.22,66.53},{86.52,65.25},{86.7,64.67},{86.92,64.07},{87.34,62.79},{87.67,62.03},{88.09,60.66},{87.94,59.58},{88.61,59.36},{89.21,59.01},{89.17,58.71},{90.39,58.61},{90.63,58.09},{91.51,57.11},{92.04,57.6},{92.81,58.33},{93.79,59.8},{93.95,60.93},{96.15,62.54},{97.14,62.68},{98.3,62.56},{98.96,61.55},{99.71,59.85},},},45,nil,nil,15,"AH",},
[2612] = {'Lieutenant Valorcall',5493,5493,38,38,1,{[45]={{33.47,52.08},},},{[45]={{33.45,52.12},{34.15,52.21},{34.62,52.26},{35.29,52.4},{35.84,52.55},{36.55,52.76},{37.33,53.06},{38.18,53.44},{38.79,54.09},{39.24,54.53},{39.71,54.85},{40.38,54.88},{40.79,54.91},{41.18,54.9},{41.72,54.9},{42.16,54.92},{42.94,54.96},{43.48,55.68},{43.64,55.08},{43.89,54.25},{44.01,53.86},{44.32,53.36},{44.34,53.01},{44.3,52.62},{44.26,52.38},{44.19,51.98},{44.03,51.63},{44.0,51.22},{43.95,50.76},{43.92,50.35},{44.11,49.64},{44.22,49.25},{44.33,48.83},{44.46,48.38},{44.69,48.09},{44.91,47.75},{45.12,47.44},{45.5,47.0},{45.89,46.67},{46.14,46.44},{46.48,46.17},{46.98,45.94},{47.18,45.81},{47.4,45.63},{47.77,45.3},{48.06,45.04},{48.38,44.77},{48.73,44.28},{49.08,43.97},{49.38,44.12},{49.73,44.31},{50.27,44.63},{50.47,44.71},{50.77,44.56},{51.07,44.42},{51.37,44.35},{51.59,44.12},{51.8,43.49},{52.02,42.76},{52.18,42.31},{52.29,41.85},{52.4,41.48},{52.49,41.18},{52.6,40.94},{52.74,40.66},{52.99,40.6},{53.32,40.79},{53.71,40.88},{54.04,40.7},{53.76,40.92},{53.49,40.82},{53.12,40.61},{52.8,40.57},{52.56,40.93},{52.43,41.35},{52.29,41.88},{52.14,42.48},{51.92,42.97},{51.79,43.44},{51.54,44.13},{51.16,44.32},{50.8,44.49},{50.39,44.6},{49.94,44.35},{49.39,44.07},{48.93,43.98},{48.65,44.4},{48.36,44.72},{48.14,44.92},{47.85,45.18},{47.59,45.49},{47.28,45.72},{46.9,45.94},{46.53,46.18},{45.67,46.82},{45.32,47.17},{45.02,47.52},{44.64,48.11},{44.32,48.91},{44.14,49.43},{43.94,50.11},{43.92,50.61},{44.01,51.36},{44.21,52.04},{44.31,52.54},{44.38,53.15},{44.07,53.75},{43.82,54.3},{43.64,55.14},{43.35,55.37},{42.81,55.0},{42.23,54.9},{41.58,54.88},{40.78,54.86},{39.97,54.84},{39.24,54.51},{38.65,53.89},{37.91,53.28},{37.36,53.03},{36.78,52.77},{35.92,52.52},{35.36,52.38},{34.84,52.26},{34.24,52.19},{33.56,52.11},{33.01,52.07},{32.48,52.02},{31.63,51.88},{31.03,51.84},{30.51,51.52},{29.74,51.04},{29.05,50.65},{28.05,50.09},{27.18,49.89},{26.98,50.49},{26.74,51.29},{26.41,52.35},{26.15,53.41},{25.98,54.24},{25.94,54.75},{25.98,55.24},{26.07,55.81},{26.07,56.83},{26.06,57.56},{26.07,58.53},{26.08,59.12},{26.09,59.7},{25.59,60.05},{24.86,60.3},{24.22,60.53},{23.73,60.56},{22.95,60.48},{22.59,61.13},{22.26,61.94},{22.06,62.13},{20.99,62.29},{20.99,62.31},{22.01,62.21},{22.26,61.76},{22.82,60.47},{23.36,60.5},{23.96,60.52},{23.96,60.52},{24.4,60.48},{24.65,60.38},{25.13,60.27},{26.0,59.83},{26.08,59.04},{26.08,58.17},{26.08,57.57},{26.08,56.96},{26.05,55.59},{26.03,55.3},{25.94,54.58},{25.95,54.25},{26.2,53.15},{26.43,52.22},{26.71,51.29},{26.97,50.34},{27.18,49.75},{27.56,49.89},{28.11,50.17},{28.66,50.47},{29.21,50.76},{29.75,51.08},{30.2,51.35},{30.93,51.75},{31.6,51.91},{32.09,51.99},{32.57,52.06},{32.87,52.08},},[267]={{98.05,83.63},{98.84,83.74},{99.37,83.79},{99.61,83.79},{98.93,83.72},{98.17,83.62},{97.55,83.58},{96.96,83.52},{96.0,83.36},{95.32,83.32},{94.74,82.96},{93.88,82.42},{93.1,81.98},{91.97,81.35},{91.0,81.12},{90.77,81.8},{90.5,82.7},{90.13,83.89},{89.83,85.08},{89.64,86.02},{89.59,86.6},{89.65,87.14},{89.74,87.78},{89.75,88.93},{89.74,89.75},{89.74,90.85},{89.76,91.51},{89.77,92.16},{89.2,92.56},{88.38,92.84},{87.66,93.1},{87.11,93.13},{86.24,93.04},{85.84,93.77},{85.46,94.68},{85.24,94.9},{84.03,95.08},{84.03,95.09},{85.18,94.98},{85.46,94.48},{86.08,93.02},{86.7,93.06},{87.37,93.09},{87.37,93.09},{87.87,93.04},{88.15,92.92},{88.69,92.8},{89.67,92.3},{89.76,91.42},{89.76,90.45},{89.75,89.77},{89.75,89.07},{89.72,87.54},{89.7,87.21},{89.6,86.41},{89.61,86.03},{89.89,84.79},{90.16,83.75},{90.47,82.7},{90.76,81.64},{91.0,80.97},{91.42,81.13},{92.04,81.44},{92.66,81.78},{93.28,82.1},{93.89,82.47},{94.4,82.77},{95.22,83.22},{95.97,83.4},{96.51,83.49},{97.06,83.57},{97.39,83.59},},},45,nil,nil,123,"A",},
[2616] = {'Privateer Groy',2666,2666,42,42,0,{[15]={{68.84,53.22},},},nil,15,nil,{623,},120,"AH",},
[2618] = {'Hammerfall Peon',1203,1289,33,34,0,{[45]={{61.22,57.4},{61.34,56.87},{61.88,57.33},{61.82,58.4},{61.19,58.24},{61.54,57.91},{59.66,58.51},{61.88,55.65},{59.42,57.17},{63.42,58.06},{62.74,58.03},{63.54,57.53},{63.12,58.79},{62.27,56.11},{62.69,59.43},{62.58,56.1},{62.52,55.71},{63.12,57.46},{63.29,59.31},{63.65,58.67},{61.49,55.48},{59.77,56.17},{60.73,57.15},{60.68,57.91},{59.85,57.2},{60.65,59.17},{60.3,55.99},},},nil,45,nil,nil,83,"H",},
[2619] = {'Hammerfall Grunt',1187,1337,34,35,0,{[45]={{64.41,60.75},{60.96,56.13},{59.67,57.14},{62.78,55.75},{62.29,58.29},{64.0,58.29},{61.52,60.15},{62.68,52.93},{62.83,60.52},{58.59,54.14},{64.58,56.25},{62.43,54.32},{59.45,56.01},{61.06,60.14},{58.53,55.6},{60.92,56.12},},},{[45]={{62.28,57.72},{62.29,57.0},{62.29,57.68},{62.27,58.26},{62.22,59.02},{61.63,59.01},{61.12,58.98},{60.71,58.99},{60.43,59.0},{61.05,59.03},{61.46,59.12},{61.83,59.15},{62.25,59.19},{62.26,58.8},{62.26,58.24},{60.89,56.22},{61.3,56.19},{61.68,56.19},{61.88,56.36},{62.1,56.4},{62.16,56.33},{62.07,56.37},{61.75,56.2},{61.31,56.22},{60.93,56.2},{60.4,56.24},{60.23,56.61},{60.22,57.07},{60.01,57.18},{60.2,57.11},{60.19,56.62},{60.47,56.3},{60.84,56.1},},},45,nil,nil,83,"H",},
[2620] = {'Prairie Dog',8,8,1,1,0,{[45]={{63.85,30.54},{27.31,21.31},{30.71,41.45},{22.13,50.13},{39.26,67.53},{72.13,46.8},{53.99,33.43},{45.7,37.22},{33.5,62.51},{48.36,77.65},{37.63,25.69},{57.61,65.27},{37.26,37.25},{46.12,52.35},{40.52,47.63},{56.62,47.67},{49.89,67.19},{68.26,34.25},{28.31,44.36},{68.82,50.15},{77.81,35.45},{17.46,48.69},{63.81,41.63},},[17]={{54.97,34.6},{51.63,33.13},{52.84,53.75},{48.82,57.38},{41.98,15.44},{48.95,29.84},{48.05,13.2},{47.34,42.52},{41.44,79.92},{42.67,49.21},{41.94,45.28},{58.56,35.01},{43.31,41.32},{53.36,38.89},{55.31,38.29},{60.94,48.9},{41.0,18.89},{44.8,43.36},{43.17,81.58},{41.81,24.86},{39.05,13.98},{52.78,46.93},{53.3,12.8},{59.28,52.61},{44.31,20.4},{53.35,16.71},{46.03,60.47},},[215]={{56.4,88.87},{48.0,64.22},{54.57,49.54},{35.38,79.47},{50.15,57.53},{39.41,35.11},{39.71,44.22},{57.54,61.26},{49.99,90.11},{52.2,79.01},{39.34,16.89},{51.76,59.41},{45.38,45.13},{45.23,50.82},{59.62,23.27},{51.35,41.16},{51.41,9.81},{53.6,34.01},{46.95,34.96},{43.68,92.34},{55.61,28.09},{41.7,82.74},{46.08,80.16},{35.59,51.76},{33.03,41.95},{36.23,46.3},{57.43,61.15},{51.59,19.05},{34.07,29.84},},[40]={{51.14,76.14},{38.77,71.89},{61.52,49.02},{49.0,25.38},{51.51,63.94},{36.76,49.2},{49.62,30.73},{49.6,43.83},{60.84,40.61},},},nil,215,nil,nil,31,"AH",},
[2621] = {'Hammerfall Guardian',2770,2770,50,50,0,{[45]={{73.62,30.32},{72.5,35.23},{74.85,35.09},{74.31,29.06},{74.49,34.74},{74.21,28.98},{73.31,30.3},{73.18,29.65},{73.19,30.38},{74.72,30.3},{74.24,30.3},{73.91,30.95},{72.96,33.47},{73.68,32.1},{73.68,31.71},{74.41,37.41},{75.19,36.58},{73.26,36.43},{74.33,38.21},{74.65,37.73},{74.73,38.38},},},{[45]={{74.57,37.97},{74.58,37.42},{73.89,35.7},{73.51,35.62},{73.27,35.26},{73.49,34.23},{73.53,33.16},{73.49,30.49},},[47]={{51.32,97.84},{51.34,97.33},{50.69,95.72},{50.34,95.64},{50.11,95.31},{50.32,94.34},{50.35,93.34},{50.32,90.85},},},45,nil,nil,85,"H",},
[2622] = {'Sly Garrett',3077,3077,46,46,0,{[33]={{28.41,76.83},},},nil,33,nil,nil,120,"AH",},
[2623] = {'Spirit of Old',1846,1846,33,33,0,nil,nil,0,nil,nil,76,"AH",},
[2624] = {'Gazban',3036,3036,40,40,0,{[33]={{22.74,24.1},},},{[33]={{22.74,24.12},{22.57,24.13},{22.31,24.19},{21.97,24.34},{21.66,24.65},{21.38,24.82},{21.02,24.52},{20.57,23.87},{20.18,23.28},{19.94,23.0},{19.69,22.62},{19.69,22.62},{19.96,23.05},{20.21,23.35},{20.59,23.87},{21.03,24.53},{21.4,24.79},{21.7,24.62},{22.04,24.3},{22.36,24.17},{22.57,24.15},{22.74,24.09},},},33,nil,nil,35,"AH",},
[2625] = {'Viznik Goldgrubber',4108,4108,55,55,0,{[33]={{26.54,76.57},},},nil,33,nil,nil,120,"AH",},
[2626] = {'Old Man Heming',2766,2766,43,43,0,{[33]={{27.42,77.16},},},nil,33,nil,nil,120,"AH",},
[2627] = {'Grarnik Goodstitch',1930,1930,34,34,0,{[33]={{28.77,76.84},},},nil,33,nil,nil,120,"AH",},
[2628] = {'Dalaran Worker',1221,1279,33,34,0,{[36]={{16.9,56.43},{12.51,74.87},{10.42,74.02},{14.72,75.58},{11.55,77.5},{13.86,77.62},{14.56,75.79},{16.48,74.88},{19.99,71.76},{20.44,58.15},},},nil,36,nil,nil,76,"AH",},
[2630] = {'Earthbind Totem',5,5,13,13,0,nil,nil,0,nil,nil,35,"AH",},
[2634] = {'Princess Poobah',2666,2666,42,42,0,{[33]={{38.53,80.58},},},nil,33,{630,},{594,630,},35,"AH",},
[2635] = {'Elder Saltwater Crocolisk',4185,4185,38,38,1,{[33]={{33.43,32.53},{25.35,19.22},{29.83,25.48},{29.32,22.28},},},nil,33,nil,nil,14,nil,},
[2636] = {'Blackwater Deckhand',2284,2284,38,38,0,{[45]={{33.2,81.47},{32.8,81.99},{31.41,80.71},},},nil,45,nil,nil,121,"AH",},
[2638] = {'Syndicate Spectre',1239,1239,35,35,0,nil,nil,0,nil,nil,87,nil,},
[2639] = {'Vilebranch Axe Thrower',2310,2399,45,46,0,{[47]={{43.49,68.29},{46.28,66.93},{50.5,64.36},{45.31,69.52},{47.93,63.34},{43.52,66.96},{43.35,65.38},{48.7,63.16},{46.8,61.86},},},nil,47,nil,nil,795,nil,},
[2640] = {'Vilebranch Witch Doctor',1919,1990,46,47,0,{[47]={{47.56,69.49},{63.27,60.03},{63.75,59.94},{67.71,65.96},{67.33,66.35},{67.35,68.72},{68.52,70.25},{65.86,68.58},{68.94,69.37},},},nil,47,nil,nil,795,nil,},
[2641] = {'Vilebranch Headhunter',5757,5970,46,47,1,{[47]={{66.06,70.19},{66.06,70.19},{65.26,69.0},{67.71,70.81},{68.74,70.64},{68.33,70.88},},},{[45]={{90.22,8.84},{90.32,8.39},{90.77,8.33},{91.14,8.6},{91.96,8.86},{92.46,8.87},{92.77,8.85},{92.83,8.66},{92.76,8.52},{92.83,8.66},{92.77,8.85},{92.46,8.87},{91.96,8.86},{91.14,8.6},{90.77,8.33},{90.32,8.39},{90.77,8.33},{91.14,8.6},{91.49,8.89},{91.96,8.86},{92.46,8.87},{92.77,8.85},{92.83,8.66},{92.76,8.52},{92.83,8.66},{92.77,8.85},{92.46,8.87},{91.96,8.86},{91.49,8.89},{91.14,8.6},{90.77,8.33},{90.32,8.39},{90.22,8.84},{90.29,9.36},{90.22,8.84},{90.32,8.39},{89.48,6.76},{89.41,6.3},{89.6,5.81},{89.41,6.3},{89.48,6.76},{89.47,7.12},{89.49,7.54},{89.46,7.89},{89.32,8.24},{89.44,8.53},{89.64,8.71},{89.44,8.53},{89.32,8.24},{89.46,7.89},{89.49,7.54},{89.47,7.12},{92.11,8.94},{92.29,8.57},{92.19,8.92},{91.93,8.93},{91.59,8.79},{91.27,8.6},{90.95,8.48},{90.67,8.4},{90.38,8.55},{89.95,8.43},{89.64,8.38},{89.55,7.95},{89.55,7.2},{89.54,7.78},{89.57,8.16},{89.74,8.43},{90.2,8.63},{90.48,8.44},{90.82,8.42},{91.29,8.74},{91.72,8.94},},[47]={{65.97,70.6},{66.06,70.19},{66.47,70.13},{66.82,70.38},{67.59,70.62},{68.06,70.63},{68.35,70.62},{68.4,70.44},{68.34,70.3},{68.4,70.44},{68.35,70.62},{68.06,70.63},{67.59,70.62},{66.82,70.38},{66.47,70.13},{66.06,70.19},{66.47,70.13},{66.82,70.38},{67.15,70.65},{67.59,70.62},{68.06,70.63},{68.35,70.62},{68.4,70.44},{68.34,70.3},{68.4,70.44},{68.35,70.62},{68.06,70.63},{67.59,70.62},{67.15,70.65},{66.82,70.38},{66.47,70.13},{66.06,70.19},{65.97,70.6},{66.03,71.09},{65.97,70.6},{66.06,70.19},{65.27,68.66},{65.2,68.23},{65.38,67.77},{65.2,68.23},{65.27,68.66},{65.26,69.0},{65.28,69.39},{65.26,69.72},{65.12,70.05},{65.24,70.32},{65.42,70.48},{65.24,70.32},{65.12,70.05},{65.26,69.72},{65.28,69.39},{65.26,69.0},{67.73,70.69},{67.9,70.35},{67.8,70.68},{67.56,70.69},{67.25,70.55},{66.94,70.38},{66.65,70.27},{66.39,70.19},{66.11,70.33},{65.71,70.22},{65.42,70.17},{65.33,69.77},{65.34,69.07},{65.33,69.61},{65.36,69.97},{65.51,70.22},{65.94,70.41},{66.21,70.23},{66.52,70.21},{66.96,70.51},{67.37,70.69},},},47,nil,nil,795,nil,},
[2642] = {'Vilebranch Shadowcaster',4179,4329,47,48,1,{[47]={{65.78,71.99},{68.03,73.17},{64.27,65.73},{63.48,65.79},{64.97,71.3},{63.7,71.36},{64.21,72.17},{65.27,73.4},},},nil,47,nil,nil,795,nil,},
[2643] = {'Vilebranch Berserker',5970,6186,47,48,1,{[47]={{66.52,71.81},{67.1,71.87},{63.26,66.57},{68.15,71.82},{68.2,72.6},{64.34,66.61},{63.56,69.97},{64.0,70.56},{64.56,70.54},{64.27,69.87},{64.59,72.72},{64.22,71.67},{66.07,73.49},{66.54,72.92},{64.33,67.54},},},{[45]={{87.65,8.16},{87.66,7.73},{87.74,7.22},{88.11,7.03},{87.87,7.18},{87.71,7.51},{87.66,8.2},{87.69,8.49},{87.96,8.9},{88.23,9.27},{88.62,9.65},{88.78,10.03},{88.95,10.49},{89.17,10.78},{88.93,10.34},{88.72,9.85},{88.51,9.49},{88.18,9.25},{87.91,8.83},{87.72,8.49},},[47]={{63.56,69.96},{63.57,69.56},{63.65,69.09},{63.99,68.91},{63.77,69.05},{63.62,69.36},{63.57,70.0},{63.6,70.27},{63.85,70.66},{64.1,71.0},{64.47,71.36},{64.62,71.71},{64.77,72.15},{64.99,72.41},{64.76,72.01},{64.56,71.55},{64.36,71.21},{64.06,70.99},{63.81,70.59},{63.62,70.28},},},47,nil,nil,795,nil,},
[2644] = {'Vilebranch Hideskinner',6186,6414,48,49,1,{[47]={{67.48,76.24},{65.02,77.08},{59.16,66.11},{66.84,80.31},{64.05,78.62},{64.42,74.08},{66.03,74.53},{65.39,75.61},{63.55,73.13},{68.31,75.28},{57.61,66.63},{61.29,67.93},{62.07,66.43},{62.73,70.81},{62.09,69.19},},},{[45]={{83.01,3.98},{83.01,3.5},{83.04,2.71},{83.06,1.99},{83.07,1.62},{83.04,1.99},{83.05,2.36},{83.05,2.94},{83.05,3.47},{83.04,4.03},{83.03,4.59},{83.01,5.27},{83.01,5.89},{83.01,6.37},{83.01,6.59},{83.04,6.36},{83.05,5.6},{83.04,5.02},{87.63,11.49},{87.35,11.15},{87.02,10.8},{86.81,10.51},{86.67,10.09},{86.59,9.76},{86.43,9.6},{86.16,9.65},{86.44,9.66},{86.62,9.8},{86.73,10.26},{86.88,10.73},{87.1,11.0},{87.42,11.21},{87.64,11.53},{87.96,12.08},{88.15,12.56},{88.39,13.05},{88.62,13.44},{88.97,13.69},{89.25,13.59},{89.56,13.43},{89.96,13.39},{90.34,13.54},{90.62,13.78},{90.91,14.05},{91.26,14.05},{91.48,13.82},{91.49,13.44},{91.49,13.22},{91.49,13.44},{91.45,13.78},{91.25,14.06},{90.85,13.97},{90.39,13.53},{89.86,13.35},{89.49,13.46},{89.05,13.68},{88.61,13.43},{88.33,12.95},{88.08,12.41},{87.78,11.65},{81.36,4.55},{81.51,4.32},{81.73,4.26},{82.16,4.2},{82.44,3.85},{82.31,4.06},{82.01,4.16},{81.64,4.24},{81.34,4.57},{81.33,4.95},{81.36,5.45},{81.41,6.02},{81.21,6.57},{80.77,6.53},{81.29,6.69},{81.57,7.05},{81.93,7.74},{81.62,7.24},{81.28,6.73},{81.34,6.38},{81.42,6.0},{81.38,5.42},{81.33,4.88},},[47]={{59.22,66.06},{59.22,65.61},{59.25,64.87},{59.27,64.2},{59.27,63.85},{59.25,64.2},{59.26,64.55},{59.26,65.08},{59.26,65.58},{59.25,66.1},{59.24,66.62},{59.23,67.27},{59.22,67.85},{59.22,68.3},{59.22,68.5},{59.25,68.29},{59.26,67.58},{59.25,67.03},{63.54,73.08},{63.28,72.76},{62.97,72.44},{62.77,72.17},{62.65,71.78},{62.57,71.47},{62.42,71.31},{62.17,71.37},{62.43,71.37},{62.6,71.5},{62.7,71.93},{62.84,72.37},{63.05,72.62},{63.35,72.82},{63.55,73.12},{63.85,73.63},{64.03,74.08},{64.25,74.54},{64.46,74.9},{64.79,75.14},{65.05,75.05},{65.35,74.89},{65.72,74.86},{66.07,75.0},{66.34,75.23},{66.61,75.47},{66.93,75.48},{67.15,75.26},{67.15,74.91},{67.15,74.7},{67.15,74.9},{67.11,75.23},{66.92,75.49},{66.55,75.4},{66.12,74.99},{65.63,74.82},{65.28,74.93},{64.87,75.12},{64.46,74.89},{64.2,74.45},{63.96,73.94},{63.69,73.23},{57.68,66.6},{57.82,66.38},{58.02,66.32},{58.43,66.26},{58.69,65.94},{58.56,66.14},{58.29,66.22},{57.94,66.31},{57.66,66.61},{57.65,66.97},{57.68,67.43},{57.72,67.97},{57.54,68.48},{57.13,68.45},{57.61,68.59},{57.88,68.93},{58.21,69.57},{57.92,69.11},{57.61,68.63},{57.66,68.31},{57.73,67.94},{57.69,67.4},{57.66,66.9},},},47,nil,nil,795,nil,},
[2645] = {'Vilebranch Shadow Hunter',4950,5130,48,49,1,{[47]={{62.49,65.34},{68.0,75.79},{68.0,74.69},{66.57,74.45},{66.57,77.33},{64.96,74.39},{63.18,73.02},{65.99,75.54},{65.02,75.84},{63.67,73.68},{62.48,72.16},{60.05,73.12},{59.1,71.32},{59.99,65.14},{62.14,70.2},{62.37,71.54},{62.56,65.97},{62.04,68.3},{62.69,68.68},},},{[45]={{90.85,16.0},{90.87,16.48},{90.87,16.98},{90.86,16.48},},[47]={{66.56,77.3},{66.57,77.75},{66.57,78.22},{66.56,77.75},},},47,nil,nil,795,nil,},
[2646] = {'Vilebranch Blood Drinker',6414,6645,49,50,1,{[47]={{65.17,82.12},{64.6,82.16},{67.05,78.07},{67.82,77.46},{67.25,77.5},{65.98,82.36},{63.5,79.72},{66.61,81.29},{65.89,80.4},{66.8,79.96},{67.05,80.86},{62.86,78.16},{58.41,68.07},{62.93,77.78},{58.79,68.3},{61.28,72.21},{58.41,67.11},{63.13,83.36},{63.55,84.07},{63.54,82.16},{64.12,83.18},{61.61,72.46},{60.75,68.68},{60.42,73.98},{60.8,67.81},{60.47,68.22},{58.27,72.79},{60.48,64.57},},},nil,47,nil,nil,795,nil,},
[2647] = {'Vilebranch Soul Eater',6327,6556,49,50,1,{[47]={{67.69,78.0},{63.28,80.23},{65.65,82.49},{66.12,79.93},{67.35,80.25},{58.72,67.15},{61.4,72.85},{63.3,82.66},{59.98,71.48},{59.93,74.14},{60.55,67.59},{57.98,71.7},{57.98,72.81},{60.75,64.52},{60.79,65.61},},},nil,47,nil,nil,795,nil,},
[2648] = {'Vilebranch Aman\'zasi Guard',6645,6876,50,51,1,{[47]={{58.88,77.71},{55.99,82.03},{57.62,81.15},{58.29,82.41},{57.87,79.64},{57.87,83.16},{57.6,80.71},{54.48,83.98},{57.66,81.51},{56.15,83.71},{57.25,84.61},{56.36,84.9},{56.87,83.45},{60.06,80.37},{57.29,84.13},{57.95,76.64},{55.72,84.76},{57.24,85.89},{64.89,81.76},{57.35,86.55},{57.31,86.57},{61.75,81.53},{61.39,81.66},{56.44,80.93},{58.66,79.16},{57.06,68.76},{57.15,68.01},{59.65,78.97},},},{[45]={{81.24,20.09},{81.37,20.23},{81.6,20.56},{81.81,20.7},{82.01,20.97},{81.99,21.24},{81.87,21.6},{81.68,21.93},{81.48,22.21},{81.64,21.96},{81.77,21.64},{81.89,21.18},{81.83,20.82},{81.63,20.6},{81.43,20.32},{81.28,20.1},{81.03,25.97},{81.06,26.11},{81.11,26.25},{81.17,26.33},{81.23,26.36},{81.31,26.37},{81.39,26.3},{81.43,26.2},{81.42,26.05},{81.38,25.97},{81.3,25.93},{81.17,25.91},{81.11,25.93},{80.92,25.88},{80.96,26.08},{81.03,26.28},{81.14,26.5},{81.35,26.48},{81.55,26.27},{81.43,25.73},{81.14,25.71},{80.97,25.81},},[47]={{57.57,81.13},{57.69,81.25},{57.9,81.56},{58.1,81.69},{58.29,81.94},{58.27,82.2},{58.15,82.54},{57.98,82.85},{57.79,83.1},{57.94,82.87},{58.06,82.57},{58.18,82.14},{58.11,81.81},{57.93,81.6},{57.74,81.34},{57.61,81.13},{57.37,86.62},{57.4,86.76},{57.45,86.88},{57.5,86.96},{57.56,86.99},{57.64,86.99},{57.7,86.93},{57.75,86.84},{57.73,86.69},{57.7,86.62},{57.63,86.58},{57.5,86.56},{57.44,86.58},{57.27,86.53},{57.31,86.73},{57.37,86.91},{57.47,87.12},{57.67,87.1},{57.86,86.9},{57.75,86.4},{57.48,86.38},{57.32,86.48},},},47,nil,nil,795,nil,},
[2649] = {'Witherbark Scalper',1829,1902,40,41,0,{[47]={{22.43,57.72},{21.75,57.54},{23.02,57.88},{23.12,58.47},{23.69,56.62},{21.95,55.22},{24.29,55.32},{22.85,55.16},{25.47,56.08},{25.18,57.96},{25.14,60.3},{24.58,59.05},{24.07,58.82},},},nil,47,nil,nil,654,nil,},
[2650] = {'Witherbark Zealot',1902,1981,41,42,0,{[47]={{21.79,56.7},{23.68,57.29},{22.82,58.34},{23.67,58.5},{22.76,56.24},{24.58,56.75},{23.55,55.37},{25.31,58.96},{24.52,60.19},},},nil,47,nil,nil,654,nil,},
[2651] = {'Witherbark Hideskinner',1981,2059,42,43,0,{[47]={{27.97,57.96},{28.01,58.94},{31.13,58.54},{31.61,56.52},{32.99,58.27},{31.9,57.58},{32.81,58.9},{31.69,58.23},{32.24,58.64},{32.68,57.34},{31.54,59.89},{29.83,61.28},{29.7,60.32},{30.48,60.08},{29.58,58.04},{28.74,56.55},{30.57,56.73},{30.59,57.69},},},nil,47,nil,nil,654,nil,},
[2652] = {'Witherbark Venomblood',2059,2059,43,43,0,{[47]={{31.15,57.4},{32.35,57.9},{31.67,57.95},{31.99,58.42},{32.59,59.77},{30.34,61.55},{29.69,58.91},{29.89,56.63},},},nil,47,nil,nil,654,nil,},
[2653] = {'Witherbark Sadist',2138,2218,44,45,0,{[47]={{30.61,71.36},{32.05,75.77},{32.58,67.03},{31.71,67.86},{36.68,66.13},{39.7,66.36},{40.27,66.04},{32.35,67.88},{25.4,66.43},{25.6,65.95},{34.96,72.82},{36.62,71.46},{36.86,72.17},{36.95,70.77},{32.95,75.7},{32.7,75.32},{36.53,63.01},{35.33,63.5},{35.67,65.91},{31.97,70.24},},},nil,47,nil,nil,654,nil,},
[2654] = {'Witherbark Caller',1618,1679,45,46,0,{[47]={{32.5,76.33},{32.05,67.05},{39.99,65.78},{36.02,72.85},{37.01,71.59},},},nil,47,nil,nil,654,nil,},
[2655] = {'Green Sludge',2399,2488,46,47,0,{[47]={{56.65,40.79},{59.78,42.99},{55.55,44.01},{55.7,44.61},{56.94,44.3},{56.87,43.63},{48.86,55.37},{57.19,44.09},{56.71,42.18},{60.2,42.83},{58.12,40.73},{57.52,41.87},{50.2,47.75},{49.02,48.69},{50.27,54.76},{47.72,53.8},{49.32,51.49},{57.83,43.75},{57.53,42.78},{48.43,51.8},{48.72,53.07},{48.19,49.98},{48.87,47.09},{49.47,46.47},{49.65,47.49},{45.72,44.19},{44.87,41.15},{43.8,43.8},{44.93,42.0},{45.77,43.04},{45.15,42.61},{46.85,43.68},{57.45,38.77},{55.81,44.49},{57.42,40.99},{59.47,41.98},{59.12,42.16},{59.87,41.3},{48.58,40.95},{47.98,42.25},{47.72,40.73},{47.02,41.47},{47.22,42.39},{46.37,39.91},{46.32,42.65},{46.24,40.9},},},{[47]={{59.61,43.04},{58.89,43.13},{59.61,43.04},{60.2,42.83},{60.41,41.99},{59.94,41.57},{59.37,41.92},{58.92,42.36},{58.46,41.98},{57.51,41.59},{58.46,41.98},{58.92,42.36},{59.37,41.92},{59.94,41.57},{60.41,41.99},{60.2,42.83},},},47,nil,nil,14,nil,},
[2656] = {'Jade Ooze',2488,2578,47,48,0,{[47]={{56.57,42.56},{58.95,40.85},{60.32,42.47},{57.15,43.38},{59.21,43.27},{58.36,42.59},{58.25,39.72},{55.99,42.72},{56.5,45.01},{56.52,43.42},{57.35,44.58},{55.62,41.01},{58.97,42.35},{56.19,39.01},{56.98,41.02},{56.9,42.99},{57.83,42.72},{58.47,42.17},{58.35,41.57},{58.19,40.89},{57.9,41.74},{49.51,48.57},{51.17,52.87},{50.09,51.07},{58.43,43.54},{59.36,43.42},{47.57,51.6},{58.27,44.73},{57.5,45.89},{49.41,53.08},{58.08,45.66},{48.21,48.05},{59.22,39.24},{56.63,44.73},{44.66,42.92},{58.34,38.55},{57.58,39.93},{56.3,42.35},{57.43,43.58},{47.54,41.64},{45.47,40.35},{45.62,39.32},{45.52,38.33},{46.06,39.56},{46.81,40.1},},},{[47]={{57.31,43.98},{57.73,43.58},{57.31,43.98},{57.15,43.38},{56.87,43.09},{56.71,42.18},{56.77,41.61},{57.17,40.71},{57.67,40.02},{58.23,40.9},{58.38,41.53},{58.39,42.29},{57.96,42.65},{57.6,43.0},{57.14,42.54},{57.6,43.0},{57.96,42.65},{58.39,42.29},{58.38,41.53},{58.23,40.9},{57.67,40.02},{57.17,40.71},{56.77,41.61},{56.71,42.18},{56.87,43.09},{57.15,43.38},},},47,nil,nil,14,nil,},
[2657] = {'Trained Razorbeak',1829,1981,40,42,0,{[47]={{17.94,53.17},{16.74,50.26},{16.24,50.75},{15.21,49.21},{15.55,49.28},{20.4,48.19},{18.27,53.0},},},{[47]={{20.43,48.06},{20.64,47.93},{20.95,47.79},{21.39,47.77},{21.7,47.71},{21.99,47.7},{22.3,47.84},{22.62,48.05},{22.94,48.06},{23.32,48.01},{23.54,47.82},{23.85,47.69},{24.09,47.54},{24.3,47.38},{24.57,47.2},{24.24,47.4},{23.89,47.71},{23.55,47.82},{23.07,47.99},{22.77,48.06},{22.58,47.98},{22.27,47.81},{21.95,47.68},{21.59,47.66},{21.21,47.75},{20.85,47.78},{20.54,48.0},{18.37,53.02},{18.38,52.34},{18.37,51.8},{18.39,51.01},{18.79,50.27},{19.16,49.98},{19.5,50.05},{19.72,50.25},{20.0,50.66},{20.28,50.84},{20.62,51.14},{20.76,51.62},{20.74,52.25},{20.74,52.75},{20.67,53.6},{20.61,54.38},{20.25,54.78},{19.95,54.73},{19.64,54.71},{19.27,54.75},{18.91,54.27},{18.43,54.22},{18.02,54.01},{18.19,53.64},},},47,nil,nil,84,"A",},
[2658] = {'Razorbeak Gryphon',2059,2218,43,45,0,{[47]={{45.08,51.75},},},nil,47,nil,nil,1055,"A",},
[2659] = {'Razorbeak Skylord',2399,2578,46,48,0,{[47]={{63.83,51.95},{54.23,49.34},},},{[47]={{54.24,49.46},{54.08,49.68},{54.09,50.11},{54.16,50.65},{54.12,51.08},{54.1,51.67},{54.3,51.92},{54.52,52.32},{54.8,52.84},{54.47,53.07},{54.22,53.16},{53.91,52.97},{53.52,52.87},{53.3,52.64},{52.99,52.34},{52.54,52.04},{52.5,51.59},{52.41,51.08},{52.21,50.63},{52.09,50.35},{51.97,50.01},{51.76,49.34},{51.73,48.96},{51.71,48.38},{51.7,47.94},{51.56,47.6},{51.27,46.85},{51.09,46.35},{51.13,45.83},{51.22,45.74},{51.67,45.52},{51.93,45.43},{52.3,45.46},{52.88,45.6},{53.23,45.91},{53.54,46.33},{53.67,46.71},{53.82,47.15},{53.94,47.61},{54.08,48.17},{54.22,48.96},},},47,nil,nil,1055,"A",},
[2663] = {'Narkk',2666,2666,42,42,0,{[33]={{28.13,74.42},},},nil,33,nil,nil,120,"AH",},
[2664] = {'Kelsey Yance',2766,2766,43,43,0,{[33]={{28.23,74.34},},},nil,33,nil,nil,120,"AH",},
[2667] = {'Ward of Laze',13,13,37,37,0,nil,nil,0,nil,nil,45,nil,},
[2668] = {'Danielle Zipstitch',1380,1380,27,27,0,{[10]={{75.87,45.56},},},nil,10,nil,nil,12,"A",},
[2669] = {'Sheri Zipstitch',1684,1684,31,31,0,{[10]={{75.68,45.57},},},nil,10,nil,nil,12,"A",},
[2670] = {'Xizk Goodstitch',2766,2766,43,43,0,{[33]={{28.71,76.89},},},nil,33,{4782,4785,},{4781,4785,},120,"AH",},
[2671] = {'Mechanical Squirrel',644,644,15,15,0,nil,nil,0,nil,nil,4,"A",},
[2672] = {'Cowardly Crosby',2471,2471,40,40,0,{[33]={{27.0,82.48},},},nil,33,nil,nil,35,"AH",},
[2673] = {'Target Dummy',64,64,1,1,0,nil,nil,0,nil,nil,5,"H",},
[2674] = {'Advanced Target Dummy',64,64,1,1,0,nil,nil,0,nil,nil,3,"A",},
[2675] = {'Explosive Sheep',1605,1605,30,30,0,nil,nil,0,nil,nil,14,nil,},
[2676] = {'Compact Harvest Reaper',1656,1724,40,41,0,nil,nil,0,nil,nil,47,nil,},
[2678] = {'Mechanical Dragonling',3184,3184,47,47,0,nil,nil,0,nil,nil,14,nil,},
[2679] = {'Wenna Silkbeard',1454,1454,28,28,0,{[11]={{25.61,25.8},},},nil,11,nil,nil,55,"A",},
[2680] = {'Vilebranch Wolf Pup',2399,3488,46,47,0,{[47]={{44.65,65.4},{46.43,65.07},{46.54,69.71},{48.36,64.0},{47.26,66.04},{43.57,67.82},{67.98,70.64},{65.81,70.26},{63.54,65.24},{63.54,68.9},{66.73,72.36},{65.15,70.27},{68.25,68.69},{68.37,70.57},},},{[45]={{90.09,8.47},{90.29,8.45},{90.6,8.33},{90.94,8.38},{91.19,8.57},{90.79,8.25},{90.45,8.35},{90.03,8.5},{89.64,8.45},{89.47,8.06},{89.5,7.52},{89.45,8.04},{89.64,8.48},},[47]={{65.85,70.26},{66.03,70.24},{66.32,70.13},{66.63,70.17},{66.87,70.35},{66.5,70.05},{66.18,70.15},{65.79,70.28},{65.42,70.24},{65.26,69.88},{65.29,69.37},{65.25,69.85},{65.42,70.26},},},47,nil,nil,38,nil,},
[2681] = {'Vilebranch Raiding Wolf',6645,6876,50,51,1,{[47]={{61.98,83.06},{60.63,78.86},{61.78,79.93},{60.79,77.38},{58.58,64.52},{58.76,64.9},{58.43,75.96},{60.76,79.81},{60.07,77.34},{58.91,75.54},{59.98,76.0},},},nil,47,nil,nil,38,nil,},
[2682] = {'Fradd Swiftgear',1172,1172,24,24,0,{[11]={{26.4,25.76},},},nil,11,nil,nil,875,"A",},
[2683] = {'Namdo Bizzfizzle',1172,1172,24,24,0,{[1]={{21.86,31.86},},},nil,1,nil,nil,875,"A",},
[2684] = {'Rizz Loosebolt',1684,1684,31,31,0,{[36]={{47.3,35.16},},},nil,36,nil,nil,35,"AH",},
[2685] = {'Mazk Snipeshot',2100,2100,36,36,0,{[33]={{28.5,75.12},},},nil,33,nil,nil,120,"AH",},
[2686] = {'Witherbark Broodguard',2138,2218,44,45,0,{[47]={{30.66,69.72},{29.48,70.66},{32.0,71.39},{34.36,66.8},{30.95,70.64},{35.46,74.41},{30.99,72.51},{32.07,73.29},{31.32,74.13},{30.63,73.64},{37.72,67.65},{35.1,73.7},{36.52,68.34},{35.35,71.35},{33.26,69.27},{33.35,73.61},{34.81,63.24},{34.76,68.27},{36.96,63.83},{35.84,64.69},},},nil,47,nil,nil,312,nil,},
[2687] = {'Gnaz Blunderflame',2666,2666,42,42,0,{[33]={{50.98,35.21},},},nil,33,nil,nil,35,"AH",},
[2688] = {'Ruppo Zipcoil',3748,3748,52,52,0,{[47]={{34.33,37.76},},},nil,47,nil,nil,35,"AH",},
[2691] = {'Highvale Outrunner',2092,2445,43,44,0,{[47]={{33.14,42.2},{34.08,48.79},{33.04,51.52},{32.32,51.46},{33.33,47.34},{33.89,50.05},{31.2,51.67},{33.93,43.23},{34.04,44.6},{30.45,51.41},{28.72,51.23},{29.6,51.41},},},nil,47,nil,nil,1576,"A",},
[2692] = {'Highvale Scout',2252,2355,44,45,0,{[47]={{33.18,44.57},{33.2,45.98},{33.32,48.23},{31.83,48.34},{33.43,48.22},{32.18,50.27},{33.0,50.07},{33.16,43.52},{31.92,49.51},{30.4,50.14},{30.65,48.98},{29.66,50.05},{31.49,48.91},},},nil,47,nil,nil,1576,"A",},
[2693] = {'Highvale Marksman',2415,2516,45,46,0,{[47]={{32.25,42.7},{31.41,43.38},{32.32,47.43},{32.14,43.34},{32.01,46.2},{29.78,48.45},{29.28,49.58},{29.24,48.47},{28.33,46.26},{28.65,46.5},{31.53,47.46},{31.08,47.87},{31.27,48.33},},},nil,47,nil,nil,1576,"A",},
[2694] = {'Highvale Ranger',2038,2062,46,47,0,{[47]={{30.55,43.42},{29.79,43.28},{30.97,47.46},{28.47,45.43},{28.76,45.98},{30.62,48.39},{30.25,48.75},{30.8,47.61},{31.81,47.08},},},nil,47,nil,nil,1576,"A",},
[2695] = {'Sara Balloo',644,644,15,15,0,{[1537]={{63.5,67.3},},},nil,1537,{683,},{637,},55,"A",},
[2696] = {'Foggy MacKreel',1605,1605,30,30,0,{[45]={{43.24,92.64},},},nil,45,{647,},nil,55,"A",},
[2697] = {'Clyde Ranthal',1684,1684,31,31,0,{[44]={{89.02,70.87},},},nil,44,nil,nil,12,"A",},
[2698] = {'George Candarte',1684,1684,31,31,0,{[267]={{92.02,38.23},},},nil,267,nil,nil,68,"H",},
[2699] = {'Rikqiz',2766,2766,43,43,0,{[33]={{28.49,76.05},},},nil,33,nil,nil,120,"AH",},
[2700] = {'Captain Nials',2568,2568,41,41,0,{[45]={{45.83,47.56},},},nil,45,{681,682,},{634,681,682,684,685,},12,"A",},
[2701] = {'Dustbelcher Ogre',1604,1678,38,39,0,{[3]={{62.52,68.44},{61.95,70.18},{29.39,56.79},{29.85,56.44},},},nil,3,nil,nil,45,nil,},
[2703] = {'Zengu',2471,2471,40,40,0,{[45]={{73.8,33.96},},},nil,45,{639,640,643,644,645,},{638,639,641,643,644,646,},126,"H",},
[2704] = {'Hanashi',3517,3517,50,50,0,{[1637]={{81.53,19.63},},},nil,1637,nil,nil,876,"H",},
[2705] = {'Brewmeister Bilger',1846,1846,33,33,0,{[267]={{52.13,58.74},},},nil,267,nil,{647,},55,"A",},
[2706] = {'Tor\'gan',2471,2471,40,40,0,{[45]={{74.72,36.29},},},nil,45,{641,671,672,673,674,701,702,},{640,655,671,672,673,675,701,847,},126,"H",},
[2707] = {'Shadra',18298,18298,55,55,1,nil,nil,0,nil,nil,32,"AH",},
[2708] = {'Archmage Malin',2471,2471,40,40,0,{[1519]={{39.77,81.46},},},nil,1519,{690,},{697,},12,"A",},
[2711] = {'Phin Odelic',2100,2100,36,36,0,{[267]={{50.35,59.05},},},nil,267,{659,},{661,},12,"A",},
[2712] = {'Quae',1609,1609,38,38,0,{[45]={{60.18,53.85},},},nil,45,{657,658,661,},{658,659,660,},123,"A",},
[2713] = {'Kinelory',1200,1200,38,38,0,{[45]={{60.24,53.92},},},nil,45,{660,},{657,},231,"A",},
[2714] = {'Forsaken Courier',1342,1342,35,35,0,{[45]={{52.47,61.53},},},{[45]={{52.47,61.53},{52.01,61.26},{51.36,60.59},{50.99,59.85},{50.59,59.7},{50.09,59.38},{49.69,59.28},{49.06,59.24},{48.38,59.35},{47.82,59.55},{47.25,59.75},{46.63,59.72},{46.34,59.57},{45.72,59.15},{45.19,58.78},{44.64,57.76},{44.08,56.76},{43.42,55.63},{43.01,55.08},{42.5,54.92},{41.34,54.87},{40.66,54.87},{39.88,54.81},{39.49,54.78},{38.93,54.22},{38.25,53.48},{37.42,53.06},{36.26,52.63},{35.59,52.45},{34.91,52.29},{34.04,52.17},{33.17,52.07},{32.3,52.02},{31.12,51.8},{30.65,51.6},{29.84,51.12},{29.15,50.7},{28.33,50.24},{27.63,49.84},{27.16,49.68},{26.51,49.11},{26.16,48.41},{25.84,47.68},{25.3,46.29},{25.08,45.83},{24.43,44.74},{24.04,44.1},{23.62,42.98},{23.33,41.74},{23.14,40.87},{22.97,39.88},{22.81,38.81},{22.77,38.08},{22.75,37.03},{22.73,36.01},{22.63,34.65},{22.51,33.62},{22.29,33.14},{22.71,36.29},{22.63,34.37},{22.54,33.65},{22.25,33.0},{21.87,32.24},{21.39,31.36},{21.09,30.89},{20.93,30.64},{20.16,29.56},{19.71,28.98},{19.29,28.5},{18.86,28.07},{18.51,27.67},{18.18,27.33},{17.55,26.81},{16.95,26.54},{16.41,26.17},{15.85,25.76},{15.35,25.43},{15.01,25.17},{14.48,24.56},{14.21,24.23},{13.93,23.89},{13.25,23.1},{12.6,22.36},{11.68,21.44},{10.71,20.61},{9.41,19.72},{8.55,19.18},{7.59,18.71},{6.75,18.14},{6.28,17.63},{5.92,17.14},{5.61,16.68},{5.44,16.46},{5.06,15.97},{4.52,15.41},{3.75,15.18},{3.18,15.05},{2.54,14.9},{2.14,14.73},{1.69,14.57},{1.13,14.19},{0.66,13.76},{0.42,13.47},{0.09,13.07},{0.31,13.39},{0.63,13.77},{0.98,14.1},{1.45,14.45},{1.78,14.62},{2.17,14.77},{2.54,14.91},{2.9,15.01},{3.84,15.19},{4.74,15.65},{5.43,16.43},{5.67,16.84},{6.08,17.42},{6.57,17.99},{7.47,18.6},{8.32,19.03},{8.78,19.29},{9.85,20.04},{10.67,20.57},{11.23,21.04},{11.92,21.67},{12.48,22.16},{13.0,22.79},{13.4,23.27},{13.8,23.71},{14.19,24.13},{14.72,24.81},{15.14,25.26},{15.82,25.76},{16.26,26.08},{16.91,26.52},{16.82,26.77},{17.63,26.94},{18.17,27.33},{18.64,27.81},{19.28,28.49},{20.01,29.36},{20.63,30.17},{21.05,30.9},{21.58,31.71},{22.09,32.76},{22.51,33.85},{22.59,34.61},{22.69,35.44},{22.75,36.1},{22.71,37.62},{22.75,38.4},{22.85,39.39},{22.99,40.16},{23.17,41.13},{23.36,41.96},{23.52,42.75},{23.72,43.38},{23.94,43.95},{24.41,44.68},{24.74,45.22},{25.05,45.76},{25.26,46.21},{25.46,46.65},{25.58,46.96},{25.8,47.59},{26.04,48.19},{26.29,48.76},{26.55,49.24},{27.25,49.79},{27.83,49.99},{28.59,50.41},{29.68,51.07},{30.82,51.76},{31.42,51.86},{31.94,51.97},{32.72,52.07},{33.95,52.18},{34.84,52.32},{36.31,52.67},{37.22,53.03},{37.9,53.37},{38.35,53.57},{38.98,54.28},{39.41,54.71},{40.97,54.91},{42.08,54.95},{43.02,55.08},{43.97,56.59},{44.85,58.1},{45.3,58.95},{45.8,59.2},{46.66,59.85},{47.6,59.72},{48.44,59.3},{49.14,59.28},{49.61,59.3},{50.43,59.5},{50.94,60.22},{51.31,60.7},{52.01,61.4},{52.79,61.58},{53.71,61.87},{54.53,62.1},{55.12,62.28},{55.49,62.46},{55.94,62.72},{56.51,63.01},{57.25,62.77},{57.64,62.81},{58.12,62.94},{58.72,63.09},{59.12,63.0},{59.55,62.66},{60.02,61.98},{60.59,61.19},{61.0,60.26},{61.06,59.84},{60.91,59.52},{60.92,59.56},{60.78,60.29},{60.69,60.86},{60.42,61.36},{60.29,61.56},{59.95,62.08},{59.74,62.38},{59.49,62.71},{59.22,62.9},{58.87,63.05},{58.68,63.04},{58.29,62.98},{57.92,62.83},{57.29,62.68},{56.56,63.0},{55.83,62.62},{55.17,62.27},{54.66,62.04},{54.03,61.87},{53.06,61.62},},[267]={{99.7,83.82},{98.72,83.69},{97.73,83.58},{96.75,83.52},{95.42,83.27},{94.9,83.05},{93.98,82.51},{93.21,82.04},{92.29,81.52},{91.5,81.07},{90.97,80.89},{90.24,80.25},{89.85,79.46},{89.49,78.64},{88.88,77.08},{88.63,76.56},{87.9,75.34},{87.46,74.61},{86.98,73.36},{86.67,71.96},{86.44,70.98},{86.26,69.87},{86.08,68.66},{86.03,67.84},{86.01,66.66},{85.98,65.51},{85.88,63.99},{85.74,62.82},{85.49,62.28},{85.97,65.83},{85.87,63.67},{85.78,62.86},{85.44,62.12},{85.02,61.27},{84.48,60.28},{84.14,59.75},{83.96,59.47},{83.1,58.25},{82.59,57.61},{82.11,57.07},{81.64,56.58},{81.25,56.13},{80.87,55.75},{80.16,55.16},{79.48,54.86},{78.88,54.44},{78.24,53.98},{77.68,53.6},{77.3,53.32},{76.7,52.63},{76.4,52.26},{76.09,51.87},{75.32,50.98},{74.6,50.15},{73.56,49.12},{72.47,48.18},{71.0,47.18},{70.04,46.57},{68.96,46.05},{68.01,45.41},{67.48,44.83},{67.08,44.29},{66.73,43.76},{66.54,43.51},{66.11,42.97},{65.5,42.34},{64.64,42.08},{64.0,41.94},{63.27,41.76},{62.82,41.58},{62.32,41.39},{61.68,40.96},{61.16,40.48},{60.89,40.15},{60.52,39.71},{60.23,39.35},{59.75,38.77},{58.71,37.61},{57.72,36.61},{57.41,35.65},{57.27,35.15},{57.0,34.18},{56.76,33.11},{56.53,32.03},{56.34,30.99},{56.1,29.92},{55.97,28.94},{55.84,27.87},{55.76,26.65},{55.74,25.48},{55.69,24.43},{55.66,23.59},{55.72,22.68},{55.77,21.36},{55.75,20.52},{55.7,19.73},{56.37,19.66},{56.91,19.85},{57.53,19.71},{58.27,19.49},{58.71,20.02},{59.04,20.69},{59.28,21.06},{59.88,21.28},{60.41,21.13},{60.82,20.54},{61.37,20.02},{62.26,20.35},{61.58,20.14},{61.41,20.01},{61.01,20.24},{60.77,20.63},{60.45,21.07},{60.04,21.26},{59.64,21.18},{59.33,21.03},{59.05,20.68},{58.82,20.17},{58.54,19.81},{58.16,19.52},{57.64,19.67},{57.29,19.76},{57.02,19.79},{56.77,19.81},{56.32,19.59},{56.0,19.6},{55.75,20.73},{55.76,21.5},{55.74,22.72},{55.64,23.57},{55.69,24.9},{55.7,25.89},{55.76,27.22},{55.85,28.02},{56.07,29.88},{56.24,30.5},{56.42,31.53},{56.58,32.4},{56.82,33.49},{57.01,34.19},{57.18,34.78},{57.36,35.45},{57.57,36.11},{57.75,36.71},{58.13,37.09},{59.03,37.98},{59.43,38.4},{60.02,39.17},{60.77,40.07},{61.13,40.49},{61.52,40.87},{62.05,41.26},{62.42,41.45},{62.85,41.62},{63.28,41.78},{63.68,41.89},{64.73,42.09},{65.75,42.6},{66.52,43.48},{66.79,43.94},{67.26,44.6},{67.81,45.24},{68.82,45.93},{69.77,46.41},{70.3,46.7},{71.5,47.55},{72.42,48.14},{73.05,48.68},{73.83,49.38},{74.46,49.93},{75.05,50.64},{75.49,51.18},{75.94,51.68},{76.38,52.15},{76.98,52.92},{77.45,53.42},{78.22,53.98},{78.71,54.34},{79.44,54.83},{79.34,55.12},{80.26,55.3},{80.86,55.74},{81.39,56.29},{82.1,57.05},{82.93,58.03},{83.63,58.95},{84.1,59.77},{84.7,60.67},{85.27,61.85},{85.74,63.08},{85.83,63.93},{85.94,64.87},{86.01,65.61},{85.97,67.32},{86.01,68.2},{86.12,69.31},{86.28,70.18},{86.49,71.28},{86.7,72.21},{86.88,73.09},{87.1,73.81},{87.35,74.44},{87.88,75.27},{88.25,75.87},{88.6,76.48},{88.83,76.99},{89.06,77.48},{89.19,77.83},{89.44,78.54},{89.72,79.22},{89.99,79.85},{90.29,80.4},{91.07,81.01},{91.72,81.24},{92.58,81.71},{93.81,82.45},{95.09,83.24},{95.77,83.35},{96.35,83.46},{97.23,83.58},{98.6,83.7},{99.61,83.86},},[47]={{3.08,99.63},{2.93,98.63},{2.89,97.95},{2.87,96.97},{2.85,96.01},{2.77,94.74},{2.65,93.77},{2.44,93.33},{2.84,96.27},{2.76,94.48},{2.68,93.8},{2.4,93.19},{2.05,92.49},{1.6,91.66},{1.32,91.22},{1.17,90.99},{0.46,89.97},{0.03,89.44},{0.31,89.79},{0.89,90.55},{1.29,91.23},{1.78,91.99},{2.26,92.97},{2.65,93.99},{2.73,94.7},{2.81,95.48},{2.87,96.09},{2.84,97.52},{2.87,98.24},{2.97,99.17},{3.1,99.89},},[36]={{55.5,99.67},{55.34,99.1},{55.02,97.99},{54.75,96.77},{54.48,95.53},{54.27,94.34},{54.0,93.12},{53.84,92.0},{53.7,90.78},{53.6,89.39},{53.58,88.05},{53.53,86.85},{53.49,85.89},{53.56,84.85},{53.61,83.34},{53.59,82.38},{53.53,81.47},{54.3,81.39},{54.92,81.61},{55.63,81.45},{56.47,81.2},{56.98,81.81},{57.36,82.57},{57.63,83.0},{58.32,83.25},{58.92,83.08},{59.39,82.4},{60.02,81.81},{61.04,82.19},{60.26,81.94},{60.07,81.79},{59.61,82.06},{59.33,82.51},{58.97,83.01},{58.5,83.22},{58.04,83.13},{57.68,82.96},{57.37,82.56},{57.1,81.98},{56.79,81.57},{56.35,81.24},{55.75,81.41},{55.35,81.51},{55.04,81.54},{54.76,81.57},{54.25,81.32},{53.88,81.33},{53.59,82.62},{53.61,83.5},{53.59,84.89},{53.47,85.87},{53.52,87.39},{53.54,88.51},{53.61,90.04},{53.71,90.95},{53.96,93.08},{54.15,93.79},{54.36,94.96},{54.54,95.96},{54.82,97.21},{55.04,98.01},{55.23,98.68},{55.43,99.44},},[130]={{99.99,70.47},{99.81,69.64},{99.67,68.85},{99.49,68.03},{99.39,67.29},{99.29,66.47},{99.23,65.54},{99.21,64.65},{99.18,63.85},{99.15,63.21},{99.2,62.52},{99.23,61.51},{99.22,60.87},{99.18,60.27},{99.69,60.21},{100.0,60.33},{99.66,60.17},{99.41,60.17},{99.22,61.03},{99.23,61.62},{99.22,62.55},{99.14,63.2},{99.17,64.21},{99.18,64.96},{99.23,65.98},{99.3,66.58},{99.46,68.01},{99.59,68.48},{99.73,69.26},{99.85,69.93},},},45,nil,nil,83,"H",},
[2715] = {'Dustbelcher Brute',1678,1753,39,40,0,{[3]={{29.65,57.42},{62.91,69.57},},},nil,3,nil,nil,45,nil,},
[2716] = {'Dustbelcher Wyrmhunter',1829,1902,40,41,0,{[3]={{12.53,74.36},{12.8,73.66},{12.2,76.05},{8.02,72.29},{8.15,78.21},{10.59,77.63},{10.61,73.94},},},{[1]={{85.23,99.42},{85.53,99.89},{90.68,99.44},{91.32,98.59},{91.98,98.09},{92.5,98.11},{93.11,98.39},{94.04,98.43},{94.67,98.34},{95.52,98.16},{96.15,98.02},{96.65,97.92},{97.5,97.75},{98.14,97.72},{98.99,97.73},{99.84,97.75},{99.89,88.68},{99.31,89.05},{98.39,89.63},{97.65,90.26},{97.3,90.62},{96.7,91.25},{96.28,91.64},{95.88,91.42},{95.48,91.19},{95.28,91.08},{94.72,90.92},{94.46,90.94},{94.13,90.84},{93.47,90.48},{93.06,90.32},{92.44,90.09},{92.05,90.0},{91.62,89.95},{91.29,89.95},{90.91,90.03},{90.49,90.14},{89.76,90.68},{89.33,90.64},{88.59,90.57},{88.5,90.86},{88.28,91.54},{87.98,91.99},{87.63,92.66},{86.94,93.36},{86.94,93.36},{86.59,93.72},{85.99,94.22},{85.52,94.21},{85.46,94.39},{85.12,95.37},{84.63,96.22},{84.69,97.14},{84.66,98.36},{84.76,98.58},{84.9,98.85},{85.23,99.42},{85.53,99.89},{90.68,99.44},{91.32,98.59},{91.98,98.09},{92.5,98.11},{93.11,98.39},{94.04,98.43},{94.67,98.34},{95.52,98.16},{96.15,98.02},{96.65,97.92},{97.5,97.75},{98.14,97.72},{98.99,97.73},{99.84,97.75},{99.89,88.68},{99.31,89.05},{98.39,89.63},{97.65,90.26},{97.3,90.62},{96.7,91.25},{96.28,91.64},{95.88,91.42},{95.48,91.19},{95.28,91.08},{94.72,90.92},{94.46,90.94},{94.13,90.84},{93.47,90.48},{93.06,90.32},{92.44,90.09},{92.05,90.0},{91.62,89.95},{91.29,89.95},{90.91,90.03},{90.49,90.14},{89.76,90.68},{89.33,90.64},{88.59,90.57},{88.5,90.86},{88.28,91.54},{87.98,91.99},{87.63,92.66},{86.94,93.36},{86.94,93.36},{86.59,93.72},{85.99,94.22},{85.52,94.21},{85.46,94.39},{85.12,95.37},{84.63,96.22},{84.69,97.14},{84.66,98.36},{84.76,98.58},{84.9,98.85},},[3]={{12.72,75.48},{13.32,76.41},{13.93,77.28},{14.68,78.03},{16.11,78.29},{16.95,78.41},{18.21,78.5},{19.37,78.3},{20.12,78.49},{21.58,77.97},{22.23,77.17},{23.51,75.51},{24.77,73.83},{26.07,72.85},{27.1,72.89},{28.32,73.45},{30.15,73.53},{31.41,73.34},{33.08,72.99},{34.34,72.72},{35.33,72.52},{37.01,72.17},{38.27,72.11},{39.96,72.13},{41.65,72.17},{43.33,72.26},{44.46,72.58},{45.91,72.71},{46.8,71.75},{48.15,72.73},{49.22,73.74},{50.39,73.71},{51.21,73.4},{53.28,72.8},{54.95,72.53},{56.63,72.31},{58.31,72.06},{59.15,71.91},{60.75,70.77},{61.54,69.91},{61.45,69.3},{61.14,67.46},{60.14,65.45},{59.13,64.3},{57.78,62.79},{56.77,61.64},{55.75,60.51},{54.74,59.37},{54.05,58.64},{52.72,57.35},{52.24,54.92},{52.56,53.09},{52.49,51.29},{51.81,50.2},{50.76,49.14},{49.68,48.82},{48.84,48.67},{47.5,49.11},{46.55,50.22},{45.61,51.5},{44.09,52.75},{42.92,53.48},{41.75,54.22},{40.59,54.96},{38.78,56.1},{37.31,57.34},{36.61,58.07},{35.42,59.31},{34.59,60.09},{33.8,59.64},{33.01,59.19},{32.62,58.97},{31.51,58.66},{31.0,58.69},{30.33,58.49},{29.04,57.78},{28.22,57.47},{26.99,57.02},{26.21,56.84},{25.37,56.74},{24.72,56.74},{23.95,56.89},{23.12,57.11},{21.68,58.19},{20.84,58.1},{19.38,57.97},{19.19,58.54},{18.76,59.89},{18.16,60.77},{17.46,62.09},{16.1,63.49},{16.1,63.49},{15.4,64.21},{14.22,65.19},{13.29,65.17},{13.17,65.53},{12.5,67.46},{11.53,69.16},{11.66,70.97},{11.58,73.38},{11.78,73.83},{12.05,74.36},{12.72,75.48},{13.32,76.41},{13.93,77.28},{14.68,78.03},{16.11,78.29},{16.95,78.41},{18.21,78.5},{19.37,78.3},{20.12,78.49},{21.58,77.97},{22.23,77.17},{23.51,75.51},{24.77,73.83},{26.07,72.85},{27.1,72.89},{28.32,73.45},{30.15,73.53},{31.41,73.34},{33.08,72.99},{34.34,72.72},{35.33,72.52},{37.01,72.17},{38.27,72.11},{39.96,72.13},{41.65,72.17},{43.33,72.26},{44.46,72.58},{45.91,72.71},{46.8,71.75},{48.15,72.73},{49.22,73.74},{50.39,73.71},{51.21,73.4},{53.28,72.8},{54.95,72.53},{56.63,72.31},{58.31,72.06},{59.15,71.91},{60.75,70.77},{61.54,69.91},{61.45,69.3},{61.14,67.46},{60.14,65.45},{59.13,64.3},{57.78,62.79},{56.77,61.64},{55.75,60.51},{54.74,59.37},{54.05,58.64},{52.72,57.35},{52.24,54.92},{52.56,53.09},{52.49,51.29},{51.81,50.2},{50.76,49.14},{49.68,48.82},{48.84,48.67},{47.5,49.11},{46.55,50.22},{45.61,51.5},{44.09,52.75},{42.92,53.48},{41.75,54.22},{40.59,54.96},{38.78,56.1},{37.31,57.34},{36.61,58.07},{35.42,59.31},{34.59,60.09},{33.8,59.64},{33.01,59.19},{32.62,58.97},{31.51,58.66},{31.0,58.69},{30.33,58.49},{29.04,57.78},{28.22,57.47},{26.99,57.02},{26.21,56.84},{25.37,56.74},{24.72,56.74},{23.95,56.89},{23.12,57.11},{21.68,58.19},{20.84,58.1},{19.38,57.97},{19.19,58.54},{18.76,59.89},{18.16,60.77},{17.46,62.09},{16.1,63.49},{16.1,63.49},{15.4,64.21},{14.22,65.19},{13.29,65.17},{13.17,65.53},{12.5,67.46},{11.53,69.16},{11.66,70.97},{11.58,73.38},{11.78,73.83},{12.05,74.36},},[46]={{72.68,5.64},{73.19,6.43},{73.71,7.17},{74.35,7.81},{75.55,8.03},{76.27,8.12},{77.34,8.2},{78.33,8.03},{78.97,8.2},{80.2,7.75},{80.76,7.07},{81.84,5.67},{82.92,4.24},{84.02,3.41},{84.89,3.43},{85.93,3.91},{87.48,3.98},{88.55,3.82},{89.97,3.52},{91.04,3.29},{91.88,3.12},{93.3,2.83},{94.38,2.78},{95.81,2.8},{97.24,2.82},{98.68,2.91},{99.64,3.17},{71.67,0.27},{71.78,1.81},{71.71,3.85},{71.88,4.24},{72.11,4.69},{72.68,5.64},{73.19,6.43},{73.71,7.17},{74.35,7.81},{75.55,8.03},{76.27,8.12},{77.34,8.2},{78.33,8.03},{78.97,8.2},{80.2,7.75},{80.76,7.07},{81.84,5.67},{82.92,4.24},{84.02,3.41},{84.89,3.43},{85.93,3.91},{87.48,3.98},{88.55,3.82},{89.97,3.52},{91.04,3.29},{91.88,3.12},{93.3,2.83},{94.38,2.78},{95.81,2.8},{97.24,2.82},{98.68,2.91},{99.64,3.17},{71.67,0.27},{71.78,1.81},{71.71,3.85},{71.88,4.24},{72.11,4.69},},[51]={{92.89,70.0},{93.56,71.04},{94.24,72.01},{95.08,72.85},{96.67,73.14},{97.6,73.26},{99.01,73.37},{99.63,52.62},{98.96,53.61},{98.18,55.08},{96.66,56.64},{96.66,56.64},{95.88,57.43},{94.57,58.53},{93.53,58.51},{93.4,58.91},{92.65,61.06},{91.57,62.95},{91.71,64.98},{91.62,67.66},{91.84,68.16},{92.15,68.76},{92.89,70.0},{93.56,71.04},{94.24,72.01},{95.08,72.85},{96.67,73.14},{97.6,73.26},{99.01,73.37},{99.63,52.62},{98.96,53.61},{98.18,55.08},{96.66,56.64},{96.66,56.64},{95.88,57.43},{94.57,58.53},{93.53,58.51},{93.4,58.91},{92.65,61.06},{91.57,62.95},{91.71,64.98},{91.62,67.66},{91.84,68.16},{92.15,68.76},},},3,nil,nil,45,nil,},
[2717] = {'Dustbelcher Mauler',1902,1981,41,42,0,{[3]={{9.43,75.66},{12.99,73.69},{10.74,75.86},{13.69,74.08},{13.95,75.97},{13.5,75.48},{9.63,83.86},{9.94,81.96},{9.43,80.5},{8.0,82.04},{7.99,73.84},},},{[1]={{85.3,99.24},{85.44,99.56},{85.59,99.98},{90.5,99.99},{90.62,99.73},{91.0,98.95},{91.48,98.32},{91.77,98.18},{92.52,98.22},{92.92,98.4},{93.7,98.4},{94.14,98.5},{94.76,98.75},{95.13,98.53},{95.64,98.13},{96.23,97.95},{96.85,97.74},{97.48,97.57},{98.33,97.53},{98.97,97.61},{99.8,97.75},{99.43,89.13},{98.61,89.51},{97.66,90.23},{97.31,90.6},{96.78,91.23},{96.24,91.54},{95.8,91.22},{95.45,91.06},{95.24,91.0},{94.42,90.94},{94.08,90.79},{93.64,90.5},{93.01,90.29},{92.59,90.18},{91.96,90.07},{91.38,90.24},{91.0,90.31},{90.62,90.2},{90.03,90.45},{89.63,90.67},{88.6,90.58},{88.42,91.06},{88.26,91.54},{87.83,92.25},{87.51,92.83},{86.94,93.34},{86.46,93.86},{86.02,94.2},{85.48,94.21},{85.34,94.89},{85.05,95.4},{84.64,96.33},{84.63,96.92},{84.67,97.96},{84.8,98.59},{85.08,98.66},},[3]={{12.85,75.12},{13.13,75.76},{13.43,76.59},{14.06,77.35},{14.81,77.94},{15.31,78.09},{16.95,78.43},{17.98,78.61},{18.55,78.38},{20.37,78.55},{21.32,78.23},{22.14,77.96},{23.15,76.62},{23.4,76.11},{24.13,74.56},{25.09,73.31},{25.67,73.04},{27.14,73.1},{27.95,73.46},{29.48,73.46},{30.36,73.66},{31.59,74.16},{32.32,73.73},{33.34,72.92},{34.49,72.56},{35.73,72.17},{36.97,71.82},{38.66,71.74},{39.92,71.91},{41.56,72.19},{43.24,72.25},{44.18,72.45},{45.43,72.73},{46.77,72.32},{48.52,72.47},{49.33,72.81},{49.74,72.96},{50.98,73.3},{52.05,73.33},{53.95,72.85},{55.77,72.33},{57.03,72.22},{58.72,71.99},{59.84,71.55},{61.46,69.75},{61.24,68.79},{60.13,66.89},{59.0,65.0},{58.19,63.54},{57.04,61.89},{55.86,60.35},{55.25,59.48},{54.7,58.52},{53.91,57.04},{53.07,55.68},{52.34,54.79},{52.56,53.32},{52.49,51.58},{51.29,49.83},{49.95,48.76},{49.53,48.68},{47.54,49.0},{46.47,50.3},{45.3,51.9},{43.36,53.17},{42.35,54.15},{40.82,55.12},{39.21,55.87},{37.33,57.29},{36.64,58.02},{35.58,59.26},{34.52,59.88},{33.64,59.24},{32.96,58.94},{32.54,58.82},{30.91,58.7},{30.24,58.4},{29.36,57.82},{28.12,57.41},{27.29,57.18},{26.04,56.98},{24.9,57.31},{24.14,57.44},{23.38,57.24},{22.22,57.72},{21.42,58.16},{19.39,57.98},{19.03,58.93},{18.71,59.87},{17.87,61.29},{17.22,62.44},{16.1,63.44},{15.14,64.47},{14.28,65.14},{13.21,65.17},{12.93,66.52},{12.37,67.52},{11.55,69.36},{11.53,70.53},{11.61,72.58},{11.87,73.84},{12.43,73.98},},[46]={{72.79,5.33},{73.03,5.88},{73.28,6.58},{73.82,7.23},{74.45,7.73},{74.88,7.86},{76.28,8.14},{77.15,8.3},{77.63,8.1},{79.18,8.24},{79.98,7.97},{80.68,7.74},{81.54,6.6},{81.75,6.17},{82.37,4.85},{83.18,3.79},{83.68,3.56},{84.93,3.61},{85.61,3.92},{86.91,3.92},{87.66,4.09},{88.7,4.51},{89.32,4.15},{90.19,3.47},{91.17,3.16},{92.22,2.82},{93.28,2.53},{94.71,2.46},{95.78,2.6},{97.17,2.84},{98.6,2.89},{99.39,3.06},{71.69,0.44},{71.67,1.43},{71.74,3.18},{71.96,4.25},{72.43,4.36},},[51]={{93.03,69.6},{93.35,70.32},{93.69,71.24},{94.39,72.09},{95.22,72.75},{95.78,72.92},{97.61,73.29},{98.76,73.5},{99.39,73.23},{99.93,51.55},{99.57,52.6},{98.63,54.18},{97.91,55.47},{96.66,56.58},{95.59,57.73},{94.63,58.48},{93.44,58.5},{93.13,60.01},{92.5,61.13},{91.59,63.18},{91.56,64.49},{91.66,66.78},{91.95,68.18},{92.57,68.33},},},3,nil,nil,45,nil,},
[2718] = {'Dustbelcher Shaman',1585,1648,42,43,0,{[3]={{8.35,76.18},{12.28,74.85},{13.65,74.97},{9.41,86.29},{10.98,80.13},{9.53,77.84},{8.14,83.9},},},{[1]={{85.3,99.24},{85.44,99.56},{85.59,99.98},{90.5,99.99},{90.62,99.73},{91.0,98.95},{91.48,98.32},{91.77,98.18},{92.52,98.22},{92.92,98.4},{93.7,98.4},{94.14,98.5},{94.76,98.75},{95.13,98.53},{95.64,98.13},{96.23,97.95},{96.85,97.74},{97.48,97.57},{98.33,97.53},{98.97,97.61},{99.8,97.75},{99.43,89.13},{98.61,89.51},{97.66,90.23},{97.31,90.6},{96.78,91.23},{96.24,91.54},{95.8,91.22},{95.45,91.06},{95.24,91.0},{94.42,90.94},{94.08,90.79},{93.64,90.5},{93.01,90.29},{92.59,90.18},{91.96,90.07},{91.38,90.24},{91.0,90.31},{90.62,90.2},{90.03,90.45},{89.63,90.67},{88.6,90.58},{88.42,91.06},{88.26,91.54},{87.83,92.25},{87.51,92.83},{86.94,93.34},{86.46,93.86},{86.02,94.2},{85.48,94.21},{85.34,94.89},{85.05,95.4},{84.64,96.33},{84.63,96.92},{84.67,97.96},{84.8,98.59},{85.08,98.66},},[3]={{12.85,75.12},{13.13,75.76},{13.43,76.59},{14.06,77.35},{14.81,77.94},{15.31,78.09},{16.95,78.43},{17.98,78.61},{18.55,78.38},{20.37,78.55},{21.32,78.23},{22.14,77.96},{23.15,76.62},{23.4,76.11},{24.13,74.56},{25.09,73.31},{25.67,73.04},{27.14,73.1},{27.95,73.46},{29.48,73.46},{30.36,73.66},{31.59,74.16},{32.32,73.73},{33.34,72.92},{34.49,72.56},{35.73,72.17},{36.97,71.82},{38.66,71.74},{39.92,71.91},{41.56,72.19},{43.24,72.25},{44.18,72.45},{45.43,72.73},{46.77,72.32},{48.52,72.47},{49.33,72.81},{49.74,72.96},{50.98,73.3},{52.05,73.33},{53.95,72.85},{55.77,72.33},{57.03,72.22},{58.72,71.99},{59.84,71.55},{61.46,69.75},{61.24,68.79},{60.13,66.89},{59.0,65.0},{58.19,63.54},{57.04,61.89},{55.86,60.35},{55.25,59.48},{54.7,58.52},{53.91,57.04},{53.07,55.68},{52.34,54.79},{52.56,53.32},{52.49,51.58},{51.29,49.83},{49.95,48.76},{49.53,48.68},{47.54,49.0},{46.47,50.3},{45.3,51.9},{43.36,53.17},{42.35,54.15},{40.82,55.12},{39.21,55.87},{37.33,57.29},{36.64,58.02},{35.58,59.26},{34.52,59.88},{33.64,59.24},{32.96,58.94},{32.54,58.82},{30.91,58.7},{30.24,58.4},{29.36,57.82},{28.12,57.41},{27.29,57.18},{26.04,56.98},{24.9,57.31},{24.14,57.44},{23.38,57.24},{22.22,57.72},{21.42,58.16},{19.39,57.98},{19.03,58.93},{18.71,59.87},{17.87,61.29},{17.22,62.44},{16.1,63.44},{15.14,64.47},{14.28,65.14},{13.21,65.17},{12.93,66.52},{12.37,67.52},{11.55,69.36},{11.53,70.53},{11.61,72.58},{11.87,73.84},{12.43,73.98},},[46]={{72.79,5.33},{73.03,5.88},{73.28,6.58},{73.82,7.23},{74.45,7.73},{74.88,7.86},{76.28,8.14},{77.15,8.3},{77.63,8.1},{79.18,8.24},{79.98,7.97},{80.68,7.74},{81.54,6.6},{81.75,6.17},{82.37,4.85},{83.18,3.79},{83.68,3.56},{84.93,3.61},{85.61,3.92},{86.91,3.92},{87.66,4.09},{88.7,4.51},{89.32,4.15},{90.19,3.47},{91.17,3.16},{92.22,2.82},{93.28,2.53},{94.71,2.46},{95.78,2.6},{97.17,2.84},{98.6,2.89},{99.39,3.06},{71.69,0.44},{71.67,1.43},{71.74,3.18},{71.96,4.25},{72.43,4.36},},[51]={{93.03,69.6},{93.35,70.32},{93.69,71.24},{94.39,72.09},{95.22,72.75},{95.78,72.92},{97.61,73.29},{98.76,73.5},{99.39,73.23},{99.93,51.55},{99.57,52.6},{98.63,54.18},{97.91,55.47},{96.66,56.58},{95.59,57.73},{94.63,58.48},{93.44,58.5},{93.13,60.01},{92.5,61.13},{91.59,63.18},{91.56,64.49},{91.66,66.78},{91.95,68.18},{92.57,68.33},},},3,nil,nil,45,nil,},
[2719] = {'Dustbelcher Lord',2138,2218,44,45,0,{[3]={{6.53,90.64},{7.59,90.4},{9.7,93.03},{9.93,92.33},{7.59,95.56},{7.09,94.53},{7.85,94.25},},},nil,3,nil,nil,45,nil,},
[2720] = {'Dustbelcher Ogre Mage',1441,1496,43,44,0,{[3]={{7.1,90.78},{7.66,89.53},{8.0,92.38},{8.55,88.25},{8.06,90.89},{7.57,85.7},{8.64,91.0},{7.85,88.13},{9.62,89.29},{9.68,88.25},},},nil,3,nil,nil,45,nil,},
[2721] = {'Forsaken Bodyguard',610,610,35,35,0,{[45]={{52.56,61.54},{52.63,61.68},{52.72,61.57},{52.65,61.43},},},nil,45,nil,nil,83,"H",},
[2723] = {'Stone Golem',1674,1751,38,39,0,{[3]={{40.18,27.3},{40.67,26.49},{39.75,27.59},{41.69,26.67},{41.57,28.23},},},nil,3,nil,nil,54,nil,},
[2725] = {'Scalding Whelp',1522,1648,41,43,0,{[3]={{81.4,30.71},{84.54,28.6},{81.39,30.09},{85.73,28.55},{85.7,27.81},{84.77,29.81},{83.71,30.51},{80.66,37.38},{81.44,32.66},{82.1,39.05},{83.22,32.67},{84.12,39.65},{82.42,34.56},{76.32,32.66},{77.94,34.38},{79.36,35.57},{82.74,42.87},{72.16,64.64},{83.25,33.67},{79.86,56.72},{72.34,57.38},{69.67,53.81},{72.82,52.44},{71.08,51.7},{73.22,62.94},{74.23,67.63},{77.22,63.4},{75.23,65.95},},},nil,3,nil,nil,16,nil,},
[2726] = {'Scorched Guardian',5148,5544,43,45,1,{[3]={{84.68,55.85},{81.83,47.93},{82.08,51.75},{83.19,53.5},{79.69,47.86},{80.42,53.59},{79.23,52.29},{81.03,45.47},{82.21,55.77},{80.34,50.02},{77.44,53.8},{83.27,57.7},},},nil,3,nil,nil,16,nil,},
[2727] = {'Crag Coyote',1403,1469,35,36,0,{[3]={{49.77,46.24},{48.39,49.79},{48.49,34.5},{49.79,41.5},{49.65,46.13},{51.22,50.9},{52.75,39.24},{58.09,46.49},{46.87,48.33},{48.85,42.42},{53.71,47.99},{48.31,37.98},{47.83,39.77},{46.68,44.14},{50.26,40.01},{50.97,38.08},{46.86,35.96},{50.16,35.24},{49.87,41.92},{55.04,49.94},{52.87,14.63},{52.38,24.69},{55.04,48.1},{54.88,24.81},{52.33,20.55},{53.79,17.5},{53.74,22.18},{53.18,52.03},},},nil,3,nil,nil,38,nil,},
[2728] = {'Feral Crag Coyote',1536,1604,37,38,0,{[3]={{56.35,67.97},{52.41,60.64},{55.51,67.23},{60.4,71.69},{59.23,70.81},{63.1,51.32},{61.68,49.73},{57.82,68.24},{60.71,63.29},{59.46,67.83},{55.3,68.51},{45.9,73.47},{60.77,48.07},{59.07,51.86},{57.85,59.85},{60.15,60.51},{58.0,63.92},{53.0,56.65},{57.98,56.52},{58.78,54.32},{58.88,55.51},{59.33,60.49},{53.48,58.17},{55.56,53.83},{60.58,55.66},{55.19,58.29},{56.2,59.03},{61.62,65.68},{55.52,56.68},{60.87,50.21},{56.66,60.97},{53.42,51.92},{53.51,61.33},{55.0,63.76},{54.23,74.7},{58.83,50.45},{48.65,76.25},{44.41,71.99},{55.02,52.02},},},nil,3,nil,nil,38,nil,},
[2729] = {'Elder Crag Coyote',1678,1753,38,40,0,{[3]={{41.58,71.37},{32.57,59.6},{40.06,68.58},{37.35,57.76},{35.89,61.08},{38.72,69.85},{37.86,69.13},{31.81,73.64},{37.58,62.99},{37.93,66.78},{35.74,73.51},{39.19,67.41},{18.78,53.9},{34.64,61.63},{33.44,54.48},{29.42,68.01},{31.09,60.15},{28.28,72.13},{29.72,64.11},{11.18,63.12},{32.5,57.84},{34.34,70.24},{10.37,67.05},{35.0,64.29},{26.36,53.02},{10.5,63.7},{33.61,71.12},{13.51,63.77},{12.88,67.37},{16.86,65.69},{27.48,60.4},{22.78,58.17},{20.91,56.85},{28.25,47.6},{24.31,58.57},{14.12,68.11},{12.91,65.83},{25.49,56.03},{30.67,62.31},{30.66,74.21},{30.09,63.84},{21.41,56.33},{30.99,70.91},{32.4,66.18},{27.35,62.23},{23.32,51.59},},},nil,3,nil,nil,38,nil,},
[2730] = {'Rabid Crag Coyote',1981,2059,42,43,0,{[3]={{70.3,33.65},{69.04,30.76},{69.36,36.22},{71.48,34.79},{70.28,32.76},{72.68,33.39},},},nil,3,nil,nil,38,nil,},
[2731] = {'Ridge Stalker',1469,1536,36,37,0,{[3]={{60.61,30.48},{61.77,39.34},{38.11,46.45},{65.33,37.05},{65.77,37.51},{33.48,43.29},{45.21,40.52},{33.59,40.94},{61.99,29.93},{60.64,43.75},{62.64,46.34},{36.12,43.29},{44.78,35.68},{63.08,29.62},{61.78,40.19},{57.11,28.28},{34.74,41.75},{46.17,37.58},{59.09,25.58},{42.86,40.23},{43.65,38.33},{53.82,15.46},{40.11,37.71},{35.13,40.37},{55.18,15.09},},},nil,3,nil,nil,16,nil,},
[2732] = {'Ridge Huntress',1604,1678,38,39,0,{[3]={{49.64,60.11},{41.37,50.97},{36.85,49.41},{56.66,74.95},{56.42,45.8},{65.01,68.4},{48.26,52.53},{59.24,45.95},{45.86,46.6},{40.26,61.51},{43.64,74.2},{40.37,64.11},{40.5,58.28},{32.19,49.93},{41.09,63.25},{60.68,62.25},{34.13,49.14},{53.6,39.48},{44.47,47.64},{47.56,51.85},{41.51,67.01},{63.07,73.73},{50.19,57.13},{63.12,64.36},{51.75,58.1},{44.39,72.85},{30.12,49.9},{43.2,69.51},{46.68,49.74},{30.04,45.54},{31.49,51.62},{31.78,46.86},{30.62,47.87},{35.51,55.99},{39.43,60.0},{46.89,76.73},{39.87,73.14},{53.81,45.94},{34.79,51.21},{49.48,58.37},{41.65,59.93},{36.92,49.86},},},nil,3,nil,nil,16,nil,},
[2733] = {'Apothecary Jorell',1469,1469,36,36,0,{[45]={{60.09,59.32},},},nil,45,nil,nil,83,"H",},
[2734] = {'Ridge Stalker Patriarch',1829,1902,40,41,0,{[3]={{15.21,51.77},{16.15,53.76},{8.38,57.82},{12.71,55.4},{19.86,72.5},{28.28,66.51},{19.46,70.43},{21.28,68.93},{25.88,64.01},{16.54,49.94},{10.35,58.82},{14.88,56.01},{25.68,71.45},{17.95,67.18},{26.08,74.72},{14.63,57.07},{20.32,62.03},{18.51,65.93},{25.36,79.32},{20.39,60.07},{22.86,60.22},{10.79,70.1},},},nil,3,nil,nil,16,nil,},
[2735] = {'Lesser Rock Elemental',1536,1678,37,39,0,{[3]={{15.07,37.57},{13.32,37.97},{13.14,39.2},{16.41,37.56},{21.33,44.1},{18.81,42.99},{21.2,45.88},{20.11,43.19},{17.69,41.3},{16.8,42.74},{14.74,41.8},{19.27,41.3},{21.6,47.86},{19.09,45.75},{23.1,47.75},{23.53,45.47},{20.15,47.94},{22.42,43.66},},},nil,3,nil,nil,91,nil,},
[2736] = {'Greater Rock Elemental',1981,2138,42,44,0,{[3]={{5.48,76.95},{6.94,80.15},{5.67,79.94},{2.77,78.22},{3.0,79.81},{4.13,77.33},{1.44,82.1},{4.11,79.91},{1.44,80.18},{2.88,82.18},{1.57,84.51},{3.74,82.18},{5.48,82.27},{0.93,78.67},{4.93,83.72},{6.65,73.85},{6.57,76.28},{15.97,90.15},{16.21,88.1},{16.16,85.47},{17.03,84.3},{14.65,86.34},{13.27,87.76},{15.02,88.01},{13.75,90.23},{13.37,86.12},{13.32,84.08},{14.74,90.46},},},nil,3,nil,nil,91,nil,},
[2737] = {'Durtham Greldon',2471,2471,40,40,0,{[1537]={{51.26,14.97},},},nil,1537,nil,nil,55,"A",},
[2738] = {'Stromgarde Cavalryman',3804,5380,36,37,1,{[45]={{33.4,51.95},{33.31,52.06},},},nil,45,nil,nil,123,"A",},
[2739] = {'Shadowforge Tunneler',1403,1469,35,36,0,{[3]={{52.44,31.17},{52.56,32.02},{54.06,33.44},{52.29,32.73},{53.34,32.65},{54.07,34.14},{53.43,33.44},{54.52,33.92},{51.89,31.79},{54.52,31.42},{53.72,30.69},},},{[3]={{53.3,32.74},{52.99,32.87},{52.44,32.31},{52.83,32.91},{53.66,33.34},{53.27,32.51},{53.12,31.54},{52.89,30.16},{53.05,31.42},{53.26,32.65},},},3,nil,nil,54,nil,},
[2740] = {'Shadowforge Darkweaver',1075,1116,36,37,0,{[3]={{53.75,32.32},{51.48,34.35},{53.58,31.1},{52.59,33.69},{53.29,34.31},{52.84,34.47},},},nil,3,nil,nil,54,nil,},
[2742] = {'Shadowforge Chanter',1305,1357,37,39,0,{[3]={{40.43,25.86},{39.65,27.76},{39.78,27.34},{43.93,31.28},{41.35,29.62},{40.62,28.87},{42.08,30.78},{42.54,27.51},{43.35,28.48},{41.86,26.96},{41.78,27.1},{42.03,27.0},{41.23,28.68},{40.88,28.92},},},nil,3,nil,nil,54,nil,},
[2743] = {'Shadowforge Warrior',1604,1678,38,39,0,{[3]={{41.54,33.72},{45.32,30.59},{44.22,29.46},{40.65,25.76},{40.63,25.91},{40.15,26.51},{42.62,33.11},{43.94,31.13},{44.03,31.07},{41.31,34.53},{40.82,29.48},{42.32,30.12},{40.99,29.18},{45.66,33.79},{43.1,30.53},{43.37,30.03},{42.68,29.62},{44.39,33.54},{44.46,31.63},{42.92,29.0},{42.21,26.95},{41.82,27.71},{40.79,29.18},},},{[1]={{99.38,74.31},{99.48,74.38},{99.55,74.28},{99.52,74.2},{99.41,74.07},{99.32,74.05},{99.23,74.25},{99.23,74.39},{99.19,74.56},{99.33,74.75},{99.19,74.58},{99.24,74.25},{99.33,74.07},{99.37,74.01},{99.41,74.06},{99.53,74.2},{99.56,74.27},{99.49,74.36},{99.43,76.2},{99.36,76.17},{99.28,76.07},{99.26,76.03},{99.26,75.96},{99.34,75.85},{99.37,75.8},{99.46,75.87},{99.55,75.71},{99.42,75.49},{99.55,75.72},{99.46,75.86},{99.32,75.84},{99.27,75.95},{99.25,76.02},{99.28,76.08},{99.37,76.17},{99.45,76.22},},[3]={{40.73,25.77},{40.94,25.92},{41.06,25.7},{41.01,25.56},{40.79,25.3},{40.61,25.25},{40.44,25.65},{40.44,25.92},{40.36,26.27},{40.64,26.65},{40.36,26.31},{40.46,25.66},{40.64,25.29},{40.72,25.17},{40.8,25.28},{41.02,25.56},{41.1,25.69},{40.95,25.87},{44.05,31.09},{44.38,31.38},{44.6,31.39},{45.16,31.32},{45.4,31.95},{45.33,32.52},{45.29,33.02},{45.6,33.57},{45.89,33.94},{46.3,34.36},{46.07,34.29},{45.6,33.75},{45.33,33.19},{45.31,32.47},{45.42,31.57},{44.86,31.21},{44.32,31.27},{40.84,29.5},{40.7,29.45},{40.53,29.25},{40.49,29.17},{40.5,29.03},{40.65,28.83},{40.71,28.73},{40.89,28.86},{41.06,28.54},{40.81,28.11},{41.07,28.57},{40.89,28.84},{40.62,28.8},{40.51,29.02},{40.48,29.16},{40.53,29.27},{40.71,29.46},{40.87,29.55},{44.65,31.54},{45.08,31.65},{45.17,32.24},{45.14,33.02},{45.29,33.63},{45.97,34.57},{45.42,33.96},{45.04,33.31},{45.14,32.79},{45.2,31.5},{44.82,31.5},{44.41,31.57},{43.81,30.83},{44.35,31.59},},[38]={{39.83,99.45},{40.01,99.58},{40.13,99.39},{40.08,99.26},{39.88,99.02},{39.72,98.98},{39.57,99.34},{39.56,99.58},{39.49,99.9},{39.49,99.94},{39.59,99.35},{39.75,99.02},{39.82,98.91},{39.89,99.0},{40.09,99.26},{40.16,99.37},{40.03,99.54},},},3,nil,nil,54,nil,},
[2744] = {'Shadowforge Commander',1752,1752,40,40,4,{[3]={{41.84,26.94},{40.27,26.28},{39.93,27.77},{40.74,28.86},},},nil,3,nil,nil,14,nil,},
[2745] = {'Ambassador Infernus',3963,3963,42,42,1,{[3]={{42.1,28.88},},},nil,3,nil,nil,54,nil,},
[2748] = {'Archaedas',29850,29850,47,47,1,{[1337]={{-1, -1}},},nil,1337,nil,nil,415,nil,},
[2749] = {'Siege Golem',5334,5334,40,40,2,{[3]={{19.86,56.58},{15.9,59.23},{11.58,59.14},{8.6,61.81},{5.49,59.53},{15.82,65.31},{19.07,60.63},{24.61,55.58},{24.53,50.11},{29.18,47.41},{31.47,50.02},{35.66,47.63},{36.25,41.73},{40.03,39.82},},},nil,3,nil,nil,91,nil,},
[2751] = {'War Golem',1469,1469,36,36,4,{[3]={{52.41,19.48},{49.38,12.06},{45.36,33.53},},},nil,3,nil,nil,91,nil,},
[2752] = {'Rumbler',2218,2218,45,45,4,{[3]={{14.73,89.33},{13.86,86.11},{4.77,81.78},{1.98,80.52},},},nil,3,nil,nil,91,nil,},
[2753] = {'Barnabus',1046,1046,38,38,4,{[3]={{46.25,74.33},{38.88,67.98},{55.84,67.75},},},nil,3,nil,nil,38,nil,},
[2754] = {'Anathemus',8316,8316,45,45,2,{[3]={{23.7,74.16},},},{[1]={{91.8,98.02},{92.55,97.17},{93.25,96.25},{94.16,95.68},{94.85,94.64},{95.27,93.24},{96.06,92.25},{97.19,90.69},{97.59,90.14},{99.08,89.27},{99.51,97.0},{98.32,95.6},{97.12,94.22},{95.59,93.11},{94.7,92.47},{93.96,91.3},{92.96,90.85},{91.78,90.31},{90.76,90.44},{89.53,90.59},{88.71,90.61},{88.38,91.48},{87.6,92.7},{86.53,93.8},{86.06,94.17},{85.87,94.66},{85.4,96.1},{85.45,97.26},{85.22,99.14},{90.68,99.49},{90.75,98.79},},[3]={{25.72,72.72},{27.21,71.02},{28.6,69.22},{30.4,68.08},{31.77,66.03},{32.6,63.24},{34.15,61.29},{36.4,58.2},{37.2,57.1},{40.13,55.38},{42.23,54.14},{44.09,52.73},{45.54,51.63},{47.04,49.39},{49.35,48.5},{51.65,50.09},{52.89,53.33},{53.17,57.73},{53.39,61.29},{53.01,64.63},{52.75,66.92},{52.98,69.35},{53.13,70.83},{52.1,73.64},{49.97,73.8},{48.46,72.89},{46.91,72.73},{45.17,72.13},{42.83,71.32},{41.0,70.69},{38.64,67.92},{36.26,65.18},{33.24,63.0},{31.46,61.72},{30.01,59.41},{28.02,58.51},{25.68,57.44},{23.66,57.7},{21.24,58.0},{19.6,58.04},{18.95,59.77},{17.41,62.18},{15.3,64.37},{14.35,65.08},{13.99,66.07},{13.06,68.91},{13.15,71.2},{12.69,74.93},{12.83,76.91},{13.96,78.32},{15.93,78.66},{17.86,78.85},{19.16,78.17},{20.7,78.5},{22.54,77.53},{23.16,76.9},{23.51,75.63},{23.64,74.24},},[46]={{83.72,3.29},{84.99,1.85},{86.17,0.32},{98.25,2.11},{96.69,1.57},{72.97,0.05},{73.04,2.0},{72.66,5.17},{72.77,6.85},{73.73,8.05},{75.4,8.34},{77.04,8.5},{78.15,7.92},{79.45,8.2},{81.02,7.38},{81.54,6.84},{81.84,5.76},{81.95,4.58},},[51]={{99.83,52.49},{98.12,55.18},{95.77,57.61},{94.71,58.41},{94.31,59.51},{93.27,62.67},{93.37,65.23},{92.86,69.39},{93.01,71.6},{94.28,73.16},{96.47,73.55},{98.62,73.76},},},3,nil,nil,778,nil,},
[2755] = {'Myzrael',11408,11408,44,44,1,nil,nil,0,nil,nil,7,"AH",},
[2757] = {'Blacklash',11075,11075,50,50,1,nil,nil,0,nil,nil,103,nil,},
[2759] = {'Hematus',13290,13290,50,50,1,nil,nil,0,nil,nil,103,nil,},
[2760] = {'Burning Exile',1604,1678,38,39,0,{[45]={{25.64,28.53},{26.33,28.34},{27.43,31.39},{24.37,29.48},{24.78,28.52},{26.48,30.99},{26.51,32.61},{26.43,29.69},{25.21,30.51},{25.64,29.82},{25.81,30.65},{24.59,32.75},{24.99,31.87},{24.38,30.52},},},nil,45,nil,nil,16,nil,},
[2761] = {'Cresting Exile',1305,1357,38,39,0,{[45]={{67.38,28.52},{65.36,31.01},{66.2,28.24},{65.3,28.82},{67.94,31.15},{66.79,30.83},{66.01,31.14},{67.04,31.13},{67.76,29.75},{67.07,29.85},{66.76,29.24},{66.56,29.9},{65.02,29.8},{67.98,28.04},},},nil,45,nil,nil,16,nil,},
[2762] = {'Thundering Exile',1305,1357,38,39,0,{[45]={{52.11,49.4},{51.99,50.39},{51.81,50.97},{52.24,50.77},{51.38,51.93},{52.53,52.09},{53.3,49.32},{50.39,50.83},{51.1,49.86},{52.15,47.73},{53.17,50.82},{50.51,53.32},},},nil,45,nil,nil,16,nil,},
[2763] = {'Thenan',4953,4953,42,42,1,nil,nil,0,nil,nil,14,nil,},
[2764] = {'Sleeby',184,184,40,40,0,{[45]={{67.68,37.57},},},nil,45,nil,nil,15,"AH",},
[2765] = {'Znort',219,219,39,39,0,{[45]={{67.79,37.74},},},nil,45,nil,nil,15,"AH",},
[2766] = {'Lolo the Lookout',2376,2376,39,39,0,{[45]={{31.78,82.68},},},nil,45,{663,},nil,390,"AH",},
[2767] = {'First Mate Nilzlix',1678,1678,39,39,0,{[45]={{32.8,81.48},},},nil,45,{662,},{662,},120,"AH",},
[2768] = {'Professor Phizzlethorpe',2284,2284,38,38,0,{[45]={{33.87,80.55},},},nil,45,{665,},nil,35,"AH",},
[2769] = {'Captain Steelgut',2376,2376,39,39,0,{[45]={{34.0,80.8},},},nil,45,{664,},{664,},120,"AH",},
[2770] = {'Tallow',1380,1380,27,27,0,{[267]={{61.87,19.57},},},nil,267,{676,},nil,68,"H",},
[2771] = {'Drum Fel',1605,1605,30,30,0,{[45]={{74.24,33.92},},},nil,45,{677,678,679,},{676,677,678,679,},125,"H",},
[2772] = {'Korin Fel',2016,2016,35,35,0,{[45]={{74.04,33.07},},},nil,45,{680,},{680,},125,"H",},
[2773] = {'Or\'Kalar',5334,5334,40,40,1,{[45]={{18.56,66.24},{18.59,66.41},{20.71,65.41},{19.53,68.3},{18.63,65.96},{19.36,68.68},{20.79,65.13},},},nil,45,nil,nil,45,nil,},
[2774] = {'Doctor Draxlegauge',2284,2284,38,38,0,{[45]={{33.86,80.45},},},nil,45,{666,668,},{665,666,},120,"AH",},
[2775] = {'Daggerspine Marauder',1829,1902,40,41,0,nil,nil,0,nil,nil,74,nil,},
[2776] = {'Vengeful Surge',1718,1718,40,40,0,nil,nil,0,nil,nil,91,nil,},
[2778] = {'Deckhand Moishe',1536,1536,37,37,0,{[45]={{32.61,80.06},},},nil,45,nil,nil,120,"AH",},
[2779] = {'Prince Nazjak',1902,1902,41,41,4,{[45]={{19.37,90.15},},},nil,45,nil,nil,74,nil,},
[2780] = {'Caretaker Nevlin',4755,4755,41,41,1,{[45]={{29.22,59.48},},},nil,45,nil,nil,123,"A",},
[2781] = {'Caretaker Weston',4755,4755,41,41,1,{[45]={{29.07,60.23},},},nil,45,nil,nil,123,"A",},
[2782] = {'Caretaker Alaric',4755,4755,41,41,1,{[45]={{28.98,59.68},},},nil,45,nil,nil,123,"A",},
[2783] = {'Marez Cowl',4572,4572,40,40,1,{[45]={{29.62,62.97},},},nil,45,nil,nil,16,nil,},
[2784] = {'King Magni Bronzebeard',17000,17000,63,63,3,{[1537]={{39.09,56.2},},},nil,1537,{686,4341,4362,},{683,700,4361,4363,7063,8484,},55,"A",},
[2785] = {'Theldurin the Lost',1605,1605,30,30,0,{[3]={{51.39,76.87},},},nil,3,{656,692,709,727,728,},{687,692,709,737,},35,"AH",},
[2786] = {'Gerrig Bonegrip',1605,1605,30,30,0,{[1537]={{50.83,5.62},},},nil,1537,{687,735,737,971,},{653,727,735,968,971,},55,"A",},
[2787] = {'Zaruk',3857,3857,60,60,0,{[45]={{74.54,35.64},},},nil,45,{687,},{688,},83,"H",},
[2788] = {'Apprentice Kryten',1605,1605,30,30,0,{[45]={{46.2,47.75},},},nil,45,{691,695,},{691,694,},1078,"A",},
[2789] = {'Skuerto',2100,2100,36,36,0,{[45]={{46.65,47.01},},},nil,45,{693,694,696,697,},{690,693,695,696,},55,"A",},
[2790] = {'Grand Mason Marblesten',2868,2868,44,44,0,{[1537]={{39.04,88.05},},},{[1]={{57.35,35.23},{57.3,35.15},{57.31,35.06},{57.35,35.08},{57.33,35.17},},[1537]={{39.04,88.05},{38.72,87.53},{38.82,86.99},{39.05,87.09},{38.96,87.7},},},1537,{689,700,},{686,689,},55,"A",},
[2791] = {'Enraged Rock Elemental',1981,2059,42,43,0,{[3]={{53.7,82.4},{53.8,81.79},{53.83,82.55},{55.29,85.61},{56.05,82.76},{54.22,85.57},{55.57,87.21},{53.87,83.91},{52.59,85.55},{56.55,83.64},{54.52,81.95},{56.05,84.03},},},nil,3,nil,nil,91,nil,},
[2792] = {'Gor\'mul',2471,2471,40,40,0,{[45]={{72.64,33.93},},},{[45]={{72.77,33.66},{72.54,34.01},{72.61,34.16},{72.82,34.22},{72.8,34.14},{72.8,34.14},},[47]={{49.65,93.81},{49.43,94.14},{49.49,94.28},{49.69,94.33},{49.68,94.26},{49.68,94.26},},},45,{655,675,847,},{674,702,},29,"H",},
[2793] = {'Kor\'gresh Coldrage',1345,1345,39,39,0,{[45]={{54.75,81.87},},},nil,45,nil,nil,45,nil,},
[2794] = {'Summoned Guardian',4736,4736,38,38,1,nil,nil,0,nil,nil,10,"A",},
[2795] = {'Lenny "Fingers" McCoy',2016,2016,35,35,0,{[1519]={{68.65,44.55},},},nil,1519,nil,nil,12,"A",},
[2796] = {'Faelyssa',1233,1233,35,35,0,{[1657]={{32.51,21.3},},},nil,1657,nil,nil,80,"A",},
[2798] = {'Pand Stonebinder',2016,2016,35,35,0,{[1638]={{29.69,21.18},},},nil,1638,nil,nil,104,"H",},
[2799] = {'Lucian Fenner',2016,2016,35,35,0,{[1497]={{76.78,75.18},},},nil,1497,nil,nil,68,"H",},
[2801] = {'Tresa MacGregor',2972,2972,45,45,0,nil,nil,0,nil,nil,55,"A",},
[2802] = {'Susan Tillinghast',4108,4108,55,55,0,{[1497]={{87.35,76.2},},},{[28]={{8.39,69.35},{7.75,69.19},{7.43,68.61},{6.41,67.98},{6.2,67.42},{6.5,66.94},{6.88,66.45},{7.1,66.34},{7.41,65.83},{7.49,65.64},{7.8,65.1},{8.58,65.75},{8.85,67.12},{9.2,68.03},{9.14,68.41},{8.84,69.05},},[36]={{25.98,6.5},{25.0,6.26},{24.51,5.37},{22.94,4.4},{22.62,3.54},{23.08,2.8},{23.66,2.04},{24.0,1.88},{24.47,1.1},{24.6,0.81},{26.27,0.98},{26.68,3.08},{27.22,4.48},{27.13,5.05},{26.67,6.04},},[85]={{65.89,81.62},{65.28,81.47},{64.98,80.92},{64.01,80.32},{63.81,79.78},{64.09,79.33},{64.45,78.86},{64.67,78.76},{64.96,78.27},{65.03,78.1},{65.33,77.58},{66.07,78.2},{66.33,79.5},{66.66,80.37},{66.6,80.72},{66.32,81.34},},[130]={{80.81,10.29},{80.16,10.12},{79.83,9.53},{78.79,8.88},{78.57,8.31},{78.88,7.82},{79.26,7.31},{79.49,7.2},{79.81,6.68},{79.89,6.49},{80.21,5.94},{81.01,6.61},{81.28,8.0},{81.64,8.94},{81.58,9.32},{81.27,9.98},},[1497]={{85.18,78.0},{82.33,77.29},{80.89,74.7},{76.32,71.86},{75.39,69.36},{76.72,67.22},{78.41,65.0},{79.42,64.52},{80.79,62.24},{81.15,61.41},{82.54,58.98},{86.04,61.9},{87.24,68.02},{88.8,72.1},{88.54,73.78},{87.19,76.67},},},1497,nil,nil,68,"H",},
[2803] = {'Malygen',4108,4108,55,55,0,{[361]={{62.32,25.64},},},nil,361,nil,nil,80,"A",},
[2804] = {'Kurden Bloodclaw',10626,10626,61,61,1,{[1497]={{54.18,96.07},},},nil,1497,nil,nil,1515,"H",},
[2805] = {'Deneb Walker',2972,2972,45,45,0,{[45]={{26.97,58.83},},},nil,45,nil,nil,12,"A",},
[2806] = {'Bale',4108,4108,55,55,0,{[361]={{34.75,53.23},},},nil,361,nil,nil,104,"H",},
[2808] = {'Vikki Lonsav',2100,2100,36,36,0,{[45]={{46.45,47.6},},},nil,45,nil,nil,12,"A",},
[2810] = {'Hammon Karwn',2016,2016,35,35,0,{[45]={{46.49,47.41},},},nil,45,nil,nil,12,"A",},
[2812] = {'Drovnar Strongbrew',2471,2471,40,40,0,{[45]={{46.32,47.04},},},nil,45,nil,nil,55,"A",},
[2814] = {'Narj Deepslice',2376,2376,39,39,0,{[45]={{45.54,47.61},},},nil,45,nil,nil,55,"A",},
[2816] = {'Androd Fadran',2192,2192,37,37,0,{[45]={{45.08,46.83},},},nil,45,nil,nil,12,"A",},
[2817] = {'Rigglefuzz',2192,2192,37,37,0,{[3]={{42.39,52.93},},},nil,3,{703,705,1559,2418,},{703,705,1559,2418,},120,"AH",},
[2818] = {'Slagg',2284,2284,38,38,0,{[45]={{74.08,33.82},},},nil,45,nil,nil,29,"H",},
[2819] = {'Tunkk',1930,1930,34,34,0,{[45]={{74.86,34.58},},},nil,45,nil,nil,29,"H",},
[2820] = {'Graud',1684,1684,31,31,0,{[45]={{74.12,32.37},},},nil,45,nil,nil,29,"H",},
[2821] = {'Keena',1846,1846,33,33,0,{[45]={{74.09,32.73},},},nil,45,nil,nil,29,"H",},
[2829] = {'Starving Buzzard',1403,1536,35,37,0,{[3]={{65.27,37.67},{63.91,45.96},{52.74,26.07},{60.73,28.27},{54.04,23.45},{56.56,28.64},},},nil,3,nil,nil,73,nil,},
[2830] = {'Buzzard',1536,1678,37,39,0,{[3]={{62.83,57.31},{52.67,50.26},{58.98,70.94},{50.23,59.66},{60.82,72.8},{51.44,74.4},{56.51,45.86},},},nil,3,nil,nil,73,nil,},
[2831] = {'Giant Buzzard',1751,1902,39,41,0,{[3]={{28.81,72.04},{15.03,60.1},{17.17,61.34},{15.04,61.82},{16.17,61.7},{15.5,58.52},{16.02,58.67},{12.28,70.96},{17.18,60.02},{17.1,58.35},{12.21,67.91},{33.42,59.81},{25.77,61.89},{17.54,49.15},{24.36,76.19},{18.85,77.61},{25.31,73.87},},},nil,3,nil,nil,73,nil,},
[2832] = {'Nixxrax Fillamug',2284,2284,38,38,0,{[33]={{27.04,77.17},},},nil,33,nil,nil,120,"AH",},
[2834] = {'Myizz Luckycatch',2766,2766,43,43,0,{[33]={{27.46,77.11},},},nil,33,nil,nil,120,"AH",},
[2835] = {'Cedrik Prose',7842,7842,55,55,0,{[45]={{45.76,46.11},},},nil,45,nil,nil,12,"A",},
[2836] = {'Brikk Keencraft',3986,3986,54,54,0,{[33]={{28.99,75.56},},},nil,33,nil,nil,120,"AH",},
[2837] = {'Jaxin Chong',3077,3077,46,46,0,{[33]={{28.04,77.99},},},nil,33,nil,nil,120,"AH",},
[2838] = {'Crazk Sparks',3077,3077,46,46,0,{[33]={{28.36,76.66},},},nil,33,nil,nil,120,"AH",},
[2839] = {'Haren Kanmae',2568,2568,41,41,0,{[33]={{28.31,74.56},},},nil,33,nil,nil,120,"AH",},
[2840] = {'Kizz Bluntstrike',2471,2471,40,40,0,{[33]={{28.27,75.22},},},nil,33,nil,nil,120,"AH",},
[2842] = {'Wigcik',2766,2766,43,43,0,{[33]={{28.0,76.99},},},nil,33,nil,nil,120,"AH",},
[2843] = {'Jutak',2766,2766,43,43,0,{[33]={{27.46,77.55},},},nil,33,nil,nil,120,"AH",},
[2844] = {'Hurklor',3077,3077,46,46,0,{[33]={{28.97,75.06},},},nil,33,nil,nil,120,"AH",},
[2845] = {'Fargon Mortalak',2471,2471,40,40,0,{[33]={{29.04,74.99},},},nil,33,nil,nil,120,"AH",},
[2846] = {'Blixrez Goodstitch',2766,2766,43,43,0,{[33]={{28.25,77.54},},},nil,33,nil,nil,120,"AH",},
[2847] = {'Jansen Underwood',3404,3404,49,49,0,{[33]={{29.07,75.48},},},nil,33,nil,nil,120,"AH",},
[2848] = {'Glyx Brewright',170,170,45,45,0,{[33]={{28.14,78.11},},},nil,33,nil,nil,120,"AH",},
[2849] = {'Qixdi Goodstitch',2868,2868,44,44,0,{[33]={{28.15,77.56},},},nil,33,nil,nil,120,"AH",},
[2850] = {'Broken Tooth',1603,1603,37,37,4,{[3]={{59.69,29.37},{59.68,26.92},{53.65,15.53},{45.8,36.5},},},nil,3,nil,nil,66,nil,},
[2851] = {'Urda',7842,7842,55,55,1,{[45]={{73.06,32.68},},},nil,45,nil,nil,29,"H",},
[2852] = {'Enslaved Druid of the Talon',413,413,10,10,0,{[141]={{38.7,80.65},{38.67,80.6},{38.8,80.62},{38.76,80.66},},},{[141]={{38.43,80.74},{38.43,80.74},{38.15,81.08},{37.89,82.69},},},141,nil,nil,35,"AH",},
[2853] = {'Freed Druid of the Talon',413,413,10,10,0,nil,nil,0,nil,nil,35,"AH",},
[2855] = {'Snang',1172,1172,24,24,0,{[1637]={{62.93,49.24},},},nil,1637,nil,nil,29,"H",},
[2856] = {'Angrun',2471,2471,40,40,0,{[33]={{32.25,27.43},},},nil,33,nil,nil,29,"H",},
[2857] = {'Thund',1106,1106,23,23,0,{[1637]={{75.96,24.15},},},nil,1637,nil,nil,29,"H",},
[2858] = {'Gringer',7842,7842,55,55,1,{[33]={{26.87,77.1},},},nil,33,nil,nil,29,"H",},
[2859] = {'Gyll',7842,7842,55,55,1,{[33]={{27.53,77.79},},},nil,33,nil,nil,55,"A",},
[2860] = {'Sigrun Ironhew',2471,2471,40,40,0,{[3]={{53.8,43.3},},},nil,3,{706,718,733,},{706,718,733,},55,"A",},
[2861] = {'Gorrik',7842,7842,55,55,1,{[3]={{3.99,44.78},},},nil,3,nil,nil,29,"H",},
[2870] = {'Henria Derth',980,980,21,21,0,nil,nil,0,nil,nil,84,"A",},
[2876] = {'Grunenstur Balindom',3517,3517,50,50,0,nil,nil,0,nil,nil,84,"A",},
[2878] = {'Peria Lamenur',2471,2471,40,40,0,{[1]={{46.68,54.0},{71.04,38.03},},},nil,1,nil,nil,55,"A",},
[2879] = {'Karrina Mekenda',2471,2471,40,40,0,{[1519]={{61.58,15.97},},},nil,1519,nil,nil,55,"A",},
[2880] = {'Hurom Juggendolf',3517,3517,50,50,0,nil,nil,0,nil,nil,84,"A",},
[2881] = {'Durdek Karrin',3517,3517,50,50,0,nil,nil,0,nil,nil,55,"A",},
[2887] = {'Prismatic Exile',1651,1716,42,43,0,nil,nil,0,nil,nil,91,nil,},
[2888] = {'Garek',3517,3517,50,50,0,{[3]={{61.94,54.26},},},nil,3,{717,732,},{717,732,},35,"AH",},
[2892] = {'Stonevault Seer',3540,3678,39,40,1,{[3]={{64.0,41.21},{64.82,41.09},{65.88,44.03},{64.71,43.51},},},nil,3,nil,nil,59,nil,},
[2893] = {'Stonevault Bonesnapper',1678,1753,39,40,0,{[3]={{49.66,64.31},{48.72,71.93},{48.27,69.95},{51.35,69.72},{47.3,69.89},{50.93,67.7},{52.48,69.61},{51.01,66.09},{52.46,65.96},{52.31,68.06},{50.17,67.12},{51.18,71.65},{49.7,71.7},{50.92,64.36},},},nil,3,nil,nil,59,nil,},
[2894] = {'Stonevault Shaman',1471,1522,40,41,0,{[3]={{49.66,66.49},{48.27,68.28},{49.53,69.8},{49.89,68.38},{50.94,67.25},},},nil,3,nil,nil,59,nil,},
[2906] = {'Dustbelcher Warrior',1403,1536,36,37,0,{[3]={{68.08,25.08},{64.36,23.75},{65.52,22.05},{65.66,23.49},{67.13,22.09},},},nil,3,nil,nil,45,nil,},
[2907] = {'Dustbelcher Mystic',1208,1257,36,37,0,{[3]={{66.67,23.29},{64.69,25.55},{12.87,73.34},{66.33,22.05},},},{[1]={{85.3,99.24},{85.44,99.56},{85.59,99.98},{90.5,99.99},{90.62,99.73},{91.0,98.95},{91.48,98.32},{91.77,98.18},{92.52,98.22},{92.92,98.4},{93.7,98.4},{94.14,98.5},{94.76,98.75},{95.13,98.53},{95.64,98.13},{96.23,97.95},{96.85,97.74},{97.48,97.57},{98.33,97.53},{98.97,97.61},{99.8,97.75},{99.43,89.13},{98.61,89.51},{97.66,90.23},{97.31,90.6},{96.78,91.23},{96.24,91.54},{95.8,91.22},{95.45,91.06},{95.24,91.0},{94.42,90.94},{94.08,90.79},{93.64,90.5},{93.01,90.29},{92.59,90.18},{91.96,90.07},{91.38,90.24},{91.0,90.31},{90.62,90.2},{90.03,90.45},{89.63,90.67},{88.6,90.58},{88.42,91.06},{88.26,91.54},{87.83,92.25},{87.51,92.83},{86.94,93.34},{86.46,93.86},{86.02,94.2},{85.48,94.21},{85.34,94.89},{85.05,95.4},{84.64,96.33},{84.63,96.92},{84.67,97.96},{84.8,98.59},{85.08,98.66},},[3]={{12.85,75.12},{13.13,75.76},{13.43,76.59},{14.06,77.35},{14.81,77.94},{15.31,78.09},{16.95,78.43},{17.98,78.61},{18.55,78.38},{20.37,78.55},{21.32,78.23},{22.14,77.96},{23.15,76.62},{23.4,76.11},{24.13,74.56},{25.09,73.31},{25.67,73.04},{27.14,73.1},{27.95,73.46},{29.48,73.46},{30.36,73.66},{31.59,74.16},{32.32,73.73},{33.34,72.92},{34.49,72.56},{35.73,72.17},{36.97,71.82},{38.66,71.74},{39.92,71.91},{41.56,72.19},{43.24,72.25},{44.18,72.45},{45.43,72.73},{46.77,72.32},{48.52,72.47},{49.33,72.81},{49.74,72.96},{50.98,73.3},{52.05,73.33},{53.95,72.85},{55.77,72.33},{57.03,72.22},{58.72,71.99},{59.84,71.55},{61.46,69.75},{61.24,68.79},{60.13,66.89},{59.0,65.0},{58.19,63.54},{57.04,61.89},{55.86,60.35},{55.25,59.48},{54.7,58.52},{53.91,57.04},{53.07,55.68},{52.34,54.79},{52.56,53.32},{52.49,51.58},{51.29,49.83},{49.95,48.76},{49.53,48.68},{47.54,49.0},{46.47,50.3},{45.3,51.9},{43.36,53.17},{42.35,54.15},{40.82,55.12},{39.21,55.87},{37.33,57.29},{36.64,58.02},{35.58,59.26},{34.52,59.88},{33.64,59.24},{32.96,58.94},{32.54,58.82},{30.91,58.7},{30.24,58.4},{29.36,57.82},{28.12,57.41},{27.29,57.18},{26.04,56.98},{24.9,57.31},{24.14,57.44},{23.38,57.24},{22.22,57.72},{21.42,58.16},{19.39,57.98},{19.03,58.93},{18.71,59.87},{17.87,61.29},{17.22,62.44},{16.1,63.44},{15.14,64.47},{14.28,65.14},{13.21,65.17},{12.93,66.52},{12.37,67.52},{11.55,69.36},{11.53,70.53},{11.61,72.58},{11.87,73.84},{12.43,73.98},},[46]={{72.79,5.33},{73.03,5.88},{73.28,6.58},{73.82,7.23},{74.45,7.73},{74.88,7.86},{76.28,8.14},{77.15,8.3},{77.63,8.1},{79.18,8.24},{79.98,7.97},{80.68,7.74},{81.54,6.6},{81.75,6.17},{82.37,4.85},{83.18,3.79},{83.68,3.56},{84.93,3.61},{85.61,3.92},{86.91,3.92},{87.66,4.09},{88.7,4.51},{89.32,4.15},{90.19,3.47},{91.17,3.16},{92.22,2.82},{93.28,2.53},{94.71,2.46},{95.78,2.6},{97.17,2.84},{98.6,2.89},{99.39,3.06},{71.69,0.44},{71.67,1.43},{71.74,3.18},{71.96,4.25},{72.43,4.36},},[51]={{93.03,69.6},{93.35,70.32},{93.69,71.24},{94.39,72.09},{95.22,72.75},{95.78,72.92},{97.61,73.29},{98.76,73.5},{99.39,73.23},{99.93,51.55},{99.57,52.6},{98.63,54.18},{97.91,55.47},{96.66,56.58},{95.59,57.73},{94.63,58.48},{93.44,58.5},{93.13,60.01},{92.5,61.13},{91.59,63.18},{91.56,64.49},{91.66,66.78},{91.95,68.18},{92.57,68.33},},},3,nil,nil,45,nil,},
[2908] = {'Grawl',2868,2868,44,44,0,{[3]={{3.12,45.93},},},nil,3,nil,nil,29,"H",},
[2909] = {'Hammertoe Grez',2331,2331,40,40,0,{[1]={{97.95,66.65},},[3]={{37.9,10.6},},[38]={{37.28,85.78},},},nil,1,{722,723,},{721,722,},55,"A",},
[2910] = {'Prospector Ryedol',2016,2016,35,35,0,{[3]={{53.42,43.39},},},nil,3,{719,721,724,},{719,720,723,},55,"A",},
[2911] = {'Archaeologist Flagongut',2868,2868,44,44,0,{[11]={{10.84,60.43},},},nil,11,{943,},{942,943,},55,"A",},
[2912] = {'Chief Archaeologist Greywhisker',2471,2471,40,40,0,{[1657]={{31.24,84.51},},},nil,1657,{730,942,},{741,},55,"A",},
[2913] = {'Archaeologist Hollee',500,500,12,12,0,{[148]={{37.44,41.84},},},nil,148,{729,741,},{730,731,},55,"A",},
[2914] = {'Snake',8,8,1,1,0,{[15]={{55.45,70.13},{56.35,30.7},{53.01,75.88},{39.07,49.15},{58.47,30.69},{39.71,71.56},{40.89,21.45},{39.71,25.06},{35.64,56.55},{59.65,35.8},{38.75,16.32},{38.2,71.9},{42.62,43.25},{52.3,56.45},{37.07,70.43},{46.47,77.49},{43.58,76.55},{47.27,63.67},{52.94,20.29},{48.97,52.7},{50.14,52.96},{41.97,21.66},{38.76,60.4},{42.04,28.66},{43.64,19.07},{55.48,73.46},{50.95,27.45},{45.96,78.22},{49.14,70.02},{40.93,58.66},{43.47,50.93},{40.92,70.78},{44.41,74.49},{50.8,65.67},{52.44,69.69},{38.2,53.99},{50.81,23.73},{34.51,59.37},{38.18,35.78},{48.59,66.27},{46.27,25.04},{34.33,47.07},{39.02,74.29},{42.95,38.35},{44.27,51.02},{36.19,25.0},{40.95,13.6},{57.69,28.98},{47.93,66.7},{42.21,74.86},{52.63,52.9},{34.42,38.77},{51.36,61.53},{50.64,56.11},{46.08,45.6},{44.85,19.7},{48.71,75.76},{33.96,63.65},{45.33,22.32},{48.26,49.84},{43.75,57.03},{45.62,53.53},{34.67,43.92},{33.32,44.65},{36.42,28.1},{55.86,27.83},},[130]={{46.49,78.99},{66.43,48.94},{45.94,26.01},{59.32,9.17},{49.92,18.97},{50.95,43.52},{49.67,15.75},},[718]={{-1, -1}},[490]={{44.61,62.88},{47.19,73.91},{54.29,72.48},{52.35,33.14},{37.75,42.65},{28.33,43.83},{66.93,28.43},{47.37,85.89},{31.1,28.95},{46.24,25.67},{75.83,44.33},{60.5,19.59},{55.76,30.45},{50.86,18.16},{74.96,62.53},{68.97,32.1},{40.99,22.3},{35.07,38.56},},[405]={{79.42,16.88},{71.32,60.14},{71.61,22.75},{50.9,68.99},{73.58,64.95},{28.76,80.11},{42.19,63.59},{56.32,22.98},{31.32,78.03},{42.4,69.98},{31.09,70.77},{71.66,32.46},{76.2,24.58},{44.42,86.33},{41.9,52.39},{63.48,72.43},{39.9,38.3},{35.3,84.45},{68.51,62.1},{62.24,77.92},{46.29,48.65},{54.44,32.37},{57.37,8.13},{70.05,41.73},{67.43,69.0},{41.62,28.12},{59.75,62.11},{34.28,76.45},{64.13,33.46},},[40]={{53.69,39.33},{63.41,73.51},{62.27,60.22},{46.51,53.43},{46.05,71.75},{58.55,14.7},{32.13,52.39},{37.2,27.05},{40.94,62.05},{46.24,79.07},{49.22,47.93},{43.64,33.73},{35.03,33.92},{54.33,20.63},{49.99,31.14},},[1977]={{-1, -1}},[357]={{58.68,54.63},{43.86,12.61},{82.73,45.12},{68.86,60.35},{40.55,24.1},{80.88,39.64},{54.06,53.76},{84.41,38.3},{56.56,69.37},{54.86,73.69},{52.82,49.02},{71.57,61.27},{52.4,47.66},{57.23,47.44},{79.5,45.2},{69.86,39.85},{49.89,31.54},{55.09,49.3},},[2100]={{-1, -1}},[2557]={{-1, -1}},},nil,15,nil,nil,190,"AH",},
[2915] = {'Hammertoe\'s Spirit',2471,2471,40,40,0,nil,nil,0,nil,nil,35,"AH",},
[2916] = {'Historian Karnik',919,919,20,20,0,{[1537]={{77.54,11.82},},},nil,1537,{725,762,2946,2964,3448,7063,},{724,726,2963,2977,7062,},55,"A",},
[2917] = {'Prospector Remtravel',695,695,16,16,0,{[148]={{35.73,83.7},},},nil,148,{731,},{729,},55,"A",},
[2918] = {'Advisor Belgrum',2471,2471,40,40,0,{[1537]={{77.34,9.71},},},nil,1537,{726,1139,},{725,762,1139,},55,"A",},
[2919] = {'Fam\'retor Guardian',2191,2191,45,45,0,nil,nil,0,nil,nil,91,nil,},
[2920] = {'Lucien Tosselwrench',1684,1684,31,31,0,{[3]={{25.82,44.24},},},nil,3,{715,716,777,},{715,716,734,},35,"AH",},
[2921] = {'Lotwil Veriatus',2100,2100,36,36,0,{[3]={{25.95,44.87},},},nil,3,{710,711,712,713,714,734,778,4063,},{710,711,712,713,714,777,778,4062,4063,},35,"AH",},
[2922] = {'Servo',102,102,5,5,0,{[3]={{26.04,44.73},},},nil,3,nil,nil,42,"AH",},
[2923] = {'Mangy Silvermane',1902,1981,41,42,0,{[47]={{21.67,47.57},{15.1,54.17},{15.15,55.62},{16.37,54.7},{22.52,51.16},{21.77,53.0},{23.59,51.74},{18.3,48.91},{20.88,50.34},{18.76,49.08},{20.04,50.2},{20.13,56.61},{19.02,47.58},{20.96,55.44},{20.26,57.22},{21.78,54.98},{17.59,48.16},{19.68,51.47},{19.31,54.31},{17.18,49.49},{19.55,52.34},{18.2,52.54},},},nil,47,nil,nil,38,nil,},
[2924] = {'Silvermane Wolf',2059,2138,43,44,0,{[47]={{35.83,44.99},{36.06,44.01},{37.3,49.73},{34.97,44.05},{34.08,46.12},{37.61,55.01},{38.14,53.07},{27.89,69.45},{35.79,48.99},{35.5,47.74},{34.96,61.57},{34.2,61.08},{32.09,63.42},{35.72,52.97},{31.0,64.61},{36.71,52.63},{36.22,49.13},{36.78,51.66},{24.7,51.08},{27.82,53.43},{33.71,53.65},{37.55,52.12},{35.16,52.64},{29.58,54.17},{32.74,63.55},{32.13,55.28},{34.41,58.78},{31.77,60.66},{26.64,55.26},{26.88,58.06},{28.85,63.22},{27.91,61.56},},},nil,47,nil,nil,38,nil,},
[2925] = {'Silvermane Howler',2310,2399,45,46,0,{[47]={{41.32,67.14},{51.83,59.96},{49.81,57.56},{50.48,58.85},{41.5,46.18},{51.06,40.58},{42.53,46.28},{40.95,55.09},{43.05,53.66},{37.39,61.02},{40.57,64.19},{43.97,61.76},{42.72,62.74},{39.86,50.59},{39.39,62.94},{39.27,45.99},{47.81,59.04},{48.03,61.5},{46.83,59.47},{46.75,47.81},},},nil,47,nil,nil,38,nil,},
[2926] = {'Silvermane Stalker',2488,2578,47,48,0,{[47]={{68.62,52.76},{74.66,48.64},{67.39,51.48},{69.22,53.89},{63.64,49.3},{60.21,55.27},{53.5,56.04},{58.84,47.54},{63.13,52.37},{72.38,56.37},{69.59,54.85},{51.1,60.99},{68.0,52.86},{64.19,48.89},{76.43,53.46},{62.47,50.28},{69.37,44.96},{58.33,54.7},{59.68,54.15},{67.04,50.36},{70.54,58.03},{64.0,55.07},{54.19,42.76},{66.64,60.59},{58.42,51.9},{53.51,56.0},{63.03,42.86},{69.32,49.77},{65.36,53.27},{73.97,55.89},{73.37,57.91},{63.2,49.08},{73.52,56.1},{51.46,54.34},{61.95,46.34},{61.2,48.0},{54.33,43.83},{73.09,51.98},{66.75,48.61},{71.45,54.83},{62.74,56.56},{55.81,43.79},{70.11,57.07},{71.29,61.53},{59.64,50.77},{56.4,46.2},{75.48,55.18},{78.05,52.22},{72.88,57.84},{71.6,59.53},{61.24,55.77},{52.21,49.11},{71.98,59.27},{59.45,48.99},{76.56,48.79},{67.58,48.65},{72.05,63.05},{60.74,54.01},{68.68,60.27},{69.78,56.37},{66.78,57.8},},},nil,47,nil,nil,38,nil,},
[2927] = {'Vicious Owlbeast',1981,2059,42,43,0,{[47]={{33.88,63.21},{26.37,68.69},{37.17,44.22},{36.54,45.73},{36.1,55.3},{36.6,47.83},{34.1,61.57},{26.19,63.94},{29.72,55.26},{31.14,62.95},{34.14,52.0},{34.2,50.98},{25.6,62.85},{35.79,50.82},{23.69,49.4},{26.56,53.16},{26.22,67.13},{31.02,52.79},{34.38,55.47},{25.95,68.38},{26.79,59.62},{26.28,54.29},{33.8,58.92},{26.5,61.32},{27.13,63.4},{27.91,65.93},{25.32,53.25},},},nil,47,nil,nil,14,nil,},
[2928] = {'Primitive Owlbeast',2138,2218,44,45,0,{[47]={{51.29,50.05},{41.43,42.49},{38.58,43.28},{40.33,56.43},{44.35,59.73},{42.78,45.23},{39.55,43.42},{38.71,45.63},{38.38,49.45},{38.22,63.62},{41.01,61.58},{39.14,44.96},{38.61,57.52},{41.6,56.78},{44.09,54.66},{42.85,55.05},{43.28,44.47},{40.11,46.28},{41.23,45.97},{42.58,44.99},{38.13,58.97},{40.69,63.81},{39.09,52.64},{45.99,54.0},{42.11,64.64},{40.95,52.25},{43.4,58.04},{38.62,52.36},{38.05,61.31},{42.27,47.27},{39.59,48.36},{47.14,56.71},{45.81,54.05},{40.47,47.69},{43.54,56.43},{44.64,53.55},{50.94,57.81},{36.99,57.66},{45.69,51.53},{51.83,63.5},{46.22,56.99},{36.13,59.48},{49.47,59.84},{51.36,42.24},},},nil,47,nil,nil,14,nil,},
[2929] = {'Savage Owlbeast',2631,2701,46,47,0,{[47]={{61.63,44.33},{61.49,41.92},{60.91,46.54},{53.81,48.86},{60.44,53.76},{62.58,40.85},{55.87,51.67},{52.21,46.36},{52.86,49.83},{65.57,57.83},{56.09,46.06},},},nil,47,nil,nil,14,nil,},
[2930] = {'Sentinel Glynda Nal\'Shea',2972,2972,45,45,0,{[148]={{37.71,43.39},},},nil,148,{4811,4812,},{4740,4811,4813,},80,"A",},
[2931] = {'Zaricotl',7842,7842,55,55,2,{[3]={{56.11,61.73},{35.38,66.49},{34.49,53.74},},},nil,3,nil,nil,14,nil,},
[2932] = {'Magregan Deepshadow',4185,4185,38,38,1,{[1]={{98.36,70.45},},[3]={{38.72,18.13},},[38]={{38.01,92.56},},},nil,1,nil,nil,54,nil,},
[2934] = {'Keeper Bel\'dugur',2666,2666,42,42,0,{[1497]={{53.74,54.46},},},nil,1497,{736,737,1013,},{728,736,1013,},68,"H",},
[2937] = {'Dagun the Ravenous',5148,5148,43,43,1,nil,nil,0,nil,nil,18,nil,},
[2941] = {'Lanie Reed',7842,7842,55,55,1,{[51]={{37.94,30.86},},},nil,51,nil,nil,55,"A",},
[2943] = {'Ransin Donner',5400,5400,35,35,0,{[1537]={{50.14,12.69},},},nil,1537,nil,nil,55,"A",},
[2944] = {'Boss Tho\'grun',1902,1981,41,42,0,{[3]={{12.62,75.49},},},{[1]={{85.23,99.42},{85.53,99.89},{90.68,99.44},{91.32,98.59},{91.98,98.09},{92.5,98.11},{93.11,98.39},{94.04,98.43},{94.67,98.34},{95.52,98.16},{96.15,98.02},{96.65,97.92},{97.5,97.75},{98.14,97.72},{98.99,97.73},{99.84,97.75},{99.89,88.68},{99.31,89.05},{98.39,89.63},{97.65,90.26},{97.3,90.62},{96.7,91.25},{96.28,91.64},{95.88,91.42},{95.48,91.19},{95.28,91.08},{94.72,90.92},{94.46,90.94},{94.13,90.84},{93.47,90.48},{93.06,90.32},{92.44,90.09},{92.05,90.0},{91.62,89.95},{91.29,89.95},{90.91,90.03},{90.49,90.14},{89.76,90.68},{89.33,90.64},{88.59,90.57},{88.5,90.86},{88.28,91.54},{87.98,91.99},{87.63,92.66},{86.94,93.36},{86.94,93.36},{86.59,93.72},{85.99,94.22},{85.52,94.21},{85.46,94.39},{85.12,95.37},{84.63,96.22},{84.69,97.14},{84.66,98.36},{84.76,98.58},{84.9,98.85},},[3]={{12.72,75.48},{13.32,76.41},{13.93,77.28},{14.68,78.03},{16.11,78.29},{16.95,78.41},{18.21,78.5},{19.37,78.3},{20.12,78.49},{21.58,77.97},{22.23,77.17},{23.51,75.51},{24.77,73.83},{26.07,72.85},{27.1,72.89},{28.32,73.45},{30.15,73.53},{31.41,73.34},{33.08,72.99},{34.34,72.72},{35.33,72.52},{37.01,72.17},{38.27,72.11},{39.96,72.13},{41.65,72.17},{43.33,72.26},{44.46,72.58},{45.91,72.71},{46.8,71.75},{48.15,72.73},{49.22,73.74},{50.39,73.71},{51.21,73.4},{53.28,72.8},{54.95,72.53},{56.63,72.31},{58.31,72.06},{59.15,71.91},{60.75,70.77},{61.54,69.91},{61.45,69.3},{61.14,67.46},{60.14,65.45},{59.13,64.3},{57.78,62.79},{56.77,61.64},{55.75,60.51},{54.74,59.37},{54.05,58.64},{52.72,57.35},{52.24,54.92},{52.56,53.09},{52.49,51.29},{51.81,50.2},{50.76,49.14},{49.68,48.82},{48.84,48.67},{47.5,49.11},{46.55,50.22},{45.61,51.5},{44.09,52.75},{42.92,53.48},{41.75,54.22},{40.59,54.96},{38.78,56.1},{37.31,57.34},{36.61,58.07},{35.42,59.31},{34.59,60.09},{33.8,59.64},{33.01,59.19},{32.62,58.97},{31.51,58.66},{31.0,58.69},{30.33,58.49},{29.04,57.78},{28.22,57.47},{26.99,57.02},{26.21,56.84},{25.37,56.74},{24.72,56.74},{23.95,56.89},{23.12,57.11},{21.68,58.19},{20.84,58.1},{19.38,57.97},{19.19,58.54},{18.76,59.89},{18.16,60.77},{17.46,62.09},{16.1,63.49},{16.1,63.49},{15.4,64.21},{14.22,65.19},{13.29,65.17},{13.17,65.53},{12.5,67.46},{11.53,69.16},{11.66,70.97},{11.58,73.38},{11.78,73.83},{12.05,74.36},},[46]={{72.68,5.64},{73.19,6.43},{73.71,7.17},{74.35,7.81},{75.55,8.03},{76.27,8.12},{77.34,8.2},{78.33,8.03},{78.97,8.2},{80.2,7.75},{80.76,7.07},{81.84,5.67},{82.92,4.24},{84.02,3.41},{84.89,3.43},{85.93,3.91},{87.48,3.98},{88.55,3.82},{89.97,3.52},{91.04,3.29},{91.88,3.12},{93.3,2.83},{94.38,2.78},{95.81,2.8},{97.24,2.82},{98.68,2.91},{99.64,3.17},{71.67,0.27},{71.78,1.81},{71.71,3.85},{71.88,4.24},{72.11,4.69},},[51]={{92.89,70.0},{93.56,71.04},{94.24,72.01},{95.08,72.85},{96.67,73.14},{97.6,73.26},{99.01,73.37},{99.63,52.62},{98.96,53.61},{98.18,55.08},{96.66,56.64},{96.66,56.64},{95.88,57.43},{94.57,58.53},{93.53,58.51},{93.4,58.91},{92.65,61.06},{91.57,62.95},{91.71,64.98},{91.62,67.66},{91.84,68.16},{92.15,68.76},},},3,nil,nil,45,nil,},
[2945] = {'Murdaloc',1981,1981,42,42,0,{[3]={{49.63,66.31},},},nil,3,nil,nil,59,nil,},
[2946] = {'Puppet of Helcular',165,165,42,42,0,nil,nil,0,nil,nil,83,"H",},
[2947] = {'Harken Windtotem',980,980,21,21,0,{[215]={{48.71,59.32},},},nil,215,{761,},{761,},83,"H",},
[2948] = {'Mull Thunderhorn',1240,1240,25,25,0,{[215]={{48.53,60.39},},},nil,215,{748,754,756,758,759,760,},{748,754,756,758,759,760,},104,"H",},
[2949] = {'Palemane Tanner',96,114,5,6,0,{[215]={{47.35,71.4},{48.35,71.76},{48.35,72.4},{34.98,62.69},{35.64,63.44},{33.01,61.19},{35.47,62.03},{33.42,61.18},{32.04,59.78},{32.78,61.83},{33.1,62.17},{32.72,60.96},{35.71,61.56},{31.61,60.36},{35.56,62.44},{35.39,62.32},{55.02,72.06},{54.5,73.4},{52.59,72.14},{53.8,72.4},{53.7,74.1},{53.45,73.55},{49.22,71.39},{48.68,71.2},{49.33,72.19},},},{[17]={{22.29,59.25},{22.42,59.28},{22.56,59.29},{22.67,59.29},{22.84,59.3},{22.9,59.29},{22.94,59.29},{23.0,59.28},{23.1,59.26},{23.17,59.27},{23.26,59.32},{23.34,59.33},{23.41,59.34},{23.54,59.39},{23.45,59.35},{23.38,59.33},{23.26,59.33},{23.17,59.27},{23.11,59.27},{23.04,59.28},{22.95,59.3},{22.9,59.3},{22.83,59.3},{22.7,59.29},{22.61,59.29},{22.51,59.28},{22.33,59.26},{22.28,58.88},{22.2,58.71},{22.15,58.62},{22.1,58.51},{22.06,58.42},{22.11,58.32},{22.07,58.42},{22.09,58.48},{22.14,58.6},{22.2,58.71},{22.29,58.88},{22.3,59.0},{21.7,58.51},{21.61,58.6},{21.5,58.67},{21.42,58.7},{21.56,58.64},{21.63,58.57},{21.72,58.47},{21.78,58.39},{21.84,58.28},{21.92,58.16},{22.0,58.04},{21.94,58.13},{21.9,58.23},{21.9,58.31},{21.86,58.45},{21.78,58.58},{21.73,58.65},{21.71,58.7},{21.78,58.71},{21.86,58.65},{21.92,58.59},{21.98,58.52},{21.92,58.6},{21.85,58.66},{21.77,58.72},{21.71,58.7},{21.73,58.65},{21.78,58.59},{21.85,58.46},{21.9,58.31},{21.92,58.19},{21.95,58.13},{22.0,58.03},{21.91,58.17},{21.84,58.29},{21.77,58.4},{32.78,65.19},{32.93,65.17},{33.03,65.07},{33.09,64.9},{33.05,64.7},{32.91,64.64},{32.8,64.63},{32.68,64.66},{32.61,64.76},{32.56,64.9},{32.58,65.06},{32.64,65.18},},[215]={{32.78,61.83},{33.04,61.89},{33.31,61.9},{33.52,61.91},{33.86,61.92},{33.97,61.91},{34.06,61.9},{34.18,61.89},{34.36,61.86},{34.5,61.87},{34.69,61.97},{34.85,61.98},{34.98,62.0},{35.23,62.1},{35.06,62.03},{34.92,61.98},{34.69,61.99},{34.5,61.88},{34.4,61.87},{34.26,61.89},{34.07,61.92},{33.98,61.93},{33.85,61.92},{33.58,61.9},{33.4,61.9},{33.2,61.9},{32.84,61.85},{32.75,61.1},{32.59,60.77},{32.49,60.58},{32.39,60.37},{32.32,60.19},{32.43,59.99},{32.34,60.19},{32.38,60.31},{32.48,60.54},{32.59,60.76},{32.78,61.1},{32.79,61.34},{31.61,60.37},{31.43,60.54},{31.21,60.69},{31.05,60.75},{31.33,60.62},{31.48,60.48},{31.65,60.3},{31.77,60.13},{31.89,59.92},{32.04,59.68},{32.2,59.43},{32.09,59.62},{32.01,59.81},{32.0,59.98},{31.93,60.25},{31.77,60.51},{31.67,60.66},{31.63,60.74},{31.77,60.77},{31.92,60.65},{32.05,60.54},{32.17,60.4},{32.05,60.54},{31.91,60.66},{31.75,60.78},{31.63,60.74},{31.67,60.65},{31.76,60.52},{31.91,60.28},{32.0,59.98},{32.04,59.74},{32.1,59.62},{32.2,59.43},{32.03,59.71},{31.88,59.94},{31.76,60.15},{53.46,73.55},{53.76,73.51},{53.96,73.31},{54.08,72.98},{53.99,72.59},{53.72,72.47},{53.5,72.45},{53.27,72.51},{53.13,72.69},{53.03,72.98},{53.07,73.28},{53.18,73.53},},[357]={{73.06,0.52},{73.25,0.56},{73.46,0.57},{73.61,0.57},{73.86,0.58},{73.94,0.58},{74.01,0.57},{74.09,0.56},{74.23,0.54},{74.34,0.55},{74.47,0.62},{74.59,0.63},{74.69,0.64},{74.88,0.72},{74.74,0.67},{74.65,0.63},{74.47,0.64},{74.33,0.55},{74.26,0.54},{74.16,0.56},{74.02,0.58},{73.95,0.59},{73.85,0.59},{73.66,0.57},{73.52,0.57},{73.37,0.57},{73.11,0.53},{73.07,0.15},{88.35,9.18},{88.57,9.15},{88.72,9.0},{88.81,8.76},{88.74,8.47},{88.54,8.38},{88.38,8.36},{88.21,8.41},{88.1,8.55},{88.03,8.76},{88.06,8.98},{88.14,9.16},},[405]={{86.07,94.82},{86.36,94.89},{86.68,94.9},{86.91,94.91},{87.3,94.93},{87.43,94.92},{87.54,94.91},{87.66,94.89},{87.88,94.85},{88.04,94.87},{88.25,94.98},{88.44,95.0},{88.58,95.01},{88.87,95.14},{88.67,95.05},{88.52,95.0},{88.25,95.01},{88.03,94.87},{87.92,94.86},{87.76,94.89},{87.54,94.92},{87.44,94.94},{87.29,94.93},{86.99,94.9},{86.78,94.91},{86.55,94.9},{86.14,94.84},{86.04,93.98},{85.85,93.61},{85.74,93.39},{85.63,93.16},{85.55,92.95},{85.66,92.72},{85.57,92.94},{85.61,93.08},{85.72,93.35},{85.85,93.6},{86.07,93.99},{86.08,94.26},{84.73,93.15},{84.53,93.35},{84.27,93.52},{84.09,93.58},{84.41,93.44},{84.58,93.28},{84.77,93.07},{84.91,92.88},{85.05,92.64},{85.22,92.36},{85.4,92.08},{85.28,92.3},{85.19,92.51},{85.18,92.71},{85.09,93.02},{84.91,93.31},{84.81,93.48},{84.76,93.57},{84.91,93.61},{85.09,93.48},{85.24,93.34},{85.37,93.18},{85.23,93.35},{85.08,93.49},{84.9,93.62},{84.75,93.57},{84.8,93.47},{84.91,93.32},{85.07,93.05},{85.18,92.71},{85.23,92.44},{85.29,92.3},{85.4,92.08},{85.21,92.4},{85.04,92.66},{84.9,92.91},},},215,nil,nil,39,nil,},
[2950] = {'Palemane Skinner',113,124,6,7,0,{[215]={{47.33,72.32},{48.03,73.28},{47.99,71.2},{48.24,72.09},{48.71,73.33},{48.56,71.81},{35.06,63.45},{30.34,59.67},{33.01,61.66},{31.67,60.68},{31.64,60.05},{29.59,60.29},{35.08,61.76},{32.41,61.12},{30.21,60.69},{30.68,60.96},{32.25,60.48},{30.56,60.52},{55.73,71.82},{54.45,71.64},{53.23,74.13},{52.59,73.16},{53.3,73.02},},},{[17]={{22.42,59.16},{22.42,59.16},{22.55,59.22},{22.76,59.3},{22.76,59.3},{22.63,59.25},{22.49,59.19},{22.41,59.15},{22.32,59.03},{22.34,59.09},{21.73,58.64},{21.79,58.57},{21.86,58.5},{21.9,58.44},{21.93,58.37},{21.9,58.42},{21.84,58.49},{21.78,58.57},{21.73,58.63},{21.71,58.69},{21.76,58.71},{21.82,58.68},{21.87,58.65},{21.93,58.6},{21.97,58.57},{22.02,58.57},{21.97,58.59},{21.93,58.61},{21.88,58.65},{21.82,58.69},{21.76,58.7},{21.73,58.69},{21.73,58.35},{21.69,58.38},{21.64,58.43},{21.57,58.5},{21.52,58.52},{21.44,58.54},{21.31,58.55},{21.43,58.56},{21.51,58.53},{21.57,58.49},{21.66,58.4},{21.69,58.38},{21.17,58.6},{21.12,58.6},{21.02,58.6},{20.93,58.57},{20.81,58.52},{20.73,58.48},{20.84,58.54},{20.93,58.59},{21.02,58.59},{21.08,58.59},},[215]={{33.02,61.66},{33.02,61.66},{33.28,61.76},{33.7,61.93},{33.7,61.93},{33.44,61.82},{33.18,61.71},{33.0,61.63},{32.83,61.4},{32.87,61.52},{31.67,60.63},{31.79,60.5},{31.92,60.34},{32.0,60.23},{32.07,60.09},{32.01,60.19},{31.89,60.34},{31.77,60.49},{31.67,60.61},{31.64,60.73},{31.74,60.76},{31.85,60.7},{31.94,60.64},{32.06,60.54},{32.13,60.5},{32.25,60.48},{32.15,60.52},{32.05,60.57},{31.96,60.64},{31.84,60.73},{31.72,60.74},{31.67,60.73},{31.68,60.05},{31.58,60.11},{31.49,60.21},{31.36,60.34},{31.26,60.39},{31.09,60.44},{30.84,60.45},{31.07,60.48},{31.23,60.4},{31.35,60.33},{31.54,60.15},{31.59,60.11},{30.55,60.54},{30.47,60.54},{30.26,60.54},{30.09,60.48},{29.86,60.38},{29.7,60.32},{29.91,60.43},{30.09,60.52},{30.28,60.53},{30.39,60.52},},[357]={{73.24,0.39},{73.24,0.39},{73.43,0.47},{73.74,0.59},{73.74,0.59},{73.55,0.51},{73.35,0.43},{73.23,0.37},{73.1,0.2},{73.13,0.29},},[405]={{86.34,94.63},{86.34,94.63},{86.64,94.74},{87.12,94.93},{87.12,94.93},{86.82,94.81},{86.52,94.69},{86.32,94.6},{86.12,94.33},{86.18,94.47},{84.8,93.45},{84.93,93.3},{85.08,93.12},{85.18,93.0},{85.26,92.84},{85.19,92.95},{85.05,93.12},{84.91,93.29},{84.8,93.43},{84.76,93.56},{84.88,93.6},{85.0,93.54},{85.11,93.46},{85.24,93.35},{85.33,93.3},{85.46,93.28},{85.35,93.33},{85.24,93.38},{85.14,93.46},{84.99,93.56},{84.86,93.58},{84.79,93.56},{84.81,92.78},{84.7,92.85},{84.6,92.97},{84.44,93.12},{84.33,93.17},{84.14,93.23},{83.86,93.24},{84.12,93.28},{84.29,93.19},{84.43,93.1},{84.65,92.91},{84.71,92.85},{83.53,93.35},{83.43,93.35},{83.19,93.35},{82.99,93.28},{82.73,93.17},{82.55,93.09},{82.79,93.22},{82.99,93.32},{83.21,93.34},{83.34,93.32},},},215,nil,nil,39,nil,},
[2951] = {'Palemane Poacher',137,156,7,8,0,{[215]={{30.99,60.43},{31.17,61.19},{31.34,61.68},{30.92,61.51},{30.21,61.55},{30.74,62.43},{30.74,60.45},{30.21,60.53},{30.29,61.13},{31.24,62.16},{30.41,61.82},{30.74,60.49},{55.24,73.06},{54.04,71.77},{54.91,72.94},{54.36,71.88},{53.6,72.42},{52.91,73.42},{53.12,72.54},},},{[17]={{32.62,65.2},{32.76,65.25},{32.9,65.21},{33.1,65.04},{33.3,64.93},{33.54,64.96},{33.5,64.68},{33.4,64.47},{33.19,64.32},{33.02,64.26},{32.79,64.19},{32.63,64.17},{32.51,64.35},{32.47,64.54},{32.47,64.83},{32.49,65.13},},[215]={{53.14,73.56},{53.42,73.66},{53.71,73.58},{54.09,73.24},{54.49,73.03},{54.96,73.09},{54.89,72.53},{54.68,72.13},{54.27,71.83},{53.94,71.71},{53.49,71.58},{53.18,71.54},{52.94,71.9},{52.85,72.26},{52.86,72.84},{52.9,73.43},},[357]={{88.11,9.19},{88.32,9.26},{88.53,9.2},{88.82,8.95},{89.11,8.79},{89.46,8.84},{89.4,8.43},{89.25,8.13},{88.95,7.91},{88.7,7.82},{88.37,7.72},{88.14,7.7},{87.96,7.96},{87.9,8.23},{87.91,8.65},{87.93,9.09},},},215,nil,nil,39,nil,},
[2952] = {'Bristleback Quilboar',71,86,3,4,0,{[215]={{57.79,81.7},{58.39,81.75},{59.21,84.75},{65.8,78.25},{60.75,75.3},{61.58,78.42},{61.51,77.09},{60.66,74.84},{61.57,78.76},{65.74,77.92},{62.95,77.28},{64.74,79.46},{60.74,76.78},{63.8,76.69},{63.68,76.96},{59.31,78.27},{59.34,78.53},{58.79,78.12},{58.4,78.34},{59.65,76.99},{60.09,78.13},{61.56,81.12},{62.33,79.66},{63.13,78.3},{64.33,79.04},{64.32,78.29},{64.16,77.79},{64.06,77.32},{58.52,79.78},{59.5,79.49},{60.43,84.2},{60.99,82.0},{62.21,82.12},{61.94,83.59},{62.33,81.53},{65.1,77.95},{59.29,84.03},{60.31,82.88},{60.14,82.28},{60.18,80.89},{64.0,78.31},{61.85,81.35},{59.94,80.0},{60.87,84.8},{64.47,77.65},{63.86,79.68},{59.7,79.17},{59.71,82.08},},},{[15]={{6.75,26.34},{6.7,26.52},{6.63,26.74},{6.55,26.89},{6.44,27.01},{6.31,27.14},{6.16,27.2},{6.02,27.21},{6.19,27.2},{6.29,27.15},{6.4,27.04},{6.53,26.88},{6.6,26.72},{6.69,26.51},{6.76,26.33},{0.44,26.5},{0.6,26.61},{0.76,26.64},{0.88,26.78},{0.93,26.98},{0.94,27.22},{0.9,27.49},{0.76,27.6},{0.59,27.62},{0.42,27.6},{0.3,27.57},{0.06,27.51},{0.14,26.61},{0.28,26.56},{0.49,31.86},{0.41,31.93},{0.32,32.03},{0.19,32.15},{0.09,32.2},{0.14,32.21},{0.27,32.1},{0.35,32.02},{0.44,31.92},{0.49,31.81},{0.57,31.66},{0.64,31.52},{0.72,31.38},{0.84,31.25},{0.76,31.34},{0.68,31.47},{0.62,31.57},{0.57,31.69},{0.52,31.8},{1.49,30.74},{1.61,30.69},{1.78,30.62},{1.91,30.56},{2.07,30.44},{2.19,30.35},{2.35,30.22},{2.25,30.3},{2.12,30.4},{2.02,30.47},{1.93,30.53},{1.81,30.61},{1.62,30.73},{1.45,30.85},{1.3,30.95},{1.11,31.08},{0.97,31.19},{1.09,31.13},{1.22,31.0},{1.32,30.91},{1.21,30.25},{1.21,30.25},{1.23,29.85},{1.23,29.85},{1.25,29.46},{1.28,29.06},{1.28,29.06},{1.26,29.46},{1.23,29.86},{1.2,30.24},{1.15,30.53},},[17]={{39.0,67.61},{38.98,67.7},{38.94,67.81},{38.9,67.89},{38.84,67.96},{38.77,68.02},{38.7,68.05},{38.63,68.06},{38.71,68.06},{38.76,68.03},{38.82,67.97},{38.89,67.89},{38.93,67.81},{38.97,67.7},{39.01,67.6},{35.73,67.69},{35.82,67.75},{35.9,67.76},{35.96,67.84},{35.99,67.94},{35.99,68.06},{35.97,68.2},{35.9,68.26},{35.81,68.27},{35.72,68.26},{35.66,68.25},{35.54,68.22},{35.45,68.16},{35.41,68.06},{35.38,67.95},{35.38,67.85},{35.42,67.8},{35.49,67.77},{35.58,67.75},{35.65,67.72},{35.76,70.47},{35.72,70.5},{35.67,70.55},{35.6,70.62},{35.55,70.64},{35.43,70.68},{35.41,70.7},{35.35,70.74},{35.29,70.83},{35.24,70.89},{35.17,70.98},{35.23,70.91},{35.29,70.84},{35.37,70.76},{35.4,70.72},{35.44,70.69},{35.5,70.67},{35.58,70.65},{35.64,70.59},{35.69,70.55},{35.73,70.5},{35.76,70.44},{35.8,70.36},{35.84,70.29},{35.88,70.22},{35.94,70.15},{35.9,70.2},{35.86,70.27},{35.83,70.31},{35.8,70.38},{35.77,70.44},{36.28,69.89},{36.34,69.86},{36.43,69.82},{36.49,69.79},{36.58,69.73},{36.64,69.69},{36.72,69.62},{36.67,69.66},{36.61,69.71},{36.55,69.75},{36.5,69.78},{36.44,69.82},{36.35,69.88},{36.26,69.94},{36.18,70.0},{36.08,70.07},{36.01,70.12},{36.07,70.09},{36.14,70.02},{36.19,69.97},{36.13,69.63},{36.13,69.63},{36.14,69.43},{36.14,69.43},{36.15,69.22},{36.17,69.02},{36.17,69.02},{36.16,69.22},{36.14,69.43},{36.13,69.63},{36.1,69.78},},[215]={{65.73,78.32},{65.68,78.5},{65.61,78.72},{65.53,78.88},{65.42,79.0},{65.29,79.14},{65.13,79.19},{64.99,79.21},{65.17,79.2},{65.26,79.15},{65.38,79.03},{65.52,78.87},{65.59,78.71},{65.68,78.49},{65.75,78.31},{59.29,78.48},{59.45,78.59},{59.61,78.62},{59.74,78.77},{59.79,78.97},{59.8,79.21},{59.76,79.49},{59.62,79.6},{59.44,79.62},{59.27,79.61},{59.14,79.58},{58.91,79.52},{58.74,79.4},{58.66,79.21},{58.6,78.99},{58.6,78.8},{58.68,78.7},{58.81,78.65},{58.98,78.59},{59.12,78.54},{59.34,83.95},{59.26,84.03},{59.17,84.13},{59.03,84.25},{58.94,84.3},{58.69,84.37},{58.64,84.41},{58.54,84.49},{58.41,84.67},{58.32,84.78},{58.19,84.97},{58.3,84.82},{58.41,84.69},{58.57,84.52},{58.63,84.46},{58.71,84.4},{58.82,84.37},{58.99,84.32},{59.11,84.21},{59.2,84.12},{59.29,84.02},{59.34,83.91},{59.42,83.75},{59.49,83.61},{59.58,83.46},{59.69,83.33},{59.62,83.43},{59.53,83.56},{59.47,83.66},{59.42,83.79},{59.37,83.89},{60.36,82.81},{60.49,82.76},{60.66,82.69},{60.79,82.63},{60.96,82.5},{61.08,82.42},{61.24,82.29},{61.14,82.36},{61.01,82.46},{60.9,82.53},{60.81,82.6},{60.69,82.68},{60.5,82.81},{60.33,82.92},{60.17,83.03},{59.98,83.16},{59.83,83.27},{59.95,83.21},{60.09,83.08},{60.19,82.98},{60.08,82.31},{60.08,82.31},{60.1,81.91},{60.1,81.91},{60.12,81.5},{60.15,81.1},{60.15,81.1},{60.12,81.51},{60.1,81.91},{60.06,82.3},{60.01,82.6},},[357]={{97.42,12.7},{97.38,12.84},{97.33,13.0},{97.27,13.12},{97.19,13.21},{97.09,13.31},{96.98,13.35},{96.88,13.36},{97.0,13.36},{97.07,13.32},{97.16,13.23},{97.26,13.11},{97.31,12.99},{97.38,12.83},{97.43,12.7},{92.66,12.82},{92.78,12.9},{92.9,12.93},{92.99,13.04},{93.02,13.19},{93.04,13.36},{93.01,13.57},{92.9,13.65},{92.77,13.67},{92.64,13.66},{92.55,13.63},{92.37,13.59},{92.25,13.5},{92.19,13.37},{92.15,13.2},{92.15,13.06},{92.21,12.99},{92.3,12.95},{92.43,12.91},{92.53,12.87},{92.69,16.87},{92.64,16.93},{92.57,17.0},{92.47,17.09},{92.4,17.13},{92.22,17.18},{92.18,17.21},{92.1,17.27},{92.01,17.4},{91.94,17.48},{91.84,17.62},{91.93,17.51},{92.01,17.41},{92.12,17.29},{92.17,17.25},{92.23,17.2},{92.31,17.18},{92.44,17.14},{92.53,17.06},{92.59,16.99},{92.66,16.92},{92.7,16.84},{92.76,16.72},{92.81,16.62},{92.87,16.51},{92.96,16.41},{92.9,16.48},{92.84,16.58},{92.79,16.65},{92.75,16.75},{92.72,16.83},{93.45,16.03},{93.54,15.99},{93.67,15.94},{93.77,15.89},{93.89,15.8},{93.98,15.73},{94.1,15.64},{94.02,15.69},{93.93,15.77},{93.85,15.82},{93.78,15.87},{93.69,15.93},{93.55,16.02},{93.42,16.11},{93.31,16.19},{93.17,16.29},{93.06,16.36},{93.15,16.32},{93.25,16.22},{93.32,16.15},{93.24,15.66},{93.24,15.66},{93.25,15.36},{93.25,15.36},{93.27,15.06},{93.3,14.76},{93.3,14.76},{93.28,15.06},{93.26,15.36},{93.23,15.65},{93.19,15.87},},},215,nil,nil,111,nil,},
[2953] = {'Bristleback Shaman',69,83,3,4,0,{[215]={{66.08,77.81},{65.95,77.09},{65.01,78.57},{63.65,76.25},{61.58,76.05},{61.74,75.82},{60.09,76.04},{59.96,75.27},{59.53,75.44},{63.27,82.85},{63.88,81.08},{63.81,79.82},{59.42,78.02},{64.74,77.86},},},nil,215,nil,nil,111,nil,},
[2954] = {'Bristleback Battleboar',86,102,4,5,0,{[215]={{65.64,77.93},{61.47,75.71},{60.97,86.47},{62.87,76.13},{63.73,81.71},{62.25,79.22},{58.99,77.21},{59.78,78.32},{61.09,80.65},{64.27,78.59},{63.95,77.59},{61.02,85.26},{63.72,78.42},{63.58,79.12},},},nil,215,nil,nil,111,nil,},
[2955] = {'Plainstrider',42,55,1,2,0,{[215]={{50.73,86.95},{53.3,86.27},{52.37,85.49},{53.93,84.27},{51.44,85.68},{50.11,86.97},{43.3,75.51},{42.1,77.28},{42.87,76.53},{52.78,82.69},{50.58,85.86},{46.72,87.57},{47.24,86.45},{47.85,88.16},{44.05,86.22},{45.24,87.88},{53.16,81.97},{51.99,81.85},{49.57,85.98},{48.6,87.68},{44.28,73.99},{46.51,73.65},{45.83,73.26},{44.93,74.22},{43.45,85.03},{52.23,74.84},{52.02,77.23},{46.63,85.2},{44.2,83.94},{49.44,83.4},{51.21,76.22},{43.31,81.7},{50.62,79.14},{47.91,86.59},{51.94,75.08},{51.53,74.93},{44.1,79.83},{50.63,77.02},{50.89,78.12},{46.52,75.0},{47.03,75.65},{47.7,75.25},{48.53,76.27},{47.51,79.14},{53.89,82.77},{48.01,77.12},{47.92,76.43},{48.91,76.93},{49.2,75.65},{49.94,75.27},{50.1,74.18},{50.96,76.16},{48.69,82.95},{48.3,80.4},{45.3,85.51},{46.22,86.88},{44.23,87.68},{50.53,88.71},{51.61,87.96},{52.56,87.51},{53.05,88.85},{53.92,86.94},{54.44,85.56},{53.4,84.07},{51.86,83.06},{51.18,83.11},{50.88,83.81},{49.9,83.43},{49.61,81.74},{49.31,80.36},{47.9,77.42},{49.6,77.84},{49.73,78.59},{51.44,79.02},{51.9,79.82},{52.23,81.33},{47.82,84.1},{48.6,79.6},{50.67,81.23},{43.63,79.11},{42.3,81.43},{42.29,82.29},{45.75,80.31},{45.42,84.15},{46.65,84.95},{44.63,83.75},{47.13,83.72},{46.03,80.6},{45.32,81.95},{46.66,80.97},{46.13,83.46},{46.61,82.23},{46.02,85.21},{48.15,81.81},{44.11,84.98},{45.44,79.15},{46.68,78.22},},},nil,215,nil,nil,189,"AH",},
[2956] = {'Adult Plainstrider',120,137,6,8,0,{[215]={{46.49,31.52},{58.38,46.83},{57.39,36.93},{59.47,57.06},{34.16,69.92},{35.06,66.43},{44.84,36.29},{34.88,79.88},{43.48,38.91},{34.98,74.37},{34.79,76.95},{45.83,37.22},{48.98,40.09},{52.47,45.07},{42.2,43.28},{55.11,36.86},{42.24,72.34},{40.88,73.19},{54.49,39.22},{36.99,51.04},{39.41,70.17},{36.63,49.99},{35.78,52.32},{37.58,61.35},{35.64,55.26},{36.8,57.99},{36.31,61.59},{35.88,56.69},{39.19,52.96},{57.35,42.97},{48.84,45.83},{36.84,65.82},{55.97,40.86},{38.83,54.3},{33.67,30.66},{41.11,68.97},{39.34,56.13},{54.65,41.95},{33.27,31.11},{36.44,53.89},{35.73,44.24},{46.03,71.18},{39.14,66.6},{45.14,71.11},{55.68,46.09},{44.85,40.81},{38.04,67.06},{39.63,66.32},{34.35,34.07},{37.59,35.29},{41.97,66.44},{62.58,54.76},{41.58,63.42},{42.8,67.43},{40.44,62.64},{40.82,68.26},{42.96,55.01},{61.66,59.65},{35.7,79.07},{39.97,56.88},{40.47,51.37},{38.21,63.46},{35.56,38.08},{43.69,51.4},{36.67,41.2},{43.73,43.92},{39.47,61.87},{37.77,75.17},{40.19,70.17},{52.51,60.64},{43.46,67.53},{39.46,52.16},{50.2,66.96},{47.89,68.31},{54.63,68.57},{53.88,61.63},{35.31,48.3},{58.43,72.27},{35.06,39.19},{56.55,57.68},{46.65,68.38},{49.12,66.41},{36.92,77.18},{36.9,73.2},{55.09,57.75},{36.98,69.38},{35.63,71.43},{36.35,68.43},{40.79,59.7},{57.76,67.36},{58.08,66.64},{45.4,45.08},{42.07,59.62},},},nil,215,nil,nil,189,"AH",},
[2957] = {'Elder Plainstrider',156,176,8,9,0,{[215]={{49.68,13.52},{55.72,25.58},{53.71,19.7},{49.62,38.14},{42.21,11.18},{50.05,33.47},{55.05,19.56},{57.04,27.94},{46.31,32.15},{55.75,33.73},{52.03,22.12},{56.78,32.54},{47.34,27.04},{52.01,39.41},{52.5,24.86},{53.2,14.06},{54.83,20.96},{53.06,18.37},{43.97,8.61},{39.74,8.76},{58.17,21.89},{52.49,34.37},{52.49,35.24},{50.62,8.09},{57.02,17.92},{47.66,25.25},{62.02,26.26},{49.81,29.32},{44.61,31.52},{47.32,18.63},{44.16,17.87},{46.81,14.0},{51.21,26.62},{43.75,10.2},{50.96,23.63},{52.57,32.48},{47.59,13.66},{49.22,29.63},{49.26,25.58},{51.26,10.07},{38.52,12.55},{37.38,14.79},{47.15,7.59},{38.35,17.09},{51.48,27.88},{53.94,12.64},{60.49,53.62},{51.23,18.59},{57.91,20.64},{60.68,25.6},{44.58,28.44},{53.95,31.31},{53.61,34.1},{56.04,29.5},{59.19,22.95},{57.79,30.31},{57.82,26.96},{51.22,42.18},{52.49,39.73},{41.58,11.49},{60.25,26.63},{54.46,24.62},{54.27,22.98},{54.03,28.94},{51.12,17.74},{57.7,53.89},{60.31,24.66},{40.8,50.07},{46.09,10.73},{50.48,14.0},{48.09,9.97},{45.82,18.53},{48.59,16.1},{41.13,13.22},{48.63,14.74},{47.33,10.15},{50.64,46.14},{46.02,17.02},{56.81,44.75},{37.11,43.04},{38.23,39.8},{46.1,44.26},{64.19,61.68},{55.66,50.63},{38.23,18.91},{43.29,47.0},{39.55,18.77},{42.72,18.57},{38.1,46.97},{53.9,44.09},{62.16,64.38},{60.97,64.55},{62.43,62.83},{64.17,63.52},{66.23,60.7},{68.22,59.65},{33.26,26.51},{47.87,36.54},{47.43,41.89},{55.9,56.42},},[1638]={{22.35,6.34},{64.21,23.02},},},nil,215,nil,nil,189,"AH",},
[2958] = {'Prairie Wolf',102,120,5,6,0,{[215]={{34.28,73.46},{36.49,71.5},{34.97,68.39},{33.92,77.48},{38.05,70.35},{33.66,76.27},{34.05,79.31},{34.91,71.26},{35.05,53.7},{39.87,52.61},{34.35,76.09},{38.25,71.16},{41.91,73.66},{43.08,71.33},{36.46,51.86},{37.46,64.41},{38.18,53.54},{34.94,52.59},{36.32,52.19},{38.23,55.66},{38.17,58.11},{37.83,56.59},{35.75,55.97},{36.05,57.66},{36.44,59.67},{41.57,51.79},{36.84,59.35},{40.03,58.73},{36.24,64.68},{35.73,65.43},{43.64,70.36},{42.05,63.82},{37.19,63.59},{36.38,60.97},{40.2,73.45},{44.85,67.29},{39.56,57.3},{45.9,69.29},{48.3,69.78},{47.63,69.08},{46.16,70.41},{42.16,54.98},{45.58,70.45},{36.9,56.43},{41.59,70.27},{39.75,63.66},{38.97,64.22},{39.51,67.48},{36.28,67.39},{37.78,69.48},{39.89,69.39},{38.09,61.82},{38.66,62.95},{40.85,66.13},{40.77,61.97},{40.71,66.44},{38.25,65.72},{36.57,65.24},{35.6,59.32},{37.65,66.4},{39.26,68.38},{40.8,53.98},{39.03,49.87},{39.98,68.63},{41.51,65.56},{41.62,68.19},{38.05,52.16},{42.95,66.65},{41.41,63.95},{39.15,50.87},{40.21,54.68},{55.02,65.83},{37.31,62.46},{40.79,60.74},{40.76,51.83},{37.77,75.59},{40.23,57.67},{39.02,74.04},{39.48,71.23},{49.82,65.3},{56.67,66.32},{53.43,69.81},{53.37,68.37},{39.6,55.65},{50.67,64.6},{55.35,70.39},{56.61,69.3},{51.88,66.71},{56.38,63.67},{48.63,67.45},{53.86,57.7},{55.78,62.69},{40.92,71.18},{35.03,77.94},{39.29,53.56},{56.3,65.79},{38.95,72.45},{34.95,76.15},{55.13,67.42},{36.31,72.37},{36.87,75.21},{37.83,58.59},{42.2,61.71},{35.61,73.36},{54.44,70.4},{36.3,70.38},{47.48,65.44},{51.27,67.45},{35.05,72.37},{54.31,59.29},{51.2,69.53},{50.58,68.37},{41.49,60.56},{35.69,69.4},{37.56,54.82},{35.69,75.25},{36.98,67.47},{42.21,55.71},},},nil,215,nil,nil,38,nil,},
[2959] = {'Prairie Stalker',137,156,7,8,0,{[215]={{59.12,71.1},{62.99,53.24},{45.23,35.5},{51.22,34.11},{57.74,70.44},{57.8,73.04},{35.51,50.97},{59.66,65.94},{58.02,44.62},{58.77,55.02},{57.13,44.45},{50.85,45.05},{58.13,42.84},{55.05,44.32},{57.63,46.44},{57.11,46.13},{52.62,43.22},{51.48,38.88},{57.87,68.23},{53.8,40.53},{38.34,40.02},{38.93,39.59},{58.17,50.76},{34.72,35.81},{60.46,63.33},{37.53,35.39},{59.35,45.46},{54.49,37.26},{55.43,48.15},{57.36,47.55},{61.12,67.74},{36.28,45.01},{35.42,49.98},{55.95,45.2},{57.56,47.22},{41.4,37.91},{55.81,44.02},{58.82,52.74},{42.84,52.95},{41.7,52.04},{34.2,31.05},{60.94,56.05},{48.68,31.08},{35.36,51.67},{35.01,43.0},{53.51,45.02},{47.41,32.6},{60.91,66.45},{54.13,41.31},{54.38,42.58},{58.92,64.6},{33.74,28.73},{50.21,36.87},{41.99,41.25},{60.26,55.44},{41.08,43.98},{39.52,42.36},{56.52,71.28},{46.97,37.84},{49.92,43.22},{49.94,48.02},{51.39,47.98},{51.9,46.3},{41.6,39.8},{52.45,45.0},{49.47,39.88},{48.01,42.15},{60.88,58.76},{51.88,40.04},{52.61,44.42},{49.01,43.13},{42.14,41.72},{57.2,65.57},{50.51,39.95},{49.34,36.21},{45.36,33.25},{58.99,67.19},{50.96,46.59},{48.6,37.78},{58.82,52.12},{46.66,35.37},{57.59,58.02},{45.56,34.23},{60.24,59.37},{54.47,44.21},{43.23,47.89},{60.34,61.71},{49.26,48.99},{45.0,49.07},{53.81,45.08},{42.78,41.49},{40.13,49.69},{60.64,60.71},{46.54,47.91},{43.36,46.59},{57.54,51.61},{44.55,47.74},{51.83,43.2},{42.19,43.19},{58.59,62.51},{42.15,46.03},{55.18,50.23},{41.84,51.01},{42.81,50.39},{46.13,33.57},{56.38,59.55},{51.17,44.18},{34.35,27.72},{61.8,69.31},{41.72,40.19},{40.93,42.19},{47.91,47.85},{57.19,55.95},{55.99,55.82},{46.76,47.03},{56.86,58.58},{46.61,48.93},{42.74,47.27},{49.31,47.11},{47.76,46.92},{45.35,39.97},{39.52,40.31},{55.78,57.85},{44.78,38.33},{41.46,49.19},{46.68,45.06},{48.03,39.18},{43.44,42.12},{44.8,40.11},{47.36,49.97},{41.44,45.17},{44.07,41.1},{57.0,62.49},{35.87,33.37},{36.97,34.34},{35.71,36.31},{37.14,35.86},},[1638]={{26.07,41.13},{26.36,39.58},{28.6,77.22},},},nil,215,nil,nil,38,nil,},
[2960] = {'Prairie Wolf Alpha',176,198,9,10,0,{[215]={{61.01,27.76},{46.18,26.64},{56.78,28.43},{45.91,27.98},{54.09,33.92},{50.46,29.63},{45.43,29.14},{49.27,14.08},{52.33,15.26},{45.49,27.28},{49.42,15.83},{46.53,28.81},{44.08,30.24},{53.08,13.02},{53.3,29.43},{66.75,66.52},{61.53,67.75},{61.68,68.32},{56.04,31.33},{51.13,14.18},{37.16,15.52},{62.22,66.35},{62.88,68.09},{64.66,67.78},{57.26,28.71},{57.44,31.3},{66.09,65.83},{50.92,16.6},{32.32,20.11},{64.76,67.17},{56.27,24.61},{59.02,28.99},{48.04,28.52},{58.21,27.9},{65.15,67.73},{52.02,19.92},{57.08,25.59},{45.41,26.59},{52.55,17.37},{52.75,20.66},{49.2,12.28},{50.63,12.93},{50.95,21.93},{36.31,15.84},{62.33,65.62},{45.35,17.74},{45.28,18.79},{54.57,21.54},{56.25,20.88},{62.26,58.42},{61.54,61.58},{62.07,56.24},{63.42,56.23},{66.18,58.81},{48.81,23.69},{57.08,20.77},{57.56,22.39},{53.86,24.09},{49.96,14.2},{42.73,10.08},{42.87,14.74},{45.3,15.91},{52.16,23.21},{57.44,24.85},{66.24,56.65},{63.52,69.21},{65.58,57.26},{64.01,59.7},{62.84,59.66},{63.2,58.7},{61.48,57.61},{66.87,58.14},{64.53,59.04},{62.26,57.71},{65.9,59.73},{66.86,60.37},{64.64,60.99},{66.98,64.83},{66.15,64.71},{66.72,58.78},{62.9,65.54},{63.67,60.66},{49.22,7.74},{51.26,9.09},{49.93,11.84},{40.82,11.1},{50.49,19.72},{49.09,27.18},{43.4,9.04},{44.38,30.32},{40.2,10.07},{49.06,30.69},{50.5,32.22},{40.74,18.58},{53.11,32.49},{62.83,61.72},{65.31,63.18},{65.52,65.42},{64.21,65.42},{66.77,63.58},{38.9,17.78},{41.52,8.05},},[1638]={{67.55,38.78},},},nil,215,nil,nil,38,nil,},
[2961] = {'Mountain Cougar',71,71,3,3,0,{[215]={{55.81,94.04},{56.43,92.71},{56.46,93.84},{56.09,94.67},{57.75,93.82},{57.86,92.34},{57.6,90.68},{41.61,90.67},{54.84,89.25},{42.8,83.63},{42.13,84.97},{42.45,85.94},{41.52,84.21},{55.07,90.5},{54.6,91.62},{55.91,90.41},{55.76,91.8},{56.52,91.06},{53.88,89.14},{41.64,87.35},{53.39,89.34},{42.04,87.94},{53.73,89.9},{47.87,91.77},{48.47,92.11},{49.19,91.57},{49.4,91.1},{48.75,89.0},{51.17,91.18},{52.03,92.37},{51.8,89.86},{52.27,90.84},{53.12,91.25},{53.15,92.52},{53.62,90.95},{53.86,90.73},{53.28,89.76},{49.98,90.43},{49.09,90.07},{50.54,89.82},{51.06,88.96},{52.54,89.24},{47.86,90.59},{48.63,91.4},{48.52,89.78},{46.79,92.06},{47.42,92.72},{40.13,83.29},{40.85,82.06},{51.86,89.85},{45.41,88.78},{44.2,94.45},{44.99,94.15},{44.83,92.83},{45.96,90.37},{46.03,89.84},{47.35,89.83},{49.81,87.74},{45.14,91.88},{45.75,89.62},{42.07,88.82},{42.74,87.66},{41.6,88.67},{40.79,88.87},{43.4,89.88},{43.33,88.51},{44.78,88.26},{43.64,89.97},{44.8,91.51},{43.23,91.26},{43.75,90.52},{43.71,92.12},{44.89,91.81},},},{[17]={{33.72,75.84},{33.95,75.58},{34.22,75.16},{34.31,74.93},{34.21,73.71},{34.3,75.48},{34.25,74.74},{34.11,75.9},{34.32,75.08},{34.19,74.49},{34.37,75.07},{34.95,75.47},{34.77,75.7},{34.56,75.68},{34.77,75.7},{34.95,75.47},{35.08,74.7},{35.04,75.26},{34.82,75.65},{35.06,75.2},{34.88,73.87},{35.05,73.97},{35.14,74.52},{35.0,74.54},{34.84,74.49},{34.99,74.54},{35.13,74.5},{35.06,73.92},{26.77,73.87},{26.77,73.87},{26.39,73.67},{33.51,73.04},{33.61,73.88},{33.52,74.54},{33.63,73.82},{27.37,70.3},{27.79,70.32},{27.39,70.29},{26.96,70.44},{27.19,71.46},{26.85,71.78},{27.19,71.46},{27.31,71.28},{27.18,71.46},{26.73,70.53},{26.71,70.61},{26.64,70.87},{26.53,70.83},{26.63,70.85},{26.7,70.6},{33.62,73.77},{33.34,74.4},{33.37,74.36},{33.41,73.53},{34.0,73.71},{33.64,73.42},{34.02,73.74},{33.72,74.68},{33.95,74.43},{33.78,74.77},{34.1,74.15},{34.36,74.02},{34.44,75.06},{33.04,73.1},{33.44,73.12},{26.79,72.19},{26.61,72.55},{26.79,72.19},{27.04,71.88},{26.79,72.22},{32.72,73.18},{32.84,73.98},{26.94,72.48},{27.22,72.82},{27.65,72.98},{27.76,73.24},{27.66,72.98},{27.22,72.83},{32.92,73.47},{32.99,74.51},{29.95,74.44},{30.08,74.76},{29.78,74.04},{30.22,74.54},{30.25,74.79},{30.16,73.48},{30.6,74.22},{30.64,74.31},{30.64,74.66},{30.74,74.08},{30.83,74.49},{30.75,74.09},{30.59,73.25},{30.42,73.04},{30.17,72.53},{30.39,73.0},{30.53,73.57},{31.61,74.13},{31.64,74.38},{31.48,73.49},{32.05,74.73},{32.0,74.3},{31.91,73.84},{31.78,73.1},{31.91,73.85},{31.99,74.27},{31.93,73.42},{31.99,73.96},{32.02,74.27},{31.95,73.43},{32.18,73.96},{32.19,74.73},{32.61,74.17},{32.19,73.91},{31.71,73.76},{31.5,73.82},{31.21,73.6},{31.53,73.83},{31.7,73.76},{32.15,73.88},{32.62,74.81},{32.64,75.0},{32.5,73.57},{32.83,73.93},{32.84,74.44},{32.81,73.13},{33.01,73.87},{33.02,74.35},{32.9,72.85},{32.65,73.33},{32.81,74.13},{31.03,73.69},{31.03,74.28},{31.02,73.68},{31.19,73.17},{30.54,73.57},{30.6,74.14},{30.54,73.6},{30.54,73.0},{31.28,73.43},{31.43,74.07},{31.31,73.48},{31.04,72.87},{31.56,72.97},{31.79,72.73},{32.07,72.44},{31.81,72.75},{32.35,73.1},{32.48,74.23},{32.34,73.04},{30.01,74.24},{29.9,73.68},{29.82,72.85},{30.32,74.21},{30.41,74.84},{30.31,74.17},{30.26,73.49},{30.26,73.49},{29.95,72.22},{30.27,73.53},{30.32,74.08},{29.39,74.58},{29.41,73.33},{29.42,72.45},{29.42,73.38},{29.74,75.12},{29.73,74.92},{29.73,74.48},{26.04,70.1},{26.37,70.29},{26.6,70.41},{26.37,70.29},{26.41,69.53},{26.7,70.02},{31.96,73.45},{31.79,72.72},{31.43,72.61},{31.26,72.7},{31.44,72.6},{31.8,72.72},{32.07,72.44},{28.73,72.89},{28.87,73.43},{29.13,74.44},{28.92,73.75},{28.78,72.88},{28.09,75.76},{28.34,75.82},{28.47,75.66},{28.33,75.83},{28.09,75.75},{28.47,75.65},{28.22,75.18},{28.15,74.65},{28.23,75.21},{28.48,75.63},{28.38,74.96},{28.13,74.63},{27.93,74.37},{28.15,74.43},{28.39,74.96},{28.97,73.72},{29.0,72.38},{29.02,73.31},{29.23,74.36},{29.35,73.72},{29.17,73.03},{29.68,73.43},{29.62,73.81},{29.64,74.74},{29.78,74.43},{29.83,73.64},{30.93,72.39},{30.78,71.64},{30.92,72.39},{30.88,72.99},{28.62,74.44},{28.68,74.69},{28.56,74.21},{28.57,73.07},{28.55,74.2},{28.9,73.34},{29.04,74.02},{28.77,72.85},{27.03,72.96},{26.77,73.23},{27.38,72.6},{27.35,72.28},{26.79,72.48},{27.49,72.23},{27.69,72.13},{27.47,72.25},{27.33,72.28},{26.81,72.87},{26.5,72.96},{27.28,72.71},{26.78,72.89},{26.36,72.95},{26.24,73.0},{26.36,72.95},{27.18,72.63},{27.74,73.4},{28.09,73.69},{28.35,73.87},{28.05,73.65},{27.65,72.83},{27.26,73.59},{27.88,72.29},{28.37,72.65},{28.11,74.2},{27.78,73.54},{28.15,73.47},{28.48,72.74},{28.17,73.47},{27.78,73.54},{28.39,74.3},{28.2,74.0},{28.37,74.28},{28.57,74.7},{27.59,74.17},{27.67,73.95},{27.73,73.21},{27.76,72.71},{27.72,73.2},{27.67,73.95},{27.82,73.82},{27.83,74.61},{27.83,73.81},{28.1,73.09},{27.86,74.64},{27.95,75.14},{28.01,74.03},{28.53,74.44},{28.32,73.93},},[215]={{55.33,94.56},{55.77,94.04},{56.3,93.22},{56.48,92.76},{56.28,90.36},{56.46,93.84},{56.35,92.39},{56.09,94.67},{56.51,93.06},{56.25,91.9},{56.61,93.04},{57.75,93.82},{57.38,94.29},{56.97,94.24},{57.39,94.28},{57.75,93.82},{58.01,92.3},{57.93,93.41},{57.49,94.17},{57.97,93.3},{57.6,90.68},{57.93,90.86},{58.13,91.96},{57.84,91.99},{57.52,91.9},{57.82,91.98},{58.1,91.91},{57.96,90.78},{41.61,90.67},{41.61,90.67},{40.85,90.27},{54.9,89.03},{55.1,90.69},{54.92,92.0},{55.14,90.58},{42.8,83.63},{43.62,83.67},{42.84,83.61},{41.98,83.9},{42.44,85.92},{41.78,86.54},{42.44,85.91},{42.67,85.57},{42.42,85.92},{41.54,84.07},{41.49,84.23},{41.34,84.74},{41.13,84.67},{41.33,84.71},{41.48,84.21},{55.12,90.48},{54.57,91.71},{54.63,91.63},{54.71,90.0},{55.86,90.36},{55.16,89.77},{55.91,90.41},{55.31,92.28},{55.78,91.77},{55.43,92.45},{56.06,91.22},{56.59,90.96},{56.73,93.01},{53.97,89.16},{54.77,89.19},{41.65,87.35},{41.3,88.06},{41.66,87.36},{42.13,86.74},{41.65,87.41},{53.35,89.3},{53.58,90.89},{41.95,87.93},{42.49,88.59},{43.35,88.91},{43.56,89.43},{43.37,88.91},{42.5,88.61},{53.74,89.87},{53.87,91.93},{47.88,91.8},{48.15,92.42},{47.56,91.0},{48.42,92.0},{48.47,92.49},{48.29,89.89},{49.17,91.37},{49.24,91.53},{49.25,92.22},{49.44,91.09},{49.63,91.89},{49.46,91.11},{49.14,89.45},{48.8,89.03},{48.32,88.03},{48.76,88.95},{49.03,90.08},{51.17,91.18},{51.22,91.68},{50.89,89.92},{52.03,92.37},{51.92,91.51},{51.75,90.62},{51.48,89.15},{51.75,90.63},{51.91,91.46},{51.79,89.78},{51.91,90.84},{51.97,91.45},{51.83,89.79},{52.27,90.84},{52.3,92.37},{53.12,91.25},{52.3,90.75},{51.35,90.46},{50.95,90.57},{50.36,90.13},{51.0,90.6},{51.34,90.45},{52.23,90.69},{53.15,92.52},{53.19,92.9},{52.92,90.08},{53.57,90.78},{53.58,91.8},{53.51,89.21},{53.92,90.67},{53.95,91.62},{53.7,88.67},{53.21,89.6},{53.53,91.19},{50.0,90.31},{50.0,91.48},{50.0,90.29},{50.33,89.29},{49.05,90.07},{49.16,91.2},{49.04,90.13},{49.04,88.96},{50.51,89.8},{50.8,91.06},{50.56,89.89},{50.04,88.69},{51.05,88.9},{51.52,88.42},{52.07,87.85},{51.55,88.45},{52.61,89.15},{52.86,91.38},{52.6,89.03},{48.01,91.41},{47.79,90.3},{47.62,88.66},{48.61,91.34},{48.78,92.58},{48.6,91.25},{48.5,89.93},{48.5,89.93},{47.89,87.41},{48.52,90.0},{48.61,91.09},{46.79,92.06},{46.82,89.61},{46.84,87.87},{46.83,89.7},{47.47,93.14},{47.45,92.75},{47.44,91.87},{40.18,83.23},{40.82,83.61},{41.27,83.85},{40.82,83.6},{40.89,82.1},{41.46,83.07},{51.85,89.83},{51.5,88.4},{50.81,88.18},{50.46,88.36},{50.83,88.16},{51.52,88.41},{52.07,87.84},{45.47,88.73},{45.76,89.8},{46.26,91.79},{45.85,90.44},{45.57,88.71},{44.22,94.4},{44.7,94.52},{44.97,94.19},{44.7,94.54},{44.21,94.38},{44.97,94.19},{44.47,93.26},{44.32,92.22},{44.48,93.32},{44.98,94.14},{44.78,92.82},{44.3,92.17},{43.89,91.66},{44.34,91.77},{44.8,92.83},{45.96,90.37},{46.01,87.72},{46.05,89.56},{46.46,91.64},{46.7,90.38},{46.35,89.01},{47.35,89.8},{47.22,90.55},{47.27,92.38},{47.55,91.78},{47.64,90.22},{49.81,87.74},{49.51,86.27},{49.79,87.75},{49.72,88.93},{45.26,91.8},{45.37,92.29},{45.14,91.33},{45.16,89.1},{45.13,91.32},{45.8,89.63},{46.09,90.97},{45.56,88.65},{42.12,88.87},{41.61,89.4},{42.81,88.17},{42.75,87.53},{41.64,87.94},{43.03,87.43},{43.43,87.23},{43.0,87.47},{42.72,87.54},{41.68,88.7},{41.09,88.87},{42.61,88.39},{41.63,88.74},{40.8,88.85},{40.57,88.96},{40.81,88.85},{42.42,88.22},{43.53,89.74},{44.21,90.31},{44.73,90.68},{44.14,90.23},{43.35,88.62},{42.58,90.11},{43.8,87.55},{44.78,88.26},{44.24,91.31},{43.61,90.01},{44.34,89.88},{44.97,88.44},{44.36,89.87},{43.61,90.01},{44.8,91.51},{44.43,90.93},{44.77,91.49},{45.16,92.31},{43.23,91.26},{43.38,90.83},{43.5,89.36},{43.56,88.37},{43.49,89.34},{43.38,90.83},{43.68,90.57},{43.7,92.13},{43.69,90.55},{44.24,89.14},{43.75,92.19},{43.94,93.18},{44.05,90.98},{45.09,91.79},{44.66,90.79},},[357]={{89.73,24.71},{90.06,24.32},{90.45,23.72},{90.58,23.38},{90.43,21.6},{90.57,24.18},{90.49,23.11},{90.29,24.79},{90.6,23.6},{90.41,22.74},{90.68,23.59},{91.52,24.17},{91.25,24.51},{90.95,24.47},{91.25,24.51},{91.52,24.17},{91.71,23.04},{91.65,23.86},{91.33,24.43},{91.68,23.78},{91.41,21.84},{91.66,21.97},{91.8,22.79},{91.58,22.81},{91.35,22.74},{91.57,22.81},{91.78,22.75},{91.68,21.91},{79.59,21.83},{79.59,21.83},{79.03,21.54},{89.41,20.62},{89.56,21.85},{89.43,22.82},{89.59,21.77},{80.47,16.63},{81.07,16.66},{80.5,16.62},{79.86,16.83},{80.2,18.32},{79.71,18.78},{80.21,18.32},{80.37,18.06},{80.19,18.32},{79.54,16.96},{79.5,17.07},{79.39,17.46},{79.24,17.4},{79.38,17.43},{79.49,17.06},{89.57,21.69},{89.17,22.6},{89.21,22.55},{89.28,21.34},{90.12,21.61},{89.61,21.17},{90.16,21.65},{89.72,23.02},{90.06,22.65},{89.81,23.15},{90.27,22.24},{90.66,22.05},{90.77,23.57},{88.73,20.72},{89.32,20.74},{79.62,19.38},{79.36,19.91},{79.62,19.39},{79.98,18.93},{79.62,19.42},{88.27,20.82},{88.44,22.0},{79.84,19.81},{80.24,20.3},{80.88,20.53},{81.03,20.92},{80.89,20.54},{80.25,20.31},{88.56,21.25},{88.65,22.77},{84.23,22.67},{84.42,23.13},{83.98,22.08},{84.63,22.82},{84.66,23.18},{84.53,21.26},{85.18,22.35},{85.23,22.47},{85.23,22.98},{85.38,22.15},{85.51,22.73},{85.39,22.16},{85.15,20.93},{84.91,20.62},{84.55,19.88},{84.87,20.57},{85.07,21.4},{86.65,22.21},{86.69,22.58},{86.45,21.28},{87.29,23.09},{87.21,22.46},{87.09,21.8},{86.89,20.71},{87.09,21.81},{87.2,22.42},{87.12,21.18},{87.2,21.96},{87.25,22.41},{87.14,21.19},{87.47,21.96},{87.49,23.09},{88.1,22.27},{87.49,21.89},{86.79,21.68},{86.49,21.76},{86.06,21.44},{86.53,21.78},{86.78,21.67},{87.44,21.85},{88.12,23.2},{88.15,23.48},{87.95,21.4},{88.43,21.92},{88.44,22.67},{88.39,20.75},{88.69,21.83},{88.71,22.54},{88.53,20.35},{88.16,21.04},{88.4,22.22},{85.8,21.57},{85.79,22.43},{85.79,21.55},{86.04,20.81},{85.09,21.39},{85.17,22.23},{85.08,21.44},{85.08,20.57},{86.17,21.19},{86.38,22.12},{86.21,21.26},{85.82,20.37},{86.57,20.52},{86.91,20.17},{87.32,19.75},{86.94,20.2},{87.72,20.71},{87.91,22.36},{87.71,20.62},{84.32,22.38},{84.16,21.56},{84.03,20.35},{84.77,22.33},{84.89,23.24},{84.75,22.27},{84.68,21.29},{84.68,21.29},{84.23,19.42},{84.7,21.34},{84.77,22.15},{83.42,22.86},{83.44,21.05},{83.46,19.77},{83.45,21.12},{83.92,23.66},{83.91,23.37},{83.9,22.72},{78.53,16.33},{79.0,16.62},{79.34,16.79},{79.01,16.61},{79.06,15.5},{79.48,16.22},{87.16,21.22},{86.9,20.16},{86.39,20.0},{86.13,20.13},{86.4,19.98},{86.92,20.16},{87.32,19.74},{82.44,20.4},{82.65,21.19},{83.03,22.66},{82.72,21.67},{82.52,20.39},{81.52,24.59},{81.87,24.68},{82.07,24.44},{81.87,24.69},{81.51,24.58},{82.07,24.43},{81.7,23.75},{81.6,22.98},{81.71,23.79},{82.08,24.4},{81.93,23.42},{81.58,22.94},{81.27,22.56},{81.61,22.65},{81.94,23.43},{82.8,21.61},{82.84,19.66},{82.87,21.02},{83.17,22.55},{83.35,21.62},{83.09,20.61},{83.83,21.19},{83.74,21.75},{83.78,23.1},{83.98,22.65},{84.05,21.5},{85.65,19.67},{85.43,18.58},{85.64,19.68},{85.58,20.55},{82.28,22.67},{82.37,23.03},{82.2,22.32},{82.21,20.67},{82.19,22.32},{82.69,21.07},{82.9,22.06},{82.51,20.34},{79.97,20.51},{79.59,20.9},{80.48,19.98},{80.43,19.51},{79.61,19.81},{80.64,19.44},{80.94,19.29},{80.61,19.47},{80.41,19.52},{79.64,20.38},{79.2,20.51},{80.33,20.15},{79.6,20.41},{78.99,20.49},{78.82,20.57},{79.0,20.49},{80.19,20.02},{81.01,21.15},{81.51,21.57},{81.9,21.84},{81.46,21.51},{80.88,20.32},{80.31,21.42},{81.21,19.53},{81.93,20.05},{81.54,22.31},{81.07,21.35},{81.6,21.25},{82.08,20.19},{81.62,21.25},{81.07,21.35},{81.94,22.46},{81.67,22.03},{81.93,22.44},{82.21,23.05},{80.79,22.27},{80.9,21.96},{80.99,20.87},{81.03,20.14},{80.98,20.85},{80.9,21.95},{81.12,21.76},{81.13,22.92},{81.13,21.75},{81.53,20.7},{81.17,22.96},{81.31,23.69},{81.39,22.07},{82.16,22.66},{81.84,21.93},},},215,nil,nil,7,"AH",},
[2962] = {'Windfury Harpy',137,156,7,8,0,{[215]={{34.27,42.14},{33.7,43.16},{67.51,69.52},{67.54,72.21},{66.74,68.39},{64.91,70.99},{32.43,41.1},{33.64,41.08},{32.32,42.08},{32.37,43.04},{31.15,42.21},{31.73,40.32},{31.73,42.24},{31.07,41.09},{61.62,71.4},{62.34,71.29},{63.56,70.42},{62.51,71.49},{62.94,70.51},{64.77,69.34},{64.14,70.41},{63.68,72.35},{65.58,68.44},{66.21,69.53},{66.07,70.21},{66.98,71.06},{66.81,70.25},},},nil,215,nil,nil,514,nil,},
[2963] = {'Windfury Wind Witch',148,166,8,9,0,{[215]={{34.4,44.05},{68.05,69.52},{34.31,41.19},{61.7,72.41},{66.11,68.36},{67.45,70.45},{66.88,69.59},{67.59,71.39},{67.98,71.22},{65.55,70.46},{33.65,42.02},{31.79,41.34},{34.23,43.14},{33.08,42.19},{33.05,43.02},{31.86,43.01},{33.78,40.3},{63.57,71.3},{65.35,69.06},},},nil,215,nil,nil,514,nil,},
[2964] = {'Windfury Sorceress',160,178,9,10,0,{[215]={{36.91,10.96},{35.0,13.67},{35.76,11.95},{36.26,9.86},{38.14,8.98},{39.5,8.01},{38.78,9.01},{28.41,21.31},{40.1,5.28},{39.55,6.1},{40.16,7.1},{37.93,8.06},{38.17,5.93},{53.41,6.02},{51.78,7.18},{51.8,5.28},{54.54,12.13},{54.35,10.71},{55.22,11.72},{56.35,15.79},{56.45,13.76},{55.82,17.06},{56.37,14.97},{29.19,21.02},{29.73,27.48},{31.09,19.64},{55.04,16.07},{29.17,22.78},{29.75,21.58},{30.5,20.71},{31.78,23.62},{29.7,26.39},{31.07,28.35},{29.65,24.68},{31.07,25.5},{29.76,23.8},{29.19,25.73},{30.38,25.74},{30.48,26.54},{30.38,22.83},{31.1,23.63},{31.78,20.84},{31.05,21.62},{31.59,22.85},{32.46,24.69},{36.89,12.03},{51.11,7.17},},},nil,215,nil,nil,514,nil,},
[2965] = {'Windfury Matriarch',186,208,10,11,0,{[215]={{36.28,10.94},{36.33,11.95},{35.19,12.82},{36.76,9.27},{39.4,5.13},{39.35,7.06},{40.79,5.22},{40.18,6.23},{40.07,8.15},{38.84,5.5},{37.93,7.03},{37.57,10.12},{38.18,7.93},{52.75,5.58},{51.96,6.06},{51.17,5.27},{55.66,12.26},{55.12,11.06},{55.15,9.87},{55.04,9.22},{56.31,12.92},{55.83,15.99},{51.23,6.04},{50.62,5.22},{32.43,23.59},{30.33,21.69},{28.99,21.72},{30.34,19.66},{29.72,19.61},{29.91,20.76},{30.34,27.62},{31.66,28.34},{32.41,27.56},{31.8,24.63},{31.07,27.66},{31.57,26.58},{31.12,26.51},{29.74,25.66},{29.84,22.56},{30.51,24.77},{30.93,24.53},{30.38,23.59},{31.76,21.74},{31.1,22.81},{32.49,25.41},{33.08,24.69},},[1638]={{13.17,23.17},},},nil,215,nil,nil,514,nil,},
[2966] = {'Battleboar',71,86,3,4,0,{[215]={{58.67,90.06},{59.46,90.55},{60.24,88.8},{59.57,90.45},{56.91,90.06},{59.38,88.59},{58.35,88.85},{55.86,87.91},{57.61,90.06},{52.38,75.04},{51.86,77.18},{53.97,76.94},{53.17,76.25},{54.4,76.31},{55.06,75.23},{55.01,77.15},{55.78,76.16},{58.15,88.05},{56.84,88.02},{57.61,86.71},{56.94,88.87},{52.62,79.26},{55.05,86.75},{56.5,87.48},{56.15,84.23},{56.26,85.22},{56.97,84.91},{56.45,84.06},{55.68,86.2},{55.11,85.7},{54.56,84.03},{52.61,80.16},{53.07,77.66},{53.28,79.29},{55.08,79.38},{55.16,78.05},{56.54,81.96},{56.06,81.95},{55.5,82.09},{54.99,81.85},{53.82,81.98},{54.97,80.84},{54.55,80.07},{54.26,81.85},{55.69,80.17},{56.46,85.89},},},nil,215,nil,nil,14,nil,},
[2967] = {'Galak Centaur',156,176,8,9,0,{[215]={{61.86,54.68},{65.04,65.18},{62.54,59.24},},},nil,215,nil,nil,131,nil,},
[2968] = {'Galak Outrunner',176,198,9,10,0,{[215]={{61.86,54.75},{65.06,65.24},{62.58,59.34},},},nil,215,nil,nil,131,nil,},
[2969] = {'Wiry Swoop',102,137,5,7,0,{[215]={{34.18,78.27},{44.68,70.43},{40.99,66.28},{35.11,66.52},{37.57,62.59},{37.95,66.41},{40.68,63.43},{40.56,54.27},{53.88,58.66},{55.15,70.36},{36.92,70.41},{39.5,70.35},{38.96,57.84},{49.91,68.59},{40.86,58.71},{37.06,59.05},{38.95,53.67},},},nil,215,nil,nil,73,nil,},
[2970] = {'Swoop',137,176,7,9,0,{[215]={{54.79,37.39},{51.72,34.79},{60.24,54.91},{52.08,37.19},{47.37,36.53},{44.72,34.89},{35.22,49.46},{56.74,46.1},{51.76,40.34},{55.34,42.3},{34.82,42.76},{36.18,44.93},{42.81,51.88},{52.1,44.12},{53.81,45.04},{53.82,40.74},{49.23,38.39},{37.62,41.16},{49.82,44.36},{58.28,51.96},{58.87,64.52},{46.15,49.65},{46.76,34.84},{42.25,43.54},{49.57,40.68},{57.43,48.62},{59.77,59.74},{42.77,39.85},{42.73,45.16},{49.01,48.01},{48.61,44.11},{57.73,68.36},{41.5,48.56},{43.32,49.21},},},nil,215,nil,nil,73,nil,},
[2971] = {'Taloned Swoop',156,198,8,10,0,{[215]={{48.91,9.2},{52.6,13.77},{50.82,28.93},{53.87,26.51},{55.51,32.43},{57.99,28.8},{51.68,20.05},{53.75,32.01},{57.76,22.4},{51.85,16.45},{46.69,10.06},{66.81,57.7},{46.59,13.42},{53.35,18.87},{64.91,59.57},{37.6,17.31},{42.17,9.97},{53.18,23.69},{52.24,30.27},},},nil,215,nil,nil,73,nil,},
[2972] = {'Kodo Calf',122,154,7,8,0,{[215]={{47.71,37.55},{48.02,37.9},{48.27,37.76},{44.47,52.66},{44.11,52.65},{57.53,31.35},{57.4,31.01},{57.47,31.21},{57.45,30.76},{39.72,66.3},{39.58,66.06},{39.43,66.51},},},nil,215,nil,nil,15,"AH",},
[2973] = {'Kodo Bull',195,198,10,11,0,{[215]={{39.74,66.61},{47.68,37.1},{43.39,53.73},},},nil,215,nil,nil,15,"AH",},
[2974] = {'Kodo Matriarch',220,265,11,12,0,{[215]={{39.41,66.31},{47.83,37.76},{61.09,69.38},{61.38,69.23},{47.8,38.56},{48.08,37.43},{44.64,52.18},{57.89,30.51},},},{[17]={{25.67,61.54},{24.9,60.69},{25.01,59.69},{24.75,58.19},{25.62,57.68},{26.49,58.64},{35.04,43.32},{35.1,43.19},{35.16,43.06},{35.21,42.93},{35.27,42.8},{35.33,42.67},{35.38,42.54},{35.46,42.34},{35.51,42.16},{35.53,41.98},{35.52,41.89},{35.48,41.74},{35.46,41.67},{35.34,41.42},{35.27,41.31},{35.19,41.2},{35.11,41.1},{35.03,41.0},{34.95,40.9},{34.87,40.82},{34.78,40.74},{34.69,40.66},{34.6,40.58},{34.51,40.5},{34.42,40.42},{34.33,40.35},{34.24,40.28},{34.14,40.21},{34.05,40.15},{33.95,40.1},{33.85,40.06},{33.75,40.03},{33.65,40.0},{33.54,39.97},{33.34,39.92},{33.34,39.92},{33.24,39.9},{33.13,39.89},{32.93,39.88},{32.82,39.87},{32.72,39.88},{32.72,39.88},{32.51,39.89},{32.41,39.91},{32.41,39.91},{32.31,39.93},{32.21,39.97},{32.1,40.01},{32.0,40.05},{31.9,40.09},{31.8,40.13},{31.71,40.17},{31.61,40.21},{31.51,40.26},{31.41,40.31},{31.26,40.41},{31.19,40.51},{31.12,40.63},{31.06,40.75},{31.06,40.75},{31.0,40.88},{30.89,41.15},{30.84,41.28},{30.84,41.28},{30.79,41.41},{30.74,41.55},{30.69,41.69},{30.65,41.83},{30.6,41.97},{30.55,42.11},{30.46,42.38},{30.41,42.52},{30.37,42.66},{30.37,42.66},{30.28,42.94},{30.28,42.94},{30.19,43.22},{30.15,43.37},{30.15,43.37},{30.07,43.65},{30.03,43.8},{30.0,43.94},{29.97,44.09},{29.97,44.09},{29.92,44.35},{29.92,44.41},{29.92,44.54},{29.93,44.7},{29.94,44.85},{29.96,45.01},{29.98,45.16},{30.01,45.31},{30.03,45.46},{30.05,45.61},{30.08,45.75},{30.11,45.89},{30.14,46.0},{30.16,46.07},{30.25,46.36},{30.3,46.5},{30.35,46.63},{30.39,46.72},{30.45,46.84},{30.56,46.99},{30.62,47.06},{30.68,47.11},{30.78,47.17},{30.87,47.22},{30.97,47.27},{31.07,47.31},{31.17,47.35},{31.27,47.39},{31.37,47.43},{31.47,47.46},{31.57,47.5},{31.67,47.54},{31.77,47.58},{31.88,47.61},{31.98,47.65},{32.08,47.69},{32.18,47.73},{32.28,47.76},{32.37,47.8},{32.37,47.8},{32.48,47.84},{32.58,47.87},{32.68,47.9},{32.78,47.93},{32.88,47.95},{32.99,47.96},{33.09,47.96},{33.17,47.96},{33.34,47.9},{33.44,47.83},{33.48,47.79},{33.57,47.69},{33.62,47.62},{33.62,47.62},{33.68,47.49},{33.74,47.36},{33.79,47.23},{33.98,46.67},{34.0,46.52},{34.03,46.37},{34.05,46.22},{34.08,46.07},{34.11,45.92},{34.14,45.77},{34.17,45.62},{34.21,45.47},{34.24,45.33},{34.27,45.18},{34.32,44.88},{34.35,44.73},{34.38,44.58},{34.41,44.43},{34.44,44.28},{34.48,44.15},{34.55,44.03},{34.62,43.92},{34.7,43.81},{34.84,43.63},{34.92,43.53},{34.99,43.42},},[215]={{39.45,66.34},{37.91,64.67},{38.14,62.7},{37.62,59.74},{39.34,58.74},{41.06,60.62},{57.92,30.4},{58.04,30.15},{58.15,29.89},{58.26,29.64},{58.38,29.38},{58.49,29.12},{58.6,28.87},{58.76,28.48},{58.86,28.11},{58.88,27.76},{58.86,27.58},{58.8,27.3},{58.75,27.15},{58.51,26.65},{58.37,26.43},{58.22,26.22},{58.07,26.02},{57.91,25.82},{57.75,25.64},{57.58,25.47},{57.4,25.31},{57.23,25.15},{57.05,24.99},{56.87,24.84},{56.7,24.69},{56.51,24.55},{56.33,24.41},{56.15,24.27},{55.96,24.16},{55.77,24.06},{55.57,23.98},{55.37,23.91},{55.17,23.85},{54.97,23.79},{54.57,23.7},{54.57,23.7},{54.36,23.67},{54.16,23.64},{53.75,23.61},{53.55,23.61},{53.34,23.62},{53.34,23.62},{52.93,23.65},{52.73,23.68},{52.73,23.68},{52.53,23.71},{52.33,23.79},{52.13,23.87},{51.93,23.95},{51.74,24.03},{51.54,24.11},{51.34,24.19},{51.15,24.28},{50.95,24.37},{50.76,24.47},{50.47,24.67},{50.33,24.87},{50.2,25.1},{50.07,25.34},{50.07,25.34},{49.96,25.6},{49.74,26.12},{49.64,26.38},{49.64,26.38},{49.54,26.65},{49.44,26.92},{49.35,27.19},{49.26,27.46},{49.16,27.74},{49.07,28.01},{48.89,28.56},{48.8,28.83},{48.7,29.1},{48.7,29.1},{48.52,29.66},{48.52,29.66},{48.36,30.22},{48.28,30.5},{48.28,30.5},{48.13,31.07},{48.05,31.35},{47.98,31.64},{47.91,31.93},{47.91,31.93},{47.83,32.43},{47.82,32.56},{47.82,32.82},{47.84,33.12},{47.87,33.43},{47.9,33.73},{47.94,34.03},{47.99,34.33},{48.04,34.63},{48.08,34.91},{48.14,35.21},{48.2,35.47},{48.26,35.69},{48.31,35.84},{48.48,36.39},{48.57,36.67},{48.66,36.94},{48.74,37.12},{48.87,37.35},{49.08,37.64},{49.21,37.78},{49.32,37.87},{49.51,38.0},{49.7,38.11},{49.9,38.2},{50.09,38.29},{50.29,38.36},{50.49,38.43},{50.69,38.51},{50.89,38.58},{51.08,38.65},{51.28,38.73},{51.48,38.8},{51.68,38.87},{51.88,38.95},{52.08,39.02},{52.27,39.1},{52.47,39.17},{52.66,39.24},{52.66,39.24},{52.86,39.31},{53.06,39.38},{53.26,39.45},{53.46,39.5},{53.66,39.54},{53.87,39.56},{54.07,39.56},{54.24,39.55},{54.56,39.44},{54.77,39.3},{54.85,39.22},{55.01,39.03},{55.13,38.89},{55.13,38.89},{55.24,38.64},{55.35,38.38},{55.46,38.12},{55.83,37.01},{55.87,36.71},{55.93,36.42},{55.98,36.12},{56.03,35.83},{56.09,35.53},{56.15,35.24},{56.22,34.95},{56.28,34.66},{56.34,34.36},{56.39,34.07},{56.5,33.48},{56.56,33.18},{56.61,32.89},{56.67,32.59},{56.74,32.31},{56.83,32.04},{56.96,31.81},{57.1,31.59},{57.25,31.38},{57.53,31.02},{57.68,30.82},{57.83,30.61},},[357]={{77.99,3.85},{76.86,2.62},{77.03,1.16},},[405]={{93.69,99.97},{91.93,98.07},{92.2,95.82},{91.6,92.43},{93.56,91.29},{95.53,93.44},},[1638]={{99.77,41.81},{99.77,41.81},{99.2,43.05},{98.14,45.61},{97.63,46.91},{97.63,46.91},{97.14,48.23},{96.66,49.56},{96.2,50.89},{95.74,52.24},{95.28,53.58},{94.83,54.93},{93.92,57.62},{93.47,58.97},{93.02,60.32},{93.02,60.32},{92.14,63.04},{92.14,63.04},{91.33,65.8},{90.94,67.19},{90.94,67.19},{90.18,69.98},{89.8,71.38},{89.44,72.79},{89.12,74.22},{89.12,74.22},{88.7,76.7},{88.66,77.35},{88.66,78.61},{88.77,80.11},{88.91,81.6},{89.08,83.09},{89.28,84.57},{89.51,86.04},{89.74,87.5},{89.97,88.92},{90.27,90.36},{90.56,91.65},{90.85,92.72},{91.06,93.46},{91.9,96.21},{92.34,97.56},{92.82,98.88},{93.22,99.75},},},215,nil,nil,15,"AH",},
[2975] = {'Venture Co. Hireling',102,120,5,6,0,{[215]={{54.18,67.04},{53.93,67.24},{54.3,66.49},{53.54,66.92},{53.3,66.79},{53.69,65.78},{54.33,65.82},{53.97,66.12},{53.34,65.67},{53.21,66.21},{53.55,66.31},},},nil,215,nil,nil,47,nil,},
[2976] = {'Venture Co. Laborer',120,137,6,7,0,{[215]={{53.8,47.19},{53.38,47.37},{53.22,48.87},{44.36,46.04},{44.16,44.88},{44.09,45.64},{53.91,66.58},{53.51,48.4},{53.74,48.88},{54.39,48.74},{54.41,48.05},{53.68,47.69},{44.81,45.44},{44.52,44.63},},},nil,215,nil,nil,47,nil,},
[2977] = {'Venture Co. Taskmaster',137,156,7,8,0,{[215]={{52.99,47.92},{53.8,48.38},{54.02,47.82},{44.84,44.87},{44.72,45.97},{44.52,44.87},{44.37,45.39},},},{[17]={{28.25,50.65},{28.32,50.69},{28.35,50.77},{28.37,50.9},{28.34,51.0},{28.28,51.06},{28.21,51.07},{28.15,51.04},{28.1,50.98},{28.08,50.95},{28.08,50.81},{28.09,50.75},{28.15,50.65},},[215]={{44.53,44.87},{44.67,44.95},{44.73,45.1},{44.76,45.35},{44.7,45.56},{44.59,45.67},{44.45,45.69},{44.33,45.63},{44.24,45.52},{44.2,45.46},{44.19,45.18},{44.21,45.07},{44.33,44.87},},[405]={{99.49,75.45},{99.66,75.54},{99.73,75.71},{99.76,75.99},{99.69,76.23},{99.56,76.36},{99.4,76.38},{99.26,76.32},{99.16,76.19},{99.12,76.11},{99.11,75.81},{99.13,75.67},{99.26,75.45},},},215,nil,nil,47,nil,},
[2978] = {'Venture Co. Worker',156,176,8,9,0,{[215]={{65.68,40.34},{62.12,35.24},{66.11,39.2},{61.06,39.79},{61.96,36.83},{66.79,39.29},{66.41,39.61},{61.69,35.6},{67.02,38.9},{66.9,38.79},{66.01,39.13},{64.86,38.81},{66.28,39.61},{62.08,35.67},{66.52,39.08},{61.23,35.36},{64.74,38.86},{61.21,39.86},{64.26,38.9},{65.21,37.41},{65.14,37.66},{65.24,38.33},{65.45,38.11},{65.3,37.54},{65.69,38.92},{65.4,37.92},{65.49,43.36},{65.76,43.41},{65.78,43.2},{62.36,38.83},{62.39,38.66},{63.17,41.22},{62.53,39.83},{61.42,36.95},{61.21,37.29},{61.01,37.51},{64.86,44.63},{64.98,42.99},{65.11,43.44},{64.45,42.55},{64.23,42.3},{64.58,42.78},{64.23,42.69},{62.95,43.55},{63.2,43.38},{63.31,41.74},{63.23,42.29},{63.07,42.67},{65.65,40.65},{65.35,40.7},{65.14,39.9},{65.44,41.2},{65.58,41.11},{59.99,42.91},{60.15,43.17},{40.28,16.93},{39.51,16.0},{39.56,14.97},{42.52,13.52},{42.48,14.38},{43.02,13.61},{40.76,16.01},{40.12,14.83},{40.22,15.9},{40.92,16.76},{62.73,37.34},{62.79,37.58},{60.25,36.35},{59.56,47.93},{59.96,48.02},{60.03,47.77},{59.66,48.71},{59.69,48.44},{59.96,48.54},{60.24,48.69},{60.06,49.12},{60.48,48.39},{60.43,49.18},{62.01,48.69},{60.69,48.96},{60.59,48.68},{61.94,47.84},{61.32,48.66},{62.11,48.17},{61.09,47.58},{61.0,47.21},{62.17,46.09},{61.88,46.36},{62.74,45.87},{62.06,45.57},{63.12,45.46},{62.54,44.43},{62.72,43.81},{63.5,44.86},{61.56,43.1},{62.31,44.06},{62.93,44.05},{61.11,42.64},{61.55,42.66},{61.98,43.22},{60.65,41.97},{63.39,41.28},{62.95,40.85},{62.98,42.2},{62.3,40.85},{62.46,41.46},{62.34,41.85},{62.63,42.25},{62.31,42.36},{61.88,42.31},{61.87,41.98},{61.59,41.58},{61.04,40.59},{62.93,39.99},{62.83,39.72},{63.34,40.12},{64.17,40.1},{64.03,40.4},{64.56,39.87},{62.95,37.96},{62.92,38.75},{62.85,38.6},{61.24,36.71},{62.73,38.14},{42.4,14.16},{43.04,14.32},{42.65,13.62},},},{[17]={{27.17,35.21},{27.25,35.26},{27.33,35.32},{27.41,35.33},{27.5,35.27},{27.56,35.15},{27.6,35.02},{27.59,34.9},{27.55,34.76},{27.47,34.65},{27.37,34.62},{27.27,34.66},{27.18,34.78},{27.14,34.89},{27.12,35.03},{27.14,35.14},{26.08,35.99},{26.19,35.95},{26.1,36.02},{26.05,36.13},{25.98,36.27},{25.89,36.08},{25.98,36.24},{25.99,36.09},{26.07,36.08},{26.13,35.79},{26.1,35.99},{25.95,36.18},},[215]={{42.4,14.4},{42.55,14.51},{42.71,14.63},{42.88,14.64},{43.04,14.53},{43.17,14.29},{43.24,14.03},{43.23,13.8},{43.14,13.51},{43.0,13.3},{42.79,13.24},{42.6,13.33},{42.43,13.56},{42.34,13.77},{42.3,14.05},{42.34,14.26},{40.26,15.94},{40.48,15.86},{40.29,16.0},{40.19,16.22},{40.06,16.5},{39.88,16.13},{40.05,16.44},{40.06,16.14},{40.24,16.12},{40.34,15.54},{40.29,15.95},{39.98,16.32},},[405]={{97.07,40.64},{97.23,40.76},{97.42,40.9},{97.61,40.91},{97.8,40.78},{97.94,40.5},{98.03,40.21},{98.01,39.95},{97.91,39.62},{97.75,39.37},{97.5,39.31},{97.29,39.41},{97.09,39.67},{96.99,39.92},{96.95,40.23},{97.0,40.48},{94.61,42.4},{94.86,42.3},{94.65,42.46},{94.53,42.71},{94.38,43.04},{94.19,42.61},{94.38,42.96},{94.39,42.63},{94.59,42.6},{94.71,41.94},{94.65,42.41},{94.3,42.83},},},215,nil,nil,47,nil,},
[2979] = {'Venture Co. Supervisor',176,198,9,10,0,{[215]={{65.61,39.88},{65.49,38.81},{59.07,35.01},{63.97,39.04},{58.92,35.01},{59.11,35.98},{60.17,34.19},{59.03,35.19},{65.2,38.93},{65.92,39.62},{59.07,36.64},{60.67,34.81},{62.19,38.48},{60.85,39.28},{60.69,38.2},{60.77,38.48},{60.86,38.03},{62.44,38.06},{61.03,38.0},{64.58,44.54},{64.44,39.08},{65.32,39.65},{64.8,44.1},{64.81,43.73},{42.65,14.15},{42.88,13.82},{40.02,15.62},{40.44,16.35},{63.68,38.96},{60.67,36.98},{60.97,37.22},{60.71,36.53},{60.44,36.6},{59.39,34.65},{64.38,43.11},{60.41,48.59},{60.22,48.29},{61.68,46.73},{61.4,47.46},{61.51,46.91},{62.33,45.9},{61.79,46.1},{62.34,45.63},{63.18,44.99},{63.25,44.88},{60.48,42.3},{62.88,41.32},{60.86,42.51},{60.86,41.94},{61.25,42.1},{62.2,39.58},{62.19,42.06},{62.65,40.7},{61.34,41.32},{62.77,42.03},{61.06,41.58},{61.1,41.13},{61.4,40.81},{61.87,41.24},{61.98,40.86},{61.62,41.04},{63.05,39.47},{63.53,40.94},{63.5,40.25},{64.9,39.63},{63.15,38.37},{60.97,36.77},},},{[17]={{38.98,48.08},{38.85,48.1},{38.72,47.67},{38.72,47.67},{38.74,47.95},{38.74,47.86},{38.73,47.74},{38.73,47.64},{37.2,47.46},{37.12,47.55},{37.01,47.59},{36.91,47.57},{36.87,47.5},{36.86,47.39},{36.87,47.33},{36.93,47.19},{37.0,47.09},{37.08,47.04},{37.18,47.05},{37.25,47.11},{37.3,47.21},{37.26,47.31},{37.24,47.37},{37.24,47.37},{37.22,47.31},{37.16,47.34},{38.33,47.73},{38.46,47.73},{38.52,47.73},{38.59,47.73},{38.66,47.72},{38.6,47.73},{38.5,47.73},{38.4,47.73},{38.31,47.73},{38.21,47.73},{38.14,47.72},{38.19,47.72},{38.25,47.72},{27.42,34.91},{27.44,34.99},{27.43,35.06},{27.39,35.12},{27.33,35.14},{27.26,35.07},{27.27,34.98},{27.32,34.89},{27.37,34.89},{36.34,46.4},{36.27,46.31},{36.19,46.2},{36.26,46.29},{36.33,46.38},{36.36,46.42},{36.91,51.61},{36.88,51.68},{36.86,51.76},{36.84,51.8},{36.81,51.89},{36.84,51.81},{36.85,51.77},{36.88,51.68},{36.92,51.6},{36.93,51.56},{36.96,51.48},{37.02,51.33},{37.11,51.27},{37.24,51.17},{37.35,51.08},{37.27,51.05},{37.1,51.13},{37.01,51.32},{36.95,51.5},{36.92,51.59},{36.81,51.96},{36.85,52.03},{36.91,52.12},{36.96,52.19},{37.0,52.27},{37.01,52.41},{37.01,52.47},{36.92,52.6},{36.83,52.74},{36.74,52.79},{36.84,52.71},{36.94,52.61},{37.01,52.47},{37.02,52.35},{36.98,52.22},{36.92,52.14},{36.87,52.07},{37.28,51.06},{37.35,51.03},{37.43,50.97},{37.5,50.87},{37.54,50.75},{37.55,50.61},{37.6,50.46},{37.7,50.39},{37.85,50.36},{37.83,50.47},{37.76,50.52},{37.63,50.6},{37.59,50.67},{37.53,50.83},{37.46,50.96},{37.39,51.04},{37.32,51.08},{37.24,51.09},{36.33,49.34},{36.33,49.34},{36.23,49.48},{36.1,49.7},{36.1,49.8},{36.15,49.82},{36.17,49.78},{36.29,49.54},{36.39,49.42},{36.42,49.4},{36.6,49.32},{36.64,49.21},{36.61,49.14},{36.54,49.15},{36.45,49.26},{36.45,49.26},{37.53,48.86},{37.47,48.72},{37.44,48.66},{37.38,48.53},{37.46,48.7},{37.48,48.76},{37.52,48.83},{37.57,48.94},{37.64,49.1},{37.57,48.98},{37.19,48.01},{37.27,48.18},{37.34,48.35},{37.28,48.31},{37.21,48.22},{37.14,48.14},{37.06,48.02},{37.11,47.96},{37.15,47.98},{37.2,49.25},{37.14,49.27},{37.07,49.27},{36.96,49.28},{36.86,49.27},{36.79,49.4},{36.71,49.4},{36.59,49.39},{36.66,49.29},{36.72,49.2},{36.8,49.15},{36.87,49.25},{37.0,49.26},{37.13,49.27},{37.24,49.26},{37.13,48.63},{37.19,48.55},{37.27,48.45},{37.35,48.36},{37.42,48.27},{37.51,48.18},{37.44,48.27},{37.44,48.27},{37.33,48.39},{37.18,48.57},{37.14,48.62},{38.57,47.95},{38.57,47.84},{38.56,47.7},{38.57,47.81},{36.6,46.53},{36.7,46.61},{36.78,46.6},{36.87,46.67},{36.99,46.76},{37.14,46.87},{37.01,46.78},{36.89,46.69},{36.79,46.62},{36.72,46.6},{36.56,46.56},},[215]={{65.69,39.79},{65.44,39.84},{65.18,38.99},{65.18,38.99},{65.22,39.53},{65.21,39.36},{65.2,39.12},{65.19,38.92},{62.17,38.58},{62.02,38.74},{61.81,38.82},{61.61,38.8},{61.54,38.66},{61.51,38.44},{61.54,38.32},{61.65,38.04},{61.78,37.84},{61.95,37.75},{62.15,37.77},{62.29,37.89},{62.39,38.07},{62.3,38.28},{62.26,38.39},{62.26,38.39},{62.22,38.27},{62.11,38.34},{64.41,39.1},{64.66,39.11},{64.79,39.11},{64.92,39.1},{65.06,39.09},{64.95,39.1},{64.74,39.1},{64.54,39.1},{64.37,39.1},{64.17,39.1},{64.04,39.09},{64.14,39.09},{64.26,39.09},{42.88,13.82},{42.93,13.97},{42.92,14.11},{42.83,14.24},{42.72,14.26},{42.58,14.13},{42.6,13.95},{42.69,13.78},{42.8,13.77},{60.49,36.49},{60.35,36.3},{60.19,36.08},{60.32,36.26},{60.46,36.45},{60.53,36.53},{61.61,46.76},{61.56,46.9},{61.5,47.05},{61.48,47.13},{61.42,47.31},{61.47,47.16},{61.5,47.08},{61.56,46.9},{61.62,46.73},{61.65,46.65},{61.71,46.49},{61.84,46.21},{62.01,46.09},{62.27,45.89},{62.48,45.72},{62.32,45.66},{61.99,45.81},{61.8,46.19},{61.69,46.55},{61.63,46.72},{61.42,47.46},{61.49,47.6},{61.6,47.77},{61.71,47.91},{61.79,48.06},{61.81,48.33},{61.8,48.46},{61.63,48.71},{61.45,48.99},{61.28,49.09},{61.47,48.94},{61.68,48.73},{61.82,48.46},{61.83,48.23},{61.74,47.95},{61.63,47.81},{61.52,47.66},{62.34,45.67},{62.47,45.62},{62.64,45.5},{62.78,45.3},{62.85,45.06},{62.88,44.78},{62.97,44.49},{63.17,44.35},{63.47,44.29},{63.42,44.52},{63.28,44.61},{63.02,44.77},{62.95,44.91},{62.84,45.21},{62.69,45.48},{62.55,45.64},{62.41,45.71},{62.26,45.74},{60.47,42.29},{60.47,42.29},{60.27,42.57},{60.01,42.99},{60.02,43.19},{60.1,43.22},{60.15,43.15},{60.38,42.67},{60.58,42.44},{60.65,42.41},{61.0,42.24},{61.08,42.02},{61.02,41.88},{60.89,41.9},{60.7,42.13},{60.7,42.13},{62.84,41.34},{62.72,41.05},{62.65,40.94},{62.53,40.69},{62.69,41.01},{62.74,41.13},{62.81,41.28},{62.91,41.49},{63.06,41.82},{62.92,41.57},{62.17,39.66},{62.31,40.0},{62.45,40.33},{62.34,40.25},{62.19,40.07},{62.06,39.91},{61.9,39.69},{62.0,39.55},{62.08,39.59},{62.18,42.1},{62.06,42.13},{61.92,42.14},{61.72,42.16},{61.51,42.14},{61.37,42.4},{61.22,42.4},{60.97,42.37},{61.12,42.18},{61.23,42.01},{61.39,41.9},{61.54,42.1},{61.79,42.13},{62.05,42.14},{62.26,42.12},{62.04,40.88},{62.16,40.73},{62.32,40.53},{62.48,40.34},{62.61,40.18},{62.78,40.0},{62.65,40.16},{62.65,40.16},{62.43,40.41},{62.15,40.76},{62.07,40.85},{64.88,39.54},{64.88,39.32},{64.87,39.04},{64.88,39.25},{61.01,36.74},{61.2,36.9},{61.34,36.87},{61.52,37.02},{61.77,37.19},{62.06,37.41},{61.81,37.23},{61.57,37.05},{61.37,36.91},{61.24,36.88},{60.92,36.79},},[405]={{97.61,39.98},{97.67,40.14},{97.65,40.31},{97.55,40.45},{97.42,40.48},{97.27,40.33},{97.29,40.12},{97.39,39.92},{97.52,39.92},},},215,nil,nil,47,nil,},
[2980] = {'Grull Hawkwind',138,138,4,4,0,{[215]={{44.88,77.07},},},nil,215,{747,750,780,3091,3092,3093,3094,},{747,750,780,},104,"H",},
[2981] = {'Chief Hawkwind',2100,2100,36,36,0,{[215]={{44.18,76.06},},},nil,215,{752,755,763,},{753,757,781,},104,"H",},
[2982] = {'Seer Graytongue',334,334,8,8,0,{[215]={{42.57,92.19},},},nil,215,{757,},{755,},104,"H",},
[2983] = {'The Plains Vision',228,228,7,7,0,nil,nil,0,nil,nil,35,"AH",},
[2984] = {'Seer Wiserunner',456,456,11,11,0,{[215]={{32.71,36.09},},},nil,215,{773,},{772,},104,"H",},
[2985] = {'Ruul Eagletalon',372,372,9,9,0,{[215]={{47.35,62.02},},},nil,215,{743,},{743,},104,"H",},
[2986] = {'Dorn Plainstalker',1528,1528,29,29,0,{[400]={{53.95,41.49},},},nil,400,{1149,1150,1151,1152,},{1149,1150,1151,1394,},104,"H",},
[2987] = {'Eyahn Eagletalon',500,500,12,12,0,{[1638]={{37.75,59.57},},},nil,1638,{744,},{744,},83,"H",},
[2988] = {'Morin Cloudstalker',413,413,10,10,0,{[215]={{57.2,61.22},},},{[17]={{34.68,58.94},{34.85,58.99},{35.08,59.1},{35.24,59.19},{35.4,59.28},{35.56,59.37},{35.73,59.46},{35.89,59.55},{36.05,59.63},{36.21,59.72},{36.38,59.81},{36.6,59.93},{36.81,60.02},{37.03,60.06},{37.42,60.04},{37.52,60.03},{37.73,59.99},{38.1,59.84},{38.43,59.68},{38.53,59.63},{38.86,59.49},{39.03,59.42},{39.19,59.35},{39.34,59.29},{39.53,59.18},{39.68,59.07},{39.84,58.96},{39.99,58.85},{40.17,58.75},{40.45,58.65},{40.7,58.59},{40.87,58.58},{40.6,58.58},{40.38,58.65},{40.26,58.69},{39.91,58.87},{39.7,59.03},{39.61,59.1},{39.38,59.25},{39.18,59.34},{39.01,59.41},{38.84,59.48},{38.68,59.55},{38.51,59.63},{38.35,59.7},{38.18,59.77},{38.02,59.84},{37.85,59.91},{37.62,60.01},{37.41,60.06},{37.19,60.08},{37.02,60.05},{36.79,60.01},{36.6,59.94},{36.44,59.85},{36.28,59.75},{36.12,59.65},{35.96,59.55},{35.8,59.46},{35.38,59.23},{35.28,59.17},{35.12,59.09},{34.87,58.98},{34.7,58.93},{34.52,58.88},{34.35,58.86},{34.16,58.84},{33.96,58.78},{33.75,58.67},{33.53,58.6},{33.31,58.55},{33.03,58.55},{32.81,58.53},{32.59,58.46},{32.26,58.29},{32.05,58.18},{31.95,58.08},{32.16,58.24},{32.36,58.37},{32.54,58.45},{32.64,58.49},{32.87,58.54},{33.04,58.56},{33.21,58.58},{33.38,58.6},{33.57,58.63},{33.78,58.69},{34.0,58.81},{34.23,58.88},{34.54,58.9},},[215]={{57.2,61.22},{57.55,61.32},{57.99,61.54},{58.31,61.72},{58.64,61.89},{58.96,62.06},{59.28,62.24},{59.6,62.41},{59.92,62.59},{60.24,62.76},{60.56,62.93},{60.99,63.17},{61.42,63.34},{61.84,63.43},{62.62,63.39},{62.82,63.37},{63.22,63.3},{63.97,63.0},{64.61,62.68},{64.81,62.59},{65.46,62.31},{65.79,62.16},{66.12,62.02},{66.4,61.9},{66.77,61.69},{67.08,61.47},{67.39,61.25},{67.68,61.04},{68.04,60.85},{68.58,60.64},{69.08,60.52},{69.42,60.51},{68.89,60.5},{68.45,60.64},{68.22,60.72},{67.52,61.09},{67.11,61.4},{66.93,61.54},{66.47,61.83},{66.08,62.0},{65.75,62.14},{65.43,62.28},{65.1,62.43},{64.77,62.57},{64.44,62.71},{64.12,62.85},{63.79,63.0},{63.46,63.14},{63.02,63.33},{62.59,63.44},{62.16,63.46},{61.82,63.41},{61.37,63.33},{61.01,63.2},{60.69,63.0},{60.37,62.81},{60.06,62.62},{59.74,62.43},{59.43,62.24},{58.6,61.79},{58.39,61.67},{58.07,61.52},{57.59,61.29},{57.26,61.2},{56.89,61.1},{56.55,61.06},{56.18,61.02},{55.79,60.91},{55.37,60.69},{54.94,60.54},{54.51,60.45},{53.97,60.45},{53.53,60.4},{53.09,60.28},{52.45,59.94},{52.03,59.72},{51.82,59.51},{52.25,59.83},{52.63,60.09},{53.0,60.25},{53.2,60.33},{53.63,60.44},{53.97,60.47},{54.31,60.51},{54.65,60.55},{55.02,60.6},{55.43,60.73},{55.88,60.97},{56.32,61.09},{56.94,61.13},},[357]={{91.12,0.06},{91.37,0.14},{91.7,0.3},{91.94,0.43},{92.17,0.56},{92.41,0.69},{92.65,0.82},{92.88,0.95},{93.12,1.08},{93.36,1.2},{93.6,1.33},{93.91,1.51},{94.23,1.63},{94.55,1.7},{95.12,1.67},{95.26,1.66},{95.56,1.6},{96.12,1.38},{96.59,1.15},{96.74,1.08},{97.22,0.87},{97.46,0.76},{97.7,0.66},{97.91,0.57},{98.19,0.41},{98.42,0.25},{98.64,0.09},{98.44,0.2},{98.31,0.3},{97.97,0.51},{97.68,0.64},{97.44,0.75},{97.19,0.85},{96.95,0.96},{96.71,1.06},{96.47,1.17},{96.23,1.27},{95.99,1.38},{95.74,1.49},{95.41,1.63},{95.1,1.7},{94.78,1.72},{94.53,1.68},{94.2,1.62},{93.93,1.53},{93.69,1.38},{93.46,1.24},{93.23,1.1},{92.99,0.96},{92.76,0.82},{92.15,0.49},{92.0,0.4},{91.76,0.28},{91.4,0.12},{91.16,0.05},{90.92,0.0},},[15]={{0.11,10.44},{0.43,10.61},{0.74,10.78},{1.05,10.95},{1.37,11.12},{1.68,11.29},{2.1,11.52},{2.52,11.69},{2.94,11.77},{3.7,11.73},{3.89,11.72},{4.29,11.64},{5.02,11.36},{5.65,11.04},{5.84,10.95},{6.48,10.67},{6.8,10.53},{7.12,10.4},{7.39,10.28},{7.76,10.07},{8.06,9.85},{8.36,9.64},{8.65,9.44},{9.01,9.25},{9.54,9.05},{10.02,8.93},{10.36,8.91},{9.84,8.91},{9.4,9.04},{9.17,9.13},{8.49,9.48},{8.1,9.78},{7.92,9.92},{7.47,10.2},{7.08,10.37},{6.76,10.51},{6.44,10.65},{6.12,10.79},{5.8,10.93},{5.48,11.07},{5.16,11.21},{4.84,11.35},{4.52,11.49},{4.09,11.68},{3.67,11.78},{3.25,11.8},{2.92,11.75},{2.48,11.67},{2.12,11.54},{1.81,11.36},{1.5,11.17},{1.19,10.98},{0.88,10.79},{0.57,10.61},},},215,{749,764,765,},{751,764,765,},104,"H",},
[2989] = {'Bael\'dun Digger',137,156,7,8,0,{[215]={{31.98,47.35},{31.39,47.64},{33.81,49.7},{32.72,49.14},{31.47,48.83},{32.3,49.18},{32.13,49.65},{31.07,50.17},{31.86,50.45},{32.06,49.99},{34.27,47.91},{33.68,49.05},{34.38,47.14},{33.76,48.05},{30.87,48.5},{31.64,47.61},{30.85,48.84},{30.86,49.22},{31.02,47.93},{30.92,49.86},{31.66,48.89},},},{[17]={{21.67,52.66},{21.79,52.56},{21.85,52.5},{21.92,52.46},{21.96,52.59},{21.94,52.71},{21.88,52.83},{21.81,52.9},{21.74,52.87},{21.65,52.76},{23.05,52.21},{23.11,52.14},{23.17,52.05},{23.13,52.14},{23.05,52.26},{22.92,52.34},{22.78,52.35},{22.72,52.34},{22.64,52.35},{22.53,52.38},{22.49,52.44},{22.45,52.53},{22.37,52.7},{22.44,52.56},{22.49,52.46},{22.55,52.38},{22.63,52.34},{22.72,52.34},{22.8,52.33},{22.88,52.34},{22.99,52.28},},[215]={{31.54,48.84},{31.78,48.63},{31.91,48.52},{32.04,48.44},{32.13,48.7},{32.08,48.93},{31.97,49.17},{31.83,49.31},{31.69,49.24},{31.51,49.02},{34.27,47.94},{34.39,47.81},{34.51,47.62},{34.42,47.79},{34.26,48.05},{34.02,48.21},{33.74,48.22},{33.61,48.2},{33.47,48.22},{33.25,48.27},{33.18,48.4},{33.09,48.57},{32.93,48.9},{33.07,48.63},{33.17,48.44},{33.29,48.28},{33.45,48.19},{33.62,48.19},{33.78,48.19},{33.94,48.2},{34.16,48.08},},[405]={{84.65,79.98},{84.92,79.74},{85.08,79.61},{85.22,79.53},{85.32,79.82},{85.27,80.08},{85.14,80.36},{84.99,80.52},{84.82,80.44},{84.61,80.19},{87.77,78.95},{87.91,78.81},{88.05,78.59},{87.95,78.79},{87.76,79.08},{87.48,79.26},{87.17,79.28},{87.02,79.25},{86.86,79.27},{86.61,79.33},{86.52,79.47},{86.42,79.68},{86.23,80.05},{86.4,79.74},{86.51,79.53},{86.65,79.34},{86.83,79.24},{87.03,79.24},{87.22,79.24},{87.4,79.26},{87.64,79.11},},},215,nil,nil,57,"A",},
[2990] = {'Bael\'dun Appraiser',143,160,8,9,0,{[215]={{31.31,48.28},{31.89,47.86},{33.22,47.5},{33.03,47.54},{31.6,48.43},{31.25,48.77},{31.47,49.43},{31.47,48.77},{32.74,48.31},{31.82,49.73},{32.03,49.65},{31.37,49.86},{31.3,48.74},},},{[17]={{21.52,52.63},{21.64,52.61},{21.78,52.61},{21.85,52.61},{21.95,52.62},{22.05,52.62},{22.14,52.65},{22.22,52.7},{22.28,52.71},{22.34,52.7},{22.37,52.68},{22.43,52.55},{22.5,52.41},{22.52,52.29},{22.51,52.2},{22.47,52.09},{22.53,52.25},{22.54,52.31},{22.52,52.47},{22.49,52.56},{22.45,52.66},{22.41,52.71},{22.33,52.75},{22.26,52.74},{22.19,52.7},{22.11,52.65},{22.05,52.63},{21.99,52.61},{21.86,52.63},{21.81,52.63},{21.71,52.62},{21.6,52.61},{21.63,52.63},{21.63,52.89},{21.63,52.67},{21.63,52.47},{21.81,53.11},{21.81,53.21},{21.76,53.22},{21.71,53.22},{21.71,53.12},{21.71,53.03},{21.79,53.03},{21.91,53.08},{21.88,53.23},{21.87,53.36},{21.8,53.41},{21.64,53.39},{21.56,53.37},{21.48,53.33},{21.42,53.23},{21.41,53.16},{21.41,52.96},{21.41,52.77},{21.39,52.6},{21.39,52.44},{21.4,52.34},{21.44,52.23},{21.54,52.18},{21.63,52.17},{21.7,52.18},{21.78,52.23},{21.86,52.31},{21.91,52.4},{21.94,52.49},{21.96,52.59},{21.96,52.7},{21.96,52.83},{21.94,52.95},},[215]={{31.25,48.77},{31.49,48.74},{31.76,48.74},{31.9,48.74},{32.1,48.74},{32.29,48.76},{32.47,48.8},{32.64,48.9},{32.76,48.94},{32.87,48.92},{32.92,48.87},{33.04,48.61},{33.19,48.34},{33.22,48.1},{33.2,47.92},{33.13,47.71},{33.24,48.03},{33.26,48.14},{33.22,48.46},{33.16,48.64},{33.08,48.82},{33.01,48.93},{32.86,49.02},{32.72,48.98},{32.58,48.91},{32.42,48.8},{32.31,48.76},{32.18,48.74},{31.93,48.77},{31.83,48.77},{31.63,48.75},{31.41,48.74},{31.47,48.77},{31.47,49.29},{31.47,48.84},{31.47,48.45},{31.83,49.73},{31.82,49.91},{31.72,49.93},{31.63,49.93},{31.63,49.74},{31.64,49.56},{31.8,49.56},{32.02,49.66},{31.97,49.96},{31.94,50.2},{31.8,50.3},{31.5,50.26},{31.34,50.23},{31.18,50.16},{31.06,49.96},{31.04,49.82},{31.05,49.41},{31.04,49.06},{31.01,48.7},{31.01,48.4},{31.01,48.19},{31.1,47.99},{31.29,47.88},{31.48,47.86},{31.62,47.88},{31.78,47.98},{31.92,48.14},{32.03,48.31},{32.09,48.49},{32.12,48.7},{32.13,48.9},{32.12,49.17},{32.09,49.4},},[405]={{84.32,79.9},{84.59,79.86},{84.91,79.86},{85.06,79.87},{85.3,79.87},{85.51,79.89},{85.71,79.94},{85.91,80.05},{86.04,80.09},{86.17,80.07},{86.23,80.01},{86.37,79.72},{86.54,79.41},{86.57,79.13},{86.55,78.92},{86.47,78.69},{86.6,79.05},{86.62,79.19},{86.58,79.55},{86.5,79.75},{86.42,79.96},{86.33,80.09},{86.15,80.18},{86.0,80.14},{85.84,80.07},{85.66,79.94},{85.53,79.89},{85.38,79.87},{85.1,79.9},{84.98,79.9},{84.75,79.88},{84.5,79.86},{84.57,79.91},{84.58,80.5},{84.57,79.98},{84.57,79.54},{84.98,80.99},{84.98,81.2},{84.86,81.22},{84.75,81.23},{84.76,81.0},{84.76,80.81},{84.94,80.8},{85.2,80.92},{85.14,81.26},{85.11,81.54},{84.95,81.65},{84.6,81.61},{84.42,81.57},{84.24,81.49},{84.11,81.26},{84.08,81.1},{84.09,80.64},{84.08,80.23},{84.04,79.83},{84.04,79.48},{84.05,79.24},{84.14,79.0},{84.36,78.88},{84.58,78.86},{84.74,78.89},{84.92,79.0},{85.09,79.18},{85.21,79.38},{85.28,79.59},{85.31,79.82},{85.32,80.06},{85.32,80.36},{85.28,80.62},},},215,nil,nil,57,"A",},
[2991] = {'Greatmother Hawkwind',372,372,9,9,0,{[215]={{50.03,81.16},},},nil,215,{753,},{752,},104,"H",},
[2992] = {'Healing Ward V',1454,1454,28,28,0,nil,nil,0,nil,nil,152,nil,},
[2993] = {'Baine Bloodhoof',413,413,10,10,0,{[215]={{47.51,60.16},},},nil,215,{745,746,767,},{745,746,763,},104,"H",},
[2994] = {'Ancestral Spirit',176,176,9,9,0,{[215]={{61.45,21.02},},},nil,215,{775,},{773,},104,"H",},
[2995] = {'Tal',7842,7842,55,55,1,{[1638]={{47.0,49.83},},},nil,1638,{6364,},{6363,},104,"H",},
[2996] = {'Torn',2972,2972,45,45,0,{[1638]={{47.63,58.58},},},nil,1638,nil,nil,104,"H",},
[2997] = {'Jyn Stonehoof',1605,1605,30,30,0,{[1638]={{41.42,62.36},},},nil,1638,nil,nil,104,"H",},
[2998] = {'Karn Stonehoof',2016,2016,35,35,0,{[1638]={{39.38,55.09},},},nil,1638,nil,nil,104,"H",},
[2999] = {'Taur Stonehoof',1605,1605,30,30,0,{[1638]={{39.82,55.65},},},nil,1638,nil,nil,104,"H",},
[3000] = {'Gibbert',2972,2972,45,45,0,{[490]={{44.1,7.19},},},nil,490,nil,nil,35,"AH",},
[3001] = {'Brek Stonehoof',2016,2016,35,35,0,{[1638]={{34.37,57.9},},},nil,1638,nil,nil,104,"H",},
[3002] = {'Kurm Stonehoof',2471,2471,40,40,0,{[1638]={{34.35,56.56},},},nil,1638,nil,nil,104,"H",},
[3003] = {'Fyr Mistrunner',1605,1605,30,30,0,{[1638]={{41.44,53.19},},},nil,1638,nil,nil,104,"H",},
[3004] = {'Tepa',2016,2016,35,35,0,{[1638]={{44.52,45.35},},},nil,1638,nil,nil,104,"H",},
[3005] = {'Mahu',1605,1605,30,30,0,{[1638]={{43.8,45.12},},},nil,1638,nil,nil,104,"H",},
[3007] = {'Una',3077,3077,46,46,0,{[1638]={{41.5,42.57},},},nil,1638,nil,{2860,},104,"H",},
[3008] = {'Mak',1172,1172,24,24,0,{[1638]={{42.06,43.45},},},nil,1638,nil,nil,104,"H",},
[3009] = {'Bena Winterhoof',2016,2016,35,35,0,{[1638]={{46.62,33.17},},},nil,1638,nil,{2440,},104,"H",},
[3010] = {'Mani Winterhoof',1605,1605,30,30,0,{[1638]={{47.41,33.74},},},nil,1638,nil,nil,104,"H",},
[3011] = {'Teg Dawnstrider',2016,2016,35,35,0,{[1638]={{44.91,37.49},},},nil,1638,nil,nil,104,"H",},
[3012] = {'Nata Dawnstrider',1605,1605,30,30,0,{[1638]={{44.99,38.75},},},nil,1638,nil,nil,104,"H",},
[3013] = {'Komin Winterhoof',2016,2016,35,35,0,{[1638]={{49.95,40.41},},},nil,1638,nil,nil,104,"H",},
[3014] = {'Nida Winterhoof',1605,1605,30,30,0,{[1638]={{49.57,39.57},},},nil,1638,nil,nil,104,"H",},
[3015] = {'Kuna Thunderhorn',1605,1605,30,30,0,{[1638]={{47.0,45.7},},},nil,1638,nil,nil,104,"H",},
[3016] = {'Tand',1605,1605,30,30,0,{[1638]={{49.05,34.24},},},nil,1638,nil,nil,104,"H",},
[3017] = {'Nan Mistrunner',1605,1605,30,30,0,{[1638]={{47.34,42.49},},},nil,1638,nil,nil,104,"H",},
[3018] = {'Hogor Thunderhoof',1605,1605,30,30,0,{[1638]={{55.55,57.07},},},nil,1638,nil,nil,104,"H",},
[3019] = {'Delgo Ragetotem',1605,1605,30,30,0,{[1638]={{54.07,57.23},},},nil,1638,nil,nil,104,"H",},
[3020] = {'Etu Ragetotem',1605,1605,30,30,0,{[1638]={{53.19,58.29},},},nil,1638,nil,nil,104,"H",},
[3021] = {'Kard Ragetotem',1605,1605,30,30,0,{[1638]={{52.98,56.63},},},nil,1638,nil,nil,104,"H",},
[3022] = {'Sunn Ragetotem',1605,1605,30,30,0,{[1638]={{49.63,48.71},},},nil,1638,nil,nil,104,"H",},
[3023] = {'Sura Wildmane',1605,1605,30,30,0,{[1638]={{51.59,55.02},},},nil,1638,nil,nil,104,"H",},
[3024] = {'Tah Winterhoof',1605,1605,30,30,0,{[1638]={{54.14,47.05},},},nil,1638,nil,nil,104,"H",},
[3025] = {'Kaga Mistrunner',1605,1605,30,30,0,{[1638]={{52.3,47.79},},},nil,1638,nil,nil,104,"H",},
[3026] = {'Aska Mistrunner',2972,2972,45,45,0,{[1638]={{50.72,53.11},},},nil,1638,nil,nil,104,"H",},
[3027] = {'Naal Mistrunner',2471,2471,40,40,0,{[1638]={{50.99,52.45},},},nil,1638,nil,nil,104,"H",},
[3028] = {'Kah Mistrunner',2972,2972,45,45,0,{[1638]={{56.13,46.38},},},nil,1638,nil,nil,104,"H",},
[3029] = {'Sewa Mistrunner',2471,2471,40,40,0,{[1638]={{55.79,47.02},},},nil,1638,nil,nil,104,"H",},
[3030] = {'Siln Skychaser',3517,3517,50,50,0,{[1638]={{22.82,21.11},},},nil,1638,{8410,},nil,104,"H",},
[3031] = {'Tigor Skychaser',2471,2471,40,40,0,{[1638]={{23.64,18.79},},},nil,1638,{8410,},nil,104,"H",},
[3032] = {'Beram Skychaser',3139,3139,60,60,0,{[1638]={{21.99,18.8},},},nil,1638,{1523,8410,},nil,104,"H",},
[3033] = {'Turak Runetotem',3517,3517,50,50,0,{[1638]={{76.48,27.22},},},nil,1638,{26,5922,6002,6126,9063,},{31,5926,5927,5928,5932,6002,6130,},104,"H",},
[3034] = {'Sheal Runetotem',3139,3139,60,60,0,{[1638]={{77.14,27.02},},},nil,1638,{9063,},nil,104,"H",},
[3035] = {'Flatland Cougar',137,156,7,8,0,{[215]={{44.66,31.57},{45.97,30.55},{53.19,34.91},{52.05,37.28},{47.3,35.0},{54.51,35.33},{52.77,38.04},{56.81,36.28},{52.85,37.25},{55.74,35.64},{53.98,38.25},{53.91,35.94},{56.18,38.06},{52.1,35.54},{49.78,36.76},{59.44,53.49},{55.82,37.17},{55.88,39.45},{34.96,51.88},{55.51,43.12},{54.63,40.44},{49.39,37.59},{56.07,41.94},{34.44,42.65},{56.54,48.19},{53.4,40.7},{59.7,64.77},{53.14,40.17},{35.03,33.48},{48.05,43.12},{36.61,42.96},{34.46,32.72},{36.45,48.65},{62.69,51.58},{36.88,44.0},{40.85,38.15},{35.72,42.2},{57.1,62.8},{42.13,37.29},{57.61,49.45},{36.88,48.62},{45.61,38.14},{38.35,45.73},{59.65,54.59},{48.07,32.39},{54.1,41.89},{55.15,38.4},{52.09,33.16},{45.39,36.38},{43.91,52.2},{51.12,36.35},{48.16,35.22},{48.62,44.48},{50.42,34.05},{50.42,43.29},{37.42,39.3},{51.66,41.49},{59.44,58.4},{49.27,45.22},{58.99,58.07},{54.92,45.91},{47.3,36.41},{48.63,41.42},{46.67,36.4},{49.78,41.14},{58.66,52.65},{38.95,46.88},{57.28,63.83},{50.61,40.61},{57.29,49.08},{56.24,51.45},{41.97,49.95},{57.75,71.93},{39.62,46.01},{50.61,42.01},{57.03,72.23},{39.02,41.23},{45.18,47.37},{44.21,48.76},{33.65,25.6},{46.29,42.35},{54.43,47.04},{43.32,45.36},{47.33,40.25},{34.15,26.43},{50.5,39.34},{42.78,43.19},{38.07,39.87},{38.77,39.29},},[1638]={{24.67,71.26},},},nil,215,nil,nil,14,nil,},
[3036] = {'Kym Wildmane',2471,2471,40,40,0,{[1638]={{77.15,29.82},},},nil,1638,nil,nil,104,"H",},
[3037] = {'Sheza Wildmane',1605,1605,30,30,0,{[1638]={{69.72,26.74},},},nil,1638,nil,nil,104,"H",},
[3038] = {'Kary Thunderhorn',3517,3517,50,50,0,{[1638]={{58.49,88.33},},},nil,1638,{6065,8151,},nil,104,"H",},
[3039] = {'Holt Thunderhorn',3139,3139,60,60,0,{[1638]={{57.3,89.79},},},nil,1638,nil,{6089,},104,"H",},
[3040] = {'Urek Thunderhorn',2471,2471,40,40,0,{[1638]={{59.13,86.87},},},nil,1638,nil,nil,104,"H",},
[3041] = {'Torm Ragetotem',3517,3517,50,50,0,{[1638]={{57.24,87.37},},},nil,1638,{1718,8417,},nil,104,"H",},
[3042] = {'Sark Ragetotem',3139,3139,60,60,0,{[1638]={{56.99,89.51},},},nil,1638,nil,nil,104,"H",},
[3043] = {'Ker Ragetotem',2471,2471,40,40,0,{[1638]={{57.58,85.5},},},nil,1638,nil,nil,104,"H",},
[3044] = {'Miles Welsh',2471,2471,40,40,0,{[1638]={{25.32,15.27},},},nil,1638,{5642,5661,},nil,68,"H",},
[3045] = {'Malakai Cross',3517,3517,50,50,0,{[1638]={{24.56,22.57},},},nil,1638,{8254,},nil,68,"H",},
[3046] = {'Father Cobb',4486,4486,60,60,0,{[1638]={{25.64,20.7},},},nil,1638,{5646,8254,},nil,68,"H",},
[3047] = {'Archmage Shymm',3139,3139,60,60,0,{[1638]={{22.76,14.53},},},nil,1638,nil,nil,68,"H",},
[3048] = {'Ursyn Ghull',2471,2471,40,40,0,{[1638]={{25.7,14.19},},},nil,1638,{2861,},nil,68,"H",},
[3049] = {'Thurston Xane',3517,3517,50,50,0,{[1638]={{25.18,20.96},},},nil,1638,{8250,},nil,68,"H",},
[3050] = {'Veren Tallstrider',980,980,21,21,0,{[1638]={{44.39,44.7},},},nil,1638,{768,769,},{768,769,},104,"H",},
[3051] = {'Supervisor Fizsprocket',247,247,12,12,0,{[215]={{64.9,43.31},},},nil,215,nil,nil,47,nil,},
[3052] = {'Skorn Whitecloud',980,980,21,21,0,{[215]={{46.75,60.23},},},nil,215,{861,},{770,},104,"H",},
[3053] = {'Synge',1605,1605,30,30,0,{[400]={{80.4,77.01},},},nil,400,nil,nil,35,"AH",},
[3054] = {'Zarlman Two-Moons',228,228,7,7,0,{[215]={{47.76,57.53},},},nil,215,{771,772,},{767,771,},104,"H",},
[3055] = {'Maur Raincaller',413,413,10,10,0,{[215]={{46.98,57.07},},},nil,215,{766,},{766,},104,"H",},
[3056] = {'Ghost Howl',247,247,12,12,4,{[215]={{33.17,25.24},{47.55,14.76},},[17]={{29.78,35.39},},},{[17]={{22.49,40.7},{22.48,40.54},{22.45,40.3},{22.44,40.16},{22.37,39.92},{22.32,39.77},{22.18,39.5},{22.11,39.38},{22.02,39.21},{21.93,39.03},{21.85,38.87},{21.81,38.69},{21.82,38.52},{21.83,38.4},{21.86,38.26},{21.9,38.11},{22.0,37.94},{22.09,37.8},{22.18,37.68},{22.3,37.59},{22.4,37.51},{22.5,37.43},{22.59,37.36},{22.66,37.3},{22.79,37.17},{22.87,37.11},{23.02,37.02},{23.12,36.99},{23.26,36.89},{23.37,36.81},{23.45,36.77},{23.53,36.76},{23.68,36.76},{23.8,36.75},{23.86,36.75},{24.03,36.75},{24.18,36.75},{24.3,36.75},{24.42,36.72},{24.56,36.65},{24.72,36.39},{24.84,36.08},{24.93,35.83},{25.01,35.61},{25.06,35.42},{25.07,35.34},{25.1,35.07},{25.17,34.69},{25.22,34.53},{25.28,34.34},{25.34,34.15},{25.35,33.97},{25.34,33.83},{25.31,33.61},{25.26,33.45},{25.18,33.22},{25.12,33.09},{25.05,32.92},{25.14,33.12},{25.22,33.37},{25.27,33.54},{25.33,33.77},{25.38,34.03},{25.4,34.23},{25.4,34.3},{25.36,34.56},{25.31,34.74},{25.24,34.89},{25.14,35.05},{25.03,35.21},{24.97,35.32},{24.87,35.66},{24.8,35.86},{24.71,36.08},{24.61,36.29},{24.52,36.43},{24.4,36.56},{24.28,36.65},{24.11,36.67},{24.01,36.68},{23.9,36.7},{23.78,36.74},{23.67,36.74},{23.51,36.76},{23.42,36.77},{23.34,36.81},{23.24,36.89},{23.16,36.96},{23.09,36.99},{22.91,37.08},{22.81,37.13},{22.71,37.2},{22.63,37.26},{22.56,37.32},{22.47,37.39},{22.32,37.54},{22.24,37.62},{22.11,37.76},{22.03,37.86},{21.93,38.0},{21.83,38.15},{21.77,38.33},{21.77,38.47},{21.78,38.65},{21.83,38.82},{21.89,38.92},{21.94,39.06},{22.02,39.29},{22.08,39.46},{22.12,39.54},{22.26,39.79},{22.35,39.94},{22.42,40.08},{22.47,40.22},{22.48,40.39},{22.49,40.64},{22.48,40.94},{22.45,41.14},{22.38,41.35},{22.31,41.55},{22.26,41.7},{22.21,41.85},{22.31,41.58},{22.37,41.4},{22.41,41.26},{22.46,41.03},{22.48,40.92},{29.78,35.39},{29.89,35.81},{29.99,35.99},{30.15,36.18},{30.33,36.24},{30.47,36.2},{30.7,36.12},{30.94,36.03},{31.08,35.94},{31.24,35.75},{31.33,35.59},{31.45,35.3},{31.5,35.06},{31.49,34.82},{31.37,34.46},{31.24,34.24},{31.07,34.02},{30.92,33.72},{30.74,33.45},{30.56,33.39},{30.35,33.59},{30.21,33.79},{30.1,34.0},{29.94,34.31},{29.86,34.57},{29.8,34.88},{29.76,35.16},},[215]={{33.17,25.23},{33.15,24.93},{33.1,24.46},{33.06,24.17},{32.93,23.7},{32.82,23.4},{32.55,22.86},{32.42,22.62},{32.24,22.29},{32.06,21.95},{31.91,21.62},{31.83,21.28},{31.84,20.94},{31.87,20.7},{31.92,20.42},{32.01,20.13},{32.2,19.79},{32.37,19.52},{32.56,19.28},{32.79,19.1},{32.98,18.95},{33.19,18.78},{33.37,18.64},{33.5,18.53},{33.75,18.27},{33.92,18.16},{34.22,17.99},{34.4,17.92},{34.68,17.73},{34.91,17.57},{35.06,17.49},{35.21,17.46},{35.51,17.46},{35.75,17.45},{35.87,17.45},{36.21,17.45},{36.51,17.45},{36.75,17.45},{36.98,17.39},{37.24,17.24},{37.57,16.74},{37.8,16.13},{37.99,15.62},{38.14,15.2},{38.23,14.82},{38.26,14.67},{38.32,14.14},{38.46,13.39},{38.55,13.06},{38.67,12.69},{38.79,12.33},{38.81,11.95},{38.79,11.68},{38.72,11.25},{38.63,10.94},{38.47,10.48},{38.36,10.22},{38.21,9.89},{38.39,10.28},{38.56,10.78},{38.66,11.11},{38.77,11.58},{38.87,12.08},{38.91,12.47},{38.9,12.62},{38.83,13.13},{38.74,13.48},{38.6,13.77},{38.39,14.1},{38.18,14.41},{38.06,14.62},{37.86,15.3},{37.73,15.69},{37.54,16.13},{37.35,16.54},{37.18,16.81},{36.94,17.07},{36.69,17.24},{36.37,17.29},{36.18,17.3},{35.95,17.35},{35.71,17.42},{35.5,17.43},{35.19,17.46},{35.01,17.49},{34.85,17.57},{34.64,17.72},{34.48,17.85},{34.35,17.92},{34.0,18.09},{33.81,18.2},{33.61,18.33},{33.44,18.46},{33.31,18.56},{33.14,18.7},{32.83,19.0},{32.68,19.17},{32.43,19.43},{32.26,19.64},{32.06,19.91},{31.87,20.21},{31.76,20.57},{31.75,20.84},{31.78,21.19},{31.86,21.52},{31.97,21.74},{32.07,22.0},{32.24,22.45},{32.37,22.79},{32.43,22.95},{32.71,23.44},{32.9,23.74},{33.03,24.01},{33.13,24.28},{33.15,24.62},{33.16,25.11},{33.15,25.71},{33.08,26.11},{32.96,26.53},{32.82,26.92},{32.72,27.2},{32.61,27.51},{32.82,26.97},{32.93,26.62},{33.01,26.35},{33.12,25.88},{33.15,25.67},{47.55,14.76},{47.77,15.6},{47.96,15.95},{48.28,16.31},{48.64,16.44},{48.9,16.36},{49.37,16.21},{49.83,16.03},{50.1,15.84},{50.43,15.47},{50.61,15.15},{50.84,14.59},{50.94,14.12},{50.92,13.64},{50.68,12.94},{50.42,12.49},{50.09,12.05},{49.8,11.46},{49.45,10.93},{49.08,10.82},{48.67,11.21},{48.4,11.61},{48.17,12.03},{47.87,12.64},{47.7,13.14},{47.58,13.76},{47.51,14.31},},[405]={{86.52,53.01},{86.49,52.66},{86.43,52.12},{86.39,51.8},{86.24,51.26},{86.12,50.92},{85.8,50.3},{85.66,50.03},{85.46,49.65},{85.24,49.25},{85.07,48.89},{84.99,48.49},{85.0,48.1},{85.03,47.83},{85.08,47.52},{85.19,47.18},{85.4,46.79},{85.6,46.49},{85.82,46.21},{86.08,46.0},{86.3,45.83},{86.54,45.64},{86.75,45.48},{86.89,45.35},{87.18,45.06},{87.37,44.93},{87.71,44.73},{87.92,44.66},{88.24,44.44},{88.5,44.26},{88.67,44.16},{88.85,44.13},{89.19,44.13},{89.46,44.12},{89.6,44.12},{89.99,44.12},{90.33,44.12},{90.6,44.11},{90.87,44.05},{91.17,43.88},{91.54,43.31},{91.81,42.61},{92.02,42.03},{92.19,41.55},{92.29,41.12},{92.33,40.95},{92.4,40.33},{92.55,39.48},{92.66,39.11},{92.8,38.68},{92.93,38.26},{92.96,37.84},{92.93,37.53},{92.86,37.04},{92.76,36.68},{92.57,36.15},{92.44,35.86},{92.28,35.48},{92.48,35.93},{92.68,36.5},{92.78,36.88},{92.91,37.41},{93.03,37.99},{93.08,38.42},{93.07,38.6},{92.99,39.19},{92.88,39.58},{92.72,39.91},{92.48,40.29},{92.24,40.65},{92.1,40.88},{91.87,41.66},{91.72,42.11},{91.51,42.61},{91.29,43.08},{91.09,43.39},{90.82,43.68},{90.54,43.89},{90.17,43.94},{89.95,43.95},{89.69,44.01},{89.41,44.08},{89.18,44.1},{88.82,44.13},{88.61,44.16},{88.43,44.26},{88.2,44.43},{88.01,44.58},{87.87,44.66},{87.46,44.85},{87.24,44.97},{87.01,45.13},{86.82,45.27},{86.67,45.39},{86.48,45.55},{86.13,45.89},{85.95,46.08},{85.66,46.38},{85.47,46.62},{85.24,46.93},{85.03,47.27},{84.9,47.68},{84.89,47.99},{84.92,48.4},{85.02,48.77},{85.15,49.02},{85.26,49.32},{85.45,49.83},{85.6,50.22},{85.67,50.41},{85.99,50.96},{86.2,51.3},{86.36,51.62},{86.46,51.93},{86.49,52.31},{86.51,52.87},{86.49,53.56},{86.41,54.01},{86.27,54.49},{86.11,54.94},{86.0,55.26},{85.87,55.61},{86.11,55.0},{86.24,54.59},{86.33,54.29},{86.45,53.76},{86.49,53.51},},[1638]={{16.57,41.26},{16.46,39.76},{16.2,37.45},{16.02,36.05},{15.4,33.72},{14.85,32.26},{13.5,29.6},{12.88,28.42},{12.0,26.79},{11.09,25.08},{10.36,23.51},{9.98,21.79},{10.03,20.12},{10.15,18.96},{10.4,17.59},{10.86,16.16},{11.77,14.47},{12.63,13.15},{13.56,11.98},{14.7,11.08},{15.64,10.34},{16.68,9.52},{17.57,8.82},{18.19,8.28},{19.44,7.0},{20.25,6.44},{21.71,5.6},{22.63,5.28},{24.0,4.34},{25.12,3.55},{25.85,3.15},{26.62,3.0},{28.07,2.99},{29.24,2.98},{29.86,2.97},{31.54,2.96},{32.99,2.94},{34.16,2.93},{35.32,2.67},{36.61,1.92},{35.1,1.08},{33.9,1.95},{32.3,2.17},{31.35,2.21},{30.26,2.48},{29.05,2.8},{28.05,2.88},{26.49,3.01},{25.6,3.14},{24.81,3.56},{23.81,4.3},{23.02,4.94},{22.39,5.29},{20.63,6.09},{19.69,6.64},{18.72,7.3},{17.87,7.91},{17.23,8.44},{16.4,9.12},{14.9,10.58},{14.13,11.41},{12.9,12.72},{12.08,13.72},{11.08,15.07},{10.16,16.52},{9.6,18.32},{9.55,19.65},{9.7,21.38},{10.12,23.01},{10.68,24.05},{11.17,25.36},{11.99,27.56},{12.61,29.24},{12.91,30.05},{14.29,32.44},{15.21,33.91},{15.89,35.26},{16.34,36.59},{16.45,38.25},{16.53,40.68},{16.46,43.62},{16.12,45.57},{15.53,47.64},{14.84,49.56},{14.33,50.96},{13.79,52.48},{14.84,49.82},{15.39,48.07},{15.77,46.77},{16.3,44.47},{16.48,43.42},},},215,nil,nil,38,nil,},
[3057] = {'Cairne Bloodhoof',40000,40000,63,63,3,{[1638]={{60.3,51.68},},},nil,1638,{776,},{775,776,7061,},104,"H",},
[3058] = {'Arra\'chea',444,444,11,11,0,{[215]={{53.0,13.97},},},{[17]={{32.61,35.13},{32.66,35.32},{32.66,35.32},{32.73,35.5},{32.79,35.68},{32.85,35.87},{32.91,36.06},{32.97,36.24},{32.97,36.24},{33.04,36.43},{33.1,36.61},{33.16,36.79},{33.21,36.98},{33.25,37.17},{33.3,37.46},{33.31,37.51},{33.32,37.67},{33.32,37.75},{33.3,37.96},{33.27,38.16},{33.25,38.37},{33.22,38.57},{33.2,38.78},{33.18,38.98},{33.16,39.19},{33.16,39.19},{33.14,39.39},{33.11,39.59},{33.09,39.8},{33.06,40.0},{33.03,40.2},{33.01,40.41},{32.95,40.81},{32.9,41.01},{32.86,41.21},{32.82,41.46},{32.85,41.65},{32.9,41.84},{32.96,42.03},{33.04,42.21},{33.2,42.54},{33.27,42.71},{33.39,42.97},{33.47,43.23},{33.5,43.42},{33.54,43.76},{33.54,43.91},{33.47,44.11},{33.33,44.32},{33.22,44.44},{33.13,44.5},{32.88,44.5},{32.75,44.41},{32.63,44.31},{32.51,44.21},{32.35,44.04},{32.24,43.83},{32.17,43.57},{32.17,43.34},{32.17,43.34},{32.19,42.92},{32.2,42.72},{32.2,42.37},{32.2,42.19},{32.17,41.79},{32.15,41.58},{32.12,41.38},{32.08,41.18},{32.01,40.78},{31.97,40.58},{31.94,40.38},{31.9,40.18},{31.84,39.78},{31.81,39.57},{31.79,39.37},{31.76,39.16},{31.71,38.8},{31.66,38.6},{31.61,38.41},{31.5,38.05},{31.4,37.92},{31.21,37.63},{31.18,37.56},{31.11,37.38},{30.99,37.01},{30.96,36.88},{30.88,36.71},{30.8,36.54},{30.73,36.22},{30.78,36.05},{30.92,35.77},{30.98,35.68},{31.09,35.55},{31.31,35.3},{31.42,35.18},{31.56,35.02},{31.62,34.79},{31.69,34.61},{31.88,34.24},{32.06,34.21},{32.21,34.33},{32.31,34.56},{32.4,34.71},},[215]={{53.12,14.24},{53.23,14.62},{53.23,14.62},{53.36,14.98},{53.48,15.34},{53.6,15.71},{53.72,16.07},{53.84,16.44},{53.84,16.44},{53.97,16.8},{54.09,17.17},{54.22,17.53},{54.31,17.89},{54.39,18.28},{54.49,18.84},{54.51,18.95},{54.53,19.25},{54.52,19.43},{54.49,19.83},{54.43,20.23},{54.39,20.64},{54.34,21.04},{54.29,21.44},{54.25,21.85},{54.21,22.25},{54.21,22.25},{54.17,22.65},{54.12,23.05},{54.07,23.46},{54.02,23.86},{53.97,24.26},{53.91,24.66},{53.79,25.46},{53.71,25.85},{53.63,26.24},{53.55,26.74},{53.6,27.12},{53.7,27.5},{53.83,27.86},{53.97,28.21},{54.28,28.88},{54.44,29.21},{54.67,29.72},{54.82,30.23},{54.89,30.6},{54.96,31.28},{54.95,31.57},{54.82,31.96},{54.55,32.38},{54.33,32.61},{54.15,32.73},{53.65,32.73},{53.41,32.55},{53.16,32.37},{52.93,32.16},{52.61,31.83},{52.39,31.41},{52.26,30.9},{52.27,30.44},{52.27,30.44},{52.31,29.62},{52.32,29.21},{52.32,28.53},{52.32,28.17},{52.26,27.38},{52.21,26.98},{52.16,26.58},{52.08,26.18},{51.94,25.4},{51.87,25.0},{51.8,24.6},{51.74,24.21},{51.61,23.41},{51.55,23.01},{51.51,22.61},{51.46,22.21},{51.34,21.49},{51.25,21.1},{51.15,20.72},{50.95,20.01},{50.74,19.76},{50.37,19.18},{50.31,19.05},{50.18,18.69},{49.94,17.96},{49.88,17.7},{49.72,17.36},{49.56,17.03},{49.43,16.4},{49.52,16.07},{49.79,15.51},{49.92,15.33},{50.14,15.08},{50.57,14.59},{50.79,14.34},{51.05,14.04},{51.17,13.57},{51.31,13.22},{51.68,12.5},{52.04,12.44},{52.34,12.68},{52.53,13.13},{52.72,13.42},},[1638]={{99.08,5.45},{98.79,4.17},{98.01,2.52},{97.23,0.89},},},215,nil,nil,15,"AH",},
[3059] = {'Harutt Thunderhorn',413,413,10,10,0,{[215]={{44.01,76.13},},},nil,215,nil,{3091,},104,"H",},
[3060] = {'Gart Mistrunner',372,372,9,9,0,{[215]={{45.09,75.93},},},nil,215,{5927,},{3094,},104,"H",},
[3061] = {'Lanka Farshot',456,456,11,11,0,{[215]={{44.26,75.69},},},nil,215,{6066,},{3092,},104,"H",},
[3062] = {'Meela Dawnstrider',413,413,10,10,0,{[215]={{45.01,75.94},},},nil,215,nil,{3093,},104,"H",},
[3063] = {'Krang Stonehoof',594,594,14,14,0,{[215]={{49.52,60.59},},},nil,215,{1505,},nil,104,"H",},
[3064] = {'Gennia Runetotem',500,500,12,12,0,{[215]={{48.48,59.64},},},nil,215,{5926,},nil,104,"H",},
[3065] = {'Yaw Sharpmane',456,456,11,11,0,{[215]={{47.82,55.69},},},nil,215,{6061,6087,6088,6089,},{6061,6065,6066,6067,6087,6088,},104,"H",},
[3066] = {'Narm Skychaser',546,546,13,13,0,{[215]={{48.38,59.15},},},nil,215,{2984,2986,},nil,104,"H",},
[3067] = {'Pyall Silentstride',500,500,12,12,0,{[215]={{45.41,58.11},},},nil,215,nil,nil,104,"H",},
[3068] = {'Mazzranache',176,176,9,9,4,{[215]={{50.39,42.58},},},{[17]={{31.32,49.36},{31.5,49.11},{31.73,48.76},{31.84,48.48},{31.88,48.14},{31.93,47.79},{31.99,47.49},{31.97,47.18},{31.86,46.82},{31.77,46.62},{31.67,46.56},{31.48,46.55},{31.21,46.61},{31.04,46.56},{30.88,46.4},{30.7,46.36},{30.5,46.43},{30.07,46.47},{29.82,46.53},{29.58,46.64},{29.38,46.74},{29.2,46.85},{28.97,47.05},{28.81,47.32},{28.63,47.51},{28.43,47.71},{28.22,47.86},{27.92,48.09},{27.64,48.26},{27.4,48.38},{27.14,48.4},{26.85,48.56},{26.64,48.76},{26.45,49.04},{26.35,49.32},{26.34,49.73},{26.38,50.11},{26.46,50.49},{26.58,50.68},{26.81,50.82},{26.99,50.84},{27.1,51.02},{27.16,51.27},{27.24,51.51},{27.37,51.67},{27.59,51.8},{27.82,51.83},{28.03,51.75},{28.29,51.64},{28.51,51.46},{28.69,51.26},{28.88,50.96},{29.02,50.73},{29.2,50.52},{29.4,50.25},{29.62,49.87},{29.85,49.7},{30.07,49.63},{30.35,49.38},{30.44,49.13},{30.63,49.05},{30.9,49.17},{31.1,49.46},{31.23,49.5},},[215]={{50.58,42.31},{50.94,41.83},{51.38,41.14},{51.62,40.58},{51.68,39.91},{51.8,39.22},{51.9,38.63},{51.87,38.01},{51.66,37.31},{51.47,36.92},{51.27,36.79},{50.89,36.77},{50.36,36.89},{50.04,36.79},{49.72,36.49},{49.36,36.4},{48.96,36.53},{48.12,36.61},{47.62,36.74},{47.16,36.96},{46.76,37.15},{46.4,37.37},{45.95,37.77},{45.63,38.29},{45.28,38.67},{44.88,39.06},{44.47,39.36},{43.88,39.82},{43.33,40.15},{42.84,40.39},{42.33,40.44},{41.77,40.75},{41.35,41.14},{40.98,41.68},{40.79,42.24},{40.76,43.06},{40.84,43.79},{41.0,44.54},{41.23,44.93},{41.69,45.19},{42.05,45.23},{42.26,45.59},{42.39,46.08},{42.53,46.57},{42.8,46.87},{43.23,47.14},{43.69,47.2},{44.1,47.04},{44.62,46.82},{45.04,46.47},{45.4,46.08},{45.77,45.48},{46.06,45.03},{46.41,44.61},{46.79,44.08},{47.22,43.33},{47.69,42.99},{48.11,42.86},{48.67,42.36},{48.85,41.86},{49.21,41.71},{49.75,41.95},{50.15,42.53},{50.42,42.59},},[1638]={{99.61,98.17},{98.01,96.67},{96.26,96.23},{94.28,96.88},{90.17,97.29},{87.7,97.89},{85.4,99.01},{83.44,99.95},},[405]={{99.9,68.81},{99.43,69.15},{98.76,69.68},{98.13,70.05},{97.57,70.32},{96.98,70.38},{96.34,70.74},{95.86,71.18},{95.44,71.8},{95.22,72.44},{95.19,73.38},{95.28,74.21},{95.46,75.07},{95.73,75.52},{96.25,75.81},{96.66,75.86},{96.91,76.27},{97.05,76.83},{97.21,77.39},{97.52,77.73},{98.01,78.04},{98.53,78.1},{99.01,77.92},{99.59,77.67},},},215,nil,nil,14,nil,},
[3069] = {'Chaw Stronghide',1106,1106,23,23,0,{[215]={{45.44,57.86},},},nil,215,nil,nil,104,"H",},
[3072] = {'Kawnie Softbreeze',334,334,8,8,0,{[215]={{45.3,76.52},},},nil,215,nil,nil,104,"H",},
[3073] = {'Marjak Keenblade',372,372,9,9,0,{[215]={{44.06,77.47},},},nil,215,nil,nil,104,"H",},
[3074] = {'Varia Hardhide',228,228,7,7,0,{[215]={{44.14,77.25},},},nil,215,nil,nil,104,"H",},
[3075] = {'Bronk Steelrage',413,413,10,10,0,{[215]={{44.21,77.5},},},nil,215,nil,nil,104,"H",},
[3076] = {'Moorat Longstride',500,500,12,12,0,{[215]={{45.86,57.66},},},nil,215,nil,nil,104,"H",},
[3077] = {'Mahnott Roughwound',456,456,11,11,0,{[215]={{45.66,58.6},},},nil,215,nil,nil,104,"H",},
[3078] = {'Kennah Hawkseye',546,546,13,13,0,{[215]={{45.49,58.47},},},nil,215,nil,nil,104,"H",},
[3079] = {'Varg Windwhisper',594,594,14,14,0,{[215]={{45.82,58.7},},},nil,215,nil,nil,104,"H",},
[3080] = {'Harant Ironbrace',456,456,11,11,0,{[215]={{45.9,58.73},},},nil,215,nil,nil,104,"H",},
[3081] = {'Wunna Darkmane',413,413,10,10,0,{[215]={{46.18,58.18},},},nil,215,nil,nil,104,"H",},
[3083] = {'Honor Guard',7543,7543,60,60,0,{[1638]={{59.76,52.26},{61.69,50.78},{59.83,51.08},{51.36,51.31},{61.6,52.82},{61.14,55.05},},},{[17]={{26.06,41.72},{25.94,41.68},{25.82,41.65},{25.91,41.68},{26.05,41.72},{26.14,41.75},{26.21,41.82},{26.27,41.92},{26.37,42.04},{26.43,42.07},{26.55,42.08},{26.72,42.06},{26.77,42.19},{26.77,42.05},{26.82,41.96},{26.85,41.8},{26.85,41.68},{26.82,41.55},{26.76,41.43},{26.82,41.3},{26.77,41.4},{26.69,41.4},{26.61,41.37},{26.51,41.38},{26.42,41.45},{26.31,41.52},{26.25,41.6},{26.21,41.75},{26.14,41.74},},[215]={{40.21,27.25},{39.97,27.18},{39.74,27.11},{39.91,27.17},{40.18,27.25},{40.36,27.31},{40.5,27.44},{40.62,27.65},{40.82,27.88},{40.95,27.95},{41.19,27.97},{41.51,27.92},{41.62,28.17},{41.61,27.91},{41.71,27.73},{41.78,27.41},{41.77,27.16},{41.71,26.92},{41.6,26.67},{41.7,26.42},{41.62,26.62},{41.45,26.61},{41.3,26.56},{41.1,26.59},{40.92,26.71},{40.71,26.86},{40.58,27.01},{40.5,27.3},{40.37,27.28},},[405]={{94.55,55.32},{94.29,55.23},{94.02,55.15},{94.22,55.23},{94.53,55.31},{94.73,55.39},{94.89,55.53},{95.03,55.78},{95.25,56.03},{95.4,56.11},{95.67,56.14},{96.05,56.08},{96.17,56.36},{96.16,56.07},{96.27,55.87},{96.35,55.5},{96.34,55.22},{96.27,54.94},{96.14,54.65},{96.27,54.37},{96.16,54.6},{95.98,54.59},{95.8,54.53},{95.58,54.56},{95.38,54.7},{95.13,54.87},{94.98,55.04},{94.89,55.38},{94.74,55.35},},[1638]={{51.19,51.21},{50.04,50.84},{48.88,50.49},{49.75,50.81},{51.09,51.19},{51.96,51.51},{52.62,52.13},{53.23,53.18},{54.19,54.29},{54.84,54.64},{56.01,54.73},{57.62,54.5},{58.14,55.72},{58.1,54.43},{58.58,53.56},{58.92,51.99},{58.91,50.76},{58.6,49.57},{58.03,48.33},{58.57,47.12},{58.13,48.1},{57.34,48.05},{56.57,47.8},{55.61,47.93},{54.73,48.53},{53.66,49.28},{53.05,50.02},{52.66,51.46},{51.98,51.36},},},1638,nil,nil,105,"H",},
[3084] = {'Bluffwatcher',5197,5197,55,55,0,{[1638]={{50.62,37.78},{72.05,30.17},{58.59,55.33},{45.12,61.32},{37.39,60.95},{59.1,78.55},{31.01,29.46},{58.05,47.12},{36.97,50.58},{43.3,38.63},{27.98,18.9},{43.12,40.01},{44.37,61.71},{30.53,31.05},{35.66,63.09},{44.32,39.61},{57.74,55.94},{40.18,62.7},{51.18,31.51},{58.81,47.89},{50.44,36.45},{36.28,51.51},},},{[17]={{28.18,39.53},{28.07,39.59},{28.16,39.53},{28.05,39.43},{27.96,39.35},{27.95,39.25},{27.94,39.36},{28.02,39.41},{28.09,39.46},{28.18,39.52},{28.28,39.54},{28.42,39.53},{28.67,39.49},{28.54,39.51},{28.2,39.55},{28.24,39.4},{28.29,39.21},{28.42,39.04},{28.59,38.95},{28.74,38.91},{28.91,38.92},{29.03,39.08},{29.14,39.29},{29.14,39.48},{29.03,39.73},{28.9,39.9},{28.72,39.96},{28.46,39.95},{28.34,39.84},{28.2,39.66},{24.65,42.75},{24.71,42.83},{24.78,42.91},{24.88,42.96},{24.93,42.89},{24.99,42.81},{25.07,42.71},{25.14,42.61},{25.22,42.62},{25.31,42.65},{25.36,42.72},{25.4,42.81},{25.37,42.74},{25.32,42.64},{25.32,42.58},{25.33,42.45},{25.26,42.35},{25.21,42.29},{25.15,42.21},{25.09,42.11},{25.02,42.01},{24.95,41.91},{24.91,41.84},{24.85,41.78},{24.76,41.71},{24.68,41.7},{24.61,41.77},{24.55,41.89},{24.53,42.02},{24.54,42.15},{24.57,42.29},{24.6,42.45},{24.62,42.58},{24.63,42.69},{26.91,44.54},{27.06,44.6},{27.04,44.75},{27.09,44.57},{27.13,44.49},{27.18,44.38},{27.14,44.46},{27.07,44.53},{26.93,44.53},{26.84,44.5},{26.85,44.39},{26.83,44.48},{26.7,44.46},{26.65,44.45},{26.65,44.4},{26.63,44.47},{26.55,44.54},{26.52,44.6},{26.5,44.68},{26.47,44.86},{26.4,45.04},{26.48,44.85},{26.5,44.73},{26.51,44.65},{26.46,44.67},{26.41,44.69},{26.47,44.66},{26.51,44.62},{26.56,44.55},{26.64,44.49},{26.82,44.5},{23.64,38.44},{23.61,38.34},{23.53,38.21},{23.6,38.3},{23.65,38.37},{23.73,38.32},{23.66,38.38},{23.69,38.49},{23.74,38.64},{23.68,38.82},{23.76,38.89},{23.9,39.02},{23.81,38.94},{23.73,38.87},{23.58,38.8},{23.52,38.76},{23.41,38.68},{23.49,38.75},{23.58,38.82},{23.64,38.88},{23.61,39.0},{23.67,39.09},{23.61,39.01},{23.5,39.11},{23.33,39.14},{23.48,39.14},{23.57,39.0},{23.69,38.8},{23.72,38.62},{25.26,40.49},{25.33,40.5},{25.41,40.59},{25.33,40.74},{25.39,40.63},{25.48,40.71},{25.57,40.77},{25.56,40.88},{25.55,41.16},{25.56,41.01},{25.57,40.87},{25.59,40.71},{25.63,40.52},{25.75,40.32},{25.73,40.21},{25.78,40.26},{25.88,40.29},{25.99,40.27},{25.9,40.31},{25.93,40.51},{25.9,40.37},{25.84,40.23},{25.88,40.12},{26.03,39.78},{25.92,40.06},{25.84,40.2},{25.74,40.32},{25.64,40.45},{25.58,40.49},{25.49,40.49},{25.42,40.58},{25.39,40.54},{24.92,42.88},{24.97,42.81},{25.04,42.73},{25.1,42.66},{25.17,42.63},{25.26,42.6},{25.34,42.52},{25.44,42.51},{25.36,42.5},{25.29,42.42},{25.23,42.32},{25.15,42.19},{25.09,42.08},{25.01,41.96},{24.94,41.86},{24.87,41.78},{24.79,41.71},{24.71,41.7},{24.61,41.74},{24.55,41.86},{24.5,41.99},{24.52,42.11},{24.55,42.22},{24.57,42.35},{24.58,42.47},{24.63,42.58},{24.67,42.67},{24.73,42.78},{24.81,42.89},{24.88,42.9},},[215]={{44.39,22.94},{44.16,23.05},{44.36,22.93},{44.14,22.73},{43.95,22.58},{43.94,22.38},{43.92,22.59},{44.07,22.69},{44.22,22.79},{44.39,22.92},{44.59,22.95},{44.86,22.92},{45.36,22.85},{45.09,22.88},{44.44,22.98},{44.51,22.68},{44.61,22.3},{44.87,21.96},{45.2,21.79},{45.49,21.71},{45.83,21.73},{46.07,22.03},{46.29,22.45},{46.28,22.84},{46.07,23.32},{45.81,23.66},{45.46,23.77},{44.94,23.76},{44.7,23.54},{44.43,23.18},{37.43,29.29},{37.55,29.43},{37.69,29.6},{37.87,29.7},{37.99,29.55},{38.11,29.39},{38.25,29.2},{38.4,29.0},{38.55,29.02},{38.74,29.08},{38.83,29.22},{38.91,29.39},{38.85,29.26},{38.74,29.07},{38.75,28.94},{38.78,28.69},{38.63,28.49},{38.53,28.37},{38.42,28.21},{38.29,28.02},{38.16,27.83},{38.03,27.63},{37.94,27.49},{37.81,27.37},{37.64,27.23},{37.48,27.21},{37.36,27.35},{37.24,27.59},{37.2,27.85},{37.22,28.09},{37.28,28.38},{37.34,28.68},{37.37,28.95},{37.38,29.16},{41.89,32.81},{42.18,32.94},{42.14,33.22},{42.24,32.87},{42.32,32.71},{42.42,32.49},{42.34,32.65},{42.19,32.78},{41.93,32.79},{41.75,32.73},{41.77,32.52},{41.72,32.7},{41.46,32.65},{41.37,32.64},{41.37,32.54},{41.34,32.68},{41.18,32.82},{41.12,32.93},{41.07,33.1},{41.02,33.44},{40.88,33.79},{41.03,33.43},{41.08,33.19},{41.1,33.03},{41.0,33.06},{40.9,33.11},{41.01,33.06},{41.1,32.96},{41.2,32.83},{41.35,32.71},{41.71,32.74},{35.44,20.78},{35.38,20.58},{35.21,20.32},{35.36,20.51},{35.46,20.64},{35.61,20.54},{35.48,20.65},{35.53,20.88},{35.63,21.17},{35.51,21.52},{35.66,21.68},{35.94,21.92},{35.77,21.76},{35.6,21.63},{35.32,21.49},{35.2,21.41},{34.98,21.25},{35.15,21.4},{35.33,21.53},{35.43,21.65},{35.38,21.88},{35.5,22.07},{35.38,21.91},{35.17,22.1},{34.82,22.17},{35.13,22.16},{35.29,21.89},{35.53,21.49},{35.6,21.13},{38.63,24.83},{38.77,24.85},{38.92,25.02},{38.77,25.32},{38.89,25.09},{39.06,25.25},{39.24,25.37},{39.23,25.59},{39.2,26.14},{39.22,25.85},{39.24,25.58},{39.28,25.26},{39.36,24.87},{39.61,24.49},{39.55,24.26},{39.66,24.37},{39.85,24.43},{40.07,24.4},{39.9,24.47},{39.95,24.86},{39.9,24.59},{39.77,24.31},{39.86,24.08},{40.15,23.42},{39.93,23.97},{39.77,24.25},{39.58,24.49},{39.39,24.75},{39.26,24.82},{39.09,24.83},{38.95,25.01},{38.89,24.92},{37.97,29.53},{38.06,29.41},{38.19,29.24},{38.31,29.11},{38.45,29.04},{38.64,28.99},{38.79,28.84},{39.0,28.82},{38.84,28.79},{38.7,28.64},{38.58,28.44},{38.42,28.17},{38.29,27.96},{38.13,27.72},{38.01,27.52},{37.87,27.37},{37.7,27.23},{37.54,27.2},{37.35,27.3},{37.23,27.52},{37.14,27.78},{37.17,28.03},{37.22,28.24},{37.27,28.49},{37.3,28.73},{37.39,28.95},{37.46,29.12},{37.58,29.33},{37.74,29.57},{37.87,29.57},},[405]={{99.34,50.39},{99.08,50.52},{99.3,50.38},{99.05,50.15},{98.83,49.98},{98.82,49.76},{98.8,49.99},{98.97,50.11},{99.14,50.22},{99.33,50.36},{99.56,50.4},{99.87,50.37},{99.39,50.43},{99.47,50.09},{99.58,49.67},{99.88,49.27},{99.96,51.33},{99.69,51.08},{99.38,50.67},{91.39,57.64},{91.51,57.81},{91.68,58.0},{91.89,58.12},{92.02,57.94},{92.16,57.76},{92.32,57.54},{92.49,57.32},{92.66,57.33},{92.88,57.4},{92.98,57.56},{93.07,57.76},{93.01,57.61},{92.88,57.4},{92.89,57.25},{92.92,56.97},{92.76,56.74},{92.64,56.6},{92.52,56.41},{92.37,56.2},{92.22,55.98},{92.07,55.75},{91.96,55.59},{91.82,55.46},{91.62,55.29},{91.44,55.27},{91.3,55.43},{91.16,55.71},{91.12,56.0},{91.14,56.28},{91.21,56.6},{91.27,56.95},{91.32,57.25},{91.33,57.5},{96.48,61.67},{96.81,61.81},{96.76,62.14},{96.88,61.73},{96.97,61.55},{97.08,61.31},{96.99,61.49},{96.82,61.64},{96.52,61.64},{96.32,61.57},{96.34,61.34},{96.29,61.55},{95.99,61.48},{95.89,61.48},{95.88,61.35},{95.85,61.52},{95.67,61.67},{95.59,61.81},{95.55,62.0},{95.49,62.38},{95.33,62.79},{95.49,62.38},{95.55,62.1},{95.57,61.92},{95.46,61.95},{95.35,62.01},{95.47,61.95},{95.58,61.84},{95.69,61.69},{95.87,61.56},{96.27,61.59},{89.11,47.93},{89.04,47.7},{88.85,47.39},{89.01,47.62},{89.14,47.77},{89.3,47.65},{89.15,47.78},{89.21,48.04},{89.32,48.37},{89.19,48.77},{89.36,48.95},{89.68,49.22},{89.49,49.05},{89.3,48.9},{88.97,48.74},{88.83,48.64},{88.58,48.46},{88.77,48.63},{88.98,48.78},{89.09,48.92},{89.04,49.18},{89.17,49.4},{89.04,49.21},{88.8,49.43},{88.4,49.51},{88.75,49.5},{88.94,49.19},{89.21,48.73},{89.29,48.33},{92.75,52.55},{92.91,52.57},{93.08,52.76},{92.92,53.1},{93.05,52.85},{93.24,53.03},{93.45,53.17},{93.44,53.42},{93.41,54.05},{93.42,53.72},{93.45,53.41},{93.49,53.04},{93.59,52.6},{93.87,52.16},{93.81,51.9},{93.93,52.02},{94.15,52.1},{94.4,52.06},{94.2,52.14},{94.26,52.58},{94.2,52.28},{94.05,51.95},{94.16,51.7},{94.49,50.94},{94.24,51.57},{94.06,51.89},{93.84,52.17},{93.62,52.46},{93.48,52.54},{93.28,52.55},{93.12,52.76},{93.05,52.65},{92.0,57.92},{92.1,57.78},{92.25,57.59},{92.39,57.44},{92.55,57.36},{92.77,57.3},{92.94,57.13},{93.17,57.11},{92.99,57.08},{92.83,56.9},{92.7,56.67},{92.52,56.36},{92.36,56.12},{92.19,55.86},{92.04,55.62},{91.88,55.45},{91.69,55.29},{91.51,55.26},{91.29,55.37},{91.15,55.62},{91.05,55.92},{91.09,56.2},{91.15,56.45},{91.2,56.74},{91.23,57.01},{91.33,57.26},{91.42,57.46},{91.55,57.7},{91.74,57.96},{91.89,57.97},},[1638]={{71.79,29.96},{70.68,30.53},{71.63,29.94},{70.57,28.96},{69.63,28.2},{69.57,27.24},{69.47,28.27},{70.19,28.76},{70.95,29.23},{71.77,29.86},{72.77,30.03},{74.11,29.9},{76.58,29.51},{75.24,29.69},{72.02,30.17},{72.35,28.69},{72.85,26.85},{74.14,25.17},{75.79,24.3},{77.19,23.91},{78.87,24.01},{80.07,25.52},{81.12,27.55},{81.1,29.48},{80.07,31.84},{78.77,33.51},{77.06,34.08},{74.5,34.01},{73.3,32.94},{71.96,31.16},{37.55,61.23},{38.1,61.93},{38.81,62.74},{39.71,63.26},{40.27,62.5},{40.86,61.73},{41.59,60.78},{42.32,59.83},{43.03,59.9},{43.98,60.18},{44.43,60.87},{44.79,61.73},{44.54,61.08},{44.0,60.16},{44.01,59.51},{44.17,58.3},{43.46,57.32},{42.96,56.71},{42.42,55.93},{41.78,54.99},{41.14,54.05},{40.48,53.07},{40.02,52.39},{39.42,51.81},{38.55,51.08},{37.77,51.0},{37.17,51.68},{36.58,52.88},{36.39,54.13},{36.5,55.35},{36.77,56.74},{37.06,58.24},{37.26,59.54},{37.3,60.62},{59.5,78.58},{60.91,79.19},{60.71,80.6},{61.21,78.84},{61.59,78.06},{62.09,77.01},{61.7,77.78},{60.97,78.43},{59.68,78.46},{58.81,78.15},{58.9,77.14},{58.66,78.04},{57.39,77.77},{56.93,77.75},{56.9,77.21},{56.77,77.93},{55.99,78.59},{55.67,79.17},{55.47,79.97},{55.21,81.65},{54.52,83.4},{55.24,81.61},{55.48,80.44},{55.57,79.64},{55.09,79.8},{54.62,80.06},{55.16,79.77},{55.6,79.31},{56.08,78.66},{56.84,78.08},{58.59,78.22},{27.74,19.36},{27.45,18.38},{26.61,17.06},{27.33,18.02},{27.85,18.67},{28.56,18.16},{27.91,18.72},{28.17,19.83},{28.65,21.26},{28.09,23.0},{28.83,23.75},{30.19,24.94},{29.37,24.19},{28.55,23.54},{27.16,22.86},{26.54,22.45},{25.45,21.64},{26.28,22.38},{27.17,23.03},{27.67,23.63},{27.44,24.76},{28.02,25.7},{27.44,24.91},{26.39,25.84},{24.69,26.17},{26.18,26.13},{27.02,24.8},{28.18,22.83},{28.52,21.09},{43.44,39.29},{44.11,39.38},{44.86,40.21},{44.14,41.67},{44.72,40.58},{45.54,41.35},{46.42,41.96},{46.4,43.02},{46.25,45.75},{46.32,44.3},{46.44,42.97},{46.62,41.39},{47.03,39.5},{48.24,37.6},{47.97,36.5},{48.52,37.01},{49.46,37.33},{50.52,37.15},{49.67,37.52},{49.92,39.41},{49.67,38.12},{49.03,36.7},{49.49,35.61},{50.92,32.33},{49.84,35.05},{49.04,36.43},{48.13,37.63},{47.15,38.89},{46.55,39.22},{45.69,39.27},{45.03,40.17},{44.72,39.73},{40.18,62.42},{40.64,61.82},{41.29,60.99},{41.86,60.35},{42.57,59.99},{43.49,59.74},{44.24,59.01},{45.23,58.91},{44.45,58.78},{43.76,58.03},{43.2,57.05},{42.42,55.71},{41.75,54.67},{41.0,53.53},{40.36,52.52},{39.69,51.79},{38.86,51.07},{38.08,50.97},{37.12,51.42},{36.55,52.52},{36.11,53.81},{36.26,55.01},{36.51,56.08},{36.72,57.32},{36.87,58.48},{37.32,59.58},{37.7,60.41},{38.26,61.46},{39.08,62.59},{39.72,62.63},},},1638,nil,nil,105,"H",},
[3085] = {'Gloria Femmel',919,919,20,20,0,{[44]={{26.66,43.51},},},nil,44,nil,nil,12,"A",},
[3086] = {'Gretchen Vogel',919,919,20,20,0,{[44]={{22.84,44.26},},},nil,44,nil,nil,12,"A",},
[3087] = {'Crystal Boughman',1042,1042,22,22,0,{[44]={{22.78,43.47},},},nil,44,nil,nil,12,"A",},
[3088] = {'Henry Chapal',1240,1240,25,25,0,{[44]={{23.84,41.32},},},nil,44,nil,nil,12,"A",},
[3089] = {'Sherman Femmel',980,980,21,21,0,{[44]={{26.73,43.24},},},nil,44,nil,nil,12,"A",},
[3090] = {'Gerald Crawley',1240,1240,25,25,0,{[44]={{25.11,41.13},},},nil,44,nil,nil,12,"A",},
[3091] = {'Franklin Hamar',1309,1309,26,26,0,{[44]={{27.18,45.54},},},nil,44,nil,nil,12,"A",},
[3092] = {'Tagain',1605,1605,30,30,0,{[1638]={{43.44,44.34},},},nil,1638,nil,nil,104,"H",},
[3093] = {'Grod',1605,1605,30,30,0,{[1638]={{42.66,43.51},},},nil,1638,nil,nil,104,"H",},
[3094] = {'Unseen',2165,2315,49,51,0,{[10]={{18.06,54.34},{17.53,54.79},{19.23,55.04},{66.44,76.67},{55.14,60.21},{54.39,59.23},{53.69,60.55},{52.11,62.25},{51.79,61.46},{14.34,67.07},{21.34,57.25},{18.13,57.94},{17.38,56.38},{17.98,54.71},{18.12,54.34},{21.12,55.5},{66.2,76.4},{65.53,67.84},{66.02,69.3},{65.26,67.68},{65.56,67.39},{54.41,60.1},{53.7,61.86},{19.22,53.39},{19.21,53.76},{77.47,36.22},{78.54,35.04},{78.64,36.22},},},nil,10,nil,nil,15,"AH",},
[3095] = {'Fela',1605,1605,30,30,0,{[1638]={{42.75,44.8},},},nil,1638,nil,nil,104,"H",},
[3096] = {'Captured Servant of Azora',1042,1042,22,22,0,{[44]={{74.46,79.51},},},nil,44,nil,nil,35,"AH",},
[3097] = {'Bernard Brubaker',919,919,20,20,0,{[44]={{88.25,71.02},},},nil,44,nil,nil,12,"A",},
[3098] = {'Mottled Boar',42,55,1,2,0,{[14]={{45.16,70.47},{46.5,66.88},{45.75,65.07},{43.92,70.62},{41.97,72.5},{46.52,64.15},{44.49,61.94},{47.12,65.09},{41.27,65.1},{44.44,61.54},{43.36,72.42},{43.46,61.07},{42.55,61.19},{41.99,64.86},{42.72,71.58},{43.89,62.4},{41.39,71.64},{44.54,70.61},{42.69,72.72},{46.32,62.96},{41.98,64.17},{42.09,71.91},{43.95,71.58},{43.86,60.31},{45.81,67.06},{47.01,68.68},{46.37,65.9},{46.43,68.78},{43.38,62.12},{45.22,69.66},{44.03,61.12},{44.59,71.61},{43.87,72.57},{45.77,68.87},{45.18,66.93},{43.14,60.32},{44.53,60.36},{43.36,64.81},{44.64,59.27},{45.81,61.28},{45.23,60.39},{45.0,63.07},{45.63,62.36},{43.07,64.02},{44.57,63.23},{43.2,63.23},{45.67,65.76},{43.84,64.91},{43.85,64.25},{45.27,63.99},{45.2,65.16},{45.06,65.89},{42.58,65.12},{43.96,65.96},{44.49,65.1},{44.47,64.07},{45.19,62.23},{45.77,63.0},{43.78,63.06},{42.65,60.06},{42.1,63.09},{41.98,62.14},{44.49,66.03},{42.02,61.21},},},nil,14,nil,nil,189,"AH",},
[3099] = {'Dire Mottled Boar',120,137,6,7,0,{[14]={{52.03,49.96},{54.2,30.65},{53.82,49.83},{51.52,63.73},{58.36,41.55},{38.96,37.84},{47.6,44.5},{42.61,32.91},{54.42,37.99},{51.21,49.42},{41.99,31.52},{47.66,43.4},{48.3,45.89},{52.01,61.69},{51.68,53.58},{51.64,72.46},{39.96,47.75},{52.59,57.07},{57.93,46.8},{43.72,46.42},{54.58,67.44},{44.42,34.63},{40.0,47.37},{56.16,39.64},{52.23,62.96},{57.36,44.38},{47.0,42.76},{42.93,50.12},{53.17,36.8},{47.24,38.32},{43.95,43.3},{42.72,46.02},{53.36,32.77},{45.98,34.91},{56.02,38.99},{46.7,44.68},{53.52,34.98},{40.67,40.66},{55.36,32.76},{53.53,68.1},{54.53,57.38},{42.88,43.25},{56.22,41.31},{50.74,55.9},{40.21,48.99},{41.07,36.82},{51.52,34.13},{45.02,43.46},{55.83,35.36},{50.9,34.69},{52.72,65.0},{53.92,31.63},{43.11,43.96},{55.24,40.32},{52.38,56.59},{44.56,37.08},{40.69,50.77},{53.85,59.12},{49.5,34.84},{38.93,47.06},{51.1,33.11},{41.1,44.92},{52.23,60.72},{43.79,33.98},{54.58,34.67},{42.09,44.25},{53.16,58.62},{45.38,48.59},{45.97,48.27},{51.71,46.04},{50.67,36.66},{40.77,44.86},{53.07,31.31},{56.54,36.71},{51.72,59.03},{55.37,39.58},{51.89,66.94},{39.4,36.54},{55.65,58.74},{40.45,32.76},{51.38,37.64},{46.18,44.38},{38.62,44.95},{45.22,41.27},{45.74,44.59},{51.54,62.09},{54.53,38.74},{48.22,40.19},{50.77,53.86},{55.72,56.23},{42.03,47.14},{46.21,39.14},{51.6,65.4},{54.39,35.86},{51.71,65.87},{53.9,56.22},{48.3,36.66},{46.94,46.29},{55.38,43.96},{42.81,47.68},{54.08,70.77},{38.11,35.87},{51.04,51.81},{45.65,38.32},{50.46,71.78},{51.22,56.73},{54.21,53.06},{41.65,50.35},{53.3,48.79},{55.25,56.98},{53.43,46.16},{52.21,47.86},{51.75,78.12},{53.91,62.59},{50.46,75.0},{49.57,73.7},},[17]={{71.58,36.23},{71.12,35.55},},},{[14]={{54.53,57.38},{54.62,57.68},{54.7,57.97},{54.73,58.31},{54.57,58.58},{54.44,58.93},{54.37,59.51},{54.35,60.1},{54.39,60.4},{54.51,60.68},{54.62,60.76},{54.78,60.63},{54.95,60.42},{55.06,60.31},{55.17,60.0},{55.26,59.6},{55.26,59.26},{55.32,58.96},{55.36,58.82},{55.52,58.46},{55.55,58.3},{55.53,58.1},{55.47,57.95},{55.38,57.72},{55.27,57.47},{55.01,57.29},{54.76,57.26},{54.21,53.06},{54.11,53.4},{54.18,53.67},{54.29,53.91},{54.46,54.24},{54.61,54.56},{54.77,54.88},{55.0,54.99},{55.15,54.92},{55.25,54.67},{55.25,54.36},{55.29,54.12},{55.36,53.67},{55.39,53.46},{55.32,53.23},{55.16,53.03},{55.03,52.96},{54.87,52.88},{54.65,52.86},{54.48,52.9},{55.25,56.98},{55.49,56.78},{55.55,56.63},{55.62,56.48},{55.69,56.13},{55.45,55.75},{55.27,55.45},{54.99,54.88},{54.67,54.98},{54.46,54.62},{54.33,54.23},{54.23,54.14},{53.97,54.3},{53.82,54.47},{53.92,54.8},{54.14,55.44},{54.38,55.66},{54.52,56.09},{54.65,56.49},{54.43,56.75},{54.34,56.89},{54.28,57.03},{54.35,57.24},{54.41,57.38},{54.55,57.64},{54.71,57.74},{54.87,57.5},{55.06,57.15},{50.46,75.0},{50.67,75.23},{50.91,75.51},{51.12,75.72},{51.28,75.85},{51.65,75.82},{51.89,75.6},{52.23,75.37},{52.45,75.25},{52.6,74.94},{52.5,74.64},{52.37,74.31},{52.36,74.05},{52.3,73.48},{52.5,73.11},{52.59,72.93},{52.75,72.57},{52.84,72.32},{52.69,72.1},{52.47,71.81},{52.21,71.95},{51.96,72.09},{51.6,72.47},{51.49,72.56},{50.99,72.41},{50.66,72.52},{50.33,72.77},{50.07,73.19},{49.83,73.6},{49.72,74.13},{49.86,74.33},{50.13,74.64},{50.37,74.91},{49.57,73.7},{49.59,73.37},{49.75,73.02},{49.93,72.65},{50.06,72.32},{50.27,71.94},{50.41,71.78},{50.69,71.55},{50.8,71.47},{50.98,70.92},{51.23,70.72},{51.42,71.68},{51.46,72.12},{51.51,72.46},{51.58,72.85},{51.67,73.48},{51.42,73.79},{51.3,74.31},{51.16,74.6},{50.92,74.83},{50.67,75.02},{50.52,74.95},{50.33,74.88},{50.01,74.69},{49.79,74.47},{49.66,74.32},{49.62,74.01},},[17]={{73.7,27.04},{73.75,27.2},{73.79,27.35},{73.81,27.52},{73.73,27.66},{73.66,27.85},{73.62,28.15},{73.61,28.46},{73.63,28.62},{73.69,28.76},{73.75,28.8},{73.83,28.73},{73.92,28.63},{73.98,28.57},{74.04,28.4},{74.08,28.2},{74.08,28.02},{74.12,27.87},{74.14,27.79},{74.22,27.6},{74.24,27.52},{74.22,27.41},{74.2,27.34},{74.15,27.22},{74.09,27.08},{73.96,26.99},{73.83,26.98},{73.54,24.78},{73.49,24.96},{73.52,25.1},{73.58,25.23},{73.67,25.4},{73.75,25.57},{73.83,25.73},{73.95,25.79},{74.03,25.75},{74.08,25.63},{74.08,25.46},{74.1,25.34},{74.14,25.1},{74.15,24.99},{74.12,24.87},{74.03,24.77},{73.96,24.73},{73.88,24.69},{73.77,24.68},{73.68,24.7},{74.08,26.83},{74.21,26.72},{74.24,26.65},{74.27,26.57},{74.31,26.38},{74.18,26.19},{74.09,26.03},{73.95,25.74},{73.78,25.78},{73.67,25.6},{73.6,25.4},{73.55,25.35},{73.41,25.43},{73.33,25.52},{73.39,25.69},{73.5,26.03},{73.63,26.14},{73.7,26.37},{73.77,26.57},{73.65,26.71},{73.61,26.78},{73.58,26.85},{73.61,26.96},{73.64,27.04},{73.71,27.17},{73.8,27.23},{73.88,27.1},{73.98,26.92},{71.58,36.23},{71.69,36.35},{71.82,36.5},{71.93,36.61},{72.01,36.68},{72.2,36.66},{72.33,36.55},{72.51,36.42},{72.62,36.36},{72.7,36.2},{72.64,36.04},{72.58,35.87},{72.57,35.74},{72.54,35.44},{72.65,35.24},{72.69,35.15},{72.77,34.96},{72.82,34.83},{72.74,34.72},{72.63,34.57},{72.49,34.64},{72.36,34.71},{72.18,34.91},{72.12,34.96},{71.86,34.88},{71.69,34.94},{71.51,35.07},{71.38,35.29},{71.25,35.5},{71.2,35.78},{71.27,35.88},{71.41,36.05},{71.53,36.18},{71.12,35.55},{71.13,35.38},{71.21,35.2},{71.31,35.01},{71.37,34.83},{71.48,34.63},{71.55,34.55},{71.7,34.43},{71.76,34.39},{71.85,34.1},{71.98,34.0},{72.08,34.5},{72.1,34.73},{72.13,34.91},{72.16,35.11},{72.21,35.44},{72.08,35.6},{72.02,35.87},{71.95,36.02},{71.82,36.14},{71.69,36.24},{71.61,36.21},{71.51,36.17},{71.35,36.07},{71.23,35.96},{71.16,35.88},{71.14,35.71},},},14,nil,nil,189,"AH",},
[3100] = {'Elder Mottled Boar',156,176,8,9,0,{[14]={{50.92,15.57},{44.59,25.24},{38.04,48.47},{37.51,54.6},{36.91,44.89},{57.75,24.52},{55.1,10.99},{36.25,49.22},{36.42,55.46},{53.65,16.8},{43.98,15.26},{45.98,19.42},{43.32,18.09},{45.86,15.53},{44.92,16.2},{37.65,45.18},{35.55,45.56},{55.15,18.64},{43.92,26.26},{57.05,17.77},{37.2,26.37},{44.64,27.04},{36.87,48.25},{55.45,16.11},{36.16,24.25},{39.55,44.31},{58.39,27.29},{35.56,39.36},{38.26,42.11},{37.03,31.73},{35.03,46.47},{55.25,20.45},{47.91,20.44},{36.34,38.85},{35.7,47.04},{51.56,13.21},{44.64,21.17},{50.15,14.79},{38.57,44.32},{39.42,17.64},{55.96,21.7},{37.55,55.64},{53.9,9.28},{52.51,15.86},{35.93,34.94},{52.93,14.18},{47.11,20.17},{42.37,18.49},{52.93,17.52},{43.15,27.92},{56.49,13.19},{41.9,16.72},{37.21,19.0},{48.28,15.83},{37.13,41.35},{48.56,20.69},{40.14,33.78},{39.55,18.73},{55.16,28.12},{39.57,49.49},{54.6,28.78},{44.46,23.3},{37.78,55.77},{40.68,42.48},{36.18,31.92},{54.77,19.37},{42.6,22.33},{51.63,16.66},{56.89,28.36},{37.67,29.98},{36.05,26.01},{42.65,21.47},{54.52,11.02},{52.21,14.79},{40.18,21.79},{35.14,49.34},{42.05,22.77},{43.94,21.54},{57.03,29.76},{39.33,19.62},{35.45,55.66},{37.0,28.07},{55.19,14.02},{40.13,17.05},{40.48,21.57},{57.68,20.25},{45.99,22.22},{56.88,24.6},{36.89,46.12},{45.36,27.33},{51.81,11.83},{59.05,24.24},{38.73,21.21},{37.13,52.39},{54.26,17.42},{55.58,12.93},{42.76,28.28},{53.4,13.05},{45.41,25.07},{57.51,18.55},{56.96,23.38},{57.14,19.33},{38.26,28.87},{35.66,30.98},{47.7,12.7},{54.02,18.93},{38.52,48.86},{56.15,17.04},{43.23,21.45},{55.8,9.98},{39.43,51.67},{42.69,17.58},{47.83,18.43},{44.78,22.31},{36.45,38.54},{38.61,33.71},{50.2,12.9},{57.68,22.48},{46.34,17.91},{43.93,22.39},{36.3,35.73},{44.69,17.76},{45.14,18.58},{45.49,16.63},{44.54,19.55},{34.99,43.25},{54.63,15.76},{44.95,17.67},{44.15,17.32},{43.19,16.93},{45.23,16.73},{45.74,15.74},{43.81,15.55},},},nil,14,nil,nil,189,"AH",},
[3101] = {'Vile Familiar',70,86,3,4,0,{[14]={{46.16,56.07},{42.76,52.71},{42.65,54.63},{43.71,55.47},{43.91,53.55},{43.8,55.6},{42.99,53.56},{44.45,52.66},{44.24,55.26},{42.81,52.53},{43.45,55.54},{43.22,54.32},{43.94,54.27},{43.57,53.47},{43.89,55.29},{43.72,52.54},{44.11,53.95},{46.16,56.79},{46.47,57.28},{47.01,57.28},{43.92,53.81},{43.82,58.29},{44.51,58.49},{45.02,58.24},{44.39,57.2},{42.75,52.7},{44.13,57.0},{44.74,53.76},{45.33,55.86},{45.66,56.84},{45.15,55.07},{45.36,56.32},{44.59,56.02},{45.19,57.3},{44.85,56.92},{45.76,57.35},{45.75,58.48},},},{[14]={{42.85,52.31},{43.05,52.01},{43.18,52.11},{43.43,51.97},{43.64,52.31},{43.84,52.9},{44.25,52.81},{44.42,52.43},{44.25,52.81},{43.84,52.9},{43.64,52.31},{43.43,51.97},{43.18,52.11},{43.05,52.01},{42.85,52.31},{42.75,52.71},{43.54,55.63},{43.3,55.58},{42.96,55.28},{42.88,54.93},{42.52,54.43},{42.35,54.04},{42.4,53.59},{42.77,53.56},{43.11,53.67},{43.28,54.04},{43.11,53.67},{42.77,53.56},{42.4,53.59},{42.35,54.04},{42.52,54.43},{42.88,54.93},{42.96,55.28},{43.3,55.58},{43.53,55.63},{43.75,55.43},{44.34,54.34},{44.56,54.84},{44.28,55.25},{43.9,55.36},{43.84,54.97},{43.93,54.41},{44.06,53.97},{45.29,55.67},{45.53,55.27},{45.37,55.05},{45.1,54.98},{44.92,54.92},{44.82,54.53},{44.76,54.02},{44.78,53.51},{44.92,53.27},{44.81,52.81},{44.92,53.27},{44.78,53.51},{44.76,54.02},{44.82,54.53},{44.92,54.92},{45.1,54.98},{45.37,55.05},{45.53,55.27},{45.29,55.67},{45.35,55.92},},[17]={{67.61,24.4},{67.71,24.24},{67.78,24.29},{67.91,24.22},{68.02,24.4},{68.12,24.7},{68.34,24.66},{68.43,24.45},{68.34,24.66},{68.12,24.7},{68.02,24.4},{67.91,24.22},{67.78,24.29},{67.71,24.24},{67.61,24.4},{67.56,24.6},{67.97,26.13},{67.84,26.1},{67.67,25.95},{67.63,25.76},{67.44,25.5},{67.35,25.29},{67.38,25.06},{67.57,25.05},{67.75,25.1},{67.83,25.29},{67.75,25.1},{67.57,25.05},{67.38,25.06},{67.35,25.29},{67.44,25.5},{67.63,25.76},{67.67,25.94},{67.84,26.1},{67.97,26.13},{68.08,26.02},{68.38,25.45},{68.5,25.71},{68.35,25.93},{68.16,25.99},{68.13,25.78},{68.17,25.49},{68.24,25.26},{68.88,26.15},{69.01,25.94},{68.92,25.82},{68.78,25.79},{68.69,25.76},{68.64,25.55},{68.61,25.29},{68.62,25.02},{68.69,24.89},{68.63,24.65},{68.69,24.89},{68.62,25.02},{68.61,25.29},{68.64,25.55},{68.69,25.76},{68.78,25.79},{68.92,25.82},{69.01,25.94},{68.88,26.15},{68.91,26.28},},},14,nil,nil,14,nil,},
[3102] = {'Felstalker',72,86,3,4,0,{[14]={{42.97,52.1},{43.83,54.86},{44.82,52.48},{44.12,52.87},{43.01,55.34},{43.26,53.85},{44.49,54.93},{42.43,54.18},{42.52,53.5},{44.29,54.19},{44.85,53.11},{44.83,52.55},{43.55,52.14},{44.75,54.54},{45.54,55.34},{45.3,55.7},},},nil,14,nil,nil,14,nil,},
[3103] = {'Makrura Clacker',120,137,6,7,0,{[14]={{65.22,49.82},{62.2,92.51},{70.35,85.92},{69.69,77.26},{70.49,82.28},{61.77,80.37},{64.01,55.43},{70.75,75.24},{69.92,88.75},{60.92,96.33},{63.5,60.12},{62.96,56.37},{59.15,91.5},{59.06,87.64},{59.69,72.41},{58.96,82.14},{68.69,77.17},{61.04,77.34},{64.65,48.77},{65.25,51.53},{63.51,50.79},{61.06,72.51},{62.1,68.87},{63.41,58.48},{67.3,77.22},{61.56,42.98},{64.67,54.85},{62.83,43.03},{71.68,72.62},{65.51,53.96},{62.13,40.54},{64.63,77.16},{62.84,45.05},{62.79,61.11},{62.19,67.05},{59.54,86.96},{52.68,84.9},{61.59,50.89},{51.41,84.88},{57.34,80.02},{62.74,47.01},},},nil,14,nil,nil,129,nil,},
[3104] = {'Makrura Shellhide',120,137,6,7,0,{[14]={{53.89,84.83},{60.28,73.5},{61.44,44.81},{61.07,42.55},{62.14,49.73},{65.89,73.62},{61.47,54.35},{64.78,50.89},{63.97,57.62},{66.64,78.12},{63.44,73.81},{58.2,85.15},{63.45,55.76},{60.91,40.44},{61.48,48.76},{65.74,71.74},{61.45,69.7},{61.02,84.65},{60.22,75.74},{55.08,82.85},{60.31,71.58},},},nil,14,nil,nil,129,nil,},
[3105] = {'Makrura Snapclaw',156,176,8,9,0,{[14]={{60.36,26.41},{60.35,17.25},{59.84,28.91},{57.53,9.39},{58.48,10.21},{58.82,15.11},{60.23,29.95},{60.44,18.49},{60.28,20.69},},},nil,14,nil,nil,129,nil,},
[3106] = {'Pygmy Surf Crawler',102,120,5,6,0,{[14]={{63.77,54.64},{63.37,61.03},{62.47,43.99},{66.02,53.46},{63.45,45.33},{63.1,47.99},{62.91,54.95},{62.67,58.23},{59.77,73.58},{61.7,53.46},{58.19,78.81},{54.5,82.97},{60.96,50.13},{63.19,44.24},{61.18,48.02},{61.32,61.76},{65.9,50.9},{63.23,54.72},{64.86,54.99},{62.78,51.59},{60.31,45.12},{60.96,52.3},{60.95,69.94},{65.45,49.32},{61.48,39.51},{64.06,47.16},{60.34,43.27},{62.73,62.55},{63.94,57.16},{53.43,82.95},{52.7,83.04},{52.13,83.97},{60.94,43.83},{53.92,83.01},{52.22,83.11},{51.53,84.03},{55.37,79.94},{55.84,80.27},{54.67,83.95},{55.21,81.75},{56.52,79.12},{57.21,79.25},{57.18,78.05},{62.82,48.95},{64.12,48.79},{56.44,80.11},{60.33,49.02},{54.63,82.0},{55.94,79.3},{60.34,47.05},{54.04,82.18},},},nil,14,nil,nil,7,"AH",},
[3107] = {'Surf Crawler',137,156,7,8,0,{[14]={{66.06,79.39},{58.85,28.34},{63.15,74.03},{63.4,92.82},{66.35,72.89},{63.15,93.2},{67.04,76.41},{62.85,81.35},{62.72,76.07},{66.19,70.78},{61.89,94.94},{67.97,78.58},{60.18,22.79},{70.47,75.93},{69.72,78.79},{59.96,25.28},{71.12,71.47},{64.57,94.18},{66.99,90.78},{60.27,24.69},{60.2,85.79},{70.98,73.95},{60.91,17.71},{65.17,93.35},{64.15,78.85},{63.9,89.03},{63.64,76.99},{58.89,86.2},{62.1,79.33},{59.89,27.17},{63.65,93.2},{64.64,96.5},{60.29,92.26},{68.99,76.25},{65.07,89.87},{67.26,75.49},{64.11,72.16},{58.28,83.54},{62.1,76.63},{65.94,91.47},{66.09,69.96},{63.3,97.99},{70.45,80.1},{60.99,86.75},{61.54,87.39},{61.44,82.12},{69.55,87.53},{62.07,90.54},{67.89,68.73},{60.81,25.39},{70.52,68.99},{65.49,74.64},{69.27,78.26},{64.6,98.24},{59.78,23.62},{62.08,80.94},{65.93,75.63},{59.63,81.31},{65.13,72.59},},},nil,14,nil,nil,7,"AH",},
[3108] = {'Encrusted Surf Crawler',176,198,9,10,0,{[14]={{57.87,15.22},{56.94,10.16},{58.44,15.68},{56.3,11.08},{58.29,13.76},{57.18,12.31},{57.9,8.42},{56.54,9.11},{59.13,16.62},{57.75,13.15},{57.81,11.4},{58.12,12.04},},},nil,14,nil,nil,7,"AH",},
[3110] = {'Dreadmaw Crocolisk',176,222,9,11,0,{[14]={{34.98,26.13},{35.24,30.11},{34.83,54.32},{34.52,53.77},{35.24,24.62},{35.08,39.22},{35.62,57.26},{35.29,28.31},{35.27,56.23},{36.48,22.22},{35.7,25.31},{34.33,48.13},{36.82,22.1},{34.48,44.27},{34.64,52.09},{34.14,46.04},{36.42,61.19},{37.44,66.05},{36.48,61.09},{36.78,17.21},{37.06,15.81},{37.65,68.12},{36.86,62.22},{34.38,44.17},{35.76,57.39},},[17]={{63.16,15.2},{63.26,13.95},{63.04,23.09},{63.36,11.25},{62.78,20.7},{62.93,21.73},{62.84,23.81},{63.88,27.93},{63.29,12.22},{62.87,24.49},{64.2,8.02},{63.88,9.32},{63.18,16.48},{63.21,13.94},{63.29,11.28},{63.07,15.29},{64.98,33.53},{63.18,10.53},{63.78,8.34},{62.69,15.48},{62.88,20.89},{65.33,34.42},{63.2,26.03},{62.72,23.68},},},nil,14,nil,nil,14,nil,},
[3111] = {'Razormane Quilboar',120,137,6,7,0,{[14]={{50.21,50.78},{46.22,49.02},{46.98,48.14},{47.39,49.33},{49.08,48.67},{49.57,47.65},{47.59,49.65},{47.54,48.6},{47.21,48.67},{48.98,48.26},{50.7,48.95},{50.33,49.07},{48.91,48.75},{48.82,48.88},{49.37,48.16},},},nil,14,nil,nil,109,nil,},
[3112] = {'Razormane Scout',137,156,7,8,0,{[14]={{44.05,49.65},{47.22,47.96},{47.13,49.54},{47.39,49.85},{44.03,50.33},{44.44,50.04},{43.29,50.76},{44.87,50.42},{44.18,49.6},{44.49,50.67},{43.65,50.24},{49.84,49.3},{50.06,49.33},{49.37,48.68},{49.18,49.09},{49.55,47.77},{47.56,47.85},{50.15,49.81},},},{[14]={{50.06,49.33},{49.71,49.23},{49.47,49.13},{49.36,48.89},{49.26,48.65},{49.13,48.59},{49.05,48.75},{49.08,48.91},{49.12,49.04},{49.31,49.19},{49.42,49.15},{49.43,48.99},{49.34,48.89},{49.18,48.91},{49.04,48.96},{48.96,48.94},{48.91,48.79},{49.06,48.89},{49.25,48.97},{49.46,49.06},{49.67,49.15},{49.87,49.24},{49.55,47.77},{49.55,47.51},{49.56,47.38},{49.6,47.27},{49.65,47.18},{49.58,47.29},{49.57,47.41},{49.55,47.5},{49.55,47.78},{49.5,47.98},{49.37,48.17},{49.24,48.39},{49.39,48.17},{49.48,48.01},{49.55,47.86},},[17]={{71.37,22.84},{71.19,22.79},{71.06,22.73},{71.01,22.61},{70.96,22.48},{70.89,22.45},{70.85,22.53},{70.86,22.62},{70.88,22.69},{70.98,22.76},{71.04,22.75},{71.04,22.66},{70.99,22.61},{70.91,22.62},{70.84,22.64},{70.8,22.64},{70.77,22.56},{70.85,22.61},{70.95,22.65},{71.06,22.7},{71.17,22.74},{71.27,22.79},{71.11,22.02},{71.11,21.89},{71.11,21.82},{71.13,21.77},{71.16,21.72},{71.12,21.78},{71.11,21.84},{71.1,21.88},{71.11,22.03},{71.08,22.13},{71.01,22.24},{70.95,22.35},{71.02,22.23},{71.07,22.15},{71.1,22.07},},},14,nil,nil,109,nil,},
[3113] = {'Razormane Dustrunner',148,166,8,9,0,{[14]={{38.86,52.79},{39.02,53.74},{38.15,52.94},{39.3,52.92},{39.53,53.24},{43.38,37.29},{44.18,38.22},{44.09,37.54},{43.29,39.05},{41.73,38.55},{42.87,38.82},{41.76,37.24},{41.33,37.58},{44.0,39.76},{43.88,40.5},{43.14,39.58},{42.86,39.26},},},nil,14,nil,nil,109,nil,},
[3114] = {'Razormane Battleguard',176,198,9,10,0,{[14]={{38.77,53.52},{38.26,54.66},{39.4,53.78},{38.25,53.96},{38.72,55.19},{42.74,37.37},{43.7,38.15},{41.93,38.87},{41.74,38.2},{39.1,52.96},{44.12,39.23},{44.65,37.34},{44.48,39.64},{42.54,38.94},{42.27,39.37},{43.06,38.89},{41.86,40.31},{42.97,38.17},{45.13,37.55},{42.24,37.24},{42.89,41.58},{42.72,40.35},{42.61,39.18},{43.88,41.42},{43.24,40.5},},},nil,14,nil,nil,109,nil,},
[3115] = {'Dustwind Harpy',137,156,7,8,0,{[14]={{45.85,33.84},{50.57,26.02},{44.99,29.02},{47.72,33.1},{49.14,22.17},{45.03,32.77},{48.16,33.01},{45.86,30.07},{48.19,32.05},{45.22,30.97},{48.67,32.32},{48.09,31.52},{47.74,31.12},{49.96,27.56},{49.88,32.52},{50.15,25.11},},},nil,14,nil,nil,514,nil,},
[3116] = {'Dustwind Pillager',137,156,7,8,0,{[14]={{47.21,29.64},{49.05,21.29},{48.92,20.61},{48.42,20.74},{48.34,31.65},{47.72,30.23},{47.12,30.13},{46.5,30.2},{46.77,30.4},{47.44,30.58},{51.35,27.29},{48.83,19.5},{50.51,26.71},},},nil,14,nil,nil,514,nil,},
[3117] = {'Dustwind Savage',176,198,9,10,0,{[14]={{51.82,23.82},{52.39,23.92},{52.81,24.29},{54.06,24.47},{52.75,21.35},{54.03,23.56},{52.12,20.77},{53.87,25.04},{54.07,27.33},{53.91,22.7},{53.92,27.84},{53.69,21.89},{53.96,26.32},{53.32,24.76},{51.43,20.86},},},nil,14,nil,nil,514,nil,},
[3118] = {'Dustwind Storm Witch',186,208,10,11,0,{[14]={{51.56,21.65},{51.36,23.07},{52.02,20.07},{51.87,23.53},{51.53,23.39},{50.97,19.56},{51.34,23.63},{53.01,23.86},{53.35,23.75},{51.22,23.25},{54.11,22.35},{53.26,21.63},{52.01,21.41},{51.74,19.99},{51.27,19.19},{51.57,19.03},{51.34,20.19},{53.13,24.25},},},nil,14,nil,nil,514,nil,},
[3119] = {'Kolkar Drudge',119,143,6,7,0,{[14]={{51.33,79.31},{52.26,80.21},{48.11,80.49},{48.1,77.65},{49.89,80.03},{46.71,80.54},{48.21,79.99},{50.04,78.52},{46.44,79.52},{52.03,76.48},{49.67,80.45},{53.04,79.83},{52.63,81.21},{49.02,79.65},{48.06,79.24},{50.15,79.23},{47.64,78.65},{52.08,82.03},{52.7,77.29},},},nil,14,nil,nil,130,nil,},
[3120] = {'Kolkar Outrunner',130,156,7,8,0,{[14]={{47.77,77.68},{49.83,81.36},{46.59,79.19},{50.07,80.53},{46.29,79.3},{47.64,78.1},{48.07,78.44},},},nil,14,nil,nil,130,nil,},
[3121] = {'Durotar Tiger',137,156,7,8,0,{[14]={{64.08,95.36},{63.25,96.25},{69.02,72.42},{62.89,97.1},{69.15,69.69},{69.08,80.32},{64.7,81.0},{64.63,88.53},{70.31,73.44},{69.76,72.79},{67.21,70.71},{63.99,97.29},{59.0,90.55},{65.27,80.24},{69.23,73.68},{62.41,95.17},{69.14,84.83},{67.67,73.8},{64.64,84.97},{65.89,81.27},{65.31,87.79},{60.18,80.02},{60.68,82.3},{59.62,84.72},{59.83,83.29},{60.85,88.75},{61.52,89.61},{60.96,90.57},{61.43,91.33},{60.33,91.39},},},nil,14,nil,nil,14,nil,},
[3122] = {'Bloodtalon Taillasher',120,156,6,8,0,{[14]={{45.78,36.57},{46.3,37.64},{42.26,49.09},{54.38,32.46},{49.36,19.23},{56.55,24.0},{40.26,47.73},{42.34,34.4},{56.09,29.25},{39.49,51.86},{66.72,88.98},{67.22,80.52},{59.89,88.04},{62.03,96.29},{69.8,74.67},{70.23,70.92},{68.43,83.87},{57.02,24.45},{39.21,47.05},{40.5,46.56},{48.9,36.88},{43.3,46.53},{50.44,35.36},{55.3,30.51},{57.62,28.52},{44.22,45.38},{58.22,26.34},{68.51,87.08},{63.87,83.76},{68.89,71.09},{68.64,74.7},{57.98,23.13},{47.61,36.79},{54.9,34.47},{41.18,50.33},{40.51,38.2},{40.73,34.77},{55.31,37.29},{49.8,37.0},{56.87,26.77},{44.45,33.97},{69.79,70.42},{64.89,82.32},{69.22,82.07},{68.29,71.78},{63.98,86.81},{64.59,73.33},{67.16,71.23},{44.18,33.61},{63.09,94.42},{68.07,80.52},{63.49,74.51},{67.74,69.83},{68.18,88.51},{60.26,82.64},{41.6,47.01},{61.42,78.12},{59.39,83.88},{59.85,89.59},{60.93,78.81},},},nil,14,nil,nil,48,nil,},
[3123] = {'Bloodtalon Scythemaw',156,198,8,10,0,{[14]={{38.46,37.37},{35.85,48.92},{36.29,27.66},{54.87,19.28},{36.06,53.24},{55.22,13.14},{55.77,12.0},{52.97,12.44},{37.01,46.39},{38.35,48.89},{37.52,32.42},{37.19,54.92},{40.44,16.07},{54.44,17.98},{39.2,19.07},{37.49,36.13},{37.09,47.28},{54.05,11.74},{56.95,15.0},{52.11,10.62},{37.94,40.0},{42.85,18.53},{36.75,34.26},{53.22,16.03},{39.27,17.09},{36.01,31.77},{36.75,27.15},{55.86,15.85},{36.89,29.65},{51.83,14.52},{36.76,25.43},{42.08,21.33},{53.93,13.46},{36.03,37.04},{36.63,39.1},{39.18,19.51},},},nil,14,nil,nil,48,nil,},
[3124] = {'Scorpid Worker',71,71,3,3,0,{[14]={{40.91,62.03},{43.14,56.43},{46.81,59.95},{41.5,65.86},{41.96,58.36},{47.73,64.01},{45.21,72.75},{47.04,62.1},{40.1,67.84},{43.2,59.53},{43.31,58.35},{40.12,68.62},{47.14,63.05},{46.41,59.32},{46.38,60.11},{43.95,73.67},{47.22,64.02},{39.99,66.02},{40.74,66.75},{46.5,61.35},{39.39,61.13},{40.7,70.5},{41.29,70.6},{40.7,67.74},{40.75,65.76},{45.09,71.37},{47.1,61.32},{41.77,57.33},{43.2,73.64},{41.4,67.91},{42.83,58.45},{41.34,66.8},{41.83,65.81},{40.06,66.87},{40.67,68.52},{45.6,58.71},{41.44,60.39},{40.67,61.23},{40.05,63.42},{39.59,63.08},{40.1,64.01},{40.82,62.94},{42.59,59.23},{39.97,61.39},{39.51,62.27},{40.22,62.07},{43.96,59.47},{41.49,64.27},{40.78,64.04},{41.37,63.37},{41.37,62.06},{41.42,61.36},{45.84,59.36},{45.21,59.35},{45.79,60.14},},},nil,14,nil,nil,7,"AH",},
[3125] = {'Clattering Scorpid',102,120,5,6,0,{[14]={{56.87,45.7},{57.82,45.95},{57.21,70.82},{54.75,59.36},{50.23,75.36},{54.53,61.06},{55.63,70.11},{57.2,42.66},{57.81,42.94},{59.05,44.7},{56.64,70.92},{52.62,72.47},{54.12,65.1},{58.31,70.84},{53.84,68.09},{52.05,73.61},{50.93,70.61},{58.54,44.58},{51.88,73.46},{57.76,41.49},{56.93,45.33},{50.97,54.22},{59.69,42.03},{58.84,50.51},{59.75,48.06},{52.24,73.67},{55.97,49.09},{57.02,48.33},{59.76,44.36},{58.18,72.05},{54.42,67.01},{49.55,72.9},{54.76,69.98},{54.11,68.97},{58.26,42.26},{57.66,46.8},{55.47,68.0},{50.61,74.91},{54.69,63.57},{54.51,56.65},{49.46,74.67},{52.11,62.82},{54.4,64.87},{50.14,71.89},{54.37,68.96},{59.56,45.92},{59.01,43.23},{56.09,69.64},{51.95,54.74},{57.77,49.45},{53.92,50.75},{57.71,71.34},{56.46,43.17},{57.11,44.18},{50.82,72.5},{50.09,73.47},{54.03,55.23},{53.43,53.54},{53.95,49.03},{56.13,70.53},{53.25,67.03},{55.91,47.53},{53.09,51.81},{55.84,44.23},{54.73,50.13},{53.32,74.44},{54.05,64.11},{54.77,80.27},{55.22,45.38},{52.91,60.6},{53.32,76.44},},},{[14]={{50.97,54.22},{51.36,53.72},{51.79,53.62},{51.7,53.29},{51.41,52.99},{51.36,52.85},{51.32,52.71},{51.26,52.61},{51.21,52.55},{51.12,52.55},{51.0,52.56},{50.71,52.44},{50.48,52.29},{50.31,52.25},{50.09,52.6},{50.13,53.0},{50.2,53.35},{50.42,53.63},{50.49,53.85},{50.37,54.23},{50.32,54.49},{50.65,54.61},{50.8,54.6},{52.09,62.82},{51.94,62.88},{51.84,62.92},{51.62,63.01},{51.39,63.21},{51.25,63.46},{51.1,63.78},{50.98,64.25},{51.14,64.37},{51.28,64.55},{51.44,64.87},{51.57,65.18},{51.64,65.33},{51.73,64.98},{51.72,64.64},{51.74,64.22},{51.98,63.92},{52.19,63.6},{52.36,63.35},{52.49,63.1},{52.33,62.92},{52.18,62.82},{51.95,54.74},{51.85,54.23},{51.65,53.91},{51.18,54.08},{51.0,54.38},{50.88,54.79},{50.89,55.2},{50.86,55.62},{50.82,56.06},{50.79,56.58},{50.97,56.66},{51.21,56.68},{51.38,56.94},{51.61,57.26},{51.75,57.48},{51.9,57.58},{52.08,57.74},{52.18,57.78},{52.26,57.63},{52.31,57.46},{52.3,57.25},{52.29,56.87},{52.11,56.37},{51.74,56.28},{51.79,55.67},{51.89,55.32},{52.01,55.07},{52.91,60.6},{52.87,60.01},{52.83,59.44},{52.81,59.02},{52.78,58.83},{52.56,58.58},{52.26,58.57},{51.95,58.61},{51.76,58.68},{51.67,58.79},{51.6,58.95},{51.6,59.26},{51.64,59.56},{51.58,59.92},{51.59,60.15},{51.64,60.42},{51.72,60.87},{51.91,61.15},{52.27,61.44},{52.43,61.56},{52.57,61.69},{52.67,61.79},{52.78,61.54},{52.9,61.1},},[17]={{71.85,25.39},{72.05,25.13},{72.28,25.08},{72.23,24.9},{72.08,24.75},{72.05,24.67},{72.03,24.6},{72.0,24.55},{71.97,24.52},{71.92,24.52},{71.86,24.52},{71.71,24.46},{71.59,24.38},{71.5,24.36},{71.39,24.54},{71.41,24.75},{71.44,24.94},{71.56,25.08},{71.6,25.2},{71.54,25.4},{71.51,25.53},{71.68,25.59},{71.76,25.59},{72.43,29.88},{72.35,29.91},{72.3,29.93},{72.18,29.98},{72.07,30.08},{71.99,30.21},{71.91,30.38},{71.85,30.62},{71.93,30.69},{72.01,30.78},{72.09,30.94},{72.16,31.11},{72.2,31.19},{72.24,31.0},{72.24,30.83},{72.25,30.61},{72.37,30.45},{72.48,30.28},{72.57,30.15},{72.64,30.02},{72.56,29.93},{72.48,29.88},{72.36,25.66},{72.31,25.4},{72.2,25.23},{71.96,25.32},{71.86,25.47},{71.8,25.69},{71.8,25.9},{71.79,26.12},{71.77,26.35},{71.75,26.62},{71.85,26.66},{71.97,26.67},{72.06,26.81},{72.18,26.97},{72.25,27.09},{72.33,27.14},{72.43,27.22},{72.48,27.25},{72.52,27.17},{72.55,27.08},{72.54,26.97},{72.53,26.77},{72.44,26.51},{72.25,26.46},{72.27,26.14},{72.33,25.96},{72.39,25.83},{72.86,28.72},{72.84,28.41},{72.82,28.11},{72.81,27.9},{72.79,27.8},{72.68,27.66},{72.52,27.66},{72.36,27.68},{72.26,27.72},{72.21,27.78},{72.18,27.86},{72.17,28.02},{72.2,28.18},{72.17,28.36},{72.17,28.48},{72.2,28.63},{72.24,28.86},{72.34,29.01},{72.52,29.16},{72.61,29.22},{72.68,29.29},{72.73,29.34},{72.79,29.21},{72.85,28.98},},},14,nil,nil,413,nil,},
[3126] = {'Armored Scorpid',137,156,7,8,0,{[14]={{43.37,32.43},{35.73,37.91},{55.72,31.68},{41.11,51.69},{36.99,37.25},{48.92,36.82},{37.07,34.4},{41.93,28.75},{44.45,33.61},{43.69,45.5},{56.1,22.8},{42.5,34.41},{38.97,35.72},{41.08,48.38},{52.84,19.35},{46.84,35.53},{54.93,23.07},{38.25,40.76},{37.93,46.49},{56.47,21.36},{38.3,33.89},{57.56,30.9},{50.65,21.56},{44.57,45.72},{48.57,30.56},{49.3,36.65},{56.55,29.04},{36.23,36.86},{47.55,36.87},{41.04,46.56},{51.1,17.81},{55.04,22.07},{57.19,27.37},{47.57,35.62},{54.41,33.83},{40.23,39.44},{36.31,41.19},{41.4,41.42},{57.41,29.52},{57.16,24.58},{45.63,46.74},{35.74,36.87},{37.26,33.85},{58.49,29.18},{42.52,48.65},{58.44,23.26},{50.99,37.7},{40.67,38.82},{41.4,50.69},{37.67,42.46},{54.76,36.64},{45.28,26.55},{50.49,19.5},{44.56,44.54},{43.34,48.1},{39.22,42.14},{42.58,45.86},{45.52,31.35},{45.23,28.21},{58.36,25.17},{40.07,45.27},{39.62,47.8},{48.34,38.62},},},nil,14,nil,nil,413,nil,},
[3127] = {'Venomtail Scorpid',176,198,9,10,0,{[14]={{56.89,14.59},{42.55,21.11},{36.22,28.43},{38.95,17.74},{35.3,53.6},{36.33,47.24},{36.83,27.03},{55.66,14.8},{42.11,18.77},{35.02,50.77},{35.7,47.05},{42.01,16.99},{37.55,50.64},{42.0,20.62},{37.11,30.96},{38.79,22.56},{44.9,20.48},{53.34,11.85},{36.78,55.7},{37.93,49.89},{43.58,18.23},{44.08,16.74},{56.0,18.33},{39.82,18.39},{54.39,11.75},{36.61,25.14},{50.36,17.65},{36.67,50.49},{36.32,52.59},{36.8,53.84},{53.62,12.69},{35.48,33.09},{41.43,20.07},{36.97,48.89},{36.51,30.24},{35.81,49.82},{38.15,20.21},{41.02,16.92},{39.43,22.05},{35.94,56.6},{53.54,15.65},{55.88,15.25},{38.85,17.67},{49.72,17.51},{55.89,12.09},{43.87,18.68},{43.94,18.38},{43.89,16.97},},},nil,14,nil,nil,413,nil,},
[3128] = {'Kul Tiras Sailor',101,122,5,6,0,{[14]={{61.01,58.75},{55.92,59.05},{60.22,59.18},{57.11,53.12},{56.72,52.76},{55.72,57.54},{58.77,60.16},{56.72,53.14},{56.36,56.47},{56.61,52.97},{56.41,58.48},{56.66,54.94},{57.11,57.24},{57.65,58.54},{55.95,53.78},{57.8,58.66},{57.22,54.7},{57.39,56.76},{57.38,58.22},{57.92,57.21},{57.12,51.52},{55.88,51.84},{58.98,52.66},{58.19,56.79},{57.82,52.64},{58.45,53.74},{59.84,58.95},{58.51,57.5},{59.38,58.94},{59.77,58.06},},},nil,14,nil,nil,123,"A",},
[3129] = {'Kul Tiras Marine',125,144,6,7,0,{[14]={{60.21,60.17},{60.75,59.37},{59.54,53.51},{59.93,54.71},{59.45,55.47},{59.5,56.35},{59.59,56.75},{58.11,55.53},{57.51,55.31},{59.09,55.59},{57.79,53.79},{59.69,58.46},{59.42,58.48},{56.53,50.8},{59.57,58.18},{58.44,58.49},{59.79,57.85},{59.2,56.74},{58.95,58.31},{59.34,58.3},},},{[14]={{59.81,57.85},{59.93,57.84},{59.96,57.8},{59.96,57.62},{59.95,57.58},{59.85,57.57},{59.81,57.67},{59.63,57.69},{59.8,57.68},{59.85,57.57},{59.94,57.57},{59.96,57.64},{59.96,57.81},{59.92,57.85},{59.82,57.85},{59.79,57.8},{59.8,57.6},{59.83,57.55},{59.88,57.56},{59.9,57.66},{59.9,57.88},{59.88,57.92},{59.83,57.9},{59.82,57.82},{59.77,57.79},{59.5,57.78},{59.31,57.79},{59.25,57.86},{59.22,57.98},{59.22,58.45},{59.23,57.89},{59.31,57.79},{59.5,57.79},{59.56,57.8},{59.58,57.95},{59.59,58.47},{59.58,57.87},{59.68,57.79},{59.8,57.79},{59.83,57.86},{59.84,57.92},{59.9,57.91},{59.9,57.87},{59.91,57.67},{59.89,57.59},{59.83,57.55},{59.8,57.59},{59.79,57.81},},[17]={{76.46,27.28},{76.52,27.28},{76.54,27.26},{76.54,27.17},{76.53,27.14},{76.48,27.14},{76.46,27.19},{76.37,27.2},{76.45,27.19},{76.48,27.14},{76.53,27.14},{76.54,27.17},{76.54,27.26},{76.52,27.28},{76.46,27.28},{76.45,27.26},{76.45,27.15},{76.47,27.13},{76.5,27.13},{76.51,27.19},{76.51,27.3},{76.49,27.32},{76.47,27.31},{76.47,27.27},{76.44,27.25},{76.3,27.25},{76.2,27.25},{76.17,27.29},{76.15,27.35},{76.15,27.6},{76.15,27.3},{76.2,27.25},{76.3,27.25},{76.33,27.26},{76.34,27.34},{76.34,27.61},{76.34,27.29},{76.39,27.25},{76.46,27.25},{76.47,27.29},{76.48,27.32},{76.5,27.32},{76.51,27.3},{76.51,27.19},{76.5,27.15},{76.47,27.13},{76.45,27.15},{76.45,27.26},},},14,nil,nil,123,"A",},
[3130] = {'Thunder Lizard',179,208,9,10,0,{[14]={{40.46,29.75},{40.65,30.11},{40.5,28.96},{40.2,28.07},{39.24,26.6},{39.15,29.29},{39.63,28.11},{39.1,30.14},{39.1,31.31},{39.1,30.78},{39.21,28.51},},},nil,14,nil,nil,14,nil,},
[3131] = {'Lightning Hide',206,221,10,11,0,{[14]={{41.99,24.39},{42.44,24.43},{40.67,24.47},{43.26,24.41},{42.87,23.73},{43.63,24.14},{41.39,24.34},{40.17,24.19},{38.88,25.27},{39.52,23.54},{39.36,24.9},},},nil,14,nil,nil,14,nil,},
[3133] = {'Herble Baubbletump',1605,1605,30,30,0,{[10]={{77.99,48.33},},},nil,10,nil,nil,875,"A",},
[3134] = {'Kzixx',1240,1240,25,25,0,{[10]={{81.82,19.77},},},nil,10,nil,nil,120,"AH",},
[3135] = {'Malissa',1172,1172,24,24,0,{[10]={{79.47,44.38},},},nil,10,nil,nil,12,"A",},
[3136] = {'Clarise Gnarltree',1684,1684,31,31,0,{[10]={{74.0,48.55},},},nil,10,nil,nil,12,"A",},
[3137] = {'Matt Johnson',919,919,20,20,0,{[10]={{74.07,49.64},},},nil,10,nil,nil,12,"A",},
[3138] = {'Scott Carevin',1240,1240,25,25,0,{[10]={{75.83,48.7},},},nil,10,nil,nil,12,"A",},
[3139] = {'Gar\'Thok',413,413,10,10,0,{[14]={{51.95,43.5},},},nil,14,{784,825,831,837,},{784,825,830,837,},29,"H",},
[3140] = {'Lar Prowltusk',228,228,7,7,0,{[14]={{54.24,73.28},},},{[14]={{54.45,74.33},{54.6,74.66},{54.5,74.96},{54.59,74.58},{54.45,74.33},{54.22,73.31},},[17]={{73.66,35.88},{73.74,36.06},{73.69,36.21},{73.74,36.01},{73.66,35.88},{73.54,35.35},},},14,{786,},{786,},126,"H",},
[3141] = {'Makrura Elder',156,156,8,8,0,{[14]={{59.02,13.03},{59.8,16.14},{61.08,23.37},{60.98,38.66},},},nil,14,nil,nil,129,nil,},
[3142] = {'Orgnil Soulscar',804,804,18,18,0,{[14]={{52.24,43.15},},},nil,14,{806,828,},{806,823,},29,"H",},
[3143] = {'Gornek',166,166,5,5,0,{[14]={{42.06,68.33},},},nil,14,{788,789,2383,3065,3082,3083,3084,3085,3086,3087,3088,3089,3090,},{787,788,789,804,4641,},29,"H",},
[3144] = {'Eitrigg',919,919,20,20,0,{[1637]={{34.28,39.35},},},nil,1637,{787,},nil,29,"H",},
[3145] = {'Zureetha Fargaze',500,500,12,12,0,{[14]={{42.85,69.15},},},nil,14,{792,794,805,},{792,794,1499,},29,"H",},
[3147] = {'Furl Scornbrow',196,196,6,6,0,{[14]={{49.88,40.39},},},nil,14,{791,},{791,},29,"H",},
[3149] = {'Nez\'raz',4440,4440,45,45,0,{[33]={{31.43,29.91},},},nil,33,nil,nil,29,"H",},
[3150] = {'Hin Denburg',5736,5736,45,45,0,{[85]={{61.78,59.18},},},nil,85,nil,nil,29,"H",},
[3151] = {'Captain Obvious',57,57,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[3152] = {'Cap\'n Copyright',48,48,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[3153] = {'Frang',456,456,11,11,0,{[14]={{42.89,69.44},},},nil,14,nil,{2383,3065,},29,"H",},
[3154] = {'Jen\'shan',334,334,8,8,0,{[14]={{42.84,69.33},},},nil,14,{6068,},{3082,3087,},126,"H",},
[3155] = {'Rwag',334,334,8,8,0,{[14]={{41.28,68.0},},},nil,14,nil,{3083,3088,},29,"H",},
[3156] = {'Nartok',372,372,9,9,0,{[14]={{40.65,68.52},},},nil,14,nil,{3090,},29,"H",},
[3157] = {'Shikrik',413,413,10,10,0,{[14]={{42.39,69.0},},},nil,14,nil,{3084,3089,},29,"H",},
[3158] = {'Duokna',413,413,10,10,0,{[14]={{42.59,67.34},},},nil,14,nil,nil,29,"H",},
[3159] = {'Kzan Thornslash',1930,1930,34,34,0,{[14]={{40.47,68.0},},},nil,14,nil,nil,29,"H",},
[3160] = {'Huklah',456,456,11,11,0,{[14]={{40.61,67.8},},},nil,14,nil,nil,29,"H",},
[3161] = {'Rarc',413,413,10,10,0,{[14]={{40.48,67.82},},},nil,14,nil,nil,29,"H",},
[3162] = {'Burdrak Harglhelm',500,500,12,12,0,{[1]={{30.11,45.28},},},nil,1,nil,nil,55,"A",},
[3163] = {'Uhgar',644,644,15,15,0,{[14]={{52.02,40.45},},},nil,14,nil,nil,29,"H",},
[3164] = {'Jark',594,594,14,14,0,{[14]={{54.39,42.18},},},nil,14,nil,nil,29,"H",},
[3165] = {'Ghrawt',546,546,13,13,0,{[14]={{52.98,41.03},},},nil,14,nil,nil,29,"H",},
[3166] = {'Cutac',594,594,14,14,0,{[14]={{53.11,40.86},},},nil,14,nil,nil,29,"H",},
[3167] = {'Wuark',594,594,14,14,0,{[14]={{51.9,41.14},},},nil,14,nil,nil,29,"H",},
[3168] = {'Flakk',644,644,15,15,0,{[14]={{52.98,41.97},},},nil,14,nil,nil,29,"H",},
[3169] = {'Tarshaw Jaggedscar',2766,2766,43,43,0,{[14]={{54.19,42.47},},},nil,14,{1505,},nil,29,"H",},
[3170] = {'Kaplak',594,594,14,14,0,{[14]={{51.98,43.69},},},nil,14,{1859,2380,},nil,29,"H",},
[3171] = {'Thotar',695,695,16,16,0,{[14]={{51.85,43.49},},},nil,14,{6062,6067,6081,6082,6083,},{6062,6068,6069,6070,6082,6083,},29,"H",},
[3172] = {'Dhugru Gorelust',2192,2192,37,37,0,{[14]={{54.38,41.2},},},nil,14,nil,nil,29,"H",},
[3173] = {'Swart',644,644,15,15,0,{[14]={{54.42,42.59},},},nil,14,{2983,2985,},nil,29,"H",},
[3174] = {'Dwukk',1380,1380,27,27,0,{[14]={{52.03,40.72},},},nil,14,nil,nil,29,"H",},
[3175] = {'Krunn',695,695,16,16,0,{[14]={{51.81,40.88},},},nil,14,nil,nil,29,"H",},
[3177] = {'Turuk Amberstill',413,413,10,10,0,{[1]={{62.9,49.89},},},nil,1,nil,nil,55,"A",},
[3178] = {'Stuart Fleming',1240,1240,25,25,0,{[11]={{8.01,58.33},},},nil,11,nil,nil,12,"A",},
[3179] = {'Harold Riggs',1240,1240,25,25,0,{[11]={{8.08,58.59},},},nil,11,nil,nil,12,"A",},
[3180] = {'Dark Iron Entrepreneur',1684,1684,31,31,0,{[11]={{46.55,18.37},},},nil,11,nil,nil,35,"AH",},
[3181] = {'Fremal Doohickey',1605,1605,30,30,0,{[11]={{10.82,61.4},},},nil,11,nil,nil,875,"A",},
[3182] = {'Junder Brokk',919,919,20,20,0,{[11]={{10.83,60.23},},},nil,11,nil,nil,55,"A",},
[3183] = {'Yarrog Baneshadow',98,98,5,5,0,{[14]={{42.71,52.95},},},nil,14,nil,nil,16,nil,},
[3184] = {'Miao\'zan',1240,1240,25,25,0,{[14]={{55.41,73.95},},},nil,14,nil,nil,126,"H",},
[3185] = {'Mishiki',594,594,14,14,0,{[14]={{55.44,75.08},},},nil,14,nil,nil,126,"H",},
[3186] = {'K\'waii',456,456,11,11,0,{[14]={{56.29,73.4},},},nil,14,nil,nil,126,"H",},
[3187] = {'Tai\'tasi',500,500,12,12,0,{[14]={{56.41,73.79},},},nil,14,nil,nil,126,"H",},
[3188] = {'Master Gadrin',500,500,12,12,0,{[14]={{55.95,74.72},},},nil,14,{808,823,826,2936,2937,},{805,808,826,2935,2936,},126,"H",},
[3189] = {'Kor\'ghan',228,228,7,7,0,{[1637]={{47.24,53.58},},},nil,1637,{813,},{813,},126,"H",},
[3190] = {'Rhinag',334,334,8,8,0,{[14]={{41.54,18.6},},},nil,14,{812,},{812,},126,"H",},
[3191] = {'Cook Torka',196,196,6,6,0,{[14]={{51.11,42.45},},},{[14]={{51.11,42.45},{51.08,42.51},{51.06,42.44},},[17]={{71.92,19.25},{71.91,19.28},{71.9,19.24},},},14,{815,},{815,},29,"H",},
[3192] = {'Lieutenant Benedict',156,156,8,8,0,{[14]={{59.72,58.27},},},nil,14,nil,nil,123,"A",},
[3193] = {'Misha Tor\'kren',166,166,5,5,0,{[14]={{43.1,30.24},},},nil,14,{816,},{816,},29,"H",},
[3194] = {'Vel\'rin Fang',228,228,7,7,0,{[14]={{55.96,73.93},},},nil,14,{817,},{817,},126,"H",},
[3195] = {'Burning Blade Thug',156,176,8,9,0,{[14]={{53.15,29.14},{52.85,29.28},{52.67,27.93},{53.4,26.93},{53.04,27.81},{52.5,29.19},},},nil,14,nil,nil,554,nil,},
[3196] = {'Burning Blade Neophyte',166,186,9,10,0,{[14]={{51.92,25.09},{52.78,28.48},{52.82,26.84},{51.88,26.31},{53.12,27.24},{52.07,26.87},},},nil,14,nil,nil,554,nil,},
[3197] = {'Burning Blade Fanatic',166,186,9,10,0,{[14]={{51.61,10.15},{53.39,10.54},{52.5,10.17},{53.74,9.92},{53.28,9.22},{52.45,8.61},{42.01,26.57},{42.29,26.9},{42.25,26.31},{42.32,27.29},{55.01,9.79},{52.08,8.23},{54.32,8.87},{53.78,8.87},{51.46,9.18},{51.87,10.85},{52.47,9.23},{54.71,9.36},{52.7,11.04},{53.35,8.19},{51.38,8.67},{52.95,8.95},{52.71,7.92},},},{[14]={{42.32,27.29},{42.43,27.33},{42.51,27.2},{42.54,27.0},{42.54,26.79},{42.46,26.66},{42.29,26.52},{42.11,26.37},{41.98,26.32},{41.81,26.42},{41.7,26.55},{41.61,26.72},{41.57,26.96},{41.6,27.17},{41.75,27.23},{41.92,27.17},{42.06,27.17},{42.19,27.25},},[17]={{67.33,11.34},{67.39,11.36},{67.43,11.29},{67.45,11.19},{67.45,11.08},{67.41,11.01},{67.32,10.94},{67.23,10.86},{67.16,10.83},{67.07,10.89},{67.01,10.95},{66.96,11.04},{66.94,11.17},{66.96,11.28},{67.03,11.31},{67.13,11.28},{67.2,11.28},{67.27,11.32},},},14,nil,nil,554,nil,},
[3198] = {'Burning Blade Apprentice',178,199,10,11,0,{[14]={{54.71,8.77},{53.08,9.4},{53.36,7.74},{52.3,11.01},{41.89,26.85},{42.88,26.43},{53.12,11.06},{53.82,9.4},{51.62,8.1},{52.09,9.84},{53.55,8.55},{51.62,10.56},{53.25,10.02},{52.9,7.6},{52.6,8.22},},},nil,14,nil,nil,554,nil,},
[3199] = {'Burning Blade Cultist',178,199,10,11,0,{[14]={{52.67,25.36},{52.23,24.54},{52.14,24.93},{52.63,24.98},{52.41,26.8},{52.64,26.39},{51.89,25.71},},},nil,14,nil,nil,554,nil,},
[3203] = {'Fizzle Darkstorm',219,219,12,12,0,{[14]={{42.12,26.66},},},{[14]={{42.12,26.66},{42.31,26.63},{42.45,26.56},{42.53,26.52},{42.61,26.48},{42.52,26.54},{42.44,26.57},{42.26,26.63},},[17]={{67.23,11.01},{67.33,10.99},{67.4,10.96},{67.44,10.94},{67.48,10.92},{67.44,10.95},{67.4,10.97},{67.3,10.99},},},14,nil,nil,554,nil,},
[3204] = {'Gazz\'uz',342,342,14,14,0,{[14]={{51.87,9.62},},},nil,14,nil,nil,14,nil,},
[3205] = {'Zalazane',186,186,10,10,0,{[14]={{67.55,87.81},},},{[14]={{67.56,87.75},{67.54,87.59},{67.56,87.15},{67.4,87.03},{67.13,87.03},{67.15,86.88},{67.29,86.72},{67.42,86.61},{67.59,86.29},{67.75,86.15},{67.72,86.34},{67.4,86.69},{67.36,87.02},{67.54,87.21},{67.54,87.56},},[17]={{80.5,42.88},{80.5,42.8},{80.5,42.57},{80.42,42.51},{80.28,42.51},{80.29,42.43},{80.36,42.35},{80.43,42.29},{80.52,42.12},{80.6,42.05},{80.59,42.15},{80.42,42.33},{80.4,42.5},{80.49,42.6},{80.49,42.79},},},14,nil,nil,16,nil,},
[3206] = {'Voodoo Troll',148,166,8,9,0,{[14]={{68.58,84.36},{67.07,87.76},{67.16,86.59},{67.56,86.86},{67.22,87.34},{68.52,83.53},{65.92,82.8},{67.4,82.58},{68.4,82.36},{67.82,82.06},{65.92,86.7},{66.88,87.18},{67.07,86.82},},},nil,14,nil,nil,16,nil,},
[3207] = {'Hexed Troll',150,164,8,9,0,{[14]={{67.75,83.49},{67.7,83.67},{68.29,83.23},{68.16,83.77},{68.11,83.53},{67.29,88.68},{68.46,86.79},{67.9,85.92},{67.13,85.94},{67.14,84.99},{65.89,84.01},{68.75,83.59},{66.53,86.73},{66.55,87.82},{66.63,83.04},},},{[14]={{68.75,83.59},{68.64,83.89},{68.5,84.02},{68.29,84.26},{68.16,84.33},{67.96,84.15},{67.85,84.03},{67.69,83.85},{67.63,83.77},{67.49,83.56},{67.41,83.36},{67.42,83.2},{67.57,82.95},{67.74,82.7},{67.87,82.47},{68.04,82.46},{68.19,82.6},{68.38,82.79},{68.54,82.99},{68.71,83.29},},[17]={{81.13,40.72},{81.07,40.87},{81.0,40.94},{80.89,41.06},{80.82,41.1},{80.71,41.0},{80.66,40.94},{80.57,40.85},{80.54,40.81},{80.47,40.7},{80.42,40.59},{80.43,40.51},{80.51,40.38},{80.6,40.25},{80.67,40.13},{80.75,40.13},{80.83,40.2},{80.93,40.29},{81.02,40.4},{81.1,40.56},},},14,nil,nil,16,nil,},
[3208] = {'Margoz',804,804,18,18,0,{[14]={{56.41,20.04},},},nil,14,{827,829,},{827,828,},29,"H",},
[3209] = {'Brave Windfeather',546,546,13,13,0,{[215]={{44.53,76.5},},},{[17]={{28.27,66.71},{28.18,66.58},{28.26,66.71},{28.26,66.81},{28.3,66.99},{28.24,67.02},{28.29,66.96},{28.27,66.84},{28.27,66.72},{28.19,66.6},{28.27,66.71},{28.35,66.7},{28.46,66.69},{28.5,66.57},{28.54,66.66},{28.57,66.68},{28.55,66.73},{28.51,66.82},{28.47,66.93},{28.43,67.06},{28.42,67.2},{28.3,67.35},{28.41,67.18},{28.4,67.08},{28.46,66.97},{28.48,66.87},{28.53,66.76},{28.59,66.69},{28.52,66.66},{28.51,66.54},{28.46,66.65},{28.42,66.69},{28.27,66.71},{28.19,66.61},{28.27,66.73},{28.31,66.94},{28.24,67.03},{28.3,66.94},},[215]={{44.57,76.55},{44.4,76.29},{44.55,76.54},{44.55,76.74},{44.62,77.09},{44.51,77.17},{44.62,77.04},{44.56,76.8},{44.58,76.57},{44.42,76.33},{44.57,76.55},{44.72,76.53},{44.94,76.51},{45.02,76.28},{45.1,76.45},{45.17,76.48},{45.12,76.59},{45.04,76.76},{44.97,76.97},{44.89,77.23},{44.86,77.51},{44.63,77.81},{44.85,77.48},{44.82,77.27},{44.95,77.05},{44.98,76.86},{45.08,76.64},{45.19,76.5},{45.07,76.44},{45.05,76.22},{44.95,76.43},{44.87,76.5},{44.56,76.54},{44.42,76.36},{44.56,76.59},{44.64,77.01},{44.51,77.17},{44.62,77.01},},[357]={{81.78,11.4},{81.65,11.21},{81.77,11.39},{81.76,11.54},{81.81,11.8},{81.74,11.85},{81.81,11.76},{81.77,11.58},{81.78,11.41},{81.66,11.24},{81.78,11.4},{81.89,11.38},{82.05,11.37},{82.11,11.2},{82.17,11.32},{82.22,11.35},{82.18,11.43},{82.12,11.55},{82.07,11.71},{82.01,11.9},{81.99,12.11},{81.82,12.33},{81.98,12.09},{81.97,11.93},{82.06,11.77},{82.08,11.63},{82.15,11.47},{82.24,11.36},{82.14,11.32},{82.13,11.15},{82.06,11.31},{82.0,11.36},{81.77,11.39},{81.66,11.25},{81.77,11.43},{81.83,11.73},{81.73,11.86},{81.82,11.74},},},215,{3376,},{3376,},105,"H",},
[3210] = {'Brave Proudsnout',5227,5227,55,55,0,{[215]={{45.47,78.27},},},nil,215,nil,nil,105,"H",},
[3211] = {'Brave Lightninghorn',4567,4567,55,55,0,{[215]={{46.0,77.17},},},nil,215,nil,nil,105,"H",},
[3212] = {'Brave Ironhorn',594,594,14,14,0,{[215]={{46.84,59.31},},},{[17]={{29.46,57.96},{29.53,57.78},{29.52,57.58},{29.51,57.37},{29.5,57.03},{29.52,57.16},{29.53,57.37},{29.53,57.79},{29.48,57.92},{29.42,57.96},{29.42,57.96},{29.2,57.7},{29.07,57.56},{29.07,57.56},{29.3,57.8},},[215]={{46.91,59.28},{47.05,58.94},{47.03,58.53},{47.02,58.12},{47.0,57.45},{47.03,57.7},{47.05,58.11},{47.06,58.96},{46.96,59.2},{46.84,59.28},{46.84,59.28},{46.41,58.78},{46.14,58.49},{46.14,58.49},{46.59,58.96},},},215,nil,nil,105,"H",},
[3213] = {'Brave Running Wolf',3866,3866,55,55,0,{[215]={{43.48,77.0},},},nil,215,nil,nil,105,"H",},
[3214] = {'Brave Greathoof',3866,3866,55,55,0,{[215]={{44.19,78.86},},},nil,215,nil,nil,105,"H",},
[3215] = {'Brave Strongbash',594,594,14,14,0,{[215]={{48.52,56.85},},},nil,215,nil,nil,105,"H",},
[3216] = {'Neeru Fireblade',2192,2192,37,37,0,{[1637]={{49.47,50.59},},},nil,1637,{809,3122,5730,5761,},{829,832,3121,5729,5761,},29,"H",},
[3217] = {'Brave Dawneagle',546,546,13,13,0,{[215]={{50.78,60.89},},},nil,215,nil,nil,105,"H",},
[3218] = {'Brave Swiftwind',546,546,13,13,0,{[215]={{49.66,57.13},},},nil,215,nil,nil,105,"H",},
[3219] = {'Brave Leaping Deer',546,546,13,13,0,{[215]={{51.09,58.59},},},nil,215,nil,nil,105,"H",},
[3220] = {'Brave Darksky',500,500,12,12,0,{[215]={{48.03,54.84},},},{[17]={{30.06,55.73},{30.13,55.6},{30.19,55.48},{30.28,55.29},{30.2,55.16},{30.08,55.02},{30.07,55.0},{30.03,54.96},{30.02,54.94},{30.02,54.94},{29.8,54.69},{29.68,54.57},{29.57,54.45},{29.41,54.26},{29.41,54.26},{29.52,54.39},{29.74,54.63},{29.85,54.75},{30.03,54.94},{30.03,54.95},{30.07,54.99},{30.08,55.0},{30.19,55.14},{30.19,55.14},{30.37,55.38},{30.3,55.49},{30.23,55.6},{30.13,55.73},{30.0,55.77},},[215]={{48.11,54.89},{48.24,54.64},{48.36,54.4},{48.53,54.02},{48.37,53.77},{48.15,53.49},{48.11,53.45},{48.05,53.37},{48.01,53.33},{48.01,53.33},{47.58,52.84},{47.36,52.6},{47.14,52.36},{46.81,51.99},{46.81,51.99},{47.03,52.23},{47.46,52.72},{47.68,52.96},{48.03,53.34},{48.05,53.35},{48.12,53.42},{48.15,53.45},{48.36,53.73},{48.36,53.73},{48.7,54.2},{48.57,54.42},{48.44,54.63},{48.23,54.88},{47.98,54.97},},},215,nil,nil,105,"H",},
[3221] = {'Brave Rockhorn',500,500,12,12,0,{[215]={{50.6,63.28},},},nil,215,nil,nil,105,"H",},
[3222] = {'Brave Wildrunner',594,594,14,14,0,{[215]={{47.52,60.69},},},{[17]={{29.76,58.68},{29.75,58.77},{29.73,58.87},{29.72,58.96},{29.75,59.09},{29.72,58.96},{29.72,58.87},{29.77,58.7},{29.75,58.62},{29.69,58.57},{29.56,58.39},{29.54,58.24},{29.56,58.08},{29.56,57.87},{29.56,57.66},{29.57,57.43},{29.65,57.28},{29.79,57.3},{29.91,57.39},{29.93,57.57},{29.94,57.7},{29.92,57.81},{29.85,58.0},{29.8,58.14},{29.85,58.31},{29.88,58.45},{29.85,58.58},{29.78,58.61},},[215]={{47.52,60.7},{47.48,60.89},{47.44,61.08},{47.43,61.26},{47.49,61.51},{47.43,61.26},{47.43,61.07},{47.52,60.74},{47.48,60.59},{47.37,60.49},{47.1,60.13},{47.07,59.84},{47.1,59.52},{47.12,59.1},{47.11,58.69},{47.14,58.23},{47.29,57.94},{47.57,57.98},{47.81,58.15},{47.85,58.52},{47.86,58.78},{47.82,59.0},{47.69,59.37},{47.58,59.63},{47.68,59.98},{47.75,60.26},{47.69,60.5},{47.54,60.56},},[357]={{83.89,0.1},{83.93,0.28},{83.89,0.09},},},215,nil,nil,105,"H",},
[3223] = {'Brave Rainchaser',500,500,12,12,0,{[215]={{47.97,63.56},},},nil,215,nil,nil,105,"H",},
[3224] = {'Brave Cloudmane',594,594,14,14,0,{[215]={{45.62,57.98},},},{[17]={{28.84,57.32},{28.87,57.34},{28.9,57.32},{28.97,57.28},{28.96,57.39},{29.0,57.51},{28.93,57.48},{28.85,57.53},{28.86,57.48},{28.87,57.43},{28.85,57.37},{28.81,57.31},},[215]={{45.69,58.02},{45.76,58.05},{45.82,58.03},{45.95,57.95},{45.94,58.17},{46.01,58.39},{45.87,58.33},{45.72,58.45},{45.73,58.34},{45.75,58.23},{45.71,58.12},{45.63,58.0},},},215,nil,nil,105,"H",},
[3225] = {'Corrupted Mottled Boar',198,222,10,11,0,{[14]={{36.87,40.07},{43.68,15.47},},},nil,14,nil,nil,14,nil,},
[3226] = {'Corrupted Scorpid',198,222,10,11,0,{[14]={{36.56,29.27},{36.4,48.41},{51.38,14.12},},},nil,14,nil,nil,413,nil,},
[3227] = {'Corrupted Bloodtalon Scythemaw',198,222,10,11,0,{[14]={{37.61,56.12},{43.73,31.67},{39.77,19.87},{38.84,18.55},{44.04,17.61},},},nil,14,nil,nil,48,nil,},
[3228] = {'Corrupted Surf Crawler',198,222,10,11,0,{[14]={{56.88,10.69},{60.36,21.78},},},nil,14,nil,nil,14,nil,},
[3229] = {'"Squealer" Thornmantle',116,116,5,5,0,{[215]={{63.28,82.58},},},nil,215,nil,nil,14,nil,},
[3230] = {'Nazgrel',4079,4079,62,62,0,{[1637]={{32.3,35.75},},},nil,1637,nil,{831,},1074,"H",},
[3231] = {'Corrupted Dreadmaw Crocolisk',222,247,11,12,0,{[14]={{34.26,52.7},},[17]={{63.26,10.63},},},nil,14,nil,nil,14,nil,},
[3232] = {'Bristleback Interloper',176,198,9,10,0,{[215]={{60.41,21.96},{62.12,20.56},{60.84,22.41},{60.82,21.09},{61.03,21.28},{62.35,20.96},{62.22,21.54},{60.18,21.63},{60.44,19.5},{61.68,19.45},{61.85,20.16},{62.04,22.51},{62.22,22.13},{60.81,20.02},{60.12,20.9},{60.13,20.02},{60.94,19.54},{60.41,20.38},{61.0,20.83},{61.34,20.49},{61.47,22.85},{61.33,21.85},{61.83,22.58},{61.16,22.82},{61.63,21.63},{61.34,20.82},{61.71,21.34},{61.79,22.03},},},{[17]={{36.3,38.19},{36.37,38.13},{36.44,38.07},{36.56,38.0},{36.59,38.1},{36.63,38.22},{36.61,38.16},{36.54,38.02},{36.47,37.99},{36.38,38.05},{36.29,38.17},{36.21,38.3},{36.13,38.4},{36.07,38.53},{36.03,38.68},{36.05,38.55},{36.06,38.36},{36.06,38.2},{36.17,38.21},{36.17,38.21},},[215]={{60.41,20.28},{60.54,20.16},{60.68,20.04},{60.92,19.92},{60.98,20.1},{61.05,20.35},{61.02,20.23},{60.88,19.95},{60.74,19.9},{60.57,20.02},{60.4,20.26},{60.22,20.5},{60.08,20.7},{59.95,20.95},{59.87,21.25},{59.91,20.99},{59.92,20.62},{59.94,20.3},{60.15,20.32},{60.15,20.32},},},215,nil,nil,111,nil,},
[3233] = {'Lorekeeper Raintotem',334,334,8,8,0,{[215]={{59.86,25.62},},},nil,215,{833,},{833,},104,"H",},
[3234] = {'Lost Barrens Kodo',299,325,14,15,0,{[17]={{40.14,24.25},{42.39,37.69},{45.77,43.34},{57.08,15.85},{54.06,41.46},{54.64,10.53},{41.16,25.55},{41.53,21.45},{42.11,30.11},{42.1,20.67},{43.84,19.69},{52.71,13.27},{53.59,12.0},{57.11,17.72},{54.82,40.13},{53.5,45.82},{55.26,45.83},{54.41,44.72},{43.72,41.81},{47.21,43.3},{52.65,43.44},{60.12,41.31},{56.17,40.12},{44.78,40.79},{51.45,42.94},{51.95,44.72},{61.65,41.66},},},nil,17,nil,nil,15,"AH",},
[3235] = {'Greater Barrens Kodo',659,752,24,25,0,{[17]={{47.21,66.47},},},nil,17,nil,nil,15,"AH",},
[3236] = {'Barrens Kodo',447,484,19,20,0,{[17]={{45.8,67.81},{45.72,68.05},{45.79,67.97},{45.8,68.12},{46.91,67.13},{47.14,66.58},},},nil,17,nil,nil,15,"AH",},
[3237] = {'Wooly Kodo',786,787,25,26,0,{[17]={{47.1,66.66},},},{[15]={{22.38,24.51},{22.12,24.87},{21.67,25.38},{20.88,25.56},{20.49,25.59},{20.3,25.53},{20.18,25.44},{20.04,25.21},{19.93,24.92},{19.85,24.65},{19.73,24.24},{19.69,23.98},{19.71,23.63},{19.67,23.35},{19.56,22.99},{19.02,21.85},{18.68,21.21},{18.66,21.05},{18.67,20.12},{18.76,19.36},{19.03,18.13},{19.2,17.59},{19.31,17.34},{19.62,16.57},{20.31,14.89},{20.75,14.06},{20.96,13.91},{21.27,13.86},{21.79,13.94},{22.06,14.0},{22.53,14.02},{23.13,13.73},{23.38,13.67},{23.49,13.65},{23.73,13.7},{24.02,13.82},{24.38,14.09},{24.63,14.26},{24.81,14.53},{25.03,15.18},{25.22,16.14},{25.13,16.86},{24.9,17.69},{24.45,19.27},{24.35,19.41},{24.27,19.62},{24.24,19.7},{24.17,19.83},{23.87,20.27},{23.45,20.56},{23.03,21.51},{22.88,22.66},{22.84,22.85},{22.81,23.05},{22.76,23.34},{22.62,24.04},},[17]={{47.1,66.66},{46.97,66.85},{46.73,67.11},{46.32,67.2},{46.12,67.22},{46.03,67.19},{45.96,67.14},{45.89,67.02},{45.83,66.87},{45.79,66.73},{45.73,66.52},{45.71,66.39},{45.72,66.2},{45.69,66.06},{45.64,65.87},{45.36,65.28},{45.18,64.95},{45.17,64.87},{45.18,64.38},{45.22,63.99},{45.36,63.36},{45.45,63.08},{45.51,62.94},{45.67,62.55},{46.03,61.68},{46.26,61.25},{46.37,61.17},{46.53,61.14},{46.8,61.18},{46.93,61.22},{47.18,61.22},{47.49,61.07},{47.62,61.04},{47.67,61.04},{47.8,61.06},{47.95,61.12},{48.14,61.26},{48.27,61.35},{48.36,61.49},{48.47,61.83},{48.57,62.32},{48.53,62.7},{48.4,63.13},{48.17,63.94},{48.12,64.02},{48.08,64.12},{48.06,64.17},{48.03,64.24},{47.87,64.46},{47.66,64.61},{47.44,65.11},{47.36,65.7},{47.34,65.8},{47.32,65.9},{47.3,66.05},{47.23,66.41},},[215]={{81.71,76.44},{81.45,76.82},{80.99,77.34},{80.18,77.52},{79.78,77.55},{79.59,77.49},{79.46,77.39},{79.32,77.16},{79.21,76.87},{79.12,76.59},{79.0,76.17},{78.96,75.91},{78.98,75.54},{78.94,75.26},{78.82,74.89},{78.28,73.73},{77.93,73.07},{77.91,72.91},{77.92,71.96},{78.01,71.18},{78.28,69.93},{78.46,69.38},{78.57,69.12},{78.89,68.33},{79.6,66.62},{80.05,65.77},{80.26,65.61},{80.58,65.57},{81.11,65.64},{81.38,65.71},{81.86,65.72},{82.47,65.43},{82.73,65.37},{82.84,65.35},{83.09,65.4},{83.39,65.52},{83.76,65.8},{84.01,65.97},{84.19,66.24},{84.41,66.91},{84.61,67.9},{84.52,68.63},{84.28,69.48},{83.82,71.09},{83.73,71.24},{83.64,71.45},{83.61,71.53},{83.54,71.67},{83.24,72.11},{82.81,72.41},{82.38,73.38},{82.22,74.56},{82.18,74.75},{82.15,74.95},{82.1,75.25},{81.96,75.96},},},17,nil,nil,15,"AH",},
[3238] = {'Stormhide',573,617,22,23,0,{[17]={{44.06,75.84},{48.95,74.93},{44.83,73.96},{47.96,73.86},{48.55,73.71},{43.8,73.88},{44.49,74.19},{48.41,74.62},{49.17,76.21},{50.11,80.39},{43.63,75.77},{48.44,75.43},{50.39,76.96},{50.37,76.11},{46.79,72.5},{46.8,72.98},{48.95,76.99},{48.68,76.47},{44.7,75.64},{45.46,74.89},{44.17,76.49},{44.48,78.55},{44.74,76.93},{43.19,78.39},{44.6,79.24},{45.16,76.76},{49.37,79.32},{49.55,80.1},{48.41,75.95},{48.06,76.4},{47.42,75.36},{46.83,74.46},{47.11,74.74},{47.83,75.91},{46.53,79.79},{47.98,81.34},{46.85,77.46},{46.45,79.15},{46.26,77.23},{47.14,82.32},{47.76,80.42},{49.08,78.57},},},nil,17,nil,nil,14,nil,},
[3239] = {'Thunderhead',510,544,20,21,0,{[17]={{46.05,66.59},{43.04,60.5},{45.37,67.82},{47.13,65.15},{46.67,68.52},{50.15,59.77},{47.44,66.66},{42.78,61.14},{50.35,60.26},{42.54,60.21},{47.81,64.12},{50.0,61.1},{49.53,59.51},{48.45,61.02},{43.82,62.26},{43.53,62.17},{48.21,64.06},{47.07,63.04},{48.44,62.42},{47.98,63.19},{48.94,61.24},{49.36,62.58},{48.78,60.54},{46.17,63.87},{48.48,59.48},{45.74,63.56},{43.81,60.64},{44.14,61.21},{49.07,61.74},{46.46,63.59},{49.28,61.98},{48.28,59.9},{48.95,59.0},{46.45,61.88},{48.95,59.71},{48.54,57.88},{48.13,60.85},{48.08,58.43},{46.53,69.05},{45.43,63.2},{47.49,60.86},{45.81,66.39},{44.39,63.97},{45.2,66.64},{45.67,67.01},{45.79,69.01},{47.05,62.03},{48.1,57.75},{45.23,64.94},{47.09,67.0},{44.46,63.13},},},nil,17,nil,nil,16,nil,},
[3240] = {'Stormsnout',417,449,18,19,0,{[17]={{48.92,51.37},{48.71,55.64},{46.95,51.1},{42.89,46.9},{46.81,47.83},{52.83,56.64},{47.09,48.26},{44.52,46.8},{52.35,56.52},{42.19,45.77},{52.31,57.12},{49.42,53.65},{48.77,55.2},{47.5,49.16},{46.44,48.48},{47.36,46.76},{42.15,48.75},{47.72,51.79},{44.69,49.36},{52.34,54.18},{52.58,55.22},{49.07,56.21},{45.12,48.19},{48.87,51.72},{48.79,56.72},{46.15,44.78},{50.51,52.81},{53.08,55.11},{43.65,44.39},{49.59,54.36},{43.72,46.49},{44.49,47.51},{50.02,53.4},{45.17,45.34},{48.86,50.77},{43.46,49.25},{50.99,52.98},{42.61,46.33},{45.28,47.88},{45.37,45.73},{43.17,46.33},{49.72,55.95},{42.21,57.71},{45.74,47.75},{47.27,47.08},{46.44,46.34},{46.14,49.84},{42.24,57.52},{50.13,52.71},{44.52,47.85},{52.76,55.76},{50.09,54.32},{44.48,44.93},{50.12,59.11},{45.32,56.28},{45.78,57.08},{45.51,55.7},{44.74,47.8},{46.77,55.84},{49.75,58.12},{43.49,49.8},{46.43,50.81},{44.17,53.37},{46.29,56.11},{45.45,52.25},{47.32,50.26},{48.08,56.61},{49.75,59.16},{48.3,56.96},{46.75,56.25},},},{[15]={{32.54,0.43},{32.32,0.21},{32.09,0.01},{31.0,0.17},{31.06,0.62},{31.37,1.04},{31.6,1.24},{32.11,1.59},{32.39,1.62},{32.54,1.61},{32.98,1.49},{33.2,1.26},{33.29,0.89},{33.07,0.46},{32.76,0.46},},[17]={{52.37,54.19},{52.25,54.07},{52.13,53.97},{51.89,53.79},{51.76,53.74},{51.61,53.75},{51.56,54.05},{51.6,54.29},{51.76,54.5},{51.88,54.6},{52.14,54.78},{52.29,54.8},{52.36,54.8},{52.59,54.73},{52.7,54.62},{52.76,54.42},{52.64,54.2},{52.48,54.2},{47.27,47.08},{47.15,46.84},{47.03,46.73},{46.91,46.63},{46.81,46.57},{46.6,46.54},{46.48,46.38},{46.52,46.18},{46.66,46.18},{46.76,46.31},{46.97,46.58},{47.17,46.87},{47.26,47.03},{47.45,47.33},{47.61,47.57},{47.7,47.67},{47.89,47.84},{47.99,48.09},{47.88,48.26},{47.82,48.22},{47.75,48.05},{47.69,47.81},{47.51,47.55},{47.44,47.4},},[215]={{92.09,51.84},{91.87,51.62},{91.63,51.41},{91.16,51.06},{90.91,50.96},{90.6,50.99},{90.52,51.57},{90.58,52.04},{90.9,52.46},{91.14,52.66},{91.65,53.02},{91.94,53.05},{92.09,53.05},{92.55,52.92},{92.76,52.69},{92.86,52.31},{92.63,51.86},{92.32,51.87},{82.05,37.82},{81.8,37.36},{81.57,37.14},{81.33,36.93},{81.13,36.82},{80.73,36.76},{80.49,36.45},{80.57,36.06},{80.83,36.05},{81.04,36.3},{81.45,36.85},{81.84,37.42},{82.03,37.72},{82.4,38.32},{82.71,38.79},{82.9,38.99},{83.26,39.32},{83.46,39.81},{83.26,40.14},{83.13,40.06},{83.0,39.73},{82.86,39.26},{82.52,38.74},{82.39,38.45},},[14]={{3.87,95.79},{3.63,95.34},{3.41,95.13},{3.18,94.93},{2.98,94.81},{2.59,94.76},{2.36,94.46},{2.44,94.08},{2.69,94.07},{2.9,94.32},{3.29,94.84},{3.67,95.4},{3.85,95.69},{4.21,96.27},{4.52,96.73},{4.7,96.93},{5.05,97.25},{5.25,97.73},{5.05,98.05},{4.93,97.97},{4.8,97.65},{4.67,97.19},{4.34,96.68},{4.2,96.4},},},17,nil,nil,14,nil,},
[3241] = {'Savannah Patriarch',328,356,15,16,0,{[17]={{43.92,16.66},{44.5,14.06},{46.96,13.7},{45.51,16.59},{43.1,15.03},{44.42,15.78},{61.63,32.73},},},nil,17,nil,nil,16,nil,},
[3242] = {'Zhevra Runner',273,300,13,14,0,{[17]={{45.2,31.24},{43.46,29.05},{46.39,27.47},{42.81,26.83},{47.62,37.64},{47.3,36.47},{59.28,20.3},{52.78,20.31},{56.17,21.19},{50.71,12.7},{64.43,32.95},{64.46,34.6},{64.97,34.32},{64.69,34.01},{63.6,31.47},{43.94,26.16},{43.49,32.18},{45.85,30.42},{49.38,37.93},{55.65,38.81},{52.38,16.26},{60.32,22.1},{61.68,22.09},{52.98,19.55},{58.56,20.37},{43.29,27.42},{42.24,25.85},{47.01,27.42},{42.78,24.28},{45.82,26.63},{45.68,29.67},{44.53,26.62},{49.73,36.44},{55.01,38.23},{52.22,17.62},{53.81,16.72},{49.45,13.27},{52.02,17.14},{58.21,20.08},{43.77,28.51},{44.39,32.83},{45.5,30.18},{43.22,25.74},{44.02,28.84},{56.64,34.61},{53.34,39.04},{54.38,38.26},{61.52,18.66},{59.02,21.54},{54.81,21.67},{56.71,23.13},{46.26,29.61},{44.27,28.01},{56.69,33.92},{49.39,37.33},{51.36,14.67},{62.23,21.64},{52.74,17.63},{44.37,33.47},{43.07,28.94},{52.67,39.37},{56.28,32.64},{55.68,21.73},{62.3,18.53},{61.36,21.85},{52.55,18.21},{60.05,22.46},{57.99,21.17},{52.31,15.5},{43.4,31.03},{47.41,26.05},{45.64,27.57},{46.39,26.82},{47.09,28.58},{48.82,38.28},{50.24,36.34},{48.64,38.42},{57.12,20.19},{52.25,16.07},{53.3,17.2},{46.78,25.15},{46.74,27.03},{44.58,35.34},{46.4,25.64},{46.12,30.98},{56.7,34.93},{55.27,35.47},{55.93,35.08},{58.03,19.84},{57.95,20.77},{61.33,23.49},{53.07,17.02},{51.72,13.07},{44.77,25.32},{48.96,37.55},{56.87,19.85},{56.32,21.65},{52.74,17.7},{52.37,14.5},{61.86,23.05},{52.49,35.22},{47.95,38.62},{57.05,19.09},{51.15,12.58},{61.49,17.83},{49.99,37.95},{48.57,37.68},{43.15,28.06},{49.52,37.42},{49.33,36.41},{48.71,35.93},{42.47,23.65},{42.78,26.09},{42.21,23.47},{45.15,25.56},{44.66,33.06},{52.1,34.86},{48.4,36.85},{51.71,37.76},{51.95,36.77},{52.89,38.62},{50.85,37.85},{51.82,35.57},{52.4,36.39},{55.75,34.43},{52.82,37.59},{50.68,35.77},{53.03,37.41},{54.73,34.11},{43.81,33.47},{59.62,21.75},{51.39,37.0},{54.31,35.1},{53.35,36.78},{53.37,35.5},{53.99,33.04},{54.02,37.51},{51.23,37.92},{51.82,36.51},{50.79,34.14},{55.99,33.55},{53.27,36.04},{56.96,21.66},{62.44,22.47},{54.65,37.91},{60.91,21.59},{52.05,37.91},{52.69,34.84},},},nil,17,nil,nil,189,"AH",},
[3243] = {'Savannah Highmane',247,273,12,13,0,{[17]={{49.64,16.05},{55.34,30.34},{54.94,30.49},{50.11,15.82},{50.7,20.65},{51.75,26.22},},},nil,17,nil,nil,16,nil,},
[3244] = {'Greater Plainstrider',222,247,11,12,0,{[17]={{49.37,24.3},{53.3,22.23},{52.92,22.71},{50.68,14.17},{52.12,20.28},{53.88,28.96},{48.02,14.34},{48.55,13.75},{51.82,19.66},{48.84,23.62},{53.26,29.11},{48.67,24.69},{52.2,21.02},{48.73,25.04},{48.1,15.25},{47.58,13.75},{54.57,32.12},{55.54,25.12},{50.88,19.49},{51.4,22.07},{53.05,33.03},{49.32,22.77},{51.63,21.6},{50.98,15.57},{55.89,23.99},{48.72,23.04},{54.01,23.06},{52.83,21.74},{51.33,23.04},{51.18,16.86},{51.31,18.12},{51.08,17.69},{51.42,19.41},{51.22,17.28},{51.71,18.65},{51.02,18.65},{50.73,15.29},{47.26,14.88},{51.86,22.41},{54.72,23.44},{51.73,23.09},{52.7,25.61},{49.82,13.78},{49.28,14.31},{47.75,14.57},{48.96,24.04},{49.07,22.75},{47.33,14.05},{48.51,23.47},{54.08,22.02},{50.41,13.85},{53.01,32.32},{53.01,23.66},{50.35,33.38},{52.36,21.75},{52.76,28.2},{47.75,25.58},{48.46,25.6},{53.6,30.51},{53.12,30.42},{53.01,26.6},{53.31,30.59},{52.64,27.03},{52.03,27.09},{54.01,27.99},{51.38,28.01},{53.93,28.53},{51.71,27.56},{50.34,31.02},{50.7,27.82},{51.02,27.58},{50.35,30.62},{53.05,31.47},{48.59,26.46},{48.09,27.11},{49.07,29.51},{50.76,33.31},{48.21,28.64},{49.06,30.63},{48.59,29.12},{49.41,29.83},{51.15,32.88},{51.02,31.83},{49.63,30.31},{47.75,27.62},{53.35,32.41},{53.35,32.58},{53.63,29.52},{52.94,33.58},{53.7,32.87},{52.72,26.12},{55.44,24.31},{54.0,23.56},},},nil,17,nil,nil,189,"AH",},
[3245] = {'Ornery Plainstrider',356,386,16,17,0,{[17]={{42.12,16.03},{45.01,13.59},{42.09,15.3},{46.79,13.17},{45.68,14.6},{60.71,31.98},{60.52,33.88},{61.36,13.22},{38.3,26.06},{38.83,24.97},{61.97,49.24},{61.02,48.87},{52.77,47.72},{45.45,17.12},{43.28,14.75},{45.33,15.4},{61.17,30.72},{57.28,6.42},{59.1,6.74},{56.01,5.34},{58.29,7.92},{60.79,9.77},{59.96,8.54},{37.26,28.4},{38.02,27.85},{39.91,24.72},{37.97,26.63},{54.42,51.37},{55.4,50.85},{45.24,13.39},{48.04,13.23},{45.37,15.85},{46.74,12.34},{60.9,34.47},{61.09,33.01},{59.56,7.84},{60.91,10.96},{50.15,49.69},{56.16,49.41},{55.59,47.34},{44.08,17.23},{44.48,15.52},{44.63,14.76},{44.2,15.29},{59.28,49.33},{47.64,44.1},{49.74,47.37},{44.56,13.73},{58.95,50.14},{49.73,50.11},{45.79,43.33},{48.76,49.83},{61.28,47.83},{59.57,53.35},{47.1,44.95},{49.09,47.35},{48.97,48.37},{50.46,47.19},{52.63,47.06},{53.69,51.75},{56.04,48.34},{53.77,48.45},{49.69,48.38},{54.62,50.35},{53.59,48.91},{49.38,48.81},{58.35,51.82},{55.54,51.2},{49.82,46.27},{55.87,48.25},{53.36,48.76},{54.71,49.71},{59.88,33.15},{59.62,31.61},{54.26,50.65},{59.46,33.54},{59.35,32.53},{55.99,6.23},{53.46,47.82},{57.15,52.19},{55.34,47.76},{58.01,51.79},{54.99,52.64},{54.33,48.0},{51.73,47.37},{55.06,49.41},{59.51,52.31},{56.0,52.33},{54.21,52.38},},},nil,17,nil,nil,14,nil,},
[3246] = {'Fleeting Plainstrider',251,282,12,13,0,{[17]={{46.72,24.43},{45.98,30.89},{44.13,25.09},{44.86,31.85},{57.24,27.03},{49.8,38.1},{46.72,20.82},{48.37,17.25},{60.2,22.98},{57.35,21.06},{49.48,18.18},{63.85,31.9},{63.54,31.08},{63.57,29.57},{63.92,30.09},{63.94,32.13},{47.51,31.6},{45.81,32.81},{46.17,27.28},{44.56,35.09},{56.43,30.24},{49.44,20.72},{48.71,20.6},{47.95,21.56},{46.24,19.43},{63.55,28.57},{63.97,35.57},{63.92,35.87},{43.11,31.44},{43.93,34.6},{42.63,29.94},{48.17,38.54},{52.32,15.23},{49.77,20.35},{50.13,21.77},{48.15,19.64},{47.61,32.53},{46.77,26.06},{44.86,32.5},{47.46,29.79},{54.69,38.5},{56.83,29.54},{57.59,30.53},{55.7,29.58},{57.67,31.32},{59.18,20.65},{56.65,21.15},{48.09,20.56},{52.67,21.13},{43.81,31.89},{49.12,32.84},{46.2,30.11},{57.34,29.84},{56.33,28.59},{57.28,31.09},{49.09,20.15},{47.6,21.28},{51.9,14.81},{58.28,20.78},{56.83,22.69},{49.13,17.63},{43.6,24.81},{46.72,33.36},{48.0,31.15},{46.32,30.83},{46.4,28.64},{49.19,38.88},{57.57,28.58},{47.04,37.66},{47.66,37.95},{48.36,18.22},{48.42,19.21},{49.58,21.15},{42.57,25.09},{47.74,33.03},{48.75,31.73},{48.81,32.03},{47.59,34.61},{57.58,27.69},{52.99,18.85},{46.66,19.34},{43.21,33.01},{46.73,32.65},{44.79,25.09},{56.65,27.97},{54.16,34.78},{58.32,31.94},{48.76,21.49},{44.68,33.97},{45.14,26.73},{44.89,35.91},{47.05,26.62},{44.89,34.46},{56.8,34.51},{50.07,35.86},{57.27,29.14},{57.02,27.6},{47.78,20.18},{50.72,12.63},{56.59,31.06},{57.72,29.91},{53.35,37.44},{56.86,26.7},{49.4,35.89},{49.47,19.26},{48.76,19.71},{52.57,16.23},{51.19,13.28},{46.99,21.66},{48.78,37.04},{48.06,37.89},{57.1,28.56},{56.02,31.95},{58.02,28.85},{48.31,37.15},{52.0,35.53},{56.65,29.08},{56.95,30.47},{57.96,30.99},{54.38,36.44},{58.0,26.12},{50.04,36.65},{48.61,15.8},{48.39,20.14},{50.31,13.24},{49.94,17.5},{57.12,20.82},{60.92,22.37},{47.75,34.15},{46.72,34.16},{54.28,33.46},{51.05,34.97},{52.36,36.95},{56.07,33.05},{56.96,31.5},{51.06,35.56},{54.35,34.97},{50.91,34.69},{52.97,35.19},{55.76,22.67},{61.5,22.51},{52.98,34.31},{57.57,23.37},{54.32,35.46},{54.67,35.46},},},nil,17,nil,nil,189,"AH",},
[3247] = {'Thunderhawk Hatchling',302,346,18,20,0,{[17]={{46.76,50.95},{42.81,46.04},{48.54,56.69},{47.61,50.85},{44.45,47.21},{45.82,46.63},{44.03,45.41},{46.71,49.14},{45.75,48.8},{49.41,55.0},{50.8,53.21},{44.13,53.15},{45.49,52.76},{49.79,54.03},},},nil,17,nil,nil,14,nil,},
[3248] = {'Barrens Giraffe',328,356,15,16,0,{[17]={{52.28,13.08},{60.39,15.84},{55.36,13.62},{55.4,46.15},{59.49,33.93},{44.04,39.85},{62.87,7.77},{62.75,28.55},{61.46,8.11},{40.55,25.27},{42.78,32.08},{52.37,42.83},{56.99,42.33},{62.85,29.47},{43.47,38.91},{54.46,9.92},{54.9,40.55},{39.54,31.43},{55.91,37.89},{58.17,34.07},{43.78,38.92},{44.14,17.77},{51.73,12.86},{56.41,16.25},{54.03,10.79},{55.65,40.54},{62.97,26.59},{63.17,6.63},{40.08,30.06},{42.19,36.45},{55.03,8.75},{56.65,17.77},{43.83,42.03},{61.57,8.66},{42.12,30.54},{60.82,14.59},{56.55,39.03},{46.76,42.66},{47.45,42.67},{43.34,33.86},{42.16,22.36},{42.88,20.05},{57.93,18.18},{59.35,35.88},{58.95,30.67},{60.59,41.13},{43.84,40.08},{41.77,21.81},{42.87,35.51},{54.07,41.59},{60.33,41.76},{58.7,33.95},{44.84,18.75},{51.85,44.67},{56.36,40.32},{60.01,27.41},{44.71,40.75},{54.96,44.38},{59.62,36.62},{56.93,39.63},{53.05,45.85},{48.68,40.38},{55.32,47.09},{59.91,33.9},{43.2,41.71},{51.38,42.65},{49.36,42.73},{48.17,41.83},{51.53,13.31},{63.63,5.43},{61.64,26.98},{44.13,19.2},{59.62,29.52},{49.24,40.87},{62.91,26.08},},},nil,17,nil,nil,189,"AH",},
[3249] = {'Greater Thunderhawk',544,582,23,24,0,{[17]={{49.08,76.26},{44.91,73.86},{43.84,76.94},{43.77,78.55},{48.61,76.25},{44.55,75.87},{47.03,73.66},{43.66,75.05},{44.75,78.16},{43.81,78.79},{44.75,75.42},{47.11,74.4},{47.5,75.24},{46.87,76.19},{45.45,81.19},{46.73,79.16},},},nil,17,nil,nil,14,nil,},
[3250] = {'Silithid Creeper',494,531,20,21,0,{[17]={{44.9,72.55},{42.51,72.07},{47.29,70.45},{49.13,69.1},{48.7,70.21},{48.15,70.38},{49.43,69.34},{42.87,71.41},{43.75,72.02},{48.08,69.46},{42.51,69.91},{42.11,69.38},{43.77,72.96},{43.74,71.06},{43.92,69.99},{42.45,71.06},{44.18,69.52},{43.16,69.15},{47.1,70.0},{47.33,71.33},{45.44,69.54},{44.73,71.59},{45.19,72.0},{45.23,70.16},{45.39,69.41},},},nil,17,nil,nil,413,nil,},
[3251] = {'Silithid Grub',485,485,20,20,0,{[17]={{48.04,70.81},{42.53,69.58},{47.45,70.02},{45.11,72.45},{42.88,71.3},{44.07,71.4},{48.04,71.13},{45.25,72.25},{44.23,71.32},{47.34,70.24},{48.65,70.03},{48.46,69.9},{44.17,72.44},{43.04,71.2},{44.0,72.35},{42.82,69.95},{42.93,69.81},{43.47,70.03},{43.29,70.1},{43.12,71.47},{44.43,72.66},{44.17,71.5},{45.06,69.73},{45.06,69.48},},},nil,17,nil,nil,413,nil,},
[3252] = {'Silithid Swarmer',531,573,21,22,0,{[17]={{44.58,71.88},{48.79,69.49},{48.47,70.93},{48.5,70.85},{42.09,71.69},{43.51,69.41},{48.19,71.63},{41.88,69.02},{49.23,69.95},{42.69,72.56},{45.59,72.59},{48.43,70.04},{47.68,70.13},{49.1,69.98},{47.6,70.91},{42.79,71.13},{43.06,71.94},{43.54,70.52},{43.13,70.94},{42.59,70.13},{42.83,70.64},{42.2,70.47},{42.81,69.37},{44.03,69.28},{44.85,69.68},{43.82,72.74},{45.39,72.55},{45.11,68.95},},},nil,17,nil,nil,413,nil,},
[3253] = {'Silithid Harvester',664,664,24,24,4,{[17]={{43.07,70.08},},},nil,17,nil,nil,310,nil,},
[3254] = {'Sunscale Lashtail',178,218,11,13,0,{[17]={{48.85,23.82},{51.79,18.7},{47.71,14.48},{51.29,22.62},{54.6,23.16},{48.35,25.11},{47.87,26.03},{52.93,33.04},{54.73,23.13},},},nil,17,nil,nil,48,nil,},
[3255] = {'Sunscale Screecher',273,328,13,15,0,{[17]={{42.86,25.63},{39.81,31.54},{41.87,20.58},{60.46,22.1},{56.62,15.4},{52.63,13.12},{58.88,17.67},{58.25,45.89},{55.75,44.37},{57.61,14.82},{62.3,25.91},{60.17,14.12},{43.8,19.79},{60.8,23.25},{59.91,17.42},{54.6,8.44},{54.27,16.24},{59.45,17.66},{57.22,10.23},{57.99,13.75},{58.25,13.32},{40.15,24.1},{54.58,35.85},{54.15,10.13},{61.53,41.31},{58.84,43.42},{54.0,40.88},{61.7,46.88},{59.37,13.71},{59.71,14.08},{41.88,25.55},{55.37,21.24},{53.35,14.74},{54.99,7.85},{59.96,44.39},{60.38,44.82},{44.43,41.2},{43.83,40.95},{56.92,11.91},{57.97,11.52},{57.29,12.73},{58.89,10.68},{60.21,11.85},{43.32,33.54},{44.75,33.41},{43.46,19.67},{43.83,18.69},{56.41,35.0},{60.92,46.51},{53.03,46.8},{58.01,12.83},{57.72,12.26},{59.52,10.59},{59.48,15.05},{44.33,26.11},{40.74,20.17},{41.81,32.88},{57.63,17.41},{60.41,14.9},{60.26,47.08},{53.5,46.2},{59.17,15.99},{59.16,12.92},{58.39,14.32},{56.3,11.31},{58.59,13.75},{40.28,24.99},{41.39,25.1},{44.12,19.77},{41.76,29.57},{41.2,23.62},{53.25,17.04},{54.69,9.24},{55.01,13.9},{53.02,13.27},{52.94,43.37},{45.62,30.31},{41.15,22.64},{55.25,9.38},{56.3,16.77},{54.97,10.34},{56.41,9.88},{54.89,15.53},{57.35,36.17},{44.17,34.64},{42.46,30.46},{42.23,33.99},{42.55,38.49},{50.33,13.07},{58.0,20.53},{60.19,17.88},{60.58,16.71},{54.37,12.81},{53.33,11.88},{52.78,42.98},{53.57,44.35},{58.75,39.93},{42.82,38.09},{44.2,18.33},{53.08,19.37},{43.54,40.72},{59.02,42.71},{41.49,20.15},{41.86,34.23},{44.44,18.77},{40.5,29.01},{57.62,38.44},{58.48,34.4},{43.27,34.11},{59.96,46.35},{54.19,40.78},{58.94,45.93},{59.91,45.34},{44.17,41.55},{59.27,44.3},{59.81,43.92},{58.66,46.34},{59.25,45.36},{58.93,46.79},{57.17,35.68},{59.64,46.81},{57.67,36.9},{54.43,41.03},{58.64,45.37},{59.62,44.9},{55.0,44.35},{60.0,42.91},{60.71,29.64},{57.35,39.91},{60.51,43.73},{51.11,43.27},{44.49,40.68},{50.0,39.01},{52.15,35.9},{63.59,6.04},{58.88,14.22},{58.32,12.31},{58.35,44.12},{52.06,43.88},{51.88,46.45},{50.06,45.32},{60.12,29.57},{55.92,40.14},{48.85,41.65},{59.61,45.8},{55.88,14.07},{54.68,11.27},{53.02,12.83},{54.68,16.21},{55.99,33.56},{54.82,39.61},{57.1,36.38},{58.8,34.48},{58.63,33.48},{49.68,39.36},{60.34,28.47},{59.3,46.38},{51.74,44.21},{55.96,38.83},{50.76,39.97},{54.69,46.14},{57.95,37.06},{56.21,39.22},{57.35,40.48},{53.35,34.4},{53.72,35.94},{61.93,23.07},{59.98,35.57},{57.57,42.32},},},nil,17,nil,nil,48,nil,},
[3256] = {'Sunscale Scytheclaw',356,417,16,18,0,{[17]={{57.04,53.01},{56.98,54.49},{48.16,11.26},{46.44,15.03},{60.25,32.21},{60.84,12.72},{59.33,6.22},{60.41,8.85},{59.91,8.85},{59.87,7.47},{57.73,6.22},{39.27,25.65},{36.19,28.79},{37.56,27.46},{37.25,26.78},{60.34,50.4},{57.65,54.12},{57.7,54.1},{57.06,52.87},{43.48,14.97},{43.85,16.19},{44.14,16.62},{42.55,15.65},{47.74,12.92},{60.02,32.03},{55.73,5.75},{58.99,6.33},{57.86,8.22},{36.66,26.43},{51.92,48.0},{44.39,44.25},{52.15,46.62},{44.72,14.26},{46.08,15.3},{61.23,34.04},{60.97,32.05},{58.25,7.37},{51.82,49.36},{50.36,46.14},{47.75,45.8},{60.91,49.85},{44.12,14.4},{45.53,14.68},{60.75,33.37},{51.76,50.7},{55.65,50.79},{48.16,46.81},{50.09,45.68},{43.88,43.44},{50.68,51.8},{47.07,43.38},{46.0,43.85},{46.34,44.13},{51.49,50.78},{48.31,47.37},{49.34,49.62},{47.78,43.21},{50.19,46.68},{52.98,51.23},{45.14,44.39},{48.83,48.66},{56.69,47.39},{60.29,30.47},{61.28,31.02},{60.89,50.02},{56.65,48.96},{48.09,50.27},{59.16,7.39},{56.64,4.35},{44.51,42.99},{57.28,53.67},{57.43,53.76},{57.11,53.38},{57.1,54.41},{58.04,53.89},{58.01,53.99},{57.9,53.93},{52.58,45.99},{44.45,43.83},{52.69,46.05},{49.45,51.16},{57.12,52.01},{57.07,51.88},{54.29,49.44},{52.41,46.62},{58.31,50.03},{52.62,46.27},{55.82,51.88},{53.02,48.28},},},{[15]={{43.06,0.0},{42.71,0.04},},[17]={{57.82,53.96},{57.89,53.88},{57.89,53.76},{57.82,53.73},{57.7,53.7},{57.63,53.66},{57.58,53.66},{57.55,53.74},{57.57,53.87},{57.64,53.98},{57.18,53.33},{57.14,53.18},{57.15,53.03},{57.25,53.01},{57.32,53.1},{57.37,53.26},{57.41,53.39},{57.49,53.64},{57.43,53.71},{57.33,53.6},{57.18,53.44},},},17,nil,nil,48,nil,},
[3257] = {'Ishamuhale',449,449,19,19,0,nil,nil,0,nil,nil,48,nil,},
[3258] = {'Bristleback Hunter',386,417,17,18,0,{[17]={{43.22,47.67},{41.45,44.43},{43.27,48.46},{40.83,45.91},{43.46,52.6},{45.39,51.22},{43.34,52.16},{44.95,51.42},{43.6,51.82},{44.75,51.73},{45.27,53.94},{46.77,54.29},{44.89,53.71},{45.08,54.18},{47.07,53.26},{43.41,48.77},{40.98,44.92},{41.31,44.91},{42.86,48.38},{43.22,47.32},{40.6,45.38},{43.16,48.93},{43.05,47.93},{44.47,52.32},{43.12,51.88},{44.47,51.82},{44.69,51.32},{44.6,51.6},{43.16,52.4},{47.09,53.59},{51.07,54.24},{43.55,48.26},{40.78,45.33},{41.2,45.85},{43.66,47.86},{43.54,47.28},{40.6,45.83},{42.8,51.59},{46.9,53.14},{51.2,54.87},{41.49,46.4},{45.36,54.36},{52.0,54.5},{50.69,55.18},{51.63,54.73},{45.73,54.15},{44.1,51.68},{43.48,52.15},{51.3,55.75},{52.07,53.86},{42.86,55.69},{42.92,54.92},{43.57,54.98},{43.16,55.23},{46.72,54.29},{46.56,53.94},{45.06,54.72},{47.36,52.62},{51.3,57.48},{51.15,55.56},},},{[17]={{43.29,47.34},{43.36,47.32},{43.49,47.36},{43.63,47.52},{43.7,47.74},{43.72,47.92},{43.65,48.18},{43.52,48.31},{43.37,48.35},{43.38,48.15},{43.46,47.99},{43.46,47.75},{43.47,47.6},{43.47,47.42},{43.46,47.4},{43.34,47.18},{43.21,47.13},{43.05,47.23},{42.97,47.43},{42.98,47.54},{43.14,47.38},{44.46,52.32},{44.46,52.32},{44.3,52.65},{44.2,52.8},{44.04,52.99},{43.9,52.95},{43.85,52.83},{43.78,52.55},{43.81,52.36},{43.87,52.21},{44.02,51.94},{44.25,52.0},{44.47,52.09},},[215]={{74.19,38.33},{74.33,38.29},{74.59,38.37},{74.87,38.68},{75.01,39.12},{75.04,39.48},{74.91,39.99},{74.65,40.25},{74.36,40.32},{74.38,39.93},{74.52,39.62},{74.52,39.14},{74.55,38.85},{74.55,38.49},{74.54,38.46},{74.29,38.01},{74.04,37.92},{73.73,38.11},{73.56,38.51},{73.59,38.73},{73.91,38.41},{76.51,48.16},{76.51,48.16},{76.18,48.81},{76.0,49.12},{75.67,49.48},{75.4,49.4},{75.29,49.16},{75.15,48.61},{75.22,48.23},{75.33,47.94},{75.63,47.42},{76.08,47.52},{76.53,47.7},},},17,nil,nil,111,nil,},
[3260] = {'Bristleback Water Seeker',325,350,16,17,0,{[17]={{47.24,53.75},{52.6,52.67},{45.09,55.26},{45.51,53.76},{47.1,52.67},{45.38,54.02},{46.42,53.27},{51.13,55.11},{51.08,54.71},{53.41,53.56},{53.73,53.98},{45.27,54.16},{45.13,53.73},{47.33,53.21},{46.82,53.77},{46.46,54.17},{46.51,53.69},{46.86,53.37},{52.63,52.15},{51.36,54.76},{45.5,54.82},{45.66,54.72},{43.51,55.2},{43.51,54.73},{42.87,55.25},{43.17,55.7},{43.09,54.88},{44.8,54.2},{47.72,52.79},{51.24,57.85},{51.44,57.57},{51.05,57.37},},},nil,17,nil,nil,111,nil,},
[3261] = {'Bristleback Thornweaver',377,404,18,19,0,{[17]={{43.41,51.6},{45.03,51.33},{43.27,52.5},{44.87,51.59},{50.73,54.73},{51.33,55.16},{53.1,54.76},{53.01,53.23},{52.36,53.69},{44.78,51.51},{43.03,52.26},{45.17,51.67},{52.95,51.7},{53.08,52.81},{53.03,53.72},{53.37,54.19},{51.66,55.16},{52.63,53.83},{44.02,51.32},{51.04,55.8},{51.32,54.16},{53.4,52.8},{45.48,51.62},{50.37,57.1},{50.43,57.75},{51.68,57.2},{51.73,57.69},{51.41,56.61},{50.73,56.83},},},{[17]={{44.87,51.58},{44.96,51.5},{45.06,51.42},{45.18,51.33},{45.25,51.29},{45.28,51.36},{45.24,51.43},{45.16,51.47},{45.05,51.53},{44.93,51.6},{44.84,51.63},{44.63,51.66},{44.53,51.66},{44.34,51.62},{44.3,51.77},{44.39,51.94},{44.46,51.88},{44.61,51.71},{44.74,51.64},{53.37,54.2},{53.34,54.26},{53.21,54.4},{52.96,54.42},{52.9,54.27},{52.84,54.01},{52.85,53.73},{52.93,53.5},{53.08,53.39},{53.2,53.4},{53.32,53.55},{53.38,53.83},},[215]={{77.3,46.69},{77.49,46.54},{77.69,46.39},{77.92,46.2},{78.06,46.13},{78.12,46.26},{78.04,46.4},{77.89,46.49},{77.67,46.61},{77.42,46.73},{77.26,46.8},{76.84,46.87},{76.63,46.86},{76.27,46.78},{76.19,47.08},{76.36,47.42},{76.51,47.3},{76.8,46.96},{77.06,46.82},{94.07,51.87},{94.02,51.98},{93.75,52.27},{93.27,52.29},{93.15,52.01},{93.03,51.5},{93.04,50.94},{93.21,50.49},{93.51,50.28},{93.75,50.29},{93.98,50.59},{94.09,51.14},},[15]={{34.48,0.46},{34.43,0.57},{34.16,0.85},{33.7,0.87},{33.58,0.6},{33.46,0.1},},},17,nil,nil,111,nil,},
[3263] = {'Bristleback Geomancer',379,405,19,20,0,{[17]={{41.56,44.9},{40.38,45.39},{41.09,46.21},{40.75,45.51},{43.27,48.0},{53.64,53.5},{53.42,53.92},{52.56,52.45},{52.79,52.12},{40.94,45.16},{41.13,45.25},{40.9,44.82},{43.81,48.17},{43.45,48.07},{43.1,46.87},{52.43,53.03},{41.39,45.77},{43.42,47.75},{52.72,53.24},{53.32,53.19},{53.03,52.27},{53.44,54.53},{53.65,54.26},{53.03,54.17},{42.81,47.76},{42.79,48.74},{42.46,46.68},{51.36,57.21},{51.18,57.58},{50.84,57.47},{51.52,57.93},{51.97,57.69},{51.05,56.64},{50.76,57.13},},},{[17]={{52.73,53.23},{52.82,53.22},{52.98,53.13},{53.12,52.97},{53.23,52.71},{53.2,52.51},{53.11,52.3},{52.98,52.21},{52.85,52.23},{52.71,52.33},{52.61,52.54},{52.6,52.73},{52.62,52.93},},[215]={{92.82,49.96},{92.99,49.94},{93.3,49.76},{93.59,49.45},{93.8,48.93},{93.75,48.53},{93.57,48.13},{93.31,47.95},{93.05,47.97},{92.77,48.17},{92.58,48.59},{92.56,48.96},{92.61,49.37},},},17,nil,nil,111,nil,},
[3265] = {'Razormane Hunter',222,247,11,12,0,{[17]={{57.81,24.44},{59.44,23.85},{54.92,25.24},{55.57,26.46},{55.1,25.59},{57.83,23.62},{58.12,24.21},{53.76,25.29},{59.2,26.45},},},nil,17,nil,nil,109,nil,},
[3266] = {'Razormane Defender',247,273,12,13,0,{[17]={{59.25,27.6},{58.88,27.35},{59.31,25.31},{59.32,27.04},{58.02,24.69},{59.14,24.48},{59.37,24.55},{59.56,24.26},{59.25,23.96},{59.62,24.5},{58.9,25.0},{58.95,26.57},{58.79,27.04},{56.7,24.57},{57.27,25.06},{57.57,25.13},{57.24,25.53},{57.2,25.39},{57.07,25.21},{58.3,26.62},{58.7,26.23},{59.26,25.58},},},nil,17,nil,nil,109,nil,},
[3267] = {'Razormane Water Seeker',198,222,10,11,0,{[17]={{54.37,25.01},{53.05,25.05},{54.03,25.19},{55.42,26.65},{55.54,25.75},{54.38,25.9},{54.33,25.56},{54.94,26.74},{55.03,26.97},{55.85,27.18},{55.49,26.91},{55.39,26.99},{55.67,27.27},{55.76,26.66},{55.82,26.67},{53.72,25.65},{53.97,26.06},{53.65,24.51},},},{[14]={{19.41,57.19},{19.21,57.17},{18.95,57.12},{18.6,57.02},{18.54,56.77},{18.66,56.46},{18.93,56.31},{19.21,56.55},{19.36,56.94},{20.21,56.59},{20.05,56.37},{19.76,56.13},{19.57,56.33},{19.42,56.66},{19.4,57.0},{19.42,57.49},{19.68,57.53},{19.91,57.25},{20.04,56.75},},[17]={{55.38,26.94},{55.27,26.93},{55.14,26.9},{54.95,26.85},{54.93,26.72},{54.99,26.56},{55.13,26.48},{55.27,26.6},{55.36,26.81},{55.8,26.63},{55.71,26.51},{55.56,26.39},{55.46,26.49},{55.39,26.66},{55.38,26.84},{55.39,27.09},{55.52,27.12},{55.64,26.97},{55.71,26.71},},},17,nil,nil,109,nil,},
[3268] = {'Razormane Thornweaver',186,208,10,11,0,{[17]={{54.44,24.59},{54.16,25.09},{55.43,26.94},{55.86,26.31},{55.61,26.17},{55.02,25.34},{54.74,25.6},{54.59,25.24},{54.72,27.1},{55.11,26.59},{55.79,26.94},{55.71,26.63},{54.06,25.52},},},{[14]={{18.72,54.11},{18.7,54.12},{18.9,53.89},{19.16,53.56},{19.14,53.08},{18.89,52.85},{18.56,52.95},{18.27,53.22},{17.97,53.57},{17.84,53.92},{17.86,54.45},{18.05,54.85},{18.36,55.13},{18.49,54.71},},[17]={{55.02,25.34},{55.01,25.34},{55.11,25.22},{55.25,25.04},{55.24,24.8},{55.11,24.67},{54.94,24.73},{54.79,24.87},{54.63,25.05},{54.56,25.23},{54.57,25.51},{54.67,25.72},{54.83,25.87},{54.9,25.64},},},17,nil,nil,109,nil,},
[3269] = {'Razormane Geomancer',219,241,12,13,0,{[17]={{59.14,25.06},{56.76,25.08},{59.12,23.96},{58.92,24.51},{59.06,24.21},{58.71,24.1},{59.44,24.56},{59.29,24.66},{59.46,24.02},{57.47,25.57},{56.96,24.13},{57.0,24.54},{57.32,24.6},{56.91,25.45},{56.78,25.39},{56.91,25.08},{56.95,25.36},},},nil,17,nil,nil,109,nil,},
[3270] = {'Elder Mystic Razorsnout',903,903,15,15,1,{[17]={{59.25,24.38},},},nil,17,nil,nil,109,nil,},
[3271] = {'Razormane Mystic',253,276,13,14,0,{[17]={{58.51,27.22},{58.75,27.34},{58.36,26.11},{58.34,26.93},{58.61,26.9},{58.6,26.57},},},{[14]={{25.58,57.03},{25.74,57.3},{25.96,57.56},{26.13,57.62},{26.34,57.57},{26.39,57.23},{26.22,56.84},{26.13,56.67},{25.98,56.4},{25.84,56.2},{25.59,56.27},{25.29,56.55},{25.41,56.96},},[17]={{58.6,26.86},{58.68,27.0},{58.8,27.13},{58.88,27.16},{59.0,27.14},{59.02,26.96},{58.93,26.76},{58.88,26.67},{58.8,26.53},{58.73,26.42},{58.61,26.46},{58.45,26.6},{58.51,26.82},},},17,nil,nil,109,nil,},
[3272] = {'Kolkar Wrangler',248,273,12,13,0,{[17]={{46.79,41.93},{47.36,41.91},{53.4,36.94},{44.26,21.62},{43.69,21.14},{43.38,21.02},{44.44,22.53},{48.81,39.44},{44.76,20.35},{47.54,24.55},{47.7,24.46},{41.98,24.77},{45.46,23.46},{53.66,37.08},{54.92,37.36},{48.72,39.19},{42.77,23.71},{44.97,20.34},{43.57,23.39},{43.76,21.49},{42.29,27.35},{45.63,22.85},{42.42,24.72},{45.14,20.0},{42.45,24.05},{42.61,24.13},{42.29,26.62},{42.28,27.02},{43.27,26.41},{43.5,26.31},{43.6,26.47},{43.54,26.81},{45.72,25.81},{45.7,25.99},{45.69,25.5},{45.51,25.36},{46.16,22.71},{45.88,25.41},{47.23,23.43},{46.6,23.14},{45.54,22.08},{46.59,22.75},{44.68,24.3},{45.63,41.43},{44.74,39.72},{44.73,39.55},{48.02,24.79},{44.41,23.68},{48.31,24.5},{47.95,24.53},{52.99,36.62},{48.39,40.01},{45.8,38.36},{45.75,37.53},{46.71,37.9},{46.79,38.52},{47.74,39.39},{47.47,38.83},{48.46,40.45},{47.04,40.56},{48.05,40.85},{47.42,40.89},{46.05,40.88},{45.44,39.38},{45.51,40.42},{44.47,38.52},{44.49,37.95},{44.63,37.78},{46.65,37.51},{53.42,36.84},},},{[14]={{15.61,76.41},{15.6,77.08},{15.3,77.63},{14.89,77.85},{14.47,77.74},{14.13,77.36},{14.0,76.76},{14.27,76.38},{14.69,76.3},{15.06,76.04},{15.51,75.9},{15.77,76.29},{0.85,55.39},{1.18,55.28},{1.52,54.86},{1.71,54.21},{1.57,53.5},{1.27,53.37},{0.98,53.56},{0.64,53.82},{0.47,54.0},{0.33,54.33},{0.36,54.83},{0.53,55.09},},[17]={{53.4,36.97},{53.39,37.32},{53.23,37.6},{53.02,37.72},{52.8,37.66},{52.62,37.47},{52.56,37.15},{52.7,36.95},{52.92,36.91},{53.11,36.77},{53.34,36.7},{53.48,36.9},{45.7,26.0},{45.87,25.94},{46.05,25.72},{46.14,25.38},{46.07,25.01},{45.91,24.94},{45.76,25.04},{45.58,25.18},{45.49,25.28},{45.42,25.45},{45.44,25.71},{45.53,25.85},{44.47,38.49},{44.48,38.64},{44.49,38.75},{44.34,38.78},{44.23,38.81},{44.36,38.79},{44.36,38.79},{44.65,38.74},{44.74,38.72},{44.52,38.76},{44.48,38.64},{44.45,37.94},{44.53,37.84},{44.59,37.8},{44.53,37.85},{44.47,37.87},{44.4,37.86},{44.36,37.78},{44.41,37.86},{44.46,37.96},{44.47,38.19},{44.47,38.39},{44.47,38.08},},[215]={{94.13,17.88},{94.12,18.56},{93.81,19.13},{93.38,19.35},{92.96,19.24},{92.61,18.86},{92.47,18.23},{92.75,17.84},{93.19,17.76},{93.56,17.49},{94.02,17.35},{94.29,17.75},{76.53,20.87},{76.55,21.17},{76.56,21.39},{76.26,21.46},{76.05,21.5},{76.3,21.46},{76.3,21.46},{76.88,21.36},{77.05,21.33},{76.62,21.4},{76.55,21.17},{76.48,19.79},{76.64,19.6},{76.76,19.53},{76.64,19.61},{76.52,19.65},{76.39,19.64},{76.3,19.47},{76.4,19.64},{76.51,19.84},{76.52,20.3},{76.52,20.69},{76.52,20.07},},},17,nil,nil,130,nil,},
[3273] = {'Kolkar Stormer',259,277,13,14,0,{[17]={{43.34,23.4},{44.43,23.09},{43.46,23.57},{43.01,23.5},{53.41,40.24},{48.72,40.86},{47.46,41.7},{42.08,24.62},{44.5,22.15},{48.88,38.82},{45.79,41.55},{47.12,37.45},{44.76,19.63},{45.12,20.72},{44.36,20.09},{44.77,22.04},{56.94,40.58},{53.57,40.04},{47.74,37.51},{45.48,24.17},{44.97,19.96},{43.71,21.29},{54.76,37.13},{43.95,21.54},{42.23,25.19},{42.08,26.55},{43.25,23.84},{42.16,26.86},{43.63,26.17},{47.21,23.44},{46.59,22.87},{45.76,22.68},{44.67,24.32},{44.82,39.83},{44.85,24.28},{57.02,41.23},{52.81,36.64},{53.05,36.85},{45.81,38.02},{44.13,38.45},{45.51,37.88},{47.18,38.84},{48.07,38.46},{46.75,40.96},{47.81,40.86},{45.8,40.39},{45.08,38.84},{45.44,39.93},{44.76,38.42},{46.05,36.94},{44.32,37.75},{45.39,36.84},{46.49,36.99},{46.77,36.45},},},{[17]={{45.14,20.76},{45.23,20.93},{45.34,21.06},{45.46,21.29},{45.39,21.4},{45.23,21.57},{45.1,21.57},{45.06,21.44},{45.04,21.21},{45.01,21.0},{44.98,20.8},{44.94,20.55},{45.02,20.49},{45.06,20.6},{56.94,40.56},{56.77,40.42},{56.55,40.23},{56.39,40.31},{56.27,40.54},{56.21,40.83},{56.28,41.19},{56.28,41.57},{56.49,41.37},{56.64,41.19},{56.77,40.97},{56.94,40.67},{45.82,38.0},{45.89,37.93},{45.95,37.97},{46.03,38.03},{46.01,38.13},{45.96,38.22},{45.85,38.32},{45.78,38.24},{45.76,38.09},},[14]={{0.16,45.92},{0.41,46.36},{0.26,46.58},{22.4,83.3},{22.07,83.03},{21.66,82.67},{21.34,82.82},{21.11,83.26},{21.01,83.82},{21.14,84.5},{21.15,85.24},{21.54,84.85},{21.83,84.51},{22.07,84.09},{22.4,83.5},{1.1,78.38},{1.23,78.26},{1.34,78.33},{1.48,78.45},{1.46,78.64},{1.35,78.82},{1.16,79.0},{1.02,78.85},{0.98,78.57},},[215]={{99.79,24.92},{99.68,25.5},{99.82,26.2},{99.82,26.96},{79.19,19.9},{79.33,19.77},{79.44,19.85},{79.59,19.98},{79.56,20.17},{79.45,20.35},{79.25,20.54},{79.11,20.39},{79.07,20.1},},},17,nil,nil,130,nil,},
[3274] = {'Kolkar Pack Runner',300,327,14,15,0,{[17]={{52.69,44.82},{53.67,41.93},{57.0,42.86},{48.53,42.45},{47.75,37.43},{55.62,45.76},{54.04,42.77},{52.36,44.93},{55.26,46.57},{53.32,40.95},{56.8,40.64},{52.72,38.92},},},nil,17,nil,nil,130,nil,},
[3275] = {'Kolkar Marauder',333,367,15,16,0,{[17]={{54.98,41.02},{53.09,44.61},{46.46,42.19},{53.29,41.93},{56.58,43.73},{53.72,42.93},{56.01,43.88},{54.55,46.72},{55.81,45.8},{52.99,42.32},{54.31,46.81},{53.93,42.97},{56.33,42.9},{56.44,41.61},},},{[14]={{15.4,85.88},{15.28,85.7},{15.19,85.58},{15.03,85.55},{14.89,85.57},{14.68,85.61},{14.51,85.63},{14.66,85.61},{14.8,85.59},{14.92,85.58},{15.08,85.57},{15.27,85.58},{15.51,85.93},{15.46,86.42},{15.18,86.86},{15.26,87.3},{15.59,87.17},{15.78,86.88},{15.72,86.59},{15.57,86.25},},[17]={{53.29,41.91},{53.23,41.81},{53.17,41.75},{53.09,41.74},{53.02,41.75},{52.91,41.77},{52.82,41.78},{52.9,41.77},{52.97,41.76},{53.04,41.75},{53.12,41.74},{53.22,41.75},{53.35,41.94},{53.32,42.19},{53.17,42.42},{53.21,42.65},{53.38,42.58},{53.49,42.43},{53.45,42.28},{53.37,42.1},},[215]={{93.91,27.62},{93.79,27.44},{93.69,27.31},{93.53,27.29},{93.39,27.31},{93.17,27.34},{92.99,27.37},{93.15,27.34},{93.29,27.33},{93.42,27.31},{93.58,27.3},{93.77,27.32},{94.03,27.68},{93.97,28.18},{93.68,28.63},{93.76,29.08},{94.1,28.95},{94.3,28.65},{94.24,28.35},{94.08,28.0},},},17,nil,nil,130,nil,},
[3276] = {'Witchwing Harpy',300,328,14,15,0,{[17]={{40.6,16.51},{41.42,18.59},{41.85,19.32},{41.12,14.29},{41.04,14.8},{39.9,18.86},{40.38,18.17},{40.23,18.86},{41.89,14.73},{40.23,16.61},{40.29,19.36},{40.84,16.17},{41.41,14.58},{41.89,18.96},{41.47,19.12},{41.5,15.19},{40.58,16.25},{41.19,15.75},{40.87,18.18},{40.9,17.16},{40.13,19.49},{40.87,15.27},{41.2,16.76},{40.57,14.75},{40.7,16.8},},},nil,17,nil,nil,514,nil,},
[3277] = {'Witchwing Roguefeather',328,356,15,16,0,{[17]={{40.35,17.87},{40.46,19.7},{41.13,19.69},{40.47,16.68},{40.95,14.58},{40.52,17.71},{40.6,17.01},{40.12,15.53},{41.24,14.7},{40.12,18.7},{40.24,15.27},{40.01,19.2},{40.53,15.67},{40.5,18.62},{40.37,16.26},{41.82,18.57},{41.2,18.71},{41.63,18.9},{40.95,16.78},{40.21,19.17},},},nil,17,nil,nil,514,nil,},
[3278] = {'Witchwing Slayer',356,386,16,17,0,{[17]={{37.78,16.05},{39.5,13.23},{39.82,16.76},{37.25,15.72},{40.17,15.97},{39.48,14.67},{39.64,11.71},{39.48,15.25},{38.8,10.67},{38.49,17.52},{40.3,15.45},{38.74,11.72},{38.18,12.58},{38.25,15.74},{38.19,15.21},{38.91,14.31},{38.46,15.11},{39.01,12.0},{38.18,14.67},{40.06,15.29},{37.25,16.2},{39.75,15.6},{38.2,13.45},{38.0,14.75},{39.27,13.23},{39.59,16.27},{39.92,11.89},{38.19,16.03},{38.79,15.11},{37.93,16.41},{38.61,17.1},{39.19,17.18},{38.96,13.29},{38.58,16.22},{38.4,13.21},{37.91,13.56},{39.02,12.31},{39.2,14.68},{39.51,16.83},{38.64,13.99},{39.27,10.97},{38.63,13.18},{38.68,12.76},{39.23,10.56},{38.82,17.64},{39.18,15.68},{38.33,12.74},{39.78,16.0},},},{[17]={{39.55,16.29},{39.51,16.19},{39.4,15.74},{39.48,15.45},{39.69,15.48},{39.85,15.67},{39.89,15.74},{39.96,16.03},{39.79,16.3},},[406]={{94.83,73.84},{94.73,73.65},{94.51,72.7},{94.68,72.12},{95.12,72.17},{95.45,72.56},{95.54,72.71},{95.69,73.31},{95.32,73.88},},},17,nil,nil,514,nil,},
[3279] = {'Witchwing Ambusher',386,417,17,18,0,{[17]={{37.57,15.61},{38.24,16.54},},},nil,17,nil,nil,514,nil,},
[3280] = {'Witchwing Windcaller',350,377,17,18,0,{[17]={{38.86,12.42},{38.4,17.12},{38.24,13.1},{38.87,11.97},{39.06,14.1},{38.15,14.83},{38.66,17.75},{38.76,17.31},{38.84,13.93},{38.16,16.37},{38.52,13.05},{37.77,16.28},{39.58,11.97},{38.82,12.92},{39.31,13.46},{39.25,11.94},{40.76,15.83},{40.49,15.07},{39.18,10.94},{38.79,10.47},{38.34,11.7},{38.52,13.4},{37.97,16.09},},},nil,17,nil,nil,514,nil,},
[3281] = {'Sarkoth',86,86,4,4,0,{[14]={{40.5,66.83},},},nil,14,nil,nil,14,nil,},
[3282] = {'Venture Co. Mercenary',328,356,15,16,0,{[17]={{55.99,8.54},{57.41,8.31},{56.45,8.39},{56.3,7.12},{56.31,8.16},{56.18,8.32},{57.0,8.71},{55.79,7.12},{55.86,8.45},{56.22,8.56},{56.35,9.27},{57.09,7.49},{56.26,8.64},{56.54,7.54},{56.1,7.63},},},nil,17,nil,nil,47,nil,},
[3283] = {'Venture Co. Enforcer',356,386,14,17,0,{[17]={{60.21,3.46},{62.16,3.52},{62.23,5.56},{60.43,4.03},{61.82,3.76},{59.87,3.73},{61.06,3.95},{61.94,3.86},{59.96,3.98},{61.38,3.99},{60.81,3.79},{60.52,3.81},{59.8,2.94},{61.93,4.52},{61.62,3.59},{60.26,3.81},{61.88,5.58},{60.14,3.24},{59.62,2.85},{62.2,4.91},{61.14,5.06},{59.81,3.49},{60.28,4.03},{60.28,3.63},{61.41,5.57},{59.74,3.83},{59.84,3.31},{61.47,4.49},{61.05,3.61},},},{[14]={{30.84,13.19},{30.54,13.05},{30.18,12.92},{30.35,13.0},{30.7,13.18},{30.83,13.24},{30.95,13.47},{31.07,13.91},{30.99,13.61},{30.97,13.34},{29.26,12.84},{29.18,13.05},{29.14,13.15},{29.02,13.29},{28.91,13.29},{28.79,13.18},{28.9,13.33},{29.01,13.31},{29.12,13.24},{29.2,12.97},{29.26,12.83},{29.32,12.79},{29.49,12.8},{29.64,12.82},{30.01,12.88},{29.7,12.79},{29.59,12.76},{29.42,12.78},{29.29,12.81},{27.5,11.03},{27.64,11.08},{27.78,11.11},{27.9,11.26},{28.03,11.45},{27.89,11.24},{27.74,11.08},{27.6,10.91},{27.55,11.01},},[17]={{61.35,3.98},{61.19,3.91},{61.0,3.84},{61.09,3.88},{61.27,3.98},{61.34,4.01},{61.4,4.13},{61.46,4.36},{61.42,4.2},{61.41,4.06},{60.52,3.8},{60.48,3.91},{60.45,3.96},{60.39,4.04},{60.34,4.03},{60.27,3.98},{60.33,4.05},{60.39,4.05},{60.44,4.01},{60.49,3.87},{60.52,3.8},{60.55,3.78},{60.64,3.78},{60.72,3.79},{60.91,3.82},{60.75,3.78},{60.69,3.76},{60.6,3.77},{60.53,3.79},{59.6,2.86},{59.67,2.88},{59.75,2.9},{59.81,2.98},{59.88,3.08},{59.81,2.97},{59.73,2.88},{59.65,2.79},{59.63,2.84},},[331]={{91.79,86.62},{91.51,86.49},{91.19,86.38},{91.34,86.45},{91.66,86.61},{91.78,86.67},{91.89,86.88},{92.0,87.28},{91.93,87.01},{91.9,86.76},{90.34,86.3},{90.27,86.49},{90.23,86.59},{90.12,86.72},{90.02,86.71},{89.91,86.62},{90.01,86.75},{90.11,86.73},{90.21,86.67},{90.28,86.42},{90.34,86.29},{90.4,86.26},{90.55,86.26},{90.69,86.28},{91.03,86.34},{90.74,86.26},{90.64,86.23},{90.49,86.25},{90.37,86.27},{88.73,84.64},{88.86,84.68},{88.98,84.72},{89.09,84.85},{89.21,85.03},{89.09,84.83},{88.95,84.69},{88.82,84.53},{88.77,84.62},},},17,nil,nil,47,nil,},
[3284] = {'Venture Co. Drudger',300,328,14,15,0,{[17]={{52.72,10.97},{52.56,11.72},{55.87,8.93},{57.43,7.14},{55.83,7.78},{57.22,8.66},{56.19,7.46},{57.04,9.01},{55.53,8.87},{57.58,7.85},{52.99,10.47},{52.96,10.27},{52.48,11.63},{52.48,10.7},{55.8,6.93},{56.4,8.21},{55.91,6.73},{57.51,8.76},{57.33,7.76},{56.51,9.4},{56.18,6.86},{56.28,7.55},{55.74,7.7},{57.2,7.15},{56.65,7.16},{56.03,8.32},{56.6,8.89},{56.34,8.77},{56.25,9.47},{56.96,7.14},{56.09,9.79},{55.94,8.76},{56.2,8.36},{56.14,7.25},{55.79,8.07},{56.09,9.16},{55.68,9.46},{55.69,8.4},{56.79,9.15},{57.62,8.23},{56.39,7.39},{57.33,7.39},{56.73,8.82},{57.27,9.16},{56.55,9.12},{56.38,8.21},{57.29,8.93},{55.68,7.24},{56.35,8.54},{56.09,8.58},{55.9,7.39},},},{[14]={{13.97,27.99},{13.92,27.57},{13.68,27.15},{13.4,26.93},{13.22,27.15},{13.23,27.68},{13.47,28.04},{13.78,28.28},{13.94,28.2},{20.1,20.31},{19.87,19.94},{19.71,19.61},{19.51,19.67},{19.42,20.14},{19.8,20.59},{20.0,20.54},{20.07,20.38},{20.77,22.02},{20.66,21.93},{20.6,21.78},{20.71,21.54},{20.85,21.44},{21.09,21.29},{21.23,21.21},{21.01,21.31},{21.02,21.61},{21.2,22.44},{20.97,21.49},{20.82,21.46},{20.7,21.53},{20.63,21.69},{20.62,21.82},{20.66,21.95},{20.86,22.11},{21.03,22.08},{20.84,22.12},},[17]={{52.54,11.7},{52.51,11.49},{52.39,11.27},{52.24,11.15},{52.15,11.27},{52.16,11.55},{52.28,11.73},{52.44,11.86},{52.53,11.81},{55.74,7.7},{55.62,7.5},{55.53,7.33},{55.43,7.36},{55.38,7.61},{55.58,7.84},{55.69,7.82},{55.73,7.73},{56.09,8.59},{56.03,8.54},{56.0,8.46},{56.06,8.34},{56.13,8.29},{56.25,8.21},{56.33,8.17},{56.22,8.22},{56.22,8.37},{56.31,8.81},{56.19,8.31},{56.11,8.3},{56.05,8.34},{56.02,8.42},{56.01,8.48},{56.03,8.56},{56.14,8.64},{56.23,8.62},{56.13,8.64},},[331]={{76.27,99.81},{76.06,99.43},{75.8,99.22},{75.63,99.42},{75.64,99.91},{81.94,93.15},{81.73,92.81},{81.58,92.51},{81.4,92.56},{81.31,93.0},{81.66,93.41},{81.85,93.36},{81.92,93.21},{82.56,94.72},{82.45,94.64},{82.4,94.5},{82.5,94.28},{82.63,94.18},{82.85,94.05},{82.98,93.98},{82.78,94.07},{82.78,94.34},{82.95,95.11},{82.74,94.23},{82.6,94.2},{82.49,94.27},{82.43,94.42},{82.42,94.53},{82.45,94.66},{82.64,94.8},{82.8,94.77},{82.62,94.81},},},17,nil,nil,47,nil,},
[3285] = {'Venture Co. Peon',273,300,13,14,0,{[17]={{52.65,11.74},{52.19,11.23},{52.61,10.36},{52.13,11.67},{53.18,10.34},{52.98,11.22},{53.4,12.22},{52.37,11.83},{51.99,11.47},{51.99,11.87},{52.19,11.49},{53.24,10.4},{53.07,10.87},{52.67,10.81},{53.09,10.34},},},{[14]={{15.16,25.52},{15.07,25.9},{14.85,26.06},{14.53,26.01},{14.3,25.84},{14.24,25.43},{14.08,25.6},{14.09,26.07},{14.31,26.17},{14.57,26.08},{14.87,25.93},{15.1,25.64},{15.03,26.34},{15.02,26.07},{14.75,25.86},{14.7,25.79},{14.83,25.94},{14.96,26.23},{14.97,26.5},{14.83,26.96},{14.72,27.34},{14.58,27.63},{14.38,27.91},{14.47,27.57},{14.62,27.27},{14.78,26.94},{14.9,26.59},},[17]={{53.16,10.42},{53.11,10.61},{53.0,10.7},{52.83,10.67},{52.71,10.58},{52.68,10.37},{52.6,10.46},{52.6,10.7},{52.72,10.76},{52.85,10.71},{53.01,10.63},{53.13,10.48},{53.09,10.84},{53.09,10.7},{52.95,10.6},{52.92,10.56},{52.99,10.64},{53.06,10.79},{53.06,10.93},{52.99,11.17},{52.93,11.37},{52.86,11.52},{52.75,11.66},{52.8,11.48},{52.88,11.33},{52.96,11.16},{53.03,10.97},},[331]={{77.41,97.93},{77.33,98.27},{77.13,98.43},{76.83,98.38},{76.62,98.22},{76.56,97.85},{76.42,98.0},{76.43,98.44},{76.63,98.53},{76.87,98.45},{77.14,98.31},{77.36,98.04},{77.29,98.68},{77.28,98.44},{77.03,98.24},{76.99,98.18},{77.11,98.32},{77.23,98.58},{77.23,98.82},{77.11,99.25},{77.01,99.6},{76.88,99.87},{76.78,99.8},{76.92,99.54},{77.07,99.23},{77.18,98.91},},},17,nil,nil,47,nil,},
[3286] = {'Venture Co. Overseer',386,417,15,18,0,{[17]={{60.4,3.58},{60.33,4.13},{61.42,5.3},{59.65,2.88},{61.87,3.97},{59.96,3.78},{59.84,3.92},{60.66,3.79},{59.92,3.71},{61.74,3.33},{59.62,2.77},{59.63,3.78},{61.95,3.58},{61.91,4.25},{59.54,3.06},{61.86,4.89},{60.55,3.77},{59.95,3.14},{61.86,5.41},{61.19,5.5},{61.62,4.95},{62.3,3.81},},},{[14]={{28.01,12.67},{27.96,12.54},{27.92,12.4},{27.89,12.21},{27.91,12.39},{27.96,12.58},{28.01,12.73},{28.06,12.89},{28.13,13.14},{28.0,13.09},{27.74,12.83},{27.87,12.96},{28.0,13.1},{28.14,13.21},{28.09,13.03},{28.06,12.83},{31.38,15.09},{31.4,14.6},{31.37,14.11},{31.42,13.66},{31.53,13.43},{31.44,13.63},{31.4,13.9},{31.39,14.37},{31.42,15.04},{31.37,15.33},{31.29,15.64},{31.28,16.0},{31.24,16.35},{31.27,16.08},{31.3,15.7},{31.34,15.42},},[17]={{59.87,3.71},{59.84,3.64},{59.82,3.57},{59.81,3.47},{59.81,3.56},{59.84,3.67},{59.87,3.74},{59.89,3.82},{59.93,3.96},{59.86,3.93},{59.73,3.8},{59.79,3.86},{59.86,3.94},{59.93,3.99},{59.91,3.9},{59.89,3.79},{61.62,4.98},{61.63,4.72},{61.62,4.47},{61.64,4.23},{61.7,4.11},{61.66,4.21},{61.63,4.35},{61.63,4.6},{61.65,4.95},{61.62,5.1},{61.58,5.26},{61.57,5.45},{61.55,5.63},{61.57,5.49},{61.58,5.29},{61.6,5.15},},[331]={{89.19,86.14},{89.15,86.03},{89.11,85.9},{89.09,85.72},{89.1,85.89},{89.15,86.07},{89.2,86.2},{89.24,86.34},{89.31,86.58},{89.18,86.53},{88.95,86.29},{89.07,86.41},{89.19,86.54},{89.31,86.64},{89.27,86.48},{89.24,86.29},{92.28,88.37},{92.3,87.91},{92.28,87.47},{92.32,87.06},{92.42,86.84},{92.34,87.02},{92.3,87.27},{92.29,87.7},{92.32,88.32},{92.28,88.58},{92.2,88.87},{92.19,89.2},{92.16,89.52},{92.18,89.27},{92.21,88.92},{92.25,88.67},},},17,nil,nil,47,nil,},
[3287] = {'Hana\'zua',87,87,2,2,0,{[14]={{40.6,62.58},},},nil,14,{790,804,},{790,},126,"H",},
[3289] = {'Spirit of Minshina',456,456,11,11,0,nil,nil,0,nil,nil,35,"AH",},
[3290] = {'Deek Fizzlebizz',836,836,27,27,0,{[38]={{45.91,13.44},},},nil,38,nil,nil,875,"A",},
[3291] = {'Greishan Ironstove',1172,1172,24,24,0,{[38]={{25.55,11.83},},},{[1]={{91.39,24.47},{91.41,25.71},{91.46,26.29},{91.56,26.83},{91.58,27.18},{91.62,27.58},{91.63,29.07},{91.71,30.09},{92.01,31.45},{92.17,31.86},{92.78,32.98},{93.0,33.81},{93.29,34.75},{93.67,35.66},{94.0,36.93},{94.09,37.57},{94.12,37.99},{94.34,39.42},{94.47,40.31},{94.58,40.6},{94.91,41.18},{95.09,41.58},{95.11,41.76},{95.09,42.46},{95.0,42.86},{94.81,43.27},{94.65,43.97},{94.6,44.8},{94.65,45.36},{94.8,45.66},{95.0,46.03},{95.1,46.44},{95.21,46.52},{95.33,46.49},{95.62,46.23},{96.09,45.56},{96.57,44.97},{96.97,44.8},{97.24,44.6},{97.38,44.53},{97.75,44.46},{97.97,44.19},{98.02,43.56},{97.92,42.64},{97.66,42.09},{97.88,42.65},{97.99,43.54},{97.94,44.14},{97.73,44.43},{97.31,44.54},{96.93,44.76},{96.68,44.84},{96.4,45.09},{95.66,46.17},{95.19,46.73},{95.15,47.39},{94.92,48.6},{94.72,50.04},{94.61,50.54},{94.21,51.1},{93.82,51.64},{93.53,52.38},{93.41,52.68},{93.16,53.54},{92.84,54.85},{92.75,55.24},{92.56,55.48},{92.17,55.65},{91.42,56.36},{91.13,56.52},{90.92,56.77},{90.32,57.63},{89.9,58.23},{89.29,59.16},{89.06,59.46},{88.61,60.47},{88.54,60.63},{88.84,61.08},{89.26,61.61},{89.58,61.88},{89.84,61.8},{90.05,61.55},{90.18,61.31},{89.95,61.7},{89.6,61.9},{89.42,61.82},{89.02,61.29},{88.62,60.75},{88.65,60.42},{89.06,59.57},{89.48,58.99},{89.96,58.3},{90.52,57.49},{90.99,56.77},{91.32,56.44},{91.55,56.33},{92.04,55.82},{92.46,55.56},{92.69,55.42},{92.83,55.21},{93.02,54.33},{93.22,53.58},{93.51,52.63},{93.82,51.66},{94.38,50.97},{94.65,50.58},{94.75,50.38},{94.93,49.07},{95.08,48.1},{95.16,47.1},{95.15,46.43},{95.08,46.15},{94.92,45.79},{94.71,45.33},{94.64,44.77},{94.69,44.08},{94.79,43.62},{94.94,43.12},{95.09,42.78},{95.17,42.26},{95.18,41.6},{94.95,41.19},{94.7,40.72},{94.52,40.22},{94.42,39.63},{94.29,38.65},{94.13,37.46},{93.92,36.22},{93.54,35.2},{93.28,34.51},{92.91,33.24},{92.77,32.8},{92.32,31.99},{92.14,31.66},{91.87,30.7},{91.73,29.67},{91.72,28.71},{91.71,27.46},{91.66,27.0},{91.5,26.28},{91.42,25.13},},[11]={{55.84,91.88},{55.86,93.36},{55.92,94.05},{56.05,94.7},{56.07,95.11},{56.11,95.59},{56.12,97.36},{56.22,98.59},{56.42,99.3},{56.25,98.08},{56.24,96.94},{56.22,95.45},{56.17,94.9},{55.97,94.04},{55.88,92.67},},[38]={{25.56,10.49},{25.6,12.71},{25.69,13.73},{25.88,14.71},{25.9,15.33},{25.97,16.04},{25.99,18.7},{26.13,20.53},{26.68,22.96},{26.96,23.68},{28.05,25.67},{28.44,27.16},{28.95,28.85},{29.64,30.47},{30.22,32.73},{30.39,33.87},{30.43,34.62},{30.83,37.18},{31.07,38.76},{31.26,39.28},{31.85,40.32},{32.16,41.03},{32.21,41.35},{32.17,42.61},{32.01,43.31},{31.67,44.06},{31.38,45.3},{31.29,46.77},{31.39,47.77},{31.65,48.32},{32.0,48.97},{32.19,49.7},{32.38,49.85},{32.61,49.79},{33.12,49.33},{33.96,48.13},{34.82,47.08},{35.53,46.77},{36.0,46.42},{36.27,46.3},{36.91,46.18},{37.32,45.68},{37.4,44.56},{37.23,42.93},{36.76,41.95},{37.15,42.94},{37.35,44.53},{37.26,45.6},{36.89,46.11},{36.14,46.31},{35.46,46.71},{35.01,46.85},{34.51,47.3},{33.18,49.22},{32.34,50.21},{32.27,51.4},{31.87,53.56},{31.5,56.13},{31.31,57.02},{30.6,58.02},{29.9,58.99},{29.39,60.31},{29.18,60.85},{28.73,62.37},{28.15,64.72},{28.0,65.4},{27.65,65.84},{26.95,66.15},{25.61,67.42},{25.09,67.7},{24.72,68.13},{23.66,69.68},{22.89,70.76},{21.82,72.41},{21.4,72.95},{20.61,74.75},{20.48,75.04},{21.0,75.84},{21.76,76.77},{22.33,77.26},{22.79,77.12},{23.17,76.68},{23.4,76.25},{22.99,76.93},{22.36,77.31},{22.05,77.15},{21.34,76.2},{20.62,75.25},{20.68,74.66},{21.4,73.14},{22.15,72.1},{23.0,70.87},{24.01,69.42},{24.85,68.14},{25.44,67.55},{25.85,67.35},{26.72,66.46},{27.47,65.99},{27.88,65.74},{28.14,65.35},{28.48,63.79},{28.83,62.45},{29.36,60.76},{29.9,59.03},{30.91,57.8},{31.39,57.09},{31.56,56.74},{31.89,54.41},{32.15,52.67},{32.29,50.88},{32.28,49.7},{32.15,49.19},{31.87,48.55},{31.5,47.72},{31.36,46.73},{31.45,45.49},{31.63,44.67},{31.91,43.78},{32.17,43.17},{32.32,42.24},{32.34,41.06},{31.93,40.34},{31.48,39.49},{31.15,38.59},{30.97,37.55},{30.74,35.81},{30.46,33.67},{30.07,31.46},{29.4,29.65},{28.93,28.4},{28.28,26.15},{28.03,25.37},{27.22,23.91},{26.9,23.33},{26.43,21.6},{26.18,19.78},{26.16,18.06},{26.14,15.83},{26.05,15.01},{25.76,13.72},{25.62,11.67},},[3]={{20.7,0.62},{21.33,1.16},{21.84,1.0},{22.26,0.51},{22.51,0.04},{22.06,0.79},{21.36,1.21},{21.02,1.04},},},38,nil,nil,55,"A",},
[3292] = {'Brewmaster Drohn',372,372,9,9,0,{[17]={{62.26,38.39},},},nil,17,{821,822,},{819,821,822,},29,"H",},
[3293] = {'Rezlak',166,166,5,5,0,{[14]={{46.37,22.94},},},nil,14,{834,835,},{834,835,},69,"AH",},
[3294] = {'Ophek',413,413,10,10,0,{[14]={{54.37,41.29},},},nil,14,{1506,},nil,29,"H",},
[3295] = {'Sludge Beast',449,449,19,19,4,{[17]={{57.54,7.03},},},nil,17,nil,nil,14,nil,},
[3296] = {'Orgrimmar Grunt',4957,4957,55,55,0,{[1637]={{29.9,63.26},{67.64,24.01},{17.12,60.13},{49.92,78.73},{50.83,35.52},{53.27,84.68},{67.6,39.69},{45.58,53.32},{51.74,84.93},{41.5,62.36},{74.88,33.23},{51.0,45.8},{49.05,34.35},{40.6,64.21},{51.37,58.16},{42.71,69.57},{49.56,37.65},{49.86,94.78},{57.36,41.09},{50.89,74.58},{42.36,68.95},{17.76,61.72},{53.03,36.94},{63.0,39.3},{48.74,76.56},{67.94,38.92},{52.42,41.42},{76.58,38.83},{51.84,36.04},{44.3,55.04},{45.85,64.71},{44.67,54.02},{74.09,28.83},{45.93,77.13},{56.61,62.58},{29.67,61.74},{42.39,39.74},{49.49,34.53},{54.7,37.41},{37.66,55.85},{62.65,38.5},{53.1,80.79},{48.96,93.19},{48.47,76.13},{58.94,47.53},{56.51,64.31},{75.39,15.76},{16.47,62.96},{40.8,69.85},{35.39,74.24},{49.59,70.37},{54.85,71.67},{48.34,95.07},{41.32,56.16},{74.81,15.26},{53.39,80.17},{61.75,41.44},{36.61,75.65},{53.51,34.3},{50.48,72.4},{48.42,59.5},{67.25,38.87},{15.85,61.47},{62.7,39.09},{52.2,39.08},{35.55,75.63},{42.72,62.42},{48.86,37.76},{57.28,41.88},{48.23,48.83},{41.7,42.44},{55.83,61.78},},[14]={{50.51,13.49},{50.48,13.27},},},{[1637]={{50.25,35.55},{49.5,35.72},{48.84,35.82},{48.17,35.93},{46.75,36.33},{45.26,36.21},{43.97,36.34},{42.89,36.53},{42.31,36.69},{41.26,36.82},{42.35,36.76},{42.59,36.73},{43.85,36.48},{45.04,36.47},{46.78,36.59},{48.42,36.31},{48.9,36.18},{49.65,36.04},{51.14,35.89},{53.36,35.43},{55.22,36.09},{57.19,37.68},{58.32,38.72},{59.99,40.63},{60.61,42.75},{61.01,45.6},{60.94,47.18},{59.67,47.89},{58.79,46.32},{57.42,44.22},{56.81,41.32},{57.39,39.79},{56.7,37.58},{54.06,35.78},{52.94,35.67},{51.2,35.9},{50.83,58.77},{49.83,60.01},{49.57,61.57},{50.14,62.72},{50.97,63.8},{50.28,64.62},{49.69,65.27},{48.31,66.32},{47.58,65.31},{48.37,66.4},{49.29,65.73},{49.79,65.24},{50.92,63.78},{52.19,65.41},{53.25,64.86},{53.77,64.56},{55.06,63.62},{53.72,64.64},{53.38,64.84},{53.05,65.04},{52.4,65.5},{52.51,67.05},{53.3,69.37},{53.8,71.07},{54.2,73.94},{52.6,75.44},{51.44,73.28},{51.01,71.87},{50.93,70.26},{51.09,68.91},{51.57,68.02},{52.06,65.31},{50.86,63.44},{50.21,62.65},{49.1,60.28},{50.55,59.02},{68.23,38.62},{68.79,37.93},{70.28,36.33},{71.71,34.53},{72.35,34.59},{73.23,34.86},{73.95,34.62},{74.51,34.23},{75.16,33.77},{75.63,33.47},{76.11,33.17},{75.58,33.41},{75.07,33.75},{74.28,34.38},{73.62,34.59},{72.55,34.42},{71.74,34.11},{71.91,32.59},{72.28,30.56},{72.84,29.29},{72.42,28.61},{71.09,26.79},{71.84,27.85},{72.74,29.3},{72.29,30.63},{71.87,32.42},{71.63,34.36},{70.51,36.18},{70.09,36.63},{68.4,38.34},{11.46,67.1},{12.02,66.53},{12.51,66.01},{13.41,65.12},{14.36,64.12},{15.44,63.01},{16.06,62.38},{17.67,60.74},{19.87,58.54},{19.8,59.22},{17.87,60.66},{17.55,60.93},{16.29,62.15},{16.07,62.36},{15.48,62.94},{14.89,63.55},{14.47,63.97},{13.63,64.79},{12.42,66.02},{11.99,66.48},{11.42,67.07},{11.12,67.37},{76.18,38.88},{75.71,39.04},{74.99,39.98},{74.26,40.29},{73.52,40.14},{72.45,39.48},{71.72,38.75},{70.73,37.15},{70.83,35.87},{71.58,34.11},{71.77,33.02},{72.29,30.37},{72.85,29.14},{73.88,28.19},{74.6,26.42},{74.31,24.61},{74.96,23.22},{75.98,22.29},{77.14,21.59},{78.59,21.07},{80.8,20.57},{81.12,22.17},{79.87,21.11},{78.72,21.05},{76.89,21.66},{75.75,22.45},{74.53,24.1},{74.41,25.62},{74.59,26.89},{73.79,28.33},{72.43,30.16},{71.73,33.12},{71.42,34.91},{70.48,36.5},{70.69,37.23},{71.53,38.59},{73.29,40.1},{74.6,40.25},{75.6,39.16},{52.45,35.85},{53.82,35.5},{55.11,36.6},{56.71,37.76},{57.46,39.17},{56.83,41.05},{56.95,42.28},{57.31,43.86},{58.38,45.42},{59.29,47.28},{60.08,48.48},{61.1,47.22},{61.1,45.66},{60.51,42.83},{60.51,41.58},{62.13,39.61},{60.43,41.0},{59.83,40.43},{59.14,39.45},{56.95,37.09},{54.9,35.7},{52.43,35.36},{50.22,35.92},{49.48,36.11},{48.74,36.26},{46.57,36.61},{45.52,36.43},{43.45,37.0},{43.01,39.04},{43.18,41.06},{42.92,39.19},{43.38,37.25},{44.59,36.49},{45.5,36.51},{47.74,36.54},{48.48,36.39},{49.22,36.23},{50.55,35.96},{51.54,35.8},{44.79,54.68},{44.57,55.38},{44.33,56.01},{44.08,56.65},{43.72,57.1},{42.68,57.65},{41.89,57.55},{41.1,56.42},{40.68,54.93},{40.41,54.03},{39.79,52.94},{39.2,52.24},{38.61,52.86},{38.18,52.63},{37.88,52.53},{37.55,52.42},{37.83,52.45},{38.14,52.58},{39.46,52.61},{39.93,53.15},{40.41,54.11},{40.83,55.6},{41.16,56.52},{41.88,57.65},{42.71,57.74},{43.51,57.18},{44.06,56.7},{44.34,56.0},{44.56,55.36},{49.01,93.97},{49.1,94.69},{49.13,95.04},{49.11,94.73},{49.04,93.9},{48.78,90.23},{52.82,89.43},{52.49,84.48},{52.3,82.25},{52.22,78.42},{52.61,75.03},{51.56,73.97},{51.3,72.68},{50.78,71.36},{50.93,70.13},{51.1,68.71},{51.41,68.09},{52.34,67.53},{52.95,68.29},{53.51,70.07},{53.77,71.2},{54.21,74.36},{53.49,76.4},{52.41,79.65},{52.38,82.45},{52.43,84.28},{52.46,84.84},{52.83,89.37},{48.7,90.33},{48.85,92.08},{36.1,74.4},{36.86,74.29},{37.66,74.26},{37.65,74.98},{37.71,77.85},{36.83,77.8},{35.79,77.38},{34.69,77.6},{33.9,79.08},{33.97,81.68},{33.76,83.03},{33.39,84.52},{33.86,82.74},{33.98,80.53},{33.9,78.83},{34.9,77.46},{35.85,77.47},{37.75,78.18},{37.87,79.84},{38.29,81.34},{37.88,79.78},{37.75,78.06},{37.64,75.85},{37.59,74.0},{38.8,73.43},{40.81,70.87},{41.53,69.56},{41.3,69.23},{40.65,68.53},{41.25,69.22},{41.54,69.55},{40.59,71.14},{38.52,73.55},{36.59,74.17},{47.76,59.36},{46.81,59.31},{45.93,60.02},{44.87,61.24},{44.11,62.75},{44.08,63.98},{44.44,66.1},{45.29,67.43},{46.17,69.17},{46.67,71.64},{47.22,72.81},{47.82,72.42},{48.67,71.38},{50.06,71.56},{50.95,70.71},{51.1,69.33},{51.65,68.22},{52.32,65.89},{50.87,63.44},{50.24,62.65},{48.97,60.12},{62.98,38.81},{64.37,37.42},{65.92,40.83},{67.67,39.06},{65.87,40.73},{64.31,37.31},{42.02,42.11},{43.11,41.07},{43.48,41.78},{44.06,42.41},{45.0,43.36},{45.55,43.77},{46.52,43.24},{47.13,42.52},{47.6,41.7},{48.62,39.9},{47.93,41.11},{47.29,42.25},{46.66,43.24},{45.45,43.84},{44.74,43.17},{43.84,42.29},{43.19,41.59},{43.1,40.88},{42.93,38.72},{43.51,37.16},{44.64,36.61},{45.86,36.5},{46.9,36.66},{48.27,36.28},{47.02,36.59},{45.67,36.3},{45.21,36.32},{42.97,36.85},{43.1,38.21},{42.96,39.32},{43.04,40.96},{42.28,41.82},},[14]={{45.98,2.39},{45.71,2.72},{45.64,3.13},{45.79,3.44},{46.01,3.72},{45.83,3.94},{45.67,4.11},{45.31,4.39},{45.11,4.12},{45.33,4.41},{45.57,4.24},{45.7,4.11},{46.0,3.72},{46.34,4.15},{46.62,4.0},{46.76,3.93},{47.1,3.68},{46.74,3.95},{46.65,4.0},{46.57,4.05},{46.39,4.17},{46.42,4.59},{46.63,5.2},{46.77,5.65},{46.87,6.41},{46.45,6.81},{46.14,6.24},{46.02,5.87},{46.0,5.44},{46.05,5.08},{46.17,4.84},{46.3,4.13},{45.98,3.63},{45.81,3.42},{45.52,2.79},{45.9,2.46},{35.53,4.6},{35.68,4.45},{35.81,4.31},{36.05,4.07},{36.3,3.81},{36.59,3.51},{36.75,3.35},{37.18,2.91},{37.76,2.33},{37.75,2.51},{37.23,2.89},{37.15,2.96},{36.82,3.29},{36.76,3.34},{36.6,3.5},{36.44,3.66},{36.33,3.77},{36.11,3.99},{35.79,4.31},{35.67,4.44},{35.52,4.59},{35.44,4.67},{44.38,1.3},{44.32,1.49},{44.25,1.66},{44.19,1.83},{44.09,1.95},{43.82,2.09},{43.61,2.07},{43.4,1.76},{43.29,1.37},{43.21,1.13},{43.05,0.84},{42.89,0.65},{42.74,0.82},{42.62,0.76},{42.54,0.73},{42.46,0.7},{42.53,0.71},{42.61,0.75},{42.96,0.75},{43.09,0.9},{43.21,1.15},{43.33,1.55},{43.41,1.79},{43.6,2.09},{43.82,2.12},{44.03,1.97},{44.18,1.84},{44.25,1.65},{44.31,1.48},{45.49,11.73},{45.52,11.92},{45.53,12.01},{45.52,11.93},{45.5,11.71},{45.43,10.74},{46.5,10.52},{46.42,9.21},{46.37,8.62},{46.35,7.6},{46.45,6.7},{46.17,6.42},{46.1,6.08},{45.96,5.73},{46.0,5.4},{46.05,5.03},{46.13,4.86},{46.38,4.71},{46.54,4.92},{46.69,5.39},{46.76,5.69},{46.87,6.53},{46.68,7.07},{46.4,7.93},{46.39,8.67},{46.4,9.16},{46.41,9.31},{46.51,10.51},{45.41,10.76},{45.45,11.23},{42.07,6.54},{42.27,6.51},{42.48,6.5},{42.48,6.69},{42.5,7.45},{42.26,7.44},{41.99,7.33},{41.7,7.39},{41.49,7.78},{41.5,8.47},{41.45,8.83},{41.35,9.22},{41.48,8.75},{41.51,8.16},{41.49,7.71},{41.75,7.35},{42.0,7.35},{42.51,7.54},{42.54,7.98},{42.65,8.38},{42.54,7.97},{42.51,7.51},{42.48,6.92},{42.46,6.43},{42.79,6.28},{43.32,5.6},{43.51,5.25},{43.45,5.16},{43.28,4.98},{43.44,5.16},{43.51,5.25},{43.26,5.67},{42.71,6.31},{42.2,6.47},{45.16,2.55},{44.91,2.53},{44.68,2.72},{44.4,3.05},{44.19,3.44},{44.19,3.77},{44.28,4.33},{44.51,4.69},{44.74,5.15},{44.87,5.8},{45.02,6.11},{45.18,6.01},{45.41,5.74},{45.77,5.78},{46.01,5.56},{46.05,5.19},{46.19,4.9},{46.37,4.28},{45.99,3.63},{45.82,3.42},{45.48,2.75},},[17]={{69.65,0.05},{69.71,0.45},{69.49,0.66},{69.33,0.36},{69.27,0.16},{68.99,3.22},{69.0,3.32},{69.01,3.37},{69.0,3.33},{68.99,3.21},{68.96,2.7},{69.52,2.59},{69.47,1.91},{69.45,1.6},{69.43,1.07},{69.49,0.6},{69.34,0.45},{69.31,0.27},{69.23,0.09},{69.65,0.07},{69.71,0.51},{69.61,0.79},{69.46,1.24},{69.46,1.63},{69.46,1.88},{69.47,1.96},{69.52,2.58},{68.95,2.72},{68.97,2.96},{67.2,0.51},{67.31,0.5},{67.42,0.49},{67.42,0.59},{67.43,0.99},{67.3,0.98},{67.16,0.92},{67.01,0.95},{66.9,1.16},{66.91,1.52},{66.88,1.71},{66.83,1.91},{66.89,1.67},{66.91,1.36},{66.9,1.13},{67.04,0.93},{67.17,0.94},{67.43,1.04},{67.45,1.27},{67.51,1.47},{67.45,1.26},{67.43,1.02},{67.42,0.71},{67.41,0.46},{67.58,0.38},{67.85,0.02},{67.82,0.06},{67.54,0.39},{67.27,0.48},{68.67,0.13},{68.74,0.29},{68.82,0.24},{68.94,0.09},{69.14,0.12},{69.26,0.0},},[16]={{28.88,99.99},{29.01,99.9},{28.86,99.97},{27.85,99.75},{27.95,99.18},{28.1,98.83},{27.99,98.64},{27.62,98.14},{27.83,98.43},{28.08,98.84},{27.95,99.2},{27.84,99.7},{27.81,99.87},{27.95,99.13},{28.11,98.79},{28.39,98.53},{28.59,98.04},{28.51,97.54},{28.69,97.15},{28.97,96.9},{29.29,96.7},{29.7,96.56},{30.31,96.42},{30.4,96.86},{30.05,96.57},{29.73,96.55},{29.23,96.72},{28.91,96.94},{28.57,97.4},{28.54,97.82},{28.59,98.17},{28.37,98.57},{27.99,99.07},{27.8,99.89},},[331]={{96.09,78.74},{96.23,78.6},{96.35,78.48},{96.57,78.26},{96.8,78.02},{97.06,77.75},{97.21,77.59},{97.6,77.2},{98.14,76.66},{98.12,76.83},{97.65,77.18},{97.57,77.24},{97.27,77.54},{97.21,77.59},{97.07,77.73},{96.93,77.88},{96.82,77.98},{96.62,78.18},{96.33,78.48},{96.22,78.59},{96.08,78.74},{96.01,78.81},},},1637,nil,nil,85,"H",},
[3297] = {'Sen\'jin Watcher',1309,1309,25,30,0,{[14]={{56.02,75.25},{55.21,74.78},{56.33,74.59},{56.26,72.62},{56.24,74.92},{55.38,73.45},{56.39,73.7},},},{[14]={{56.16,74.61},{55.99,74.49},{55.81,74.2},{55.76,74.06},{55.75,73.84},{55.74,73.73},{55.7,73.69},{55.63,73.69},{55.59,73.76},{55.57,73.85},{55.6,73.97},{55.61,74.16},{55.52,74.37},{55.49,74.58},{55.58,74.85},{55.7,75.08},{55.84,75.17},{55.93,75.18},{55.99,75.11},{56.11,74.87},{56.25,74.78},{56.33,74.59},{56.25,74.55},{56.26,72.62},{56.05,72.56},{55.73,72.52},{55.45,72.55},{55.3,72.81},{55.2,73.12},{55.06,73.61},{54.97,74.0},{54.96,74.39},{54.93,74.85},{54.93,75.16},{54.92,75.48},{54.92,75.77},{54.94,76.19},{55.1,76.54},{55.23,76.63},{55.39,76.67},{55.63,76.6},{55.89,76.49},{56.1,76.43},{56.3,76.39},{56.5,76.35},{56.66,76.31},{56.83,76.19},{56.98,75.97},{57.12,75.7},{57.21,75.49},{57.27,75.14},{57.26,74.86},{57.2,74.55},{57.11,74.26},{56.95,73.8},{56.75,73.3},{56.61,72.97},{56.48,72.78},{56.33,72.6},},[17]={{74.55,36.03},{74.47,35.97},{74.37,35.82},{74.34,35.74},{74.34,35.63},{74.33,35.57},{74.31,35.55},{74.28,35.55},{74.26,35.59},{74.25,35.63},{74.26,35.69},{74.27,35.79},{74.22,35.91},{74.21,36.01},{74.25,36.15},{74.32,36.27},{74.39,36.32},{74.43,36.33},{74.47,36.29},{74.53,36.16},{74.6,36.12},{74.64,36.02},{74.6,36.0},{74.61,34.99},{74.5,34.96},{74.33,34.94},{74.19,34.95},{74.1,35.09},{74.06,35.25},{73.98,35.51},{73.93,35.71},{73.93,35.92},{73.91,36.15},{73.91,36.31},{73.91,36.48},{73.91,36.64},{73.92,36.85},{74.0,37.03},{74.07,37.08},{74.15,37.1},{74.28,37.07},{74.41,37.01},{74.53,36.98},{74.63,36.96},{74.73,36.94},{74.82,36.92},{74.91,36.85},{74.98,36.74},{75.06,36.6},{75.1,36.49},{75.13,36.3},{75.13,36.16},{75.1,36.0},{75.05,35.84},{74.97,35.61},{74.86,35.35},{74.79,35.17},{74.72,35.07},{74.64,34.98},},},14,nil,nil,877,"H",},
[3298] = {'Gabrielle Chase',3866,3866,53,53,0,{[46]={{84.24,67.78},},},nil,46,nil,nil,12,"A",},
[3300] = {'Adder',1,1,1,1,0,{[14]={{44.39,19.94},{45.48,25.59},{56.27,43.9},{54.19,77.84},{53.83,54.85},{38.04,23.22},{48.79,15.38},{38.41,36.53},{52.2,71.51},{39.79,34.27},{37.1,55.1},{54.22,15.16},{36.1,53.1},{53.06,53.0},{57.6,49.43},{41.82,36.17},{53.3,53.82},{56.72,45.85},{42.04,29.15},{44.15,29.66},{45.32,62.34},{53.21,19.52},{53.01,12.48},{42.29,32.51},{36.56,32.56},{39.98,47.59},{44.12,33.49},{50.16,45.07},{41.48,46.05},{57.31,28.35},{40.53,18.89},{57.79,72.15},{46.65,64.14},{40.5,21.6},{39.43,22.1},{39.2,45.83},{57.35,25.67},{42.97,63.58},{43.98,59.72},{51.1,48.41},{43.62,42.85},{54.11,62.92},{44.97,17.08},{42.36,17.31},{45.28,17.8},},[17]={{37.21,27.68},{54.89,51.52},{45.03,84.65},{44.84,74.23},{61.72,33.34},{47.82,37.43},{51.5,17.93},{49.96,46.74},{38.59,15.79},{50.02,50.13},{57.32,34.46},{46.06,42.48},{47.74,64.13},{57.76,43.7},{56.38,48.23},{60.29,30.8},{48.47,52.17},{50.01,59.99},{53.64,30.11},{40.16,29.28},{53.8,49.47},{57.04,22.11},{43.79,56.72},{45.34,29.66},{50.54,53.51},{43.99,33.25},{56.03,15.83},{42.5,59.72},{59.69,17.78},{51.99,56.79},{43.59,36.11},{54.55,44.97},{50.6,14.61},{43.88,53.67},{46.34,24.46},{47.84,45.66},{45.74,49.22},{61.4,20.84},{60.08,35.7},{47.97,49.82},{48.02,60.2},{44.41,46.73},{44.37,38.3},{41.98,28.27},{41.33,32.52},{47.44,77.4},{44.17,80.02},{47.77,80.34},{46.09,47.24},{46.13,51.77},{47.97,74.44},{53.85,27.45},{48.76,77.06},{41.65,21.35},{50.82,37.29},{59.69,27.22},{51.17,43.27},{45.04,76.85},{54.26,41.04},{45.97,66.71},{44.85,64.12},},},nil,17,nil,nil,7,"AH",},
[3301] = {'Morgan Ladimore',1342,1342,1,1,0,nil,nil,0,nil,nil,35,"AH",},
[3304] = {'Master Vornal',456,456,11,11,0,{[14]={{55.94,74.39},},},nil,14,{818,},{818,},126,"H",},
[3305] = {'Grisha',7842,7842,55,55,1,{[51]={{34.84,30.87},},},nil,51,nil,nil,29,"H",},
[3306] = {'Keldas',2471,2471,40,40,0,{[141]={{56.79,59.78},},},nil,141,nil,nil,80,"A",},
[3309] = {'Karus',2972,2972,45,45,0,{[1637]={{49.58,69.12},},},nil,1637,nil,{4511,},29,"H",},
[3310] = {'Doras',7842,7842,55,55,1,{[1637]={{45.12,63.89},},},nil,1637,{6386,},{6385,},29,"H",},
[3312] = {'Olvia',3517,3517,50,50,0,{[1637]={{44.68,70.01},},},nil,1637,nil,nil,29,"H",},
[3313] = {'Trak\'gen',1605,1605,30,30,0,{[1637]={{48.12,80.53},},},nil,1637,nil,nil,29,"H",},
[3314] = {'Urtharo',1605,1605,30,30,0,{[1637]={{47.56,68.38},},},nil,1637,nil,nil,29,"H",},
[3315] = {'Tor\'phan',1605,1605,30,30,0,{[1637]={{62.81,50.44},},},nil,1637,nil,nil,29,"H",},
[3316] = {'Handor',1605,1605,30,30,0,{[1637]={{62.88,44.69},},},nil,1637,nil,nil,29,"H",},
[3317] = {'Ollanus',1605,1605,30,30,0,{[1637]={{56.52,73.77},},},nil,1637,nil,nil,29,"H",},
[3318] = {'Koma',2972,2972,45,45,0,{[1637]={{50.0,68.58},},},nil,1637,nil,nil,29,"H",},
[3319] = {'Sana',1605,1605,30,30,0,{[1637]={{55.97,72.73},},},nil,1637,nil,nil,29,"H",},
[3320] = {'Soran',2972,2972,45,45,0,{[1637]={{49.08,69.59},},},nil,1637,nil,nil,29,"H",},
[3321] = {'Morgum',1605,1605,30,30,0,{[1637]={{56.24,73.21},},},nil,1637,nil,nil,29,"H",},
[3322] = {'Kaja',1605,1605,30,30,0,{[1637]={{52.15,62.13},},},nil,1637,nil,nil,29,"H",},
[3323] = {'Horthus',1605,1605,30,30,0,{[1637]={{45.43,56.55},},},nil,1637,nil,nil,29,"H",},
[3324] = {'Grol\'dar',3517,3517,50,50,0,{[1637]={{47.98,45.93},},},nil,1637,{8419,},nil,29,"H",},
[3325] = {'Mirket',3517,3517,50,50,0,{[1637]={{48.62,46.95},},},nil,1637,{8419,},nil,29,"H",},
[3326] = {'Zevrost',3517,3517,50,50,0,{[1637]={{48.47,45.43},},},nil,1637,{3631,4737,4967,8419,},nil,29,"H",},
[3327] = {'Gest',2471,2471,40,40,0,{[1637]={{42.69,51.48},},},nil,1637,nil,nil,29,"H",},
[3328] = {'Ormok',3517,3517,50,50,0,{[1637]={{43.9,54.63},},},nil,1637,{8233,},nil,29,"H",},
[3329] = {'Kor\'jus',1605,1605,30,30,0,{[1637]={{48.96,54.22},},},nil,1637,nil,nil,29,"H",},
[3330] = {'Muragus',1605,1605,30,30,0,{[1637]={{44.35,48.11},},},nil,1637,nil,nil,29,"H",},
[3331] = {'Kareth',1605,1605,30,30,0,{[1637]={{45.65,55.96},},},nil,1637,nil,nil,29,"H",},
[3332] = {'Lumak',2016,2016,35,35,0,{[1637]={{69.8,29.21},},},nil,1637,{6608,},nil,29,"H",},
[3333] = {'Shankys',1605,1605,30,30,0,{[1637]={{69.99,29.77},},},nil,1637,nil,nil,29,"H",},
[3334] = {'Rekkul',1605,1605,30,30,0,{[1637]={{42.09,49.48},},},nil,1637,nil,nil,29,"H",},
[3335] = {'Hagrus',1605,1605,30,30,0,{[1637]={{45.99,45.68},},},nil,1637,nil,nil,29,"H",},
[3336] = {'Takrin Pathseeker',1605,1605,30,30,0,{[14]={{50.84,43.59},},},nil,14,{840,},nil,29,"H",},
[3337] = {'Kargal Battlescar',644,644,15,15,0,{[17]={{62.26,19.38},},},nil,17,{842,},{840,},29,"H",},
[3338] = {'Sergra Darkthorn',6800,6800,60,60,1,{[17]={{52.23,31.01},},},nil,17,{844,845,881,903,905,3261,},{842,844,845,860,881,903,905,},125,"H",},
[3339] = {'Captain Thalo\'thas Brightsun',1240,1240,25,25,0,{[17]={{62.29,39.03},},},nil,17,{891,},{891,898,},69,"AH",},
[3341] = {'Gann Stonespire',434,434,18,18,0,{[17]={{45.89,77.0},},},{[15]={{20.05,44.53},{20.05,44.53},{20.15,44.16},{20.36,43.54},{20.38,43.37},{20.42,42.57},{20.43,42.17},{20.46,41.81},{20.54,41.33},{20.54,41.33},{20.45,41.94},{20.44,42.34},{20.43,42.74},{20.4,43.29},{20.32,43.73},{20.07,44.38},{19.95,44.94},{19.87,46.03},{19.88,46.83},{19.91,47.38},{19.99,47.88},{20.19,48.31},{20.35,48.64},{20.51,49.05},{20.55,49.44},{20.5,50.19},{20.47,50.58},{20.46,50.98},{20.48,51.78},{20.49,52.18},{20.48,52.58},{20.47,52.98},{20.49,53.38},{20.47,54.18},{20.44,54.86},{20.45,55.26},{20.47,55.66},{20.49,56.46},{20.49,56.86},{20.48,57.26},{20.39,58.35},{20.21,58.71},{20.05,59.03},{19.75,59.69},{19.63,59.87},{19.78,59.54},{20.11,58.91},{20.34,58.45},{20.45,57.98},{20.48,57.23},{20.48,56.62},{20.48,56.22},{20.46,55.42},{20.45,55.04},{20.47,54.64},{20.51,53.88},{20.5,53.48},{20.49,53.08},{20.48,52.28},{20.48,52.28},{20.47,51.3},{20.47,50.9},{20.49,50.5},{20.53,49.65},{20.53,49.25},{20.41,48.69},{20.26,48.36},{20.1,48.04},{19.91,47.58},{19.86,46.71},{19.86,46.31},{19.87,45.36},{19.92,44.89},},[17]={{45.89,77.03},{45.89,77.03},{45.94,76.84},{46.05,76.52},{46.07,76.43},{46.08,76.01},{46.09,75.81},{46.11,75.62},{46.14,75.37},{46.14,75.37},{46.1,75.69},{46.1,75.89},{46.09,76.1},{46.07,76.39},{46.03,76.62},{45.9,76.95},{45.84,77.24},{45.8,77.81},{45.8,78.22},{45.82,78.51},{45.86,78.76},{45.97,78.99},{46.05,79.16},{46.13,79.37},{46.15,79.57},{46.13,79.96},{46.11,80.17},{46.1,80.37},{46.12,80.79},{46.12,80.99},{46.12,81.2},{46.11,81.41},{46.12,81.62},{46.11,82.03},{46.09,82.38},{46.1,82.59},{46.11,82.8},{46.12,83.21},{46.12,83.42},{46.12,83.62},{46.07,84.19},{45.98,84.38},{45.9,84.54},{45.74,84.88},{45.68,84.98},{45.75,84.8},{45.93,84.48},{46.04,84.24},{46.1,84.0},{46.12,83.61},{46.12,83.29},{46.12,83.09},{46.1,82.67},{46.1,82.48},{46.11,82.27},{46.13,81.88},{46.13,81.67},{46.12,81.46},{46.12,81.05},{46.12,81.05},{46.11,80.54},{46.11,80.33},{46.12,80.13},{46.14,79.69},{46.14,79.48},{46.08,79.19},{46.0,79.02},{45.92,78.85},{45.82,78.61},{45.79,78.16},{45.79,77.95},{45.8,77.46},{45.83,77.22},},[215]={{79.33,96.9},{79.33,96.9},{79.43,96.52},{79.65,95.89},{79.67,95.71},{79.7,94.9},{79.72,94.49},{79.75,94.12},{79.82,93.64},{79.82,93.64},{79.74,94.26},{79.73,94.66},{79.72,95.07},{79.69,95.64},{79.6,96.09},{79.35,96.75},{79.22,97.32},{79.15,98.43},{79.15,99.25},{79.18,99.81},{79.13,99.13},{79.13,98.73},{79.15,97.75},{79.2,97.27},},[400]={{36.72,0.03},{36.74,0.5},{36.76,1.46},{36.76,1.93},{36.75,2.41},{36.65,3.71},{36.43,4.14},{36.24,4.52},{35.88,5.31},{35.74,5.52},{35.91,5.13},{36.31,4.38},{36.58,3.83},{36.71,3.27},{36.75,2.38},{36.75,1.65},{36.74,1.17},{36.72,0.22},},},17,{843,846,849,},{843,846,849,},104,"H",},
[3342] = {'Shan\'ti',2016,2016,35,35,0,{[1637]={{37.41,52.32},},},nil,1637,nil,nil,29,"H",},
[3343] = {'Grelkor',25918,25918,55,55,0,{[2597]={{-1, -1}},},nil,2597,nil,nil,1215,"H",},
[3344] = {'Kardris Dreamseeker',3139,3139,60,60,0,{[1637]={{38.8,36.37},},},nil,1637,{8410,},nil,29,"H",},
[3345] = {'Godan',2016,2016,35,35,0,{[1637]={{53.9,38.67},},},nil,1637,nil,nil,29,"H",},
[3346] = {'Kithas',2016,2016,35,35,0,{[1637]={{53.88,38.02},},},nil,1637,nil,nil,29,"H",},
[3347] = {'Yelmak',2016,2016,35,35,0,{[1637]={{56.84,33.03},},},nil,1637,nil,nil,29,"H",},
[3348] = {'Kor\'geld',1605,1605,30,30,0,{[1637]={{56.05,34.12},},},nil,1637,nil,nil,29,"H",},
[3349] = {'Ukra\'nor',1605,1605,30,30,0,{[1637]={{29.74,74.17},},},nil,1637,nil,nil,29,"H",},
[3350] = {'Asoran',1605,1605,30,30,0,{[1637]={{46.07,40.87},},},nil,1637,nil,nil,29,"H",},
[3351] = {'Magenius',1605,1605,30,30,0,{[1637]={{45.74,40.94},},},nil,1637,nil,nil,29,"H",},
[3352] = {'Ormak Grimshot',3139,3139,60,60,0,{[1637]={{66.05,18.53},},},nil,1637,nil,{6081,},29,"H",},
[3353] = {'Grezz Ragefist',3139,3139,60,60,0,{[1637]={{79.79,31.42},},},nil,1637,nil,nil,29,"H",},
[3354] = {'Sorek',3517,3517,50,50,0,{[1637]={{80.39,32.38},},},nil,1637,{1505,1718,1823,8417,},nil,29,"H",},
[3355] = {'Saru Steelfury',2972,2972,45,45,0,{[1637]={{82.35,22.97},},},nil,1637,nil,nil,29,"H",},
[3356] = {'Sumi',1605,1605,30,30,0,{[1637]={{82.6,23.96},},},nil,1637,nil,nil,29,"H",},
[3357] = {'Makaru',2016,2016,35,35,0,{[1637]={{73.12,26.08},},},nil,1637,nil,nil,29,"H",},
[3358] = {'Gorina',1605,1605,30,30,0,{[1637]={{73.31,26.6},},},nil,1637,nil,nil,29,"H",},
[3359] = {'Kiro',1605,1605,30,30,0,{[1637]={{73.26,42.25},},},nil,1637,nil,nil,29,"H",},
[3360] = {'Koru',1605,1605,30,30,0,{[1637]={{81.48,18.74},},},nil,1637,nil,nil,29,"H",},
[3361] = {'Shoma',1605,1605,30,30,0,{[1637]={{81.59,18.86},},},nil,1637,nil,nil,29,"H",},
[3362] = {'Ogunaro Wolfrunner',2972,2972,45,45,0,{[1637]={{69.38,12.24},},},nil,1637,{7660,7661,},{7660,7661,},29,"H",},
[3363] = {'Magar',2016,2016,35,35,0,{[1637]={{63.65,49.93},},},nil,1637,nil,nil,29,"H",},
[3364] = {'Borya',1605,1605,30,30,0,{[1637]={{63.08,51.45},},},nil,1637,nil,nil,29,"H",},
[3365] = {'Karolek',2016,2016,35,35,0,{[1637]={{62.81,44.15},},},nil,1637,nil,nil,29,"H",},
[3366] = {'Tamar',1605,1605,30,30,0,{[1637]={{63.05,45.53},},},nil,1637,nil,nil,29,"H",},
[3367] = {'Felika',1605,1605,30,30,0,{[1637]={{60.6,48.93},},},{[14]={{48.57,0.15},{48.6,0.68},{48.52,1.21},{48.24,1.69},{47.89,2.25},{47.59,2.26},{47.13,2.06},{46.82,1.93},{46.52,1.97},{46.3,2.18},{46.14,2.32},{45.98,2.38},{46.11,2.14},{46.26,2.03},{46.45,1.93},{46.74,1.87},{47.14,2.07},{47.48,2.33},{47.87,2.11},{48.23,1.74},{48.51,1.16},{48.54,0.42},},[1637]={{60.62,50.34},{60.71,52.34},{60.4,54.34},{59.38,56.14},{58.02,58.23},{56.89,58.3},{55.16,57.51},{54.01,57.03},{52.88,57.19},{52.06,57.98},{51.44,58.53},{50.83,58.73},{51.33,57.82},{51.9,57.4},{52.62,57.05},{53.71,56.81},{55.2,57.56},{56.5,58.54},{57.98,57.71},{59.31,56.34},{60.39,54.16},{60.51,51.35},{60.35,48.34},{61.09,45.98},{60.62,43.4},{60.36,41.01},{60.03,40.58},{59.14,39.42},{57.52,37.83},{55.53,36.27},{53.95,35.4},{52.04,35.63},{49.82,36.13},{49.08,36.26},{48.34,36.39},{46.51,36.62},{48.22,36.38},{48.96,36.23},{49.7,36.09},{50.52,35.94},{51.26,35.8},{53.33,35.55},{55.45,36.17},{57.24,38.16},{57.4,39.71},{56.75,41.34},{57.11,42.79},{57.42,43.81},{58.63,45.69},{59.29,47.25},{60.63,48.28},},},1637,nil,nil,29,"H",},
[3368] = {'Borstan',1605,1605,30,30,0,{[1637]={{57.2,53.32},},},nil,1637,nil,nil,29,"H",},
[3369] = {'Gotri',1605,1605,30,30,0,{[1637]={{58.81,52.73},},},nil,1637,nil,nil,29,"H",},
[3370] = {'Urtrun Clanbringer',2972,2972,45,45,0,{[1637]={{43.64,74.63},},},nil,1637,nil,nil,29,"H",},
[3371] = {'Tamaro',1605,1605,30,30,0,{[1637]={{56.18,46.05},},},nil,1637,nil,nil,29,"H",},
[3372] = {'Sarlek',1605,1605,30,30,0,{[1637]={{55.68,46.73},},},nil,1637,nil,nil,29,"H",},
[3373] = {'Arnok',2016,2016,35,35,0,{[1637]={{34.18,84.58},},},nil,1637,{6623,},nil,29,"H",},
[3374] = {'Bael\'dun Excavator',531,573,21,22,0,{[17]={{48.42,86.01},{47.55,84.26},{47.49,84.05},{48.4,86.32},{47.27,85.74},{47.99,86.05},{47.74,85.91},{48.19,86.37},{47.06,83.85},{47.36,84.87},{47.4,84.1},{47.96,84.88},{47.37,85.57},{48.02,85.19},{48.06,85.48},{48.21,85.81},{46.92,85.87},{46.85,85.58},{47.07,85.84},{47.04,84.07},{46.89,84.28},{47.36,84.02},{47.22,84.95},{47.57,85.73},{47.82,85.46},{47.46,84.77},{47.21,85.24},{47.4,85.32},{47.71,84.63},},},nil,17,nil,nil,122,"A",},
[3375] = {'Bael\'dun Foreman',573,617,22,23,0,{[17]={{47.54,84.91},{47.19,85.08},{47.62,85.27},{47.19,84.24},{47.5,84.35},{47.7,84.93},{47.49,85.4},{47.44,85.5},},},{[15]={{22.58,58.5},{22.78,58.49},{22.85,59.11},{22.85,58.98},{22.78,58.52},{22.6,58.49},{22.23,58.54},},[17]={{47.2,84.27},{47.31,84.26},{47.35,84.58},{47.35,84.52},{47.31,84.28},{47.21,84.26},{47.02,84.29},},[400]={{39.25,3.89},{39.5,3.88},{39.58,4.62},{39.58,4.46},{39.49,3.92},{39.27,3.88},{38.83,3.94},},},17,nil,nil,122,"A",},
[3376] = {'Bael\'dun Soldier',617,664,23,24,0,{[17]={{49.43,83.94},{49.15,84.12},{49.69,83.94},{49.35,84.09},{49.42,84.43},{49.74,83.95},{49.67,83.83},{48.69,84.81},{48.86,84.55},{48.8,84.35},{49.11,84.67},{49.18,84.13},{49.3,84.53},{49.25,84.26},{48.34,84.15},{48.47,83.75},{49.54,83.61},},},{[15]={{26.88,58.81},{26.82,58.87},{26.76,58.91},{26.52,59.07},{26.38,59.17},{26.24,59.27},{26.38,59.17},{26.5,59.08},{26.78,58.89},},[17]={{49.43,84.43},{49.4,84.46},{49.37,84.48},{49.25,84.56},{49.17,84.62},{49.1,84.67},{49.17,84.62},{49.24,84.57},{49.38,84.47},},[400]={{44.38,4.26},{44.31,4.33},{44.24,4.38},{43.96,4.57},{43.78,4.7},{43.61,4.82},{43.78,4.69},{43.94,4.58},{44.26,4.36},},},17,nil,nil,122,"A",},
[3377] = {'Bael\'dun Rifleman',664,713,24,25,0,{[17]={{49.35,84.44},{49.46,84.35},{49.27,84.23},{49.56,84.3},{49.37,83.9},{49.49,84.15},{48.53,84.64},{48.94,84.34},{48.93,84.91},{49.06,84.34},{48.91,84.03},{49.1,83.88},{48.63,83.9},{48.58,84.1},{49.37,83.71},},},{[15]={{26.65,57.89},{26.61,57.69},{26.66,57.83},{26.84,57.77},{26.89,57.92},{26.84,57.95},{26.64,58.06},{26.85,57.92},{26.9,57.87},{26.83,57.77},{27.0,58.29},{26.97,58.15},{26.91,58.19},{26.72,58.32},{26.92,58.2},{26.96,58.16},{27.0,58.28},{26.85,58.4},{26.88,58.59},{26.87,58.44},{25.98,58.71},{25.78,58.82},{25.62,58.91},{25.48,59.01},{25.59,58.94},{25.87,58.75},{26.06,58.86},{26.08,58.92},{26.2,59.17},{26.08,58.92},{26.05,58.86},{25.93,58.47},{25.92,58.41},{25.87,58.06},{25.91,58.4},{25.93,58.48},{26.26,57.72},{26.12,57.84},{25.97,57.92},{25.87,58.0},{25.94,57.94},{26.09,57.83},{26.26,57.72},{26.36,57.65},{26.41,57.61},{26.51,57.54},{26.42,57.61},{26.37,57.64},},[17]={{49.31,83.95},{49.29,83.85},{49.32,83.92},{49.41,83.89},{49.44,83.97},{49.41,83.98},{49.31,84.04},{49.42,83.97},{49.44,83.94},{49.41,83.89},{49.5,84.16},{49.48,84.09},{49.45,84.1},{49.35,84.18},{49.45,84.11},{49.48,84.09},{49.5,84.15},{49.42,84.22},{49.43,84.31},{49.43,84.24},{48.96,84.38},{48.86,84.43},{48.78,84.48},{48.71,84.53},{48.76,84.49},{48.91,84.4},{49.01,84.46},{49.02,84.48},{49.08,84.62},{49.02,84.49},{49.0,84.45},{48.94,84.25},{48.93,84.22},{48.91,84.04},{48.93,84.21},{48.94,84.26},{49.11,83.86},{49.04,83.92},{48.96,83.97},{48.91,84.01},{48.95,83.98},{49.02,83.92},{49.11,83.86},{49.16,83.83},{49.19,83.81},{49.24,83.77},{49.19,83.81},{49.17,83.82},},[400]={{44.11,3.17},{44.06,2.93},{44.12,3.09},{44.34,3.02},{44.39,3.2},{44.34,3.23},{44.1,3.37},{44.35,3.2},{44.4,3.14},{44.32,3.02},{44.53,3.64},{44.49,3.48},{44.42,3.52},{44.2,3.68},{44.43,3.53},{44.48,3.49},{44.53,3.62},{44.35,3.77},{44.39,4.0},{44.37,3.82},{43.3,4.14},{43.07,4.27},{42.88,4.38},{42.71,4.5},{42.84,4.42},{43.18,4.19},{43.41,4.33},{43.43,4.39},{43.57,4.69},{43.43,4.4},{43.4,4.32},{43.24,3.86},{43.23,3.78},{43.18,3.37},{43.23,3.77},{43.25,3.86},{43.64,2.96},{43.47,3.1},{43.3,3.2},{43.18,3.29},{43.27,3.22},{43.44,3.1},{43.65,2.96},{43.76,2.88},{43.82,2.84},{43.94,2.74},{43.83,2.83},{43.78,2.87},},},17,nil,nil,122,"A",},
[3378] = {'Bael\'dun Officer',788,788,26,26,0,{[17]={{49.26,83.81},{49.22,84.08},{49.76,84.09},{49.21,84.31},{49.53,84.34},{49.14,83.91},{49.6,83.56},{49.5,83.95},{48.64,84.24},{49.4,84.13},{49.19,84.33},},},nil,17,nil,nil,122,"A",},
[3379] = {'Burning Blade Bruiser',198,222,10,11,0,{[17]={{48.35,18.76},{47.17,19.1},{47.78,18.1},{47.87,15.84},{47.64,17.89},{47.85,19.15},{47.71,19.18},{48.07,18.86},{46.29,18.13},{47.21,18.66},{48.23,15.14},{47.39,19.45},{48.48,18.96},{47.91,14.92},{47.95,18.04},{47.0,15.83},{46.68,18.04},{47.38,18.68},{46.5,17.94},{47.38,19.08},{47.54,19.22},{47.58,15.02},{47.79,17.89},{46.33,18.03},{46.47,18.23},{46.66,18.23},},},{[14]={{5.02,42.24},{4.89,42.2