-- RecipeData.lua: all recipes organized by profession

local L = LibStub("AceLocale-3.0"):GetLocale("RecipeRadarClassic")
local BFAC = LibStub("LibBabble-Faction-3.0"):GetLookupTable()

RecipeRadar_RecipeData = {

[L["Mining"]] = {
   Recipes = {
   }
},

[L["Herbalism"]] = {
   Recipes = {
   }
},

[L["Skinning"]] = {
   Recipes = {
   }
},

[L["Poisons"]] = {
   Recipes = {
   }
},

[L["Alchemy"]] = {
   Recipes = {
      {
         ID = 13477,
         Spell = 17553,
         Item = 13443,
         Type = L["Alchemy"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1457, Vendor = L["Ulthir"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Algernon"], Team = "Horde" },
         },
      },
      {
         ID = 13478,
         Spell = 17554,
         Item = 13445,
         Type = L["Alchemy"],
         Skill = 265,
         Cost = 13000,
         Locations = {
            { Region = 1455, Vendor = L["Soolie Berryfizz"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Kor'geld"], Team = "Horde" },
         },
      },
      {
         ID = 5640,
         Spell = 6617,
         Item = 5631,
         Type = L["Alchemy"],
         Skill = 60,
         Cost = 100,
         Locations = {
            { Region = 1436, Vendor = L["Defias Profiteer"], Team = "Alliance" },
            { Region = 1432, Vendor = L["Xandar Goodbeard"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Hagrus"], Team = "Horde" },
            { Region = 1413, Vendor = L["Ranik"], Team = "Neutral" },
         },
      },
      {
         ID = 5642,
         Spell = 6624,
         Item = 5634,
         Type = L["Alchemy"],
         Skill = 150,
         Cost = 1800,
         Locations = {
            { Region = 1455, Vendor = L["Soolie Berryfizz"], Team = "Alliance" },
            { Region = 1457, Vendor = L["Ulthir"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Kor'geld"], Team = "Horde" },
         },
      },
      {
         ID = 5643,
         Spell = 6618,
         Item = 5633,
         Type = L["Alchemy"],
         Skill = 175,
         Cost = 2000,
         Locations = {
            { Region = 1457, Vendor = L["Ulthir"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Hagrus"], Team = "Horde" },
         },
      },
      {
         ID = 6053,
         Spell = 7255,
         Item = 6051,
         Type = L["Alchemy"],
         Skill = 100,
         Cost = 800,
         Locations = {
            { Region = 1432, Vendor = L["Xandar Goodbeard"], Team = "Alliance" },
            { Region = 1413, Vendor = L["Hula'mahi"], Team = "Horde" },
            { Region = 1431, Vendor = L["Kzixx"], Team = "Neutral" },
         },
      },
      {
         ID = 6055,
         Spell = 7257,
         Item = 6049,
         Type = L["Alchemy"],
         Skill = 165,
         Cost = 1500,
         Locations = {
            { Region = 1424, Vendor = L["Nandar Branson"], Team = "Alliance" },
            { Region = 1442, Vendor = L["Jeeda"], Team = "Horde" },
         },
      },
      {
         ID = 6056,
         Spell = 7258,
         Item = 6050,
         Type = L["Alchemy"],
         Skill = 190,
         Cost = 2000,
         Locations = {
            { Region = 1417, Vendor = L["Drovnar Strongbrew"], Team = "Alliance" },
            { Region = 1434, Vendor = L["Glyx Brewright"], Team = "Neutral" },
         },
      },
      {
         ID = 6057,
         Spell = 7259,
         Item = 6052,
         Type = L["Alchemy"],
         Skill = 190,
         Cost = 2000,
         Locations = {
            { Region = 1444, Vendor = L["Logannas"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Bronk"], Team = "Horde" },
            { Region = 1434, Vendor = L["Glyx Brewright"], Team = "Neutral" },
            { Region = 1446, Vendor = L["Alchemist Pestlezugg"], Team = "Neutral" },
         },
      },
      {
         ID = 9300,
         Spell = 11477,
         Item = 9224,
         Type = L["Alchemy"],
         Skill = 250,
         Cost = 10000,
         Locations = {
            { Region = 1419, Vendor = L["Nina Lightbrew"], Team = "Alliance" },
            { Region = 1435, Vendor = L["Rartar"], Team = "Horde" },
         },
      },
      {
         ID = 9301,
         Spell = 11476,
         Item = 9264,
         Type = L["Alchemy"],
         Skill = 250,
         Cost = 10000,
         Locations = {
            { Region = 1453, Vendor = L["Maria Lumere"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Algernon"], Team = "Horde" },
         },
      },
      {
         ID = 9302,
         Spell = 11473,
         Item = 9210,
         Type = L["Alchemy"],
         Skill = 245,
         Cost = 9000,
         Locations = {
            { Region = 1444, Vendor = L["Logannas"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Bronk"], Team = "Horde" },
         },
      },
      {
         ID = 6068,
         Spell = 3449,
         Item = 3824,
         Type = L["Alchemy"],
         Skill = 165,
         Cost = 1500,
         Locations = {
            { Region = 1441, Vendor = L["Montarr"], Team = "Horde" },
            { Region = 1431, Vendor = L["Bliztik"], Team = "Neutral" },
         },
      },
      {
         ID = 6054,
         Spell = 7256,
         Item = 6048,
         Type = L["Alchemy"],
         Skill = 135,
         Cost = 900,
         Locations = {
            { Region = 1440, Vendor = L["Harklan Moongrove"], Team = "Alliance" },
            { Region = 1424, Vendor = L["Christoph Jeffcoat"], Team = "Horde" },
         },
      },
      {
         ID = 14634,
         Spell = 3454,
         Item = 3829,
         Type = L["Alchemy"],
         Skill = 200,
         Cost = 2500,
         Locations = {
            { Region = 1416, Vendor = L["Bro'kin"], Team = "Neutral" },
         },
      },
      {
         ID = 13480,
         Spell = 17556,
         Item = 13446,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 15000,
         Locations = {
            { Region = 1452, Vendor = L["Evie Whirlbrew"], Team = "Neutral" },
         },
      },
      {
         ID = 9303,
         Spell = 11459,
         Item = 9149,
         Type = L["Alchemy"],
         Skill = 225,
         Cost = 8000,
         Locations = {
            { Region = 1446, Vendor = L["Alchemist Pestlezugg"], Team = "Neutral" },
         },
      },
      {
         ID = 12958,
         Spell = 17187,
         Item = 12360,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 50000,
         Locations = {
            { Region = 1446, Vendor = L["Alchemist Pestlezugg"], Team = "Neutral" },
         },
      },
      {
         ID = 9304,
         Spell = 11479,
         Item = 3577,
         Type = L["Alchemy"],
         Skill = 225,
         Cost = 8000,
         Locations = {
            { Region = 1446, Vendor = L["Alchemist Pestlezugg"], Team = "Neutral" },
         },
      },
      {
         ID = 9305,
         Spell = 11480,
         Item = 6037,
         Type = L["Alchemy"],
         Skill = 225,
         Cost = 8000,
         Locations = {
            { Region = 1446, Vendor = L["Alchemist Pestlezugg"], Team = "Neutral" },
         },
      },
      {
         ID = 13501,
         Spell = 17580,
         Item = 13444,
         Type = L["Alchemy"],
         Skill = 295,
         Cost = 30000,
         Locations = {
            { Region = 1422, Vendor = L["Magnus Frostwake"], Team = "Neutral" },
         },
      },
      {
         ID = 13483,
         Spell = 17560,
         Item = 7076,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 15000,
         Locations = {
            { Region = 230, Vendor = L["Plugger Spazzring"], Team = "Neutral" },
         },
      },
      {
         ID = 13482,
         Spell = 17559,
         Item = 7078,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 15000,
         Faction = BFAC["Argent Dawn"],
         Level = 6,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 13484,
         Spell = 17561,
         Item = 7080,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 15000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 5,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 13485,
         Spell = 17562,
         Item = 7082,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 15000,
         Locations = {
            { Region = 1422, Vendor = L["Magnus Frostwake"], Team = "Neutral" },
         },
      },
      {
         ID = 20013,
         Spell = 24367,
         Item = 20008,
         Type = L["Alchemy"],
         Skill = 285,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 8,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 20011,
         Spell = 24365,
         Item = 20007,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 7,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 20014,
         Spell = 24368,
         Item = 20004,
         Type = L["Alchemy"],
         Skill = 290,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 20012,
         Spell = 24366,
         Item = 20002,
         Type = L["Alchemy"],
         Skill = 275,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 5,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 20761,
         Spell = 25146,
         Item = 7068,
         Type = L["Alchemy"],
         Skill = 300,
         Cost = 120000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 5,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
   },
},

[L["Blacksmithing"]] = {
   Recipes = {
      {
         ID = 12162,
         Spell = 3492,
         Item = 3849,
         Type = L["Blacksmithing"],
         Skill = 160,
         Cost = 3000,
         Locations = {
            { Region = 1453, Vendor = L["Kaita Deepforge"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Sumi"], Team = "Horde" },
            { Region = 1434, Vendor = L["Jutak"], Team = "Neutral" },
         },
      },
      {
         ID = 12164,
         Spell = 3498,
         Item = 3855,
         Type = L["Blacksmithing"],
         Skill = 185,
         Cost = 4400,
         Locations = {
            { Region = 1434, Vendor = L["Vharr"], Team = "Horde" },
            { Region = 1434, Vendor = L["Jaquilina Dramet"], Team = "Neutral" },
         },
      },
      {
         ID = 7995,
         Spell = 9937,
         Item = 7924,
         Type = L["Blacksmithing"],
         Skill = 215,
         Cost = 6000,
         Locations = {
            { Region = 1425, Vendor = L["Harggan"], Team = "Alliance" },
            { Region = 1435, Vendor = L["Gharash"], Team = "Horde" },
         },
      },
      {
         ID = 10858,
         Spell = 3494,
         Item = 3851,
         Type = L["Blacksmithing"],
         Skill = 155,
         Cost = 3000,
         Locations = {
            { Region = 1417, Vendor = L["Jannos Ironwill"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Muuran"], Team = "Horde" },
            { Region = 1418, Vendor = L["Jazzrik"], Team = "Neutral" },
         },
      },
      {
         ID = 6047,
         Spell = 3503,
         Item = 3837,
         Type = L["Blacksmithing"],
         Skill = 190,
         Cost = 4400,
         Locations = {
            { Region = 1446, Vendor = L["Krinkle Goodsteel"], Team = "Neutral" },
         },
      },
      {
         ID = 12163,
         Spell = 3496,
         Item = 3853,
         Type = L["Blacksmithing"],
         Skill = 180,
         Cost = 4400,
         Locations = {
            { Region = 1434, Vendor = L["Zarena Cromwind"], Team = "Neutral" },
         },
      },
      {
         ID = 8030,
         Spell = 10013,
         Item = 7947,
         Type = L["Blacksmithing"],
         Skill = 255,
         Cost = 10000,
         Locations = {
            { Region = 1422, Vendor = L["Magnus Frostwake"], Team = "Neutral" },
         },
      },
      {
         ID = 12823,
         Spell = 16971,
         Item = 12775,
         Type = L["Blacksmithing"],
         Skill = 280,
         Cost = 20000,
         Locations = {
            { Region = 1422, Vendor = L["Magnus Frostwake"], Team = "Neutral" },
         },
      },
      {
         ID = 12819,
         Spell = 16969,
         Item = 12773,
         Type = L["Blacksmithing"],
         Skill = 275,
         Cost = 16000,
         Locations = {
            { Region = 1422, Vendor = L["Magnus Frostwake"], Team = "Neutral" },
         },
      },
      {
         ID = 12703,
         Spell = 16661,
         Item = 12632,
         Type = L["Blacksmithing"],
         Skill = 295,
         Cost = 40000,
         Locations = {
            { Region = 1422, Vendor = L["Magnus Frostwake"], Team = "Neutral" },
         },
      },
      {
         ID = 19208,
         Spell = 23638,
         Item = 19166,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 70000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Specialty = L["Weaponsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19209,
         Spell = 23639,
         Item = 19167,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 70000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 8,
         Specialty = L["Weaponsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19211,
         Spell = 23652,
         Item = 19168,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 120000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 8,
         Specialty = L["Master Swordsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19210,
         Spell = 23650,
         Item = 19170,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 120000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 8,
         Specialty = L["Master Hammersmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19212,
         Spell = 23653,
         Item = 19169,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 120000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 8,
         Specialty = L["Master Axesmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17051,
         Spell = 20874,
         Item = 17014,
         Type = L["Blacksmithing"],
         Skill = 295,
         Cost = 70000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 5,
         Specialty = L["Armorsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17060,
         Spell = 20897,
         Item = 17016,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 220000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 8,
         Specialty = L["Master Axesmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19207,
         Spell = 23637,
         Item = 19164,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 80000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Specialty = L["Armorsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19206,
         Spell = 23636,
         Item = 19148,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 60000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Specialty = L["Armorsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17052,
         Spell = 20876,
         Item = 17013,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 180000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 8,
         Specialty = L["Armorsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17059,
         Spell = 20890,
         Item = 17015,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 220000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 6,
         Specialty = L["Master Swordsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 20040,
         Spell = 24399,
         Item = 20039,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 80000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 8,
         Specialty = L["Armorsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17049,
         Spell = 20872,
         Item = 16989,
         Type = L["Blacksmithing"],
         Skill = 295,
         Cost = 90000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 6,
         Specialty = L["Armorsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17053,
         Spell = 20873,
         Item = 16988,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 200000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Specialty = L["Armorsmith"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19202,
         Spell = 23628,
         Item = 19043,
         Type = L["Blacksmithing"],
         Skill = 290,
         Cost = 22000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 6,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19204,
         Spell = 23629,
         Item = 19048,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 7,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19203,
         Spell = 23632,
         Item = 19051,
         Type = L["Blacksmithing"],
         Skill = 290,
         Cost = 22000,
         Faction = BFAC["Argent Dawn"],
         Level = 6,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 19205,
         Spell = 23633,
         Item = 19057,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 19781,
         Spell = 24141,
         Item = 19695,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 5,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19780,
         Spell = 24140,
         Item = 19694,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19779,
         Spell = 24139,
         Item = 19693,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 7,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19778,
         Spell = 24138,
         Item = 19692,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 5,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19777,
         Spell = 24137,
         Item = 19691,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19776,
         Spell = 24136,
         Item = 19690,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 7,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 22209,
         Spell = 27585,
         Item = 22197,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Vargus"], Team = "Neutral" },
         },
      },
      {
         ID = 22214,
         Spell = 27588,
         Item = 22195,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 6,
         Locations = {
            { Region = 1451, Vendor = L["Vargus"], Team = "Neutral" },
         },
      },
      {
         ID = 22766,
         Spell = 28461,
         Item = 22762,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 7,
         Locations = {
            { Region = 1451, Vendor = L["Vargus"], Team = "Neutral" },
         },
      },
      {
         ID = 22767,
         Spell = 28462,
         Item = 22763,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 6,
         Locations = {
            { Region = 1451, Vendor = L["Vargus"], Team = "Neutral" },
         },
      },
      {
         ID = 22768,
         Spell = 28463,
         Item = 22764,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Vargus"], Team = "Neutral" },
         },
      },
      {
         ID = 22705,
         Spell = 28244,
         Item = 22671,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Hydraxian Waterlords"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22704,
         Spell = 28243,
         Item = 22670,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22703,
         Spell = 28242,
         Item = 22669,
         Type = L["Blacksmithing"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Argent Dawn"],
         Level = 8,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
   },
},

[L["Enchanting"]] = {
   Recipes = {
      {
         ID = 6349,
         Spell = 7793,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 100,
         Cost = 500,
         Locations = {
            { Region = 1455, Vendor = L["Tilli Thistlefuzz"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Kithas"], Team = "Horde" },
            { Region = 1421, Vendor = L["Leo Sarn"], Team = "Horde" },
            { Region = 1456, Vendor = L["Nata Dawnstrider"], Team = "Horde" },
         },
      },
      {
         ID = 11223,
         Spell = 13931,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 235,
         Cost = 5800,
         Locations = {
            { Region = 1457, Vendor = L["Mythrin'dir"], Team = "Alliance" },
            { Region = 1435, Vendor = L["Banalash"], Team = "Horde" },
         },
      },
      {
         ID = 11163,
         Spell = 13646,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 170,
         Cost = 3000,
         Locations = {
            { Region = 1424, Vendor = L["Micha Yance"], Team = "Alliance" },
            { Region = 1417, Vendor = L["Keena"], Team = "Horde" },
         },
      },
      {
         ID = 11101,
         Spell = 13536,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 140,
         Cost = 2500,
         Locations = {
            { Region = 1440, Vendor = L["Dalria"], Team = "Alliance" },
            { Region = 1442, Vendor = L["Kulwia"], Team = "Horde" },
         },
      },
      {
         ID = 6342,
         Spell = 7443,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 20,
         Cost = 300,
         Locations = {
            { Region = 1453, Vendor = L["Jessara Cordell"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Tilli Thistlefuzz"], Team = "Alliance" },
            { Region = 1457, Vendor = L["Vaean"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Kithas"], Team = "Horde" },
            { Region = 1421, Vendor = L["Leo Sarn"], Team = "Horde" },
            { Region = 1421, Vendor = L["Lilly"], Team = "Horde" },
            { Region = 1456, Vendor = L["Nata Dawnstrider"], Team = "Horde" },
            { Region = 1458, Vendor = L["Thaddeus Webb"], Team = "Horde" },
            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
         },
      },
      {
         ID = 11039,
         Spell = 13419,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 110,
         Cost = 800,
         Locations = {
            { Region = 1440, Vendor = L["Dalria"], Team = "Alliance" },
            { Region = 1442, Vendor = L["Kulwia"], Team = "Horde" },
         },
      },
      {
         ID = 16217,
         Spell = 20017,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 265,
         Cost = 12000,
         Locations = {
            { Region = 1457, Vendor = L["Mythrin'dir"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Daniel Bartlett"], Team = "Horde" },
         },
      },
      {
         ID = 6377,
         Spell = 7867,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 125,
         Cost = 1000,
         Locations = {
            { Region = 1456, Vendor = L["Nata Dawnstrider"], Team = "Horde" },
            { Region = 1424, Vendor = L["Zixil"], Team = "Neutral" },
         },
      },
      {
         ID = 6346,
         Spell = 7776,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 80,
         Cost = 400,
         Locations = {
            { Region = 1454, Vendor = L["Kithas"], Team = "Horde" },
            { Region = 1421, Vendor = L["Lilly"], Team = "Horde" },
         },
      },
      {
         ID = 16221,
         Spell = 20026,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 275,
         Cost = 16000,
         Locations = {
            { Region = 1452, Vendor = L["Qia"], Team = "Neutral" },
         },
      },
      {
         ID = 16224,
         Spell = 20015,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 285,
         Cost = 20000,
         Locations = {
            { Region = 1450, Vendor = L["Lorelae Wintersong"], Team = "Neutral" },
         },
      },
      {
         ID = 16243,
         Spell = 20051,
         Item = 16207,
         Type = L["Enchanting"],
         Skill = 290,
         Cost = 22000,
         Locations = {
            { Region = 1450, Vendor = L["Lorelae Wintersong"], Team = "Neutral" },
         },
      },
-- Minor Wizard Oil not yet in game
--      {
--         ID = 20758,
--         Spell = 25124,
--         Item = 20744,
--         Type = L["Enchanting"],
--         Skill = 45,
--         Cost = 125,
--         Locations = {
--            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
--            { Region = 1457, Vendor = L["Vaean"], Team = "Alliance" },
--            { Region = 1453, Vendor = L["Jessara Cordell"], Team = "Alliance" },
--            { Region = 1421, Vendor = L["Leo Sarn"], Team = "Horde" },
--            { Region = 1456, Vendor = L["Nata Dawnstrider"], Team = "Horde" },
--            { Region = 1458, Vendor = L["Thaddeus Webb"], Team = "Horde" },
--            { Region = 1454, Vendor = L["Kithas"], Team = "Horde" },
--            { Region = 1455, Vendor = L["Tilli Thistlefuzz"], Team = "Alliance" },
--            { Region = 1421, Vendor = L["Lilly"], Team = "Horde" },
--         },
--      },
--      {
-- Minor Mana Oil not yet in game
--         ID = 20752,
--         Spell = 25125,
--         Item = 20745,
--         Type = L["Enchanting"],
--         Skill = 150,
--         Cost = 750,
--         Locations = {
--            { Region = 1457, Vendor = L["Vaean"], Team = "Alliance" },
--            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
--            { Region = 1453, Vendor = L["Jessara Cordell"], Team = "Alliance" },
--            { Region = 1421, Vendor = L["Leo Sarn"], Team = "Horde" },
--            { Region = 1456, Vendor = L["Nata Dawnstrider"], Team = "Horde" },
--            { Region = 1458, Vendor = L["Thaddeus Webb"], Team = "Horde" },
--            { Region = 1455, Vendor = L["Tilli Thistlefuzz"], Team = "Alliance" },
--            { Region = 1454, Vendor = L["Kithas"], Team = "Horde" },
--            { Region = 1421, Vendor = L["Lilly"], Team = "Horde" },
--         },
--      },
-- Lesser Wizard Oil not yet in game
--      {
--         ID = 20753,
--         Spell = 25126,
--         Item = 20746,
--         Type = L["Enchanting"],
--         Skill = 200,
--         Cost = 1000,
--         Locations = {
--            { Region = 1456, Vendor = L["Nata Dawnstrider"], Team = "Horde" },
--            { Region = 1421, Vendor = L["Lilly"], Team = "Horde" },
--            { Region = 1455, Vendor = L["Tilli Thistlefuzz"], Team = "Alliance" },
--            { Region = 1454, Vendor = L["Kithas"], Team = "Horde" },
--            { Region = 1458, Vendor = L["Thaddeus Webb"], Team = "Horde" },
--            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
--            { Region = 1457, Vendor = L["Vaean"], Team = "Alliance" },
--            { Region = 1453, Vendor = L["Jessara Cordell"], Team = "Alliance" },
--            { Region = 1421, Vendor = L["Leo Sarn"], Team = "Horde" },
--         },
--      },
      {
         ID = 20754,
         Spell = 25127,
         Item = 20747,
         Type = L["Enchanting"],
         Skill = 250,
         Cost = 2500,
         Locations = {
            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
         },
      },
      {
         ID = 20755,
         Spell = 25128,
         Item = 20750,
         Type = L["Enchanting"],
         Skill = 275,
         Cost = 5000,
         Locations = {
            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
         },
      },
      {
         ID = 19449,
         Spell = 23804,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 300,
         Cost = 100000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19448,
         Spell = 23803,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 300,
         Cost = 80000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 6,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19444,
         Spell = 23799,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 290,
         Cost = 30000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 5,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19445,
         Spell = 23800,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 290,
         Cost = 30000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 6,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19447,
         Spell = 23802,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 300,
         Cost = 60000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 19446,
         Spell = 23801,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 290,
         Cost = 30000,
         Faction = BFAC["Argent Dawn"],
         Level = 6,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 20756,
         Spell = 25129,
         Item = 20749,
         Type = L["Enchanting"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 20732,
         Spell = 25081,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 300,
         Cost = 100000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
         },
      },
      {
         ID = 20733,
         Spell = 25082,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 300,
         Cost = 100000,
         Faction = BFAC["Cenarion Circle"],
         Level = 6,
         Locations = {
            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
         },
      },
      {
         ID = 20757,
         Spell = 25130,
         Item = 20748,
         Type = L["Enchanting"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 5,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 22392,
         Spell = 27837,
         Item = 0,
         Type = L["Enchanting"],
         Skill = 290,
         Cost = 25000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 5,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
   },
},

[L["Engineering"]] = {
   Recipes = {
      {
         ID = 18649,
         Spell = 23067,
         Item = 9312,
         Type = L["Engineering"],
         Skill = 150,
         Cost = 1800,
         Locations = {
            { Region = 1453, Vendor = L["Darian Singh"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Gearcutter Cogspinner"], Team = "Alliance" },
         },
      },
      {
         ID = 10607,
         Spell = 12617,
         Item = 10506,
         Type = L["Engineering"],
         Skill = 230,
         Cost = 3600,
         Locations = {
            { Region = 1447, Vendor = L["Jubie Gadgetspring"], Team = "Neutral" },
         },
      },
      {
         ID = 7560,
         Spell= 9269,
         Item = 7506,
         Type = L["Engineering"],
         Skill = 125,
         Cost = 1200,
         Locations = {
            { Region = 1455, Vendor = L["Gearcutter Cogspinner"], Team = "Alliance" },
            { Region = 1441, Vendor = L["Jinky Twizzlefixxit"], Team = "Neutral" },
         },
      },
      {
         ID = 13309,
         Spell = 3939,
         Item = 4372,
         Type = L["Engineering"],
         Skill = 120,
         Cost = 1000,
         Locations = {
            { Region = 1437, Vendor = L["Fradd Swiftgear"], Team = "Alliance" },
            { Region = 1441, Vendor = L["Jinky Twizzlefixxit"], Team = "Neutral" },
         },
      },
      {
         ID = 14639,
         Spell = 3952,
         Item = 4381,
         Type = L["Engineering"],
         Skill = 140,
         Cost = 1500,
         Locations = {
            { Region = 1437, Vendor = L["Fradd Swiftgear"], Team = "Alliance" },
            { Region = 90, Vendor = L["Namdo Bizzfizzle"], Team = "Alliance" },
         },
      },
      {
         ID = 10609,
         Spell = 12624,
         Item = 10576,
         Type = L["Engineering"],
         Skill = 250,
         Cost = 4000,
         Locations = {
            { Region = 1425, Vendor = L["Ruppo Zipcoil"], Team = "Neutral" },
         },
      },
      {
         ID = 16041,
         Spell = 19790,
         Item = 15993,
         Type = L["Engineering"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1455, Vendor = L["Gearcutter Cogspinner"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Sovik"], Team = "Horde" },
         },
      },
      {
         ID = 16042,
         Spell = 19791,
         Item = 15994,
         Type = L["Engineering"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1455, Vendor = L["Gearcutter Cogspinner"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Sovik"], Team = "Horde" },
         },
      },
      {
         ID = 18647,
         Spell = 23066,
         Item = 9318,
         Type = L["Engineering"],
         Skill = 150,
         Cost = 1800,
         Locations = {
            { Region = 1454, Vendor = L["Sovik"], Team = "Horde" },
         },
      },
      {
         ID = 13310,
         Spell = 3979,
         Item = 4407,
         Type = L["Engineering"],
         Skill = 180,
         Cost = 2000,
         Locations = {
            { Region = 1434, Vendor = L["Mazk Snipeshot"], Team = "Neutral" },
         },
      },
      {
         ID = 10602,
         Spell = 12597,
         Item = 10546,
         Type = L["Engineering"],
         Skill = 210,
         Cost = 3000,
         Locations = {
            { Region = 1434, Vendor = L["Knaz Blunderflame"], Team = "Neutral" },
            { Region = 1428, Vendor = L["Yuka Screwspigot"], Team = "Neutral" },
         },
      },
      {
         ID = 16050,
         Spell = 19815,
         Item = 16006,
         Type = L["Engineering"],
         Skill = 285,
         Cost = 20000,
         Locations = {
            { Region = 1452, Vendor = L["Xizzer Fizzbolt"], Team = "Neutral" },
         },
      },
      {
         ID = 7742,
         Spell = 3971,
         Item = 4397,
         Type = L["Engineering"],
         Skill = 200,
         Cost = 2400,
         Locations = {
            { Region = 1424, Vendor = L["Zan Shivsproket"], Team = "Neutral" },
         },
      },
      {
         ID = 7561,
         Spell = 9273,
         Item = 7148,
         Type = L["Engineering"],
         Skill = 165,
         Cost = 2000,
         Locations = {
            { Region = 1431, Vendor = L["Kzixx"], Team = "Neutral" },
            { Region = 1442, Vendor = L["Veenix"], Team = "Neutral" },
            { Region = 1424, Vendor = L["Zixil"], Team = "Neutral" },
         },
      },
      {
         ID = 18648,
         Spell = 23068,
         Item = 9313,
         Type = L["Engineering"],
         Skill = 150,
         Cost = 1800,
         Locations = {
            { Region = 1434, Vendor = L["Crazk Sparks"], Team = "Neutral" },
            { Region = 1413, Vendor = L["Gagsprocket"], Team = "Neutral" },
         },
      },
      {
         ID = 18652,
         Spell = 23077,
         Item = 18634,
         Type = L["Engineering"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1452, Vendor = L["Xizzer Fizzbolt"], Team = "Neutral" },
         },
      },
      {
         ID = 13308,
         Spell = 3957,
         Item = 4386,
         Type = L["Engineering"],
         Skill = 155,
         Cost = 1800,
         Locations = {
            { Region = 1416, Vendor = L["Rizz Loosebolt"], Team = "Neutral" },
         },
      },
      {
         ID = 16046,
         Spell = 19814,
         Item = 16023,
         Type = L["Engineering"],
         Skill = 275,
         Cost = 16000,
         Locations = {
            { Region = 1452, Vendor = L["Xizzer Fizzbolt"], Team = "Neutral" },
         },
      },
      {
         ID = 13311,
         Spell = 3969,
         Item = 4396,
         Type = L["Engineering"],
         Skill = 200,
         Cost = 10000,
         Locations = {
            { Region = 1434, Vendor = L["Gnaz Blunderflame"], Team = "Neutral" },
         },
      },
      {
         ID = 18656,
         Spell = 23080,
         Item = 18594,
         Type = L["Engineering"],
         Skill = 275,
         Cost = 16000,
         Locations = {
            { Region = 1452, Vendor = L["Xizzer Fizzbolt"], Team = "Neutral" },
         },
      },
      {
         ID = 16047,
         Spell = 19795,
         Item = 16000,
         Type = L["Engineering"],
         Skill = 275,
         Cost = 16000,
         Locations = {
            { Region = 1452, Vendor = L["Xizzer Fizzbolt"], Team = "Neutral" },
         },
      },
      {
         ID = 18651,
         Spell = 23071,
         Item = 18631,
         Type = L["Engineering"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1434, Vendor = L["Mazk Snipeshot"], Team = "Neutral" },
         },
      },
      {
         ID = 20001,
         Spell = 24357,
         Item = 19998,
         Type = L["Engineering"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 5,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 20000,
         Spell = 24356,
         Item = 19999,
         Type = L["Engineering"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19027,
         Spell = 23507,
         Item = 19026,
         Type = L["Engineering"],
         Skill = 250,
         Cost = 5000,
         Locations = {
            { Region = 1444, Vendor = L["Zorbin Fandazzle"], Team = "Neutral" },
         },
      },
      {
         ID = 18650,
         Spell = 23069,
         Item = 18588,
         Type = L["Engineering"],
         Skill = 200,
         Cost = 5000,
         Locations = {
            { Region = 1446, Vendor = L["Blizrik Buckshot"], Team = "Neutral" },
         },
      },
   },
},

[L["Leatherworking"]] = {
   Recipes = {
      {
         ID = 18949,
         Spell = 23399,
         Item = 18948,
         Type = L["Leatherworking"],
         Skill = 155,
         Cost = 2000,
         Locations = {
            { Region = 1457, Vendor = L["Saenorion"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Joseph Moore"], Team = "Horde" },
         },
      },
      {
         ID = 5973,
         Spell = 7149,
         Item = 5963,
         Type = L["Leatherworking"],
         Skill = 170,
         Cost = 650,
         Locations = {
            { Region = 1417, Vendor = L["Hammon Karwn"], Team = "Alliance" },
            { Region = 1440, Vendor = L["Lardan"], Team = "Alliance" },
            { Region = 1441, Vendor = L["Jandia"], Team = "Horde" },
            { Region = 1417, Vendor = L["Keena"], Team = "Horde" },
         },
      },
      {
         ID = 7289,
         Spell = 9070,
         Item = 7283,
         Type = L["Leatherworking"],
         Skill = 100,
         Cost = 650,
         Locations = {
            { Region = 1433, Vendor = L["Clyde Ranthal"], Team = "Alliance" },
         },
      },
      {
         ID = 20576,
         Spell = 24940,
         Item = 20575,
         Type = L["Leatherworking"],
         Skill = 100,
         Cost = 350,
         Locations = {
            { Region = 1433, Vendor = L["Amy Davenport"], Team = "Alliance" },
         },
      },
      {
         ID = 15751,
         Spell = 19077,
         Item = 15048,
         Type = L["Leatherworking"],
         Skill = 285,
         Cost = 20000,
         Specialty = L["Dragonscale Leatherworking"],
         Locations = {
            { Region = 1447, Vendor = L["Blimo Gadgetspring"], Team = "Neutral" },
         },
      },
      {
         ID = 15729,
         Spell = 19053,
         Item = 15074,
         Type = L["Leatherworking"],
         Skill = 265,
         Cost = 12000,
         Specialty = L["Tribal Leatherworking"],
         Locations = {
            { Region = 1447, Vendor = L["Blimo Gadgetspring"], Team = "Neutral" },
         },
      },
      {
         ID = 7613,
         Spell = 3772,
         Item = 4255,
         Type = L["Leatherworking"],
         Skill = 155,
         Cost = 2000,
         Locations = {
            { Region = 1437, Vendor = L["Wenna Silkbeard"], Team = "Alliance" },
            { Region = 1424, Vendor = L["George Candarte"], Team = "Horde" },
         },
      },
      {
         ID = 7451,
         Spell = 9202,
         Item = 7386,
         Type = L["Leatherworking"],
         Skill = 190,
         Cost = 2800,
         Locations = {
            { Region = 1444, Vendor = L["Pratt McGrubben"], Team = "Alliance" },
            { Region = 1457, Vendor = L["Saenorion"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Jangdor Swiftstrider"], Team = "Horde" },
            { Region = 1458, Vendor = L["Joseph Moore"], Team = "Horde" },
         },
      },
      {
         ID = 18731,
         Spell = 23190,
         Item = 18662,
         Type = L["Leatherworking"],
         Skill = 150,
         Cost = 2000,
         Locations = {
            { Region = 1455, Vendor = L["Bombus Finespindle"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Tamar"], Team = "Horde" },
         },
      },
      {
         ID = 7361,
         Spell = 9146,
         Item = 7349,
         Type = L["Leatherworking"],
         Skill = 135,
         Cost = 1800,
         Locations = {
            { Region = 1440, Vendor = L["Harlown Darkweave"], Team = "Alliance" },
         },
      },
      {
         ID = 15735,
         Spell = 19062,
         Item = 15067,
         Type = L["Leatherworking"],
         Skill = 270,
         Cost = 14000,
         Specialty = L["Tribal Leatherworking"],
         Locations = {
            { Region = 1425, Vendor = L["Gigget Zipcoil"], Team = "Neutral" },
         },
      },
      {
         ID = 15734,
         Spell = 19061,
         Item = 15061,
         Type = L["Leatherworking"],
         Skill = 270,
         Cost = 14000,
         Specialty = L["Elemental Leatherworking"],
         Locations = {
            { Region = 1444, Vendor = L["Pratt McGrubben"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Jangdor Swiftstrider"], Team = "Horde" },
         },
      },
      {
         ID = 5786,
         Spell = 6702,
         Item = 5780,
         Type = L["Leatherworking"],
         Skill = 90,
         Cost = 550,
         Locations = {
            { Region = 1436, Vendor = L["Gina MacGregor"], Team = "Alliance" },
            { Region = 1439, Vendor = L["Mavralyn"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Andrew Hilbert"], Team = "Horde" },
         },
      },
      {
         ID = 5787,
         Spell = 6703,
         Item = 5781,
         Type = L["Leatherworking"],
         Skill = 95,
         Cost = 600,
         Locations = {
            { Region = 1436, Vendor = L["Gina MacGregor"], Team = "Alliance" },
            { Region = 1439, Vendor = L["Mavralyn"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Andrew Hilbert"], Team = "Horde" },
         },
      },
      {
         ID = 5789,
         Spell = 6705,
         Item = 5783,
         Type = L["Leatherworking"],
         Skill = 190,
         Cost = 2800,
         Locations = {
            { Region = 1445, Vendor = L["Helenia Olden"], Team = "Alliance" },
            { Region = 1434, Vendor = L["Blixrez Goodstitch"], Team = "Neutral" },
         },
      },
      {
         ID = 8409,
         Spell = 10516,
         Item = 8192,
         Type = L["Leatherworking"],
         Skill = 210,
         Cost = 4000,
         Locations = {
            { Region = 1425, Vendor = L["Nioma"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Jangdor Swiftstrider"], Team = "Horde" },
            { Region = 1444, Vendor = L["Worb Strongstitch"], Team = "Horde" },
         },
      },
      {
         ID = 13288,
         Spell = 4097,
         Item = 4456,
         Type = L["Leatherworking"],
         Skill = 165,
         Cost = 2500,
         Locations = {
            { Region = 1417, Vendor = L["Androd Fadran"], Team = "Alliance" },
         },
      },
      {
         ID = 7290,
         Spell = 9072,
         Item = 7284,
         Type = L["Leatherworking"],
         Skill = 120,
         Cost = 1600,
         Locations = {
            { Region = 1437, Vendor = L["Wenna Silkbeard"], Team = "Alliance" },
         },
      },
      {
         ID = 15741,
         Spell = 19067,
         Item = 15057,
         Type = L["Leatherworking"],
         Skill = 275,
         Cost = 16000,
         Specialty = L["Elemental Leatherworking"],
         Locations = {
            { Region = 1422, Vendor = L["Leonard Porter"], Team = "Alliance" },
            { Region = 1420, Vendor = L["Werg Thickblade"], Team = "Horde" },
         },
      },
      {
         ID = 5788,
         Spell = 6704,
         Item = 5782,
         Type = L["Leatherworking"],
         Skill = 170,
         Cost = 650,
         Locations = {
            { Region = 1424, Vendor = L["Micha Yance"], Team = "Alliance" },
            { Region = 1424, Vendor = L["Christoph Jeffcoat"], Team = "Horde" },
            { Region = 1434, Vendor = L["Blixrez Goodstitch"], Team = "Neutral" },
         },
      },
      {
         ID = 8385,
         Spell = 10509,
         Item = 8187,
         Type = L["Leatherworking"],
         Skill = 205,
         Cost = 3500,
         Locations = {
            { Region = 1444, Vendor = L["Pratt McGrubben"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Jangdor Swiftstrider"], Team = "Horde" },
         },
      },
      {
         ID = 15725,
         Spell = 19049,
         Item = 15083,
         Type = L["Leatherworking"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1422, Vendor = L["Leonard Porter"], Team = "Alliance" },
            { Region = 1420, Vendor = L["Werg Thickblade"], Team = "Horde" },
         },
      },
      {
         ID = 13287,
         Spell = 4096,
         Item = 4445,
         Type = L["Leatherworking"],
         Skill = 165,
         Cost = 2500,
         Locations = {
            { Region = 1417, Vendor = L["Tunkk"], Team = "Horde" },
         },
      },
      {
         ID = 6474,
         Spell = 7953,
         Item = 6466,
         Type = L["Leatherworking"],
         Skill = 90,
         Cost = 550,
         Locations = {
            { Region = 43, Vendor = L["Kalldan Felmoon"], Team = "Neutral" },
         },
      },
      {
         ID = 6475,
         Spell = 7954,
         Item = 6467,
         Type = L["Leatherworking"],
         Skill = 105,
         Cost = 1500,
         Locations = {
            { Region = 43, Vendor = L["Kalldan Felmoon"], Team = "Neutral" },
         },
      },
      {
         ID = 15758,
         Spell = 19084,
         Item = 15063,
         Type = L["Leatherworking"],
         Skill = 290,
         Cost = 22000,
         Specialty = L["Tribal Leatherworking"],
         Locations = {
            { Region = 1449, Vendor = L["Nergal"], Team = "Neutral" },
         },
      },
      {
         ID = 7362,
         Spell = 9147,
         Item = 7352,
         Type = L["Leatherworking"],
         Skill = 135,
         Cost = 2000,
         Locations = {
            { Region = 1424, Vendor = L["Zixil"], Team = "Neutral" },
         },
      },
      {
         ID = 15740,
         Spell = 19066,
         Item = 15071,
         Type = L["Leatherworking"],
         Skill = 275,
         Cost = 16000,
         Specialty = L["Tribal Leatherworking"],
         Locations = {
            { Region = 1452, Vendor = L["Qia"], Team = "Neutral" },
         },
      },
      {
         ID = 14635,
         Spell = 3778,
         Item = 4262,
         Type = L["Leatherworking"],
         Skill = 185,
         Cost = 3000,
         Locations = {
            { Region = 1434, Vendor = L["Rikqiz"], Team = "Neutral" },
         },
      },
      {
         ID = 15726,
         Spell = 19050,
         Item = 15045,
         Type = L["Leatherworking"],
         Skill = 260,
         Cost = 12000,
         Specialty = L["Dragonscale Leatherworking"],
         Locations = {
            { Region = 1435, Vendor = L["Masat T'andr"], Team = "Neutral" },
         },
      },
      {
         ID = 15724,
         Spell = 19048,
         Item = 15077,
         Type = L["Leatherworking"],
         Skill = 255,
         Cost = 12000,
         Locations = {
            { Region = 1451, Vendor = L["Zannok Hidepiercer"], Team = "Neutral" },
         },
      },
      {
         ID = 15762,
         Spell = 19088,
         Item = 15080,
         Type = L["Leatherworking"],
         Skill = 295,
         Cost = 25000,
         Locations = {
            { Region = 1451, Vendor = L["Zannok Hidepiercer"], Team = "Neutral" },
         },
      },
      {
         ID = 15756,
         Spell = 19082,
         Item = 15094,
         Type = L["Leatherworking"],
         Skill = 290,
         Cost = 22000,
         Locations = {
            { Region = 1423, Vendor = L["Jase Farlane"], Team = "Neutral" },
         },
      },
      {
         ID = 18239,
         Spell = 22711,
         Item = 18238,
         Type = L["Leatherworking"],
         Skill = 200,
         Cost = 3500,
         Locations = {
            { Region = 1434, Vendor = L["Rikqiz"], Team = "Neutral" },
         },
      },
      {
         ID = 15759,
         Spell = 19085,
         Item = 15050,
         Type = L["Leatherworking"],
         Skill = 290,
         Cost = 22000,
         Locations = {
            { Region = 230, Vendor = L["Plugger Spazzring"], Team = "Neutral" },
         },
      },
      {
         ID = 17025,
         Spell = 20855,
         Item = 16984,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 160000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 6,
         Specialty = L["Dragonscale Leatherworking"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19331,
         Spell = 23708,
         Item = 19157,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 90000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Specialty = L["Dragonscale Leatherworking"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19332,
         Spell = 23709,
         Item = 19162,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 90000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17022,
         Spell = 20853,
         Item = 16982,
         Type = L["Leatherworking"],
         Skill = 295,
         Cost = 150000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 5,
         Specialty = L["Tribal Leatherworking"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19330,
         Spell = 23707,
         Item = 19149,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 60000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19333,
         Spell = 23710,
         Item = 19163,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 90000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Specialty = L["Elemental Leatherworking"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17023,
         Spell = 20854,
         Item = 16983,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 160000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 5,
         Specialty = L["Elemental Leatherworking"],
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 20253,
         Spell = 19068,
         Item = 15064,
         Type = L["Leatherworking"],
         Skill = 275,
         Cost = 16000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 5,
         Specialty = L["Tribal Leatherworking"],
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 20254,
         Spell = 19080,
         Item = 15065,
         Type = L["Leatherworking"],
         Skill = 285,
         Cost = 20000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 5,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19327,
         Spell = 23704,
         Item = 19049,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 7,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19326,
         Spell = 23703,
         Item = 19044,
         Type = L["Leatherworking"],
         Skill = 290,
         Cost = 22000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 6,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19328,
         Spell = 23705,
         Item = 19052,
         Type = L["Leatherworking"],
         Skill = 290,
         Cost = 22000,
         Faction = BFAC["Argent Dawn"],
         Level = 6,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 19329,
         Spell = 23706,
         Item = 19058,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 19771,
         Spell = 24123,
         Item = 19687,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 5,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19773,
         Spell = 24125,
         Item = 19689,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19770,
         Spell = 24122,
         Item = 19686,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19772,
         Spell = 24124,
         Item = 19688,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 7,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19769,
         Spell = 24121,
         Item = 19685,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 7,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 20382,
         Spell = 24703,
         Item = 20380,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 60000,
         Faction = BFAC["Cenarion Circle"],
         Level = 8,
         Specialty = L["Dragonscale Leatherworking"],
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 20506,
         Spell = 24846,
         Item = 20481,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 20507,
         Spell = 24847,
         Item = 20480,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Cenarion Circle"],
         Level = 6,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 20508,
         Spell = 24848,
         Item = 20479,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Cenarion Circle"],
         Level = 7,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 20509,
         Spell = 24849,
         Item = 20476,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 20510,
         Spell = 24850,
         Item = 20477,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Cenarion Circle"],
         Level = 6,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 20511,
         Spell = 24851,
         Item = 20478,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Cenarion Circle"],
         Level = 7,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 22769,
         Spell = 28474,
         Item = 22761,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 22770,
         Spell = 28473,
         Item = 22760,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 6,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 22771,
         Spell = 28472,
         Item = 22759,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 7,
         Locations = {
            { Region = 1451, Vendor = L["Aendel Windspear"], Team = "Neutral" },
         },
      },
      {
         ID = 22695,
         Spell = 28221,
         Item = 22663,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Hydraxian Waterlords"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22694,
         Spell = 28220,
         Item = 22662,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22692,
         Spell = 28219,
         Item = 22661,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Argent Dawn"],
         Level = 8,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22698,
         Spell = 28224,
         Item = 22665,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Hydraxian Waterlords"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22697,
         Spell = 28223,
         Item = 22666,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22696,
         Spell = 28222,
         Item = 22664,
         Type = L["Leatherworking"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Argent Dawn"],
         Level = 8,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
   },
},

[L["Tailoring"]] = {
   Recipes = {
      {
         ID = 7089,
         Spell = 8786,
         Item = 7053,
         Type = L["Tailoring"],
         Skill = 175,
         Cost = 1500,
         Locations = {
            { Region = 1444, Vendor = L["Brienna Starglow"], Team = "Alliance" },
            { Region = 1417, Vendor = L["Jun'ha"], Team = "Horde" },
         },
      },
      {
         ID = 7114,
         Spell = 3854,
         Item = 4319,
         Type = L["Tailoring"],
         Skill = 145,
         Cost = 1000,
         Locations = {
            { Region = 1437, Vendor = L["Wenna Silkbeard"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Kireena"], Team = "Horde" },
         },
      },
      {
         ID = 6272,
         Spell = 7633,
         Item = 6242,
         Type = L["Tailoring"],
         Skill = 70,
         Cost = 300,
         Locations = {
            { Region = 1429, Vendor = L["Drake Lindgren"], Team = "Alliance" },
            { Region = 1457, Vendor = L["Elynna"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Andrew Hilbert"], Team = "Horde" },
            { Region = 1413, Vendor = L["Wrahk"], Team = "Horde" },
            { Region = 1413, Vendor = L["Ranik"], Team = "Neutral" },
         },
      },
      {
         ID = 6270,
         Spell = 7630,
         Item = 6240,
         Type = L["Tailoring"],
         Skill = 55,
         Cost = 200,
         Locations = {
            { Region = 1429, Vendor = L["Tharynn Bouden"], Team = "Alliance" },
            { Region = 1439, Vendor = L["Valdaron"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Borya"], Team = "Horde" },
            { Region = 1420, Vendor = L["Constance Brisboise"], Team = "Horde" },
            { Region = 1413, Vendor = L["Wrahk"], Team = "Horde" },
         },
      },
      {
         ID = 6274,
         Spell = 7639,
         Item = 6263,
         Type = L["Tailoring"],
         Skill = 100,
         Cost = 400,
         Locations = {
            { Region = 1436, Vendor = L["Gina MacGregor"], Team = "Alliance" },
            { Region = 1453, Vendor = L["Alexandra Bolero"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Borya"], Team = "Horde" },
            { Region = 1424, Vendor = L["Mallen Swain"], Team = "Horde" },
            { Region = 1413, Vendor = L["Yonada"], Team = "Horde" },
         },
      },
      {
         ID = 14627,
         Spell = 3869,
         Item = 4332,
         Type = L["Tailoring"],
         Skill = 135,
         Cost = 800,
         Locations = {
            { Region = 1431, Vendor = L["Danielle Zipstitch"], Team = "Alliance" },
         },
      },
      {
         ID = 6401,
         Spell = 3870,
         Item = 4333,
         Type = L["Tailoring"],
         Skill = 155,
         Cost = 1100,
         Locations = {
            { Region = 1431, Vendor = L["Sheri Zipstitch"], Team = "Alliance" },
            { Region = 1424, Vendor = L["Mallen Swain"], Team = "Horde" },
         },
      },
      {
         ID = 6275,
         Spell = 7643,
         Item = 6264,
         Type = L["Tailoring"],
         Skill = 115,
         Cost = 800,
         Locations = {
            { Region = 1457, Vendor = L["Elynna"], Team = "Alliance" },
            { Region = 1437, Vendor = L["Jennabink Powerseam"], Team = "Alliance" },
            { Region = 1432, Vendor = L["Rann Flamespinner"], Team = "Alliance" },
            { Region = 1431, Vendor = L["Sheri Zipstitch"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Millie Gregorian"], Team = "Horde" },
            { Region = 1413, Vendor = L["Ranik"], Team = "Neutral" },
         },
      },
      {
         ID = 4355,
         Spell = 3862,
         Item = 4327,
         Type = L["Tailoring"],
         Skill = 200,
         Cost = 1500,
         Locations = {
            { Region = 1424, Vendor = L["Micha Yance"], Team = "Alliance" },
            { Region = 1445, Vendor = L["Ghok'kah"], Team = "Horde" },
         },
      },
      {
         ID = 10314,
         Spell = 12075,
         Item = 10054,
         Type = L["Tailoring"],
         Skill = 230,
         Cost = 4000,
         Locations = {
            { Region = 1455, Vendor = L["Outfitter Eric"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Borya"], Team = "Horde" },
         },
      },
      {
         ID = 10311,
         Spell = 12064,
         Item = 10052,
         Type = L["Tailoring"],
         Skill = 220,
         Cost = 3000,
         Locations = {
            { Region = 1457, Vendor = L["Elynna"], Team = "Alliance" },
            { Region = 1456, Vendor = L["Mahu"], Team = "Horde" },
         },
      },
      {
         ID = 10317,
         Spell = 12080,
         Item = 10055,
         Type = L["Tailoring"],
         Skill = 235,
         Cost = 4000,
         Locations = {
            { Region = 1455, Vendor = L["Outfitter Eric"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Borya"], Team = "Horde" },
         },
      },
      {
         ID = 5771,
         Spell = 6686,
         Item = 5762,
         Type = L["Tailoring"],
         Skill = 70,
         Cost = 200,
         Locations = {
            { Region = 1436, Vendor = L["Gina MacGregor"], Team = "Alliance" },
            { Region = 1439, Vendor = L["Valdaron"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Andrew Hilbert"], Team = "Horde" },
            { Region = 1456, Vendor = L["Mahu"], Team = "Horde" },
         },
      },
      {
         ID = 5772,
         Spell = 6688,
         Item = 5763,
         Type = L["Tailoring"],
         Skill = 115,
         Cost = 500,
         Locations = {
            { Region = 1433, Vendor = L["Amy Davenport"], Team = "Alliance" },
            { Region = 1437, Vendor = L["Jennabink Powerseam"], Team = "Alliance" },
            { Region = 1432, Vendor = L["Rann Flamespinner"], Team = "Alliance" },
            { Region = 1439, Vendor = L["Valdaron"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Borya"], Team = "Horde" },
            { Region = 1456, Vendor = L["Mahu"], Team = "Horde" },
            { Region = 1458, Vendor = L["Millie Gregorian"], Team = "Horde" },
            { Region = 1413, Vendor = L["Wrahk"], Team = "Horde" },
            { Region = 1413, Vendor = L["Yonada"], Team = "Horde" },
            { Region = 1413, Vendor = L["Kiknikle"], Team = "Neutral" },
            { Region = 1424, Vendor = L["Zixil"], Team = "Neutral" },
         },
      },
      {
         ID = 10326,
         Spell = 12093,
         Item = 10036,
         Type = L["Tailoring"],
         Skill = 250,
         Cost = 5000,
         Locations = {
            { Region = 1455, Vendor = L["Outfitter Eric"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Millie Gregorian"], Team = "Horde" },
         },
      },
      {
         ID = 10323,
         Spell = 12089,
         Item = 10035,
         Type = L["Tailoring"],
         Skill = 245,
         Cost = 4500,
         Locations = {
            { Region = 1455, Vendor = L["Outfitter Eric"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Millie Gregorian"], Team = "Horde" },
         },
      },
      {
         ID = 10321,
         Spell = 12085,
         Item = 10034,
         Type = L["Tailoring"],
         Skill = 240,
         Cost = 4500,
         Locations = {
            { Region = 1455, Vendor = L["Outfitter Eric"], Team = "Alliance" },
            { Region = 1458, Vendor = L["Millie Gregorian"], Team = "Horde" },
         },
      },
      {
         ID = 10325,
         Spell = 12091,
         Item = 10040,
         Type = L["Tailoring"],
         Skill = 250,
         Cost = 10000,
         Locations = {
            { Region = 1453, Vendor = L["Alexandra Bolero"], Team = "Alliance" },
            { Region = 1456, Vendor = L["Mahu"], Team = "Horde" },
         },
      },
      {
         ID = 10318,
         Spell = 12081,
         Item = 10030,
         Type = L["Tailoring"],
         Skill = 240,
         Cost = 7000,
         Locations = {
            { Region = 1434, Vendor = L["Cowardly Crosby"], Team = "Neutral" },
         },
      },
      {
         ID = 10728,
         Spell = 3873,
         Item = 4336,
         Type = L["Tailoring"],
         Skill = 200,
         Cost = 1500,
         Locations = {
            { Region = 1434, Vendor = L["Narkk"], Team = "Neutral" },
         },
      },
      {
         ID = 7087,
         Spell = 8789,
         Item = 7056,
         Type = L["Tailoring"],
         Skill = 180,
         Cost = 1200,
         Locations = {
            { Region = 1434, Vendor = L["Xizk Goodstitch"], Team = "Neutral" },
         },
      },
      {
         ID = 7088,
         Spell = 8802,
         Item = 7063,
         Type = L["Tailoring"],
         Skill = 205,
         Cost = 5000,
         Locations = {
            { Region = 1446, Vendor = L["Vizzklick"], Team = "Neutral" },
         },
      },
      {
         ID = 14630,
         Spell = 3857,
         Item = 4322,
         Type = L["Tailoring"],
         Skill = 165,
         Cost = 1000,
         Locations = {
            { Region = 1434, Vendor = L["Xizk Goodstitch"], Team = "Neutral" },
         },
      },
      {
         ID = 14483,
         Spell = 18419,
         Item = 14107,
         Type = L["Tailoring"],
         Skill = 275,
         Cost = 16000,
         Locations = {
            { Region = 1450, Vendor = L["Lorelae Wintersong"], Team = "Neutral" },
         },
      },
      {
         ID = 14526,
         Spell = 18560,
         Item = 14342,
         Type = L["Tailoring"],
         Skill = 250,
         Cost = 20000,
         Locations = {
            { Region = 1452, Vendor = L["Qia"], Team = "Neutral" },
            { Region = 1452, Vendor = L["Evie Whirlbrew"], Team = "Neutral" },
         },
      },
      {
         ID = 14468,
         Spell = 18405,
         Item = 14046,
         Type = L["Tailoring"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1452, Vendor = L["Qia"], Team = "Neutral" },
         },
      },
      {
         ID = 14488,
         Spell = 18423,
         Item = 13864,
         Type = L["Tailoring"],
         Skill = 280,
         Cost = 12000,
         Locations = {
            { Region = 1450, Vendor = L["Darnall"], Team = "Neutral" },
         },
      },
      {
         ID = 14472,
         Spell = 18409,
         Item = 13860,
         Type = L["Tailoring"],
         Skill = 265,
         Cost = 12000,
         Locations = {
            { Region = 1450, Vendor = L["Darnall"], Team = "Neutral" },
         },
      },
      {
         ID = 14481,
         Spell = 18417,
         Item = 13863,
         Type = L["Tailoring"],
         Skill = 275,
         Cost = 16000,
         Locations = {
            { Region = 1452, Vendor = L["Qia"], Team = "Neutral" },
         },
      },
      {
         ID = 14469,
         Spell = 18406,
         Item = 13858,
         Type = L["Tailoring"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1450, Vendor = L["Darnall"], Team = "Neutral" },
         },
      },
      {
         ID = 18487,
         Spell = 22902,
         Item = 18486,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 40000,
         Locations = {
            { Region = 429, Vendor = L["Shen'dralar Provisioner"], Team = "Neutral" },
         },
      },
      {
         ID = 17018,
         Spell = 20849,
         Item = 16979,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 80000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 5,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19220,
         Spell = 23667,
         Item = 19165,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 90000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 7,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 17017,
         Spell = 20848,
         Item = 16980,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 180000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 6,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19219,
         Spell = 23666,
         Item = 19156,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 60000,
         Faction = BFAC["Thorium Brotherhood"],
         Level = 6,
         Locations = {
            { Region = 230, Vendor = L["Lokhtos Darkbargainer"], Team = "Neutral" },
         },
      },
      {
         ID = 19215,
         Spell = 23662,
         Item = 19047,
         Type = L["Tailoring"],
         Skill = 290,
         Cost = 22000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 6,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19218,
         Spell = 23663,
         Item = 19050,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Timbermaw Hold"],
         Level = 7,
         Locations = {
            { Region = 1448, Vendor = L["Meilosh"], Team = "Neutral" },
         },
      },
      {
         ID = 19216,
         Spell = 23664,
         Item = 19056,
         Type = L["Tailoring"],
         Skill = 290,
         Cost = 22000,
         Faction = BFAC["Argent Dawn"],
         Level = 6,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 19217,
         Spell = 23665,
         Item = 19059,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 40000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
      {
         ID = 19766,
         Spell = 24093,
         Item = 19684,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 5,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19765,
         Spell = 24092,
         Item = 19683,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 6,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 19764,
         Spell = 24091,
         Item = 19682,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Zandalar Tribe"],
         Level = 7,
         Locations = {
            { Region = 1434, Vendor = L["Rin'wosho the Trader"], Team = "Neutral" },
         },
      },
      {
         ID = 21358,
         Spell = 26085,
         Item = 21340,
         Type = L["Tailoring"],
         Skill = 260,
         Cost = 12000,
         Locations = {
            { Region = 1446, Vendor = L["Vizzklick"], Team = "Neutral" },
         },
      },
      {
         ID = 22307,
         Spell = 27568,
         Item = 22246,
         Type = L["Tailoring"],
         Skill = 225,
         Cost = 6000,
         Locations = {
            { Region = 1457, Vendor = L["Vaean"], Team = "Alliance" },
            { Region = 1453, Vendor = L["Jessara Cordell"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Leo Sarn"], Team = "Horde" },
            { Region = 1456, Vendor = L["Nata Dawnstrider"], Team = "Horde" },
            { Region = 1458, Vendor = L["Thaddeus Webb"], Team = "Horde" },
            { Region = 1454, Vendor = L["Kithas"], Team = "Horde" },
            { Region = 1455, Vendor = L["Tilli Thistlefuzz"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Lilly"], Team = "Horde" },
            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
         },
      },
      {
         ID = 22308,
         Spell = 27569,
         Item = 22248,
         Type = L["Tailoring"],
         Skill = 275,
         Cost = 20000,
         Locations = {
            { Region = 1451, Vendor = L["Kania"], Team = "Neutral" },
         },
      },
      {
         ID = 22312,
         Spell = 27725,
         Item = 22252,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 7,
         Locations = {
            { Region = 1451, Vendor = L["Mishta"], Team = "Neutral" },
         },
      },
      {
         ID = 22310,
         Spell = 27724,
         Item = 22251,
         Type = L["Tailoring"],
         Skill = 275,
         Cost = 20000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Mishta"], Team = "Neutral" },
         },
      },
      {
         ID = 22683,
         Spell = 28210,
         Item = 22660,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 90000,
         Faction = BFAC["Cenarion Circle"],
         Level = 7,
         Locations = {
            { Region = 1451, Vendor = L["Mishta"], Team = "Neutral" },
         },
      },
      {
         ID = 22772,
         Spell = 28482,
         Item = 22758,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 5,
         Locations = {
            { Region = 1451, Vendor = L["Mishta"], Team = "Neutral" },
         },
      },
      {
         ID = 22773,
         Spell = 28481,
         Item = 22757,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 6,
         Locations = {
            { Region = 1451, Vendor = L["Mishta"], Team = "Neutral" },
         },
      },
      {
         ID = 22774,
         Spell = 28480,
         Item = 22756,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 50000,
         Faction = BFAC["Cenarion Circle"],
         Level = 7,
         Locations = {
            { Region = 1451, Vendor = L["Mishta"], Team = "Neutral" },
         },
      },
      {
         ID = 22687,
         Spell = 28209,
         Item = 22655,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 120000,
         Faction = BFAC["Hydraxian Waterlords"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22684,
         Spell = 28205,
         Item = 22654,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 120000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 533 , Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22686,
         Spell = 28207,
         Item = 22652,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 150000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
      {
         ID = 22685,
         Spell = 28208,
         Item = 22658,
         Type = L["Tailoring"],
         Skill = 300,
         Cost = 120000,
         Faction = BFAC["Argent Dawn"],
         Level = 7,
         Locations = {
            { Region = 533, Vendor = L["Master Craftsman Omarion"], Team = "Neutral" },
         },
      },
   },
},

[L["Cooking"]] = {
   Recipes = {
      {
         ID = 16072,
         Spell = 3413,
         Item = 0,
         Type = L["Cooking"],
         Skill = 125,
         Cost = 10000,
         Locations = {
            { Region = 1440, Vendor = L["Shandrina"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Wulan"], Team = "Horde" },
         },
      },
      {
         ID = 13949,
         Spell = 18247,
         Item = 13935,
         Type = L["Cooking"],
         Skill = 275,
         Cost = 20000,
         Locations = {
            { Region = 1444, Vendor = L["Vivianna"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Sheendra Tallgrass"], Team = "Horde" },
         },
      },
      {
         ID = 4609,
         Spell = 4094,
         Item = 4457,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 1000,
         Locations = {
            { Region = 1417, Vendor = L["Narj Deepslice"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Super-Seller 680"], Team = "Neutral" },
         },
      },
      {
         ID = 2889,
         Spell = 2795,
         Item = 2888,
         Type = L["Cooking"],
         Skill = 25,
         Cost = 240,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 3734,
         Spell = 3397,
         Item = 3726,
         Type = L["Cooking"],
         Skill = 110,
         Cost = 1600,
         Locations = {
            { Region = 1440, Vendor = L["Ulthaan"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Super-Seller 680"], Team = "Neutral" },
         },
      },
      {
         ID = 3679,
         Spell = 3371,
         Item = 3220,
         Type = L["Cooking"],
         Skill = 60,
         Cost = 400,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 6325,
         Spell = 7751,
         Item = 6290,
         Type = L["Cooking"],
         Skill = 1,
         Cost = 40,
         Locations = {
            { Region = 1453, Vendor = L["Catherine Leland"], Team = "Alliance" },
            { Region = 1426, Vendor = L["Gretta Ganter"], Team = "Alliance" },
            { Region = 1432, Vendor = L["Khara Deepwater"], Team = "Alliance" },
            { Region = 1438, Vendor = L["Nyoma"], Team = "Alliance" },
            { Region = 1429, Vendor = L["Tharynn Bouden"], Team = "Alliance" },
            { Region = 1412, Vendor = L["Harn Longcast"], Team = "Horde" },
            { Region = 1420, Vendor = L["Martine Tramblay"], Team = "Horde" },
            { Region = 1456, Vendor = L["Sewa Mistrunner"], Team = "Horde" },
            { Region = 1458, Vendor = L["Lizbeth Cromwell"], Team = "Horde" },
         },
      },
      {
         ID = 6330,
         Spell = 7755,
         Item = 4593,
         Type = L["Cooking"],
         Skill = 100,
         Cost = 1200,
         Locations = {
            { Region = 1453, Vendor = L["Catherine Leland"], Team = "Alliance" },
            { Region = 1424, Vendor = L["Lindea Rabonne"], Team = "Alliance" },
            { Region = 1424, Vendor = L["Derak Nightfall"], Team = "Horde" },
            { Region = 1456, Vendor = L["Naal Mistrunner"], Team = "Horde" },
            { Region = 1456, Vendor = L["Sewa Mistrunner"], Team = "Horde" },
            { Region = 1458, Vendor = L["Ronald Burch"], Team = "Horde" },
            { Region = 1413, Vendor = L["Kilxx"], Team = "Neutral" },
         },
      },
      {
         ID = 5528,
         Spell = 6501,
         Item = 5526,
         Type = L["Cooking"],
         Skill = 90,
         Cost = 800,
         Locations = {
            { Region = 1439, Vendor = L["Heldan Galesong"], Team = "Alliance" },
            { Region = 1436, Vendor = L["Kriggon Talsone"], Team = "Alliance" },
         },
      },
      {
         ID = 2698,
         Spell = 2545,
         Item = 2682,
         Type = L["Cooking"],
         Skill = 85,
         Cost = 400,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 3681,
         Spell = 3373,
         Item = 3664,
         Type = L["Cooking"],
         Skill = 120,
         Cost = 1600,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 3678,
         Spell = 3370,
         Item = 3662,
         Type = L["Cooking"],
         Skill = 80,
         Cost = 400,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 3682,
         Spell = 3376,
         Item = 3665,
         Type = L["Cooking"],
         Skill = 130,
         Cost = 1600,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
            { Region = 1417, Vendor = L["Keena"], Team = "Horde" },
            { Region = 1434, Vendor = L["Nerrist"], Team = "Horde" },
         },
      },
      {
         ID = 12239,
         Spell = 15906,
         Item = 12217,
         Type = L["Cooking"],
         Skill = 200,
         Cost = 7000,
         Locations = {
            { Region = 1445, Vendor = L["Helenia Olden"], Team = "Alliance" },
            { Region = 1445, Vendor = L["Ogg'marr"], Team = "Horde" },
            { Region = 1443, Vendor = L["Super-Seller 680"], Team = "Neutral" },
         },
      },
      {
         ID = 5485,
         Spell = 6415,
         Item = 5476,
         Type = L["Cooking"],
         Skill = 50,
         Cost = 400,
         Locations = {
            { Region = 1439, Vendor = L["Laird"], Team = "Alliance" },
         },
      },
      {
         ID = 3683,
         Spell = 3377,
         Item = 3666,
         Type = L["Cooking"],
         Skill = 110,
         Cost = 1600,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 2697,
         Spell = 2542,
         Item = 724,
         Type = L["Cooking"],
         Skill = 50,
         Cost = 400,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 12240,
         Spell = 15910,
         Item = 12215,
         Type = L["Cooking"],
         Skill = 200,
         Cost = 7000,
         Locations = {
            { Region = 1443, Vendor = L["Janet Hommers"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Kireena"], Team = "Horde" },
            { Region = 1443, Vendor = L["Vendor-Tron 1000"], Team = "Neutral" },
         },
      },
      {
         ID = 20075,
         Spell = 24418,
         Item = 20074,
         Type = L["Cooking"],
         Skill = 150,
         Cost = 2000,
         Locations = {
            { Region = 1445, Vendor = L["Ogg'marr"], Team = "Horde" },
         },
      },
      {
         ID = 3735,
         Spell = 3398,
         Item = 3727,
         Type = L["Cooking"],
         Skill = 125,
         Cost = 1800,
         Locations = {
            { Region = 1413, Vendor = L["Zargh"], Team = "Horde" },
            { Region = 1443, Vendor = L["Vendor-Tron 1000"], Team = "Neutral" },
         },
      },
      {
         ID = 12229,
         Spell = 15856,
         Item = 13851,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 5000,
         Locations = {
            { Region = 1444, Vendor = L["Vivianna"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Sheendra Tallgrass"], Team = "Horde" },
            { Region = 1443, Vendor = L["Super-Seller 680"], Team = "Neutral" },
         },
      },
      {
         ID = 12231,
         Spell = 15861,
         Item = 12212,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 3000,
         Locations = {
            { Region = 1434, Vendor = L["Corporal Bluth"], Team = "Alliance" },
            { Region = 1434, Vendor = L["Nerrist"], Team = "Horde" },
            { Region = 1443, Vendor = L["Vendor-Tron 1000"], Team = "Neutral" },
         },
      },
      {
         ID = 5489,
         Spell = 6419,
         Item = 5480,
         Type = L["Cooking"],
         Skill = 110,
         Cost = 1200,
         Locations = {
            { Region = 1440, Vendor = L["Ulthaan"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Vendor-Tron 1000"], Team = "Neutral" },
         },
      },
      {
         ID = 13947,
         Spell = 18245,
         Item = 13933,
         Type = L["Cooking"],
         Skill = 275,
         Cost = 20000,
         Locations = {
            { Region = 1444, Vendor = L["Vivianna"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Sheendra Tallgrass"], Team = "Horde" },
         },
      },
      {
         ID = 6329,
         Spell = 7754,
         Item = 6316,
         Type = L["Cooking"],
         Skill = 50,
         Cost = 400,
         Locations = {
            { Region = 1432, Vendor = L["Khara Deepwater"], Team = "Alliance" },
         },
      },
      {
         ID = 6328,
         Spell = 7753,
         Item = 4592,
         Type = L["Cooking"],
         Skill = 50,
         Cost = 400,
         Locations = {
            { Region = 1432, Vendor = L["Khara Deepwater"], Team = "Alliance" },
            { Region = 1438, Vendor = L["Nyoma"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Tansy Puddlefizz"], Team = "Alliance" },
            { Region = 1429, Vendor = L["Tharynn Bouden"], Team = "Alliance" },
            { Region = 1412, Vendor = L["Harn Longcast"], Team = "Horde" },
            { Region = 1421, Vendor = L["Killian Sanatha"], Team = "Horde" },
            { Region = 1456, Vendor = L["Naal Mistrunner"], Team = "Horde" },
            { Region = 1458, Vendor = L["Lizbeth Cromwell"], Team = "Horde" },
         },
      },
      {
         ID = 13948,
         Spell = 18246,
         Item = 13934,
         Type = L["Cooking"],
         Skill = 275,
         Cost = 20000,
         Locations = {
            { Region = 1444, Vendor = L["Vivianna"], Team = "Alliance" },
            { Region = 1444, Vendor = L["Sheendra Tallgrass"], Team = "Horde" },
         },
      },
      {
         ID = 17062,
         Spell = 20916,
         Item = 8364,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 2200,
         Locations = {
            { Region = 1439, Vendor = L["Heldan Galesong"], Team = "Alliance" },
            { Region = 1424, Vendor = L["Lindea Rabonne"], Team = "Alliance" },
            { Region = 1437, Vendor = L["Stuart Fleming"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Tansy Puddlefizz"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Shankys"], Team = "Horde" },
            { Region = 1440, Vendor = L["Wik'Tar"], Team = "Horde" },
            { Region = 1443, Vendor = L["Wulan"], Team = "Horde" },
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
            { Region = 1458, Vendor = L["Lizbeth Cromwell"], Team = "Horde" },
         },
      },
      {
         ID = 3680,
         Spell = 3372,
         Item = 3663,
         Type = L["Cooking"],
         Skill = 90,
         Cost = 1600,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 12233,
         Spell = 15865,
         Item = 12214,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 3000,
         Locations = {
            { Region = 1445, Vendor = L["Helenia Olden"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Janet Hommers"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Super-Seller 680"], Team = "Neutral" },
         },
      },
      {
         ID = 6368,
         Spell = 7827,
         Item = 5095,
         Type = L["Cooking"],
         Skill = 50,
         Cost = 400,
         Locations = {
            { Region = 1453, Vendor = L["Catherine Leland"], Team = "Alliance" },
            { Region = 1439, Vendor = L["Heldan Galesong"], Team = "Alliance" },
            { Region = 1436, Vendor = L["Kriggon Talsone"], Team = "Alliance" },
            { Region = 1438, Vendor = L["Nessa Shadowsong"], Team = "Alliance" },
            { Region = 1437, Vendor = L["Stuart Fleming"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Killian Sanatha"], Team = "Horde" },
            { Region = 1454, Vendor = L["Shankys"], Team = "Horde" },
            { Region = 1411, Vendor = L["Zansoa"], Team = "Horde" },
            { Region = 1458, Vendor = L["Ronald Burch"], Team = "Horde" },
            { Region = 1413, Vendor = L["Kilxx"], Team = "Neutral" },
         },
      },
      {
         ID = 2699,
         Spell = 2547,
         Item = 1082,
         Type = L["Cooking"],
         Skill = 100,
         Cost = 800,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 12228,
         Spell = 15855,
         Item = 12210,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 5000,
         Locations = {
            { Region = 1434, Vendor = L["Corporal Bluth"], Team = "Alliance" },
            { Region = 1417, Vendor = L["Hammon Karwn"], Team = "Alliance" },
            { Region = 1445, Vendor = L["Helenia Olden"], Team = "Alliance" },
            { Region = 1417, Vendor = L["Keena"], Team = "Horde" },
            { Region = 1434, Vendor = L["Nerrist"], Team = "Horde" },
            { Region = 1445, Vendor = L["Ogg'marr"], Team = "Horde" },
            { Region = 1443, Vendor = L["Vendor-Tron 1000"], Team = "Neutral" },
         },
      },
      {
         ID = 6369,
         Spell = 7828,
         Item = 4594,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 2200,
         Locations = {
            { Region = 1439, Vendor = L["Heldan Galesong"], Team = "Alliance" },
            { Region = 1424, Vendor = L["Lindea Rabonne"], Team = "Alliance" },
            { Region = 1437, Vendor = L["Stuart Fleming"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Tansy Puddlefizz"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Shankys"], Team = "Horde" },
            { Region = 1440, Vendor = L["Wik'Tar"], Team = "Horde" },
            { Region = 1443, Vendor = L["Wulan"], Team = "Horde" },
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
            { Region = 1458, Vendor = L["Lizbeth Cromwell"], Team = "Horde" },
         },
      },
      {
         ID = 2701,
         Spell = 2549,
         Item = 1017,
         Type = L["Cooking"],
         Skill = 100,
         Cost = 1600,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 6326,
         Spell = 7752,
         Item = 787,
         Type = L["Cooking"],
         Skill = 1,
         Cost = 40,
         Locations = {
            { Region = 1436, Vendor = L["Kriggon Talsone"], Team = "Alliance" },
            { Region = 1438, Vendor = L["Nessa Shadowsong"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Tansy Puddlefizz"], Team = "Alliance" },
            { Region = 1420, Vendor = L["Martine Tramblay"], Team = "Horde" },
            { Region = 1411, Vendor = L["Zansoa"], Team = "Horde" },
         },
      },
      {
         ID = 6892,
         Spell = 8607,
         Item = 6890,
         Type = L["Cooking"],
         Skill = 40,
         Cost = 250,
         Locations = {
            { Region = 1432, Vendor = L["Drac Roughcut"], Team = "Alliance" },
            { Region = 1421, Vendor = L["Andrew Hilbert"], Team = "Horde" },
         },
      },
      {
         ID = 16111,
         Spell = 15915,
         Item = 12216,
         Type = L["Cooking"],
         Skill = 225,
         Cost = 12000,
         Locations = {
            { Region = 1436, Vendor = L["Kriggon Talsone"], Team = "Alliance" },
            { Region = 1435, Vendor = L["Banalash"], Team = "Horde" },
            { Region = 1434, Vendor = L["Uthok"], Team = "Horde" },
         },
      },
      {
         ID = 2700,
         Spell = 2548,
         Item = 2685,
         Type = L["Cooking"],
         Skill = 110,
         Cost = 400,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 18046,
         Spell = 22480,
         Item = 18045,
         Type = L["Cooking"],
         Skill = 225,
         Cost = 12000,
         Locations = {
            { Region = 1425, Vendor = L["Truk Wildbeard"], Team = "Alliance" },
            { Region = 1446, Vendor = L["Dirge Quikcleave"], Team = "Neutral" },
         },
      },
      {
         ID = 728,
         Spell = 2543,
         Item = 733,
         Type = L["Cooking"],
         Skill = 75,
         Cost = 200,
         Locations = {
            { Region = 1453, Vendor = L["Kendor Kabonka"], Team = "Alliance" },
         },
      },
      {
         ID = 12226,
         Spell = 15935,
         Item = 12224,
         Type = L["Cooking"],
         Skill = 1,
         Cost = 25,
         Locations = {
            { Region = 1420, Vendor = L["Abigail Shiel"], Team = "Horde" },
         },
      },
      {
         ID = 5488,
         Spell = 6418,
         Item = 5479,
         Type = L["Cooking"],
         Skill = 100,
         Cost = 400,
         Locations = {
            { Region = 1413, Vendor = L["Tari'qa"], Team = "Horde" },
         },
      },
      {
         ID = 5484,
         Spell = 6414,
         Item = 5474,
         Type = L["Cooking"],
         Skill = 35,
         Cost = 240,
         Locations = {
            { Region = 1412, Vendor = L["Wunna Darkmane"], Team = "Horde" },
         },
      },
      {
         ID = 5483,
         Spell = 6413,
         Item = 5473,
         Type = L["Cooking"],
         Skill = 20,
         Cost = 140,
         Locations = {
            { Region = 1411, Vendor = L["Grimtak"], Team = "Horde" },
         },
      },
      {
         ID = 5486,
         Spell = 6416,
         Item = 5477,
         Type = L["Cooking"],
         Skill = 50,
         Cost = 440,
         Locations = {
            { Region = 1413, Vendor = L["Tari'qa"], Team = "Horde" },
         },
      },
      {
         ID = 12232,
         Spell = 15863,
         Item = 12213,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 5000,
         Locations = {
            { Region = 1435, Vendor = L["Banalash"], Team = "Horde" },
            { Region = 1443, Vendor = L["Kireena"], Team = "Horde" },
            { Region = 1445, Vendor = L["Ogg'marr"], Team = "Horde" },
            { Region = 1443, Vendor = L["Vendor-Tron 1000"], Team = "Neutral" },
         },
      },
      {
         ID = 13940,
         Spell = 18239,
         Item = 13927,
         Type = L["Cooking"],
         Skill = 225,
         Cost = 16000,
         Locations = {
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
         },
      },
      {
         ID = 13941,
         Spell = 18241,
         Item = 13930,
         Type = L["Cooking"],
         Skill = 225,
         Cost = 16000,
         Locations = {
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
         },
      },
      {
         ID = 6039,
         Spell = 7213,
         Item = 6038,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 5000,
         Locations = {
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
         },
      },
      {
         ID = 13942,
         Spell = 18240,
         Item = 13928,
         Type = L["Cooking"],
         Skill = 240,
         Cost = 16000,
         Locations = {
            { Region = 1446, Vendor = L["Gikkix"], Team = "Neutral" },
         },
      },
      {
         ID = 13943,
         Spell = 18242,
         Item = 13929,
         Type = L["Cooking"],
         Skill = 240,
         Cost = 16000,
         Locations = {
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
         },
      },
      {
         ID = 12227,
         Spell = 15853,
         Item = 12209,
         Type = L["Cooking"],
         Skill = 125,
         Cost = 1600,
         Locations = {
            { Region = 1443, Vendor = L["Super-Seller 680"], Team = "Neutral" },
         },
      },
      {
         ID = 16110,
         Spell = 15933,
         Item = 12218,
         Type = L["Cooking"],
         Skill = 225,
         Cost = 12000,
         Locations = {
            { Region = 1448, Vendor = L["Malygen"], Team = "Alliance" },
            { Region = 1448, Vendor = L["Bale"], Team = "Horde" },
            { Region = 1452, Vendor = L["Himmik"], Team = "Neutral" },
            { Region = 1452, Vendor = L["Qia"], Team = "Neutral" },
         },
      },
      {
         ID = 13945,
         Spell = 18243,
         Item = 13931,
         Type = L["Cooking"],
         Skill = 250,
         Cost = 20000,
         Locations = {
            { Region = 1446, Vendor = L["Gikkix"], Team = "Neutral" },
         },
      },
      {
         ID = 13946,
         Spell = 18244,
         Item = 13932,
         Type = L["Cooking"],
         Skill = 250,
         Cost = 20000,
         Locations = {
            { Region = 1446, Vendor = L["Gikkix"], Team = "Neutral" },
         },
      },
      {
         ID = 13939,
         Spell = 18238,
         Item = 6887,
         Type = L["Cooking"],
         Skill = 225,
         Cost = 16000,
         Locations = {
            { Region = 1446, Vendor = L["Gikkix"], Team = "Neutral" },
         },
      },
      {
         ID = 16767,
         Spell = 20626,
         Item = 16766,
         Type = L["Cooking"],
         Skill = 225,
         Cost = 3000,
         Locations = {
            { Region = 1446, Vendor = L["Jabbey"], Team = "Neutral" },
         },
      },
      {
         ID = 17201,
         Spell = 21144,
         Item = 17198,
         Type = L["Cooking"],
         Skill = 35,
         Cost = 240,
         Locations = {
            { Region = 1453, Vendor = L["Khole Jinglepocket"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Wulmort Jinglepocket"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Penney Copperpinch"], Team = "Horde" },
            { Region = 1456, Vendor = L["Seersa Copperpinch"], Team = "Horde" },
            { Region = 1458, Vendor = L["Nardstrum Copperpinch"], Team = "Horde" },
         },
      },
      {
         ID = 17200,
         Spell = 21143,
         Item = 17197,
         Type = L["Cooking"],
         Skill = 1,
         Cost = 25,
         Locations = {
            { Region = 1453, Vendor = L["Khole Jinglepocket"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Wulmort Jinglepocket"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Penney Copperpinch"], Team = "Horde" },
            { Region = 1456, Vendor = L["Seersa Copperpinch"], Team = "Horde" },
            { Region = 1458, Vendor = L["Nardstrum Copperpinch"], Team = "Horde" },
         },
      },
      {
         ID = 21099,
         Spell = 25704,
         Item = 21072,
         Type = L["Cooking"],
         Skill = 80,
         Cost = 500,
         Locations = {
            { Region = 1457, Vendor = L["Fyldan"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Wulan"], Team = "Horde" },
            { Region = 1424, Vendor = L["Derak Nightfall"], Team = "Horde" },
            { Region = 1424, Vendor = L["Micha Yance"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Emrul Riknussun"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Xen'to"], Team = "Horde" },
            { Region = 1433, Vendor = L["Gloria Femmel"], Team = "Alliance" },
            { Region = 1453, Vendor = L["Erika Tate"], Team = "Alliance" },
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
            { Region = 1438, Vendor = L["Nyoma"], Team = "Alliance" },
            { Region = 1413, Vendor = L["Tarban Hearthgrain"], Team = "Horde" },
            { Region = 1425, Vendor = L["Otho Moji'ko"], Team = "Horde" },
            { Region = 1456, Vendor = L["Naal Mistrunner"], Team = "Horde" },
            { Region = 1458, Vendor = L["Ronald Burch"], Team = "Horde" },
         },
      },
      {
         ID = 21219,
         Spell = 25954,
         Item = 21217,
         Type = L["Cooking"],
         Skill = 175,
         Cost = 5000,
         Locations = {
            { Region = 1457, Vendor = L["Fyldan"], Team = "Alliance" },
            { Region = 1443, Vendor = L["Wulan"], Team = "Horde" },
            { Region = 1424, Vendor = L["Derak Nightfall"], Team = "Horde" },
            { Region = 1424, Vendor = L["Micha Yance"], Team = "Alliance" },
            { Region = 1455, Vendor = L["Emrul Riknussun"], Team = "Alliance" },
            { Region = 1454, Vendor = L["Xen'to"], Team = "Horde" },
            { Region = 1433, Vendor = L["Gloria Femmel"], Team = "Alliance" },
            { Region = 1453, Vendor = L["Erika Tate"], Team = "Alliance" },
            { Region = 1434, Vendor = L["Kelsey Yance"], Team = "Neutral" },
            { Region = 1438, Vendor = L["Nyoma"], Team = "Alliance" },
            { Region = 1413, Vendor = L["Tarban Hearthgrain"], Team = "Horde" },
            { Region = 1425, Vendor = L["Otho Moji'ko"], Team = "Horde" },
            { Region = 1456, Vendor = L["Naal Mistrunner"], Team = "Horde" },
            { Region = 1458, Vendor = L["Ronald Burch"], Team = "Horde" },
         },
      },
-- Thistle Tea not in game
--      {
--         ID = 18160,
--         Spell = 9513,
--         Item = 7676,
--         Type = L["Cooking"],
--         Skill = 60,
--         Cost = 200,
--         Notes = L["Rogue Only"],
--         Locations = {
--            { Region = 1424, Vendor = L["Smudge Thunderwood"], Team = "Neutral" },
--         },
--      },
   },
},

[L["Fishing"]] = {
   Recipes = {
      {
         ID = 16083,
         Spell = 7732,
         Item = 0,
         Type = L["Fishing"],
         Skill = 125,
         Cost = 10000,
         Locations = {
            { Region = 1434, Vendor = L["Old Man Heming"], Team = "Neutral" },
         },
      },
   },
},

[L["First Aid"]] = {
   Recipes = {
      {
         ID = 16084,
         Spell = 7924,
         Item = 0,
         Type = L["First Aid"],
         Skill = 125,
         Cost = 10000,
         Locations = {
            { Region = 1417, Vendor = L["Deneb Walker"], Team = "Alliance" },
            { Region = 1445, Vendor = L["Balai Lok'Wein"], Team = "Horde" },
            { Region = 1445, Vendor = L["Ghok'kah"], Team = "Horde" },
         },
      },
      {
         ID = 16112,
         Spell = 7929,
         Item = 6451,
         Type = L["First Aid"],
         Skill = 180,
         Cost = 2200,
         Locations = {
            { Region = 1417, Vendor = L["Deneb Walker"], Team = "Alliance" },
            { Region = 1445, Vendor = L["Balai Lok'Wein"], Team = "Horde" },
            { Region = 1445, Vendor = L["Ghok'kah"], Team = "Horde" },
         },
      },
      {
         ID = 16113,
         Spell = 10840,
         Item = 8544,
         Type = L["First Aid"],
         Skill = 210,
         Cost = 5000,
         Locations = {
            { Region = 1417, Vendor = L["Deneb Walker"], Team = "Alliance" },
            { Region = 1445, Vendor = L["Balai Lok'Wein"], Team = "Horde" },
            { Region = 1445, Vendor = L["Ghok'kah"], Team = "Horde" },
         },
      },
      {
         ID = 19442,
         Spell = 23787,
         Item = 19440,
         Type = L["First Aid"],
         Skill = 300,
         Cost = 100000,
         Faction = BFAC["Argent Dawn"],
         Level = 6,
         Locations = {
            { Region = 1420, Vendor = L["Argent Quartermaster Hasana"], Team = "Neutral" },
            { Region = 1422, Vendor = L["Argent Quartermaster Lightspark"], Team = "Neutral" },
            { Region = 1423, Vendor = L["Quartermaster Miranda Breechlock"], Team = "Neutral" },
         },
      },
   },
},

}

