local TOCNAME,Addon = ...
Addon.MinimapButton=Addon.MinimapButton or {}
local MinimapButton=Addon.MinimapButton

local function BottomZoom(button)
	local deltaX, deltaY = 0, 0
	if not button.Lib_GPI_MinimapButton.isMouseDown then
		deltaX = 0.05
		deltaY = 0.05
	end
	button.Lib_GPI_MinimapButton.icon:SetTexCoord( deltaX, 1 - deltaX,  deltaY, 1 - deltaY)
end

local function onUpdate(button)
	local mx, my = Minimap:GetCenter()
	local px, py = GetCursorPosition()
	local w=((Minimap:GetWidth() / 2) + 5)
	local scale = Minimap:GetEffectiveScale()
	px, py = px / scale, py / scale
	local dx,dy= px - mx,py - my
	local dist=math.sqrt(dx*dx+dy*dy)/w
	if button.Lib_GPI_MinimapButton.db.lockDistance then
		dist=1
	else
		if dist<1 then dist=1 elseif dist>2 then dist=2 end
	end
	
	button.Lib_GPI_MinimapButton.db.distance=dist
	button.Lib_GPI_MinimapButton.db.position = math.deg(math.atan2(dy, dx)) % 360	
	button.Lib_GPI_MinimapButton:UpdatePosition()
end

local function onDragStart(button)
	button.Lib_GPI_MinimapButton.isMouseDown = true
	if button.Lib_GPI_MinimapButton.db.lock==false then
		button:LockHighlight()
		BottomZoom(button)
		button:SetScript("OnUpdate", onUpdate)		
		button.Lib_GPI_MinimapButton.isDraggingButton = true
	end
	GameTooltip:Hide()	
end

local function onDragStop(button)
	button:SetScript("OnUpdate", nil)
	button.Lib_GPI_MinimapButton.isMouseDown = false
	BottomZoom(button)
	button:UnlockHighlight()
	button.Lib_GPI_MinimapButton.isDraggingButton = false	
end

local function onEnter(button)
	if button.Lib_GPI_MinimapButton.isDraggingButton or not button.Lib_GPI_MinimapButton.Tooltip then return end
	GameTooltip:SetOwner(button, "ANCHOR_BOTTOMLEFT", 0,0	)
	GameTooltip:AddLine(button.Lib_GPI_MinimapButton.Tooltip)		
	GameTooltip:Show()
end

local function onLeave(button)
	GameTooltip:Hide()
end

local function onClick(button, b)
	GameTooltip:Hide()
	if button.Lib_GPI_MinimapButton.onClick then
		button.Lib_GPI_MinimapButton.onClick(button.Lib_GPI_MinimapButton, b)
	end		
end

local function onMouseDown(button)
	button.Lib_GPI_MinimapButton.isMouseDown = true
	BottomZoom(button)
end

local function onMouseUp(button)
	button.Lib_GPI_MinimapButton.isMouseDown = false
	BottomZoom(button)
end
		
function MinimapButton.Init(DB,Texture,DoOnClick,Tooltip)
	MinimapButton.db=DB
	MinimapButton.onClick=DoOnClick
	MinimapButton.Tooltip=Tooltip
	MinimapButton.isMinimapButton=true
	
	local button = CreateFrame("Button", "Lib_GPI_Minimap_"..TOCNAME, Minimap)
	
	MinimapButton.button=button
	button.Lib_GPI_MinimapButton=MinimapButton
	
	button:SetFrameStrata("MEDIUM")
	button:SetSize(31, 31)
	button:SetFrameLevel(8)
	button:RegisterForClicks("anyUp")
	button:RegisterForDrag("LeftButton")
	button:SetHighlightTexture(136477) --"Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight"
	local overlay = button:CreateTexture(nil, "OVERLAY")
	overlay:SetSize(53, 53)
	overlay:SetTexture(136430) --"Interface\\Minimap\\MiniMap-TrackingBorder"
	overlay:SetPoint("TOPLEFT")
	local background = button:CreateTexture(nil, "BACKGROUND")
	background:SetSize(20, 20)
	background:SetTexture(136467) --"Interface\\Minimap\\UI-Minimap-Background"
	background:SetPoint("TOPLEFT", 7, -5)
	local icon = button:CreateTexture(nil, "ARTWORK")
	icon:SetSize(17, 17)
	icon:SetTexture(Texture)
	icon:SetPoint("TOPLEFT", 7, -6)
	
	MinimapButton.icon = icon
	MinimapButton.isMouseDown = false
	MinimapButton.isDraggingButton = false
	
	button:SetScript("OnEnter", onEnter)
	button:SetScript("OnLeave", onLeave)
		
	
	button:SetScript("OnClick", onClick)
		
	button:SetScript("OnDragStart", onDragStart)
	button:SetScript("OnDragStop", onDragStop)
	
	button:SetScript("OnMouseDown", onMouseDown)
	button:SetScript("OnMouseUp", onMouseUp) 
		
	if MinimapButton.db.position==nil then MinimapButton.db.position=225 end
	if MinimapButton.db.distance==nil then MinimapButton.db.distance=1 end
	if MinimapButton.db.visible==nil then MinimapButton.db.visible=true end
	if MinimapButton.db.lock==nil then MinimapButton.db.lock=false end
	if MinimapButton.db.lockDistance==nil then MinimapButton.db.lockDistance=false end

	
	BottomZoom(button)
	MinimapButton:UpdatePosition()
end

function MinimapButton:UpdatePosition()
	local w = ((Minimap:GetWidth() / 2) + 10) * self.db.distance
	local h = ((Minimap:GetHeight() / 2) + 10) * self.db.distance
	local r=math.rad(self.db.position)
	self.button:SetPoint("CENTER", Minimap, "CENTER", w * math.cos(r), h * math.sin(r))
	if self.db.visible then
		self:Show()
	else
		self:Hide()
	end		
end

function MinimapButton:Show()
	self.db.visible = true
	self.button:SetParent(Minimap)
	self.button:Show()
end

function MinimapButton:Hide()
	self.db.visible = false
	self.button:Hide()
	self.button:SetParent(nil)
end

function MinimapButton:SetTooltip(Text)
	self.Tooltip=Text
end
