local TOCNAME,Addon = ...
Addon.Tool=Addon.Tool or {}
local Tool=Addon.Tool


Tool.IconClass={
  ["WARRIOR"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:0:64:0:64|t",
  ["MAGE"]=		"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:64:128:0:64|t",
  ["ROGUE"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:128:192:0:64|t",
  ["DRUID"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:192:256:0:64|t",
  ["HUNTER"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:0:64:64:128|t",
  ["SHAMAN"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:64:128:64:128|t",
  ["PRIEST"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:128:192:64:128|t",
  ["WARLOCK"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:192:256:64:128|t",
  ["PALADIN"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:0:0:0:0:256:256:0:64:128:192|t",
  }
Tool.IconClassBig={
  ["WARRIOR"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:0:64:0:64|t",
  ["MAGE"]=		"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:64:128:0:64|t",
  ["ROGUE"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:128:192:0:64|t",
  ["DRUID"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:192:256:0:64|t",
  ["HUNTER"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:0:64:64:128|t",
  ["SHAMAN"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:64:128:64:128|t",
  ["PRIEST"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:128:192:64:128|t",
  ["WARLOCK"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:192:256:64:128|t",
  ["PALADIN"]=	"|TInterface\\WorldStateFrame\\ICONS-CLASSES:18:18:-4:4:256:256:0:64:128:192|t",
  }  
  
Tool.Classes={ "WARRIOR", "MAGE", "ROGUE", "DRUID", "HUNTER", "SHAMAN", "PRIEST", "WARLOCK", "PALADIN" }

local _tableAccents = {
    [""] = "A", [""] = "A", [""] = "A", [""] = "A", [""] = "Ae", [""] = "A",
	[""] = "AE", [""] = "C", [""] = "E", [""] = "E", [""] = "E", [""] = "E", 
	[""] = "I", [""] = "I", [""] = "I", [""] = "I", [""] = "D", [""] = "N", 
	[""] = "O", [""] = "O", [""] = "O", [""] = "O", [""] = "Oe", [""] = "O", 
	[""] = "U", [""] = "U", [""] = "U", [""] = "Ue", [""] = "Y", [""] = "P", 
	[""] = "s", [""] = "a", [""] = "a", [""] = "a", [""] = "a", [""] = "ae", 
	[""] = "a", [""] = "ae", [""] = "c", [""] = "e", [""] = "e", [""] = "e", 
	[""] = "e", [""] = "i", [""] = "i", [""] = "i", [""] = "i", [""] = "eth", 
	[""] = "n", [""] = "o", [""] = "o", [""] = "o", [""] = "o", [""] = "oe", 
	[""] = "o", [""] = "u", [""] = "u", [""] = "u", [""] = "ue", [""] = "y", 
	[""] = "p", [""] = "y", [""] = "ss",
	}

function Tool.Merge(t1,...)
	for index=1 , select("#",...) do
		for i,v in pairs(select(index,...)) do 
			t1[i]=v
		end
	end
	return t1
end

function Tool.iMerge(t1,...)
	for index=1 , select("#",...) do 
		for i,v in ipairs(select(index,...)) do 
			if tContains(t1,v)==false then
				tinsert(t1,v)
			end
		end
	end
	return t1
end

function Tool.stripChars(str)
	return string.gsub(str,"[%z\1-\127\194-\244][\128-\191]*", _tableAccents)
end

function Tool.CreatePattern(pattern,maximize)		
	pattern = string.gsub(pattern, "[%(%)%-%+%[%]]", "%%%1")
	if not maximize then 
		pattern = string.gsub(pattern, "%%s", "(.-)")
	else
		pattern = string.gsub(pattern, "%%s", "(.+)")
	end
	pattern = string.gsub(pattern, "%%d", "%(%%d-%)")
	if not maximize then 
		pattern = string.gsub(pattern, "%%%d%$s", "(.-)")
	else
		pattern = string.gsub(pattern, "%%%d%$s", "(.+)")
	end
	pattern = string.gsub(pattern, "%%%d$d", "%(%%d-%)")		
	--pattern = string.gsub(pattern, "%[", "%|H%(%.%-%)%[")
	--pattern = string.gsub(pattern, "%]", "%]%|h")
	return pattern
	
end

function Tool.Combine(t,sep,first,last)
	if type(t)~="table" then return "" end
	sep=sep or " "
	first=first or 1
	last= last or #t
	
	local ret=""
	for i=first,last do
		ret=ret..sep..t[i]
	end
	return string.sub(ret,string.len(sep)+1)
end

function Tool.iSplit(inputstr, sep)
	if sep == nil then
		sep = "%s"
	end
	local t={}
	for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
		if tContains(t, str)==false then
			table.insert(t,tonumber(str))
		end
	end
	return t
end

function Tool.Split(inputstr, sep)
	if sep == nil then
		sep = "%s"
	end
	local t={}
	for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
		if tContains(t, str)==false then
			table.insert(t, str)
		end
	end
	return t
end

-- Size 

local ResizeCursor
local SizingStop=function(self,button)
	self:GetParent():StopMovingOrSizing()
	if self.GPI_DoStop then self.GPI_DoStop(self:GetParent()) end
end

local SizingStart=function(self,button)
	self:GetParent():StartSizing(self.GPI_SIZETYPE)
	if self.GPI_DoStart then self.GPI_DoStart(self:GetParent()) end
end

local SizingEnter=function(self)
	if not (GetCursorInfo()) then
		ResizeCursor:Show()
		ResizeCursor.Texture:SetTexture(self.GPI_Cursor)
	end
end

local SizingLeave=function(self,button)
	ResizeCursor:Hide()
end

local sizecount=0
local CreateSizeBorder=function(frame,name,a1,x1,y1,a2,x2,y2,cursor,OnStart,OnStop) 
	local FrameSizeBorder
	sizecount=sizecount+1
	FrameSizeBorder=CreateFrame("Frame",(frame:GetName() or TOCNAME..sizecount).."_size_"..name,frame)
	FrameSizeBorder:SetPoint("TOPLEFT", frame, a1, x1, y1)
	FrameSizeBorder:SetPoint("BOTTOMRIGHT", frame, a2, x2,y2 )
	FrameSizeBorder.GPI_SIZETYPE=name
	FrameSizeBorder.GPI_Cursor = cursor
	FrameSizeBorder.GPI_DoStart=OnStart
	FrameSizeBorder.GPI_DoStop=OnStop
	FrameSizeBorder:SetScript("OnMouseDown", SizingStart)
	FrameSizeBorder:SetScript("OnMouseUp", SizingStop)
	FrameSizeBorder:SetScript("OnEnter", SizingEnter)
	FrameSizeBorder:SetScript("OnLeave", SizingLeave)	
	return FrameSizeBorder
end

local ResizeCursor_Update=function(self)
	local X, Y = GetCursorPosition()
	local Scale = self:GetEffectiveScale()
	self:SetPoint("CENTER", UIParent, "BOTTOMLEFT", X / Scale, Y / Scale)
end

function Tool.EnableSize(frame,border,OnStart,OnStop)
	if not ResizeCursor then 
		ResizeCursor = CreateFrame("Frame", nil, UIParent)
		ResizeCursor:Hide()
		ResizeCursor:SetWidth(24)
		ResizeCursor:SetHeight(24)
		ResizeCursor:SetFrameStrata("TOOLTIP")
		ResizeCursor.Texture = ResizeCursor:CreateTexture()
		ResizeCursor.Texture:SetAllPoints()
		ResizeCursor:SetScript("OnUpdate", ResizeCursor_Update)
	end
	border=border or 8
	
	path= "Interface\\AddOns\\".. TOCNAME .. "\\Resize\\"
	
	CreateSizeBorder(frame,"BOTTOM","BOTTOMLEFT", border, border, "BOTTOMRIGHT", -border, 0,path.."Vertical.tga",OnStart,OnStop)
	CreateSizeBorder(frame,"TOP","TOPLEFT", border, 0, "TOPRIGHT", -border, -border,path.. "Vertical.tga",OnStart,OnStop)
	CreateSizeBorder(frame,"LEFT","TOPLEFT", 0,-border, "BOTTOMLEFT", border, border,path.. "Horizontal.tga",OnStart,OnStop)
	CreateSizeBorder(frame,"RIGHT","TOPRIGHT",-border,-border, "BOTTOMRIGHT", 0, border,path.. "Horizontal.tga",OnStart,OnStop)
	
	CreateSizeBorder(frame,"TOPLEFT","TOPLEFT", 0,0, "TOPLEFT", border, -border,path.. "Diagonal1.tga",OnStart,OnStop)
	CreateSizeBorder(frame,"BOTTOMLEFT","BOTTOMLEFT", 0,0, "BOTTOMLEFT", border, border,path.. "Diagonal2.tga",OnStart,OnStop)
	CreateSizeBorder(frame,"TOPRIGHT","TOPRIGHT", 0,0, "TOPRIGHT", -border, -border,path.. "Diagonal2.tga",OnStart,OnStop)
	CreateSizeBorder(frame,"BOTTOMRIGHT","BOTTOMRIGHT", 0,0, "BOTTOMRIGHT", -border, border,path.. "Diagonal1.tga",OnStart,OnStop)
	
end

-- popup

local function PopupClick(self, arg1, arg2, checked)
	if type(self.value)=="table" then		
		self.value[arg1]=not checked
		if arg2 then
			arg2(self.value,arg1,checked)		
		end
	elseif type(self.value)=="function" then		
		self.value(arg1,arg2)		
	end		
end

local function PopupAddItem(self,text,checked,disabled,value,arg1,arg2)
	local c=self._Frame._GPIPRIVAT_Items.count+1
	self._Frame._GPIPRIVAT_Items.count=c
	
	if not self._Frame._GPIPRIVAT_Items[c] then
		self._Frame._GPIPRIVAT_Items[c]={}
	end
	local t=self._Frame._GPIPRIVAT_Items[c]
	t["text"]=text
	t["checked"]=checked
	t["disabled"]=disabled
	t["value"]=value
	t["arg1"]=arg1
	t["arg2"]=arg2
end

local function PopupWipe(self)
	self._Frame._GPIPRIVAT_Items.count=0
	if UIDROPDOWNMENU_OPEN_MENU == self._Frame then
		ToggleDropDownMenu(nil, nil, self._Frame, self._where, self._x, self._y)
		return false
	end
	return true
end

local function PopupCreate(frame, level, menuList)
	if level~=1 then return end
	
	local info = UIDropDownMenu_CreateInfo()

	for i=1,frame._GPIPRIVAT_Items.count do
		local val=frame._GPIPRIVAT_Items[i]		
		info.text=val.text
		info.notCheckable = (val.checked==nil)
		info.checked = val.checked
		info.disabled=val.disabled
		info.value=val.value
		info.arg1=val.arg1
		if type(val.value)=="table" then			
			info.arg2=frame._GPIPRIVAT_TableCallback
		elseif type(val.value)=="function" then
			info.arg2=val.arg2
		end		
		info.func=PopupClick
		UIDropDownMenu_AddButton(info)
	end
end

local function PopupShow(self,where,x,y)
	if where==nil then where="cursor" end
	if UIDROPDOWNMENU_OPEN_MENU ~= self._Frame then 
		UIDropDownMenu_Initialize(self._Frame, PopupCreate, "MENU")
	end
	ToggleDropDownMenu(nil, nil, self._Frame, where, x,y)
	self._where=where
	self._x=x
	self._y=y
end

function Tool.CreatePopup(TableCallback)
	local popup={}
	popup._Frame=CreateFrame("Frame", nil, UIParent, "UIDropDownMenuTemplate")
	popup._Frame._GPIPRIVAT_TableCallback=TableCallback
	popup._Frame._GPIPRIVAT_Items={}
	popup._Frame._GPIPRIVAT_Items.count=0
	popup.AddItem=PopupAddItem
	popup.Show=PopupShow
	popup.Wipe=PopupWipe
	return popup
end	

-- TAB

local function SelectTab(self)
	local parent=self:GetParent()
	PanelTemplates_SetTab(parent,self:GetID())
	for i=1, parent.numTabs do
		parent.Tabs[i].content:Hide()
	end
	self.content:Show()	
end

function Tool.TabHide(frame,id)
	if id and frame.Tabs and frame.Tabs[id] then
		frame:Hide()
	elseif not id and frame.Tabs then
		for i=1, frame.numTabs do
			frame.Tabs[i]:Hide()
		end
	end
end

function Tool.TabShow(frame,id)
	if id and frame.Tabs and frame.Tabs[id] then
		frame:Show()
	elseif not id and frame.Tabs then
		for i=1, frame.numTabs do
			frame.Tabs[i]:Show()
		end
	end
end

function Tool.SelectTab(frame,id)
	if id and frame.Tabs and frame.Tabs[id] then
		SelectTab(frame.Tabs[id])
	end
end	
	
function Tool.GetSelectedTab(frame)
	if frame.Tabs then 
		for i=1, frame.numTabs do
			if frame.Tabs[i].content:IsShown() then
				return i
			end					
		end
	end
	return 0
end
	
function Tool.AddTab(frame,name,tabFrame)
	local frameName=frame:GetName()
	frame.numTabs=frame.numTabs and frame.numTabs+1 or 1
	if frame.Tabs==nil then frame.Tabs={} end
	
	frame.Tabs[frame.numTabs]=CreateFrame("Button",frameName.."Tab"..frame.numTabs, frame, "CharacterFrameTabButtonTemplate")
	frame.Tabs[frame.numTabs]:SetID(frame.numTabs)
	frame.Tabs[frame.numTabs]:SetText(name)
	frame.Tabs[frame.numTabs]:SetScript("OnClick",SelectTab)		
	frame.Tabs[frame.numTabs].content=tabFrame
	tabFrame:Hide()
	
	if frame.numTabs==1 then
		frame.Tabs[frame.numTabs]:SetPoint("TOPLEFT",frame,"BOTTOMLEFT",5,4)
	else
		frame.Tabs[frame.numTabs]:SetPoint("TOPLEFT",frame.Tabs[frame.numTabs-1],"TOPRIGHT",-14,0)
	end
	
	SelectTab(frame.Tabs[frame.numTabs])
	SelectTab(frame.Tabs[1])
	return frame.numTabs
end


-- DataBrocker
local DataBrocker=false
function Tool.AddDataBrocker(icon,onClick,onTooltipShow,text)
	if LibStub ~= nil and DataBrocker ~= true then 
		local Launcher = LibStub('LibDataBroker-1.1',true)
		if Launcher ~= nil then	
			DataBrocker=true
			Launcher:NewDataObject(TOCNAME, {
				type = "launcher",
				icon = icon,
				OnClick = onClick,
				OnTooltipShow = onTooltipShow,
				tocname = TOCNAME,
				label = text or GetAddOnMetadata(TOCNAME, "Title"),
			})
		end
	end	
end
	
-- Slashcommands
		
local slash,slashCmd
local function slashUnpack(t,sep)
	local ret=""
	if sep==nil then sep=", " end
	for i=1,#t do
		if i~=1 then ret=ret..sep end
		ret=ret.. t[i]
	end
	return ret
end

function Tool.PrintSlashCommand(prefix,subSlash,p)
	p=p or print
	prefix=prefix or ""
	subSlash=subSlash or slash
	
	local colCmd="|cFFFF9C00"
	
	for i,subcmd in ipairs(subSlash) do
		local words= (type(subcmd[1])=="table") and "|r("..colCmd..slashUnpack(subcmd[1],"|r/"..colCmd).."|r)"..colCmd or subcmd[1]
		if words=="%" then words="<value>" end
		
		if subcmd[2]~=nil and subcmd[2]~="" then 
			p(colCmd.. ((type(slashCmd)=="table" ) and slashCmd[1] or slashCmd).. " ".. prefix .. words .."|r: "..subcmd[2])
		end
		if type(subcmd[3])=="table" then
			
			Tool.PrintSlashCommand(prefix..words.." ",subcmd[3],p)
		end
		
	end
end
local function DoSlash(deep,msg,subSlash)
	for i,subcmd in ipairs(subSlash) do
		local ok=(type(subcmd[1])=="table") and tContains(subcmd[1],msg[deep]) or 
					(subcmd[1]==msg[deep] or (subcmd[1]=="" and msg[deep]==nil))
		if subcmd[1]=="%" then
			local para=Tool.iMerge( {unpack(subcmd,4)},{unpack(msg,deep)})
			return subcmd[3](unpack( para ) )
		end
		if ok then
			if type(subcmd[3])=="function" then
				return subcmd[3](unpack(subcmd,4))
			elseif type(subcmd[3])=="table" then
				return DoSlash(deep+1,msg,subcmd[3])
			end
		end
	end
	Tool.PrintSlashCommand(Tool.Combine(msg," ",1,deep-1).." ",subSlash)
	return nil
end


local function mySlashs(msg)
	if msg=="help" then
		local colCmd="|cFFFF9C00"
		print("|cFFFF1C1C"..GetAddOnMetadata(TOCNAME, "Title") .." ".. GetAddOnMetadata(TOCNAME, "Version") .." by "..GetAddOnMetadata(TOCNAME, "Author"))
		print(GetAddOnMetadata(TOCNAME, "Notes"))		
		if type(slashCmd)=="table" then
			print("SlashCommand:",colCmd,slashUnpack(slashCmd,"|r, "..colCmd),"|r")
		end
		
		Tool.PrintSlashCommand()

		
	else
		DoSlash(1,Tool.Split(msg," "),slash)
	end
end
	
function Tool.SlashCommand(cmds,subcommand)
	slash=subcommand
	slashCmd=cmds
	if type(cmds)=="table" then
		for i,cmd in ipairs(cmds) do
			_G["SLASH_"..TOCNAME..i]= cmd
		end
	else
		_G["SLASH_"..TOCNAME.."1"]= cmds
	end
	
	SlashCmdList[TOCNAME]=mySlashs
end
	
---- quick copy&past

local CopyPastFrame
local CopyPastSavedText
local CopyPastText
local function CreateCopyPast()
	local frame = CreateFrame("Frame", nil, UIParent)
    frame:SetFrameStrata("DIALOG")
	frame:SetBackdrop({
        bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
        tile = true,
        edgeFile = "Interface/DialogFrame/UI-DialogBox-Border",
        edgeSize = 32,
        insets = {
            left = 11,
            right = 12,
            top = 12,
            bottom = 11,
        },
    })
	frame:SetSize(700, 450)
	frame:SetPoint("CENTER")
	frame:EnableMouse(true)
    frame:EnableKeyboard(true)
	frame:SetMovable(true)
	frame:SetResizable(true)
	frame:SetMinResize(200,200)
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart",function()
			CopyPastFrame:StartMoving()
		end)
	frame:SetScript("OnDragStop",function()
			CopyPastFrame:StopMovingOrSizing();
			CopyPastText:SetSize(CopyPastText:GetParent(scrollFrame):GetWidth(),10)
		end)
	frame:SetScript("OnSizeChanged",function()
			if CopyPastText then
				CopyPastText:SetSize(CopyPastText:GetParent(scrollFrame):GetWidth(),10)
			end
		end)
		
		
		
	
	
	Tool.EnableSize(frame)
	
	local button =CreateFrame("Button", nil, frame, "UIPanelButtonTemplate")
	button:SetWidth(128)
    button:SetPoint("BOTTOM", 0, 16)
    button:SetText("OK")
	button:SetScript("OnClick", function()
        CopyPastFrame:Hide()
    end)
	

	
	local scrollFrame = CreateFrame("ScrollFrame", nil, frame, "UIPanelScrollFrameTemplate")
    scrollFrame:SetSize(10, 10)
	scrollFrame:ClearAllPoints()
	scrollFrame:SetPoint("TOPLEFT",frame,"TOPLEFT", 20, -20)
	scrollFrame:SetPoint("RIGHT", -40, 0)
	scrollFrame:SetPoint("BOTTOM",button,"TOP",0,10)
    
    scrollFrame:Show()
	
	local editBox = CreateFrame("EditBox", nil, scrollFrame)
    editBox:SetMaxLetters(999999)
	editBox:SetSize(editBox:GetParent(scrollFrame):GetWidth(),10)
	editBox:ClearAllPoints()
	--editBox:SetPoint("TOPLEFT",scrollFrame,"TOPLEFT")
	editBox:SetPoint("RIGHT",scrollFrame,"RIGHT")
    
    editBox:SetFont(ChatFontNormal:GetFont())
    editBox:SetAutoFocus(true)
    editBox:SetMultiLine(true)
    editBox:Show()
    editBox:SetScript("OnEscapePressed", function(self)
        CopyPastFrame:Hide()
    end)
	editBox:SetScript("OnEnterPressed", function(self)
        CopyPastFrame:Hide()
    end)
	editBox:SetScript("OnTextChanged", function(self)
        CopyPastText:SetText(CopyPastSavedText)
		CopyPastText:HighlightText()	
    end)
	

	scrollFrame:SetScrollChild(editBox)
	
	CopyPastFrame=frame
	CopyPastTitle=title
	CopyPastText=editBox
	return frame
end

function Tool.CopyPast(Text)
	if CopyPastFrame==nil then
		CreateCopyPast()
	end
	CopyPastText:SetText(Text)
	CopyPastText:HighlightText()
	CopyPastFrame:Show()
	CopyPastText:SetFocus()
	CopyPastSavedText=Text
end
