--[[
	This file keeps track of aura duration and debuff type.
	I'm opting to use PvP durations when possible.
	
]]

local lib = LibStub("LibAuraInfo-1.0");
if(not lib) then error("spellIdData.lua needs LibAuraInfo loaded."); return; end

local myDataVersion = 1303970412;
if(lib.auraInfo and myDataVersion <= lib.spellIdDataVersion) then return; end
lib.spellIdDataVersion = myDataVersion;

--[[
	info is saved as a string seperated by ;. 
	Duration;DebuffType
	
	debuffTypes: Magic = 1,	Disease = 2, Poison = 3, Curse = 4, Enrage = 5, Invisibility = 5
]]

lib.auraInfo = {
	[118]	= '50;1',	-- Polymorph
	[130]	= '30;1',	-- Slow Fall
	[131]	= '600;0',	-- Water Breathing
	[324]	= '600;1',	-- Lightning Shield
	[339]	= '30;1',	-- Entangling Roots
	[355]	= '3;0',	-- Taunt
	[498]	= '10;1',	-- Divine Protection
	[546]	= '600;0',	-- Water Walking
	[588]	= '1800;0',	-- Inner Fire
	[605]	= '60;1',	-- Mind Control
	[642]	= '8;1',	-- Divine Shield
	[673]	= '3600;0',	-- Lesser Armor
	[768]	= '0;0',	-- Cat Form
	[783]	= '0;0',	-- Travel Form
	[871]	= '12;0',	-- Shield Wall
	[982]	= '3;0',	-- Revive Pet
	[768]	= '0;0',	-- Cat Form
	[770]	= '300;0',	-- Faerie Fire
	[783]	= '0;0',	-- Travel Form
	[1038]	= '10;1',	-- Hand of Salvation
	[1044]	= '6;1',	-- Hand of Freedom
	[1066]	= '0;0',	-- Aquatic Form
	[1126]	= '3600;0',	-- Mark of the Wild
	[1161]	= '6;0',	-- Challenging Shout
	[1330]	= '3;0',	-- Garrote - Silence
	[1459]	= '3600;0',	-- Arcane Brilliance
	[1513]	= '20;1',	-- Scare Beast
	[1539]	= '10;0',	-- Feed Pet
	[1543]	= '0;0',	-- Flare
	[1604]	= '4;0',	-- Dazed
	[1706]	= '120;1',	-- Levitate
	[1715]	= '15;0',	-- Hamstring
	[1719]	= '12;0',	-- Recklessness
	[1776]	= '4;0',	-- Gouge
	[1784]	= '0;0',	-- Stealth
	[1833]	= '4;0',	-- Cheap Shot
	[1953]	= '1;0',	-- Blink
	[2094]	= '10;0',	-- Blind
	[2367]	= '3600;0',	-- Lesser Strength
	[2374]	= '3600;0',	-- Lesser Agility
	[2378]	= '3600;0',	-- Health
	[2479]	= '30;0',	-- Honorless Target
	[2565]	= '10;0',	-- Shield Block
	[2584]	= '0;0',	-- Waiting to Resurrect
	[2645]	= '0;1',	-- Ghost Wolf
	[2825]	= '40;1',	-- Bloodlust
	[2895]	= '0;0',	-- Wrath of Air Totem
	[3045]	= '15;0',	-- Rapid Fire
	[3166]	= '3600;0',	-- Lesser Intellect
	[3355]	= '20;1',	-- Freezing Trap
	[3409]	= '12;3',	-- Crippling Poison
	[3436]	= '300;2',	-- Wandering Plague
	[3600]	= '5;1',	-- Earthbind
	[3714]	= '600;0',	-- Path of Frost
	[4167]	= '5;1',	-- Web
	[2895]	= '0;0',	-- Wrath of Air Totem
	[3045]	= '15;0',	-- Rapid Fire
	[3166]	= '3600;0',	-- Lesser Intellect
	[3409]	= '12;3',	-- Crippling Poison
	[3436]	= '300;2',	-- Wandering Plague
	[3600]	= '5;1',	-- Earthbind
	[3714]	= '600;0',	-- Path of Frost
	[4167]	= '5;1',	-- Web
	[5116]	= '4;0',	-- Concussive Shot
	[5118]	= '0;0',	-- Aspect of the Cheetah
	[5209]	= '6;0',	-- Challenging Roar
	[5215]	= '0;0',	-- Prowl
	[5229]	= '10;0',	-- Enrage
	[5384]	= '360;0',	-- Feign Death
	[5484]	= '8;1',	-- Howl of Terror
	[5487]	= '0;0',	-- Bear Form
	[5697]	= '600;0',	-- Unending Breath
	[5760]	= '10;3',	-- Mind-numbing Poison
	[6150]	= '12;0',	-- Quick Shots
	[6196]	= '60;0',	-- Far Sight
	[6307]	= '0;0',	-- Blood Pact
	[6346]	= '180;1',	-- Fear Ward
	[6358]	= '30;1',	-- Seduction
	[6562]	= '0;0',	-- Heroic Presence
	[6653]	= '0;0',	-- Dire Wolf
	[6770]	= '60;0',	-- Sap
	[6788]	= '15;0',	-- Weakened Soul
	[6795]	= '3;0',	-- Growl
	[7178]	= '1800;0',	-- Water Breathing
	[7302]	= '1800;0',	-- Frost Armor
	[7321]	= '5;1',	-- Chilled
	[7353]	= '60;0',	-- Cozy Fire
	[7744]	= '0;0',	-- Will of the Forsaken
	[7870]	= '300;0',	-- Lesser Invisibility
	[7922]	= '1.5;0',	-- Charge Stun
	[8178]	= '0;0',	-- Grounding Totem Effect
	[8212]	= '1200;0',	-- Enlarge
	[8219]	= '3600;0',	-- Flip Out
	[8220]	= '3600;0',	-- Flip Out
	[8221]	= '3600;0',	-- Yaaarrrr
	[8222]	= '3600;0',	-- Yaaarrrr
	[8326]	= '0;0',	-- Ghost
	[8385]	= '3600;1',	-- Swift Wind
	[8395]	= '0;0',	-- Emerald Raptor
	[8515]	= '0;0',	-- Windfury Totem
	[8647]	= '10;0',	-- Expose Armor (1 combo point = 10 seconds)
	[9484]	= '50;1',	-- Shackle Undead
	[10060]	= '15;1',	-- Power Infusion
	[10326]	= '20;1',	-- Turn Evil
	[10796]	= '0;0',	-- Turquoise Raptor
	[10799]	= '0;0',	-- Violet Raptor
	[11196]	= '60;0',	-- Recently Bandaged
	[12042]	= '15;1',	-- Arcane Power
	[12043]	= '0;1',	-- Presence of Mind
	[12051]	= '6;0',	-- Evocation
	[12169]	= '5;0',	-- Shield Block
	[12323]	= '6;0',	-- Piercing Howl
	[12328]	= '10;0',	-- Sweeping Strikes
	[12472]	= '20;1',	-- Icy Veins
	[12536]	= '15;1',	-- Clearcasting
	[12544]	= '1800;1',	-- Frost Armor
	[12579]	= '15;1',	-- Winter's Chill
	[12654]	= '4;1',	-- Ignite
	[12721]	= '6;0',	-- Deep Wounds
	[12809]	= '5;0',	-- Concussion Blow
	[12976]	= '20;0',	-- Last Stand
	[13159]	= '0;0',	-- Aspect of the Pack
	[13165]	= '0;0',	-- Aspect of the Hawk
	[13443]	= '15;0',	-- Rend
	[13750]	= '15;0',	-- Adrenaline Rush
	[13810]	= '30;0',	-- Ice Trap
	[13877]	= '15;0',	-- Blade Flurry
	[14149]	= '20;0',	-- Remorseless
	[14177]	= '0;0',	-- Cold Blood
	[14267]	= '0;0',	-- Horde Flag
	[14268]	= '0;0',	-- Alliance Flag
	[14751]	= '30;1',	-- Chakra
	[14893]	= '15;1',	-- Inspiration
	[15007]	= '600;0',	-- Resurrection Sickness
	[15286]	= '1800;0',	-- Vampiric Embrace
	[15473]	= '0;0',	-- Shadowform
	[15487]	= '5;1',	-- Silence
	[15571]	= '4;0',	-- Dazed
	[15588]	= '10;1',	-- Thunderclap
	[15708]	= '5;0',	-- Mortal Strike
	[16166]	= '30;1',	-- Elemental Mastery
	[16188]	= '0;1',	-- Nature's Swiftness
	[16236]	= '15;1',	-- Ancestral Fortitude
	[16246]	= '15;1',	-- Clearcasting
	[16468]	= '0;3',	-- Mother's Milk
	[16491]	= '5;0',	-- Blood Craze
	[16509]	= '15;0',	-- Rend
	[16567]	= '600;4',	-- Tainted Mind
	[16591]	= '600;1',	-- Noggenfogger Elixir
	[16593]	= '15;1',	-- Noggenfogger Elixir
	[16595]	= '600;1',	-- Noggenfogger Elixir
	[16609]	= '3600;0',	-- Warchief's Blessing
	[16857]	= '600;0',	-- Faerie Fire (Feral)
	[16870]	= '8;1',	-- Clearcasting
	[16886]	= '15;1',	-- Nature's Grace
	[17116]	= '0;1',	-- Nature's Swiftness
	[17229]	= '0;0',	-- Winterspring Frostsaber
	[17364]	= '15;0',	-- Stormstrike
	[17465]	= '0;0',	-- Green Skeletal Warhorse
	[17481]	= '0;0',	-- Rivendare's Deathcharger
	[17539]	= '3600;0',	-- Greater Arcane Elixir
	[17619]	= '0;0',	-- Alchemist's Stone
	[17670]	= '0;0',	-- Argent Dawn Commission
	[17800]	= '30;1',	-- Shadow Mastery
	[17941]	= '10;1',	-- Shadow Trance
	[18118]	= '5;1',	-- Aftermath
	[18223]	= '30;4',	-- Curse of Exhaustion
	[18425]	= '1.5;1',	-- Silenced - Improved Kick
	[18469]	= '2;1',	-- Silenced - Improved Counterspell
	[18498]	= '3;1',	-- Silenced - Gag Order
	[18499]	= '10;0',	-- Berserker Rage
	[18708]	= '15;0',	-- Fel Domination
	[18990]	= '0;0',	-- Brown Kodo
	[19136]	= '5;0',	-- Stormbolt
	[19263]	= '5;0',	-- Deterrence
	[19503]	= '4;0',	-- Scatter Shot
	[19506]	= '0;0',	-- Trueshot Aura
	[19574]	= '10;0',	-- Bestial Wrath
	[19615]	= '10;0',	-- Frenzy Effect
	[19683]	= '900;0',	-- Tame Armored Scorpid
	[19746]	= '0;0',	-- Concentration Aura
	[19821]	= '5;1',	-- Arcane Bomb
	[20005]	= '5;0',	-- Chilled
	[20007]	= '15;0',	-- Holy Strength
	[20053]	= '15;1',	-- Conviction
	[20066]	= '60;1',	-- Repentance
	[20132]	= '10;0',	-- Redoubt
	[20164]	= '1800;0',	-- Seal of Justice
	[20165]	= '1800;0',	-- Seal of Insight
	[20170]	= '5;1',	-- Seal of Justice
	[20178]	= '8;0',	-- Reckoning
	[20217]	= '3600;0',	-- Blessing of Kings
	[20230]	= '12;0',	-- Retaliation
	[20253]	= '3;0',	-- Intercept
	[20511]	= '8;0',	-- Intimidating Shout
	[20549]	= '2;0',	-- War Stomp
	[20572]	= '15;0',	-- Blood Fury
	[20578]	= '10;0',	-- Cannibalize
	[20736]	= '6;0',	-- Distracting Shot
	[20911]	= '0;0',	-- Sanctuary
	[22717]	= '0;0',	-- Black War Steed
	[22718]	= '0;0',	-- Black War Kodo
	[22719]	= '0;0',	-- Black Battlestrider
	[22720]	= '0;0',	-- Black War Ram
	[22721]	= '0;0',	-- Black War Raptor
	[22722]	= '0;0',	-- Red Skeletal Warhorse
	[22723]	= '0;0',	-- Black War Tiger
	[22724]	= '0;0',	-- Black War Wolf
	[22812]	= '12;1',	-- Barkskin
	[22842]	= '20;0',	-- Frenzied Regeneration
	[22888]	= '7200;0',	-- Rallying Cry of the Dragonslayer
	[22911]	= '2;0',	-- Charge
	[22959]	= '30;1',	-- Critical Mass
	[23033]	= '0;0',	-- Battle Standard
	[23036]	= '0;0',	-- Battle Standard
	[23161]	= '0;0',	-- Dreadsteed
	[23214]	= '0;0',	-- Summon Charger
	[23219]	= '0;0',	-- Swift Mistsaber
	[23221]	= '0;0',	-- Swift Frostsaber
	[23227]	= '0;0',	-- Swift Palomino
	[23228]	= '0;0',	-- Swift White Steed
	[23229]	= '0;0',	-- Swift Brown Steed
	[23238]	= '0;0',	-- Swift Brown Ram
	[23239]	= '0;0',	-- Swift Gray Ram
	[23240]	= '0;0',	-- Swift White Ram
	[23241]	= '0;0',	-- Swift Blue Raptor
	[23242]	= '0;0',	-- Swift Olive Raptor
	[23243]	= '0;0',	-- Swift Orange Raptor
	[23246]	= '0;0',	-- Purple Skeletal Warhorse
	[23247]	= '0;0',	-- Great White Kodo
	[23248]	= '0;0',	-- Great Gray Kodo
	[23249]	= '0;0',	-- Great Brown Kodo
	[23250]	= '0;0',	-- Swift Brown Wolf
	[23251]	= '0;0',	-- Swift Timber Wolf
	[23252]	= '0;0',	-- Swift Gray Wolf
	[23333]	= '0;0',	-- Warsong Flag
	[23335]	= '0;0',	-- Silverwing Flag
	[23338]	= '0;0',	-- Swift Stormsaber
	[23451]	= '10;0',	-- Speed
	[23493]	= '10;0',	-- Restoration
	[23509]	= '0;0',	-- Frostwolf Howler
	[23510]	= '0;0',	-- Stormpike Battle Charger
	[23511]	= '30;0',	-- Demoralizing Shout
	[23693]	= '120;0',	-- Stormpike's Salvation
	[23694]	= '5;0',	-- Improved Hamstring
	[23885]	= '8;0',	-- Bloodthirst
	[23920]	= '5;0',	-- Spell Reflection
	[23978]	= '10;0',	-- Speed
	[24242]	= '0;0',	-- Swift Razzashi Raptor
	[24252]	= '0;0',	-- Swift Zulian Tiger
	[24259]	= '3;1',	-- Spell Lock
	[24378]	= '60;0',	-- Berserking
	[24450]	= '0;0',	-- Prowl
	[24529]	= '0;0',	-- Spirit Bond
	[24711]	= '3600;0',	-- Ninja Costume
	[24735]	= '3600;0',	-- Ghost Costume
	[24858]	= '0;0',	-- Moonkin Form
	[24907]	= '0;0',	-- Moonkin Aura
	[24932]	= '0;0',	-- Leader of the Pack
	[25046]	= '2;1',	-- Arcane Torrent
	[25163]	= '0;0',	-- Oozeling's Disgusting Aura
	[25228]	= '0;0',	-- Soul Link
	[25771]	= '120;0',	-- Forbearance
	[25780]	= '0;1',	-- Righteous Fury
	[25804]	= '900;0',	-- Rumsey Rum Black Label
	[25809]	= '12;3',	-- Crippling Poison
	[25810]	= '12;3',	-- Mind-numbing Poison
	[26004]	= '1800;0',	-- Mistletoe
	[26013]	= '900;0',	-- Deserter
	[26017]	= '30;1',	-- Vindication
	[26297]	= '10;0',	-- Berserking
	[27089]	= '30;0',	-- Drink
	[27813]	= '6;1',	-- Blessed Recovery
	[27818]	= '6;1',	-- Blessed Recovery
	[27827]	= '15;0',	-- Spirit of Redemption
	[28093]	= '15;0',	-- Lightning Speed
	[28176]	= '1800;0',	-- Fel Armor
	[28497]	= '3600;0',	-- Mighty Agility
	[28520]	= '3600;0',	-- Flask of Relentless Assault
	[28730]	= '2;1',	-- Arcane Torrent
	[28878]	= '0;0',	-- Heroic Presence
	[29131]	= '10;0',	-- Bloodrage
	[29166]	= '10;1',	-- Innervate
	[29178]	= '10;0',	-- Elemental Devastation
	[29348]	= '900;0',	-- Goldenmist Special Brew
	[29703]	= '6;0',	-- Dazed
	[29801]	= '0;0',	-- Rampage
	[29842]	= '10;0',	-- Second Wind
	[30070]	= '0;0',	-- Blood Frenzy
	[30802]	= '0;0',	-- Unleashed Rage
	[30823]	= '15;0',	-- Shamanistic Rage
	[31224]	= '5;0',	-- Cloak of Shadows
	[31579]	= '0;0',	-- Arcane Empowerment
	[31583]	= '0;0',	-- Arcane Empowerment
	[31589]	= '15;1',	-- Slow
	[31616]	= '10;0',	-- Nature's Guardian
	[31661]	= '5;1',	-- Dragon's Breath
	[31665]	= '0;0',	-- Master of Subtlety
	[31790]	= '3;0',	-- Righteous Defense
	[31801]	= '1800;0',	-- Seal of Truth
	[31803]	= '15;0',	-- Censure
	[31821]	= '6;0',	-- Aura Mastery
	[31842]	= '20;1',	-- Divine Favor
	[31884]	= '20;1',	-- Avenging Wrath
	[32182]	= '40;1',	-- Heroism
	[32223]	= '0;0',	-- Crusader Aura
	[32243]	= '0;0',	-- Tawny Wind Rider
	[32244]	= '0;0',	-- Blue Wind Rider
	[32245]	= '0;0',	-- Green Wind Rider
	[32246]	= '0;0',	-- Swift Red Wind Rider
	[32295]	= '0;0',	-- Swift Green Wind Rider
	[32297]	= '0;0',	-- Swift Purple Wind Rider
	[32388]	= '12;1',	-- Shadow Embrace
	[32600]	= '10;0',	-- Avoidance
	[32612]	= '20;0',	-- Invisibility
	[33197]	= '24;0',	-- Misery
	[33198]	= '24;0',	-- Misery
	[33206]	= '8;1',	-- Pain Suppression
	[33256]	= '1800;0',	-- Well Fed
	[33263]	= '1800;0',	-- Well Fed
	[33268]	= '1800;0',	-- Well Fed
	[33280]	= '3600;0',	-- Corporal
	[33395]	= '8;1',	-- Freeze
	[33660]	= '0;0',	-- Swift Pink Hawkstrider
	[33697]	= '15;0',	-- Blood Fury
	[33721]	= '3600;0',	-- Spellpower Elixir
	[33763]	= '10;1',	-- Lifebloom
	[33786]	= '6;0',	-- Cyclone
	[33891]	= '30;0',	-- Tree of Life
	[33943]	= '0;0',	-- Flight Form
	[34321]	= '10;0',	-- Call of the Nexus
	[34471]	= '10;0',	-- The Beast Within
	[34477]	= '20;0',	-- Misdirection
	[34490]	= '3;1',	-- Silencing Shot
	[34655]	= '8;3',	-- Deadly Poison
	[34767]	= '0;0',	-- Summon Charger
	[34769]	= '0;0',	-- Summon Warhorse
	[34790]	= '0;0',	-- Dark War Talbuk
	[34795]	= '0;0',	-- Red Hawkstrider
	[34837]	= '8;0',	-- Master Tactician
	[34896]	= '0;0',	-- Cobalt War Talbuk
	[34897]	= '0;0',	-- White War Talbuk
	[34898]	= '0;0',	-- Silver War Talbuk
	[34899]	= '0;0',	-- Tan War Talbuk
	[34936]	= '8;1',	-- Backlash
	[35020]	= '0;0',	-- Blue Hawkstrider
	[35025]	= '0;0',	-- Swift Green Hawkstrider
	[35027]	= '0;0',	-- Swift Purple Hawkstrider
	[35028]	= '0;0',	-- Swift Warstrider
	[35098]	= '20;0',	-- Rapid Killing
	[35099]	= '20;0',	-- Rapid Killing
	[35101]	= '4;0',	-- Concussive Barrage
	[35696]	= '0;0',	-- Demonic Knowledge
	[35706]	= '0;0',	-- Master Demonologist
	[35713]	= '0;0',	-- Great Blue Elekk
	[35714]	= '0;0',	-- Great Purple Elekk
	[36032]	= '6;0',	-- Arcane Blast
	[36444]	= '0;0',	-- Wintergrasp Water
	[36554]	= '3;0',	-- Shadowstep
	[36563]	= '10;0',	-- Shadowstep
	[37795]	= '3600;0',	-- Recruit
	[38384]	= '8;1',	-- Cone of Cold
	[39315]	= '0;0',	-- Cobalt Riding Talbuk
	[39316]	= '0;0',	-- Dark Riding Talbuk
	[39317]	= '0;0',	-- Silver Riding Talbuk
	[39319]	= '0;0',	-- White Riding Talbuk
	[39439]	= '10;0',	-- Aura of the Crusader
	[39627]	= '3600;0',	-- Elixir of Draenic Wisdom
	[39796]	= '3;1',	-- Stoneclaw Stun
	[39800]	= '0;0',	-- Red Riding Nether Ray
	[39802]	= '0;0',	-- Silver Riding Nether Ray
	[40120]	= '0;0',	-- Swift Flight Form
	[40623]	= '3600;0',	-- Apexis Vibrations
	[40625]	= '5400;0',	-- Apexis Emanations
	[41252]	= '0;0',	-- Raven Lord
	[41425]	= '30;0',	-- Hypothermia
	[41514]	= '0;0',	-- Azure Netherwing Drake
	[41516]	= '0;0',	-- Purple Netherwing Drake
	[42138]	= '7200;0',	-- Brewfest Enthusiast
	[42292]	= '0.1;0',	-- PvP Trinket
	[42650]	= '4;0',	-- Army of the Dead
	[43180]	= '30;0',	-- Food
	[43183]	= '30;0',	-- Drink
	[43196]	= '1800;1',	-- Armor
	[43265]	= '10;0',	-- Death and Decay
	[43680]	= '60;0',	-- Idle
	[43681]	= '60;0',	-- Inactive
	[43688]	= '0;0',	-- Amani War Bear
	[43751]	= '10;0',	-- Energized
	[43771]	= '3600;0',	-- Well Fed
	[43900]	= '0;0',	-- Swift Brewfest Ram
	[43927]	= '0;0',	-- Cenarion War Hippogryph
	[44151]	= '0;0',	-- Turbo-Charged Flying Machine
	[44153]	= '0;0',	-- Flying Machine
	[44413]	= '10;1',	-- Incanter's Absorption
	[44521]	= '0;0',	-- Preparation
	[44535]	= '6;0',	-- Spirit Heal
	[44572]	= '5;1',	-- Deep Freeze
	[44795]	= '0;0',	-- Parachute
	[45182]	= '3;0',	-- Cheating Death
	[45241]	= '8;1',	-- Focused Will
	[45242]	= '8;1',	-- Focused Will
	[45282]	= '8;1',	-- Natural Perfection
	[45283]	= '8;1',	-- Natural Perfection
	[45334]	= '4;0',	-- Feral Charge Effect
	[45373]	= '7200;0',	-- Bloodberry
	[45438]	= '10;1',	-- Ice Block
	[45472]	= '60;0',	-- Parachute
	[45524]	= '8;0',	-- Chains of Ice
	[45529]	= '20;0',	-- Blood Tap
	[45544]	= '8;0',	-- First Aid
	[45548]	= '30;0',	-- Food
	[46168]	= '0;0',	-- Pet Biscuit
	[46199]	= '0;0',	-- X-51 Nether-Rocket X-TREME
	[46356]	= '300;0',	-- Blood Elf Illusion
	[46604]	= '4;1',	-- Ice Block
	[46628]	= '0;0',	-- Swift White Hawkstrider
	[46833]	= '15;0',	-- Wrath of Elune
	[46857]	= '60;0',	-- Trauma
	[46916]	= '10;0',	-- Bloodsurge
	[46924]	= '6;0',	-- Bladestorm
	[46968]	= '4;0',	-- Shockwave
	[46987]	= '4;1',	-- Frostbolt
	[46989]	= '3;1',	-- Improved Blink
	[47241]	= '30;0',	-- Metamorphosis
	[47476]	= '5;1',	-- Strangulate
	[47481]	= '0;0',	-- Gnaw
	[47585]	= '6;0',	-- Dispersion
	[47753]	= '12;1',	-- Divine Aegis
	[47930]	= '15;1',	-- Grace
	[48018]	= '360;0',	-- Demonic Circle: Summon
	[48024]	= '0;0',	-- Headless Horseman's Mount
	[48027]	= '0;0',	-- Black War Elekk
	[48101]	= '1800;1',	-- Stamina
	[48111]	= '30;1',	-- Prayer of Mending
	[48263]	= '0;0',	-- Blood Presence
	[48265]	= '0;0',	-- Unholy Presence
	[48266]	= '0;0',	-- Frost Presence
	[48301]	= '10;0',	-- Mind Trauma
	[48391]	= '10;5',	-- Owlkin Frenzy
	[48418]	= '0;0',	-- Master Shapeshifter
	[48420]	= '0;0',	-- Master Shapeshifter
	[48421]	= '0;0',	-- Master Shapeshifter
	[48504]	= '15;0',	-- Living Seed
	[48517]	= '0;0',	-- Eclipse (Solar)
	[48518]	= '0;0',	-- Eclipse (Lunar)
	[48707]	= '5;0',	-- Anti-Magic Shell
	[48778]	= '0;0',	-- Acherus Deathcharger
	[48792]	= '12;0',	-- Icebound Fortitude
	[48836]	= '5;0',	-- Vengeful Justice
	[49016]	= '30;5',	-- Unholy Frenzy
	[49028]	= '12;0',	-- Dancing Rune Weapon
	[49039]	= '10;0',	-- Lichborne
	[49203]	= '0;1',	-- Hungering Cold
	[49206]	= '40;0',	-- Summon Gargoyle
	[49222]	= '300;0',	-- Bone Shield
	[49322]	= '0;0',	-- Swift Zhevra
	[49379]	= '0;0',	-- Great Brewfest Kodo
	[49560]	= '3;0',	-- Death Grip
	[49759]	= '30;0',	-- Teleport
	[50227]	= '5;0',	-- Sword and Board
	[50259]	= '3;0',	-- Dazed
	[50334]	= '15;0',	-- Berserk
	[50411]	= '3;0',	-- Dazed
	[50421]	= '20;0',	-- Scent of Blood
	[50461]	= '30;0',	-- Anti-Magic Zone
	[50518]	= '25;0',	-- Ravage
	[50519]	= '2;0',	-- Sonic Blast
	[50536]	= '10;0',	-- Unholy Blight
	[50589]	= '15;0',	-- Immolation Aura
	[50613]	= '2;1',	-- Arcane Torrent
	[50989]	= '3;0',	-- Flame Breath
	[51124]	= '10;0',	-- Killing Machine
	[51271]	= '20;0',	-- Pillar of Frost
	[51470]	= '0;0',	-- Elemental Oath
	[51514]	= '60;4',	-- Hex
	[51585]	= '8;0',	-- Blade Twisting
	[51690]	= '2;0',	-- Killing Spree
	[51693]	= '8;0',	-- Waylay
	[51713]	= '6;0',	-- Shadow Dance
	[51722]	= '10;0',	-- Dismantle
	[52127]	= '600;1',	-- Water Shield
	[52179]	= '0;0',	-- Astral Shift
	[52418]	= '0;0',	-- Carrying Seaforium
	[52437]	= '2;0',	-- Sudden Death
	[52459]	= '10;0',	-- End of Round
	[52610]	= '9;5',	-- Savage Roar
	[52910]	= '8;0',	-- Turn the Tables
	[53137]	= '0;0',	-- Abomination's Might
	[53138]	= '0;0',	-- Abomination's Might
	[53148]	= '1;0',	-- Charge
	[53220]	= '8;0',	-- Improved Steady Shot
	[53257]	= '15;0',	-- Cobra Strikes
	[53283]	= '30;0',	-- Food
	[53284]	= '1800;0',	-- Well Fed
	[53365]	= '15;0',	-- Unholy Strength
	[53390]	= '15;1',	-- Tidal Waves
	[53401]	= '20;0',	-- Rabid
	[53403]	= '20;0',	-- Rabid Power
	[53426]	= '5;0',	-- Lick Your Wounds
	[53434]	= '20;0',	-- Call of the Wild
	[53477]	= '3;0',	-- Taunt
	[53480]	= '12;0',	-- Roar of Sacrifice
	[53515]	= '8;1',	-- Owl's Focus
	[53517]	= '9;1',	-- Roar of Recovery
	[53563]	= '60;1',	-- Beacon of Light
	[53657]	= '60;0',	-- Judgements of the Pure
	[53746]	= '3600;0',	-- Wrath Elixir
	[53748]	= '3600;0',	-- Mighty Strength
	[53749]	= '3600;0',	-- Guru's Elixir
	[53751]	= '3600;0',	-- Elixir of Mighty Fortitude
	[53752]	= '3600;0',	-- Lesser Flask of Toughness
	[53755]	= '3600;0',	-- Flask of the Frost Wyrm
	[53758]	= '3600;0',	-- Flask of Stoneblood
	[53760]	= '3600;0',	-- Flask of Endless Rage
	[53768]	= '0;0',	-- Haunted
	[53806]	= '600;0',	-- Pygmy Oil
	[53817]	= '30;0',	-- Maelstrom Weapon
	[53908]	= '15;0',	-- Speed
	[54131]	= '5;0',	-- Bloodthirsty
	[54149]	= '15;0',	-- Infusion of Light
	[54212]	= '3600;0',	-- Flask of Pure Mojo
	[54277]	= '15;1',	-- Backdraft
	[54370]	= '12;1',	-- Nether Protection (Holy)
	[54371]	= '12;1',	-- Nether Protection (Fire)
	[54372]	= '12;1',	-- Nether Protection (Frost)
	[54373]	= '12;1',	-- Nether Protection (Arcane)
	[54374]	= '12;1',	-- Nether Protection (Shadow)
	[54375]	= '12;1',	-- Nether Protection (Nature)
	[54428]	= '15;1',	-- Divine Plea
	[54501]	= '6;0',	-- Consume Shadows
	[54508]	= '15;5',	-- Demonic Empowerment
	[54643]	= '20;0',	-- Teleport
	[54646]	= '1800;1',	-- Focus Magic
	[54648]	= '10;1',	-- Focus Magic
	[54726]	= '0;0',	-- Winged Steed of the Ebon Blade
	[54727]	= '0;0',	-- Winged Steed of the Ebon Blade
	[54753]	= '0;0',	-- White Polar Bear
	[54758]	= '12;0',	-- Hyperspeed Acceleration
	[54833]	= '10;1',	-- Innervate
	[54839]	= '10;0',	-- Purified Spirit
	[54861]	= '5;0',	-- Nitro Boosts
	[55001]	= '30;0',	-- Parachute
	[55018]	= '10;0',	-- Sonic Awareness
	[55021]	= '4;1',	-- Silenced - Improved Counterspell
	[55078]	= '21;2',	-- Blood Plague
	[55080]	= '3;1',	-- Shattered Barrier
	[55095]	= '21;2',	-- Frost Fever
	[55166]	= '20;1',	-- Tidal Force
	[55233]	= '10;0',	-- Vampiric Blood
	[55277]	= '15;0',	-- Stoneclaw Totem
	[55428]	= '20;0',	-- Lifeblood
	[55480]	= '20;0',	-- Lifeblood
	[55502]	= '20;0',	-- Lifeblood
	[55503]	= '20;0',	-- Lifeblood
	[55531]	= '0;0',	-- Mechano-hog
	[55610]	= '0;0',	-- Improved Icy Talons
	[55629]	= '3600;0',	-- First Lieutenant
	[55637]	= '15;0',	-- Lightweave
	[55694]	= '10;0',	-- Enraged Regeneration
	[55711]	= '480;0',	-- Weakened Heart
	[55741]	= '20;0',	-- Desecration
	[55817]	= '3600;0',	-- Eck Residue
	[56222]	= '3;0',	-- Dark Command
	[56453]	= '12;0',	-- Lock and Load
	[56520]	= '1800;1',	-- Blessing of Might
	[56654]	= '6;0',	-- Rapid Recuperation
	[57073]	= '30;0',	-- Drink
	[57100]	= '3600;0',	-- Well Fed
	[57102]	= '3600;0',	-- Well Fed
	[57111]	= '3600;0',	-- Well Fed
	[57286]	= '3600;0',	-- Well Fed
	[57288]	= '3600;0',	-- Well Fed
	[57291]	= '3600;0',	-- Well Fed
	[57294]	= '3600;0',	-- Well Fed
	[57325]	= '3600;0',	-- Well Fed
	[57327]	= '3600;0',	-- Well Fed
	[57329]	= '3600;0',	-- Well Fed
	[57330]	= '120;0',	-- Horn of Winter
	[57332]	= '3600;0',	-- Well Fed
	[57334]	= '3600;0',	-- Well Fed
	[57348]	= '0;0',	-- Carrying an RP-GG
	[57350]	= '6;1',	-- Illusionary Barrier
	[57356]	= '3600;0',	-- Well Fed
	[57358]	= '3600;0',	-- Well Fed
	[57365]	= '3600;0',	-- Well Fed
	[57367]	= '3600;0',	-- Well Fed
	[57371]	= '3600;0',	-- Well Fed
	[57399]	= '3600;0',	-- Well Fed
	[57516]	= '12;5',	-- Enrage
	[57524]	= '120;1',	-- Metanoia
	[57531]	= '0;1',	-- Arcane Potency
	[57669]	= '15;0',	-- Replenishment
	[57723]	= '600;0',	-- Exhaustion
	[57724]	= '600;0',	-- Sated
	[57761]	= '15;1',	-- Brain Freeze
	[57819]	= '0;0',	-- Argent Champion
	[57820]	= '0;0',	-- Ebon Champion
	[57821]	= '0;0',	-- Champion of the Kirin Tor
	[57822]	= '0;0',	-- Wyrmrest Champion
	[57933]	= '6;0',	-- Tricks of the Trade
	[57934]	= '20;0',	-- Tricks of the Trade
	[57940]	= '0;0',	-- Essence of Wintergrasp
	[58045]	= '0;0',	-- Essence of Wintergrasp
	[58179]	= '12;2',	-- Infected Wounds
	[58371]	= '180;0',	-- Recently Slain
	[58374]	= '10;0',	-- Glyph of Shield Block
	[58427]	= '0;0',	-- Overkill
	[58449]	= '1800;1',	-- Strength
	[58450]	= '1800;1',	-- Agility
	[58499]	= '7200;0',	-- Happy
	[58500]	= '7200;0',	-- Angry
	[58511]	= '45;0',	-- Rotten Apple Aroma
	[58514]	= '45;0',	-- Rotten Banana Aroma
	[58519]	= '45;0',	-- Spit
	[58549]	= '1800;0',	-- Tenacity
	[58555]	= '180;0',	-- Great Honor
	[58556]	= '180;0',	-- Greater Honor
	[58557]	= '180;0',	-- Greatest Honor
	[58567]	= '30;0',	-- Sunder Armor
	[58600]	= '10;0',	-- Restricted Flight Area
	[58617]	= '10;0',	-- Glyph of Heart Strike
	[58683]	= '0;0',	-- Savage Combat
	[58729]	= '0;0',	-- Spiritual Immunity
	[58861]	= '2;0',	-- Bash
	[58875]	= '15;0',	-- Spirit Walk
	[58882]	= '6;0',	-- Rapid Recuperation
	[59052]	= '15;1',	-- Freezing Fog
	[59542]	= '15;0',	-- Gift of the Naaru
	[59547]	= '15;0',	-- Gift of the Naaru
	[59548]	= '15;0',	-- Gift of the Naaru
	[59568]	= '0;0',	-- Blue Drake
	[59569]	= '0;0',	-- Bronze Drake
	[59570]	= '0;0',	-- Red Drake
	[59578]	= '15;1',	-- The Art of War
	[59620]	= '15;0',	-- Berserk
	[59626]	= '10;0',	-- Black Magic
	[59628]	= '6;0',	-- Tricks of the Trade
	[59638]	= '4;1',	-- Frostbolt
	[59725]	= '5;0',	-- Spell Reflection
	[59752]	= '0.1;0',	-- Every Man for Himself
	[59785]	= '0;0',	-- Black War Mammoth
	[59788]	= '0;0',	-- Black War Mammoth
	[59793]	= '0;0',	-- Wooly Mammoth
	[59797]	= '0;0',	-- Ice Mammoth
	[59889]	= '6;1',	-- Borrowed Time
	[59911]	= '1800;0',	-- Tenacity
	[59961]	= '0;0',	-- Red Proto-Drake
	[59996]	= '0;0',	-- Blue Proto-Drake
	[60002]	= '0;0',	-- Time-Lost Proto-Drake
	[60024]	= '0;0',	-- Violet Proto-Drake
	[60025]	= '0;0',	-- Albino Drake
	[60062]	= '10;0',	-- Essence of Life
	[60064]	= '10;0',	-- Now is the time!
	[60065]	= '10;0',	-- Reflection of Torment
	[60097]	= '10;0',	-- Feeding Frenzy
	[60114]	= '0;0',	-- Armored Brown Bear
	[60116]	= '0;0',	-- Armored Brown Bear
	[60118]	= '0;0',	-- Black War Bear
	[60119]	= '0;0',	-- Black War Bear
	[60196]	= '12;0',	-- Berserker!
	[60214]	= '20;0',	-- Seal of the Pantheon
	[60215]	= '40;0',	-- Lavanthor's Talisman
	[60218]	= '10;0',	-- Essence of Gossamer
	[60229]	= '15;0',	-- Greatness
	[60233]	= '15;0',	-- Greatness
	[60234]	= '15;0',	-- Greatness
	[60302]	= '10;0',	-- Meteorite Whetstone
	[60305]	= '20;0',	-- Heart of a Dragon
	[60314]	= '10;0',	-- Fury of the Five Flights
	[60318]	= '13;0',	-- Edward's Insight
	[60340]	= '3600;0',	-- Accuracy
	[60341]	= '3600;0',	-- Deadly Strikes
	[60345]	= '3600;0',	-- Armor Piercing
	[60346]	= '3600;0',	-- Lightning Speed
	[60347]	= '3600;0',	-- Mighty Thoughts
	[60424]	= '0;0',	-- Mekgineer's Chopper
	[60433]	= '12;1',	-- Earth and Moon
	[60437]	= '10;0',	-- Grim Toll
	[60479]	= '10;0',	-- Forge Ember
	[60503]	= '9;0',	-- Taste for Blood
	[60512]	= '15;0',	-- Healing Trance
	[60520]	= '15;0',	-- Spark of Life
	[60525]	= '10;0',	-- Majestic Dragon Figurine
	[60549]	= '10;0',	-- Deadly Aggression
	[60551]	= '10;0',	-- Furious Gladiator's Libram of Fortitude
	[60553]	= '10;0',	-- Relentless Aggression
	[60568]	= '10;0',	-- Furious Gladiator's Idol of Steadfastness
	[60946]	= '5;1',	-- Nightmare
	[60947]	= '5;1',	-- Nightmare
	[60956]	= '0;0',	-- Improved Health Funnel
	[61258]	= '5;0',	-- Runic Return
	[61294]	= '0;0',	-- Green Proto-Drake
	[61309]	= '0;0',	-- Magnificent Flying Carpet
	[61316]	= '3600;1',	-- Dalaran Brilliance
	[61336]	= '12;0',	-- Survival Instincts
	[61394]	= '4;1',	-- Frozen Wake
	[61427]	= '20;0',	-- Infinite Speed
	[61447]	= '0;0',	-- Traveler's Tundra Mammoth
	[61465]	= '0;0',	-- Grand Black War Mammoth
	[61467]	= '0;0',	-- Grand Black War Mammoth
	[61469]	= '0;0',	-- Grand Ice Mammoth
	[61485]	= '60;0',	-- Dreadful Roar
	[61573]	= '0;0',	-- Banner of the Alliance
	[61619]	= '10;0',	-- Tentacles
	[61671]	= '10;0',	-- Crusader's Glory
	[61684]	= '16;0',	-- Dash
	[61685]	= '4;0',	-- Charge
	[61721]	= '50;1',	-- Polymorph
	[61858]	= '9;0',	-- Plague Slime
	[62064]	= '1800;0',	-- Tower Control
	[62124]	= '3;0',	-- Hand of Reckoning
	[62408]	= '300;0',	-- Ethereal Oil
	[62552]	= '60;0',	-- Defend
	[62574]	= '0;0',	-- Warts-B-Gone Lip Balm
	[62606]	= '10;0',	-- Savage Defense
	[63167]	= '10;1',	-- Decimation
	[63232]	= '0;0',	-- Stormwind Steed
	[63283]	= '300;0',	-- Totem of Wrath
	[63433]	= '0;0',	-- Orgrimmar Champion's Pennant
	[63468]	= '8;0',	-- Piercing Shots
	[63500]	= '0;0',	-- Argent Crusade Valiant's Pennant
	[63529]	= '10;1',	-- Dazed - Avenger's Shield
	[63619]	= '5;0',	-- Shadowcrawl
	[63635]	= '0;0',	-- Darkspear Raptor
	[63640]	= '0;0',	-- Orgrimmar Wolf
	[63641]	= '0;0',	-- Thunder Bluff Kodo
	[63665]	= '2.5;0',	-- Charge
	[63672]	= '15;1',	-- ObsoleteBlack Arrow
	[63685]	= '5;1',	-- Freeze
	[63729]	= '3600;0',	-- Elixir of Minor Accuracy
	[63844]	= '0;0',	-- Argent Hippogryph
	[63963]	= '0;0',	-- Rusted Proto-Drake
	[64044]	= '3;1',	-- Psychic Horror
	[64058]	= '10;0',	-- Psychic Horror
	[64205]	= '10;1',	-- Divine Sacrifice
	[64368]	= '10;1',	-- Eradication
	[64370]	= '10;1',	-- Eradication
	[64371]	= '10;1',	-- Eradication
	[64373]	= '0;0',	-- Armistice
	[64419]	= '15;0',	-- Sniper Training
	[64420]	= '15;0',	-- Sniper Training
	[64440]	= '10;0',	-- Blade Warding
	[64524]	= '20;0',	-- Platinum Disks of Battle
	[64568]	= '20;0',	-- Blood Reserve
	[64658]	= '0;0',	-- Black Wolf
	[64659]	= '0;0',	-- Venomhide Ravasaur
	[64695]	= '5;1',	-- Earthgrab
	[64701]	= '15;1',	-- Elemental Mastery
	[64810]	= '300;0',	-- Bested Ironforge
	[64844]	= '8;1',	-- Divine Hymn
	[64855]	= '10;0',	-- Blade Barrier
	[64856]	= '10;0',	-- Blade Barrier
	[64951]	= '12;0',	-- Primal Wrath
	[64977]	= '0;0',	-- Black Skeletal Horse
	[65019]	= '10;0',	-- Mjolnir Runestone
	[65156]	= '10;0',	-- Juggernaut
	[65247]	= '3600;0',	-- Well Fed
	[65264]	= '6;1',	-- Lava Flows
	[65639]	= '0;0',	-- Swift Red Hawkstrider
	[65641]	= '0;0',	-- Great Golden Kodo
	[65642]	= '0;0',	-- Turbostrider
	[65644]	= '0;0',	-- Swift Purple Raptor
	[65645]	= '0;0',	-- White Skeletal Warhorse
	[65646]	= '0;0',	-- Swift Burgundy Wolf
	[65745]	= '300;0',	-- Path of Cenarius
	[66090]	= '0;0',	-- Quel'dorei Steed
	[66091]	= '0;0',	-- Sunreaver Hawkstrider
	[66122]	= '0;0',	-- Magic Rooster
	[66157]	= '0;0',	-- Honorable Defender
	[66803]	= '20;0',	-- Desolation
	[66846]	= '0;0',	-- Ochre Skeletal Warhorse
	[66906]	= '0;0',	-- Argent Charger
	[67016]	= '3600;0',	-- Flask of the North
	[67017]	= '3600;0',	-- Flask of the North
	[67018]	= '3600;0',	-- Flask of the North
	[67117]	= '15;0',	-- Unholy Might
	[67354]	= '9;0',	-- Evasion
	[67355]	= '16;0',	-- Agile
	[67358]	= '9;0',	-- Rejuvenating
	[67360]	= '12;0',	-- Blessing of the Moon Goddess
	[67364]	= '15;0',	-- Holy Judgement
	[67371]	= '16;0',	-- Holy Strength
	[67378]	= '18;0',	-- Evasion
	[67383]	= '20;0',	-- Unholy Force
	[67388]	= '15;0',	-- Spiritual Trance
	[67391]	= '18;0',	-- Volcanic Fury
	[67466]	= '0;0',	-- Argent Warhorse
	[67596]	= '15;0',	-- Tremendous Fortitude
	[67631]	= '10;1',	-- Aegis
	[67669]	= '10;0',	-- Elusive Power
	[67671]	= '10;0',	-- Fury
	[67683]	= '20;0',	-- Celerity
	[67684]	= '20;0',	-- Hospitality
	[67694]	= '20;0',	-- Defensive Tactics
	[67695]	= '20;0',	-- Rage
	[67696]	= '10;0',	-- Energized
	[67703]	= '15;0',	-- Paragon
	[67708]	= '15;0',	-- Paragon
	[67713]	= '0;0',	-- Mote of Flame
	[67737]	= '0;0',	-- Risen Fury
	[67738]	= '20;0',	-- Rising Fury
	[67890]	= '3;0',	-- Cobalt Frag Bomb
	[68054]	= '600;0',	-- Pressing Engagement
	[68055]	= '20;1',	-- Judgements of the Just
	[68056]	= '0;0',	-- Swift Horde Wolf
	[68057]	= '0;0',	-- Swift Alliance Steed
	[68269]	= '0;0',	-- The Brewmaiden's Blessing
	[68766]	= '20;0',	-- Desecration
	[69369]	= '8;1',	-- Predator's Swiftness
	[70013]	= '0;0',	-- Quel'Delar's Compulsion
	[70029]	= '0.1;0',	-- The Beast Within
	[70657]	= '15;0',	-- Advantage
	[70691]	= '15;1',	-- Rejuvenation
	[70721]	= '6;0',	-- Omen of Doom
	[70725]	= '10;0',	-- Enraged Defense
	[70728]	= '10;0',	-- Exploit Weakness
	[70753]	= '5;0',	-- Pushing the Limit
	[70757]	= '10;0',	-- Holiness
	[70806]	= '10;0',	-- Rapid Currents
	[70840]	= '10;0',	-- Devious Minds
	[70855]	= '10;0',	-- Blood Drinker
	[70893]	= '10;0',	-- Culling the Herd
	[70940]	= '6;0',	-- Divine Guardian
	[23223]	= '0;0',	-- Swift White Mechanostrider
	[41513]	= '0;0',	-- Onyx Netherwing Drake
	[53805]	= '600;0',	-- Pygmy Oil
	[71007]	= '10;0',	-- Stinger
	[71041]	= '1800;0',	-- Dungeon Deserter
	[71165]	= '15;0',	-- Molten Core
	[71177]	= '15;0',	-- Vicious
	[71184]	= '15;0',	-- Soothing
	[71187]	= '15;0',	-- Formidable
	[71192]	= '15;0',	-- Blessed
	[71197]	= '15;0',	-- Evasive
	[71199]	= '30;0',	-- Furious
	[71216]	= '15;0',	-- Enraged
	[71220]	= '15;0',	-- Energized
	[71227]	= '15;0',	-- Indomitable
	[71396]	= '10;0',	-- Rage of the Fallen
	[71401]	= '15;0',	-- Icy Rage
	[71403]	= '10;0',	-- Fatal Flaws
	[71432]	= '0;0',	-- Mote of Anger
	[71484]	= '30;0',	-- Strength of the Taunka
	[71486]	= '30;0',	-- Power of the Taunka
	[71491]	= '30;0',	-- Aim of the Iron Dwarves
	[71492]	= '30;0',	-- Speed of the Vrykul
	[71564]	= '20;0',	-- Deadly Precision
	[71570]	= '10;0',	-- Cultivated Power
	[71572]	= '10;0',	-- Cultivated Power
	[71584]	= '15;0',	-- Revitalized
	[71586]	= '10;0',	-- Hardened Skin
	[71600]	= '20;0',	-- Surging Power
	[71601]	= '20;0',	-- Surge of Power
	[71633]	= '10;0',	-- Thick Skin
	[71824]	= '6;1',	-- Lava Burst
	[71864]	= '6;0',	-- Fountain of Light
	[71882]	= '10;1',	-- Invigoration
	[72412]	= '10;0',	-- Frostforged Champion
	[72414]	= '10;0',	-- Frostforged Defender
	[72416]	= '10;0',	-- Frostforged Sage
	[72418]	= '10;0',	-- Chilling Knowledge
	[72586]	= '1800;1',	-- Blessing of Forgotten Kings
	[72590]	= '3600;1',	-- Fortitude
	[72808]	= '0;0',	-- Bloodbathed Frostbrood Vanquisher
	[72968]	= '0;0',	-- Precious's Ribbon
	[73313]	= '0;0',	-- Crimson Deathcharger
	[74347]	= '3;1',	-- Silenced - Gag Order
	[75447]	= '0;0',	-- Ferocious Inspiration
	[75596]	= '0;0',	-- Frosty Flying Carpet
	[75617]	= '0;0',	-- Celestial Steed
	[75618]	= '0;0',	-- Celestial Steed
	[75619]	= '0;0',	-- Celestial Steed
	[75620]	= '0;0',	-- Celestial Steed
	[75957]	= '0;0',	-- X-53 Touring Rocket
	[75972]	= '0;0',	-- X-53 Touring Rocket
	[5784]	= '0;0',	-- Felsteed
	[8733]	= '3600;0',	-- Blessing of Blackfathom
	[19740]	= '3600;0',	-- Blessing of Might
	[25040]	= '900;0',	-- Mark of Nature
	[27683]	= '3600;0',	-- Shadow Protection
	[32386]	= '12;1',	-- Shadow Embrace
	[35018]	= '0;0',	-- Purple Hawkstrider
	[35022]	= '0;0',	-- Black Hawkstrider
	[45123]	= '0;0',	-- Romantic Picnic
	[46202]	= '10;0',	-- Pierce Armor
	[51987]	= '20;0',	-- Arcane Infusion
	[53747]	= '3600;0',	-- Elixir of Spirit
	[54452]	= '3600;0',	-- Adept's Elixir
	[54842]	= '0;0',	-- Thunder Charge
	[57107]	= '3600;0',	-- Well Fed
	[58269]	= '0;0',	-- Iceskin Stoneform
	[58501]	= '600;1',	-- Iron Boot Flask
	[60494]	= '10;0',	-- Dying Curse
	[60569]	= '10;0',	-- Relentless Survival
	[62061]	= '3600;0',	-- Festive Holiday Mount
	[64657]	= '0;0',	-- White Kodo
	[64731]	= '0;0',	-- Sea Turtle
	[65006]	= '10;0',	-- Eye of the Broodmother
	[66088]	= '0;0',	-- Sunreaver Dragonhawk
	[3593]	= '3600;0',	-- Elixir of Fortitude
	[8272]	= '600;1',	-- Mind Tremor
	[11396]	= '3600;0',	-- Greater Intellect
	[11841]	= '600;1',	-- Static Barrier
	[21562]	= '3600;0',	-- Power Word: Fortitude
	[23844]	= '0;0',	-- Master Demonologist
	[32752]	= '5;0',	-- Summoning Disorientation
	[33257]	= '1800;0',	-- Well Fed
	[50434]	= '10;0',	-- Chilblains
	[50720]	= '1800;0',	-- Vigilance
	[57360]	= '3600;0',	-- Well Fed
	[58479]	= '3600;0',	-- Nearly Well Fed
	[58999]	= '0;0',	-- Big Blizzard Bear
	[59658]	= '15;0',	-- Argent Heroism
	[60106]	= '300;0',	-- Old Spices
	[60122]	= '30;0',	-- Baby Spice
	[60530]	= '12;0',	-- Forethought Talisman
	[2974]	= '10;0',	-- Wing Clip
	[6117]	= '1800;0',	-- Mage Armor
	[10668]	= '3600;0',	-- Spirit of Boar
	[11334]	= '3600;0',	-- Greater Agility
	[15357]	= '15;1',	-- Inspiration
	[16511]	= '60;0',	-- Hemorrhage
	[16711]	= '300;1',	-- Grow
	[17463]	= '0;0',	-- Blue Skeletal Horse
	[28491]	= '3600;0',	-- Healing Power
	[30808]	= '0;0',	-- Unleashed Rage
	[44212]	= '3600;0',	-- Jack-o'-Lanterned!
	[48846]	= '20;0',	-- Runic Infusion
	[54424]	= '0;0',	-- Fel Intelligence
	[58180]	= '12;2',	-- Infected Wounds
	[65640]	= '0;0',	-- Swift Gray Steed
	[68188]	= '0;0',	-- Crusader's Black Warhorse
	[70772]	= '9;0',	-- Blessed Healing
	[72081]	= '0;0',	-- Frozen Orb
	[1463]	= '60;1',	-- Mana Shield
	[8117]	= '1800;1',	-- Agility
	[8119]	= '1800;1',	-- Strength
	[14030]	= '6;0',	-- Hooked Net
	[16488]	= '5;0',	-- Blood Craze
	[18989]	= '0;0',	-- Gray Kodo
	[23829]	= '0;0',	-- Master Demonologist
	[46355]	= '300;0',	-- Blood Elf Illusion
	[48102]	= '1800;1',	-- Stamina
	[48108]	= '15;0',	-- Hot Streak
	[52419]	= '10;0',	-- Deflection
	[53301]	= '2;0',	-- Explosive Shot
	[55775]	= '15;0',	-- Swordguard Embroidery
	[57079]	= '3600;0',	-- Well Fed
	[57097]	= '3600;0',	-- Well Fed
	[59650]	= '0;0',	-- Black Drake
	[63250]	= '10;0',	-- Jouster's Fury
	[66721]	= '0;0',	-- Burning Fury
	[66725]	= '15;0',	-- Meteor Fists
	[66808]	= '15;0',	-- Meteor Fists
	[70760]	= '10;0',	-- Deliverance
	[71875]	= '10;1',	-- Necrotic Touch
	[71993]	= '0;0',	-- Frozen Mallet
	[72004]	= '20;0',	-- Frostbite
	[72034]	= '60;0',	-- Whiteout
	[72122]	= '0;0',	-- Frozen Mallet
	[467]	= '20;1',	-- Thorns
	[3219]	= '3600;0',	-- Weak Troll's Blood Elixir
	[6114]	= '300;0',	-- Raptor Punch
	[7294]	= '0;0',	-- Retribution Aura
	[7844]	= '3600;0',	-- Fire Power
	[8050]	= '18;1',	-- Flame Shock
	[8096]	= '1800;1',	-- Intellect
	[8314]	= '3600;1',	-- Rock Skin
	[11328]	= '3600;0',	-- Agility
	[12178]	= '1800;1',	-- Stamina
	[17038]	= '1200;0',	-- Winterfall Firewater
	[17628]	= '3600;0',	-- Supreme Power
	[19705]	= '900;0',	-- Well Fed
	[20154]	= '1800;0',	-- Seal of Righteousness
	[23760]	= '0;0',	-- Master Demonologist
	[28518]	= '3600;0',	-- Flask of Fortification
	[28694]	= '900;0',	-- Dreaming Glory
	[32296]	= '0;0',	-- Swift Yellow Wind Rider
	[33254]	= '1800;0',	-- Well Fed
	[36895]	= '3600;0',	-- Transporter Malfunction
	[36897]	= '3600;0',	-- Transporter Malfunction
	[44614]	= '9;1',	-- Frostfire Bolt
	[54216]	= '4;0',	-- Master's Call
	[57833]	= '4;0',	-- Frost Spit
	[58468]	= '3600;0',	-- Hugely Well Fed
	[58984]	= '0;0',	-- Shadowmeld
	[59230]	= '3600;0',	-- Well Fed
	[62305]	= '4;0',	-- Master's Call
	[67735]	= '0;0',	-- Volatility
	[67736]	= '20;0',	-- Volatile Power
	[1120]	= '15;0',	-- Drain Soul
	[17535]	= '3600;0',	-- Elixir of the Sages
	[18400]	= '0;0',	-- Piccolo of the Flaming Fire
	[21163]	= '1800;0',	-- Polished Armor
	[23225]	= '0;0',	-- Swift Green Mechanostrider
	[26276]	= '3600;0',	-- Greater Firepower
	[29175]	= '180;0',	-- Ribbon Dance
	[32240]	= '0;0',	-- Snowy Gryphon
	[32289]	= '0;0',	-- Swift Red Gryphon
	[33151]	= '10;1',	-- Surge of Light
	[44825]	= '0;0',	-- Flying Reindeer
	[56161]	= '6;1',	-- Glyph of Prayer of Healing
	[57054]	= '10;0',	-- Tranquility
	[57363]	= '3600;0',	-- Well Fed
	[63956]	= '0;0',	-- Ironbound Proto-Drake
	[72096]	= '60;0',	-- Whiteout
	[72098]	= '20;0',	-- Frostbite
	[72104]	= '5;1',	-- Freezing Ground
	[72121]	= '10;0',	-- Frostbite
	[73320]	= '600;1',	-- Frostborn Illusion
	[1120]	= '15;0',	-- Drain Soul
	[17535]	= '3600;0',	-- Elixir of the Sages
	[18400]	= '0;0',	-- Piccolo of the Flaming Fire
	[21163]	= '1800;0',	-- Polished Armor
	[23225]	= '0;0',	-- Swift Green Mechanostrider
	[26276]	= '3600;0',	-- Greater Firepower
	[29175]	= '180;0',	-- Ribbon Dance
	[32240]	= '0;0',	-- Snowy Gryphon
	[32289]	= '0;0',	-- Swift Red Gryphon
	[33151]	= '10;1',	-- Surge of Light
	[44825]	= '0;0',	-- Flying Reindeer
	[56161]	= '6;1',	-- Glyph of Prayer of Healing
	[57054]	= '10;0',	-- Tranquility
	[57363]	= '3600;0',	-- Well Fed
	[63956]	= '0;0',	-- Ironbound Proto-Drake
	[72096]	= '60;0',	-- Whiteout
	[72098]	= '20;0',	-- Frostbite
	[72104]	= '5;1',	-- Freezing Ground
	[72121]	= '10;0',	-- Frostbite
	[73320]	= '600;1',	-- Frostborn Illusion
	[469]	= '120;0',	-- Commanding Shout
	[586]	= '10;0',	-- Fade
	[744]	= '30;3',	-- Poison
	[774]	= '12;1',	-- Rejuvenation
	[3220]	= '3600;0',	-- Armor
	[6673]	= '120;0',	-- Battle Shout
	[11349]	= '3600;0',	-- Armor
	[12024]	= '5;0',	-- Net
	[19706]	= '900;0',	-- Well Fed
	[20798]	= '1800;1',	-- Demon Skin
	[28747]	= '600;0',	-- Frenzy
	[42728]	= '60;0',	-- Dreadful Roar
	[45716]	= '40;0',	-- Torch Tossing Training
	[47748]	= '45;0',	-- Rift Shield
	[48058]	= '30;1',	-- Crystal Bloom
	[50131]	= '10;0',	-- Draw Magic
	[52537]	= '10;5',	-- Fixate
	[53334]	= '9;0',	-- Animate Bones
	[53764]	= '3600;0',	-- Mighty Mana Regeneration
	[54314]	= '30;0',	-- Drain Power
	[54315]	= '30;0',	-- Drain Power
	[54497]	= '3600;0',	-- Lesser Armor
	[57056]	= '90;0',	-- Aura of Regeneration
	[57063]	= '10;1',	-- Arcane Attraction
	[63637]	= '0;0',	-- Darnassian Nightsaber
	[64904]	= '8;1',	-- Hymn of Hope
	[68720]	= '0;0',	-- Quarry
	[116]	= '9;1',	-- Frostbolt
	[133]	= '0;0',	-- Fireball
	[172]	= '18;1',	-- Corruption
	[589]	= '18;1',	-- Shadow Word: Pain
	[3248]	= '6;0',	-- Improved Blocking
	[13730]	= '30;0',	-- Demoralizing Shout
	[15572]	= '30;0',	-- Sunder Armor
	[16244]	= '30;0',	-- Demoralizing Shout
	[17464]	= '0;0',	-- Brown Skeletal Horse
	[25058]	= '15;1',	-- Renew
	[29341]	= '5;0',	-- Shadowburn
	[29882]	= '20;0',	-- Loose Mana
	[34410]	= '3600;0',	-- Hellscream's Warsong
	[35079]	= '4;0',	-- Misdirection
	[42705]	= '60;5',	-- Enrage
	[43182]	= '30;0',	-- Drink
	[43931]	= '15;0',	-- Rend
	[47543]	= '0;0',	-- Frozen Prison
	[47774]	= '120;0',	-- Frenzy
	[47781]	= '6;0',	-- Spellbreaker
	[47854]	= '0;0',	-- Frozen Prison
	[47981]	= '15;0',	-- Spell Reflection
	[56778]	= '60;1',	-- Mana Shield
	[60819]	= '10;0',	-- Libram of Reciprocation
	[61470]	= '0;0',	-- Grand Ice Mammoth
	[64843]	= '8;0',	-- Divine Hymn
	[66776]	= '0;0',	-- Rage
	[67811]	= '12;0',	-- Dagger Throw
	[68719]	= '0;0',	-- Oil Refinery
	[68722]	= '2;0',	-- Oil Refinery
	[71877]	= '10;1',	-- Necrotic Touch
	[348]	= '15;1',	-- Immolate
	[755]	= '3;0',	-- Health Funnel
	[980]	= '24;4',	-- Bane of Agony
	[1130]	= '300;1',	-- Hunter's Mark
	[5262]	= '10;1',	-- Fanatic Blade
	[5782]	= '20;1',	-- Fear
	[6268]	= '3;0',	-- Rushing Charge
	[6278]	= '60;2',	-- Creeping Mold
	[8042]	= '8;0',	-- Earth Shock
	[12541]	= '600;2',	-- Ghoul Rot
	[18070]	= '30;0',	-- Earthborer Acid
	[18267]	= '30;4',	-- Curse of Weakness
	[29334]	= '3600;0',	-- Toasted Smorc
	[40192]	= '0;0',	-- Ashes of Al'ar
	[46221]	= '180;0',	-- Animal Blood
	[47791]	= '5;0',	-- Arcane Haste
	[48400]	= '20;0',	-- Frost Tomb
	[53520]	= '4;0',	-- Carrion Beetles
	[54309]	= '10;1',	-- Mark of Darkness
	[54955]	= '5;0',	-- Ticking Bomb
	[58493]	= '3600;0',	-- Mohawked!
	[68298]	= '5;0',	-- Parachute
	[68377]	= '0;0',	-- Carrying Huge Seaforium
	[71579]	= '20;0',	-- Elusive Power
	[99]	= '30;0',	-- Demoralizing Roar
	[126]	= '45;0',	-- Eye of Kilrogg
	[5280]	= '45;0',	-- Razor Mane
	[6950]	= '60;1',	-- Faerie Fire
	[8076]	= '0;0',	-- Strength of Earth
	[8202]	= '1200;1',	-- Sapta Sight
	[8242]	= '2;0',	-- Shield Slam
	[12292]	= '30;5',	-- Death Wish
	[18266]	= '15;4',	-- Curse of Agony
	[20800]	= '21;1',	-- Immolate
	[29235]	= '3600;0',	-- Fire Festival Fortitude
	[42702]	= '10;2',	-- Decrepify
	[42740]	= '8;1',	-- Njord's Rune of Protection
	[43664]	= '15;5',	-- Unholy Rage
	[46899]	= '900;0',	-- Well Fed
	[48095]	= '0;0',	-- Intense Cold
	[52446]	= '10;0',	-- Acid Splash
	[52470]	= '8;5',	-- Enrage
	[52493]	= '10;3',	-- Poison Spray
	[53322]	= '6;0',	-- Crushing Webs
	[53330]	= '20;2',	-- Infected Wound
	[54494]	= '3600;0',	-- Major Agility
	[57139]	= '3600;0',	-- Well Fed
	[58502]	= '7200;0',	-- Scared
	[60486]	= '10;0',	-- Illustration of the Dragon Soul
	[64861]	= '15;0',	-- Precision Shots
	[65638]	= '0;0',	-- Swift Moonsaber
	[66550]	= '20;0',	-- Teleport
	[432]	= '24;0',	-- Drink
	[702]	= '120;4',	-- Curse of Weakness
	[6343]	= '30;0',	-- Thunder Clap
	[8599]	= '120;5',	-- Enrage
	[11348]	= '3600;0',	-- Greater Armor
	[11390]	= '3600;0',	-- Arcane Elixir
	[20043]	= '0;0',	-- Aspect of the Wild
	[25207]	= '1800;1',	-- Amulet of the Moon
	[27817]	= '6;1',	-- Blessed Recovery
	[31403]	= '120;0',	-- Battle Shout
	[35944]	= '30;1',	-- Power Word: Shield
	[39171]	= '5;0',	-- Mortal Strike
	[47283]	= '8;1',	-- Empowered Imp
	[53467]	= '15;0',	-- Leeching Swarm
	[53602]	= '12;0',	-- Dart
	[53801]	= '600;0',	-- Frenzy
	[54965]	= '8;1',	-- Bolthorn's Rune of Flame
	[57580]	= '5;1',	-- Lightning Infusion
	[60344]	= '3600;0',	-- Expertise
	[63643]	= '0;0',	-- Forsaken Warhorse
	[64057]	= '3600;0',	-- Well Fed
	[65014]	= '10;0',	-- Pyrite Infusion
	[68652]	= '0;0',	-- Honorable Defender
	[71568]	= '20;0',	-- Urgency
	[71870]	= '10;1',	-- Blessing of Light
	[72221]	= '0;0',	-- Luck of the Draw
	[580]	= '0;0',	-- Timber Wolf
	[687]	= '1800;0',	-- Demon Armor
	[8936]	= '6;1',	-- Regrowth
	[17462]	= '0;0',	-- Red Skeletal Horse
	[19709]	= '900;0',	-- Well Fed
	[21049]	= '30;1',	-- Bloodlust
	[28521]	= '3600;0',	-- Flask of Blinding Light
	[33702]	= '15;0',	-- Blood Fury
	[36702]	= '0;0',	-- Fiery Warhorse
	[37578]	= '5;0',	-- Debilitating Strike
	[38232]	= '20;0',	-- Battle Shout
	[42723]	= '2;0',	-- Dark Smash
	[45444]	= '0;0',	-- Bonfire's Blessing
	[46352]	= '3600;0',	-- Fire Festival Fury
	[47699]	= '300;1',	-- Crystal Bark
	[47747]	= '45;0',	-- Charge Rifts
	[53030]	= '10;3',	-- Leech Poison
	[53317]	= '15;0',	-- Rend
	[53468]	= '1;0',	-- Leeching Swarm
	[55077]	= '5;0',	-- Pounce
	[56827]	= '60;1',	-- Aura of Arcane Haste
	[57086]	= '0;0',	-- Frenzy
	[58448]	= '1800;1',	-- Strength
	[67332]	= '20;0',	-- Flaming Cinder
	[68160]	= '15;0',	-- Meteor Fists
	[68161]	= '15;0',	-- Meteor Fists
	[113]	= '15;1',	-- Chains of Ice
	[853]	= '6;1',	-- Hammer of Justice
	[1127]	= '27;0',	-- Food
	[3603]	= '15;0',	-- Distracting Pain
	[5171]	= '6;0',	-- Slice and Dice
	[5213]	= '15;0',	-- Molten Metal
	[6432]	= '10;0',	-- Smite Stomp
	[6466]	= '3;0',	-- Axe Toss
	[6713]	= '5;0',	-- Disarm
	[7483]	= '300;0',	-- Howling Rage
	[7484]	= '300;0',	-- Howling Rage
	[7947]	= '60;3',	-- Localized Toxin
	[7948]	= '20;1',	-- Wild Regeneration
	[8898]	= '1200;1',	-- Sapta Sight
	[9128]	= '120;0',	-- Battle Shout
	[17627]	= '3600;0',	-- Distilled Wisdom
	[20707]	= '900;0',	-- Soulstone Resurrection
	[22766]	= '0;0',	-- Sneak
	[25746]	= '15;1',	-- Damage Absorb
	[27863]	= '600;0',	-- The Baron's Ultimatum
	[28273]	= '600;0',	-- Bloodthistle
	[29073]	= '30;0',	-- Food
	[29333]	= '3600;0',	-- Midsummer Sausage
	[41635]	= '30;1',	-- Prayer of Mending
	[47779]	= '4;1',	-- Arcane Torrent
	[48100]	= '1800;1',	-- Intellect
	[51714]	= '20;0',	-- Frost Vulnerability
	[56969]	= '8;0',	-- Arcane Blast
	[58452]	= '1800;1',	-- Armor
	[60299]	= '20;0',	-- Incisor Fragment
	[62380]	= '3600;0',	-- Lesser Flask of Resistance
	[63438]	= '0;0',	-- Silvermoon Champion's Pennant
	[65081]	= '4;1',	-- Body and Soul
	[71175]	= '15;0',	-- Agile
	[122]	= '8;1',	-- Frost Nova
	[6016]	= '20;0',	-- Pierce Armor
	[6253]	= '2;0',	-- Backhand
	[7038]	= '60;4',	-- Forsaken Skill: Swords
	[7039]	= '60;4',	-- Forsaken Skill: Axes
	[7040]	= '60;4',	-- Forsaken Skill: Daggers
	[7041]	= '60;4',	-- Forsaken Skill: Maces
	[7042]	= '60;4',	-- Forsaken Skill: Staves
	[7044]	= '60;4',	-- Forsaken Skill: Guns
	[7045]	= '60;4',	-- Forsaken Skill: 2H Axes
	[8040]	= '15;1',	-- Druid's Slumber
	[9672]	= '4;1',	-- Frostbolt
	[11977]	= '15;0',	-- Rend
	[16739]	= '300;0',	-- Orb of Deception
	[20006]	= '12;1',	-- Unholy Curse
	[30991]	= '0;7',	-- Stealth
	[51209]	= '10;1',	-- Hungering Cold
	[52109]	= '0;0',	-- Flametongue Totem
	[58891]	= '45;0',	-- Wild Magic
	[70639]	= '8;0',	-- Call of Sylvanas
	[430]	= '18;0',	-- Drink
	[431]	= '21;0',	-- Drink
	[435]	= '24;0',	-- Food
	[700]	= '20;1',	-- Sleep
	[1079]	= '16;0',	-- Rip
	[5277]	= '15;0',	-- Evasion
	[6306]	= '30;3',	-- Acid Splash
	[7046]	= '60;4',	-- Forsaken Skill: 2H Maces
	[7047]	= '60;4',	-- Forsaken Skill: 2H Swords
	[7049]	= '60;4',	-- Forsaken Skill: Fire
	[7053]	= '60;4',	-- Forsaken Skill: Shadow
	[7057]	= '300;4',	-- Haunting Spirits
	[7068]	= '15;4',	-- Veil of Shadow
	[7072]	= '60;0',	-- Wild Rage
	[7074]	= '5;1',	-- Screams of the Past
	[7295]	= '10;1',	-- Soul Drain
	[7812]	= '30;1',	-- Sacrifice
	[8041]	= '10;0',	-- Serpent Form
	[8066]	= '120;4',	-- Shrink
	[8112]	= '1800;1',	-- Spirit
	[8365]	= '10;1',	-- Enlarge
	[8379]	= '10;0',	-- Disarm
	[14143]	= '20;0',	-- Remorseless
	[14914]	= '7;1',	-- Holy Fire
	[30482]	= '1800;0',	-- Molten Armor
	[33720]	= '3600;0',	-- Onslaught Elixir
	[42777]	= '0;0',	-- Swift Spectral Tiger
	[56112]	= '10;0',	-- Furious Attacks
	[543]	= '30;1',	-- Mage Ward
	[703]	= '18;0',	-- Garrote
	[1850]	= '15;0',	-- Dash
	[7051]	= '60;4',	-- Forsaken Skill: Holy
	[7054]	= '300;4',	-- Forsaken Skills
	[7121]	= '10;0',	-- Anti-Magic Shield
	[7124]	= '300;4',	-- Arugal's Gift
	[7125]	= '120;3',	-- Toxic Saliva
	[7127]	= '60;1',	-- Wavering Will
	[7481]	= '300;0',	-- Howling Rage
	[7621]	= '10;4',	-- Arugal's Curse
	[8140]	= '15;1',	-- Befuddlement
	[8148]	= '60;0',	-- Thorns Aura
	[8153]	= '0;0',	-- Owl Form
	[16490]	= '5;0',	-- Blood Craze
	[18381]	= '30;0',	-- Cripple
	[19386]	= '30;3',	-- Wyvern Sting
	[19434]	= '0;0',	-- Aimed Shot
	[26522]	= '1800;0',	-- Lunar Fortune
	[28274]	= '1200;0',	-- Bloodthistle Withdrawal
	[29332]	= '3600;0',	-- Fire-toasted Bun
	[29335]	= '3600;0',	-- Elderberry Pie
	[53386]	= '30;0',	-- Cinderglacier
	[58496]	= '7200;0',	-- Sad
	[71345]	= '0;0',	-- Big Love Rocket
	[434]	= '21;0',	-- Food
	[689]	= '3;1',	-- Drain Life
	[853]	= '6;1',	-- Hammer of Justice
	[1159]	= '6;0',	-- First Aid
	[1160]	= '30;0',	-- Demoralizing Shout
	[2944]	= '24;2',	-- Devouring Plague
	[2983]	= '8;0',	-- Sprint
	[3427]	= '30;2',	-- Infected Wound
	[5115]	= '6;1',	-- Battle Command
	[5159]	= '20;0',	-- Melt Ore
	[6136]	= '5;1',	-- Chilled
	[7140]	= '5;1',	-- Expose Weakness
	[7389]	= '15;0',	-- Attack
	[7399]	= '4;1',	-- Terrify
	[8056]	= '8;1',	-- Frost Shock
	[8101]	= '1800;1',	-- Stamina
	[8382]	= '45;3',	-- Leech Poison
	[8398]	= '8;1',	-- Frostbolt Volley
	[11113]	= '3;1',	-- Blast Wave
	[11640]	= '15;1',	-- Renew
	[12548]	= '8;1',	-- Frost Shock
	[13704]	= '6;1',	-- Psychic Scream
	[13797]	= '15;1',	-- Immolation Trap
	[14251]	= '30;0',	-- Riposte
	[16689]	= '45;1',	-- Nature's Grasp
	[18610]	= '8;0',	-- First Aid
	[21069]	= '6;3',	-- Larva Goo
	[23600]	= '6;0',	-- Piercing Howl
	[23768]	= '7200;0',	-- Sayge's Dark Fortune of Damage
	[24870]	= '900;0',	-- Well Fed
	[33053]	= '7200;0',	-- Mr Pinchy's Blessing
	[35712]	= '0;0',	-- Great Green Elekk
	[43197]	= '1800;1',	-- Spirit
	[45062]	= '0;0',	-- Holy Energy
	[45693]	= '0;0',	-- Torches Caught
	[51466]	= '0;0',	-- Elemental Oath
	[53909]	= '15;0',	-- Wild Magic
	[56352]	= '12;1',	-- Storm Punch
	[64128]	= '4;1',	-- Body and Soul
	[69180]	= '30;4',	-- Gutgore Ripper
	[453]	= '15;0',	-- Mind Soothe
	[2602]	= '15;1',	-- Fire Shield IV
	[3583]	= '60;3',	-- Deadly Poison
	[3604]	= '8;0',	-- Tendon Rip
	[5137]	= '60;4',	-- Call of the Grave
	[5211]	= '4;0',	-- Bash
	[5217]	= '6;0',	-- Tiger's Fury
	[6726]	= '5;1',	-- Silence
	[6742]	= '30;1',	-- Bloodlust
	[8263]	= '0;0',	-- Elemental Protection Totem Aura
	[8267]	= '600;4',	-- Cursed Blood
	[10730]	= '10;1',	-- Pacify
	[10734]	= '3;0',	-- Hail Storm
	[10838]	= '8;0',	-- First Aid
	[11397]	= '300;2',	-- Diseased Shot
	[11445]	= '60;1',	-- Bone Armor
	[11876]	= '5;0',	-- War Stomp
	[12255]	= '900;4',	-- Curse of Tuten'kash
	[12946]	= '10;2',	-- Putrid Stench
	[13812]	= '20;0',	-- Explosive Trap
	[13864]	= '1800;1',	-- Power Word: Fortitude
	[14515]	= '15;1',	-- Dominate Mind
	[15976]	= '10;0',	-- Puncture
	[20615]	= '3;0',	-- Intercept
	[21062]	= '30;2',	-- Putrid Breath
	[28703]	= '900;0',	-- Netherbloom Pollen
	[32727]	= '0;0',	-- Arena Preparation
	[43195]	= '1800;1',	-- Intellect
	[51945]	= '12;1',	-- Earthliving
	[55012]	= '0;0',	-- Lok'lira's Bargain
	[465]	= '0;0',	-- Devotion Aura
	[676]	= '10;0',	-- Disarm
	[1822]	= '9;0',	-- Rake
	[3222]	= '3600;0',	-- Strong Troll's Blood Elixir
	[3639]	= '6;0',	-- Improved Blocking
	[3742]	= '15;0',	-- Static Electricity
	[5403]	= '6;1',	-- Crash of Waves
	[5413]	= '120;2',	-- Noxious Catalyst
	[6940]	= '12;1',	-- Hand of Sacrifice
	[7964]	= '4;1',	-- Smoke Bomb
	[7966]	= '60;0',	-- Thorns Aura
	[8391]	= '3;0',	-- Ravage
	[8399]	= '10;1',	-- Sleep
	[8990]	= '0;0',	-- Retribution Aura
	[10348]	= '20;0',	-- Tune Up
	[10831]	= '5;1',	-- Reflection Field
	[11641]	= '10;1',	-- Hex
	[11971]	= '30;0',	-- Sunder Armor
	[12531]	= '8;1',	-- Chilling Touch
	[12627]	= '0;0',	-- Disease Cloud
	[12795]	= '120;0',	-- Frenzy
	[12890]	= '15;1',	-- Deep Slumber
	[12891]	= '45;0',	-- Acid Breath
	[13218]	= '15;3',	-- Wound Poison
	[13326]	= '1800;1',	-- Arcane Intellect
	[13532]	= '10;0',	-- Thunder Clap
	[14032]	= '18;1',	-- Shadow Word: Pain
	[18972]	= '20;1',	-- Slow
	[20925]	= '0;1',	-- Holy Shield
	[21909]	= '8;0',	-- Dust Field
	[24425]	= '7200;0',	-- Spirit of Zandalar
	[25606]	= '1800;1',	-- Pendant of the Agate Shield
	[25694]	= '900;0',	-- Well Fed
	[25702]	= '21;0',	-- Food
	[25941]	= '900;0',	-- Well Fed
	[28489]	= '3600;0',	-- Camouflage
	[30931]	= '20;0',	-- Battle Shout
	[31643]	= '8;1',	-- Blazing Speed
	[32736]	= '5;0',	-- Mortal Strike
	[39318]	= '0;0',	-- Tan Riding Talbuk
	[60343]	= '3600;0',	-- Mighty Defense
	[60518]	= '10;1',	-- Touched by a Troll
	[61451]	= '0;0',	-- Flying Carpet
	[63735]	= '20;1',	-- Serendipity
	[66684]	= '20;0',	-- Flaming Cinder
	[70845]	= '10;0',	-- Stoicism
	[71866]	= '6;0',	-- Fountain of Light
	[72282]	= '0;0',	-- Invincible
	[74960]	= '10;0',	-- Infrigidate
	[75731]	= '0;0',	-- Instant Statue
	[139]	= '12;1',	-- Renew
	[408]	= '1;0',	-- Kidney Shot
	[3267]	= '7;0',	-- First Aid
	[8068]	= '1800;1',	-- Healthy Spirit
	[8078]	= '10;1',	-- Thunderclap
	[9007]	= '18;0',	-- Pounce Bleed
	[9034]	= '21;1',	-- Immolate
	[9438]	= '8;0',	-- Arcane Bubble
	[9482]	= '30;1',	-- Amplify Flames
	[11366]	= '12;0',	-- Pyroblast
	[11426]	= '60;1',	-- Ice Barrier
	[11442]	= '180;2',	-- Withered Touch
	[12484]	= '2;0',	-- Chilled
	[12528]	= '10;1',	-- Silence
	[14201]	= '9;5',	-- Enrage
	[15087]	= '15;0',	-- Evasion
	[15971]	= '30;0',	-- Demoralizing Roar
	[16177]	= '15;1',	-- Ancestral Fortitude
	[19891]	= '0;0',	-- Resistance Aura
	[24379]	= '10;0',	-- Restoration
	[24394]	= '3;0',	-- Intimidation
	[24712]	= '3600;0',	-- Leper Gnome Costume
	[25859]	= '0;0',	-- Reindeer
	[29544]	= '6;0',	-- Frightening Shout
	[31125]	= '4;0',	-- Blade Twisting
	[34976]	= '0;0',	-- Netherstorm Flag
	[48103]	= '1800;1',	-- Spirit
	[52909]	= '1800;0',	-- Water Breathing
	[58451]	= '1800;1',	-- Agility
	[59675]	= '1800;0',	-- Nexus Residue
	[59676]	= '1800;0',	-- Residue of Darkness
	[63896]	= '12;0',	-- Bullheaded
	[64343]	= '10;0',	-- Impact
	[70747]	= '30;0',	-- Quad Core
	[71485]	= '30;0',	-- Agility of the Vrykul
	[1135]	= '30;0',	-- Drink
	[1137]	= '30;0',	-- Drink
	[1490]	= '300;4',	-- Curse of the Elements
	[3815]	= '45;3',	-- Poison Cloud
	[7992]	= '25;3',	-- Slowing Poison
	[8282]	= '120;4',	-- Curse of Blood
	[8285]	= '2.5;0',	-- Rampage
	[8600]	= '180;2',	-- Fevered Plague
	[9275]	= '21;1',	-- Immolate
	[10732]	= '10;0',	-- Supercharge
	[11131]	= '10;0',	-- Icicle
	[11980]	= '120;4',	-- Curse of Weakness
	[12097]	= '20;0',	-- Pierce Armor
	[12245]	= '300;2',	-- Infected Spine
	[16277]	= '15;0',	-- Flurry
	[16914]	= '10;0',	-- Hurricane
	[21007]	= '120;4',	-- Curse of Weakness
	[21337]	= '600;1',	-- Thorns
	[26008]	= '1800;0',	-- Toast
	[33726]	= '3600;0',	-- Elixir of Mastery
	[44415]	= '3;1',	-- Blackout
	[45245]	= '1800;0',	-- Well Fed
	[45724]	= '0;0',	-- Braziers Hit!
	[48838]	= '10;0',	-- Elemental Tenacity
	[51399]	= '3;0',	-- Death Grip
	[54443]	= '20;0',	-- Demonic Empowerment
	[62146]	= '30;0',	-- Unflinching Valor
	[67380]	= '20;0',	-- Evasion
	[70244]	= '3600;0',	-- "Wizardry" Cologne
	[120]	= '8;1',	-- Cone of Cold
	[710]	= '30;1',	-- Banish
	[3356]	= '45;1',	-- Flame Lash
	[5677]	= '0;0',	-- Mana Spring
	[6146]	= '15;1',	-- Slow
	[7739]	= '10;1',	-- Inferno Shell
	[8269]	= '120;0',	-- Frenzy
	[8281]	= '6;1',	-- Sonic Burst
	[8377]	= '4;0',	-- Earthgrab
	[8788]	= '600;1',	-- Lightning Shield
	[9798]	= '0;0',	-- Radiation
	[11327]	= '3;7',	-- Vanish
	[12248]	= '10;1',	-- Amplify Damage
	[12251]	= '30;3',	-- Virulent Poison
	[12421]	= '2;0',	-- Mithril Frag Bomb
	[12540]	= '4;0',	-- Gouge
	[12884]	= '45;0',	-- Acid Breath
	[13439]	= '5;1',	-- Frostbolt
	[15407]	= '3;0',	-- Mind Flay
	[17154]	= '30;1',	-- The Green Tower
	[21655]	= '1;0',	-- Blink
	[32292]	= '0;0',	-- Swift Purple Gryphon
	[36899]	= '3600;0',	-- Transporter Malfunction
	[59843]	= '600;0',	-- Underbelly Elixir
	[65637]	= '0;0',	-- Great Red Elekk
	[2601]	= '30;1',	-- Fire Shield III
	[5246]	= '8;0',	-- Intimidating Shout
	[6789]	= '3;1',	-- Death Coil
	[9256]	= '10;0',	-- Deep Sleep
	[9459]	= '60;1',	-- Corrosive Ooze
	[10452]	= '20;1',	-- Flame Buffet
	[11020]	= '8;1',	-- Petrify
	[11922]	= '15;1',	-- Entangling Roots
	[11962]	= '15;1',	-- Immolate
	[11974]	= '30;1',	-- Power Word: Shield
	[12461]	= '2;0',	-- Backhand
	[12493]	= '120;4',	-- Curse of Weakness
	[14517]	= '30;1',	-- Crusader Strike
	[15039]	= '12;1',	-- Flame Shock
	[15531]	= '8;1',	-- Frost Nova
	[20875]	= '900;0',	-- Rumsey Rum
	[29674]	= '0;1',	-- Lesser Shielding
	[38254]	= '1800;2',	-- Festering Wound
	[49623]	= '15;0',	-- Effervescence
	[59125]	= '120;0',	-- Lucky
	[75458]	= '15;0',	-- Piercing Twilight
	[3419]	= '6;0',	-- Improved Blocking
	[6728]	= '10;1',	-- Enveloping Winds
	[8275]	= '75;3',	-- Poisoned Shot
	[8988]	= '10;1',	-- Silence
	[9080]	= '10;0',	-- Hamstring
	[9906]	= '5;1',	-- Reflection
	[11443]	= '15;1',	-- Cripple
	[11639]	= '18;1',	-- Shadow Word: Pain
	[11647]	= '30;0',	-- Power Word: Shield
	[11820]	= '6;0',	-- Electrified Net
	[12096]	= '8;1',	-- Fear
	[12098]	= '20;1',	-- Sleep
	[13298]	= '30;3',	-- Poison
	[19710]	= '900;0',	-- Well Fed
	[21067]	= '10;3',	-- Poison Bolt
	[21331]	= '15;1',	-- Entangling Roots
	[24709]	= '3600;0',	-- Pirate Costume
	[36893]	= '3600;0',	-- Transporter Malfunction
	[39628]	= '3600;0',	-- Elixir of Ironskin
	[46630]	= '90;0',	-- Torch Tossing Practice
	[50263]	= '20;1',	-- Quickness of the Sailor
	[57529]	= '0;1',	-- Arcane Potency
	[61425]	= '0;0',	-- Traveler's Tundra Mammoth
	[65780]	= '300;0',	-- Pink Gumball
	[71560]	= '30;0',	-- Speed of the Vrykul
	[740]	= '8;0',	-- Tranquility
	[745]	= '5;0',	-- Web
	[1129]	= '30;0',	-- Food
	[1133]	= '27;0',	-- Drink
	[1943]	= '6;0',	-- Rupture
	[2818]	= '12;3',	-- Deadly Poison
	[3256]	= '240;2',	-- Plague Cloud
	[3439]	= '300;2',	-- Wandering Plague
	[4318]	= '1800;1',	-- Guile of the Raptor
	[5005]	= '21;0',	-- Food
	[5138]	= '3;1',	-- Drain Mana
	[6524]	= '2;0',	-- Ground Tremor
	[6533]	= '2;0',	-- Net
	[8258]	= '240;0',	-- Devotion Aura
	[8362]	= '20;1',	-- Renew
	[9775]	= '60;2',	-- Irradiated
	[10093]	= '1;0',	-- Harsh Winds
	[11264]	= '10;1',	-- Ice Blast
	[11436]	= '10;1',	-- Slow
	[12040]	= '30;1',	-- Shadow Shield
	[12294]	= '10;0',	-- Mortal Strike
	[12479]	= '10;0',	-- Hex of Jammal'an
	[12486]	= '1.5;0',	-- Chilled
	[12530]	= '60;1',	-- Frailty
	[12611]	= '8;1',	-- Cone of Cold
	[12741]	= '120;4',	-- Curse of Weakness
	[13445]	= '15;0',	-- Rend
	[13526]	= '30;3',	-- Corrosive Poison
	[14518]	= '30;1',	-- Crusader Strike
	[15532]	= '8;1',	-- Frost Nova
	[15548]	= '10;1',	-- Thunderclap
	[17537]	= '3600;0',	-- Elixir of Brute Force
	[21068]	= '24;1',	-- Corruption
	[21547]	= '5;0',	-- Spore Cloud
	[21687]	= '15;3',	-- Toxic Volley
	[21749]	= '2;0',	-- Thorn Volley
	[21787]	= '120;3',	-- Deadly Poison
	[23759]	= '0;0',	-- Master Demonologist
	[23767]	= '7200;0',	-- Sayge's Dark Fortune of Armor
	[25747]	= '15;1',	-- Damage Absorb
	[28509]	= '3600;0',	-- Greater Mana Regeneration
	[33082]	= '1800;1',	-- Strength
	[33259]	= '1800;0',	-- Well Fed
	[34709]	= '15;0',	-- Shadow Sight
	[42792]	= '3;0',	-- Recently Dropped Flag
	[45694]	= '180;0',	-- Captain Rumsey's Lager
	[45699]	= '5;0',	-- Flames of Failure
	[47057]	= '180;0',	-- Fiery Seduction
	[48333]	= '300;0',	-- Going Ape
	[49962]	= '17;0',	-- Jungle Madness!
	[50872]	= '30;0',	-- Savagery
	[56521]	= '1800;1',	-- Blessing of Wisdom
	[56525]	= '1800;1',	-- Blessing of Kings
	[57514]	= '12;5',	-- Enrage
	[60517]	= '20;0',	-- Talisman of Troll Divinity
	[63311]	= '8;0',	-- Shadowsnare
	[64937]	= '5;0',	-- Heightened Reflexes
	[74855]	= '0;0',	-- Blazing Hippogryph
	[16278]	= '15;0',	-- Flurry
	[20052]	= '15;1',	-- Conviction
	[34914]	= '15;1',	-- Vampiric Touch
	[49868]	= '0;0',	-- Mind Quickening
	[53290]	= '0;0',	-- Hunting Party
	[73681]	= '12;0',	-- Unleash Wind
	[73683]	= '8;0',	-- Unleash Flame
	[77487]	= '60;1',	-- Shadow Orb
	[77661]	= '15;1',	-- Searing Flames
	[79063]	= '3600;1',	-- Blessing of Kings
	[79105]	= '3600;1',	-- Power Word: Fortitude
	[79107]	= '3600;1',	-- Shadow Protection
	[82661]	= '0;0',	-- Aspect of the Fox
	[85509]	= '20;0',	-- Denounce
	[85767]	= '1800;1',	-- Dark Intent
	[85768]	= '1800;1',	-- Dark Intent
	[86273]	= '6;1',	-- Illuminated Healing
	[87118]	= '15;0',	-- Dark Evangelism
	[87153]	= '18;1',	-- Dark Archangel
	[91724]	= '0;0',	-- Spell Warding
	[17]	= '30;1',	-- Power Word: Shield
	[879]	= '6;0',	-- Exorcism
	[1714]	= '30;4',	-- Curse of Tongues
	[8122]	= '8;1',	-- Psychic Scream
	[32389]	= '12;1',	-- Shadow Embrace
	[44457]	= '12;1',	-- Living Bomb
	[44544]	= '15;1',	-- Fingers of Frost
	[47960]	= '6;1',	-- Shadowflame
	[50435]	= '10;0',	-- Chilblains
	[51460]	= '3;0',	-- Runic Corruption
	[51698]	= '0;0',	-- Honor Among Thieves
	[65142]	= '21;2',	-- Ebon Plague
	[73413]	= '1800;0',	-- Inner Will
	[73651]	= '0;0',	-- Recuperate
	[73975]	= '15;0',	-- Necrotic Strike
	[76691]	= '0;5',	-- Vengeance
	[77613]	= '15;1',	-- Grace
	[79058]	= '3600;1',	-- Arcane Brilliance
	[80354]	= '600;0',	-- Temporal Displacement
	[81326]	= '0;0',	-- Brittle Bones
	[83302]	= '4;1',	-- Improved Cone of Cold
	[85673]	= '6;0',	-- Word of Glory
	[87098]	= '8;0',	-- Invocation
	[88611]	= '1;0',	-- Smoke Bomb
	[88819]	= '12;0',	-- Daybreak
	[91021]	= '10;0',	-- Find Weakness
	[91342]	= '30;0',	-- Shadow Infusion
	[1134]	= '15;0',	-- Inner Rage
	[30108]	= '15;1',	-- Unstable Affliction
	[48181]	= '12;1',	-- Haunt
	[53646]	= '0;0',	-- Demonic Pact
	[54729]	= '0;0',	-- Winged Steed of the Ebon Blade
	[57519]	= '12;5',	-- Enrage
	[77616]	= '20;0',	-- Dark Simulacrum
	[77747]	= '0;0',	-- Totemic Wrath
	[79061]	= '3600;1',	-- Mark of the Wild
	[79102]	= '3600;1',	-- Blessing of Might
	[79140]	= '30;0',	-- Vendetta
	[79683]	= '20;0',	-- Arcane Missiles!
	[82930]	= '0;0',	-- Arcane Tactics
	[84586]	= '15;0',	-- Slaughter
	[84620]	= '10;0',	-- Hold the Line
	[84958]	= '20;0',	-- Tranquilized
	[85388]	= '5;0',	-- Throwdown
	[85730]	= '10;0',	-- Deadly Calm
	[86346]	= '6;0',	-- Colossus Smash
	[86627]	= '10;0',	-- Incite
	[93068]	= '15;0',	-- Master Poisoner
	[94009]	= '15;0',	-- Rend
	[82327]	= '10;1',	-- Holy Radiance
	[85497]	= '4;1',	-- Speed of Light
	[32645]	= '1;3',	-- Envenom
	[974]	= '600;1',	-- Earth Shield
	[1978]	= '15;3',	-- Serpent Sting
	[3674]	= '15;1',	-- Black Arrow
	[5570]	= '12;1',	-- Insect Swarm
	[5916]	= '0;7',	-- Shadowstalker Stealth
	[6229]	= '30;1',	-- Shadow Ward
	[8185]	= '0;0',	-- Elemental Resistance
	[8921]	= '12;1',	-- Moonfire
	[11538]	= '4;1',	-- Frostbolt
	[12355]	= '2;0',	-- Impact
	[17767]	= '6;0',	-- Consume Shadows
	[23145]	= '16;0',	-- Dive
	[33876]	= '60;0',	-- Mangle
	[37548]	= '3;0',	-- Taunt
	[51700]	= '0;0',	-- Honor Among Thieves
	[61044]	= '15;0',	-- Demoralizing Shout
	[64803]	= '4;1',	-- Entrapment
	[74001]	= '30;0',	-- Combat Readiness
	[74002]	= '6;0',	-- Combat Insight
	[77606]	= '8;0',	-- Dark Simulacrum
	[79057]	= '3600;1',	-- Arcane Brilliance
	[79060]	= '3600;1',	-- Mark of the Wild
	[79268]	= '9;0',	-- Soul Harvest
	[80353]	= '40;1',	-- Time Warp
	[81340]	= '10;0',	-- Sudden Doom
	[82365]	= '10;0',	-- Skull Bash
	[82368]	= '20;0',	-- Victorious
	[82654]	= '30;3',	-- Widow Venom
	[84721]	= '2;0',	-- Frostfire Orb
	[86000]	= '15;0',	-- Curse of Gul'dan
	[86211]	= '20;1',	-- Soul Swap
	[88466]	= '9;3',	-- Serpent Sting
	[89775]	= '24;0',	-- Hemorrhage
	[91565]	= '300;1',	-- Faerie Fire
	[91800]	= '3;0',	-- Gnaw
	[71]	= '0;0',	-- Defensive Stance
	[136]	= '10;1',	-- Mend Pet
	[2457]	= '0;0',	-- Battle Stance
	[2458]	= '0;0',	-- Berserker Stance
	[9005]	= '3;0',	-- Pounce
	[14202]	= '9;5',	-- Enrage
	[16191]	= '0;0',	-- Mana Tide
	[22570]	= '0;0',	-- Maim
	[24131]	= '6;3',	-- Wyvern Sting
	[24844]	= '45;1',	-- Lightning Breath
	[30213]	= '6;0',	-- Legion Strike
	[30283]	= '3;1',	-- Shadowfury
	[48020]	= '1;0',	-- Demonic Circle: Teleport
	[48438]	= '7;1',	-- Wild Growth
	[51755]	= '60;0',	-- Camouflage
	[55328]	= '15;0',	-- Stoneclaw Totem
	[55342]	= '30;0',	-- Mirror Image
	[59888]	= '6;1',	-- Borrowed Time
	[61295]	= '15;1',	-- Riptide
	[63058]	= '20;0',	-- Glyph of Amberskin Protection
	[63560]	= '30;0',	-- Dark Transformation
	[64901]	= '8;0',	-- Hymn of Hope
	[73685]	= '8;0',	-- Unleash Life
	[74434]	= '15;0',	-- Soulburn
	[77535]	= '10;0',	-- Blood Shield
	[77769]	= '15;0',	-- Trap Launcher
	[77800]	= '8;1',	-- Focused Insight
	[79101]	= '3600;1',	-- Blessing of Might
	[79104]	= '3600;1',	-- Power Word: Fortitude
	[79206]	= '10;1',	-- Spiritwalker's Grace
	[79438]	= '8;1',	-- Soulburn: Demonic Circle
	[79460]	= '20;1',	-- Demon Soul: Felhunter
	[80886]	= '0;0',	-- Primal Madness
	[81141]	= '10;0',	-- Blood Swarm
	[81256]	= '12;0',	-- Dancing Rune Weapon
	[81277]	= '0;0',	-- Blood Gorged
	[81781]	= '25;0',	-- Power Word: Barrier
	[82691]	= '10;0',	-- Ring of Frost
	[82692]	= '15;0',	-- Focus Fire
	[82897]	= '8;0',	-- Resistance is Futile!
	[82925]	= '30;0',	-- Ready, Set, Aim...
	[83073]	= '6;1',	-- Shattered Barrier
	[83154]	= '9;1',	-- Piercing Chill
	[84963]	= '4;1',	-- Inquisition
	[85421]	= '7;1',	-- Burning Embers
	[85696]	= '20;1',	-- Zealotry
	[85739]	= '10;0',	-- Meat Cleaver
	[86669]	= '30;0',	-- Guardian of Ancient Kings Summon
	[87173]	= '4;0',	-- Long Arm of the Law
	[88448]	= '10;0',	-- Demonic Rebirth
	[89388]	= '12;0',	-- Sic 'Em!
	[89420]	= '1.5;1',	-- Drain Life
	[89485]	= '0;1',	-- Inner Focus
	[89751]	= '6;0',	-- Felstorm
	[89766]	= '4;0',	-- Axe Toss
	[89906]	= '10;0',	-- Judgements of the Bold
	[90174]	= '8;0',	-- Hand of Light
	[90315]	= '30;1',	-- Tailspin
	[90364]	= '0;0',	-- Qiraji Fortitude
	[91711]	= '30;1',	-- Nether Ward
	[91807]	= '2;0',	-- Shambling Rush
	[66]	= '3;6',	-- Invisibility
	[603]	= '60;4',	-- Bane of Doom
	[1742]	= '6;0',	-- Cower
	[1949]	= '15;0',	-- Hellfire
	[2812]	= '3;1',	-- Holy Wrath
	[14183]	= '20;0',	-- Premeditation
	[17057]	= '6;0',	-- Furor
	[19306]	= '5;0',	-- Counterattack
	[19577]	= '15;0',	-- Intimidation
	[31117]	= '5;1',	-- Unstable Affliction
	[31850]	= '10;0',	-- Ardent Defender
	[31930]	= '10;0',	-- Judgements of the Wise
	[31935]	= '3;1',	-- Avenger's Shield
	[32409]	= '1;0',	-- Shadow Word: Death
	[33878]	= '60;0',	-- Mangle
	[51185]	= '0;0',	-- King of the Jungle
	[54706]	= '5;1',	-- Venom Web Spray
	[64382]	= '10;0',	-- Shattering Throw
	[77489]	= '6;0',	-- Echo of Light
	[77758]	= '6;0',	-- Thrash
	[79440]	= '6;1',	-- Soulburn: Searing Pain
	[81017]	= '8;5',	-- Stampede
	[81022]	= '10;5',	-- Stampede
	[81162]	= '8;0',	-- Will of the Necropolis
	[81206]	= '30;0',	-- Chakra: Prayer of Healing
	[81262]	= '7;0',	-- Efflorescence
	[81325]	= '0;0',	-- Brittle Bones
	[85383]	= '15;1',	-- Improved Soul Fire
	[85416]	= '2;0',	-- Grand Crusader
	[85433]	= '15;0',	-- Sacred Duty
	[86659]	= '12;0',	-- Guardian of Ancient Kings Summon
	[87342]	= '20;1',	-- Holy Shield
	[88063]	= '6;1',	-- Guarded by the Light
	[90785]	= '0.4;0',	-- Glyph of Power Word: Barrier
	[91797]	= '4;0',	-- Monstrous Blow
	[94528]	= '20;0',	-- Flare
	[26573]	= '10;0',	-- Consecration
	[30151]	= '6;0',	-- Pursuit
	[54786]	= '2;0',	-- Demon Leap
	[79106]	= '3600;1',	-- Shadow Protection
	[81208]	= '30;0',	-- Chakra: Heal
	[87096]	= '20;0',	-- Thunderstruck
	[88684]	= '6;0',	-- Holy Word: Serenity
	[90361]	= '10;1',	-- Spirit Mend
	[93435]	= '60;0',	-- Roar of Courage
	[93987]	= '3;0',	-- Aura of Foreboding
	[19883]	= '0;0',	-- Track Humanoids
	[32216]	= '20;0',	-- Victorious
	[48025]	= '0;0',	-- Headless Horseman's Mount
	[51789]	= '10;0',	-- Blade Barrier
	[66251]	= '8;0',	-- Launch
	[79459]	= '30;1',	-- Demon Soul: Imp
	[83046]	= '1.5;0',	-- Improved Polymorph
	[83098]	= '15;0',	-- Improved Mana Gem
	[84585]	= '15;0',	-- Slaughter
	[86662]	= '15;0',	-- Rude Interruption
	[87160]	= '6;1',	-- Mind Melt
	[87178]	= '12;0',	-- Mind Spike
	[87717]	= '0;0',	-- Tranquil Mind
	[89792]	= '0.2;0',	-- Flee
	[5740]	= '8;0',	-- Rain of Fire
	[17735]	= '5;0',	-- Suffering
	[19975]	= '27;1',	-- Entangling Roots
	[33745]	= '15;0',	-- Lacerate
	[63087]	= '5;0',	-- Raptor Strike
	[79437]	= '8;0',	-- Soulburn: Healthstone
	[80951]	= '10;0',	-- Pulverize
	[85387]	= '2;1',	-- Aftermath
	[86663]	= '30;0',	-- Rude Interruption
	[87194]	= '4;0',	-- Paralysis
	[93622]	= '5;0',	-- Berserk
	[10]	= '8;0',	-- Blizzard
	[8034]	= '8;0',	-- Frostbrand Attack
	[73682]	= '5;0',	-- Unleash Frost
	[5225]	= '0;0',	-- Track Humanoids
	[12968]	= '15;0',	-- Flurry
	[26679]	= '6;0',	-- Deadly Throw
	[48505]	= '10;0',	-- Starfall
	[48719]	= '600;0',	-- Water Breathing
	[60970]	= '0.1;0',	-- Heroic Fury
	[61391]	= '6;0',	-- Typhoon
	[61882]	= '8;0',	-- Earthquake
	[77764]	= '6;0',	-- Stampeding Roar
	[79462]	= '20;1',	-- Demon Soul: Felguard
	[81192]	= '3;0',	-- Lunar Shower
	[81261]	= '10;0',	-- Solar Beam
	[81281]	= '2;1',	-- Fungal Growth
	[84617]	= '15;0',	-- Revealing Strike
	[84745]	= '15;0',	-- Shallow Insight
	[84746]	= '15;0',	-- Moderate Insight
	[84747]	= '15;0',	-- Deep Insight
	[85539]	= '0;0',	-- Jinx
	[86105]	= '3;0',	-- Jinx: Curse of the Elements
	[86759]	= '3;1',	-- Silenced - Improved Kick
	[93400]	= '8;1',	-- Shooting Stars
	[93402]	= '12;1',	-- Sunfire
	[93986]	= '3;1',	-- Aura of Foreboding
	[746]	= '6;0',	-- First Aid
	[1022]	= '10;1',	-- Hand of Protection
	[20050]	= '15;1',	-- Conviction
	[27243]	= '18;1',	-- Seed of Corruption
	[76780]	= '50;1',	-- Bind Elemental
	[79062]	= '3600;1',	-- Blessing of Kings
	[79464]	= '15;1',	-- Demon Soul: Voidwalker
	[81661]	= '15;0',	-- Evangelism
	[81700]	= '18;1',	-- Archangel
	[80325]	= '0;7',	-- Camouflage
	[81301]	= '12;1',	-- Glyph of Spirit Tap
	[87204]	= '3;1',	-- Sin and Punishment
	[51701]	= '0;0',	-- Honor Among Thieves
	[81021]	= '10;5',	-- Stampede
	[81130]	= '30;0',	-- Scarlet Fever
	[90806]	= '9;0',	-- Executioner
	[28271]	= '50;1',	-- Polymorph (turtle)
	[28272]	= '50;1',	-- Polymorph (pig)
	[61305]	= '50;1',	-- Polymorph (cat)
}



--Durations that don't match PvE durations.
--http://www.wowwiki.com/Diminishing_returns
lib.auraInfoPvP = {
	[339]	= 10, 	-- Entangling Roots	
	[2637]	= 10, 	-- Hibernate (18657)
	[3355]	= 10, 	-- Freezing Trap Effect
	[61721] = 10, 	-- Polymorph (Rabbit)
	[118]	= 10,	-- Polymorph
	[28271]	= 10,	-- Polymorph (turtle)
	[28272]	= 10,	-- Polymorph (pig)
	[61305]	= 10,	-- Polymorph (cat)
	[20066] = 6, 	-- Repentance
	[10326] = 10, 	-- Turn Evil
	[605]	= 10, 	-- Mind Control
	[6770]	= 10, 	-- Sap
	[51514] = 10, 	-- Hex 
	[6358]	= 10, 	-- Seduction
	[1715]	= 10, 	-- Hamstring
	[770]	= 40, 	-- Faerie Fire
	[16857] = 40, 	-- Faerie Fire (Feral)
	[710]	= 6,	-- Banish
	[5782]	= 10,	-- Fear
	[1130]	= 120,	-- Hunter's Mark
	[1490]	= 120,	-- Curse of the Elements
	[19386]	= 6,	-- Wyvern Sting
	[9484]	= 10,	-- Shackle Undead

}

--[[
	PvP spells need confirm
[14308] = 10, --Freezing Trap Effect (Rank 2)
[14309] = 10, --Freezing Trap Effect (Rank 3)
[49012] = 6, -- Wyvern Sting (Rank 6)
[8643] = 6, -- Kidney Shot (Rank 2) (time based on comob points, i'll assume they're using 5 points)
[51724] = 10, -- Sap (Rank 4)
[18647] = 6, -- Banish (Rank 2)
[6215] = 10, -- Fear (Rank 3)
	
]]

--~ local mem2 = collectgarbage("count")
--~ local memoryUsed = (mem2 - mem1) * 1024
--~ print("our spelldata table's using. "..memoryUsed.." bytes")

--~ local newTbl = {}

--~ for spellID in pairs(lib.auraInfo) do 
--~ 	newTbl[spellID] = {x=1,y=1}
--~ end

--~ local mem3 = collectgarbage("count")
--~ local memoryUsed = (mem3 - mem2) * 1024
--~ print("our spelldata if we were using tables. "..memoryUsed.." bytes")
