----------------------------------------------------------------------
-- 	Leatrix Plus Locale
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Plus = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Plus.L = L

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["Leatrix Plus"] = "功能百宝箱"
L["A friend request from"] = "你有一个好友申请，来自"
L["Accept resurrection"] = "自动接受战复"
L["Accept summon"] = "自动接受召唤"
L["Addon"] = "插件"
L["Ahn'kahet (Old Kingdom)"] = "安卡赫特：古代王国"
L["Ahn'Qiraj"] = "安其拉"
L["Alterac Mountains"] = "奥特兰克山脉"
L["Alterac Valley"] = "奥特兰克山谷"
L["Anchor"] = "锚点"
L["Angelic"] = "主题：天使"
L["Arathi Basin"] = "阿拉希盆地"
L["Arathi Highlands"] = "阿拉希高地"
L["Arcatraz"] = "禁魔监狱"
L["Ashenvale"] = "灰谷"
L["Auchenai Crypts"] = "奥金尼地穴"
L["Auchindoun"] = "奥金顿"
L["Auto loot is now enabled."] = "自动拾取已启用。"
L["AutoFollow"] = "自动跟随"
L["AutoFollow disabled."] = "已关闭自动跟随。"
L["Automate gossip"] = "对话自动交互"
L["Automate quests"] = "任务自动交接"
L["Automation"] = "自动交互"
L["Azjol-Nerub"] = "艾卓-尼鲁布"
L["Azshara"] = "艾萨拉"
L["Azuremyst Isle"] = "秘蓝岛"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "损坏的ID"
L["Badlands"] = "荒芜之地"
L["Barrens"] = "南贫瘠之地"
L["Battle"] = "主题：战争"
L["Battle of Angrathar the Wrathgate"] = "天谴之门之站"
L["Battlegrounds"] = "战场"
L["Black Morass"] = "幽暗沼泽"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "刀锋山"
L["Blasted Lands"] = "诅咒之地"
L["Block duels"] = "屏蔽决斗信息"
L["Block friend requests"] = "屏蔽好友申请"
L["Block party invites"] = "屏蔽队伍邀请"
L["Blocks"] = "屏蔽"
L["Bloodmyst Isle"] = "秘血岛"
L["Book Text"] = "文本字体"
L["Borean Tundra"] = "北风苔原"
L["Bottom"] = "底部"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "燃烧平原"
L["Buyout Only"] = "仅限一口价"
L["C"] = "披风"
L["Camera distance"] = "镜头距离"
L["Cape of Stranglethorn"] = "荆棘谷海角"
L["Caverns of Time"] = "时光之穴"
L["Chain style"] = "边框样式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天窗口"
L["Checkbox labels are Ok."] = "复选框信息检查通过"
L["Cinematics"] = "过场动画"
L["Class Colored Frames"] = "职业颜色染色面板"
L["Class colored frames"] = "框体职业染色"
L["Class icon portraits"] = "职业图标替换"
L["Classic"] = "经典"
L["click here for new selection"] = "点击此处跳转下一曲目"
L["click here to shuffle music"] = "点击随机播放音乐"
L["Click to configure the settings for this option."] = "点击进行额外的选项设置"
L["Click to reset the settings on this page."] = "点击重置此页面的设置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "点击重设屏幕尺寸以适配上下边框"
L["Click to return to the main menu."] = "点击返回到主菜单"
L["Cloak"] = "披风"
L["Coilfang Reservoir"] = "盘牙水库"
L["Color the backdrops based on faction"] = "根据阵营着色边框"
L["Combat log cannot be hidden while undocked."] = "战斗记录窗口被分离时无法隐藏。"
L["Combat plates"] = "自动开关姓名板"
L["Configuration Panel"] = "设置面板"
L["Connections for"] = "连接到"
L["Cooldowns"] = "冷却计时"
L["Credits"] = "Credits"
L["Crystalsong Forest"] = "晶歌森林"
L["Culling of Stratholme"] = "净化斯坦索姆"
L["Cursor"] = "光标"
L["Cursor Left"] = "光标左侧"
L["Cursor Right"] = "光标右侧"
L["Customise minimap"] = "自定义小地图"
L["Dalaran"] = "达拉然"
L["Darken the frame background"] = "显示深色背景"
L["Darkmoon Faire"] = "暗月马戏团"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "达纳苏斯"
L["Deadmines"] = "死亡矿井"
L["Deadwind Pass"] = "逆风小径"
L["Deepwind Gorge"] = "深风峡谷"
L["Desolace"] = "凄凉之地"
L["Dire Maul"] = "厄运之槌"
L["Dire Maul: Capital Gardens"] = "厄运之槌：中心花园"
L["Dire Maul: Gordok Commons"] = "厄运之槌：戈多克议会"
L["Dire Maul: Warpwood Quarter"] = "厄运之槌：扭木广场"
L["Disable bag automation"] = "禁用自动背包"
L["Disable chat fade"] = "禁用聊天窗口淡出"
L["Disable loot warnings"] = "禁用拾取通报"
L["Disable screen effects"] = "禁用屏幕特效"
L["Disable screen glow"] = "禁用屏幕泛光"
L["Disable sticky chat"] = "禁用聊天频道粘滞"
L["Drag the frame overlay to position the frame."] = "拖动框体边框来移动。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移动面板来定位框体。|n|n如果想要改变框体尺寸，你需选定面板，然后移动滑块来选择。|n|n你一旦进入战斗，这个框体会自动关闭。"
L["Drag to set the cursor X offset."] = "拖拽以设置光标横向偏移。"
L["Drag to set the cursor Y offset."] = "拖拽以设置光标纵向偏移。"
L["Drag to set the density of weather effects."] = "拖动以调整天气效果的密度。"
L["Drag to set the font size of book text."] = "拖动以调整文本字体的大小。"
L["Drag to set the font size of mail text."] = "拖动以调整邮件文本大小。"
L["Drag to set the font size of quest text."] = "拖动以调整任务文本大小。"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖到以调整小地图缩放。|n|n需要注意的是，如果你使用自带的动作条，对小地图进行缩放会影响到右侧动作条的排序。为避免这种情况，建议将此项设置为100%。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板缩放。"
L["Drag to set the scale of the selected frame."] = "拖动以调整所选中面板的缩放。"
L["Drag to set the size of the bottom border."] = "拖动以调整底部边框。"
L["Drag to set the size of the left border."] = "拖动以调整左侧边框。"
L["Drag to set the size of the right border."] = "拖动以调整右侧边框。"
L["Drag to set the size of the top border."] = "拖动以调整顶部边框。"
L["Drag to set the tooltip scale."] = "拖动以调整鼠标提示的缩放。"
L["Drag to set the transparency of the borders."] = "拖动以调整边框透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板的透明度。"
L["Dragonblight"] = "龙骨荒野"
L["Drak'Tharon Keep"] = "达克萨隆要塞"
L["Dun Morogh"] = "丹莫罗"
L["Dungeon"] = "地下城"
L["Dungeons"] = "地下城"
L["Dup ID"] = "复制的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Eastern"] = "东部王国"
L["Eastern Kingdoms"] = "东部王国"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾尔文森林"
L["Enable hotkey"] = "启用热键"
L["Enable viewport"] = "画面视口"
L["Enhance dressup"] = "增强换装预览"
L["Enhance professions"] = "专业面板增强"
L["Enhance quest log"] = "任务面板拓展"
L["Enhance trainers"] = "增强训练面板"
L["Enhancements"] = "增强功能"
L["Enter"] = "输入"
L["enter music or movie name"] = "输入音乐或短片名称"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "输入你想要监控的法术ID。|n|n如果这个法术来自于你的宠物，请勾选宠物复选框。|n|n法术图标会按职业进行保存。"
L["enter zone or track name"] = "输入区域或者曲目名称"
L["Error messages will be hidden"] = "错误信息已屏蔽。"
L["Error messages will be shown"] = "错误信息已显示。"
L["Error Text"] = "错误文本"
L["Events"] = "事件"
L["Eversong Woods"] = "永歌森林"
L["Extras"] = "其他"
L["Eye of the Storm"] = "风暴之眼"
L["Fall of the Lich King"] = "巫妖王的殒落"
L["False"] = "错误"
L["Faster auto loot"] = "加速自动拾取"
L["Faster movie skip"] = "快速跳过短片"
L["Features"] = "功能"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Find Item"] = "查找物品"
L["Forge of Souls"] = "灵魂熔炉"
L["Frames"] = "框体相关"
L["Game Options"] = "游戏设置"
L["Ghost"] = "灵魂状态框体"
L["Ghostlands"] = "幽魂之地"
L["Gloomy"] = "主题：阴暗"
L["Gnomeregan"] = "诺莫瑞根"
L["Gold Only"] = "仅输入金币"
L["Graphics and Sound"] = "界面和音效"
L["Grizzly Hills"] = "灰熊丘陵"
L["Groups"] = "队伍"
L["Gruul's Lair"] = "格鲁尔的巢穴"
L["Gundrak"] = "古达克"
L["Gundrak (rear entrance)"] = "古达克（后门）"
L["H"] = "头盔"
L["Halls of Lightning"] = "闪电大厅"
L["Halls of Reflection"] = "倒映大厅"
L["Halls of Stone"] = "岩石大厅"
L["Halls of Valor"] = "勇气大厅"
L["Haunted"] = "主题：鬼怪"
L["Hellfire Citadel"] = "地狱火堡垒"
L["Hellfire Peninsula"] = "地狱火半岛"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Helm"] = "头盔"
L["Help"] = "帮助"
L["Hide chat buttons"] = "隐藏聊天窗口按钮"
L["Hide cooldown duration numbers (if enabled)"] = "隐藏冷却计时（若启用）"
L["Hide crafted names"] = "隐藏制造者名字"
L["Hide error messages"] = "隐藏错误信息"
L["Hide gryphons"] = "隐藏动作条狮鹫"
L["Hide level-up display"] = "隐藏升级提示"
L["Hide portrait numbers"] = "隐藏头像数字"
L["Hide social button"] = "隐藏社交按钮"
L["Hide stance bar"] = "隐藏姿态条"
L["Hide the clock"] = "隐藏时钟"
L["Hide the combat log"] = "隐藏战斗记录窗口"
L["Hide the zone text bar"] = "隐藏区域信息"
L["Hide the zoom buttons"] = "隐藏缩放按钮"
L["Hide tooltips for world units during combat"] = "战斗中隐藏窗口"
L["Hide zone text"] = "隐藏区域文本"
L["High"] = "高"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Hinterlands"] = "辛特兰"
L["Home"] = "主页"
L["Howling Fjord"] = "嚎风峡湾"
L["Hyjal Summit"] = "海加尔山"
L["Icecrown"] = "冰冠冰川"
L["Icecrown Citadel"] = "冰冠堡垒"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "勾选后，会在背包及银行界面显示搜索框。"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾选后，一个按钮会显示在角色框体，其鼠标提示信息会显示身上的装备耐久度。|n|n当你死后，你的整体耐久度也会显示在聊天框体。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "勾选后，当你未组队或者有队伍权限时，会自动邀请密语中包含预设关键词的玩家。"
L["If checked, a master volume slider will be shown in the character sheet."] = "勾选后，一个音量调整滑块会显示在你角色页面。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾选后，会启用小地图快捷按钮。|n|n左键：打开设置面板。|n|nSHIFT+左键：打开音乐播放器。|n|nCTRL+右键：开关红字错误过滤（需启用）。|n|nCTRL+SHIFT+左键：开关Zygor插件（需安装）。|n|nCTRL+SHIFT+右键：切换窗口模式。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "勾选后，会增强你的拍卖行窗口。|n|n一口价：商品上架时自动同步起拍价和一口价。|n|n取整：自动将铜币与银币设置为99。|n|n搜索：搜索拍卖行中你正售卖的物品。|n|n额外的，拍卖持续时间将设置为账号共享。"
L["If checked, alert frames will not be shown."] = "勾选后，通知提示框体不再显示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你访问商贩时将自动出售背包中的杂物。|n|n当你访问时按住Shift键，可以暂时忽略该功能。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾选后，信息窗口的边框会更改为蓝色（右方）或者红色（敌方）。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾选后，战网好友申请会自动屏蔽。|n|n启用后，当前待处理的申请会自动拒绝。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾选后，聊天窗口的按钮会被隐藏。|n|n点击窗口标签会自动显示最新的消息。|n|n使用鼠标滚轮可以查看历史消息。按住SHIFT进行消息页面跳转，按住CTRL将滚动至消息页首/页尾。"
L["If checked, chat text will not fade out after a time period."] = "勾选后，聊天信息不会在一定时间后淡出。"
L["If checked, class coloring will be used in the player frame and target frame."] = "勾选后，将在玩家与目标框体显示职业颜色。"
L["If checked, class colors will be used in the chat frame."] = "勾选后，职业颜色将应用于聊天窗口。"
L["If checked, class icons will be shown in the portrait frames."] = "勾选后，玩家的头像会替换为职业图标。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾选后，当你选择Roll点或者想要出售/邮寄一个可交易物品时，不再显示确认信息。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾选后，冷却计时数字不再显示。|n|n如果未勾选，在界面-动作条中启用冷却计时后，在相关的冷却中的法术图标会显示计时数字。"
L["If checked, crafted items will no longer show the name of the crafter."] = "勾选后，制造物品不再显示制造者的名字。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾选后，在玩家头像和宠物头像上的伤害及治疗数字不再显示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾选后，对锁定的聊天窗口进行拖动，会使其竖直拉伸。|n|n对已解锁的聊天窗口进行拖动，会使其移动。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的决斗信息会被屏蔽。"
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "勾选后，当你休息或处于黑铁酒吧时，禁用表情音效。|n|n在其他状态下，将恢复表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾选后，敌对姓名板会在战斗中自动开启，离开战斗后关闭。"
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "勾选后，自动邀请将仅限于好友及公会成员。|n|n如果未勾选，组队邀请将面向所有人。"
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "勾选后，将显示其公会名字。如果玩家和你处于同一公会，将同时显示其公会会阶。"
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "勾选后，会在角色面板显示头盔及披风的开关复选框。|n|n你可以按住Shift键的同时，右键点击复选框切换排列。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾选后，除了部分特殊提示，大部分的错误信息（例如怒气不足）都不再显示。|n|n如果你启用了小地图按钮，你可以按住CTRL+鼠标右键来单独控制错误信息的开关。"
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "勾选后，脱装及战袍切换按钮会显示在试衣间。同时将移除模型旋转控制按钮。"
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "勾选后，自动接受来自好友及公会成员的组队邀请。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的组队邀请会被屏蔽。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "勾选后，将自动交互任务系统。|n|n任务如果需要提供金币，不会进行自动交互。|n|n当按住SHIFT键后与NPC进行交谈，会停止该次自动交互。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾选后，团队和副本聊天信息会改为蓝色（与小队一致）。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "勾选后，当你不处于战斗中时，会自动接受他人对你的复活。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾选后，在Buff框体和目标头像下方的相关法术图标的鼠标提示框中，会显示它们的法术ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾选后，会禁用聊天频道的粘滞。|n|n此选项不会影响临时对话窗口。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾选后，当你不处于战斗状态时会自动接受召唤。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾选后，插件列表（游戏菜单处）会显示默认的对角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾选后，自动拾取的耗时将会明显降低。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾选后，背包及银行的整理按钮不再显示。"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "勾选后，BOSS的横幅信息不再显示。|n|n该信息通常在BOSS被击败后显示。它显示BOSS的名字以及掉落。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾选后，打开团队信息的按钮会显示在左侧团队管理框体的上方，而不是在其内部。|n|n此选项让你无需打开团队管理框体，就可以切换团队框体。"
L["If checked, the clock will be hidden."] = "勾选后，小地图的时钟会被隐藏。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾选后，战斗记录会被隐藏。|n|n战斗记录窗口必须未被分离时才能生效。|n|n如果战斗记录窗口被分离了，你可以拖动其合并至主窗口（然后重载插件），或者在聊天设置中重置设置。"
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "勾选后，“对他人只显示角色成就”的选项（界面-社交）会被永久勾选并锁定。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾选后文本框会被移动至聊天窗口上方。"
L["If checked, the game world will be resized to fit between the top and bottom borders.|n|nNote that if you enable this setting, the transparency slider will no longer affect the top and bottom borders."] = "勾选后，游戏界面的大小会修改适应顶部和底部的边框。|n|n当你启用这个选项时，透明度的调节不再影响这两个边框。"
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "勾选后，你的保镖对话时不再出现选项。|n|n对话时按住Shift键，可以暂时忽略该项设置。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾选后，将关闭死亡后的灵魂世界特效和渐隐时的特殊光效。"
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "勾选后，升级提示不再显示。|n|n升级提示功能包括副本目标、升级、小宠物奖励等等。"
L["If checked, the main bar gryphons will not be shown."] = "勾选后，动作条两边的狮鹫不再显示。"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "勾选后，会在行囊图标处显示剩余背包空间。"
L["If checked, the per unit vendor price will be shown in item tooltips."] = "勾选后，会在鼠标提示中显示每个单位物品的售价。"
L["If checked, the player frame background will be shown in class color."] = "勾选后，玩家头像面板的背景将用职业颜色染色。"
L["If checked, the professions frame will be larger."] = "勾选后，将拓展专业面板。"
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "勾选后，将增大任务日志窗口，同时显示任务等级，并添加一个显示地图的按钮。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾选后，屏幕泛光会被禁用。|n|n启用这个选项的同时，也会关闭醉酒时的泛光效果。"
L["If checked, the shaman class color will be changed from pink to blue."] = "勾选后，萨满的职业颜色会从粉色修改为蓝色。"
L["If checked, the skill trainer frame will be larger."] = "勾选后，技能训练面板会进行拓展。"
L["If checked, the stance bar will not be shown."] = "勾选后，姿态条不再显示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾选后，对话面板不再显示。|n|n当NPC与你交流时，该框体通常出现在界面下方。"
L["If checked, the target frame background will be shown in class color."] = "勾选后，目标头像面板的背景将用职业颜色染色。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾选后，鼠标信息会被着色，你可以设置他的布局和大小尺寸。"
L["If checked, the vendor price will be shown in item tooltips."] = "勾选后，将在物品的鼠标提示中显示其卖价。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾选后，小地图的区域信息会被隐藏。追踪按钮的提示信息里会显示区域信息。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾选后，缩放按钮会被隐藏。你可以使用鼠标滚来来对小地图进行缩放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾选后，目标的信息窗口在战斗中会被隐藏。|n|n你可以按住SHIFT键暂时忽略这个设置。"
L["If checked, unit targets will be shown."] = "勾选后，目标的目标会显示在信息窗口上。"
L["If checked, Wowhead links will be shown above the quest log frame."] = "勾选后，将在任务窗口中显示相应的Wowhead链接。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "勾选后，对于只有一个选项的对话窗口，你可以按住ALT键进行自动交互。|n|n如果目标是银行管理员、飞行管理员、训练师或者商贩，无需按住ALT键即可自动跳过。|n|n你可以按住SHIFT键忽略该次交互。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾选后，你可以按住CTRL键，点击聊天标签来打开相应的历史记录窗口，以供复制。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾选后，你可以使用CTRL+Z来打开Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾选后，你可以使用方向键移动文本框中的光标。|n|n如果未被勾选，方向键将保持它所绑定的按键功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾选后，你无需确认即可快速跳过过场短片。"
L["If checked, you will be able to change the font size of book text."] = "勾选后，你可以调整文本字体的大小。"
L["If checked, you will be able to change the font size of quest text."] = "勾选后，你可以调整任务文本的字体大小。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾选后，你可以更改邮件文本的字体大小。|n|n这个选项不会影响系统邮件模版（例如拍卖行的收据信息）。"
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Buffs frame|n- Widget top center frame|n- Timer bar"] = "勾选后，你可以调整下列框体的位置及缩放：|n|n- 玩家框体|n- 目标框体|n- Buff框体|n- 顶部信息框体|n- 计时条"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾选后，你会生成一个画面视口，这个可以在游戏界面周围增加黑色的边框背景。|n|n边框的层级是处于游戏界面和插件之间，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾选后，你可以开启小地图相关的自定义选项。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾选后，你可以把聊天窗口拖动到屏幕边缘。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾选后，你可以在目标框体上方监控至多5个的法术监控。"
L["If checked, you will be able to reposition the tooltip."] = "勾选后，你可以重新给鼠标提示框设置锚点。"
L["If checked, you will be able to set the density of weather effects."] = "勾选后，你可以调整天气密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾选后，会在玩家框体显示稀有、精英或者稀有精英的边框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾选后，你可以加大镜头的缩放距离。"
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "勾选后，当你在战场中阵亡时会自动进行释放。|n|n如果你有复生能力，则不会进行自动释放。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾选后，当你打开商贩、银行或者邮箱时，背包不会自动开启或者关闭。"
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "勾选后，你的角色会根据当前需求自动站立或者解除坐骑。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾选后，你的聊天历史记录会增涨至4096行。如果未被勾选，会保持在默认的128行。|n|n启用这个设置可能会在登录时会隐藏一些聊天信息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你打开一个可供修理的商贩时，会自动修理身上的装备。|n|n当你打开商贩时，按住SHIFT键会让你当下忽略此项功能。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾选后，区域文本不再显示。"
L["Increase chat history"] = "增加聊天历史记录"
L["Interface"] = "界面设置"
L["Invalid console variable."] = "无效控制台缓存。"
L["Invalid parameter."] = "无效参数"
L["Invalid quest ID."] = "无效的任务ID。"
L["Invalid sound ID"] = "无效的声音ID"
L["Invalid taint level."] = "无效的污染等级。"
L["Invalid target."] = "无效目标。"
L["Invite from whispers"] = "密语邀请"
L["Invite From Whispers"] = "密语自动邀请"
L["Iron Docks"] = "钢铁码头"
L["Ironforge"] = "铁炉堡"
L["Isle of Quel'Danas"] = "奎尔丹纳斯岛"
L["Kalimdor"] = "卡利姆多"
L["Karazhan"] = "卡拉赞"
L["Keyword"] = "关键词"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "下次登出时不会清空LeatrixPlus的插件缓存。"
L["Left"] = "左边"
L["Lifetime honorable kills"] = "荣誉击杀总数"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享锁定"
L["Lower Blackrock Spire"] = "黑石塔下层"
L["Magic"] = "主题：魔法"
L["Magisters' Terrace"] = "魔导师平台"
L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
L["Mail Text"] = "邮件文本"
L["Main Titles"] = "主题音乐"
L["Make shaman blue"] = "萨满使用蓝色职业色"
L["Manage frames"] = "管理框体面板"
L["Manage tooltip"] = "鼠标信息窗口"
L["Managed by Leatrix Plus"] = "LeatrixPlus托管"
L["Mana-Tombs"] = "法力陵墓"
L["Map"] = "地图"
L["Maraudon"] = "玛拉顿"
L["Maraudon: Earth Song Falls"] = "玛拉顿：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "玛拉顿：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "玛拉顿：邪恶洞穴"
L["Max camera zoom"] = "最大镜头距离"
L["Mechanics"] = "特性设置"
L["Media"] = "媒体"
L["Medium"] = "中"
L["Memory Usage"] = "内存占用"
L["Merge the tracking and calendar buttons"] = "合并追踪和日历按钮"
L["message shown."] = "信息显示。"
L["messages shown."] = "信息显示。"
L["Minimap"] = "小地图"
L["Missing console variable."] = "丢失控制台缓存。"
L["Missing mount name."] = "坐骑名字缺失。"
L["Missing movie ID."] = "影片编号不存在。"
L["Missing quest ID."] = "缺少任务ID。"
L["Missing sound file parameter."] = "缺失音频文件参数"
L["Missing sound ID."] = "缺少声音ID。"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["Mount Hyjal"] = "海加尔山"
L["Mount not found."] = "无法找到该坐骑。"
L["Move editbox to top"] = "把文本框移动上方"
L["Movie not playable."] = "无法播放该影片。"
L["Movie number"] = "影片编号"
L["Movies"] = "电影"
L["Mulgore"] = "莫高雷"
L["Music"] = "音乐"
L["Music Rolls"] = "音乐列表"
L["Musical Moments"] = "音乐主题时刻"
L["Mystery"] = "主题：神秘"
L["Nagrand"] = "纳格兰"
L["Narration"] = "旁白"
L["Naxxramas"] = "纳克萨玛斯"
L["Netherstorm"] = "虚空风暴"
L["Nexus"] = "时空枢纽"
L["No bad sound IDs found."] = "没有发现损坏的ID。"
L["No help is available for this page."] = "此页面没有帮助信息。"
L["No items with durability equipped."] = "尚未装备任何带有耐久度的物品。"
L["No media duplicates found."] = "没有发现媒体的副本。"
L["No tooltip showing."] = "目前没有任何提示信息。"
L["None"] = "无"
L["Northern Barrens"] = "北贫瘠之地"
L["Northern Stranglethorn"] = "北荆棘谷"
L["Northrend"] = "诺森德"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "注意！|n你必须重新启动游戏客户端才可以正确加载新版本的Leatrix Plus。"
L["Nude"] = "隐藏着装"
L["Obsidian Sanctum"] = "黑曜石圣殿"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["or click the minimap button to open Leatrix Plus."] = "或点击小地图按钮打开Leatrix Maps。"
L["Orgrimmar"] = "奥格瑞玛"
L["Outland"] = "外域"
L["Overall"] = "总计"
L["Overlay"] = "边框"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友组队邀请"
L["Pet"] = "宠物"
L["Pit of Saron"] = "萨隆矿坑"
L["Player"] = "玩家框体"
L["Player Chain"] = "玩家边框"
L["Portal"] = "传送门"
L["Power"] = "能量"
L["Press CTRL/C to copy."] = "按住CTRL+C复制"
L["Quest completed."] = "任务已完成。"
L["Quest not completed."] = "任务未完成。"
L["Quest Text"] = "任务信息文本"
L["Queue from friends"] = "好友队列申请"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Raid frame toggle"] = "切换团队框体"
L["Random"] = "随机"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Recent chat window"] = "临时聊天窗口"
L["Redridge Mountains"] = "赤脊山"
L["Release in PvP"] = "PvP自动释放尸体"
L["Reload"] = "重载插件"
L["Repair automatically"] = "自动修理装备"
L["Repair Automatically"] = "自动修理"
L["Repair using guild funds if available"] = "优先使用公会修理"
L["Repaired for"] = "修理花费"
L["Reposition the tooltip"] = "重设提示框锚点"
L["Requires UI reload."] = "需要重载插件"
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "需要你与拉兰娜·德罗姆交流。她可以在达拉然（诺森德）的铭文店里找到。"
L["Reset"] = "重置"
L["Resize book text"] = "文本字体调整"
L["Resize mail text"] = "重设邮件文本"
L["Resize quest text"] = "重设任务文本"
L["Resize Screen"] = "屏幕缩放"
L["Resize the game world"] = "修改界面大小"
L["Rested bubbles"] = "休息气泡信息"
L["Restrict to friends and guild members"] = "仅限好友及公会成员"
L["result"] = "结果"
L["results"] = "结果"
L["Right"] = "右边"
L["Right-click to close"] = "右键关闭"
L["Right-click to close."] = "右键点击关闭。"
L["right-click to go back"] = "右键点击返回"
L["Ruby Sanctum"] = "红玉圣殿"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Sacred"] = "主题：恐怖"
L["Scale"] = "尺寸"
L["Scarlet Halls"] = "血色大厅"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Search"] = "搜索"
L["Searing Gorge"] = "灼热峡谷"
L["Select the settings that you want to use."] = "选择你想启用的设置。"
L["Selection of music tracks"] = "音乐列表的选择"
L["Self Markers Allowed"] = "允许自我标记"
L["Self Markers Blocked"] = "屏蔽自我标记"
L["Sell junk automatically"] = "自动出售杂物"
L["SELLING JUNK"] = "出售杂物"
L["Serpentshrine Cavern"] = "毒蛇神殿"
L["Set weather density"] = "调整天气密度"
L["Sethekk Halls"] = "塞泰克大厅"
L["Settings"] = "设置"
L["Shaders"] = "阴影"
L["Shadow Labyrinth"] = "暗影迷宫"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Sholazar Basin"] = "索拉查盆地"
L["Show auction controls"] = "显示拍卖行控制"
L["Show bag search box"] = "显示背包搜索框"
L["Show character addons"] = "显示角色插件"
L["Show cooldowns"] = "显示冷却计时"
L["Show durability status"] = "显示耐久度"
L["Show free bag slots"] = "显示背包剩余空间"
L["Show guild names"] = "显示公会名字"
L["Show minimap button"] = "显示小地图按钮"
L["Show pet save button"] = "保存宠物按钮"
L["Show player chain"] = "显示玩家边框"
L["Show player frame in class color"] = "玩家头像职业染色"
L["Show target frame in class color"] = "目标头像职业染色"
L["Show the spell ID in buff icon tooltips"] = "显示法术ID"
L["Show unit targets"] = "显示单位目标"
L["Show vanity controls"] = "显示模型控制"
L["Show vendor price"] = "显示物品卖价"
L["Show volume slider"] = "显示音量控制"
L["Show Wowhead links"] = "显示wowhead链接"
L["Shrine of the Storm"] = "风暴神殿"
L["Silence rested emotes"] = "表情禁音"
L["Silithus"] = "希利苏斯"
L["Silverpine Forest"] = "银松森林"
L["Silvershard Mines"] = "碎银矿脉"
L["Slave Pens"] = "奴隶围栏"
L["Social"] = "社交信息"
L["Sold junk for"] = "杂物出售总计"
L["Sound system restarted."] = "声音系统已重启。"
L["Southern Barrens"] = "南贫瘠之地"
L["Spell ID"] = "法术ID"
L["Spooky"] = "主题：阴森"
L["Stand and dismount"] = "站立和解除坐骑"
L["Steamvault"] = "蒸汽地窟"
L["Stockade"] = "暴风城监狱"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stop"] = "停止"
L["Storm Peaks"] = "风暴峭壁"
L["Stormwind"] = "暴风城"
L["Strand of the Ancients"] = "远古海滩"
L["Stranglethorn Vale"] = "荆棘谷"
L["Stratholme"] = "斯坦索姆"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字军广场"
L["Stratholme: The Gauntlet"] = "斯坦索姆：后门"
L["Sunken Temple"] = "沉没的神庙"
L["Sunwell Plateau"] = "太阳之井高地"
L["Support"] = "帮助支持"
L["Swamp"] = "主题：沼泽"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["System"] = "系统设置"
L["Tabard"] = "隐藏战袍"
L["Taint level: Basic (1)."] = "污染等级：基本(1)。"
L["Taint level: Disabled (0)."] = "污染等级：禁用(0)。"
L["Taint level: Full (2)."] = "污染等级：全面(2)。"
L["Tanaris"] = "塔纳利斯"
L["Target"] = "目标框体"
L["Target Tracking Disabled"] = "禁用目标追踪"
L["Target Tracking Enabled"] = "启用目标追踪"
L["Teldrassil"] = "泰达希尔"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Temple of Kotmogu"] = "寇魔古寺"
L["Ten Years of Warcraft"] = "魔兽十周年"
L["Terokkar Forest"] = "泰罗卡森林"
L["Text"] = "文本信息"
L["Text size"] = "字体尺寸"
L["Text Size"] = "字体尺寸"
L["The Arcatraz"] = "禁魔监狱"
L["The Black Morass"] = "黑色沼泽"
L["The Blood Furnace"] = "鲜血熔炉"
L["The Botanica"] = "生态船"
L["The Burning Crusade"] = "燃烧的远征"
L["The Culling of Stratholme"] = "净化斯坦索姆"
L["The Deadmines"] = "死亡矿井"
L["The Eye"] = "风暴要塞"
L["The Eye of Eternity"] = "永恒之眼"
L["The Forge of Souls"] = "灵魂洪炉"
L["The Frozen Halls"] = "冰封大殿"
L["The Halls of Reflection"] = "倒映大厅"
L["The Mechanar"] = "能源舰"
L["The Nexus"] = "魔枢"
L["The Obsidian Sanctum"] = "黑曜石圣殿"
L["The Oculus"] = "魔环"
L["The Old Kingdom"] = "古代王国"
L["The Pit of Saron"] = "萨隆矿坑"
L["The Ruby Sanctum"] = "红玉圣殿"
L["The Shattered Halls"] = "破碎大厅"
L["The Stockade"] = "监狱"
L["The Stonecore"] = "巨石之核"
L["The Violet Hold"] = "紫罗兰监狱"
L["The Waning Crescent"] = "残月酒馆"
L["Themes"] = "主题"
L["This panel will close automatically if you enter combat."] = "此面板在你进入战斗后自动关闭。"
L["Thousand Needles"] = "千针石林"
L["Thunder Bluff"] = "雷霆崖"
L["Timer"] = "计时框体"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["To begin, choose an options page."] = "请选择一项开始使用"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "你必须取消魔兽货币分类以启用寻找物品的按钮。"
L["Tol Barad"] = "托尔巴拉德"
L["Tooltip"] = "鼠标信息窗口"
L["Tooltip title color"] = "鼠标提示信息颜色"
L["Top"] = "顶部"
L["Top Center"] = "顶级中心"
L["Tracing started."] = "追踪开始。"
L["Tracing stopped."] = "追踪停止。"
L["Transparency"] = "透明度"
L["Trial of Style"] = "时尚试炼"
L["Trial of the Champion"] = "冠军的试炼"
L["Trial of the Crusader"] = "十字军的试炼"
L["Trial of Valor"] = "勇气试炼"
L["True"] = "正确"
L["Twin Peaks"] = "双子峰"
L["Uldaman"] = "奥达曼"
L["Ulduar"] = "奥杜尔"
L["Unclamp chat frame"] = "不限制窗口位置"
L["Underbog"] = "幽暗沼泽"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Universal group color"] = "统一队伍颜色"
L["Upper Blackrock Spire"] = "黑石塔上层"
L["Use arrow keys in chat"] = "允许使用方向键"
L["Use class colors in chat"] = "聊天窗口启用职业颜色"
L["Use easy resizing"] = "使用简单拉伸"
L["Use Leatrix Plus to move that frame."] = "使用Leatrix Plues来移动框体"
L["Use Leatrix Plus to reset that frame."] = "使用Leatrix Plues来重置框体"
L["Utgarde Keep"] = "乌特加德城堡"
L["Value must be a number."] = "该参数必须为数字。"
L["Various"] = "其他"
L["Vault of Archavon"] = "阿尔卡冯的宝库"
L["Vendors"] = "商贩"
L["Version"] = "版本"
L["Very Low"] = "低"
L["Video"] = "视频"
L["Viewport"] = "视口"
L["Violet Hold"] = "紫罗兰监狱"
L["Visibility"] = "可见性"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Wandering Isle"] = "迷踪岛"
L["Warsong Gulch"] = "战歌峡谷"
L["was automatically declined."] = "已经自动拒绝。"
L["Weather density"] = "天气密度"
L["Weather Density"] = "天气效果密度"
L["Welcome to Leatrix Plus."] = "欢迎使用Leatrix Plus"
L["Well of Eternity"] = "永恒之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "湿地"
L["Widget"] = "窗口小部件"
L["Winter"] = "冬日"
L["Wintergrasp"] = "冬拥湖"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔兽世界"
L["Wrath of the Lich King"] = "巫妖王之怒"
L["Wyrmrest Temple"] = "龙眠神殿"
L["X Offset"] = "横向偏移"
L["Y Offset"] = "纵向偏移"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你无法在战斗中进行该项操作。"
L["You have"] = "你有"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要进行重载插件后才能使部分设置生效。|n|n你无需立即点击重载插件按钮，但是你完成设置并希望其生效时，必须点击它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新载入。"
L["Zangarmarsh"] = "赞加沼泽"
L["Zones"] = "区域"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Drak"] = "祖达克"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"
L["Zygor addon not found."] = "你尚未安装Zygor插件。"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["Leatrix Plus"] = "功能百寶箱"
L["A friend request from"] = "你有一個好友申請，來自"
L["Accept resurrection"] = "自動接受復活"
L["Accept summon"] = "自動接受召喚"
L["Addon"] = "插件"
L["Ahn'kahet (Old Kingdom)"] = "安卡罕特：古王國"
L["Ahn'Qiraj"] = "安其拉"
L["Alterac Mountains"] = "奧特蘭克山脈"
L["Alterac Valley"] = "奧特蘭克山谷"
L["Anchor"] = "定位點"
L["Angelic"] = "天使"
L["Arathi Basin"] = "阿拉希盆地"
L["Arathi Highlands"] = "阿拉希高地"
L["Arcatraz"] = "奴隸監獄"
L["Ashenvale"] = "梣谷"
L["Auchenai Crypts"] = "奧奇奈地穴"
L["Auchindoun"] = "奧齊頓"
L["Auto loot is now enabled."] = "自動拾取現在已啟動。"
L["AutoFollow"] = "自動跟隨"
L["AutoFollow disabled."] = "自動跟隨已停用。"
L["Automate gossip"] = "自動對話"
L["Automate quests"] = "任務自動化"
L["Automation"] = "自動化"
L["Azjol-Nerub"] = "阿茲歐-奈幽"
L["Azshara"] = "艾薩拉"
L["Azuremyst Isle"] = "藍謎島"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "損壞的ID"
L["Badlands"] = "荒蕪之地"
L["Barrens"] = "南貧瘠之地"
L["Battle"] = "戰爭"
L["Battle of Angrathar the Wrathgate"] = "安格薩憤怒之門的戰役"
L["Battlegrounds"] = "戰場"
L["Black Morass"] = "黑色沼澤"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "劍刃山脈"
L["Blasted Lands"] = "詛咒之地"
L["Block duels"] = "拒絕決鬥"
L["Block friend requests"] = "封鎖好友邀請"
L["Block party invites"] = "封鎖隊伍邀請"
L["Blocks"] = "封鎖"
L["Bloodmyst Isle"] = "血謎島"
L["Book Text"] = "書籍文字"
L["Borean Tundra"] = "北風凍原"
L["Bottom"] = "底部"
L["Buffs"] = "增益"
L["Burning Steppes"] = "燃燒平原"
L["Buyout Only"] = "僅限直購價"
L["C"] = "披"
L["Camera distance"] = "鏡頭距離"
L["Cape of Stranglethorn"] = "荊棘谷海角"
L["Caverns of Time"] = "時光之穴"
L["Chain style"] = "邊框樣式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天視窗"
L["Checkbox labels are Ok."] = "複選框標籤是OK的。"
L["Cinematics"] = "過場動畫"
L["Class Colored Frames"] = "職業著色框架"
L["Class colored frames"] = "框架職業染色"
L["Class icon portraits"] = "職業圖示頭像"
L["Classic"] = "經典"
L["click here for new selection"] = "點擊這裡跳轉新選擇"
L["click here to shuffle music"] = "點擊這裡變換音樂"
L["Click to configure the settings for this option."] = "點擊進行額外的選項設置"
L["Click to reset the settings on this page."] = "點擊重置此頁面的設置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "點擊來重設螢幕大小以適配上下邊框。"
L["Click to return to the main menu."] = "點擊返回到主選單"
L["Cloak"] = "披風"
L["Coilfang Reservoir"] = "盤牙蓄湖"
L["Color the backdrops based on faction"] = "根據陣營著色邊框"
L["Combat log cannot be hidden while undocked."] = "戰鬥記錄視窗被分離時無法隱藏。"
L["Combat plates"] = "自動開關姓名板"
L["Configuration Panel"] = "設置面板"
L["Connections for"] = "連結在"
L["Cooldowns"] = "冷卻"
L["Credits"] = "有功人員"
L["Crystalsong Forest"] = "水晶之歌森林"
L["Culling of Stratholme"] = "斯坦索姆的抉擇"
L["Cursor"] = "鼠標"
L["Cursor Left"] = "鼠標左側"
L["Cursor Right"] = "鼠標右側"
L["Customise minimap"] = "自定義小地圖"
L["Dalaran"] = "達拉然"
L["Darken the frame background"] = "顯示深色背景"
L["Darkmoon Faire"] = "暗月馬戲團"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "達納蘇斯"
L["Deadmines"] = "死亡礦坑"
L["Deadwind Pass"] = "逆風小徑"
L["Deepwind Gorge"] = "深風峽谷"
L["Desolace"] = "淒涼之地"
L["Dire Maul"] = "厄運之槌"
L["Dire Maul: Capital Gardens"] = "厄運之槌：中心花園"
L["Dire Maul: Gordok Commons"] = "厄運之槌：戈多克平民區"
L["Dire Maul: Warpwood Quarter"] = "厄運之槌：杻木廣場"
L["Disable bag automation"] = "停用背包自動開啟"
L["Disable chat fade"] = "停用聊天視窗淡出"
L["Disable loot warnings"] = "停用拾取通報"
L["Disable screen effects"] = "停用螢幕特效"
L["Disable screen glow"] = "停用螢幕光暈"
L["Disable sticky chat"] = "停用聊天頻道粘附"
L["Drag the frame overlay to position the frame."] = "拖曳框架的遮罩以定位此框架。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移動面板來定位框架。|n|n如果想要改變框架尺寸，你需選定面板，然後移動滑塊來選擇。|n|n你一旦進入戰鬥，這個框架會自動關閉。"
L["Drag to set the cursor X offset."] = "拖拉來設置鼠標水平偏移量。"
L["Drag to set the cursor Y offset."] = "拖拉來設置鼠標垂直偏移量。"
L["Drag to set the density of weather effects."] = "拖動來設定天氣效果的密度。"
L["Drag to set the font size of book text."] = "拖拉來設定書籍文字大小。"
L["Drag to set the font size of mail text."] = "拖動以設置郵件文字的字體大小。"
L["Drag to set the font size of quest text."] = "拖動以設置任務文字的字體大小。"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖洞已設置小地圖縮放比例。|n|n注意如果您使用預設動作列，重新縮放小地圖也會在啟動時重新縮放右側動作列，因此您可能希望將其保留為100％。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖動以設置Leatrix Plus面板的縮放比例。"
L["Drag to set the scale of the selected frame."] = "拖動以設置所選框架的縮放比例。"
L["Drag to set the size of the bottom border."] = "拖動以設置底部邊框的大小。"
L["Drag to set the size of the left border."] = "拖動以設置左側邊框的大小。"
L["Drag to set the size of the right border."] = "拖動以設置右側邊框的大小。"
L["Drag to set the size of the top border."] = "拖動以設置頂部邊框的大小。"
L["Drag to set the tooltip scale."] = "拖動以設置工具提示的縮放比例。"
L["Drag to set the transparency of the borders."] = "拖動以設置邊框的透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖動以設置Leatrix Plus面板的透明度。"
L["Dragonblight"] = "龍骨荒野"
L["Drak'Tharon Keep"] = "德拉克薩隆要塞"
L["Dun Morogh"] = "丹莫洛"
L["Dungeon"] = "地城"
L["Dungeons"] = "地城"
L["Dup ID"] = "重複的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Eastern"] = "東部王國"
L["Eastern Kingdoms"] = "東部王國"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾爾文森林"
L["Enable hotkey"] = "啟用熱鍵"
L["Enable viewport"] = "啟用視窗背景"
L["Enhance dressup"] = "增強試衣間"
L["Enhance professions"] = "增強專業"
L["Enhance quest log"] = "增強任務日誌"
L["Enhance trainers"] = "加強技能訓練"
L["Enhancements"] = "增強功能"
L["Enter"] = "進入"
L["enter music or movie name"] = "輸入音樂或動畫名稱"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "輸入您要查看的冷卻圖示的法術ID。|n|n如果想要寵物框架下正常出現冷卻圖示，請選中寵物複選框。|n|n冷卻圖示會依據您的職業保存。"
L["enter zone or track name"] = "輸入區域或曲目名稱"
L["Error messages will be hidden"] = "錯誤訊息將會隱藏"
L["Error messages will be shown"] = "錯誤訊息將會顯示"
L["Error Text"] = "錯誤文字"
L["Events"] = "事件"
L["Eversong Woods"] = "永歌森林"
L["Extras"] = "其他"
L["Eye of the Storm"] = "暴風之眼"
L["Fall of the Lich King"] = "巫妖王之殞"
L["False"] = "虛假"
L["Faster auto loot"] = "加速自動拾取"
L["Faster movie skip"] = "快速動畫跳過"
L["Features"] = "功能"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Find Item"] = "搜尋物品"
L["Forge of Souls"] = "眾魂熔爐"
L["Frames"] = "框架相關"
L["Game Options"] = "游戲設置"
L["Ghost"] = "靈魂狀態框架"
L["Ghostlands"] = "鬼魂之地"
L["Gloomy"] = "黑暗"
L["Gnomeregan"] = "諾姆瑞根"
L["Gold Only"] = "僅輸入金幣"
L["Graphics and Sound"] = "圖形和音效"
L["Grizzly Hills"] = "灰白之丘"
L["Groups"] = "隊伍"
L["Gruul's Lair"] = "戈魯爾之巢"
L["Gundrak"] = "剛德拉克"
L["Gundrak (rear entrance)"] = "剛德拉克（後方入口）"
L["H"] = "頭"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Reflection"] = "倒影大廳"
L["Halls of Stone"] = "石之大廳"
L["Halls of Valor"] = "英靈殿"
L["Haunted"] = "鬧鬼的"
L["Hellfire Citadel"] = "地獄火堡壘"
L["Hellfire Peninsula"] = "地獄火半島"
L["Hellfire Ramparts"] = "地獄火壁壘"
L["Helm"] = "頭盔"
L["Help"] = "幫助"
L["Hide chat buttons"] = "隱藏聊天視窗按鈕"
L["Hide cooldown duration numbers (if enabled)"] = "隱藏冷卻持續時間數字(如果啟用)"
L["Hide crafted names"] = "隱藏製造者名稱"
L["Hide error messages"] = "隱藏錯誤訊息"
L["Hide gryphons"] = "隱藏動作條獅鷲"
L["Hide level-up display"] = "隱藏升級提示"
L["Hide portrait numbers"] = "隱藏頭像數字"
L["Hide social button"] = "隱藏社交按鈕"
L["Hide stance bar"] = "隱藏姿態條"
L["Hide the clock"] = "隱藏時鐘"
L["Hide the combat log"] = "隱藏戰鬥記錄視窗"
L["Hide the zone text bar"] = "隱藏區域文字列"
L["Hide the zoom buttons"] = "隱藏縮放按紐"
L["Hide tooltips for world units during combat"] = "戰鬥中隱藏視窗"
L["Hide zone text"] = "隱藏區域文字"
L["High"] = "高"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Hinterlands"] = "辛特蘭"
L["Home"] = "首頁"
L["Howling Fjord"] = "凜風峽灣"
L["Hyjal Summit"] = "海加爾山之戰"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "勾選後，背包搜尋框會顯示在背包與銀行視窗上。"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾選後，一個按鈕會顯示在角色框架，其鼠標提示訊息會顯示身上的裝備耐久度。|n|n當你死後，你的整體耐久度也會顯示在聊天框架。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "勾選後，只要你還沒組隊、或是隊伍領隊或團隊助理，所有密語你設定好的關鍵字的人將會收到隊伍邀請。"
L["If checked, a master volume slider will be shown in the character sheet."] = "勾選後，主要聲道的調整滑桿將出現在角色視窗。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾選後，小地圖按鈕將可使用。|n|n點擊 - 切換選項面板。|n|nShift+左鍵點擊 - 切換音樂。|n|nCTRL+右鍵點擊 - 切換錯誤顯示(如果可用)。|n|nCTRL+SHIFT+左鍵點擊 - 切換Zygor(如果有安裝)。|n|nCTRL+SHIFT+右鍵點擊 - 切換視窗模式。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "勾選後，拍賣場將加入額外功能。|n|n僅限直購 - 在不填寫起始價格的情況下建立直購拍賣。|n|n僅限金幣 - 將銅和銀價格定在99，以加快新的拍賣。|n|n搜尋物品 - 在拍賣行搜尋您正在銷售的商品。|n|n除此以外，拍賣持續時間設置將保存為帳戶通用。"
L["If checked, alert frames will not be shown."] = "勾選後，警告框架將不會顯示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問商販時將自動出售背包中的垃圾。|n|n當你訪問時按住Shift鍵，可以暫時忽略該功能。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾選後，訊息視窗的邊框會更改為藍色（友方）或者紅色（敵方）。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾選後，戰網好友邀請會自動拒絕。|n|n啟用後，當前待處理的邀請會自動拒絕。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾選後，聊天視窗的按鈕會被隱藏。|n|n點擊視窗標簽會自動顯示最新的消息。|n|n使用鼠標滾輪可以查看歷史訊息。按住SHIFT進行訊息頁面跳轉，按住CTRL將滾動至訊息頁首/頁尾。"
L["If checked, chat text will not fade out after a time period."] = "勾選後，聊天訊息不會在一定時間後淡出。"
L["If checked, class coloring will be used in the player frame and target frame."] = "勾選後，玩家與目標框架將使用職業著色。"
L["If checked, class colors will be used in the chat frame."] = "勾選後，聊天框架將使用職業著色。"
L["If checked, class icons will be shown in the portrait frames."] = "勾選後，職業圖示會顯示在頭像框架。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾選後，當你選擇一個擲骰選項或是試圖出售或郵寄可交易物品將不再確認。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾選後，冷卻持續時間數字將不顯示在冷卻上。|n|n取消勾選後，冷卻持續時間數字將會顯示在冷卻上如果已在遊戲選項面板中啟用('動作條'選單)。"
L["If checked, crafted items will no longer show the name of the crafter."] = "勾選後，製造物品將不再顯示製造者名稱"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾選後，在玩家頭像和寵物頭像上的傷害及治療數字不再顯示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾選後，對鎖定的聊天視窗進行拖動，會使其豎直拉伸。|n|n對已解鎖的聊天視窗進行拖動，會使其移動。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾選後，對於非好友與公會成員的決鬥請求會被封鎖。"
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "勾選後，當您的角色在黑鐵酒吧休息時表情音效將靜音。|n|n其他所有時間都會啟用表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾選後，敵對姓名板會在戰鬥中自動開啟，離開戰鬥後關閉。"
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "勾選後，組隊邀請將只發送到好友以及公會成員。|n|n如未勾選，隊伍邀請將會發送到每個人。"
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "勾選後，公會名稱將會顯示。在您公會中的玩家也會顯示公會會階。"
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "勾選後，角色視窗會顯示頭盔與披風切換複選框。|n|n您可以按住Shift以及右鍵點擊複選框來切換布局。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾選後，大部分錯誤訊息將不顯示(像是'沒有足夠的怒氣')。部分重要錯誤將排除在外。|n|n如果你有啟用小地圖按鈕，你可以按下CTRL+右鍵來切換錯誤訊息的顯示而不管此設置。"
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "勾選後，裸體與外袍切換顯示按鈕將加入試衣視窗，並且模型旋轉控制鈕將被移除。"
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "勾選後，來自好友或公會成員的隊伍邀請會自動接受。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾選後，對於非好友與公會成員的組隊邀請會被封鎖。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "勾選後，任務將會自動化的選擇、接受以及回交。|n|n需求金錢的任務不會自動回交。|n|n您可以在與任務提供者交談時按下Shift鍵無視此設置。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾選後，團隊和副本聊天訊息會改為藍色（與小隊一致）。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "勾選後，只要復活你的玩家不在戰鬥中，復活請求將被自動接受。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾選後，位於增益框架與目標框架之下的增益圖標提示會顯示法術ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾選後，會停用聊天頻道的粘附。|n|n此選項不會影響臨時視窗的對話。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾選後，當你不處於戰鬥狀態時會自動接受召喚。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾選後，插件列表（游戲選單處）會顯示預設的對角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾選後，自動拾取所需的時間將大幅減少。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾選後，背包及銀行的整理按鈕不再顯示。"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "勾選後，BOSS的橫幅訊息不再顯示。|n|n該訊息通常在BOSS被擊敗後顯示。它顯示BOSS的名字以及掉落。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾選後，打開團隊訊息的按鈕會顯示在左側團隊管理框架的上方，而不是在其內部。|n|n此選項讓你無需打開團隊管理框架，就可以切換團隊框架。"
L["If checked, the clock will be hidden."] = "勾選後，時鐘將會隱藏。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾選後，戰鬥記錄會被隱藏。|n|n戰鬥記錄視窗必須未被分離時才能生效。|n|n如果戰鬥記錄視窗被分離了，你可以拖動其合併至主視窗（然後重載插件），或者在聊天設置中重置設置。"
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "勾選後，“對他人只顯示角色成就”的選項（介面-社交）會被永久勾選並鎖定。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾選後輸入框會被移動至聊天視窗上方。"
L["If checked, the game world will be resized to fit between the top and bottom borders.|n|nNote that if you enable this setting, the transparency slider will no longer affect the top and bottom borders."] = "勾選後，游戲介面的大小會修改以適應頂部和底部的邊框。|n|n當你啟用這個選項時，透明度的調節不再影響這兩個邊框。"
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "勾選後，你的保鏢對話時不再出現選項。|n|n對話時按住Shift鍵，可以暫時忽略該項設置。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾選後，死亡後的灰色螢幕以及靈魂世界特效將會停用。"
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "勾選後，升級提示不再顯示。|n|n升級提示功能包括副本目標、升級、小寵物獎勵等等。"
L["If checked, the main bar gryphons will not be shown."] = "勾選後，動作條兩邊的獅鷲不再顯示。"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "勾選後，背包的空餘格數會顯示在背包按鈕以及提示上。"
L["If checked, the per unit vendor price will be shown in item tooltips."] = "勾選後，物品提示中會顯示每單位的商店售價。"
L["If checked, the player frame background will be shown in class color."] = "勾選後，玩家框架背景將會顯示職業顏色。"
L["If checked, the professions frame will be larger."] = "勾選後，專業技能視窗將會放大。"
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "勾選後，任務日誌框架將會加大並配有世界地圖按鈕以及任務等級。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾選後，螢幕光暈將停用。|n|n啟用此選項同時也停用醉酒霧霾效果。"
L["If checked, the shaman class color will be changed from pink to blue."] = "勾選後，薩滿的職業顏色會從粉紅變為藍色。"
L["If checked, the skill trainer frame will be larger."] = "勾選後，專業技能訓練框架將會增大。"
L["If checked, the stance bar will not be shown."] = "勾選後，姿態條不再顯示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾選後，對話面板不再顯示。|n|n當NPC與你交流時，該框架通常出現在界面下方。"
L["If checked, the target frame background will be shown in class color."] = "勾選後，目標框架背景將會顯示職業顏色。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾選後，提示訊息會被著色，你可以設置他的佈局和大小尺寸。"
L["If checked, the vendor price will be shown in item tooltips."] = "勾選後，物品提示中將顯示商店售價。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾選後，區域文字列將隱藏。追蹤按鈕提示將顯示區域資訊。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾選後，縮放按鈕將隱藏。無論此設置如何，您都可以使用滑鼠滾輪進行縮放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾選後，目標的訊息視窗在戰鬥中會被隱藏。|n|n你可以按住SHIFT鍵暫時忽略這個設置。"
L["If checked, unit targets will be shown."] = "勾選後，目標的目標會顯示在訊息視窗上。"
L["If checked, Wowhead links will be shown above the quest log frame."] = "勾選後，任務日誌框架上方會顯示Wowhead連結。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "勾選後，您可以在打開對話視窗時按住alt鍵以自動選擇單獨的對話選項。如果對話選項類型是銀行，鳥點，訓練師或商店，無需按下alt鍵就會跳過對話。 您可以按住shift鍵以防止這種情況發生。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾選後，你可以在點擊聊天標籤時按下Ctrl鍵，在易於複製的視窗中查看最近的聊天。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾選後，你可以透過按下CTRL+Z來開啟Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾選後，你可以使用方向鍵移動聊天框中的輸入點。|n|n如果未被勾選，方向鍵將保持它所綁定的按鍵功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾選後，你可以取消動畫而不經確認。"
L["If checked, you will be able to change the font size of book text."] = "勾選後，您將可以更改書籍中文字的大小。"
L["If checked, you will be able to change the font size of quest text."] = "勾選後，您將可以改變任務文字的字體大小。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾選後，你可以更改郵件文字的字體大小。|n|n這個選項不會影響使用系統範本的郵件（例如拍賣行的收據訊息）。"
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Buffs frame|n- Widget top center frame|n- Timer bar"] = "勾選後，您將可以改變下列框架的位置與縮放比例：n|n- 玩家框架|n- 目標框架|n- 增益框架|n- 頂部中央組件框架|n- 計時條"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾選後，你會生成一個視窗背景，這個可以在游戲界面周圍增加黑色的邊框背景。|n|n邊框的層級是處於游戲界面和插件之間，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾選後，您將可以自定義小地圖。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾選後，你可以把聊天視窗拖動到屏幕邊緣。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾選後，你可以在目標框架上放置最多5個有用的冷卻圖標。"
L["If checked, you will be able to reposition the tooltip."] = "勾選後，您可以重新定位工具提示。"
L["If checked, you will be able to set the density of weather effects."] = "勾選後，您將可以設置天氣效果的密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾選後，會在玩家框架顯示稀有、精英或者稀有精英的邊框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾選後，你可以將鏡頭拉遠到更遠的距離。"
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "勾選後，您在戰場死亡時將會自動釋放。|n|n如果您具有自我復活的技能，則不會自動釋放。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾選後，當你打開商店、銀行或者郵箱時，背包不會自動開啟或者關閉。"
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "勾選後，當您的動作因為坐下或在坐騎上而被阻止時，您的角色將會自動站立或解除坐騎。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾選後，你的聊天歷史記錄會增漲至4096行。如果未被勾選，會保持在預設的128行。|n|n啟用這個設置可能會在登錄時會隱藏一些聊天訊息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問適用的商店時，裝備將自動修理。|n|n當你開啟商店時可以按下Shift鍵以無視此設置。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾選後，區域文字不再顯示。"
L["Increase chat history"] = "增加聊天歷史記錄"
L["Interface"] = "界面設置"
L["Invalid console variable."] = "無效控制台變量。"
L["Invalid parameter."] = "無效參數"
L["Invalid quest ID."] = "無效任務ID。"
L["Invalid sound ID"] = "無效聲音ID"
L["Invalid taint level."] = "無效的汙染等級。"
L["Invalid target."] = "無效的目標。"
L["Invite from whispers"] = "密語邀請"
L["Invite From Whispers"] = "從密語邀請"
L["Iron Docks"] = "鋼鐵碼頭"
L["Ironforge"] = "鐵爐堡"
L["Isle of Quel'Danas"] = "奎爾達納斯之島"
L["Kalimdor"] = "卡林多"
L["Karazhan"] = "卡拉贊"
L["Keyword"] = "關鍵字"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus將會在下次登出時覆寫LeaPlus數據庫。"
L["Left"] = "左側"
L["Lifetime honorable kills"] = "榮譽擊殺總數"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享鎖定"
L["Lower Blackrock Spire"] = "黑石塔下層"
L["Magic"] = "魔法"
L["Magisters' Terrace"] = "博學者殿堂"
L["Magtheridon's Lair"] = "瑪瑟里頓的巢穴"
L["Mail Text"] = "郵件文字"
L["Main Titles"] = "主標題"
L["Make shaman blue"] = "讓薩滿變藍色"
L["Manage frames"] = "管理框架面板"
L["Manage tooltip"] = "管理提示訊息"
L["Managed by Leatrix Plus"] = "由Leatrix Plus管理"
L["Mana-Tombs"] = "法力墓地"
L["Map"] = "地圖"
L["Maraudon"] = "瑪拉頓"
L["Maraudon: Earth Song Falls"] = "瑪拉頓：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "瑪拉頓：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "瑪拉頓：邪惡洞穴"
L["Max camera zoom"] = "最大鏡頭縮放"
L["Mechanics"] = "特性設置"
L["Media"] = "音樂"
L["Medium"] = "中"
L["Memory Usage"] = "記憶體占用"
L["Merge the tracking and calendar buttons"] = "整合追蹤與行事曆按紐"
L["message shown."] = "顯示訊息。"
L["messages shown."] = "顯示訊息。"
L["Minimap"] = "小地圖"
L["Missing console variable."] = "缺少控制台變量。"
L["Missing mount name."] = "缺少坐騎名稱。"
L["Missing movie ID."] = "缺少動畫ID。"
L["Missing quest ID."] = "缺少任務ID。"
L["Missing sound file parameter."] = "缺少聲音檔案參數。"
L["Missing sound ID."] = "缺少聲音ID。"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["Mount Hyjal"] = "海加爾山"
L["Mount not found."] = "坐騎未找到。"
L["Move editbox to top"] = "輸入框移動至頂部"
L["Movie not playable."] = "動畫不可播放。"
L["Movie number"] = "動畫編號"
L["Movies"] = "動畫"
L["Mulgore"] = "莫高雷"
L["Music"] = "音樂"
L["Music Rolls"] = "音樂曲單"
L["Musical Moments"] = "音樂時刻"
L["Mystery"] = "秘法"
L["Nagrand"] = "納葛蘭"
L["Narration"] = "解說"
L["Naxxramas"] = "納克薩瑪斯"
L["Netherstorm"] = "虛空風暴"
L["Nexus"] = "奧核之心"
L["No bad sound IDs found."] = "沒有發現損壞的聲音ID。"
L["No help is available for this page."] = "此頁面沒有幫助訊息。"
L["No items with durability equipped."] = "沒有裝備有耐久度的物品。"
L["No media duplicates found."] = "未找到重複的媒體檔。"
L["No tooltip showing."] = "目前沒有任何提示訊息。"
L["None"] = "無"
L["Northern Barrens"] = "北貧瘠之地"
L["Northern Stranglethorn"] = "北荊棘谷"
L["Northrend"] = "北裂境"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "警示！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Plus。"
L["Nude"] = "脫光"
L["Obsidian Sanctum"] = "黑曜聖所"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["or click the minimap button to open Leatrix Plus."] = "或是點擊小地圖按鈕來開啟Leatrix Maps。"
L["Orgrimmar"] = "奧格瑪"
L["Outland"] = "外域"
L["Overall"] = "整體"
L["Overlay"] = "覆蓋"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友組隊邀請"
L["Pet"] = "寵物"
L["Pit of Saron"] = "薩倫之淵"
L["Player"] = "玩家框架"
L["Player Chain"] = "玩家邊框"
L["Portal"] = "傳送門"
L["Power"] = "能量"
L["Press CTRL/C to copy."] = "按下CTRL/C來複製。"
L["Quest completed."] = "任務完成。"
L["Quest not completed."] = "任務未完成。"
L["Quest Text"] = "任務訊息文字"
L["Queue from friends"] = "好友佇列申請"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Raid frame toggle"] = "切換團隊框架"
L["Random"] = "隨機"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Recent chat window"] = "最近聊天視窗"
L["Redridge Mountains"] = "赤脊山"
L["Release in PvP"] = "PvP自動釋放屍體"
L["Reload"] = "重載插件"
L["Repair automatically"] = "自動修理裝備"
L["Repair Automatically"] = "自動修理"
L["Repair using guild funds if available"] = "修理使用公會資金(如果可用)"
L["Repaired for"] = "修理花費"
L["Reposition the tooltip"] = "重新定位工具提示"
L["Requires UI reload."] = "需要重載插件"
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "需要你與拉蕾娜．德羅姆互動，她可以在北裂境的達拉然的雕銘師禮拜堂中找到。"
L["Reset"] = "重置"
L["Resize book text"] = "書籍文字大小改變"
L["Resize mail text"] = "重設郵件文字"
L["Resize quest text"] = "重設任務文字"
L["Resize Screen"] = "螢幕縮放"
L["Resize the game world"] = "遊戲介面縮放"
L["Rested bubbles"] = "休息氣泡訊息"
L["Restrict to friends and guild members"] = "只限於好友與公會成員"
L["result"] = "結果"
L["results"] = "結果"
L["Right"] = "右側"
L["Right-click to close"] = "右鍵點擊來關閉"
L["Right-click to close."] = "右鍵點擊來關閉。"
L["right-click to go back"] = "右鍵點擊返回"
L["Ruby Sanctum"] = "晶紅聖所"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Sacred"] = "神聖"
L["Scale"] = "尺寸"
L["Scarlet Halls"] = "血色大廳"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Search"] = "搜尋"
L["Searing Gorge"] = "灼熱峽谷"
L["Select the settings that you want to use."] = "選擇你想啟用的設置。"
L["Selection of music tracks"] = "選擇的音樂曲目"
L["Self Markers Allowed"] = "允許自身標記"
L["Self Markers Blocked"] = "阻擋自身標記"
L["Sell junk automatically"] = "自動出售垃圾"
L["SELLING JUNK"] = "出售垃圾"
L["Serpentshrine Cavern"] = "毒蛇神殿洞穴"
L["Set weather density"] = "設置天氣效果密度"
L["Sethekk Halls"] = "塞司克大廳"
L["Settings"] = "設置"
L["Shaders"] = "陰影"
L["Shadow Labyrinth"] = "暗影迷宮"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Sholazar Basin"] = "休拉薩盆地"
L["Show auction controls"] = "顯示拍賣行控制"
L["Show bag search box"] = "顯示背包搜尋框"
L["Show character addons"] = "顯示角色插件"
L["Show cooldowns"] = "顯示冷卻"
L["Show durability status"] = "顯示耐久度"
L["Show free bag slots"] = "顯示背包空餘格數"
L["Show guild names"] = "顯示公會名稱"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show pet save button"] = "顯示寵物儲存按鈕"
L["Show player chain"] = "顯示玩家邊框"
L["Show player frame in class color"] = "玩家框架顯示職業顏色"
L["Show target frame in class color"] = "目標框架顯示職業顏色"
L["Show the spell ID in buff icon tooltips"] = "在增益圖標提示顯示法術ID"
L["Show unit targets"] = "顯示單位目標"
L["Show vanity controls"] = "顯示外觀控制鍵"
L["Show vendor price"] = "顯示商店售價"
L["Show volume slider"] = "顯示音量控制"
L["Show Wowhead links"] = "顯示Wowhead連結"
L["Shrine of the Storm"] = "風暴聖壇"
L["Silence rested emotes"] = "表情靜音"
L["Silithus"] = "希利蘇斯"
L["Silverpine Forest"] = "銀松森林"
L["Silvershard Mines"] = "碎銀礦坑"
L["Slave Pens"] = "奴隸監牢"
L["Social"] = "社交訊息"
L["Sold junk for"] = "賣出垃圾為"
L["Sound system restarted."] = "聲音系統已重啟。"
L["Southern Barrens"] = "南貧瘠之地"
L["Spell ID"] = "法術ID"
L["Spooky"] = "幽靈"
L["Stand and dismount"] = "站立與解除坐騎"
L["Steamvault"] = "蒸氣洞窟"
L["Stockade"] = "暴風城監獄"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stop"] = "停止"
L["Storm Peaks"] = "風暴群山"
L["Stormwind"] = "暴風城"
L["Strand of the Ancients"] = "遠祖灘頭"
L["Stranglethorn Vale"] = "荊棘谷"
L["Stratholme"] = "斯坦索姆"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字軍廣場"
L["Stratholme: The Gauntlet"] = "斯坦索姆：The Gauntlet"
L["Sunken Temple"] = "沉沒的神廟"
L["Sunwell Plateau"] = "太陽之井高地"
L["Support"] = "支援"
L["Swamp"] = "沼澤"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["System"] = "系統設置"
L["Tabard"] = "隱藏戰袍"
L["Taint level: Basic (1)."] = "汙染等級：基本(1)"
L["Taint level: Disabled (0)."] = "汙染等級：停用(0)"
L["Taint level: Full (2)."] = "汙染等級：完整(2)"
L["Tanaris"] = "塔納利斯"
L["Target"] = "目標框架"
L["Target Tracking Disabled"] = "停用目標追蹤"
L["Target Tracking Enabled"] = "啟用目標追蹤"
L["Teldrassil"] = "泰達希爾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Temple of Kotmogu"] = "科特魔古神廟"
L["Ten Years of Warcraft"] = "魔獸十周年"
L["Terokkar Forest"] = "泰洛卡森林"
L["Text"] = "文字訊息"
L["Text size"] = "字體尺寸"
L["Text Size"] = "字體尺寸"
L["The Arcatraz"] = "亞克崔茲"
L["The Black Morass"] = "黑色沼澤"
L["The Blood Furnace"] = "血熔爐"
L["The Botanica"] = "波塔尼卡"
L["The Burning Crusade"] = "燃燒的遠征"
L["The Culling of Stratholme"] = "斯坦索姆的抉擇"
L["The Deadmines"] = "死亡礦坑"
L["The Eye"] = "風暴要塞"
L["The Eye of Eternity"] = "永恆之眼"
L["The Forge of Souls"] = "眾魂熔爐"
L["The Frozen Halls"] = "冰封大廳"
L["The Halls of Reflection"] = "鏡像大廳"
L["The Mechanar"] = "麥克納爾"
L["The Nexus"] = "奧核之心"
L["The Obsidian Sanctum"] = "黑曜聖所"
L["The Oculus"] = "奧核之眼"
L["The Old Kingdom"] = "古王國"
L["The Pit of Saron"] = "薩隆陷坑"
L["The Ruby Sanctum"] = "晶紅聖所"
L["The Shattered Halls"] = "破碎大廳"
L["The Stockade"] = "監獄"
L["The Stonecore"] = "石岩之心"
L["The Violet Hold"] = "紫羅蘭堡"
L["The Waning Crescent"] = "弦月旅店"
L["Themes"] = "主題"
L["This panel will close automatically if you enter combat."] = "此面板將在你進入戰鬥後自動關閉。"
L["Thousand Needles"] = "千針石林"
L["Thunder Bluff"] = "雷霆崖"
L["Timer"] = "計時框架"
L["Tirisfal Glades"] = "提里斯法林地"
L["To begin, choose an options page."] = "請選擇一個選項開始使用"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "要使用此搜尋物品按鈕，您需要取消選擇WoW的代幣類別"
L["Tol Barad"] = "托巴拉德"
L["Tooltip"] = "提示訊息"
L["Tooltip title color"] = "鼠標提示訊息顏色。"
L["Top"] = "頂部"
L["Top Center"] = "頂級中心"
L["Tracing started."] = "追蹤已開始。"
L["Tracing stopped."] = "追蹤已停止。"
L["Transparency"] = "透明度"
L["Trial of Style"] = "造型選拔賽"
L["Trial of the Champion"] = "勇士試煉"
L["Trial of the Crusader"] = "十字軍試煉"
L["Trial of Valor"] = "勇氣試煉"
L["True"] = "真實"
L["Twin Peaks"] = "雙子峰"
L["Uldaman"] = "奧達曼"
L["Ulduar"] = "奧杜亞"
L["Unclamp chat frame"] = "不限制視窗位置"
L["Underbog"] = "幽暗沼澤"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛環形山"
L["Universal group color"] = "通用的隊伍著色"
L["Upper Blackrock Spire"] = "黑石塔上層"
L["Use arrow keys in chat"] = "允許使用方向鍵"
L["Use class colors in chat"] = "在聊天中使用職業著色"
L["Use easy resizing"] = "使用簡單拉伸"
L["Use Leatrix Plus to move that frame."] = "使用Leatrix Plues來移動框架"
L["Use Leatrix Plus to reset that frame."] = "使用Leatrix Plues來重置框架"
L["Utgarde Keep"] = "俄特加德要塞"
L["Value must be a number."] = "值必須為數字。"
L["Various"] = "雜項"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Vendors"] = "商店"
L["Version"] = "版本"
L["Very Low"] = "非常低"
L["Video"] = "影像"
L["Viewport"] = "視窗背景"
L["Violet Hold"] = "紫羅蘭堡"
L["Visibility"] = "可見性"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Wandering Isle"] = "漂流島"
L["Warsong Gulch"] = "戰歌峽谷"
L["was automatically declined."] = "已經自動拒絕。"
L["Weather density"] = "天氣密度"
L["Weather Density"] = "天氣密度"
L["Welcome to Leatrix Plus."] = "歡迎使用Leatrix Plus"
L["Well of Eternity"] = "永恆之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "濕地"
L["Widget"] = "窗口小部件"
L["Winter"] = "寒冬"
L["Wintergrasp"] = "冬握湖"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔獸世界"
L["Wrath of the Lich King"] = "巫妖王之怒"
L["Wyrmrest Temple"] = "龍眠神殿"
L["X Offset"] = "水平偏移"
L["Y Offset"] = "垂直偏移"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你無法在戰鬥中進行該項操作。"
L["You have"] = "你有"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要進行重載插件後才能使部分設置生效。|n|n你無需立即點擊重載插件按鈕，但是你完成設置並希望其生效時，必須點擊它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新載入。"
L["Zangarmarsh"] = "贊格沼澤"
L["Zones"] = "區域"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Drak"] = "祖爾德拉克"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"
L["Zygor addon not found."] = "你尚未安裝Zygor插件。"

end