--@non-debug@

local locales = {
	["enUS"] = 
{
	["Always display CD icons at full opacity (ReloadUI is needed)"] = "Always display CD icons at full opacity (ReloadUI is needed)",
	["chat:addon-is-disabled"] = "Addon is disabled",
	["chat:addon-is-disabled-note"] = "Please note: this addon is disabled. You can enable it in options dialog (/nc)",
	["chat:addon-is-enabled"] = "Addon is enabled",
	["chat:default-spell-is-added-to-ignore-list"] = "Default spell is added to ignore list: %s. You will not receive cooldown time updates for this spell.",
	["chat:enable-only-for-target-nameplate"] = "Cooldowns will be shown on target nameplate only",
	["chat:print-updated-spells"] = "%s: your cooldown: %s sec, new cooldown: %s sec",
	["Click on icon to enable/disable tracking"] = "Click on icon to enable/disable tracking",
	["Copy"] = "Copy",
	["Copy other profile to current profile:"] = "Copy other profile to current profile:",
	["Current profile: [%s]"] = "Current profile: [%s]",
	["Data from '%s' has been successfully copied to '%s'"] = "Data from '%s' has been successfully copied to '%s'",
	["Delete"] = "Delete",
	["Delete profile:"] = "Delete profile:",
	["Disable test mode"] = "Disable test mode",
	["Enable test mode (need at least one visible nameplate)"] = "Enable test mode (need at least one visible nameplate)",
	["Filters"] = "Filters",
	["filters.instance-types"] = [=[Set the visibility of the cooldowns
in different types of locations]=],
	["Font:"] = "Font:",
	["General"] = "General",
	["general.sort-mode"] = "Sort mode:",
	["Icon size"] = "Icon size",
	["Icon X-coord offset"] = "Icon X-coord offset",
	["Icon Y-coord offset"] = "Icon Y-coord offset",
	["instance-type:arena"] = "Arenas",
	["instance-type:none"] = "Open World",
	["instance-type:party"] = "5ppl dungeons",
	["instance-type:pvp"] = "Battlegrounds",
	["instance-type:raid"] = "Raid dungeons",
	["instance-type:scenario"] = "Scenarios",
	["instance-type:unknown"] = "Unknown dungeons (some quest scenarios)",
	["MISC"] = "Misc",
	["msg:question:import-existing-spells"] = [=[NameplateCooldowns
There are updated cooldowns for some of your spells. Do you want to apply update?]=],
	["New spell has been added: %s"] = "New spell has been added: %s",
	["Options are not available in combat!"] = "Options are not available in combat!",
	["options:category:spells"] = "Spells",
	["options:general:disable-addon-btn"] = "Disable addon",
	["options:general:enable-addon-btn"] = "Enable addon",
	["options:general:enable-only-for-target-nameplate"] = "Show the cooldowns on the current target nameplate only",
	["options:general:space-between-icons"] = "Space between icons (px)",
	["options:profiles:open-profiles-dialog"] = "Open profiles dialog",
	["options:spells:add-new-spell"] = "Add new spell (name or id):",
	["options:spells:add-spell"] = "Add spell",
	["options:spells:click-to-select-spell"] = "Click to select spell",
	["options:spells:cooldown-time"] = "Cooldown time",
	["options:spells:delete-all-spells"] = "Delete all spells",
	["options:spells:delete-all-spells-confirmation"] = "Do you really want to delete ALL spells?",
	["options:spells:delete-spell"] = "Delete spell",
	["options:spells:disable-all-spells"] = "Disable all spells",
	["options:spells:enable-all-spells"] = "Enable all spells",
	["options:spells:enable-tracking-of-this-spell"] = "Enable tracking of this spell",
	["options:spells:icon-glow"] = "Icon glow is disabled",
	["options:spells:icon-glow-always"] = "Icon will glow if spell is on cooldown",
	["options:spells:icon-glow-threshold"] = "Icon will glow if remaining time is less than",
	["options:spells:please-push-once-more"] = "Please push once more",
	["options:spells:track-only-this-spellid"] = [=[Track only these spell IDs
(comma-separated)]=],
	["Profile '%s' has been successfully deleted"] = "Profile '%s' has been successfully deleted",
	["Profiles"] = "Profiles",
	["Show border around interrupts"] = "Show border around interrupts",
	["Show border around trinkets"] = "Show border around trinkets",
	["Unknown spell: %s"] = "Unknown spell: %s",
	["Value must be a number"] = "Value must be a number",
	
	["none"] = "none",
	["trinkets, then interrupts, then other spells"] = "trinkets, then interrupts, then other spells",
	["interrupts, then trinkets, then other spells"] = "interrupts, then trinkets, then other spells",
	["trinkets, then other spells"] = "trinkets, then other spells",
	["interrupts, then other spells"] = "interrupts, then other spells",
	["NameplateCooldowns"] = "NameplateCooldowns",
	["Open config dialog"] = "Open config dialog"
},
	["zhCN"] = 
{
	["Always display CD icons at full opacity (ReloadUI is needed)"] = "总是以不透明的方式显示冷却图标（需要重载界面）",
	["chat:addon-is-disabled"] = "插件已停用",
	["chat:addon-is-disabled-note"] = "请注意: 这个插件已被停用，你可以在设置页面 (/nc) 中启用。",
	["chat:addon-is-enabled"] = "插件已启用",
	["chat:default-spell-is-added-to-ignore-list"] = "预设法术已加入忽略列表: %s，将不会显示这个法术的冷却时间。",
	["chat:enable-only-for-target-nameplate"] = "只在当前目标的血条上显示技能冷却",
	["chat:print-updated-spells"] = "%s: 你的冷却: %s 秒，新的冷却: %s 秒",
	["Click on icon to enable/disable tracking"] = "点击图标启用/禁用跟踪",
	["Copy"] = "复制",
	["Copy other profile to current profile:"] = "复制其他配置文件至当前配置文件：",
	["Current profile: [%s]"] = "当前配置文件：[%s]",
	["Data from '%s' has been successfully copied to '%s'"] = "从 '%s' 的数据已被成功复制到 '%s'",
	["Delete"] = "删除",
	["Delete profile:"] = "删除配置文件",
	["Disable test mode"] = "关闭测试模式",
	["Enable test mode (need at least one visible nameplate)"] = "启用测试模式（至少需要一个可见的姓名板）",
	["Filters"] = "过滤器",
	["filters.instance-types"] = "设置在不同地域下是否显示冷却",
	["Font:"] = "字体：",
	["General"] = "综合",
	["general.sort-mode"] = "排序方式:",
	["Icon size"] = "图标大小",
	["Icon X-coord offset"] = "图标的X坐标偏移",
	["Icon Y-coord offset"] = "图标的Y坐标偏移",
	["instance-type:arena"] = "竞技场",
	["instance-type:none"] = "野外",
	["instance-type:party"] = "5人地下城",
	["instance-type:pvp"] = "战场",
	["instance-type:raid"] = "团队副本",
	["instance-type:scenario"] = "场景战役",
	["instance-type:unknown"] = "未知地域(某些任务场景)",
	["MISC"] = "杂项",
	["msg:question:import-existing-spells"] = [=[NameplateCooldowns你的某些法术冷却已更新，是否要应用更新?]=],
	["New spell has been added: %s"] = "新的法术已添加：%s",
	["Options are not available in combat!"] = "选项在战斗中不可用！",
	["options:category:spells"] = "法术",
	["options:general:disable-addon-btn"] = "禁用插件",
	["options:general:enable-addon-btn"] = "启用插件",
	["options:general:enable-only-for-target-nameplate"] = "只在当前目标的姓名板上显示技能冷却",
	["options:general:space-between-icons"] = "图标间距(px)",
	["options:profiles:open-profiles-dialog"] = "打开配置文件窗口",
	["options:spells:add-new-spell"] = "添加新的法术 (名称或ID):",
	["options:spells:add-spell"] = "添加法术",
	["options:spells:click-to-select-spell"] = "点击以选择法术",
	["options:spells:cooldown-time"] = "冷却时间",
	["options:spells:delete-all-spells"] = "删除所有法术",
	["options:spells:delete-all-spells-confirmation"] = "确定要删除所有法术?",
	["options:spells:delete-spell"] = "删除法术",
	--[[Translation missing --]]
	["options:spells:disable-all-spells"] = "Disable all spells",
	--[[Translation missing --]]
	["options:spells:enable-all-spells"] = "Enable all spells",
	["options:spells:enable-tracking-of-this-spell"] = "开始追踪这个法术",
	["options:spells:icon-glow"] = "高亮图标已被禁用",
	["options:spells:icon-glow-always"] = "图标高亮，当法术冷却中",
	["options:spells:icon-glow-threshold"] = "图标高亮，当剩余时间小于",
	--[[Translation missing --]]
	["options:spells:please-push-once-more"] = "Please push once more",
	["options:spells:track-only-this-spellid"] = [=[只追踪这些法术ID(使用逗号分隔)]=],
	["Profile '%s' has been successfully deleted"] = "配置文件 '%s' 已成功删除",
	["Profiles"] = "配置文件",
	["Show border around interrupts"] = "为打断技能显示边框",
	["Show border around trinkets"] = "为饰品显示边框",
	["Unknown spell: %s"] = "未知的法术：%s",
	["Value must be a number"] = "值必须是数字"
},
	["zhTW"] = 
{
	["Always display CD icons at full opacity (ReloadUI is needed)"] = "圖示完全不透明 (需要重新載入介面)",
	["chat:addon-is-disabled"] = "插件已停用",
	["chat:addon-is-disabled-note"] = "請注意：這個插件已經停用，可以在設定選項 (/nc) 中啟用。",
	["chat:addon-is-enabled"] = "插件已啟用",
	["chat:default-spell-is-added-to-ignore-list"] = "預設法術已加入忽略清單: %s，將不會顯示這個法術的冷卻時間。",
	["chat:enable-only-for-target-nameplate"] = "只會在當前目標的血條上顯示技能冷卻",
	["chat:print-updated-spells"] = "%s: 你的冷卻: %s 秒，新的冷卻: %s 秒",
	["Click on icon to enable/disable tracking"] = "點一下圖示來啟用/停用監控",
	["Copy"] = "複製",
	["Copy other profile to current profile:"] = "複製現有的設定檔到目前設定檔:",
	["Current profile: [%s]"] = "目前設定檔: [%s]",
	["Data from '%s' has been successfully copied to '%s'"] = "已經成功地將資料從 '%s' 複製到 '%s'",
	["Delete"] = "刪除",
	["Delete profile:"] = "刪除設定檔:",
	["Disable test mode"] = "關閉測試模式",
	["Enable test mode (need at least one visible nameplate)"] = "開啟測試模式 (範圍內至少要能看見一個血條)",
	["Filters"] = "過濾方式",
	["filters.instance-types"] = [=[設定在不同類型的地方是否要顯示技能冷卻]=],
	["Font:"] = "字體:",
	["General"] = "一般",
	["general.sort-mode"] = "排列順序:",
	["Icon size"] = "圖示大小",
	["Icon X-coord offset"] = "圖示水平位置",
	["Icon Y-coord offset"] = "圖示垂直位置",
	["instance-type:arena"] = "競技場",
	["instance-type:none"] = "野外",
	["instance-type:party"] = "5 人地城",
	["instance-type:pvp"] = "戰場",
	["instance-type:raid"] = "團隊副本",
	["instance-type:scenario"] = "事件",
	["instance-type:unknown"] = "未知地城 (某些任務事件)",
	["MISC"] = "其他",
	["msg:question:import-existing-spells"] = [=[NameplateCooldowns你的某些法術冷卻已更新，是否要套用更新?]=],
	["New spell has been added: %s"] = "已加入新的法術：%s",
	["Options are not available in combat!"] = "戰鬥中無法調整設定!",
	["options:category:spells"] = "法術",
	["options:general:disable-addon-btn"] = "停用插件",
	["options:general:enable-addon-btn"] = "啟用插件",
	["options:general:enable-only-for-target-nameplate"] = "只在當前目標的血條上顯示技能冷卻",
	["options:general:space-between-icons"] = "圖示間距 (px)",
	["options:profiles:open-profiles-dialog"] = "開啟設定檔視窗",
	["options:spells:add-new-spell"] = "加入新的法術 (名稱或 ID):",
	["options:spells:add-spell"] = "新增法術",
	["options:spells:click-to-select-spell"] = "點一下選擇法術",
	["options:spells:cooldown-time"] = "冷卻時間",
	["options:spells:delete-all-spells"] = "刪除所有法術",
	["options:spells:delete-all-spells-confirmation"] = "是否確定要刪除所有法術?",
	["options:spells:delete-spell"] = "刪除法術",
	["options:spells:disable-all-spells"] = "停用所有法術",
	["options:spells:enable-all-spells"] = "啟用所有法術",
	["options:spells:enable-tracking-of-this-spell"] = "啟用追蹤這個法術",
	["options:spells:icon-glow"] = "圖示發光已停用",
	["options:spells:icon-glow-always"] = "圖示發光，當法術正在冷卻中",
	["options:spells:icon-glow-threshold"] = "圖示發光，當剩餘時間小於",
	["options:spells:please-push-once-more"] = "請再按一次",
	["options:spells:track-only-this-spellid"] = [=[只追蹤這些法術 ID(使用逗號分隔)]=],
	["Profile '%s' has been successfully deleted"] = "已經成功地刪除設定檔 '%s'",
	["Profiles"] = "設定檔",
	["Show border around interrupts"] = "斷法技能顯示邊框",
	["Show border around trinkets"] = "飾品圖示顯示邊框",
	["Unknown spell: %s"] = "未知的法術：%s",
	["Value must be a number"] = "必須填寫數字",
	
	["none"] = "無",
	["trinkets, then interrupts, then other spells"] = "飾品、斷法、其他法術",
	["interrupts, then trinkets, then other spells"] = "斷法、飾品、其他法術",
	["trinkets, then other spells"] = "飾品、其他法術",
	["interrupts, then other spells"] = "斷法、其他法術",
	["NameplateCooldowns"] = "PVP 血條技能監控",
	["Open config dialog"] = "開啟設定選項視窗"
},
};

--@end-non-debug@

local localizedClasses = {};
FillLocalizedClassList(localizedClasses);
for _, localeTable in pairs(locales) do
	for classToken, localizedClassName in pairs(localizedClasses) do
		localeTable[classToken] = localizedClassName;
	end
end

local _, addonTable = ...;
addonTable.L = locales[GetLocale()];
addonTable.L = setmetatable(addonTable.L, {
	__index = function(t, key)
		local enus = locales["enUS"][key];
		if (enus ~= nil) then
			return enus;
		else
			print("NameplateCooldowns: missing localisation: "..key);
			return key;
		end
	end
});
