﻿--[[	RealMobHealth Localization Module
	by SDPhantom
	https://www.wowinterface.com/forums/member.php?u=34145	]]
------------------------------------------------------------------

----------------------------------
--[[	Localization Table	]]
----------------------------------
local Localization={
	enUS={
--		Commands
		Command_NoUnitData="Unit not found.";
		Command_DeletedUnitFormat="Deleted %2$s(%1$s)";--	format(CreatureKey,UnitName)
		Command_HealthWiped="Health data wiped.";

--		Options Panel
		Options_DynamicList={--	Button Text,Tooltip Title,Description
--					Tooltip Title=false to use Button Text
			ShowStatusBarTextAdditions={"Show TargetFrame Text",false,"Creates text for TargetFrame's bars."};
			ModifyHealthBarText={"Modify UnitFrame Health",false,"Shows real health values for mobs in default UnitFrames."};
			ShowTooltipText={"Show Tooltip Feedback",false,"Displays if a mob's health is present in Health Cache."};
			ShowTooltipHealthText={"Show Tooltip Health",false,"Shows health on the GameTooltip's StatusBar"};
			ShowNamePlateHealthText={"Show NamePlate Health",false,"Shows health on the left side of NamePlates."};

			EnablePeerCache={"Enable","Enable Peer Cache","Toggles receiving health data from others.\n|cffffff00Note: This addon will still answer queries and broadcast health updates.|r"};
		};
		Options_SetByAddOn="|cffff0000This option has been overridden by another addon.|r";

--		Options Cache Panels
		Options_HealthCachePanel={"Health Cache","Stores health data from mobs encountered."};
		Options_PeerCachePanel={"Peer Cache","Stores health data reported by others."};
		Options_CacheSizeLabel="Cache Size:";

--		Options Clear Cache Buttons
		Options_ClearCacheButtonText="Clear Cache";
		Options_ClearHealthCacheTTText="Clear Health Cache";
		Options_ClearPeerCacheTTText="Clear Peer Cache";
		Options_ClearCacheWarning="|cffff0000Warning! All data in this cache will be lost forever.|r";

--		UITweaks Tooltip Lines
		UITweaksTooltip_Blacklisted="Blacklisted Mob";
		UITweaksTooltip_HealthRecorded="Recorded Health Data";
		UITweaksTooltip_HealthOverride="Health Data Overridden";
		UITweaksTooltip_NoData="Missing Health Data";
		
		Options_Name="RealMobHealth";

--		Numbers
		NumberGroupingScale=3;--	Controls scale of FIRST_NUMBER_CAP and SECOND_NUMBER_CAP
	};
	zhCN={--	Translation by HopeASD
		Command_NoUnitData="单位未找到";
		Command_DeletedUnitFormat="已删除 %2$s(%1$s)";--	format(CreatureKey,UnitName)
		Command_HealthWiped="清空生命值数据。";

--		Options Panel
		Options_DynamicList={--	Buttom Text, Tooltip Title, Description
--					Tooltip Title = false to use Button Text
			ShowStatusBarTextAdditions={"目标框体上显示数值",false,"在原生目标框体的条上创建数值文字。\n|cffffff00注意：这个选项的功能是将 esc > 界面选项 > 显示 > 状态数值 的设定应用到自己以外的头像框架上。|r"};
			ModifyHealthBarText={"调整单位框体生命值格式",false,"在原生单位框体上显示真实的生命值。\n|cffffff00注意：默认只支援暴雪原生框体。其他插件要由各插件作者自行添加对RealMobHealth的支持，方法可以查看APIDoc.txt。|r"};
			ShowTooltipText={"鼠标提示上显示反馈",false,"在鼠标提示上显示是否存在生命值数据。"};
			ShowTooltipHealthText={"鼠标提示上显示生命值",false,"在你的鼠标提示的状态条上显示生命值。"};
			ShowNamePlateHealthText={"姓名版上显示生命值",false,"在姓名版的左侧显示生命值。\n|cffffff00注意：默认只支援暴雪姓名板。其他插件要由作者自行添加对RealMobHealth的支持，方法可以查看APIDoc.txt。|r"};

			EnablePeerCache={"开启","开启共享缓存","开启这个选项将尝试从其他安装此插件的玩家处获取缓存。\n|cffffff00Note: 开启后，本插件将会不停的尝试询问和接受其他玩家的缓存数据。|r"};
		};
		Options_SetByAddOn="|cffff0000这个选项被其他来源给覆盖了。|r";

--		Options Cache Panels
		Options_HealthCachePanel={"生命值缓存","存储遇到的怪物的生命值数据。"};
		Options_PeerCachePanel={"共享缓存","存储其他人共享过来的生命值数据。"};
		Options_CacheSizeLabel="缓存大小：";

--		Options Clear Cache Buttons
		Options_ClearCacheButtonText="清除缓存";
		Options_ClearHealthCacheTTText="清除生命值缓存";
		Options_ClearPeerCacheTTText="清除共享缓存";
		Options_ClearCacheWarning="|cffff0000警告！所有的缓存数据将被永久清除。|r";

--		UITweaks Tooltip Lines
		UITweaksTooltip_Blacklisted="黑名单中的怪物";
		UITweaksTooltip_HealthRecorded="生命值数据 已记录";
		UITweaksTooltip_HealthOverride="生命值数据 被覆盖";
		UITweaksTooltip_NoData="生命值数据 不存在";

--		Numbers
		NumberGroupingScale=4;--	Controls scale of FIRST_NUMBER_CAP and SECOND_NUMBER_CAP
	};
	zhTW={
--		Commands
		Command_NoUnitData="無法找到單位。";
		Command_DeletedUnitFormat="已刪除 %2$s(%1$s)";--	format(CreatureKey,UnitName)
		Command_HealthWiped="已清空血量資料。";

--		Options Panel
		Options_DynamicList={--	Buttom Text, Tooltip Title, Description
--					Tooltip Title = false to use Button Text
			ShowStatusBarTextAdditions={"顯示目標框架文字",false,"在目標框架的血量條上建立文字。"};
			ModifyHealthBarText={"修改單位框架的血量",false,"在預設的單位框架上顯示怪物的實際血量。"};
			ShowTooltipText={"顯示滑鼠提示快取",false,"在滑鼠提示中顯示是否有怪物的血量快取。"};
			ShowTooltipHealthText={"顯示滑鼠提示血量",false,"在滑鼠提示的狀態列顯示怪物血量。"};
			ShowNamePlateHealthText={"顯示血條血量",false,"在遊戲內建血條的左側顯示血量。"};

			EnablePeerCache={"啟用","啟用其他人的快取","開啟或關閉接收來自其他玩家的血量資料。\n|cffffff00注意: 這個插件將會持續回應和廣播血量更新。|r"};
		};
		Options_SetByAddOn="|cffff0000這個選項已被另一個插件取代。|r";

--		Options Cache Panels
		Options_HealthCachePanel={"血量快取","儲存打過的怪的血量資料。"};
		Options_PeerCachePanel={"其他人的快取","儲存其他玩家回報的血量資料。"};
		Options_CacheSizeLabel="快取大小:";

--		Options Clear Cache Buttons
		Options_ClearCacheButtonText="清空快取";
		Options_ClearHealthCacheTTText="清空血量快取";
		Options_ClearPeerCacheTTText="清空其他人的快取";
		Options_ClearCacheWarning="|cffff0000警告! 此快取中的所有資料都會永久消失。|r";

--		UITweaks Tooltip Lines
		UITweaksTooltip_Blacklisted="已忽略怪物";
		UITweaksTooltip_HealthRecorded="已記錄血量";
		UITweaksTooltip_HealthOverride="已更新血量";
		UITweaksTooltip_NoData="尚無血量資料";
		
		Options_Name="戰鬥-血量";

--		Numbers
		NumberGroupingScale=4;--	Controls scale of FIRST_NUMBER_CAP and SECOND_NUMBER_CAP
	};
};

----------------------------------
--[[	Localization Loader	]]--	Nothing to localize below this line
----------------------------------
local LocalizationMeta={__index=Localization.enUS};
local DynamicOptionsMeta={__index=Localization.enUS.Options_DynamicList};
for locale,tbl in pairs(Localization) do if locale~="enUS" then
	setmetatable(tbl,LocalizationMeta);
	if rawget(tbl,"Options_DynamicList") then setmetatable(tbl.Options_DynamicList,DynamicOptionsMeta); end
end end
select(2,...).Localization=setmetatable(Localization,{__index=function(t,k) return t.enUS; end})[GetLocale()];
