local TOCNAME,Addon = ...
Addon.Options=Addon.Options or {}
local Options=Addon.Options

local function Options_CheckButtonRightClick(self,button)
	if button=="RightButton" then
		self:Lib_GPI_rclick()
	end
end

function Options.Init(doOk,doCancel,doDefault)
	Options.Prefix=TOCNAME.."O_"
	Options._DoOk=doOk
	Options._DoCancel=doCancel
	Options._DoDefault=doDefault

	
	Options.Panel={}
	Options.Frames={}
	Options.CBox={}
	Options.Btn={}
	Options.Edit={}
	Options.Vars={}
	Options.Index={}
	
	Options.Frames.count=0
	Options.Panel.count=0
	Options.scale=1
end
		
function Options:DoOk()
	for name,cbox in pairs(self.CBox) do
		self.Vars[name .. "_db"] [self.Vars[name]] = cbox:GetChecked()
	end
	for name,edit in pairs(self.Edit) do
		if self.Vars[name .. "_onlynumbers"] then 
			self.Vars[name .. "_db"] [self.Vars[name]] = edit:GetNumber()
		else
			if self.Vars[name.."_suggestion"] and self.Vars[name.."_suggestion"]~="" then
				if edit:GetText()==self.Vars[name.."_suggestion"] then
					self.Vars[name .. "_db"] [self.Vars[name]] = ""
				else
					self.Vars[name .. "_db"] [self.Vars[name]] = edit:GetText()
				end
			else
				self.Vars[name .. "_db"] [self.Vars[name]] = edit:GetText()
			end
		end
	end
end
	
function Options:DoCancel()
	for name,cbox in pairs(self.CBox) do
		cbox:SetChecked( self.Vars[name .. "_db"] [self.Vars[name]] )
	end
	for name,edit in pairs(self.Edit) do
		if self.Vars[name .. "_onlynumbers"] then 
			edit:SetNumber( self.Vars[name .. "_db"] [self.Vars[name]] )
		else
			edit:SetText( self.Vars[name .. "_db"] [self.Vars[name]] )
			self.__EditBoxLostFocus(edit)
		end		
	end
end
	
function Options:DoDefault()
	for name,cbox in pairs(self.CBox) do
		self.Vars[name .. "_db"] [self.Vars[name]]= self.Vars[name .. "_init"]
	end
	for name,edit in pairs(self.Edit) do
		self.Vars[name .. "_db"] [self.Vars[name]]= self.Vars[name .. "_init"]
	end
	self:DoCancel()
end
	
function Options:SetScale(x)
	self.scale=x
end
	
function Options:AddPanel(Title,noheader,scrollable)
	local c=self.Panel.count +1
	local FrameName=self.Prefix.."OptionFrame"..c
	
	self.Panel.count=c
	
	
	self.Panel[c] = CreateFrame( "Frame",FrameName , UIParent )
	self.Panel[c].name = Title
	if c==1 then 
		self.Panel[c].okay = self._DoOk
		self.Panel[c].cancel = self._DoCancel
		self.Panel[c].refresh = self._DoCancel
		self.Panel[c].default = self._DoDefault
	else
		self.Panel[c].parent = self.Panel[1].name
	end
	
	InterfaceOptions_AddCategory(self.Panel[c])
	self.CurrentPanel=self.Panel[c]		
	
	if scrollable then
		
		self.Panel["scroll"..c]=CreateFrame("ScrollFrame", FrameName.."Scroll", self.CurrentPanel,"UIPanelScrollFrameTemplate")
		self.Panel["scroll"..c]:SetPoint("TOPLEFT",0, -10) 
		self.Panel["scroll"..c]:SetPoint("BOTTOMRIGHT", -30, 10) 
		self.Panel["scrollChild"..c] = CreateFrame("Frame",FrameName.."ScrollChild") 
		self.Panel["scroll"..c]:SetScrollChild(self.Panel["scrollChild"..c])
		
		self.Panel["scrollChild"..c]:SetSize(100,100)
		self.CurrentPanel=self.Panel["scrollChild"..c]
	end
	
	
	self.Frames["title_"..c] = self.CurrentPanel:CreateFontString(FrameName.."_Title", "OVERLAY", "GameFontNormalLarge")
	if noheader==true then
		self.Frames["title_"..c]:SetHeight(1)
	else
		self.Frames["title_"..c]:SetText(Title)
	end
	self.Frames["title_"..c]:SetPoint("TOPLEFT", 10, -10)
	self.Frames["title_"..c]:SetScale(self.scale)
	
	self.NextRelativ=FrameName.."_Title"
	self.NextRelativX=25
	self.NextRelativY=0
	
	return self.Panel[c]
end
	
function Options:Indent(width)
	if width==nil then width=10 end
	self.NextRelativX = self.NextRelativX + width
end
	
function Options:InLine()
	self.inLine=true
	self.LineRelativ=nil
end

function Options:EndInLine()
	self.inLine=false
	self.LineRelativ=nil
end	
	
function Options:SetRightSide(w)
	self.NextRelativ=self.Prefix.."OptionFrame".. self.Panel.count .."_Title"
	self.NextRelativX=310 / self.scale
	self.NextRelativY=0
end
	
function Options:AddVersion(version)
	local i="version_"..self.Panel.count
	self.Frames[i] = self.CurrentPanel:CreateFontString(nil, "OVERLAY", "GameFontNormal")
	self.Frames[i]:SetText(version)
	self.Frames[i]:SetPoint("BOTTOMRIGHT", -10, 10)
	self.Frames[i]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	return self.Frames[i]
end
	
function Options:AddCategory(Text)
	local c=self.Frames.count+1
	self.Frames.count=c		
	CatName=self.Prefix .. "Cat" .. c
	self.Frames[CatName] = self.CurrentPanel:CreateFontString(CatName, "OVERLAY", "GameFontNormal")
	self.Frames[CatName]:SetText('|cffffffff' .. Text .. '|r')
	self.Frames[CatName]:SetPoint("TOPLEFT",self.NextRelativ,"BOTTOMLEFT", self.NextRelativX, self.NextRelativY-10)
	self.Frames[CatName]:SetFontObject("GameFontNormalLarge")
	self.Frames[CatName]:SetScale(self.scale)
	self.NextRelativ=CatName
	self.NextRelativX=0
	self.NextRelativY=0
	return self.Frames[CatName]
end
	
function Options:AddButton(Text,func)
	local c=self.Frames.count+1
	self.Frames.count=c	
	local ButtonName=self.Prefix .."BUTTON_"..c
			
	self.Btn[ButtonName] = CreateFrame("Button", ButtonName, self.CurrentPanel, "UIPanelButtonTemplate")
	self.Btn[ButtonName]:ClearAllPoints()
	
	if self.inLine~=true or self.LineRelativ ==nil then
		self.Btn[ButtonName]:SetPoint("TOPLEFT", self.NextRelativ,"BOTTOMLEFT", self.NextRelativX, self.NextRelativY)
		self.NextRelativ=ButtonName
		self.LineRelativ=ButtonName
		self.NextRelativX=0
		self.NextRelativY=0
	else
		self.Btn[ButtonName]:SetPoint("TOP", self.LineRelativ,"TOP", 0, 0)
		self.Btn[ButtonName]:SetPoint("LEFT", self.LineRelativ.."Text","RIGHT", 10, 0)
		self.LineRelativ=ButtonName
	end
	
	self.Btn[ButtonName]:SetScale(self.scale)
	self.Btn[ButtonName]:SetScript("OnClick", func)
	self.Btn[ButtonName]:SetText(Text)
	self.Btn[ButtonName]:SetWidth( self.Btn[ButtonName]:GetTextWidth()+10 )
	return self.Btn[ButtonName]
end

local function CheckBox_OnRightClick(self,func)
	self.Lib_GPI_rclick=func
	self:SetScript("OnMouseDown",Options_CheckButtonRightClick)
end	

function Options:AddCheckBox(DB,Var,Init,Text,width)
	local c=self.Frames.count+1
	self.Frames.count=c	
	local ButtonName=self.Prefix .."CBOX_"..c.. Var
	
	if Init==nil then
		Init=false
	end
	
	self.Index[c]=ButtonName
	
	
	self.Vars[ButtonName]=Var
	self.Vars[ButtonName.."_init"]=Init
	self.Vars[ButtonName.."_db"]=DB
	
	if DB[Var] == nil then DB[Var]=Init end
	
	self.CBox[ButtonName] = CreateFrame("CheckButton", ButtonName, self.CurrentPanel, "ChatConfigCheckButtonTemplate")
	_G[ButtonName .. "Text"]:SetText(Text)
	if width then
		_G[ButtonName .. "Text"]:SetWidth(width)
		_G[ButtonName .. "Text"]:SetNonSpaceWrap(false)
		_G[ButtonName .. "Text"]:SetMaxLines(1)
		self.CBox[ButtonName]:SetHitRectInsets(0, -width, 0,0)
	else
		self.CBox[ButtonName]:SetHitRectInsets(0, -_G[ButtonName.."Text"]:GetStringWidth()-2, 0,0)
	end
	
	self.CBox[ButtonName]:ClearAllPoints()
	
	if self.inLine~=true or self.LineRelativ ==nil then
		self.CBox[ButtonName]:SetPoint("TOPLEFT", self.NextRelativ,"BOTTOMLEFT", self.NextRelativX, self.NextRelativY)
		self.NextRelativ=ButtonName
		self.LineRelativ=ButtonName
		self.NextRelativX=0
		self.NextRelativY=0
	else
		self.CBox[ButtonName]:SetPoint("TOP", self.LineRelativ,"TOP", 0, 0)
		self.CBox[ButtonName]:SetPoint("LEFT", self.LineRelativ.."Text","RIGHT", 10, 0)			
		self.LineRelativ=ButtonName
	end
	
	self.CBox[ButtonName]:SetScale(self.scale)
	self.CBox[ButtonName]:SetChecked(DB[Var])
	
	self.CBox[ButtonName].OnRightClick=CheckBox_OnRightClick
	
	return self.CBox[ButtonName]
end
	
function Options:AddText(TXT,width,centre)
	local textbox
			
	textbox= self.CurrentPanel:CreateFontString(CatName, "OVERLAY", "GameFontNormal")
	textbox:SetText(TXT)
	textbox:SetPoint("TOPLEFT",self.NextRelativ,"BOTTOMLEFT", self.NextRelativX, self.NextRelativY-2)
	textbox:SetScale(self.scale)
	if width==nil or width==0 then 
		textbox:SetWidth(textbox:GetStringWidth())
	elseif width<0 then
		textbox:SetPoint("RIGHT",width,0)
		if not centre then 
			textbox:SetJustifyH("LEFT")
			textbox:SetJustifyV("TOP")
		end
	else
		textbox:SetWidth(width)
		if not centre then 
			textbox:SetJustifyH("LEFT")
			textbox:SetJustifyV("TOP")
		end
	end
	self.NextRelativ=textbox
	self.NextRelativX=0
	self.NextRelativY=0
	return textbox
end

function Options:__EditBoxTooltipShow()
	local name=self:GetName().."_tooltip"
	if self.GPI_Options and self.GPI_Options.Vars and self.GPI_Options.Vars[name] then 
		GameTooltip:SetOwner(self, "ANCHOR_BOTTOM", 0,0	)
		GameTooltip:SetMinimumWidth(self:GetWidth())
		GameTooltip:ClearLines()
		GameTooltip:AddLine(self.GPI_Options.Vars[name],0.9,0.9,0.9,true)
		GameTooltip:Show()
	end		
end

function Options:__EditBoxTooltipHide()
	GameTooltip:Hide()
end

function Options:__EditBoxGetFocus()
	local name=self:GetName().."_suggestion"
	if self.GPI_Options and self.GPI_Options.Vars and self.GPI_Options.Vars[name] then 
		if self:GetText()==self.GPI_Options.Vars[name] then
			self:SetText("")
			self:SetTextColor(1,1,1)				
		end
	end	
end

function Options:__EditBoxLostFocus()
	local name=self:GetName().."_suggestion"
	if self.GPI_Options and self.GPI_Options.Vars and self.GPI_Options.Vars[name] then 
		if self:GetText()=="" then
			self:SetTextColor(0.6,0.6,0.6)
			self:SetText(self.GPI_Options.Vars[name])
			self:HighlightText(0,0) 
			self:SetCursorPosition(0)
		end
	end	
end

function Options:__EditBoxOnEnterPressed()
	self:ClearFocus()
end


function Options:AddEditBox(DB,Var,Init,TXTLeft,width,widthLeft,onlynumbers,tooltip,suggestion)
	if width==nil then width=200 end
	local c=self.Frames.count+1
	self.Frames.count=c	

	local ButtonName= self.Prefix .."Edit_"..c.. Var
	local CatName = ButtonName.."_Text"
			
	self.Frames[CatName] = self.CurrentPanel:CreateFontString(CatName, "OVERLAY", "GameFontNormal")
	self.Frames[CatName]:SetText('|cffffffff' .. TXTLeft .. '|r')
	self.Frames[CatName]:SetPoint("TOPLEFT",self.NextRelativ,"BOTTOMLEFT", self.NextRelativX, self.NextRelativY-2)
	self.Frames[CatName]:SetScale(self.scale)
	if widthLeft==nil or widthLeft==0 then 
		self.Frames[CatName]:SetWidth(self.Frames[CatName]:GetStringWidth())
	else
		self.Frames[CatName]:SetWidth(widthLeft)
		self.Frames[CatName]:SetJustifyH("LEFT")
		self.Frames[CatName]:SetJustifyV("TOP")
	end
	
	
	
	self.Vars[ButtonName]=Var
	self.Vars[ButtonName.."_db"]=DB
	self.Vars[ButtonName.."_init"]=Init
	self.Vars[ButtonName.."_onlynumbers"]=onlynumbers
	
	
	if DB[Var] == nil then DB[Var]=Init end

	self.Edit[ButtonName] = CreateFrame("EditBox", ButtonName, self.CurrentPanel, "InputBoxTemplate")
	self.Edit[ButtonName]:SetPoint("TOPLEFT", self.Frames[CatName],"TOPRIGHT",5 ,5)
	self.Edit[ButtonName]:SetScale(self.scale)
	self.Edit[ButtonName]:SetWidth(width)
	self.Edit[ButtonName]:SetHeight(20)
	
	self.Edit[ButtonName]:SetScript("OnEnterPressed",self.__EditBoxOnEnterPressed)
	
	self.Edit[ButtonName].GPI_Options=self
			
	if onlynumbers then
		self.Edit[ButtonName]:SetNumeric(true)
		self.Edit[ButtonName]:SetNumber(DB[Var])
	else
		self.Edit[ButtonName]:SetText(DB[Var])
	end
	
	self.Edit[ButtonName]:SetCursorPosition(0)
	self.Edit[ButtonName]:HighlightText(0,0) 
	self.Edit[ButtonName]:SetAutoFocus(false)
	self.Edit[ButtonName]:ClearFocus() 
	if tooltip and tooltip~="" then 
		self.Edit[ButtonName]:SetScript("OnEnter",self.__EditBoxTooltipShow)
		self.Edit[ButtonName]:SetScript("onLeave",self.__EditBoxTooltipHide)
		self.Vars[ButtonName.."_tooltip"]=tooltip
	end
	
	if suggestion and suggestion~="" then 
		self.Edit[ButtonName]:SetScript("OnEditFocusGained",self.__EditBoxGetFocus)
		self.Edit[ButtonName]:SetScript("OnEditFocusLost",self.__EditBoxLostFocus)
		self.Vars[ButtonName.."_suggestion"]=suggestion			
	end
	
	self.Frames[CatName]:SetHeight(self.Edit[ButtonName]:GetHeight()-10)
	
	self.NextRelativ=CatName
	self.NextRelativX=0
	self.NextRelativY=-10
	
	return self.Edit[ButtonName]
end

function Options:AddSpace()
	self.NextRelativY=self.NextRelativY-20
end

function Options:Open(panel)
	if panel==nil or panel > self.Panel.count then panel = 1 end
	InterfaceOptionsFrame_OpenToCategory(self.Panel[self.Panel.count])
	InterfaceOptionsFrame_OpenToCategory(self.Panel[self.Panel.count])
	InterfaceOptionsFrame_OpenToCategory(self.Panel[panel])
end

