local RTC_TOCNAME,RTC = ...

-- Basic localizations
function RTC.GetLocale()
	local ColRed="|cffff4040"

	local locales = {
		zhCN = {
			["MsgRollCleared"] = "所有骰子已被清除。",
			["MsgNbRolls"] = "%d个骰子",
		},
		zhTW = {
			["MsgNbRolls"] = "共計 %d 個人擲骰",
			["MsgRollCleared"] = "所有擲骰記錄都已清空。",
			["MsgUndoRoll"]="還原所有擲骰。",
			["MsgAnnounce"] = "%s 贏了! 骰 %d。",
			["MsgAnnounceTie"] = "再來是 %s 贏了! 骰 %d。",
			["MsgNotRolled"]="下列玩家仍需擲骰，或說 '%s'",
			["MsgCheat"]="忽略 %s 骰的 %s (%s-%s)。",  -- (player, roll, max_roll, min_roll)
			["MsgStart"]="現在開始新的擲骰! 請輸入 '/rnd' 或 '%s'",
			["MsgStartGreenAndNeed"]="現在開始新的擲骰! 需求請輸入 '/rnd'，貪婪請輸入 '/rnd 1-50' 或 '%s'",
			["MsgNextItem"]="%s 要的骰",
			["MsgTooltip"]=ColRed.."左鍵:|r 打開骰子記錄|n"..ColRed.."Shift+左鍵:|r 打開 '拾取記錄'|n"..ColRed.."右鍵:|r 設定選項",
			["MsgBar"]="==============================",
			["MsgLocalRestart"]="需要重新載入介面 (/reload) 設定才會生效",
			["MsgNbLoots"]="%d 個已儲存的拾取物品。",
			["MsgLootLine"]="%s: %s 獲得物品: %s", -- date, name, item
			["MsgLootCleared"] = "所有已儲存的拾取物品都已清空。",
			["MsgUndoLoot"]="還原所有拾取物品。",
			["MsgLTnotenabled"]="尚未啟用拾取追蹤。",
			["MsgRaidRoll"] = "%s 贏了! (%d)",

			["TxtGreed"]="貪婪",
			["TxtNeed"]="需求",
			["TxtLine"]="------------------------------------------------------------------------------------------------------",
			["pass"] = "pass",		
			["BtnClear"]="清空",
			["BtnUndo"]="還原",
			["BtnNotRolled"]="沒骰",
			["BtnRoll"]="擲骰",
			["BtnAnnounce"]="公佈",
			["BtnGreed"]="貪婪",
			["BtnPass"]="跳過",
			
			["BtnOpen"]="打開",
			["BtnConfig"]="設定",
			["BtnLootRolls"]="拾取記錄",
			["BtnOpenLoot"]="拾取追蹤",
			["BtnCSVExport"]="匯出 CSV",
			["BtnCancel"]="取消",
			["BtnRaidRoll"]="團隊擲骰",
			
			["EdtWhiteList"]="白名單物品 ID",
			["EdtNbLoots"]="拾取物品最多儲存數量",
			["EdtCSVexport"]="CSV-Export-Format",
			
			["TxtCSVJokers"]="%% %name% %class% %timestamp% %dd% %mm% %yy% %HH% %MM% %SS%",
			["TxtCSVJokers2"]="%iname% %irarity% %iraritytxt% %ilevel% %iid% %iprice% %icount% %itype% %itypetxt%",
			["TxtCSVJokersTitle"]="匯出 CSV 時可以使用這些文字標籤:",
			["TxtItemType"]="注意! 物品類型和稀有度是各自獨立分開的!",
			
			["TabRoll"]="骰子",
			["TabLoot"]="物品",
			["TabCSV"]="CSV",
			
			["PanelLootTracker"]="拾取追蹤",
			["HeaderRarity"]="追蹤稀有度",
			["HeaderItemType"]="追蹤物品類型",
						
			["HeaderSettings"]="設定",
			["HeaderCustomLocales"]="自訂文字",
			["HeaderCSV"]="匯出 CSV",
			["PanelAbout"]="關於",
			["HeaderSlashCommand"]="指令",
			["HeaderCredits"]="感謝",
			["HeaderInfo"]="資訊",
			["HeaderUsage"]="用法",

			["Cboxshowminimapbutton"]="顯示小地圖按鈕",
			["CboxLockMinimapButton"]="鎖定小地圖按鈕位置",		
			["CboxLockMinimapButtonDistance"]="最小化小地圖按鈕距離",
			["CboxCloseOnClear"]="[清空] 後關閉視窗",
			["CboxClearOnAnnounce"]="[公佈] 後清空擲骰記錄",
			["CboxCloseOnAnnounce"]="[公佈] 後關閉視窗",
			["CboxClearOnClose"]="[關閉] 後清空擲骰記錄",
			["CboxIgnoreDouble"]="忽略重複骰的",
			["CboxRejectOutBounds"]="拒絕骰子範圍不是 (1-100) 的",
			["CboxAnnounceIgnoreDouble"]="只有 [公佈] 時: 忽略重複骰的",
			["CboxAnnounceRejectOutBounds"]="只有 [公佈] 時: 拒絕骰子範圍不是 (1-100) 的",
			["CboxNeedAndGreed"]="使用需求 '/rnd' 和貪婪 '/rnd 1-50' 系統，其他方式一概忽略",
			["CboxShowNotRolled"]="顯示 [沒骰] 按鈕",
			["CboxAutoLootRolls"]="自動打開 '拾取記錄'",
			["CboxAutoCloseLootRolls"]="所有人都骰過後自動關閉 '拾取記錄'",
			["CboxClearOnStart"]="有人開始新的擲骰時清空",
			["CboxOpenOnStart"]="有人開始新的擲骰時打開",
			["CboxColorName"]="名字顯示職業顏色",
			["CboxShowClassIcon"]="顯示職業圖示",
			["CboxOnDebug"]="顯示除錯資訊",
			
			["CboxLTShortMessage"]="簡短訊息",
			["CboxLTTrackSolo"]="追蹤單人",
			["CboxLTTrackGroup"]="追蹤隊伍",
			["CboxLTTrackSRaid"]="追蹤小於 10 人的團隊",
			["CboxLTTrackBRaid"]="追蹤大於 11 人的團隊",
			["CboxLTEnable"]="啟用拾取追蹤",
			["CboxLTSmallFont"]="文字較小",
			["CboxLTShowIcon"]="顯示物品圖示",
			
			["SlashClearRolls"]="清空骰子",
			["SlashClearLoot"]="清空拾取",
			["SlashClearLootRolls"]="清空 '拾取記錄'",
			["SlashUndoRolls"]="恢復上次骰子",
			["SlashUndoLoot"]="恢復上次拾取",
			["SlashAnnounce"]="公佈最後一輪骰的獲勝者",
			["SlashNotRolled"]="提醒所有未骰的人",
			["SlashClose"]="關閉主視窗",
			["SlashReset"]="重置主視窗的位置",
			["SlashConfig"]="打開設定選項",
			["SlashAbout"]="打開關於",
			["SlashStart"]="宣布開始新的一輪擲骰, <value> 可以是空的或物品連結",
			["SlashOpen"]="打開主視窗",
			["SlashRaidRoll"]="骰一個玩家名字",
			["SlashRaidRollList"]="輸出所有玩家",
			
			["AboutInfo"]="Have you ever tried to roll the 'Onyxia Hide Backpack' in a raid? RTC collects all roll results and sorts them. Ever thought about whether you wanted something for your second-equip, but didn't know if somebody needed it? RTC can automatically open the Blizzard 'Loot rolls' window, where you can see immediately who needs or has greed.|nIn raid ever lost the overview, who got what? Again, RTC can help you. On request, it records all items, including a variable export function.",
			
			["AboutSlashCommand"]="<value> 可以是 true, 1, enable, false, 0, disable。省略 <value> 時會切換目前的狀態開/關。",
			
			["AboutUsage"]="RTC will automatically open when someone rolls the dice. Double rolls or rolls outside the default range are ignored on request.|nBy default, the automatic opening of 'Loot Rolls' is disabled. Likewise, the 'Loot Tracker' must be turned on manually.",
			
			["AboutCredits"]="Russian translation by tierggg and Hubbotu|nBaudzilla for the graphics/idea of the resize-code|nRollTracker Classic is an updated version of 'RollTracker Lite', originally by Jerry Chong - zanglang@gmail.com.",

			["RollTracker Classic"]="骰子記錄",
			["RollTracker"]="副本-骰子記錄",
		},
	}
	

	
	
	local DefaultEnGB = {
			["MsgNbRolls"] = "%d Roll(s)",
			["MsgRollCleared"] = "All rolls have been cleared.",
			["MsgUndoRoll"]="Undo all rolls.",
			["MsgAnnounce"] = "%s won with a roll of %d.",
			["MsgAnnounceTie"] = "Tie, %s won with a roll of %d.",
			["MsgNotRolled"]="The following people still need to roll or say '%s'",
			["MsgCheat"]="Ignoring %s's roll of %s (%s-%s).",  -- (player, roll, max_roll, min_roll)
			["MsgStart"]="New roll starting now! Type '/rnd' or '%s'",
			["MsgStartGreenAndNeed"]="New roll starting now! Type '/rnd' for need, '/rnd 1-50' for greed or '%s'",
			["MsgNextItem"]="Next item: %s",
			["MsgTooltip"]=ColRed.."Left click|r to open RTC |n"..ColRed.."Shift+Left click|r to open 'Loot Rolls'|n"..ColRed.."Right click|r to open options",
			["MsgBar"]="==============================",
			["MsgLocalRestart"]="The setting is not transferred until after a restart (/reload)",
			["MsgNbLoots"]="%d stored loot(s).",
			["MsgLootLine"]="%s: %s receives loot: %s", -- date, name, item
			["MsgLootCleared"] = "All stored loots have been cleared.",
			["MsgUndoLoot"]="Undo all loots.",
			["MsgLTnotenabled"]="Loot Tracker is not enabled.",
			["MsgRaidRoll"] = "%s won. (%d)",
						
			["TxtGreed"]="Greed",
			["TxtNeed"]="Need",
			["TxtLine"]="------------------------------------------------------------------------------------------------------",
			["pass"] = "pass",		
			
			["BtnClear"]="Clear",
			["BtnUndo"]="Undo",
			["BtnNotRolled"]="Not rolled",
			["BtnRoll"]="Roll",
			["BtnAnnounce"]="Announce",
			["BtnGreed"]="Greed",
			["BtnPass"]="Pass",			
			["BtnOpen"]="Open",
			["BtnConfig"]="Settings",
			["BtnLootRolls"]="Loot Rolls",
			["BtnOpenLoot"]="Loot Tracker",
			["BtnCSVExport"]="CSV Export",
			["BtnCancel"]="Cancel",
			["BtnRaidRoll"]="Raid Roll",
			
			["EdtWhiteList"]="Whitelist ItemIds",
			["EdtNbLoots"]="Maximum stored loot",
			["EdtCSVexport"]="CSV-Export-Format",
			
			["TxtCSVJokers"]="%% %name% %class% %timestamp% %dd% %mm% %yy% %HH% %MM% %SS%",
			["TxtCSVJokers2"]="%iname% %irarity% %iraritytxt% %ilevel% %iid% %iprice% %icount% %itype% %itypetxt%",
			["TxtCSVJokersTitle"]="For CSV-Export you can use this jokers:",
			["TxtItemType"]="Attention! ItemType is independent of the rarity!",
			
			["TabRoll"]="Rolls",
			["TabLoot"]="Loot",
			["TabCSV"]="CSV",
			
			["PanelLootTracker"]="Loot Tracker",
			["HeaderRarity"]="Track Rarity",
			["HeaderItemType"]="Track ItemType",
			["HeaderSettings"]="Settings",
			["HeaderCustomLocales"]="Localization",
			["HeaderCSV"]="CSV-Export",
			["PanelAbout"]="About",
			["HeaderSlashCommand"]="Slash Commands",
			["HeaderCredits"]="Credits",
			["HeaderInfo"]="Information",
			["HeaderUsage"]="Usage",
		
			["Cboxshowminimapbutton"]="Show minimap button",
			["CboxLockMinimapButton"]="Lock minimap button position",		
			["CboxLockMinimapButtonDistance"]="Minimize minimap button distance",
			["CboxCloseOnClear"]="Close window after [Clear]",
			["CboxClearOnAnnounce"]="Clear rolls after [Announce]",
			["CboxCloseOnAnnounce"]="Close window after [Announce]",
			["CboxClearOnClose"]="Clear rolls after [Close]",
			["CboxIgnoreDouble"]="Ignore double rolls",
			["CboxRejectOutBounds"]="Reject rolls with bounds other than (1-100)",
			["CboxAnnounceIgnoreDouble"]="Only with [Announce]: Ignore double rolls",
			["CboxAnnounceRejectOutBounds"]="Only with [Announce]: Reject rolls with bounds other than (1-100)",
			["CboxNeedAndGreed"]="Use Need '/rnd' and Greed '/rnd 1-50' system, ignores out of bounce",
			["CboxShowNotRolled"]="Show [Not rolled] button",
			["CboxAutoLootRolls"]="Open 'Loot Rolls' automatically",
			["CboxAutoCloseLootRolls"]="Automatic close 'Loot Rolls' when everyone has rolled",
			["CboxClearOnStart"]="Clear when somebody starts a new roll",
			["CboxOpenOnStart"]="Open when somebody starts a new roll",
			["CboxColorName"]="Colorize names by class",
			["CboxShowClassIcon"]="Show class icon",
			["CboxOnDebug"]="Show debug information",
			
			["CboxLTShortMessage"]="Short Message",
			["CboxLTTrackSolo"]="Track solo",
			["CboxLTTrackGroup"]="Track party",
			["CboxLTTrackSRaid"]="Track raid with 10 or less members",
			["CboxLTTrackBRaid"]="Track raid with 11 or more members",
			["CboxLTEnable"]="Enable loot tracking",
			["CboxLTSmallFont"]="Small font",
			["CboxLTShowIcon"]="Show item icon",
			
			["SlashClearRolls"]="Clear rolls",
			["SlashClearLoot"]="Clear loot",
			["SlashClearLootRolls"]="Clear 'Loot Rolls'",
			["SlashUndoRolls"]="Recover last rolls",
			["SlashUndoLoot"]="Recover last loots",
			["SlashAnnounce"]="Announce winner of the last roll",
			["SlashNotRolled"]="Remind everyone who has not rolled",
			["SlashClose"]="Close main window",
			["SlashReset"]="Reset position of main window",
			["SlashConfig"]="Open Configuration",
			["SlashAbout"]="Open about",
			["SlashStart"]="Announce a new roll, <value> can be empty or itemlink",
			["SlashOpen"]="Open main window",
			["SlashRaidRoll"]="Roll a player name",
			["SlashRaidRollList"]="Output all player",
			
			["AboutInfo"]="Have you ever tried to roll the 'Onyxia Hide Backpack' in a raid? RTC collects all roll results and sorts them. Ever thought about whether you wanted something for your second-equip, but didn't know if somebody needed it? RTC can automatically open the Blizzard 'Loot rolls' window, where you can see immediately who needs or has greed.|nIn raid ever lost the overview, who got what? Again, RTC can help you. On request, it records all items, including a variable export function.",
			
			["AboutSlashCommand"]="<value> can be true, 1, enable, false, 0, disable. If <value> is omitted, the current status switches.",
			
			["AboutUsage"]="RTC will automatically open when someone rolls the dice. Double rolls or rolls outside the default range are ignored on request.|nBy default, the automatic opening of 'Loot Rolls' is disabled. Likewise, the 'Loot Tracker' must be turned on manually.",
			
			["AboutCredits"]="Russian translation by tierggg and Hubbotu|nBaudzilla for the graphics/idea of the resize-code|nRollTracker Classic is an updated version of 'RollTracker Lite', originally by Jerry Chong - zanglang@gmail.com.",

			["RollTracker Classic"]="RollTracker Classic",
			["RollTracker"]="RollTracker",
		}
	
	
	locales.esES=locales.esMX
	
	if RollTrackerClassicDB and RollTrackerClassicDB.OnDebug then
		for lkey,loc in pairs(locales) do
			if loc["MsgStart"] then
				for key,value in pairs(DefaultEnGB) do
					if loc[key]==nil then --or loc[key]==value then
						print ("RTC-Missing:"..lkey.."["..key.."]")
					end
				end
			end	
		end
	end
	
	
	local L = locales[GetLocale()] or {}
	
	if RollTrackerClassicDB and RollTrackerClassicDB.CustomLocales and type(RollTrackerClassicDB.CustomLocales) == "table" then
		for key,value in pairs(RollTrackerClassicDB.CustomLocales) do
			if value~=nil and value ~="" then
				L[key.."_org"]=L[key]
				L[key]=value
			end
		end
	end
	
	setmetatable(DefaultEnGB,{__index =function(t,k) return "["..k.."]" end})
	
	setmetatable(L, {
		__index = DefaultEnGB
	})
	
	return L
end