local name, addon = ...
local modulname = 'currency'
local events = {}
local modul = {
	['name'] = modulname
}
local function getCurrencyItem(index)
	local currencyLink = GetCurrencyListLink(index)
	if(currencyLink) then
		return tonumber(currencyLink:match("currency:(%d+)")) or nil
	end
end
local function curLoop(res,id)
	local unitname = nil
	for k,v in pairs(modul['db']) do
		local units = addon:getUnits()
		if(units and units[k]) then
			unitname = units[k]['name']
			for a,b in pairs(v) do
				if(a == id and b['count']>0) then
					if(b['max']>0) then
						res[unitname] = addon:colorize(format("%s/%s",b['count'],b['max']),b['count']==b['max'] and "ff0000" or "ffffff")
					else
						res[unitname] = addon:colorize(format("%s",b['count']),"ffffff")
					end
				end
			end
		end
	end
	return res
end
addon['curLoop'] = curLoop
local function SetCurrencyByID(tooltip,itemID)
	if(itemID) then
		local res = curLoop({},itemID)
		if(type(res) == 'table') then
			tooltip:AddLine(" ")
			for curName, b in pairs(res) do
				if(addon:GetPref(modul.name .. "Tooltip")) then 
					tooltip:AddLine(format("%s %s: %s",addon:getIcon(itemID),curName,b))
				end
			end
		end
		tooltip:Show()
	end
	return tooltip,itemID
end
local function SetCurrencyToken(tooltip,index)
	SetCurrencyByID(tooltip,getCurrencyItem(index))
end
local function GameTooltip_SetHyperlink(tooltip, link)
	SetCurrencyByID(tooltip,tonumber(link:match("currency:(%d+)")))
end

function events:CURRENCY_DISPLAY_UPDATE(event)
	local playerID = addon.getPID()
	if(playerID) then
		modul['db'][playerID] = modul['db'][playerID] or {}
		for index=1,GetCurrencyListSize() do
			local curName, isHeader, isExpanded, isUnused, isWatched, count, icon, maximum, hasWeeklyLimit, currentWeeklyAmount =GetCurrencyListInfo(index)
			local itemID = getCurrencyItem(index)
			if((not isHeader) and itemID) then
				modul['db'][playerID][tonumber(itemID)] = {
					['count'] = count,
					['max'] = maximum,
				}
				addon:setIcon(itemID, icon)
			end
		end
	end
end
local function OnEvent(self,event,...)
	local playerID = addon.getPID()
	if(playerID and type(events[event])=='function') then
		modul['db'] = addon:GetNamespace(modul.name)
		modul['db'][playerID] = modul['db'][playerID] or {}
		events[event](self, event, ...)
	end
end
function modul:Delete(id, typ)
	self['db'] = addon:GetNamespace(modul.name)
	if(typ == self['typ'] and id and id>0) then
		self['db'][id] = nil
	end
end
local skipClassic = {
	['CURRENCY_DISPLAY_UPDATE'] = true
}
function modul:Enable()
	if(not addon:IsClassic()) then
		self.status = true
		local list = {}
		for event,func in pairs(events) do
			if(not addon:IsClassic() or (addon:IsClassic() and not skipClassic[event])) then
				list[#list+1] = event
			end
		end
		self.frame = addon:RegisterFunc(list,"OnEvent",OnEvent)
		OnEvent(self.frame, "CURRENCY_DISPLAY_UPDATE")
		hooksecurefunc(GameTooltip, "SetCurrencyByID", SetCurrencyByID)
		hooksecurefunc(GameTooltip, "SetCurrencyToken", SetCurrencyToken)
		hooksecurefunc(GameTooltip,"SetHyperlink", GameTooltip_SetHyperlink)
	else
		self.status = false
	end
	
end
function modul:Disable()
	self.status = false
	for event,func in pairs(events) do
		if(not addon:IsClassic() or (addon:IsClassic() and not skipClassic[event])) then
			self.frame:UnregisterEvent(event)
		end
	end
end
addon['inits'][#addon['inits']+1] = function()
	modul.db,modul.status = addon:RegisterModul(modul, modulname)
	if(modul.status) then
		modul:Enable()
	end
end