/*

*/

; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER "0.0.0.0"
!define APPNAME "Google Chrome"
!define APP "Chrome"
!define APPDIR "App\Chrome"
!define APPEXE "chrome.exe"
!define APPDIR64 "App\Chrome64"
!define APPEXE64 "chrome.exe"
!define APPSWITCH ` --user-data-dir="$EXEDIR\Data\${APP}" --no-default-browser-check --enable-npapi`

; --- Define RegKeys ---
	!define REGKEY1 "HKEY_CURRENT_USER\Software\Google"
	!define REGKEY2 "HKEY_LOCAL_MACHINE\SOFTWARE\Google"
	!define REGKEY3 "HKEY_LOCAL_MACHINE\SOFTWARE\MozillaPlugins"

; ---Define Local Dirs, SubDirs (if any) beginnig with back-slash and Portable Dirs ---
; $LOCALAPPDATA\Google\Chrome\User Data\Crashpad
	!define LOCALDIR1 "$LOCALAPPDATA\Google"
	!define SUBDIR1 "\${APP}"

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "FileFunc.nsh"
!include "TextReplace.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\ChromePortable\${APP}Portable.exe"
Icon "${APP}.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************

Var INCOGNITO
Var CACHE
Var PLUGINS
Var PFLASHPATH
Var PFLASHVER
Var PARENTDIR

Function Init
ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "LastDirectory"
StrCpy $1 $0 3
StrCpy $2 $EXEDIR 3
StrCmp $1 $2 +3
	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\Default\Preferences" "$EXEDIR\Data\${APP}\Default\Preferences" "$1" "$2" "" $0
	${textreplace::Unload}

IfFileExists "$EXEDIR\Data\${APP}\Default\Preferences" +3
CreateDirectory "$EXEDIR\Data\${APP}\Default"
CopyFiles "$EXEDIR\App\DefaultData\${APP}\Default\*.*" "$EXEDIR\Data\${APP}\Default"

StrCpy $INCOGNITO ""
ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Incognito"
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Incognito" "false"
StrCmp $0 "true" 0 +3
	WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Incognito" "true"
	StrCpy $INCOGNITO "--incognito"

StrCpy $CACHE ""
ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "TempCache"
StrCmp $0 "false" +4
	WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "TempCache" "true"
	CreateDirectory "$TEMP\${APP}Portable"
	StrCpy $CACHE `--disk-cache-dir="$TEMP\${APP}Portable"`

StrCpy $PLUGINS ""
ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AllowOutdatedPlugins"
StrCmp $0 "false" +3
	WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AllowOutdatedPlugins" "true"
	StrCpy $PLUGINS `--allow-outdated-plugins`

	${GetParent} "$EXEDIR" "$PARENTDIR"
	StrCpy $PFLASHPATH ""
	StrCpy $PFLASHVER ""
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
IfFileExists "$PARENTDIR\CommonFiles\Plugins\NPSWF64.dll" 0 +2
	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\MozillaPlugins\@adobe.com/FlashPlayer" "Path" "$PARENTDIR\CommonFiles\Plugins\NPSWF64.dll"
IfFileExists "$PARENTDIR\CommonFiles\Java64\bin\plugin2\npjp2.dll" 0 +2
	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\MozillaPlugins\@java.com/JavaPlugin" "Path" "$PARENTDIR\CommonFiles\Java64\bin\plugin2\npjp2.dll"
IfFileExists "$PARENTDIR\CommonFiles\Java_64\bin\plugin2\npjp2.dll" 0 +2
	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\MozillaPlugins\@java.com/JavaPlugin" "Path" "$PARENTDIR\CommonFiles\Java_64\bin\plugin2\npjp2.dll"
IfFileExists "$PARENTDIR\CommonFiles\Plugins\pepflashplayer64.dll" 0 +9
	StrCpy $PFLASHPATH `--ppapi-flash-path="$PARENTDIR\CommonFiles\Plugins\pepflashplayer64.dll"`
GetDllVersion "$PARENTDIR\CommonFiles\Plugins\pepflashplayer64.dll" $R0 $R1
IntOp $R2 $R0 / 0x00010000
IntOp $R3 $R0 & 0x0000FFFF
IntOp $R4 $R1 / 0x00010000
IntOp $R5 $R1 & 0x0000FFFF
StrCpy $0 "$R2.$R3.$R4.$R5"
	StrCpy $PFLASHVER `--ppapi-flash-version=$0`
	nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR64}\${APPEXE64}" "${APPNAME} Portable 64 bit"
${Else}
IfFileExists "$PARENTDIR\CommonFiles\Plugins\NPSWF32.dll" 0 +2
	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\MozillaPlugins\@adobe.com/FlashPlayer" "Path" "$PARENTDIR\CommonFiles\Plugins\NPSWF32.dll"
IfFileExists "$PARENTDIR\CommonFiles\Java\bin\plugin2\npjp2.dll" 0 +2
	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\MozillaPlugins\@java.com/JavaPlugin" "Path" "$PARENTDIR\CommonFiles\Java\bin\plugin2\npjp2.dll"
IfFileExists "$PARENTDIR\CommonFiles\Plugins\pepflashplayer32.dll" 0 +9
	StrCpy $PFLASHPATH ` --ppapi-flash-path="$PARENTDIR\CommonFiles\Plugins\pepflashplayer32.dll"`
GetDllVersion "$PARENTDIR\CommonFiles\Plugins\pepflashplayer32.dll" $R0 $R1
IntOp $R2 $R0 / 0x00010000
IntOp $R3 $R0 & 0x0000FFFF
IntOp $R4 $R1 / 0x00010000
IntOp $R5 $R1 & 0x0000FFFF
StrCpy $0 "$R2.$R3.$R4.$R5"
	StrCpy $PFLASHVER `--ppapi-flash-version=$0`
	nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}" "${APPNAME} Portable"
${EndIf}

FunctionEnd
;**********************************************************
Function Close
ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "DeleteTempCache"
StrCmp $0 "false" +3
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "DeleteTempCache" "true"
	RMDir "/r" "$TEMP\${APP}Portable"

${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR64}\${APPEXE64}"
${Else}
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}"
${EndIf}

RMDir "$DOCUMENTS\Downloads"

FunctionEnd

; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckStart

	Call BackupLocalKeys

	Call BackupLocalDirs

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close

	Call RestoreLocalDirs

	Call RestoreLocalKeys

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
ReadINIStr $1 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters"
StrCmp $1 "" 0 +2
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters" ""

${GetParameters} $0
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
SetOutPath "$EXEDIR\${APPDIR64}"
ExecWait `"$EXEDIR\${APPDIR64}\${APPEXE64}"${APPSWITCH} $INCOGNITO $CACHE $PLUGINS $PFLASHPATH $PFLASHVER $1 $0`
${Else}
SetOutPath "$EXEDIR\${APPDIR}"
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}"${APPSWITCH}$INCOGNITO $CACHE $PLUGINS $PFLASHPATH $PFLASHVER $1 $0`
${EndIf}
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Actions on Registry Keys =====
; **************************************************************************
Function BackupLocalKeys
SetRegView 64
	${registry::BackupKey} "${REGKEY1}"
	${registry::BackupKey} "${REGKEY2}"
	${registry::BackupKey} "${REGKEY3}"
Sleep 50
FunctionEnd

Function RestoreLocalKeys
SetRegView 64
	${registry::RestoreBackupKey} "${REGKEY1}"
	${registry::RestoreBackupKey} "${REGKEY2}"
	${registry::RestoreBackupKey} "${REGKEY3}"
Sleep 50
${registry::Unload}
FunctionEnd

; **************************************************************************
; ==== Actions on Folders =====
; **************************************************************************
Function BackupLocalDirs
	${directory::BackupLocal} "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd

Function RestoreLocalDirs
	${directory::RestoreLocal} "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd
