/*
Chrome Portable 48.0.2564.116 32-64-bit_Multilingual_Online.exe
*/
!define RELEASURL	""
!define APPSIZE	"155000" # kB
!define DLVER	"MultiVersion"
!define APPVER 	"0.0.0.0"
!define APPNAME "Chrome"
!define APP 	"Chrome"
!define DLNAME	"Chrome"
!define APPLANG	"32-64-bit_Multilingual_Online"
!define FOLDER	"ChromePortable"
!define 7ZA ; Delete if setup not 7za
!define FINISHRUN
!define INPUTBOX ; Delete if no InputBox
!define OPTIONS
; !define DESCRIPTION	"Google Internet browser"
!define SOURCES

SetCompressor /SOLID lzma
SetCompressorDictSize 32

!include "..\_Include\Installer.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"
!include "XML.nsh"

!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Arabic"
!insertmacro MUI_LANGUAGE "Bulgarian"
!insertmacro MUI_LANGUAGE "Catalan"
!insertmacro MUI_LANGUAGE "Czech"
!insertmacro MUI_LANGUAGE "Danish"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Greek"
!insertmacro MUI_LANGUAGE "SpanishInternational"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "Estonian"
!insertmacro MUI_LANGUAGE "Farsi"
!insertmacro MUI_LANGUAGE "Finnish"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Hebrew"
!insertmacro MUI_LANGUAGE "Croatian"
!insertmacro MUI_LANGUAGE "Hungarian"
!insertmacro MUI_LANGUAGE "Indonesian"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "Japanese"
!insertmacro MUI_LANGUAGE "Korean"
!insertmacro MUI_LANGUAGE "Lithuanian"
!insertmacro MUI_LANGUAGE "Latvian"
!insertmacro MUI_LANGUAGE "Malay"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "Portuguese"
!insertmacro MUI_LANGUAGE "Romanian"
!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Slovak"
!insertmacro MUI_LANGUAGE "Slovenian"
!insertmacro MUI_LANGUAGE "Serbian"
!insertmacro MUI_LANGUAGE "Swedish"
!insertmacro MUI_LANGUAGE "Thai"
!insertmacro MUI_LANGUAGE "Turkish"
!insertmacro MUI_LANGUAGE "Ukrainian"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "TradChinese"

Var ARCH
Var APPID
Var AP
Var URL
Var NEWVER
Var NAME
Var SIZE

Var x86
Var x64
Function nsDialogsPage
	nsDialogs::Create 1018
	Pop $0
	${NSD_CreateLabel} 0 0 100% 12u "Please select application architecture:"
	Pop $0
	${NSD_CreateRadioButton} 0 15u 100% 10u "32 bit"
	Pop $x86
	${NSD_CreateRadioButton} 0 30u 100% 10u "64 bit"
	Pop $x64
${If} ${RunningX64}
	${NSD_SetState} $x64 ${BST_CHECKED}
${Else}
	${NSD_SetState} $x86 ${BST_CHECKED}
${EndIf}
	nsDialogs::Show
FunctionEnd

Function nsDialogsPageLeave
	${NSD_GetState} $x86 $R0
${If} $R0 = 1
	StrCpy $ARCH ""
${Else}
	StrCpy $ARCH "64"
${EndIf}
FunctionEnd

Function Install

Call CheckConnected
inetc::post `<?xml version="1.0" encoding="UTF-8"?><request protocol="3.0" version="1.3.23.9" ismachine="0" sessionid="" installsource="ondemandcheckforupdate" requestid=""><os platform="win" version="6.2" sp="" arch="x64"/><app appid="$APPID" version="" nextversion="" ap="$AP" lang="" brand="GGLS" client=""><updatecheck/><ping active="1"/></app></request>` `http://tools.google.com/service/update2` `$TEMP\${APP}PortableTemp\SnifLink.xml` /END
Pop $0
StrCmp $0 "OK" +3
MessageBox MB_USERICON "Download of SnifLink.xml: $0"
Abort

${xml::LoadFile} "$TEMP\${APP}PortableTemp\SnifLink.xml" $0
${xml::GotoPath} "/response/app/updatecheck/urls/url" $0
${xml::GetAttribute} "codebase" $URL $0
${xml::GotoPath} "/response/app/updatecheck/manifest" $0
${xml::GetAttribute} "version" $NEWVER $0
${xml::GotoPath} "/response/app/updatecheck/manifest/packages/package" $0
${xml::GetAttribute} "name" $NAME $0
${xml::GetAttribute} "size" $SIZE $0
${xml::Unload}

IntOp $SIZE $SIZE / 1048576

${If} ${FileExists} "$INSTDIR\App\${APP}$ARCH\chrome.dll"
GetDllVersion "$INSTDIR\App\${APP}$ARCH\chrome.dll" $R0 $R1
IntOp $R2 $R0 / 0x00010000
IntOp $R3 $R0 & 0x0000FFFF
IntOp $R4 $R1 / 0x00010000
IntOp $R5 $R1 & 0x0000FFFF
StrCpy $0 "$R2.$R3.$R4.$R5"
MessageBox MB_OKCANCEL "Replace $0 with $NEWVER ?$\n$SIZE MB will be downloaded." IDOK install IDCANCEL cancelled
${Else}
MessageBox MB_OKCANCEL "Install $NEWVER ?$\n$SIZE MB will be downloaded." IDOK install IDCANCEL cancelled
${EndIf}

install:

inetc::get "$URL$NAME" "$TEMP\${APP}PortableTemp\$NAME" /END
Pop $0
StrCmp $0 "OK" +3
MessageBox MB_USERICON "Download of $NAME: $0"
Abort

nsExec::Exec `"$TEMP\${APP}PortableTemp\7za.exe" x "$TEMP\${APP}PortableTemp\$NAME" -o"$TEMP\${APP}PortableTemp"`
nsExec::Exec `"$TEMP\${APP}PortableTemp\7za.exe" x "$TEMP\${APP}PortableTemp\chrome.7z" -o"$TEMP\${APP}PortableTemp"`

SetOutPath "$INSTDIR"
File "..\..\..\${FOLDER}\${APP}Portable.exe"
SetOutPath "$INSTDIR\App\DefaultData\${APP}\Default"
File "Default\Preferences"
File "Default\Bookmarks"
SetOutPath "$INSTDIR\App\${APP}$ARCH"
FileOpen $0 "$INSTDIR\App\${APP}$ARCH\First Run" w
FileClose $0
CopyFiles /SILENT /FILESONLY "$TEMP\${APP}PortableTemp\Chrome-bin\*.*" "$INSTDIR\App\${APP}$ARCH"
CopyFiles /SILENT "$TEMP\${APP}PortableTemp\Chrome-bin\$NEWVER\*.*" "$INSTDIR\App\${APP}$ARCH"

!ifdef DESCRIPTION
	Call AppInfo
!endif
!ifdef SOURCES
	Call Sources
	SetOutPath "$INSTDIR\Other\_Include\7-Zip"
	File "..\_Include\7-Zip\7za.exe"
	SetOutPath "$INSTDIR\Other\Source\Default"
	File "Default\Preferences"
!endif
!ifdef SOURCES & DESCRIPTION
	Call SourceInfo
!endif

cancelled:

FunctionEnd

Function .onGUIEnd
	RMDir "/r" "$TEMP\${APP}PortableTemp"
FunctionEnd



Section "Chrome Stable" SEC_STABLE
${If} $ARCH == ""
	StrCpy $AP "stable"
${Else}
	StrCpy $AP "x64-stable"
${EndIf}
	StrCpy $APPID "{8A69D345-D564-463C-AFF1-A69D9E530F96}"
	Call Install
SectionEnd

Section /o "Chrome Beta" SEC_BETA
${If} $ARCH == ""
	StrCpy $AP "1.1-beta"
${Else}
	StrCpy $AP "x64-beta"
${EndIf}
	StrCpy $APPID "{8A69D345-D564-463C-AFF1-A69D9E530F96}"
	Call Install
SectionEnd

Section /o "Chrome Dev" SEC_DEV
${If} $ARCH == ""
	StrCpy $AP "2.0-dev"
${Else}
	StrCpy $AP "x64-dev"
${EndIf}
	StrCpy $APPID "{8A69D345-D564-463C-AFF1-A69D9E530F96}"
	Call Install
SectionEnd

Section /o "Chrome Canary" SEC_CANARY
${If} $ARCH == ""
	StrCpy $AP ""
${Else}
	StrCpy $AP "x64-canary"
${EndIf}
	StrCpy $APPID "{4EA16AC7-FD5A-47C3-875B-DBF4A2008C20}"
	Call Install
SectionEnd


Function Init
  StrCpy $1 ${SEC_STABLE}

SectionSetSize ${SEC_STABLE} 155000 # kB
SectionSetSize ${SEC_BETA} 155000 # kB
SectionSetSize ${SEC_DEV} 150000 # kB
SectionSetSize ${SEC_CANARY} 150000 # kB
FunctionEnd

Function .onSelChange
!insertmacro StartRadioButtons $1
	!insertmacro RadioButton ${SEC_STABLE}
	!insertmacro RadioButton ${SEC_BETA}
	!insertmacro RadioButton ${SEC_DEV}
	!insertmacro RadioButton ${SEC_CANARY}
!insertmacro EndRadioButtons
FunctionEnd
