#pragma once

#include "Emu/Memory/vm_ptr.h"

// Return Codes
enum
{
	CELL_ATRACMULTI_ERROR_API_FAIL                    = 0x80610b01,
	CELL_ATRACMULTI_ERROR_READSIZE_OVER_BUFFER        = 0x80610b11,
	CELL_ATRACMULTI_ERROR_UNKNOWN_FORMAT              = 0x80610b12,
	CELL_ATRACMULTI_ERROR_READSIZE_IS_TOO_SMALL       = 0x80610b13,
	CELL_ATRACMULTI_ERROR_ILLEGAL_SAMPLING_RATE       = 0x80610b14,
	CELL_ATRACMULTI_ERROR_ILLEGAL_DATA                = 0x80610b15,
	CELL_ATRACMULTI_ERROR_NO_DECODER                  = 0x80610b21,
	CELL_ATRACMULTI_ERROR_UNSET_DATA                  = 0x80610b22,
	CELL_ATRACMULTI_ERROR_DECODER_WAS_CREATED         = 0x80610b23,
	CELL_ATRACMULTI_ERROR_ALLDATA_WAS_DECODED         = 0x80610b31,
	CELL_ATRACMULTI_ERROR_NODATA_IN_BUFFER            = 0x80610b32,
	CELL_ATRACMULTI_ERROR_NOT_ALIGNED_OUT_BUFFER      = 0x80610b33,
	CELL_ATRACMULTI_ERROR_NEED_SECOND_BUFFER          = 0x80610b34,
	CELL_ATRACMULTI_ERROR_ALLDATA_IS_ONMEMORY         = 0x80610b41,
	CELL_ATRACMULTI_ERROR_ADD_DATA_IS_TOO_BIG         = 0x80610b42,
	CELL_ATRACMULTI_ERROR_NONEED_SECOND_BUFFER        = 0x80610b51,
	CELL_ATRACMULTI_ERROR_UNSET_LOOP_NUM              = 0x80610b61,
	CELL_ATRACMULTI_ERROR_ILLEGAL_SAMPLE              = 0x80610b71,
	CELL_ATRACMULTI_ERROR_ILLEGAL_RESET_BYTE          = 0x80610b72,
	CELL_ATRACMULTI_ERROR_ILLEGAL_PPU_THREAD_PRIORITY = 0x80610b81,
	CELL_ATRACMULTI_ERROR_ILLEGAL_SPU_THREAD_PRIORITY = 0x80610b82,
	CELL_ATRACMULTI_ERROR_API_PARAMETER               = 0x80610b91,
};

// Remain Frame
enum : s32
{
	CELL_ATRACMULTI_ALLDATA_IS_ON_MEMORY             = -1,
	CELL_ATRACMULTI_NONLOOP_STREAM_DATA_IS_ON_MEMORY = -2,
	CELL_ATRACMULTI_LOOP_STREAM_DATA_IS_ON_MEMORY    = -3,
};

struct alignas(8) CellAtracMultiHandle
{
	vm::ptr<u8> pucWorkMem;
	// ...
};

CHECK_MAX_SIZE(CellAtracMultiHandle, 512);

struct CellAtracMultiBufferInfo
{
	vm::ptr<u8> pucWriteAddr;
	be_t<u32> uiWritableByte;
	be_t<u32> uiMinWriteByte;
	be_t<u32> uiReadPosition;
};

struct CellAtracMultiExtRes
{
	vm::ptr<struct CellSpurs> pSpurs;
	u8 priority[8];
};
