#include "stdafx.h"
#include "PPUFunction.h"

#include "PPUModule.h"

extern std::string ppu_get_syscall_name(u64 code)
{
	switch (code)
	{
	case 1: return "sys_process_getpid";
	case 2: return "sys_process_wait_for_child";
	case 4: return "sys_process_get_status";
	case 5: return "sys_process_detach_child";
	case 12: return "sys_process_get_number_of_object";
	case 13: return "sys_process_get_id";
	case 14: return "sys_process_is_spu_lock_line_reservation_address";
	case 18: return "sys_process_getppid";
	case 19: return "sys_process_kill";
	case 21: return "_sys_process_spawn";
	case 22: return "_sys_process_exit";
	case 23: return "sys_process_wait_for_child2";
	case 25: return "sys_process_get_sdk_version";
	case 26: return "_sys_process_exit2";
	case 28: return "_sys_process_get_number_of_object";
	case 29: return "sys_process_get_id";
	case 30: return "_sys_process_get_paramsfo";
	case 31: return "sys_process_get_ppu_guid";
	case 41: return "_sys_ppu_thread_exit";
	case 43: return "sys_ppu_thread_yield";
	case 44: return "sys_ppu_thread_join";
	case 45: return "sys_ppu_thread_detach";
	case 46: return "sys_ppu_thread_get_join_state";
	case 47: return "sys_ppu_thread_set_priority";
	case 48: return "sys_ppu_thread_get_priority";
	case 49: return "sys_ppu_thread_get_stack_information";
	case 50: return "sys_ppu_thread_stop";
	case 51: return "sys_ppu_thread_restart";
	case 52: return "_sys_ppu_thread_create";
	case 53: return "sys_ppu_thread_start";
	case 56: return "sys_ppu_thread_rename";
	case 57: return "sys_ppu_thread_recover_page_fault";
	case 58: return "sys_ppu_thread_get_page_fault_context";
	case 60: return "sys_trace_create";
	case 61: return "sys_trace_start";
	case 62: return "sys_trace_stop";
	case 63: return "sys_trace_update_top_index";
	case 64: return "sys_trace_destroy";
	case 65: return "sys_trace_drain";
	case 66: return "sys_trace_attach_process";
	case 67: return "sys_trace_allocate_buffer";
	case 68: return "sys_trace_free_buffer";
	case 69: return "sys_trace_create2";
	case 70: return "sys_timer_create";
	case 71: return "sys_timer_destroy";
	case 72: return "sys_timer_get_information";
	case 73: return "_sys_timer_start";
	case 74: return "sys_timer_stop";
	case 75: return "sys_timer_connect_event_queue";
	case 76: return "sys_timer_disconnect_event_queue";
	case 77: return "sys_trace_create2_in_cbepm";
	case 80: return "sys_interrupt_tag_create";
	case 81: return "sys_interrupt_tag_destroy";
	case 82: return "sys_event_flag_create";
	case 83: return "sys_event_flag_destroy";
	case 84: return "_sys_interrupt_thread_establish";
	case 85: return "sys_event_flag_wait";
	case 86: return "sys_event_flag_trywait";
	case 87: return "sys_event_flag_set";
	case 88: return "sys_interrupt_thread_eoi";
	case 89: return "_sys_interrupt_thread_disestablish";
	case 90: return "sys_semaphore_create";
	case 91: return "sys_semaphore_destroy";
	case 92: return "sys_semaphore_wait";
	case 93: return "sys_semaphore_trywait";
	case 94: return "sys_semaphore_post";
	case 95: return "_sys_lwmutex_create";
	case 96: return "_sys_lwmutex_destroy";
	case 97: return "_sys_lwmutex_lock";
	case 98: return "_sys_lwmutex_unlock";
	case 99: return "_sys_lwmutex_trylock";
	case 100: return "sys_mutex_create";
	case 101: return "sys_mutex_destroy";
	case 102: return "sys_mutex_lock";
	case 103: return "sys_mutex_trylock";
	case 104: return "sys_mutex_unlock";
	case 105: return "sys_cond_create";
	case 106: return "sys_cond_destroy";
	case 107: return "sys_cond_wait";
	case 108: return "sys_cond_signal";
	case 109: return "sys_cond_signal_all";
	case 110: return "sys_cond_signal_to";
	case 111: return "_sys_lwcond_create";
	case 112: return "_sys_lwcond_destroy";
	case 113: return "_sys_lwcond_queue_wait";
	case 114: return "sys_semaphore_get_value";
	case 115: return "_sys_lwcond_signal";
	case 116: return "_sys_lwcond_signal_all";
	case 117: return "_sys_lwmutex_unlock2";
	case 118: return "sys_event_flag_clear";
	case 119: return "sys_time_get_rtc";
	case 120: return "sys_rwlock_create";
	case 121: return "sys_rwlock_destroy";
	case 122: return "sys_rwlock_rlock";
	case 123: return "sys_rwlock_tryrlock";
	case 124: return "sys_rwlock_runlock";
	case 125: return "sys_rwlock_wlock";
	case 126: return "sys_rwlock_trywlock";
	case 127: return "sys_rwlock_wunlock";
	case 128: return "sys_event_queue_create";
	case 129: return "sys_event_queue_destroy";
	case 130: return "sys_event_queue_receive";
	case 131: return "sys_event_queue_tryreceive";
	case 132: return "sys_event_flag_cancel";
	case 133: return "sys_event_queue_drain";
	case 134: return "sys_event_port_create";
	case 135: return "sys_event_port_destroy";
	case 136: return "sys_event_port_connect_local";
	case 137: return "sys_event_port_disconnect";
	case 138: return "sys_event_port_send";
	case 139: return "sys_event_flag_get";
	case 140: return "sys_event_port_connect_ipc";
	case 141: return "sys_timer_usleep";
	case 142: return "sys_timer_sleep";
	case 143: return "sys_time_set_timezone";
	case 144: return "sys_time_get_timezone";
	case 145: return "sys_time_get_current_time";
	case 146: return "sys_time_get_system_time";
	case 147: return "sys_time_get_timebase_frequency";
	case 148: return "_sys_rwlock_trywlock";
	case 150: return "sys_raw_spu_create_interrupt_tag";
	case 151: return "sys_raw_spu_set_int_mask";
	case 152: return "sys_raw_spu_get_int_mask";
	case 153: return "sys_raw_spu_set_int_stat";
	case 154: return "sys_raw_spu_get_int_stat";
	case 155: return "_sys_spu_image_get_information";
	case 156: return "sys_spu_image_open";
	case 157: return "_sys_spu_image_import";
	case 158: return "_sys_spu_image_close";
	case 159: return "_sys_spu_image_get_segments";
	case 160: return "sys_raw_spu_create";
	case 161: return "sys_raw_spu_destroy";
	case 163: return "sys_raw_spu_read_puint_mb";
	case 165: return "sys_spu_thread_get_exit_status";
	case 166: return "sys_spu_thread_set_argument";
	case 167: return "sys_spu_thread_group_start_on_exit";
	case 169: return "sys_spu_initialize";
	case 170: return "sys_spu_thread_group_create";
	case 171: return "sys_spu_thread_group_destroy";
	case 172: return "sys_spu_thread_initialize";
	case 173: return "sys_spu_thread_group_start";
	case 174: return "sys_spu_thread_group_suspend";
	case 175: return "sys_spu_thread_group_resume";
	case 176: return "sys_spu_thread_group_yield";
	case 177: return "sys_spu_thread_group_terminate";
	case 178: return "sys_spu_thread_group_join";
	case 179: return "sys_spu_thread_group_set_priority";
	case 180: return "sys_spu_thread_group_get_priority";
	case 181: return "sys_spu_thread_write_ls";
	case 182: return "sys_spu_thread_read_ls";
	case 184: return "sys_spu_thread_write_snr";
	case 185: return "sys_spu_thread_group_connect_event";
	case 186: return "sys_spu_thread_group_disconnect_event";
	case 187: return "sys_spu_thread_set_spu_cfg";
	case 188: return "sys_spu_thread_get_spu_cfg";
	case 190: return "sys_spu_thread_write_spu_mb";
	case 191: return "sys_spu_thread_connect_event";
	case 192: return "sys_spu_thread_disconnect_event";
	case 193: return "sys_spu_thread_bind_queue";
	case 194: return "sys_spu_thread_unbind_queue";
	case 196: return "sys_raw_spu_set_spu_cfg";
	case 197: return "sys_raw_spu_get_spu_cfg";
	case 198: return "sys_spu_thread_recover_page_fault";
	case 199: return "sys_raw_spu_recover_page_fault";
	case 215: return "sys_dbg_mat_set_condition";
	case 216: return "sys_dbg_mat_get_condition";
	case 230: return "sys_isolated_spu_create";
	case 231: return "sys_isolated_spu_destroy";
	case 232: return "sys_isolated_spu_start";
	case 233: return "sys_isolated_spu_create_interrupt_tag";
	case 234: return "sys_isolated_spu_set_int_mask";
	case 235: return "sys_isolated_spu_get_int_mask";
	case 236: return "sys_isolated_spu_set_int_stat";
	case 237: return "sys_isolated_spu_get_int_stat";
	case 238: return "sys_isolated_spu_set_spu_cfg";
	case 239: return "sys_isolated_spu_get_spu_cfg";
	case 240: return "sys_isolated_spu_read_puint_mb";
	case 244: return "sys_spu_thread_group_system_set_next_group";
	case 245: return "sys_spu_thread_group_system_unset_next_group";
	case 246: return "sys_spu_thread_group_system_set_switch_group";
	case 247: return "sys_spu_thread_group_system_unset_switch_group";
	case 250: return "sys_spu_thread_group_set_cooperative_victims";
	case 251: return "sys_spu_thread_group_connect_event_all_threads";
	case 252: return "sys_spu_thread_group_disconnect_event_all_threads";
	case 254: return "sys_spu_thread_group_log";
	case 260: return "sys_spu_image_open_by_fd";
	case 300: return "sys_vm_memory_map";
	case 301: return "sys_vm_unmap";
	case 302: return "sys_vm_append_memory";
	case 303: return "sys_vm_return_memory";
	case 304: return "sys_vm_lock";
	case 305: return "sys_vm_unlock";
	case 306: return "sys_vm_touch";
	case 307: return "sys_vm_flush";
	case 308: return "sys_vm_invalidate";
	case 309: return "sys_vm_store";
	case 310: return "sys_vm_sync";
	case 311: return "sys_vm_test";
	case 312: return "sys_vm_get_statistics";
	case 313: return "sys_vm_memory_map_different";
	case 324: return "sys_memory_container_create";
	case 325: return "sys_memory_container_destroy";
	case 326: return "sys_mmapper_allocate_fixed_address";
	case 327: return "sys_mmapper_enable_page_fault_notification";
	case 328: return "sys_mmapper_allocate_shared_memory_ext";
	case 329: return "sys_mmapper_free_shared_memory";
	case 330: return "sys_mmapper_allocate_address";
	case 331: return "sys_mmapper_free_address";
	case 332: return "sys_mmapper_allocate_shared_memory";
	case 333: return "sys_mmapper_set_shared_memory_flag";
	case 334: return "sys_mmapper_map_shared_memory";
	case 335: return "sys_mmapper_unmap_shared_memory";
	case 336: return "sys_mmapper_change_address_access_right";
	case 337: return "sys_mmapper_search_and_map";
	case 338: return "sys_mmapper_get_shared_memory_attribute";
	case 341: return "sys_memory_container_create";
	case 342: return "sys_memory_container_destroy";
	case 343: return "sys_memory_container_get_size";
	case 344: return "sys_memory_budget_set";
	case 348: return "sys_memory_allocate";
	case 349: return "sys_memory_free";
	case 350: return "sys_memory_allocate_from_container";
	case 351: return "sys_memory_get_page_attribute";
	case 352: return "sys_memory_get_user_memory_size";
	case 353: return "sys_memory_get_user_memory_stat";
	case 356: return "sys_memory_allocate_colored";
	case 361: return "sys_memory_allocate_from_container_colored";
	case 362: return "sys_mmapper_allocate_shared_memory_from_container";
	case 367: return "sys_uart_initialize";
	case 368: return "sys_uart_receive";
	case 369: return "sys_uart_send";
	case 370: return "sys_uart_get_params";
	case 372: return "sys_game_watchdog_start";
	case 373: return "sys_game_watchdog_stop";
	case 374: return "sys_game_watchdog_clear";
	case 375: return "sys_game_set_system_sw_version";
	case 376: return "sys_game_get_system_sw_version";
	case 377: return "sys_sm_set_shop_mode";
	case 378: return "sys_sm_get_ext_event2";
	case 379: return "sys_sm_shutdown";
	case 380: return "sys_sm_get_params";
	case 381: return "sys_sm_get_inter_lpar_parameter";
	case 382: return "sys_sm_initialize";
	case 383: return "sys_game_get_temperature";
	case 384: return "sys_sm_get_tzpb";
	case 385: return "sys_sm_request_led";
	case 386: return "sys_sm_control_led";
	case 387: return "sys_sm_get_system_info";
	case 388: return "sys_sm_ring_buzzer";
	case 389: return "sys_sm_set_fan_policy";
	case 390: return "sys_sm_request_error_log";
	case 391: return "sys_sm_request_be_count";
	case 392: return "sys_sm_ring_buzzer";
	case 393: return "sys_sm_get_hw_config";
	case 394: return "sys_sm_request_scversion";
	case 395: return "sys_sm_request_system_event_log";
	case 396: return "sys_sm_set_rtc_alarm";
	case 397: return "sys_sm_get_rtc_alarm";
	case 398: return "sys_console_write";
	case 402: return "sys_tty_read";
	case 403: return "sys_tty_write";
	case 408: return "sys_sm_get_tzpb";
	case 409: return "sys_sm_get_fan_policy";
	case 410: return "sys_game_board_storage_read";
	case 411: return "sys_game_board_storage_write";
	case 412: return "sys_game_get_rtc_status";
	case 450: return "sys_overlay_load_module";
	case 451: return "sys_overlay_unload_module";
	case 452: return "sys_overlay_get_module_list";
	case 453: return "sys_overlay_get_module_info";
	case 454: return "sys_overlay_load_module_by_fd";
	case 455: return "sys_overlay_get_module_info2";
	case 456: return "sys_overlay_get_sdk_version";
	case 457: return "sys_overlay_get_module_dbg_info";
	case 458: return "sys_overlay_get_module_dbg_info";
	case 460: return "sys_prx_dbg_get_module_id_list";
	case 461: return "_sys_prx_get_module_id_by_address";
	case 463: return "_sys_prx_load_module_by_fd";
	case 464: return "_sys_prx_load_module_on_memcontainer_by_fd";
	case 465: return "_sys_prx_load_module_list";
	case 466: return "_sys_prx_load_module_list_on_memcontainer";
	case 467: return "sys_prx_get_ppu_guid";
	case 470: return "sys_npdrm_check_ekc";
	case 471: return "sys_npdrm_regist_ekc";
	case 480: return "_sys_prx_load_module";
	case 481: return "_sys_prx_start_module";
	case 482: return "_sys_prx_stop_module";
	case 483: return "_sys_prx_unload_module";
	case 484: return "_sys_prx_register_module";
	case 485: return "_sys_prx_query_module";
	case 486: return "_sys_prx_register_library";
	case 487: return "_sys_prx_unregister_library";
	case 488: return "_sys_prx_link_library";
	case 489: return "_sys_prx_unlink_library";
	case 490: return "_sys_prx_query_library";
	case 492: return "sys_prx_dbg_get_module_list";
	case 493: return "sys_prx_dbg_get_module_info";
	case 494: return "_sys_prx_get_module_list";
	case 495: return "_sys_prx_get_module_info";
	case 496: return "_sys_prx_get_module_id_by_name";
	case 497: return "_sys_prx_load_module_on_memcontainer";
	case 498: return "_sys_prx_start";
	case 499: return "_sys_prx_stop";
	case 500: return "sys_hid_manager_open";
	case 501: return "sys_hid_manager_close";
	case 502: return "sys_hid_manager_read";
	case 503: return "sys_hid_manager_ioctl";
	case 504: return "sys_hid_manager_map_logical_id_to_port_id";
	case 505: return "sys_hid_manager_unmap_logical_id_to_port_id";
	case 506: return "sys_hid_manager_add_hot_key_observer";
	case 507: return "sys_hid_manager_remove_hot_key_observer";
	case 508: return "sys_hid_manager_grab_focus";
	case 509: return "sys_hid_manager_release_focus";
	case 510: return "sys_hid_manager_check_focus";
	case 511: return "sys_hid_manager_set_master_process";
	case 516: return "sys_config_open";
	case 517: return "sys_config_close";
	case 518: return "sys_config_get_service_event";
	case 519: return "sys_config_add_service_listener";
	case 520: return "sys_config_remove_service_listener";
	case 521: return "sys_config_register_service";
	case 522: return "sys_config_unregister_service";
	case 523: return "sys_config_get_io_event";
	case 524: return "sys_config_register_io_error_listener";
	case 525: return "sys_config_unregister_io_error_listener";
	case 530: return "sys_usbd_initialize";
	case 531: return "sys_usbd_finalize";
	case 532: return "sys_usbd_get_device_list";
	case 533: return "sys_usbd_get_descriptor_size";
	case 534: return "sys_usbd_get_descriptor";
	case 535: return "sys_usbd_register_ldd";
	case 536: return "sys_usbd_unregister_ldd";
	case 537: return "sys_usbd_open_pipe";
	case 538: return "sys_usbd_open_default_pipe";
	case 539: return "sys_usbd_close_pipe";
	case 540: return "sys_usbd_receive_event";
	case 541: return "sys_usbd_detect_event";
	case 542: return "sys_usbd_attach";
	case 543: return "sys_usbd_transfer_data";
	case 544: return "sys_usbd_isochronous_transfer_data";
	case 545: return "sys_usbd_get_transfer_status";
	case 546: return "sys_usbd_get_isochronous_transfer_status";
	case 547: return "sys_usbd_get_device_location";
	case 548: return "sys_usbd_send_event";
	case 549: return "sys_usbd_event_port_send";
	case 550: return "sys_usbd_allocate_memory";
	case 551: return "sys_usbd_free_memory";
	case 556: return "sys_usbd_get_device_speed";
	case 559: return "sys_usbd_register_extra_ldd";
	case 570: return "sys_pad_ldd_register_controller";
	case 571: return "sys_pad_ldd_unregister_controller";
	case 572: return "sys_pad_ldd_data_insert";
	case 573: return "sys_pad_dbg_ldd_set_data_insert_mode";
	case 574: return "sys_pad_ldd_register_controller";
	case 575: return "sys_pad_ldd_get_port_no";
	case 583: return "sys_bt_read_firmware_version";
	case 584: return "sys_bt_complete_wake_on_host";
	case 585: return "sys_bt_disable_bluetooth";
	case 586: return "sys_bt_enable_bluetooth";
	case 587: return "sys_bt_bccmd";
	case 588: return "sys_bt_read_hq";
	case 589: return "sys_bt_hid_get_remote_status";
	case 590: return "sys_bt_register_controller";
	case 591: return "sys_bt_clear_registered_contoller";
	case 592: return "sys_bt_connect_accept_controller";
	case 593: return "sys_bt_get_local_bdaddress";
	case 594: return "sys_bt_hid_get_data";
	case 595: return "sys_bt_hid_set_report";
	case 596: return "sys_bt_sched_log";
	case 597: return "sys_bt_cancel_connect_accept_controller";
	case 600: return "sys_storage_open";
	case 601: return "sys_storage_close";
	case 602: return "sys_storage_read";
	case 603: return "sys_storage_write";
	case 604: return "sys_storage_send_device_command";
	case 605: return "sys_storage_async_configure";
	case 606: return "sys_storage_async_read";
	case 607: return "sys_storage_async_write";
	case 608: return "sys_storage_async_cancel";
	case 609: return "sys_storage_get_device_info";
	case 610: return "sys_storage_get_device_config";
	case 611: return "sys_storage_report_devices";
	case 612: return "sys_storage_configure_medium_event";
	case 613: return "sys_storage_set_medium_polling_interval";
	case 614: return "sys_storage_create_region";
	case 615: return "sys_storage_delete_region";
	case 616: return "sys_storage_execute_device_command";
	case 617: return "sys_storage_check_region_acl";
	case 618: return "sys_storage_set_region_acl";
	case 619: return "sys_storage_async_send_device_command";
	case 621: return "sys_gamepad_ycon_if";
	case 622: return "sys_storage_get_region_offset";
	case 623: return "sys_storage_set_emulated_speed";
	case 624: return "sys_io_buffer_create";
	case 625: return "sys_io_buffer_destroy";
	case 626: return "sys_io_buffer_allocate";
	case 627: return "sys_io_buffer_free";
	case 630: return "sys_gpio_set";
	case 631: return "sys_gpio_get";
	case 633: return "sys_fsw_connect_event";
	case 634: return "sys_fsw_disconnect_event";
	case 635: return "sys_btsetting_if";
	case 640: return "sys_usbbtaudio_initialize";
	case 641: return "sys_usbbtaudio_finalize";
	case 642: return "sys_usbbtaudio_discovery";
	case 643: return "sys_usbbtaudio_cancel_discovery";
	case 644: return "sys_usbbtaudio_pairing";
	case 645: return "sys_usbbtaudio_set_passkey";
	case 646: return "sys_usbbtaudio_connect";
	case 647: return "sys_usbbtaudio_disconnect";
	case 650: return "sys_rsxaudio_initialize";
	case 651: return "sys_rsxaudio_finalize";
	case 652: return "sys_rsxaudio_import_shared_memory";
	case 653: return "sys_rsxaudio_unimport_shared_memory";
	case 654: return "sys_rsxaudio_create_connection";
	case 655: return "sys_rsxaudio_close_connection";
	case 656: return "sys_rsxaudio_prepare_process";
	case 657: return "sys_rsxaudio_start_process";
	case 658: return "sys_rsxaudio_stop_process";
	case 666: return "sys_rsx_device_open";
	case 667: return "sys_rsx_device_close";
	case 668: return "sys_rsx_memory_allocate";
	case 669: return "sys_rsx_memory_free";
	case 670: return "sys_rsx_context_allocate";
	case 671: return "sys_rsx_context_free";
	case 672: return "sys_rsx_context_iomap";
	case 673: return "sys_rsx_context_iounmap";
	case 674: return "sys_rsx_context_attribute";
	case 675: return "sys_rsx_device_map";
	case 676: return "sys_rsx_device_unmap";
	case 677: return "sys_rsx_attribute";
	case 699: return "sys_bdemu_send_command";
	case 700: return "sys_net_bnet_accept";
	case 701: return "sys_net_bnet_bind";
	case 702: return "sys_net_bnet_connect";
	case 703: return "sys_net_bnet_getpeername";
	case 704: return "sys_net_bnet_getsockname";
	case 705: return "sys_net_bnet_getsockopt";
	case 706: return "sys_net_bnet_listen";
	case 707: return "sys_net_bnet_recvfrom";
	case 708: return "sys_net_bnet_recvmsg";
	case 709: return "sys_net_bnet_sendmsg";
	case 710: return "sys_net_bnet_sendto";
	case 711: return "sys_net_bnet_setsockopt";
	case 712: return "sys_net_bnet_shutdown";
	case 713: return "sys_net_bnet_socket";
	case 714: return "sys_net_bnet_close";
	case 715: return "sys_net_bnet_poll";
	case 716: return "sys_net_bnet_select";
	case 717: return "_sys_net_open_dump";
	case 718: return "_sys_net_read_dump";
	case 719: return "_sys_net_close_dump";
	case 720: return "_sys_net_write_dump";
	case 721: return "sys_net_abort";
	case 722: return "sys_net_infoctl";
	case 723: return "sys_net_control";
	case 724: return "sys_net_bnet_ioctl";
	case 725: return "sys_net_bnet_sysctl";
	case 726: return "sys_net_eurus_post_command";
	case 800: return "sys_fs_test";
	case 801: return "sys_fs_open";
	case 802: return "sys_fs_read";
	case 803: return "sys_fs_write";
	case 804: return "sys_fs_close";
	case 805: return "sys_fs_opendir";
	case 806: return "sys_fs_readdir";
	case 807: return "sys_fs_closedir";
	case 808: return "sys_fs_stat";
	case 809: return "sys_fs_fstat";
	case 810: return "sys_fs_link";
	case 811: return "sys_fs_mkdir";
	case 812: return "sys_fs_rename";
	case 813: return "sys_fs_rmdir";
	case 814: return "sys_fs_unlink";
	case 815: return "sys_fs_utime";
	case 816: return "sys_fs_access";
	case 817: return "sys_fs_fcntl";
	case 818: return "sys_fs_lseek";
	case 819: return "sys_fs_fdatasync";
	case 820: return "sys_fs_fsync";
	case 821: return "sys_fs_fget_block_size";
	case 822: return "sys_fs_get_block_size";
	case 823: return "sys_fs_acl_read";
	case 824: return "sys_fs_acl_write";
	case 825: return "sys_fs_lsn_get_cda_size";
	case 826: return "sys_fs_lsn_get_cda";
	case 827: return "sys_fs_lsn_lock";
	case 828: return "sys_fs_lsn_unlock";
	case 829: return "sys_fs_lsn_read";
	case 830: return "sys_fs_lsn_write";
	case 831: return "sys_fs_truncate";
	case 832: return "sys_fs_ftruncate";
	case 833: return "sys_fs_symbolic_link";
	case 834: return "sys_fs_chmod";
	case 835: return "sys_fs_chown";
	case 836: return "sys_fs_newfs";
	case 837: return "sys_fs_mount";
	case 838: return "sys_fs_unmount";
	case 839: return "sys_fs_sync";
	case 840: return "sys_fs_disk_free";
	case 841: return "sys_fs_get_mount_info_size";
	case 842: return "sys_fs_get_mount_info";
	case 843: return "sys_fs_get_fs_info_size";
	case 844: return "sys_fs_get_fs_info";
	case 845: return "sys_fs_mapped_allocate";
	case 846: return "sys_fs_mapped_free";
	case 847: return "sys_fs_truncate2";
	case 860: return "sys_ss_get_cache_of_analog_sunset_flag";
	case 861: return "sys_ss_protected_file_db";
	case 862: return "sys_ss_virtual_trm_manager";
	case 863: return "sys_ss_update_manager";
	case 864: return "sys_ss_sec_hw_framework";
	case 865: return "sys_ss_random_number_generator";
	case 866: return "sys_ss_secure_rtc";
	case 867: return "sys_ss_appliance_info_manager";
	case 868: return "sys_ss_individual_info_manager";
	case 869: return "sys_ss_factory_data_manager";
	case 870: return "sys_ss_get_console_id";
	case 871: return "sys_ss_access_control_engine";
	case 872: return "sys_ss_get_open_psid";
	case 873: return "sys_ss_get_cache_of_product_mode";
	case 874: return "sys_ss_get_cache_of_flash_ext_flag";
	case 875: return "sys_ss_get_boot_device";
	case 876: return "sys_ss_disc_access_control";
	case 878: return "sys_ss_ad_sign";
	case 879: return "sys_ss_media_id";
	case 880: return "sys_deci3_open";
	case 881: return "sys_deci3_create_event_path";
	case 882: return "sys_deci3_close";
	case 883: return "sys_deci3_send";
	case 884: return "sys_deci3_receive";
	case 885: return "sys_deci3_open2";
	case 890: return "sys_deci3_initialize";
	case 891: return "sys_deci3_terminate";
	case 892: return "sys_deci3_debug_mode";
	case 893: return "sys_deci3_show_status";
	case 894: return "sys_deci3_echo_test";
	case 895: return "sys_deci3_send_dcmp_packet";
	case 896: return "sys_deci3_dump_cp_register";
	case 897: return "sys_deci3_dump_cp_buffer";
	case 899: return "sys_deci3_test";
	case 900: return "sys_dbg_stop_processes";
	case 901: return "sys_dbg_continue_processes";
	case 902: return "sys_dbg_stop_threads";
	case 903: return "sys_dbg_continue_threads";
	case 904: return "sys_dbg_read_process_memory";
	case 905: return "sys_dbg_write_process_memory";
	case 906: return "sys_dbg_read_thread_register";
	case 907: return "sys_dbg_write_thread_register";
	case 908: return "sys_dbg_get_process_list";
	case 909: return "sys_dbg_get_thread_list";
	case 910: return "sys_dbg_get_thread_info";
	case 911: return "sys_dbg_spu_thread_read_from_ls";
	case 912: return "sys_dbg_spu_thread_write_to_ls";
	case 913: return "sys_dbg_kill_process";
	case 914: return "sys_dbg_get_process_info";
	case 915: return "sys_dbg_set_run_control_bit_to_spu";
	case 916: return "sys_dbg_spu_thread_get_exception_cause";
	case 917: return "sys_dbg_create_kernel_event_queue";
	case 918: return "sys_dbg_read_kernel_event_queue";
	case 919: return "sys_dbg_destroy_kernel_event_queue";
	case 920: return "sys_dbg_get_process_event_ctrl_flag";
	case 921: return "sys_dbg_set_process_event_cntl_flag";
	case 922: return "sys_dbg_get_spu_thread_group_event_cntl_flag";
	case 923: return "sys_dbg_set_spu_thread_group_event_cntl_flag";
	case 924: return "sys_dbg_get_module_list";
	case 925: return "sys_dbg_get_raw_spu_list";
	case 926: return "sys_dbg_initialize_scratch_executable_area";
	case 927: return "sys_dbg_terminate_scratch_executable_area";
	case 928: return "sys_dbg_initialize_scratch_data_area";
	case 929: return "sys_dbg_terminate_scratch_data_area";
	case 930: return "sys_dbg_get_user_memory_stat";
	case 931: return "sys_dbg_get_shared_memory_attribute_list";
	case 932: return "sys_dbg_get_mutex_list";
	case 933: return "sys_dbg_get_mutex_information";
	case 934: return "sys_dbg_get_cond_list";
	case 935: return "sys_dbg_get_cond_information";
	case 936: return "sys_dbg_get_rwlock_list";
	case 937: return "sys_dbg_get_rwlock_information";
	case 938: return "sys_dbg_get_lwmutex_list";
	case 939: return "sys_dbg_get_address_from_dabr";
	case 940: return "sys_dbg_set_address_to_dabr";
	case 941: return "sys_dbg_get_lwmutex_information";
	case 942: return "sys_dbg_get_event_queue_list";
	case 943: return "sys_dbg_get_event_queue_information";
	case 944: return "sys_dbg_initialize_ppu_exception_handler";
	case 945: return "sys_dbg_finalize_ppu_exception_handler";
	case 946: return "sys_dbg_get_semaphore_list";
	case 947: return "sys_dbg_get_semaphore_information";
	case 948: return "sys_dbg_get_kernel_thread_list";
	case 949: return "sys_dbg_get_kernel_thread_info";
	case 950: return "sys_dbg_get_lwcond_list";
	case 951: return "sys_dbg_get_lwcond_information";
	case 952: return "sys_dbg_create_scratch_data_area_ext";
	case 953: return "sys_dbg_vm_get_page_information";
	case 954: return "sys_dbg_vm_get_info";
	case 955: return "sys_dbg_enable_floating_point_enabled_exception";
	case 956: return "sys_dbg_disable_floating_point_enabled_exception";
	case 957: return "sys_dbg_get_process_memory_container_information";
	case 960: return "sys_control_performance_monitor";
	case 961: return "sys_performance_monitor_hidden";
	case 962: return "sys_performance_monitor_bookmark";
	case 963: return "sys_lv1_pc_trace_create";
	case 964: return "sys_lv1_pc_trace_start";
	case 965: return "sys_lv1_pc_trace_stop";
	case 966: return "sys_lv1_pc_trace_get_status";
	case 967: return "sys_lv1_pc_trace_destroy";
	case 968: return "sys_rsx_trace_ioctl";
	case 970: return "sys_dbg_get_event_flag_list";
	case 971: return "sys_dbg_get_event_flag_information";
	case 975: return "sys_dbg_read_spu_thread_context2";
	case 976: return "sys_crypto_engine_create";
	case 977: return "sys_crypto_engine_destroy";
	case 978: return "sys_crypto_engine_hasher_prepare";
	case 979: return "sys_crypto_engine_hasher_run";
	case 980: return "sys_crypto_engine_hasher_get_hash";
	case 981: return "sys_crypto_engine_cipher_prepare";
	case 982: return "sys_crypto_engine_cipher_run";
	case 983: return "sys_crypto_engine_cipher_get_hash";
	case 984: return "sys_crypto_engine_random_generate";
	case 985: return "sys_dbg_get_console_type";
	}

	return fmt::format("syscall_%llu", code);
}

// Get function name by FNID
extern std::string ppu_get_function_name(const std::string& module, u32 fnid)
{
	if (module == "") switch (fnid)
	{
	case 0x0d10fd3f: return "module_prologue";
	case 0x330f7005: return "module_epilogue";
	case 0x3ab9a95e: return "module_exit";
	case 0xbc9a0086: return "module_start";
	case 0xab779874: return "module_stop";
	}

	// Check known FNIDs
	if (module == "sys_libc" || module == "sys_libm") switch (fnid)
	{
	case 0x00acf0e5: return "spu_printf_finalize";
	case 0x00fb4a6b: return "spu_thread_sprintf";
	case 0x0125b2ca: return "_rand_int32_TT800";
	case 0x01508f24: return "raw_spu_write_float";
	case 0x0264f468: return "_Wctomb";
	case 0x02f4d325: return "spu_thread_read_double";
	case 0x02f52a3c: return "_filep_close_it";
	case 0x03becf3c: return "_Defloc";
	case 0x04a183fc: return "strcpy";
	case 0x04a1f19d: return "raw_spu_write_short";
	case 0x05d821c4: return "_Stoullx";
	case 0x077cdb23: return "btowc";
	case 0x07c7971d: return "_Stoldx";
	case 0x0871ffb0: return "mspace_malloc_usable_size";
	case 0x0891a3fa: return "_Tlsfree";
	case 0x09cbee1e: return "strxfrm";
	case 0x0a1d4b00: return "spu_thread_read_uint";
	case 0x0a4e2541: return "spu_thread_read_ldouble";
	case 0x0ae275a4: return "_Stolx";
	case 0x0b0d272f: return "_malloc_finalize";
	case 0x0b9d04d0: return "_Getnloc";
	case 0x0b9ecb98: return "toupper_ascii";
	case 0x0cae547f: return "raw_spu_write_double";
	case 0x0d2a593b: return "srand";
	case 0x0d8a2de0: return "_CStrxfrm";
	case 0x0df8809f: return "__call_functions_registered_with_atexit";
	case 0x0f60eb63: return "vfwscanf";
	case 0x0ff4722c: return "raw_spu_read_ushort";
	case 0x1096f8f1: return "ispunct_ascii";
	case 0x1098a99d: return "localeconv";
	case 0x112ea8ea: return "strspn";
	case 0x115e2f70: return "spu_thread_snprintf";
	case 0x116cda13: return "wcstol";
	case 0x118712ea: return "islower";
	case 0x11d270d2: return "exitspawn";
	case 0x126656b7: return "_Btowc";
	case 0x128b334f: return "raw_spu_read_mem";
	case 0x12a55fb7: return "mbrtowc";
	case 0x130d20a5: return "towlower";
	case 0x1365b52a: return "fcntl";
	case 0x13808972: return "wcstok";
	case 0x14052ae0: return "absi4";
	case 0x14348b57: return "divi4";
	case 0x145853cd: return "mspace_destroy";
	case 0x15362bc9: return "spu_thread_read_long";
	case 0x153b364a: return "mkdir";
	case 0x15bdcc00: return "rand";
	case 0x15c2e29d: return "isgraph_ascii";
	case 0x17752bab: return "wcsftime";
	case 0x17bc0136: return "_Lrv2d";
	case 0x17c031d7: return "spu_thread_read_ulong";
	case 0x1855b9b1: return "setlocale";
	case 0x1895908d: return "mspace_realloc";
	case 0x18e48b5d: return "wscanf";
	case 0x18f7b77d: return "_Dnorm";
	case 0x1970cd7e: return "getpid";
	case 0x19ccbb81: return "mktime";
	case 0x1ab01ea8: return "truncate";
	case 0x1abd0985: return "div";
	case 0x1ae06860: return "wcstoumax";
	case 0x1b4c3ff0: return "atexit";
	case 0x1c0e8ab6: return "vswscanf";
	case 0x1c2ef212: return "getwc";
	case 0x1cf4d80a: return "iswalpha";
	case 0x1dcd8609: return "_Strxfrmx";
	case 0x1dd0d4c5: return "spu_printf_attach_group";
	case 0x1df4732e: return "_Getptolower";
	case 0x1e9d2b4f: return "spu_thread_read_int";
	case 0x1ecae195: return "_Vacopy";
	case 0x1f913e8d: return "chmod";
	case 0x1f925c41: return "_allocate_mapped_pages";
	case 0x206612c4: return "spu_thread_read_ptr";
	case 0x216984ed: return "spu_thread_write_long";
	case 0x216fcd2a: return "_Atrealloc";
	case 0x21807b8e: return "towctrans";
	case 0x225702e1: return "_fs_initialize";
	case 0x22b0e566: return "_Stollx";
	case 0x23d3bca7: return "_Eadd";
	case 0x242c603e: return "_Frprep";
	case 0x243b52d8: return "_Mbtowcx";
	case 0x24802244: return "iswcntrl";
	case 0x24c9e021: return "abs";
	case 0x24e230d2: return "_Wctob";
	case 0x24f6cbdd: return "clock";
	case 0x253b7210: return "_rand_real2_TT800";
	case 0x25beee5a: return "__raw_spu_printf";
	case 0x25da8fbb: return "iscntrl";
	case 0x266311a0: return "localtime";
	case 0x2677568c: return "putchar";
	case 0x26f023d5: return "ftell";
	case 0x273b9711: return "sprintf";
	case 0x28b92ebf: return "raw_spu_read_uchar";
	case 0x296bc72f: return "_FDunscale";
	case 0x2b45cb34: return "wcsrtombs";
	case 0x2b7ba4ca: return "_Tlsset";
	case 0x2b81fb7f: return "readdir";
	case 0x2bc9dee6: return "raw_spu_read_short";
	case 0x2caea755: return "_Once";
	case 0x2d067448: return "ftruncate64";
	case 0x2d17ca7f: return "_Puttxt";
	case 0x2eea9f25: return "_Esub";
	case 0x2f45d39c: return "strlen";
	case 0x2fecec13: return "getwchar";
	case 0x30fb2899: return "_Getmem";
	case 0x312be3b3: return "_malloc_init_lv2";
	case 0x313f04ab: return "raw_spu_read_char";
	case 0x329a4540: return "_WPrintf";
	case 0x32e4a30a: return "_Mtxdst";
	case 0x336b4191: return "_Getint";
	case 0x33d6ae54: return "ferror";
	case 0x344eca7e: return "_WGetstr";
	case 0x34dd6650: return "_Getcloc";
	case 0x34e7c97e: return "_Unlocksyslock";
	case 0x3512ad38: return "tmpnam";
	case 0x355fd1fd: return "mbtowc";
	case 0x3574d37d: return "_Wcsxfrmx";
	case 0x36c067c1: return "_Stoll";
	case 0x36f2b4ed: return "strtoull";
	case 0x36feb965: return "raw_spu_write_llong";
	case 0x3704840e: return "_fs_finalize";
	case 0x38426d25: return "_Wctombx";
	case 0x3902363a: return "malloc_footprint";
	case 0x39bf419c: return "valloc";
	case 0x3a210c93: return "swscanf";
	case 0x3a840ae3: return "snprintf";
	case 0x3b22e88a: return "isxdigit";
	case 0x3b8097ac: return "_WScanf";
	case 0x3bce073b: return "putc";
	case 0x3bd9ce0a: return "fsync";
	case 0x3ca81c76: return "_Iswctype";
	case 0x3d1460e9: return "_Strerror";
	case 0x3d541975: return "atoi";
	case 0x3d5fdea7: return "vfwprintf";
	case 0x3d85d6f8: return "strcmp";
	case 0x3dbc3bee: return "opendir";
	case 0x3e57dfac: return "_Genld";
	case 0x3ec99a66: return "_Getptimes";
	case 0x3ee29d0b: return "_Stof";
	case 0x3f125e2e: return "spu_thread_write_short";
	case 0x3f4ccdc7: return "isdigit";
	case 0x3f650700: return "mspace_is_heap_empty";
	case 0x40a2599a: return "atol";
	case 0x40d04e4e: return "fwide";
	case 0x40e0ff25: return "_WGenld";
	case 0x41283333: return "isdigit_ascii";
	case 0x418bdfe1: return "_get_fd";
	case 0x4217b4cf: return "difftime";
	case 0x433fe2a9: return "fwscanf";
	case 0x44115dd0: return "_Geterrno";
	case 0x44796e5c: return "strerror";
	case 0x449317ed: return "_Fopen";
	case 0x44d7cae8: return "raw_spu_read_float";
	case 0x4544c2de: return "spu_thread_write_mem";
	case 0x4569518c: return "malloc_stats";
	case 0x459072c3: return "_init_TT800";
	case 0x4595c42b: return "wcsxfrm";
	case 0x468b45dc: return "mspace_calloc";
	case 0x4911ff9c: return "rand_int31_TT800";
	case 0x498a5036: return "raw_spu_write_mem";
	case 0x4a0049c6: return "_Getpctype";
	case 0x4ab5fbe2: return "_Printf";
	case 0x4b36c0e0: return "vfscanf";
	case 0x4b6a4010: return "vswprintf";
	case 0x4bb8e2b2: return "raw_spu_write_ushort";
	case 0x4c3f5f29: return "_Getgloballocale";
	case 0x4c7dc863: return "iswupper";
	case 0x4d348427: return "fputs";
	case 0x4e4be299: return "longjmp";
	case 0x4e72f810: return "wmemchr";
	case 0x4ffba189: return "feof";
	case 0x508196b4: return "raw_spu_printf";
	case 0x508e00c6: return "_Getloc";
	case 0x51b28904: return "_Stodx";
	case 0x526a496a: return "write";
	case 0x532b03be: return "raw_spu_read_uint";
	case 0x53eb43a1: return "_Getpmbstate";
	case 0x54b383bc: return "_Locvar";
	case 0x54c2844e: return "spu_raw_snprintf";
	case 0x54f57626: return "rewind";
	case 0x5516bbbf: return "iswctype";
	case 0x55d4866e: return "fgetws";
	case 0x5751acf9: return "_LDscale";
	case 0x575fb268: return "wctrans";
	case 0x57ff7dd7: return "_WStod";
	case 0x58320830: return "_WLitob";
	case 0x589b5314: return "strncat";
	case 0x5909e3c4: return "memset";
	case 0x59640bc6: return "raw_spu_read_ullong";
	case 0x59c1bb1f: return "_Getpwcstate";
	case 0x59e8dd58: return "strtoll";
	case 0x5a74f774: return "spu_thread_read_float";
	case 0x5b162b7f: return "memmove";
	case 0x5b4b6d6d: return "wcspbrk";
	case 0x5cc71eee: return "raw_spu_write_ldouble";
	case 0x5d43c1a3: return "_Mbtowc";
	case 0x5dbceee3: return "rand_int32_TT800";
	case 0x5e06c3fe: return "__getpid";
	case 0x5e7888f0: return "bsearch";
	case 0x5eb95641: return "_Stold";
	case 0x5f922a30: return "_Dscale";
	case 0x5f9a65c7: return "_WStold";
	case 0x5fa1e497: return "_Unlockfilelock";
	case 0x60627fb3: return "_LDunscale";
	case 0x6075a3c6: return "_Ld2rv";
	case 0x609080ec: return "isspace_ascii";
	case 0x6137d196: return "memalign";
	case 0x6287ac6a: return "iswdigit";
	case 0x62bf1d6c: return "swprintf";
	case 0x64aaf016: return "raw_spu_read_ldouble";
	case 0x6514dbe5: return "wcstold";
	case 0x6539ff6d: return "_Gentime";
	case 0x6545b7de: return "fgetpos";
	case 0x65e8d4d0: return "wcslen";
	case 0x6660fc8d: return "TlsGetValue";
	case 0x6687fba4: return "_Fgpos";
	case 0x66b71b17: return "wcsspn";
	case 0x67582370: return "spu_thread_write_double";
	case 0x676e3e7a: return "raw_spu_write_ptr";
	case 0x67d6334b: return "strtof";
	case 0x6823c180: return "iswprint";
	case 0x69106fd2: return "_init_by_array_TT800";
	case 0x692b497f: return "perror";
	case 0x6995f5e8: return "_Ldtob";
	case 0x69c27c12: return "fopen";
	case 0x69ff1b9b: return "fseek";
	case 0x6ba10474: return "_Tlsalloc";
	case 0x6cf78f3e: return "_Mtxunlock";
	case 0x6d5115b0: return "wcsncmp";
	case 0x6e988e5f: return "_rand_int31_TT800";
	case 0x7028dea9: return "_Locksyslock";
	case 0x703ec767: return "setvbuf";
	case 0x70b0e833: return "mblen";
	case 0x714c9618: return "__raw_spu_putfld";
	case 0x717b2502: return "stat";
	case 0x72236cbc: return "raw_spu_write_ullong";
	case 0x72b84004: return "spu_printf_attach_thread";
	case 0x73096858: return "wctob";
	case 0x7345b4be: return "_WStoll";
	case 0x73eae03d: return "strrchr";
	case 0x744d2505: return "ispunct";
	case 0x74fe4a7b: return "iswgraph";
	case 0x759e0635: return "malloc";
	case 0x75d4485c: return "rename";
	case 0x75f98579: return "wcscoll";
	case 0x76da0c84: return "ftruncate";
	case 0x76ed4243: return "_Wcsftime";
	case 0x770bfaee: return "wctype";
	case 0x77a602dd: return "free";
	case 0x77c15441: return "_WGetfloat";
	case 0x77e241bc: return "_Skip";
	case 0x7817edf0: return "raw_spu_write_uint";
	case 0x783636d1: return "spu_thread_read_char";
	case 0x78429d81: return "putwchar";
	case 0x79819dbf: return "fputc";
	case 0x7994c28d: return "_FDtentox";
	case 0x79eadf05: return "malloc_usable_size";
	case 0x7aaab95c: return "iswblank";
	case 0x7ae82e0f: return "vsprintf";
	case 0x7aee5acd: return "_Lockfilelock";
	case 0x7b5aac20: return "spu_thread_write_ptr";
	case 0x7b7a687a: return "_WPutfld";
	case 0x7b9c592e: return "spu_thread_read_ullong";
	case 0x7c1bcf37: return "isalnum_ascii";
	case 0x7c370679: return "_Foprep";
	case 0x7cec7b39: return "_Putfld";
	case 0x7d894764: return "_Readloc";
	case 0x7e7017b1: return "rmdir";
	case 0x7ea8d860: return "spu_printf_detach_group";
	case 0x7efd420a: return "_Daysto";
	case 0x7fd325c4: return "mspace_malloc_stats";
	case 0x7fdcf73e: return "wcscat";
	case 0x806fd281: return "isblank_ascii";
	case 0x809a143f: return "kill";
	case 0x813a9666: return "ungetwc";
	case 0x814d8cb0: return "fflush";
	case 0x81a0a858: return "_memset_int";
	case 0x82a3cc30: return "wcschr";
	case 0x82a4561a: return "_put_fd";
	case 0x831d70a5: return "memcpy";
	case 0x8342b757: return "utime";
	case 0x84378ddc: return "wcsncpy";
	case 0x86532174: return "imaxdiv";
	case 0x867275d7: return "_Stoul";
	case 0x86b4c669: return "tolower_ascii";
	case 0x8713c859: return "link";
	case 0x8725a1a7: return "_memset_vmx";
	case 0x87e8f748: return "memset_vmx";
	case 0x8809cdfd: return "_Getpwctytab";
	case 0x882689f2: return "_Makeloc";
	case 0x882e7760: return "raw_spu_write_uchar";
	case 0x889d5804: return "_Dunscale";
	case 0x88e009f5: return "vwprintf";
	case 0x896e1bfd: return "spu_thread_write_uchar";
	case 0x89b62f56: return "_Etentox";
	case 0x89f6f026: return "time";
	case 0x8a6830e7: return "abort";
	case 0x8a71132c: return "remove";
	case 0x8a847b51: return "tmpfile";
	case 0x8ab0abc6: return "strncpy";
	case 0x8b439438: return "clearerr";
	case 0x8b9d8dd2: return "iswpunct";
	case 0x8cb6bfdc: return "_Locsum";
	case 0x8d7ffaf1: return "_WStopfx";
	case 0x8e2484f1: return "_Emul";
	case 0x8ed71e8b: return "_WGetfld";
	case 0x8ef85e47: return "_WPuttxt";
	case 0x8f5dd179: return "_Nnl";
	case 0x90010029: return "gets";
	case 0x9027fd99: return "_WStoldx";
	case 0x90457fe3: return "raw_spu_read_long";
	case 0x90b27880: return "strtoumax";
	case 0x9234f738: return "raw_spu_read_int";
	case 0x93427cb9: return "setbuf";
	case 0x938bfcf7: return "spu_thread_write_char";
	case 0x93a3e3ac: return "tolower";
	case 0x9439e4cd: return "wcsncat";
	case 0x96b6baa6: return "spu_thread_read_mem";
	case 0x96e6303b: return "_WStoxflt";
	case 0x96ea4de6: return "wctomb";
	case 0x97896359: return "isspace";
	case 0x9800573c: return "_WLdtob";
	case 0x980d3ea7: return "_Getfld";
	case 0x9886810c: return "_FDnorm";
	case 0x98f0eeab: return "raw_spu_write_ulong";
	case 0x99782342: return "strncasecmp_ascii";
	case 0x99a72146: return "vsnprintf";
	case 0x99b38ce7: return "wmemmove";
	case 0x9a87bb3a: return "_Getmbcurmax";
	case 0x9abe8c74: return "wprintf";
	case 0x9c7028a5: return "spu_thread_write_uint";
	case 0x9c9d7b0d: return "strtold";
	case 0x9cab08d1: return "spu_thread_write_int";
	case 0x9d140351: return "_Destroytls";
	case 0x9eb25e00: return "strcoll";
	case 0x9eee5387: return "truncate64";
	case 0x9ff08d57: return "_Clearlocks";
	case 0xa0ab76d5: return "_absi4";
	case 0xa0bc0efb: return "mallinfo";
	case 0xa0ddba8e: return "_Stoulx";
	case 0xa1dbb466: return "_Gettime";
	case 0xa2945229: return "_WGetint";
	case 0xa30d4797: return "wcstoll";
	case 0xa3440924: return "closedir";
	case 0xa3da58f6: return "rand_real1_TT800";
	case 0xa45a0313: return "mspace_create";
	case 0xa483d50d: return "_rv2d";
	case 0xa53800c2: return "_malloc_finalize_lv2";
	case 0xa568db82: return "spu_thread_read_ushort";
	case 0xa57cc615: return "iswspace";
	case 0xa5bc0e19: return "getchar";
	case 0xa6463518: return "__rename";
	case 0xa650df19: return "toupper";
	case 0xa65886b8: return "_Findloc";
	case 0xa72a7595: return "calloc";
	case 0xa797790f: return "wcsstr";
	case 0xa82d70da: return "_Tlsget";
	case 0xa835be11: return "__cxa_atexit";
	case 0xa874036a: return "wcstof";
	case 0xa8a6f615: return "TlsSetValue";
	case 0xa8b07f1b: return "wmemcpy";
	case 0xa9f68eff: return "qsort";
	case 0xaa1e687d: return "isgraph";
	case 0xaa266d35: return "_malloc_init";
	case 0xaa9635d7: return "strcat";
	case 0xab4c7ca1: return "_CWcsxfrm";
	case 0xab77019f: return "fstat";
	case 0xabc27420: return "wcstoul";
	case 0xac758d20: return "wmemcmp";
	case 0xac893127: return "fgetc";
	case 0xace90be4: return "_Dtentox";
	case 0xad62a342: return "ldiv";
	case 0xad8e9ad0: return "_Initlocks";
	case 0xaec7c970: return "lseek";
	case 0xaf002043: return "independent_comalloc";
	case 0xaf44a615: return "fgets";
	case 0xaf6bdcb0: return "_Nonfatal_Assert";
	case 0xaf89fdbd: return "_Assert";
	case 0xafa39179: return "_WPutstr";
	case 0xb120f6ca: return "close";
	case 0xb17b79d0: return "isalpha";
	case 0xb18cc115: return "freopen";
	case 0xb1cc43e3: return "_CStrftime";
	case 0xb1f4779d: return "spu_thread_printf";
	case 0xb24cb8d6: return "_Locterm";
	case 0xb2702e15: return "wcrtomb";
	case 0xb2748a9f: return "_Freeloc";
	case 0xb30042ce: return "lldiv";
	case 0xb37982ea: return "_Getstr";
	case 0xb3c495bd: return "imaxabs";
	case 0xb3d98d59: return "_rand_real1_TT800";
	case 0xb400f226: return "isupper_ascii";
	case 0xb4225825: return "mbsinit";
	case 0xb43c25c7: return "wcstoull";
	case 0xb49eea74: return "_init_malloc_lock0";
	case 0xb4a54446: return "_Stofx";
	case 0xb4fc7078: return "_close_all_FILE";
	case 0xb529d259: return "isalnum";
	case 0xb569849d: return "reallocalign";
	case 0xb57bdf7b: return "iswxdigit";
	case 0xb5d353e8: return "_LDtentox";
	case 0xb6002508: return "_Putstr";
	case 0xb6257e3d: return "strncasecmp";
	case 0xb680e240: return "wcstombs";
	case 0xb6af290e: return "_WFrprep";
	case 0xb6d92ac3: return "strcasecmp";
	case 0xb738027a: return "strtok_r";
	case 0xb794631e: return "_WStofx";
	case 0xb7ab5127: return "wcsrchr";
	case 0xb7b793ed: return "get_state_TT800";
	case 0xb7ba4aeb: return "_WStoul";
	case 0xb7d3427f: return "iscntrl_ascii";
	case 0xb81cd66a: return "mbrlen";
	case 0xb9ed25d4: return "raw_spu_read_ulong";
	case 0xba62681f: return "mspace_memalign";
	case 0xbb605c96: return "pvalloc";
	case 0xbbd4582f: return "_Setloc";
	case 0xbc1d69c5: return "atoll";
	case 0xbc374779: return "_Getlname";
	case 0xbc5af0b5: return "fgetwc";
	case 0xbc7b4b8e: return "ctime";
	case 0xbe11beaa: return "_wremove";
	case 0xbe251a29: return "islower_ascii";
	case 0xbe6e5c58: return "spu_thread_read_uchar";
	case 0xbec43f86: return "raw_spu_read_ptr";
	case 0xbf5bf5ea: return "lseek64";
	case 0xbfcd1b3b: return "_Getdst";
	case 0xc01d9f97: return "printf";
	case 0xc08cc41d: return "wcstod";
	case 0xc0e27b2c: return "_Makestab";
	case 0xc155a73f: return "_WStoull";
	case 0xc15e657e: return "spu_raw_sprintf";
	case 0xc1a71972: return "_d2rv";
	case 0xc1b4bbb9: return "raw_spu_write_char";
	case 0xc1c8737c: return "_Getptoupper";
	case 0xc291e698: return "exit";
	case 0xc3c598e2: return "spu_printf_initialize";
	case 0xc3e14cbe: return "memcmp";
	case 0xc4178000: return "_rand_real3_TT800";
	case 0xc41c6e5d: return "_Scanf";
	case 0xc57337f8: return "_Fofind";
	case 0xc5c09834: return "strstr";
	case 0xc63c354f: return "_Exit";
	case 0xc69b2427: return "labs";
	case 0xc78df618: return "rand_real3_TT800";
	case 0xc7b62ab8: return "spu_thread_write_ullong";
	case 0xc9471fac: return "_Mtxinit";
	case 0xc94b27e3: return "_WStof";
	case 0xc95b20d3: return "fputwc";
	case 0xc9607d35: return "_Stopfx";
	case 0xc97a17d7: return "vsscanf";
	case 0xcab654bf: return "_Once_ctor";
	case 0xcb85ac70: return "mspace_malloc";
	case 0xcb9c535b: return "strftime";
	case 0xcbac7ad7: return "memchr";
	case 0xcbdc3a6d: return "raw_spu_write_int";
	case 0xcc5e0c72: return "_divi4";
	case 0xcca68e9c: return "putwc";
	case 0xce7a9e76: return "isprint_ascii";
	case 0xcecbcdc4: return "_Frv2d";
	case 0xcf863219: return "_Fwprep";
	case 0xcfbfb7a7: return "spu_printf_detach_thread";
	case 0xd14ece90: return "strtol";
	case 0xd1d69cb8: return "_Stod";
	case 0xd20f6601: return "independent_calloc";
	case 0xd2a99b1e: return "isprint";
	case 0xd2ac48d7: return "iswalnum";
	case 0xd360dcb4: return "fileno";
	case 0xd3964a09: return "__spu_thread_putfld";
	case 0xd40723d6: return "fread";
	case 0xd417eeb5: return "_Stoull";
	case 0xd4912ee3: return "_FDscale";
	case 0xd5c8cb55: return "spu_thread_write_ushort";
	case 0xd69c513d: return "_Wcscollx";
	case 0xd784459d: return "isupper";
	case 0xd7dc3a8f: return "strtod";
	case 0xd8b4eb20: return "__spu_thread_puttxt";
	case 0xd9674905: return "mspace_reallocalign";
	case 0xd9a4f812: return "atoff";
	case 0xda5a7eb8: return "strtoul";
	case 0xdaeada07: return "mallopt";
	case 0xddbac025: return "strcasecmp_ascii";
	case 0xddc71a75: return "_SCE_Assert";
	case 0xde1bb092: return "init_by_array_TT800";
	case 0xde32a334: return "_Exitspawn";
	case 0xde7aff7a: return "memcpy16";
	case 0xdebee2af: return "strchr";
	case 0xdef86a83: return "isxdigit_ascii";
	case 0xdfb52083: return "_Stoxflt";
	case 0xe03c7ab1: return "_Fspos";
	case 0xe1858899: return "_Getpwctrtab";
	case 0xe1bd3587: return "fclose";
	case 0xe1e83c65: return "strncmp";
	case 0xe2c5274a: return "_WStoflt";
	case 0xe3812672: return "fdopen";
	case 0xe3cc73f3: return "puts";
	case 0xe3d91db3: return "raw_spu_read_double";
	case 0xe40ba755: return "strtok";
	case 0xe44bf0bf: return "atof";
	case 0xe469fb20: return "_Atexit";
	case 0xe48348e9: return "vprintf";
	case 0xe4c51d4c: return "wcstoimax";
	case 0xe5ea9e2b: return "_Isdst";
	case 0xe5f09c80: return "llabs";
	case 0xe60ee9e5: return "fputws";
	case 0xe6a7de0a: return "ungetc";
	case 0xe7def231: return "_Getfloat";
	case 0xe89071ad: return "isalpha_ascii";
	case 0xe9137453: return "fwprintf";
	case 0xe9a2cc40: return "raw_spu_write_long";
	case 0xe9b560a5: return "sscanf";
	case 0xeb26298c: return "gmtime";
	case 0xeb40c9ec: return "rand_real2_TT800";
	case 0xeb8abe73: return "vwscanf";
	case 0xec9e7cb9: return "spu_thread_read_llong";
	case 0xecddba69: return "_WStodx";
	case 0xed6ec979: return "fsetpos";
	case 0xeda48c80: return "malloc_trim";
	case 0xeddcee2c: return "init_TT800";
	case 0xedec777d: return "_Ttotm";
	case 0xeeeb4f3e: return "_get_state_TT800";
	case 0xeeffc9a6: return "_wrename";
	case 0xef110b6b: return "unlink";
	case 0xf06eed36: return "wmemset";
	case 0xf0776a44: return "wcscmp";
	case 0xf0e022c6: return "getc";
	case 0xf2bbbee9: return "_Litob";
	case 0xf2fca4b2: return "spu_thread_write_llong";
	case 0xf356418c: return "open";
	case 0xf3ef3678: return "wcscspn";
	case 0xf41355f9: return "wcscpy";
	case 0xf418ee84: return "_WFwprep";
	case 0xf4207734: return "spu_thread_write_ulong";
	case 0xf5a32994: return "_Getpcostate";
	case 0xf5ef229c: return "_Getpwcostate";
	case 0xf5f7dda8: return "towupper";
	case 0xf68e2ac9: return "_init_malloc_lock";
	case 0xf7583d67: return "vscanf";
	case 0xf7908e27: return "strcspn";
	case 0xf7a14a22: return "realloc";
	case 0xf7d51596: return "scanf";
	case 0xf7ddb471: return "_Setgloballocale";
	case 0xf88f26c4: return "fwrite";
	case 0xf8935fe3: return "spu_thread_write_float";
	case 0xf89dc648: return "strpbrk";
	case 0xf9dae72c: return "setjmp";
	case 0xf9dba140: return "_Mtxlock";
	case 0xf9e26b72: return "_Once_dtor";
	case 0xfa00d211: return "read";
	case 0xfae4b063: return "_Strcollx";
	case 0xfaec8c60: return "fprintf";
	case 0xfb0f0018: return "_Makewct";
	case 0xfb2081fd: return "vfprintf";
	case 0xfb81426d: return "iswlower";
	case 0xfb8ea4d2: return "_Fd2rv";
	case 0xfc0428a6: return "strdup";
	case 0xfc60575c: return "__spu_thread_printf";
	case 0xfc606237: return "mbsrtowcs";
	case 0xfcac2e8e: return "mbstowcs";
	case 0xfd0cb96d: return "spu_thread_read_short";
	case 0xfd461e85: return "spu_thread_write_ldouble";
	case 0xfd6a1ddb: return "raw_spu_read_llong";
	case 0xfd81f6ca: return "_Stoflt";
	case 0xfe0261aa: return "mspace_free";
	case 0xfe630fd9: return "isblank";
	case 0xfe88e97e: return "fscanf";
	case 0xff689124: return "strtoimax";
	case 0xffbae95e: return "asctime";
	case 0xffbd876b: return "__raw_spu_puttxt";
	case 0x003395d9: return "_Feraise";
	case 0x00367be0: return "fminl";
	case 0x007854f4: return "_FDclass";
	case 0x00fde072: return "f_powf";
	case 0x010818fc: return "asinf4";
	case 0x012d0a91: return "_fminf4";
	case 0x016556df: return "_sinf4";
	case 0x01b84b27: return "llround";
	case 0x01ecef7d: return "_FCbuild";
	case 0x02e68d44: return "_f_fmodf";
	case 0x032cc709: return "csin";
	case 0x03593d2c: return "_f_expf";
	case 0x03aea906: return "divf4";
	case 0x0522d1af: return "_recipf4";
	case 0x054aae63: return "_fdimf4";
	case 0x05cb1718: return "f_fdimf";
	case 0x05e27a13: return "log10f4fast";
	case 0x05efc660: return "asin";
	case 0x05f1dc9e: return "_FExp";
	case 0x07274304: return "csinh";
	case 0x07daed62: return "log2f4";
	case 0x07f400e3: return "_LCbuild";
	case 0x080414bd: return "conjl";
	case 0x08139bd2: return "_fmaxf4";
	case 0x0829a21d: return "asinhl";
	case 0x0a242ed5: return "sinf4";
	case 0x0b3f4e90: return "catanhf";
	case 0x0bb036a6: return "_cosf4";
	case 0x0c14cfcc: return "fesetenv";
	case 0x0c9b8305: return "hypotf4";
	case 0x0cbdae68: return "sinf";
	case 0x0cf9b8bd: return "_Erfc";
	case 0x0d86295d: return "_LCaddcr";
	case 0x0e53319f: return "_asinf4";
	case 0x0e8573dc: return "expm1l";
	case 0x0f02f882: return "llrintl";
	case 0x0f428f0f: return "rint";
	case 0x0f721a9d: return "_LCsubcc";
	case 0x10627248: return "f_fmodf";
	case 0x11c51388: return "tgamma";
	case 0x1225dd31: return "casinf";
	case 0x12de4e46: return "_powf4";
	case 0x12e04cd7: return "cimagl";
	case 0x1313a420: return "acos";
	case 0x137f7e77: return "expf4";
	case 0x14208b00: return "_asinf4fast";
	case 0x1498a072: return "_Cmulcr";
	case 0x16bf208a: return "log10f";
	case 0x17316bee: return "log2";
	case 0x178d98dd: return "atanf4fast";
	case 0x17cd5d87: return "_recipf4fast";
	case 0x182cd542: return "tgammal";
	case 0x18668ce3: return "exp";
	case 0x18b26998: return "remainderl";
	case 0x18ec6099: return "rintl";
	case 0x1988732d: return "clog10";
	case 0x1a1adede: return "rsqrtf4fast";
	case 0x1acb2b16: return "acosf4";
	case 0x1bbdcd9f: return "expm1f4";
	case 0x1bcdeb47: return "_LSinh";
	case 0x1be996cc: return "_LCdivcc";
	case 0x1c11885d: return "_floorf4";
	case 0x1d35bfe4: return "_LLog";
	case 0x1d5bf5d0: return "_modff4";
	case 0x1e623f95: return "truncf4";
	case 0x1e85ef02: return "f_atanf";
	case 0x1e9fd6ba: return "_sinf4fast";
	case 0x2033eeb7: return "csqrt";
	case 0x2118fe46: return "cexpl";
	case 0x21a37b3e: return "log1pf";
	case 0x21e6d304: return "ceil";
	case 0x22c3e308: return "_exp2f4";
	case 0x238af59b: return "fegetenv";
	case 0x23b985f7: return "floorf";
	case 0x241f9337: return "_FCmulcr";
	case 0x24497c52: return "cosf";
	case 0x246ea8d0: return "f_sqrtf";
	case 0x2627d6b2: return "erfc";
	case 0x266d2473: return "_Caddcr";
	case 0x26deed0b: return "cosl";
	case 0x26ef50ed: return "asinh";
	case 0x28faaa5a: return "ilogbf4";
	case 0x29685118: return "_negatef4";
	case 0x2a138d2b: return "truncf";
	case 0x2a4dcbad: return "cacosl";
	case 0x2a89ce33: return "llrintf";
	case 0x2af4b73b: return "fmax";
	case 0x2b282ebb: return "sqrtl";
	case 0x2bb0f2c9: return "logb";
	case 0x2c45fe6a: return "fmaxl";
	case 0x2c601f3b: return "csinl";
	case 0x2cbb6f53: return "f_hypotf";
	case 0x2dcab6a4: return "nanl";
	case 0x2df339bc: return "_f_floorf";
	case 0x2e69bb2a: return "_FCosh";
	case 0x2ec867b4: return "exp2f4fast";
	case 0x30bc7a53: return "logf4";
	case 0x315673f6: return "_Csubcc";
	case 0x31be25c3: return "scalblnf";
	case 0x31db8c89: return "atan2";
	case 0x321c55de: return "nexttowardl";
	case 0x3261de11: return "fesetexceptflag";
	case 0x329ec019: return "rsqrtf4";
	case 0x32f994a1: return "cosf4fast";
	case 0x33e5929b: return "_LDsign";
	case 0x33f27f25: return "_FCdivcr";
	case 0x3436f008: return "csinhf";
	case 0x3459748b: return "log10f4";
	case 0x347c1ee1: return "atanf4";
	case 0x34c0371e: return "powl";
	case 0x358d7f93: return "_f_lrintf";
	case 0x3593a445: return "clog";
	case 0x35b6e70a: return "lrintl";
	case 0x35d3f688: return "creal";
	case 0x36778d1b: return "coshf";
	case 0x373054d1: return "cpow";
	case 0x37345541: return "log1pl";
	case 0x376fb27f: return "sinhl";
	case 0x3792b12d: return "lroundl";
	case 0x38ba5590: return "ccosl";
	case 0x38e69f09: return "pow";
	case 0x398483aa: return "_expm1f4fast";
	case 0x39ef81c9: return "f_fmaxf";
	case 0x3ad203fa: return "lrint";
	case 0x3adc01d7: return "f_frexpf";
	case 0x3b802524: return "ldexpf4";
	case 0x3c057fbd: return "atanf";
	case 0x3c616743: return "_LDtest";
	case 0x3cb818fa: return "_f_fdimf";
	case 0x3d4efafb: return "atan2l";
	case 0x3d549f2a: return "ctanhl";
	case 0x3d901a10: return "_ceilf4";
	case 0x3da55602: return "fabsf";
	case 0x3dfa060f: return "scalbnl";
	case 0x3e7eb58f: return "frexpf4";
	case 0x3e919cba: return "scalbnf";
	case 0x3ec9de23: return "_cbrtf4";
	case 0x3eeedb0e: return "_Dclass";
	case 0x3f6262b3: return "f_fminf";
	case 0x3f701e78: return "_Poly";
	case 0x4020f5ef: return "cbrt";
	case 0x405f9727: return "_log1pf4fast";
	case 0x40a2e212: return "_fabsf4";
	case 0x4111b546: return "_LExp";
	case 0x411434bb: return "asinf";
	case 0x414c5ecc: return "_f_hypotf";
	case 0x4152669c: return "scalbln";
	case 0x417851ce: return "feholdexcept";
	case 0x418036e3: return "_FTgamma";
	case 0x4189a367: return "remquo";
	case 0x41d1b236: return "_f_rintf";
	case 0x430309a1: return "ldexpf";
	case 0x434881a0: return "cacosf";
	case 0x43d522f4: return "cabsl";
	case 0x44cd6308: return "remainder";
	case 0x44cf744b: return "tanhl";
	case 0x45034943: return "nan";
	case 0x452ac4bb: return "floorf4";
	case 0x453f9e91: return "cbrtf";
	case 0x46b66f76: return "csqrtl";
	case 0x46cf72d9: return "fdimf";
	case 0x47433144: return "expm1f4fast";
	case 0x475d855b: return "trunc";
	case 0x476b5591: return "fmaf";
	case 0x48157605: return "_f_llrintf";
	case 0x4826db61: return "fma";
	case 0x4875601d: return "_exp2f4fast";
	case 0x487bbd1c: return "tanf4";
	case 0x488df791: return "cexp";
	case 0x48d462a9: return "_FDint";
	case 0x4930ac11: return "logbl";
	case 0x4a5ae27d: return "f_exp2f";
	case 0x4a6ca9a6: return "powf4";
	case 0x4ab22a63: return "_Caddcc";
	case 0x4add664c: return "feclearexcept";
	case 0x4ae52dd3: return "exp2";
	case 0x4b03d5b2: return "f_rintf";
	case 0x4b584841: return "f_asinf";
	case 0x4cb5fa99: return "nexttoward";
	case 0x4d878773: return "remainderf4";
	case 0x4ddb926b: return "powf";
	case 0x4e010403: return "copysign";
	case 0x4eb5eb51: return "sin";
	case 0x4fa4f5ec: return "nexttowardf";
	case 0x501c412f: return "cargf";
	case 0x519ebb77: return "floor";
	case 0x547fb4a7: return "sinf4fast";
	case 0x54d2fb8c: return "rintf";
	case 0x5516d621: return "acosl";
	case 0x55c8a549: return "truncl";
	case 0x56c573a8: return "log1p";
	case 0x575e9b6e: return "asinl";
	case 0x58eb9e57: return "fabs";
	case 0x596ab55c: return "atanh";
	case 0x5b18eded: return "clogl";
	case 0x5b474c22: return "casinhl";
	case 0x5bfd37be: return "_FCaddcc";
	case 0x5e48dede: return "exp2f4";
	case 0x5ee10a95: return "catanh";
	case 0x5ee37927: return "_LErfc";
	case 0x60e9ff3c: return "_expm1f4";
	case 0x61250988: return "catanl";
	case 0x6261c0b5: return "_log10f4";
	case 0x63bbdfa6: return "_FCmulcc";
	case 0x642e3d18: return "_frexpf4";
	case 0x642f7d6b: return "f_copysignf";
	case 0x645557bd: return "copysignl";
	case 0x64abdb4d: return "csinhl";
	case 0x657d0e83: return "divf4fast";
	case 0x65935877: return "ilogbf";
	case 0x659e011e: return "sqrt";
	case 0x6636c4a5: return "frexpf";
	case 0x664e04b9: return "negatef4";
	case 0x6764c707: return "f_log2f";
	case 0x683cacb3: return "sinh";
	case 0x68a8957f: return "casinhf";
	case 0x68f72416: return "nextafterl";
	case 0x69040b9b: return "logbf4";
	case 0x69725dce: return "lgamma";
	case 0x6ad1c42b: return "_sincosf4";
	case 0x6b660894: return "_acosf4fast";
	case 0x6b6ab2a9: return "_LDclass";
	case 0x6c009c56: return "f_log10f";
	case 0x6c6285c6: return "acoshf";
	case 0x6cc4bd13: return "casinh";
	case 0x6ddd31b2: return "hypot";
	case 0x6df35518: return "floorl";
	case 0x6e9eb0dc: return "sincosf4fast";
	case 0x6ef6b083: return "_FCsubcr";
	case 0x6f5dd7d2: return "cexpf";
	case 0x6f639afb: return "f_llroundf";
	case 0x6fcc1e27: return "_FPoly";
	case 0x70357b12: return "_atanf4fast";
	case 0x7048396e: return "carg";
	case 0x705d9e24: return "f_acosf";
	case 0x70f71871: return "_FCdivcc";
	case 0x71293b71: return "_FLog";
	case 0x714adce1: return "log";
	case 0x71f2bc56: return "_divf4fast";
	case 0x728149e5: return "f_ldexpf";
	case 0x729b7269: return "cproj";
	case 0x72a3ed28: return "fesettrapenable";
	case 0x72f1f64b: return "_logbf4";
	case 0x734ca589: return "_f_cosf";
	case 0x742f12b4: return "_Sin";
	case 0x74902d4b: return "expf4fast";
	case 0x749440f9: return "lgammal";
	case 0x752fa85e: return "fmaxf4";
	case 0x758f33dc: return "nearbyint";
	case 0x75e3e2e9: return "nearbyintl";
	case 0x76afaf04: return "_sqrtf4";
	case 0x76e639ec: return "_atanf4";
	case 0x772f1e4d: return "lround";
	case 0x7793a86b: return "ctanf";
	case 0x7831a2e0: return "hypotl";
	case 0x78e4590a: return "acosh";
	case 0x790c53bd: return "_Fpcomp";
	case 0x7919f414: return "_f_nearbyintf";
	case 0x79ba9b5c: return "expl";
	case 0x7a893af1: return "_rsqrtf4";
	case 0x7ab679da: return "f_cosf";
	case 0x7c2eaeb5: return "fminf";
	case 0x7d02a5ca: return "sqrtf4fast";
	case 0x7d6191d0: return "_Cosh";
	case 0x7f381837: return "frexp";
	case 0x7f579e03: return "atan";
	case 0x7f91cd41: return "tanf4fast";
	case 0x812ed488: return "cabsf";
	case 0x81daf880: return "_LCsubcr";
	case 0x8217e783: return "cosh";
	case 0x833e6b0e: return "cimag";
	case 0x834f5917: return "ccosh";
	case 0x842cb14d: return "_log1pf4";
	case 0x8451edf0: return "sqrtf";
	case 0x889cccb0: return "llroundl";
	case 0x88fb4a66: return "recipf4fast";
	case 0x892f2590: return "fegetround";
	case 0x895cdb49: return "fmaxf";
	case 0x89b507b3: return "catanhl";
	case 0x89d1d168: return "_LAtan";
	case 0x8b168769: return "fdiml";
	case 0x8bd1deb2: return "_LTgamma";
	case 0x8bd67efc: return "erf";
	case 0x8c85369b: return "_f_fminf";
	case 0x8d5858db: return "_f_exp2f";
	case 0x8e01379e: return "cacoshf";
	case 0x8e258fa0: return "cacos";
	case 0x8ecae294: return "nextafter";
	case 0x8f2bcdb5: return "_logf4";
	case 0x8f96319e: return "log10l";
	case 0x8fb7bac7: return "_sqrtf4fast";
	case 0x904e646b: return "cargl";
	case 0x90f0242f: return "_f_sinf";
	case 0x9110708a: return "modfl";
	case 0x91cdfdb0: return "asinf4fast";
	case 0x9232baea: return "_FDtest";
	case 0x9245e01b: return "_divf4";
	case 0x9379e36e: return "tanf";
	case 0x938fb946: return "_tanf4fast";
	case 0x947ae18e: return "_LHypot";
	case 0x9558ed08: return "lrintf";
	case 0x95dfecb1: return "_FCsubcc";
	case 0x961688d1: return "f_nearbyintf";
	case 0x9616e336: return "_FHypot";
	case 0x964ac044: return "creall";
	case 0x96d1b95e: return "log2f4fast";
	case 0x9700d9cd: return "clogf";
	case 0x970a3432: return "cacosh";
	case 0x99a6c261: return "catanf";
	case 0x99c228fc: return "roundl";
	case 0x9a81e583: return "fmodf";
	case 0x9af30eaf: return "casin";
	case 0x9e289062: return "_f_ceilf";
	case 0x9e3ada21: return "logl";
	case 0x9e8130b6: return "ccos";
	case 0x9f03dd3e: return "lgammaf";
	case 0x9f0efc6e: return "exp2l";
	case 0x9f46f5a4: return "tgammaf";
	case 0x9f65bd34: return "fdimf4";
	case 0x9f78f052: return "cos";
	case 0x9fded78a: return "_acosf4";
	case 0xa0160c30: return "_copysignf4";
	case 0xa20827a8: return "ctanl";
	case 0xa2c81938: return "_LSin";
	case 0xa4578433: return "fmin";
	case 0xa46a70a1: return "atanhl";
	case 0xa4ca5cf2: return "llroundf";
	case 0xa56557b6: return "catan";
	case 0xa5d0b260: return "acoshl";
	case 0xa713f8cf: return "modf";
	case 0xa7658186: return "log1pf4";
	case 0xa823836b: return "ilogb";
	case 0xa8c16038: return "_FDsign";
	case 0xa8d180e8: return "_Cbuild";
	case 0xa92bcc85: return "cabs";
	case 0xa9e039c4: return "erfcf";
	case 0xaaa270dc: return "_LCdivcr";
	case 0xab377381: return "log2f";
	case 0xabdccc7a: return "f_atan2f";
	case 0xacca2f83: return "copysignf";
	case 0xad17e787: return "_Dint";
	case 0xad3a093d: return "_LCosh";
	case 0xad5d3e57: return "_FLgamma";
	case 0xaddce673: return "erfcl";
	case 0xafa13040: return "f_llrintf";
	case 0xafcfdad7: return "_Lgamma";
	case 0xafd9a625: return "cimagf";
	case 0xb0fa1592: return "clog10l";
	case 0xb24bd2f8: return "logbf";
	case 0xb348c5c2: return "_LLgamma";
	case 0xb412a8dc: return "_LDint";
	case 0xb4ef29d5: return "f_floorf";
	case 0xb4f4513e: return "_Tgamma";
	case 0xb54cc9a1: return "f_sinf";
	case 0xb5961d4e: return "_sincosf4fast";
	case 0xb598a495: return "fmodl";
	case 0xb5e28191: return "_FSin";
	case 0xb7696143: return "nextafterf";
	case 0xb79012ba: return "modff";
	case 0xb89863bc: return "_rsqrtf4fast";
	case 0xb8aa984e: return "_expf4";
	case 0xb94b9d13: return "_Dtest";
	case 0xb9d2ad22: return "remquol";
	case 0xba136594: return "csinf";
	case 0xba84eab5: return "coshl";
	case 0xbaf11866: return "ceilf";
	case 0xbb165807: return "expm1f";
	case 0xbb208b20: return "cbrtf4fast";
	case 0xbb761c89: return "remquof";
	case 0xbbaa300b: return "f_log1pf";
	case 0xbbf7354e: return "fegetexceptflag";
	case 0xbd7410d9: return "recipf4";
	case 0xbd8bb75c: return "asinhf";
	case 0xbf23f2e7: return "cprojl";
	case 0xbfda6837: return "_f_log10f";
	case 0xc0609820: return "nearbyintf";
	case 0xc0bcf25e: return "_logf4fast";
	case 0xc357b33a: return "frexpl";
	case 0xc406dd09: return "cbrtf4";
	case 0xc41f01db: return "fminf4";
	case 0xc477c0f6: return "f_lroundf";
	case 0xc4cccd1f: return "modff4";
	case 0xc7369fce: return "_Atan";
	case 0xc78ac9d0: return "scalbn";
	case 0xc7b45a19: return "_LFpcomp";
	case 0xc7f1d407: return "fmal";
	case 0xc7fb73d6: return "f_lrintf";
	case 0xc8910002: return "ilogbl";
	case 0xc8dd9279: return "expm1";
	case 0xc90f4bbc: return "_atan2f4";
	case 0xc9481758: return "_tanf4";
	case 0xc94fcc63: return "cbrtl";
	case 0xc977e1ea: return "fetestexcept";
	case 0xc984bf53: return "roundf";
	case 0xc9c536ce: return "_ldexpf4";
	case 0xca239640: return "fmodf4";
	case 0xca463458: return "_Log";
	case 0xcaaf7ae7: return "cprojf";
	case 0xcac167a5: return "_Cmulcc";
	case 0xcb6599c0: return "exp2f";
	case 0xcb6a147e: return "_cosf4fast";
	case 0xcbdf9afb: return "_log10f4fast";
	case 0xccc66f11: return "_FSinh";
	case 0xce91ff18: return "nanf";
	case 0xcfee82d8: return "_remainderf4";
	case 0xd0fd3ca8: return "_hypotf4";
	case 0xd125b89e: return "conjf";
	case 0xd1a3574c: return "clog10f";
	case 0xd231e30a: return "ldexpl";
	case 0xd28ef6dd: return "_Hypot";
	case 0xd2a666c9: return "ctanh";
	case 0xd3a346a8: return "tanl";
	case 0xd40f3f2c: return "erff";
	case 0xd42904b7: return "fabsl";
	case 0xd477852d: return "logf";
	case 0xd48eaae1: return "scalblnl";
	case 0xd4f37b9d: return "tanhf";
	case 0xd50277ad: return "tan";
	case 0xd54039cb: return "fegettrapenable";
	case 0xd5adc4b2: return "cpowl";
	case 0xd5d38552: return "_LCaddcc";
	case 0xd612fa16: return "_Sinh";
	case 0xd70df92a: return "_FCaddcr";
	case 0xd7653782: return "sinhf";
	case 0xd76a16da: return "_fmaf4";
	case 0xd8270894: return "fdim";
	case 0xd8c4096d: return "atan2f4";
	case 0xd8d157f5: return "f_expf";
	case 0xd8f79f4c: return "log10";
	case 0xd97852b7: return "sinl";
	case 0xd97ce5d4: return "fesetround";
	case 0xda217d1f: return "atanl";
	case 0xda31fc5d: return "_FFpcomp";
	case 0xdc14974c: return "fmaf4";
	case 0xdc151707: return "_f_log2f";
	case 0xdd8660d2: return "atan2f4fast";
	case 0xdd92118e: return "ceill";
	case 0xdddabb32: return "remainderf";
	case 0xde7833f2: return "_log2f4fast";
	case 0xdece76a6: return "acosf";
	case 0xdfd41734: return "_Exp";
	case 0xdffb4e3c: return "casinl";
	case 0xe1288c47: return "atanhf";
	case 0xe1c71b05: return "ccoshl";
	case 0xe2b596ec: return "ccosf";
	case 0xe2de89e6: return "csqrtf";
	case 0xe2f1d4b2: return "tanh";
	case 0xe31cc0d3: return "_ilogbf4";
	case 0xe3e379b8: return "_expf4fast";
	case 0xe584836c: return "_LPoly";
	case 0xe58fc9b5: return "erfl";
	case 0xe5a0be9f: return "_powf4fast";
	case 0xe5d2293f: return "_Force_raise";
	case 0xe5ea65e8: return "feraiseexcept";
	case 0xe6c1ff41: return "llrint";
	case 0xe769e5cf: return "fmod";
	case 0xe8fcf1f8: return "acosf4fast";
	case 0xe913a166: return "logf4fast";
	case 0xe92f3fb8: return "_f_fmaf";
	case 0xe93abfca: return "ctan";
	case 0xe9ac8223: return "_LCmulcr";
	case 0xe9f501df: return "crealf";
	case 0xea1e83e3: return "f_logf";
	case 0xeac62795: return "_Cdivcc";
	case 0xeac7ca2c: return "ceilf4";
	case 0xebb4e08a: return "hypotf";
	case 0xec43b983: return "_f_sqrtf";
	case 0xec7da0c8: return "_atan2f4fast";
	case 0xed05c265: return "sqrtf4";
	case 0xed9d1ac5: return "f_tanf";
	case 0xeda86c48: return "copysignf4";
	case 0xee0db701: return "_Csubcr";
	case 0xee204ac6: return "f_ceilf";
	case 0xee303936: return "_Dsign";
	case 0xeed82401: return "_f_logf";
	case 0xf0947035: return "ctanhf";
	case 0xf0ab77c1: return "ccoshf";
	case 0xf16568af: return "_FAtan";
	case 0xf19c5e94: return "sincosf4";
	case 0xf1aaa2f8: return "conj";
	case 0xf3bd7d08: return "_cbrtf4fast";
	case 0xf3ec0258: return "round";
	case 0xf4ad6ea8: return "ldexp";
	case 0xf537d837: return "_truncf4";
	case 0xf5cd1e19: return "cosf4";
	case 0xf7844153: return "_f_fmaxf";
	case 0xf83a372f: return "f_fmaf";
	case 0xf95b7769: return "powf4fast";
	case 0xf99da2fc: return "fabsf4";
	case 0xfa28434b: return "log2l";
	case 0xfa765d42: return "_Cdivcr";
	case 0xfa97afbf: return "feupdateenv";
	case 0xfae9e727: return "_f_copysignf";
	case 0xfb6e6213: return "log1pf4fast";
	case 0xfb932a56: return "atan2f";
	case 0xfbb4047a: return "lroundf";
	case 0xfbe88922: return "_FErfc";
	case 0xfcedabc3: return "_fmodf4";
	case 0xfcf08193: return "expf";
	case 0xfdec16e1: return "cacoshl";
	case 0xfe23dbe9: return "_log2f4";
	case 0xff036800: return "cpowf";
	case 0xfffe79bf: return "_LCmulcc";
	}

	if (module == "sys_libstdcxx") switch (fnid)
	{
	case 0x002c338b: return "_ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE16do_get_monthnameES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0x002e18d8: return "_ZNSt6locale7_LocimpD0Ev";
	case 0x0091a3fd: return "_ZNKSt6locale9_GetfacetEj";
	case 0x00c3975e: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE5_LockEv";
	case 0x00cf44f7: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecl";
	case 0x01409785: return "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE7_GetintERS3_S5_iiRi";
	case 0x01aa0cef: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERx";
	case 0x01c4ef01: return "_ZNSt6localeC2ERKS_S1_i";
	case 0x01d9b3f5: return "_ZNSt6localeC1EPKci";
	case 0x01f81190: return "_ZNSt12codecvt_baseD1Ev";
	case 0x020b22f3: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewPKv";
	case 0x02e40598: return "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE5_InitERKSt8_Locinfo";
	case 0x03217f6f: return "_ZNSt19istreambuf_iteratorIcSt11char_traitsIcEE5_PeekEv";
	case 0x0339259c: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecPKv";
	case 0x033c18f4: return "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev";
	case 0x03cca12f: return "_ZNSt6localeC1ERKS_PKci";
	case 0x040c18ff: return "_ZNKSt7_MpunctIwE16do_decimal_pointEv";
	case 0x045e124a: return "_ZdaPv";
	case 0x0490855d: return "_ZNSt8numpunctIwE7_GetcatEPPKNSt6locale5facetE";
	case 0x055c1462: return "_ZNSt15basic_streambufIcSt11char_traitsIcEED1Ev";
	case 0x05903101: return "_ZNKSt7collateIcE7do_hashEPKcS2_";
	case 0x05a9cef6: return "_ZNSt7_MpunctIcE5_InitERKSt8_Locinfo";
	case 0x05ec37c8: return "_ZSt10_MaklocstrIwEPT_PKcS1_RKSt7_Cvtvec";
	case 0x06bc5b51: return "_ZNKSt7_MpunctIwE16do_positive_signEv";
	case 0x07a3bd16: return "_ZNSt6locale7_LocimpD1Ev";
	case 0x07b6c924: return "_ZTv0_n12_NSt13basic_ostreamIwSt11char_traitsIwEED1Ev";
	case 0x085bff4f: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE5_LockEv";
	case 0x08e1865c: return "_ZNKSt8numpunctIwE16do_thousands_sepEv";
	case 0x09e73a2a: return "_ZNKSt7codecvtIwcSt9_MbstatetE11do_encodingEv";
	case 0x0ba5483c: return "_ZNKSt12codecvt_base11do_encodingEv";
	case 0x0bc08c57: return "_ZNKSt7collateIwE7do_hashEPKwS2_";
	case 0x0bcc1910: return "_ZNSt10ostrstreamD2Ev";
	case 0x0d4290d2: return "_ZNSt12length_errorD0Ev";
	case 0x0d644dca: return "_ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE11do_get_dateES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0x0e147a9d: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE9pbackfailEi";
	case 0x0e744ef5: return "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED1Ev";
	case 0x0e9698af: return "_ZNSt7codecvtIwcSt9_MbstatetED1Ev";
	case 0x0e9a5554: return "_ZNSt13basic_istreamIwSt11char_traitsIwEED0Ev";
	case 0x0f930fdd: return "_ZNSt13messages_baseD2Ev";
	case 0x0ff264b9: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE4syncEv";
	case 0x10231873: return "_ZNSt13runtime_errorD1Ev";
	case 0x10dc3f6c: return "_ZNSbIwSt11char_traitsIwESaIwEE6appendEjw";
	case 0x113a515f: return "_ZNKSt8messagesIcE7do_openERKSsRKSt6locale";
	case 0x114e9178: return "_ZNSt11logic_errorD0Ev";
	case 0x128cd621: return "_ZNKSt5ctypeIwE10do_scan_isEsPKwS2_";
	case 0x12de5772: return "_ZNKSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_bRSt8ios_baseRNSt5_IosbIiE8_IostateERSs";
	case 0x1374b8c8: return "_ZNSt10moneypunctIcLb0EED1Ev";
	case 0x143048bf: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE7seekoffElNSt5_IosbIiE8_SeekdirENS4_9_OpenmodeE";
	case 0x1474ac53: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERt";
	case 0x14e3faa5: return "_ZNKSt5ctypeIwE9do_narrowEwc";
	case 0x1527fe95: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE4syncEv";
	case 0x1692ae0c: return "_ZNSt6localeD1Ev";
	case 0x16df5ecb: return "_ZNKSt12codecvt_base16do_always_noconvEv";
	case 0x17dd0a4e: return "_ZNKSt7_MpunctIwE16do_negative_signEv";
	case 0x18628537: return "_ZNKSt8numpunctIcE16do_decimal_pointEv";
	case 0x186bcc94: return "_ZNSt8ios_base4InitD1Ev";
	case 0x18a38254: return "_ZNSt10ctype_baseD1Ev";
	case 0x197fc348: return "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED1Ev";
	case 0x1989f59c: return "_ZNSt8ios_base17register_callbackEPFvNS_5eventERS_iEi";
	case 0x19c901ce: return "_ZTv0_n12_NSt9strstreamD0Ev";
	case 0x1a00f889: return "_ZNSt9exceptionD2Ev";
	case 0x1a4f2fa6: return "_ZNSt8ios_base7failureD0Ev";
	case 0x1a7f963c: return "_ZNKSt8numpunctIcE11do_truenameEv";
	case 0x1b266c3d: return "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE7_GetcatEPPKNSt6locale5facetE";
	case 0x1b6a7482: return "_ZNKSt7_MpunctIwE13do_neg_formatEv";
	case 0x1b6ad260: return "_ZSt13resetiosflagsNSt5_IosbIiE9_FmtflagsE";
	case 0x1b9b3b5c: return "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev";
	case 0x1bccd2ca: return "_ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE7_GetintERS3_S5_iiRi";
	case 0x1c3f1c4f: return "_ZNSt6_MutexD1Ev";
	case 0x1c8083c5: return "_ZNSt12strstreambufD0Ev";
	case 0x1c8405dc: return "_ZNSt7_MpunctIcEC2Ejb";
	case 0x1cf6785d: return "_ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale";
	case 0x1d43fb44: return "_ZSt9use_facetISt8numpunctIwEERKT_RKSt6locale";
	case 0x1ee13e83: return "_ZNSt6locale5facetD0Ev";
	case 0x1f2e9f4e: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE9underflowEv";
	case 0x1f3a9ada: return "_ZNSt12strstreambuf7seekposESt4fposISt9_MbstatetENSt5_IosbIiE9_OpenmodeE";
	case 0x2070a73d: return "_ZNSt6locale7_LocimpC1ERKS0_";
	case 0x207b56fa: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE8_GetffldEPcRS3_S6_RKSt6locale";
	case 0x20a02b6d: return "_ZNSt6locale2idcvjEv";
	case 0x20f7e066: return "_ZNSt10moneypunctIwLb0EED0Ev";
	case 0x21659e45: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE5_FputES3_RSt8ios_basecPKcjjjj";
	case 0x22777290: return "_ZNSs7replaceEjjPKcj";
	case 0x229a0963: return "_ZNKSt5ctypeIwE5do_isEsw";
	case 0x2354ec0a: return "_ZNKSt7codecvtIwcSt9_MbstatetE10do_unshiftERS0_PcS3_RS3_";
	case 0x2356ef16: return "_ZnajRKSt9nothrow_t";
	case 0x23a87483: return "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE11do_get_timeES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0x23ef7642: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE8_GetifldEPcRS3_S6_NSt5_IosbIiE9_FmtflagsERKSt6locale";
	case 0x258359df: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basece";
	case 0x2670b433: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE8_GetffldEPcRS3_S6_RKSt6locale";
	case 0x268c3ea5: return "_ZNKSt7_MpunctIwE13do_pos_formatEv";
	case 0x26e8e1cf: return "_ZNKSt5ctypeIwE5do_isEPKwS2_Ps";
	case 0x273be056: return "_ZNKSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE8_PutmfldES3_bRSt8ios_basecbSs";
	case 0x281f9107: return "_ZTv0_n12_NSiD1Ev";
	case 0x294779fb: return "_ZNSt8ios_base4InitD2Ev";
	case 0x2954d64d: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE9underflowEv";
	case 0x29c11f46: return "_ZNKSt7codecvtIccSt9_MbstatetE9do_lengthERKS0_PKcS5_j";
	case 0x29c90b94: return "_ZNKSt8numpunctIcE16do_thousands_sepEv";
	case 0x2a16469d: return "_ZNSt8ios_base5imbueERKSt6locale";
	case 0x2ac890f4: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERb";
	case 0x2adccb1a: return "_ZNKSt7_MpunctIcE14do_frac_digitsEv";
	case 0x2af79bd6: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE5_IputES3_RSt8ios_basecPcj";
	case 0x2b05b95a: return "_ZNKSt7_MpunctIcE11do_groupingEv";
	case 0x2b88f26e: return "_ZNSt15basic_streambufIwSt11char_traitsIwEED0Ev";
	case 0x2c241d13: return "_ZnajjRKSt9nothrow_t";
	case 0x2c6ce396: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERd";
	case 0x2cf8ea50: return "_ZNKSt7codecvtIwcSt9_MbstatetE16do_always_noconvEv";
	case 0x2d489b47: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE9underflowEv";
	case 0x2d50650f: return "_ZSt9use_facetISt10moneypunctIcLb1EEERKT_RKSt6locale";
	case 0x2d8be7e8: return "_ZNKSt9exception6_RaiseEv";
	case 0x2daa5a42: return "_ZTv0_n12_NSt9strstreamD1Ev";
	case 0x2e2b80c8: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERPv";
	case 0x2e84ebb3: return "_ZNSt8_LocinfoC1EiPKc";
	case 0x2eb5c13a: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE4syncEv";
	case 0x2f29da90: return "_ZNSt12strstreambuf5_TidyEv";
	case 0x2ff8d101: return "_ZNSt6localeC1ERKS_S1_i";
	case 0x30195cf5: return "_ZNKSt8numpunctIcE11do_groupingEv";
	case 0x30ce43d4: return "_ZNSt8numpunctIcED0Ev";
	case 0x30e297ea: return "_ZNSt7_MpunctIcEC2ERKSt8_Locinfojb";
	case 0x316b7a34: return "_ZNSt9exceptionD1Ev";
	case 0x31a81476: return "_ZdlPvj";
	case 0x31b3e5cc: return "_ZNSs5_TidyEbj";
	case 0x3286b855: return "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE7_GetcatEPPKNSt6locale5facetE";
	case 0x332f8409: return "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE7_GetcatEPPKNSt6locale5facetE";
	case 0x336e904e: return "_ZNSdD0Ev";
	case 0x33e04d8e: return "_ZNKSt7collateIwE12do_transformEPKwS2_";
	case 0x34b63588: return "_ZNKSt5ctypeIwE9_DonarrowEwc";
	case 0x34edd72b: return "_ZNSt10moneypunctIwLb0EED1Ev";
	case 0x360f8a4f: return "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev";
	case 0x3697bbd3: return "_ZNSt8ios_base5_InitEv";
	case 0x36e7826a: return "_ZNSt7collateIcED1Ev";
	case 0x3783acfa: return "_ZTv0_n12_NSt13basic_istreamIwSt11char_traitsIwEED1Ev";
	case 0x38783beb: return "_ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE11do_get_yearES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0x3933645f: return "_ZNKSt7_MpunctIwE14do_frac_digitsEv";
	case 0x3937f2f8: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecm";
	case 0x39775ce9: return "_ZNSt11logic_errorD2Ev";
	case 0x3ad12959: return "_ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_Eb";
	case 0x3bac19dc: return "_ZThn8_NSdD0Ev";
	case 0x3bda45a7: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecy";
	case 0x3d32a7f4: return "_ZNSt6localeC2EPKci";
	case 0x3da21a90: return "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED1Ev";
	case 0x3e18602a: return "_ZNKSt12codecvt_base13do_max_lengthEv";
	case 0x3eeb7167: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE7_UnlockEv";
	case 0x3f6a6e68: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE9_EndwriteEv";
	case 0x3f9cb259: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERl";
	case 0x3fc2324d: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecd";
	case 0x409409af: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE6setbufEPci";
	case 0x411b923e: return "_ZSt9use_facetISt8numpunctIcEERKT_RKSt6locale";
	case 0x4148e091: return "_ZNKSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE8_GetmfldERS3_S5_bRSt8ios_base";
	case 0x417f47af: return "_ZSt9use_facetISt10moneypunctIcLb0EEERKT_RKSt6locale";
	case 0x42c40b2f: return "_ZNSt12out_of_rangeD0Ev";
	case 0x45010630: return "_ZNSt10moneypunctIcLb1EED0Ev";
	case 0x4520d6a2: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE5_LockEv";
	case 0x46034d2e: return "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev";
	case 0x460e5cb7: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE7seekposESt4fposISt9_MbstatetENSt5_IosbIiE9_OpenmodeE";
	case 0x4761783a: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE5imbueERKSt6locale";
	case 0x47aab531: return "_ZNSt7_MpunctIcED0Ev";
	case 0x47e5c318: return "_ZNSt8_LocinfoD2Ev";
	case 0x4827e6be: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERe";
	case 0x48d101ef: return "_ZNKSt8ios_base7failure8_DoraiseEv";
	case 0x493212da: return "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED0Ev";
	case 0x4952490e: return "_ZNSt8ios_base5clearENSt5_IosbIiE8_IostateEb";
	case 0x496c6f50: return "_Getctyptab";
	case 0x49d9ddaf: return "_ZNKSt8numpunctIwE12do_falsenameEv";
	case 0x49da8c5f: return "_ZNKSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_bRSt8ios_baseRNSt5_IosbIiE8_IostateERe";
	case 0x49f7d434: return "_ZNSt8numpunctIwED0Ev";
	case 0x4a40969d: return "_Fac_tidy";
	case 0x4a799510: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERl";
	case 0x4aec14d5: return "_ZNSt12length_errorD1Ev";
	case 0x4aff73cc: return "_ZSt14_Debug_messagePKcS0_";
	case 0x4b1ad744: return "_ZdaPvjRKSt9nothrow_t";
	case 0x4b5a8abc: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE6setbufEPwi";
	case 0x4bc193c7: return "_ZNSt10ostrstreamC2EPciNSt5_IosbIiE9_OpenmodeE";
	case 0x4bda379a: return "_ZNSt8ios_base4InitC1Ev";
	case 0x4bee7ba9: return "_ZNSt8ios_base7failureD1Ev";
	case 0x4cb35e7d: return "_ZNSt9time_baseD1Ev";
	case 0x4cdab0ba: return "_ZNSt7_MpunctIwED0Ev";
	case 0x4daf3fcf: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE6xsgetnEPci";
	case 0x4e34cf83: return "_ZNSbIwSt11char_traitsIwESaIwEE5_GrowEjb";
	case 0x4e5cd916: return "_ZNKSt8numpunctIwE11do_groupingEv";
	case 0x4ec89bf8: return "_ZNSt7collateIcE7_GetcatEPPKNSt6locale5facetE";
	case 0x4ef0eb8e: return "_ZNSt12strstreambuf7seekoffElNSt5_IosbIiE8_SeekdirENS1_9_OpenmodeE";
	case 0x4fde96de: return "_ZNSt15basic_streambufIwSt11char_traitsIwEED1Ev";
	case 0x5015b8d3: return "_ZSt7_FiopenPKwNSt5_IosbIiE9_OpenmodeEi";
	case 0x50b34c09: return "_ZNKSt9exception4whatEv";
	case 0x5102ac61: return "_ZNKSt7_MpunctIwE14do_curr_symbolEv";
	case 0x5119680b: return "_ZNSt8_LocinfoD1Ev";
	case 0x5127dcd1: return "_ZNSsC1Ev";
	case 0x522b0457: return "_ZNSt10istrstreamD0Ev";
	case 0x52330fbd: return "_ZNSt13runtime_errorD0Ev";
	case 0x5298ef8e: return "_ZdaPvRKSt9nothrow_t";
	case 0x5333bdc9: return "_ZNKSt13runtime_error4whatEv";
	case 0x53693d40: return "_ZSt11setiosflagsNSt5_IosbIiE9_FmtflagsE";
	case 0x5438d7d8: return "_ZdaPvS_";
	case 0x550255f7: return "_ZNKSt7codecvtIccSt9_MbstatetE10do_unshiftERS0_PcS3_RS3_";
	case 0x55481e6f: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE9showmanycEv";
	case 0x5560c79e: return "_ZNSdD1Ev";
	case 0x55b3ebf2: return "_ZNSt9strstreamC2EPciNSt5_IosbIiE9_OpenmodeE";
	case 0x563fd2be: return "_ZNSt6localeC2ERKS_PKci";
	case 0x5656ccff: return "_ZNKSt7collateIcE10do_compareEPKcS2_S2_S2_";
	case 0x56d3d4f0: return "_ZNSt9bad_allocD1Ev";
	case 0x56fac416: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERe";
	case 0x577c2695: return "_ZNSt6_Mutex5_LockEv";
	case 0x57ef52f0: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE7_UnlockEv";
	case 0x581fc95b: return "_ZNSt5ctypeIcED0Ev";
	case 0x58fad1c1: return "_ZNSt5ctypeIwE7_GetcatEPPKNSt6locale5facetE";
	case 0x5949408e: return "_ZNSt8ios_base5_TidyEv";
	case 0x59c77266: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERd";
	case 0x5a3ad4bd: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERf";
	case 0x5a5a9107: return "_ZNSt6localeC2Ev";
	case 0x5a6e4e50: return "_ZNSt6locale7_Locimp9_MakewlocERKSt8_LocinfoiPS0_PKS_";
	case 0x5a898327: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE7seekoffElNSt5_IosbIiE8_SeekdirENS4_9_OpenmodeE";
	case 0x5adf9060: return "_ZNKSt5ctypeIcE8do_widenEPKcS2_Pc";
	case 0x5b71b85d: return "_ZNSt19istreambuf_iteratorIwSt11char_traitsIwEE4_IncEv";
	case 0x5c15972f: return "_ZNSt13basic_ostreamIwSt11char_traitsIwEED1Ev";
	case 0x5ca98e4a: return "_ZNSt13basic_filebufIcSt11char_traitsIcEED0Ev";
	case 0x5e1f2d37: return "_ZNKSt9exception8_DoraiseEv";
	case 0x5e55ab8c: return "_ZSt10_GetloctxtIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEiRT0_S5_jPKT_";
	case 0x5ed4fb7a: return "_ZTv0_n12_NSt13basic_istreamIwSt11char_traitsIwEED0Ev";
	case 0x604fec95: return "_ZNSt12out_of_rangeD1Ev";
	case 0x605131d5: return "_ZNSt8_LocinfoC1EPKc";
	case 0x6051c802: return "_ZNSt7codecvtIccSt9_MbstatetED0Ev";
	case 0x608abbb5: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE5uflowEv";
	case 0x61119152: return "_ZNSt6locale5_InitEv";
	case 0x61248c80: return "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE13do_date_orderEv";
	case 0x61a23009: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE5_FputES3_RSt8ios_basewPKcjjjj";
	case 0x61f55c30: return "_ZNKSt5ctypeIcE8do_widenEc";
	case 0x629b8531: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE5_IputES3_RSt8ios_basewPcj";
	case 0x62d6bf82: return "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED1Ev";
	case 0x62f52bb0: return "_ZNSt7_MpunctIwEC2ERKSt8_Locinfojb";
	case 0x635166c3: return "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_bRSt8ios_basewe";
	case 0x63a2b2cc: return "_ZNKSt8messagesIcE8do_closeEi";
	case 0x643235cf: return "_ZNSt9strstreamD1Ev";
	case 0x6437a975: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERt";
	case 0x643e67f4: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERPv";
	case 0x6463d9ea: return "_ZNKSt8messagesIwE6do_getEiiiRKSbIwSt11char_traitsIwESaIwEE";
	case 0x64ce0374: return "_ZNSbIwSt11char_traitsIwESaIwEE7replaceEjjPKwj";
	case 0x64ed868e: return "_ZSt9terminatev";
	case 0x6500d2d5: return "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE7_GetcatEPPKNSt6locale5facetE";
	case 0x65f19631: return "_ZTv0_n12_NSiD0Ev";
	case 0x660882e8: return "_ZNSt6localeC1Ev";
	case 0x667d741b: return "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED0Ev";
	case 0x668b31c6: return "_ZNSs5_GrowEjb";
	case 0x66f39adb: return "_ZNSt8numpunctIwED1Ev";
	case 0x66fcc6f4: return "_ZNSt8messagesIwE7_GetcatEPPKNSt6locale5facetE";
	case 0x67948307: return "_ZNKSt7codecvtIwcSt9_MbstatetE9do_lengthERKS0_PKcS5_j";
	case 0x67c09257: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERx";
	case 0x67edde2f: return "_ZdlPvjRKSt9nothrow_t";
	case 0x67fbabf0: return "_ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE14do_get_weekdayES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0x683ca70a: return "_ZNKSt12_String_base5_XlenEv";
	case 0x6863452e: return "_ZNSt6locale5facetD1Ev";
	case 0x6929318d: return "_ZNSs6assignERKSsjj";
	case 0x696b47f2: return "_ZNKSt7_MpunctIcE13do_neg_formatEv";
	case 0x6a6b90c9: return "_ZSt15set_new_handlerPFvvE";
	case 0x6adc320a: return "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev";
	case 0x6b493669: return "_ZSt7setbasei";
	case 0x6b913d53: return "_ZNSs6insertEjjc";
	case 0x6c19db26: return "_ZNKSt7_MpunctIcE16do_thousands_sepEv";
	case 0x6c386f54: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE7seekposESt4fposISt9_MbstatetENSt5_IosbIiE9_OpenmodeE";
	case 0x6c8dc459: return "_ZNKSt8bad_cast4whatEv";
	case 0x6cb1a335: return "_ZNSt6locale5facet7_DecrefEv";
	case 0x6d483b7a: return "_ZNSt12strstreambuf9pbackfailEi";
	case 0x6daed882: return "_ZNSt8ios_baseD0Ev";
	case 0x6dbbb9de: return "_ZNKSt5ctypeIcE10do_toupperEc";
	case 0x6e0bf85d: return "_ZTv0_n12_NSt10istrstreamD1Ev";
	case 0x6e4a84c1: return "_ZNSt5ctypeIcED1Ev";
	case 0x6e61426d: return "_ZNSt13basic_filebufIwSt11char_traitsIwEED1Ev";
	case 0x6f1945fc: return "_ZNSoD1Ev";
	case 0x6fe060a0: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE7seekposESt4fposISt9_MbstatetENSt5_IosbIiE9_OpenmodeE";
	case 0x7008e209: return "_ZNKSt5ctypeIwE10do_toupperEw";
	case 0x708cf940: return "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE11do_get_dateES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0x709ab035: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE6setbufEPci";
	case 0x7142ad20: return "_ZNKSt7_MpunctIcE16do_decimal_pointEv";
	case 0x718977c5: return "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE7_GetcatEPPKNSt6locale5facetE";
	case 0x736c5f22: return "_ZNSoD0Ev";
	case 0x74a39b4f: return "_ZThn8_NSt9strstreamD1Ev";
	case 0x753c71db: return "_ZNKSt7_MpunctIcE13do_pos_formatEv";
	case 0x75824de0: return "_ZNSt6_MutexC1Ev";
	case 0x75975eb4: return "_ZNSsC1EPKc";
	case 0x75a0617c: return "_ZNKSt7_MpunctIwE11do_groupingEv";
	case 0x764ceaa4: return "_ZNSt10ostrstreamD0Ev";
	case 0x767a4e70: return "_ZNSt6_WinitC2Ev";
	case 0x76db6974: return "_ZNSt7codecvtIwcSt9_MbstatetED0Ev";
	case 0x76de9b0f: return "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev";
	case 0x76e846b2: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE6xsputnEPKwi";
	case 0x77c1d3a9: return "_ZNKSt13runtime_error8_DoraiseEv";
	case 0x7882e64e: return "_ZNSt7collateIwED0Ev";
	case 0x78a142d0: return "_ZSt7_FiopenPKcNSt5_IosbIiE9_OpenmodeEi";
	case 0x79a415f8: return "_ZNSbIwSt11char_traitsIwESaIwEE6insertEjjw";
	case 0x79ad3575: return "_ZTv0_n12_NSoD1Ev";
	case 0x7a180518: return "_ZNSt10money_baseD0Ev";
	case 0x7b1db41e: return "_ZNSt6locale7_AddfacEPNS_5facetEjj";
	case 0x7b5fce95: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE6setbufEPwi";
	case 0x7c391411: return "_ZNSt10moneypunctIcLb0EED0Ev";
	case 0x7cdbda48: return "_ZNSt7collateIcED0Ev";
	case 0x7d23aa12: return "_ZNSt10moneypunctIwLb0EE7_GetcatEPPKNSt6locale5facetE";
	case 0x7da7fdb1: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewy";
	case 0x7e7ac30e: return "_ZNSt6locale5emptyEv";
	case 0x7ebad3f0: return "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE8_PutmfldES3_bRSt8ios_basewbSbIwS2_SaIwEE";
	case 0x7fe08910: return "_ZNSt10moneypunctIcLb0EE7_GetcatEPPKNSt6locale5facetE";
	case 0x7ff35597: return "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE7_GetcatEPPKNSt6locale5facetE";
	case 0x8006c4ec: return "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED0Ev";
	case 0x8044f596: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE5_LockEv";
	case 0x81027e75: return "_ZNSt7_MpunctIwE5_InitERKSt8_Locinfo";
	case 0x816aebc3: return "_ZNSt9bad_allocD0Ev";
	case 0x823759d3: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewl";
	case 0x8341b529: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE8overflowEi";
	case 0x83b2cc6f: return "_Znwj";
	case 0x83bca135: return "_ZNKSt11logic_error4whatEv";
	case 0x83cba890: return "_ZNSt6locale5facetD2Ev";
	case 0x84023c03: return "_ZSt12setprecisioni";
	case 0x854bc7c7: return "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev";
	case 0x85b3c6da: return "_ZNKSt8_Locinfo7_GetcvtEv";
	case 0x85ba062f: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE7_UnlockEv";
	case 0x867956a4: return "_ZNSt9basic_iosIcSt11char_traitsIcEED1Ev";
	case 0x868531a3: return "_ZdaPvj";
	case 0x86c66cfc: return "_ZNSsD1Ev";
	case 0x871506ea: return "_ZNSbIwSt11char_traitsIwESaIwEE6assignERKS2_jj";
	case 0x8729f617: return "_ZNSt10ostrstreamC1EPciNSt5_IosbIiE9_OpenmodeE";
	case 0x87b1f5eb: return "_ZNSt9exceptionD0Ev";
	case 0x88052736: return "_ZTv0_n12_NSt10ostrstreamD0Ev";
	case 0x883e1f16: return "_ZNKSt11logic_error8_DoraiseEv";
	case 0x884b021b: return "_ZNKSt5ctypeIwE8_DowidenEc";
	case 0x8a665143: return "_ZNSt8_Locinfo8_AddcatsEiPKc";
	case 0x8a85d688: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewx";
	case 0x8bfd4395: return "_ZNSt9basic_iosIwSt11char_traitsIwEE4initEPSt15basic_streambufIwS1_Eb";
	case 0x8c2e6d06: return "_ZNKSt8messagesIwE7do_openERKSsRKSt6locale";
	case 0x8c3afd4c: return "_ZSt10unexpectedv";
	case 0x8c6b8d39: return "_ZNSt13basic_filebufIcSt11char_traitsIcEED1Ev";
	case 0x8cda1f3b: return "_ZSt10_GetloctxtIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEiRT0_S5_jPKT_";
	case 0x8d4e266b: return "_ZNKSt8_Locinfo9_GetctypeEv";
	case 0x8fa764f3: return "_ZNSt6_WinitC1Ev";
	case 0x900d1fa4: return "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED0Ev";
	case 0x903afa37: return "_ZTv0_n12_NSt13basic_ostreamIwSt11char_traitsIwEED0Ev";
	case 0x904dbd32: return "_ZNSt6locale7_LocimpC1Eb";
	case 0x9111ec36: return "_ZNSt13messages_baseD0Ev";
	case 0x91959ed6: return "_ZNKSt5ctypeIcE9do_narrowEcc";
	case 0x91b0e37e: return "_ZSt14set_unexpectedPFvvE";
	case 0x9268d6e7: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERj";
	case 0x928fbe36: return "_ZTv0_n12_NSdD1Ev";
	case 0x93c638e9: return "_ZNSt19istreambuf_iteratorIwSt11char_traitsIwEE5_PeekEv";
	case 0x94c49383: return "_ZdlPvS_";
	case 0x94fa1f5b: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE5uflowEv";
	case 0x95082493: return "_ZNKSt8messagesIcE6do_getEiiiRKSs";
	case 0x95b43c9d: return "_ZNSt6locale7_LocimpD2Ev";
	case 0x96634e42: return "_ZNKSt9bad_alloc4whatEv";
	case 0x96bc2578: return "_Znajj";
	case 0x97911f5f: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE5uflowEv";
	case 0x984ce3d7: return "_ZNSt8numpunctIcED1Ev";
	case 0x9891bf45: return "_ZNKSt7_MpunctIwE16do_thousands_sepEv";
	case 0x9a194306: return "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE5_InitERKSt8_Locinfo";
	case 0x9a449047: return "_ZNSt7_MpunctIwEC2Ejb";
	case 0x9aa7a8b3: return "_ZNSt10istrstreamD2Ev";
	case 0x9afa5d71: return "_ZNSt10money_baseD2Ev";
	case 0x9b5358f9: return "_ZNKSt7_MpunctIcE16do_positive_signEv";
	case 0x9c40d1f9: return "_ZNKSt8numpunctIwE16do_decimal_pointEv";
	case 0x9c486668: return "_ZNSt6locale7_Locimp9_MakexlocERKSt8_LocinfoiPS0_PKS_";
	case 0x9cb73ee0: return "_ZSt6_ThrowRKSt9exception";
	case 0x9cfc0eaf: return "_ZNSiD1Ev";
	case 0x9d6a8167: return "_ZNSbIwSt11char_traitsIwESaIwEE5eraseEjj";
	case 0x9dbbe07d: return "_ZNKSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE8_GetmfldERS3_S5_bRSt8ios_base";
	case 0x9dc040e4: return "_Deletegloballocale";
	case 0x9dcb4bcb: return "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14do_get_weekdayES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0x9e741d47: return "_ZNSsC1ERKSs";
	case 0x9ec88ae6: return "_ZNKSt5ctypeIwE10do_tolowerEPwPKw";
	case 0x9ef60bf3: return "_ZNKSt5ctypeIwE10do_tolowerEw";
	case 0x9f528cd3: return "_ZNKSt7codecvtIccSt9_MbstatetE6do_outERS0_PKcS4_RS4_PcS6_RS6_";
	case 0x9f959451: return "_ZNSt13basic_istreamIwSt11char_traitsIwEED1Ev";
	case 0x9facb533: return "_ZNSt13messages_baseD1Ev";
	case 0x9fd2eea9: return "_ZNSt8_LocinfoC2EiPKc";
	case 0xa1c6fc55: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE7_UnlockEv";
	case 0xa1de25c2: return "_ZTv0_n12_NSt10ostrstreamD1Ev";
	case 0xa22d5dda: return "_ZNSt8messagesIcED0Ev";
	case 0xa2fd0ec5: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE9pbackfailEi";
	case 0xa35033e8: return "_ZNKSt5ctypeIwE8do_widenEPKcS2_Pw";
	case 0xa37c3e51: return "_ZNKSt5ctypeIwE8do_widenEc";
	case 0xa3f5c3b2: return "_ZNSt9strstreamD2Ev";
	case 0xa433147a: return "_ZNSt8messagesIcE7_GetcatEPPKNSt6locale5facetE";
	case 0xa464c70a: return "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_bRSt8ios_basewRKSbIwS2_SaIwEE";
	case 0xa4f6a919: return "_ZThn8_NSdD1Ev";
	case 0xa5306edb: return "_ZNSt10moneypunctIwLb1EED1Ev";
	case 0xa562099c: return "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev";
	case 0xa700bc7d: return "_ZNKSt7codecvtIwcSt9_MbstatetE6do_outERS0_PKwS4_RS4_PcS6_RS6_";
	case 0xa74e5a27: return "_ZNKSt6localeeqERKS_";
	case 0xa79c4516: return "_ZNSt15basic_streambufIcSt11char_traitsIcEED0Ev";
	case 0xa8ece2e0: return "_ZSt9use_facetISt10moneypunctIwLb0EEERKT_RKSt6locale";
	case 0xa8f64fdb: return "_ZNKSt5ctypeIcE10do_tolowerEPcPKc";
	case 0xa90c4ff2: return "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE7_GetcatEPPKNSt6locale5facetE";
	case 0xa9116516: return "_ZNSs6appendEjc";
	case 0xa94be0fa: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE9_EndwriteEv";
	case 0xa957adcc: return "_ZNKSt5ctypeIcE9do_narrowEPKcS2_cPc";
	case 0xa9e5bb16: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERm";
	case 0xaa520d9f: return "_ZNSt6locale7_Locimp7_AddfacEPNS_5facetEj";
	case 0xaae64804: return "_ZNSt8ios_base8_FindarrEi";
	case 0xab211d97: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecb";
	case 0xab5832fd: return "_ZNSt10money_baseD1Ev";
	case 0xabd92bcc: return "_ZNSt7collateIwE7_GetcatEPPKNSt6locale5facetE";
	case 0xabdc2b49: return "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE7_GetcatEPPKNSt6locale5facetE";
	case 0xac6c23c0: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERy";
	case 0xad3777a2: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE8overflowEi";
	case 0xad382a99: return "_ZdlPvRKSt9nothrow_t";
	case 0xad6d839f: return "_ZNSt12codecvt_baseD0Ev";
	case 0xad6dbac2: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERm";
	case 0xadc2263b: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE6xsputnEPKci";
	case 0xae7d042f: return "_ZNSt7codecvtIwcSt9_MbstatetE7_GetcatEPPKNSt6locale5facetE";
	case 0xaea59ceb: return "_ZNSt10ctype_baseD0Ev";
	case 0xb0c185b7: return "_ZNSt10moneypunctIcLb1EE7_GetcatEPPKNSt6locale5facetE";
	case 0xb0e7c2f3: return "_ZNSiD0Ev";
	case 0xb1550b3c: return "_ZNKSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecx";
	case 0xb1ac1fa3: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE6xsgetnEPwi";
	case 0xb1d696f7: return "_ZNKSt8numpunctIcE12do_falsenameEv";
	case 0xb326f699: return "_ZNKSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_bRSt8ios_basece";
	case 0xb33ef042: return "_ZNSt8bad_castD0Ev";
	case 0xb3f05af3: return "_ZNKSt7collateIcE12do_transformEPKcS2_";
	case 0xb4352488: return "_ZNKSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_bRSt8ios_basecRKSs";
	case 0xb4a8791f: return "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED1Ev";
	case 0xb509ab64: return "_ZNSt10moneypunctIcLb1EED1Ev";
	case 0xb53fa02e: return "_ZnwjjRKSt9nothrow_t";
	case 0xb6a4d760: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE7seekposESt4fposISt9_MbstatetENSt5_IosbIiE9_OpenmodeE";
	case 0xb6a7ba7a: return "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED0Ev";
	case 0xb74f7b8f: return "_ZNSt6locale7_LocimpC2ERKS0_";
	case 0xb7dcbfdd: return "__Setgloballocale";
	case 0xb80ca215: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE5imbueERKSt6locale";
	case 0xb87c4b43: return "_ZNSt12strstreambuf6freezeEb";
	case 0xb8836b50: return "_ZNSt9exception18_Set_raise_handlerEPFvRKS_E";
	case 0xb8ec13a5: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewb";
	case 0xb9a2282d: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE8overflowEi";
	case 0xba0b6300: return "_ZNSt9basic_iosIwSt11char_traitsIwEED1Ev";
	case 0xba85ce08: return "_ZNSt12strstreambufD2Ev";
	case 0xbaa15803: return "_ZSt4setwi";
	case 0xbb4599c5: return "_ZNSt11logic_errorD1Ev";
	case 0xbb712718: return "_ZnwjRKSt9nothrow_t";
	case 0xbc5ad91c: return "_ZNKSt7collateIwE10do_compareEPKwS2_S2_S2_";
	case 0xbd140e12: return "_ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE11do_get_timeES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0xbd316983: return "_ZNSt8numpunctIcE5_InitERKSt8_Locinfo";
	case 0xbd35830b: return "_ZdaPvjS_";
	case 0xbd58ea5a: return "_ZNSt19ostreambuf_iteratorIwSt11char_traitsIwEEaSEw";
	case 0xbda26024: return "_ZNSt9strstreamD0Ev";
	case 0xbf9c3609: return "_ZNKSt5ctypeIwE10do_toupperEPwPKw";
	case 0xc013acd8: return "_ZNSt8ios_base8_CallfnsENS_5eventE";
	case 0xc06a4cd8: return "_ZNSt7_MpunctIwED1Ev";
	case 0xc22cebd8: return "_ZNSt8messagesIwED1Ev";
	case 0xc3d24eb3: return "_ZNSt9basic_iosIwSt11char_traitsIwEED0Ev";
	case 0xc41d676d: return "_ZNSt9time_baseD2Ev";
	case 0xc4c7993b: return "_ZNSbIwSt11char_traitsIwESaIwEE5_TidyEbj";
	case 0xc53ab1c0: return "_ZNSt8numpunctIwE5_InitERKSt8_Locinfo";
	case 0xc5977986: return "_ZNSt8ios_base7_AddstdEv";
	case 0xc612a38e: return "_ZNSt6_WinitD1Ev";
	case 0xc6e09225: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE5_InitEPSt6_FiletNS2_7_InitflE";
	case 0xc6ea0fd0: return "_ZNSt6locale7classicEv";
	case 0xc6f18e84: return "_ZNKSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_bRSt8ios_baseRNSt5_IosbIiE8_IostateERSbIwS2_SaIwEE";
	case 0xc79278ec: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE5imbueERKSt6locale";
	case 0xc7931798: return "_ZNKSt12_String_base5_XranEv";
	case 0xc7d0ee0c: return "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE16do_get_monthnameES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0xc862f7c8: return "_ZNSt12strstreambuf8overflowEi";
	case 0xcac83a05: return "_ZNSt6locale7_LocimpC2Eb";
	case 0xcb7d00a4: return "_ZNSt6_WinitD2Ev";
	case 0xcb82e0dc: return "_ZSt13set_terminatePFvvE";
	case 0xcbe74ad3: return "_ZNKSt8messagesIwE8do_closeEi";
	case 0xcc79f55d: return "_ZNKSt7_MpunctIcE16do_negative_signEv";
	case 0xccf14bd5: return "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE7_GetcatEPPKNSt6locale5facetE";
	case 0xcd33ed4f: return "_ZNSbIwSt11char_traitsIwESaIwEEC1Ev";
	case 0xcdafdf19: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE9showmanycEv";
	case 0xce653b6c: return "_ZNSt6_MutexC2Ev";
	case 0xce6705c3: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE8_GetifldEPcRS3_S6_NSt5_IosbIiE9_FmtflagsERKSt6locale";
	case 0xce8c6abc: return "_ZNSt8ios_base4InitC2Ev";
	case 0xcf9b4d80: return "_ZNSt10moneypunctIwLb1EED0Ev";
	case 0xd05ea37c: return "_ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv";
	case 0xd1b043b7: return "_ZSt10_MaklocchrIwET_cPS0_RKSt7_Cvtvec";
	case 0xd1ee6195: return "_ZNKSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE6do_putES3_RSt8ios_basecPKSt2tmcc";
	case 0xd2f9d93d: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewe";
	case 0xd356aefd: return "_ZNSt6_Mutex7_UnlockEv";
	case 0xd38f4018: return "_ZSt11_MaklocbyteIwEcT_RKSt7_Cvtvec";
	case 0xd4838fbd: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewm";
	case 0xd4ba5b31: return "_ZNSt8_LocinfoC2EPKc";
	case 0xd5244a29: return "_ZNSt10moneypunctIwLb1EE7_GetcatEPPKNSt6locale5facetE";
	case 0xd5c5ee3d: return "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERj";
	case 0xd6ee1090: return "_ZNKSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_bRSt8ios_baseRNSt5_IosbIiE8_IostateERe";
	case 0xd73321ed: return "_ZNSt10ostrstreamD1Ev";
	case 0xd76b2e07: return "_ZNKSt7codecvtIwcSt9_MbstatetE13do_max_lengthEv";
	case 0xd78efcc3: return "_ZNSt12strstreambuf9underflowEv";
	case 0xd7bc220d: return "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev";
	case 0xd7d92e51: return "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev";
	case 0xd830252c: return "_ZNSt12strstreambuf5_InitEiPcS0_i";
	case 0xd84b3689: return "_ZdlPv";
	case 0xd8aeb94a: return "_ZNSt8messagesIcED1Ev";
	case 0xd8b23008: return "_ZNSt8ios_baseD2Ev";
	case 0xd93d52b1: return "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED1Ev";
	case 0xd9a12c5e: return "_ZNKSt5ctypeIcE10do_toupperEPcPKc";
	case 0xd9d8af82: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE8overflowEi";
	case 0xda1088ce: return "_ZNSt6locale5facet7_IncrefEv";
	case 0xda1b159a: return "_ZNSt6_MutexD2Ev";
	case 0xda5469b3: return "_ZNSt9time_baseD0Ev";
	case 0xdab0a910: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE9pbackfailEi";
	case 0xdaf3996f: return "_ZNSt6locale6globalERKS_";
	case 0xdb5eae26: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE5_InitEPSt6_FiletNS2_7_InitflE";
	case 0xdc0c889c: return "_ZNSt8ios_base7copyfmtERKS_";
	case 0xdc4d7540: return "_ZNSt5ctypeIwED1Ev";
	case 0xdc65ab00: return "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev";
	case 0xdc981b5f: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE9underflowEv";
	case 0xdd8b1d47: return "_ZNSs5eraseEjj";
	case 0xdefe3230: return "_ZNSt8ios_baseD1Ev";
	case 0xdf1e09e1: return "_ZNKSt5ctypeIwE9do_narrowEPKwS2_cPc";
	case 0xdf7edb4d: return "_ZSt9use_facetISt10moneypunctIwLb1EEERKT_RKSt6locale";
	case 0xe177fd02: return "_ZNSt7_MpunctIcED2Ev";
	case 0xe196beab: return "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED0Ev";
	case 0xe206c08f: return "_ZNSt13basic_filebufIwSt11char_traitsIwEED0Ev";
	case 0xe2b2ac5a: return "_ZNSt6locale5facet9_RegisterEv";
	case 0xe3edd790: return "_ZNSt8bad_castD1Ev";
	case 0xe528a368: return "_ZNKSt7_MpunctIcE14do_curr_symbolEv";
	case 0xe54f1fe0: return "_ZNKSt9bad_alloc8_DoraiseEv";
	case 0xe5e1dcbc: return "_ZNSt15basic_streambufIwSt11char_traitsIwEE5imbueERKSt6locale";
	case 0xe6547e35: return "_ZNSt8messagesIwED0Ev";
	case 0xe667985a: return "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev";
	case 0xe75f6e21: return "_ZNKSt12length_error8_DoraiseEv";
	case 0xe7d8449e: return "_ZdlPvjS_";
	case 0xe82a422d: return "_ZNKSt8numpunctIwE11do_truenameEv";
	case 0xe8691be5: return "_ZNSt5ctypeIwED0Ev";
	case 0xe8c15f8a: return "_ZNSt7_MpunctIwED2Ev";
	case 0xe9d7a4ae: return "_ZNKSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewPKSt2tmcc";
	case 0xeb76301c: return "_ZNSt15basic_streambufIcSt11char_traitsIcEE9pbackfailEi";
	case 0xebd4b51d: return "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE11do_get_yearES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateEPSt2tm";
	case 0xece969c0: return "_ZTv0_n12_NSt10istrstreamD0Ev";
	case 0xed3da02b: return "_Znwjj";
	case 0xee853baf: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE4syncEv";
	case 0xef62751c: return "_ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE13do_date_orderEv";
	case 0xef6f90d8: return "_ZNKSt5ctypeIwE11do_scan_notEsPKwS2_";
	case 0xef959a6d: return "_ZThn8_NSt9strstreamD0Ev";
	case 0xf001a741: return "_ZNSt12strstreambufD1Ev";
	case 0xf00401d2: return "_ZNSt9basic_iosIcSt11char_traitsIcEED0Ev";
	case 0xf01deff8: return "_ZNKSt7codecvtIwcSt9_MbstatetE5do_inERS0_PKcS4_RS4_PwS6_RS6_";
	case 0xf05df017: return "_ZNSt5ctypeIcE7_GetcatEPPKNSt6locale5facetE";
	case 0xf127e816: return "_ZNSt10istrstreamD1Ev";
	case 0xf1543f02: return "_ZNKSt8_Locinfo8_GetcollEv";
	case 0xf1c86c92: return "_ZNKSt12out_of_range8_DoraiseEv";
	case 0xf1cff87d: return "_ZNSt10ctype_baseD2Ev";
	case 0xf2b9ab86: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERf";
	case 0xf30d3407: return "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewd";
	case 0xf51dc289: return "_ZNSt7codecvtIccSt9_MbstatetED1Ev";
	case 0xf53021e0: return "_ZNSt8bad_castC1Ev";
	case 0xf5825c7d: return "_ZNSt7collateIwED1Ev";
	case 0xf584de56: return "_ZNSt6locale7_Locimp8_MakelocERKSt8_LocinfoiPS0_PKS_";
	case 0xf58e83a5: return "_Znaj";
	case 0xf67a7e17: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE5uflowEv";
	case 0xf73f6afc: return "_ZNSt13basic_filebufIcSt11char_traitsIcEE7seekoffElNSt5_IosbIiE8_SeekdirENS4_9_OpenmodeE";
	case 0xf7845d1c: return "_ZNSt7_MpunctIcED1Ev";
	case 0xf7ba51fd: return "_ZNSt13basic_ostreamIwSt11char_traitsIwEED0Ev";
	case 0xf83e8d95: return "_ZNKSt5ctypeIcE10do_tolowerEc";
	case 0xf9ff46a1: return "_ZNSt13basic_filebufIwSt11char_traitsIwEE7seekoffElNSt5_IosbIiE8_SeekdirENS4_9_OpenmodeE";
	case 0xfb36c588: return "_ZNSt9strstreamC1EPciNSt5_IosbIiE9_OpenmodeE";
	case 0xfc563813: return "_ZNKSt7codecvtIccSt9_MbstatetE5do_inERS0_PKcS4_RS4_PcS6_RS6_";
	case 0xfc825dda: return "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE7_GetcatEPPKNSt6locale5facetE";
	case 0xfe468b7a: return "_ZTv0_n12_NSdD0Ev";
	case 0xfeb4107c: return "_ZNSt12codecvt_baseD2Ev";
	case 0xfefd7d3a: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERy";
	case 0xffaf3218: return "_ZTv0_n12_NSoD0Ev";
	case 0xfff6ef55: return "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRNSt5_IosbIiE8_IostateERb";
	}

	if (module == "sysPrxForUser") switch (fnid)
	{
	case 0x02e20ec1: return "__sys_printf_basename";
	case 0x0341bb97: return "sys_prx_get_module_id_by_address";
	case 0x04e83d2c: return "_sys_strncmp";
	case 0x052d29a6: return "_sys_strcat";
	case 0x05c65656: return "sys_mempool_try_allocate_block";
	case 0x0618936b: return "_sys_vsnprintf";
	case 0x06574237: return "_sys_snprintf";
	case 0x1573dc3f: return "sys_lwmutex_lock";
	case 0x191f0c4a: return "_sys_strrchr";
	case 0x1ae10b92: return "_sys_spu_printf_attach_thread";
	case 0x1bc200f4: return "sys_lwmutex_unlock";
	case 0x1c9a942c: return "sys_lwcond_destroy";
	case 0x1ca525a2: return "_sys_strncasecmp";
	case 0x1ed454ce: return "sys_spu_elf_get_information";
	case 0x24a1ea07: return "sys_ppu_thread_create";
	case 0x25596f51: return "sys_mempool_get_count";
	case 0x26090058: return "sys_prx_load_module";
	case 0x27427742: return "_sys_memmove";
	case 0x2a6d9d51: return "sys_lwcond_wait";
	case 0x2c847572: return "_sys_process_atexitspawn";
	case 0x2d36462b: return "_sys_strlen";
	case 0x2f85c0ef: return "sys_lwmutex_create";
	case 0x3172759d: return "sys_game_get_temperature";
	case 0x318f17e1: return "_sys_memalign";
	case 0x350d454e: return "sys_ppu_thread_get_id";
	case 0x35168520: return "_sys_heap_malloc";
	case 0x3bd53c7b: return "_sys_memchr";
	case 0x3dd4a957: return "sys_ppu_thread_register_atexit";
	case 0x3ef17f8c: return "__sys_look_ctype_table";
	case 0x409ad939: return "sys_mmapper_free_memory";
	case 0x4232b0db: return "_sys_panic";
	case 0x42b23552: return "sys_prx_register_library";
	case 0x44265c08: return "_sys_heap_memalign";
	case 0x459b4393: return "_sys_strcmp";
	case 0x45fe2fce: return "_sys_spu_printf_initialize";
	case 0x4643ba6e: return "sys_mmapper_unmap_memory";
	case 0x4a071d98: return "sys_interrupt_thread_disestablish";
	case 0x4b2f301a: return "_sys_tolower";
	case 0x4bbf59d0: return "_sys_net_eurus_post_command";
	case 0x4f7172c9: return "sys_process_is_stack";
	case 0x5267cb35: return "sys_spinlock_unlock";
	case 0x52aadadf: return "sys_lwcond_signal_to";
	case 0x5fdfb2fe: return "_sys_spu_printf_detach_group";
	case 0x608212fc: return "sys_mempool_free_block";
	case 0x620e35a7: return "sys_game_get_system_sw_version";
	case 0x637bdaae: return "_proc_spawn";
	case 0x67f9fedb: return "sys_game_process_exitspawn2";
	case 0x68b9b011: return "_sys_memset";
	case 0x6bf66ea7: return "_sys_memcpy";
	case 0x6e05231d: return "sys_game_watchdog_stop";
	case 0x70258515: return "sys_mmapper_allocate_memory_from_container";
	case 0x71a8472a: return "sys_get_random_number";
	case 0x722a0254: return "sys_spinlock_trylock";
	case 0x74311398: return "sys_prx_get_my_module_id";
	case 0x744680a2: return "sys_initialize_tls";
	case 0x7498887b: return "_sys_strchr";
	case 0x791b9219: return "_sys_vsprintf";
	case 0x80fb0c19: return "sys_prx_stop_module";
	case 0x8461e528: return "sys_time_get_system_time";
	case 0x84bb6774: return "sys_prx_get_module_info";
	case 0x893305fa: return "sys_raw_spu_load";
	case 0x8985b5b6: return "_sys_heap_stats";
	case 0x8a2f159b: return "console_getc";
	case 0x8a561d92: return "_sys_heap_free";
	case 0x8bb03ab8: return "sys_game_board_storage_write";
	case 0x8c2bb498: return "sys_spinlock_initialize";
	case 0x8cfef376: return "__tls_get_addr";
	case 0x96328741: return "_sys_process_at_Exitspawn";
	case 0x996f7cf8: return "_sys_strncat";
	case 0x99c88692: return "_sys_strcpy";
	case 0x9d2ec4ff: return "sys_process_spawn";
	case 0x9d3c0f81: return "sys_mempool_destroy";
	case 0x9e0623b5: return "sys_game_watchdog_start";
	case 0x9f04f7af: return "_sys_printf";
	case 0x9f18429d: return "sys_prx_start_module";
	case 0x9f950780: return "sys_game_get_rtc_status";
	case 0xa146a143: return "sys_mempool_allocate_block";
	case 0xa1f9eafe: return "_sys_sprintf";
	case 0xa285139d: return "sys_spinlock_lock";
	case 0xa2c7ba64: return "sys_prx_exitspawn_with_level";
	case 0xa330ad84: return "sys_prx_load_module_on_memcontainer_by_fd";
	case 0xa3e3be68: return "sys_ppu_thread_once";
	case 0xa5d06bf0: return "sys_prx_get_module_list";
	case 0xaa6d9bff: return "sys_prx_load_module_on_memcontainer";
	case 0xac6fc404: return "sys_ppu_thread_unregister_atexit";
	case 0xacad8fb6: return "sys_game_watchdog_clear";
	case 0xaeb78725: return "sys_lwmutex_trylock";
	case 0xaede4b03: return "_sys_heap_delete_heap";
	case 0xaff080a4: return "sys_ppu_thread_exit";
	case 0xb257540b: return "sys_mmapper_allocate_memory";
	case 0xb27c8ae7: return "sys_prx_load_module_list";
	case 0xb2fcf2c8: return "_sys_heap_create_heap";
	case 0xb3bbcf2a: return "_sys_spu_printf_detach_thread";
	case 0xb6369393: return "_sys_heap_get_total_free_size";
	case 0xb995662e: return "sys_raw_spu_image_load";
	case 0xb9bf1078: return "_sys_heap_alloc_heap_memory";
	case 0xbab62b99: return "_sys_process_wait_for_game_process";
	case 0xbdb18f83: return "_sys_malloc";
	case 0xbf8ee5bb: return "sys_process_spawn_with_memory_budget";
	case 0xc3476d0c: return "sys_lwmutex_destroy";
	case 0xc4fd6121: return "_sys_qsort";
	case 0xca9a60bf: return "sys_mempool_create";
	case 0xd0ea47a7: return "sys_prx_unregister_library";
	case 0xd1ad4570: return "_sys_heap_get_mallinfo";
	case 0xd3039d4d: return "_sys_strncpy";
	case 0xda0eb71a: return "sys_lwcond_create";
	case 0xdb6b3250: return "sys_spu_elf_get_segments";
	case 0xdc578057: return "sys_mmapper_map_memory";
	case 0xdd0c1e09: return "_sys_spu_printf_attach_group";
	case 0xdd3b27ac: return "_sys_spu_printf_finalize";
	case 0xde2f9c85: return "sys_process_atexit";
	case 0xe0998dbf: return "sys_prx_get_module_id_by_name";
	case 0xe0da8efd: return "sys_spu_image_close";
	case 0xe66bac36: return "console_putc";
	case 0xe6f2c1e7: return "sys_process_exit";
	case 0xe76964f5: return "sys_game_board_storage_read";
	case 0xe7ef3a80: return "sys_prx_load_module_list_on_memcontainer";
	case 0xe95ffa0a: return "sys_process_wait_for_game_process";
	case 0xe9a1bd84: return "sys_lwcond_signal_all";
	case 0xebe5f72f: return "sys_spu_image_import";
	case 0xeef75113: return "_sys_toupper";
	case 0xef68c17c: return "sys_prx_load_module_by_fd";
	case 0xef87a695: return "sys_lwcond_signal";
	case 0xf0aece0d: return "sys_prx_unload_module";
	case 0xf57e1d6f: return "console_write";
	case 0xf7f7fb20: return "_sys_free";
	case 0xfa7f693d: return "_sys_vprintf";
	case 0xfb5db080: return "_sys_memcmp";
	case 0xfc52a7a9: return "sys_game_process_exitspawn";
	case 0xfecc05b6: return "__sys_time";
	}

	// Check registered functions
	if (const auto sm = ppu_module_manager::get_module(module))
	{
		const auto found = sm->functions.find(fnid);

		if (found != sm->functions.end())
		{
			return found->second.name;
		}
	}

	return fmt::format("0x%08X", fnid);
}

// Get variable name by VNID
extern std::string ppu_get_variable_name(const std::string& module, u32 vnid)
{
	if (module == "") switch (vnid)
	{
	// these arent the actual hash, but its close enough
	case 0xd7f43016: return "module_info";
	}
	// Check known FNIDs
	if (module == "sys_libc") switch (vnid)
	{
	case 0x071928b0: return "_LNan";
	case 0x0a331920: return "_Clocale";
	case 0x0b2e15ed: return "_malloc_limit";
	case 0x0fbc732d: return "_Zero";
	case 0x17667744: return "_LInf";
	case 0x210b2f6e: return "_FNan";
	case 0x2418f6c0: return "__TT800";
	case 0x2470d3bc: return "_Hugeval";
	case 0x26a34f81: return "_Flt";
	case 0x277a84bb: return "_Mutex_attr";
	case 0x29e76a6d: return "_LXbig";
	case 0x2cf8b5d1: return "_Wctrans";
	case 0x32e56b1a: return "_Stdin";
	case 0x3916a06a: return "_FILE_P_Head";
	case 0x45ec2df6: return "_LEps";
	case 0x529d4301: return "_Denorm";
	case 0x57dbcf27: return "_Inf";
	case 0x5ff11eb4: return "_FZero";
	case 0x620967c9: return "_Mbcurmax";
	case 0x6524499e: return "_FInf";
	case 0x67d1406b: return "__ctype_ptr";
	case 0x6a09df41: return "_LRteps";
	case 0x73898db8: return "environ";
	case 0x76628efb: return "_FSnan";
	case 0x790b0082: return "_Xbig";
	case 0x7aff3242: return "_Snan";
	case 0x7bc88211: return "_Tolotab";
	case 0x7f456af2: return "_Rteps";
	case 0x81acf7c1: return "_LZero";
	case 0x8f87ed0c: return "_Times";
	case 0x92c43f6d: return "_Eps";
	case 0x96e1e748: return "tls_mutex_attr";
	case 0x985fc057: return "_Dbl";
	case 0x9c8454c9: return "_LSnan";
	case 0xaa860d4c: return "_Wctype";
	case 0xb5b84f80: return "_LDenorm";
	case 0xb5d2f53b: return "_Touptab";
	case 0xb6f5f98c: return "_FRteps";
	case 0xd59c193c: return "_Nan";
	case 0xd698385d: return "_Ldbl";
	case 0xd97b0687: return "_Ctype";
	case 0xe0bc8d86: return "_Loctab";
	case 0xeace53d6: return "_FDenorm";
	case 0xeca056df: return "_Locale";
	case 0xef25075b: return "_FXbig";
	case 0xfb2bd688: return "_Stdout";
	case 0xfefbe065: return "_Stderr";
	case 0xff2f0cc7: return "_FEps";
	}

	if (module == "sys_libm") switch (vnid)
	{
	case 0x1cf745bc: return "_LErf_one";
	case 0x2259ef96: return "_LGamma_big";
	case 0x3acad7f1: return "_Erf_small";
	case 0x3fb8629d: return "_FErf_one";
	case 0x42eb9508: return "_Fenv0";
	case 0x4af28f31: return "_FErf_small";
	case 0xa8d907ff: return "_LErf_small";
	case 0xad443e79: return "_Erf_one";
	case 0xe9892674: return "_FGamma_big";
	case 0xf39005fc: return "_Gamma_big";
	}

	// Check registered variables
	if (const auto sm = ppu_module_manager::get_module(module))
	{
		const auto found = sm->variables.find(vnid);

		if (found != sm->variables.end())
		{
			return found->second.name;
		}
	}

	return fmt::format("0x%08X", vnid);
}

std::vector<ppu_function_t>& ppu_function_manager::access()
{
	static std::vector<ppu_function_t> list
	{
		[](ppu_thread& ppu) -> bool
		{
			LOG_ERROR(PPU, "Unregistered function called (LR=0x%x)", ppu.lr);
			ppu.gpr[3] = 0;
			ppu.cia = (u32)ppu.lr & ~3;
			return false;
		},
		[](ppu_thread& ppu) -> bool
		{
			ppu.state += cpu_flag::ret;
			ppu.cia += 4;
			return false;
		},
	};

	return list;
}

u32 ppu_function_manager::add_function(ppu_function_t function)
{
	auto& list = access();

	list.push_back(function);

	return ::size32(list) - 1;
}

DECLARE(ppu_function_manager::addr);
