#include "gcm_printing.h"
#include "rsx_decode.h"
#include <unordered_map>
#include <Utilities/StrFmt.h>

namespace
{
	const std::unordered_map<u32, const char*> methods_name = {
		{NV406E_SET_REFERENCE, "NV406E_SET_REFERENCE"},
		{NV406E_SET_CONTEXT_DMA_SEMAPHORE, "NV406E_SET_CONTEXT_DMA_SEMAPHORE"},
		{NV406E_SEMAPHORE_OFFSET, "NV406E_SEMAPHORE_OFFSET"},
		{NV406E_SEMAPHORE_ACQUIRE, "NV406E_SEMAPHORE_ACQUIRE"},
		{NV406E_SEMAPHORE_RELEASE, "NV406E_SEMAPHORE_RELEASE"},
	    {NV4097_NO_OPERATION, "NV4097_NO_OPERATION"}, {NV4097_NOTIFY, "NV4097_NOTIFY"},
	    {NV4097_WAIT_FOR_IDLE, "NV4097_WAIT_FOR_IDLE"}, {NV4097_PM_TRIGGER, "NV4097_PM_TRIGGER"},
	    {NV4097_SET_CONTEXT_DMA_NOTIFIES, "NV4097_SET_CONTEXT_DMA_NOTIFIES"},
	    {NV4097_SET_CONTEXT_DMA_A, "NV4097_SET_CONTEXT_DMA_A"},
	    {NV4097_SET_CONTEXT_DMA_B, "NV4097_SET_CONTEXT_DMA_B"},
	    {NV4097_SET_CONTEXT_DMA_COLOR_B, "NV4097_SET_CONTEXT_DMA_COLOR_B"},
	    {NV4097_SET_CONTEXT_DMA_STATE, "NV4097_SET_CONTEXT_DMA_STATE"},
	    {NV4097_SET_CONTEXT_DMA_COLOR_A, "NV4097_SET_CONTEXT_DMA_COLOR_A"},
	    {NV4097_SET_CONTEXT_DMA_ZETA, "NV4097_SET_CONTEXT_DMA_ZETA"},
	    {NV4097_SET_CONTEXT_DMA_VERTEX_A, "NV4097_SET_CONTEXT_DMA_VERTEX_A"},
	    {NV4097_SET_CONTEXT_DMA_VERTEX_B, "NV4097_SET_CONTEXT_DMA_VERTEX_B"},
	    {NV4097_SET_CONTEXT_DMA_SEMAPHORE, "NV4097_SET_CONTEXT_DMA_SEMAPHORE"},
	    {NV4097_SET_CONTEXT_DMA_REPORT, "NV4097_SET_CONTEXT_DMA_REPORT"},
	    {NV4097_SET_CONTEXT_DMA_CLIP_ID, "NV4097_SET_CONTEXT_DMA_CLIP_ID"},
	    {NV4097_SET_CONTEXT_DMA_CULL_DATA, "NV4097_SET_CONTEXT_DMA_CULL_DATA"},
	    {NV4097_SET_CONTEXT_DMA_COLOR_C, "NV4097_SET_CONTEXT_DMA_COLOR_C"},
	    {NV4097_SET_CONTEXT_DMA_COLOR_D, "NV4097_SET_CONTEXT_DMA_COLOR_D"},
	    {NV4097_SET_SURFACE_CLIP_HORIZONTAL, "NV4097_SET_SURFACE_CLIP_HORIZONTAL"},
	    {NV4097_SET_SURFACE_CLIP_VERTICAL, "NV4097_SET_SURFACE_CLIP_VERTICAL"},
	    {NV4097_SET_SURFACE_FORMAT, "NV4097_SET_SURFACE_FORMAT"},
	    {NV4097_SET_SURFACE_PITCH_A, "NV4097_SET_SURFACE_PITCH_A"},
	    {NV4097_SET_SURFACE_COLOR_AOFFSET, "NV4097_SET_SURFACE_COLOR_AOFFSET"},
	    {NV4097_SET_SURFACE_ZETA_OFFSET, "NV4097_SET_SURFACE_ZETA_OFFSET"},
	    {NV4097_SET_SURFACE_COLOR_BOFFSET, "NV4097_SET_SURFACE_COLOR_BOFFSET"},
	    {NV4097_SET_SURFACE_PITCH_B, "NV4097_SET_SURFACE_PITCH_B"},
	    {NV4097_SET_SURFACE_COLOR_TARGET, "NV4097_SET_SURFACE_COLOR_TARGET"},
	    {NV4097_SET_SURFACE_PITCH_Z, "NV4097_SET_SURFACE_PITCH_Z"},
	    {NV4097_INVALIDATE_ZCULL, "NV4097_INVALIDATE_ZCULL"},
	    {NV4097_SET_CYLINDRICAL_WRAP, "NV4097_SET_CYLINDRICAL_WRAP"},
	    {NV4097_SET_CYLINDRICAL_WRAP1, "NV4097_SET_CYLINDRICAL_WRAP1"},
	    {NV4097_SET_SURFACE_PITCH_C, "NV4097_SET_SURFACE_PITCH_C"},
	    {NV4097_SET_SURFACE_PITCH_D, "NV4097_SET_SURFACE_PITCH_D"},
	    {NV4097_SET_SURFACE_COLOR_COFFSET, "NV4097_SET_SURFACE_COLOR_COFFSET"},
	    {NV4097_SET_SURFACE_COLOR_DOFFSET, "NV4097_SET_SURFACE_COLOR_DOFFSET"},
	    {NV4097_SET_WINDOW_OFFSET, "NV4097_SET_WINDOW_OFFSET"},
	    {NV4097_SET_DITHER_ENABLE, "NV4097_SET_DITHER_ENABLE"},
	    {NV4097_SET_ALPHA_TEST_ENABLE, "NV4097_SET_ALPHA_TEST_ENABLE"},
	    {NV4097_SET_ALPHA_FUNC, "NV4097_SET_ALPHA_FUNC"},
	    {NV4097_SET_ALPHA_REF, "NV4097_SET_ALPHA_REF"},
	    {NV4097_SET_BLEND_ENABLE, "NV4097_SET_BLEND_ENABLE"},
	    {NV4097_SET_BLEND_FUNC_SFACTOR, "NV4097_SET_BLEND_FUNC_SFACTOR"},
	    {NV4097_SET_BLEND_FUNC_DFACTOR, "NV4097_SET_BLEND_FUNC_DFACTOR"},
	    {NV4097_SET_BLEND_COLOR, "NV4097_SET_BLEND_COLOR"},
	    {NV4097_SET_BLEND_EQUATION, "NV4097_SET_BLEND_EQUATION"},
	    {NV4097_SET_COLOR_MASK, "NV4097_SET_COLOR_MASK"},
	    {NV4097_SET_STENCIL_TEST_ENABLE, "NV4097_SET_STENCIL_TEST_ENABLE"},
	    {NV4097_SET_STENCIL_MASK, "NV4097_SET_STENCIL_MASK"},
	    {NV4097_SET_STENCIL_FUNC, "NV4097_SET_STENCIL_FUNC"},
	    {NV4097_SET_STENCIL_FUNC_REF, "NV4097_SET_STENCIL_FUNC_REF"},
	    {NV4097_SET_STENCIL_FUNC_MASK, "NV4097_SET_STENCIL_FUNC_MASK"},
	    {NV4097_SET_STENCIL_OP_FAIL, "NV4097_SET_STENCIL_OP_FAIL"},
	    {NV4097_SET_STENCIL_OP_ZFAIL, "NV4097_SET_STENCIL_OP_ZFAIL"},
	    {NV4097_SET_STENCIL_OP_ZPASS, "NV4097_SET_STENCIL_OP_ZPASS"},
	    {NV4097_SET_TWO_SIDED_STENCIL_TEST_ENABLE, "NV4097_SET_TWO_SIDED_STENCIL_TEST_ENABLE"},
	    {NV4097_SET_BACK_STENCIL_MASK, "NV4097_SET_BACK_STENCIL_MASK"},
	    {NV4097_SET_BACK_STENCIL_FUNC, "NV4097_SET_BACK_STENCIL_FUNC"},
	    {NV4097_SET_BACK_STENCIL_FUNC_REF, "NV4097_SET_BACK_STENCIL_FUNC_REF"},
	    {NV4097_SET_BACK_STENCIL_FUNC_MASK, "NV4097_SET_BACK_STENCIL_FUNC_MASK"},
	    {NV4097_SET_BACK_STENCIL_OP_FAIL, "NV4097_SET_BACK_STENCIL_OP_FAIL"},
	    {NV4097_SET_BACK_STENCIL_OP_ZFAIL, "NV4097_SET_BACK_STENCIL_OP_ZFAIL"},
	    {NV4097_SET_BACK_STENCIL_OP_ZPASS, "NV4097_SET_BACK_STENCIL_OP_ZPASS"},
	    {NV4097_SET_SHADE_MODE, "NV4097_SET_SHADE_MODE"},
	    {NV4097_SET_BLEND_ENABLE_MRT, "NV4097_SET_BLEND_ENABLE_MRT"},
	    {NV4097_SET_COLOR_MASK_MRT, "NV4097_SET_COLOR_MASK_MRT"},
	    {NV4097_SET_LOGIC_OP_ENABLE, "NV4097_SET_LOGIC_OP_ENABLE"},
	    {NV4097_SET_LOGIC_OP, "NV4097_SET_LOGIC_OP"},
	    {NV4097_SET_BLEND_COLOR2, "NV4097_SET_BLEND_COLOR2"},
	    {NV4097_SET_DEPTH_BOUNDS_TEST_ENABLE, "NV4097_SET_DEPTH_BOUNDS_TEST_ENABLE"},
	    {NV4097_SET_DEPTH_BOUNDS_MIN, "NV4097_SET_DEPTH_BOUNDS_MIN"},
	    {NV4097_SET_DEPTH_BOUNDS_MAX, "NV4097_SET_DEPTH_BOUNDS_MAX"},
	    {NV4097_SET_CLIP_MIN, "NV4097_SET_CLIP_MIN"}, {NV4097_SET_CLIP_MAX, "NV4097_SET_CLIP_MAX"},
	    {NV4097_SET_CONTROL0, "NV4097_SET_CONTROL0"}, {NV4097_SET_LINE_WIDTH, "NV4097_SET_LINE_WIDTH"},
	    {NV4097_SET_LINE_SMOOTH_ENABLE, "NV4097_SET_LINE_SMOOTH_ENABLE"},
	    {NV4097_SET_ANISO_SPREAD, "NV4097_SET_ANISO_SPREAD"},
	    {NV4097_SET_ANISO_SPREAD + 4 / 4, "NV4097_SET_ANISO_SPREAD + 4"},
	    {NV4097_SET_ANISO_SPREAD + 8 / 4, "NV4097_SET_ANISO_SPREAD + 8"},
	    {NV4097_SET_ANISO_SPREAD + 12 / 4, "NV4097_SET_ANISO_SPREAD + 12"},
	    {NV4097_SET_ANISO_SPREAD + 16 / 4, "NV4097_SET_ANISO_SPREAD + 16"},
	    {NV4097_SET_ANISO_SPREAD + 20 / 4, "NV4097_SET_ANISO_SPREAD + 20"},
	    {NV4097_SET_ANISO_SPREAD + 24 / 4, "NV4097_SET_ANISO_SPREAD + 24"},
	    {NV4097_SET_ANISO_SPREAD + 28 / 4, "NV4097_SET_ANISO_SPREAD + 28"},
	    {NV4097_SET_ANISO_SPREAD + 32 / 4, "NV4097_SET_ANISO_SPREAD + 32"},
	    {NV4097_SET_ANISO_SPREAD + 36 / 4, "NV4097_SET_ANISO_SPREAD + 36"},
	    {NV4097_SET_ANISO_SPREAD + 40 / 4, "NV4097_SET_ANISO_SPREAD + 40"},
	    {NV4097_SET_ANISO_SPREAD + 44 / 4, "NV4097_SET_ANISO_SPREAD + 44"},
	    {NV4097_SET_ANISO_SPREAD + 48 / 4, "NV4097_SET_ANISO_SPREAD + 48"},
	    {NV4097_SET_ANISO_SPREAD + 52 / 4, "NV4097_SET_ANISO_SPREAD + 52"},
	    {NV4097_SET_ANISO_SPREAD + 56 / 4, "NV4097_SET_ANISO_SPREAD + 56"},
	    {NV4097_SET_ANISO_SPREAD + 60 / 4, "NV4097_SET_ANISO_SPREAD + 60"},
	    {NV4097_SET_SCISSOR_HORIZONTAL, "NV4097_SET_SCISSOR_HORIZONTAL"},
	    {NV4097_SET_SCISSOR_VERTICAL, "NV4097_SET_SCISSOR_VERTICAL"},
	    {NV4097_SET_FOG_MODE, "NV4097_SET_FOG_MODE"}, {NV4097_SET_FOG_PARAMS, "NV4097_SET_FOG_PARAMS"},
	    {NV4097_SET_FOG_PARAMS + 4 / 4, "NV4097_SET_FOG_PARAMS + 4"},
	    {NV4097_SET_FOG_PARAMS + 8 / 4, "NV4097_SET_FOG_PARAMS + 8"},
	    {NV4097_SET_SHADER_PROGRAM, "NV4097_SET_SHADER_PROGRAM"},
	    {NV4097_SET_VERTEX_TEXTURE_OFFSET, "NV4097_SET_VERTEX_TEXTURE_OFFSET"},
	    {NV4097_SET_VERTEX_TEXTURE_FORMAT, "NV4097_SET_VERTEX_TEXTURE_FORMAT"},
	    {NV4097_SET_VERTEX_TEXTURE_ADDRESS, "NV4097_SET_VERTEX_TEXTURE_ADDRESS"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL0, "NV4097_SET_VERTEX_TEXTURE_CONTROL0"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL3, "NV4097_SET_VERTEX_TEXTURE_CONTROL3"},
	    {NV4097_SET_VERTEX_TEXTURE_FILTER, "NV4097_SET_VERTEX_TEXTURE_FILTER"},
	    {NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT, "NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT"},
	    {NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR, "NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR"},
	    {NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_FILTER + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_FILTER + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x20 / 4,
	        "NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x20 / 4,
	        "NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x20"},
	    {NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_FILTER + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_FILTER + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x40 / 4,
	        "NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x40 / 4,
	        "NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x40"},
	    {NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x60"},
	    {NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x60"},
	    {NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x60"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x60"},
	    {NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x60"},
	    {NV4097_SET_VERTEX_TEXTURE_FILTER + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_FILTER + 0x60"},
	    {NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x60 / 4,
	        "NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x60"},
	    {NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x60 / 4,
	        "NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x60"},
	    {NV4097_SET_VIEWPORT_HORIZONTAL, "NV4097_SET_VIEWPORT_HORIZONTAL"},
	    {NV4097_SET_VIEWPORT_VERTICAL, "NV4097_SET_VIEWPORT_VERTICAL"},
	    {NV4097_SET_VIEWPORT_OFFSET, "NV4097_SET_VIEWPORT_OFFSET"},
	    {NV4097_SET_VIEWPORT_SCALE, "NV4097_SET_VIEWPORT_SCALE"},
	    {NV4097_SET_POLY_OFFSET_LINE_ENABLE, "NV4097_SET_POLY_OFFSET_LINE_ENABLE"},
	    {NV4097_SET_POLY_OFFSET_FILL_ENABLE, "NV4097_SET_POLY_OFFSET_FILL_ENABLE"},
	    {NV4097_SET_DEPTH_FUNC, "NV4097_SET_DEPTH_FUNC"},
	    {NV4097_SET_DEPTH_MASK, "NV4097_SET_DEPTH_MASK"},
	    {NV4097_SET_DEPTH_TEST_ENABLE, "NV4097_SET_DEPTH_TEST_ENABLE"},
	    {NV4097_SET_POLYGON_OFFSET_SCALE_FACTOR, "NV4097_SET_POLYGON_OFFSET_SCALE_FACTOR"},
	    {NV4097_SET_POLYGON_OFFSET_BIAS, "NV4097_SET_POLYGON_OFFSET_BIAS"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M, "NV4097_SET_VERTEX_DATA_SCALED4S_M"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 4 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 4"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 8 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 8"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 12 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 12"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 16 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 16"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 20 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 20"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 24 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 24"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 28 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 28"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 32 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 32"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 36 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 36"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 40 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 40"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 44 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 44"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 48 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 48"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 52 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 52"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 56 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 56"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 60 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 60"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 64 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 64"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 68 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 68"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 72 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 72"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 76 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 76"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 80 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 80"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 84 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 84"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 88 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 88"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 92 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 92"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 96 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 96"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 100 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 100"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 104 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 104"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 108 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 108"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 112 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 112"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 116 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 116"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 120 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 120"},
	    {NV4097_SET_VERTEX_DATA_SCALED4S_M + 124 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 124"},
	    {NV4097_SET_TEXTURE_CONTROL2, "NV4097_SET_TEXTURE_CONTROL2"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 4 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 4"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 8 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 8"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 12 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 12"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 16 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 16"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 20 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 20"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 24 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 24"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 28 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 28"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 32 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 32"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 36 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 36"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 40 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 40"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 44 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 44"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 48 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 48"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 52 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 52"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 56 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 56"},
	    {NV4097_SET_TEXTURE_CONTROL2 + 60 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 60"},
	    {NV4097_SET_TEX_COORD_CONTROL, "NV4097_SET_TEX_COORD_CONTROL"},
	    {NV4097_SET_TEX_COORD_CONTROL + 4 / 4, "NV4097_SET_TEX_COORD_CONTROL + 4"},
	    {NV4097_SET_TEX_COORD_CONTROL + 8 / 4, "NV4097_SET_TEX_COORD_CONTROL + 8"},
	    {NV4097_SET_TEX_COORD_CONTROL + 12 / 4, "NV4097_SET_TEX_COORD_CONTROL + 12"},
	    {NV4097_SET_TEX_COORD_CONTROL + 16 / 4, "NV4097_SET_TEX_COORD_CONTROL + 16"},
	    {NV4097_SET_TEX_COORD_CONTROL + 20 / 4, "NV4097_SET_TEX_COORD_CONTROL + 20"},
	    {NV4097_SET_TEX_COORD_CONTROL + 24 / 4, "NV4097_SET_TEX_COORD_CONTROL + 24"},
	    {NV4097_SET_TEX_COORD_CONTROL + 28 / 4, "NV4097_SET_TEX_COORD_CONTROL + 28"},
	    {NV4097_SET_TEX_COORD_CONTROL + 32 / 4, "NV4097_SET_TEX_COORD_CONTROL + 32"},
	    {NV4097_SET_TEX_COORD_CONTROL + 36 / 4, "NV4097_SET_TEX_COORD_CONTROL + 36"},
	    {NV4097_SET_TRANSFORM_PROGRAM, "NV4097_SET_TRANSFORM_PROGRAM"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 4 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 4"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 8 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 8"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 12 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 12"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 16 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 16"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 20 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 20"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 24 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 24"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 28 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 28"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 32 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 32"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 36 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 36"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 40 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 40"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 44 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 44"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 48 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 48"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 52 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 52"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 56 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 56"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 60 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 60"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 64 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 64"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 68 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 68"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 72 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 72"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 76 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 76"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 80 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 80"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 84 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 84"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 88 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 88"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 92 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 92"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 96 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 96"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 100 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 100"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 104 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 104"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 108 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 108"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 112 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 112"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 116 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 116"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 120 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 120"},
	    {NV4097_SET_TRANSFORM_PROGRAM + 124 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 124"},
	    {NV4097_SET_TWO_SIDE_LIGHT_EN, "NV4097_SET_TWO_SIDE_LIGHT_EN"},
	    {NV4097_CLEAR_ZCULL_SURFACE, "NV4097_CLEAR_ZCULL_SURFACE"},
	    {NV4097_SET_USER_CLIP_PLANE_CONTROL, "NV4097_SET_USER_CLIP_PLANE_CONTROL"},
	    {NV4097_SET_POLYGON_STIPPLE, "NV4097_SET_POLYGON_STIPPLE"},
	    {NV4097_SET_POLYGON_STIPPLE_PATTERN, "NV4097_SET_POLYGON_STIPPLE_PATTERN"},
	    {NV4097_SET_VERTEX_DATA3F_M, "NV4097_SET_VERTEX_DATA3F_M"},
	    {NV4097_SET_VERTEX_DATA3F_M + 4 / 4, "NV4097_SET_VERTEX_DATA3F_M + 4"},
	    {NV4097_SET_VERTEX_DATA3F_M + 8 / 4, "NV4097_SET_VERTEX_DATA3F_M + 8"},
	    {NV4097_SET_VERTEX_DATA3F_M + 12 / 4, "NV4097_SET_VERTEX_DATA3F_M + 12"},
	    {NV4097_SET_VERTEX_DATA3F_M + 16 / 4, "NV4097_SET_VERTEX_DATA3F_M + 16"},
	    {NV4097_SET_VERTEX_DATA3F_M + 20 / 4, "NV4097_SET_VERTEX_DATA3F_M + 20"},
	    {NV4097_SET_VERTEX_DATA3F_M + 24 / 4, "NV4097_SET_VERTEX_DATA3F_M + 24"},
	    {NV4097_SET_VERTEX_DATA3F_M + 28 / 4, "NV4097_SET_VERTEX_DATA3F_M + 28"},
	    {NV4097_SET_VERTEX_DATA3F_M + 32 / 4, "NV4097_SET_VERTEX_DATA3F_M + 32"},
	    {NV4097_SET_VERTEX_DATA3F_M + 36 / 4, "NV4097_SET_VERTEX_DATA3F_M + 36"},
	    {NV4097_SET_VERTEX_DATA3F_M + 40 / 4, "NV4097_SET_VERTEX_DATA3F_M + 40"},
	    {NV4097_SET_VERTEX_DATA3F_M + 44 / 4, "NV4097_SET_VERTEX_DATA3F_M + 44"},
	    {NV4097_SET_VERTEX_DATA3F_M + 48 / 4, "NV4097_SET_VERTEX_DATA3F_M + 48"},
	    {NV4097_SET_VERTEX_DATA3F_M + 52 / 4, "NV4097_SET_VERTEX_DATA3F_M + 52"},
	    {NV4097_SET_VERTEX_DATA3F_M + 56 / 4, "NV4097_SET_VERTEX_DATA3F_M + 56"},
	    {NV4097_SET_VERTEX_DATA3F_M + 60 / 4, "NV4097_SET_VERTEX_DATA3F_M + 60"},
	    {NV4097_SET_VERTEX_DATA3F_M + 64 / 4, "NV4097_SET_VERTEX_DATA3F_M + 64"},
	    {NV4097_SET_VERTEX_DATA3F_M + 68 / 4, "NV4097_SET_VERTEX_DATA3F_M + 68"},
	    {NV4097_SET_VERTEX_DATA3F_M + 72 / 4, "NV4097_SET_VERTEX_DATA3F_M + 72"},
	    {NV4097_SET_VERTEX_DATA3F_M + 76 / 4, "NV4097_SET_VERTEX_DATA3F_M + 76"},
	    {NV4097_SET_VERTEX_DATA3F_M + 80 / 4, "NV4097_SET_VERTEX_DATA3F_M + 80"},
	    {NV4097_SET_VERTEX_DATA3F_M + 84 / 4, "NV4097_SET_VERTEX_DATA3F_M + 84"},
	    {NV4097_SET_VERTEX_DATA3F_M + 88 / 4, "NV4097_SET_VERTEX_DATA3F_M + 88"},
	    {NV4097_SET_VERTEX_DATA3F_M + 92 / 4, "NV4097_SET_VERTEX_DATA3F_M + 92"},
	    {NV4097_SET_VERTEX_DATA3F_M + 96 / 4, "NV4097_SET_VERTEX_DATA3F_M + 96"},
	    {NV4097_SET_VERTEX_DATA3F_M + 100 / 4, "NV4097_SET_VERTEX_DATA3F_M + 100"},
	    {NV4097_SET_VERTEX_DATA3F_M + 104 / 4, "NV4097_SET_VERTEX_DATA3F_M + 104"},
	    {NV4097_SET_VERTEX_DATA3F_M + 108 / 4, "NV4097_SET_VERTEX_DATA3F_M + 108"},
	    {NV4097_SET_VERTEX_DATA3F_M + 112 / 4, "NV4097_SET_VERTEX_DATA3F_M + 112"},
	    {NV4097_SET_VERTEX_DATA3F_M + 116 / 4, "NV4097_SET_VERTEX_DATA3F_M + 116"},
	    {NV4097_SET_VERTEX_DATA3F_M + 120 / 4, "NV4097_SET_VERTEX_DATA3F_M + 120"},
	    {NV4097_SET_VERTEX_DATA3F_M + 124 / 4, "NV4097_SET_VERTEX_DATA3F_M + 124"},
	    {NV4097_SET_VERTEX_DATA3F_M + 128 / 4, "NV4097_SET_VERTEX_DATA3F_M + 128"},
	    {NV4097_SET_VERTEX_DATA3F_M + 132 / 4, "NV4097_SET_VERTEX_DATA3F_M + 132"},
	    {NV4097_SET_VERTEX_DATA3F_M + 136 / 4, "NV4097_SET_VERTEX_DATA3F_M + 136"},
	    {NV4097_SET_VERTEX_DATA3F_M + 140 / 4, "NV4097_SET_VERTEX_DATA3F_M + 140"},
	    {NV4097_SET_VERTEX_DATA3F_M + 144 / 4, "NV4097_SET_VERTEX_DATA3F_M + 144"},
	    {NV4097_SET_VERTEX_DATA3F_M + 148 / 4, "NV4097_SET_VERTEX_DATA3F_M + 148"},
	    {NV4097_SET_VERTEX_DATA3F_M + 152 / 4, "NV4097_SET_VERTEX_DATA3F_M + 152"},
	    {NV4097_SET_VERTEX_DATA3F_M + 156 / 4, "NV4097_SET_VERTEX_DATA3F_M + 156"},
	    {NV4097_SET_VERTEX_DATA3F_M + 160 / 4, "NV4097_SET_VERTEX_DATA3F_M + 160"},
	    {NV4097_SET_VERTEX_DATA3F_M + 164 / 4, "NV4097_SET_VERTEX_DATA3F_M + 164"},
	    {NV4097_SET_VERTEX_DATA3F_M + 168 / 4, "NV4097_SET_VERTEX_DATA3F_M + 168"},
	    {NV4097_SET_VERTEX_DATA3F_M + 172 / 4, "NV4097_SET_VERTEX_DATA3F_M + 172"},
	    {NV4097_SET_VERTEX_DATA3F_M + 176 / 4, "NV4097_SET_VERTEX_DATA3F_M + 176"},
	    {NV4097_SET_VERTEX_DATA3F_M + 180 / 4, "NV4097_SET_VERTEX_DATA3F_M + 180"},
	    {NV4097_SET_VERTEX_DATA3F_M + 184 / 4, "NV4097_SET_VERTEX_DATA3F_M + 184"},
	    {NV4097_SET_VERTEX_DATA3F_M + 188 / 4, "NV4097_SET_VERTEX_DATA3F_M + 188"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 4 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 4"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 8 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 8"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 12 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 12"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 16 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 16"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 20 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 20"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 24 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 24"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 28 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 28"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 32 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 32"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 36 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 36"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 40 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 40"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 44 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 44"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 48 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 48"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 52 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 52"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 56 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 56"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 60 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 60"},
	    {NV4097_INVALIDATE_VERTEX_CACHE_FILE, "NV4097_INVALIDATE_VERTEX_CACHE_FILE"},
	    {NV4097_INVALIDATE_VERTEX_FILE, "NV4097_INVALIDATE_VERTEX_FILE"},
	    {NV4097_SET_VERTEX_DATA_BASE_OFFSET, "NV4097_SET_VERTEX_DATA_BASE_OFFSET"},
	    {NV4097_SET_VERTEX_DATA_BASE_INDEX, "NV4097_SET_VERTEX_DATA_BASE_INDEX"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 4 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 4"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 8 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 8"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 12 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 12"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 16 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 16"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 20 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 20"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 24 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 24"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 28 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 28"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 32 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 32"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 36 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 36"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 40 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 40"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 44 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 44"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 48 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 48"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 52 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 52"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 56 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 56"},
	    {NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 60 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 60"},
	    {NV4097_CLEAR_REPORT_VALUE, "NV4097_CLEAR_REPORT_VALUE"},
	    {NV4097_SET_ZPASS_PIXEL_COUNT_ENABLE, "NV4097_SET_ZPASS_PIXEL_COUNT_ENABLE"},
	    {NV4097_GET_REPORT, "NV4097_GET_REPORT"},
	    {NV4097_SET_ZCULL_STATS_ENABLE, "NV4097_SET_ZCULL_STATS_ENABLE"},
	    {NV4097_SET_BEGIN_END, "NV4097_SET_BEGIN_END"},
	    {NV4097_ARRAY_ELEMENT16, "NV4097_ARRAY_ELEMENT16"},
	    {NV4097_ARRAY_ELEMENT32, "NV4097_ARRAY_ELEMENT32"}, {NV4097_DRAW_ARRAYS, "NV4097_DRAW_ARRAYS"},
	    {NV4097_INLINE_ARRAY, "NV4097_INLINE_ARRAY"},
	    {NV4097_SET_INDEX_ARRAY_ADDRESS, "NV4097_SET_INDEX_ARRAY_ADDRESS"},
	    {NV4097_SET_INDEX_ARRAY_DMA, "NV4097_SET_INDEX_ARRAY_DMA"},
	    {NV4097_DRAW_INDEX_ARRAY, "NV4097_DRAW_INDEX_ARRAY"},
	    {NV4097_SET_FRONT_POLYGON_MODE, "NV4097_SET_FRONT_POLYGON_MODE"},
	    {NV4097_SET_BACK_POLYGON_MODE, "NV4097_SET_BACK_POLYGON_MODE"},
	    {NV4097_SET_CULL_FACE, "NV4097_SET_CULL_FACE"},
	    {NV4097_SET_FRONT_FACE, "NV4097_SET_FRONT_FACE"},
	    {NV4097_SET_POLY_SMOOTH_ENABLE, "NV4097_SET_POLY_SMOOTH_ENABLE"},
	    {NV4097_SET_CULL_FACE_ENABLE, "NV4097_SET_CULL_FACE_ENABLE"},
	    {NV4097_SET_TEXTURE_CONTROL3, "NV4097_SET_TEXTURE_CONTROL3"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 4 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 4"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 8 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 8"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 12 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 12"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 16 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 16"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 20 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 20"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 24 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 24"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 28 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 28"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 32 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 32"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 36 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 36"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 40 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 40"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 44 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 44"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 48 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 48"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 52 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 52"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 56 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 56"},
	    {NV4097_SET_TEXTURE_CONTROL3 + 60 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 60"},
	    {NV4097_SET_VERTEX_DATA2F_M, "NV4097_SET_VERTEX_DATA2F_M"},
	    {NV4097_SET_VERTEX_DATA2F_M + 4 / 4, "NV4097_SET_VERTEX_DATA2F_M + 4"},
	    {NV4097_SET_VERTEX_DATA2F_M + 8 / 4, "NV4097_SET_VERTEX_DATA2F_M + 8"},
	    {NV4097_SET_VERTEX_DATA2F_M + 12 / 4, "NV4097_SET_VERTEX_DATA2F_M + 12"},
	    {NV4097_SET_VERTEX_DATA2F_M + 16 / 4, "NV4097_SET_VERTEX_DATA2F_M + 16"},
	    {NV4097_SET_VERTEX_DATA2F_M + 20 / 4, "NV4097_SET_VERTEX_DATA2F_M + 20"},
	    {NV4097_SET_VERTEX_DATA2F_M + 24 / 4, "NV4097_SET_VERTEX_DATA2F_M + 24"},
	    {NV4097_SET_VERTEX_DATA2F_M + 28 / 4, "NV4097_SET_VERTEX_DATA2F_M + 28"},
	    {NV4097_SET_VERTEX_DATA2F_M + 32 / 4, "NV4097_SET_VERTEX_DATA2F_M + 32"},
	    {NV4097_SET_VERTEX_DATA2F_M + 36 / 4, "NV4097_SET_VERTEX_DATA2F_M + 36"},
	    {NV4097_SET_VERTEX_DATA2F_M + 40 / 4, "NV4097_SET_VERTEX_DATA2F_M + 40"},
	    {NV4097_SET_VERTEX_DATA2F_M + 44 / 4, "NV4097_SET_VERTEX_DATA2F_M + 44"},
	    {NV4097_SET_VERTEX_DATA2F_M + 48 / 4, "NV4097_SET_VERTEX_DATA2F_M + 48"},
	    {NV4097_SET_VERTEX_DATA2F_M + 52 / 4, "NV4097_SET_VERTEX_DATA2F_M + 52"},
	    {NV4097_SET_VERTEX_DATA2F_M + 56 / 4, "NV4097_SET_VERTEX_DATA2F_M + 56"},
	    {NV4097_SET_VERTEX_DATA2F_M + 60 / 4, "NV4097_SET_VERTEX_DATA2F_M + 60"},
	    {NV4097_SET_VERTEX_DATA2F_M + 64 / 4, "NV4097_SET_VERTEX_DATA2F_M + 64"},
	    {NV4097_SET_VERTEX_DATA2F_M + 68 / 4, "NV4097_SET_VERTEX_DATA2F_M + 68"},
	    {NV4097_SET_VERTEX_DATA2F_M + 72 / 4, "NV4097_SET_VERTEX_DATA2F_M + 72"},
	    {NV4097_SET_VERTEX_DATA2F_M + 76 / 4, "NV4097_SET_VERTEX_DATA2F_M + 76"},
	    {NV4097_SET_VERTEX_DATA2F_M + 80 / 4, "NV4097_SET_VERTEX_DATA2F_M + 80"},
	    {NV4097_SET_VERTEX_DATA2F_M + 84 / 4, "NV4097_SET_VERTEX_DATA2F_M + 84"},
	    {NV4097_SET_VERTEX_DATA2F_M + 88 / 4, "NV4097_SET_VERTEX_DATA2F_M + 88"},
	    {NV4097_SET_VERTEX_DATA2F_M + 92 / 4, "NV4097_SET_VERTEX_DATA2F_M + 92"},
	    {NV4097_SET_VERTEX_DATA2F_M + 96 / 4, "NV4097_SET_VERTEX_DATA2F_M + 96"},
	    {NV4097_SET_VERTEX_DATA2F_M + 100 / 4, "NV4097_SET_VERTEX_DATA2F_M + 100"},
	    {NV4097_SET_VERTEX_DATA2F_M + 104 / 4, "NV4097_SET_VERTEX_DATA2F_M + 104"},
	    {NV4097_SET_VERTEX_DATA2F_M + 108 / 4, "NV4097_SET_VERTEX_DATA2F_M + 108"},
	    {NV4097_SET_VERTEX_DATA2F_M + 112 / 4, "NV4097_SET_VERTEX_DATA2F_M + 112"},
	    {NV4097_SET_VERTEX_DATA2F_M + 116 / 4, "NV4097_SET_VERTEX_DATA2F_M + 116"},
	    {NV4097_SET_VERTEX_DATA2F_M + 120 / 4, "NV4097_SET_VERTEX_DATA2F_M + 120"},
	    {NV4097_SET_VERTEX_DATA2F_M + 124 / 4, "NV4097_SET_VERTEX_DATA2F_M + 124"},
	    {NV4097_SET_VERTEX_DATA2S_M, "NV4097_SET_VERTEX_DATA2S_M"},
	    {NV4097_SET_VERTEX_DATA2S_M + 4 / 4, "NV4097_SET_VERTEX_DATA2S_M + 4"},
	    {NV4097_SET_VERTEX_DATA2S_M + 8 / 4, "NV4097_SET_VERTEX_DATA2S_M + 8"},
	    {NV4097_SET_VERTEX_DATA2S_M + 12 / 4, "NV4097_SET_VERTEX_DATA2S_M + 12"},
	    {NV4097_SET_VERTEX_DATA2S_M + 16 / 4, "NV4097_SET_VERTEX_DATA2S_M + 16"},
	    {NV4097_SET_VERTEX_DATA2S_M + 20 / 4, "NV4097_SET_VERTEX_DATA2S_M + 20"},
	    {NV4097_SET_VERTEX_DATA2S_M + 24 / 4, "NV4097_SET_VERTEX_DATA2S_M + 24"},
	    {NV4097_SET_VERTEX_DATA2S_M + 28 / 4, "NV4097_SET_VERTEX_DATA2S_M + 28"},
	    {NV4097_SET_VERTEX_DATA2S_M + 32 / 4, "NV4097_SET_VERTEX_DATA2S_M + 32"},
	    {NV4097_SET_VERTEX_DATA2S_M + 36 / 4, "NV4097_SET_VERTEX_DATA2S_M + 36"},
	    {NV4097_SET_VERTEX_DATA2S_M + 40 / 4, "NV4097_SET_VERTEX_DATA2S_M + 40"},
	    {NV4097_SET_VERTEX_DATA2S_M + 44 / 4, "NV4097_SET_VERTEX_DATA2S_M + 44"},
	    {NV4097_SET_VERTEX_DATA2S_M + 48 / 4, "NV4097_SET_VERTEX_DATA2S_M + 48"},
	    {NV4097_SET_VERTEX_DATA2S_M + 52 / 4, "NV4097_SET_VERTEX_DATA2S_M + 52"},
	    {NV4097_SET_VERTEX_DATA2S_M + 56 / 4, "NV4097_SET_VERTEX_DATA2S_M + 56"},
	    {NV4097_SET_VERTEX_DATA2S_M + 60 / 4, "NV4097_SET_VERTEX_DATA2S_M + 60"},
	    {NV4097_SET_VERTEX_DATA4UB_M, "NV4097_SET_VERTEX_DATA4UB_M"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 4 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 4"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 8 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 8"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 12 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 12"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 16 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 16"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 20 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 20"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 24 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 24"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 28 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 28"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 32 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 32"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 36 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 36"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 40 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 40"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 44 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 44"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 48 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 48"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 52 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 52"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 56 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 56"},
	    {NV4097_SET_VERTEX_DATA4UB_M + 60 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 60"},
	    {NV4097_SET_VERTEX_DATA4S_M, "NV4097_SET_VERTEX_DATA4S_M"},
	    {NV4097_SET_VERTEX_DATA4S_M + 4 / 4, "NV4097_SET_VERTEX_DATA4S_M + 4"},
	    {NV4097_SET_VERTEX_DATA4S_M + 8 / 4, "NV4097_SET_VERTEX_DATA4S_M + 8"},
	    {NV4097_SET_VERTEX_DATA4S_M + 12 / 4, "NV4097_SET_VERTEX_DATA4S_M + 12"},
	    {NV4097_SET_VERTEX_DATA4S_M + 16 / 4, "NV4097_SET_VERTEX_DATA4S_M + 16"},
	    {NV4097_SET_VERTEX_DATA4S_M + 20 / 4, "NV4097_SET_VERTEX_DATA4S_M + 20"},
	    {NV4097_SET_VERTEX_DATA4S_M + 24 / 4, "NV4097_SET_VERTEX_DATA4S_M + 24"},
	    {NV4097_SET_VERTEX_DATA4S_M + 28 / 4, "NV4097_SET_VERTEX_DATA4S_M + 28"},
	    {NV4097_SET_VERTEX_DATA4S_M + 32 / 4, "NV4097_SET_VERTEX_DATA4S_M + 32"},
	    {NV4097_SET_VERTEX_DATA4S_M + 36 / 4, "NV4097_SET_VERTEX_DATA4S_M + 36"},
	    {NV4097_SET_VERTEX_DATA4S_M + 40 / 4, "NV4097_SET_VERTEX_DATA4S_M + 40"},
	    {NV4097_SET_VERTEX_DATA4S_M + 44 / 4, "NV4097_SET_VERTEX_DATA4S_M + 44"},
	    {NV4097_SET_VERTEX_DATA4S_M + 48 / 4, "NV4097_SET_VERTEX_DATA4S_M + 48"},
	    {NV4097_SET_VERTEX_DATA4S_M + 52 / 4, "NV4097_SET_VERTEX_DATA4S_M + 52"},
	    {NV4097_SET_VERTEX_DATA4S_M + 56 / 4, "NV4097_SET_VERTEX_DATA4S_M + 56"},
	    {NV4097_SET_VERTEX_DATA4S_M + 60 / 4, "NV4097_SET_VERTEX_DATA4S_M + 60"},
	    {NV4097_SET_VERTEX_DATA4S_M + 64 / 4, "NV4097_SET_VERTEX_DATA4S_M + 64"},
	    {NV4097_SET_VERTEX_DATA4S_M + 68 / 4, "NV4097_SET_VERTEX_DATA4S_M + 68"},
	    {NV4097_SET_VERTEX_DATA4S_M + 72 / 4, "NV4097_SET_VERTEX_DATA4S_M + 72"},
	    {NV4097_SET_VERTEX_DATA4S_M + 76 / 4, "NV4097_SET_VERTEX_DATA4S_M + 76"},
	    {NV4097_SET_VERTEX_DATA4S_M + 80 / 4, "NV4097_SET_VERTEX_DATA4S_M + 80"},
	    {NV4097_SET_VERTEX_DATA4S_M + 84 / 4, "NV4097_SET_VERTEX_DATA4S_M + 84"},
	    {NV4097_SET_VERTEX_DATA4S_M + 88 / 4, "NV4097_SET_VERTEX_DATA4S_M + 88"},
	    {NV4097_SET_VERTEX_DATA4S_M + 92 / 4, "NV4097_SET_VERTEX_DATA4S_M + 92"},
	    {NV4097_SET_VERTEX_DATA4S_M + 96 / 4, "NV4097_SET_VERTEX_DATA4S_M + 96"},
	    {NV4097_SET_VERTEX_DATA4S_M + 100 / 4, "NV4097_SET_VERTEX_DATA4S_M + 100"},
	    {NV4097_SET_VERTEX_DATA4S_M + 104 / 4, "NV4097_SET_VERTEX_DATA4S_M + 104"},
	    {NV4097_SET_VERTEX_DATA4S_M + 108 / 4, "NV4097_SET_VERTEX_DATA4S_M + 108"},
	    {NV4097_SET_VERTEX_DATA4S_M + 112 / 4, "NV4097_SET_VERTEX_DATA4S_M + 112"},
	    {NV4097_SET_VERTEX_DATA4S_M + 116 / 4, "NV4097_SET_VERTEX_DATA4S_M + 116"},
	    {NV4097_SET_VERTEX_DATA4S_M + 120 / 4, "NV4097_SET_VERTEX_DATA4S_M + 120"},
	    {NV4097_SET_VERTEX_DATA4S_M + 124 / 4, "NV4097_SET_VERTEX_DATA4S_M + 124"},
	    {NV4097_SET_TEXTURE_OFFSET, "NV4097_SET_TEXTURE_OFFSET"},
	    {NV4097_SET_TEXTURE_FORMAT, "NV4097_SET_TEXTURE_FORMAT"},
	    {NV4097_SET_TEXTURE_ADDRESS, "NV4097_SET_TEXTURE_ADDRESS"},
	    {NV4097_SET_TEXTURE_CONTROL0, "NV4097_SET_TEXTURE_CONTROL0"},
	    {NV4097_SET_TEXTURE_CONTROL1, "NV4097_SET_TEXTURE_CONTROL1"},
	    {NV4097_SET_TEXTURE_FILTER, "NV4097_SET_TEXTURE_FILTER"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT, "NV4097_SET_TEXTURE_IMAGE_RECT"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR, "NV4097_SET_TEXTURE_BORDER_COLOR"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x20 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x20"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x20 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x20"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x20 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x20"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x20 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x20"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x20 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x20"},
	    {NV4097_SET_TEXTURE_FILTER + 0x20 / 4, "NV4097_SET_TEXTURE_FILTER + 0x20"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x20 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x20"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x20 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x20"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x40 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x40"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x40 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x40"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x40 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x40"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x40 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x40"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x40 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x40"},
	    {NV4097_SET_TEXTURE_FILTER + 0x40 / 4, "NV4097_SET_TEXTURE_FILTER + 0x40"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x40 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x40"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x40 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x40"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x60 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x60"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x60 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x60"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x60 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x60"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x60 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x60"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x60 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x60"},
	    {NV4097_SET_TEXTURE_FILTER + 0x60 / 4, "NV4097_SET_TEXTURE_FILTER + 0x60"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x60 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x60"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x60 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x60"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x80 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x80"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x80 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x80"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x80 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x80"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x80 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x80"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x80 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x80"},
	    {NV4097_SET_TEXTURE_FILTER + 0x80 / 4, "NV4097_SET_TEXTURE_FILTER + 0x80"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x80 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x80"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x80 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x80"},
	    {NV4097_SET_TEXTURE_OFFSET + 0xa0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0xa0"},
	    {NV4097_SET_TEXTURE_FORMAT + 0xa0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0xa0"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0xa0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0xa0"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0xa0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0xa0"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0xa0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0xa0"},
	    {NV4097_SET_TEXTURE_FILTER + 0xa0 / 4, "NV4097_SET_TEXTURE_FILTER + 0xa0"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0xa0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0xa0"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0xa0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0xa0"},
	    {NV4097_SET_TEXTURE_OFFSET + 0xc0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0xc0"},
	    {NV4097_SET_TEXTURE_FORMAT + 0xc0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0xc0"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0xc0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0xc0"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0xc0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0xc0"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0xc0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0xc0"},
	    {NV4097_SET_TEXTURE_FILTER + 0xc0 / 4, "NV4097_SET_TEXTURE_FILTER + 0xc0"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0xc0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0xc0"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0xc0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0xc0"},
	    {NV4097_SET_TEXTURE_OFFSET + 0xe0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0xe0"},
	    {NV4097_SET_TEXTURE_FORMAT + 0xe0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0xe0"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0xe0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0xe0"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0xe0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0xe0"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0xe0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0xe0"},
	    {NV4097_SET_TEXTURE_FILTER + 0xe0 / 4, "NV4097_SET_TEXTURE_FILTER + 0xe0"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0xe0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0xe0"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0xe0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0xe0"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x100 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x100"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x100 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x100"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x100 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x100"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x100 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x100"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x100 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x100"},
	    {NV4097_SET_TEXTURE_FILTER + 0x100 / 4, "NV4097_SET_TEXTURE_FILTER + 0x100"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x100 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x100"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x100 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x100"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x120 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x120"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x120 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x120"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x120 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x120"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x120 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x120"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x120 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x120"},
	    {NV4097_SET_TEXTURE_FILTER + 0x120 / 4, "NV4097_SET_TEXTURE_FILTER + 0x120"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x120 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x120"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x120 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x120"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x140 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x140"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x140 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x140"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x140 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x140"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x140 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x140"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x140 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x140"},
	    {NV4097_SET_TEXTURE_FILTER + 0x140 / 4, "NV4097_SET_TEXTURE_FILTER + 0x140"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x140 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x140"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x140 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x140"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x160 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x160"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x160 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x160"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x160 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x160"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x160 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x160"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x160 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x160"},
	    {NV4097_SET_TEXTURE_FILTER + 0x160 / 4, "NV4097_SET_TEXTURE_FILTER + 0x160"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x160 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x160"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x160 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x160"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x180 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x180"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x180 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x180"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x180 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x180"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x180 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x180"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x180 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x180"},
	    {NV4097_SET_TEXTURE_FILTER + 0x180 / 4, "NV4097_SET_TEXTURE_FILTER + 0x180"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x180 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x180"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x180 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x180"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x1a0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x1a0"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x1a0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x1a0"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x1a0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x1a0"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x1a0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x1a0"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x1a0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x1a0"},
	    {NV4097_SET_TEXTURE_FILTER + 0x1a0 / 4, "NV4097_SET_TEXTURE_FILTER + 0x1a0"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x1a0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x1a0"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x1a0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x1a0"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x1c0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x1c0"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x1c0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x1c0"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x1c0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x1c0"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x1c0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x1c0"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x1c0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x1c0"},
	    {NV4097_SET_TEXTURE_FILTER + 0x1c0 / 4, "NV4097_SET_TEXTURE_FILTER + 0x1c0"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x1c0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x1c0"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x1c0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x1c0"},
	    {NV4097_SET_TEXTURE_OFFSET + 0x1e0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x1e0"},
	    {NV4097_SET_TEXTURE_FORMAT + 0x1e0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x1e0"},
	    {NV4097_SET_TEXTURE_ADDRESS + 0x1e0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x1e0"},
	    {NV4097_SET_TEXTURE_CONTROL0 + 0x1e0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x1e0"},
	    {NV4097_SET_TEXTURE_CONTROL1 + 0x1e0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x1e0"},
	    {NV4097_SET_TEXTURE_FILTER + 0x1e0 / 4, "NV4097_SET_TEXTURE_FILTER + 0x1e0"},
	    {NV4097_SET_TEXTURE_IMAGE_RECT + 0x1e0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x1e0"},
	    {NV4097_SET_TEXTURE_BORDER_COLOR + 0x1e0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x1e0"},
	    {NV4097_SET_VERTEX_DATA4F_M, "NV4097_SET_VERTEX_DATA4F_M"},
	    {NV4097_SET_VERTEX_DATA4F_M + 4 / 4, "NV4097_SET_VERTEX_DATA4F_M + 4"},
	    {NV4097_SET_VERTEX_DATA4F_M + 8 / 4, "NV4097_SET_VERTEX_DATA4F_M + 8"},
	    {NV4097_SET_VERTEX_DATA4F_M + 12 / 4, "NV4097_SET_VERTEX_DATA4F_M + 12"},
	    {NV4097_SET_VERTEX_DATA4F_M + 16 / 4, "NV4097_SET_VERTEX_DATA4F_M + 16"},
	    {NV4097_SET_VERTEX_DATA4F_M + 20 / 4, "NV4097_SET_VERTEX_DATA4F_M + 20"},
	    {NV4097_SET_VERTEX_DATA4F_M + 24 / 4, "NV4097_SET_VERTEX_DATA4F_M + 24"},
	    {NV4097_SET_VERTEX_DATA4F_M + 28 / 4, "NV4097_SET_VERTEX_DATA4F_M + 28"},
	    {NV4097_SET_VERTEX_DATA4F_M + 32 / 4, "NV4097_SET_VERTEX_DATA4F_M + 32"},
	    {NV4097_SET_VERTEX_DATA4F_M + 36 / 4, "NV4097_SET_VERTEX_DATA4F_M + 36"},
	    {NV4097_SET_VERTEX_DATA4F_M + 40 / 4, "NV4097_SET_VERTEX_DATA4F_M + 40"},
	    {NV4097_SET_VERTEX_DATA4F_M + 44 / 4, "NV4097_SET_VERTEX_DATA4F_M + 44"},
	    {NV4097_SET_VERTEX_DATA4F_M + 48 / 4, "NV4097_SET_VERTEX_DATA4F_M + 48"},
	    {NV4097_SET_VERTEX_DATA4F_M + 52 / 4, "NV4097_SET_VERTEX_DATA4F_M + 52"},
	    {NV4097_SET_VERTEX_DATA4F_M + 56 / 4, "NV4097_SET_VERTEX_DATA4F_M + 56"},
	    {NV4097_SET_VERTEX_DATA4F_M + 60 / 4, "NV4097_SET_VERTEX_DATA4F_M + 60"},
	    {NV4097_SET_VERTEX_DATA4F_M + 64 / 4, "NV4097_SET_VERTEX_DATA4F_M + 64"},
	    {NV4097_SET_VERTEX_DATA4F_M + 68 / 4, "NV4097_SET_VERTEX_DATA4F_M + 68"},
	    {NV4097_SET_VERTEX_DATA4F_M + 72 / 4, "NV4097_SET_VERTEX_DATA4F_M + 72"},
	    {NV4097_SET_VERTEX_DATA4F_M + 76 / 4, "NV4097_SET_VERTEX_DATA4F_M + 76"},
	    {NV4097_SET_VERTEX_DATA4F_M + 80 / 4, "NV4097_SET_VERTEX_DATA4F_M + 80"},
	    {NV4097_SET_VERTEX_DATA4F_M + 84 / 4, "NV4097_SET_VERTEX_DATA4F_M + 84"},
	    {NV4097_SET_VERTEX_DATA4F_M + 88 / 4, "NV4097_SET_VERTEX_DATA4F_M + 88"},
	    {NV4097_SET_VERTEX_DATA4F_M + 92 / 4, "NV4097_SET_VERTEX_DATA4F_M + 92"},
	    {NV4097_SET_VERTEX_DATA4F_M + 96 / 4, "NV4097_SET_VERTEX_DATA4F_M + 96"},
	    {NV4097_SET_VERTEX_DATA4F_M + 100 / 4, "NV4097_SET_VERTEX_DATA4F_M + 100"},
	    {NV4097_SET_VERTEX_DATA4F_M + 104 / 4, "NV4097_SET_VERTEX_DATA4F_M + 104"},
	    {NV4097_SET_VERTEX_DATA4F_M + 108 / 4, "NV4097_SET_VERTEX_DATA4F_M + 108"},
	    {NV4097_SET_VERTEX_DATA4F_M + 112 / 4, "NV4097_SET_VERTEX_DATA4F_M + 112"},
	    {NV4097_SET_VERTEX_DATA4F_M + 116 / 4, "NV4097_SET_VERTEX_DATA4F_M + 116"},
	    {NV4097_SET_VERTEX_DATA4F_M + 120 / 4, "NV4097_SET_VERTEX_DATA4F_M + 120"},
	    {NV4097_SET_VERTEX_DATA4F_M + 124 / 4, "NV4097_SET_VERTEX_DATA4F_M + 124"},
	    {NV4097_SET_VERTEX_DATA4F_M + 128 / 4, "NV4097_SET_VERTEX_DATA4F_M + 128"},
	    {NV4097_SET_VERTEX_DATA4F_M + 132 / 4, "NV4097_SET_VERTEX_DATA4F_M + 132"},
	    {NV4097_SET_VERTEX_DATA4F_M + 136 / 4, "NV4097_SET_VERTEX_DATA4F_M + 136"},
	    {NV4097_SET_VERTEX_DATA4F_M + 140 / 4, "NV4097_SET_VERTEX_DATA4F_M + 140"},
	    {NV4097_SET_VERTEX_DATA4F_M + 144 / 4, "NV4097_SET_VERTEX_DATA4F_M + 144"},
	    {NV4097_SET_VERTEX_DATA4F_M + 148 / 4, "NV4097_SET_VERTEX_DATA4F_M + 148"},
	    {NV4097_SET_VERTEX_DATA4F_M + 152 / 4, "NV4097_SET_VERTEX_DATA4F_M + 152"},
	    {NV4097_SET_VERTEX_DATA4F_M + 156 / 4, "NV4097_SET_VERTEX_DATA4F_M + 156"},
	    {NV4097_SET_VERTEX_DATA4F_M + 160 / 4, "NV4097_SET_VERTEX_DATA4F_M + 160"},
	    {NV4097_SET_VERTEX_DATA4F_M + 164 / 4, "NV4097_SET_VERTEX_DATA4F_M + 164"},
	    {NV4097_SET_VERTEX_DATA4F_M + 168 / 4, "NV4097_SET_VERTEX_DATA4F_M + 168"},
	    {NV4097_SET_VERTEX_DATA4F_M + 172 / 4, "NV4097_SET_VERTEX_DATA4F_M + 172"},
	    {NV4097_SET_VERTEX_DATA4F_M + 176 / 4, "NV4097_SET_VERTEX_DATA4F_M + 176"},
	    {NV4097_SET_VERTEX_DATA4F_M + 180 / 4, "NV4097_SET_VERTEX_DATA4F_M + 180"},
	    {NV4097_SET_VERTEX_DATA4F_M + 184 / 4, "NV4097_SET_VERTEX_DATA4F_M + 184"},
	    {NV4097_SET_VERTEX_DATA4F_M + 188 / 4, "NV4097_SET_VERTEX_DATA4F_M + 188"},
	    {NV4097_SET_VERTEX_DATA4F_M + 192 / 4, "NV4097_SET_VERTEX_DATA4F_M + 192"},
	    {NV4097_SET_VERTEX_DATA4F_M + 196 / 4, "NV4097_SET_VERTEX_DATA4F_M + 196"},
	    {NV4097_SET_VERTEX_DATA4F_M + 200 / 4, "NV4097_SET_VERTEX_DATA4F_M + 200"},
	    {NV4097_SET_VERTEX_DATA4F_M + 204 / 4, "NV4097_SET_VERTEX_DATA4F_M + 204"},
	    {NV4097_SET_VERTEX_DATA4F_M + 208 / 4, "NV4097_SET_VERTEX_DATA4F_M + 208"},
	    {NV4097_SET_VERTEX_DATA4F_M + 212 / 4, "NV4097_SET_VERTEX_DATA4F_M + 212"},
	    {NV4097_SET_VERTEX_DATA4F_M + 216 / 4, "NV4097_SET_VERTEX_DATA4F_M + 216"},
	    {NV4097_SET_VERTEX_DATA4F_M + 220 / 4, "NV4097_SET_VERTEX_DATA4F_M + 220"},
	    {NV4097_SET_VERTEX_DATA4F_M + 224 / 4, "NV4097_SET_VERTEX_DATA4F_M + 224"},
	    {NV4097_SET_VERTEX_DATA4F_M + 228 / 4, "NV4097_SET_VERTEX_DATA4F_M + 228"},
	    {NV4097_SET_VERTEX_DATA4F_M + 232 / 4, "NV4097_SET_VERTEX_DATA4F_M + 232"},
	    {NV4097_SET_VERTEX_DATA4F_M + 236 / 4, "NV4097_SET_VERTEX_DATA4F_M + 236"},
	    {NV4097_SET_VERTEX_DATA4F_M + 240 / 4, "NV4097_SET_VERTEX_DATA4F_M + 240"},
	    {NV4097_SET_VERTEX_DATA4F_M + 244 / 4, "NV4097_SET_VERTEX_DATA4F_M + 244"},
	    {NV4097_SET_VERTEX_DATA4F_M + 248 / 4, "NV4097_SET_VERTEX_DATA4F_M + 248"},
	    {NV4097_SET_VERTEX_DATA4F_M + 252 / 4, "NV4097_SET_VERTEX_DATA4F_M + 252"},
	    {NV4097_SET_SHADER_CONTROL, "NV4097_SET_SHADER_CONTROL"},
	    {NV4097_SET_SEMAPHORE_OFFSET, "NV4097_SET_SEMAPHORE_OFFSET"},
	    {NV4097_BACK_END_WRITE_SEMAPHORE_RELEASE, "NV4097_BACK_END_WRITE_SEMAPHORE_RELEASE"},
	    {NV4097_TEXTURE_READ_SEMAPHORE_RELEASE, "NV4097_TEXTURE_READ_SEMAPHORE_RELEASE"},
	    {NV4097_SET_ZMIN_MAX_CONTROL, "NV4097_SET_ZMIN_MAX_CONTROL"},
	    {NV4097_SET_ANTI_ALIASING_CONTROL, "NV4097_SET_ANTI_ALIASING_CONTROL"},
	    {NV4097_SET_ZCULL_EN, "NV4097_SET_ZCULL_EN"},
	    {NV4097_SET_SHADER_WINDOW, "NV4097_SET_SHADER_WINDOW"},
	    {NV4097_SET_ZSTENCIL_CLEAR_VALUE, "NV4097_SET_ZSTENCIL_CLEAR_VALUE"},
	    {NV4097_SET_COLOR_CLEAR_VALUE, "NV4097_SET_COLOR_CLEAR_VALUE"},
	    {NV4097_CLEAR_SURFACE, "NV4097_CLEAR_SURFACE"},
	    {NV4097_SET_RESTART_INDEX_ENABLE, "NV4097_SET_RESTART_INDEX_ENABLE"},
	    {NV4097_SET_RESTART_INDEX, "NV4097_SET_RESTART_INDEX"},
	    {NV4097_SET_LINE_STIPPLE, "NV4097_SET_LINE_STIPPLE"},
	    {NV4097_SET_LINE_STIPPLE_PATTERN, "NV4097_SET_LINE_STIPPLE_PATTERN"},
	    {NV4097_SET_VERTEX_DATA1F_M, "NV4097_SET_VERTEX_DATA1F_M"},
	    {NV4097_SET_VERTEX_DATA1F_M + 4 / 4, "NV4097_SET_VERTEX_DATA1F_M + 4"},
	    {NV4097_SET_VERTEX_DATA1F_M + 8 / 4, "NV4097_SET_VERTEX_DATA1F_M + 8"},
	    {NV4097_SET_VERTEX_DATA1F_M + 12 / 4, "NV4097_SET_VERTEX_DATA1F_M + 12"},
	    {NV4097_SET_VERTEX_DATA1F_M + 16 / 4, "NV4097_SET_VERTEX_DATA1F_M + 16"},
	    {NV4097_SET_VERTEX_DATA1F_M + 20 / 4, "NV4097_SET_VERTEX_DATA1F_M + 20"},
	    {NV4097_SET_VERTEX_DATA1F_M + 24 / 4, "NV4097_SET_VERTEX_DATA1F_M + 24"},
	    {NV4097_SET_VERTEX_DATA1F_M + 28 / 4, "NV4097_SET_VERTEX_DATA1F_M + 28"},
	    {NV4097_SET_VERTEX_DATA1F_M + 32 / 4, "NV4097_SET_VERTEX_DATA1F_M + 32"},
	    {NV4097_SET_VERTEX_DATA1F_M + 36 / 4, "NV4097_SET_VERTEX_DATA1F_M + 36"},
	    {NV4097_SET_VERTEX_DATA1F_M + 40 / 4, "NV4097_SET_VERTEX_DATA1F_M + 40"},
	    {NV4097_SET_VERTEX_DATA1F_M + 44 / 4, "NV4097_SET_VERTEX_DATA1F_M + 44"},
	    {NV4097_SET_VERTEX_DATA1F_M + 48 / 4, "NV4097_SET_VERTEX_DATA1F_M + 48"},
	    {NV4097_SET_VERTEX_DATA1F_M + 52 / 4, "NV4097_SET_VERTEX_DATA1F_M + 52"},
	    {NV4097_SET_VERTEX_DATA1F_M + 56 / 4, "NV4097_SET_VERTEX_DATA1F_M + 56"},
	    {NV4097_SET_VERTEX_DATA1F_M + 60 / 4, "NV4097_SET_VERTEX_DATA1F_M + 60"},
	    {NV4097_SET_RENDER_ENABLE, "NV4097_SET_RENDER_ENABLE"},
	    {NV4097_SET_TRANSFORM_PROGRAM_LOAD, "NV4097_SET_TRANSFORM_PROGRAM_LOAD"},
	    {NV4097_SET_TRANSFORM_PROGRAM_START, "NV4097_SET_TRANSFORM_PROGRAM_START"},
	    {NV4097_SET_ZCULL_CONTROL0, "NV4097_SET_ZCULL_CONTROL0"},
	    {NV4097_SET_ZCULL_CONTROL1, "NV4097_SET_ZCULL_CONTROL1"},
	    {NV4097_SET_SCULL_CONTROL, "NV4097_SET_SCULL_CONTROL"},
	    {NV4097_SET_POINT_SIZE, "NV4097_SET_POINT_SIZE"},
	    {NV4097_SET_POINT_PARAMS_ENABLE, "NV4097_SET_POINT_PARAMS_ENABLE"},
	    {NV4097_SET_POINT_SPRITE_CONTROL, "NV4097_SET_POINT_SPRITE_CONTROL"},
	    {NV4097_SET_TRANSFORM_TIMEOUT, "NV4097_SET_TRANSFORM_TIMEOUT"},
	    {NV4097_SET_TRANSFORM_CONSTANT_LOAD, "NV4097_SET_TRANSFORM_CONSTANT_LOAD"},
	    {NV4097_SET_FREQUENCY_DIVIDER_OPERATION, "NV4097_SET_FREQUENCY_DIVIDER_OPERATION"},
	    {NV4097_SET_ATTRIB_COLOR, "NV4097_SET_ATTRIB_COLOR"},
	    {NV4097_SET_ATTRIB_TEX_COORD, "NV4097_SET_ATTRIB_TEX_COORD"},
	    {NV4097_SET_ATTRIB_TEX_COORD_EX, "NV4097_SET_ATTRIB_TEX_COORD_EX"},
	    {NV4097_SET_ATTRIB_UCLIP0, "NV4097_SET_ATTRIB_UCLIP0"},
	    {NV4097_SET_ATTRIB_UCLIP1, "NV4097_SET_ATTRIB_UCLIP1"},
	    {NV4097_INVALIDATE_L2, "NV4097_INVALIDATE_L2"},
	    {NV4097_SET_REDUCE_DST_COLOR, "NV4097_SET_REDUCE_DST_COLOR"},
	    {NV4097_SET_NO_PARANOID_TEXTURE_FETCHES, "NV4097_SET_NO_PARANOID_TEXTURE_FETCHES"},
	    {NV4097_SET_SHADER_PACKER, "NV4097_SET_SHADER_PACKER"},
	    {NV4097_SET_VERTEX_ATTRIB_INPUT_MASK, "NV4097_SET_VERTEX_ATTRIB_INPUT_MASK"},
	    {NV4097_SET_VERTEX_ATTRIB_OUTPUT_MASK, "NV4097_SET_VERTEX_ATTRIB_OUTPUT_MASK"},
	    {NV4097_SET_TRANSFORM_BRANCH_BITS, "NV4097_SET_TRANSFORM_BRANCH_BITS"},
	    {NV3062_SET_OBJECT, "NV3062_SET_OBJECT"},
	    {NV3062_SET_CONTEXT_DMA_NOTIFIES, "NV3062_SET_CONTEXT_DMA_NOTIFIES"},
	    {NV3062_SET_CONTEXT_DMA_IMAGE_SOURCE, "NV3062_SET_CONTEXT_DMA_IMAGE_SOURCE"},
	    {NV3062_SET_CONTEXT_DMA_IMAGE_DESTIN, "NV3062_SET_CONTEXT_DMA_IMAGE_DESTIN"},
	    {NV3062_SET_COLOR_FORMAT, "NV3062_SET_COLOR_FORMAT"}, {NV3062_SET_PITCH, "NV3062_SET_PITCH"},
	    {NV3062_SET_OFFSET_SOURCE, "NV3062_SET_OFFSET_SOURCE"},
	    {NV3062_SET_OFFSET_DESTIN, "NV3062_SET_OFFSET_DESTIN"}, {NV308A_POINT, "NV308A_POINT"},
	    {NV308A_SIZE_OUT, "NV308A_SIZE_OUT"}, {NV308A_SIZE_IN, "NV308A_SIZE_IN"},
	    {NV308A_COLOR, "NV308A_COLOR"},
	    {GCM_SET_USER_COMMAND, "GCM_SET_USER_COMMAND"},
	    {GCM_DRIVER_QUEUE, "GCM_DRIVER_QUEUE + 0x0"},
	    {GCM_DRIVER_QUEUE+1, "GCM_DRIVER_QUEUE + 0x4"},
	    {GCM_FLIP_HEAD, "GCM_FLIP_HEAD"},
	    {GCM_FLIP_HEAD+1, "GCM_FLIP_HEAD + 0x4"},
	};
}

std::string rsx::get_method_name(const u32 id)
{
	auto found = methods_name.find(id);
	if (found != methods_name.end()) {
		return std::string("CELL_GCM_") + found->second;
	}

	return fmt::format("Unknown/illegal method [0x%04x]", id << 2);
}

// Various parameter pretty printing function
namespace
{
	std::string ptr_to_string(u32 ptr)
	{
		return fmt::format("0x%08x", ptr);
	}

	std::string dma_mode(u32 arg)
	{
		switch (arg)
		{
		case CELL_GCM_LOCATION_LOCAL:
		case CELL_GCM_CONTEXT_DMA_MEMORY_FRAME_BUFFER: return "Local memory";
		case CELL_GCM_LOCATION_MAIN:
		case CELL_GCM_CONTEXT_DMA_MEMORY_HOST_BUFFER: return "Main memory";
		}
		return "Error";
	}

	std::string texture_dimension(u8 dim)
	{
		switch (rsx::to_texture_dimension(dim))
		{
		case rsx::texture_dimension::dimension1d: return "1D";
		case rsx::texture_dimension::dimension2d: return "2D";
		case rsx::texture_dimension::dimension3d: return "3D";
		}
		return "";
	}

	std::string get_vertex_attribute_format(u8 type)
	{
		switch (rsx::to_vertex_base_type(type))
		{
		case rsx::vertex_base_type::s1: return "Signed short normalized";
		case rsx::vertex_base_type::f: return "Float";
		case rsx::vertex_base_type::sf: return "Half float";
		case rsx::vertex_base_type::ub: return "Unsigned byte normalized";
		case rsx::vertex_base_type::s32k: return "Signed short unormalized";
		case rsx::vertex_base_type::cmp: return "CMP";
		case rsx::vertex_base_type::ub256: return "Unsigned byte unormalized";
		}
		return "";
	}

	std::string unpack_vertex_format(u32 arg)
	{
		u32 frequency = arg >> 16;
		u32 stride    = (arg >> 8) & 0xff;
		u32 size      = (arg >> 4) & 0xf;
		u32 type      = arg & 0xf;
		if (size == 0) return "(disabled)";

		return "Type = " + get_vertex_attribute_format(type) + " size = " + std::to_string(size) +
		       " stride = " + std::to_string(stride) + " frequency = " + std::to_string(frequency);
	}

	std::string transform_constant(size_t index, u32 arg)
	{
		return "Transform constant " + std::to_string(index) + ": " + std::to_string(arg) + "/" +
		       std::to_string(std::bit_cast<f32>(arg));
	}

	std::string texture_offset(size_t index, u32 arg)
	{
		return "Texture " + std::to_string(index) + ": Offset @" + ptr_to_string(arg);
	}

	std::string texture_size(size_t index, u32 arg)
	{
		return "Texture " + std::to_string(index) + ": width = " + std::to_string(arg & 0xffff) +
		       " height = " + std::to_string(arg >> 16);
	}

	static std::string get_texture_format_name(u32 format)
	{
		switch (format)
		{
		case CELL_GCM_TEXTURE_COMPRESSED_HILO8: return "CELL_GCM_TEXTURE_COMPRESSED_HILO8";
		case CELL_GCM_TEXTURE_COMPRESSED_HILO_S8: return "CELL_GCM_TEXTURE_COMPRESSED_HILO_S8";
		case CELL_GCM_TEXTURE_B8: return "CELL_GCM_TEXTURE_B8";
		case CELL_GCM_TEXTURE_A1R5G5B5: return "CELL_GCM_TEXTURE_A1R5G5B5";
		case CELL_GCM_TEXTURE_A4R4G4B4: return "CELL_GCM_TEXTURE_A4R4G4B4";
		case CELL_GCM_TEXTURE_R5G6B5: return "CELL_GCM_TEXTURE_R5G6B5";
		case CELL_GCM_TEXTURE_A8R8G8B8: return "CELL_GCM_TEXTURE_A8R8G8B8";
		case CELL_GCM_TEXTURE_COMPRESSED_DXT1: return "CELL_GCM_TEXTURE_COMPRESSED_DXT1";
		case CELL_GCM_TEXTURE_COMPRESSED_DXT23: return "CELL_GCM_TEXTURE_COMPRESSED_DXT23";
		case CELL_GCM_TEXTURE_COMPRESSED_DXT45: return "CELL_GCM_TEXTURE_COMPRESSED_DXT45";
		case CELL_GCM_TEXTURE_G8B8: return "CELL_GCM_TEXTURE_G8B8";
		case CELL_GCM_TEXTURE_R6G5B5: return "CELL_GCM_TEXTURE_R6G5B5";
		case CELL_GCM_TEXTURE_DEPTH24_D8: return "CELL_GCM_TEXTURE_DEPTH24_D8";
		case CELL_GCM_TEXTURE_DEPTH24_D8_FLOAT: return "CELL_GCM_TEXTURE_DEPTH24_D8_FLOAT";
		case CELL_GCM_TEXTURE_DEPTH16: return "CELL_GCM_TEXTURE_DEPTH16";
		case CELL_GCM_TEXTURE_DEPTH16_FLOAT: return "CELL_GCM_TEXTURE_DEPTH16_FLOAT";
		case CELL_GCM_TEXTURE_X16: return "CELL_GCM_TEXTURE_X16";
		case CELL_GCM_TEXTURE_Y16_X16: return "CELL_GCM_TEXTURE_Y16_X16";
		case CELL_GCM_TEXTURE_R5G5B5A1: return "CELL_GCM_TEXTURE_R5G5B5A1";
		case CELL_GCM_TEXTURE_W16_Z16_Y16_X16_FLOAT: return "CELL_GCM_TEXTURE_W16_Z16_Y16_X16_FLOAT";
		case CELL_GCM_TEXTURE_W32_Z32_Y32_X32_FLOAT: return "CELL_GCM_TEXTURE_W32_Z32_Y32_X32_FLOAT";
		case CELL_GCM_TEXTURE_X32_FLOAT: return "CELL_GCM_TEXTURE_X32_FLOAT";
		case CELL_GCM_TEXTURE_D1R5G5B5: return "CELL_GCM_TEXTURE_D1R5G5B5";
		case CELL_GCM_TEXTURE_D8R8G8B8: return "CELL_GCM_TEXTURE_D8R8G8B8";
		case CELL_GCM_TEXTURE_Y16_X16_FLOAT: return "CELL_GCM_TEXTURE_Y16_X16_FLOAT";
		case CELL_GCM_TEXTURE_COMPRESSED_B8R8_G8R8: return "CELL_GCM_TEXTURE_COMPRESSED_B8R8_G8R8";
		case CELL_GCM_TEXTURE_COMPRESSED_R8B8_R8G8: return "CELL_GCM_TEXTURE_COMPRESSED_R8B8_R8G8";
		}
		return "Error";
	}

	std::string texture_format(size_t index, u32 arg)
	{
		int format = ((arg >> 8) & 0xFF);
		return "Texture " + std::to_string(index) + ": location = " + ptr_to_string((arg & 0x3) - 1) +
		       (((arg >> 2) & 0x1) ? " cubemap " : "") + " border type = " +
		       std::to_string((arg >> 3) & 0x1) + " dimension = " + std::to_string((arg >> 4) & 0xF) +
		       " format = " +
		       get_texture_format_name(format & ~(CELL_GCM_TEXTURE_LN | CELL_GCM_TEXTURE_UN)) +
		       ((format & CELL_GCM_TEXTURE_LN) ? "" : " swizzled") +
		       ((format & CELL_GCM_TEXTURE_UN) ? " unormalized coordinates" : "") + " mipmap levels = " +
		       std::to_string((arg >> 16) & 0xFFFF);
	}

	std::string get_texture_wrap_mode(u8 wrap)
	{
		switch (rsx::to_texture_wrap_mode(wrap))
		{
		case rsx::texture_wrap_mode::wrap: return "WRAP";
		case rsx::texture_wrap_mode::mirror: return "MIRROR";
		case rsx::texture_wrap_mode::clamp_to_edge: return "CLAMP_TO_EDGE";
		case rsx::texture_wrap_mode::border: return "BORDER";
		case rsx::texture_wrap_mode::clamp: return "CLAMP";
		case rsx::texture_wrap_mode::mirror_once_clamp_to_edge: return "MIRROR_ONCE_CLAMP_TO_EDGE";
		case rsx::texture_wrap_mode::mirror_once_border: return "MIRROR_ONCE_BORDER";
		case rsx::texture_wrap_mode::mirror_once_clamp: return "MIRROR_ONCE_CLAMP";
		}
		return "Error";
	}

	std::string get_zfunc_name(u8 op)
	{
		switch (op)
		{
		case 0: return "Never";
		case 1: return "Less";
		case 2: return "Equal";
		case 3: return "LEqual";
		case 4: return "Greater";
		case 5: return "NotEqual";
		case 6: return "GreaterOrEqual";
		case 7: return "Always";
		}
		return "Error";
	}

	std::string texture_address(size_t index, u32 arg)
	{
		return "Texture " + std::to_string(index) + ": wrap_s = " + get_texture_wrap_mode(arg & 0xF) +
		       " wrap_t = " + get_texture_wrap_mode((arg >> 8) & 0xF) + " wrap_r = " +
		       get_texture_wrap_mode((arg >> 16) & 0xF) + " unsigned remap = " +
		       std::to_string((arg >> 12) & 0xF) + " zfunc = " + get_zfunc_name((arg >> 28) & 0xF) +
		       " gamma = " + std::to_string((arg >> 20) & 0xF) + " aniso bias = " +
		       std::to_string((arg >> 4) & 0xF) + " signed remap = " + std::to_string((arg >> 24) & 0xF);
	}

	std::string get_texture_max_aniso_name(u8 aniso)
	{
		switch (rsx::to_texture_max_anisotropy(aniso))
		{
		case rsx::texture_max_anisotropy::x1: return "1";
		case rsx::texture_max_anisotropy::x2: return "2";
		case rsx::texture_max_anisotropy::x4: return "4";
		case rsx::texture_max_anisotropy::x6: return "6";
		case rsx::texture_max_anisotropy::x8: return "8";
		case rsx::texture_max_anisotropy::x10: return "10";
		case rsx::texture_max_anisotropy::x12: return "12";
		case rsx::texture_max_anisotropy::x16: return "16";
		}
		return "Error";
	}

	std::string texture_control0(size_t index, u32 arg)
	{
		std::string result = "Texture " + std::to_string(index);
		if ((arg >> 31) & 0x1) {
			result += " min lod = " + std::to_string((arg >> 19) & 0xFFF) + " max lod = " +
			          std::to_string((arg >> 7) & 0xFFF) + " max aniso = " +
			          get_texture_max_aniso_name((arg >> 4) & 0x7) + " alpha kill = " +
			          (((arg >> 2) & 0x1) ? "true" : "false");
		}
		else
			result += " (disabled)";
		return result;
	}

	std::string get_remap_channel(u8 op) noexcept
	{
		switch (op)
		{
		case 0: return "A";
		case 1: return "R";
		case 2: return "G";
		case 3: return "B";
		}
		return "Error";
	}

	std::string texture_control1(size_t index, u32 arg) noexcept
	{
		return "Texture " + std::to_string(index) + " Component 0 = " + get_remap_channel(arg & 0x3) +
		       " Component 1 = " + get_remap_channel((arg >> 2) & 0x3) + " Component 2 = " +
		       get_remap_channel((arg >> 4) & 0x3) + " Component 3 = " +
		       get_remap_channel((arg >> 6) & 0x3);
	}

	std::string texture_control3(size_t index, u32 arg)
	{
		return "Texture " + std::to_string(index) + " depth = " + std::to_string(arg >> 20) +
		       " pitch = " + std::to_string(arg & 0xFFFFF);
	}

	std::string texture_border_color(size_t index, u32 arg)
	{
		return "Texture " + std::to_string(index) + " border color = " + std::to_string(arg);
	}

	std::string texture_filter(size_t index, u32 arg)
	{
		return "Texture " + std::to_string(index) + " bias = " + std::to_string(arg & 0x1fff) +
		       " min_filter = " + std::to_string((arg >> 16) & 0x7) + " mag_filter = " +
		       std::to_string((arg >> 24) & 0x7) + " convolution_filter = " +
		       std::to_string((arg >> 13) & 0xF) + " a_signed = " + std::to_string((arg >> 28) & 0x1) +
		       " r_signed = " + std::to_string((arg >> 29) & 0x1) + " g_signed = " +
		       std::to_string((arg >> 30) & 0x1) + " b_signed = " + std::to_string((arg >> 31) & 0x1);
	}

	namespace
	{
		template <u32 opcode>
		auto register_pretty_printing(u32 arg)
		{
			typename rsx::registers_decoder<opcode>::decoded_type decoded_value(arg);
			return rsx::registers_decoder<opcode>::dump(std::move(arg));
		}

		template <u32... opcode>
		auto create_printing_table(const std::integer_sequence<u32, opcode...>&)
		{
			return std::unordered_map<uint32_t, std::string (*)(u32)>{
			    {opcode, register_pretty_printing<opcode>}...};
		}
	}

	const std::unordered_map<u32, std::string (*)(u32)> printing_functions =
	    create_printing_table(rsx::opcode_list);
	/*	{
	  { NV4097_DRAW_ARRAYS, [](u32 arg) -> std::string { return "Draw " + std::to_string((arg >> 24) +
	 1) + " vertex starting from " + std::to_string(arg & 0xFFFFFF); } },
	  { NV4097_DRAW_INDEX_ARRAY, [](u32 arg) -> std::string { return "Draw " + std::to_string((arg >>
	 24) + 1) + " index starting from " + std::to_string(arg & 0xFFFFFF); } },
	  { NV4097_SET_SEMAPHORE_OFFSET, [](u32 arg) -> std::string { return "Semaphore: @ " +
	 ptr_to_string(arg); } },
	  { NV4097_TEXTURE_READ_SEMAPHORE_RELEASE, [](u32 arg) -> std::string { return "Write semaphore
	 value " + std::to_string(arg); } },
	  { NV4097_CLEAR_SURFACE, [](u32 arg) -> std::string { return "Clear surface " + std::string(arg &
	 0x1 ? "Depth " : "") + std::string(arg & 0x2 ? "Stencil " : "") + std::string(arg & 0xF0 ? "Color
	 " : ""); } },
	 };*/
}

std::function<std::string(u32)> rsx::get_pretty_printing_function(u32 id)
{
	auto found = printing_functions.find(id);
	if (found != printing_functions.end()) {
		return found->second;
	}

	return [=](u32 v) { return fmt::format("%s : 0x%08x", rsx::get_method_name(id), v); };
}
