/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.bmp.BmpMetadataReader;
import com.drew.imaging.gif.GifMetadataReader;
import com.drew.imaging.ico.IcoMetadataReader;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.pcx.PcxMetadataReader;
import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.raf.RafMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.webp.WebpMetadataReader;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.file.FileMetadataReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class ImageMetadataReader {
    @NotNull
    public static Metadata F(@NotNull InputStream inputStream, long streamLength) throws ImageProcessingException, IOException {
        BufferedInputStream a2 = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        FileType a3 = FileTypeDetector.F(a2);
        if (a3 == FileType.g) {
            return JpegMetadataReader.F(a2);
        }
        if (a3 == FileType.F || a3 == FileType.I || a3 == FileType.A || a3 == FileType.d || a3 == FileType.C || a3 == FileType.J) {
            return TiffMetadataReader.F(new RandomAccessStreamReader(a2, 2048, streamLength));
        }
        if (a3 == FileType.l) {
            return PsdMetadataReader.F(a2);
        }
        if (a3 == FileType.b) {
            return PngMetadataReader.F(a2);
        }
        if (a3 == FileType.h) {
            return BmpMetadataReader.F(a2);
        }
        if (a3 == FileType.c) {
            return GifMetadataReader.F(a2);
        }
        if (a3 == FileType.i) {
            return IcoMetadataReader.F(a2);
        }
        if (a3 == FileType.K) {
            return PcxMetadataReader.F(a2);
        }
        if (a3 == FileType.j) {
            return WebpMetadataReader.F(a2);
        }
        if (a3 == FileType.k) {
            return RafMetadataReader.F(a2);
        }
        throw new ImageProcessingException(Rc.F("%B\u000fNCM\fY\u000eJ\u0017\u000b\nXCE\f_CX\u0016[\u0013D\u0011_\u0006O"));
    }

    @NotNull
    public static Metadata F(@NotNull File file) throws ImageProcessingException, IOException {
        Metadata a2;
        try (FileInputStream a3 = new FileInputStream(file);){
            a2 = ImageMetadataReader.F(a3, file.length());
        }
        new FileMetadataReader().F(file, a2);
        return a2;
    }

    private /* synthetic */ ImageMetadataReader() throws Exception {
        ImageMetadataReader a2;
        throw new Exception(Fa.F(")O\u0013\u0000\u000eN\u0013E\tD\u0002DGF\bRGI\tS\u0013A\tT\u000eA\u0013I\bN"));
    }

    public static String F(Object a2) {
        a2 = (String)a2;
        int n2 = ((String)a2).length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = (2 ^ 5) << 4 ^ 1;
        int cfr_ignored_0 = (3 ^ 5) << 4 ^ (3 ^ 5) << 1;
        int n5 = n3;
        int n6 = 4 << 3;
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(((String)a2).charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(((String)a2).charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    @NotNull
    public static Metadata F(@NotNull InputStream inputStream) throws ImageProcessingException, IOException {
        return ImageMetadataReader.F(inputStream, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(@NotNull String[] args) throws MetadataException, IOException {
        void var4_4;
        Object a2;
        ArrayList<String> a3 = new ArrayList<String>(Arrays.asList(args));
        boolean a4 = a3.remove(Rc.F("\u0006\u000eJ\u0011@\u0007D\u0014E"));
        boolean a5 = a3.remove(Fa.F("JH\u0002X"));
        if (a3.size() < 1) {
            a2 = ImageMetadataReader.class.getPackage().getImplementationVersion();
            System.out.println("metadata-extractor version " + (String)a2);
            System.out.println();
            System.out.println(String.format(Rc.F("6X\u0002L\u0006\u0011CA\u0002]\u0002\u000bNA\u0002YCF\u0006_\u0002O\u0002_\u0002\u0006\u0006S\u0017Y\u0002H\u0017D\u0011\u0006FXMA\u0002YC\u0017\u0005B\u000fN\rJ\u000eN]\u000b8\u0017\u0005B\u000fN\rJ\u000eN]vCpN_\u000b^\u000eI>\u000b8\u0006\u000eJ\u0011@\u0007D\u0014E>\u000b8\u0006\u000bN\u001bv"), a2 == null ? Fa.F("AIBIC") : a2));
            System.exit(1);
        }
        a2 = a3.iterator();
        while (var4_4.hasNext()) {
            String a7 = (String)var4_4.next();
            long a8 = System.nanoTime();
            File a9 = new File(a7);
            if (!a4 && a3.size() > 1) {
                System.out.printf(Rc.F("!I\u0001I\u0001I\u000b3y,h&x0b-lY\u000bFXFEFE"), a7);
            }
            Metadata a10 = null;
            try {
                a10 = ImageMetadataReader.F(a9);
            }
            catch (Exception a11) {
                a11.printStackTrace(System.err);
                System.exit(1);
            }
            long a12 = System.nanoTime() - a8;
            if (!a4) {
                System.out.printf(Fa.F("p\u0015O\u0004E\u0014S\u0002DG\u0005I\u0013\u0001\u0000*bGF\u000eL\u0002\u0000\u000eNG\u0005I\u0012\u0001\u0000\nSBNBN"), (double)a9.length() / 1048576.0, (double)a12 / 1000000.0);
            }
            if (a4) {
                String a13 = a9.getName();
                String string = StringUtil.F(a7);
                ExifIFD0Directory a6 = a10.F(ExifIFD0Directory.class);
                String a15 = a6 == null ? "" : a6.l(271);
                String string2 = a6 == null ? "" : a6.l(272);
                System.out.println();
                System.out.println(Rc.F("\u0006N\u0006"));
                System.out.println();
                System.out.printf(Fa.F("\u0003G\u0005\u0014\u0000J\u0000BSBN"), a15, string2);
                System.out.println();
                System.out.printf(Rc.F("\u0017\u0002\u000b\u000bY\u0006M^\t\u000b_\u0017[\u0010\u0011L\u0004\u0011J\u0014\u0005\u0004B\u0017C\u0016I\u0016X\u0006Y\u0000D\r_\u0006E\u0017\u0005\u0000D\u000e\u0004\u0007Y\u0006\\\rD\u0002@\u0006XLF\u0006_\u0002O\u0002_\u0002\u0006\u0006S\u0017Y\u0002H\u0017D\u0011\u0006\nF\u0002L\u0006XLF\u0002X\u0017N\u0011\u0004FXA\u0015FE"), string);
                System.out.printf(Fa.F("[I\nGGS\u0015CZ\u0002\u000fT\u0013P\u0014\u001aH\u000f\u0015A\u0010\u000e\u0000I\u0013H\u0012B\u0012S\u0002R\u0004O\tT\u0002N\u0013\u000e\u0004O\n\u000f\u0003R\u0002W\tO\u0006K\u0002SHM\u0002T\u0006D\u0006T\u0006\r\u0002X\u0013R\u0006C\u0013O\u0015\r\u000eM\u0006G\u0002SHM\u0006S\u0013E\u0015\u000fBSE\u0000\u0010I\u0003T\u000f\u001dE\u0013W\u0010E\u000fY\u001c\u0005RH\u001eBN"), string);
                System.out.println(a13);
                System.out.println(Rc.F("_\u0004\u0002\u0015"));
                System.out.println();
                System.out.println(Fa.F("d\u000eR\u0002C\u0013O\u0015YG\\Gt\u0006GGi\u0003\u0000\u001b\u00003A\u0000\u0000)A\nEG\\Ge\u001fT\u0015A\u0004T\u0002DGv\u0006L\u0012E"));
                System.out.println(Rc.F("\u0011N\u0006N\u0006N\u0006N\u0006YWN\u0006N\u0006N\u0006N\u0011\u001f\u0006N\u0006N\u0006N\u0006N\u0006NWN\u0006N\u0006N\u0006N\u0006N\u0006N\u0006N\u0006N\u0006"));
            }
            for (Directory directory : a10.F()) {
                String a6 = directory.F();
                for (Tag tag : directory.F()) {
                    String a17 = tag.h();
                    Object a18 = tag.l();
                    if (a18 != null && ((String)a18).length() > 1024) {
                        a18 = ((String)a18).substring(0, 1024) + "...";
                    }
                    if (a4) {
                        System.out.printf(Fa.F("\u0005\u0014\\WXBS\u001b\u0005\u0014\\BSBN"), a6, Integer.toHexString(tag.F()), a17, a18);
                        continue;
                    }
                    if (a5) {
                        System.out.printf(Rc.F("pFXC\u0006C\u000e\u0010vC\u000e\u0010\u000b^\u000bFXFE"), a6, tag.f(), a17, a18);
                        continue;
                    }
                    System.out.printf(Fa.F("<\u0005\u0014}G\u0005\u0014\u0000Z\u0000BSBN"), a6, a17, a18);
                }
                for (String string : directory.F()) {
                    System.err.println("ERROR: " + string);
                }
            }
        }
    }
}

