/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.twelvemonkeys.io.enc.DecoderStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;

public class JpegSegmentReader {
    private static final byte k = -39;
    private static final byte C = -38;
    private static final byte f = -1;

    @NotNull
    public static JpegSegmentData F(@NotNull SequentialReader reader, @Nullable Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        assert (reader.F());
        int a2 = reader.f();
        if (a2 != 65496) {
            throw new JpegProcessingException("JPEG data is expected to begin with 0xFFD8 (\u00ff\u00d8) not 0x" + Integer.toHexString(a2));
        }
        HashSet<Byte> a3 = null;
        if (segmentTypes != null) {
            a3 = new HashSet<Byte>();
            for (JpegSegmentType a4 : segmentTypes) {
                a3.add(a4.z);
            }
        }
        JpegSegmentData a5 = new JpegSegmentData();
        while (true) {
            byte a6 = reader.F();
            byte a7 = reader.F();
            while (a6 != -1 || a7 == -1 || a7 == 0) {
                a6 = a7;
                a7 = reader.F();
            }
            if (a7 == -38) {
                return a5;
            }
            if (a7 == -39) {
                return a5;
            }
            int a8 = reader.f();
            if ((a8 -= 2) < 0) {
                throw new JpegProcessingException(rR.F("\u001a_\u0015Hp|5h=j>{p|9u5/'`%c4/2jpc5|#/$g1apu5}?"));
            }
            if (a3 == null || a3.contains(a7)) {
                byte[] a9 = reader.F(a8);
                assert (a8 == a9.length);
                a5.F(a7, a9);
                continue;
            }
            if (!reader.F((long)a8)) break;
        }
        return a5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JpegSegmentData F(@NotNull File file, @Nullable Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        try (FileInputStream a2 = null;){
            a2 = new FileInputStream(file);
            JpegSegmentData jpegSegmentData = JpegSegmentReader.F(new StreamReader(a2), segmentTypes);
            return jpegSegmentData;
        }
    }

    private /* synthetic */ JpegSegmentReader() throws Exception {
        JpegSegmentReader a2;
        throw new Exception(DecoderStream.F("#&\u0019i\u0004'\u0019,\u0003-\b-M/\u0002;M \u0003:\u0019(\u0003=\u0004(\u0019 \u0002'C"));
    }
}

