/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleCMYKColorSpace;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public abstract class TIFFDecompressor {
    private static final boolean DEBUG = false;
    protected ImageReader reader;
    protected IIOMetadata metadata;
    protected int photometricInterpretation;
    protected int compression;
    protected boolean planar;
    protected int samplesPerPixel;
    protected int[] bitsPerSample;
    protected int[] sampleFormat = new int[]{1};
    protected int[] extraSamples;
    protected char[] colorMap;
    protected ImageInputStream stream;
    protected long offset;
    protected int byteCount;
    protected int srcMinX;
    protected int srcMinY;
    protected int srcWidth;
    protected int srcHeight;
    protected int sourceXOffset;
    protected int dstXOffset;
    protected int sourceYOffset;
    protected int dstYOffset;
    protected int subsampleX;
    protected int subsampleY;
    protected int[] sourceBands;
    protected int[] destinationBands;
    protected BufferedImage rawImage;
    protected BufferedImage image;
    protected int dstMinX;
    protected int dstMinY;
    protected int dstWidth;
    protected int dstHeight;
    protected int activeSrcMinX;
    protected int activeSrcMinY;
    protected int activeSrcWidth;
    protected int activeSrcHeight;
    protected TIFFColorConverter colorConverter;
    boolean isBilevel;
    boolean isContiguous;
    boolean isImageSimple;
    boolean adjustBitDepths;
    int[][] bitDepthScale;
    private boolean isFirstBitDepthTable = true;
    private boolean planarCache = false;
    private int[] destBitsPerSampleCache = null;
    private int[] sourceBandsCache = null;
    private int[] bitsPerSampleCache = null;
    private int[] destinationBandsCache = null;

    static SampleModel createInterleavedSM(int n2, int n3) {
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = i2;
        }
        return new PixelInterleavedSampleModel(n2, 1, 1, n3, n3, nArray);
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int n2, int n3, boolean bl2, boolean bl3) {
        ComponentColorModel componentColorModel;
        int n4;
        int n5 = n4 = bl2 ? 3 : 1;
        if (n3 == 4 || n3 == 5) {
            componentColorModel = new ComponentColorModel(colorSpace, bl2, bl3, n4, n3);
        } else {
            int n6;
            int[] nArray = new int[n2];
            if (n3 == 0) {
                n6 = 8;
            } else if (n3 == 2 || n3 == 1) {
                n6 = 16;
            } else if (n3 == 3) {
                n6 = 32;
            } else {
                throw new IllegalArgumentException("dataType = " + n3);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = n6;
            }
            componentColorModel = new ComponentColorModel(colorSpace, nArray, bl2, bl3, n4, n3);
        }
        return componentColorModel;
    }

    private static int createMask(int[] nArray, int n2) {
        int n3 = (1 << nArray[n2]) - 1;
        for (int i2 = n2 + 1; i2 < nArray.length; ++i2) {
            n3 <<= nArray[i2];
        }
        return n3;
    }

    private static int getDataTypeFromNumBits(int n2, boolean bl2) {
        int n3 = n2 <= 8 ? 0 : (n2 <= 16 ? (bl2 ? 2 : 1) : 3);
        return n3;
    }

    private static boolean areIntArraysEqual(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return nArray == null && nArray2 == null;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private static int getDataTypeSize(int n2) throws IIOException {
        int n3 = 0;
        switch (n2) {
            case 0: {
                n3 = 8;
                break;
            }
            case 1: 
            case 2: {
                n3 = 16;
                break;
            }
            case 3: 
            case 4: {
                n3 = 32;
                break;
            }
            case 5: {
                n3 = 64;
                break;
            }
            default: {
                throw new IIOException("Unknown data type " + n2);
            }
        }
        return n3;
    }

    private static int getBitsPerPixel(SampleModel sampleModel) {
        int n2 = 0;
        int[] nArray = sampleModel.getSampleSize();
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += nArray[i2];
        }
        return n2;
    }

    private static boolean areSampleSizesEqual(SampleModel sampleModel) {
        boolean bl2 = true;
        int[] nArray = sampleModel.getSampleSize();
        int n2 = nArray[0];
        int n3 = nArray.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            if (nArray[i2] == n2) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    private static boolean isDataBufferBitContiguous(SampleModel sampleModel) throws IIOException {
        int n2 = TIFFDecompressor.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof ComponentSampleModel) {
            int n3 = sampleModel.getNumBands();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (sampleModel.getSampleSize(i2) == n2) continue;
                return false;
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            if (n2 % multiPixelPackedSampleModel.getPixelBitStride() != 0) {
                return false;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int n4 = sampleModel.getNumBands();
            int n5 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                n5 += sampleModel.getSampleSize(i3);
            }
            if (n5 != n2) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void reformatData(byte[] byArray, int n2, int n3, short[] sArray, int[] nArray, int n4, int n5) throws IIOException {
        if (sArray != null) {
            int n6 = 0;
            int n7 = n2 / 2;
            int n8 = n2 % 2;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n9 = n4;
                for (int i3 = 0; i3 < n7; ++i3) {
                    sArray[n9++] = (short)((byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF);
                }
                if (n8 != 0) {
                    sArray[n9++] = (short)((byArray[n6++] & 0xFF) << 8);
                }
                n4 += n5;
            }
        } else if (nArray != null) {
            int n10 = 0;
            int n11 = n2 / 4;
            int n12 = n2 % 4;
            for (int i4 = 0; i4 < n3; ++i4) {
                int n13;
                int n14 = n4;
                for (n13 = 0; n13 < n11; ++n13) {
                    nArray[n14++] = (byArray[n10++] & 0xFF) << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF;
                }
                if (n12 != 0) {
                    n13 = 24;
                    int n15 = 0;
                    for (int i5 = 0; i5 < n12; ++i5) {
                        n15 |= (byArray[n10++] & 0xFF) << n13;
                        n13 -= 8;
                    }
                    nArray[n14++] = n15;
                }
                n4 += n5;
            }
        } else {
            throw new IIOException("shortData == null && intData == null!");
        }
    }

    private static void reformatDiscontiguousData(byte[] byArray, int n2, int n3, int n4, WritableRaster writableRaster) throws IOException {
        SampleModel sampleModel = writableRaster.getSampleModel();
        int n5 = sampleModel.getNumBands();
        int[] nArray = sampleModel.getSampleSize();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
        long l2 = 0L;
        int n6 = writableRaster.getMinY();
        int n7 = 0;
        while (n7 < n4) {
            memoryCacheImageInputStream.seek(l2);
            int n8 = writableRaster.getMinX();
            int n9 = 0;
            while (n9 < n3) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    long l3 = memoryCacheImageInputStream.readBits(nArray[i2]);
                    writableRaster.setSample(n8, n6, i2, (int)l3);
                }
                ++n9;
                ++n8;
            }
            l2 += (long)n2;
            ++n7;
            ++n6;
        }
    }

    public static ImageTypeSpecifier getRawImageTypeSpecifier(int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, char[] cArray) {
        int n5;
        int n6;
        int n7;
        if (n4 == 1 && (nArray[0] == 1 || nArray[0] == 2 || nArray[0] == 4 || nArray[0] == 8 || nArray[0] == 16)) {
            int n8;
            if (cArray == null) {
                boolean bl2;
                boolean bl3 = bl2 = nArray2[0] == 2;
                int n9 = nArray[0] <= 8 ? 0 : (nArray2[0] == 2 ? 2 : 1);
                return ImageTypeSpecifier.createGrayscale(nArray[0], n9, bl2);
            }
            int n10 = 1 << nArray[0];
            byte[] byArray = new byte[n10];
            byte[] byArray2 = new byte[n10];
            byte[] byArray3 = new byte[n10];
            byte[] byArray4 = null;
            boolean bl4 = false;
            for (n8 = 0; n8 < n10; ++n8) {
                byArray[n8] = (byte)(cArray[n8] * 255 / 65535);
                byArray2[n8] = (byte)(cArray[n10 + n8] * 255 / 65535);
                byArray3[n8] = (byte)(cArray[2 * n10 + n8] * 255 / 65535);
            }
            n8 = nArray[0] == 8 ? 0 : 1;
            return ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, nArray[0], n8);
        }
        if (n4 == 2 && nArray[0] == 8 && nArray[1] == 8) {
            int n11 = 0;
            boolean bl5 = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl5 = true;
            }
            return ImageTypeSpecifier.createGrayscale(8, n11, false, bl5);
        }
        if (n4 == 2 && nArray[0] == 16 && nArray[1] == 16) {
            int n12 = nArray2[0] == 2 ? 2 : 1;
            boolean bl6 = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl6 = true;
            }
            boolean bl7 = n12 == 2;
            return ImageTypeSpecifier.createGrayscale(16, n12, bl7, bl6);
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (n4 == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8) {
            int[] nArray4 = new int[]{0, 1, 2};
            int n13 = 0;
            ColorSpace colorSpace2 = n2 == 6 && n3 != 7 && n3 != 6 || n2 == 8 ? ColorSpace.getInstance(1004) : colorSpace;
            return ImageTypeSpecifier.createInterleaved(colorSpace2, nArray4, n13, false, false);
        }
        if (n4 == 4 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8 && nArray[3] == 8) {
            boolean bl8;
            ColorSpace colorSpace3;
            int[] nArray5 = new int[]{0, 1, 2, 3};
            int n14 = 0;
            boolean bl9 = false;
            if (n2 == 5) {
                colorSpace3 = SimpleCMYKColorSpace.getInstance();
                bl8 = false;
            } else {
                colorSpace3 = colorSpace;
                bl8 = true;
                if (nArray3 != null && nArray3[0] == 1) {
                    bl9 = true;
                }
            }
            return ImageTypeSpecifier.createInterleaved(colorSpace3, nArray5, n14, bl8, bl9);
        }
        if (n4 == 3 && nArray[0] == 16 && nArray[1] == 16 && nArray[2] == 16) {
            int[] nArray6 = new int[]{0, 1, 2};
            int n15 = nArray2[0] == 2 ? 2 : 1;
            return ImageTypeSpecifier.createInterleaved(colorSpace, nArray6, n15, false, false);
        }
        if (n4 == 4 && nArray[0] == 16 && nArray[1] == 16 && nArray[2] == 16 && nArray[3] == 16) {
            int[] nArray7 = new int[]{0, 1, 2, 3};
            int n16 = nArray2[0] == 2 ? 2 : 1;
            boolean bl10 = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl10 = true;
            }
            return ImageTypeSpecifier.createInterleaved(colorSpace, nArray7, n16, true, bl10);
        }
        if (n2 == 5 && (nArray[0] == 1 || nArray[0] == 2 || nArray[0] == 4)) {
            ColorSpace colorSpace4 = null;
            colorSpace4 = n4 == 4 ? SimpleCMYKColorSpace.getInstance() : new BogusColorSpace(n4);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace4, nArray, false, false, 1, 0);
            return new ImageTypeSpecifier(componentColorModel, ((ColorModel)componentColorModel).createCompatibleSampleModel(1, 1));
        }
        int n17 = 0;
        for (n7 = 0; n7 < nArray.length; ++n7) {
            n17 += nArray[n7];
        }
        if (!(n4 != 3 && n4 != 4 || n17 != 8 && n17 != 16)) {
            n7 = TIFFDecompressor.createMask(nArray, 0);
            int n18 = TIFFDecompressor.createMask(nArray, 1);
            int n19 = TIFFDecompressor.createMask(nArray, 2);
            int n20 = n4 == 4 ? TIFFDecompressor.createMask(nArray, 3) : 0;
            int n21 = n17 == 8 ? 0 : 1;
            boolean bl11 = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl11 = true;
            }
            return ImageTypeSpecifier.createPacked(colorSpace, n7, n18, n19, n20, n21, bl11);
        }
        if (nArray[0] % 8 == 0) {
            n7 = 1;
            for (n6 = 1; n6 < nArray.length; ++n6) {
                if (nArray[n6] == nArray[n6 - 1]) continue;
                n7 = 0;
                break;
            }
            if (n7 != 0) {
                n6 = -1;
                n5 = 0;
                switch (nArray[0]) {
                    case 8: {
                        if (nArray2[0] == 3) break;
                        n6 = 0;
                        n5 = 1;
                        break;
                    }
                    case 16: {
                        if (nArray2[0] == 3) break;
                        n6 = nArray2[0] == 2 ? 2 : 1;
                        n5 = 1;
                        break;
                    }
                    case 32: {
                        n6 = nArray2[0] == 3 ? 4 : 3;
                        n5 = 1;
                    }
                }
                if (n5 != 0) {
                    ColorModel colorModel;
                    SampleModel sampleModel = TIFFDecompressor.createInterleavedSM(n6, n4);
                    if (n4 >= 1 && n4 <= 4 && (n6 == 3 || n6 == 4)) {
                        ColorSpace colorSpace5 = n4 <= 2 ? ColorSpace.getInstance(1003) : colorSpace;
                        boolean bl12 = n4 % 2 == 0;
                        boolean bl13 = false;
                        if (bl12 && nArray3 != null && nArray3[0] == 1) {
                            bl13 = true;
                        }
                        colorModel = TIFFDecompressor.createComponentCM(colorSpace5, n4, n6, bl12, bl13);
                    } else {
                        BogusColorSpace bogusColorSpace = new BogusColorSpace(n4);
                        colorModel = TIFFDecompressor.createComponentCM(bogusColorSpace, n4, n6, false, false);
                    }
                    return new ImageTypeSpecifier(colorModel, sampleModel);
                }
            }
        }
        if (cArray == null && nArray2[0] != 3) {
            n7 = 0;
            for (n6 = 0; n6 < nArray.length; ++n6) {
                if (nArray[n6] <= n7) continue;
                n7 = nArray[n6];
            }
            int n22 = n6 = nArray2[0] == 2 ? 1 : 0;
            if (n4 == 1) {
                n5 = TIFFDecompressor.getDataTypeFromNumBits(n7, n6 != 0);
                return ImageTypeSpecifier.createGrayscale(n7, n5, n6 != 0);
            }
            if (n4 == 2) {
                n5 = 0;
                if (nArray3 != null && nArray3[0] == 1) {
                    n5 = 1;
                }
                int n23 = TIFFDecompressor.getDataTypeFromNumBits(n7, n6 != 0);
                return ImageTypeSpecifier.createGrayscale(n7, n23, false, n5 != 0);
            }
            if (n4 == 3 || n4 == 4) {
                if (n17 <= 32 && n6 == 0) {
                    n5 = TIFFDecompressor.createMask(nArray, 0);
                    int n24 = TIFFDecompressor.createMask(nArray, 1);
                    int n25 = TIFFDecompressor.createMask(nArray, 2);
                    int n26 = n4 == 4 ? TIFFDecompressor.createMask(nArray, 3) : 0;
                    int n27 = TIFFDecompressor.getDataTypeFromNumBits(n17, false);
                    boolean bl14 = false;
                    if (nArray3 != null && nArray3[0] == 1) {
                        bl14 = true;
                    }
                    return ImageTypeSpecifier.createPacked(colorSpace, n5, n24, n25, n26, n27, bl14);
                }
                if (n4 == 3) {
                    int[] nArray8 = new int[]{0, 1, 2};
                    int n28 = TIFFDecompressor.getDataTypeFromNumBits(n7, n6 != 0);
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray8, n28, false, false);
                }
                if (n4 == 4) {
                    int[] nArray9 = new int[]{0, 1, 2, 3};
                    int n29 = TIFFDecompressor.getDataTypeFromNumBits(n7, n6 != 0);
                    boolean bl15 = false;
                    if (nArray3 != null && nArray3[0] == 1) {
                        bl15 = true;
                    }
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray9, n29, true, bl15);
                }
            } else {
                n5 = TIFFDecompressor.getDataTypeFromNumBits(n7, n6 != 0);
                SampleModel sampleModel = TIFFDecompressor.createInterleavedSM(n5, n4);
                BogusColorSpace bogusColorSpace = new BogusColorSpace(n4);
                ColorModel colorModel = TIFFDecompressor.createComponentCM(bogusColorSpace, n4, n5, false, false);
                return new ImageTypeSpecifier(colorModel, sampleModel);
            }
        }
        return null;
    }

    public void setReader(ImageReader imageReader) {
        this.reader = imageReader;
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        this.metadata = iIOMetadata;
    }

    public void setPhotometricInterpretation(int n2) {
        this.photometricInterpretation = n2;
    }

    public void setCompression(int n2) {
        this.compression = n2;
    }

    public void setPlanar(boolean bl2) {
        this.planar = bl2;
    }

    public void setSamplesPerPixel(int n2) {
        this.samplesPerPixel = n2;
    }

    public void setBitsPerSample(int[] nArray) {
        this.bitsPerSample = nArray == null ? null : (int[])nArray.clone();
    }

    public void setSampleFormat(int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 1;
        } else {
            nArray2 = (int[])nArray.clone();
        }
        this.sampleFormat = nArray2;
    }

    public void setExtraSamples(int[] nArray) {
        this.extraSamples = nArray == null ? null : (int[])nArray.clone();
    }

    public void setColorMap(char[] cArray) {
        this.colorMap = cArray == null ? null : (char[])cArray.clone();
    }

    public void setStream(ImageInputStream imageInputStream) {
        this.stream = imageInputStream;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }

    public void setByteCount(int n2) {
        this.byteCount = n2;
    }

    public void setSrcMinX(int n2) {
        this.srcMinX = n2;
    }

    public void setSrcMinY(int n2) {
        this.srcMinY = n2;
    }

    public void setSrcWidth(int n2) {
        this.srcWidth = n2;
    }

    public void setSrcHeight(int n2) {
        this.srcHeight = n2;
    }

    public void setSourceXOffset(int n2) {
        this.sourceXOffset = n2;
    }

    public void setDstXOffset(int n2) {
        this.dstXOffset = n2;
    }

    public void setSourceYOffset(int n2) {
        this.sourceYOffset = n2;
    }

    public void setDstYOffset(int n2) {
        this.dstYOffset = n2;
    }

    public void setSubsampleX(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("subsampleX <= 0!");
        }
        this.subsampleX = n2;
    }

    public void setSubsampleY(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("subsampleY <= 0!");
        }
        this.subsampleY = n2;
    }

    public void setSourceBands(int[] nArray) {
        this.sourceBands = nArray == null ? null : (int[])nArray.clone();
    }

    public void setDestinationBands(int[] nArray) {
        this.destinationBands = nArray == null ? null : (int[])nArray.clone();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void setDstMinX(int n2) {
        this.dstMinX = n2;
    }

    public void setDstMinY(int n2) {
        this.dstMinY = n2;
    }

    public void setDstWidth(int n2) {
        this.dstWidth = n2;
    }

    public void setDstHeight(int n2) {
        this.dstHeight = n2;
    }

    public void setActiveSrcMinX(int n2) {
        this.activeSrcMinX = n2;
    }

    public void setActiveSrcMinY(int n2) {
        this.activeSrcMinY = n2;
    }

    public void setActiveSrcWidth(int n2) {
        this.activeSrcWidth = n2;
    }

    public void setActiveSrcHeight(int n2) {
        this.activeSrcHeight = n2;
    }

    public void setColorConverter(TIFFColorConverter tIFFColorConverter) {
        this.colorConverter = tIFFColorConverter;
    }

    public ImageTypeSpecifier getRawImageType() {
        ImageTypeSpecifier imageTypeSpecifier = TIFFDecompressor.getRawImageTypeSpecifier(this.photometricInterpretation, this.compression, this.samplesPerPixel, this.bitsPerSample, this.sampleFormat, this.extraSamples, this.colorMap);
        return imageTypeSpecifier;
    }

    public BufferedImage createRawImage() {
        if (this.planar) {
            int n2 = this.bitsPerSample[this.sourceBands[0]];
            int n3 = this.sampleFormat[0] == 3 ? 4 : (n2 <= 8 ? 0 : (n2 <= 16 ? (this.sampleFormat[0] == 2 ? 2 : 1) : 3));
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ImageTypeSpecifier imageTypeSpecifier = null;
            if (n2 == 1 || n2 == 2 || n2 == 4) {
                int n4 = n2;
                int n5 = 1 << n4;
                byte[] byArray = new byte[n5];
                byte[] byArray2 = new byte[n5];
                byte[] byArray3 = new byte[n5];
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    byArray[i2] = 0;
                    byArray2[i2] = 0;
                    byArray3[i2] = 0;
                }
                IndexColorModel indexColorModel = new IndexColorModel(n4, n5, byArray, byArray2, byArray3);
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, 1, 1, n4);
                imageTypeSpecifier = new ImageTypeSpecifier(indexColorModel, multiPixelPackedSampleModel);
            } else {
                imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0}, n3, false, false);
            }
            return imageTypeSpecifier.createBufferedImage(this.srcWidth, this.srcHeight);
        }
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType();
        if (imageTypeSpecifier == null) {
            return null;
        }
        BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(this.srcWidth, this.srcHeight);
        return bufferedImage;
    }

    public abstract void decodeRaw(byte[] var1, int var2, int var3, int var4) throws IOException;

    public void decodeRaw(short[] sArray, int n2, int n3, int n4) throws IOException {
        int n5 = (this.srcWidth * n3 + 7) / 8;
        int n6 = n5 / 2;
        byte[] byArray = new byte[n5 * this.srcHeight];
        this.decodeRaw(byArray, 0, n3, n5);
        int n7 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < this.srcHeight; ++i2) {
                for (int i3 = 0; i3 < n6; ++i3) {
                    short s2;
                    short s3 = byArray[n7++];
                    short s4 = byArray[n7++];
                    sArray[n2 + i3] = s2 = (short)(s3 << 8 | s4 & 0xFF);
                }
                n2 += n4;
            }
        } else {
            for (int i4 = 0; i4 < this.srcHeight; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    short s5;
                    short s6 = byArray[n7++];
                    short s7 = byArray[n7++];
                    sArray[n2 + i5] = s5 = (short)(s7 << 8 | s6 & 0xFF);
                }
                n2 += n4;
            }
        }
    }

    public void decodeRaw(int[] nArray, int n2, int n3, int n4) throws IOException {
        int n5 = n3 / 32;
        int n6 = this.srcWidth * n5;
        int n7 = n6 * 4;
        byte[] byArray = new byte[n7 * this.srcHeight];
        this.decodeRaw(byArray, 0, n3, n7);
        int n8 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < this.srcHeight; ++i2) {
                for (int i3 = 0; i3 < n6; ++i3) {
                    int n9;
                    int n10 = byArray[n8++] & 0xFF;
                    int n11 = byArray[n8++] & 0xFF;
                    int n12 = byArray[n8++] & 0xFF;
                    int n13 = byArray[n8++] & 0xFF;
                    nArray[n2 + i3] = n9 = n10 << 24 | n11 << 16 | n12 << 8 | n13;
                }
                n2 += n4;
            }
        } else {
            for (int i4 = 0; i4 < this.srcHeight; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    int n14;
                    int n15 = byArray[n8++] & 0xFF;
                    int n16 = byArray[n8++] & 0xFF;
                    int n17 = byArray[n8++] & 0xFF;
                    int n18 = byArray[n8++] & 0xFF;
                    nArray[n2 + i5] = n14 = n18 << 24 | n17 << 16 | n16 << 8 | n15;
                }
                n2 += n4;
            }
        }
    }

    public void decodeRaw(float[] fArray, int n2, int n3, int n4) throws IOException {
        int n5 = n3 / 32;
        int n6 = this.srcWidth * n5;
        int n7 = n6 * 4;
        byte[] byArray = new byte[n7 * this.srcHeight];
        this.decodeRaw(byArray, 0, n3, n7);
        int n8 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < this.srcHeight; ++i2) {
                for (int i3 = 0; i3 < n6; ++i3) {
                    float f2;
                    int n9 = byArray[n8++] & 0xFF;
                    int n10 = byArray[n8++] & 0xFF;
                    int n11 = byArray[n8++] & 0xFF;
                    int n12 = byArray[n8++] & 0xFF;
                    int n13 = n9 << 24 | n10 << 16 | n11 << 8 | n12;
                    fArray[n2 + i3] = f2 = Float.intBitsToFloat(n13);
                }
                n2 += n4;
            }
        } else {
            for (int i4 = 0; i4 < this.srcHeight; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    float f3;
                    int n14 = byArray[n8++] & 0xFF;
                    int n15 = byArray[n8++] & 0xFF;
                    int n16 = byArray[n8++] & 0xFF;
                    int n17 = byArray[n8++] & 0xFF;
                    int n18 = n17 << 24 | n16 << 16 | n15 << 8 | n14;
                    fArray[n2 + i5] = f3 = Float.intBitsToFloat(n18);
                }
                n2 += n4;
            }
        }
    }

    public void beginDecoding() {
        int n2;
        int n3;
        int n4;
        this.adjustBitDepths = false;
        int n5 = this.destinationBands.length;
        int[] nArray = null;
        if (this.planar) {
            n4 = this.bitsPerSample.length;
            nArray = new int[n4];
            n3 = this.image.getSampleModel().getSampleSize(0);
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n2] = n3;
            }
        } else {
            nArray = this.image.getSampleModel().getSampleSize();
        }
        if (this.photometricInterpretation != 5 || this.bitsPerSample[0] != 1 && this.bitsPerSample[0] != 2 && this.bitsPerSample[0] != 4) {
            for (n4 = 0; n4 < n5; ++n4) {
                if (nArray[this.destinationBands[n4]] == this.bitsPerSample[this.sourceBands[n4]]) continue;
                this.adjustBitDepths = true;
                break;
            }
        }
        if (this.adjustBitDepths) {
            if (!(!this.isFirstBitDepthTable && this.planar == this.planarCache && TIFFDecompressor.areIntArraysEqual(nArray, this.destBitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.sourceBands, this.sourceBandsCache) && TIFFDecompressor.areIntArraysEqual(this.bitsPerSample, this.bitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.destinationBands, this.destinationBandsCache))) {
                this.isFirstBitDepthTable = false;
                this.planarCache = this.planar;
                this.destBitsPerSampleCache = (int[])nArray.clone();
                this.sourceBandsCache = this.sourceBands == null ? null : (int[])this.sourceBands.clone();
                this.bitsPerSampleCache = this.bitsPerSample == null ? null : (int[])this.bitsPerSample.clone();
                this.destinationBandsCache = this.destinationBands == null ? null : (int[])this.destinationBands.clone();
                this.bitDepthScale = new int[n5][];
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = (1 << this.bitsPerSample[this.sourceBands[n4]]) - 1;
                    n2 = n3 / 2;
                    int n6 = (1 << nArray[this.destinationBands[n4]]) - 1;
                    this.bitDepthScale[n4] = new int[n3 + 1];
                    for (int i2 = 0; i2 <= n3; ++i2) {
                        this.bitDepthScale[n4][i2] = (i2 * n6 + n2) / n3;
                    }
                }
            }
        } else {
            this.bitDepthScale = null;
        }
        n4 = 0;
        n3 = 0;
        if (n5 == this.samplesPerPixel) {
            n4 = 1;
            n3 = 1;
            for (n2 = 0; n2 < n5; ++n2) {
                if (this.sourceBands[n2] != n2) {
                    n4 = 0;
                }
                if (this.destinationBands[n2] == n2) continue;
                n3 = 0;
            }
        }
        this.isBilevel = ImageUtil.isBinary(this.image.getRaster().getSampleModel());
        this.isContiguous = this.isBilevel ? true : ImageUtil.imageIsContiguous(this.image);
        this.isImageSimple = this.colorConverter == null && this.subsampleX == 1 && this.subsampleY == 1 && this.srcWidth == this.dstWidth && this.srcHeight == this.dstHeight && this.dstMinX + this.dstWidth <= this.image.getWidth() && this.dstMinY + this.dstHeight <= this.image.getHeight() && n4 != 0 && n3 != 0 && !this.adjustBitDepths;
    }

    public void decode() throws IOException {
        Object object;
        Object object2;
        int n2;
        Object object3;
        Object object4;
        boolean bl2;
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        this.rawImage = null;
        if (this.isImageSimple) {
            if (this.isBilevel) {
                this.rawImage = this.image;
            } else if (this.isContiguous) {
                this.rawImage = this.image.getSubimage(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight);
            }
        }
        boolean bl3 = bl2 = this.rawImage != null;
        if (this.rawImage == null) {
            this.rawImage = this.createRawImage();
            if (this.rawImage == null) {
                throw new IIOException("Couldn't create image buffer!");
            }
        }
        WritableRaster writableRaster = this.rawImage.getRaster();
        if (this.isBilevel) {
            object4 = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : writableRaster.getBounds();
            byArray = ImageUtil.getPackedBinaryData(writableRaster, (Rectangle)object4);
            n3 = 0;
            n4 = 1;
            n5 = (((Rectangle)object4).width + 7) / 8;
        } else {
            object4 = writableRaster.getSampleModel();
            object3 = writableRaster.getDataBuffer();
            n2 = 0;
            if (object4 instanceof ComponentSampleModel) {
                object2 = (ComponentSampleModel)object4;
                n3 = ((ComponentSampleModel)object2).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n5 = ((ComponentSampleModel)object2).getScanlineStride();
                if (object3 instanceof DataBufferByte) {
                    object = (DataBufferByte)object3;
                    byArray = ((DataBufferByte)object).getData();
                    n4 = ((ComponentSampleModel)object2).getPixelStride() * 8;
                    n2 = 1;
                } else if (object3 instanceof DataBufferUShort) {
                    object = (DataBufferUShort)object3;
                    sArray = ((DataBufferUShort)object).getData();
                    n4 = ((ComponentSampleModel)object2).getPixelStride() * 16;
                    n2 = 1;
                } else if (object3 instanceof DataBufferShort) {
                    object = (DataBufferShort)object3;
                    sArray = ((DataBufferShort)object).getData();
                    n4 = ((ComponentSampleModel)object2).getPixelStride() * 16;
                    n2 = 1;
                } else if (object3 instanceof DataBufferInt) {
                    object = (DataBufferInt)object3;
                    nArray = ((DataBufferInt)object).getData();
                    n4 = ((ComponentSampleModel)object2).getPixelStride() * 32;
                    n2 = 1;
                } else if (object3 instanceof DataBufferFloat) {
                    object = (DataBufferFloat)object3;
                    fArray = ((DataBufferFloat)object).getData();
                    n4 = ((ComponentSampleModel)object2).getPixelStride() * 32;
                    n2 = 1;
                }
            } else if (object4 instanceof MultiPixelPackedSampleModel) {
                object2 = (MultiPixelPackedSampleModel)object4;
                n3 = ((MultiPixelPackedSampleModel)object2).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n4 = ((MultiPixelPackedSampleModel)object2).getPixelBitStride();
                n5 = ((MultiPixelPackedSampleModel)object2).getScanlineStride();
                if (object3 instanceof DataBufferByte) {
                    object = (DataBufferByte)object3;
                    byArray = ((DataBufferByte)object).getData();
                    n2 = 1;
                } else if (object3 instanceof DataBufferUShort) {
                    object = (DataBufferUShort)object3;
                    sArray = ((DataBufferUShort)object).getData();
                    n2 = 1;
                } else if (object3 instanceof DataBufferInt) {
                    object = (DataBufferInt)object3;
                    nArray = ((DataBufferInt)object).getData();
                    n2 = 1;
                }
            } else if (object4 instanceof SinglePixelPackedSampleModel) {
                object2 = (SinglePixelPackedSampleModel)object4;
                n3 = ((SinglePixelPackedSampleModel)object2).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n5 = ((SinglePixelPackedSampleModel)object2).getScanlineStride();
                if (object3 instanceof DataBufferByte) {
                    object = (DataBufferByte)object3;
                    byArray = ((DataBufferByte)object).getData();
                    n4 = 8;
                    n2 = 1;
                } else if (object3 instanceof DataBufferUShort) {
                    object = (DataBufferUShort)object3;
                    sArray = ((DataBufferUShort)object).getData();
                    n4 = 16;
                    n2 = 1;
                } else if (object3 instanceof DataBufferInt) {
                    object = (DataBufferInt)object3;
                    nArray = ((DataBufferInt)object).getData();
                    n4 = 32;
                    n2 = 1;
                }
            }
            if (n2 == 0) {
                throw new IIOException("Unsupported raw image type: SampleModel = " + object4 + "; DataBuffer = " + object3);
            }
        }
        if (this.isBilevel) {
            this.decodeRaw(byArray, n3, n4, n5);
        } else {
            object4 = writableRaster.getSampleModel();
            if (TIFFDecompressor.isDataBufferBitContiguous((SampleModel)object4)) {
                if (byArray != null) {
                    this.decodeRaw(byArray, n3, n4, n5);
                } else if (fArray != null) {
                    this.decodeRaw(fArray, n3, n4, n5);
                } else if (sArray != null) {
                    if (TIFFDecompressor.areSampleSizesEqual((SampleModel)object4) && ((SampleModel)object4).getSampleSize(0) == 16) {
                        this.decodeRaw(sArray, n3, n4, n5);
                    } else {
                        int n6 = TIFFDecompressor.getBitsPerPixel((SampleModel)object4);
                        n2 = (n6 * this.srcWidth + 7) / 8;
                        object2 = new byte[n2 * this.srcHeight];
                        this.decodeRaw((byte[])object2, 0, n6, n2);
                        TIFFDecompressor.reformatData((byte[])object2, n2, this.srcHeight, sArray, null, n3, n5);
                    }
                } else if (nArray != null) {
                    if (TIFFDecompressor.areSampleSizesEqual((SampleModel)object4) && ((SampleModel)object4).getSampleSize(0) == 32) {
                        this.decodeRaw(nArray, n3, n4, n5);
                    } else {
                        int n7 = TIFFDecompressor.getBitsPerPixel((SampleModel)object4);
                        n2 = (n7 * this.srcWidth + 7) / 8;
                        object2 = new byte[n2 * this.srcHeight];
                        this.decodeRaw((byte[])object2, 0, n7, n2);
                        TIFFDecompressor.reformatData((byte[])object2, n2, this.srcHeight, null, nArray, n3, n5);
                    }
                }
            } else {
                int n8 = TIFFDecompressor.getBitsPerPixel((SampleModel)object4);
                n2 = (n8 * this.srcWidth + 7) / 8;
                object2 = new byte[n2 * this.srcHeight];
                this.decodeRaw((byte[])object2, 0, n8, n2);
                TIFFDecompressor.reformatDiscontiguousData((byte[])object2, n2, this.srcWidth, this.srcHeight, writableRaster);
            }
        }
        if (this.colorConverter != null) {
            float f2;
            float f3;
            object4 = new float[3];
            if (byArray != null) {
                for (int i2 = 0; i2 < this.dstHeight; ++i2) {
                    n2 = n3;
                    for (int i3 = 0; i3 < this.dstWidth; ++i3) {
                        float f4 = byArray[n2] & 0xFF;
                        f3 = byArray[n2 + 1] & 0xFF;
                        f2 = byArray[n2 + 2] & 0xFF;
                        this.colorConverter.toRGB(f4, f3, f2, (float[])object4);
                        byArray[n2] = (byte)((int)object4[0]);
                        byArray[n2 + 1] = (byte)((int)object4[1]);
                        byArray[n2 + 2] = (byte)((int)object4[2]);
                        n2 += 3;
                    }
                    n3 += n5;
                }
            } else if (sArray != null) {
                if (this.sampleFormat[0] == 2) {
                    for (int i4 = 0; i4 < this.dstHeight; ++i4) {
                        n2 = n3;
                        for (int i5 = 0; i5 < this.dstWidth; ++i5) {
                            float f5 = sArray[n2];
                            f3 = sArray[n2 + 1];
                            f2 = sArray[n2 + 2];
                            this.colorConverter.toRGB(f5, f3, f2, (float[])object4);
                            sArray[n2] = (short)((int)object4[0]);
                            sArray[n2 + 1] = (short)((int)object4[1]);
                            sArray[n2 + 2] = (short)((int)object4[2]);
                            n2 += 3;
                        }
                        n3 += n5;
                    }
                } else {
                    for (int i6 = 0; i6 < this.dstHeight; ++i6) {
                        n2 = n3;
                        for (int i7 = 0; i7 < this.dstWidth; ++i7) {
                            float f6 = sArray[n2] & 0xFFFF;
                            f3 = sArray[n2 + 1] & 0xFFFF;
                            f2 = sArray[n2 + 2] & 0xFFFF;
                            this.colorConverter.toRGB(f6, f3, f2, (float[])object4);
                            sArray[n2] = (short)((int)object4[0]);
                            sArray[n2 + 1] = (short)((int)object4[1]);
                            sArray[n2 + 2] = (short)((int)object4[2]);
                            n2 += 3;
                        }
                        n3 += n5;
                    }
                }
            } else if (nArray != null) {
                for (int i8 = 0; i8 < this.dstHeight; ++i8) {
                    n2 = n3;
                    for (int i9 = 0; i9 < this.dstWidth; ++i9) {
                        float f7 = nArray[n2];
                        f3 = nArray[n2 + 1];
                        f2 = nArray[n2 + 2];
                        this.colorConverter.toRGB(f7, f3, f2, (float[])object4);
                        nArray[n2] = (int)object4[0];
                        nArray[n2 + 1] = (int)object4[1];
                        nArray[n2 + 2] = (int)object4[2];
                        n2 += 3;
                    }
                    n3 += n5;
                }
            } else if (fArray != null) {
                for (int i10 = 0; i10 < this.dstHeight; ++i10) {
                    n2 = n3;
                    for (int i11 = 0; i11 < this.dstWidth; ++i11) {
                        float f8 = fArray[n2];
                        f3 = fArray[n2 + 1];
                        f2 = fArray[n2 + 2];
                        this.colorConverter.toRGB(f8, f3, f2, (float[])object4);
                        fArray[n2] = (float)object4[0];
                        fArray[n2 + 1] = (float)object4[1];
                        fArray[n2 + 2] = (float)object4[2];
                        n2 += 3;
                    }
                    n3 += n5;
                }
            }
        }
        if (this.photometricInterpretation == 0) {
            if (byArray != null) {
                int n9 = (this.srcWidth * n4 + 7) / 8;
                for (int i12 = 0; i12 < this.srcHeight; ++i12) {
                    n2 = n3 + i12 * n5;
                    for (int i13 = 0; i13 < n9; ++i13) {
                        int n10 = n2 + i13;
                        byArray[n10] = (byte)(byArray[n10] ^ 0xFF);
                    }
                }
            } else if (sArray != null) {
                int n11;
                int n12 = (this.srcWidth * n4 + 15) / 16;
                if (this.sampleFormat[0] == 2) {
                    for (n11 = 0; n11 < this.srcHeight; ++n11) {
                        n2 = n3 + n11 * n5;
                        for (int i14 = 0; i14 < n12; ++i14) {
                            int n13 = n2 + i14;
                            sArray[n13] = (short)(Short.MAX_VALUE - sArray[n13]);
                        }
                    }
                } else {
                    for (n11 = 0; n11 < this.srcHeight; ++n11) {
                        n2 = n3 + n11 * n5;
                        for (int i15 = 0; i15 < n12; ++i15) {
                            int n14 = n2 + i15;
                            sArray[n14] = (short)(sArray[n14] ^ 0xFFFF);
                        }
                    }
                }
            } else if (nArray != null) {
                int n15 = (this.srcWidth * n4 + 15) / 16;
                for (int i16 = 0; i16 < this.srcHeight; ++i16) {
                    n2 = n3 + i16 * n5;
                    for (int i17 = 0; i17 < n15; ++i17) {
                        int n16 = n2 + i17;
                        nArray[n16] = Integer.MAX_VALUE - nArray[n16];
                    }
                }
            } else if (fArray != null) {
                int n17 = (this.srcWidth * n4 + 15) / 16;
                for (int i18 = 0; i18 < this.srcHeight; ++i18) {
                    n2 = n3 + i18 * n5;
                    for (int i19 = 0; i19 < n17; ++i19) {
                        int n18 = n2 + i19;
                        fArray[n18] = 1.0f - fArray[n18];
                    }
                }
            }
        }
        if (this.isBilevel) {
            Rectangle rectangle = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : writableRaster.getBounds();
            ImageUtil.setPackedBinaryData(byArray, writableRaster, rectangle);
        }
        if (bl2) {
            return;
        }
        WritableRaster writableRaster2 = this.rawImage.getRaster();
        object3 = writableRaster2.createChild(0, 0, this.srcWidth, this.srcHeight, this.srcMinX, this.srcMinY, this.planar ? null : this.sourceBands);
        WritableRaster writableRaster3 = this.image.getRaster();
        object2 = writableRaster3.createWritableChild(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight, this.dstMinX, this.dstMinY, this.destinationBands);
        if (this.subsampleX == 1 && this.subsampleY == 1 && !this.adjustBitDepths) {
            object3 = ((Raster)object3).createChild(this.activeSrcMinX, this.activeSrcMinY, this.activeSrcWidth, this.activeSrcHeight, this.dstMinX, this.dstMinY, null);
            ((WritableRaster)object2).setRect((Raster)object3);
        } else if (this.subsampleX == 1 && !this.adjustBitDepths) {
            int n19 = this.activeSrcMinY;
            int n20 = this.dstMinY;
            while (n19 < this.srcMinY + this.srcHeight) {
                Raster raster = ((Raster)object3).createChild(this.activeSrcMinX, n19, this.activeSrcWidth, 1, this.dstMinX, n20, null);
                ((WritableRaster)object2).setRect(raster);
                n19 += this.subsampleY;
                ++n20;
            }
        } else {
            object = ((Raster)object3).getPixel(this.srcMinX, this.srcMinY, (int[])null);
            int n21 = ((Object)object).length;
            int n22 = this.activeSrcMinY;
            int n23 = this.dstMinY;
            while (n22 < this.activeSrcMinY + this.activeSrcHeight) {
                int n24 = this.activeSrcMinX;
                int n25 = this.dstMinX;
                while (n24 < this.activeSrcMinX + this.activeSrcWidth) {
                    ((Raster)object3).getPixel(n24, n22, (int[])object);
                    if (this.adjustBitDepths) {
                        for (int i20 = 0; i20 < n21; ++i20) {
                            object[i20] = this.bitDepthScale[i20][object[i20]];
                        }
                    }
                    ((WritableRaster)object2).setPixel(n25, n23, (int[])object);
                    n24 += this.subsampleX;
                    ++n25;
                }
                n22 += this.subsampleY;
                ++n23;
            }
        }
    }
}

