/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;

public class TIFFDirectory
implements Cloneable {
    private static final int MAX_LOW_FIELD_TAG_NUM = 532;
    private List tagSets;
    private TIFFTag parentTag;
    private TIFFField[] lowFields = new TIFFField[533];
    private int numLowFields = 0;
    private Map highFields = new TreeMap();

    public static TIFFDirectory createFromMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        TIFFImageMetadata tIFFImageMetadata;
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("tiffImageMetadata == null");
        }
        if (iIOMetadata instanceof TIFFImageMetadata) {
            tIFFImageMetadata = (TIFFImageMetadata)iIOMetadata;
        } else {
            ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
            arrayList.add(BaselineTIFFTagSet.getInstance());
            tIFFImageMetadata = new TIFFImageMetadata(arrayList);
            String string = null;
            if ("com_sun_media_imageio_plugins_tiff_image_1.0".equals(iIOMetadata.getNativeMetadataFormatName())) {
                string = "com_sun_media_imageio_plugins_tiff_image_1.0";
            } else {
                String[] stringArray = iIOMetadata.getExtraMetadataFormatNames();
                if (stringArray != null) {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (!"com_sun_media_imageio_plugins_tiff_image_1.0".equals(stringArray[i2])) continue;
                        string = stringArray[i2];
                        break;
                    }
                }
                if (string == null) {
                    if (iIOMetadata.isStandardMetadataFormatSupported()) {
                        string = "javax_imageio_1.0";
                    } else {
                        throw new IllegalArgumentException("Parameter does not support required metadata format!");
                    }
                }
            }
            tIFFImageMetadata.setFromTree(string, iIOMetadata.getAsTree(string));
        }
        return tIFFImageMetadata.getRootIFD();
    }

    private static TIFFIFD getDirectoryAsIFD(TIFFDirectory tIFFDirectory) {
        if (tIFFDirectory instanceof TIFFIFD) {
            return (TIFFIFD)tIFFDirectory;
        }
        TIFFIFD tIFFIFD = new TIFFIFD(Arrays.asList(tIFFDirectory.getTagSets()), tIFFDirectory.getParentTag());
        TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
        int n2 = tIFFFieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TIFFField tIFFField = tIFFFieldArray[i2];
            TIFFTag tIFFTag = tIFFField.getTag();
            if (tIFFTag.isIFDPointer()) {
                TIFFIFD tIFFIFD2 = TIFFDirectory.getDirectoryAsIFD((TIFFDirectory)tIFFField.getData());
                tIFFField = new TIFFField(tIFFTag, tIFFField.getType(), tIFFField.getCount(), tIFFIFD2);
            }
            tIFFIFD.addTIFFField(tIFFField);
        }
        return tIFFIFD;
    }

    public TIFFDirectory(TIFFTagSet[] tIFFTagSetArray, TIFFTag tIFFTag) {
        if (tIFFTagSetArray == null) {
            throw new IllegalArgumentException("tagSets == null!");
        }
        this.tagSets = new ArrayList(tIFFTagSetArray.length);
        int n2 = tIFFTagSetArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tagSets.add(tIFFTagSetArray[i2]);
        }
        this.parentTag = tIFFTag;
    }

    public TIFFTagSet[] getTagSets() {
        return this.tagSets.toArray(new TIFFTagSet[this.tagSets.size()]);
    }

    public void addTagSet(TIFFTagSet tIFFTagSet) {
        if (tIFFTagSet == null) {
            throw new IllegalArgumentException("tagSet == null");
        }
        if (!this.tagSets.contains(tIFFTagSet)) {
            this.tagSets.add(tIFFTagSet);
        }
    }

    public void removeTagSet(TIFFTagSet tIFFTagSet) {
        if (tIFFTagSet == null) {
            throw new IllegalArgumentException("tagSet == null");
        }
        if (this.tagSets.contains(tIFFTagSet)) {
            this.tagSets.remove(tIFFTagSet);
        }
    }

    public TIFFTag getParentTag() {
        return this.parentTag;
    }

    public TIFFTag getTag(int n2) {
        return TIFFIFD.getTag(n2, this.tagSets);
    }

    public int getNumTIFFFields() {
        return this.numLowFields + this.highFields.size();
    }

    public boolean containsTIFFField(int n2) {
        return n2 >= 0 && n2 <= 532 && this.lowFields[n2] != null || this.highFields.containsKey(new Integer(n2));
    }

    public void addTIFFField(TIFFField tIFFField) {
        if (tIFFField == null) {
            throw new IllegalArgumentException("f == null");
        }
        int n2 = tIFFField.getTagNumber();
        if (n2 >= 0 && n2 <= 532) {
            if (this.lowFields[n2] == null) {
                ++this.numLowFields;
            }
            this.lowFields[n2] = tIFFField;
        } else {
            this.highFields.put(new Integer(n2), tIFFField);
        }
    }

    public TIFFField getTIFFField(int n2) {
        TIFFField tIFFField = n2 >= 0 && n2 <= 532 ? this.lowFields[n2] : (TIFFField)this.highFields.get(new Integer(n2));
        return tIFFField;
    }

    public void removeTIFFField(int n2) {
        if (n2 >= 0 && n2 <= 532) {
            if (this.lowFields[n2] != null) {
                --this.numLowFields;
                this.lowFields[n2] = null;
            }
        } else {
            this.highFields.remove(new Integer(n2));
        }
    }

    public TIFFField[] getTIFFFields() {
        TIFFField[] tIFFFieldArray = new TIFFField[this.numLowFields + this.highFields.size()];
        int n2 = 0;
        for (int i2 = 0; i2 <= 532; ++i2) {
            if (this.lowFields[i2] == null) continue;
            tIFFFieldArray[n2++] = this.lowFields[i2];
            if (n2 == this.numLowFields) break;
        }
        if (!this.highFields.isEmpty()) {
            Iterator iterator = this.highFields.keySet().iterator();
            while (iterator.hasNext()) {
                tIFFFieldArray[n2++] = (TIFFField)this.highFields.get(iterator.next());
            }
        }
        return tIFFFieldArray;
    }

    public void removeTIFFFields() {
        Arrays.fill(this.lowFields, null);
        this.numLowFields = 0;
        this.highFields.clear();
    }

    public IIOMetadata getAsMetadata() {
        return new TIFFImageMetadata(TIFFDirectory.getDirectoryAsIFD(this));
    }

    public Object clone() {
        TIFFDirectory tIFFDirectory = new TIFFDirectory(this.getTagSets(), this.getParentTag());
        TIFFField[] tIFFFieldArray = this.getTIFFFields();
        int n2 = tIFFFieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            tIFFDirectory.addTIFFField(tIFFFieldArray[i2]);
        }
        return tIFFDirectory;
    }
}

