/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFieldNode;
import java.util.StringTokenizer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TIFFField
implements Comparable {
    private static final String[] typeNames = new String[]{null, "Byte", "Ascii", "Short", "Long", "Rational", "SByte", "Undefined", "SShort", "SLong", "SRational", "Float", "Double", "IFDPointer"};
    private static final boolean[] isIntegral = new boolean[]{false, true, false, true, true, false, true, true, true, true, false, false, false, false};
    private TIFFTag tag;
    private int tagNumber;
    private int type;
    private int count;
    private Object data;

    private TIFFField() {
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        return namedNodeMap.getNamedItem(string).getNodeValue();
    }

    private static void initData(Node node, int[] nArray, int[] nArray2, Object[] objectArray) {
        Node node2;
        Object object = null;
        String string = node.getNodeName();
        string = string.substring(4);
        int n2 = TIFFField.getTypeByName(string = string.substring(0, string.length() - 1));
        if (n2 == -1) {
            throw new IllegalArgumentException("typeName = " + string);
        }
        int n3 = 0;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string2 = node2.getNodeName().substring(4);
            if (!string.equals(string2)) {
                // empty if block
            }
            ++n3;
        }
        if (n3 > 0) {
            object = TIFFField.createArrayForType(n2, n3);
            int n4 = 0;
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string3 = TIFFField.getAttribute(node2, "value");
                switch (n2) {
                    case 2: {
                        ((String[])object)[n4] = string3;
                        break;
                    }
                    case 1: 
                    case 6: {
                        ((byte[])object)[n4] = (byte)Integer.parseInt(string3);
                        break;
                    }
                    case 3: {
                        ((char[])object)[n4] = (char)Integer.parseInt(string3);
                        break;
                    }
                    case 8: {
                        ((short[])object)[n4] = (short)Integer.parseInt(string3);
                        break;
                    }
                    case 9: {
                        ((int[])object)[n4] = Integer.parseInt(string3);
                        break;
                    }
                    case 4: 
                    case 13: {
                        ((long[])object)[n4] = Long.parseLong(string3);
                        break;
                    }
                    case 11: {
                        ((float[])object)[n4] = Float.parseFloat(string3);
                        break;
                    }
                    case 12: {
                        ((double[])object)[n4] = Double.parseDouble(string3);
                        break;
                    }
                    case 10: {
                        int n5 = string3.indexOf("/");
                        String string4 = string3.substring(0, n5);
                        String string5 = string3.substring(n5 + 1);
                        ((int[][])object)[n4] = new int[2];
                        ((int[][])object)[n4][0] = Integer.parseInt(string4);
                        ((int[][])object)[n4][1] = Integer.parseInt(string5);
                        break;
                    }
                    case 5: {
                        int n5 = string3.indexOf("/");
                        String string4 = string3.substring(0, n5);
                        String string5 = string3.substring(n5 + 1);
                        ((long[][])object)[n4] = new long[2];
                        ((long[][])object)[n4][0] = Long.parseLong(string4);
                        ((long[][])object)[n4][1] = Long.parseLong(string5);
                        break;
                    }
                }
                ++n4;
            }
        }
        nArray[0] = n2;
        nArray2[0] = n3;
        objectArray[0] = object;
    }

    public static TIFFField createFromMetadataNode(TIFFTagSet tIFFTagSet, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null!");
        }
        String string = node.getNodeName();
        if (!string.equals("TIFFField")) {
            throw new IllegalArgumentException("!name.equals(\"TIFFField\")");
        }
        int n2 = Integer.parseInt(TIFFField.getAttribute(node, "number"));
        TIFFTag tIFFTag = tIFFTagSet != null ? tIFFTagSet.getTag(n2) : new TIFFTag("unknown", n2, 0, null);
        int n3 = 7;
        int n4 = 0;
        Object object = null;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            String string2 = node2.getNodeName();
            if (string2.equals("TIFFUndefined")) {
                String string3 = TIFFField.getAttribute(node2, "value");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                n4 = stringTokenizer.countTokens();
                byte[] byArray = new byte[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    byArray[i2] = (byte)Integer.parseInt(stringTokenizer.nextToken());
                }
                n3 = 7;
                object = byArray;
            } else {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                Object[] objectArray = new Object[1];
                TIFFField.initData(node.getFirstChild(), nArray, nArray2, objectArray);
                n3 = nArray[0];
                n4 = nArray2[0];
                object = objectArray[0];
            }
        } else {
            int n5;
            for (n5 = 13; n5 >= 1 && !tIFFTag.isDataTypeOK(n5); --n5) {
            }
            n3 = n5;
        }
        return new TIFFField(tIFFTag, n3, n4, object);
    }

    public TIFFField(TIFFTag tIFFTag, int n2, int n3, Object object) {
        if (tIFFTag == null) {
            throw new IllegalArgumentException("tag == null!");
        }
        if (n2 < 1 || n2 > 13) {
            throw new IllegalArgumentException("Unknown data type " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("count < 0!");
        }
        this.tag = tIFFTag;
        this.tagNumber = tIFFTag.getNumber();
        this.type = n2;
        this.count = n3;
        this.data = object;
    }

    public TIFFField(TIFFTag tIFFTag, int n2, int n3) {
        this(tIFFTag, n2, n3, TIFFField.createArrayForType(n2, n3));
    }

    public TIFFField(TIFFTag tIFFTag, int n2) {
        if (tIFFTag == null) {
            throw new IllegalArgumentException("tag == null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("value < 0!");
        }
        this.tag = tIFFTag;
        this.tagNumber = tIFFTag.getNumber();
        this.count = 1;
        if (n2 < 65536) {
            this.type = 3;
            char[] cArray = new char[]{(char)n2};
            this.data = cArray;
        } else {
            this.type = 4;
            long[] lArray = new long[]{n2};
            this.data = lArray;
        }
    }

    public TIFFTag getTag() {
        return this.tag;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public int getType() {
        return this.type;
    }

    public static String getTypeName(int n2) {
        if (n2 < 1 || n2 > 13) {
            throw new IllegalArgumentException("Unknown data type " + n2);
        }
        return typeNames[n2];
    }

    public static int getTypeByName(String string) {
        for (int i2 = 1; i2 <= 13; ++i2) {
            if (!string.equals(typeNames[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static Object createArrayForType(int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("count < 0!");
        }
        switch (n2) {
            case 1: 
            case 6: 
            case 7: {
                return new byte[n3];
            }
            case 2: {
                return new String[n3];
            }
            case 3: {
                return new char[n3];
            }
            case 4: 
            case 13: {
                return new long[n3];
            }
            case 5: {
                return new long[n3][2];
            }
            case 8: {
                return new short[n3];
            }
            case 9: {
                return new int[n3];
            }
            case 10: {
                return new int[n3][2];
            }
            case 11: {
                return new float[n3];
            }
            case 12: {
                return new double[n3];
            }
        }
        throw new IllegalArgumentException("Unknown data type " + n2);
    }

    public Node getAsNativeNode() {
        return new TIFFFieldNode(this);
    }

    public boolean isIntegral() {
        return isIntegral[this.type];
    }

    public int getCount() {
        return this.count;
    }

    public Object getData() {
        return this.data;
    }

    public byte[] getAsBytes() {
        return (byte[])this.data;
    }

    public char[] getAsChars() {
        return (char[])this.data;
    }

    public short[] getAsShorts() {
        return (short[])this.data;
    }

    public int[] getAsInts() {
        if (this.data instanceof int[]) {
            return (int[])this.data;
        }
        if (this.data instanceof char[]) {
            char[] cArray = (char[])this.data;
            int[] nArray = new int[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                nArray[i2] = cArray[i2] & 0xFFFF;
            }
            return nArray;
        }
        if (this.data instanceof short[]) {
            short[] sArray = (short[])this.data;
            int[] nArray = new int[sArray.length];
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                nArray[i3] = sArray[i3];
            }
            return nArray;
        }
        throw new ClassCastException("Data not char[], short[], or int[]!");
    }

    public long[] getAsLongs() {
        return (long[])this.data;
    }

    public float[] getAsFloats() {
        return (float[])this.data;
    }

    public double[] getAsDoubles() {
        return (double[])this.data;
    }

    public int[][] getAsSRationals() {
        return (int[][])this.data;
    }

    public long[][] getAsRationals() {
        return (long[][])this.data;
    }

    public int getAsInt(int n2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
            case 4: 
            case 13: {
                return (int)((long[])this.data)[n2];
            }
            case 11: {
                return (int)((float[])this.data)[n2];
            }
            case 12: {
                return (int)((double[])this.data)[n2];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n2);
                return (int)((double)nArray[0] / (double)nArray[1]);
            }
            case 5: {
                long[] lArray = this.getAsRational(n2);
                return (int)((double)lArray[0] / (double)lArray[1]);
            }
            case 2: {
                String string = ((String[])this.data)[n2];
                return (int)Double.parseDouble(string);
            }
        }
        throw new ClassCastException();
    }

    public long getAsLong(int n2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[n2];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n2);
                return (long)((double)nArray[0] / (double)nArray[1]);
            }
            case 5: {
                long[] lArray = this.getAsRational(n2);
                return (long)((double)lArray[0] / (double)lArray[1]);
            }
            case 2: {
                String string = ((String[])this.data)[n2];
                return (long)Double.parseDouble(string);
            }
        }
        throw new ClassCastException();
    }

    public float getAsFloat(int n2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[n2];
            }
            case 11: {
                return ((float[])this.data)[n2];
            }
            case 12: {
                return (float)((double[])this.data)[n2];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n2);
                return (float)((double)nArray[0] / (double)nArray[1]);
            }
            case 5: {
                long[] lArray = this.getAsRational(n2);
                return (float)((double)lArray[0] / (double)lArray[1]);
            }
            case 2: {
                String string = ((String[])this.data)[n2];
                return (float)Double.parseDouble(string);
            }
        }
        throw new ClassCastException();
    }

    public double getAsDouble(int n2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[n2];
            }
            case 11: {
                return ((float[])this.data)[n2];
            }
            case 12: {
                return ((double[])this.data)[n2];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n2);
                return (double)nArray[0] / (double)nArray[1];
            }
            case 5: {
                long[] lArray = this.getAsRational(n2);
                return (double)lArray[0] / (double)lArray[1];
            }
            case 2: {
                String string = ((String[])this.data)[n2];
                return Double.parseDouble(string);
            }
        }
        throw new ClassCastException();
    }

    public String getAsString(int n2) {
        return ((String[])this.data)[n2];
    }

    public int[] getAsSRational(int n2) {
        return ((int[][])this.data)[n2];
    }

    public long[] getAsRational(int n2) {
        return ((long[][])this.data)[n2];
    }

    public String getValueAsString(int n2) {
        switch (this.type) {
            case 2: {
                return ((String[])this.data)[n2];
            }
            case 1: 
            case 7: {
                return Integer.toString(((byte[])this.data)[n2] & 0xFF);
            }
            case 6: {
                return Integer.toString(((byte[])this.data)[n2]);
            }
            case 3: {
                return Integer.toString(((char[])this.data)[n2] & 0xFFFF);
            }
            case 8: {
                return Integer.toString(((short[])this.data)[n2]);
            }
            case 9: {
                return Integer.toString(((int[])this.data)[n2]);
            }
            case 4: 
            case 13: {
                return Long.toString(((long[])this.data)[n2]);
            }
            case 11: {
                return Float.toString(((float[])this.data)[n2]);
            }
            case 12: {
                return Double.toString(((double[])this.data)[n2]);
            }
            case 10: {
                int[] nArray = this.getAsSRational(n2);
                String string = nArray[1] != 0 && nArray[0] % nArray[1] == 0 ? Integer.toString(nArray[0] / nArray[1]) + "/1" : Integer.toString(nArray[0]) + "/" + Integer.toString(nArray[1]);
                return string;
            }
            case 5: {
                long[] lArray = this.getAsRational(n2);
                String string = lArray[1] != 0L && lArray[0] % lArray[1] == 0L ? Long.toString(lArray[0] / lArray[1]) + "/1" : Long.toString(lArray[0]) + "/" + Long.toString(lArray[1]);
                return string;
            }
        }
        throw new ClassCastException();
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n2 = ((TIFFField)object).getTagNumber();
        if (this.tagNumber < n2) {
            return -1;
        }
        if (this.tagNumber > n2) {
            return 1;
        }
        return 0;
    }
}

