/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.util.Locale;
import javax.imageio.ImageWriteParam;

public class TIFFImageWriteParam
extends ImageWriteParam {
    TIFFCompressor compressor = null;
    TIFFColorConverter colorConverter = null;
    int photometricInterpretation;
    private boolean appendedCompressionType = false;

    public TIFFImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteCompressed = true;
        this.canWriteTiles = true;
        this.compressionTypes = TIFFImageWriter.TIFFCompressionTypes;
    }

    public boolean isCompressionLossless() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.compressionType == null) {
            throw new IllegalStateException("No compression type set!");
        }
        if (this.compressor != null && this.compressionType.equals(this.compressor.getCompressionType())) {
            return this.compressor.isCompressionLossless();
        }
        for (int i2 = 0; i2 < this.compressionTypes.length; ++i2) {
            if (!this.compressionType.equals(this.compressionTypes[i2])) continue;
            return TIFFImageWriter.isCompressionLossless[i2];
        }
        return false;
    }

    public void setTIFFCompressor(TIFFCompressor tIFFCompressor) {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        this.compressor = tIFFCompressor;
        if (this.appendedCompressionType) {
            int n2 = this.compressionTypes.length - 1;
            String[] stringArray = new String[n2];
            System.arraycopy(this.compressionTypes, 0, stringArray, 0, n2);
            this.compressionTypes = stringArray;
            this.appendedCompressionType = false;
        }
        if (tIFFCompressor != null) {
            String string = tIFFCompressor.getCompressionType();
            int n3 = this.compressionTypes.length;
            boolean bl2 = true;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!string.equals(this.compressionTypes[i2])) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                String[] stringArray = new String[n3 + 1];
                System.arraycopy(this.compressionTypes, 0, stringArray, 0, n3);
                stringArray[n3] = string;
                this.compressionTypes = stringArray;
                this.appendedCompressionType = true;
            }
        }
    }

    public TIFFCompressor getTIFFCompressor() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        return this.compressor;
    }

    public void setColorConverter(TIFFColorConverter tIFFColorConverter, int n2) {
        this.colorConverter = tIFFColorConverter;
        this.photometricInterpretation = n2;
    }

    public TIFFColorConverter getColorConverter() {
        return this.colorConverter;
    }

    public int getPhotometricInterpretation() {
        if (this.colorConverter == null) {
            throw new IllegalStateException("Color converter not set!");
        }
        return this.photometricInterpretation;
    }

    public void unsetColorConverter() {
        this.colorConverter = null;
    }
}

