/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileChannelImageInputStream
extends ImageInputStreamImpl {
    private FileChannel channel;
    private MappedByteBuffer mappedBuffer;
    private long mappedPos;
    private long mappedUpperBound;

    public FileChannelImageInputStream(FileChannel fileChannel) throws IOException {
        long l2;
        if (fileChannel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!fileChannel.isOpen()) {
            throw new IllegalArgumentException("channel.isOpen() == false");
        }
        this.channel = fileChannel;
        this.streamPos = this.flushedPos = (l2 = fileChannel.position());
        long l3 = fileChannel.size() - l2;
        long l4 = Math.min(l3, Integer.MAX_VALUE);
        this.mappedPos = 0L;
        this.mappedUpperBound = this.mappedPos + l4;
        this.mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, l2, l4);
    }

    private MappedByteBuffer getMappedBuffer(int n2) throws IOException {
        if (this.streamPos < this.mappedPos || this.streamPos + (long)n2 >= this.mappedUpperBound) {
            this.mappedPos = this.streamPos;
            long l2 = Math.min(this.channel.size() - this.mappedPos, Integer.MAX_VALUE);
            this.mappedUpperBound = this.mappedPos + l2;
            this.mappedBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.mappedPos, l2);
            this.mappedBuffer.order(super.getByteOrder());
        }
        return this.mappedBuffer;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(1);
        if (mappedByteBuffer.remaining() < 1) {
            return -1;
        }
        int n2 = mappedByteBuffer.get() & 0xFF;
        ++this.streamPos;
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (n3 == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n3);
        int n4 = mappedByteBuffer.remaining();
        if (n4 < 1) {
            return -1;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        mappedByteBuffer.get(byArray, n2, n3);
        this.streamPos += (long)n3;
        return n3;
    }

    public void close() throws IOException {
        super.close();
        this.channel = null;
    }

    public void readFully(char[] cArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n3 == 0) {
            return;
        }
        int n4 = 2 * n3;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n4);
        if (mappedByteBuffer.remaining() < n4) {
            throw new EOFException();
        }
        CharBuffer charBuffer = mappedByteBuffer.asCharBuffer();
        charBuffer.get(cArray, n2, n3);
        this.seek(this.streamPos + (long)n4);
    }

    public void readFully(short[] sArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > sArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length");
        }
        if (n3 == 0) {
            return;
        }
        int n4 = 2 * n3;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n4);
        if (mappedByteBuffer.remaining() < n4) {
            throw new EOFException();
        }
        ShortBuffer shortBuffer = mappedByteBuffer.asShortBuffer();
        shortBuffer.get(sArray, n2, n3);
        this.seek(this.streamPos + (long)n4);
    }

    public void readFully(int[] nArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > nArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length");
        }
        if (n3 == 0) {
            return;
        }
        int n4 = 4 * n3;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n4);
        if (mappedByteBuffer.remaining() < n4) {
            throw new EOFException();
        }
        IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
        intBuffer.get(nArray, n2, n3);
        this.seek(this.streamPos + (long)n4);
    }

    public void readFully(long[] lArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > lArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length");
        }
        if (n3 == 0) {
            return;
        }
        int n4 = 8 * n3;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n4);
        if (mappedByteBuffer.remaining() < n4) {
            throw new EOFException();
        }
        LongBuffer longBuffer = mappedByteBuffer.asLongBuffer();
        longBuffer.get(lArray, n2, n3);
        this.seek(this.streamPos + (long)n4);
    }

    public void readFully(float[] fArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > fArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length");
        }
        if (n3 == 0) {
            return;
        }
        int n4 = 4 * n3;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n4);
        if (mappedByteBuffer.remaining() < n4) {
            throw new EOFException();
        }
        FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
        floatBuffer.get(fArray, n2, n3);
        this.seek(this.streamPos + (long)n4);
    }

    public void readFully(double[] dArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > dArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length");
        }
        if (n3 == 0) {
            return;
        }
        int n4 = 8 * n3;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n4);
        if (mappedByteBuffer.remaining() < n4) {
            throw new EOFException();
        }
        DoubleBuffer doubleBuffer = mappedByteBuffer.asDoubleBuffer();
        doubleBuffer.get(dArray, n2, n3);
        this.seek(this.streamPos + (long)n4);
    }

    public long length() {
        long l2 = -1L;
        try {
            l2 = this.channel.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l2;
    }

    public void seek(long l2) throws IOException {
        super.seek(l2);
        if (l2 >= this.mappedPos && l2 < this.mappedUpperBound) {
            this.mappedBuffer.position((int)(l2 - this.mappedPos));
        } else {
            int n2 = (int)Math.min(this.channel.size() - l2, Integer.MAX_VALUE);
            this.mappedBuffer = this.getMappedBuffer(n2);
        }
    }

    public void setByteOrder(ByteOrder byteOrder) {
        super.setByteOrder(byteOrder);
        this.mappedBuffer.order(byteOrder);
    }
}

