/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import com.sun.media.imageio.stream.FileChannelImageInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileChannelImageOutputStream
extends ImageOutputStreamImpl {
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 0x100000;
    private FileChannel channel;
    private ByteBuffer byteBuffer;
    private ImageInputStream readStream = null;

    public FileChannelImageOutputStream(FileChannel fileChannel) throws IOException {
        if (fileChannel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!fileChannel.isOpen()) {
            throw new IllegalArgumentException("channel.isOpen() == false");
        }
        this.channel = fileChannel;
        this.streamPos = this.flushedPos = fileChannel.position();
        this.byteBuffer = ByteBuffer.allocateDirect(0x100000);
        this.readStream = new FileChannelImageInputStream(fileChannel);
    }

    private ImageInputStream getImageInputStream() throws IOException {
        this.flushBuffer();
        this.readStream.setByteOrder(this.byteOrder);
        this.readStream.seek(this.streamPos);
        this.readStream.flushBefore(this.flushedPos);
        this.readStream.setBitOffset(this.bitOffset);
        return this.readStream;
    }

    private void flushBuffer() throws IOException {
        if (this.byteBuffer.position() != 0) {
            this.byteBuffer.limit(this.byteBuffer.position());
            this.byteBuffer.position(0);
            this.channel.write(this.byteBuffer);
            this.byteBuffer.clear();
        }
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        ImageInputStream imageInputStream = this.getImageInputStream();
        ++this.streamPos;
        return imageInputStream.read();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (n3 == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        ImageInputStream imageInputStream = this.getImageInputStream();
        int n4 = imageInputStream.read(byArray, n2, n3);
        this.streamPos += (long)n4;
        return n4;
    }

    public void write(int n2) throws IOException {
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (n3 == 0) {
            return;
        }
        this.flushBits();
        int n4 = 0;
        do {
            int n5;
            if ((n5 = Math.min(n3 - n4, this.byteBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            this.byteBuffer.put(byArray, n2 + n4, n5);
            n4 += n5;
        } while (n4 < n3);
        this.streamPos += (long)n3;
    }

    public void readFully(char[] cArray, int n2, int n3) throws IOException {
        this.getImageInputStream().readFully(cArray, n2, n3);
        this.streamPos += (long)(2 * n3);
    }

    public void readFully(short[] sArray, int n2, int n3) throws IOException {
        this.getImageInputStream().readFully(sArray, n2, n3);
        this.streamPos += (long)(2 * n3);
    }

    public void readFully(int[] nArray, int n2, int n3) throws IOException {
        this.getImageInputStream().readFully(nArray, n2, n3);
        this.streamPos += (long)(4 * n3);
    }

    public void readFully(long[] lArray, int n2, int n3) throws IOException {
        this.getImageInputStream().readFully(lArray, n2, n3);
        this.streamPos += (long)(8 * n3);
    }

    public void readFully(float[] fArray, int n2, int n3) throws IOException {
        this.getImageInputStream().readFully(fArray, n2, n3);
        this.streamPos += (long)(4 * n3);
    }

    public void readFully(double[] dArray, int n2, int n3) throws IOException {
        this.getImageInputStream().readFully(dArray, n2, n3);
        this.streamPos += (long)(8 * n3);
    }

    public void writeChars(char[] cArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n3 == 0) {
            return;
        }
        this.flushBits();
        int n4 = 0;
        CharBuffer charBuffer = this.byteBuffer.asCharBuffer();
        do {
            int n5;
            if ((n5 = Math.min(n3 - n4, charBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            charBuffer.put(cArray, n2 + n4, n5);
            this.byteBuffer.position(this.byteBuffer.position() + 2 * n5);
            n4 += n5;
        } while (n4 < n3);
        this.streamPos += (long)(2 * n3);
    }

    public void writeShorts(short[] sArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > sArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n3 == 0) {
            return;
        }
        this.flushBits();
        int n4 = 0;
        ShortBuffer shortBuffer = this.byteBuffer.asShortBuffer();
        do {
            int n5;
            if ((n5 = Math.min(n3 - n4, shortBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            shortBuffer.put(sArray, n2 + n4, n5);
            this.byteBuffer.position(this.byteBuffer.position() + 2 * n5);
            n4 += n5;
        } while (n4 < n3);
        this.streamPos += (long)(2 * n3);
    }

    public void writeInts(int[] nArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > nArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n3 == 0) {
            return;
        }
        this.flushBits();
        int n4 = 0;
        IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
        do {
            int n5;
            if ((n5 = Math.min(n3 - n4, intBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            intBuffer.put(nArray, n2 + n4, n5);
            this.byteBuffer.position(this.byteBuffer.position() + 4 * n5);
            n4 += n5;
        } while (n4 < n3);
        this.streamPos += (long)(4 * n3);
    }

    public void writeLongs(long[] lArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > lArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n3 == 0) {
            return;
        }
        this.flushBits();
        int n4 = 0;
        LongBuffer longBuffer = this.byteBuffer.asLongBuffer();
        do {
            int n5;
            if ((n5 = Math.min(n3 - n4, longBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            longBuffer.put(lArray, n2 + n4, n5);
            this.byteBuffer.position(this.byteBuffer.position() + 8 * n5);
            n4 += n5;
        } while (n4 < n3);
        this.streamPos += (long)(8 * n3);
    }

    public void writeFloats(float[] fArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > fArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length");
        }
        if (n3 == 0) {
            return;
        }
        this.flushBits();
        int n4 = 0;
        FloatBuffer floatBuffer = this.byteBuffer.asFloatBuffer();
        do {
            int n5;
            if ((n5 = Math.min(n3 - n4, floatBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            floatBuffer.put(fArray, n2 + n4, n5);
            this.byteBuffer.position(this.byteBuffer.position() + 4 * n5);
            n4 += n5;
        } while (n4 < n3);
        this.streamPos += (long)(4 * n3);
    }

    public void writeDoubles(double[] dArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > dArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length");
        }
        if (n3 == 0) {
            return;
        }
        this.flushBits();
        int n4 = 0;
        DoubleBuffer doubleBuffer = this.byteBuffer.asDoubleBuffer();
        do {
            int n5;
            if ((n5 = Math.min(n3 - n4, doubleBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            doubleBuffer.put(dArray, n2 + n4, n5);
            this.byteBuffer.position(this.byteBuffer.position() + 8 * n5);
            n4 += n5;
        } while (n4 < n3);
        this.streamPos += (long)(8 * n3);
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.readStream.close();
        this.readStream = null;
        this.channel = null;
        this.byteBuffer = null;
        super.close();
    }

    public long length() {
        long l2 = -1L;
        try {
            l2 = this.channel.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l2;
    }

    public void seek(long l2) throws IOException {
        super.seek(l2);
        this.flushBuffer();
        this.channel.position(l2);
    }

    public void setByteOrder(ByteOrder byteOrder) {
        super.setByteOrder(byteOrder);
        this.byteBuffer.order(byteOrder);
    }
}

