/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import com.sun.media.imageio.stream.SectorStreamSegmentMapper;
import com.sun.media.imageio.stream.StreamSegment;
import com.sun.media.imageio.stream.StreamSegmentMapper;
import com.sun.media.imageio.stream.StreamSegmentMapperImpl;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class SegmentedImageInputStream
extends ImageInputStreamImpl {
    private ImageInputStream stream;
    private StreamSegmentMapper mapper;
    private StreamSegment streamSegment = new StreamSegment();

    public SegmentedImageInputStream(ImageInputStream imageInputStream, StreamSegmentMapper streamSegmentMapper) {
        this.stream = imageInputStream;
        this.mapper = streamSegmentMapper;
    }

    public SegmentedImageInputStream(ImageInputStream imageInputStream, long[] lArray, int[] nArray) {
        this(imageInputStream, new StreamSegmentMapperImpl(lArray, nArray));
    }

    public SegmentedImageInputStream(ImageInputStream imageInputStream, long[] lArray, int n2, int n3) {
        this(imageInputStream, new SectorStreamSegmentMapper(lArray, n2, n3));
    }

    public int read() throws IOException {
        this.mapper.getStreamSegment(this.streamPos, 1, this.streamSegment);
        int n2 = this.streamSegment.getSegmentLength();
        if (n2 < 0) {
            return -1;
        }
        this.stream.seek(this.streamSegment.getStartPos());
        int n3 = this.stream.read();
        ++this.streamPos;
        return n3;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        this.mapper.getStreamSegment(this.streamPos, n3, this.streamSegment);
        int n4 = this.streamSegment.getSegmentLength();
        if (n4 < 0) {
            return -1;
        }
        this.stream.seek(this.streamSegment.getStartPos());
        int n5 = this.stream.read(byArray, n2, n4);
        this.streamPos += (long)n5;
        return n5;
    }

    public long length() {
        long l2;
        if (this.mapper instanceof StreamSegmentMapperImpl) {
            l2 = ((StreamSegmentMapperImpl)this.mapper).length();
        } else if (this.mapper instanceof SectorStreamSegmentMapper) {
            l2 = ((SectorStreamSegmentMapper)this.mapper).length();
        } else if (this.mapper != null) {
            l2 = 0L;
            long l3 = 0L;
            StreamSegment streamSegment = this.mapper.getStreamSegment(l3, Integer.MAX_VALUE);
            while ((l2 = (long)streamSegment.getSegmentLength()) > 0L) {
                streamSegment.setSegmentLength(0);
                this.mapper.getStreamSegment(l3 += l2, Integer.MAX_VALUE, streamSegment);
            }
            l2 = l3;
        } else {
            l2 = super.length();
        }
        return l2;
    }
}

