/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class BitFile {
    ImageOutputStream output_;
    byte[] buffer_;
    int index_;
    int bitsLeft_;
    boolean blocks_ = false;

    public BitFile(ImageOutputStream imageOutputStream, boolean bl2) {
        this.output_ = imageOutputStream;
        this.blocks_ = bl2;
        this.buffer_ = new byte[256];
        this.index_ = 0;
        this.bitsLeft_ = 8;
    }

    public void flush() throws IOException {
        int n2 = this.index_ + (this.bitsLeft_ == 8 ? 0 : 1);
        if (n2 > 0) {
            if (this.blocks_) {
                this.output_.write(n2);
            }
            this.output_.write(this.buffer_, 0, n2);
            this.buffer_[0] = 0;
            this.index_ = 0;
            this.bitsLeft_ = 8;
        }
    }

    public void writeBits(int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 255;
        do {
            if (this.index_ == 254 && this.bitsLeft_ == 0 || this.index_ > 254) {
                if (this.blocks_) {
                    this.output_.write(n5);
                }
                this.output_.write(this.buffer_, 0, n5);
                this.buffer_[0] = 0;
                this.index_ = 0;
                this.bitsLeft_ = 8;
            }
            if (n3 <= this.bitsLeft_) {
                if (this.blocks_) {
                    int n6 = this.index_;
                    this.buffer_[n6] = (byte)(this.buffer_[n6] | (n2 & (1 << n3) - 1) << 8 - this.bitsLeft_);
                    n4 += n3;
                    this.bitsLeft_ -= n3;
                    n3 = 0;
                    continue;
                }
                int n7 = this.index_;
                this.buffer_[n7] = (byte)(this.buffer_[n7] | (n2 & (1 << n3) - 1) << this.bitsLeft_ - n3);
                n4 += n3;
                this.bitsLeft_ -= n3;
                n3 = 0;
                continue;
            }
            if (this.blocks_) {
                int n8 = this.index_++;
                this.buffer_[n8] = (byte)(this.buffer_[n8] | (n2 & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
                n4 += this.bitsLeft_;
                n2 >>= this.bitsLeft_;
                n3 -= this.bitsLeft_;
                this.buffer_[this.index_] = 0;
                this.bitsLeft_ = 8;
                continue;
            }
            int n9 = n2 >>> n3 - this.bitsLeft_ & (1 << this.bitsLeft_) - 1;
            int n10 = this.index_++;
            this.buffer_[n10] = (byte)(this.buffer_[n10] | n9);
            n3 -= this.bitsLeft_;
            n4 += this.bitsLeft_;
            this.buffer_[this.index_] = 0;
            this.bitsLeft_ = 8;
        } while (n3 != 0);
    }
}

