/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.io.PrintStream;

public class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr_ = new byte[4096];
    short[] strNxt_ = new short[4096];
    short[] strHsh_;
    short numStrings_;
    int[] strLen_ = new int[4096];

    public LZWStringTable() {
        this.strHsh_ = new short[9973];
    }

    public int AddCharString(short s2, byte by2) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int n2 = LZWStringTable.Hash(s2, by2);
        while (this.strHsh_[n2] != -1) {
            n2 = (n2 + 2039) % 9973;
        }
        this.strHsh_[n2] = this.numStrings_;
        this.strChr_[this.numStrings_] = by2;
        if (s2 == -1) {
            this.strNxt_[this.numStrings_] = -1;
            this.strLen_[this.numStrings_] = 1;
        } else {
            this.strNxt_[this.numStrings_] = s2;
            this.strLen_[this.numStrings_] = this.strLen_[s2] + 1;
        }
        short s3 = this.numStrings_;
        this.numStrings_ = (short)(s3 + 1);
        return s3;
    }

    public short FindCharString(short s2, byte by2) {
        short s3;
        if (s2 == -1) {
            return (short)(by2 & 0xFF);
        }
        int n2 = LZWStringTable.Hash(s2, by2);
        while ((s3 = this.strHsh_[n2]) != -1) {
            if (this.strNxt_[s3] == s2 && this.strChr_[s3] == by2) {
                return s3;
            }
            n2 = (n2 + 2039) % 9973;
        }
        return -1;
    }

    public void ClearTable(int n2) {
        int n3;
        this.numStrings_ = 0;
        for (n3 = 0; n3 < 9973; ++n3) {
            this.strHsh_[n3] = -1;
        }
        n3 = (1 << n2) + 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.AddCharString((short)-1, (byte)i2);
        }
    }

    public static int Hash(short s2, byte by2) {
        return (((short)(by2 << 8) ^ s2) & 0xFFFF) % 9973;
    }

    public int expandCode(byte[] byArray, int n2, short s2, int n3) {
        if (n2 == -2 && n3 == 1) {
            n3 = 0;
        }
        if (s2 == -1 || n3 == this.strLen_[s2]) {
            return 0;
        }
        int n4 = byArray.length - n2;
        int n5 = this.strLen_[s2] - n3;
        int n6 = n4 > n5 ? n5 : n4;
        int n7 = n5 - n6;
        int n8 = n2 + n6;
        while (n8 > n2 && s2 != -1) {
            if (--n7 < 0) {
                byArray[--n8] = this.strChr_[s2];
            }
            s2 = this.strNxt_[s2];
        }
        if (n5 > n6) {
            return -n6;
        }
        return n6;
    }

    public void dump(PrintStream printStream) {
        for (int i2 = 258; i2 < this.numStrings_; ++i2) {
            printStream.println(" strNxt_[" + i2 + "] = " + this.strNxt_[i2] + " strChr_ " + Integer.toHexString(this.strChr_[i2] & 0xFF) + " strLen_ " + Integer.toHexString(this.strLen_[i2]));
        }
    }
}

